/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 Unisoc Inc.
 */

#ifndef _GSP_SIN_COS_H_
#define _GSP_SIN_COS_H_

static int sin_table[] = {
	0x000000, 0x000192, 0x000324, 0x0004b6,
	0x000648, 0x0007db, 0x00096d, 0x000aff,
	0x000c91, 0x000e23, 0x000fb5, 0x001147,
	0x0012d9, 0x00146c, 0x0015fe, 0x001790,
	0x001922, 0x001ab4, 0x001c46, 0x001dd8,
	0x001f6a, 0x0020fd, 0x00228f, 0x002421,
	0x0025b3, 0x002745, 0x0028d7, 0x002a69,
	0x002bfb, 0x002d8d, 0x002f1f, 0x0030b2,
	0x003244, 0x0033d6, 0x003568, 0x0036fa,
	0x00388c, 0x003a1e, 0x003bb0, 0x003d42,
	0x003ed4, 0x004066, 0x0041f8, 0x00438b,
	0x00451d, 0x0046af, 0x004841, 0x0049d3,
	0x004b65, 0x004cf7, 0x004e89, 0x00501b,
	0x0051ad, 0x00533f, 0x0054d1, 0x005663,
	0x0057f5, 0x005987, 0x005b19, 0x005cab,
	0x005e3d, 0x005fcf, 0x006161, 0x0062f3,
	0x006485, 0x006617, 0x0067a9, 0x00693b,
	0x006acd, 0x006c5f, 0x006df1, 0x006f83,
	0x007115, 0x0072a7, 0x007439, 0x0075cb,
	0x00775d, 0x0078ef, 0x007a81, 0x007c13,
	0x007da5, 0x007f37, 0x0080c9, 0x00825b,
	0x0083ed, 0x00857e, 0x008710, 0x0088a2,
	0x008a34, 0x008bc6, 0x008d58, 0x008eea,
	0x00907c, 0x00920e, 0x00939f, 0x009531,
	0x0096c3, 0x009855, 0x0099e7, 0x009b79,
	0x009d0b, 0x009e9c, 0x00a02e, 0x00a1c0,
	0x00a352, 0x00a4e4, 0x00a675, 0x00a807,
	0x00a999, 0x00ab2b, 0x00acbd, 0x00ae4e,
	0x00afe0, 0x00b172, 0x00b304, 0x00b495,
	0x00b627, 0x00b7b9, 0x00b94a, 0x00badc,
	0x00bc6e, 0x00be00, 0x00bf91, 0x00c123,
	0x00c2b5, 0x00c446, 0x00c5d8, 0x00c76a,
	0x00c8fb, 0x00ca8d, 0x00cc1e, 0x00cdb0,
	0x00cf42, 0x00d0d3, 0x00d265, 0x00d3f6,
	0x00d588, 0x00d71a, 0x00d8ab, 0x00da3d,
	0x00dbce, 0x00dd60, 0x00def1, 0x00e083,
	0x00e214, 0x00e3a6, 0x00e537, 0x00e6c9,
	0x00e85a, 0x00e9ec, 0x00eb7d, 0x00ed0f,
	0x00eea0, 0x00f032, 0x00f1c3, 0x00f354,
	0x00f4e6, 0x00f677, 0x00f809, 0x00f99a,
	0x00fb2b, 0x00fcbd, 0x00fe4e, 0x00ffe0,
	0x010171, 0x010302, 0x010493, 0x010625,
	0x0107b6, 0x010947, 0x010ad9, 0x010c6a,
	0x010dfb, 0x010f8c, 0x01111e, 0x0112af,
	0x011440, 0x0115d1, 0x011762, 0x0118f4,
	0x011a85, 0x011c16, 0x011da7, 0x011f38,
	0x0120c9, 0x01225b, 0x0123ec, 0x01257d,
	0x01270e, 0x01289f, 0x012a30, 0x012bc1,
	0x012d52, 0x012ee3, 0x013074, 0x013205,
	0x013396, 0x013527, 0x0136b8, 0x013849,
	0x0139da, 0x013b6b, 0x013cfc, 0x013e8d,
	0x01401e, 0x0141af, 0x01433f, 0x0144d0,
	0x014661, 0x0147f2, 0x014983, 0x014b14,
	0x014ca4, 0x014e35, 0x014fc6, 0x015157,
	0x0152e7, 0x015478, 0x015609, 0x01579a,
	0x01592a, 0x015abb, 0x015c4c, 0x015ddc,
	0x015f6d, 0x0160fe, 0x01628e, 0x01641f,
	0x0165af, 0x016740, 0x0168d1, 0x016a61,
	0x016bf2, 0x016d82, 0x016f13, 0x0170a3,
	0x017234, 0x0173c4, 0x017555, 0x0176e5,
	0x017876, 0x017a06, 0x017b96, 0x017d27,
	0x017eb7, 0x018047, 0x0181d8, 0x018368,
	0x0184f8, 0x018689, 0x018819, 0x0189a9,
	0x018b3a, 0x018cca, 0x018e5a, 0x018fea,
	0x01917a, 0x01930b, 0x01949b, 0x01962b,
	0x0197bb, 0x01994b, 0x019adb, 0x019c6b,
	0x019dfb, 0x019f8b, 0x01a11c, 0x01a2ac,
	0x01a43c, 0x01a5cc, 0x01a75c, 0x01a8ec,
	0x01aa7b, 0x01ac0b, 0x01ad9b, 0x01af2b,
	0x01b0bb, 0x01b24b, 0x01b3db, 0x01b56b,
	0x01b6fa, 0x01b88a, 0x01ba1a, 0x01bbaa,
	0x01bd3a, 0x01bec9, 0x01c059, 0x01c1e9,
	0x01c378, 0x01c508, 0x01c698, 0x01c827,
	0x01c9b7, 0x01cb47, 0x01ccd6, 0x01ce66,
	0x01cff5, 0x01d185, 0x01d314, 0x01d4a4,
	0x01d633, 0x01d7c3, 0x01d952, 0x01dae2,
	0x01dc71, 0x01de00, 0x01df90, 0x01e11f,
	0x01e2ae, 0x01e43e, 0x01e5cd, 0x01e75c,
	0x01e8eb, 0x01ea7b, 0x01ec0a, 0x01ed99,
	0x01ef28, 0x01f0b8, 0x01f247, 0x01f3d6,
	0x01f565, 0x01f6f4, 0x01f883, 0x01fa12,
	0x01fba1, 0x01fd30, 0x01febf, 0x02004e,
	0x0201dd, 0x02036c, 0x0204fb, 0x02068a,
	0x020819, 0x0209a8, 0x020b36, 0x020cc5,
	0x020e54, 0x020fe3, 0x021172, 0x021300,
	0x02148f, 0x02161e, 0x0217ac, 0x02193b,
	0x021aca, 0x021c58, 0x021de7, 0x021f76,
	0x022104, 0x022293, 0x022421, 0x0225b0,
	0x02273e, 0x0228cd, 0x022a5b, 0x022be9,
	0x022d78, 0x022f06, 0x023095, 0x023223,
	0x0233b1, 0x02353f, 0x0236ce, 0x02385c,
	0x0239ea, 0x023b78, 0x023d07, 0x023e95,
	0x024023, 0x0241b1, 0x02433f, 0x0244cd,
	0x02465b, 0x0247e9, 0x024977, 0x024b05,
	0x024c93, 0x024e21, 0x024faf, 0x02513d,
	0x0252cb, 0x025459, 0x0255e6, 0x025774,
	0x025902, 0x025a90, 0x025c1e, 0x025dab,
	0x025f39, 0x0260c7, 0x026254, 0x0263e2,
	0x02656f, 0x0266fd, 0x02688b, 0x026a18,
	0x026ba6, 0x026d33, 0x026ec1, 0x02704e,
	0x0271db, 0x027369, 0x0274f6, 0x027684,
	0x027811, 0x02799e, 0x027b2b, 0x027cb9,
	0x027e46, 0x027fd3, 0x028160, 0x0282ed,
	0x02847b, 0x028608, 0x028795, 0x028922,
	0x028aaf, 0x028c3c, 0x028dc9, 0x028f56,
	0x0290e3, 0x029270, 0x0293fc, 0x029589,
	0x029716, 0x0298a3, 0x029a30, 0x029bbd,
	0x029d49, 0x029ed6, 0x02a063, 0x02a1ef,
	0x02a37c, 0x02a509, 0x02a695, 0x02a822,
	0x02a9ae, 0x02ab3b, 0x02acc7, 0x02ae54,
	0x02afe0, 0x02b16c, 0x02b2f9, 0x02b485,
	0x02b612, 0x02b79e, 0x02b92a, 0x02bab6,
	0x02bc43, 0x02bdcf, 0x02bf5b, 0x02c0e7,
	0x02c273, 0x02c3ff, 0x02c58b, 0x02c717,
	0x02c8a3, 0x02ca2f, 0x02cbbb, 0x02cd47,
	0x02ced3, 0x02d05f, 0x02d1eb, 0x02d377,
	0x02d502, 0x02d68e, 0x02d81a, 0x02d9a6,
	0x02db31, 0x02dcbd, 0x02de49, 0x02dfd4,
	0x02e160, 0x02e2eb, 0x02e477, 0x02e602,
	0x02e78e, 0x02e919, 0x02eaa5, 0x02ec30,
	0x02edbb, 0x02ef47, 0x02f0d2, 0x02f25d,
	0x02f3e8, 0x02f574, 0x02f6ff, 0x02f88a,
	0x02fa15, 0x02fba0, 0x02fd2b, 0x02feb6,
	0x030041, 0x0301cc, 0x030357, 0x0304e2,
	0x03066d, 0x0307f8, 0x030983, 0x030b0d,
	0x030c98, 0x030e23, 0x030fae, 0x031138,
	0x0312c3, 0x03144e, 0x0315d8, 0x031763,
	0x0318ed, 0x031a78, 0x031c02, 0x031d8d,
	0x031f17, 0x0320a1, 0x03222c, 0x0323b6,
	0x032540, 0x0326cb, 0x032855, 0x0329df,
	0x032b69, 0x032cf3, 0x032e7d, 0x033008,
	0x033192, 0x03331c, 0x0334a6, 0x033630,
	0x0337b9, 0x033943, 0x033acd, 0x033c57,
	0x033de1, 0x033f6b, 0x0340f4, 0x03427e,
	0x034408, 0x034591, 0x03471b, 0x0348a5,
	0x034a2e, 0x034bb8, 0x034d41, 0x034ecb,
	0x035054, 0x0351dd, 0x035367, 0x0354f0,
	0x035679, 0x035803, 0x03598c, 0x035b15,
	0x035c9e, 0x035e27, 0x035fb0, 0x03613a,
	0x0362c3, 0x03644c, 0x0365d5, 0x03675d,
	0x0368e6, 0x036a6f, 0x036bf8, 0x036d81,
	0x036f0a, 0x037092, 0x03721b, 0x0373a4,
	0x03752c, 0x0376b5, 0x03783e, 0x0379c6,
	0x037b4f, 0x037cd7, 0x037e60, 0x037fe8,
	0x038170, 0x0382f9, 0x038481, 0x038609,
	0x038791, 0x03891a, 0x038aa2, 0x038c2a,
	0x038db2, 0x038f3a, 0x0390c2, 0x03924a,
	0x0393d2, 0x03955a, 0x0396e2, 0x03986a,
	0x0399f2, 0x039b79, 0x039d01, 0x039e89,
	0x03a011, 0x03a198, 0x03a320, 0x03a4a7,
	0x03a62f, 0x03a7b6, 0x03a93e, 0x03aac5,
	0x03ac4d, 0x03add4, 0x03af5b, 0x03b0e3,
	0x03b26a, 0x03b3f1, 0x03b578, 0x03b700,
	0x03b887, 0x03ba0e, 0x03bb95, 0x03bd1c,
	0x03bea3, 0x03c02a, 0x03c1b1, 0x03c337,
	0x03c4be, 0x03c645, 0x03c7cc, 0x03c953,
	0x03cad9, 0x03cc60, 0x03cde7, 0x03cf6d,
	0x03d0f4, 0x03d27a, 0x03d401, 0x03d587,
	0x03d70d, 0x03d894, 0x03da1a, 0x03dba0,
	0x03dd27, 0x03dead, 0x03e033, 0x03e1b9,
	0x03e33f, 0x03e4c5, 0x03e64b, 0x03e7d1,
	0x03e957, 0x03eadd, 0x03ec63, 0x03ede9,
	0x03ef6f, 0x03f0f4, 0x03f27a, 0x03f400,
	0x03f585, 0x03f70b, 0x03f891, 0x03fa16,
	0x03fb9c, 0x03fd21, 0x03fea6, 0x04002c,
	0x0401b1, 0x040336, 0x0404bc, 0x040641,
	0x0407c6, 0x04094b, 0x040ad0, 0x040c55,
	0x040dda, 0x040f5f, 0x0410e4, 0x041269,
	0x0413ee, 0x041573, 0x0416f8, 0x04187c,
	0x041a01, 0x041b86, 0x041d0a, 0x041e8f,
	0x042014, 0x042198, 0x04231c, 0x0424a1,
	0x042625, 0x0427aa, 0x04292e, 0x042ab2,
	0x042c36, 0x042dbb, 0x042f3f, 0x0430c3,
	0x043247, 0x0433cb, 0x04354f, 0x0436d3,
	0x043857, 0x0439db, 0x043b5f, 0x043ce2,
	0x043e66, 0x043fea, 0x04416d, 0x0442f1,
	0x044475, 0x0445f8, 0x04477c, 0x0448ff,
	0x044a82, 0x044c06, 0x044d89, 0x044f0c,
	0x045090, 0x045213, 0x045396, 0x045519,
	0x04569c, 0x04581f, 0x0459a2, 0x045b25,
	0x045ca8, 0x045e2b, 0x045fae, 0x046131,
	0x0462b3, 0x046436, 0x0465b9, 0x04673b,
	0x0468be, 0x046a41, 0x046bc3, 0x046d45,
	0x046ec8, 0x04704a, 0x0471cd, 0x04734f,
	0x0474d1, 0x047653, 0x0477d5, 0x047958,
	0x047ada, 0x047c5c, 0x047dde, 0x047f5f,
	0x0480e1, 0x048263, 0x0483e5, 0x048567,
	0x0486e8, 0x04886a, 0x0489ec, 0x048b6d,
	0x048cef, 0x048e70, 0x048ff2, 0x049173,
	0x0492f5, 0x049476, 0x0495f7, 0x049778,
	0x0498fa, 0x049a7b, 0x049bfc, 0x049d7d,
	0x049efe, 0x04a07f, 0x04a200, 0x04a381,
	0x04a502, 0x04a682, 0x04a803, 0x04a984,
	0x04ab04, 0x04ac85, 0x04ae06, 0x04af86,
	0x04b107, 0x04b287, 0x04b407, 0x04b588,
	0x04b708, 0x04b888, 0x04ba08, 0x04bb89,
	0x04bd09, 0x04be89, 0x04c009, 0x04c189,
	0x04c309, 0x04c489, 0x04c608, 0x04c788,
	0x04c908, 0x04ca88, 0x04cc07, 0x04cd87,
	0x04cf06, 0x04d086, 0x04d205, 0x04d385,
	0x04d504, 0x04d684, 0x04d803, 0x04d982,
	0x04db01, 0x04dc80, 0x04ddff, 0x04df7e,
	0x04e0fd, 0x04e27c, 0x04e3fb, 0x04e57a,
	0x04e6f9, 0x04e878, 0x04e9f6, 0x04eb75,
	0x04ecf4, 0x04ee72, 0x04eff1, 0x04f16f,
	0x04f2ee, 0x04f46c, 0x04f5ea, 0x04f769,
	0x04f8e7, 0x04fa65, 0x04fbe3, 0x04fd61,
	0x04fedf, 0x05005d, 0x0501db, 0x050359,
	0x0504d7, 0x050655, 0x0507d3, 0x050950,
	0x050ace, 0x050c4c, 0x050dc9, 0x050f47,
	0x0510c4, 0x051242, 0x0513bf, 0x05153c,
	0x0516ba, 0x051837, 0x0519b4, 0x051b31,
	0x051cae, 0x051e2b, 0x051fa8, 0x052125,
	0x0522a2, 0x05241f, 0x05259c, 0x052718,
	0x052895, 0x052a12, 0x052b8e, 0x052d0b,
	0x052e87, 0x053004, 0x053180, 0x0532fc,
	0x053479, 0x0535f5, 0x053771, 0x0538ed,
	0x053a69, 0x053be5, 0x053d61, 0x053edd,
	0x054059, 0x0541d5, 0x054351, 0x0544cc,
	0x054648, 0x0547c4, 0x05493f, 0x054abb,
	0x054c36, 0x054db2, 0x054f2d, 0x0550a8,
	0x055223, 0x05539f, 0x05551a, 0x055695,
	0x055810, 0x05598b, 0x055b06, 0x055c81,
	0x055dfc, 0x055f77, 0x0560f1, 0x05626c,
	0x0563e7, 0x056561, 0x0566dc, 0x056856,
	0x0569d1, 0x056b4b, 0x056cc5, 0x056e40,
	0x056fba, 0x057134, 0x0572ae, 0x057428,
	0x0575a2, 0x05771c, 0x057896, 0x057a10,
	0x057b8a, 0x057d04, 0x057e7d, 0x057ff7,
	0x058170, 0x0582ea, 0x058464, 0x0585dd,
	0x058756, 0x0588d0, 0x058a49, 0x058bc2,
	0x058d3b, 0x058eb4, 0x05902e, 0x0591a7,
	0x05931f, 0x059498, 0x059611, 0x05978a,
	0x059903, 0x059a7b, 0x059bf4, 0x059d6d,
	0x059ee5, 0x05a05e, 0x05a1d6, 0x05a34e,
	0x05a4c7, 0x05a63f, 0x05a7b7, 0x05a92f,
	0x05aaa7, 0x05ac1f, 0x05ad97, 0x05af0f,
	0x05b087, 0x05b1ff, 0x05b377, 0x05b4ee,
	0x05b666, 0x05b7de, 0x05b955, 0x05bacd,
	0x05bc44, 0x05bdbc, 0x05bf33, 0x05c0aa,
	0x05c221, 0x05c398, 0x05c510, 0x05c687,
	0x05c7fe, 0x05c974, 0x05caeb, 0x05cc62,
	0x05cdd9, 0x05cf50, 0x05d0c6, 0x05d23d,
	0x05d3b3, 0x05d52a, 0x05d6a0, 0x05d817,
	0x05d98d, 0x05db03, 0x05dc79, 0x05ddf0,
	0x05df66, 0x05e0dc, 0x05e252, 0x05e3c8,
	0x05e53d, 0x05e6b3, 0x05e829, 0x05e99f,
	0x05eb14, 0x05ec8a, 0x05edff, 0x05ef75,
	0x05f0ea, 0x05f260, 0x05f3d5, 0x05f54a,
	0x05f6bf, 0x05f834, 0x05f9aa, 0x05fb1f,
	0x05fc93, 0x05fe08, 0x05ff7d, 0x0600f2,
	0x060267, 0x0603db, 0x060550, 0x0606c4,
	0x060839, 0x0609ad, 0x060b22, 0x060c96,
	0x060e0a, 0x060f7e, 0x0610f3, 0x061267,
	0x0613db, 0x06154f, 0x0616c3, 0x061836,
	0x0619aa, 0x061b1e, 0x061c92, 0x061e05,
	0x061f79, 0x0620ec, 0x062260, 0x0623d3,
	0x062546, 0x0626b9, 0x06282d, 0x0629a0,
	0x062b13, 0x062c86, 0x062df9, 0x062f6c,
	0x0630df, 0x063251, 0x0633c4, 0x063537,
	0x0636a9, 0x06381c, 0x06398e, 0x063b01,
	0x063c73, 0x063de5, 0x063f58, 0x0640ca,
	0x06423c, 0x0643ae, 0x064520, 0x064692,
	0x064804, 0x064976, 0x064ae7, 0x064c59,
	0x064dcb, 0x064f3c, 0x0650ae, 0x06521f,
	0x065391, 0x065502, 0x065673, 0x0657e4,
	0x065955, 0x065ac7, 0x065c38, 0x065da8,
	0x065f19, 0x06608a, 0x0661fb, 0x06636c,
	0x0664dc, 0x06664d, 0x0667bd, 0x06692e,
	0x066a9e, 0x066c0f, 0x066d7f, 0x066eef,
	0x06705f, 0x0671cf, 0x06733f, 0x0674af,
	0x06761f, 0x06778f, 0x0678ff, 0x067a6f,
	0x067bde, 0x067d4e, 0x067ebd, 0x06802d,
	0x06819c, 0x06830c, 0x06847b, 0x0685ea,
	0x068759, 0x0688c8, 0x068a37, 0x068ba6,
	0x068d15, 0x068e84, 0x068ff3, 0x069162,
	0x0692d0, 0x06943f, 0x0695ad, 0x06971c,
	0x06988a, 0x0699f9, 0x069b67, 0x069cd5,
	0x069e43, 0x069fb1, 0x06a11f, 0x06a28d,
	0x06a3fb, 0x06a569, 0x06a6d7, 0x06a844,
	0x06a9b2, 0x06ab20, 0x06ac8d, 0x06adfb,
	0x06af68, 0x06b0d5, 0x06b242, 0x06b3b0,
	0x06b51d, 0x06b68a, 0x06b7f7, 0x06b964,
	0x06bad1, 0x06bc3d, 0x06bdaa, 0x06bf17,
	0x06c083, 0x06c1f0, 0x06c35c, 0x06c4c9,
	0x06c635, 0x06c7a1, 0x06c90e, 0x06ca7a,
	0x06cbe6, 0x06cd52, 0x06cebe, 0x06d02a,
	0x06d195, 0x06d301, 0x06d46d, 0x06d5d8,
	0x06d744, 0x06d8af, 0x06da1b, 0x06db86,
	0x06dcf2, 0x06de5d, 0x06dfc8, 0x06e133,
	0x06e29e, 0x06e409, 0x06e574, 0x06e6df,
	0x06e849, 0x06e9b4, 0x06eb1f, 0x06ec89,
	0x06edf4, 0x06ef5e, 0x06f0c9, 0x06f233,
	0x06f39d, 0x06f507, 0x06f671, 0x06f7db,
	0x06f945, 0x06faaf, 0x06fc19, 0x06fd83,
	0x06feec, 0x070056, 0x0701c0, 0x070329,
	0x070492, 0x0705fc, 0x070765, 0x0708ce,
	0x070a37, 0x070ba1, 0x070d0a, 0x070e72,
	0x070fdb, 0x071144, 0x0712ad, 0x071416,
	0x07157e, 0x0716e7, 0x07184f, 0x0719b7,
	0x071b20, 0x071c88, 0x071df0, 0x071f58,
	0x0720c0, 0x072228, 0x072390, 0x0724f8,
	0x072660, 0x0727c8, 0x07292f, 0x072a97,
	0x072bfe, 0x072d66, 0x072ecd, 0x073034,
	0x07319c, 0x073303, 0x07346a, 0x0735d1,
	0x073738, 0x07389f, 0x073a06, 0x073b6c,
	0x073cd3, 0x073e3a, 0x073fa0, 0x074106,
	0x07426d, 0x0743d3, 0x074539, 0x0746a0,
	0x074806, 0x07496c, 0x074ad2, 0x074c38,
	0x074d9d, 0x074f03, 0x075069, 0x0751ce,
	0x075334, 0x07549a, 0x0755ff, 0x075764,
	0x0758ca, 0x075a2f, 0x075b94, 0x075cf9,
	0x075e5e, 0x075fc3, 0x076128, 0x07628c,
	0x0763f1, 0x076556, 0x0766ba, 0x07681f,
	0x076983, 0x076ae7, 0x076c4c, 0x076db0,
	0x076f14, 0x077078, 0x0771dc, 0x077340,
	0x0774a4, 0x077608, 0x07776b, 0x0778cf,
	0x077a32, 0x077b96, 0x077cf9, 0x077e5d,
	0x077fc0, 0x078123, 0x078286, 0x0783e9,
	0x07854c, 0x0786af, 0x078812, 0x078975,
	0x078ad7, 0x078c3a, 0x078d9c, 0x078eff,
	0x079061, 0x0791c4, 0x079326, 0x079488,
	0x0795ea, 0x07974c, 0x0798ae, 0x079a10,
	0x079b72, 0x079cd3, 0x079e35, 0x079f97,
	0x07a0f8, 0x07a25a, 0x07a3bb, 0x07a51c,
	0x07a67e, 0x07a7df, 0x07a940, 0x07aaa1,
	0x07ac02, 0x07ad62, 0x07aec3, 0x07b024,
	0x07b185, 0x07b2e5, 0x07b446, 0x07b5a6,
	0x07b706, 0x07b867, 0x07b9c7, 0x07bb27,
	0x07bc87, 0x07bde7, 0x07bf47, 0x07c0a7,
	0x07c206, 0x07c366, 0x07c4c5, 0x07c625,
	0x07c784, 0x07c8e4, 0x07ca43, 0x07cba2,
	0x07cd01, 0x07ce60, 0x07cfbf, 0x07d11e,
	0x07d27d, 0x07d3dc, 0x07d53b, 0x07d699,
	0x07d7f8, 0x07d956, 0x07dab5, 0x07dc13,
	0x07dd71, 0x07decf, 0x07e02d, 0x07e18b,
	0x07e2e9, 0x07e447, 0x07e5a5, 0x07e703,
	0x07e860, 0x07e9be, 0x07eb1b, 0x07ec79,
	0x07edd6, 0x07ef33, 0x07f090, 0x07f1ed,
	0x07f34a, 0x07f4a7, 0x07f604, 0x07f761,
	0x07f8be, 0x07fa1a, 0x07fb77, 0x07fcd3,
	0x07fe30, 0x07ff8c, 0x0800e8, 0x080244,
	0x0803a0, 0x0804fc, 0x080658, 0x0807b4,
	0x080910, 0x080a6c, 0x080bc7, 0x080d23,
	0x080e7e, 0x080fda, 0x081135, 0x081290,
	0x0813eb, 0x081546, 0x0816a1, 0x0817fc,
	0x081957, 0x081ab2, 0x081c0d, 0x081d67,
	0x081ec2, 0x08201c, 0x082177, 0x0822d1,
	0x08242b, 0x082585, 0x0826df, 0x082839,
	0x082993, 0x082aed, 0x082c47, 0x082da0,
	0x082efa, 0x083053, 0x0831ad, 0x083306,
	0x083460, 0x0835b9, 0x083712, 0x08386b,
	0x0839c4, 0x083b1d, 0x083c75, 0x083dce,
	0x083f27, 0x08407f, 0x0841d8, 0x084330,
	0x084489, 0x0845e1, 0x084739, 0x084891,
	0x0849e9, 0x084b41, 0x084c99, 0x084df1,
	0x084f48, 0x0850a0, 0x0851f7, 0x08534f,
	0x0854a6, 0x0855fd, 0x085755, 0x0858ac,
	0x085a03, 0x085b5a, 0x085cb1, 0x085e07,
	0x085f5e, 0x0860b5, 0x08620b, 0x086362,
	0x0864b8, 0x08660e, 0x086765, 0x0868bb,
	0x086a11, 0x086b67, 0x086cbd, 0x086e13,
	0x086f68, 0x0870be, 0x087214, 0x087369,
	0x0874bf, 0x087614, 0x087769, 0x0878be,
	0x087a13, 0x087b68, 0x087cbd, 0x087e12,
	0x087f67, 0x0880bc, 0x088210, 0x088365,
	0x0884b9, 0x08860d, 0x088762, 0x0888b6,
	0x088a0a, 0x088b5e, 0x088cb2, 0x088e06,
	0x088f5a, 0x0890ad, 0x089201, 0x089355,
	0x0894a8, 0x0895fb, 0x08974f, 0x0898a2,
	0x0899f5, 0x089b48, 0x089c9b, 0x089dee,
	0x089f41, 0x08a093, 0x08a1e6, 0x08a338,
	0x08a48b, 0x08a5dd, 0x08a72f, 0x08a882,
	0x08a9d4, 0x08ab26, 0x08ac78, 0x08adca,
	0x08af1b, 0x08b06d, 0x08b1bf, 0x08b310,
	0x08b462, 0x08b5b3, 0x08b704, 0x08b856,
	0x08b9a7, 0x08baf8, 0x08bc49, 0x08bd9a,
	0x08beea, 0x08c03b, 0x08c18c, 0x08c2dc,
	0x08c42d, 0x08c57d, 0x08c6cd, 0x08c81d,
	0x08c96d, 0x08cabd, 0x08cc0d, 0x08cd5d,
	0x08cead, 0x08cffd, 0x08d14c, 0x08d29c,
	0x08d3eb, 0x08d53b, 0x08d68a, 0x08d7d9,
	0x08d928, 0x08da77, 0x08dbc6, 0x08dd15,
	0x08de64, 0x08dfb2, 0x08e101, 0x08e24f,
	0x08e39e, 0x08e4ec, 0x08e63a, 0x08e788,
	0x08e8d6, 0x08ea24, 0x08eb72, 0x08ecc0,
	0x08ee0e, 0x08ef5b, 0x08f0a9, 0x08f1f6,
	0x08f344, 0x08f491, 0x08f5de, 0x08f72b,
	0x08f878, 0x08f9c5, 0x08fb12, 0x08fc5f,
	0x08fdab, 0x08fef8, 0x090045, 0x090191,
	0x0902dd, 0x09042a, 0x090576, 0x0906c2,
	0x09080e, 0x09095a, 0x090aa5, 0x090bf1,
	0x090d3d, 0x090e88, 0x090fd4, 0x09111f,
	0x09126a, 0x0913b6, 0x091501, 0x09164c,
	0x091797, 0x0918e2, 0x091a2c, 0x091b77,
	0x091cc2, 0x091e0c, 0x091f56, 0x0920a1,
	0x0921eb, 0x092335, 0x09247f, 0x0925c9,
	0x092713, 0x09285d, 0x0929a7, 0x092af0,
	0x092c3a, 0x092d83, 0x092ecc, 0x093016,
	0x09315f, 0x0932a8, 0x0933f1, 0x09353a,
	0x093683, 0x0937cb, 0x093914, 0x093a5d,
	0x093ba5, 0x093ced, 0x093e36, 0x093f7e,
	0x0940c6, 0x09420e, 0x094356, 0x09449e,
	0x0945e5, 0x09472d, 0x094875, 0x0949bc,
	0x094b04, 0x094c4b, 0x094d92, 0x094ed9,
	0x095020, 0x095167, 0x0952ae, 0x0953f5,
	0x09553b, 0x095682, 0x0957c9, 0x09590f,
	0x095a55, 0x095b9b, 0x095ce2, 0x095e28,
	0x095f6e, 0x0960b3, 0x0961f9, 0x09633f,
	0x096484, 0x0965ca, 0x09670f, 0x096855,
	0x09699a, 0x096adf, 0x096c24, 0x096d69,
	0x096eae, 0x096ff3, 0x097137, 0x09727c,
	0x0973c0, 0x097505, 0x097649, 0x09778d,
	0x0978d2, 0x097a16, 0x097b5a, 0x097c9d,
	0x097de1, 0x097f25, 0x098068, 0x0981ac,
	0x0982ef, 0x098433, 0x098576, 0x0986b9,
	0x0987fc, 0x09893f, 0x098a82, 0x098bc5,
	0x098d07, 0x098e4a, 0x098f8c, 0x0990cf,
	0x099211, 0x099353, 0x099495, 0x0995d7,
	0x099719, 0x09985b, 0x09999d, 0x099ade,
	0x099c20, 0x099d61, 0x099ea3, 0x099fe4,
	0x09a125, 0x09a266, 0x09a3a7, 0x09a4e8,
	0x09a629, 0x09a76a, 0x09a8ab, 0x09a9eb,
	0x09ab2b, 0x09ac6c, 0x09adac, 0x09aeec,
	0x09b02c, 0x09b16c, 0x09b2ac, 0x09b3ec,
	0x09b52c, 0x09b66b, 0x09b7ab, 0x09b8ea,
	0x09ba2a, 0x09bb69, 0x09bca8, 0x09bde7,
	0x09bf26, 0x09c065, 0x09c1a4, 0x09c2e2,
	0x09c421, 0x09c55f, 0x09c69e, 0x09c7dc,
	0x09c91a, 0x09ca58, 0x09cb96, 0x09ccd4,
	0x09ce12, 0x09cf50, 0x09d08d, 0x09d1cb,
	0x09d308, 0x09d446, 0x09d583, 0x09d6c0,
	0x09d7fd, 0x09d93a, 0x09da77, 0x09dbb4,
	0x09dcf0, 0x09de2d, 0x09df69, 0x09e0a6,
	0x09e1e2, 0x09e31e, 0x09e45a, 0x09e596,
	0x09e6d2, 0x09e80e, 0x09e94a, 0x09ea86,
	0x09ebc1, 0x09ecfd, 0x09ee38, 0x09ef73,
	0x09f0ae, 0x09f1e9, 0x09f324, 0x09f45f,
	0x09f59a, 0x09f6d5, 0x09f80f, 0x09f94a,
	0x09fa84, 0x09fbbe, 0x09fcf9, 0x09fe33,
	0x09ff6d, 0x0a00a7, 0x0a01e0, 0x0a031a,
	0x0a0454, 0x0a058d, 0x0a06c7, 0x0a0800,
	0x0a0939, 0x0a0a72, 0x0a0bab, 0x0a0ce4,
	0x0a0e1d, 0x0a0f56, 0x0a108f, 0x0a11c7,
	0x0a1300, 0x0a1438, 0x0a1570, 0x0a16a8,
	0x0a17e0, 0x0a1918, 0x0a1a50, 0x0a1b88,
	0x0a1cc0, 0x0a1df7, 0x0a1f2f, 0x0a2066,
	0x0a219d, 0x0a22d5, 0x0a240c, 0x0a2543,
	0x0a267a, 0x0a27b0, 0x0a28e7, 0x0a2a1e,
	0x0a2b54, 0x0a2c8b, 0x0a2dc1, 0x0a2ef7,
	0x0a302d, 0x0a3163, 0x0a3299, 0x0a33cf,
	0x0a3505, 0x0a363a, 0x0a3770, 0x0a38a5,
	0x0a39db, 0x0a3b10, 0x0a3c45, 0x0a3d7a,
	0x0a3eaf, 0x0a3fe4, 0x0a4118, 0x0a424d,
	0x0a4382, 0x0a44b6, 0x0a45ea, 0x0a471f,
	0x0a4853, 0x0a4987, 0x0a4abb, 0x0a4bef,
	0x0a4d22, 0x0a4e56, 0x0a4f89, 0x0a50bd,
	0x0a51f0, 0x0a5324, 0x0a5457, 0x0a558a,
	0x0a56bd, 0x0a57f0, 0x0a5922, 0x0a5a55,
	0x0a5b87, 0x0a5cba, 0x0a5dec, 0x0a5f1e,
	0x0a6051, 0x0a6183, 0x0a62b5, 0x0a63e6,
	0x0a6518, 0x0a664a, 0x0a677b, 0x0a68ad,
	0x0a69de, 0x0a6b0f, 0x0a6c41, 0x0a6d72,
	0x0a6ea3, 0x0a6fd3, 0x0a7104, 0x0a7235,
	0x0a7365, 0x0a7496, 0x0a75c6, 0x0a76f6,
	0x0a7827, 0x0a7957, 0x0a7a87, 0x0a7bb6,
	0x0a7ce6, 0x0a7e16, 0x0a7f45, 0x0a8075,
	0x0a81a4, 0x0a82d3, 0x0a8402, 0x0a8531,
	0x0a8660, 0x0a878f, 0x0a88be, 0x0a89ec,
	0x0a8b1b, 0x0a8c49, 0x0a8d78, 0x0a8ea6,
	0x0a8fd4, 0x0a9102, 0x0a9230, 0x0a935e,
	0x0a948b, 0x0a95b9, 0x0a96e7, 0x0a9814,
	0x0a9941, 0x0a9a6e, 0x0a9b9c, 0x0a9cc9,
	0x0a9df5, 0x0a9f22, 0x0aa04f, 0x0aa17c,
	0x0aa2a8, 0x0aa3d4, 0x0aa501, 0x0aa62d,
	0x0aa759, 0x0aa885, 0x0aa9b1, 0x0aaadc,
	0x0aac08, 0x0aad34, 0x0aae5f, 0x0aaf8a,
	0x0ab0b6, 0x0ab1e1, 0x0ab30c, 0x0ab437,
	0x0ab562, 0x0ab68c, 0x0ab7b7, 0x0ab8e2,
	0x0aba0c, 0x0abb36, 0x0abc60, 0x0abd8b,
	0x0abeb5, 0x0abfdf, 0x0ac108, 0x0ac232,
	0x0ac35c, 0x0ac485, 0x0ac5ae, 0x0ac6d8,
	0x0ac801, 0x0ac92a, 0x0aca53, 0x0acb7c,
	0x0acca5, 0x0acdcd, 0x0acef6, 0x0ad01e,
	0x0ad147, 0x0ad26f, 0x0ad397, 0x0ad4bf,
	0x0ad5e7, 0x0ad70f, 0x0ad836, 0x0ad95e,
	0x0ada86, 0x0adbad, 0x0adcd4, 0x0addfb,
	0x0adf23, 0x0ae04a, 0x0ae170, 0x0ae297,
	0x0ae3be, 0x0ae4e4, 0x0ae60b, 0x0ae731,
	0x0ae858, 0x0ae97e, 0x0aeaa4, 0x0aebca,
	0x0aecef, 0x0aee15, 0x0aef3b, 0x0af060,
	0x0af186, 0x0af2ab, 0x0af3d0, 0x0af4f5,
	0x0af61a, 0x0af73f, 0x0af864, 0x0af989,
	0x0afaad, 0x0afbd2, 0x0afcf6, 0x0afe1a,
	0x0aff3e, 0x0b0062, 0x0b0186, 0x0b02aa,
	0x0b03ce, 0x0b04f1, 0x0b0615, 0x0b0738,
	0x0b085c, 0x0b097f, 0x0b0aa2, 0x0b0bc5,
	0x0b0ce8, 0x0b0e0b, 0x0b0f2d, 0x0b1050,
	0x0b1172, 0x0b1294, 0x0b13b7, 0x0b14d9,
	0x0b15fb, 0x0b171d, 0x0b183f, 0x0b1960,
	0x0b1a82, 0x0b1ba3, 0x0b1cc5, 0x0b1de6,
	0x0b1f07, 0x0b2028, 0x0b2149, 0x0b226a,
	0x0b238b, 0x0b24ab, 0x0b25cc, 0x0b26ec,
	0x0b280c, 0x0b292d, 0x0b2a4d, 0x0b2b6d,
	0x0b2c8d, 0x0b2dac, 0x0b2ecc, 0x0b2fec,
	0x0b310b, 0x0b322a, 0x0b334a, 0x0b3469,
	0x0b3588, 0x0b36a7, 0x0b37c5, 0x0b38e4,
	0x0b3a03, 0x0b3b21, 0x0b3c3f, 0x0b3d5e,
	0x0b3e7c, 0x0b3f9a, 0x0b40b8, 0x0b41d6,
	0x0b42f3, 0x0b4411, 0x0b452e, 0x0b464c,
	0x0b4769, 0x0b4886, 0x0b49a3, 0x0b4ac0,
	0x0b4bdd, 0x0b4cfa, 0x0b4e16, 0x0b4f33,
	0x0b504f, 0x0b516b, 0x0b5288, 0x0b53a4,
	0x0b54c0, 0x0b55dc, 0x0b56f7, 0x0b5813,
	0x0b592e, 0x0b5a4a, 0x0b5b65, 0x0b5c80,
	0x0b5d9b, 0x0b5eb6, 0x0b5fd1, 0x0b60ec,
	0x0b6207, 0x0b6321, 0x0b643c, 0x0b6556,
	0x0b6670, 0x0b678a, 0x0b68a4, 0x0b69be,
	0x0b6ad8, 0x0b6bf2, 0x0b6d0b, 0x0b6e25,
	0x0b6f3e, 0x0b7057, 0x0b7170, 0x0b7289,
	0x0b73a2, 0x0b74bb, 0x0b75d4, 0x0b76ec,
	0x0b7805, 0x0b791d, 0x0b7a35, 0x0b7b4d,
	0x0b7c65, 0x0b7d7d, 0x0b7e95, 0x0b7fad,
	0x0b80c4, 0x0b81dc, 0x0b82f3, 0x0b840a,
	0x0b8521, 0x0b8638, 0x0b874f, 0x0b8866,
	0x0b897d, 0x0b8a93, 0x0b8baa, 0x0b8cc0,
	0x0b8dd6, 0x0b8eec, 0x0b9002, 0x0b9118,
	0x0b922e, 0x0b9344, 0x0b9459, 0x0b956f,
	0x0b9684, 0x0b9799, 0x0b98ae, 0x0b99c3,
	0x0b9ad8, 0x0b9bed, 0x0b9d02, 0x0b9e16,
	0x0b9f2b, 0x0ba03f, 0x0ba153, 0x0ba267,
	0x0ba37b, 0x0ba48f, 0x0ba5a3, 0x0ba6b7,
	0x0ba7ca, 0x0ba8de, 0x0ba9f1, 0x0bab04,
	0x0bac17, 0x0bad2a, 0x0bae3d, 0x0baf50,
	0x0bb063, 0x0bb175, 0x0bb288, 0x0bb39a,
	0x0bb4ac, 0x0bb5be, 0x0bb6d0, 0x0bb7e2,
	0x0bb8f4, 0x0bba05, 0x0bbb17, 0x0bbc28,
	0x0bbd3a, 0x0bbe4b, 0x0bbf5c, 0x0bc06d,
	0x0bc17e, 0x0bc28e, 0x0bc39f, 0x0bc4af,
	0x0bc5c0, 0x0bc6d0, 0x0bc7e0, 0x0bc8f0,
	0x0bca00, 0x0bcb10, 0x0bcc20, 0x0bcd2f,
	0x0bce3f, 0x0bcf4e, 0x0bd05d, 0x0bd16c,
	0x0bd27c, 0x0bd38a, 0x0bd499, 0x0bd5a8,
	0x0bd6b6, 0x0bd7c5, 0x0bd8d3, 0x0bd9e1,
	0x0bdaf0, 0x0bdbfe, 0x0bdd0b, 0x0bde19,
	0x0bdf27, 0x0be034, 0x0be142, 0x0be24f,
	0x0be35c, 0x0be469, 0x0be576, 0x0be683,
	0x0be790, 0x0be89d, 0x0be9a9, 0x0beab5,
	0x0bebc2, 0x0becce, 0x0bedda, 0x0beee6,
	0x0beff2, 0x0bf0fd, 0x0bf209, 0x0bf314,
	0x0bf420, 0x0bf52b, 0x0bf636, 0x0bf741,
	0x0bf84c, 0x0bf957, 0x0bfa61, 0x0bfb6c,
	0x0bfc76, 0x0bfd81, 0x0bfe8b, 0x0bff95,
	0x0c009f, 0x0c01a9, 0x0c02b3, 0x0c03bc,
	0x0c04c6, 0x0c05cf, 0x0c06d8, 0x0c07e2,
	0x0c08eb, 0x0c09f4, 0x0c0afc, 0x0c0c05,
	0x0c0d0e, 0x0c0e16, 0x0c0f1e, 0x0c1027,
	0x0c112f, 0x0c1237, 0x0c133f, 0x0c1446,
	0x0c154e, 0x0c1656, 0x0c175d, 0x0c1864,
	0x0c196b, 0x0c1a73, 0x0c1b79, 0x0c1c80,
	0x0c1d87, 0x0c1e8e, 0x0c1f94, 0x0c209a,
	0x0c21a1, 0x0c22a7, 0x0c23ad, 0x0c24b3,
	0x0c25b9, 0x0c26be, 0x0c27c4, 0x0c28c9,
	0x0c29ce, 0x0c2ad4, 0x0c2bd9, 0x0c2cde,
	0x0c2de3, 0x0c2ee7, 0x0c2fec, 0x0c30f0,
	0x0c31f5, 0x0c32f9, 0x0c33fd, 0x0c3501,
	0x0c3605, 0x0c3709, 0x0c380d, 0x0c3910,
	0x0c3a13, 0x0c3b17, 0x0c3c1a, 0x0c3d1d,
	0x0c3e20, 0x0c3f23, 0x0c4026, 0x0c4128,
	0x0c422b, 0x0c432d, 0x0c442f, 0x0c4531,
	0x0c4633, 0x0c4735, 0x0c4837, 0x0c4939,
	0x0c4a3a, 0x0c4b3c, 0x0c4c3d, 0x0c4d3e,
	0x0c4e3f, 0x0c4f40, 0x0c5041, 0x0c5142,
	0x0c5242, 0x0c5343, 0x0c5443, 0x0c5543,
	0x0c5644, 0x0c5744, 0x0c5843, 0x0c5943,
	0x0c5a43, 0x0c5b42, 0x0c5c42, 0x0c5d41,
	0x0c5e40, 0x0c5f3f, 0x0c603e, 0x0c613d,
	0x0c623c, 0x0c633a, 0x0c6439, 0x0c6537,
	0x0c6635, 0x0c6733, 0x0c6831, 0x0c692f,
	0x0c6a2d, 0x0c6b2a, 0x0c6c28, 0x0c6d25,
	0x0c6e23, 0x0c6f20, 0x0c701d, 0x0c711a,
	0x0c7216, 0x0c7313, 0x0c7410, 0x0c750c,
	0x0c7608, 0x0c7704, 0x0c7801, 0x0c78fc,
	0x0c79f8, 0x0c7af4, 0x0c7bf0, 0x0c7ceb,
	0x0c7de6, 0x0c7ee2, 0x0c7fdd, 0x0c80d8,
	0x0c81d2, 0x0c82cd, 0x0c83c8, 0x0c84c2,
	0x0c85bd, 0x0c86b7, 0x0c87b1, 0x0c88ab,
	0x0c89a5, 0x0c8a9f, 0x0c8b98, 0x0c8c92,
	0x0c8d8b, 0x0c8e84, 0x0c8f7e, 0x0c9077,
	0x0c9170, 0x0c9268, 0x0c9361, 0x0c945a,
	0x0c9552, 0x0c964a, 0x0c9743, 0x0c983b,
	0x0c9933, 0x0c9a2a, 0x0c9b22, 0x0c9c1a,
	0x0c9d11, 0x0c9e08, 0x0c9f00, 0x0c9ff7,
	0x0ca0ee, 0x0ca1e5, 0x0ca2db, 0x0ca3d2,
	0x0ca4c8, 0x0ca5bf, 0x0ca6b5, 0x0ca7ab,
	0x0ca8a1, 0x0ca997, 0x0caa8d, 0x0cab82,
	0x0cac78, 0x0cad6d, 0x0cae63, 0x0caf58,
	0x0cb04d, 0x0cb142, 0x0cb236, 0x0cb32b,
	0x0cb420, 0x0cb514, 0x0cb608, 0x0cb6fc,
	0x0cb7f1, 0x0cb8e4, 0x0cb9d8, 0x0cbacc,
	0x0cbbbf, 0x0cbcb3, 0x0cbda6, 0x0cbe99,
	0x0cbf8c, 0x0cc07f, 0x0cc172, 0x0cc265,
	0x0cc357, 0x0cc44a, 0x0cc53c, 0x0cc62e,
	0x0cc721, 0x0cc812, 0x0cc904, 0x0cc9f6,
	0x0ccae8, 0x0ccbd9, 0x0cccca, 0x0ccdbc,
	0x0ccead, 0x0ccf9e, 0x0cd08f, 0x0cd17f,
	0x0cd270, 0x0cd360, 0x0cd451, 0x0cd541,
	0x0cd631, 0x0cd721, 0x0cd811, 0x0cd901,
	0x0cd9f0, 0x0cdae0, 0x0cdbcf, 0x0cdcbe,
	0x0cddad, 0x0cde9c, 0x0cdf8b, 0x0ce07a,
	0x0ce169, 0x0ce257, 0x0ce345, 0x0ce434,
	0x0ce522, 0x0ce610, 0x0ce6fe, 0x0ce7eb,
	0x0ce8d9, 0x0ce9c6, 0x0ceab4, 0x0ceba1,
	0x0cec8e, 0x0ced7b, 0x0cee68, 0x0cef55,
	0x0cf041, 0x0cf12e, 0x0cf21a, 0x0cf307,
	0x0cf3f3, 0x0cf4df, 0x0cf5cb, 0x0cf6b6,
	0x0cf7a2, 0x0cf88d, 0x0cf979, 0x0cfa64,
	0x0cfb4f, 0x0cfc3a, 0x0cfd25, 0x0cfe10,
	0x0cfefa, 0x0cffe5, 0x0d00cf, 0x0d01ba,
	0x0d02a4, 0x0d038e, 0x0d0478, 0x0d0561,
	0x0d064b, 0x0d0734, 0x0d081e, 0x0d0907,
	0x0d09f0, 0x0d0ad9, 0x0d0bc2, 0x0d0cab,
	0x0d0d93, 0x0d0e7c, 0x0d0f64, 0x0d104d,
	0x0d1135, 0x0d121d, 0x0d1304, 0x0d13ec,
	0x0d14d4, 0x0d15bb, 0x0d16a3, 0x0d178a,
	0x0d1871, 0x0d1958, 0x0d1a3f, 0x0d1b26,
	0x0d1c0c, 0x0d1cf3, 0x0d1dd9, 0x0d1ebf,
	0x0d1fa5, 0x0d208b, 0x0d2171, 0x0d2257,
	0x0d233c, 0x0d2422, 0x0d2507, 0x0d25ec,
	0x0d26d1, 0x0d27b6, 0x0d289b, 0x0d2980,
	0x0d2a65, 0x0d2b49, 0x0d2c2d, 0x0d2d11,
	0x0d2df6, 0x0d2ed9, 0x0d2fbd, 0x0d30a1,
	0x0d3185, 0x0d3268, 0x0d334b, 0x0d342e,
	0x0d3512, 0x0d35f4, 0x0d36d7, 0x0d37ba,
	0x0d389c, 0x0d397f, 0x0d3a61, 0x0d3b43,
	0x0d3c25, 0x0d3d07, 0x0d3de9, 0x0d3ecb,
	0x0d3fac, 0x0d408e, 0x0d416f, 0x0d4250,
	0x0d4331, 0x0d4412, 0x0d44f3, 0x0d45d3,
	0x0d46b4, 0x0d4794, 0x0d4874, 0x0d4954,
	0x0d4a34, 0x0d4b14, 0x0d4bf4, 0x0d4cd4,
	0x0d4db3, 0x0d4e92, 0x0d4f72, 0x0d5051,
	0x0d5130, 0x0d520f, 0x0d52ed, 0x0d53cc,
	0x0d54aa, 0x0d5589, 0x0d5667, 0x0d5745,
	0x0d5823, 0x0d5901, 0x0d59de, 0x0d5abc,
	0x0d5b99, 0x0d5c76, 0x0d5d54, 0x0d5e31,
	0x0d5f0e, 0x0d5fea, 0x0d60c7, 0x0d61a3,
	0x0d6280, 0x0d635c, 0x0d6438, 0x0d6514,
	0x0d65f0, 0x0d66cc, 0x0d67a7, 0x0d6883,
	0x0d695e, 0x0d6a3a, 0x0d6b15, 0x0d6bf0,
	0x0d6cca, 0x0d6da5, 0x0d6e80, 0x0d6f5a,
	0x0d7034, 0x0d710f, 0x0d71e9, 0x0d72c3,
	0x0d739c, 0x0d7476, 0x0d7550, 0x0d7629,
	0x0d7702, 0x0d77dc, 0x0d78b5, 0x0d798d,
	0x0d7a66, 0x0d7b3f, 0x0d7c17, 0x0d7cf0,
	0x0d7dc8, 0x0d7ea0, 0x0d7f78, 0x0d8050,
	0x0d8128, 0x0d81ff, 0x0d82d7, 0x0d83ae,
	0x0d8485, 0x0d855c, 0x0d8633, 0x0d870a,
	0x0d87e1, 0x0d88b7, 0x0d898e, 0x0d8a64,
	0x0d8b3a, 0x0d8c10, 0x0d8ce6, 0x0d8dbc,
	0x0d8e91, 0x0d8f67, 0x0d903c, 0x0d9112,
	0x0d91e7, 0x0d92bc, 0x0d9390, 0x0d9465,
	0x0d953a, 0x0d960e, 0x0d96e3, 0x0d97b7,
	0x0d988b, 0x0d995f, 0x0d9a33, 0x0d9b06,
	0x0d9bda, 0x0d9cad, 0x0d9d80, 0x0d9e54,
	0x0d9f27, 0x0d9ffa, 0x0da0cc, 0x0da19f,
	0x0da271, 0x0da344, 0x0da416, 0x0da4e8,
	0x0da5ba, 0x0da68c, 0x0da75e, 0x0da82f,
	0x0da901, 0x0da9d2, 0x0daaa3, 0x0dab74,
	0x0dac45, 0x0dad16, 0x0dade6, 0x0daeb7,
	0x0daf87, 0x0db058, 0x0db128, 0x0db1f8,
	0x0db2c8, 0x0db397, 0x0db467, 0x0db536,
	0x0db606, 0x0db6d5, 0x0db7a4, 0x0db873,
	0x0db942, 0x0dba10, 0x0dbadf, 0x0dbbad,
	0x0dbc7c, 0x0dbd4a, 0x0dbe18, 0x0dbee6,
	0x0dbfb3, 0x0dc081, 0x0dc14e, 0x0dc21c,
	0x0dc2e9, 0x0dc3b6, 0x0dc483, 0x0dc550,
	0x0dc61c, 0x0dc6e9, 0x0dc7b5, 0x0dc882,
	0x0dc94e, 0x0dca1a, 0x0dcae6, 0x0dcbb1,
	0x0dcc7d, 0x0dcd49, 0x0dce14, 0x0dcedf,
	0x0dcfaa, 0x0dd075, 0x0dd140, 0x0dd20b,
	0x0dd2d5, 0x0dd3a0, 0x0dd46a, 0x0dd534,
	0x0dd5fe, 0x0dd6c8, 0x0dd792, 0x0dd85b,
	0x0dd925, 0x0dd9ee, 0x0ddab7, 0x0ddb80,
	0x0ddc49, 0x0ddd12, 0x0ddddb, 0x0ddea3,
	0x0ddf6c, 0x0de034, 0x0de0fc, 0x0de1c4,
	0x0de28c, 0x0de354, 0x0de41c, 0x0de4e3,
	0x0de5aa, 0x0de672, 0x0de739, 0x0de800,
	0x0de8c6, 0x0de98d, 0x0dea54, 0x0deb1a,
	0x0debe0, 0x0deca6, 0x0ded6c, 0x0dee32,
	0x0deef8, 0x0defbe, 0x0df083, 0x0df148,
	0x0df20e, 0x0df2d3, 0x0df398, 0x0df45c,
	0x0df521, 0x0df5e6, 0x0df6aa, 0x0df76e,
	0x0df832, 0x0df8f6, 0x0df9ba, 0x0dfa7e,
	0x0dfb42, 0x0dfc05, 0x0dfcc8, 0x0dfd8c,
	0x0dfe4f, 0x0dff11, 0x0dffd4, 0x0e0097,
	0x0e0159, 0x0e021c, 0x0e02de, 0x0e03a0,
	0x0e0462, 0x0e0524, 0x0e05e6, 0x0e06a7,
	0x0e0769, 0x0e082a, 0x0e08eb, 0x0e09ac,
	0x0e0a6d, 0x0e0b2e, 0x0e0bee, 0x0e0caf,
	0x0e0d6f, 0x0e0e2f, 0x0e0eef, 0x0e0faf,
	0x0e106f, 0x0e112f, 0x0e11ee, 0x0e12ae,
	0x0e136d, 0x0e142c, 0x0e14eb, 0x0e15aa,
	0x0e1669, 0x0e1727, 0x0e17e6, 0x0e18a4,
	0x0e1962, 0x0e1a20, 0x0e1ade, 0x0e1b9c,
	0x0e1c59, 0x0e1d17, 0x0e1dd4, 0x0e1e92,
	0x0e1f4f, 0x0e200c, 0x0e20c8, 0x0e2185,
	0x0e2242, 0x0e22fe, 0x0e23ba, 0x0e2476,
	0x0e2532, 0x0e25ee, 0x0e26aa, 0x0e2766,
	0x0e2821, 0x0e28dc, 0x0e2997, 0x0e2a53,
	0x0e2b0d, 0x0e2bc8, 0x0e2c83, 0x0e2d3d,
	0x0e2df8, 0x0e2eb2, 0x0e2f6c, 0x0e3026,
	0x0e30e0, 0x0e3199, 0x0e3253, 0x0e330c,
	0x0e33c6, 0x0e347f, 0x0e3538, 0x0e35f1,
	0x0e36a9, 0x0e3762, 0x0e381a, 0x0e38d3,
	0x0e398b, 0x0e3a43, 0x0e3afb, 0x0e3bb2,
	0x0e3c6a, 0x0e3d22, 0x0e3dd9, 0x0e3e90,
	0x0e3f47, 0x0e3ffe, 0x0e40b5, 0x0e416c,
	0x0e4222, 0x0e42d8, 0x0e438f, 0x0e4445,
	0x0e44fb, 0x0e45b1, 0x0e4666, 0x0e471c,
	0x0e47d1, 0x0e4887, 0x0e493c, 0x0e49f1,
	0x0e4aa6, 0x0e4b5a, 0x0e4c0f, 0x0e4cc3,
	0x0e4d78, 0x0e4e2c, 0x0e4ee0, 0x0e4f94,
	0x0e5048, 0x0e50fb, 0x0e51af, 0x0e5262,
	0x0e5315, 0x0e53c8, 0x0e547b, 0x0e552e,
	0x0e55e1, 0x0e5693, 0x0e5746, 0x0e57f8,
	0x0e58aa, 0x0e595c, 0x0e5a0e, 0x0e5abf,
	0x0e5b71, 0x0e5c22, 0x0e5cd4, 0x0e5d85,
	0x0e5e36, 0x0e5ee7, 0x0e5f97, 0x0e6048,
	0x0e60f8, 0x0e61a9, 0x0e6259, 0x0e6309,
	0x0e63b9, 0x0e6469, 0x0e6518, 0x0e65c8,
	0x0e6677, 0x0e6726, 0x0e67d5, 0x0e6884,
	0x0e6933, 0x0e69e2, 0x0e6a90, 0x0e6b3f,
	0x0e6bed, 0x0e6c9b, 0x0e6d49, 0x0e6df7,
	0x0e6ea4, 0x0e6f52, 0x0e6fff, 0x0e70ac,
	0x0e715a, 0x0e7207, 0x0e72b3, 0x0e7360,
	0x0e740d, 0x0e74b9, 0x0e7565, 0x0e7611,
	0x0e76bd, 0x0e7769, 0x0e7815, 0x0e78c1,
	0x0e796c, 0x0e7a17, 0x0e7ac3, 0x0e7b6e,
	0x0e7c18, 0x0e7cc3, 0x0e7d6e, 0x0e7e18,
	0x0e7ec3, 0x0e7f6d, 0x0e8017, 0x0e80c1,
	0x0e816a, 0x0e8214, 0x0e82be, 0x0e8367,
	0x0e8410, 0x0e84b9, 0x0e8562, 0x0e860b,
	0x0e86b4, 0x0e875c, 0x0e8804, 0x0e88ad,
	0x0e8955, 0x0e89fd, 0x0e8aa5, 0x0e8b4c,
	0x0e8bf4, 0x0e8c9b, 0x0e8d42, 0x0e8de9,
	0x0e8e90, 0x0e8f37, 0x0e8fde, 0x0e9084,
	0x0e912b, 0x0e91d1, 0x0e9277, 0x0e931d,
	0x0e93c3, 0x0e9469, 0x0e950e, 0x0e95b4,
	0x0e9659, 0x0e96fe, 0x0e97a3, 0x0e9848,
	0x0e98ed, 0x0e9991, 0x0e9a36, 0x0e9ada,
	0x0e9b7e, 0x0e9c22, 0x0e9cc6, 0x0e9d6a,
	0x0e9e0d, 0x0e9eb1, 0x0e9f54, 0x0e9ff7,
	0x0ea09a, 0x0ea13d, 0x0ea1e0, 0x0ea283,
	0x0ea325, 0x0ea3c7, 0x0ea46a, 0x0ea50c,
	0x0ea5ae, 0x0ea64f, 0x0ea6f1, 0x0ea792,
	0x0ea834, 0x0ea8d5, 0x0ea976, 0x0eaa17,
	0x0eaab8, 0x0eab58, 0x0eabf9, 0x0eac99,
	0x0ead39, 0x0eadd9, 0x0eae79, 0x0eaf19,
	0x0eafb9, 0x0eb058, 0x0eb0f8, 0x0eb197,
	0x0eb236, 0x0eb2d5, 0x0eb374, 0x0eb412,
	0x0eb4b1, 0x0eb54f, 0x0eb5ed, 0x0eb68b,
	0x0eb729, 0x0eb7c7, 0x0eb865, 0x0eb902,
	0x0eb9a0, 0x0eba3d, 0x0ebada, 0x0ebb77,
	0x0ebc14, 0x0ebcb0, 0x0ebd4d, 0x0ebde9,
	0x0ebe86, 0x0ebf22, 0x0ebfbe, 0x0ec059,
	0x0ec0f5, 0x0ec191, 0x0ec22c, 0x0ec2c7,
	0x0ec362, 0x0ec3fd, 0x0ec498, 0x0ec533,
	0x0ec5cd, 0x0ec668, 0x0ec702, 0x0ec79c,
	0x0ec836, 0x0ec8d0, 0x0ec969, 0x0eca03,
	0x0eca9c, 0x0ecb36, 0x0ecbcf, 0x0ecc68,
	0x0ecd00, 0x0ecd99, 0x0ece32, 0x0ececa,
	0x0ecf62, 0x0ecffa, 0x0ed092, 0x0ed12a,
	0x0ed1c2, 0x0ed259, 0x0ed2f1, 0x0ed388,
	0x0ed41f, 0x0ed4b6, 0x0ed54d, 0x0ed5e4,
	0x0ed67a, 0x0ed710, 0x0ed7a7, 0x0ed83d,
	0x0ed8d3, 0x0ed969, 0x0ed9fe, 0x0eda94,
	0x0edb29, 0x0edbbe, 0x0edc54, 0x0edce8,
	0x0edd7d, 0x0ede12, 0x0edea7, 0x0edf3b,
	0x0edfcf, 0x0ee063, 0x0ee0f7, 0x0ee18b,
	0x0ee21f, 0x0ee2b2, 0x0ee346, 0x0ee3d9,
	0x0ee46c, 0x0ee4ff, 0x0ee592, 0x0ee624,
	0x0ee6b7, 0x0ee749, 0x0ee7db, 0x0ee86e,
	0x0ee8ff, 0x0ee991, 0x0eea23, 0x0eeab4,
	0x0eeb46, 0x0eebd7, 0x0eec68, 0x0eecf9,
	0x0eed8a, 0x0eee1b, 0x0eeeab, 0x0eef3b,
	0x0eefcc, 0x0ef05c, 0x0ef0ec, 0x0ef17b,
	0x0ef20b, 0x0ef29b, 0x0ef32a, 0x0ef3b9,
	0x0ef448, 0x0ef4d7, 0x0ef566, 0x0ef5f4,
	0x0ef683, 0x0ef711, 0x0ef7a0, 0x0ef82e,
	0x0ef8bc, 0x0ef949, 0x0ef9d7, 0x0efa64,
	0x0efaf2, 0x0efb7f, 0x0efc0c, 0x0efc99,
	0x0efd26, 0x0efdb2, 0x0efe3f, 0x0efecb,
	0x0eff57, 0x0effe3, 0x0f006f, 0x0f00fb,
	0x0f0186, 0x0f0212, 0x0f029d, 0x0f0328,
	0x0f03b3, 0x0f043e, 0x0f04c9, 0x0f0554,
	0x0f05de, 0x0f0668, 0x0f06f3, 0x0f077d,
	0x0f0806, 0x0f0890, 0x0f091a, 0x0f09a3,
	0x0f0a2c, 0x0f0ab6, 0x0f0b3f, 0x0f0bc7,
	0x0f0c50, 0x0f0cd9, 0x0f0d61, 0x0f0de9,
	0x0f0e71, 0x0f0ef9, 0x0f0f81, 0x0f1009,
	0x0f1091, 0x0f1118, 0x0f119f, 0x0f1226,
	0x0f12ad, 0x0f1334, 0x0f13bb, 0x0f1441,
	0x0f14c8, 0x0f154e, 0x0f15d4, 0x0f165a,
	0x0f16e0, 0x0f1765, 0x0f17eb, 0x0f1870,
	0x0f18f5, 0x0f197b, 0x0f19ff, 0x0f1a84,
	0x0f1b09, 0x0f1b8d, 0x0f1c12, 0x0f1c96,
	0x0f1d1a, 0x0f1d9e, 0x0f1e22, 0x0f1ea5,
	0x0f1f29, 0x0f1fac, 0x0f202f, 0x0f20b2,
	0x0f2135, 0x0f21b8, 0x0f223a, 0x0f22bd,
	0x0f233f, 0x0f23c1, 0x0f2443, 0x0f24c5,
	0x0f2547, 0x0f25c9, 0x0f264a, 0x0f26cb,
	0x0f274c, 0x0f27cd, 0x0f284e, 0x0f28cf,
	0x0f2950, 0x0f29d0, 0x0f2a50, 0x0f2ad0,
	0x0f2b50, 0x0f2bd0, 0x0f2c50, 0x0f2ccf,
	0x0f2d4f, 0x0f2dce, 0x0f2e4d, 0x0f2ecc,
	0x0f2f4b, 0x0f2fc9, 0x0f3048, 0x0f30c6,
	0x0f3144, 0x0f31c3, 0x0f3240, 0x0f32be,
	0x0f333c, 0x0f33b9, 0x0f3437, 0x0f34b4,
	0x0f3531, 0x0f35ae, 0x0f362b, 0x0f36a7,
	0x0f3724, 0x0f37a0, 0x0f381c, 0x0f3898,
	0x0f3914, 0x0f3990, 0x0f3a0b, 0x0f3a87,
	0x0f3b02, 0x0f3b7d, 0x0f3bf8, 0x0f3c73,
	0x0f3cee, 0x0f3d68, 0x0f3de3, 0x0f3e5d,
	0x0f3ed7, 0x0f3f51, 0x0f3fcb, 0x0f4044,
	0x0f40be, 0x0f4137, 0x0f41b0, 0x0f422a,
	0x0f42a2, 0x0f431b, 0x0f4394, 0x0f440c,
	0x0f4485, 0x0f44fd, 0x0f4575, 0x0f45ed,
	0x0f4665, 0x0f46dc, 0x0f4754, 0x0f47cb,
	0x0f4842, 0x0f48b9, 0x0f4930, 0x0f49a7,
	0x0f4a1d, 0x0f4a94, 0x0f4b0a, 0x0f4b80,
	0x0f4bf6, 0x0f4c6c, 0x0f4ce2, 0x0f4d57,
	0x0f4dcd, 0x0f4e42, 0x0f4eb7, 0x0f4f2c,
	0x0f4fa1, 0x0f5015, 0x0f508a, 0x0f50fe,
	0x0f5172, 0x0f51e6, 0x0f525a, 0x0f52ce,
	0x0f5342, 0x0f53b5, 0x0f5429, 0x0f549c,
	0x0f550f, 0x0f5582, 0x0f55f4, 0x0f5667,
	0x0f56d9, 0x0f574c, 0x0f57be, 0x0f5830,
	0x0f58a2, 0x0f5913, 0x0f5985, 0x0f59f6,
	0x0f5a68, 0x0f5ad9, 0x0f5b4a, 0x0f5bbb,
	0x0f5c2b, 0x0f5c9c, 0x0f5d0c, 0x0f5d7c,
	0x0f5dec, 0x0f5e5c, 0x0f5ecc, 0x0f5f3c,
	0x0f5fab, 0x0f601b, 0x0f608a, 0x0f60f9,
	0x0f6168, 0x0f61d6, 0x0f6245, 0x0f62b3,
	0x0f6322, 0x0f6390, 0x0f63fe, 0x0f646c,
	0x0f64d9, 0x0f6547, 0x0f65b4, 0x0f6622,
	0x0f668f, 0x0f66fc, 0x0f6769, 0x0f67d5,
	0x0f6842, 0x0f68ae, 0x0f691a, 0x0f6986,
	0x0f69f2, 0x0f6a5e, 0x0f6aca, 0x0f6b35,
	0x0f6ba0, 0x0f6c0c, 0x0f6c77, 0x0f6ce2,
	0x0f6d4c, 0x0f6db7, 0x0f6e21, 0x0f6e8c,
	0x0f6ef6, 0x0f6f60, 0x0f6fca, 0x0f7033,
	0x0f709d, 0x0f7106, 0x0f716f, 0x0f71d8,
	0x0f7241, 0x0f72aa, 0x0f7313, 0x0f737b,
	0x0f73e4, 0x0f744c, 0x0f74b4, 0x0f751c,
	0x0f7584, 0x0f75eb, 0x0f7653, 0x0f76ba,
	0x0f7721, 0x0f7788, 0x0f77ef, 0x0f7856,
	0x0f78bc, 0x0f7923, 0x0f7989, 0x0f79ef,
	0x0f7a55, 0x0f7abb, 0x0f7b21, 0x0f7b86,
	0x0f7beb, 0x0f7c51, 0x0f7cb6, 0x0f7d1b,
	0x0f7d7f, 0x0f7de4, 0x0f7e49, 0x0f7ead,
	0x0f7f11, 0x0f7f75, 0x0f7fd9, 0x0f803d,
	0x0f80a0, 0x0f8104, 0x0f8167, 0x0f81ca,
	0x0f822d, 0x0f8290, 0x0f82f3, 0x0f8355,
	0x0f83b7, 0x0f841a, 0x0f847c, 0x0f84de,
	0x0f853f, 0x0f85a1, 0x0f8603, 0x0f8664,
	0x0f86c5, 0x0f8726, 0x0f8787, 0x0f87e8,
	0x0f8848, 0x0f88a9, 0x0f8909, 0x0f8969,
	0x0f89c9, 0x0f8a29, 0x0f8a89, 0x0f8ae8,
	0x0f8b48, 0x0f8ba7, 0x0f8c06, 0x0f8c65,
	0x0f8cc4, 0x0f8d22, 0x0f8d81, 0x0f8ddf,
	0x0f8e3d, 0x0f8e9b, 0x0f8ef9, 0x0f8f57,
	0x0f8fb5, 0x0f9012, 0x0f906f, 0x0f90cc,
	0x0f9129, 0x0f9186, 0x0f91e3, 0x0f9240,
	0x0f929c, 0x0f92f8, 0x0f9354, 0x0f93b0,
	0x0f940c, 0x0f9468, 0x0f94c3, 0x0f951e,
	0x0f957a, 0x0f95d5, 0x0f9630, 0x0f968a,
	0x0f96e5, 0x0f973f, 0x0f979a, 0x0f97f4,
	0x0f984e, 0x0f98a8, 0x0f9901, 0x0f995b,
	0x0f99b4, 0x0f9a0d, 0x0f9a66, 0x0f9abf,
	0x0f9b18, 0x0f9b71, 0x0f9bc9, 0x0f9c22,
	0x0f9c7a, 0x0f9cd2, 0x0f9d2a, 0x0f9d81,
	0x0f9dd9, 0x0f9e30, 0x0f9e88, 0x0f9edf,
	0x0f9f36, 0x0f9f8d, 0x0f9fe3, 0x0fa03a,
	0x0fa090, 0x0fa0e6, 0x0fa13d, 0x0fa192,
	0x0fa1e8, 0x0fa23e, 0x0fa293, 0x0fa2e9,
	0x0fa33e, 0x0fa393, 0x0fa3e8, 0x0fa43c,
	0x0fa491, 0x0fa4e5, 0x0fa53a, 0x0fa58e,
	0x0fa5e2, 0x0fa636, 0x0fa689, 0x0fa6dd,
	0x0fa730, 0x0fa783, 0x0fa7d6, 0x0fa829,
	0x0fa87c, 0x0fa8cf, 0x0fa921, 0x0fa973,
	0x0fa9c6, 0x0faa18, 0x0faa69, 0x0faabb,
	0x0fab0d, 0x0fab5e, 0x0fabaf, 0x0fac00,
	0x0fac51, 0x0faca2, 0x0facf3, 0x0fad43,
	0x0fad94, 0x0fade4, 0x0fae34, 0x0fae84,
	0x0faed3, 0x0faf23, 0x0faf72, 0x0fafc2,
	0x0fb011, 0x0fb060, 0x0fb0af, 0x0fb0fd,
	0x0fb14c, 0x0fb19a, 0x0fb1e9, 0x0fb237,
	0x0fb284, 0x0fb2d2, 0x0fb320, 0x0fb36d,
	0x0fb3bb, 0x0fb408, 0x0fb455, 0x0fb4a2,
	0x0fb4ee, 0x0fb53b, 0x0fb587, 0x0fb5d4,
	0x0fb620, 0x0fb66c, 0x0fb6b8, 0x0fb703,
	0x0fb74f, 0x0fb79a, 0x0fb7e5, 0x0fb830,
	0x0fb87b, 0x0fb8c6, 0x0fb910, 0x0fb95b,
	0x0fb9a5, 0x0fb9ef, 0x0fba39, 0x0fba83,
	0x0fbacd, 0x0fbb16, 0x0fbb60, 0x0fbba9,
	0x0fbbf2, 0x0fbc3b, 0x0fbc84, 0x0fbccc,
	0x0fbd15, 0x0fbd5d, 0x0fbda5, 0x0fbded,
	0x0fbe35, 0x0fbe7d, 0x0fbec4, 0x0fbf0c,
	0x0fbf53, 0x0fbf9a, 0x0fbfe1, 0x0fc028,
	0x0fc06f, 0x0fc0b5, 0x0fc0fb, 0x0fc142,
	0x0fc188, 0x0fc1ce, 0x0fc213, 0x0fc259,
	0x0fc29e, 0x0fc2e4, 0x0fc329, 0x0fc36e,
	0x0fc3b2, 0x0fc3f7, 0x0fc43c, 0x0fc480,
	0x0fc4c4, 0x0fc508, 0x0fc54c, 0x0fc590,
	0x0fc5d4, 0x0fc617, 0x0fc65a, 0x0fc69e,
	0x0fc6e1, 0x0fc723, 0x0fc766, 0x0fc7a9,
	0x0fc7eb, 0x0fc82d, 0x0fc86f, 0x0fc8b1,
	0x0fc8f3, 0x0fc935, 0x0fc976, 0x0fc9b7,
	0x0fc9f9, 0x0fca3a, 0x0fca7b, 0x0fcabb,
	0x0fcafc, 0x0fcb3c, 0x0fcb7d, 0x0fcbbd,
	0x0fcbfd, 0x0fcc3c, 0x0fcc7c, 0x0fccbc,
	0x0fccfb, 0x0fcd3a, 0x0fcd79, 0x0fcdb8,
	0x0fcdf7, 0x0fce35, 0x0fce74, 0x0fceb2,
	0x0fcef0, 0x0fcf2e, 0x0fcf6c, 0x0fcfaa,
	0x0fcfe7, 0x0fd025, 0x0fd062, 0x0fd09f,
	0x0fd0dc, 0x0fd118, 0x0fd155, 0x0fd192,
	0x0fd1ce, 0x0fd20a, 0x0fd246, 0x0fd282,
	0x0fd2be, 0x0fd2f9, 0x0fd334, 0x0fd370,
	0x0fd3ab, 0x0fd3e6, 0x0fd420, 0x0fd45b,
	0x0fd496, 0x0fd4d0, 0x0fd50a, 0x0fd544,
	0x0fd57e, 0x0fd5b8, 0x0fd5f1, 0x0fd62b,
	0x0fd664, 0x0fd69d, 0x0fd6d6, 0x0fd70f,
	0x0fd747, 0x0fd780, 0x0fd7b8, 0x0fd7f0,
	0x0fd828, 0x0fd860, 0x0fd898, 0x0fd8cf,
	0x0fd907, 0x0fd93e, 0x0fd975, 0x0fd9ac,
	0x0fd9e3, 0x0fda1a, 0x0fda50, 0x0fda87,
	0x0fdabd, 0x0fdaf3, 0x0fdb29, 0x0fdb5e,
	0x0fdb94, 0x0fdbc9, 0x0fdbff, 0x0fdc34,
	0x0fdc69, 0x0fdc9e, 0x0fdcd2, 0x0fdd07,
	0x0fdd3b, 0x0fdd6f, 0x0fdda3, 0x0fddd7,
	0x0fde0b, 0x0fde3f, 0x0fde72, 0x0fdea5,
	0x0fded9, 0x0fdf0b, 0x0fdf3e, 0x0fdf71,
	0x0fdfa4, 0x0fdfd6, 0x0fe008, 0x0fe03a,
	0x0fe06c, 0x0fe09e, 0x0fe0cf, 0x0fe101,
	0x0fe132, 0x0fe163, 0x0fe194, 0x0fe1c5,
	0x0fe1f6, 0x0fe226, 0x0fe257, 0x0fe287,
	0x0fe2b7, 0x0fe2e7, 0x0fe317, 0x0fe346,
	0x0fe376, 0x0fe3a5, 0x0fe3d4, 0x0fe403,
	0x0fe432, 0x0fe461, 0x0fe48f, 0x0fe4be,
	0x0fe4ec, 0x0fe51a, 0x0fe548, 0x0fe576,
	0x0fe5a4, 0x0fe5d1, 0x0fe5fe, 0x0fe62b,
	0x0fe658, 0x0fe685, 0x0fe6b2, 0x0fe6df,
	0x0fe70b, 0x0fe737, 0x0fe763, 0x0fe78f,
	0x0fe7bb, 0x0fe7e7, 0x0fe812, 0x0fe83e,
	0x0fe869, 0x0fe894, 0x0fe8bf, 0x0fe8e9,
	0x0fe914, 0x0fe93e, 0x0fe968, 0x0fe993,
	0x0fe9bd, 0x0fe9e6, 0x0fea10, 0x0fea39,
	0x0fea63, 0x0fea8c, 0x0feab5, 0x0feade,
	0x0feb07, 0x0feb2f, 0x0feb58, 0x0feb80,
	0x0feba8, 0x0febd0, 0x0febf8, 0x0fec1f,
	0x0fec47, 0x0fec6e, 0x0fec95, 0x0fecbc,
	0x0fece3, 0x0fed0a, 0x0fed31, 0x0fed57,
	0x0fed7d, 0x0feda3, 0x0fedc9, 0x0fedef,
	0x0fee15, 0x0fee3a, 0x0fee60, 0x0fee85,
	0x0feeaa, 0x0feecf, 0x0feef3, 0x0fef18,
	0x0fef3c, 0x0fef61, 0x0fef85, 0x0fefa9,
	0x0fefcd, 0x0feff0, 0x0ff014, 0x0ff037,
	0x0ff05a, 0x0ff07d, 0x0ff0a0, 0x0ff0c3,
	0x0ff0e5, 0x0ff108, 0x0ff12a, 0x0ff14c,
	0x0ff16e, 0x0ff190, 0x0ff1b2, 0x0ff1d3,
	0x0ff1f5, 0x0ff216, 0x0ff237, 0x0ff258,
	0x0ff278, 0x0ff299, 0x0ff2b9, 0x0ff2da,
	0x0ff2fa, 0x0ff31a, 0x0ff33a, 0x0ff359,
	0x0ff379, 0x0ff398, 0x0ff3b7, 0x0ff3d6,
	0x0ff3f5, 0x0ff414, 0x0ff433, 0x0ff451,
	0x0ff46f, 0x0ff48d, 0x0ff4ab, 0x0ff4c9,
	0x0ff4e7, 0x0ff504, 0x0ff522, 0x0ff53f,
	0x0ff55c, 0x0ff579, 0x0ff596, 0x0ff5b2,
	0x0ff5cf, 0x0ff5eb, 0x0ff607, 0x0ff623,
	0x0ff63f, 0x0ff65a, 0x0ff676, 0x0ff691,
	0x0ff6ac, 0x0ff6c8, 0x0ff6e2, 0x0ff6fd,
	0x0ff718, 0x0ff732, 0x0ff74c, 0x0ff767,
	0x0ff781, 0x0ff79a, 0x0ff7b4, 0x0ff7cd,
	0x0ff7e7, 0x0ff800, 0x0ff819, 0x0ff832,
	0x0ff84b, 0x0ff863, 0x0ff87c, 0x0ff894,
	0x0ff8ac, 0x0ff8c4, 0x0ff8dc, 0x0ff8f4,
	0x0ff90b, 0x0ff922, 0x0ff93a, 0x0ff951,
	0x0ff968, 0x0ff97e, 0x0ff995, 0x0ff9ab,
	0x0ff9c2, 0x0ff9d8, 0x0ff9ee, 0x0ffa03,
	0x0ffa19, 0x0ffa2f, 0x0ffa44, 0x0ffa59,
	0x0ffa6e, 0x0ffa83, 0x0ffa98, 0x0ffaac,
	0x0ffac1, 0x0ffad5, 0x0ffae9, 0x0ffafd,
	0x0ffb11, 0x0ffb25, 0x0ffb38, 0x0ffb4b,
	0x0ffb5f, 0x0ffb72, 0x0ffb85, 0x0ffb97,
	0x0ffbaa, 0x0ffbbc, 0x0ffbcf, 0x0ffbe1,
	0x0ffbf3, 0x0ffc04, 0x0ffc16, 0x0ffc28,
	0x0ffc39, 0x0ffc4a, 0x0ffc5b, 0x0ffc6c,
	0x0ffc7d, 0x0ffc8d, 0x0ffc9e, 0x0ffcae,
	0x0ffcbe, 0x0ffcce, 0x0ffcde, 0x0ffcee,
	0x0ffcfd, 0x0ffd0c, 0x0ffd1c, 0x0ffd2b,
	0x0ffd39, 0x0ffd48, 0x0ffd57, 0x0ffd65,
	0x0ffd73, 0x0ffd82, 0x0ffd90, 0x0ffd9d,
	0x0ffdab, 0x0ffdb8, 0x0ffdc6, 0x0ffdd3,
	0x0ffde0, 0x0ffded, 0x0ffdfa, 0x0ffe06,
	0x0ffe13, 0x0ffe1f, 0x0ffe2b, 0x0ffe37,
	0x0ffe43, 0x0ffe4e, 0x0ffe5a, 0x0ffe65,
	0x0ffe70, 0x0ffe7b, 0x0ffe86, 0x0ffe91,
	0x0ffe9b, 0x0ffea6, 0x0ffeb0, 0x0ffeba,
	0x0ffec4, 0x0ffece, 0x0ffed8, 0x0ffee1,
	0x0ffeea, 0x0ffef4, 0x0ffefd, 0x0fff05,
	0x0fff0e, 0x0fff17, 0x0fff1f, 0x0fff27,
	0x0fff30, 0x0fff37, 0x0fff3f, 0x0fff47,
	0x0fff4e, 0x0fff56, 0x0fff5d, 0x0fff64,
	0x0fff6b, 0x0fff71, 0x0fff78, 0x0fff7e,
	0x0fff85, 0x0fff8b, 0x0fff91, 0x0fff96,
	0x0fff9c, 0x0fffa2, 0x0fffa7, 0x0fffac,
	0x0fffb1, 0x0fffb6, 0x0fffbb, 0x0fffbf,
	0x0fffc4, 0x0fffc8, 0x0fffcc, 0x0fffd0,
	0x0fffd4, 0x0fffd7, 0x0fffdb, 0x0fffde,
	0x0fffe1, 0x0fffe4, 0x0fffe7, 0x0fffea,
	0x0fffec, 0x0fffef, 0x0ffff1, 0x0ffff3,
	0x0ffff5, 0x0ffff7, 0x0ffff8, 0x0ffffa,
	0x0ffffb, 0x0ffffc, 0x0ffffd, 0x0ffffe,
	0x0fffff, 0x0fffff, 0x100000, 0x100000
};

#endif
