// SPDX-License-Identifier: GPL-2.0-only
/*
 *
 * Unisoc sharkle pinctrl driver
 *
 * Copyright (C) 2021 Unisoc, Inc.
 * Author: luting guo<luting.guo@unisoc.com>
 */

#include <linux/module.h>
#include <linux/mod_devicetable.h>
#include <linux/platform_device.h>

#include "pinctrl-sprd.h"

#define PINCTRL_REG_OFFSET		0x20
#define PINCTRL_REG_MISC_OFFSET		0x0420

enum sprd_sharkle_pins {
	/* PIN_CTRL_reg0 */
	SHARKLE_PIN_CTRL_REG0_FUNC_CFG = SPRD_PIN_INFO(0, GLOBAL_CTRL_PIN, 0, 32, 0),

	/* PIN_CTRL_REG1 */
	SHARKLE_PIN_CTRL_REG1_FUNC_CFG = SPRD_PIN_INFO(1, GLOBAL_CTRL_PIN, 0, 32, 1),

	/* PIN_CTRL_REG2 */
	SHARKLE_UART1_USB_PHY_SEL = SPRD_PIN_INFO(2, GLOBAL_CTRL_PIN, 31, 1, 2),
	SHARKLE_SPI0_LCD_DISABLE = SPRD_PIN_INFO(3, GLOBAL_CTRL_PIN, 30, 1, 2),
	SHARKLE_SPI2_LCD_DISABLE = SPRD_PIN_INFO(4, GLOBAL_CTRL_PIN, 29, 1, 2),
	SHARKLE_SIM2_SYS_SEL = SPRD_PIN_INFO(5, GLOBAL_CTRL_PIN, 23, 1, 2),
	SHARKLE_SIM1_SYS_SEL = SPRD_PIN_INFO(6, GLOBAL_CTRL_PIN, 22, 1, 2),
	SHARKLE_SIM0_SYS_SEL = SPRD_PIN_INFO(7, GLOBAL_CTRL_PIN, 21, 1, 2),
	SHARKLE_WCI2_EXWCN_SEL = SPRD_PIN_INFO(8, GLOBAL_CTRL_PIN, 20, 1, 2),
	SHARKLE_AUD_IIS2_SEL = SPRD_PIN_INFO(9, GLOBAL_CTRL_PIN, 19, 1, 2),
	SHARKLE_WCN_IIS_SYS_SEL = SPRD_PIN_INFO(10, GLOBAL_CTRL_PIN, 16, 3, 2),
	SHARKLE_UART2_SYS_SEL = SPRD_PIN_INFO(11, GLOBAL_CTRL_PIN, 10, 3, 2),
	SHARKLE_UART1_SYS_SEL = SPRD_PIN_INFO(12, GLOBAL_CTRL_PIN, 7, 3, 2),
	SHARKLE_UART0_SYS_SEL = SPRD_PIN_INFO(13, GLOBAL_CTRL_PIN, 4, 3, 2),
	SHARKLE_UART20_LOOP_SEL = SPRD_PIN_INFO(14, GLOBAL_CTRL_PIN, 1, 1, 2),
	SHARKLE_UART12_LOOP_SEL = SPRD_PIN_INFO(15, GLOBAL_CTRL_PIN, 0, 1, 2),

	/* PIN_CTRL_REG3 */
	SHARKLE_WDRST_OUT_SEL = SPRD_PIN_INFO(16, GLOBAL_CTRL_PIN, 29, 3, 3),
	SHARKLE_IIS1_SYS_SEL = SPRD_PIN_INFO(17, GLOBAL_CTRL_PIN, 10, 3, 3),

	/* PIN_CTRL_REG4 */
	SHARKLE_PIN_CTRL_REG4_FUNC_CFG = SPRD_PIN_INFO(18, GLOBAL_CTRL_PIN, 0, 32, 4),

	/* PIN_CTRL_REG5 */
	SHARKLE_CARD_DET_SEL = SPRD_PIN_INFO(19, GLOBAL_CTRL_PIN, 17, 3, 5),
	SHARKLE_SIM0_DET_SEL = SPRD_PIN_INFO(20, GLOBAL_CTRL_PIN, 16, 1, 5),
	SHARKLE_AP_SIM0_BD_EB = SPRD_PIN_INFO(21, GLOBAL_CTRL_PIN, 15, 1, 5),
	SHARKLE_AP_EMMC_BD_EB = SPRD_PIN_INFO(22, GLOBAL_CTRL_PIN, 14, 1, 5),
	SHARKLE_AP_SDIO2_BD_EB = SPRD_PIN_INFO(23, GLOBAL_CTRL_PIN, 13, 1, 5),
	SHARKLE_AP_NANDC_BD_EB = SPRD_PIN_INFO(24, GLOBAL_CTRL_PIN, 12, 1, 5),
	SHARKLE_AP_SDIO0_BD_EB = SPRD_PIN_INFO(25, GLOBAL_CTRL_PIN, 11, 1, 5),
	SHARKLE_PUBCP_SIM1_BD_EB = SPRD_PIN_INFO(26, GLOBAL_CTRL_PIN, 9, 1, 5),
	SHARKLE_PUBCP_SIM0_BD_EB = SPRD_PIN_INFO(27, GLOBAL_CTRL_PIN, 8, 1, 5),
	SHARKLE_AP_SIM0_BUA_DET_BYPASS_EB = SPRD_PIN_INFO(28, GLOBAL_CTRL_PIN, 7, 1, 5),
	SHARKLE_PUBCP_SIM1_BUA_DET_BYPASS_EB = SPRD_PIN_INFO(29, GLOBAL_CTRL_PIN, 6, 1, 5),
	SHARKLE_PUBCP_SIM0_BUA_DET_BYPASS_EB = SPRD_PIN_INFO(30, GLOBAL_CTRL_PIN, 5, 1, 5),
	SHARKLE_UART3_SYS_SEL = SPRD_PIN_INFO(31, GLOBAL_CTRL_PIN, 1, 4, 5),
	SHARKLE_TEST_DBG_MODE0 = SPRD_PIN_INFO(32, GLOBAL_CTRL_PIN, 0, 1, 5),

	/* Common pin registers definitions */
	SHARKLE_IIS1DI = SPRD_PIN_INFO(33, COMMON_PIN, 0, 0, 0),
	SHARKLE_IIS1DO = SPRD_PIN_INFO(34, COMMON_PIN, 0, 0, 0),
	SHARKLE_IIS1CLK = SPRD_PIN_INFO(35, COMMON_PIN, 0, 0, 0),
	SHARKLE_IIS1LRCK = SPRD_PIN_INFO(36, COMMON_PIN, 0, 0, 0),
	SHARKLE_SCL2 = SPRD_PIN_INFO(37, COMMON_PIN, 0, 0, 0),
	SHARKLE_SDA2 = SPRD_PIN_INFO(38, COMMON_PIN, 0, 0, 0),
	SHARKLE_CLK_AUX0 = SPRD_PIN_INFO(39, COMMON_PIN, 0, 0, 0),
	SHARKLE_T_DIG = SPRD_PIN_INFO(40, COMMON_PIN, 0, 0, 0),
	SHARKLE_GNSS_LNA_EN = SPRD_PIN_INFO(41, COMMON_PIN, 0, 0, 0),
	SHARKLE_EXTINT0 = SPRD_PIN_INFO(42, COMMON_PIN, 0, 0, 0),
	SHARKLE_EXTINT1 = SPRD_PIN_INFO(43, COMMON_PIN, 0, 0, 0),
	SHARKLE_SCL3 = SPRD_PIN_INFO(44, COMMON_PIN, 0, 0, 0),
	SHARKLE_SDA3 = SPRD_PIN_INFO(45, COMMON_PIN, 0, 0, 0),
	SHARKLE_SCL0 = SPRD_PIN_INFO(46, COMMON_PIN, 0, 0, 0),
	SHARKLE_SDA0 = SPRD_PIN_INFO(47, COMMON_PIN, 0, 0, 0),
	SHARKLE_SCL1 = SPRD_PIN_INFO(48, COMMON_PIN, 0, 0, 0),
	SHARKLE_SDA1 = SPRD_PIN_INFO(49, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMPD2 = SPRD_PIN_INFO(50, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMRST2 = SPRD_PIN_INFO(51, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMMCLK0 = SPRD_PIN_INFO(52, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMRST0 = SPRD_PIN_INFO(53, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMPD0 = SPRD_PIN_INFO(54, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMMCLK1 = SPRD_PIN_INFO(55, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMRST1 = SPRD_PIN_INFO(56, COMMON_PIN, 0, 0, 0),
	SHARKLE_CMPD1 = SPRD_PIN_INFO(57, COMMON_PIN, 0, 0, 0),
	SHARKLE_U0TXD = SPRD_PIN_INFO(58, COMMON_PIN, 0, 0, 0),
	SHARKLE_U0RXD = SPRD_PIN_INFO(59, COMMON_PIN, 0, 0, 0),
	SHARKLE_U0CTS = SPRD_PIN_INFO(60, COMMON_PIN, 0, 0, 0),
	SHARKLE_U0RTS = SPRD_PIN_INFO(61, COMMON_PIN, 0, 0, 0),
	SHARKLE_U1TXD = SPRD_PIN_INFO(62, COMMON_PIN, 0, 0, 0),
	SHARKLE_U1RXD = SPRD_PIN_INFO(63, COMMON_PIN, 0, 0, 0),
	SHARKLE_U2TXD = SPRD_PIN_INFO(64, COMMON_PIN, 0, 0, 0),
	SHARKLE_U2RXD = SPRD_PIN_INFO(65, COMMON_PIN, 0, 0, 0),
	SHARKLE_EXTINT9 = SPRD_PIN_INFO(66, COMMON_PIN, 0, 0, 0),
	SHARKLE_EXTINT10 = SPRD_PIN_INFO(67, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D7 = SPRD_PIN_INFO(68, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D3 = SPRD_PIN_INFO(69, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_CMD = SPRD_PIN_INFO(70, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D2 = SPRD_PIN_INFO(71, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_DUMMY = SPRD_PIN_INFO(72, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D4 = SPRD_PIN_INFO(73, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_CLK = SPRD_PIN_INFO(74, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D0 = SPRD_PIN_INFO(75, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_DS = SPRD_PIN_INFO(76, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_RST = SPRD_PIN_INFO(77, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D6 = SPRD_PIN_INFO(78, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D1 = SPRD_PIN_INFO(79, COMMON_PIN, 0, 0, 0),
	SHARKLE_EMMC_D5 = SPRD_PIN_INFO(80, COMMON_PIN, 0, 0, 0),
	SHARKLE_NF_DATA_2 = SPRD_PIN_INFO(81, COMMON_PIN, 0, 0, 0),
	SHARKLE_NF_DATA_0 = SPRD_PIN_INFO(82, COMMON_PIN, 0, 0, 0),
	SHARKLE_NF_DATA_1 = SPRD_PIN_INFO(83, COMMON_PIN, 0, 0, 0),
	SHARKLE_NF_WEN = SPRD_PIN_INFO(84, COMMON_PIN, 0, 0, 0),
	SHARKLE_NF_CEN0 = SPRD_PIN_INFO(85, COMMON_PIN, 0, 0, 0),
	SHARKLE_LCM_RSTN = SPRD_PIN_INFO(86, COMMON_PIN, 0, 0, 0),
	SHARKLE_LCM_FMARK = SPRD_PIN_INFO(87, COMMON_PIN, 0, 0, 0),
	SHARKLE_CHIP_SLEEP = SPRD_PIN_INFO(88, COMMON_PIN, 0, 0, 0),
	SHARKLE_PTEST = SPRD_PIN_INFO(89, COMMON_PIN, 0, 0, 0),
	SHARKLE_EXT_RST_B = SPRD_PIN_INFO(90, COMMON_PIN, 0, 0, 0),
	SHARKLE_XTL_BUF_EN1 = SPRD_PIN_INFO(91, COMMON_PIN, 0, 0, 0),
	SHARKLE_CLK_32K = SPRD_PIN_INFO(92, COMMON_PIN, 0, 0, 0),
	SHARKLE_AUD_SCLK = SPRD_PIN_INFO(93, COMMON_PIN, 0, 0, 0),
	SHARKLE_AUD_ADD0 = SPRD_PIN_INFO(94, COMMON_PIN, 0, 0, 0),
	SHARKLE_DCDCARM_EN = SPRD_PIN_INFO(95, COMMON_PIN, 0, 0, 0),
	SHARKLE_ANA_INT = SPRD_PIN_INFO(96, COMMON_PIN, 0, 0, 0),
	SHARKLE_AUD_ADSYNC = SPRD_PIN_INFO(97, COMMON_PIN, 0, 0, 0),
	SHARKLE_ADI_SCLK = SPRD_PIN_INFO(98, COMMON_PIN, 0, 0, 0),
	SHARKLE_AUD_DAD1 = SPRD_PIN_INFO(99, COMMON_PIN, 0, 0, 0),
	SHARKLE_AUD_DAD0 = SPRD_PIN_INFO(100, COMMON_PIN, 0, 0, 0),
	SHARKLE_AUD_DASYNC = SPRD_PIN_INFO(101, COMMON_PIN, 0, 0, 0),
	SHARKLE_ADI_SYNC = SPRD_PIN_INFO(102, COMMON_PIN, 0, 0, 0),
	SHARKLE_ADI_D = SPRD_PIN_INFO(103, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_D3 = SPRD_PIN_INFO(104, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_D2 = SPRD_PIN_INFO(105, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_CMD = SPRD_PIN_INFO(106, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_D0 = SPRD_PIN_INFO(107, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_D1 = SPRD_PIN_INFO(108, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_CLK = SPRD_PIN_INFO(109, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD0_DUMMY = SPRD_PIN_INFO(110, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_CLK = SPRD_PIN_INFO(111, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_CMD = SPRD_PIN_INFO(112, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_D0 = SPRD_PIN_INFO(113, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_D1 = SPRD_PIN_INFO(114, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_D2 = SPRD_PIN_INFO(115, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_D3 = SPRD_PIN_INFO(116, COMMON_PIN, 0, 0, 0),
	SHARKLE_SD2_DUMMY = SPRD_PIN_INFO(117, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMCLK0 = SPRD_PIN_INFO(118, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMDAT0 = SPRD_PIN_INFO(119, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMRST0 = SPRD_PIN_INFO(120, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMCLK1 = SPRD_PIN_INFO(121, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMDAT1 = SPRD_PIN_INFO(122, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMRST1 = SPRD_PIN_INFO(123, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMCLK2 = SPRD_PIN_INFO(124, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMDAT2 = SPRD_PIN_INFO(125, COMMON_PIN, 0, 0, 0),
	SHARKLE_SIMRST2 = SPRD_PIN_INFO(126, COMMON_PIN, 0, 0, 0),
	SHARKLE_KEYOUT0 = SPRD_PIN_INFO(127, COMMON_PIN, 0, 0, 0),
	SHARKLE_KEYOUT1 = SPRD_PIN_INFO(128, COMMON_PIN, 0, 0, 0),
	SHARKLE_KEYOUT2 = SPRD_PIN_INFO(129, COMMON_PIN, 0, 0, 0),
	SHARKLE_KEYIN0 = SPRD_PIN_INFO(130, COMMON_PIN, 0, 0, 0),
	SHARKLE_KEYIN1 = SPRD_PIN_INFO(131, COMMON_PIN, 0, 0, 0),
	SHARKLE_KEYIN2 = SPRD_PIN_INFO(132, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFFE0_SCK = SPRD_PIN_INFO(133, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFFE0_SDA = SPRD_PIN_INFO(134, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL0 = SPRD_PIN_INFO(135, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL1 = SPRD_PIN_INFO(136, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL2 = SPRD_PIN_INFO(137, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL3 = SPRD_PIN_INFO(138, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL4 = SPRD_PIN_INFO(139, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL5 = SPRD_PIN_INFO(140, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL6 = SPRD_PIN_INFO(141, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL7 = SPRD_PIN_INFO(142, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL8 = SPRD_PIN_INFO(143, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL9 = SPRD_PIN_INFO(144, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL10 = SPRD_PIN_INFO(145, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL11 = SPRD_PIN_INFO(146, COMMON_PIN, 0, 0, 0),
	SHARKLE_GPIO31 = SPRD_PIN_INFO(147, COMMON_PIN, 0, 0, 0),
	SHARKLE_GPIO32 = SPRD_PIN_INFO(148, COMMON_PIN, 0, 0, 0),
	SHARKLE_GPIO33 = SPRD_PIN_INFO(149, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL16 = SPRD_PIN_INFO(150, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL17 = SPRD_PIN_INFO(151, COMMON_PIN, 0, 0, 0),
	SHARKLE_GPIO9 = SPRD_PIN_INFO(152, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL19 = SPRD_PIN_INFO(153, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFCTL20 = SPRD_PIN_INFO(154, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFSDA0 = SPRD_PIN_INFO(155, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFSCK0 = SPRD_PIN_INFO(156, COMMON_PIN, 0, 0, 0),
	SHARKLE_RFSEN0 = SPRD_PIN_INFO(157, COMMON_PIN, 0, 0, 0),
	SHARKLE_LVDSRF0_ADCON = SPRD_PIN_INFO(158, COMMON_PIN, 0, 0, 0),
	SHARKLE_LVDSRF0_DACON = SPRD_PIN_INFO(159, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI2_CSN = SPRD_PIN_INFO(160, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI2_DO = SPRD_PIN_INFO(161, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI2_DI = SPRD_PIN_INFO(162, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI2_CLK = SPRD_PIN_INFO(163, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI0_CSN = SPRD_PIN_INFO(164, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI0_DO = SPRD_PIN_INFO(165, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI0_DI = SPRD_PIN_INFO(166, COMMON_PIN, 0, 0, 0),
	SHARKLE_SPI0_CLK = SPRD_PIN_INFO(167, COMMON_PIN, 0, 0, 0),
	SHARKLE_TD0_LTE = SPRD_PIN_INFO(168, COMMON_PIN, 0, 0, 0),
	SHARKLE_TDI_LTE = SPRD_PIN_INFO(169, COMMON_PIN, 0, 0, 0),
	SHARKLE_TCK_LTE = SPRD_PIN_INFO(170, COMMON_PIN, 0, 0, 0),
	SHARKLE_TMS_LTE = SPRD_PIN_INFO(171, COMMON_PIN, 0, 0, 0),
	SHARKLE_RTCK_LTE = SPRD_PIN_INFO(172, COMMON_PIN, 0, 0, 0),
	SHARKLE_TCK_ARM = SPRD_PIN_INFO(173, COMMON_PIN, 0, 0, 0),
	SHARKLE_TMS_ARM = SPRD_PIN_INFO(174, COMMON_PIN, 0, 0, 0),

	/* MSIC pin registers definitions */
	SHARKLE_IIS1DI_MSIC = SPRD_PIN_INFO(175, MISC_PIN, 0, 0, 0),
	SHARKLE_IIS1DO_MSIC = SPRD_PIN_INFO(176, MISC_PIN, 0, 0, 0),
	SHARKLE_IIS1CLK_MSIC = SPRD_PIN_INFO(177, MISC_PIN, 0, 0, 0),
	SHARKLE_IIS1LRCK_MSIC = SPRD_PIN_INFO(178, MISC_PIN, 0, 0, 0),
	SHARKLE_SCL2_MSIC = SPRD_PIN_INFO(179, MISC_PIN, 0, 0, 0),
	SHARKLE_SDA2_MSIC = SPRD_PIN_INFO(180, MISC_PIN, 0, 0, 0),
	SHARKLE_CLK_AUX0_MSIC = SPRD_PIN_INFO(181, MISC_PIN, 0, 0, 0),
	SHARKLE_T_DIG_MSIC = SPRD_PIN_INFO(182, MISC_PIN, 0, 0, 0),
	SHARKLE_GNSS_LNA_EN_MSIC = SPRD_PIN_INFO(183, MISC_PIN, 0, 0, 0),
	SHARKLE_EXTINT0_MSIC = SPRD_PIN_INFO(184, MISC_PIN, 0, 0, 0),
	SHARKLE_EXTINT1_MSIC = SPRD_PIN_INFO(185, MISC_PIN, 0, 0, 0),
	SHARKLE_SCL3_MSIC = SPRD_PIN_INFO(186, MISC_PIN, 0, 0, 0),
	SHARKLE_SDA3_MSIC = SPRD_PIN_INFO(187, MISC_PIN, 0, 0, 0),
	SHARKLE_SCL0_MSIC = SPRD_PIN_INFO(188, MISC_PIN, 0, 0, 0),
	SHARKLE_SDA0_MSIC = SPRD_PIN_INFO(189, MISC_PIN, 0, 0, 0),
	SHARKLE_SCL1_MSIC = SPRD_PIN_INFO(190, MISC_PIN, 0, 0, 0),
	SHARKLE_SDA1_MSIC = SPRD_PIN_INFO(191, MISC_PIN, 0, 0, 0),
	SHARKLE_CMPD2_MSIC = SPRD_PIN_INFO(192, MISC_PIN, 0, 0, 0),
	SHARKLE_CMRST2_MSIC = SPRD_PIN_INFO(193, MISC_PIN, 0, 0, 0),
	SHARKLE_CMMCLK0_MSIC = SPRD_PIN_INFO(194, MISC_PIN, 0, 0, 0),
	SHARKLE_CMRST0_MSIC = SPRD_PIN_INFO(195, MISC_PIN, 0, 0, 0),
	SHARKLE_CMPD0_MSIC = SPRD_PIN_INFO(196, MISC_PIN, 0, 0, 0),
	SHARKLE_CMMCLK1_MSIC = SPRD_PIN_INFO(197, MISC_PIN, 0, 0, 0),
	SHARKLE_CMRST1_MSIC = SPRD_PIN_INFO(198, MISC_PIN, 0, 0, 0),
	SHARKLE_CMPD1_MSIC = SPRD_PIN_INFO(199, MISC_PIN, 0, 0, 0),
	SHARKLE_U0TXD_MSIC = SPRD_PIN_INFO(200, MISC_PIN, 0, 0, 0),
	SHARKLE_U0RXD_MSIC = SPRD_PIN_INFO(201, MISC_PIN, 0, 0, 0),
	SHARKLE_U0CTS_MSIC = SPRD_PIN_INFO(202, MISC_PIN, 0, 0, 0),
	SHARKLE_U0RTS_MSIC = SPRD_PIN_INFO(203, MISC_PIN, 0, 0, 0),
	SHARKLE_U1TXD_MSIC = SPRD_PIN_INFO(204, MISC_PIN, 0, 0, 0),
	SHARKLE_U1RXD_MSIC = SPRD_PIN_INFO(205, MISC_PIN, 0, 0, 0),
	SHARKLE_U2TXD_MSIC = SPRD_PIN_INFO(206, MISC_PIN, 0, 0, 0),
	SHARKLE_U2RXD_MSIC = SPRD_PIN_INFO(207, MISC_PIN, 0, 0, 0),
	SHARKLE_EXTINT9_MSIC = SPRD_PIN_INFO(208, MISC_PIN, 0, 0, 0),
	SHARKLE_EXTINT10_MSIC = SPRD_PIN_INFO(209, MISC_PIN, 0, 0, 0),

	SHARKLE_EMMC_D7_MSIC = SPRD_PIN_INFO(210, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D3_MSIC = SPRD_PIN_INFO(211, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_CMD_MSIC = SPRD_PIN_INFO(212, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D2_MSIC = SPRD_PIN_INFO(213, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_DUMMY_MSIC = SPRD_PIN_INFO(214, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D4_MSIC = SPRD_PIN_INFO(215, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_CLK_MSIC = SPRD_PIN_INFO(216, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D0_MSIC = SPRD_PIN_INFO(217, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_DS_MSIC = SPRD_PIN_INFO(218, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_RST_MSIC = SPRD_PIN_INFO(219, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D6_MSIC = SPRD_PIN_INFO(220, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D1_MSIC = SPRD_PIN_INFO(221, MISC_PIN, 0, 0, 0),
	SHARKLE_EMMC_D5_MSIC = SPRD_PIN_INFO(222, MISC_PIN, 0, 0, 0),
	SHARKLE_NF_DATA_2_MSIC = SPRD_PIN_INFO(223, MISC_PIN, 0, 0, 0),
	SHARKLE_NF_DATA_0_MSIC  = SPRD_PIN_INFO(224, MISC_PIN, 0, 0, 0),
	SHARKLE_NF_DATA_1_MSIC = SPRD_PIN_INFO(225, MISC_PIN, 0, 0, 0),
	SHARKLE_NF_WEN_MSIC = SPRD_PIN_INFO(226, MISC_PIN, 0, 0, 0),
	SHARKLE_NF_CEN0_MISC = SPRD_PIN_INFO(227, MISC_PIN, 0, 0, 0),

	SHARKLE_LCM_RSTN_MISC = SPRD_PIN_INFO(228, MISC_PIN, 0, 0, 0),
	SHARKLE_DSI_TE_MISC = SPRD_PIN_INFO(229, MISC_PIN, 0, 0, 0),
	SHARKLE_CHIP_SLEEP_MISC = SPRD_PIN_INFO(230, MISC_PIN, 0, 0, 0),
	SHARKLE_PTEST_MISC = SPRD_PIN_INFO(231, MISC_PIN, 0, 0, 0),
	SHARKLE_EXT_RST_B_MISC = SPRD_PIN_INFO(232, MISC_PIN, 0, 0, 0),
	SHARKLE_XTL_BUF_EN1_MISC = SPRD_PIN_INFO(233, MISC_PIN, 0, 0, 0),
	SHARKLE_CLK_32K_MISC = SPRD_PIN_INFO(234, MISC_PIN, 0, 0, 0),
	SHARKLE_AUD_SCLK_MISC = SPRD_PIN_INFO(235, MISC_PIN, 0, 0, 0),
	SHARKLE_AUD_ADD0_MISC = SPRD_PIN_INFO(236, MISC_PIN, 0, 0, 0),
	SHARKLE_XTL_BUF_EN0_MISC  = SPRD_PIN_INFO(237, MISC_PIN, 0, 0, 0),
	SHARKLE_ANA_INT_MISC = SPRD_PIN_INFO(238, MISC_PIN, 0, 0, 0),
	SHARKLE_AUD_ADSYNC_MISC  = SPRD_PIN_INFO(239, MISC_PIN, 0, 0, 0),
	SHARKLE_ADI_SCLK_MISC = SPRD_PIN_INFO(240, MISC_PIN, 0, 0, 0),
	SHARKLE_AUD_DAD1_MISC  = SPRD_PIN_INFO(241, MISC_PIN, 0, 0, 0),
	SHARKLE_AUD_DAD0_MISC  = SPRD_PIN_INFO(242, MISC_PIN, 0, 0, 0),
	SHARKLE_AUD_DASYNC_MISC  = SPRD_PIN_INFO(243, MISC_PIN, 0, 0, 0),
	SHARKLE_ADI_SYNC_MISC  = SPRD_PIN_INFO(244, MISC_PIN, 0, 0, 0),
	SHARKLE_ADI_D_MISC = SPRD_PIN_INFO(245, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_D3_MISC = SPRD_PIN_INFO(246, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_D2_MISC = SPRD_PIN_INFO(247, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_CMD_MISC = SPRD_PIN_INFO(248, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_D0_MISC = SPRD_PIN_INFO(249, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_D1_MISC = SPRD_PIN_INFO(250, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_CLK0_MISC = SPRD_PIN_INFO(251, MISC_PIN, 0, 0, 0),
	SHARKLE_SD0_DUMMY_MISC = SPRD_PIN_INFO(252, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_CLK_MISC = SPRD_PIN_INFO(253, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_CMD_MISC  = SPRD_PIN_INFO(254, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_D0_MISC = SPRD_PIN_INFO(255, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_D1_MISC = SPRD_PIN_INFO(256, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_D2_MISC = SPRD_PIN_INFO(257, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_D3_MISC = SPRD_PIN_INFO(258, MISC_PIN, 0, 0, 0),
	SHARKLE_SD2_DUMMY_MISC = SPRD_PIN_INFO(259, MISC_PIN, 0, 0, 0),

	SHARKLE_SIMCLK0_MISC = SPRD_PIN_INFO(260, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMDA0_MISC  = SPRD_PIN_INFO(261, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMRST0_MISC  = SPRD_PIN_INFO(262, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMCLK1_MISC = SPRD_PIN_INFO(263, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMDA1_MISC  = SPRD_PIN_INFO(264, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMRST1_MISC  = SPRD_PIN_INFO(265, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMCLK2_MISC  = SPRD_PIN_INFO(266, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMDA2_MISC  = SPRD_PIN_INFO(267, MISC_PIN, 0, 0, 0),
	SHARKLE_SIMRST2_MISC  = SPRD_PIN_INFO(268, MISC_PIN, 0, 0, 0),
	SHARKLE_KEYOUT0_MISC  = SPRD_PIN_INFO(269, MISC_PIN, 0, 0, 0),
	SHARKLE_KEYOUT1_MISC = SPRD_PIN_INFO(270, MISC_PIN, 0, 0, 0),
	SHARKLE_KEYOUT2_MISC = SPRD_PIN_INFO(271, MISC_PIN, 0, 0, 0),
	SHARKLE_KEYIN0_MISC = SPRD_PIN_INFO(272, MISC_PIN, 0, 0, 0),
	SHARKLE_KEYIN1_MISC = SPRD_PIN_INFO(273, MISC_PIN, 0, 0, 0),
	SHARKLE_KEYIN2_MISC = SPRD_PIN_INFO(274, MISC_PIN, 0, 0, 0),
	SHARKLE_RFFE0_SCK_MISC  = SPRD_PIN_INFO(275, MISC_PIN, 0, 0, 0),
	SHARKLE_RFFE0_SDA_MISC  = SPRD_PIN_INFO(276, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL0_MISC = SPRD_PIN_INFO(277, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL1_MISC = SPRD_PIN_INFO(278, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL2_MISC = SPRD_PIN_INFO(279, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL3_MISC = SPRD_PIN_INFO(280, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL4_MISC = SPRD_PIN_INFO(281, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL5_MISC = SPRD_PIN_INFO(282, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL6_MISC = SPRD_PIN_INFO(283, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL7_MISC = SPRD_PIN_INFO(284, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL8_MISC = SPRD_PIN_INFO(285, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL9_MISC = SPRD_PIN_INFO(286, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL10_MISC  = SPRD_PIN_INFO(287, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL11_MISC  = SPRD_PIN_INFO(288, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL12_MISC = SPRD_PIN_INFO(289, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL13_MISC = SPRD_PIN_INFO(290, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL14_MISC  = SPRD_PIN_INFO(291, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL16_MISC  = SPRD_PIN_INFO(292, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL17_MISC = SPRD_PIN_INFO(293, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL18_MISC = SPRD_PIN_INFO(294, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL19_MISC  = SPRD_PIN_INFO(295, MISC_PIN, 0, 0, 0),
	SHARKLE_RFCTL20_MISC  = SPRD_PIN_INFO(296, MISC_PIN, 0, 0, 0),
	SHARKLE_RFSDA0_MISC = SPRD_PIN_INFO(297, MISC_PIN, 0, 0, 0),
	SHARKLE_RFSCK0_MISC = SPRD_PIN_INFO(298, MISC_PIN, 0, 0, 0),
	SHARKLE_RFSEN0_MISC = SPRD_PIN_INFO(299, MISC_PIN, 0, 0, 0),
	SHARKLE_RF_LVDS0_ADC_ON_MISC = SPRD_PIN_INFO(300, MISC_PIN, 0, 0, 0),
	SHARKLE_RF_LVDS0_DAC_ON_MISC = SPRD_PIN_INFO(301, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI2_CSN_MISC = SPRD_PIN_INFO(302, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI2_DO_MISC  = SPRD_PIN_INFO(303, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI2_DI_MISC  = SPRD_PIN_INFO(304, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI2_CLK_MISC = SPRD_PIN_INFO(305, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI0_CSN_MISC = SPRD_PIN_INFO(306, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI0_DO_MISC  = SPRD_PIN_INFO(307, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI0_DI_MISC  = SPRD_PIN_INFO(308, MISC_PIN, 0, 0, 0),
	SHARKLE_SPI0_CLK_MISC = SPRD_PIN_INFO(309, MISC_PIN, 0, 0, 0),
	SHARKLE_DTD0_LTE_MISC  = SPRD_PIN_INFO(310, MISC_PIN, 0, 0, 0),
	SHARKLE_DTDI_LTE_MISC  = SPRD_PIN_INFO(311, MISC_PIN, 0, 0, 0),
	SHARKLE_DTCK_LTE_MISC  = SPRD_PIN_INFO(312, MISC_PIN, 0, 0, 0),
	SHARKLE_DTMS_LTE_MISC  = SPRD_PIN_INFO(313, MISC_PIN, 0, 0, 0),
	SHARKLE_DRTCK_LTE_MISC = SPRD_PIN_INFO(314, MISC_PIN, 0, 0, 0),
	SHARKLE_MTCK_ARM_MISC  = SPRD_PIN_INFO(315, MISC_PIN, 0, 0, 0),
	SHARKLE_MTMS_ARM_MISC  = SPRD_PIN_INFO(316, MISC_PIN, 0, 0, 0),

};

static struct sprd_pins_info sprd_sharkle_pins_info[] = {
	SPRD_PINCTRL_PIN(SHARKLE_PIN_CTRL_REG0_FUNC_CFG),

	SPRD_PINCTRL_PIN(SHARKLE_PIN_CTRL_REG1_FUNC_CFG),

	SPRD_PINCTRL_PIN(SHARKLE_UART1_USB_PHY_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_LCD_DISABLE),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_LCD_DISABLE),
	SPRD_PINCTRL_PIN(SHARKLE_SIM2_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_SIM1_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_SIM0_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_WCI2_EXWCN_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_IIS2_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_WCN_IIS_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_UART2_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_UART1_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_UART0_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_UART20_LOOP_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_UART12_LOOP_SEL),

	SPRD_PINCTRL_PIN(SHARKLE_WDRST_OUT_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1_SYS_SEL),

	SPRD_PINCTRL_PIN(SHARKLE_PIN_CTRL_REG4_FUNC_CFG),

	SPRD_PINCTRL_PIN(SHARKLE_CARD_DET_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_SIM0_DET_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_AP_SIM0_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_AP_EMMC_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_AP_SDIO2_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_AP_NANDC_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_AP_SDIO0_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_PUBCP_SIM1_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_PUBCP_SIM0_BD_EB),
	SPRD_PINCTRL_PIN(SHARKLE_AP_SIM0_BUA_DET_BYPASS_EB),
	SPRD_PINCTRL_PIN(SHARKLE_PUBCP_SIM1_BUA_DET_BYPASS_EB),
	SPRD_PINCTRL_PIN(SHARKLE_PUBCP_SIM0_BUA_DET_BYPASS_EB),
	SPRD_PINCTRL_PIN(SHARKLE_UART3_SYS_SEL),
	SPRD_PINCTRL_PIN(SHARKLE_TEST_DBG_MODE0),

	SPRD_PINCTRL_PIN(SHARKLE_IIS1DI),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1DO),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1CLK),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1LRCK),
	SPRD_PINCTRL_PIN(SHARKLE_SCL2),
	SPRD_PINCTRL_PIN(SHARKLE_SDA2),
	SPRD_PINCTRL_PIN(SHARKLE_CLK_AUX0),
	SPRD_PINCTRL_PIN(SHARKLE_T_DIG),
	SPRD_PINCTRL_PIN(SHARKLE_GNSS_LNA_EN),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT0),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT1),
	SPRD_PINCTRL_PIN(SHARKLE_SCL3),
	SPRD_PINCTRL_PIN(SHARKLE_SDA3),
	SPRD_PINCTRL_PIN(SHARKLE_SCL0),
	SPRD_PINCTRL_PIN(SHARKLE_SDA0),
	SPRD_PINCTRL_PIN(SHARKLE_SCL1),
	SPRD_PINCTRL_PIN(SHARKLE_SDA1),
	SPRD_PINCTRL_PIN(SHARKLE_CMPD2),
	SPRD_PINCTRL_PIN(SHARKLE_CMRST2),
	SPRD_PINCTRL_PIN(SHARKLE_CMMCLK0),
	SPRD_PINCTRL_PIN(SHARKLE_CMRST0),
	SPRD_PINCTRL_PIN(SHARKLE_CMPD0),
	SPRD_PINCTRL_PIN(SHARKLE_CMMCLK1),
	SPRD_PINCTRL_PIN(SHARKLE_CMRST1),
	SPRD_PINCTRL_PIN(SHARKLE_CMPD1),
	SPRD_PINCTRL_PIN(SHARKLE_U0TXD),
	SPRD_PINCTRL_PIN(SHARKLE_U0RXD),
	SPRD_PINCTRL_PIN(SHARKLE_U0CTS),
	SPRD_PINCTRL_PIN(SHARKLE_U0RTS),
	SPRD_PINCTRL_PIN(SHARKLE_U1TXD),
	SPRD_PINCTRL_PIN(SHARKLE_U1RXD),
	SPRD_PINCTRL_PIN(SHARKLE_U2TXD),
	SPRD_PINCTRL_PIN(SHARKLE_U2RXD),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT9),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT10),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D7),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D3),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_CMD),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D2),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_DUMMY),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D4),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_CLK),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D0),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_DS),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_RST),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D6),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D1),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D5),
	SPRD_PINCTRL_PIN(SHARKLE_NF_DATA_2),
	SPRD_PINCTRL_PIN(SHARKLE_NF_DATA_0),
	SPRD_PINCTRL_PIN(SHARKLE_NF_DATA_1),
	SPRD_PINCTRL_PIN(SHARKLE_NF_WEN),
	SPRD_PINCTRL_PIN(SHARKLE_NF_CEN0),
	SPRD_PINCTRL_PIN(SHARKLE_LCM_RSTN),

	SPRD_PINCTRL_PIN(SHARKLE_LCM_FMARK),
	SPRD_PINCTRL_PIN(SHARKLE_CHIP_SLEEP),
	SPRD_PINCTRL_PIN(SHARKLE_PTEST),
	SPRD_PINCTRL_PIN(SHARKLE_EXT_RST_B),
	SPRD_PINCTRL_PIN(SHARKLE_XTL_BUF_EN1),
	SPRD_PINCTRL_PIN(SHARKLE_CLK_32K),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_SCLK),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_ADD0),
	SPRD_PINCTRL_PIN(SHARKLE_DCDCARM_EN),
	SPRD_PINCTRL_PIN(SHARKLE_ANA_INT),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_ADSYNC),
	SPRD_PINCTRL_PIN(SHARKLE_ADI_SCLK),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_DAD1),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_DAD0),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_DASYNC),
	SPRD_PINCTRL_PIN(SHARKLE_ADI_SYNC),
	SPRD_PINCTRL_PIN(SHARKLE_ADI_D),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D3),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D2),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_CMD),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D0),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D1),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_CLK),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_DUMMY),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_CLK),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_CMD),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D0),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D1),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D2),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D3),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_DUMMY),
	SPRD_PINCTRL_PIN(SHARKLE_SIMCLK0),
	SPRD_PINCTRL_PIN(SHARKLE_SIMDAT0),
	SPRD_PINCTRL_PIN(SHARKLE_SIMRST0),
	SPRD_PINCTRL_PIN(SHARKLE_SIMCLK1),
	SPRD_PINCTRL_PIN(SHARKLE_SIMDAT1),
	SPRD_PINCTRL_PIN(SHARKLE_SIMRST1),
	SPRD_PINCTRL_PIN(SHARKLE_SIMCLK2),
	SPRD_PINCTRL_PIN(SHARKLE_SIMDAT2),
	SPRD_PINCTRL_PIN(SHARKLE_SIMRST2),
	SPRD_PINCTRL_PIN(SHARKLE_KEYOUT0),
	SPRD_PINCTRL_PIN(SHARKLE_KEYOUT1),
	SPRD_PINCTRL_PIN(SHARKLE_KEYOUT2),
	SPRD_PINCTRL_PIN(SHARKLE_KEYIN0),
	SPRD_PINCTRL_PIN(SHARKLE_KEYIN1),
	SPRD_PINCTRL_PIN(SHARKLE_KEYIN2),
	SPRD_PINCTRL_PIN(SHARKLE_RFFE0_SCK),
	SPRD_PINCTRL_PIN(SHARKLE_RFFE0_SDA),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL0),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL1),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL2),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL3),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL4),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL5),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL6),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL7),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL8),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL9),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL10),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL11),
	SPRD_PINCTRL_PIN(SHARKLE_GPIO31),
	SPRD_PINCTRL_PIN(SHARKLE_GPIO32),
	SPRD_PINCTRL_PIN(SHARKLE_GPIO33),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL16),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL17),
	SPRD_PINCTRL_PIN(SHARKLE_GPIO9),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL19),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL20),
	SPRD_PINCTRL_PIN(SHARKLE_RFSDA0),
	SPRD_PINCTRL_PIN(SHARKLE_RFSCK0),
	SPRD_PINCTRL_PIN(SHARKLE_RFSEN0),
	SPRD_PINCTRL_PIN(SHARKLE_LVDSRF0_ADCON),
	SPRD_PINCTRL_PIN(SHARKLE_LVDSRF0_DACON),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_CSN),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_DO),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_DI),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_CLK),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_CSN),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_DO),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_DI),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_CLK),
	SPRD_PINCTRL_PIN(SHARKLE_TD0_LTE),
	SPRD_PINCTRL_PIN(SHARKLE_TDI_LTE),
	SPRD_PINCTRL_PIN(SHARKLE_TCK_LTE),
	SPRD_PINCTRL_PIN(SHARKLE_TMS_LTE),
	SPRD_PINCTRL_PIN(SHARKLE_RTCK_LTE),
	SPRD_PINCTRL_PIN(SHARKLE_TCK_ARM),
	SPRD_PINCTRL_PIN(SHARKLE_TMS_ARM),

	SPRD_PINCTRL_PIN(SHARKLE_IIS1DI_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1DO_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1CLK_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_IIS1LRCK_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SCL2_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SDA2_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CLK_AUX0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_T_DIG_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_GNSS_LNA_EN_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SCL3_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SDA3_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SCL0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SDA0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SCL1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_SDA1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMPD2_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMRST2_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMMCLK0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMRST0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMPD0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMMCLK1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMRST1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_CMPD1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U0TXD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U0RXD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U0CTS_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U0RTS_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U1TXD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U1RXD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U2TXD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_U2RXD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT9_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EXTINT10_MSIC),

	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D7_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D3_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_CMD_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D2_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_DUMMY_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D4_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_CLK_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_DS_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_RST_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D6_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_EMMC_D5_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_NF_DATA_2_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_NF_DATA_0_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_NF_DATA_1_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_NF_WEN_MSIC),
	SPRD_PINCTRL_PIN(SHARKLE_NF_CEN0_MISC),

	SPRD_PINCTRL_PIN(SHARKLE_LCM_RSTN_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_DSI_TE_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_CHIP_SLEEP_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_PTEST_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_EXT_RST_B_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_XTL_BUF_EN1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_CLK_32K_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_SCLK_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_ADD0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_XTL_BUF_EN0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_ANA_INT_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_ADSYNC_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_ADI_SCLK_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_DAD1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_DAD0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_AUD_DASYNC_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_ADI_SYNC_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_ADI_D_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D3_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_CMD_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_D1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_CLK0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD0_DUMMY_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_CLK_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_CMD_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_D3_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SD2_DUMMY_MISC),

	SPRD_PINCTRL_PIN(SHARKLE_SIMCLK0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMDA0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMRST0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMCLK1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMDA1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMRST1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMCLK2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMDA2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SIMRST2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_KEYOUT0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_KEYOUT1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_KEYOUT2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_KEYIN0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_KEYIN1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_KEYIN2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFFE0_SCK_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFFE0_SDA_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL1_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL2_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL3_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL4_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL5_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL6_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL7_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL8_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL9_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL10_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL11_MISC),

	SPRD_PINCTRL_PIN(SHARKLE_RFCTL12_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL13_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL14_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL16_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL17_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL18_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL19_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFCTL20_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFSDA0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFSCK0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RFSEN0_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RF_LVDS0_ADC_ON_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_RF_LVDS0_DAC_ON_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_CSN_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_DO_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_DI_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI2_CLK_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_CSN_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_DO_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_DI_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_SPI0_CLK_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_DTD0_LTE_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_DTDI_LTE_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_DTCK_LTE_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_DTMS_LTE_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_DRTCK_LTE_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_MTCK_ARM_MISC),
	SPRD_PINCTRL_PIN(SHARKLE_MTMS_ARM_MISC),
};

static int sprd_pinctrl_probe(struct platform_device *pdev)
{
	return sprd_pinctrl_core_probe(pdev, sprd_sharkle_pins_info,
				       ARRAY_SIZE(sprd_sharkle_pins_info),
				       PINCTRL_REG_OFFSET,
				       PINCTRL_REG_MISC_OFFSET);
}

static const struct of_device_id sprd_pinctrl_of_match[] = {
	{
		.compatible = "sprd,sharkle-pinctrl",
	},
	{ },
};
MODULE_DEVICE_TABLE(of, sprd_pinctrl_of_match);

static struct platform_driver sprd_pinctrl_driver = {
	.driver = {
		.name = "sprd-pinctrl",
		.of_match_table = sprd_pinctrl_of_match,
	},
	.probe = sprd_pinctrl_probe,
	.remove = sprd_pinctrl_remove,
	.shutdown = sprd_pinctrl_shutdown,
};

module_platform_driver(sprd_pinctrl_driver);

MODULE_DESCRIPTION("SPREADTRUM Pin Controller Driver");
MODULE_AUTHOR("luting guo <luting.guo@unisoc.com>");
MODULE_LICENSE("GPL v2");
