// SPDX-License-Identifier: GPL-2.0-only
/*
 * Unisoc qogirn6lite pinctrl driver
 *
 * Copyright (C) 2021 Unisoc, Inc.
 * Author: qiang.lin <qiang.lin@unisoc.com>
 */

#include <linux/module.h>
#include <linux/mod_devicetable.h>
#include <linux/platform_device.h>

#include "pinctrl-sprd.h"

#define	PINCTRL_REG_OFFSET		0x44
#define	PINCTRL_REG_MISC_OFFSET		0x444

enum sprd_qogirn6lite_pins {
	/*sim_matrix_mtx_cfg*/
	QOGIRN6LITE_SIM_INF1_SYS_SEL = SPRD_PIN_INFO(0, GLOBAL_CTRL_PIN, 1, 1, 1),
	QOGIRN6LITE_SIM_INF0_SYS_SEL = SPRD_PIN_INFO(1, GLOBAL_CTRL_PIN, 0, 1, 1),

	/*dmic_matrix_mtx_cfg*/
	QOGIRN6LITE_DMIC_INF2_SYS_SEL = SPRD_PIN_INFO(2, GLOBAL_CTRL_PIN, 2, 1, 2),
	QOGIRN6LITE_DMIC_INF1_SYS_SEL = SPRD_PIN_INFO(3, GLOBAL_CTRL_PIN, 1, 1, 2),
	QOGIRN6LITE_DMIC_INF0_SYS_SEL = SPRD_PIN_INFO(4, GLOBAL_CTRL_PIN, 0, 1, 2),

	/*uart_matrix_mtx_cfg*/
	QOGIRN6LITE_UART_INF6_SYS_SEL = SPRD_PIN_INFO(5, GLOBAL_CTRL_PIN, 28, 4, 3),
	QOGIRN6LITE_UART_INF5_SYS_SEL = SPRD_PIN_INFO(6, GLOBAL_CTRL_PIN, 24, 4, 3),
	QOGIRN6LITE_UART_INF4_SYS_SEL = SPRD_PIN_INFO(7, GLOBAL_CTRL_PIN, 20, 4, 3),
	QOGIRN6LITE_UART_INF3_SYS_SEL = SPRD_PIN_INFO(8, GLOBAL_CTRL_PIN, 16, 4, 3),
	QOGIRN6LITE_UART_INF2_INF3_LOOP = SPRD_PIN_INFO(9, GLOBAL_CTRL_PIN, 15, 1, 3),
	QOGIRN6LITE_UART_INF2_INF4_LOOP = SPRD_PIN_INFO(10, GLOBAL_CTRL_PIN, 14, 1, 3),
	QOGIRN6LITE_UART_INF2_SYS_SEL = SPRD_PIN_INFO(11, GLOBAL_CTRL_PIN, 10, 4, 3),
	QOGIRN6LITE_UART_INF1_INF4_LOOP = SPRD_PIN_INFO(12, GLOBAL_CTRL_PIN, 9, 1, 3),
	QOGIRN6LITE_UART_INF1_INF3_LOOP = SPRD_PIN_INFO(13, GLOBAL_CTRL_PIN, 8, 1, 3),
	QOGIRN6LITE_UART_INF1_SYS_SEL = SPRD_PIN_INFO(14, GLOBAL_CTRL_PIN, 4, 4, 3),
	QOGIRN6LITE_UART_INF0_SYS_SEL = SPRD_PIN_INFO(15, GLOBAL_CTRL_PIN, 0, 4, 3),

	/*uart_matrix_mtx_cfg1*/
	QOGIRN6LITE_UART_INF8_SYS_SEL = SPRD_PIN_INFO(16, GLOBAL_CTRL_PIN, 4, 4, 4),
	QOGIRN6LITE_UART_INF7_SYS_SEL = SPRD_PIN_INFO(17, GLOBAL_CTRL_PIN, 0, 4, 4),

	/*iis_matrix_mtx_cfg*/
	QOGIRN6LITE_IIS_INF4_SYS_SEL = SPRD_PIN_INFO(18, GLOBAL_CTRL_PIN, 23, 5, 5),
	QOGIRN6LITE_IIS_INF3_SYS_SEL = SPRD_PIN_INFO(19, GLOBAL_CTRL_PIN, 18, 5, 5),
	QOGIRN6LITE_IIS_INF2_SYS_SEL = SPRD_PIN_INFO(20, GLOBAL_CTRL_PIN, 13, 5, 5),
	QOGIRN6LITE_IIS_INF1_INF2_LOOP = SPRD_PIN_INFO(21, GLOBAL_CTRL_PIN, 12, 1, 5),
	QOGIRN6LITE_IIS_INF1_SYS_SEL = SPRD_PIN_INFO(22, GLOBAL_CTRL_PIN, 7, 5, 5),
	QOGIRN6LITE_IIS_INF0_INF2_LOOP = SPRD_PIN_INFO(23, GLOBAL_CTRL_PIN, 6, 1, 5),
	QOGIRN6LITE_IIS_INF0_INF1_LOOP = SPRD_PIN_INFO(24, GLOBAL_CTRL_PIN, 5, 1, 5),
	QOGIRN6LITE_IIS_INF0_SYS_SEL = SPRD_PIN_INFO(25, GLOBAL_CTRL_PIN, 0, 5, 5),

	/*iis_matrix_mtx_cfg1*/
	QOGIRN6LITE_IIS_INF6_SYS_SEL = SPRD_PIN_INFO(26, GLOBAL_CTRL_PIN, 5, 1, 6),
	QOGIRN6LITE_IIS_INF5_SYS_SEL = SPRD_PIN_INFO(27, GLOBAL_CTRL_PIN, 0, 5, 6),

	/*spi_matrix_mtx_cfg*/
	QOGIRN6LITE_SPI_INF3_SYS_SEL = SPRD_PIN_INFO(28, GLOBAL_CTRL_PIN, 6, 2, 7),
	QOGIRN6LITE_SPI_INF2_SYS_SEL = SPRD_PIN_INFO(29, GLOBAL_CTRL_PIN, 4, 2, 7),
	QOGIRN6LITE_SPI_INF1_SYS_SEL = SPRD_PIN_INFO(30, GLOBAL_CTRL_PIN, 2, 2, 7),
	QOGIRN6LITE_SPI_INF0_SYS_SEL = SPRD_PIN_INFO(31, GLOBAL_CTRL_PIN, 0, 2, 7),

	/*iic_matrix_mtx_cfg*/
	QOGIRN6LITE_IIC_INF7_SYS_SEL = SPRD_PIN_INFO(32, GLOBAL_CTRL_PIN, 28, 4, 8),
	QOGIRN6LITE_IIC_INF6_SYS_SEL = SPRD_PIN_INFO(33, GLOBAL_CTRL_PIN, 24, 4, 8),
	QOGIRN6LITE_IIC_INF5_SYS_SEL = SPRD_PIN_INFO(34, GLOBAL_CTRL_PIN, 20, 4, 8),
	QOGIRN6LITE_IIC_INF4_SYS_SEL = SPRD_PIN_INFO(35, GLOBAL_CTRL_PIN, 16, 4, 8),
	QOGIRN6LITE_IIC_INF3_SYS_SEL = SPRD_PIN_INFO(36, GLOBAL_CTRL_PIN, 12, 4, 8),
	QOGIRN6LITE_IIC_INF2_SYS_SEL = SPRD_PIN_INFO(37, GLOBAL_CTRL_PIN, 8, 4, 8),
	QOGIRN6LITE_IIC_INF1_SYS_SEL = SPRD_PIN_INFO(38, GLOBAL_CTRL_PIN, 4, 4, 8),
	QOGIRN6LITE_IIC_INF0_SYS_SEL = SPRD_PIN_INFO(39, GLOBAL_CTRL_PIN, 0, 4, 8),

	/*iic_matrix_mtx_cfg1*/
	QOGIRN6LITE_IIC_INF9_SYS_SEL = SPRD_PIN_INFO(40, GLOBAL_CTRL_PIN, 4, 4, 9),
	QOGIRN6LITE_IIC_INF8_SYS_SEL = SPRD_PIN_INFO(41, GLOBAL_CTRL_PIN, 0, 4, 9),

	/*hot_plug_matrix_mtx_cfg*/
	QOGIRN6LITE_HOT_PLUG_DET_INF2_SYS_SEL = SPRD_PIN_INFO(42, GLOBAL_CTRL_PIN, 4, 2, 10),
	QOGIRN6LITE_HOT_PLUG_DET_INF1_SYS_SEL = SPRD_PIN_INFO(43, GLOBAL_CTRL_PIN, 2, 2, 10),
	QOGIRN6LITE_HOT_PLUG_DET_INF0_SYS_SEL = SPRD_PIN_INFO(44, GLOBAL_CTRL_PIN, 0, 2, 10),

	/*PIN_CTRL_REG0*/
	QOGIRN6LITE_PIN_CTRL_REG0_FUNC_CFG = SPRD_PIN_INFO(45, GLOBAL_CTRL_PIN, 0, 1, 11),

	/*PIN_CTRL_REG1*/
	QOGIRN6LITE_PIN_CTRL_REG1_FUNC_CFG = SPRD_PIN_INFO(46, GLOBAL_CTRL_PIN, 0, 0, 12),

	/*PIN_CTRL_REG2*/
	QOGIRN6LITE_UART_USB_PHY_SEL = SPRD_PIN_INFO(47, GLOBAL_CTRL_PIN, 29, 3, 13),


	/*PIN_CTRL_REG3*/
	QOGIRN6LITE_CH_EIC_DPAD3 = SPRD_PIN_INFO(48, GLOBAL_CTRL_PIN, 24, 8, 14),
	QOGIRN6LITE_CH_EIC_DPAD2 = SPRD_PIN_INFO(49, GLOBAL_CTRL_PIN, 16, 8, 14),
	QOGIRN6LITE_CH_EIC_DPAD1 = SPRD_PIN_INFO(50, GLOBAL_CTRL_PIN, 8, 8, 14),
	QOGIRN6LITE_CH_EIC_DPAD0 = SPRD_PIN_INFO(51, GLOBAL_CTRL_PIN, 0, 8, 14),

	/*PIN_CTRL_REG4*/
	QOGIRN6LITE_CH_EIC_DPAD7 = SPRD_PIN_INFO(52, GLOBAL_CTRL_PIN, 24, 8, 15),
	QOGIRN6LITE_CH_EIC_DPAD6 = SPRD_PIN_INFO(53, GLOBAL_CTRL_PIN, 16, 8, 15),
	QOGIRN6LITE_CH_EIC_DPAD5 = SPRD_PIN_INFO(54, GLOBAL_CTRL_PIN, 8, 8, 15),
	QOGIRN6LITE_CH_EIC_DPAD4 = SPRD_PIN_INFO(55, GLOBAL_CTRL_PIN, 0, 8, 15),

	/*PIN_CTRL_REG5*/
	QOGIRN6LITE_CORE_OUT_WDGRST_SOUR_SEL = SPRD_PIN_INFO(56, GLOBAL_CTRL_PIN, 28, 4, 16),
	QOGIRN6LITE_VBC_IIS_INF_SYS_SEL = SPRD_PIN_INFO(57, GLOBAL_CTRL_PIN, 20, 1, 16),
	QOGIRN6LITE_VAD_DIN_SEL = SPRD_PIN_INFO(58, GLOBAL_CTRL_PIN, 19, 1, 16),
	QOGIRN6LITE_TF_DET_SW = SPRD_PIN_INFO(59, GLOBAL_CTRL_PIN, 10, 1, 16),
	QOGIRN6LITE_CORE_IN_TF_DET_MUX = SPRD_PIN_INFO(60, GLOBAL_CTRL_PIN, 8, 2, 16),
	QOGIRN6LITE_SIM1_DET_SW = SPRD_PIN_INFO(61, GLOBAL_CTRL_PIN, 6, 1, 16),
	QOGIRN6LITE_CORE_IN_SIM1_DET_MUX = SPRD_PIN_INFO(62, GLOBAL_CTRL_PIN, 4, 2, 16),
	QOGIRN6LITE_SIM0_DET_SW = SPRD_PIN_INFO(63, GLOBAL_CTRL_PIN, 2, 1, 16),
	QOGIRN6LITE_CORE_IN_SIM0_DET_MUX = SPRD_PIN_INFO(64, GLOBAL_CTRL_PIN, 0, 2, 16),

	/* Common pin registers definitions */
	QOGIRN6LITE_SD1_CMD = SPRD_PIN_INFO(65, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D0 = SPRD_PIN_INFO(66, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D1 = SPRD_PIN_INFO(67, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_CLK = SPRD_PIN_INFO(68, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D2 = SPRD_PIN_INFO(69, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D3 = SPRD_PIN_INFO(70, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_RST = SPRD_PIN_INFO(71, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_CMD = SPRD_PIN_INFO(72, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D0 = SPRD_PIN_INFO(73, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D3 = SPRD_PIN_INFO(74, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D2 = SPRD_PIN_INFO(75, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D5 = SPRD_PIN_INFO(76, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_CLK = SPRD_PIN_INFO(77, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_DS = SPRD_PIN_INFO(78, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D1 = SPRD_PIN_INFO(79, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D4 = SPRD_PIN_INFO(80, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D6 = SPRD_PIN_INFO(81, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D7 = SPRD_PIN_INFO(82, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DNS_D0 = SPRD_PIN_INFO(83, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DNS_D1 = SPRD_PIN_INFO(84, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_LCM0_RSTN = SPRD_PIN_INFO(85, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DSI0_TE = SPRD_PIN_INFO(86, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_PWMA = SPRD_PIN_INFO(87, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT0 = SPRD_PIN_INFO(88, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT1 = SPRD_PIN_INFO(89, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA3 = SPRD_PIN_INFO(90, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL3 = SPRD_PIN_INFO(91, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DCDC_ARM1_EN = SPRD_PIN_INFO(92, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_PTEST = SPRD_PIN_INFO(93, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EXT_RST_B = SPRD_PIN_INFO(94, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_ADI_SCLK = SPRD_PIN_INFO(95, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_32K = SPRD_PIN_INFO(96, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_ANA_INT1 = SPRD_PIN_INFO(97, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_ANA_INT0 = SPRD_PIN_INFO(98, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_ANA_INT2 = SPRD_PIN_INFO(99, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_ADI_D = SPRD_PIN_INFO(100, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_SCLK = SPRD_PIN_INFO(101, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DCDC_ARM0_EN = SPRD_PIN_INFO(102, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DCDC_ARM2_EN = SPRD_PIN_INFO(103, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_ADD0 = SPRD_PIN_INFO(104, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_ADD1 = SPRD_PIN_INFO(105, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_XTL_EN0 = SPRD_PIN_INFO(106, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_ADSYNC = SPRD_PIN_INFO(107, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DAD0 = SPRD_PIN_INFO(108, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_XTL_EN1 = SPRD_PIN_INFO(109, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_XTL_EN2 = SPRD_PIN_INFO(110, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DASYNC = SPRD_PIN_INFO(111, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DAD1 = SPRD_PIN_INFO(112, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CHIP_SLEEP = SPRD_PIN_INFO(113, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CHG_TYPE = SPRD_PIN_INFO(114, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMCLK0= SPRD_PIN_INFO(115, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMDA0 = SPRD_PIN_INFO(116, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMRST0 = SPRD_PIN_INFO(117, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMCLK1 = SPRD_PIN_INFO(118, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMDA1 = SPRD_PIN_INFO(119, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMRST1 = SPRD_PIN_INFO(120, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_CMD = SPRD_PIN_INFO(121, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_0 = SPRD_PIN_INFO(122, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_1 = SPRD_PIN_INFO(123, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_CLK = SPRD_PIN_INFO(124, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_2 = SPRD_PIN_INFO(125, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_3 = SPRD_PIN_INFO(126, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_CLK = SPRD_PIN_INFO(127, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D1 = SPRD_PIN_INFO(128, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_CMD = SPRD_PIN_INFO(129, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D0 = SPRD_PIN_INFO(130, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D2 = SPRD_PIN_INFO(131, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D3 = SPRD_PIN_INFO(132, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIM_DET0 = SPRD_PIN_INFO(133, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SIM_DET1 = SPRD_PIN_INFO(134, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_TF_DET = SPRD_PIN_INFO(135, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_BAT_DET = SPRD_PIN_INFO(136, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL4 = SPRD_PIN_INFO(137, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA4 = SPRD_PIN_INFO(138, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_AUX1 = SPRD_PIN_INFO(139, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1DI = SPRD_PIN_INFO(140, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1DO = SPRD_PIN_INFO(141, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1CLK = SPRD_PIN_INFO(142, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1LRCK = SPRD_PIN_INFO(143, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3DI = SPRD_PIN_INFO(144, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3DO = SPRD_PIN_INFO(145, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3LRCK = SPRD_PIN_INFO(146, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3CLK = SPRD_PIN_INFO(147, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_AUX2 = SPRD_PIN_INFO(148, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_0 = SPRD_PIN_INFO(149, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_1 = SPRD_PIN_INFO(150, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_2 = SPRD_PIN_INFO(151, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_3 = SPRD_PIN_INFO(152, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_4 = SPRD_PIN_INFO(153, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_5 = SPRD_PIN_INFO(154, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_6 = SPRD_PIN_INFO(155, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_7 = SPRD_PIN_INFO(156, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_8 = SPRD_PIN_INFO(157, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_9 = SPRD_PIN_INFO(158, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_10 = SPRD_PIN_INFO(159, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_11 = SPRD_PIN_INFO(160, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_12 = SPRD_PIN_INFO(161, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_13 = SPRD_PIN_INFO(162, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_14 = SPRD_PIN_INFO(163, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_15 = SPRD_PIN_INFO(164, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE0_SCK = SPRD_PIN_INFO(165, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE0_SDA = SPRD_PIN_INFO(166, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE1_SCK = SPRD_PIN_INFO(167, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE1_SDA = SPRD_PIN_INFO(168, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE2_SCK = SPRD_PIN_INFO(169, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE2_SDA = SPRD_PIN_INFO(170, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE3_SCK = SPRD_PIN_INFO(171, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE3_SDA = SPRD_PIN_INFO(172, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE4_SCK = SPRD_PIN_INFO(173, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE4_SDA = SPRD_PIN_INFO(174, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE5_SCK = SPRD_PIN_INFO(175, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE5_SDA = SPRD_PIN_INFO(176, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE6_SCK = SPRD_PIN_INFO(177, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE6_SDA = SPRD_PIN_INFO(178, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE7_SCK = SPRD_PIN_INFO(179, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE7_SDA = SPRD_PIN_INFO(180, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC0_ON = SPRD_PIN_INFO(181, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC1_ON = SPRD_PIN_INFO(182, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC2_ON = SPRD_PIN_INFO(183, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC3_ON = SPRD_PIN_INFO(184, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA0 = SPRD_PIN_INFO(185, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA1 = SPRD_PIN_INFO(186, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA2 = SPRD_PIN_INFO(187, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA3 = SPRD_PIN_INFO(188, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SCK = SPRD_PIN_INFO(189, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SEN = SPRD_PIN_INFO(190, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL6 = SPRD_PIN_INFO(191, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA6 = SPRD_PIN_INFO(192, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TDO = SPRD_PIN_INFO(193, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TDI = SPRD_PIN_INFO(194, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TMS = SPRD_PIN_INFO(195, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TCK = SPRD_PIN_INFO(196, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_RTCK = SPRD_PIN_INFO(197, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_CLK2 = SPRD_PIN_INFO(198, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_DATA2 = SPRD_PIN_INFO(199, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_CLK0 = SPRD_PIN_INFO(200, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_DATA0 = SPRD_PIN_INFO(201, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_CLK1 = SPRD_PIN_INFO(202, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_DATA1 = SPRD_PIN_INFO(203, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U2TXD = SPRD_PIN_INFO(204, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U2RXD = SPRD_PIN_INFO(205, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U1TXD = SPRD_PIN_INFO(206, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U1RXD = SPRD_PIN_INFO(207, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U7TXD = SPRD_PIN_INFO(208, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U7RXD = SPRD_PIN_INFO(209, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U6TXD = SPRD_PIN_INFO(210, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U6RXD = SPRD_PIN_INFO(211, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_MTCK_ARM = SPRD_PIN_INFO(212, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_MTMS_ARM = SPRD_PIN_INFO(213, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TDO = SPRD_PIN_INFO(214, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_RTCK = SPRD_PIN_INFO(215, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TDI = SPRD_PIN_INFO(216, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TCK = SPRD_PIN_INFO(217, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TMS = SPRD_PIN_INFO(218, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK0 = SPRD_PIN_INFO(219, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK1 = SPRD_PIN_INFO(220, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK2 = SPRD_PIN_INFO(221, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK3 = SPRD_PIN_INFO(222, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST0 = SPRD_PIN_INFO(223, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST1 = SPRD_PIN_INFO(224, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST2 = SPRD_PIN_INFO(225, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST3 = SPRD_PIN_INFO(226, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST4 = SPRD_PIN_INFO(227, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST5 = SPRD_PIN_INFO(228, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD0 = SPRD_PIN_INFO(229, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD1 = SPRD_PIN_INFO(230, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD2 = SPRD_PIN_INFO(231, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD3 = SPRD_PIN_INFO(232, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD4 = SPRD_PIN_INFO(233, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD5 = SPRD_PIN_INFO(234, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL0 = SPRD_PIN_INFO(235, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA0 = SPRD_PIN_INFO(236, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL1 = SPRD_PIN_INFO(237, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA1 = SPRD_PIN_INFO(238, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL8 = SPRD_PIN_INFO(239, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA8 = SPRD_PIN_INFO(240, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL9 = SPRD_PIN_INFO(241, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA9 = SPRD_PIN_INFO(242, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_CSN = SPRD_PIN_INFO(243, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_DO = SPRD_PIN_INFO(244, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_DI = SPRD_PIN_INFO(245, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_CLK = SPRD_PIN_INFO(246, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_CSN = SPRD_PIN_INFO(247, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_CLK = SPRD_PIN_INFO(248, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_DI = SPRD_PIN_INFO(249, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_DO = SPRD_PIN_INFO(250, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_CSN = SPRD_PIN_INFO(251, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_DO = SPRD_PIN_INFO(252, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_DI = SPRD_PIN_INFO(253, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_CLK = SPRD_PIN_INFO(254, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL2 = SPRD_PIN_INFO(255, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA2 = SPRD_PIN_INFO(256, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYOUT1 = SPRD_PIN_INFO(257, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYOUT0 = SPRD_PIN_INFO(258, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYOUT2 = SPRD_PIN_INFO(259, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT9 = SPRD_PIN_INFO(260, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT10 = SPRD_PIN_INFO(261, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYIN0 = SPRD_PIN_INFO(262, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYIN1 = SPRD_PIN_INFO(263, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYIN2 = SPRD_PIN_INFO(264, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U5TXD = SPRD_PIN_INFO(265, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U5RXD = SPRD_PIN_INFO(266, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_AUX0 = SPRD_PIN_INFO(267, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U0TXD = SPRD_PIN_INFO(268, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U0RXD = SPRD_PIN_INFO(269, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U0CTS = SPRD_PIN_INFO(270, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U0RTS = SPRD_PIN_INFO(271, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0DI = SPRD_PIN_INFO(272, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0DO = SPRD_PIN_INFO(273, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0CLK = SPRD_PIN_INFO(274, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0LRCK = SPRD_PIN_INFO(275, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_PWMC = SPRD_PIN_INFO(276, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4DO = SPRD_PIN_INFO(277, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4DI = SPRD_PIN_INFO(278, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4CLK = SPRD_PIN_INFO(279, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4LRCK = SPRD_PIN_INFO(280, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U4TXD = SPRD_PIN_INFO(281, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U4RXD = SPRD_PIN_INFO(282, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U4CTS = SPRD_PIN_INFO(283, COMMON_PIN, 0, 0, 0),
	QOGIRN6LITE_U4RTS = SPRD_PIN_INFO(284, COMMON_PIN, 0, 0, 0),

	/* MSIC pin registers definitions */
	QOGIRN6LITE_SD1_CMD_MISC = SPRD_PIN_INFO(285, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D0_MISC = SPRD_PIN_INFO(286, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D1_MISC = SPRD_PIN_INFO(287, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_CLK_MISC = SPRD_PIN_INFO(288, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D2_MISC = SPRD_PIN_INFO(289, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD1_D3_MISC = SPRD_PIN_INFO(290, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_RST_MISC = SPRD_PIN_INFO(291, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_CMD_MISC = SPRD_PIN_INFO(292, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D0_MISC = SPRD_PIN_INFO(293, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D3_MISC = SPRD_PIN_INFO(294, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D2_MISC = SPRD_PIN_INFO(295, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D5_MISC = SPRD_PIN_INFO(296, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_CLK_MISC = SPRD_PIN_INFO(297, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_DS_MISC = SPRD_PIN_INFO(298, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D1_MISC = SPRD_PIN_INFO(299, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D4_MISC = SPRD_PIN_INFO(300, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D6_MISC = SPRD_PIN_INFO(301, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EMMC_D7_MISC = SPRD_PIN_INFO(302, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DNS_D0_MISC = SPRD_PIN_INFO(303, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DNS_D1_MISC = SPRD_PIN_INFO(304, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_LCM0_RSTN_MISC = SPRD_PIN_INFO(305, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DSI0_TE_MISC = SPRD_PIN_INFO(306, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_PWMA_MISC = SPRD_PIN_INFO(307, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT0_MISC = SPRD_PIN_INFO(308, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT1_MISC = SPRD_PIN_INFO(309, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA3_MISC = SPRD_PIN_INFO(310, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL3_MISC = SPRD_PIN_INFO(311, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DCDC_ARM1_EN_MISC = SPRD_PIN_INFO(312, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_PTEST_MISC = SPRD_PIN_INFO(313, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EXT_RST_B_MISC = SPRD_PIN_INFO(314, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_ADI_SCLK_MISC = SPRD_PIN_INFO(315, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_32K_MISC = SPRD_PIN_INFO(316, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_ANA_INT1_MISC = SPRD_PIN_INFO(317, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_ANA_INT0_MISC = SPRD_PIN_INFO(318, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_ANA_INT2_MISC = SPRD_PIN_INFO(319, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_ADI_D_MISC = SPRD_PIN_INFO(320, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_SCLK_MISC = SPRD_PIN_INFO(321, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DCDC_ARM0_EN_MISC = SPRD_PIN_INFO(322, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DCDC_ARM2_EN_MISC = SPRD_PIN_INFO(323, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_ADD0_MISC = SPRD_PIN_INFO(324, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_ADD1_MISC = SPRD_PIN_INFO(325, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_XTL_EN0_MISC = SPRD_PIN_INFO(326, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_ADSYNC_MISC = SPRD_PIN_INFO(327, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DAD0_MISC = SPRD_PIN_INFO(328, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_XTL_EN1_MISC = SPRD_PIN_INFO(329, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_XTL_EN2_MISC = SPRD_PIN_INFO(330, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DASYNC_MISC = SPRD_PIN_INFO(331, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DAD1_MISC = SPRD_PIN_INFO(332, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CHIP_SLEEP_MISC = SPRD_PIN_INFO(333, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CHG_TYPE_MISC = SPRD_PIN_INFO(334, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMCLK0_MISC = SPRD_PIN_INFO(335, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMDA0_MISC = SPRD_PIN_INFO(336, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMRST0_MISC = SPRD_PIN_INFO(337, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMCLK1_MISC = SPRD_PIN_INFO(338, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMDA1_MISC = SPRD_PIN_INFO(339, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIMRST1_MISC = SPRD_PIN_INFO(340, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_CMD_MISC = SPRD_PIN_INFO(341, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_0_MISC = SPRD_PIN_INFO(342, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_1_MISC = SPRD_PIN_INFO(343, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_CLK_MISC = SPRD_PIN_INFO(344, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_2_MISC = SPRD_PIN_INFO(345, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD0_D_3_MISC = SPRD_PIN_INFO(346, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_CLK_MISC = SPRD_PIN_INFO(347, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D1_MISC = SPRD_PIN_INFO(348, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_CMD_MISC = SPRD_PIN_INFO(349, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D0_MISC = SPRD_PIN_INFO(350, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D2_MISC = SPRD_PIN_INFO(351, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SD2_D3_MISC = SPRD_PIN_INFO(352, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIM_DET0_MISC = SPRD_PIN_INFO(353, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SIM_DET1_MISC = SPRD_PIN_INFO(354, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_TF_DET_MISC = SPRD_PIN_INFO(355, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_BAT_DET_MISC = SPRD_PIN_INFO(356, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL4_MISC = SPRD_PIN_INFO(357, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA4_MISC = SPRD_PIN_INFO(358, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_AUX1_MISC = SPRD_PIN_INFO(359, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1DI_MISC = SPRD_PIN_INFO(360, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1DO_MISC = SPRD_PIN_INFO(361, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1CLK_MISC = SPRD_PIN_INFO(362, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS1LRCK_MISC = SPRD_PIN_INFO(363, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3DI_MISC = SPRD_PIN_INFO(364, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3DO_MISC = SPRD_PIN_INFO(365, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3LRCK_MISC = SPRD_PIN_INFO(366, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS3CLK_MISC = SPRD_PIN_INFO(367, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_AUX2_MISC = SPRD_PIN_INFO(368, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_0_MISC = SPRD_PIN_INFO(369, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_1_MISC = SPRD_PIN_INFO(370, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_2_MISC = SPRD_PIN_INFO(371, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_3_MISC = SPRD_PIN_INFO(372, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_4_MISC = SPRD_PIN_INFO(373, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_5_MISC = SPRD_PIN_INFO(374, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_6_MISC = SPRD_PIN_INFO(375, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_7_MISC = SPRD_PIN_INFO(376, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_8_MISC = SPRD_PIN_INFO(377, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_9_MISC = SPRD_PIN_INFO(378, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_10_MISC = SPRD_PIN_INFO(379, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_11_MISC = SPRD_PIN_INFO(380, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_12_MISC = SPRD_PIN_INFO(381, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_13_MISC = SPRD_PIN_INFO(382, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_14_MISC = SPRD_PIN_INFO(383, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFCTL_15_MISC = SPRD_PIN_INFO(384, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE0_SCK_MISC = SPRD_PIN_INFO(385, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE0_SDA_MISC = SPRD_PIN_INFO(386, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE1_SCK_MISC = SPRD_PIN_INFO(387, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE1_SDA_MISC = SPRD_PIN_INFO(388, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE2_SCK_MISC = SPRD_PIN_INFO(389, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE2_SDA_MISC = SPRD_PIN_INFO(390, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE3_SCK_MISC = SPRD_PIN_INFO(391, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE3_SDA_MISC = SPRD_PIN_INFO(392, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE4_SCK_MISC = SPRD_PIN_INFO(393, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE4_SDA_MISC = SPRD_PIN_INFO(394, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE5_SCK_MISC = SPRD_PIN_INFO(395, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE5_SDA_MISC = SPRD_PIN_INFO(396, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE6_SCK_MISC = SPRD_PIN_INFO(397, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE6_SDA_MISC = SPRD_PIN_INFO(398, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE7_SCK_MISC = SPRD_PIN_INFO(399, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFFE7_SDA_MISC = SPRD_PIN_INFO(400, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC0_ON_MISC = SPRD_PIN_INFO(401, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC1_ON_MISC = SPRD_PIN_INFO(402, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC2_ON_MISC = SPRD_PIN_INFO(403, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_LVDSRF_ADDAC3_ON_MISC = SPRD_PIN_INFO(404, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA0_MISC = SPRD_PIN_INFO(405, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA1_MISC = SPRD_PIN_INFO(406, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA2_MISC = SPRD_PIN_INFO(407, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SDA3_MISC = SPRD_PIN_INFO(408, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SCK_MISC = SPRD_PIN_INFO(409, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_RFSPI_SEN_MISC = SPRD_PIN_INFO(410, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL6_MISC = SPRD_PIN_INFO(411, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA6_MISC = SPRD_PIN_INFO(412, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TDO_MISC = SPRD_PIN_INFO(413, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TDI_MISC = SPRD_PIN_INFO(414, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TMS_MISC = SPRD_PIN_INFO(415, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_TCK_MISC = SPRD_PIN_INFO(416, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_VDSP_RTCK_MISC = SPRD_PIN_INFO(417, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_CLK2_MISC = SPRD_PIN_INFO(418, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_DATA2_MISC = SPRD_PIN_INFO(419, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_CLK0_MISC = SPRD_PIN_INFO(420, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_DATA0_MISC = SPRD_PIN_INFO(421, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_CLK1_MISC = SPRD_PIN_INFO(422, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_DMIC_DATA1_MISC = SPRD_PIN_INFO(423, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U2TXD_MISC = SPRD_PIN_INFO(424, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U2RXD_MISC = SPRD_PIN_INFO(425, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U1TXD_MISC = SPRD_PIN_INFO(426, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U1RXD_MISC = SPRD_PIN_INFO(427, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U7TXD_MISC = SPRD_PIN_INFO(428, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U7RXD_MISC = SPRD_PIN_INFO(429, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U6TXD_MISC = SPRD_PIN_INFO(430, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U6RXD_MISC = SPRD_PIN_INFO(431, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_MTCK_ARM_MISC = SPRD_PIN_INFO(432, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_MTMS_ARM_MISC = SPRD_PIN_INFO(433, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TDO_MISC = SPRD_PIN_INFO(434, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_RTCK_MISC = SPRD_PIN_INFO(435, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TDI_MISC = SPRD_PIN_INFO(436, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TCK_MISC = SPRD_PIN_INFO(437, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_AUD_DSP_TMS_MISC = SPRD_PIN_INFO(438, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK0_MISC = SPRD_PIN_INFO(439, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK1_MISC = SPRD_PIN_INFO(440, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK2_MISC = SPRD_PIN_INFO(441, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMMCLK3_MISC = SPRD_PIN_INFO(442, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST0_MISC = SPRD_PIN_INFO(443, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST1_MISC = SPRD_PIN_INFO(444, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST2_MISC = SPRD_PIN_INFO(445, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST3_MISC = SPRD_PIN_INFO(446, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST4_MISC = SPRD_PIN_INFO(447, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMRST5_MISC = SPRD_PIN_INFO(448, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD0_MISC = SPRD_PIN_INFO(449, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD1_MISC = SPRD_PIN_INFO(450, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD2_MISC = SPRD_PIN_INFO(451, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD3_MISC = SPRD_PIN_INFO(452, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD4_MISC = SPRD_PIN_INFO(453, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CMPD5_MISC = SPRD_PIN_INFO(454, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL0_MISC = SPRD_PIN_INFO(455, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA0_MISC = SPRD_PIN_INFO(456, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL1_MISC = SPRD_PIN_INFO(457, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA1_MISC = SPRD_PIN_INFO(458, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL8_MISC = SPRD_PIN_INFO(459, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA8_MISC = SPRD_PIN_INFO(460, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL9_MISC = SPRD_PIN_INFO(461, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA9_MISC = SPRD_PIN_INFO(462, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_CSN_MISC = SPRD_PIN_INFO(463, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_DO_MISC = SPRD_PIN_INFO(464, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_DI_MISC = SPRD_PIN_INFO(465, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI2_CLK_MISC = SPRD_PIN_INFO(466, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_CSN_MISC = SPRD_PIN_INFO(467, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_CLK_MISC = SPRD_PIN_INFO(468, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_DI_MISC = SPRD_PIN_INFO(469, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI3_DO_MISC = SPRD_PIN_INFO(470, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_CSN_MISC = SPRD_PIN_INFO(471, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_DO_MISC = SPRD_PIN_INFO(472, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_DI_MISC = SPRD_PIN_INFO(473, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SPI0_CLK_MISC = SPRD_PIN_INFO(474, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SCL2_MISC = SPRD_PIN_INFO(475, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_SDA2_MISC = SPRD_PIN_INFO(476, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYOUT1_MISC = SPRD_PIN_INFO(477, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYOUT0_MISC = SPRD_PIN_INFO(478, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYOUT2_MISC = SPRD_PIN_INFO(479, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT9_MISC = SPRD_PIN_INFO(480, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_EXTINT10_MISC = SPRD_PIN_INFO(481, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYIN0_MISC = SPRD_PIN_INFO(482, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYIN1_MISC = SPRD_PIN_INFO(483, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_KEYIN2_MISC = SPRD_PIN_INFO(484, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U5TXD_MISC = SPRD_PIN_INFO(485, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U5RXD_MISC = SPRD_PIN_INFO(486, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_CLK_AUX0_MISC = SPRD_PIN_INFO(487, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U0TXD_MISC = SPRD_PIN_INFO(488, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U0RXD_MISC = SPRD_PIN_INFO(489, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U0CTS_MISC = SPRD_PIN_INFO(490, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U0RTS_MISC = SPRD_PIN_INFO(491, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0DI_MISC = SPRD_PIN_INFO(492, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0DO_MISC = SPRD_PIN_INFO(493, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0CLK_MISC = SPRD_PIN_INFO(494, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS0LRCK_MISC = SPRD_PIN_INFO(495, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_PWMC_MISC = SPRD_PIN_INFO(496, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4DO_MISC = SPRD_PIN_INFO(497, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4DI_MISC = SPRD_PIN_INFO(498, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4CLK_MISC = SPRD_PIN_INFO(499, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_IIS4LRCK_MISC = SPRD_PIN_INFO(500, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U4TXD_MISC = SPRD_PIN_INFO(501, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U4RXD_MISC = SPRD_PIN_INFO(502, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U4CTS_MISC = SPRD_PIN_INFO(503, MISC_PIN, 0, 0, 0),
	QOGIRN6LITE_U4RTS_MISC = SPRD_PIN_INFO(504, MISC_PIN, 0, 0, 0),

};

static struct sprd_pins_info sprd_qogirn6lite_pins_info[] = {

	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF5_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF2_INF3_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF2_INF4_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF1_INF4_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF1_INF3_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF8_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_INF7_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF1_INF2_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF0_INF2_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF0_INF1_LOOP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS_INF5_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF7_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF5_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF9_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIC_INF8_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_HOT_PLUG_DET_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_HOT_PLUG_DET_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_HOT_PLUG_DET_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_PIN_CTRL_REG0_FUNC_CFG),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_PIN_CTRL_REG1_FUNC_CFG),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_UART_USB_PHY_SEL),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD0),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD7),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD6),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD5),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CH_EIC_DPAD4),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_CORE_OUT_WDGRST_SOUR_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VBC_IIS_INF_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VAD_DIN_SEL),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_TF_DET_SW),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CORE_IN_TF_DET_MUX),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM1_DET_SW),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CORE_IN_SIM1_DET_MUX),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM0_DET_SW),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CORE_IN_SIM0_DET_MUX),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_CMD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_RST),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_CMD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D5),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_DS),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D4),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D6),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D7),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DNS_D0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DNS_D1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LCM0_RSTN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DSI0_TE),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_PWMA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DCDC_ARM1_EN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_PTEST),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXT_RST_B),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ADI_SCLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_32K),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ANA_INT1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ANA_INT0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ANA_INT2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ADI_D),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_SCLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DCDC_ARM0_EN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DCDC_ARM2_EN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_ADD0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_ADD1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_XTL_EN0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_ADSYNC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DAD0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_XTL_EN1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_XTL_EN2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DASYNC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DAD1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CHIP_SLEEP),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CHG_TYPE),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMCLK0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMDA0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMRST0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMCLK1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMDA1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMRST1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_CMD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_CMD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM_DET0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM_DET1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_TF_DET),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_BAT_DET),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL4),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA4),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_AUX1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1LRCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3LRCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_AUX2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_4),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_5),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_6),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_7),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_8),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_9),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_10),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_11),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_12),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_13),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_14),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_15),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE0_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE0_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE1_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE1_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE2_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE2_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE3_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE3_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE4_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE4_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE5_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE5_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE6_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE6_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE7_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE7_SDA),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC0_ON),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC1_ON),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC2_ON),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC3_ON),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SEN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL6),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA6),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TDO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TDI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TMS),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_RTCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_CLK2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_DATA2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_CLK0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_DATA0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_CLK1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_DATA1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U2TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U2RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U1TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U1RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U7TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U7RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U6TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U6RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_MTCK_ARM),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_MTMS_ARM),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TDO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_RTCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TDI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TMS),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST4),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST5),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD3),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD4),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD5),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL8),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA8),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL9),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA9),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_CSN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_CSN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_CSN),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYOUT1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYOUT0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYOUT2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT9),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT10),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYIN0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYIN1),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYIN2),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U5TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U5RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_AUX0),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0CTS),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0RTS),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0LRCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_PWMC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4DO),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4DI),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4CLK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4LRCK),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4TXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4RXD),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4CTS),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4RTS),

	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD1_D3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_RST_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D5_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_DS_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D4_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D6_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EMMC_D7_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DNS_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DNS_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LCM0_RSTN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DSI0_TE_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_PWMA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DCDC_ARM1_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_PTEST_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXT_RST_B_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ADI_SCLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_32K_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ANA_INT1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ANA_INT0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ANA_INT2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_ADI_D_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_SCLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DCDC_ARM0_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DCDC_ARM2_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_ADD0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_ADD1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_XTL_EN0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_ADSYNC_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DAD0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_XTL_EN1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_XTL_EN2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DASYNC_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DAD1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CHIP_SLEEP_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CHG_TYPE_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMCLK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMDA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMRST0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMCLK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMDA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIMRST1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD0_D_3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SD2_D3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM_DET0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SIM_DET1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_TF_DET_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_BAT_DET_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL4_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA4_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_AUX1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS1LRCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3LRCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS3CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_AUX2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_4_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_5_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_6_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_7_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_8_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_9_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_10_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_11_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_12_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_13_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_14_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFCTL_15_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE0_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE0_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE1_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE1_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE2_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE2_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE3_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE3_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE4_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE4_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE5_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE5_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE6_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE6_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE7_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFFE7_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC0_ON_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC1_ON_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC2_ON_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_LVDSRF_ADDAC3_ON_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SDA3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_RFSPI_SEN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL6_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA6_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TDO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TDI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TMS_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_TCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_VDSP_RTCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_CLK2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_DATA2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_CLK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_DATA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_CLK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_DMIC_DATA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U2TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U2RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U1TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U1RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U7TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U7RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U6TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U6RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_MTCK_ARM_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_MTMS_ARM_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TDO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_RTCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TDI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_AUD_DSP_TMS_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMMCLK3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST4_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMRST5_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD3_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD4_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CMPD5_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL8_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA8_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL9_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA9_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_CSN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI2_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_CSN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI3_DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_CSN_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SPI0_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SCL2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_SDA2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYOUT1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYOUT0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYOUT2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT9_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_EXTINT10_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYIN0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYIN1_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_KEYIN2_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U5TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U5RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_CLK_AUX0_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0CTS_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U0RTS_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS0LRCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_PWMC_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_IIS4LRCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4CTS_MISC),
	SPRD_PINCTRL_PIN(QOGIRN6LITE_U4RTS_MISC),
};

static int sprd_pinctrl_probe(struct platform_device *pdev)
{
	return sprd_pinctrl_core_probe(pdev, sprd_qogirn6lite_pins_info,
				       ARRAY_SIZE(sprd_qogirn6lite_pins_info),
				       PINCTRL_REG_OFFSET,
				       PINCTRL_REG_MISC_OFFSET);
}

static const struct of_device_id sprd_pinctrl_of_match[] = {
	{
		.compatible = "sprd,qogirn6lite-pinctrl",
	},
	{ },
};
MODULE_DEVICE_TABLE(of, sprd_pinctrl_of_match);

static struct platform_driver sprd_pinctrl_driver = {
	.driver = {
		.name = "sprd-pinctrl",
		.of_match_table = sprd_pinctrl_of_match,
	},
	.probe = sprd_pinctrl_probe,
	.remove = sprd_pinctrl_remove,
	.shutdown = sprd_pinctrl_shutdown,
};

module_platform_driver(sprd_pinctrl_driver);

MODULE_DESCRIPTION("SPREADTRUM Pin Controller Driver");
MODULE_AUTHOR("qiang lin <qiang.lin@unisoc.com>");
MODULE_LICENSE("GPL v2");
