/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2013-2019, The Linux Foundation. All rights reserved.
 */

#ifndef __QPNP_REVID
#define __QPNP_REVID

#include <linux/types.h>

/* Common TYPE for all PMICs */
#define PMIC_TYPE		0x51

/* PM8994 */
#define PM8941_SUBTYPE		0x01

#define PM8941_V1P0_REV1	0x00
#define PM8941_V1P0_REV2	0x00
#define PM8941_V1P0_REV3	0x00
#define PM8941_V1P0_REV4	0x01

#define PM8941_V2P0_REV1	0x00
#define PM8941_V2P0_REV2	0x00
#define PM8941_V2P0_REV3	0x00
#define PM8941_V2P0_REV4	0x01

#define PM8941_V3P0_REV1	0x00
#define PM8941_V3P0_REV2	0x00
#define PM8941_V3P0_REV3	0x00
#define PM8941_V3P0_REV4	0x03

#define PM8941_V3P1_REV1	0x00
#define PM8941_V3P1_REV2	0x00
#define PM8941_V3P1_REV3	0x01
#define PM8941_V3P1_REV4	0x03

/* PM8841 */
#define PM8841_SUBTYPE		0x02

/* PM8019 */
#define PM8019_SUBTYPE		0x03

/* PM8226 */
#define PM8226_SUBTYPE		0x04

#define PM8226_V2P2_REV1	0x00
#define PM8226_V2P2_REV2	0x00
#define PM8226_V2P2_REV3	0x02
#define PM8226_V2P2_REV4	0x02

#define PM8226_V2P1_REV1	0x00
#define PM8226_V2P1_REV2	0x00
#define PM8226_V2P1_REV3	0x01
#define PM8226_V2P1_REV4	0x02

#define PM8226_V2P0_REV1	0x00
#define PM8226_V2P0_REV2	0x00
#define PM8226_V2P0_REV3	0x00
#define PM8226_V2P0_REV4	0x02

#define PM8226_V1P0_REV1	0x00
#define PM8226_V1P0_REV2	0x00
#define PM8226_V1P0_REV3	0x00
#define PM8226_V1P0_REV4	0x00

/* PM8110 */
#define PM8110_SUBTYPE		0x05

#define PM8110_V1P0_REV1	0x00
#define PM8110_V1P0_REV2	0x00
#define PM8110_V1P0_REV3	0x00
#define PM8110_V1P0_REV4	0x01

#define PM8110_V1P1_REV1	0x00
#define PM8110_V1P1_REV2	0x01
#define PM8110_V1P1_REV3	0x00
#define PM8110_V1P1_REV4	0x01

#define PM8110_V1P3_REV1	0x00
#define PM8110_V1P3_REV2	0x03
#define PM8110_V1P3_REV3	0x00
#define PM8110_V1P3_REV4	0x01

#define PM8110_V2P0_REV1	0x00
#define PM8110_V2P0_REV2	0x00
#define PM8110_V2P0_REV3	0x00
#define PM8110_V2P0_REV4	0x02

/* PMA8084 */
#define PMA8084_SUBTYPE		0x06

/* PMI8962 */
#define PMI8962_SUBTYPE		0x07

/* PMD9635 */
#define PMD9635_SUBTYPE		0x08
/* PM8994 */
#define PM8994_SUBTYPE		0x09

/* PMI8994 */
#define PMI8994_TYPE		0x51
#define PMI8994_SUBTYPE		0x0A

#define PMI8994_V1P0_REV1	0x00
#define PMI8994_V1P0_REV2	0x00
#define PMI8994_V1P0_REV3	0x00
#define PMI8994_V1P0_REV4	0x01

#define PMI8994_V2P0_REV1	0x00
#define PMI8994_V2P0_REV2	0x00
#define PMI8994_V2P0_REV3	0x00
#define PMI8994_V2P0_REV4	0x02

/* PM8916 */
#define PM8916_SUBTYPE		0x0B

#define PM8916_V1P0_REV1	0x00
#define PM8916_V1P0_REV2	0x00
#define PM8916_V1P0_REV3	0x00
#define PM8916_V1P0_REV4	0x01

#define PM8916_V1P1_REV1	0x00
#define PM8916_V1P1_REV2	0x00
#define PM8916_V1P1_REV3	0x01
#define PM8916_V1P1_REV4	0x01

#define PM8916_V2P0_REV1	0x00
#define PM8916_V2P0_REV2	0x00
#define PM8916_V2P0_REV3	0x00
#define PM8916_V2P0_REV4	0x02

/* PM8004 */
#define PM8004_SUBTYPE		0x0C

/* PM8909 */
#define PM8909_SUBTYPE		0x0D

#define PM8909_V1P0_REV1	0x00
#define PM8909_V1P0_REV2	0x00
#define PM8909_V1P0_REV3	0x00
#define PM8909_V1P0_REV4	0x01

#define PM8909_V1P1_REV1	0x00
#define PM8909_V1P1_REV2	0x00
#define PM8909_V1P1_REV3	0x01
#define PM8909_V1P1_REV4	0x01

/* PM2433 */
#define PM2433_SUBTYPE		0x0E

/* PMD9655 */
#define PMD9655_SUBTYPE		0x0F

/* PM8950 */
#define PM8950_SUBTYPE		0x10
#define PM8950_V1P0_REV4	0x01

#define PM8950_V2P0_REV4	0x02

/* PMI8950 */
#define PMI8950_SUBTYPE		0x11

/* PMK8001 */
#define PMK8001_SUBTYPE		0x12

/* PMI8996 */
#define PMI8996_SUBTYPE		0x13

/* PM8998 */
#define PM8998_SUBTYPE	0x14

/* PMI8998 */
#define PMI8998_SUBTYPE	0x15

/* PM660 */
#define PM660L_SUBTYPE	0x1A
#define PM660_SUBTYPE	0x1B

/* PM8150 */
#define PM8150_SUBTYPE		0x1E
#define PM8150L_SUBTYPE		0x1F
#define PM8150B_SUBTYPE		0x20

#define PM6150_SUBTYPE		0x28
#define PM6150L_SUBTYPE		0x1F

#define PM7250B_SUBTYPE		0x2E

/* PM6125 SUBTYPE */
#define PM6125_SUBTYPE		0x2D

/* PMI632 */
#define PMI632_SUBTYPE	0x25

/* PM8008 SUBTYPE */
#define PM8008_SUBTYPE	0x2C

/* PMI8998 REV_ID */
#define PMI8998_V1P0_REV1	0x00
#define PMI8998_V1P0_REV2	0x00
#define PMI8998_V1P0_REV3	0x00
#define PMI8998_V1P0_REV4	0x01

#define PMI8998_V1P1_REV1	0x00
#define PMI8998_V1P1_REV2	0x00
#define PMI8998_V1P1_REV3	0x01
#define PMI8998_V1P1_REV4	0x01

#define PMI8998_V2P0_REV1	0x00
#define PMI8998_V2P0_REV2	0x00
#define PMI8998_V2P0_REV3	0x00
#define PMI8998_V2P0_REV4	0x02

/* PM660 REV_ID */
#define PM660_V1P0_REV1		0x00
#define PM660_V1P0_REV2		0x00
#define PM660_V1P0_REV3		0x00
#define PM660_V1P0_REV4		0x01

#define PM660_V1P1_REV1		0x00
#define PM660_V1P1_REV2		0x00
#define PM660_V1P1_REV3		0x01
#define PM660_V1P1_REV4		0x01

/* PM660L REV_ID */
#define PM660L_V1P1_REV1	0x00
#define PM660L_V1P1_REV2	0x00
#define PM660L_V1P1_REV3	0x01
#define PM660L_V1P1_REV4	0x01

#define PM660L_V2P0_REV1	0x00
#define PM660L_V2P0_REV2	0x00
#define PM660L_V2P0_REV3	0x00
#define PM660L_V2P0_REV4	0x02

/* PMI632 REV_ID */
#define PMI632_V1P0_REV1	0x00
#define PMI632_V1P0_REV2	0x00
#define PMI632_V1P0_REV3	0x00
#define PMI632_V1P0_REV4	0x01

/* PM8150B_REV_ID */
#define PM8150B_V1P0_REV1	0x00
#define PM8150B_V1P0_REV2	0x00
#define PM8150B_V1P0_REV3	0x00
#define PM8150B_V1P0_REV4	0x01

#define PM8150B_V2P0_REV1	0x00
#define PM8150B_V2P0_REV2	0x00
#define PM8150B_V2P0_REV3	0x00
#define PM8150B_V2P0_REV4	0x02

/* PM8150L_REV_ID */
#define PM8150L_V1P0_REV1	0x00
#define PM8150L_V1P0_REV2	0x00
#define PM8150L_V1P0_REV3	0x00
#define PM8150L_V1P0_REV4	0x01

#define PM8150L_V2P0_REV1	0x00
#define PM8150L_V2P0_REV2	0x00
#define PM8150L_V2P0_REV3	0x00
#define PM8150L_V2P0_REV4	0x02

#define PM8150L_V3P0_REV1	0x00
#define PM8150L_V3P0_REV2	0x00
#define PM8150L_V3P0_REV3	0x00
#define PM8150L_V3P0_REV4	0x03

#define PM6150_V1P0_REV1	0x00
#define PM6150_V1P0_REV2	0x00
#define PM6150_V1P0_REV3	0x00
#define PM6150_V1P0_REV4	0x01

#define PM6150_V1P1_REV1	0x00
#define PM6150_V1P1_REV2	0x00
#define PM6150_V1P1_REV3	0x01
#define PM6150_V1P1_REV4	0x01

#define PM6150_V2P0_REV1	0x00
#define PM6150_V2P0_REV2	0x00
#define PM6150_V2P0_REV3	0x00
#define PM6150_V2P0_REV4	0x02

/* PM7250B_REV_ID */
#define PM7250B_V1P0_REV1	0x00
#define PM7250B_V1P0_REV2	0x00
#define PM7250B_V1P0_REV3	0x00
#define PM7250B_V1P0_REV4	0x01

/* PM6125_REV_ID */
#define PM6125_V1P0_REV1	0x00
#define PM6125_V1P0_REV2	0x00
#define PM6125_V1P0_REV3	0x00
#define PM6125_V1P0_REV4	0x01

/* PMI8998 FAB_ID */
#define PMI8998_FAB_ID_SMIC	0x11
#define PMI8998_FAB_ID_GF	0x30

/* PM660 FAB_ID */
#define PM660_FAB_ID_GF		0x0
#define PM660_FAB_ID_TSMC	0x2
#define PM660_FAB_ID_MX		0x3

/* PM8005 */
#define PM8005_SUBTYPE		0x18

/* PM8937 */
#define PM8937_SUBTYPE		0x19

/* PMI8937 */
#define PMI8937_SUBTYPE		0x37

/* SMB1390 */
#define SMB1390_SUBTYPE		0x23

/* SMB1381 */
#define SMB1381_SUBTYPE		0x17

/* SMB1355 */
#define SMB1355_SUBTYPE		0x1C

struct pmic_revid_data {
	u8		rev1;
	u8		rev2;
	u8		rev3;
	u8		rev4;
	u8		pmic_type;
	u8		pmic_subtype;
	const char	*pmic_name;
	int		fab_id;
	int		tp_rev;
};

struct device_node;

#if IS_ENABLED(CONFIG_QPNP_REVID)
struct pmic_revid_data *get_revid_data(struct device_node *dev_node);
#else
static inline
struct pmic_revid_data *get_revid_data(struct device_node *dev_node)
{
	return NULL;
}
#endif
#endif
