/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2021, Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _DT_BINDINGS_QCOM_SPMI_VADC_PM7325_H
#define _DT_BINDINGS_QCOM_SPMI_VADC_PM7325_H

#ifndef PM7325_SID
#define PM7325_SID					1
#endif

/* ADC channels for PM7325_ADC for PMIC7 */
#define PM7325_ADC7_REF_GND			(PM7325_SID << 8 | 0x0)
#define PM7325_ADC7_1P25VREF			(PM7325_SID << 8 | 0x01)
#define PM7325_ADC7_VREF_VADC			(PM7325_SID << 8 | 0x02)
#define PM7325_ADC7_DIE_TEMP			(PM7325_SID << 8 | 0x03)

#define PM7325_ADC7_AMUX_THM1			(PM7325_SID << 8 | 0x04)
#define PM7325_ADC7_AMUX_THM2			(PM7325_SID << 8 | 0x05)
#define PM7325_ADC7_AMUX_THM3			(PM7325_SID << 8 | 0x06)
#define PM7325_ADC7_AMUX_THM4			(PM7325_SID << 8 | 0x07)
#define PM7325_ADC7_AMUX_THM5			(PM7325_SID << 8 | 0x08)
#define PM7325_ADC7_GPIO1			(PM7325_SID << 8 | 0x0a)
#define PM7325_ADC7_GPIO2			(PM7325_SID << 8 | 0x0b)
#define PM7325_ADC7_GPIO3			(PM7325_SID << 8 | 0x0c)
#define PM7325_ADC7_GPIO4			(PM7325_SID << 8 | 0x0d)

/* 30k pull-up1 */
#define PM7325_ADC7_AMUX_THM1_30K_PU		(PM7325_SID << 8 | 0x24)
#define PM7325_ADC7_AMUX_THM2_30K_PU		(PM7325_SID << 8 | 0x25)
#define PM7325_ADC7_AMUX_THM3_30K_PU		(PM7325_SID << 8 | 0x26)
#define PM7325_ADC7_AMUX_THM4_30K_PU		(PM7325_SID << 8 | 0x27)
#define PM7325_ADC7_AMUX_THM5_30K_PU		(PM7325_SID << 8 | 0x28)
#define PM7325_ADC7_GPIO1_30K_PU		(PM7325_SID << 8 | 0x2a)
#define PM7325_ADC7_GPIO2_30K_PU		(PM7325_SID << 8 | 0x2b)
#define PM7325_ADC7_GPIO3_30K_PU		(PM7325_SID << 8 | 0x2c)
#define PM7325_ADC7_GPIO4_30K_PU		(PM7325_SID << 8 | 0x2d)

/* 100k pull-up2 */
#define PM7325_ADC7_AMUX_THM1_100K_PU		(PM7325_SID << 8 | 0x44)
#define PM7325_ADC7_AMUX_THM2_100K_PU		(PM7325_SID << 8 | 0x45)
#define PM7325_ADC7_AMUX_THM3_100K_PU		(PM7325_SID << 8 | 0x46)
#define PM7325_ADC7_AMUX_THM4_100K_PU		(PM7325_SID << 8 | 0x47)
#define PM7325_ADC7_AMUX_THM5_100K_PU		(PM7325_SID << 8 | 0x48)
#define PM7325_ADC7_GPIO1_100K_PU		(PM7325_SID << 8 | 0x4a)
#define PM7325_ADC7_GPIO2_100K_PU		(PM7325_SID << 8 | 0x4b)
#define PM7325_ADC7_GPIO3_100K_PU		(PM7325_SID << 8 | 0x4c)
#define PM7325_ADC7_GPIO4_100K_PU		(PM7325_SID << 8 | 0x4d)

/* 400k pull-up3 */
#define PM7325_ADC7_AMUX_THM1_400K_PU		(PM7325_SID << 8 | 0x64)
#define PM7325_ADC7_AMUX_THM2_400K_PU		(PM7325_SID << 8 | 0x65)
#define PM7325_ADC7_AMUX_THM3_400K_PU		(PM7325_SID << 8 | 0x66)
#define PM7325_ADC7_AMUX_THM4_400K_PU		(PM7325_SID << 8 | 0x67)
#define PM7325_ADC7_AMUX_THM5_400K_PU		(PM7325_SID << 8 | 0x68)
#define PM7325_ADC7_GPIO1_400K_PU		(PM7325_SID << 8 | 0x6a)
#define PM7325_ADC7_GPIO2_400K_PU		(PM7325_SID << 8 | 0x6b)
#define PM7325_ADC7_GPIO3_400K_PU		(PM7325_SID << 8 | 0x6c)
#define PM7325_ADC7_GPIO4_400K_PU		(PM7325_SID << 8 | 0x6d)

/* 1/3 Divider */
#define PM7325_ADC7_GPIO4_DIV3			(PM7325_SID << 8 | 0x8d)

#define PM7325_ADC7_VPH_PWR			(PM7325_SID << 8 | 0x8e)

#endif /* _DT_BINDINGS_QCOM_SPMI_VADC_PM7325_H */
