/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022, Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _DT_BINDINGS_QCOM_SPMI_VADC_PM8550B_H
#define _DT_BINDINGS_QCOM_SPMI_VADC_PM8550B_H

#ifndef PM8550B_SID
#define PM8550B_SID		7
#endif

/* ADC channels for PM8550B_ADC for PMIC5 Gen3 */
#define PM8550B_ADC5_GEN3_OFFSET_REF			(PM8550B_SID << 8 | 0x00)
#define PM8550B_ADC5_GEN3_1P25VREF			(PM8550B_SID << 8 | 0x01)
#define PM8550B_ADC5_GEN3_VREF_VADC			(PM8550B_SID << 8 | 0x02)
#define PM8550B_ADC5_GEN3_DIE_TEMP			(PM8550B_SID << 8 | 0x03)

#define PM8550B_ADC5_GEN3_AMUX_THM1_BATT_THERM		(PM8550B_SID << 8 | 0x04)
#define PM8550B_ADC5_GEN3_AMUX_THM2_BATT_ID		(PM8550B_SID << 8 | 0x05)
#define PM8550B_ADC5_GEN3_AMUX_THM3_SMB_TEMP_V		(PM8550B_SID << 8 | 0x06)
#define PM8550B_ADC5_GEN3_AMUX_THM4_USB_THERM		(PM8550B_SID << 8 | 0x07)
#define PM8550B_ADC5_GEN3_AMUX_THM5_OPTION		(PM8550B_SID << 8 | 0x08)
#define PM8550B_ADC5_GEN3_AMUX_THM6_GPIO10		(PM8550B_SID << 8 | 0x09)
#define PM8550B_ADC5_GEN3_AMUX1_GPIO1			(PM8550B_SID << 8 | 0x0a)
#define PM8550B_ADC5_GEN3_AMUX2_GPIO5			(PM8550B_SID << 8 | 0x0b)
#define PM8550B_ADC5_GEN3_AMUX3_GPIO6			(PM8550B_SID << 8 | 0x0c)
#define PM8550B_ADC5_GEN3_AMUX4_GPIO12			(PM8550B_SID << 8 | 0x0d)

#define PM8550B_ADC5_GEN3_CHG_TEMP			(PM8550B_SID << 8 | 0x10)
#define PM8550B_ADC5_GEN3_USB_SNS_V_16			(PM8550B_SID << 8 | 0x11)
#define PM8550B_ADC5_GEN3_VIN_DIV16_MUX			(PM8550B_SID << 8 | 0x12)
#define PM8550B_ADC5_GEN3_USBC_MUX			(PM8550B_SID << 8 | 0x13)
#define PM8550B_ADC5_GEN3_VREF_BAT_THERM		(PM8550B_SID << 8 | 0x15)
#define PM8550B_ADC5_GEN3_IIN_FB			(PM8550B_SID << 8 | 0x17)
#define PM8550B_ADC5_GEN3_TEMP_ALARM_LITE		(PM8550B_SID << 8 | 0x18)
#define PM8550B_ADC5_GEN3_SMB_IIN			(PM8550B_SID << 8 | 0x19)
#define PM8550B_ADC5_GEN3_VREF_BAT2_THERM		(PM8550B_SID << 8 | 0x1a)
#define PM8550B_ADC5_GEN3_SMB_ICHG			(PM8550B_SID << 8 | 0x1b)
#define PM8550B_ADC5_GEN3_SMB_TEMP_I			(PM8550B_SID << 8 | 0x1e)
#define PM8550B_ADC5_GEN3_CHG_TEMP_I			(PM8550B_SID << 8 | 0x1f)
#define PM8550B_ADC5_GEN3_ICHG_FB			(PM8550B_SID << 8 | 0xa1)

/* 30k pull-up */
#define PM8550B_ADC5_GEN3_AMUX_THM1_BATT_THERM_30K_PU	(PM8550B_SID << 8 | 0x24)
#define PM8550B_ADC5_GEN3_AMUX_THM2_BATT_ID_30K_PU	(PM8550B_SID << 8 | 0x25)
#define PM8550B_ADC5_GEN3_AMUX_THM3_SMB_TEMP_V_30K_PU	(PM8550B_SID << 8 | 0x26)
#define PM8550B_ADC5_GEN3_AMUX_THM4_USB_THERM_30K_PU	(PM8550B_SID << 8 | 0x27)
#define PM8550B_ADC5_GEN3_AMUX_THM5_OPTION_30K_PU	(PM8550B_SID << 8 | 0x28)
#define PM8550B_ADC5_GEN3_AMUX_THM6_GPIO10_30K_PU	(PM8550B_SID << 8 | 0x29)
#define PM8550B_ADC5_GEN3_AMUX1_GPIO1_30K_PU		(PM8550B_SID << 8 | 0x2a)
#define PM8550B_ADC5_GEN3_AMUX2_GPIO5_30K_PU		(PM8550B_SID << 8 | 0x2b)
#define PM8550B_ADC5_GEN3_AMUX3_GPIO6_30K_PU		(PM8550B_SID << 8 | 0x2c)
#define PM8550B_ADC5_GEN3_AMUX4_GPIO12_30K_PU		(PM8550B_SID << 8 | 0x2d)

#define PM8550B_ADC5_GEN3_USBC_MUX_30K_PU		(PM8550B_SID << 8 | 0x33)

/* 100k pull-up */
#define PM8550B_ADC5_GEN3_AMUX_THM1_BATT_THERM_100K_PU	(PM8550B_SID << 8 | 0x44)
#define PM8550B_ADC5_GEN3_AMUX_THM2_BATT_ID_100K_PU	(PM8550B_SID << 8 | 0x45)
#define PM8550B_ADC5_GEN3_AMUX_THM3_SMB_TEMP_V_100K_PU	(PM8550B_SID << 8 | 0x46)
#define PM8550B_ADC5_GEN3_AMUX_THM4_USB_THERM_100K_PU	(PM8550B_SID << 8 | 0x47)
#define PM8550B_ADC5_GEN3_AMUX_THM5_OPTION_100K_PU	(PM8550B_SID << 8 | 0x48)
#define PM8550B_ADC5_GEN3_AMUX_THM6_GPIO10_100K_PU	(PM8550B_SID << 8 | 0x49)
#define PM8550B_ADC5_GEN3_AMUX1_GPIO1_100K_PU		(PM8550B_SID << 8 | 0x4a)
#define PM8550B_ADC5_GEN3_AMUX2_GPIO5_100K_PU		(PM8550B_SID << 8 | 0x4b)
#define PM8550B_ADC5_GEN3_AMUX3_GPIO6_100K_PU		(PM8550B_SID << 8 | 0x4c)
#define PM8550B_ADC5_GEN3_AMUX4_GPIO12_100K_PU		(PM8550B_SID << 8 | 0x4d)

#define PM8550B_ADC5_GEN3_USBC_MUX_100K_PU		(PM8550B_SID << 8 | 0x53)

/* 400k pull-up */
#define PM8550B_ADC5_GEN3_AMUX_THM1_BATT_THERM_400K_PU	(PM8550B_SID << 8 | 0x64)
#define PM8550B_ADC5_GEN3_AMUX_THM2_BATT_ID_400K_PU	(PM8550B_SID << 8 | 0x65)
#define PM8550B_ADC5_GEN3_AMUX_THM3_SMB_TEMP_V_400K_PU	(PM8550B_SID << 8 | 0x66)
#define PM8550B_ADC5_GEN3_AMUX_THM4_USB_THERM_400K_PU	(PM8550B_SID << 8 | 0x67)
#define PM8550B_ADC5_GEN3_AMUX_THM5_OPTION_400K_PU	(PM8550B_SID << 8 | 0x68)
#define PM8550B_ADC5_GEN3_AMUX_THM6_GPIO10_400K_PU	(PM8550B_SID << 8 | 0x69)
#define PM8550B_ADC5_GEN3_AMUX1_GPIO1_400K_PU		(PM8550B_SID << 8 | 0x6a)
#define PM8550B_ADC5_GEN3_AMUX2_GPIO5_400K_PU		(PM8550B_SID << 8 | 0x6b)
#define PM8550B_ADC5_GEN3_AMUX3_GPIO6_400K_PU		(PM8550B_SID << 8 | 0x6c)
#define PM8550B_ADC5_GEN3_AMUX4_GPIO12_400K_PU		(PM8550B_SID << 8 | 0x6d)

#define PM8550B_ADC5_GEN3_USBC_MUX_400K_PU		(PM8550B_SID << 8 | 0x73)

/* 1/3 Divider */
#define PM8550B_ADC5_GEN3_AMUX1_GPIO1_DIV3		(PM8550B_SID << 8 | 0x8a)
#define PM8550B_ADC5_GEN3_AMUX2_GPIO5_DIV3		(PM8550B_SID << 8 | 0x8b)
#define PM8550B_ADC5_GEN3_AMUX3_GPIO6_DIV3		(PM8550B_SID << 8 | 0x8c)

#define PM8550B_ADC5_GEN3_VPH_PWR			(PM8550B_SID << 8 | 0x8e)
#define PM8550B_ADC5_GEN3_VBAT_SNS_QBG			(PM8550B_SID << 8 | 0x8f)
#define PM8550B_ADC5_GEN3_VBAT_SNS_CHGR			(PM8550B_SID << 8 | 0x94)
#define PM8550B_ADC5_GEN3_VBAT_2S_MID_QBG		(PM8550B_SID << 8 | 0x96)
#define PM8550B_ADC5_GEN3_VBAT_2S_MID_CHGR		(PM8550B_SID << 8 | 0x9d)

#endif /* _DT_BINDINGS_QCOM_SPMI_VADC_PM8550B_H */
