// SPDX-License-Identifier: GPL-2.0-only
/*
 * sc8551_reg.h - Unisoc platform header
 *
 * Copyright 2022 Unisoc(Shanghai) Technologies Co.Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#ifndef __SC8551_HEADER__
#define __SC8551_HEADER__

/* Register 00h */
#define SC8551_REG_00				0x00
#define	SC8551_BAT_OVP_DIS_MASK			0x80
#define	SC8551_BAT_OVP_DIS_SHIFT		7
#define	SC8551_BAT_OVP_ENABLE			0
#define	SC8551_BAT_OVP_DISABLE			1

#define SC8551_BAT_OVP_MASK			0x3F
#define SC8551_BAT_OVP_SHIFT			0
#define SC8551_BAT_OVP_BASE			3500
#define SC8551_BAT_OVP_MAX			5075
#define SC8551_BAT_OVP_LSB			25

/* Register 02h */
#define SC8551_REG_02				0x02
#define	SC8551_BAT_OCP_DIS_MASK			0x80
#define	SC8551_BAT_OCP_DIS_SHIFT		7
#define SC8551_BAT_OCP_ENABLE			0
#define SC8551_BAT_OCP_DISABLE			1

#define SC8551_BAT_OCP_MASK			0x7F
#define SC8551_BAT_OCP_SHIFT			0
#define SC8551_BAT_OCP_BASE			2000
#define SC8551_BAT_OCP_MAX			10000
#define SC8551_BAT_OCP_LSB			100

/* Register 05h */
#define SC8551_REG_05				0x05
#define SC8551_AC_OVP_STAT_MASK			0x80
#define SC8551_AC_OVP_STAT_SHIFT		7

#define SC8551_AC_OVP_FLAG_MASK			0x40
#define SC8551_AC_OVP_FLAG_SHIFT		6

#define SC8551_AC_OVP_MASK_MASK			0x20
#define SC8551_AC_OVP_MASK_SHIFT		5

#define SC8551_VDROP_THRESHOLD_SET_MASK		0x10
#define SC8551_VDROP_THRESHOLD_SET_SHIFT	4
#define SC8551_VDROP_THRESHOLD_300MV		0
#define SC8551_VDROP_THRESHOLD_400MV		1

#define SC8551_VDROP_DEGLITCH_SET_MASK		0x08
#define SC8551_VDROP_DEGLITCH_SET_SHIFT		3
#define SC8551_VDROP_DEGLITCH_8US		0
#define SC8551_VDROP_DEGLITCH_5MS		1

#define SC8551_AC_OVP_MASK			0x07
#define SC8551_AC_OVP_SHIFT			0
#define SC8551_AC_OVP_BASE			11
#define SC8551_AC_OVP_MAX			18
#define SC8551_AC_OVP_LSB			1
#define SC8551_AC_OVP_6P5V			65

/* Register 06h */
#define SC8551_REG_06				0x06
#define SC8551_VBUS_PD_EN_MASK			0x80
#define SC8551_VBUS_PD_EN_SHIFT			7
#define SC8551_VBUS_PD_ENABLE			1
#define SC8551_VBUS_PD_DISABLE			0

#define SC8551_BUS_OVP_MASK			0x7F
#define SC8551_BUS_OVP_SHIFT			0
#define SC8551_BUS_OVP_BASE			6000
#define SC8551_BUS_OVP_MAX			12350
#define SC8551_BUS_OVP_LSB			50

/* Register 08h */
#define SC8551_REG_08				0x08
#define SC8551_BUS_OCP_DIS_MASK			0x80
#define SC8551_BUS_OCP_DIS_SHIFT		7
#define	SC8551_BUS_OCP_ENABLE			0
#define	SC8551_BUS_OCP_DISABLE			1

#define SC8551_IBUS_UCP_RISE_FLAG_MASK		0x40
#define SC8551_IBUS_UCP_RISE_FLAG_SHIFT		6

#define SC8551_IBUS_UCP_RISE_MASK_MASK		0x20
#define SC8551_IBUS_UCP_RISE_MASK_SHIFT		5
#define SC8551_IBUS_UCP_RISE_MASK_ENABLE	1
#define SC8551_IBUS_UCP_RISE_MASK_DISABLE	0

#define SC8551_IBUS_UCP_FALL_FLAG_MASK		0x10
#define SC8551_IBUS_UCP_FALL_FLAG_SHIFT		4

#define SC8551_BUS_OCP_MASK			0x0F
#define SC8551_BUS_OCP_SHIFT			0
#define SC8551_BUS_OCP_BASE			1000
#define SC8551_BUS_OCP_MAX			4750
#define SC8551_BUS_OCP_LSB			250

/* Register 0Ah */
#define SC8551_REG_0A				0x0A
#define SC8551_TSHUT_FLAG_MASK			0x80
#define SC8551_TSHUT_FLAG_SHIFT			7

#define SC8551_TSHUT_STAT_MASK			0x40
#define SC8551_TSHUT_STAT_SHIFT			6

#define SC8551_VBUS_ERRORLO_STAT_MASK		0x20
#define SC8551_VBUS_ERRORLO_STAT_SHIFT		5

#define SC8551_VBUS_ERRORHI_STAT_MASK		0x10
#define SC8551_VBUS_ERRORHI_STAT_SHIFT		4

#define SC8551_SS_TIMEOUT_FLAG_MASK		0x08
#define SC8551_SS_TIMEOUT_FLAG_SHIFT		3

#define SC8551_CONV_SWITCHING_STAT_MASK		0x04
#define SC8551_CONV_SWITCHING_STAT_SHIFT	2

#define SC8551_CONV_OCP_FLAG_MASK		0x02
#define SC8551_CONV_OCP_FLAG_SHIFT		1

#define SC8551_PIN_DIAG_FALL_FLAG_MASK		0x01
#define SC8551_PIN_DIAG_FALL_FLAG_SHIFT		0

/* Register 0Bh */
#define SC8551_REG_0B				0x0B
#define SC8551_REG_RST_MASK			0x80
#define SC8551_REG_RST_SHIFT			7
#define SC8551_REG_RST_ENABLE			1
#define SC8551_REG_RST_DISABLE			0

#define SC8551_FSW_SET_MASK			0x70
#define SC8551_FSW_SET_SHIFT			4
#define SC8551_FSW_SET_300KHZ			0
#define SC8551_FSW_SET_350KHZ			1
#define SC8551_FSW_SET_400KHZ			2
#define SC8551_FSW_SET_450KHZ			3
#define SC8551_FSW_SET_500KHZ			4
#define SC8551_FSW_SET_550KHZ			5
#define SC8551_FSW_SET_600KHZ			6
#define SC8551_FSW_SET_750KHZ			7

#define SC8551_WD_TIMEOUT_FLAG_MASK		0x08
#define SC8551_WD_TIMEOUT_SHIFT			3

#define SC8551_WATCHDOG_DIS_MASK		0x04
#define SC8551_WATCHDOG_DIS_SHIFT		2
#define SC8551_WATCHDOG_ENABLE			0
#define SC8551_WATCHDOG_DISABLE			1

#define SC8551_WATCHDOG_MASK			0x03
#define SC8551_WATCHDOG_SHIFT			0
#define SC8551_WATCHDOG_0P5S			0
#define SC8551_WATCHDOG_1S			1
#define SC8551_WATCHDOG_5S			2
#define SC8551_WATCHDOG_30S			3

/* Register 0Ch */
#define SC8551_REG_0C				0x0C
#define SC8551_CHG_EN_MASK			0x80
#define SC8551_CHG_EN_SHIFT			7
#define SC8551_CHG_ENABLE			1
#define SC8551_CHG_DISABLE			0

#define SC8551_MS_MASK				0x60
#define SC8551_MS_SHIFT				5
#define SC8551_MS_STANDALONE			0
#define SC8551_MS_SLAVE				1
#define SC8551_MS_MASTER			2

#define SC8551_FREQ_SHIFT_MASK			0x18
#define SC8551_FREQ_SHIFT_SHIFT			3
#define SC8551_FREQ_SHIFT_NORMINAL		0
#define SC8551_FREQ_SHIFT_POSITIVE10		1
#define SC8551_FREQ_SHIFT_NEGATIVE10		2
#define SC8551_FREQ_SHIFT_SPREAD_SPECTRUM	3

#define SC8551_TSBUS_DIS_MASK			0x04
#define SC8551_TSBUS_DIS_SHIFT			2
#define SC8551_TSBUS_ENABLE			0
#define SC8551_TSBUS_DISABLE			1

#define SC8551_TSBAT_DIS_MASK			0x02
#define SC8551_TSBAT_DIS_SHIFT			1
#define SC8551_TSBAT_ENABLE			0
#define SC8551_TSBAT_DISABLE			1

/* Register 0Dh */
#define SC8551_REG_0D				0x0D
#define SC8551_BAT_OVP_ALM_STAT_MASK		0x80
#define SC8551_BAT_OVP_ALM_STAT_SHIFT		7

#define SC8551_BAT_OCP_ALM_STAT_MASK		0x40
#define SC8551_BAT_OCP_ALM_STAT_SHIFT		6

#define SC8551_BUS_OVP_ALM_STAT_MASK		0x20
#define SC8551_BUS_OVP_ALM_STAT_SHIFT		5

#define SC8551_BUS_OCP_ALM_STAT_MASK		0x10
#define SC8551_BUS_OCP_ALM_STAT_SHIFT		4

#define SC8551_BAT_UCP_ALM_STAT_MASK		0x08
#define SC8551_BAT_UCP_ALM_STAT_SHIFT		3

#define SC8551_ADAPTER_INSERT_STAT_MASK		0x04
#define SC8551_ADAPTER_INSERT_STAT_SHIFT	2

#define SC8551_VBAT_INSERT_STAT_MASK		0x02
#define SC8551_VBAT_INSERT_STAT_SHIFT		1

#define SC8551_ADC_DONE_STAT_MASK		0x01
#define SC8551_ADC_DONE_STAT_SHIFT		0
#define SC8551_ADC_DONE_STAT_COMPLETE		1
#define SC8551_ADC_DONE_STAT_NOTCOMPLETE	0

/* Register 0Eh */
#define SC8551_REG_0E				0x0E
#define SC8551_BAT_OVP_ALM_FLAG_MASK		0x80
#define SC8551_BAT_OVP_ALM_FLAG_SHIFT		7

#define SC8551_BAT_OCP_ALM_FLAG_MASK		0x40
#define SC8551_BAT_OCP_ALM_FLAG_SHIFT		6

#define SC8551_BUS_OVP_ALM_FLAG_MASK		0x20
#define SC8551_BUS_OVP_ALM_FLAG_SHIFT		5

#define SC8551_BUS_OCP_ALM_FLAG_MASK		0x10
#define SC8551_BUS_OCP_ALM_FLAG_SHIFT		4

#define SC8551_BAT_UCP_ALM_FLAG_MASK		0x08
#define SC8551_BAT_UCP_ALM_FLAG_SHIFT		3

#define SC8551_ADAPTER_INSERT_FLAG_MASK		0x04
#define SC8551_ADAPTER_INSERT_FLAG_SHIFT	2

#define SC8551_VBAT_INSERT_FLAG_MASK		0x02
#define SC8551_VBAT_INSERT_FLAG_SHIFT		1

#define SC8551_ADC_DONE_FLAG_MASK		0x01
#define SC8551_ADC_DONE_FLAG_SHIFT		0
#define SC8551_ADC_DONE_FLAG_COMPLETE		1
#define SC8551_ADC_DONE_FLAG_NOTCOMPLETE	0

/* Register 0Fh */
#define SC8551_REG_0F				0x0F
#define SC8551_BAT_OVP_ALM_MASK_MASK		0x80
#define SC8551_BAT_OVP_ALM_MASK_SHIFT		7
#define SC8551_BAT_OVP_ALM_MASK_ENABLE		1
#define SC8551_BAT_OVP_ALM_MASK_DISABLE		0

#define SC8551_BAT_OCP_ALM_MASK_MASK		0x40
#define SC8551_BAT_OCP_ALM_MASK_SHIFT		6
#define SC8551_BAT_OCP_ALM_MASK_ENABLE		1
#define SC8551_BAT_OCP_ALM_MASK_DISABLE		0

#define SC8551_BUS_OVP_ALM_MASK_MASK		0x20
#define SC8551_BUS_OVP_ALM_MASK_SHIFT		5
#define SC8551_BUS_OVP_ALM_MASK_ENABLE		1
#define SC8551_BUS_OVP_ALM_MASK_DISABLE		0

#define SC8551_BUS_OCP_ALM_MASK_MASK		0x10
#define SC8551_BUS_OCP_ALM_MASK_SHIFT		4
#define SC8551_BUS_OCP_ALM_MASK_ENABLE		1
#define SC8551_BUS_OCP_ALM_MASK_DISABLE		0

#define SC8551_BAT_UCP_ALM_MASK_MASK		0x08
#define SC8551_BAT_UCP_ALM_MASK_SHIFT		3
#define SC8551_BAT_UCP_ALM_MASK_ENABLE		1
#define SC8551_BAT_UCP_ALM_MASK_DISABLE		0

#define SC8551_ADAPTER_INSERT_MASK_MASK		0x04
#define SC8551_ADAPTER_INSERT_MASK_SHIFT	2
#define SC8551_ADAPTER_INSERT_MASK_ENABLE	1
#define SC8551_ADAPTER_INSERT_MASK_DISABLE	0

#define SC8551_VBAT_INSERT_MASK_MASK		0x02
#define SC8551_VBAT_INSERT_MASK_SHIFT		1
#define SC8551_VBAT_INSERT_MASK_ENABLE		1
#define SC8551_VBAT_INSERT_MASK_DISABLE		0

#define SC8551_ADC_DONE_MASK_MASK		0x01
#define SC8551_ADC_DONE_MASK_SHIFT		0
#define SC8551_ADC_DONE_MASK_ENABLE		1
#define SC8551_ADC_DONE_MASK_DISABLE		0

/* Register 10h */
#define SC8551_REG_10				0x10
#define SC8551_BAT_OVP_FLT_STAT_MASK		0x80
#define SC8551_BAT_OVP_FLT_STAT_SHIFT		7

#define SC8551_BAT_OCP_FLT_STAT_MASK		0x40
#define SC8551_BAT_OCP_FLT_STAT_SHIFT		6

#define SC8551_BUS_OVP_FLT_STAT_MASK		0x20
#define SC8551_BUS_OVP_FLT_STAT_SHIFT		5

#define SC8551_BUS_OCP_FLT_STAT_MASK		0x10
#define SC8551_BUS_OCP_FLT_STAT_SHIFT		4

#define SC8551_TSBUS_TSBAT_ALM_STAT_MASK	0x08
#define SC8551_TSBUS_TSBAT_ALM_STAT_SHIFT	3

#define SC8551_TSBAT_FLT_STAT_MASK		0x04
#define SC8551_TSBAT_FLT_STAT_SHIFT		2

#define SC8551_TSBUS_FLT_STAT_MASK		0x02
#define SC8551_TSBUS_FLT_STAT_SHIFT		1

#define SC8551_TDIE_ALM_STAT_MASK		0x01
#define SC8551_TDIE_ALM_STAT_SHIFT		0

/* Register 11h */
#define SC8551_REG_11				0x11
#define SC8551_BAT_OVP_FLT_FLAG_MASK		0x80
#define SC8551_BAT_OVP_FLT_FLAG_SHIFT		7

#define SC8551_BAT_OCP_FLT_FLAG_MASK		0x40
#define SC8551_BAT_OCP_FLT_FLAG_SHIFT		6

#define SC8551_BUS_OVP_FLT_FLAG_MASK		0x20
#define SC8551_BUS_OVP_FLT_FLAG_SHIFT		5

#define SC8551_BUS_OCP_FLT_FLAG_MASK		0x10
#define SC8551_BUS_OCP_FLT_FLAG_SHIFT		4

#define SC8551_TSBUS_TSBAT_ALM_FLAG_MASK	0x08
#define SC8551_TSBUS_TSBAT_ALM_FLAG_SHIFT	3

#define SC8551_TSBAT_FLT_FLAG_MASK		0x04
#define SC8551_TSBAT_FLT_FLAG_SHIFT		2

#define SC8551_TSBUS_FLT_FLAG_MASK		0x02
#define SC8551_TSBUS_FLT_FLAG_SHIFT		1

#define SC8551_TDIE_ALM_FLAG_MASK		0x01
#define SC8551_TDIE_ALM_FLAG_SHIFT		0

/* Register 12h */
#define SC8551_REG_12				0x12
#define SC8551_BAT_OVP_FLT_MASK_MASK		0x80
#define SC8551_BAT_OVP_FLT_MASK_SHIFT		7
#define SC8551_BAT_OVP_FLT_MASK_ENABLE		1
#define SC8551_BAT_OVP_FLT_MASK_DISABLE		0

#define SC8551_BAT_OCP_FLT_MASK_MASK		0x40
#define SC8551_BAT_OCP_FLT_MASK_SHIFT		6
#define SC8551_BAT_OCP_FLT_MASK_ENABLE		1
#define SC8551_BAT_OCP_FLT_MASK_DISABLE		0

#define SC8551_BUS_OVP_FLT_MASK_MASK		0x20
#define SC8551_BUS_OVP_FLT_MASK_SHIFT		5
#define SC8551_BUS_OVP_FLT_MASK_ENABLE		1
#define SC8551_BUS_OVP_FLT_MASK_DISABLE		0

#define SC8551_BUS_OCP_FLT_MASK_MASK		0x10
#define SC8551_BUS_OCP_FLT_MASK_SHIFT		4
#define SC8551_BUS_OCP_FLT_MASK_ENABLE		1
#define SC8551_BUS_OCP_FLT_MASK_DISABLE		0

#define SC8551_TSBUS_TSBAT_ALM_MASK_MASK	0x08
#define SC8551_TSBUS_TSBAT_ALM_MASK_SHIFT	3
#define SC8551_TSBUS_TSBAT_ALM_MASK_ENABLE	1
#define SC8551_TSBUS_TSBAT_ALM_MASK_DISABLE	0

#define SC8551_TSBAT_FLT_MASK_MASK		0x04
#define SC8551_TSBAT_FLT_MASK_SHIFT		2
#define SC8551_TSBAT_FLT_MASK_ENABLE		1
#define SC8551_TSBAT_FLT_MASK_DISABLE		0

#define SC8551_TSBUS_FLT_MASK_MASK		0x02
#define SC8551_TSBUS_FLT_MASK_SHIFT		1
#define SC8551_TSBUS_FLT_MASK_ENABLE		1
#define SC8551_TSBUS_FLT_MASK_DISABLE		0

#define SC8551_TDIE_ALM_MASK_MASK		0x01
#define SC8551_TDIE_ALM_MASK_SHIFT		0
#define SC8551_TDIE_ALM_MASK_ENABLE		1
#define SC8551_TDIE_ALM_MASK_DISABLE		0

/* Register 13h */
#define SC8551_REG_13				0x13
#define SC8551_DEV_ID_MASK			0xFF
#define SC8551_DEV_ID_SHIFT			0
#define SC8551_DEV_ID				0x51

/* Register 14h */
#define SC8551_REG_14				0x14
#define SC8551_ADC_EN_MASK			0x80
#define SC8551_ADC_EN_SHIFT			7
#define SC8551_ADC_ENABLE			1
#define SC8551_ADC_DISABLE			0

#define SC8551_ADC_RATE_MASK			0x40
#define SC8551_ADC_RATE_SHIFT			6
#define SC8551_ADC_RATE_CONTINUOUS		0
#define SC8551_ADC_RATE_ONESHOT			1

#define SC8551_IBUS_ADC_DIS_MASK		0x01
#define SC8551_IBUS_ADC_DIS_SHIFT		0
#define SC8551_IBUS_ADC_ENABLE			0
#define SC8551_IBUS_ADC_DISABLE			1

/* Register 15h */
#define SC8551_REG_15				0x15
#define SC8551_VBUS_ADC_DIS_MASK		0x80
#define SC8551_VBUS_ADC_DIS_SHIFT		7
#define SC8551_VBUS_ADC_ENABLE			0
#define SC8551_VBUS_ADC_DISABLE			1

#define SC8551_VAC_ADC_DIS_MASK			0x40
#define SC8551_VAC_ADC_DIS_SHIFT		6
#define SC8551_VAC_ADC_ENABLE			0
#define SC8551_VAC_ADC_DISABLE			1

#define SC8551_VOUT_ADC_DIS_MASK		0x20
#define SC8551_VOUT_ADC_DIS_SHIFT		5
#define SC8551_VOUT_ADC_ENABLE			0
#define SC8551_VOUT_ADC_DISABLE			1

#define SC8551_VBAT_ADC_DIS_MASK		0x10
#define SC8551_VBAT_ADC_DIS_SHIFT		4
#define SC8551_VBAT_ADC_ENABLE			0
#define SC8551_VBAT_ADC_DISABLE			1

#define SC8551_IBAT_ADC_DIS_MASK		0x08
#define SC8551_IBAT_ADC_DIS_SHIFT		3
#define SC8551_IBAT_ADC_ENABLE			0
#define SC8551_IBAT_ADC_DISABLE			1

#define SC8551_TSBUS_ADC_DIS_MASK		0x04
#define SC8551_TSBUS_ADC_DIS_SHIFT		2
#define SC8551_TSBUS_ADC_ENABLE			0
#define SC8551_TSBUS_ADC_DISABLE		1

#define SC8551_TSBAT_ADC_DIS_MASK		0x02
#define SC8551_TSBAT_ADC_DIS_SHIFT		1
#define SC8551_TSBAT_ADC_ENABLE			0
#define SC8551_TSBAT_ADC_DISABLE		1

#define SC8551_TDIE_ADC_DIS_MASK		0x01
#define SC8551_TDIE_ADC_DIS_SHIFT		0
#define SC8551_TDIE_ADC_ENABLE			0
#define SC8551_TDIE_ADC_DISABLE			1

/* Register 16h */
#define SC8551_REG_16				0x16
#define SC8551_IBUS_POL_H_MASK			0x0F

/* Register 17h */
#define SC8551_REG_17				0x17
#define SC8551_IBUS_POL_L_MASK			0xFF

/* Register 18h */
#define SC8551_REG_18				0x18
#define SC8551_VBUS_POL_H_MASK			0x0F

/* Register 19h */
#define SC8551_REG_19				0x19
#define SC8551_VBUS_POL_L_MASK			0xFF

/* Register 1Ah */
#define SC8551_REG_1A				0x1A
#define SC8551_VAC_POL_H_MASK			0x0F

/* Register 1Bh */
#define SC8551_REG_1B				0x1B
#define SC8551_VAC_POL_L_MASK			0xFF

/* Register 1Ch */
#define SC8551_REG_1C				0x1C
#define SC8551_VOUT_POL_H_MASK			0x0F

/* Register 1Dh */
#define SC8551_REG_1D				0x1D
#define SC8551_VOUT_POL_L_MASK			0x0F

/* Register 1Eh */
#define SC8551_REG_1E				0x1E
#define SC8551_VBAT_POL_H_MASK			0x0F

/* Register 1Fh */
#define SC8551_REG_1F				0x1F
#define SC8551_VBAT_POL_L_MASK			0xFF

/* Register 20h */
#define SC8551_REG_20				0x20
#define SC8551_IBAT_POL_H_MASK			0x0F

/* Register 21h */
#define SC8551_REG_21				0x21
#define SC8551_IBAT_POL_L_MASK			0xFF

/* Register 26h */
#define SC8551_REG_26				0x26
#define SC8551_TDIE_POL_H_MASK			0x01

/* Register 27h */
#define SC8551_REG_27				0x27
#define SC8551_TDIE_POL_L_MASK			0xFF

/* Register 2Bh */
#define SC8551_REG_2B				0x2B
#define SC8551_SS_TIMEOUT_SET_MASK		0xE0
#define SC8551_SS_TIMEOUT_SET_SHIFT		5
#define SC8551_SS_TIMEOUT_DISABLE		0
#define SC8551_SS_TIMEOUT_40MS			1
#define SC8551_SS_TIMEOUT_80MS			2
#define SC8551_SS_TIMEOUT_320MS			3
#define SC8551_SS_TIMEOUT_1280MS		4
#define SC8551_SS_TIMEOUT_5120MS		5
#define SC8551_SS_TIMEOUT_20480MS		6
#define SC8551_SS_TIMEOUT_81920MS		7

#define SC8551_EN_REGULATION_MASK		0x10
#define SC8551_EN_REGULATION_SHIFT		4
#define SC8551_EN_REGULATION_ENABLE		1
#define SC8551_EN_REGULATION_DISABLE		0

#define SC8551_VOUT_OVP_DIS_MASK		0x08
#define SC8551_VOUT_OVP_DIS_SHIFT		3
#define SC8551_VOUT_OVP_ENABLE			1
#define SC8551_VOUT_OVP_DISABLE			0

#define SC8551_IBUS_UCP_RISE_TH_MASK		0x04
#define SC8551_IBUS_UCP_RISE_TH_SHIFT		2
#define SC8551_IBUS_UCP_RISE_150MA		0
#define SC8551_IBUS_UCP_RISE_250MA		1

#define SC8551_SET_IBAT_SNS_RES_MASK		0x02
#define SC8551_SET_IBAT_SNS_RES_SHIFT		1
#define SC8551_SET_IBAT_SNS_RES_2MHM		0
#define SC8551_SET_IBAT_SNS_RES_5MHM		1

#define SC8551_VAC_PD_EN_MASK			0x01
#define SC8551_VAC_PD_EN_SHIFT			0
#define SC8551_VAC_PD_ENABLE			1
#define SC8551_VAC_PD_DISABLE			0

/* Register 2Ch */
#define SC8551_REG_2C				0x2C
#define SC8551_IBAT_REG_MASK			0xC0
#define SC8551_IBAT_REG_SHIFT			6
#define SC8551_IBAT_REG_200MA			0
#define SC8551_IBAT_REG_300MA			1
#define SC8551_IBAT_REG_400MA			2
#define SC8551_IBAT_REG_500MA			3
#define SC8551_VBAT_REG_MASK			0x30
#define SC8551_VBAT_REG_SHIFT			4
#define SC8551_VBAT_REG_50MV			0
#define SC8551_VBAT_REG_100MV			1
#define SC8551_VBAT_REG_150MV			2
#define SC8551_VBAT_REG_200MV			3

#define SC8551_VBAT_REG_ACTIVE_STAT_MASK	0x08
#define SC8551_IBAT_REG_ACTIVE_STAT_MASK	0x04
#define SC8551_VDROP_OVP_ACTIVE_STAT_MASK	0x02
#define SC8551_VOUT_OVP_ACTIVE_STAT_MASK	0x01

#define SC8551_REG_2D				0x2D
#define SC8551_VBAT_REG_ACTIVE_FLAG_MASK	0x80
#define SC8551_IBAT_REG_ACTIVE_FLAG_MASK	0x40
#define SC8551_VDROP_OVP_FLAG_MASK		0x20
#define SC8551_VOUT_OVP_FLAG_MASK		0x10
#define SC8551_VBAT_REG_ACTIVE_MASK_MASK	0x08
#define SC8551_IBAT_REG_ACTIVE_MASK_MASK	0x04
#define SC8551_VDROP_OVP_MASK_MASK		0x02
#define SC8551_VOUT_OVP_MASK_MASK		0x01

#define SC8551_REG_2E				0x2E
#define SC8551_IBUS_LOW_DG_MASK			0x08
#define SC8551_IBUS_LOW_DG_SHIFT		3
#define SC8551_IBUS_LOW_DG_10US			0
#define SC8551_IBUS_LOW_DG_5MS			1

#define SC8551_REG_2F				0x2F
#define SC8551_PMID2OUT_UVP_FLAG_MASK		0x08
#define SC8551_PMID2OUT_OVP_FLAG_MASK		0x04
#define SC8551_PMID2OUT_UVP_STAT_MASK		0x02
#define SC8551_PMID2OUT_OVP_STAT_MASK		0x01

#define SC8551_REG_30				0x30
#define SC8551_IBUS_REG_EN_MASK			0x80
#define SC8551_IBUS_REG_EN_SHIFT		7
#define SC8551_IBUS_REG_ENABLE			1
#define SC8551_IBUS_REG_DISABLE			0
#define SC8551_IBUS_REG_ACTIVE_STAT_MASK	0x40
#define SC8551_IBUS_REG_ACTIVE_FLAG_MASK	0x20
#define SC8551_IBUS_REG_ACTIVE_MASK_MASK	0x10
#define SC8551_IBUS_REG_ACTIVE_MASK_SHIFT	4
#define SC8551_IBUS_REG_ACTIVE_NOT_MASK		0
#define SC8551_IBUS_REG_ACTIVE_MASK		1
#define SC8551_IBUS_REG_MASK			0x0F
#define SC8551_IBUS_REG_SHIFT			0
#define SC8551_IBUS_REG_BASE			1000
#define SC8551_IBUS_REG_LSB			250

#define SC8551_REG_31				0x31
#define SC8551_CHARGE_MODE_MASK			0x01
#define SC8551_CHARGE_MODE_SHIFT		0
#define SC8551_CHARGE_MODE_2_1			0
#define SC8551_CHARGE_MODE_1_1			1

#endif
