/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Unisoc UMS9621 platform clocks
 *
 * Copyright (C) 2022, Unisoc Inc.
 */


#ifndef __DT_BINDINGS_SPRD_QOGIRL6_REGS_H
#define __DT_BINDINGS_SPRD_QOGIRL6_REGS_H

#define REG_AON_APB_APB_EB0                                 0x0000
#define REG_AON_APB_APB_EB1                                 0x0004
#define REG_AON_APB_APB_EB2                                 0x0008
#define REG_AON_APB_APB_RST0                                0x000C
#define REG_AON_APB_APB_RST1                                0x0010
#define REG_AON_APB_APB_RST2                                0x0014
#define REG_AON_APB_APB_RTC_EB0                             0x0018
#define REG_AON_APB_PWR_CTRL                                0x0024
#define REG_AON_APB_TS_CFG                                  0x0028
#define REG_AON_APB_BOOT_MODE                               0x002C
#define REG_AON_APB_BB_BG_CTRL                              0x0030
#define REG_AON_APB_CP_ARM_JTAG_CTRL                        0x0034
#define REG_AON_APB_DCXO_LC_REG0                            0x003C
#define REG_AON_APB_DCXO_LC_REG1                            0x0040
#define REG_AON_APB_AUDCP_BOOT_PROT                         0x0078
#define REG_AON_APB_AON_REG_PROT                            0x007C
#define REG_AON_APB_AON_APB_CLK_SEL                         0x0080
#define REG_AON_APB_DAP_DJTAG_SEL                           0x0084
#define REG_AON_APB_USER_RSV_FLAG1                          0x0088
#define REG_AON_APB_CM4_SYS_SOFT_RST                        0x008C
#define REG_AON_APB_AUTO_GATE_CTRL0                         0x00D0
#define REG_AON_APB_AUTO_GATE_CTRL1                         0x00D4
#define REG_AON_APB_AP_AXI_CTRL                             0x00D8
#define REG_AON_APB_AON_CHIP_ID0                            0x00E0
#define REG_AON_APB_AON_CHIP_ID1                            0x00E4
#define REG_AON_APB_AON_PLAT_ID0                            0x00E8
#define REG_AON_APB_AON_PLAT_ID1                            0x00EC
#define REG_AON_APB_AON_IMPL_ID                             0x00F0
#define REG_AON_APB_AON_MFT_ID                              0x00F4
#define REG_AON_APB_AON_VER_ID                              0x00F8
#define REG_AON_APB_AON_CHIP_ID                             0x00FC
#define REG_AON_APB_CCIR_RCVR_CFG                           0x0100
#define REG_AON_APB_PLL_BG_CFG                              0x0108
#define REG_AON_APB_LVDSDIS_SEL                             0x010C
#define REG_AON_APB_AUTO_GATE_CTRL2                         0x0114
#define REG_AON_APB_AUTO_GATE_CTRL3                         0x0118
#define REG_AON_APB_APCPU_CTRL0                             0x011C
#define REG_AON_APB_SP_CFG_BUS                              0x0124
#define REG_AON_APB_APB_RST3                                0x0130
#define REG_AON_APB_RC100M_CFG                              0x0134
#define REG_AON_APB_CGM_REG1                                0x0138
#define REG_AON_APB_CGM_CLK_TOP_REG1                        0x013C
#define REG_AON_APB_AUDCP_DSP_CTRL0                         0x0140
#define REG_AON_APB_AUDCP_DSP_CTRL1                         0x0144
#define REG_AON_APB_AUDCP_CTRL                              0x014C
#define REG_AON_APB_WTLCP_LDSP_CTRL0                        0x0150
#define REG_AON_APB_WTLCP_LDSP_CTRL1                        0x0154
#define REG_AON_APB_WTLCP_TDSP_CTRL0                        0x0158
#define REG_AON_APB_WTLCP_TDSP_CTRL1                        0x015C
#define REG_AON_APB_WTLCP_CTRL                              0x0164
#define REG_AON_APB_WTL_WCDMA_EB                            0x0168
#define REG_AON_APB_PCP_AON_EB                              0x0170
#define REG_AON_APB_PCP_SOFT_RST                            0x0174
#define REG_AON_APB_PUBCP_CTRL                              0x0178
#define REG_AON_APB_WTLCP_LPC_CTRL                          0x0180
#define REG_AON_APB_PUBCP_LPC_CTRL                          0x0184
#define REG_AON_APB_AON_SOC_USB_CTRL                        0x0190
#define REG_AON_APB_SOFT_RST_AON_ADD1                       0x01A0
#define REG_AON_APB_VDSP_INT_CTRL                           0x01A4
#define REG_AON_APB_EB_AON_ADD1                             0x01B0
#define REG_AON_APB_DBG_DJTAG_CTRL                          0x01C0
#define REG_AON_APB_MBIST_EFUSE_CTRL                        0x01FC
#define REG_AON_APB_OTG_PHY_TUNE                            0x0200
#define REG_AON_APB_OTG_PHY_TEST                            0x0204
#define REG_AON_APB_OTG_PHY_CTRL                            0x0208
#define REG_AON_APB_OTG_CTRL1                               0x0210
#define REG_AON_APB_USB_CLK_REF_SEL                         0x0214
#define REG_AON_APB_LVDSRF_CTRL                             0x0218
#define REG_AON_APB_THM0_CTRL                               0x021C
#define REG_AON_APB_THM1_CTRL                               0x0220
#define REG_AON_APB_THM2_CTRL                               0x0224
#define REG_AON_APB_OVERHEAT_CTRL                           0x022C
#define REG_AON_APB_PUBCP_SIM1_TOP_CTRL                     0x0230
#define REG_AON_APB_PUBCP_SIM2_TOP_CTRL                     0x0234
#define REG_AON_APB_PUBCP_SIM3_TOP_CTRL                     0x0238
#define REG_AON_APB_AP_SIM_TOP_CTRL                         0x023C
#define REG_AON_APB_TOP_PU_NUM_CTRL1                        0x0250
#define REG_AON_APB_TOP_PU_NUM_CTRL2                        0x0254
#define REG_AON_APB_TOP_PU_NUM_CTRL3                        0x0258
#define REG_AON_APB_TOP_PU_NUM_CTRL4                        0x025C
#define REG_AON_APB_TOP_PU_NUM_CTRL5                        0x0260
#define REG_AON_APB_TOP_PU_NUM_CTRL6                        0x0264
#define REG_AON_APB_TOP_PU_NUM_CTRL7                        0x0268
#define REG_AON_APB_TOP_PU_NUM_CTRL8                        0x026C
#define REG_AON_APB_TOP_PU_NUM_CTRL9                        0x0270
#define REG_AON_APB_APCPU_MONITOR_STATUS                    0x0280
#define REG_AON_APB_APCPU_DEBUG_PWR_LP_CTRL                 0x0284
#define REG_AON_APB_APCPU_GIC_COL_LP_CTRL                   0x0288
#define REG_AON_APB_APCPU_CLUSTER_ATB_LPC_CTRL              0x028C
#define REG_AON_APB_APCPU_CLUSTER_APB_LPC_CTRL              0x0290
#define REG_AON_APB_APCPU_CLUSTER_GIC_LPC_CTRL              0x0294
#define REG_AON_APB_APCPU_GIC600_GIC_LPC_CTRL               0x0298
#define REG_AON_APB_APCPU_DBG_BLK_LPC_CTRL                  0x029C
#define REG_AON_APB_APCPU_TOP_MTX_M0_LPC_CTRL               0x0300
#define REG_AON_APB_APCPU_PU_NUM_CTRL                       0x0304
#define REG_AON_APB_APCPU_CLUSTER_SCU_LPC_CTRL              0x0320
#define REG_AON_APB_APCPU_DDR_AB_LPC_CTRL                   0x0324
#define REG_AON_APB_APCPU_QOS_CTRL                          0x0328
#define REG_AON_APB_MPLL0_CTRL                              0x032C
#define REG_AON_APB_MPLL1_CTRL                              0x0330
#define REG_AON_APB_MPLL2_CTRL                              0x0334
#define REG_AON_APB_DPLL_CTRL                               0x0340
#define REG_AON_APB_PUB_CLK_GATING_CTRL                     0x0344
#define REG_AON_APB_DDRPHY_VREP                             0x0348
#define REG_AON_APB_WCN_SDIO_CTRL0                          0x034C
#define REG_AON_APB_WCN_SDIO_CTRL1                          0x0350
#define REG_AON_APB_WCN_SDIO_CTRL2                          0x0354
#define REG_AON_APB_WCN_SDIO_CTRL3                          0x0358
#define REG_AON_APB_WCN_SDIO_STAT0                          0x035C
#define REG_AON_APB_WCN_SDIO_STAT1                          0x0360
#define REG_AON_APB_WCN_SDIO_STAT2                          0x0364
#define REG_AON_APB_WCN_SDIO_STAT3                          0x0368
#define REG_AON_APB_AON_MTX_M7_LPC_CTRL                     0x036C
#define REG_AON_APB_AON_MTX_S10_LPC_CTRL                    0x0370
#define REG_AON_APB_USB_UART_JTAG_MUX                       0x0374
#define REG_AON_APB_PUBCP2WTL_ASYNC_BRIDGE_LPC_CTRL         0x037C
#define REG_AON_APB_CM42AON_LPC_CTRL                        0x0380
#define REG_AON_APB_AON_MTX_MAIN_LPC_CTRL                   0x0384
#define REG_AON_APB_AON_MTX_M0_LPC_CTRL                     0x0388
#define REG_AON_APB_AON_MTX_M1_LPC_CTRL                     0x038C
#define REG_AON_APB_AON_MTX_M2_LPC_CTRL                     0x0390
#define REG_AON_APB_AON_MTX_M3_LPC_CTRL                     0x0394
#define REG_AON_APB_AON_MTX_M4_LPC_CTRL                     0x0398
#define REG_AON_APB_AON_MTX_M5_LPC_CTRL                     0x039C
#define REG_AON_APB_AON_MTX_M6_LPC_CTRL                     0x03A0
#define REG_AON_APB_AON_MTX_S0_LPC_CTRL                     0x03A4
#define REG_AON_APB_AON_MTX_S1_LPC_CTRL                     0x03A8
#define REG_AON_APB_AON_MTX_S2_LPC_CTRL                     0x03AC
#define REG_AON_APB_AON_MTX_S3_LPC_CTRL                     0x03B0
#define REG_AON_APB_AON_MTX_S4_LPC_CTRL                     0x03B4
#define REG_AON_APB_AON_MTX_S5_LPC_CTRL                     0x03B8
#define REG_AON_APB_AON_MTX_S6_LPC_CTRL                     0x03BC
#define REG_AON_APB_AON_MTX_S7_LPC_CTRL                     0x03C0
#define REG_AON_APB_AON_MTX_S8_LPC_CTRL                     0x03C4
#define REG_AON_APB_AON_MTX_S9_LPC_CTRL                     0x03C8
#define REG_AON_APB_AP2GPU_SLI_LPC_CTRL                     0x03CC
#define REG_AON_APB_AP2MM_SLI_LPC_CTRL                      0x03D0
#define REG_AON_APB_WTLCP2DDR_SLI_LPC_CTRL                  0x03D4
#define REG_AON_APB_APCPU2AP_SLI_LPC_CTRL                   0x03D8
#define REG_AON_APB_AUDCP2DDR_SLI_LPC_CTRL                  0x03DC
#define REG_AON_APB_APCPU2DDR_SLI_LPC_CTRL                  0x03E0
#define REG_AON_APB_AON2DDR_BRG_LPC_CTRL                    0x03E4
#define REG_AON_APB_PUBCP2WTLCP_SLI_LPC_CTRL                0x03E8
#define REG_AON_APB_DCAM2DDR_SLI_LPC_CTRL                   0x03EC
#define REG_AON_APB_DPU2DDR_SLI_LPC_CTRL                    0x03F0
#define REG_AON_APB_GPU2DDR_SLI_LPC_CTRL                    0x03F4
#define REG_AON_APB_ISP2DDR_SLI_LPC_CTRL                    0x03F8
#define REG_AON_APB_AP2DDR_SLI_LPC_CTRL                     0x03FC
#define REG_AON_APB_AON_APB_FREQ_CTRL                       0x0400
#define REG_AON_APB_C2G_ANALOG_BB_TOP_CLK26MHZ_AUD_EN       0x0404
#define REG_AON_APB_MIPI_CSI_POWER_CTRL                     0x0408
#define REG_AON_APB_SINDRV_POWER_CTRL                       0x040C
#define REG_AON_APB_AP_EMMC_PHY_CTRL                        0x0440
#define REG_AON_APB_AP_SDIO0_PHY_CTRL                       0x0444
#define REG_AON_APB_AP_SDIO1_PHY_CTRL                       0x0448
#define REG_AON_APB_AP_SDIO2_PHY_CTRL                       0x044C
#define REG_AON_APB_PUBCP_SDIO0_PHY_CTRL                    0x0450
#define REG_AON_APB_APCPU_INT_ENABLE_CTRL0                  0x0500
#define REG_AON_APB_APCPU_INT_ENABLE_CTRL1                  0x0504
#define REG_AON_APB_APCPU_INT_ENABLE_CTRL2                  0x0508
#define REG_AON_APB_APCPU_INT_ENABLE_CTRL3                  0x050C
#define REG_AON_APB_APCPU_INT_ENABLE_CTRL4                  0x0510
#define REG_AON_APB_APCPU_INT_ENABLE_CTRL5                  0x0514
#define REG_AON_APB_WDG_RST_FLAG                            0x0824
#define REG_AON_APB_BOND_OPT0                               0x083C
#define REG_AON_APB_DEVICE_LIFE_CYCLE                       0x0840
#define REG_AON_APB_RES_REG0                                0x0844
#define REG_AON_APB_RES_REG1                                0x0848
#define REG_AON_APB_RES_REG2                                0x084C
#define REG_AON_APB_RES_REG3                                0x0850
#define REG_AON_APB_RES_REG4                                0x0854
#define REG_AON_APB_AON_MTX_PROT_CFG                        0x0858
#define REG_AON_APB_PLL_LOCK_OUT_SEL                        0x0864
#define REG_AON_APB_CPU2DDR_BRIDGE_DEBUG_SIGNAL_R           0x0870
#define REG_AON_APB_AON2DDR_BRIDGE_DEBUG_SIGNAL_W           0x0874
#define REG_AON_APB_AON2DDR_BRIDGE_DEBUG_SIGNAL_LIST        0x0878
#define REG_AON_APB_AUD2DDR_BRIDGE_DEBUG_SIGNAL_R           0x087C
#define REG_AON_APB_PUBCP2WTL_BRIDGE_DEBUG_SIGNAL_R         0x0884
#define REG_AON_APB_LEAKAGE_MAGIC_WORD                      0x0900
#define REG_AON_APB_LEAKAGE_SWITCH                          0x0904
#define REG_AON_APB_FUNC_TEST_BOOT_ADDR                     0x0910
#define REG_AON_APB_CGM_RESCUE                              0x0914
#define REG_AON_APB_AON_SDIO                                0x092C
#define REG_AON_APB_SP_WAKEUP_MASK_EN0                      0x0984
#define REG_AON_APB_SP_WAKEUP_MASK_EN1                      0x0988
#define REG_AON_APB_SP_WAKEUP_MASK_EN2                      0x098C
#define REG_AON_APB_DBG_BUS_DATA_WTLCP                      0x0990
#define REG_AON_APB_DBG_BUS_DATA_PUBCP                      0x0994
#define REG_AON_APB_DBG_BUS_DATA_AUDCP                      0x0998
#define REG_AON_APB_SCC_DBG_BUS                             0x0A00
#define REG_AON_APB_AON_FUNC_CTRL_0                         0x0A04
#define REG_AON_APB_AON_FUNC_CTRL_1                         0x0A08
#define REG_AON_APB_WDG_RST_FLAG_CLR                        0x3024
#define REG_AON_DBG_APB_APCPU_COMM_CTRL                     0x0000
#define REG_AON_DBG_APB_APCPU_PROT_CTRL                     0x0004
#define REG_AON_DBG_APB_CSSYS_CFG                           0x0008
#define REG_AON_DBG_APB_CR5_PROT_CTRL                       0x000C
#define REG_AON_DBG_APB_APCPU_PROT_CTRL_NON_SEC             0x0010
#define REG_AON_DBG_APB_CSSYS_CFG_NON_SEC                   0x0014
#define REG_AON_DBG_APB_CR5_PROT_CTRL_NON_SEC               0x0018
#define REG_AON_DBG_APB_DEBUG_BOND_OPTION                   0x001C
#define REG_AP_AHB_AHB_EB                                   0x0000
#define REG_AP_AHB_AHB_RST                                  0x0004
#define REG_AP_AHB_AP_SYS_FORCE_SLEEP_CFG                   0x000C
#define REG_AP_AHB_AP_SYS_AUTO_SLEEP_CFG                    0x0010
#define REG_AP_AHB_HOLDING_PEN                              0x0014
#define REG_AP_AHB_CLOCK_FREQUENCY_DOWN                     0x0018
#define REG_AP_AHB_UFS_CLK_EN_FORCE_ON_OFF                  0x001C
#define REG_AP_AHB_AP_SYS_CLK_EN_FRC_OFF_0                  0x0020
#define REG_AP_AHB_AP_SYS_CLK_EN_FRC_OFF_1                  0x0024
#define REG_AP_AHB_AP_SYS_CLK_EN_FRC_ON_0                   0x0028
#define REG_AP_AHB_AP_SYS_CLK_EN_FRC_ON_1                   0x002C
#define REG_AP_AHB_MISC_CKG_EN                              0x0040
#define REG_AP_AHB_DISP_ASYNC_BRG                           0x0050
#define REG_AP_AHB_AP_ASYNC_BRG                             0x005C
#define REG_AP_AHB_M0_LPC                                   0x0060
#define REG_AP_AHB_M1_LPC                                   0x0064
#define REG_AP_AHB_M2_LPC                                   0x0068
#define REG_AP_AHB_M3_LPC                                   0x006C
#define REG_AP_AHB_M4_LPC                                   0x0070
#define REG_AP_AHB_M5_LPC                                   0x0074
#define REG_AP_AHB_M6_LPC                                   0x0078
#define REG_AP_AHB_M7_LPC                                   0x007C
#define REG_AP_AHB_MAIN_LPC                                 0x0088
#define REG_AP_AHB_S0_LPC                                   0x008C
#define REG_AP_AHB_S1_LPC                                   0x0090
#define REG_AP_AHB_S2_LPC                                   0x0094
#define REG_AP_AHB_S3_LPC                                   0x0098
#define REG_AP_AHB_S4_LPC                                   0x009C
#define REG_AP_AHB_S5_LPC                                   0x0058
#define REG_AP_AHB_S6_LPC                                   0x0054
#define REG_AP_AHB_MERGE_M0_LPC                             0x00A0
#define REG_AP_AHB_MERGE_M1_LPC                             0x00A4
#define REG_AP_AHB_MERGE_S0_LPC                             0x00AC
#define REG_AP_AHB_AP_QOS0                                  0x00B0
#define REG_AP_AHB_AP_QOS1                                  0x00B8
#define REG_AP_AHB_AP_QOS2                                  0x00BC
#define REG_AP_AHB_ASYNC_BRIDGE_IDLE_OVERFLOW               0x00C0
#define REG_AP_AHB_ASYNC_BRIDGE_DEBUG_SIGNAL_W_DISP         0x00C8
#define REG_AP_AHB_ASYNC_BRIDGE_DEBUG_SIGNAL_W_AP           0x00CC
#define REG_AP_AHB_SYS_RST                                  0x3010
#define REG_AP_AHB_CACHE_EMMC_SDIO                          0x3014
#define REG_AP_AHB_CACHE_UFS                                0x3018
#define REG_AP_AHB_AP_QOS_CFG                               0x301C
#define REG_AP_AHB_DSI_PHY                                  0x3034
#define REG_AP_AHB_CHIP_ID                                  0x30FC
#define REG_AP_AHB_UFS_LP_CTRL_0                            0x3100
#define REG_AP_AHB_UFS_LP_CTRL_1                            0x3104
#define REG_AP_AHB_UFS_CONTROLLER                           0x3108
#define REG_AP_AHB_MPHY_TX_TEST_OBSERVE                     0x310C
#define REG_AP_AHB_MPHY_RX_TEST_OBSERVE                     0x3110
#define REG_AP_AHB_MPHY_CB_TEST_OBSERVE                     0x3114
#define REG_AP_AHB_MPHY_RESERVE_IO                          0x3118
#define REG_AP_AHB_MPHY_CB_CHANNEL_0                        0x311C
#define REG_AP_AHB_MPHY_CB_CHANNEL_1                        0x3120
#define REG_AP_AHB_UFS_CLK_CTRL                             0x3124
#define REG_AP_AHB_MTX_BUS_EN                               0x3128
#define REG_AP_AHB_UFS_CONTROLLER_STATUS                    0x312C
#define REG_AP_APB_APB_EB                                   0x0000
#define REG_AP_APB_APB_RST                                  0x0004
#define REG_AP_APB_APB_MISC_CTRL                            0x0008
#define REG_AP_APB_APB_EB1                                  0x000C
#define REG_GPU_APB_GONDUL_PDC_CONTROL_STACK0               0x002C
#define REG_PMU_APB_AON_MEM_CTRL                            0x0000
#define REG_PMU_APB_MEM_AUTO_SD_CFG0                        0x0004
#define REG_PMU_APB_MEM_AUTO_SD_CFG1                        0x0008
#define REG_PMU_APB_MEM_AUTO_SLP_CFG0                       0x0010
#define REG_PMU_APB_MEM_AUTO_SLP_CFG1                       0x0014
#define REG_PMU_APB_MEM_SD_CFG0                             0x001C
#define REG_PMU_APB_MEM_SD_CFG1                             0x0020
#define REG_PMU_APB_MEM_SLP_CFG0                            0x0028
#define REG_PMU_APB_MEM_SLP_CFG1                            0x002C
#define REG_PMU_APB_RAM_PD_EN_CTRL                          0x0034
#define REG_PMU_APB_RAM_SLP_EN_CTRL                         0x003C
#define REG_PMU_APB_RAM_FORCE_PD_CFG_0                      0x0044
#define REG_PMU_APB_RAM_FORCE_SLP_CFG                       0x0054
#define REG_PMU_APB_RAM_FORCE_ON_CFG                        0x0060
#define REG_PMU_APB_SRAM_DLY_CTRL_CFG                       0x006C
#define REG_PMU_APB_APCPU_CORE_WAKEUP_EN                    0x008C
#define REG_PMU_APB_APCPU_SOFT_INT_GEN                      0x0090
#define REG_PMU_APB_APCPU_CORE_FORCE_STOP                   0x0094
#define REG_PMU_APB_APCPU_CSYSPWRUP_WAKEUP_EN_CFG           0x0098
#define REG_PMU_APB_ANALOG_PHY_PWRDOWN_CFG                  0x009C
#define REG_PMU_APB_ANALOG_PHY_PWRON_CFG                    0x00A0
#define REG_PMU_APB_ANALOG_PHY_PWR_DLY_CFG                  0x00A4
#define REG_PMU_APB_BISR_FORCE_SEL_0                        0x00F8
#define REG_PMU_APB_BISR_FORCE_SEL_1                        0x00FC
#define REG_PMU_APB_BISR_FORCE_SEL_2                        0x0100
#define REG_PMU_APB_BISR_BYP_CFG_0                          0x0108
#define REG_PMU_APB_BISR_BYP_CFG_1                          0x010C
#define REG_PMU_APB_BISR_BYP_CFG_2                          0x0110
#define REG_PMU_APB_BISR_EN_CFG_0                           0x0118
#define REG_PMU_APB_BISR_EN_CFG_1                           0x011C
#define REG_PMU_APB_BISR_EN_CFG_2                           0x0120
#define REG_PMU_APB_BISR_DONE_STATUS_0                      0x0128
#define REG_PMU_APB_BISR_DONE_STATUS_1                      0x012C
#define REG_PMU_APB_BISR_DONE_STATUS_2                      0x0130
#define REG_PMU_APB_BISR_BUSY_STATUS_0                      0x0138
#define REG_PMU_APB_BISR_BUSY_STATUS_1                      0x013C
#define REG_PMU_APB_BISR_BUSY_STATUS_2                      0x0140
#define REG_PMU_APB_DVFS_BLOCK_SHUTDOWN_CFG                 0x014C
#define REG_PMU_APB_DCDC_CPU0_PWR_DLY_CFG                   0x0150
#define REG_PMU_APB_DCDC_CPU1_PWR_DLY_CFG                   0x0154
#define REG_PMU_APB_PD_DCDC_CPU1_DCDC_CFG                   0x017C
#define REG_PMU_APB_APCPU_CORE0_DSLP_ENA                    0x01B8
#define REG_PMU_APB_APCPU_CORE1_DSLP_ENA                    0x01BC
#define REG_PMU_APB_APCPU_CORE2_DSLP_ENA                    0x01C0
#define REG_PMU_APB_APCPU_CORE3_DSLP_ENA                    0x01C4
#define REG_PMU_APB_APCPU_CORE4_DSLP_ENA                    0x01C8
#define REG_PMU_APB_APCPU_CORE5_DSLP_ENA                    0x01CC
#define REG_PMU_APB_APCPU_CORE6_DSLP_ENA                    0x01D0
#define REG_PMU_APB_APCPU_CORE7_DSLP_ENA                    0x01D4
#define REG_PMU_APB_AUDCP_AUDDSP_DSLP_ENA                   0x01F8
#define REG_PMU_APB_WTLCP_LDSP_DSLP_ENA                     0x0204
#define REG_PMU_APB_WTLCP_TGDSP_DSLP_ENA                    0x0208
#define REG_PMU_APB_APCPU_CORE0_INT_DISABLE                 0x0218
#define REG_PMU_APB_APCPU_CORE1_INT_DISABLE                 0x021C
#define REG_PMU_APB_APCPU_CORE2_INT_DISABLE                 0x0220
#define REG_PMU_APB_APCPU_CORE3_INT_DISABLE                 0x0224
#define REG_PMU_APB_APCPU_CORE4_INT_DISABLE                 0x0228
#define REG_PMU_APB_APCPU_CORE5_INT_DISABLE                 0x022C
#define REG_PMU_APB_APCPU_CORE6_INT_DISABLE                 0x0230
#define REG_PMU_APB_APCPU_CORE7_INT_DISABLE                 0x0234
#define REG_PMU_APB_AUDCP_AUDDSP_CORE_INT_DISABLE           0x0258
#define REG_PMU_APB_WTLCP_LDSP_CORE_INT_DISABLE             0x0264
#define REG_PMU_APB_WTLCP_TGDSP_CORE_INT_DISABLE            0x0268
#define REG_PMU_APB_GIC_CFG                                 0x0278
#define REG_PMU_APB_PD_AP_CFG_0                             0x027C
#define REG_PMU_APB_PD_APCPU_TOP_CFG_0                      0x0280
#define REG_PMU_APB_PD_APCPU_CORE0_CFG_0                    0x0284
#define REG_PMU_APB_PD_APCPU_CORE1_CFG_0                    0x0288
#define REG_PMU_APB_PD_APCPU_CORE2_CFG_0                    0x028C
#define REG_PMU_APB_PD_APCPU_CORE3_CFG_0                    0x0290
#define REG_PMU_APB_PD_APCPU_CORE4_CFG_0                    0x0294
#define REG_PMU_APB_PD_APCPU_CORE5_CFG_0                    0x0298
#define REG_PMU_APB_PD_APCPU_CORE6_CFG_0                    0x029C
#define REG_PMU_APB_PD_APCPU_CORE7_CFG_0                    0x02A0
#define REG_PMU_APB_PD_GPU_TOP_CFG_0                        0x02C4
#define REG_PMU_APB_PD_GPU_C0_CFG_0                         0x02C8
#define REG_PMU_APB_PD_MM_CFG_0                             0x02E8
#define REG_PMU_APB_PD_AP_VSP_CFG_0                         0x0314
#define REG_PMU_APB_PD_PUBCP_CFG_0                          0x0330
#define REG_PMU_APB_PD_WTLCP_CFG_0                          0x0344
#define REG_PMU_APB_PD_WTLCP_LDSP_CFG_0                     0x0348
#define REG_PMU_APB_PD_WTLCP_TGDSP_CFG_0                    0x034C
#define REG_PMU_APB_PD_WTLCP_TD_PROC_CFG_0                  0x0354
#define REG_PMU_APB_PD_WTLCP_LTE_PROC_CFG_0                 0x0358
#define REG_PMU_APB_PD_WTLCP_LTE_CE_CFG_0                   0x035C
#define REG_PMU_APB_PD_WTLCP_LTE_DPFEC_CFG_0                0x0360
#define REG_PMU_APB_PD_WTLCP_HU3GE_A_CFG_0                  0x0364
#define REG_PMU_APB_PD_WTLCP_HU3GE_B_CFG_0                  0x0368
#define REG_PMU_APB_PD_WCN_CFG_0                            0x03A8
#define REG_PMU_APB_PD_WIFI_WRAP_CFG_0                      0x03AC
#define REG_PMU_APB_PD_WIFI_MAC_CFG_0                       0x03B0
#define REG_PMU_APB_PD_WIFI_PHY_CFG_0                       0x03B4
#define REG_PMU_APB_PD_BTWF_SS_CFG_0                        0x03B8
#define REG_PMU_APB_PD_GNSS_SS_CFG_0                        0x03BC
#define REG_PMU_APB_PD_GNSS_IP_CFG_0                        0x03C0
#define REG_PMU_APB_PD_BT_CFG_0                             0x03C4
#define REG_PMU_APB_PD_AUDCP_CFG_0                          0x03D0
#define REG_PMU_APB_PD_AUDCP_AUDDSP_CFG_0                   0x03D4
#define REG_PMU_APB_PD_PUB_CFG_0                            0x03F8
#define REG_PMU_APB_RAM_PWR_DLY_CFG_0                       0x047C
#define REG_PMU_APB_RAM_PWR_DLY_CFG_1                       0x0480
#define REG_PMU_APB_RAM_PWR_DLY_CFG_2                       0x0484
#define REG_PMU_APB_RAM_PWR_DLY_CFG_4                       0x048C
#define REG_PMU_APB_RAM_PWR_DLY_CFG_6                       0x0494
#define REG_PMU_APB_RAM_PWR_DLY_CFG_9                       0x04A0
#define REG_PMU_APB_RAM_PWR_DLY_CFG_11                      0x04A8
#define REG_PMU_APB_RAM_PWR_DLY_CFG_12                      0x04AC
#define REG_PMU_APB_RAM_PWR_DLY_CFG_13                      0x04B0
#define REG_PMU_APB_RAM_PWR_DLY_CFG_14                      0x04B4
#define REG_PMU_APB_RAM_PWR_DLY_CFG_18                      0x04C4
#define REG_PMU_APB_RAM_PWR_DLY_CFG_19                      0x04C8
#define REG_PMU_APB_RAM_PWR_DLY_CFG_20                      0x04CC
#define REG_PMU_APB_RAM_PWR_DLY_CFG_21                      0x04D0
#define REG_PMU_APB_RAM_PWR_DLY_CFG_23                      0x04D8
#define REG_PMU_APB_PWR_DBG_PARAMETER                       0x04EC
#define REG_PMU_APB_PWR_STATUS_DBG_0                        0x04F0
#define REG_PMU_APB_PWR_STATUS_DBG_1                        0x04F4
#define REG_PMU_APB_PWR_STATUS_DBG_2                        0x04F8
#define REG_PMU_APB_PWR_STATUS_DBG_4                        0x0500
#define REG_PMU_APB_PWR_STATUS_DBG_6                        0x0508
#define REG_PMU_APB_PWR_STATUS_DBG_9                        0x0514
#define REG_PMU_APB_PWR_STATUS_DBG_11                       0x051C
#define REG_PMU_APB_PWR_STATUS_DBG_12                       0x0520
#define REG_PMU_APB_PWR_STATUS_DBG_13                       0x0524
#define REG_PMU_APB_PWR_STATUS_DBG_14                       0x0528
#define REG_PMU_APB_PWR_STATUS_DBG_18                       0x0538
#define REG_PMU_APB_PWR_STATUS_DBG_19                       0x053C
#define REG_PMU_APB_PWR_STATUS_DBG_20                       0x0540
#define REG_PMU_APB_PWR_STATUS_DBG_21                       0x0544
#define REG_PMU_APB_PWR_STATUS_DBG_23                       0x054C
#define REG_PMU_APB_APCPU_C0_SIMD_RET_MODE                  0x05A0
#define REG_PMU_APB_APCPU_C1_SIMD_RET_MODE                  0x05A4
#define REG_PMU_APB_APCPU_C2_SIMD_RET_MODE                  0x05A8
#define REG_PMU_APB_APCPU_C3_SIMD_RET_MODE                  0x05AC
#define REG_PMU_APB_APCPU_C4_SIMD_RET_MODE                  0x05B0
#define REG_PMU_APB_APCPU_C5_SIMD_RET_MODE                  0x05B4
#define REG_PMU_APB_APCPU_C6_SIMD_RET_MODE                  0x05B8
#define REG_PMU_APB_APCPU_C7_SIMD_RET_MODE                  0x05BC
#define REG_PMU_APB_APCPU_CORE0_SW_PACTIVE                  0x05E0
#define REG_PMU_APB_APCPU_CORE1_SW_PACTIVE                  0x05E4
#define REG_PMU_APB_APCPU_CORE2_SW_PACTIVE                  0x05E8
#define REG_PMU_APB_APCPU_CORE3_SW_PACTIVE                  0x05EC
#define REG_PMU_APB_APCPU_CORE4_SW_PACTIVE                  0x05F0
#define REG_PMU_APB_APCPU_CORE5_SW_PACTIVE                  0x05F4
#define REG_PMU_APB_APCPU_CORE6_SW_PACTIVE                  0x05F8
#define REG_PMU_APB_APCPU_CORE7_SW_PACTIVE                  0x05FC
#define REG_PMU_APB_APCPU_CLUSTER_SW_PACTIVE                0x0620
#define REG_PMU_APB_APCPU_CORE0_SW_PCHANNEL_HANDSHAKE       0x0624
#define REG_PMU_APB_APCPU_CORE1_SW_PCHANNEL_HANDSHAKE       0x0628
#define REG_PMU_APB_APCPU_CORE2_SW_PCHANNEL_HANDSHAKE       0x062C
#define REG_PMU_APB_APCPU_CORE3_SW_PCHANNEL_HANDSHAKE       0x0630
#define REG_PMU_APB_APCPU_CORE4_SW_PCHANNEL_HANDSHAKE       0x0634
#define REG_PMU_APB_APCPU_CORE5_SW_PCHANNEL_HANDSHAKE       0x0638
#define REG_PMU_APB_APCPU_CORE6_SW_PCHANNEL_HANDSHAKE       0x063C
#define REG_PMU_APB_APCPU_CORE7_SW_PCHANNEL_HANDSHAKE       0x0640
#define REG_PMU_APB_APCPU_CLUSTER_SW_PCHANNEL_HANDSHAKE     0x0664
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE0_INF         0x0668
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE1_INF         0x066C
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE2_INF         0x0670
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE3_INF         0x0674
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE4_INF         0x0678
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE5_INF         0x067C
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE6_INF         0x0680
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE7_INF         0x0684
#define REG_PMU_APB_INT_REQ_MODE_ST_APCPU_CLUSTER_INF       0x06A8
#define REG_PMU_APB_APCPU_MODE_ST_CFG0                      0x06AC
#define REG_PMU_APB_APCPU_MODE_ST_CFG1                      0x06B0
#define REG_PMU_APB_APCPU_MODE_ST_CFG2                      0x06B4
#define REG_PMU_APB_APCPU_MODE_ST_CFG3                      0x06B8
#define REG_PMU_APB_APCPU_CORINTH_SCU_CLK_GATE_CFG          0x06BC
#define REG_PMU_APB_APCPU_DENY_TIME_THRESHOLD_CFG           0x06C0
#define REG_PMU_APB_APCPU_MODE_ST_CGM_EN_CFG                0x06C4
#define REG_PMU_APB_APCPU_MODE_ST_FRC_ON_CFG                0x06C8
#define REG_PMU_APB_APCPU_SOFT_RST_TYPE_CFG                 0x06CC
#define REG_PMU_APB_DEBUG_RECOV_TYPE_CFG                    0x06D0
#define REG_PMU_APB_OFF_EMU_CLR_IN_DISABLE_CFG              0x06D4
#define REG_PMU_APB_OFF_EMU_TO_OFF_CFG                      0x06D8
#define REG_PMU_APB_WDG_TRIG_DBG_RECOV_CFG                  0x06DC
#define REG_PMU_APB_APCPU_CORE_ON_DISABLE_GEN               0x06E0
#define REG_PMU_APB_SOFTWARE_APCPU_PACTIVE_ENABLE           0x06E4
#define REG_PMU_APB_SOFTWARE_APCPU_PCHANNEL_HANDSHAKE_ENABLE 0x06E8
#define REG_PMU_APB_INT_REQ_APCPU_MODE_ST_ENABLE            0x06EC
#define REG_PMU_APB_INT_REQ_APCPU_MODE_ST_CLR               0x06F0
#define REG_PMU_APB_INT_REQ_APCPU_MODE_ST_RECORD            0x06F4
#define REG_PMU_APB_APCPU_WFI_MARK                          0x06F8
#define REG_PMU_APB_DEBUG_STATE_MARK                        0x06FC
#define REG_PMU_APB_APCPU_MODE_STATE_0                      0x0700
#define REG_PMU_APB_APCPU_MODE_STATE_1                      0x0704
#define REG_PMU_APB_APCPU_MODE_STATE_4                      0x0710
#define REG_PMU_APB_APCPU_PCHANNEL_STATE_0                  0x0714
#define REG_PMU_APB_APCPU_PCHANNEL_STATE_2                  0x071C
#define REG_PMU_APB_SLEEP_XTLON_CTRL                        0x0744
#define REG_PMU_APB_PWR_CNT_WAIT_CFG_0                      0x0748
#define REG_PMU_APB_PWR_CNT_WAIT_CFG_1                      0x074C
#define REG_PMU_APB_PWR_CNT_WAIT_CFG_2                      0x0750
#define REG_PMU_APB_SP_CLK_GATE_BYP_CFG                     0x0760
#define REG_PMU_APB_AP_DSLP_ENA                             0x0770
#define REG_PMU_APB_PUBCP_DSLP_ENA                          0x0774
#define REG_PMU_APB_WTLCP_DSLP_ENA                          0x0778
#define REG_PMU_APB_AUDCP_DSLP_ENA                          0x077C
#define REG_PMU_APB_WCN_DSLP_ENA                            0x078C
#define REG_PMU_APB_SP_DSLP_ENA                             0x0790
#define REG_PMU_APB_APCPU_TOP_DSLP_ENA                      0x07BC
#define REG_PMU_APB_PUBCP_CORE_INT_DISABLE                  0x07F0
#define REG_PMU_APB_LIGHT_SLEEP_ENABLE                      0x0808
#define REG_PMU_APB_PUB_DEEP_SLEEP_ENA                      0x080C
#define REG_PMU_APB_LIGHT_SLEEP_WAKEUP_EN                   0x0810
#define REG_PMU_APB_PUB_DEEP_SLEEP_WAKEUP_EN                0x0814
#define REG_PMU_APB_FORCE_DEEP_SLEEP_CFG_0                  0x0818
#define REG_PMU_APB_FORCE_DEEP_SLEEP_CFG_1                  0x081C
#define REG_PMU_APB_FORCE_PUB_DEEP_SLEEP_CFG                0x0820
#define REG_PMU_APB_FORCE_SYSTEM_SLEEP_CFG_0                0x0824
#define REG_PMU_APB_FORCE_SYSTEM_SLEEP_CFG_1                0x0828
#define REG_PMU_APB_ALL_FORCE_SYSTEM_SLEEP_CFG              0x082C
#define REG_PMU_APB_FORCE_LIGHT_SLEEP_CFG_0                 0x0830
#define REG_PMU_APB_FORCE_LIGHT_SLEEP_CFG_1                 0x0834
#define REG_PMU_APB_REG_SYS_DDR_PWR_HS_ACK_0                0x0838
#define REG_PMU_APB_DEEP_SLEEP_MON_0                        0x0850
#define REG_PMU_APB_DEEP_SLEEP_MON_1                        0x0854
#define REG_PMU_APB_LIGHT_SLEEP_MON_0                       0x0858
#define REG_PMU_APB_LIGHT_SLEEP_MON_1                       0x085C
#define REG_PMU_APB_SLEEP_STATUS_0                          0x0860
#define REG_PMU_APB_SLEEP_STATUS_1                          0x0864
#define REG_PMU_APB_DDR_SLEEP_WAIT_CNT                      0x08AC
#define REG_PMU_APB_PUB_SLEEP_BYPASS_CFG                    0x08B0
#define REG_PMU_APB_DDR_OP_MODE_CFG                         0x08B4
#define REG_PMU_APB_DDR_PHY_RET_CFG                         0x08B8
#define REG_PMU_APB_PUB_ACC_RDY                             0x08BC
#define REG_PMU_APB_DDR_SLEEP_CTRL                          0x08C0
#define REG_PMU_APB_DDR_SLP_STATUS                          0x08C4
#define REG_PMU_APB_PUB_VOL_DOWN_CFG                        0x08C8
#define REG_PMU_APB_SMART_LIGHT_SLEEP_ENABLE                0x08CC
#define REG_PMU_APB_PUB_AUTO_LIGHT_SLEEP_ENABLE             0x08D0
#define REG_PMU_APB_PUB_DEEP_SLEEP_POLL_0                   0x08D4
#define REG_PMU_APB_PUB_DEEP_SLEEP_POLL_2                   0x08DC
#define REG_PMU_APB_PUB_DEEP_SLEEP_POLL_3                   0x08E0
#define REG_PMU_APB_PUB_DEEP_SLEEP_POLL_5                   0x08E8
#define REG_PMU_APB_PUB_DEEP_SLEEP_POLL_7                   0x08F0
#define REG_PMU_APB_PUB_DEEP_SLEEP_POLL_8                   0x08F4
#define REG_PMU_APB_PUB_DFS_FRQ_SEL                         0x0904
#define REG_PMU_APB_PUB_DEEP_SLEEP_SEL                      0x0908
#define REG_PMU_APB_SP_ACCESS_DDR_CFG                       0x090C
#define REG_PMU_APB_FIREWALL_WAKEUP_PUB                     0x092C
#define REG_PMU_APB_XTL0_REL_CFG                            0x09C4
#define REG_PMU_APB_XTL1_REL_CFG                            0x09C8
#define REG_PMU_APB_XTL2_REL_CFG                            0x09CC
#define REG_PMU_APB_XTL3_REL_CFG                            0x09D0
#define REG_PMU_APB_XTLBUF0_REL_CFG                         0x09D4
#define REG_PMU_APB_XTLBUF1_REL_CFG                         0x09D8
#define REG_PMU_APB_XTLBUF2_REL_CFG                         0x09DC
#define REG_PMU_APB_XTLBUF3_REL_CFG                         0x09E0
#define REG_PMU_APB_RCO_REL_CFG                             0x09E4
#define REG_PMU_APB_MPLL0_REL_CFG                           0x09F4
#define REG_PMU_APB_MPLL1_REL_CFG                           0x09F8
#define REG_PMU_APB_MPLL2_REL_CFG                           0x09FC
#define REG_PMU_APB_RPLL_REL_CFG                            0x0A0C
#define REG_PMU_APB_DPLL0_REL_CFG                           0x0A14
#define REG_PMU_APB_GPLL_REL_CFG                            0x0A20
#define REG_PMU_APB_ISPPLL_REL_CFG                          0x0A28
#define REG_PMU_APB_TWPLL_REL_CFG                           0x0A40
#define REG_PMU_APB_LTEPLL_REL_CFG                          0x0A44
#define REG_PMU_APB_XTL_WAIT_CNT                            0x0A84
#define REG_PMU_APB_XTLBUF_WAIT_CNT                         0x0A88
#define REG_PMU_APB_RCO_WAIT_CNT                            0x0A8C
#define REG_PMU_APB_PLL_WAIT_CNT_0                          0x0A90
#define REG_PMU_APB_PLL_WAIT_CNT_1                          0x0A94
#define REG_PMU_APB_PLL_WAIT_CNT_2                          0x0A98
#define REG_PMU_APB_PLL_WAIT_CNT_3                          0x0A9C
#define REG_PMU_APB_PLL_WAIT_CNT_4                          0x0AA0
#define REG_PMU_APB_PLL_WAIT_CNT_5                          0x0AA4
#define REG_PMU_APB_MPLL0_RST_CTRL_CFG                      0x0AB4
#define REG_PMU_APB_MPLL1_RST_CTRL_CFG                      0x0AB8
#define REG_PMU_APB_MPLL2_RST_CTRL_CFG                      0x0ABC
#define REG_PMU_APB_RPLL_RST_CTRL_CFG                       0x0ACC
#define REG_PMU_APB_DPLL0_RST_CTRL_CFG                      0x0AD4
#define REG_PMU_APB_GPLL_RST_CTRL_CFG                       0x0AE0
#define REG_PMU_APB_ISPPLL_RST_CTRL_CFG                     0x0AE8
#define REG_PMU_APB_TWPLL_RST_CTRL_CFG                      0x0B00
#define REG_PMU_APB_LTEPLL_RST_CTRL_CFG                     0x0B04
#define REG_PMU_APB_PLL_CTRL_STATE_0                        0x0B44
#define REG_PMU_APB_PLL_CTRL_STATE_1                        0x0B48
#define REG_PMU_APB_PLL_CTRL_STATE_2                        0x0B4C
#define REG_PMU_APB_APCPU_DSLP_ENA_SRST_MASK_CFG            0x0B7C
#define REG_PMU_APB_APCPU_GIC_RST_EN                        0x0B80
#define REG_PMU_APB_APCPU_MODE_ST_SOFT_RST                  0x0B84
#define REG_PMU_APB_DM_SOFT_RST                             0x0B88
#define REG_PMU_APB_ADM_SOFT_RST                            0x0B8C
#define REG_PMU_APB_REG_SYS_SRST_FRC_LP_ACK_0               0x0B90
#define REG_PMU_APB_SYS_SOFT_RST_0                          0x0B98
#define REG_PMU_APB_SYS_SOFT_RST_1                          0x0B9C
#define REG_PMU_APB_SYS_SOFT_RST_BUSY_0                     0x0BA0
#define REG_PMU_APB_SOFT_RST_SEL_0                          0x0BA8
#define REG_PMU_APB_PD_AP_SHUTDOWN_MARK_STATUS              0x0BB0
#define REG_PMU_APB_PD_APCPU_TOP_SHUTDOWN_MARK_STATUS       0x0BB4
#define REG_PMU_APB_PD_APCPU_CORE0_SHUTDOWN_MARK_STATUS     0x0BB8
#define REG_PMU_APB_PD_APCPU_CORE1_SHUTDOWN_MARK_STATUS     0x0BBC
#define REG_PMU_APB_PD_APCPU_CORE2_SHUTDOWN_MARK_STATUS     0x0BC0
#define REG_PMU_APB_PD_APCPU_CORE3_SHUTDOWN_MARK_STATUS     0x0BC4
#define REG_PMU_APB_PD_APCPU_CORE4_SHUTDOWN_MARK_STATUS     0x0BC8
#define REG_PMU_APB_PD_APCPU_CORE5_SHUTDOWN_MARK_STATUS     0x0BCC
#define REG_PMU_APB_PD_APCPU_CORE6_SHUTDOWN_MARK_STATUS     0x0BD0
#define REG_PMU_APB_PD_APCPU_CORE7_SHUTDOWN_MARK_STATUS     0x0BD4
#define REG_PMU_APB_PD_GPU_TOP_SHUTDOWN_MARK_STATUS         0x0BF8
#define REG_PMU_APB_PD_MM_SHUTDOWN_MARK_STATUS              0x0C1C
#define REG_PMU_APB_PD_AP_VSP_SHUTDOWN_MARK_STATUS          0x0C48
#define REG_PMU_APB_PD_PUBCP_SHUTDOWN_MARK_STATUS           0x0C64
#define REG_PMU_APB_PD_WTLCP_SHUTDOWN_MARK_STATUS           0x0C78
#define REG_PMU_APB_PD_WTLCP_LDSP_SHUTDOWN_MARK_STATUS      0x0C7C
#define REG_PMU_APB_PD_WTLCP_TGDSP_SHUTDOWN_MARK_STATUS     0x0C80
#define REG_PMU_APB_PD_WTLCP_TD_PROC_SHUTDOWN_MARK_STATUS   0x0C88
#define REG_PMU_APB_PD_WTLCP_LTE_PROC_SHUTDOWN_MARK_STATUS  0x0C8C
#define REG_PMU_APB_PD_WTLCP_LTE_CE_SHUTDOWN_MARK_STATUS    0x0C90
#define REG_PMU_APB_PD_WTLCP_LTE_DPFEC_SHUTDOWN_MARK_STATUS 0x0C94
#define REG_PMU_APB_PD_WTLCP_HU3GE_A_SHUTDOWN_MARK_STATUS   0x0C98
#define REG_PMU_APB_PD_WTLCP_HU3GE_B_SHUTDOWN_MARK_STATUS   0x0C9C
#define REG_PMU_APB_PD_WCN_SHUTDOWN_MARK_STATUS             0x0CDC
#define REG_PMU_APB_PD_AUDCP_SHUTDOWN_MARK_STATUS           0x0D04
#define REG_PMU_APB_PD_AUDCP_AUDDSP_SHUTDOWN_MARK_STATUS    0x0D08
#define REG_PMU_APB_PD_PUB_SHUTDOWN_MARK_STATUS             0x0D2C
#define REG_PMU_APB_ALL_PLL_PD_RCO_BYP                      0x0D98
#define REG_PMU_APB_PAD_OUT_CHIP_SLEEP_CFG                  0x0D9C
#define REG_PMU_APB_PAD_OUT_XTL_EN0_CFG                     0x0DA0
#define REG_PMU_APB_PAD_OUT_XTL_EN1_CFG                     0x0DA4
#define REG_PMU_APB_PAD_OUT_XTL_EN2_CFG                     0x0DA8
#define REG_PMU_APB_PAD_OUT_XTL_EN3_CFG                     0x0DAC
#define REG_PMU_APB_PAD_OUT_DCDC_ARM0_EN_CFG                0x0DB4
#define REG_PMU_APB_PAD_OUT_DCDC_ARM1_EN_CFG                0x0DB8
#define REG_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_CFG          0x0DC8
#define REG_PMU_APB_AP_DEEP_SLEEP_CNT                       0x0DFC
#define REG_PMU_APB_PUBCP_DEEP_SLEEP_CNT                    0x0E00
#define REG_PMU_APB_WTLCP_DEEP_SLEEP_CNT                    0x0E04
#define REG_PMU_APB_AUDCP_DEEP_SLEEP_CNT                    0x0E08
#define REG_PMU_APB_WCN_DEEP_SLEEP_CNT                      0x0E18
#define REG_PMU_APB_SP_DEEP_SLEEP_CNT                       0x0E1C
#define REG_PMU_APB_APCPU_TOP_DEEP_STOP_FINAL_CNT           0x0E48
#define REG_PMU_APB_PUB_DEEP_SLEEP_CNT                      0x0E60
#define REG_PMU_APB_DEEP_SLEEP_CNT_CLR                      0x0E64
#define REG_PMU_APB_AP_LIGHT_SLEEP_CNT                      0x0E68
#define REG_PMU_APB_PUBCP_LIGHT_SLEEP_CNT                   0x0E6C
#define REG_PMU_APB_WTLCP_LIGHT_SLEEP_CNT                   0x0E70
#define REG_PMU_APB_AUDCP_LIGHT_SLEEP_CNT                   0x0E74
#define REG_PMU_APB_WCN_LIGHT_SLEEP_CNT                     0x0E84
#define REG_PMU_APB_AON_LIGHT_SLEEP_CNT                     0x0E88
#define REG_PMU_APB_APCPU_TOP_LIGHT_STOP_FINAL_CNT          0x0EB4
#define REG_PMU_APB_PUB_LIGHT_SLEEP_CNT                     0x0ECC
#define REG_PMU_APB_LIGHT_SLEEP_CNT_CLR                     0x0ED0
#define REG_PMU_APB_AP_SYS_STOP_CNT                         0x0ED4
#define REG_PMU_APB_PUBCP_SYS_STOP_CNT                      0x0ED8
#define REG_PMU_APB_WTLCP_SYS_STOP_CNT                      0x0EDC
#define REG_PMU_APB_AUDCP_SYS_STOP_CNT                      0x0EE0
#define REG_PMU_APB_WCN_SYS_STOP_CNT                        0x0EF0
#define REG_PMU_APB_APCPU_TOP_SYS_STOP_CNT                  0x0F20
#define REG_PMU_APB_SYS_STOP_CNT_CLR                        0x0F38
#define REG_PMU_APB_PAD_OUT_CHIP_SLEEP_EDG_CNT              0x0F3C
#define REG_PMU_APB_PAD_OUT_CHIP_SLEEP_DUR_CNT              0x0F50
#define REG_PMU_APB_FUNCTION_CNT_CLR                        0x0F60
#define REG_PMU_APB_PWR_ST_CLK_DIV_CFG                      0x0F64
#define REG_PMU_APB_SLP_CTRL_CLK_DIV_CFG                    0x0F68
#define REG_PMU_APB_MPLL_WAIT_CLK_DIV_CFG                   0x0F6C
#define REG_PMU_APB_DOMAIN_PWR_DOWN_INT_CLR                 0x0F78
#define REG_PMU_APB_DOMAIN_PWR_UP_INT_CLR                   0x0F7C
#define REG_PMU_APB_CGM_PMU_SEL                             0x0F80
#define REG_PMU_APB_EFUSE_SEL_BUF                           0x0F84
#define REG_PMU_APB_EIC_SEL                                 0x0F88
#define REG_PMU_APB_DUMMY_REG_0                             0x0FAC
#define REG_PMU_APB_DUMMY_REG_1                             0x0FB0
#define REG_PMU_APB_AON_DBG_SIG_SEL                         0x0FB4
#define REG_PMU_APB_AON_DBG_SUBSYS_BUS                      0x0FB8
#define REG_PMU_APB_CPU_AXI_LP_CTRL_DISABLE                 0x0FBC
#define REG_PMU_APB_CSI_WRAP_CTRL                           0x0FC0
#define REG_PMU_APB_DCDC_ARM0_PD_EN                         0x0FC4
#define REG_PMU_APB_EIC_CTRL_REG                            0x0FC8
#define REG_PMU_APB_GPIO_GATING_DISABLE                     0x0FCC
#define REG_PMU_APB_OTHER_SYS_BLK_SRST                      0x0FD0
#define REG_PMU_APB_Z_PD_DCDC_CPU1_ISO_ON_DLY               0x0FD4
#define REG_PMU_APB_PUBCP_WTLCP_ASYNCBRIDGE                 0x0FD8
#define REG_PMU_APB_PWD_CTRL                                0x0FDC
#define REG_PMU_APB_WCN_DBGPWR_CTRL                         0x0FE0
#define REG_PMU_APB_WCN_XTL_CTRL                            0x0FE4
#define REG_TOP_DVFS_APB_SUBSYS_SW_DVFS_EN_CFG              0x0150
#define REG_WTL_AON_APB_APB_EB0                             0x0000
#define REG_WTL_AON_APB_APB_ARM_ROOT_ADDR                   0x0004
#define REG_WTL_AON_APB_WCDMA_CLK_EB                        0x0008
#define REG_WTL_AON_APB_APB_STS                             0x000C
#define REG_WTL_AON_APB_APB_ARCH_EB                         0x0010
#define REG_WTL_AON_APB_APB_MISC_CTL                        0x0014
#define REG_WTL_AON_APB_SLEEP_CTL_INT_MASK                  0x0018
#define REG_WTL_AON_APB_APB_SOFT_RST0                       0x0020
#define REG_WTL_AON_APB_LTE_LP_EB0                          0x0024
#define REG_WTL_AON_APB_LTE_LP_EB1                          0x0028
#define REG_WTL_AON_APB_LTE_LP_EB2                          0x002C
#define REG_WTL_AON_APB_LTE_LP_EB3                          0x0030
#define REG_WTL_AON_APB_WAKEUP_XTL_EN                       0x0040
#define REG_WTL_AON_APB_C_CHANNEL_CTL                       0x004C
#define REG_WTL_AON_APB_RSV_REG_A                           0x0050
#define REG_WTL_AON_APB_RSV_REG_B                           0x0054
#define REG_WTL_AON_APB_OCM_RST_MSK                         0x0060
#define REG_WTL_AON_APB_RFFE_EB                             0x0084
#define REG_WTL_AON_APB_RFFE_RST                            0x0088
#define REG_WTL_AON_APB_SCC_EB                              0x0090
#define REG_WTL_AON_APB_SCC_RST                             0x0094
#define REG_WTL_AON_APB_SCC_LP_EB0                          0x0098
#define REG_WTL_AON_APB_SCC_LP_EB1                          0x009C
#define REG_WTL_AON_APB_SCC_LP_EB2                          0x00A0
#define REG_WTL_AON_APB_SCC_LP_EB3                          0x00A4
#define REG_WTL_AON_APB_LTE_HARQ_LP_EB0                     0x00A8
#define REG_WTL_AON_APB_LTE_HARQ_LP_EB1                     0x00AC
#define REG_WTL_AON_APB_RAM_PD_RET_CTL                      0x00B0
#define REG_WTL_AON_APB_MEM_AUTO_SLP_EN                     0x00B4
#define REG_WTL_AON_APB_BUS_EB                              0x00B8
#define REG_MM_AHB_AHB_EB                                   0x0000
#define REG_MM_AHB_AHB_RST                                  0x0004
#define REG_MM_AHB_MM_LPC_CTRL_FD                           0x0040
#endif /* __DT_BINDINGS_SPRD_QOGIRL6_REGS_H */
