/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Unisoc UMS9621 platform clocks
 *
 * Copyright (C) 2022, Unisoc Inc.
 */


#ifndef __DT_BINDINGS_SPRD_QOGIRL6_MASK_H
#define __DT_BINDINGS_SPRD_QOGIRL6_MASK_H

#define MASK_AON_APB_TOP2WCN_EB_AUTO_SEL                    0x200000
#define MASK_AON_APB_TOP2WCN_EB                             0x100000
#define MASK_AON_APB_BUS_TRANSMON_EN                        0x80000
#define MASK_AON_APB_LVDIS_PLL_DIV_EN                       0x40000
#define MASK_AON_APB_CSSYS_PUB_EB                           0x20000
#define MASK_AON_APB_CSSYS_APB_EB                           0x10000
#define MASK_AON_APB_CSSYS_EB                               0x8000
#define MASK_AON_APB_APCPU_DAP_EB                           0x4000
#define MASK_AON_APB_MSPI_EB                                0x1000
#define MASK_AON_APB_GPU_EB                                 0x0800
#define MASK_AON_APB_SP_AHB_CLK_SOFT_EB                     0x0400
#define MASK_AON_APB_MM_EB                                  0x0200
#define MASK_AON_APB_PROBE_EB                               0x0080
#define MASK_AON_APB_AUX2_EB                                0x0040
#define MASK_AON_APB_AUX1_EB                                0x0020
#define MASK_AON_APB_AUX0_EB                                0x0010
#define MASK_AON_APB_DJTAG_EB                               0x0008
#define MASK_AON_APB_DJTAG_TCK_EB                           0x0004
#define MASK_AON_APB_RFTI_EB                                0x0002
#define MASK_AON_APB_RC100M_CAL_EB                          0x0001
#define MASK_AON_APB_SCC_EB                                 0x100000
#define MASK_AON_APB_AON_IIS_EB                             0x80000
#define MASK_AON_APB_APB_BUSMON_EB                          0x40000
#define MASK_AON_APB_APCPU_TS0_EB                           0x20000
#define MASK_AON_APB_ADI_2ND_EB                             0x8000
#define MASK_AON_APB_CKG_EB                                 0x2000
#define MASK_AON_APB_ANA_EB                                 0x1000
#define MASK_AON_APB_PIN_EB                                 0x0800
#define MASK_AON_APB_SPLK_EB                                0x0400
#define MASK_AON_APB_OTG_UTMI_EB                            0x0100
#define MASK_AON_APB_DVFS_TOP_EB                            0x0080
#define MASK_AON_APB_AON_TMR_EB                             0x0040
#define MASK_AON_APB_AP_SYST_EB                             0x0020
#define MASK_AON_APB_AON_SYST_EB                            0x0010
#define MASK_AON_APB_KPD_EB                                 0x0008
#define MASK_AON_APB_MBOX_EB                                0x0004
#define MASK_AON_APB_GPIO_EB                                0x0002
#define MASK_AON_APB_EFUSE_EB                               0x0001
#define MASK_AON_APB_SERDES_EB                              0x80000000
#define MASK_AON_APB_APCPU_WDG_EB                           0x40000000
#define MASK_AON_APB_AP_WDG_EB                              0x20000000
#define MASK_AON_APB_PWM3_EB                                0x10000000
#define MASK_AON_APB_PWM2_EB                                0x8000000
#define MASK_AON_APB_PWM1_EB                                0x4000000
#define MASK_AON_APB_PWM0_EB                                0x2000000
#define MASK_AON_APB_AP_TMR2_EB                             0x1000000
#define MASK_AON_APB_AP_TMR1_EB                             0x800000
#define MASK_AON_APB_AP_TMR0_EB                             0x400000
#define MASK_AON_APB_WTLCP_INTC_EB                          0x200000
#define MASK_AON_APB_WTLCP_LDSP_INTC_EB                     0x100000
#define MASK_AON_APB_WTLCP_TGDSP_INTC_EB                    0x80000
#define MASK_AON_APB_PUBCP_INTC_EB                          0x40000
#define MASK_AON_APB_AUDCP_INTC_EB                          0x20000
#define MASK_AON_APB_AP_INTC5_EB                            0x10000
#define MASK_AON_APB_AP_INTC4_EB                            0x8000
#define MASK_AON_APB_AP_INTC3_EB                            0x4000
#define MASK_AON_APB_AP_INTC2_EB                            0x2000
#define MASK_AON_APB_AP_INTC1_EB                            0x1000
#define MASK_AON_APB_AP_INTC0_EB                            0x0800
#define MASK_AON_APB_EIC_EB                                 0x0400
#define MASK_AON_APB_ADI_EB                                 0x0200
#define MASK_AON_APB_PMU_EB                                 0x0100
#define MASK_AON_APB_I2C_EB                                 0x0080
#define MASK_AON_APB_PUBCP_SIM2_AON_TOP_EB                  0x0040
#define MASK_AON_APB_PUBCP_SIM1_AON_TOP_EB                  0x0020
#define MASK_AON_APB_PUBCP_SIM0_AON_TOP_EB                  0x0010
#define MASK_AON_APB_AP_SIM_AON_TOP_EB                      0x0008
#define MASK_AON_APB_THM2_EB                                0x0004
#define MASK_AON_APB_THM1_EB                                0x0002
#define MASK_AON_APB_THM0_EB                                0x0001
#define MASK_AON_APB_PUBCP_SDIO0_SOFT_RST                   0x4000
#define MASK_AON_APB_AP_SDIO2_SOFT_RST                      0x2000
#define MASK_AON_APB_AP_SDIO1_SOFT_RST                      0x1000
#define MASK_AON_APB_AP_SDIO0_SOFT_RST                      0x0800
#define MASK_AON_APB_AP_EMMC_SOFT_RST                       0x0400
#define MASK_AON_APB_LVDSDIS_SOFT_RST                       0x0080
#define MASK_AON_APB_DAP_MTX_SOFT_RST                       0x0040
#define MASK_AON_APB_MSPI1_SOFT_RST                         0x0020
#define MASK_AON_APB_MSPI0_SOFT_RST                         0x0010
#define MASK_AON_APB_BB_CAL_SOFT_RST                        0x0008
#define MASK_AON_APB_DCXO_LC_SOFT_RST                       0x0004
#define MASK_AON_APB_RFTI_SOFT_RST                          0x0002
#define MASK_AON_APB_RC100M_CAL_SOFT_RST                    0x0001
#define MASK_AON_APB_SCC_SOFT_RST                           0x100000
#define MASK_AON_APB_AON_IIS_SOFT_RST                       0x80000
#define MASK_AON_APB_APB_BUSMON_SOFT_RST                    0x40000
#define MASK_AON_APB_APCPU_TS0_SOFT_RST                     0x20000
#define MASK_AON_APB_ADI_2ND_SOFT_RST                       0x8000
#define MASK_AON_APB_CKG_SOFT_RST                           0x2000
#define MASK_AON_APB_ANA_SOFT_RST                           0x1000
#define MASK_AON_APB_PIN_SOFT_RST                           0x0800
#define MASK_AON_APB_SPLK_SOFT_RST                          0x0400
#define MASK_AON_APB_OTG_PHY_SOFT_RST                       0x0200
#define MASK_AON_APB_OTG_UTMI_SOFT_RST                      0x0100
#define MASK_AON_APB_DVFS_TOP_SOFT_RST                      0x0080
#define MASK_AON_APB_AON_TMR_SOFT_RST                       0x0040
#define MASK_AON_APB_AP_SYST_SOFT_RST                       0x0020
#define MASK_AON_APB_AON_SYST_SOFT_RST                      0x0010
#define MASK_AON_APB_KPD_SOFT_RST                           0x0008
#define MASK_AON_APB_MBOX_SOFT_RST                          0x0004
#define MASK_AON_APB_GPIO_SOFT_RST                          0x0002
#define MASK_AON_APB_EFUSE_SOFT_RST                         0x0001
#define MASK_AON_APB_SERDES_SOFT_RST                        0x80000000
#define MASK_AON_APB_APCPU_WDG_SOFT_RST                     0x40000000
#define MASK_AON_APB_AP_WDG_SOFT_RST                        0x20000000
#define MASK_AON_APB_PWM3_SOFT_RST                          0x10000000
#define MASK_AON_APB_PWM2_SOFT_RST                          0x8000000
#define MASK_AON_APB_PWM1_SOFT_RST                          0x4000000
#define MASK_AON_APB_PWM0_SOFT_RST                          0x2000000
#define MASK_AON_APB_AP_TMR2_SOFT_RST                       0x1000000
#define MASK_AON_APB_AP_TMR1_SOFT_RST                       0x800000
#define MASK_AON_APB_AP_TMR0_SOFT_RST                       0x400000
#define MASK_AON_APB_WTLCP_INTC_SOFT_RST                    0x200000
#define MASK_AON_APB_WTLCP_LDSP_INTC_SOFT_RST               0x100000
#define MASK_AON_APB_WTLCP_TGDSP_INTC_SOFT_RST              0x80000
#define MASK_AON_APB_PUBCP_INTC_SOFT_RST                    0x40000
#define MASK_AON_APB_AUDCP_INTC_SOFT_RST                    0x20000
#define MASK_AON_APB_AP_INTC5_SOFT_RST                      0x10000
#define MASK_AON_APB_AP_INTC4_SOFT_RST                      0x8000
#define MASK_AON_APB_AP_INTC3_SOFT_RST                      0x4000
#define MASK_AON_APB_AP_INTC2_SOFT_RST                      0x2000
#define MASK_AON_APB_AP_INTC1_SOFT_RST                      0x1000
#define MASK_AON_APB_AP_INTC0_SOFT_RST                      0x0800
#define MASK_AON_APB_EIC_SOFT_RST                           0x0400
#define MASK_AON_APB_ADI_SOFT_RST                           0x0200
#define MASK_AON_APB_PMU_SOFT_RST                           0x0100
#define MASK_AON_APB_I2C_SOFT_RST                           0x0080
#define MASK_AON_APB_PUBCP_SIM2_AON_TOP_SOFT_RST            0x0040
#define MASK_AON_APB_PUBCP_SIM1_AON_TOP_SOFT_RST            0x0020
#define MASK_AON_APB_PUBCP_SIM0_AON_TOP_SOFT_RST            0x0010
#define MASK_AON_APB_AP_SIM_AON_TOP_SOFT_RST                0x0008
#define MASK_AON_APB_THM2_SOFT_RST                          0x0004
#define MASK_AON_APB_THM1_SOFT_RST                          0x0002
#define MASK_AON_APB_THM0_SOFT_RST                          0x0001
#define MASK_AON_APB_PUBCP_SDIO0_RTC_EB                     0x40000
#define MASK_AON_APB_AP_SDIO2_RTC_EB                        0x20000
#define MASK_AON_APB_AP_SDIO1_RTC_EB                        0x10000
#define MASK_AON_APB_AP_SDIO0_RTC_EB                        0x8000
#define MASK_AON_APB_AP_EMMC_RTC_EB                         0x4000
#define MASK_AON_APB_BB_CAL_RTC_EB                          0x2000
#define MASK_AON_APB_DCXO_LC_RTC_EB                         0x1000
#define MASK_AON_APB_AP_TMR2_RTC_EB                         0x0800
#define MASK_AON_APB_AP_TMR1_RTC_EB                         0x0400
#define MASK_AON_APB_AP_TMR0_RTC_EB                         0x0200
#define MASK_AON_APB_APCPU_WDG_RTC_EB                       0x0100
#define MASK_AON_APB_AP_WDG_RTC_EB                          0x0080
#define MASK_AON_APB_EIC_RTCDV5_EB                          0x0040
#define MASK_AON_APB_EIC_RTC_EB                             0x0020
#define MASK_AON_APB_AON_TMR_RTC_EB                         0x0010
#define MASK_AON_APB_AP_SYST_RTC_EB                         0x0008
#define MASK_AON_APB_AON_SYST_RTC_EB                        0x0004
#define MASK_AON_APB_KPD_RTC_EB                             0x0002
#define MASK_AON_APB_ARCH_RTC_EB                            0x0001
#define MASK_AON_APB_EFUSE_PWON_RD_END_FLAG                 0x0004
#define MASK_AON_APB_DBG_TRACE_CTRL_EN                      0x10000
#define MASK_AON_APB_EVENTACK_RESTARTREQ_TS01               0x0010
#define MASK_AON_APB_EVENT_RESTARTREQ_TS01                  0x0002
#define MASK_AON_APB_EVENT_HALTREQ_TS01                     0x0001
#define MASK_AON_APB_ARM_BOOT_MD4                           0x0200
#define MASK_AON_APB_PTEST_FUNC_ATSPEED_SEL                 0x0100
#define MASK_AON_APB_PTEST_FUNC_MODE                        0x0080
#define MASK_AON_APB_FUNCTST_DMA_EB                         0x0040
#define MASK_AON_APB_PTEST_BIST_MODE                        0x0020
#define MASK_AON_APB_USB_DLOAD_EN                           0x0010
#define MASK_AON_APB_ARM_BOOT_MD3                           0x0008
#define MASK_AON_APB_ARM_BOOT_MD2                           0x0004
#define MASK_AON_APB_ARM_BOOT_MD1                           0x0002
#define MASK_AON_APB_ARM_BOOT_MD0                           0x0001
#define MASK_AON_APB_BB_BG_AUTO_PD_EN                       0x0008
#define MASK_AON_APB_BB_BG_SLP_PD_EN                        0x0004
#define MASK_AON_APB_BB_BG_FORCE_ON                         0x0002
#define MASK_AON_APB_BB_BG_FORCE_PD                         0x0001
#define MASK_AON_APB_AGCP_DSP_JTAG_MODE                     0x0008
#define MASK_AON_APB_CP_ARM_JTAG_PIN_SEL                    0x0007
#define MASK_AON_APB_DCXO_LC_FLAG                           0x0100
#define MASK_AON_APB_DCXO_LC_FLAG_CLR                       0x0002
#define MASK_AON_APB_DCXO_LC_CNT_CLR                        0x0001
#define MASK_AON_APB_DCXO_LC_CNT                            0xFFFFFFFF
#define MASK_AON_APB_AUDCP_BOOTCTRL_PROT                    0x80000000
#define MASK_AON_APB_AUDCP_REG_PROT_VAL                     0xFFFF
#define MASK_AON_APB_LDSP_CTRL_PROT                         0x80000000
#define MASK_AON_APB_REG_PROT_VAL                           0xFFFF
#define MASK_AON_APB_CGM_AON_APB_LP_SEL                     0x0007
#define MASK_AON_APB_DAP_DBGPWRUP_SOFT_EN                   0x0004
#define MASK_AON_APB_DAP_SYSPWRUP_SOFT_EN                   0x0002
#define MASK_AON_APB_DAP_DJTAG_EN                           0x0001
#define MASK_AON_APB_USER_RSV_FLAG1_B1                      0x0002
#define MASK_AON_APB_USER_RSV_FLAG1_B0                      0x0001
#define MASK_AON_APB_CM4_SYS_SOFT_RST                       0x0010
#define MASK_AON_APB_CM4_CORE_SOFT_RST                      0x0001
#define MASK_AON_APB_CGM_AP_AXI_APCPU_AUTO_GATE_SEL         0x80000000
#define MASK_AON_APB_CGM_AP_MM_AP_FORCE_EN                  0x40000000
#define MASK_AON_APB_CGM_AP_MM_AP_AUTO_GATE_SEL             0x20000000
#define MASK_AON_APB_CGM_EMC_FORCE_EN                       0x10000000
#define MASK_AON_APB_CGM_EMC_AUTO_GATE_SEL                  0x8000000
#define MASK_AON_APB_CGM_MM_ISP_RAW_FORCE_EN                0x4000000
#define MASK_AON_APB_CGM_MM_ISP_RAW_AUTO_GATE_SEL           0x2000000
#define MASK_AON_APB_CGM_MM_ISP_YUV_FORCE_EN                0x1000000
#define MASK_AON_APB_CGM_MM_ISP_YUV_AUTO_GATE_SEL           0x800000
#define MASK_AON_APB_CGM_AON_APB_PUB_FORCE_EN               0x400000
#define MASK_AON_APB_CGM_AON_APB_PUB_AUTO_GATE_SEL          0x200000
#define MASK_AON_APB_CGM_AON_APB_AUDCP_FORCE_EN             0x100000
#define MASK_AON_APB_CGM_AON_APB_AUDCP_AUTO_GATE_SEL        0x80000
#define MASK_AON_APB_CGM_AON_APB_PUBCP_FORCE_EN             0x40000
#define MASK_AON_APB_CGM_AON_APB_PUBCP_AUTO_GATE_SEL        0x20000
#define MASK_AON_APB_CGM_AON_APB_WTLCP_FORCE_EN             0x10000
#define MASK_AON_APB_CGM_AON_APB_WTLCP_AUTO_GATE_SEL        0x8000
#define MASK_AON_APB_CGM_AON_APB_AP_FORCE_EN                0x4000
#define MASK_AON_APB_CGM_AON_APB_AP_AUTO_GATE_SEL           0x2000
#define MASK_AON_APB_CGM_AP_AXI_FORCE_EN                    0x1000
#define MASK_AON_APB_CGM_AP_AXI_AUTO_GATE_SEL               0x0800
#define MASK_AON_APB_CGM_AP_MM_ROOT_FORCE_EN                0x0400
#define MASK_AON_APB_CGM_AP_MM_ROOT_AUTO_GATE_SEL           0x0200
#define MASK_AON_APB_CGM_AP_MM_MM_FORCE_EN                  0x0100
#define MASK_AON_APB_CGM_AP_MM_MM_AUTO_GATE_SEL             0x0080
#define MASK_AON_APB_CGM_AP_MM_GPU_FORCE_EN                 0x0040
#define MASK_AON_APB_CGM_AP_MM_GPU_AUTO_GATE_SEL            0x0020
#define MASK_AON_APB_CGM_GPU_MEM_FORCE_EN                   0x0010
#define MASK_AON_APB_CGM_GPU_MEM_AUTO_GATE_SEL              0x0008
#define MASK_AON_APB_CGM_APCPU_PMU_AUTO_GATE_SEL            0x0004
#define MASK_AON_APB_CGM_APCPU_PMU_FORCE_EN                 0x0002
#define MASK_AON_APB_MBOX_AUTO_GATE_SEL                     0x0001
#define MASK_AON_APB_CGM_PUB_CLK_ANLG_IO_APB_EN             0x0020
#define MASK_AON_APB_CGM_DMC_REF_AUTO_GATE_SEL              0x0010
#define MASK_AON_APB_CGM_TOP_DVFS_ROOT_AUTO_GATE_SEL        0x0008
#define MASK_AON_APB_CGM_TOP_DVFS_ROOT_FORCE_EN             0x0004
#define MASK_AON_APB_CGM_AON_APB_WCN_FORCE_EN               0x0002
#define MASK_AON_APB_CGM_AON_APB_WCN_AUTO_GATE_SEL          0x0001
#define MASK_AON_APB_CGM_AP_AXI_AUTO_FREQ_DOWN_CTRL_SEL     0x0008
#define MASK_AON_APB_CGM_AP_AXI_AUTO_FREQ_DOWN_EN           0x0004
#define MASK_AON_APB_CGM_AP_AXI_SEL_IDLE                    0x0003
#define MASK_AON_APB_AON_CHIP_ID0                           0xFFFFFFFF
#define MASK_AON_APB_AON_CHIP_ID1                           0xFFFFFFFF
#define MASK_AON_APB_AON_PLAT_ID0                           0xFFFFFFFF
#define MASK_AON_APB_AON_PLAT_ID1                           0xFFFFFFFF
#define MASK_AON_APB_AON_IMPL_ID                            0xFFFFFFFF
#define MASK_AON_APB_AON_MFT_ID                             0xFFFFFFFF
#define MASK_AON_APB_AON_VER_ID                             0xFFFFFFFF
#define MASK_AON_APB_AON_CHIP_ID                            0xFFFFFFFF
#define MASK_AON_APB_ANALOG_PLL_RSV                         0xFFFF0000
#define MASK_AON_APB_ANALOG_TESTMUX                         0xFFFF
#define MASK_AON_APB_PLL_BG_RSV                             0x003F
#define MASK_AON_APB_LVDSDIS_LOG_SEL                        0x0006
#define MASK_AON_APB_LVDSDIS_DBG_SEL                        0x0001
#define MASK_AON_APB_CGM_WCDMA_ROOT_FORCE_EN                0x0020
#define MASK_AON_APB_CGM_WCDMA_ROOT_AUTO_GATE_SEL           0x0010
#define MASK_AON_APB_CGM_WCDMA_PUBCP_FORCE_EN               0x0008
#define MASK_AON_APB_CGM_WCDMA_PUBCP_AUTO_GATE_SEL          0x0004
#define MASK_AON_APB_CGM_WCDMA_WTLCP_FORCE_EN               0x0002
#define MASK_AON_APB_CGM_WCDMA_WTLCP_AUTO_GATE_SEL          0x0001
#define MASK_AON_APB_CGM_PERIPH_AUTO_GATE_EN                0x2000
#define MASK_AON_APB_CGM_GIC_AUTO_GATE_EN                   0x1000
#define MASK_AON_APB_CGM_ACP_AUTO_GATE_EN                   0x0800
#define MASK_AON_APB_CGM_AXI_PERIPH_AUTO_GATE_EN            0x0400
#define MASK_AON_APB_CGM_ACE_AUTO_GATE_EN                   0x0200
#define MASK_AON_APB_CGM_SCU_AUTO_GATE_EN                   0x0100
#define MASK_AON_APB_CGM_CORE7_AUTO_GATE_EN                 0x0080
#define MASK_AON_APB_CGM_CORE6_AUTO_GATE_EN                 0x0040
#define MASK_AON_APB_CGM_CORE5_AUTO_GATE_EN                 0x0020
#define MASK_AON_APB_CGM_CORE4_AUTO_GATE_EN                 0x0010
#define MASK_AON_APB_CGM_CORE3_AUTO_GATE_EN                 0x0008
#define MASK_AON_APB_CGM_CORE2_AUTO_GATE_EN                 0x0004
#define MASK_AON_APB_CGM_CORE1_AUTO_GATE_EN                 0x0002
#define MASK_AON_APB_CGM_CORE0_AUTO_GATE_EN                 0x0001
#define MASK_AON_APB_APCPU_PERIPH_CO_SCLK                   0x0008
#define MASK_AON_APB_APCPU_DEEP_CO_QACTIVE                  0x0004
#define MASK_AON_APB_APCPU_CORE_WAKEUP_ACE_CLK_EN           0x0002
#define MASK_AON_APB_APCPU_CORE_WAKEUP_SCU_CLK_EN           0x0001
#define MASK_AON_APB_SP_AHB_CLK_SOFT_EN                     0x0080
#define MASK_AON_APB_CM4_SLEEPING_STAT                      0x0040
#define MASK_AON_APB_CM4_LOCKUP_STAT                        0x0020
#define MASK_AON_APB_CM4_SOFT_MPUDIS                        0x0010
#define MASK_AON_APB_MMTX_SLEEP_CM4_PUB_WR                  0x0008
#define MASK_AON_APB_MMTX_SLEEP_CM4_PUB_RD                  0x0004
#define MASK_AON_APB_INT_REQ_CM4_SOFT                       0x0002
#define MASK_AON_APB_SP_CFG_BUS_SLEEP                       0x0001
#define MASK_AON_APB_DJTAG_WCN_SOFT_RST                     0x0800
#define MASK_AON_APB_DJTAG_SOFT_RST                         0x0400
#define MASK_AON_APB_DJTAG_PUB0_SOFT_RST                    0x0200
#define MASK_AON_APB_DJTAG_AON_SOFT_RST                     0x0100
#define MASK_AON_APB_DJTAG_AUDCP_SOFT_RST                   0x0080
#define MASK_AON_APB_DJTAG_WTLCP_SOFT_RST                   0x0040
#define MASK_AON_APB_DJTAG_PUBCP_SOFT_RST                   0x0020
#define MASK_AON_APB_DJTAG_MM_SOFT_RST                      0x0010
#define MASK_AON_APB_DJTAG_CDMA2K_SOFT_RST                  0x0008
#define MASK_AON_APB_DJTAG_GPU_SOFT_RST                     0x0004
#define MASK_AON_APB_DJTAG_APCPU_SOFT_RST                   0x0002
#define MASK_AON_APB_DJTAG_AP_SOFT_RST                      0x0001
#define MASK_AON_APB_RTC_CAL_CTL                            0x1FC00000
#define MASK_AON_APB_RTC_CAL_SEL                            0x200000
#define MASK_AON_APB_RTC_CAL_PRECISION                      0x1FE000
#define MASK_AON_APB_RC100M_DIV                             0x1F80
#define MASK_AON_APB_RC100M_CAL_DONE                        0x0040
#define MASK_AON_APB_RC100M_CAL_START                       0x0020
#define MASK_AON_APB_RC100M_ANA_SOFT_RST                    0x0010
#define MASK_AON_APB_RC100M_FORCE_EN                        0x0002
#define MASK_AON_APB_RC100M_AUTO_GATE_EN                    0x0001
#define MASK_AON_APB_LTE_PCCSCC_RFTI_CLK_SW_CFG             0xFF000000
#define MASK_AON_APB_CGM_UFS_AO_EN                          0x800000
#define MASK_AON_APB_CGM_LPLL1_WTLCP_SEL                    0x200000
#define MASK_AON_APB_CGM_LPLL0_WTLCP_SEL                    0x100000
#define MASK_AON_APB_CGM_CM4_TMR2_EN                        0x80000
#define MASK_AON_APB_DET_32K_EB                             0x40000
#define MASK_AON_APB_CGM_DEBOUNCE_EN                        0x20000
#define MASK_AON_APB_CGM_RC100M_FDK_EN                      0x10000
#define MASK_AON_APB_CGM_RC100M_REF_EN                      0x8000
#define MASK_AON_APB_CGM_TMR_EN                             0x4000
#define MASK_AON_APB_CGM_TSEN_EN                            0x2000
#define MASK_AON_APB_CGM_OTG_REF_EN                         0x1000
#define MASK_AON_APB_CGM_DMC_REF_EN                         0x0800
#define MASK_AON_APB_CGM_DPHY_REF_EN                        0x0400
#define MASK_AON_APB_CGM_DJTAG_TCK_EN                       0x0200
#define MASK_AON_APB_CGM_DSI_CSI_TEST_EB                    0x0100
#define MASK_AON_APB_CGM_MDAR_CHK_EN                        0x0080
#define MASK_AON_APB_CGM_LVDSRF_CALI_EN                     0x0020
#define MASK_AON_APB_CGM_RFTI2_XO_EN                        0x0008
#define MASK_AON_APB_CGM_RFTI1_XO_EN                        0x0002
#define MASK_AON_APB_CGM_RFTI_SBI_EN                        0x0001
#define MASK_AON_APB_SOFT_DDR0_CKG_1X_EN                    0x4000000
#define MASK_AON_APB_SOFT_DDR0_DATA_RET                     0x800000
#define MASK_AON_APB_LIGHT_SLEEP_DDR0_DATA_RET_EN           0x200000
#define MASK_AON_APB_EMC0_CKG_SEL_LOAD                      0x80000
#define MASK_AON_APB_CLK_DEBUG_TS_EB                        0x40000
#define MASK_AON_APB_AAPC_CLK_TEST_EB                       0x10000
#define MASK_AON_APB_CGM_CPHY_CFG_EN                        0x8000
#define MASK_AON_APB_ALL_PLL_TEST_EB                        0x4000
#define MASK_AON_APB_CGM_WCDMA_ICI_EN                       0x2000
#define MASK_AON_APB_CGM_RFTI_RX_WD_EN                      0x1000
#define MASK_AON_APB_CGM_RFTI_TX_WD_EN                      0x0800
#define MASK_AON_APB_CGM_WCDMA_EN                           0x0400
#define MASK_AON_APB_CGM_EMMC_2X_EN                         0x0200
#define MASK_AON_APB_CGM_EMMC_1X_EN                         0x0100
#define MASK_AON_APB_CGM_SDIO2_1X_EN                        0x0080
#define MASK_AON_APB_CGM_SDIO2_2X_EN                        0x0040
#define MASK_AON_APB_CGM_SDIO1_1X_EN                        0x0020
#define MASK_AON_APB_CGM_SDIO1_2X_EN                        0x0010
#define MASK_AON_APB_CGM_SDIO0_1X_EN                        0x0008
#define MASK_AON_APB_CGM_SDIO0_2X_EN                        0x0004
#define MASK_AON_APB_CGM_AP_AXI_EN                          0x0002
#define MASK_AON_APB_CGM_CSSYS_EN                           0x0001
#define MASK_AON_APB_AUDCP_DSP_BOOT_VECTOR                  0xFFFFFFFF
#define MASK_AON_APB_AUDCP_STCK_DSP                         0x2000
#define MASK_AON_APB_AUDCP_STMS_DSP                         0x1000
#define MASK_AON_APB_AUDCP_STDO_DSP                         0x0800
#define MASK_AON_APB_AUDCP_STDI_DSP                         0x0400
#define MASK_AON_APB_AUDCP_STRTCK_DSP                       0x0200
#define MASK_AON_APB_AUDCP_SW_JTAG_ENA_DSP                  0x0100
#define MASK_AON_APB_AUDCP_DSP_EXTERNAL_WAIT                0x0002
#define MASK_AON_APB_AUDCP_DSP_BOOT                         0x0001
#define MASK_AON_APB_CM4_2_AUD_ACCESS_EN                    0x0040
#define MASK_AON_APB_AP_2_AUD_ACCESS_EN                     0x0020
#define MASK_AON_APB_CR5_2_AUD_ACCESS_EN                    0x0010
#define MASK_AON_APB_LDSP_2_AUD_ACCESS_EN                   0x0008
#define MASK_AON_APB_TGDSP_2_AUD_ACCESS_EN                  0x0004
#define MASK_AON_APB_AUDCP_FRC_CLK_DSP_EN                   0x0002
#define MASK_AON_APB_TOP_2_AUD_ACCESS_EN                    0x0001
#define MASK_AON_APB_WTLCP_LDSP_BOOT_VECTOR                 0xFFFFFFFF
#define MASK_AON_APB_WTLCP_STCK_LDSP                        0x2000
#define MASK_AON_APB_WTLCP_STMS_LDSP                        0x1000
#define MASK_AON_APB_WTLCP_STDO_LDSP                        0x0800
#define MASK_AON_APB_WTLCP_STDI_LDSP                        0x0400
#define MASK_AON_APB_WTLCP_STRTCK_LDSP                      0x0200
#define MASK_AON_APB_WTLCP_SW_JTAG_ENA_LDSP                 0x0100
#define MASK_AON_APB_WTLCP_LDSP_EXTERNAL_WAIT               0x0002
#define MASK_AON_APB_WTLCP_LDSP_BOOT                        0x0001
#define MASK_AON_APB_WTLCP_TDSP_BOOT_VECTOR                 0xFFFFFFFF
#define MASK_AON_APB_WTLCP_STCK_TDSP                        0x2000
#define MASK_AON_APB_WTLCP_STMS_TDSP                        0x1000
#define MASK_AON_APB_WTLCP_STDO_TDSP                        0x0800
#define MASK_AON_APB_WTLCP_STDI_TDSP                        0x0400
#define MASK_AON_APB_WTLCP_STRTCK_TDSP                      0x0200
#define MASK_AON_APB_WTLCP_SW_JTAG_ENA_TDSP                 0x0100
#define MASK_AON_APB_WTLCP_TDSP_EXTERNAL_WAIT               0x0002
#define MASK_AON_APB_WTLCP_TDSP_BOOT                        0x0001
#define MASK_AON_APB_WTLCP_EIC_SOFT_RST                     0x0100
#define MASK_AON_APB_WTLCP_EIC_EB                           0x0080
#define MASK_AON_APB_WTLCP_EIC_RTCDV5_EB                    0x0040
#define MASK_AON_APB_WTLCP_EIC_RTC_EB                       0x0020
#define MASK_AON_APB_WTLCP_AON_FRC_WSYS_LT_STOP             0x0010
#define MASK_AON_APB_WTLCP_AON_FRC_WSYS_STOP                0x0008
#define MASK_AON_APB_WTLCP_DSP_DEEP_SLEEP_EN                0x0004
#define MASK_AON_APB_WTLCP_WCMDA_EB                         0x10000
#define MASK_AON_APB_WCDMA_AUTO_GATE_EN                     0x0100
#define MASK_AON_APB_WTLCP_WTLSYS_RFTI_TX_EB                0x0002
#define MASK_AON_APB_WTLCP_WTLSYS_RFTI_RX_EB                0x0001
#define MASK_AON_APB_PUBCP_SYST_RTC_EB                      0x0800
#define MASK_AON_APB_PUBCP_TMR_EB                           0x0400
#define MASK_AON_APB_PUBCP_TMR_RTC_EB                       0x0200
#define MASK_AON_APB_PUBCP_SYST_EB                          0x0100
#define MASK_AON_APB_PUBCP_WDG_EB                           0x0080
#define MASK_AON_APB_PUBCP_WDG_RTC_EB                       0x0040
#define MASK_AON_APB_PUBCP_ARCH_RTC_EB                      0x0020
#define MASK_AON_APB_PUBCP_EIC_EB                           0x0010
#define MASK_AON_APB_PUBCP_EIC_RTCDV5_EB                    0x0008
#define MASK_AON_APB_PUBCP_EIC_RTC_EB                       0x0004
#define MASK_AON_APB_PUBCP_CR5_CORE_SOFT_RST                0x0400
#define MASK_AON_APB_PUBCP_CR5_DBG_SOFT_RST                 0x0200
#define MASK_AON_APB_PUBCP_CR5_ETM_SOFT_RST                 0x0100
#define MASK_AON_APB_PUBCP_CR5_MP_SOFT_RST                  0x0080
#define MASK_AON_APB_PUBCP_CR5_CS_DBG_SOFT_RST              0x0040
#define MASK_AON_APB_PUBCP_TMR_SOFT_RST                     0x0020
#define MASK_AON_APB_PUBCP_SYST_SOFT_RST                    0x0010
#define MASK_AON_APB_PUBCP_WDG_SOFT_RST                     0x0008
#define MASK_AON_APB_PUBCP_EIC_SOFT_RST                     0x0004
#define MASK_AON_APB_AON_ACCESS_PUBCP                       0x2000
#define MASK_AON_APB_PUBCP_CR5_STANDBYWFI_N                 0x1000
#define MASK_AON_APB_PUBCP_CR5_STANDBYWFE_N                 0x0800
#define MASK_AON_APB_PUBCP_CR5_CLKSTOPPED0_N                0x0400
#define MASK_AON_APB_PUBCP_CR5_L2IDLE                       0x0200
#define MASK_AON_APB_PUBCP_CR5_VALIRQ0_N                    0x0100
#define MASK_AON_APB_PUBCP_CR5_VALFIQ0_N                    0x0080
#define MASK_AON_APB_PUBCP_CR5_STOP                         0x0040
#define MASK_AON_APB_PUBCP_CR5_CSYSACK_ATB                  0x0020
#define MASK_AON_APB_PUBCP_CR5_CACTIVE_ATB                  0x0010
#define MASK_AON_APB_PUBCP_CR5_CSSYNC_REQ                   0x0008
#define MASK_AON_APB_PUBCP_CR5_CSYSREQ_ATB                  0x0004
#define MASK_AON_APB_PUBCP_CR5_NODBGCLK                     0x0002
#define MASK_AON_APB_PUBCP_CR5_CFGEE                        0x0001
#define MASK_AON_APB_PUBCP_FRC_STOP_ACK                     0x0100
#define MASK_AON_APB_PUBCP_FRC_STOP_REQ                     0x0001
#define MASK_AON_APB_USB_BUSCLK_SEL_SOC                     0x0004
#define MASK_AON_APB_USB_DIVN_MUX_SEL                       0x0002
#define MASK_AON_APB_AON_IIS_SEL                            0x0001
#define MASK_AON_APB_BSMTMR_SOFT_RST                        0x0080
#define MASK_AON_APB_RFTI2_LTH_SOFT_RST                     0x0040
#define MASK_AON_APB_RFTI1_LTH_SOFT_RST                     0x0020
#define MASK_AON_APB_CSSYS_SOFT_RST                         0x0010
#define MASK_AON_APB_RFTI_SBI_SOFT_RST                      0x0002
#define MASK_AON_APB_LVDSRF_CALI_SOFT_RST                   0x0001
#define MASK_AON_APB_INT_REQ_DCAM2_ARM_STAT                 0x0200
#define MASK_AON_APB_INT_REQ_DCAM1_ARM_STAT                 0x0100
#define MASK_AON_APB_INT_REQ_DCAM0_ARM_STAT                 0x0080
#define MASK_AON_APB_INT_REQ_ISP_CH1_STAT                   0x0040
#define MASK_AON_APB_INT_REQ_ISP_CH0_STAT                   0x0020
#define MASK_AON_APB_INT_REQ_DCAM2_ARM_MASK                 0x0010
#define MASK_AON_APB_INT_REQ_DCAM1_ARM_MASK                 0x0008
#define MASK_AON_APB_INT_REQ_DCAM0_ARM_MASK                 0x0004
#define MASK_AON_APB_INT_REQ_ISP_CH1_MASK                   0x0002
#define MASK_AON_APB_INT_REQ_ISP_CH0_MASK                   0x0001
#define MASK_AON_APB_BSM_TMR_EB                             0x0002
#define MASK_AON_APB_DBGSYS_CSSYS_STM_NSGUAREN              0x10000
#define MASK_AON_APB_DJTAG_SRC_MUX_SEL                      0x0001
#define MASK_AON_APB_FUSEBOX_SELECT_BUFFER_SW               0x0008
#define MASK_AON_APB_EFUSE_MUX_SEL_SW_DEFAULT0              0x0004
#define MASK_AON_APB_EFUSE_MUX_SEL_SW_DEFAULT1              0x0002
#define MASK_AON_APB_EFUSE_MUX_SEL_SW                       0x0001
#define MASK_AON_APB_OTG_TXPREEMPPULSETUNE                  0x100000
#define MASK_AON_APB_OTG_TXRESTUNE                          0xC0000
#define MASK_AON_APB_OTG_TXHSXVTUNE                         0x30000
#define MASK_AON_APB_OTG_TXVREFTUNE                         0xF000
#define MASK_AON_APB_OTG_TXPREEMPAMPTUNE                    0x0C00
#define MASK_AON_APB_OTG_TXRISETUNE                         0x0300
#define MASK_AON_APB_OTG_TXFSLSTUNE                         0x00F0
#define MASK_AON_APB_OTG_SQRXTUNE                           0x0007
#define MASK_AON_APB_OTG_ATERESET                           0x80000000
#define MASK_AON_APB_OTG_VBUS_VALID_PHYREG                  0x1000000
#define MASK_AON_APB_OTG_VBUS_VALID_PHYREG_SEL              0x800000
#define MASK_AON_APB_OTG_TESTBURNIN                         0x200000
#define MASK_AON_APB_OTG_LOOPBACKENB                        0x100000
#define MASK_AON_APB_OTG_TESTDATAOUT                        0xF0000
#define MASK_AON_APB_OTG_VATESTENB                          0xC000
#define MASK_AON_APB_USB2_CON_TESTMODE                      0x80000000
#define MASK_AON_APB_UTMI_WIDTH_SEL                         0x40000000
#define MASK_AON_APB_OTG_SS_SCALEDOWNMODE                   0x6000000
#define MASK_AON_APB_OTG_DMPULLDOWN                         0x200000
#define MASK_AON_APB_OTG_DPPULLDOWN                         0x100000
#define MASK_AON_APB_OTG_COMMONONN                          0x0100
#define MASK_AON_APB_USB2_PHY_IDDIG                         0x0008
#define MASK_AON_APB_OTG_FSEL                               0x0007
#define MASK_AON_APB_USB20_SAMPLER_SEL                      0x100000
#define MASK_AON_APB_HSIC_PLLON                             0x10000
#define MASK_AON_APB_USB20_S_ID                             0x4000
#define MASK_AON_APB_USB_REF_CLK_MUX_SEL                    0x0001
#define MASK_AON_APB_THM0_CALI_RSVD                         0x00FF
#define MASK_AON_APB_THM1_CALI_RSVD                         0x00FF
#define MASK_AON_APB_THM2_CALI_RSVD                         0x00FF
#define MASK_AON_APB_THM2_INT_ADIE_EN                       0x0400
#define MASK_AON_APB_THM1_INT_ADIE_EN                       0x0200
#define MASK_AON_APB_THM0_INT_ADIE_EN                       0x0100
#define MASK_AON_APB_THM2_OVERHEAT_ALARM_ADIE_EN            0x0040
#define MASK_AON_APB_THM1_OVERHEAT_ALARM_ADIE_EN            0x0020
#define MASK_AON_APB_THM0_OVERHEAT_ALARM_ADIE_EN            0x0010
#define MASK_AON_APB_THM2_OVERHEAT_RST_DDIE_EN              0x0004
#define MASK_AON_APB_THM1_OVERHEAT_RST_DDIE_EN              0x0002
#define MASK_AON_APB_THM0_OVERHEAT_RST_DDIE_EN              0x0001
#define MASK_AON_APB_CP_SIM1_CLK_PL                         0x0020
#define MASK_AON_APB_CP_SIM1_DETECT_EN                      0x0010
#define MASK_AON_APB_CP_BAT1_DETECT_EN                      0x0008
#define MASK_AON_APB_CP_SIM1_DETECT_POL                     0x0004
#define MASK_AON_APB_CP_BAT1_DETECT_POL                     0x0002
#define MASK_AON_APB_CP_SIM1_OFF_PD_EN                      0x0001
#define MASK_AON_APB_CP_SIM2_CLK_PL                         0x0020
#define MASK_AON_APB_CP_SIM2_DETECT_EN                      0x0010
#define MASK_AON_APB_CP_BAT2_DETECT_EN                      0x0008
#define MASK_AON_APB_CP_SIM2_DETECT_POL                     0x0004
#define MASK_AON_APB_CP_BAT2_DETECT_POL                     0x0002
#define MASK_AON_APB_CP_SIM2_OFF_PD_EN                      0x0001
#define MASK_AON_APB_CP_SIM3_CLK_PL                         0x0020
#define MASK_AON_APB_CP_SIM3_DETECT_EN                      0x0010
#define MASK_AON_APB_CP_BAT3_DETECT_EN                      0x0008
#define MASK_AON_APB_CP_SIM3_DETECT_POL                     0x0004
#define MASK_AON_APB_CP_BAT3_DETECT_POL                     0x0002
#define MASK_AON_APB_CP_SIM3_OFF_PD_EN                      0x0001
#define MASK_AON_APB_AP_SIM_CLK_PL                          0x0020
#define MASK_AON_APB_AP_SIM_DETECT_EN                       0x0010
#define MASK_AON_APB_AP_BAT_DETECT_EN                       0x0008
#define MASK_AON_APB_AP_SIM_DETECT_POL                      0x0004
#define MASK_AON_APB_AP_BAT_DETECT_POL                      0x0002
#define MASK_AON_APB_AP_SIM_OFF_PD_EN                       0x0001
#define MASK_AON_APB_PU_NUM_AON_MTX_M3                      0xFF000000
#define MASK_AON_APB_PU_NUM_AON_MTX_M2                      0xFF0000
#define MASK_AON_APB_PU_NUM_AON_MTX_M1                      0xFF00
#define MASK_AON_APB_PU_NUM_AON_MTX_M0                      0x00FF
#define MASK_AON_APB_PU_NUM_AON_MTX_MAIN                    0xFF000000
#define MASK_AON_APB_PU_NUM_AON_MTX_M6                      0xFF0000
#define MASK_AON_APB_PU_NUM_AON_MTX_M5                      0xFF00
#define MASK_AON_APB_PU_NUM_AON_MTX_M4                      0x00FF
#define MASK_AON_APB_PU_NUM_AON_MTX_S3                      0xFF000000
#define MASK_AON_APB_PU_NUM_AON_MTX_S2                      0xFF0000
#define MASK_AON_APB_PU_NUM_AON_MTX_S1                      0xFF00
#define MASK_AON_APB_PU_NUM_AON_MTX_S0                      0x00FF
#define MASK_AON_APB_PU_NUM_AON_MTX_S7                      0xFF000000
#define MASK_AON_APB_PU_NUM_AON_MTX_S6                      0xFF0000
#define MASK_AON_APB_PU_NUM_AON_MTX_S5                      0xFF00
#define MASK_AON_APB_PU_NUM_AON_MTX_S4                      0x00FF
#define MASK_AON_APB_PU_NUM_AXI_CM4_TO_AON                  0xFF000000
#define MASK_AON_APB_PU_NUM_AON2DDR_ASYNC_BRIDGE_W          0xFF0000
#define MASK_AON_APB_PU_NUM_AON_MTX_S9                      0xFF00
#define MASK_AON_APB_PU_NUM_AON_MTX_S8                      0x00FF
#define MASK_AON_APB_PU_NUM_WCDMA_REGSLICE                  0xFF000000
#define MASK_AON_APB_PU_NUM_APCPU_AP_REGSLICE               0xFF0000
#define MASK_AON_APB_PU_NUM_AP_MM_REGSLICE                  0xFF00
#define MASK_AON_APB_PU_NUM_AP_GPU_REGSLICE                 0x00FF
#define MASK_AON_APB_PU_NUM_ISP2DDR_REGSLICE                0xFF000000
#define MASK_AON_APB_PU_NUM_AP2DDR_REGSLICE                 0xFF0000
#define MASK_AON_APB_PU_NUM_DPU2DDR_REGSLICE                0xFF00
#define MASK_AON_APB_PU_NUM_GPU2DDR_REGSLICE                0x00FF
#define MASK_AON_APB_PU_NUM_PUBCP2WTLCP_REGSLICE            0xFF000000
#define MASK_AON_APB_PU_NUM_APCPU2DDR_REGSLICE              0xFF0000
#define MASK_AON_APB_PU_NUM_AUDCP2DDR_REGSLICE              0xFF00
#define MASK_AON_APB_PU_NUM_DCAM2DDR_REGSLICE               0x00FF
#define MASK_AON_APB_PU_NUM_WTL2DDR_REGSLICE                0xFF000000
#define MASK_AON_APB_PU_NUM_AON_MTX_S10                     0xFF0000
#define MASK_AON_APB_PU_NUM_AON_MTX_M7                      0xFF00
#define MASK_AON_APB_PU_NUM_PUBCP2WTL_ASYNC_BRIDGE          0x00FF
#define MASK_AON_APB_MONITOR_GATE_AUTO_EN_STATUS            0x00F0
#define MASK_AON_APB_MONITOR_WAIT_EN_STATUS                 0x000F
#define MASK_AON_APB_APCPU_LP_NUM_DEBUG_PWR                 0x1FFFE
#define MASK_AON_APB_APCPU_LP_EB_DEBUG_PWR                  0x0001
#define MASK_AON_APB_APCPU_LP_NUM_GIC_COL                   0x1FFFE
#define MASK_AON_APB_APCPU_LP_EB_GIC_COL                    0x0001
#define MASK_AON_APB_APCPU_CLUSTER_ATB_LP_NUM               0x1FFFE
#define MASK_AON_APB_APCPU_CLUSTER_ATB_LP_EB                0x0001
#define MASK_AON_APB_APCPU_CLUSTER_APB_LP_NUM               0x1FFFE
#define MASK_AON_APB_APCPU_CLUSTER_APB_LP_EB                0x0001
#define MASK_AON_APB_APCPU_CLUSTER_GIC_LP_NUM               0x1FFFE
#define MASK_AON_APB_APCPU_CLUSTER_GIC_LP_EB                0x0001
#define MASK_AON_APB_APCPU_GIC600_GIC_LP_NUM                0x1FFFE
#define MASK_AON_APB_APCPU_GIC600_GIC_LP_EB                 0x0001
#define MASK_AON_APB_APCPU_DBG_BLK_LP_NUM                   0x1FFFE
#define MASK_AON_APB_APCPU_DBG_BLK_LP_EB                    0x0001
#define MASK_AON_APB_APCPU_TOP_MTX_LP_NUM                   0x1FFFE00
#define MASK_AON_APB_APCPU_TOP_MTX_MIAN_LP_EB               0x0100
#define MASK_AON_APB_APCPU_TOP_MTX_S3_LP_EB                 0x0080
#define MASK_AON_APB_APCPU_TOP_MTX_S1_LP_EB                 0x0020
#define MASK_AON_APB_APCPU_TOP_MTX_S0_LP_EB                 0x0010
#define MASK_AON_APB_APCPU_TOP_MTX_M3_LP_EB                 0x0008
#define MASK_AON_APB_APCPU_TOP_MTX_M2_LP_EB                 0x0004
#define MASK_AON_APB_APCPU_TOP_MTX_M1_LP_EB                 0x0002
#define MASK_AON_APB_APCPU_TOP_MTX_M0_LP_EB                 0x0001
#define MASK_AON_APB_APCPU_ACE_PU_NUM                       0xFF00
#define MASK_AON_APB_APCPU_MTX_PU_NUM                       0x00FF
#define MASK_AON_APB_APCPU_CLUSTER_SCU_LP_NUM               0x1FFFE
#define MASK_AON_APB_APCPU_CLUSTER_SCU_LP_EB                0x0001
#define MASK_AON_APB_APCPU_DDR_AB_LP_NUM                    0x1FFFE
#define MASK_AON_APB_APCPU_DDR_AB_LP_EB                     0x0001
#define MASK_AON_APB_QOS_DAP_APCPU                          0xF00000
#define MASK_AON_APB_QOS_ETR_APCPU                          0xF0000
#define MASK_AON_APB_ARQOS_THRESHOLD_APCPU                  0xF000
#define MASK_AON_APB_AWQOS_THRESHOLD_APCPU                  0x0F00
#define MASK_AON_APB_ARQOS_APCPU                            0x00F0
#define MASK_AON_APB_AWQOS_APCPU                            0x000F
#define MASK_AON_APB_CGM_MPLL0_APCPU_FORCE_EN               0x0200
#define MASK_AON_APB_CGM_MPLL0_APCPU_AUTO_GATE_SEL          0x0100
#define MASK_AON_APB_MPLL0_WAIT_FORCE_EN                    0x0004
#define MASK_AON_APB_MPLL0_WAIT_AUTO_GATE_SEL               0x0002
#define MASK_AON_APB_MPLL0_SOFT_CNT_DONE                    0x0001
#define MASK_AON_APB_CGM_MPLL1_APCPU_FORCE_EN               0x0200
#define MASK_AON_APB_CGM_MPLL1_APCPU_AUTO_GATE_SEL          0x0100
#define MASK_AON_APB_MPLL1_WAIT_FORCE_EN                    0x0004
#define MASK_AON_APB_MPLL1_WAIT_AUTO_GATE_SEL               0x0002
#define MASK_AON_APB_MPLL1_SOFT_CNT_DONE                    0x0001
#define MASK_AON_APB_CGM_MPLL2_APCPU_FORCE_EN               0x0200
#define MASK_AON_APB_CGM_MPLL2_APCPU_AUTO_GATE_SEL          0x0100
#define MASK_AON_APB_MPLL2_WAIT_FORCE_EN                    0x0004
#define MASK_AON_APB_MPLL2_WAIT_AUTO_GATE_SEL               0x0002
#define MASK_AON_APB_MPLL2_SOFT_CNT_DONE                    0x0001
#define MASK_AON_APB_CGM_DPLL0_2666M_PUB_FORCE_EN           0x0100
#define MASK_AON_APB_CGM_DPLL0_2666M_PUB_AUTO_GATE_SEL      0x0040
#define MASK_AON_APB_DPLL0_WAIT_FORCE_EN                    0x0010
#define MASK_AON_APB_DPLL0_WAIT_AUTO_GATE_SEL               0x0004
#define MASK_AON_APB_DPLL0_SOFT_CNT_DONE                    0x0001
#define MASK_AON_APB_PUB_APB_FW_EB                          0x20000
#define MASK_AON_APB_PUB_REG_EB                             0x10000
#define MASK_AON_APB_DMC_EB                                 0x8000
#define MASK_AON_APB_PHY_VREF_ADJ                           0x03FC
#define MASK_AON_APB_PHY_VREF_PD                            0x0002
#define MASK_AON_APB_PHY_VREF_HI_C                          0x0001
#define MASK_AON_APB_WCN_PMU_SDIO_CTRL0                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_CTRL1                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_CTRL2                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_CTRL3                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_STAT0                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_STAT1                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_STAT2                     0xFFFFFFFF
#define MASK_AON_APB_WCN_PMU_SDIO_STAT3                     0xFFFFFFFF
#define MASK_AON_APB_AON_MTX_M7_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M7_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S10_LP_NUM                     0x1FFFE
#define MASK_AON_APB_AON_MTX_S10_LP_EB                      0x0001
#define MASK_AON_APB_UART_JTAG_SEL                          0x0008
#define MASK_AON_APB_USB_BYPASS_SEL                         0x0004
#define MASK_AON_APB_DAP_USB_JTAG_SEL                       0x0002
#define MASK_AON_APB_USB_JTAG_HW_SEL_EN                     0x0001
#define MASK_AON_APB_PUBCP2WTL_ASYNC_BRIDGE_LP_NUM          0x1FFFE
#define MASK_AON_APB_PUBCP2WTL_ASYNC_BRIDGE_LP_EB           0x0001
#define MASK_AON_APB_CM4_TO_AON_AXI_LP_NUM                  0x1FFFE
#define MASK_AON_APB_CM4_TO_AON_AXI_LP_EB                   0x0001
#define MASK_AON_APB_AON_MTX_MAIN_LP_NUM                    0x1FFFE
#define MASK_AON_APB_AON_MTX_MAIN_LP_EB                     0x0001
#define MASK_AON_APB_AON_MTX_M0_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M0_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_M1_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M1_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_M2_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M2_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_M3_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M3_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_M4_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M4_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_M5_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M5_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_M6_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_M6_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S0_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S0_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S1_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S1_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S2_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S2_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S3_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S3_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S4_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S4_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S5_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S5_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S6_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S6_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S7_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S7_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S8_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S8_LP_EB                       0x0001
#define MASK_AON_APB_AON_MTX_S9_LP_NUM                      0x1FFFE
#define MASK_AON_APB_AON_MTX_S9_LP_EB                       0x0001
#define MASK_AON_APB_AP2GPU_SLICE_LP_NUM                    0x1FFFE
#define MASK_AON_APB_AP2GPU_SLICE_LP_EB                     0x0001
#define MASK_AON_APB_AP2MM_SLICE_LP_NUM                     0x1FFFE
#define MASK_AON_APB_AP2MM_SLICE_LP_EB                      0x0001
#define MASK_AON_APB_WTL2DDR_SLICE_LP_NUM                   0x1FFFE
#define MASK_AON_APB_WTL2DDR_SLICE_LP_EB                    0x0001
#define MASK_AON_APB_APCPU2AP_SLICE_LP_NUM                  0x1FFFE
#define MASK_AON_APB_APCPU2AP_SLICE_LP_EB                   0x0001
#define MASK_AON_APB_AUDCP2DDR_SLICE_LP_NUM                 0x1FFFE
#define MASK_AON_APB_AUDCP2DDR_SLICE_LP_EB                  0x0001
#define MASK_AON_APB_APCPU2DDR_SLICE_LP_NUM                 0x1FFFE
#define MASK_AON_APB_APCPU2DDR_SLICE_LP_EB                  0x0001
#define MASK_AON_APB_AON2DDR_ASYNC_BRIDGE_LP_NUM            0x1FFFE
#define MASK_AON_APB_AON2DDR_ASYNC_BRIDGE_LP_EB             0x0001
#define MASK_AON_APB_PUBCP2WTLCP_SLICE_LP_NUM               0x1FFFE
#define MASK_AON_APB_PUBCP2WTLCP_SLICE_LP_EB                0x0001
#define MASK_AON_APB_DCAM2DDR_SLICE_LP_NUM                  0x1FFFE
#define MASK_AON_APB_DCAM2DDR_SLICE_LP_EB                   0x0001
#define MASK_AON_APB_DPU2DDR_SLICE_LP_NUM                   0x1FFFE
#define MASK_AON_APB_DPU2DDR_SLICE_LP_EB                    0x0001
#define MASK_AON_APB_GPU2DDR_SLICE_LP_NUM                   0x1FFFE
#define MASK_AON_APB_GPU2DDR_SLICE_LP_EB                    0x0001
#define MASK_AON_APB_ISP2DDR_SLICE_LP_NUM                   0x1FFFE
#define MASK_AON_APB_ISP2DDR_SLICE_LP_EB                    0x0001
#define MASK_AON_APB_AP2DDR_SLICE_LP_NUM                    0x1FFFE
#define MASK_AON_APB_AP2DDR_SLICE_LP_EB                     0x0001
#define MASK_AON_APB_AON_APB_MASTER_BUSY                    0x00FC
#define MASK_AON_APB_AON_APB_FREQ_CTRL_EN                   0x0002
#define MASK_AON_APB_AON_APB_IDLE_EN                        0x0001
#define MASK_AON_APB_CLK_26MHZ_AUD_CP_ADC_EN                0x0010
#define MASK_AON_APB_CLK_26MHZ_AUD_AP_ADC_EN                0x0008
#define MASK_AON_APB_CLK_26MHZ_AUD_CAL_EN                   0x0004
#define MASK_AON_APB_CLK_26MHZ_AUD_DVFS_EN                  0x0002
#define MASK_AON_APB_CLK_26MHZ_AUD_EN                       0x0001
#define MASK_AON_APB_ANALOG_BB_TOP_SINDRV_ENA_AUTO_EN       0x0040
#define MASK_AON_APB_R2G_ANALOG_BB_TOP_SINDRV_ENA           0x0020
#define MASK_AON_APB_M2G_ANALOG_BB_TOP_SINDRV_ENA           0x0010
#define MASK_AON_APB_R2G_ANALOG_BB_TOP_SINDRV_ENA_SQUARE    0x0008
#define MASK_AON_APB_R2G_ANALOG_BB_TOP_SINDRV_ENA_ADC       0x0004
#define MASK_AON_APB_R2G_ANALOG_BB_TOP_SINDRV_ENA_DVFS      0x0002
#define MASK_AON_APB_R2G_ANALOG_BB_TOP_SINDRV_ENA_CAL       0x0001
#define MASK_AON_APB_AP_EMMC_IO_POWER_OFF_DELAY             0x2000000
#define MASK_AON_APB_AP_EMMC_IO_POWER_OFF                   0x1000000
#define MASK_AON_APB_AP_EMMC_CARDDET_DBNC_THD_32K           0xFF0000
#define MASK_AON_APB_AP_EMMC_BATTERY_DBNC_THD_32K           0xFF00
#define MASK_AON_APB_AP_EMMC_CARDDET_DBNC_EN_32K            0x0080
#define MASK_AON_APB_AP_EMMC_BATTERY_DBNC_EN_32K            0x0040
#define MASK_AON_APB_AP_EMMC_BATTERY_DEB_EN_32K             0x0020
#define MASK_AON_APB_AP_EMMC_BATTERY_PRESENT_32K            0x0010
#define MASK_AON_APB_AP_EMMC_CARD_PROTECT_32K               0x0008
#define MASK_AON_APB_AP_EMMC_CARD_PRESENT_32K               0x0004
#define MASK_AON_APB_AP_EMMC_BATTERY_DET                    0x0002
#define MASK_AON_APB_AP_EMMC_CARD_DET                       0x0001
#define MASK_AON_APB_AP_SDIO0_IO_POWER_OFF_DELAY            0x2000000
#define MASK_AON_APB_AP_SDIO0_IO_POWER_OFF                  0x1000000
#define MASK_AON_APB_AP_SDIO0_CARDDET_DBNC_THD_32K          0xFF0000
#define MASK_AON_APB_AP_SDIO0_BATTERY_DBNC_THD_32K          0xFF00
#define MASK_AON_APB_AP_SDIO0_CARDDET_DBNC_EN_32K           0x0080
#define MASK_AON_APB_AP_SDIO0_BATTERY_DBNC_EN_32K           0x0040
#define MASK_AON_APB_AP_SDIO0_BATTERY_DEB_EN_32K            0x0020
#define MASK_AON_APB_AP_SDIO0_BATTERY_PRESENT_32K           0x0010
#define MASK_AON_APB_AP_SDIO0_CARD_PROTECT_32K              0x0008
#define MASK_AON_APB_AP_SDIO0_CARD_PRESENT_32K              0x0004
#define MASK_AON_APB_AP_SDIO0_BATTERY_DET                   0x0002
#define MASK_AON_APB_AP_SDIO0_CARD_DET                      0x0001
#define MASK_AON_APB_AP_SDIO1_IO_POWER_OFF_DELAY            0x2000000
#define MASK_AON_APB_AP_SDIO1_IO_POWER_OFF                  0x1000000
#define MASK_AON_APB_AP_SDIO1_CARDDET_DBNC_THD_32K          0xFF0000
#define MASK_AON_APB_AP_SDIO1_BATTERY_DBNC_THD_32K          0xFF00
#define MASK_AON_APB_AP_SDIO1_CARDDET_DBNC_EN_32K           0x0080
#define MASK_AON_APB_AP_SDIO1_BATTERY_DBNC_EN_32K           0x0040
#define MASK_AON_APB_AP_SDIO1_BATTERY_DEB_EN_32K            0x0020
#define MASK_AON_APB_AP_SDIO1_BATTERY_PRESENT_32K           0x0010
#define MASK_AON_APB_AP_SDIO1_CARD_PROTECT_32K              0x0008
#define MASK_AON_APB_AP_SDIO1_CARD_PRESENT_32K              0x0004
#define MASK_AON_APB_AP_SDIO1_BATTERY_DET                   0x0002
#define MASK_AON_APB_AP_SDIO1_CARD_DET                      0x0001
#define MASK_AON_APB_AP_SDIO2_IO_POWER_OFF_DELAY            0x2000000
#define MASK_AON_APB_AP_SDIO2_IO_POWER_OFF                  0x1000000
#define MASK_AON_APB_AP_SDIO2_CARDDET_DBNC_THD_32K          0xFF0000
#define MASK_AON_APB_AP_SDIO2_BATTERY_DBNC_THD_32K          0xFF00
#define MASK_AON_APB_AP_SDIO2_CARDDET_DBNC_EN_32K           0x0080
#define MASK_AON_APB_AP_SDIO2_BATTERY_DBNC_EN_32K           0x0040
#define MASK_AON_APB_AP_SDIO2_BATTERY_DEB_EN_32K            0x0020
#define MASK_AON_APB_AP_SDIO2_BATTERY_PRESENT_32K           0x0010
#define MASK_AON_APB_AP_SDIO2_CARD_PROTECT_32K              0x0008
#define MASK_AON_APB_AP_SDIO2_CARD_PRESENT_32K              0x0004
#define MASK_AON_APB_AP_SDIO2_BATTERY_DET                   0x0002
#define MASK_AON_APB_AP_SDIO2_CARD_DET                      0x0001
#define MASK_AON_APB_PUBCP_SDIO0_IO_POWER_OFF_DELAY         0x2000000
#define MASK_AON_APB_PUBCP_SDIO0_IO_POWER_OFF               0x1000000
#define MASK_AON_APB_PUBCP_SDIO0_CARDDET_DBNC_THD_32K       0xFF0000
#define MASK_AON_APB_PUBCP_SDIO0_BATTERY_DBNC_THD_32K       0xFF00
#define MASK_AON_APB_PUBCP_SDIO0_CARDDET_DBNC_EN_32K        0x0080
#define MASK_AON_APB_PUBCP_SDIO0_BATTERY_DBNC_EN_32K        0x0040
#define MASK_AON_APB_PUBCP_SDIO0_BATTERY_DEB_EN_32K         0x0020
#define MASK_AON_APB_PUBCP_SDIO0_BATTERY_PRESENT_32K        0x0010
#define MASK_AON_APB_PUBCP_SDIO0_CARD_PROTECT_32K           0x0008
#define MASK_AON_APB_PUBCP_SDIO0_CARD_PRESENT_32K           0x0004
#define MASK_AON_APB_PUBCP_SDIO0_BATTERY_DET                0x0002
#define MASK_AON_APB_PUBCP_SDIO0_CARD_DET                   0x0001
#define MASK_AON_APB_APCPU_INT_EN_31                        0x80000000
#define MASK_AON_APB_APCPU_INT_EN_30                        0x40000000
#define MASK_AON_APB_APCPU_INT_EN_29                        0x20000000
#define MASK_AON_APB_APCPU_INT_EN_28                        0x10000000
#define MASK_AON_APB_APCPU_INT_EN_27                        0x8000000
#define MASK_AON_APB_APCPU_INT_EN_26                        0x4000000
#define MASK_AON_APB_APCPU_INT_EN_25                        0x2000000
#define MASK_AON_APB_APCPU_INT_EN_24                        0x1000000
#define MASK_AON_APB_APCPU_INT_EN_23                        0x800000
#define MASK_AON_APB_APCPU_INT_EN_22                        0x400000
#define MASK_AON_APB_APCPU_INT_EN_21                        0x200000
#define MASK_AON_APB_APCPU_INT_EN_20                        0x100000
#define MASK_AON_APB_APCPU_INT_EN_19                        0x80000
#define MASK_AON_APB_APCPU_INT_EN_18                        0x40000
#define MASK_AON_APB_APCPU_INT_EN_17                        0x20000
#define MASK_AON_APB_APCPU_INT_EN_16                        0x10000
#define MASK_AON_APB_APCPU_INT_EN_15                        0x8000
#define MASK_AON_APB_APCPU_INT_EN_14                        0x4000
#define MASK_AON_APB_APCPU_INT_EN_13                        0x2000
#define MASK_AON_APB_APCPU_INT_EN_12                        0x1000
#define MASK_AON_APB_APCPU_INT_EN_11                        0x0800
#define MASK_AON_APB_APCPU_INT_EN_10                        0x0400
#define MASK_AON_APB_APCPU_INT_EN_9                         0x0200
#define MASK_AON_APB_APCPU_INT_EN_8                         0x0100
#define MASK_AON_APB_APCPU_INT_EN_7                         0x0080
#define MASK_AON_APB_APCPU_INT_EN_6                         0x0040
#define MASK_AON_APB_APCPU_INT_EN_5                         0x0020
#define MASK_AON_APB_APCPU_INT_EN_4                         0x0010
#define MASK_AON_APB_APCPU_INT_EN_3                         0x0008
#define MASK_AON_APB_APCPU_INT_EN_2                         0x0004
#define MASK_AON_APB_APCPU_INT_EN_1                         0x0002
#define MASK_AON_APB_APCPU_INT_EN_0                         0x0001
#define MASK_AON_APB_APCPU_INT_EN_63                        0x80000000
#define MASK_AON_APB_APCPU_INT_EN_62                        0x40000000
#define MASK_AON_APB_APCPU_INT_EN_61                        0x20000000
#define MASK_AON_APB_APCPU_INT_EN_60                        0x10000000
#define MASK_AON_APB_APCPU_INT_EN_59                        0x8000000
#define MASK_AON_APB_APCPU_INT_EN_58                        0x4000000
#define MASK_AON_APB_APCPU_INT_EN_57                        0x2000000
#define MASK_AON_APB_APCPU_INT_EN_56                        0x1000000
#define MASK_AON_APB_APCPU_INT_EN_55                        0x800000
#define MASK_AON_APB_APCPU_INT_EN_54                        0x400000
#define MASK_AON_APB_APCPU_INT_EN_53                        0x200000
#define MASK_AON_APB_APCPU_INT_EN_52                        0x100000
#define MASK_AON_APB_APCPU_INT_EN_51                        0x80000
#define MASK_AON_APB_APCPU_INT_EN_50                        0x40000
#define MASK_AON_APB_APCPU_INT_EN_49                        0x20000
#define MASK_AON_APB_APCPU_INT_EN_48                        0x10000
#define MASK_AON_APB_APCPU_INT_EN_47                        0x8000
#define MASK_AON_APB_APCPU_INT_EN_46                        0x4000
#define MASK_AON_APB_APCPU_INT_EN_45                        0x2000
#define MASK_AON_APB_APCPU_INT_EN_44                        0x1000
#define MASK_AON_APB_APCPU_INT_EN_43                        0x0800
#define MASK_AON_APB_APCPU_INT_EN_42                        0x0400
#define MASK_AON_APB_APCPU_INT_EN_41                        0x0200
#define MASK_AON_APB_APCPU_INT_EN_40                        0x0100
#define MASK_AON_APB_APCPU_INT_EN_39                        0x0080
#define MASK_AON_APB_APCPU_INT_EN_38                        0x0040
#define MASK_AON_APB_APCPU_INT_EN_37                        0x0020
#define MASK_AON_APB_APCPU_INT_EN_36                        0x0010
#define MASK_AON_APB_APCPU_INT_EN_35                        0x0008
#define MASK_AON_APB_APCPU_INT_EN_34                        0x0004
#define MASK_AON_APB_APCPU_INT_EN_33                        0x0002
#define MASK_AON_APB_APCPU_INT_EN_32                        0x0001
#define MASK_AON_APB_APCPU_INT_EN_95                        0x80000000
#define MASK_AON_APB_APCPU_INT_EN_94                        0x40000000
#define MASK_AON_APB_APCPU_INT_EN_93                        0x20000000
#define MASK_AON_APB_APCPU_INT_EN_92                        0x10000000
#define MASK_AON_APB_APCPU_INT_EN_91                        0x8000000
#define MASK_AON_APB_APCPU_INT_EN_90                        0x4000000
#define MASK_AON_APB_APCPU_INT_EN_89                        0x2000000
#define MASK_AON_APB_APCPU_INT_EN_88                        0x1000000
#define MASK_AON_APB_APCPU_INT_EN_87                        0x800000
#define MASK_AON_APB_APCPU_INT_EN_86                        0x400000
#define MASK_AON_APB_APCPU_INT_EN_85                        0x200000
#define MASK_AON_APB_APCPU_INT_EN_84                        0x100000
#define MASK_AON_APB_APCPU_INT_EN_83                        0x80000
#define MASK_AON_APB_APCPU_INT_EN_82                        0x40000
#define MASK_AON_APB_APCPU_INT_EN_81                        0x20000
#define MASK_AON_APB_APCPU_INT_EN_80                        0x10000
#define MASK_AON_APB_APCPU_INT_EN_79                        0x8000
#define MASK_AON_APB_APCPU_INT_EN_78                        0x4000
#define MASK_AON_APB_APCPU_INT_EN_77                        0x2000
#define MASK_AON_APB_APCPU_INT_EN_76                        0x1000
#define MASK_AON_APB_APCPU_INT_EN_75                        0x0800
#define MASK_AON_APB_APCPU_INT_EN_74                        0x0400
#define MASK_AON_APB_APCPU_INT_EN_73                        0x0200
#define MASK_AON_APB_APCPU_INT_EN_72                        0x0100
#define MASK_AON_APB_APCPU_INT_EN_71                        0x0080
#define MASK_AON_APB_APCPU_INT_EN_70                        0x0040
#define MASK_AON_APB_APCPU_INT_EN_69                        0x0020
#define MASK_AON_APB_APCPU_INT_EN_68                        0x0010
#define MASK_AON_APB_APCPU_INT_EN_67                        0x0008
#define MASK_AON_APB_APCPU_INT_EN_66                        0x0004
#define MASK_AON_APB_APCPU_INT_EN_65                        0x0002
#define MASK_AON_APB_APCPU_INT_EN_64                        0x0001
#define MASK_AON_APB_APCPU_INT_EN_127                       0x80000000
#define MASK_AON_APB_APCPU_INT_EN_126                       0x40000000
#define MASK_AON_APB_APCPU_INT_EN_125                       0x20000000
#define MASK_AON_APB_APCPU_INT_EN_124                       0x10000000
#define MASK_AON_APB_APCPU_INT_EN_123                       0x8000000
#define MASK_AON_APB_APCPU_INT_EN_122                       0x4000000
#define MASK_AON_APB_APCPU_INT_EN_121                       0x2000000
#define MASK_AON_APB_APCPU_INT_EN_120                       0x1000000
#define MASK_AON_APB_APCPU_INT_EN_119                       0x800000
#define MASK_AON_APB_APCPU_INT_EN_118                       0x400000
#define MASK_AON_APB_APCPU_INT_EN_117                       0x200000
#define MASK_AON_APB_APCPU_INT_EN_116                       0x100000
#define MASK_AON_APB_APCPU_INT_EN_115                       0x80000
#define MASK_AON_APB_APCPU_INT_EN_114                       0x40000
#define MASK_AON_APB_APCPU_INT_EN_113                       0x20000
#define MASK_AON_APB_APCPU_INT_EN_112                       0x10000
#define MASK_AON_APB_APCPU_INT_EN_111                       0x8000
#define MASK_AON_APB_APCPU_INT_EN_110                       0x4000
#define MASK_AON_APB_APCPU_INT_EN_109                       0x2000
#define MASK_AON_APB_APCPU_INT_EN_108                       0x1000
#define MASK_AON_APB_APCPU_INT_EN_107                       0x0800
#define MASK_AON_APB_APCPU_INT_EN_106                       0x0400
#define MASK_AON_APB_APCPU_INT_EN_105                       0x0200
#define MASK_AON_APB_APCPU_INT_EN_104                       0x0100
#define MASK_AON_APB_APCPU_INT_EN_103                       0x0080
#define MASK_AON_APB_APCPU_INT_EN_102                       0x0040
#define MASK_AON_APB_APCPU_INT_EN_101                       0x0020
#define MASK_AON_APB_APCPU_INT_EN_100                       0x0010
#define MASK_AON_APB_APCPU_INT_EN_99                        0x0008
#define MASK_AON_APB_APCPU_INT_EN_98                        0x0004
#define MASK_AON_APB_APCPU_INT_EN_97                        0x0002
#define MASK_AON_APB_APCPU_INT_EN_96                        0x0001
#define MASK_AON_APB_APCPU_INT_EN_159                       0x80000000
#define MASK_AON_APB_APCPU_INT_EN_158                       0x40000000
#define MASK_AON_APB_APCPU_INT_EN_157                       0x20000000
#define MASK_AON_APB_APCPU_INT_EN_156                       0x10000000
#define MASK_AON_APB_APCPU_INT_EN_155                       0x8000000
#define MASK_AON_APB_APCPU_INT_EN_154                       0x4000000
#define MASK_AON_APB_APCPU_INT_EN_153                       0x2000000
#define MASK_AON_APB_APCPU_INT_EN_152                       0x1000000
#define MASK_AON_APB_APCPU_INT_EN_151                       0x800000
#define MASK_AON_APB_APCPU_INT_EN_150                       0x400000
#define MASK_AON_APB_APCPU_INT_EN_149                       0x200000
#define MASK_AON_APB_APCPU_INT_EN_148                       0x100000
#define MASK_AON_APB_APCPU_INT_EN_147                       0x80000
#define MASK_AON_APB_APCPU_INT_EN_146                       0x40000
#define MASK_AON_APB_APCPU_INT_EN_145                       0x20000
#define MASK_AON_APB_APCPU_INT_EN_144                       0x10000
#define MASK_AON_APB_APCPU_INT_EN_143                       0x8000
#define MASK_AON_APB_APCPU_INT_EN_142                       0x4000
#define MASK_AON_APB_APCPU_INT_EN_141                       0x2000
#define MASK_AON_APB_APCPU_INT_EN_140                       0x1000
#define MASK_AON_APB_APCPU_INT_EN_139                       0x0800
#define MASK_AON_APB_APCPU_INT_EN_138                       0x0400
#define MASK_AON_APB_APCPU_INT_EN_137                       0x0200
#define MASK_AON_APB_APCPU_INT_EN_136                       0x0100
#define MASK_AON_APB_APCPU_INT_EN_135                       0x0080
#define MASK_AON_APB_APCPU_INT_EN_134                       0x0040
#define MASK_AON_APB_APCPU_INT_EN_133                       0x0020
#define MASK_AON_APB_APCPU_INT_EN_132                       0x0010
#define MASK_AON_APB_APCPU_INT_EN_131                       0x0008
#define MASK_AON_APB_APCPU_INT_EN_130                       0x0004
#define MASK_AON_APB_APCPU_INT_EN_129                       0x0002
#define MASK_AON_APB_APCPU_INT_EN_128                       0x0001
#define MASK_AON_APB_APCPU_INT_EN_191                       0x80000000
#define MASK_AON_APB_APCPU_INT_EN_190                       0x40000000
#define MASK_AON_APB_APCPU_INT_EN_189                       0x20000000
#define MASK_AON_APB_APCPU_INT_EN_188                       0x10000000
#define MASK_AON_APB_APCPU_INT_EN_187                       0x8000000
#define MASK_AON_APB_APCPU_INT_EN_186                       0x4000000
#define MASK_AON_APB_APCPU_INT_EN_185                       0x2000000
#define MASK_AON_APB_APCPU_INT_EN_184                       0x1000000
#define MASK_AON_APB_APCPU_INT_EN_183                       0x800000
#define MASK_AON_APB_APCPU_INT_EN_182                       0x400000
#define MASK_AON_APB_APCPU_INT_EN_181                       0x200000
#define MASK_AON_APB_APCPU_INT_EN_180                       0x100000
#define MASK_AON_APB_APCPU_INT_EN_179                       0x80000
#define MASK_AON_APB_APCPU_INT_EN_178                       0x40000
#define MASK_AON_APB_APCPU_INT_EN_177                       0x20000
#define MASK_AON_APB_APCPU_INT_EN_176                       0x10000
#define MASK_AON_APB_APCPU_INT_EN_175                       0x8000
#define MASK_AON_APB_APCPU_INT_EN_174                       0x4000
#define MASK_AON_APB_APCPU_INT_EN_173                       0x2000
#define MASK_AON_APB_APCPU_INT_EN_172                       0x1000
#define MASK_AON_APB_APCPU_INT_EN_171                       0x0800
#define MASK_AON_APB_APCPU_INT_EN_170                       0x0400
#define MASK_AON_APB_APCPU_INT_EN_169                       0x0200
#define MASK_AON_APB_APCPU_INT_EN_168                       0x0100
#define MASK_AON_APB_APCPU_INT_EN_167                       0x0080
#define MASK_AON_APB_APCPU_INT_EN_166                       0x0040
#define MASK_AON_APB_APCPU_INT_EN_165                       0x0020
#define MASK_AON_APB_APCPU_INT_EN_164                       0x0010
#define MASK_AON_APB_APCPU_INT_EN_163                       0x0008
#define MASK_AON_APB_APCPU_INT_EN_162                       0x0004
#define MASK_AON_APB_APCPU_INT_EN_161                       0x0002
#define MASK_AON_APB_APCPU_INT_EN_160                       0x0001
#define MASK_AON_APB_AP_WDG_RST_FLAG                        0x0040
#define MASK_AON_APB_PCP_WDG_RST_FLAG                       0x0020
#define MASK_AON_APB_WTLCP_LTE_WDG_RST_FLAG                 0x0010
#define MASK_AON_APB_WTLCP_TG_WDG_RST_FLAG                  0x0008
#define MASK_AON_APB_AUDCP_WDG_RST_FLAG                     0x0004
#define MASK_AON_APB_APCPU_WDG_RST_FLAG                     0x0002
#define MASK_AON_APB_SEC_WDG_RST_FLAG                       0x0001
#define MASK_AON_APB_BOND_OPTION0                           0xFFFFFFFF
#define MASK_AON_APB_BOND_OPTION1                           0xFFFFFFFF
#define MASK_AON_APB_RES_REG0                               0xFFFFFFFF
#define MASK_AON_APB_RES_REG1                               0xFFFFFFFF
#define MASK_AON_APB_RES_REG2                               0xFFFFFFFF
#define MASK_AON_APB_RES_REG3                               0xFFFFFFFF
#define MASK_AON_APB_RES_REG4                               0xFFFFFFFF
#define MASK_AON_APB_HPROT_DMAW                             0x00F0
#define MASK_AON_APB_HPROT_DMAR                             0x000F
#define MASK_AON_APB_REC_26MHZ_0_BUF_PD                     0x0100
#define MASK_AON_APB_SLEEP_PLLLOCK_SEL                      0x0080
#define MASK_AON_APB_PLL_LOCK_SEL                           0x0070
#define MASK_AON_APB_SLEEP_DBG_SEL                          0x000F
#define MASK_AON_APB_CPU2DDR_BRIDGE_DEBUG_SIGNAL_R          0xFFFFFFFF
#define MASK_AON_APB_AON2DDR_BRIDGE_DEBUG_SIGNAL_R          0xFFFFFFFF
#define MASK_AON_APB_AON2DDR_AXI_DETECTOR_OVERFLOW          0x0004
#define MASK_AON_APB_AON2DDR_RST_SUBSYS                     0x0002
#define MASK_AON_APB_AON2DDR_BRIDGE_TRANS_IDLE              0x0001
#define MASK_AON_APB_AUD2DDR_BRIDGE_DEBUG_SIGNAL_R          0xFFFFFFFF
#define MASK_AON_APB_PUBCP2WTL_BRIDGE_DEBUG_SIGNAL_R        0xFFFFFFFF
#define MASK_AON_APB_LEAKAGE_MAGIC_WORD                     0xFFFFFFFF
#define MASK_AON_APB_LEAKAGE_SWITCH                         0x0001
#define MASK_AON_APB_FUNC_TEST_BOOT_ADDR                    0xFFFFFFFF
#define MASK_AON_APB_CGM_RESCUE                             0xFFFFFFFF
#define MASK_AON_APB_SDIO2_SLICE_EN                         0x0008
#define MASK_AON_APB_CP_SDIO_ENABLE                         0x0004
#define MASK_AON_APB_AP_SDIO_ENABLE                         0x0002
#define MASK_AON_APB_SDIO_MODULE_SEL                        0x0001
#define MASK_AON_APB_SP_INT_REQ_BUSMON_PUBCP_WAKEUP_EN      0x80000000
#define MASK_AON_APB_SP_INT_REQ_BUSMON_AUDCP_WAKEUP_EN      0x40000000
#define MASK_AON_APB_SP_INT_REQ_ADI_WAKEUP_EN               0x20000000
#define MASK_AON_APB_SP_INT_REQ_PCP_WDG_WAKEUP_EN           0x10000000
#define MASK_AON_APB_SP_INT_REQ_PWR_DOWN_ALL_WAKEUP_EN      0x8000000
#define MASK_AON_APB_SP_INT_REQ_PWR_UP_ALL_WAKEUP_EN        0x4000000
#define MASK_AON_APB_SP_INT_REQ_AP_WDG_RST_WAKEUP_EN        0x2000000
#define MASK_AON_APB_SP_INT_REQ_APCPU_WDG_RST_WAKEUP_EN     0x1000000
#define MASK_AON_APB_SP_INT_REQ_SEC_EIC_WAKEUP_EN           0x800000
#define MASK_AON_APB_SP_INT_REQ_SEC_TMR_WAKEUP_EN           0x400000
#define MASK_AON_APB_SP_INT_REQ_SEC_WDG_WAKEUP_EN           0x200000
#define MASK_AON_APB_SP_INT_REQ_SEC_RTC_WAKEUP_EN           0x100000
#define MASK_AON_APB_SP_INT_REQ_SEC_GPIO_WAKEUP_EN          0x80000
#define MASK_AON_APB_SP_INT_REQ_MBOX_SRC_SIPC_SP_CM4_WAKEUP_EN 0x40000
#define MASK_AON_APB_SP_INT_REQ_MBOX_SRC_CM4_WAKEUP_EN      0x20000
#define MASK_AON_APB_SP_INT_REQ_MBOX_TAR_CM4_WAKEUP_EN      0x10000
#define MASK_AON_APB_SP_INT_REQ_CM4_SOFT_WAKEUP_EN          0x8000
#define MASK_AON_APB_SP_INT_FPU_EXCEPTION_WAKEUP_EN         0x4000
#define MASK_AON_APB_SP_INT_REQ_EIC_GPIO_NON_LAT_WAKEUP_EN  0x2000
#define MASK_AON_APB_SP_INT_REQ_EIC_GPIO_LAT_WAKEUP_EN      0x1000
#define MASK_AON_APB_SP_INT_REQ_EIC_NON_LAT_WAKEUP_EN       0x0800
#define MASK_AON_APB_SP_INT_REQ_EIC_LAT_WAKEUP_EN           0x0400
#define MASK_AON_APB_SP_INT_REQ_CM4_DMA_WAKEUP_EN           0x0200
#define MASK_AON_APB_SP_INT_REQ_CM4_GPIO_WAKEUP_EN          0x0100
#define MASK_AON_APB_SP_INT_REQ_CM4_SYST_WAKEUP_EN          0x0080
#define MASK_AON_APB_SP_INT_REQ_CM4_I2C0_SLV_WAKEUP_EN      0x0040
#define MASK_AON_APB_SP_INT_REQ_CM4_WDG_WAKEUP_EN           0x0020
#define MASK_AON_APB_SP_INT_REQ_CM4_SPI_WAKEUP_EN           0x0010
#define MASK_AON_APB_SP_INT_REQ_CM4_UART1_WAKEUP_EN         0x0008
#define MASK_AON_APB_SP_INT_REQ_CM4_UART0_WAKEUP_EN         0x0004
#define MASK_AON_APB_SP_INT_REQ_CM4_I3C1_WAKEUP_EN          0x0002
#define MASK_AON_APB_SP_INT_REQ_CM4_I3C0_WAKEUP_EN          0x0001
#define MASK_AON_APB_SP_INT_REQ_AUDCP_VBC_AUDRCD_WAKEUP_EN  0x80000000
#define MASK_AON_APB_SP_INT_REQ_AUDCP_MCDT_WAKEUP_EN        0x40000000
#define MASK_AON_APB_SP_INT_REQ_AUDCP_DMA_WAKEUP_EN         0x20000000
#define MASK_AON_APB_SP_INT_REQ_AUDCP_CHN_START_CHN3_WAKEUP_EN 0x10000000
#define MASK_AON_APB_SP_INT_REQ_AUDCP_CHN_START_CHN2_WAKEUP_EN 0x8000000
#define MASK_AON_APB_SP_INT_REQ_AUDCP_CHN_START_CHN1_WAKEUP_EN 0x4000000
#define MASK_AON_APB_SP_INT_REQ_AUDCP_CHN_START_CHN0_WAKEUP_EN 0x2000000
#define MASK_AON_APB_SP_INT_REQ_ANA_WAKEUP_EN               0x1000000
#define MASK_AON_APB_SP_INT_REQ_WTLCP_LTE_WDG_RST_WAKEUP_EN 0x800000
#define MASK_AON_APB_SP_INT_REQ_WTLCP_TG_WDG_RST_WAKEUP_EN  0x400000
#define MASK_AON_APB_SP_INT_REQ_GSP_WAKEUP_EN               0x200000
#define MASK_AON_APB_SP_INT_REQ_SLV_FW_AP_WAKEUP_EN         0x100000
#define MASK_AON_APB_SP_INT_REQ_DISPC_WAKEUP_EN             0x80000
#define MASK_AON_APB_SP_INT_REQ_PUB_DFS_DENY_EN             0x40000
#define MASK_AON_APB_SP_INT_REQ_PUB_DMC_MPU_VIO_WAKEUP_EN   0x20000
#define MASK_AON_APB_SP_INT_REQ_MEM_FW_PUB_WAKEUP_EN        0x10000
#define MASK_AON_APB_SP_INT_REQ_PUB_DFI_BUSMON_WAKEUP_EN    0x8000
#define MASK_AON_APB_SP_INT_REQ_PUB_PTM_WAKEUP_EN           0x4000
#define MASK_AON_APB_SP_INT_REQ_PUB_HARDWARE_DFS_EXIT_WAKEUP_EN 0x2000
#define MASK_AON_APB_SP_INT_REQ_PUB_DFS_COMPLETE_WAKEUP_EN  0x1000
#define MASK_AON_APB_SP_INT_REQ_PUB_DFS_ERROR_WAKEUP_EN     0x0800
#define MASK_AON_APB_SP_INT_REQ_PUB_DFS_GIVEUP_EN           0x0400
#define MASK_AON_APB_SP_INT_REQ_CLK_32K_DET_WAKEUP_EN       0x0200
#define MASK_AON_APB_SP_INT_REQ_AON_I2C_WAKEUP_EN           0x0100
#define MASK_AON_APB_SP_INT_REQ_THM0_WAKEUP_EN              0x0080
#define MASK_AON_APB_SP_INT_REQ_PWR_UP_PUB_WAKEUP_EN        0x0040
#define MASK_AON_APB_SP_INT_REQ_PWR_UP_AP_WAKEUP_EN         0x0020
#define MASK_AON_APB_SP_INT_REQ_SLV_FW_AON_WAKEUP_EN        0x0010
#define MASK_AON_APB_SP_INT_REQ_MEM_FW_AON_WAKEUP_EN        0x0008
#define MASK_AON_APB_SP_INT_REQ_BUSMON_USB_WAKEUP_EN        0x0004
#define MASK_AON_APB_SP_INT_REQ_BUSMON_AP_WAKEUP_EN         0x0002
#define MASK_AON_APB_SP_INT_REQ_BUSMON_WTLCP_WAKEUP_EN      0x0001
#define MASK_AON_APB_SP_INT_REQ_WCN_BTWF_WDG_WAKEUP_EN      0x4000
#define MASK_AON_APB_SP_INT_REQ_WCN_GNSS_WDG_WAKEUP_EN      0x2000
#define MASK_AON_APB_SP_INT_REQ_ICACHE_SP_WAKEUP_EN         0x1000
#define MASK_AON_APB_SP_INT_REQ_DCACHE_SP_WAKEUP_EN         0x0800
#define MASK_AON_APB_SP_INT_REQ_BUSMON_CM4_SP_WAKEUP_EN     0x0400
#define MASK_AON_APB_SP_INT_REQ_DFS_VOTE_DONE_WAKEUP_EN     0x0200
#define MASK_AON_APB_SP_INT_REQ_THM2_WAKEUP_EN              0x0100
#define MASK_AON_APB_SP_INT_REQ_THM1_WAKEUP_EN              0x0080
#define MASK_AON_APB_SP_INT_REQ_CM4_TMR2_WAKEUP_EN          0x0040
#define MASK_AON_APB_SP_INT_REQ_CM4_TMR1_WAKEUP_EN          0x0020
#define MASK_AON_APB_SP_INT_REQ_CM4_TMR0_WAKEUP_EN          0x0010
#define MASK_AON_APB_SP_INT_REQ_EXT_RSTB_SPCPU_WAKEUP_EN    0x0008
#define MASK_AON_APB_SP_INT_REQ_DBG_AXI_MON_WAKEUP_EN       0x0004
#define MASK_AON_APB_SP_INT_REQ_AUDCP_WDG_RST_WAKEUP_EN     0x0002
#define MASK_AON_APB_SP_INT_REQ_AUDCP_VBC_AUDPLY_WAKEUP_EN  0x0001
#define MASK_AON_APB_DBG_BUS_DATA_WTLCP                     0xFFFFFFFF
#define MASK_AON_APB_DBG_BUS_DATA_PUBCP                     0xFFFFFFFF
#define MASK_AON_APB_DBG_BUS_DATA_AUDCP                     0xFFFFFFFF
#define MASK_AON_APB_SCC_DBG_BUS                            0xFFFFFFFF
#define MASK_AON_APB_AON_FUNC_CTRL_0                        0xFFFFFFFF
#define MASK_AON_APB_AON_FUNC_CTRL_1                        0xFFFFFFFF
#define MASK_AON_APB_AP_WDG_RST_FLAG_CLR                    0x0040
#define MASK_AON_APB_PCP_WDG_RST_FLAG_CLR                   0x0020
#define MASK_AON_APB_WTLCP_LTE_WDG_RST_FLAG_CLR             0x0010
#define MASK_AON_APB_WTLCP_TG_WDG_RST_FLAG_CLR              0x0008
#define MASK_AON_APB_AUDCP_WDG_RST_FLAG_CLR                 0x0004
#define MASK_AON_APB_APCPU_WDG_RST_FLAG_CLR                 0x0002
#define MASK_AON_APB_SEC_WDG_RST_FLAG_CLR                   0x0001
#define MASK_AON_DBG_APB_APCPU_AWSTASHLPIDENS               0x100000
#define MASK_AON_DBG_APB_APCPU_AWSTASHLPIDS                 0xF0000
#define MASK_AON_DBG_APB_APCPU_CFGTE                        0xFF00
#define MASK_AON_DBG_APB_APCPU_AA64NAA32                    0x00FF
#define MASK_AON_DBG_APB_APCPU_SPNIDEN                      0x0008
#define MASK_AON_DBG_APB_APCPU_SPIDEN                       0x0004
#define MASK_AON_DBG_APB_APCPU_NIDEN                        0x0002
#define MASK_AON_DBG_APB_APCPU_DBGEN                        0x0001
#define MASK_AON_DBG_APB_DAP_DEVICEEN                       0x80000000
#define MASK_AON_DBG_APB_DAP_DBGEN                          0x40000000
#define MASK_AON_DBG_APB_DAP_SPIDBGEN                       0x20000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_DBGEN                  0x10000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_SINV_DBGEN             0x8000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_NINV_DBGEN             0x4000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_NSINV_DBGEN            0x2000000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_DBGEN                  0x1000000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_SINV_DBGEN             0x800000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_NINV_DBGEN             0x400000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_NSINV_DBGEN            0x200000
#define MASK_AON_DBG_APB_AON_CMSTAR_SINV_DBGEN              0x8000
#define MASK_AON_DBG_APB_AON_CMSTAR_NINV_DBGEN              0x4000
#define MASK_AON_DBG_APB_AON_CMSTAR_NSINV_DBGEN             0x2000
#define MASK_AON_DBG_APB_CDMA2K_DBGEN                       0x1000
#define MASK_AON_DBG_APB_VDSP_DBGEN                         0x0800
#define MASK_AON_DBG_APB_GPU_DBGEN                          0x0400
#define MASK_AON_DBG_APB_TG_JTAG_EN                         0x0200
#define MASK_AON_DBG_APB_LTE_JTAG_EN                        0x0100
#define MASK_AON_DBG_APB_AON_CM4_DBGEN                      0x0080
#define MASK_AON_DBG_APB_DJTAG_EN                           0x0040
#define MASK_AON_DBG_APB_AG_JTAG_EN                         0x0020
#define MASK_AON_DBG_APB_MJTAG_EN                           0x0010
#define MASK_AON_DBG_APB_CSSYS_NIDEN                        0x0008
#define MASK_AON_DBG_APB_CSSYS_SPNIDEN                      0x0004
#define MASK_AON_DBG_APB_CSSYS_SPIDEN                       0x0002
#define MASK_AON_DBG_APB_CSSYS_DBGEN                        0x0001
#define MASK_AON_DBG_APB_CR5_NIDEN                          0x0002
#define MASK_AON_DBG_APB_CR5_DBGEN                          0x0001
#define MASK_AON_DBG_APB_APCPU_SPNIDEN_NON_SEC              0x0008
#define MASK_AON_DBG_APB_APCPU_SPIDEN_NON_SEC               0x0004
#define MASK_AON_DBG_APB_APCPU_NIDEN_NON_SEC                0x0002
#define MASK_AON_DBG_APB_APCPU_DBGEN_NON_SEC                0x0001
#define MASK_AON_DBG_APB_DAP_DEVICEEN_NON_SEC               0x80000000
#define MASK_AON_DBG_APB_DAP_DBGEN_NON_SEC                  0x40000000
#define MASK_AON_DBG_APB_DAP_SPIDBGEN_NON_SEC               0x20000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_DBGEN_NON_SEC          0x10000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_SINV_DBGEN_NON_SEC     0x8000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_NINV_DBGEN_NON_SEC     0x4000000
#define MASK_AON_DBG_APB_GNSS_CMSTAR_NSINV_DBGEN_NON_SEC    0x2000000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_DBGEN_NON_SEC          0x1000000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_SINV_DBGEN_NON_SEC     0x800000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_NINV_DBGEN_NON_SEC     0x400000
#define MASK_AON_DBG_APB_BTWF_CMSTAR_NSINV_DBGEN_NON_SEC    0x200000
#define MASK_AON_DBG_APB_AON_CMSTAR_SINV_DBGEN_NON_SEC      0x8000
#define MASK_AON_DBG_APB_AON_CMSTAR_NINV_DBGEN_NON_SEC      0x4000
#define MASK_AON_DBG_APB_AON_CMSTAR_NSINV_DBGEN_NON_SEC     0x2000
#define MASK_AON_DBG_APB_CDMA2K_DBGEN_NON_SEC               0x1000
#define MASK_AON_DBG_APB_VDSP_DBGEN_NON_SEC                 0x0800
#define MASK_AON_DBG_APB_GPU_DBGEN_NON_SEC                  0x0400
#define MASK_AON_DBG_APB_TG_JTAG_EN_NON_SEC                 0x0200
#define MASK_AON_DBG_APB_LTE_JTAG_EN_NON_SEC                0x0100
#define MASK_AON_DBG_APB_AON_CM4_DBGEN_NON_SEC              0x0080
#define MASK_AON_DBG_APB_DJTAG_EN_NON_SEC                   0x0040
#define MASK_AON_DBG_APB_AG_JTAG_EN_NON_SEC                 0x0020
#define MASK_AON_DBG_APB_MJTAG_EN_NON_SEC                   0x0010
#define MASK_AON_DBG_APB_CSSYS_NIDEN_NON_SEC                0x0008
#define MASK_AON_DBG_APB_CSSYS_SPNIDEN_NON_SEC              0x0004
#define MASK_AON_DBG_APB_CSSYS_SPIDEN_NON_SEC               0x0002
#define MASK_AON_DBG_APB_CSSYS_DBGEN_NON_SEC                0x0001
#define MASK_AON_DBG_APB_CR5_NIDEN_NON_SEC                  0x0002
#define MASK_AON_DBG_APB_CR5_DBGEN_NON_SEC                  0x0001
#define MASK_AON_DBG_APB_EFUSE_DEBUG_BOND_OFF               0x80000000
#define MASK_AON_DBG_APB_EFUSE_SECURE_DEBUG                 0x40000000
#define MASK_AP_AHB_DMA_EB                                  0x0020
#define MASK_AP_AHB_DMA_ENABLE                              0x0010
#define MASK_AP_AHB_VSP_EB                                  0x0004
#define MASK_AP_AHB_DISPC_EB                                0x0002
#define MASK_AP_AHB_DSI_EB                                  0x0001
#define MASK_AP_AHB_DISPC_VAU_SOFT_RST                      0x4000
#define MASK_AP_AHB_VSP_SOFT_RST                            0x2000
#define MASK_AP_AHB_VPP_SOFT_RST                            0x1000
#define MASK_AP_AHB_VSP_GLOBAL_SOFT_RST                     0x0800
#define MASK_AP_AHB_VSP_VAU_SOFT_RST                        0x0400
#define MASK_AP_AHB_DMA_SOFT_RST                            0x0100
#define MASK_AP_AHB_DISPC_SOFT_RST                          0x0002
#define MASK_AP_AHB_DSI_SOFT_RST                            0x0001
#define MASK_AP_AHB_AXI_LP_CTRL_DISABLE                     0x0008
#define MASK_AP_AHB_PERI_FORCE_ON                           0x0004
#define MASK_AP_AHB_PERI_FORCE_OFF                          0x0002
#define MASK_AP_AHB_CGM_CLK_AP_AXI_AUTO_GATE_EN             0x0001
#define MASK_AP_AHB_AP_MAINMTX_LP_DISABLE                   0x0040
#define MASK_AP_AHB_AP_AHB_AUTO_GATE_EN                     0x0020
#define MASK_AP_AHB_AP_EMC_AUTO_GATE_EN                     0x0010
#define MASK_AP_AHB_HOLDING_PEN                             0xFFFFFFFF
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_UFS              0x0400
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_SDIO2            0x0200
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_SDIO1            0x0100
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_SDIO0            0x0080
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_EMMC             0x0040
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_APCPU            0x0020
#define MASK_AP_AHB_AP_AXI_BUS_IDLE_BYPASS_DMA              0x0010
#define MASK_AP_AHB_AP_APB_AUTO_CONTROL_SEL                 0x0008
#define MASK_AP_AHB_AP_APB_AUTO_MUX_SEL                     0x0006
#define MASK_AP_AHB_AP_APB_AUTO_MUX_EN                      0x0001
#define MASK_AP_AHB_UFS_HCLK_FRC_ON                         0x8000
#define MASK_AP_AHB_UFS_TX_FRC_ON                           0x4000
#define MASK_AP_AHB_UFS_RX_FRC_ON                           0x2000
#define MASK_AP_AHB_UFS_RX_1_FRC_ON                         0x1000
#define MASK_AP_AHB_UFS_CFG_FRC_ON                          0x0800
#define MASK_AP_AHB_UFS_PCLK_FRC_ON                         0x0400
#define MASK_AP_AHB_UFS_REF_FRC_ON                          0x0200
#define MASK_AP_AHB_UFS_XTAL_FRC_ON                         0x0100
#define MASK_AP_AHB_UFS_HCLK_FRC_OFF                        0x0080
#define MASK_AP_AHB_UFS_TX_FRC_OFF                          0x0040
#define MASK_AP_AHB_UFS_RX_FRC_OFF                          0x0020
#define MASK_AP_AHB_UFS_RX_1_FRC_OFF                        0x0010
#define MASK_AP_AHB_UFS_CFG_FRC_OFF                         0x0008
#define MASK_AP_AHB_UFS_PCLK_FRC_OFF                        0x0004
#define MASK_AP_AHB_UFS_REF_FRC_OFF                         0x0002
#define MASK_AP_AHB_UFS_XTAL_FRC_OFF                        0x0001
#define MASK_AP_AHB_VSP_FRC_OFF                             0x10000000
#define MASK_AP_AHB_SIM0_32K_FRC_OFF                        0x8000000
#define MASK_AP_AHB_I2C6_FRC_OFF                            0x1000000
#define MASK_AP_AHB_I2C5_FRC_OFF                            0x800000
#define MASK_AP_AHB_CE_FRC_OFF                              0x400000
#define MASK_AP_AHB_IIS2_FRC_OFF                            0x200000
#define MASK_AP_AHB_IIS1_FRC_OFF                            0x100000
#define MASK_AP_AHB_IIS0_FRC_OFF                            0x80000
#define MASK_AP_AHB_SPI3_FRC_OFF                            0x40000
#define MASK_AP_AHB_SPI2_FRC_OFF                            0x20000
#define MASK_AP_AHB_SPI1_FRC_OFF                            0x10000
#define MASK_AP_AHB_SPI0_FRC_OFF                            0x8000
#define MASK_AP_AHB_I2C4_FRC_OFF                            0x4000
#define MASK_AP_AHB_I2C3_FRC_OFF                            0x2000
#define MASK_AP_AHB_I2C2_FRC_OFF                            0x1000
#define MASK_AP_AHB_I2C1_FRC_OFF                            0x0800
#define MASK_AP_AHB_I2C0_FRC_OFF                            0x0400
#define MASK_AP_AHB_UART2_FRC_OFF                           0x0200
#define MASK_AP_AHB_UART1_FRC_OFF                           0x0100
#define MASK_AP_AHB_UART0_FRC_OFF                           0x0080
#define MASK_AP_AHB_AP_APB_FRC_OFF                          0x0040
#define MASK_AP_AHB_EMMC_1X_FRC_OFF                         0x0020
#define MASK_AP_AHB_EMMC_2X_FRC_OFF                         0x0010
#define MASK_AP_AHB_SDIO1_1X_FRC_OFF                        0x0008
#define MASK_AP_AHB_SDIO1_2X_FRC_OFF                        0x0004
#define MASK_AP_AHB_SDIO0_1X_FRC_OFF                        0x0002
#define MASK_AP_AHB_SDIO0_2X_FRC_OFF                        0x0001
#define MASK_AP_AHB_SIM_FRC_OFF                             0x0020
#define MASK_AP_AHB_DSI_APB_FRC_OFF                         0x0010
#define MASK_AP_AHB_DPHY_CFG_FRC_OFF                        0x0008
#define MASK_AP_AHB_DPHY_REF_FRC_OFF                        0x0004
#define MASK_AP_AHB_DISP_DPI_FRC_OFF                        0x0002
#define MASK_AP_AHB_DISP_FRC_OFF                            0x0001
#define MASK_AP_AHB_VSP_FRC_ON                              0x10000000
#define MASK_AP_AHB_SIM0_32K_FRC_ON                         0x8000000
#define MASK_AP_AHB_I2C6_FRC_ON                             0x1000000
#define MASK_AP_AHB_I2C5_FRC_ON                             0x800000
#define MASK_AP_AHB_CE_FRC_ON                               0x400000
#define MASK_AP_AHB_IIS2_FRC_ON                             0x200000
#define MASK_AP_AHB_IIS1_FRC_ON                             0x100000
#define MASK_AP_AHB_IIS0_FRC_ON                             0x80000
#define MASK_AP_AHB_SPI3_FRC_ON                             0x40000
#define MASK_AP_AHB_SPI2_FRC_ON                             0x20000
#define MASK_AP_AHB_SPI1_FRC_ON                             0x10000
#define MASK_AP_AHB_SPI0_FRC_ON                             0x8000
#define MASK_AP_AHB_I2C4_FRC_ON                             0x4000
#define MASK_AP_AHB_I2C3_FRC_ON                             0x2000
#define MASK_AP_AHB_I2C2_FRC_ON                             0x1000
#define MASK_AP_AHB_I2C1_FRC_ON                             0x0800
#define MASK_AP_AHB_I2C0_FRC_ON                             0x0400
#define MASK_AP_AHB_UART2_FRC_ON                            0x0200
#define MASK_AP_AHB_UART1_FRC_ON                            0x0100
#define MASK_AP_AHB_UART0_FRC_ON                            0x0080
#define MASK_AP_AHB_AP_APB_FRC_ON                           0x0040
#define MASK_AP_AHB_EMMC_1X_FRC_ON                          0x0020
#define MASK_AP_AHB_EMMC_2X_FRC_ON                          0x0010
#define MASK_AP_AHB_SDIO1_1X_FRC_ON                         0x0008
#define MASK_AP_AHB_SDIO1_2X_FRC_ON                         0x0004
#define MASK_AP_AHB_SDIO0_1X_FRC_ON                         0x0002
#define MASK_AP_AHB_SDIO0_2X_FRC_ON                         0x0001
#define MASK_AP_AHB_SIM_FRC_ON                              0x0020
#define MASK_AP_AHB_DSI_APB_FRC_ON                          0x0010
#define MASK_AP_AHB_DPHY_CFG_FRC_ON                         0x0008
#define MASK_AP_AHB_DPHY_REF_FRC_ON                         0x0004
#define MASK_AP_AHB_DISP_DPI_FRC_ON                         0x0002
#define MASK_AP_AHB_DISP_FRC_ON                             0x0001
#define MASK_AP_AHB_DPHY_REF_CKG_EN                         0x0002
#define MASK_AP_AHB_DPHY_CFG_CKG_EN                         0x0001
#define MASK_AP_AHB_DISP_ASYNC_BRG_PU_NUM                   0x7F80000
#define MASK_AP_AHB_DISP_CSYSACK_SYNC_SEL                   0x40000
#define MASK_AP_AHB_DISP_CACTIVE_SYNC_SEL                   0x20000
#define MASK_AP_AHB_DISP_ASYNC_BRG_LP_NUM                   0x1FFFE
#define MASK_AP_AHB_DISP_ASYNC_BRG_LP_EB                    0x0001
#define MASK_AP_AHB_AP_ASYNC_BRG_PU_NUM                     0x1FE0000
#define MASK_AP_AHB_AP_ASYNC_BRG_LP_NUM                     0x1FFFE
#define MASK_AP_AHB_AP_ASYNC_BRG_LP_EB                      0x0001
#define MASK_AP_AHB_MAIN_M0_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M0_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M0_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M1_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M1_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M1_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M2_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M2_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M2_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M3_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M3_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M3_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M4_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M4_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M4_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M5_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M5_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M5_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M6_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M6_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M6_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_M7_PU_NUM                          0x1FE0000
#define MASK_AP_AHB_MAIN_M7_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_M7_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_PU_NUM                             0x3FC0000
#define MASK_AP_AHB_CGM_MATRIX_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_LP_EB                              0x10000
#define MASK_AP_AHB_MAIN_LP_NUM                             0xFFFF
#define MASK_AP_AHB_MAIN_S0_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S0_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S0_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S0_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_S1_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S1_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S1_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S1_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_S2_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S2_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S2_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S2_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_S3_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S3_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S3_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S3_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_S4_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S4_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S4_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S4_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_S5_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S5_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S5_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S5_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MAIN_S6_PU_NUM                          0x3FC0000
#define MASK_AP_AHB_CGM_MTX_S6_AUTO_GATE_EN                 0x20000
#define MASK_AP_AHB_MAIN_S6_LP_EB                           0x10000
#define MASK_AP_AHB_MAIN_S6_LP_NUM                          0xFFFF
#define MASK_AP_AHB_MERGE_M0_PU_NUM                         0x1FE0000
#define MASK_AP_AHB_MERGE_M0_LP_EB                          0x10000
#define MASK_AP_AHB_MERGE_M0_LP_NUM                         0xFFFF
#define MASK_AP_AHB_MERGE_M1_PU_NUM                         0x1FE0000
#define MASK_AP_AHB_MERGE_M1_LP_EB                          0x10000
#define MASK_AP_AHB_MERGE_M1_LP_NUM                         0xFFFF
#define MASK_AP_AHB_MERGE_S0_PU_NUM                         0x3FC0000
#define MASK_AP_AHB_CGM_MERGE_S0_AUTO_GATE_EN               0x20000
#define MASK_AP_AHB_MERGE_S0_LP_EB                          0x10000
#define MASK_AP_AHB_MERGE_S0_LP_NUM                         0xFFFF
#define MASK_AP_AHB_ARQOS_CE                                0xF00000
#define MASK_AP_AHB_AWQOS_CE                                0xF0000
#define MASK_AP_AHB_ARQOS_DMA                               0xF000
#define MASK_AP_AHB_AWQOS_DMA                               0x0F00
#define MASK_AP_AHB_ARQOS_UFS                               0x00F0
#define MASK_AP_AHB_AWQOS_UFS                               0x000F
#define MASK_AP_AHB_ARQOS_SDIO0                             0xF0000000
#define MASK_AP_AHB_AWQOS_SDIO0                             0xF000000
#define MASK_AP_AHB_ARQOS_SDIO1                             0xF00000
#define MASK_AP_AHB_AWQOS_SDIO1                             0xF0000
#define MASK_AP_AHB_ARQOS_SDIO2                             0xF000
#define MASK_AP_AHB_AWQOS_SDIO2                             0x0F00
#define MASK_AP_AHB_ARQOS_EMMC                              0x00F0
#define MASK_AP_AHB_AWQOS_EMMC                              0x000F
#define MASK_AP_AHB_ARQOS_THRESHOLD_MAIN                   0xF00000
#define MASK_AP_AHB_AWQOS_THRESHOLD_MAIN                   0xF0000
#define MASK_AP_AHB_ARQOS_THRESHOLD_MERGE                  0xF000
#define MASK_AP_AHB_AWQOS_THRESHOLD_MERGE                  0x0F00
#define MASK_AP_AHB_ARQOS_THRESHOLD_DISP                   0x00F0
#define MASK_AP_AHB_AWQOS_THRESHOLD_DISP                   0x000F
#define MASK_AP_AHB_AXI_DETECTOR_OVERFLOW_AP                0x0020
#define MASK_AP_AHB_AXI_DETECTOR_OVERFLOW_DISP              0x0010
#define MASK_AP_AHB_BRIDGE_TRANS_IDLE_AP                    0x0004
#define MASK_AP_AHB_BRIDGE_TRANS_IDLE_DISP                  0x0002
#define MASK_AP_AHB_DISP_BRIDGE_DEBUG_SIGNAL_W              0xFFFFFFFF
#define MASK_AP_AHB_AP_BRIDGE_DEBUG_SIGNAL_W                0xFFFFFFFF
#define MASK_AP_AHB_SYS_SOFT_RST_REQ_GSP                    0x0004
#define MASK_AP_AHB_SYS_SOFT_RST_REQ_DISP                   0x0002
#define MASK_AP_AHB_SYS_SOFT_RST_REQ_VSP                    0x0001
#define MASK_AP_AHB_ARCACHE_SDIO2                           0xF0000000
#define MASK_AP_AHB_AWCACHE_SDIO2                           0xF000000
#define MASK_AP_AHB_ARCACHE_SDIO1                           0xF00000
#define MASK_AP_AHB_AWCACHE_SDIO1                           0xF0000
#define MASK_AP_AHB_ARCACHE_SDIO0                           0xF000
#define MASK_AP_AHB_AWCACHE_SDIO0                           0x0F00
#define MASK_AP_AHB_ARCACHE_EMMC                            0x00F0
#define MASK_AP_AHB_AWCACHE_EMMC                            0x000F
#define MASK_AP_AHB_ARCACHE_UFS                             0x00F0
#define MASK_AP_AHB_AWCACHE_UFS                             0x000F
#define MASK_AP_AHB_DISP_FRAME_LINE_SEL_FOR_DDR_DFS         0x0200
#define MASK_AP_AHB_DISP_FRAME_LINE_SEL_FOR_DVFS            0x0100
#define MASK_AP_AHB_MIPI_DSI_RESERVED                       0x1FFFE00
#define MASK_AP_AHB_MIPI_DSI_TX_RCTL                        0x01E0
#define MASK_AP_AHB_MIPI_DSI_TRIMBG                         0x001E
#define MASK_AP_AHB_MIPI_DSI_IF_SEL                         0x0001
#define MASK_AP_AHB_CHIP_ID                                 0xFFFFFFFF
#define MASK_AP_AHB_UFS_POWER_ON_WAIT_CNT                   0xFFFF0000
#define MASK_AP_AHB_UFS_POWER_DOWN_WAIT_CNT                 0xFFFF
#define MASK_AP_AHB_UFS_EXTERNAL_EVENT                      0x80000000
#define MASK_AP_AHB_UFS_CG_LP_PWR_READY_BYPASS              0x40000000
#define MASK_AP_AHB_UFS_FORCE_LP_PWR_READY                  0x20000000
#define MASK_AP_AHB_UFS_SEL_LP_PWR_READY                    0x10000000
#define MASK_AP_AHB_UFS_FORCE_LP_ISOL_EN                    0x8000000
#define MASK_AP_AHB_UFS_SEL_LP_ISOL_EN                      0x4000000
#define MASK_AP_AHB_UFS_FORCE_LP_RESET_N                    0x2000000
#define MASK_AP_AHB_UFS_SEL_LP_RESET_N                      0x1000000
#define MASK_AP_AHB_UFS_ISO_WAIT_CNT                        0xF00000
#define MASK_AP_AHB_UFS_PWR_READY_WAIT_CNT                  0xF0000
#define MASK_AP_AHB_UFS_TRESET_WAIT_CNT                     0xFFFF
#define MASK_AP_AHB_MPX_TX_ADAPTACTIVE                      0x6000000
#define MASK_AP_AHB_MPX_TX_ADAPTREQ                         0x1800000
#define MASK_AP_AHB_TX_PHYDIRDYIN                           0x600000
#define MASK_AP_AHB_RX_LCCRDDET                             0x180000
#define MASK_AP_AHB_MP_EXTACC                               0x40000
#define MASK_AP_AHB_TX_EXTACC                               0x20000
#define MASK_AP_AHB_TX_CFGBUSY                              0x18000
#define MASK_AP_AHB_RX_EXTACC                               0x4000
#define MASK_AP_AHB_RX_CFGBUSY                              0x3000
#define MASK_AP_AHB_TX_PLL_ON                               0x0800
#define MASK_AP_AHB_TX_PWRENBL                              0x0600
#define MASK_AP_AHB_RX_PWRENBL                              0x0180
#define MASK_AP_AHB_TX_MK2EXTENSIONPHASE                    0x0040
#define MASK_AP_AHB_RX_MK2EXTENSIONPHASE                    0x0020
#define MASK_AP_AHB_TX_MK2EXTENSIONEN                       0x0010
#define MASK_AP_AHB_RX_MK2DEEPEXIT                          0x0008
#define MASK_AP_AHB_LP_RESET_COMPLETE                       0x0004
#define MASK_AP_AHB_UFS_IDLE_IND                            0x0002
#define MASK_AP_AHB_IES_EN_MASK                             0x0001
#define MASK_AP_AHB_TX_TST_RTOBSERVE_1                      0xFF000000
#define MASK_AP_AHB_TX_TST_RTCONTROL_1                      0xFF0000
#define MASK_AP_AHB_TX_TST_RTOBSERVE_0                      0xFF00
#define MASK_AP_AHB_TX_TST_RTCONTROL_0                      0x00FF
#define MASK_AP_AHB_RX_TST_RTOBSERVE_1                      0xFF000000
#define MASK_AP_AHB_RX_TST_RTCONTROL_1                      0xFF0000
#define MASK_AP_AHB_RX_TST_RTOBSERVE_0                      0xFF00
#define MASK_AP_AHB_RX_TST_RTCONTROL_0                      0x00FF
#define MASK_AP_AHB_CB_TST_RTOBSERVE                        0xFF00
#define MASK_AP_AHB_CB_TST_RTCONTROL                        0x00FF
#define MASK_AP_AHB_MPHY_RESERVEDO                          0xFFFF0000
#define MASK_AP_AHB_MPHY_RESERVEDI                          0xFFFF
#define MASK_AP_AHB_CB_CFGUPDT                              0x80000000
#define MASK_AP_AHB_CB_INLNCFG                              0x40000000
#define MASK_AP_AHB_CB_CFGENBL                              0x20000000
#define MASK_AP_AHB_CB_ATTRWRN                              0x10000000
#define MASK_AP_AHB_CB_ATTRWRVAL                            0xFF00000
#define MASK_AP_AHB_CB_ATTRRDVAL                            0xFF000
#define MASK_AP_AHB_CB_ATTRID                               0x0FF0
#define MASK_AP_AHB_CB_ATTRRESET                            0x0008
#define MASK_AP_AHB_CB_RESET                                0x0004
#define MASK_AP_AHB_CB_CFGCLK                               0x0002
#define MASK_AP_AHB_REFCLKON                                0x0001
#define MASK_AP_AHB_CB_CFGCLK_DIV                           0x0200
#define MASK_AP_AHB_CB_CFGCLK_FREQ                          0x01FE
#define MASK_AP_AHB_CB_CFGRDYN                              0x0001
#define MASK_AP_AHB_CG_CFGCLK_SW                            0x0040
#define MASK_AP_AHB_TX_SYMBOLCLKREQ_SW                      0x0020
#define MASK_AP_AHB_HCK_SW                                  0x0010
#define MASK_AP_AHB_CG_SYSCLK_SW                            0x0008
#define MASK_AP_AHB_CG_CLK_TREQ_SW                          0x0004
#define MASK_AP_AHB_CG_LP_CLK_TREQ_SW                       0x0002
#define MASK_AP_AHB_CG_PCLKREQ_SW                           0x0001
#define MASK_AP_AHB_BUSMON_ENABLE_VSP                       0x0002
#define MASK_AP_AHB_BUSMON_ENABLE_AP                        0x0001
#define MASK_AP_AHB_LP_SM_STATE                             0xF000
#define MASK_AP_AHB_AH8_FSM_STATE                           0x0F00
#define MASK_AP_AHB_LP_RESET_N                              0x0080
#define MASK_AP_AHB_LP_ISO_EN                               0x0040
#define MASK_AP_AHB_LP_PWR_READY                            0x0020
#define MASK_AP_AHB_LP_PWR_GATE                             0x0010
#define MASK_AP_AHB_CG_SYSCLKREQ                            0x0008
#define MASK_AP_AHB_CG_CLK_TREQ                             0x0004
#define MASK_AP_AHB_CG_LP_CLK_TREQ                          0x0002
#define MASK_AP_AHB_CG_PCLKREQ                              0x0001
#define MASK_AP_APB_CE_PUB_EB                               0x80000000
#define MASK_AP_APB_CE_SEC_EB                               0x40000000
#define MASK_AP_APB_AXI_REGU_EB                             0x10000000
#define MASK_AP_APB_I2C6_EB                                 0x8000000
#define MASK_AP_APB_I2C5_EB                                 0x4000000
#define MASK_AP_APB_EMMC_EB                                 0x2000000
#define MASK_AP_APB_SDIO2_EB                                0x1000000
#define MASK_AP_APB_SDIO1_EB                                0x800000
#define MASK_AP_APB_SDIO0_EB                                0x400000
#define MASK_AP_APB_SPI3_LCD_FMARK_IN_EB                    0x200000
#define MASK_AP_APB_SPI2_LCD_FMARK_IN_EB                    0x100000
#define MASK_AP_APB_SPI1_LCD_FMARK_IN_EB                    0x80000
#define MASK_AP_APB_SPI0_LCD_FMARK_IN_EB                    0x40000
#define MASK_AP_APB_SIM0_32K_EB                             0x20000
#define MASK_AP_APB_UART2_EB                                0x10000
#define MASK_AP_APB_UART1_EB                                0x8000
#define MASK_AP_APB_UART0_EB                                0x4000
#define MASK_AP_APB_I2C4_EB                                 0x2000
#define MASK_AP_APB_I2C3_EB                                 0x1000
#define MASK_AP_APB_I2C2_EB                                 0x0800
#define MASK_AP_APB_I2C1_EB                                 0x0400
#define MASK_AP_APB_I2C0_EB                                 0x0200
#define MASK_AP_APB_SPI3_EB                                 0x0100
#define MASK_AP_APB_SPI2_EB                                 0x0080
#define MASK_AP_APB_SPI1_EB                                 0x0040
#define MASK_AP_APB_SPI0_EB                                 0x0020
#define MASK_AP_APB_APB_REG_EB                              0x0010
#define MASK_AP_APB_IIS2_EB                                 0x0008
#define MASK_AP_APB_IIS1_EB                                 0x0004
#define MASK_AP_APB_IIS0_EB                                 0x0002
#define MASK_AP_APB_SIM0_EB                                 0x0001
#define MASK_AP_APB_UFS_AES_SOFT_RST                        0x20000000
#define MASK_AP_APB_AXI_REGU_SOFT_RST                       0x10000000
#define MASK_AP_APB_I2C6_SOFT_RST                           0x8000000
#define MASK_AP_APB_I2C5_SOFT_RST                           0x4000000
#define MASK_AP_APB_CKG_SOFT_RST                            0x2000000
#define MASK_AP_APB_UFS_REG_SOFT_RST                        0x1000000
#define MASK_AP_APB_UFS_SOFT_RST                            0x800000
#define MASK_AP_APB_AP_DVFS_SOFT_RST                        0x400000
#define MASK_AP_APB_CE_PUB_SOFT_RST                         0x200000
#define MASK_AP_APB_CE_SEC_SOFT_RST                         0x100000
#define MASK_AP_APB_EMMC_SOFT_RST                           0x80000
#define MASK_AP_APB_SDIO2_SOFT_RST                          0x40000
#define MASK_AP_APB_SDIO1_SOFT_RST                          0x20000
#define MASK_AP_APB_SDIO0_SOFT_RST                          0x10000
#define MASK_AP_APB_UART2_SOFT_RST                          0x8000
#define MASK_AP_APB_UART1_SOFT_RST                          0x4000
#define MASK_AP_APB_UART0_SOFT_RST                          0x2000
#define MASK_AP_APB_I2C4_SOFT_RST                           0x1000
#define MASK_AP_APB_I2C3_SOFT_RST                           0x0800
#define MASK_AP_APB_I2C2_SOFT_RST                           0x0400
#define MASK_AP_APB_I2C1_SOFT_RST                           0x0200
#define MASK_AP_APB_I2C0_SOFT_RST                           0x0100
#define MASK_AP_APB_SPI3_SOFT_RST                           0x0080
#define MASK_AP_APB_SPI2_SOFT_RST                           0x0040
#define MASK_AP_APB_SPI1_SOFT_RST                           0x0020
#define MASK_AP_APB_SPI0_SOFT_RST                           0x0010
#define MASK_AP_APB_IIS2_SOFT_RST                           0x0008
#define MASK_AP_APB_IIS1_SOFT_RST                           0x0004
#define MASK_AP_APB_IIS0_SOFT_RST                           0x0002
#define MASK_AP_APB_SIM0_SOFT_RST                           0x0001
#define MASK_AP_APB_I2C6_SEC_EB                             0x10000
#define MASK_AP_APB_I2C5_SEC_EB                             0x8000
#define MASK_AP_APB_I2C4_SEC_EB                             0x4000
#define MASK_AP_APB_I2C3_SEC_EB                             0x2000
#define MASK_AP_APB_I2C2_SEC_EB                             0x1000
#define MASK_AP_APB_I2C1_SEC_EB                             0x0800
#define MASK_AP_APB_I2C0_SEC_EB                             0x0400
#define MASK_AP_APB_SPI3_SEC_EB                             0x0200
#define MASK_AP_APB_SPI2_SEC_EB                             0x0100
#define MASK_AP_APB_SPI1_SEC_EB                             0x0080
#define MASK_AP_APB_SPI0_SEC_EB                             0x0040
#define MASK_AP_APB_SPI3_FMARK_POLARITY_INV                 0x0020
#define MASK_AP_APB_SPI2_FMARK_POLARITY_INV                 0x0010
#define MASK_AP_APB_SPI1_FMARK_POLARITY_INV                 0x0008
#define MASK_AP_APB_SPI0_FMARK_POLARITY_INV                 0x0004
#define MASK_AP_APB_SIM_CLK_POLARITY                        0x0002
#define MASK_AP_APB_FORCE_CLKTOP_PCLK_EN                    0x0008
#define MASK_AP_APB_CKG_EB                                  0x0004
#define MASK_AP_APB_UFS_REG_EB                              0x0002
#define MASK_AP_APB_UFS_EB                                  0x0001
#define MASK_GPU_APB_CUR_ST_ST0                             0x00F0
#define MASK_PMU_APB_WCN_ACCESS_AON_MEM_EN                  0x0004
#define MASK_PMU_APB_SP_SYS_MEM_ALL_SEL                     0x0002
#define MASK_PMU_APB_AON_MEM_ALL_SYS_SEL                    0x0001
#define MASK_PMU_APB_MEM_AUTO_SD_EN0                        0xFFFFFFFF
#define MASK_PMU_APB_MEM_AUTO_SD_EN1                        0xFFFFFFFF
#define MASK_PMU_APB_MEM_AUTO_SLP_EN0                       0xFFFFFFFF
#define MASK_PMU_APB_MEM_AUTO_SLP_EN1                       0xFFFFFFFF
#define MASK_PMU_APB_MEM_SD_CFG0                            0xFFFFFFFF
#define MASK_PMU_APB_MEM_SD_CFG1                            0xFFFFFFFF
#define MASK_PMU_APB_MEM_SLP_CFG0                           0xFFFFFFFF
#define MASK_PMU_APB_MEM_SLP_CFG1                           0xFFFFFFFF
#define MASK_PMU_APB_APCPU_TOP_RAM_PD_EN                    0x0001
#define MASK_PMU_APB_APCPU_CORE7_RAM_DSLP_EN                0x1000
#define MASK_PMU_APB_APCPU_CORE6_RAM_DSLP_EN                0x0800
#define MASK_PMU_APB_APCPU_CORE5_RAM_DSLP_EN                0x0400
#define MASK_PMU_APB_APCPU_CORE4_RAM_DSLP_EN                0x0200
#define MASK_PMU_APB_APCPU_CORE3_RAM_DSLP_EN                0x0100
#define MASK_PMU_APB_APCPU_CORE2_RAM_DSLP_EN                0x0080
#define MASK_PMU_APB_APCPU_CORE1_RAM_DSLP_EN                0x0040
#define MASK_PMU_APB_APCPU_CORE0_RAM_DSLP_EN                0x0020
#define MASK_PMU_APB_APCPU_SNOOP_FILTER_RAM_DSLP_EN         0x0010
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P3_RAM_DSLP_EN       0x0008
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P2_RAM_DSLP_EN       0x0004
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P1_RAM_DSLP_EN       0x0002
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P0_RAM_DSLP_EN       0x0001
#define MASK_PMU_APB_RAM_PD_PUB_FRC                         0x80000000
#define MASK_PMU_APB_RAM_PD_WCN_FRC                         0x40000000
#define MASK_PMU_APB_RAM_PD_PUBCP_FRC                       0x20000000
#define MASK_PMU_APB_RAM_PD_WTLCP_LTE_PROC_FRC              0x10000000
#define MASK_PMU_APB_RAM_PD_WTLCP_TD_PROC_FRC               0x8000000
#define MASK_PMU_APB_RAM_PD_WTLCP_HU3GE_B_FRC               0x4000000
#define MASK_PMU_APB_RAM_PD_WTLCP_HU3GE_A_FRC               0x2000000
#define MASK_PMU_APB_RAM_PD_WTLCP_TGDSP_FRC                 0x1000000
#define MASK_PMU_APB_RAM_PD_WTLCP_LDSP_FRC                  0x800000
#define MASK_PMU_APB_RAM_PD_WTLCP_FRC                       0x400000
#define MASK_PMU_APB_RAM_PD_WTLCP_LTE_DPFEC_FRC             0x200000
#define MASK_PMU_APB_RAM_PD_WTLCP_LTE_CE_FRC                0x100000
#define MASK_PMU_APB_RAM_PD_AUDCP_AUDDSP_FRC                0x80000
#define MASK_PMU_APB_RAM_PD_AUDCP_FRC                       0x40000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE7_FRC                 0x20000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE6_FRC                 0x10000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE5_FRC                 0x8000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE4_FRC                 0x4000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE3_FRC                 0x2000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE2_FRC                 0x1000
#define MASK_PMU_APB_RAM_PD_APCPU_CORE1_FRC                 0x0800
#define MASK_PMU_APB_RAM_PD_APCPU_CORE0_FRC                 0x0400
#define MASK_PMU_APB_RAM_PD_APCPU_SNOOP_FILTER_FRC          0x0200
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P3_FRC        0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P2_FRC        0x0080
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P1_FRC        0x0040
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P0_FRC        0x0020
#define MASK_PMU_APB_RAM_PD_APCPU_TOP_FRC                   0x0010
#define MASK_PMU_APB_RAM_PD_GPU_TOP_FRC                     0x0008
#define MASK_PMU_APB_RAM_PD_MM_FRC                          0x0004
#define MASK_PMU_APB_RAM_PD_AP_VSP_FRC                      0x0002
#define MASK_PMU_APB_RAM_PD_AP_FRC                          0x0001
#define MASK_PMU_APB_RAM_RET_APCPU_CORE7_FRC                0x2000
#define MASK_PMU_APB_RAM_RET_APCPU_CORE6_FRC                0x1000
#define MASK_PMU_APB_RAM_RET_APCPU_CORE5_FRC                0x0800
#define MASK_PMU_APB_RAM_RET_APCPU_CORE4_FRC                0x0400
#define MASK_PMU_APB_RAM_RET_APCPU_CORE3_FRC                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE2_FRC                0x0100
#define MASK_PMU_APB_RAM_RET_APCPU_CORE1_FRC                0x0080
#define MASK_PMU_APB_RAM_RET_APCPU_CORE0_FRC                0x0040
#define MASK_PMU_APB_RAM_RET_APCPU_SNOOP_FILTER_FRC         0x0020
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P3_FRC       0x0010
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P2_FRC       0x0008
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P1_FRC       0x0004
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P0_FRC       0x0002
#define MASK_PMU_APB_RAM_RET_APCPU_TOP_FRC                  0x0001
#define MASK_PMU_APB_APCPU_CORE7_RAM_FRC_ON                 0x1000
#define MASK_PMU_APB_APCPU_CORE6_RAM_FRC_ON                 0x0800
#define MASK_PMU_APB_APCPU_CORE5_RAM_FRC_ON                 0x0400
#define MASK_PMU_APB_APCPU_CORE4_RAM_FRC_ON                 0x0200
#define MASK_PMU_APB_APCPU_CORE3_RAM_FRC_ON                 0x0100
#define MASK_PMU_APB_APCPU_CORE2_RAM_FRC_ON                 0x0080
#define MASK_PMU_APB_APCPU_CORE1_RAM_FRC_ON                 0x0040
#define MASK_PMU_APB_APCPU_CORE0_RAM_FRC_ON                 0x0020
#define MASK_PMU_APB_APCPU_SNOOP_FILTER_RAM_FRC_ON          0x0010
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P3_RAM_FRC_ON        0x0008
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P2_RAM_FRC_ON        0x0004
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P1_RAM_FRC_ON        0x0002
#define MASK_PMU_APB_APCPU_L3CACHE_TAG_P0_RAM_FRC_ON        0x0001
#define MASK_PMU_APB_SP_SRAM_XTLBUF0_SYS_SEL                0x0008
#define MASK_PMU_APB_SP_SRAM_RCO_SYS_SEL                    0x0004
#define MASK_PMU_APB_AON_SRAM_XTLBUF0_SYS_SEL               0x0002
#define MASK_PMU_APB_AON_SRAM_RCO_SYS_SEL                   0x0001
#define MASK_PMU_APB_APCPU_CORE7_WAKEUP_EN                  0x0080
#define MASK_PMU_APB_APCPU_CORE6_WAKEUP_EN                  0x0040
#define MASK_PMU_APB_APCPU_CORE5_WAKEUP_EN                  0x0020
#define MASK_PMU_APB_APCPU_CORE4_WAKEUP_EN                  0x0010
#define MASK_PMU_APB_APCPU_CORE3_WAKEUP_EN                  0x0008
#define MASK_PMU_APB_APCPU_CORE2_WAKEUP_EN                  0x0004
#define MASK_PMU_APB_APCPU_CORE1_WAKEUP_EN                  0x0002
#define MASK_PMU_APB_APCPU_CORE0_WAKEUP_EN                  0x0001
#define MASK_PMU_APB_APCPU_CORE7_SOFT_INT                   0x0080
#define MASK_PMU_APB_APCPU_CORE6_SOFT_INT                   0x0040
#define MASK_PMU_APB_APCPU_CORE5_SOFT_INT                   0x0020
#define MASK_PMU_APB_APCPU_CORE4_SOFT_INT                   0x0010
#define MASK_PMU_APB_APCPU_CORE3_SOFT_INT                   0x0008
#define MASK_PMU_APB_APCPU_CORE2_SOFT_INT                   0x0004
#define MASK_PMU_APB_APCPU_CORE1_SOFT_INT                   0x0002
#define MASK_PMU_APB_APCPU_CORE0_SOFT_INT                   0x0001
#define MASK_PMU_APB_APCPU_TOP_FORCE_DEEP_STOP              0x10000
#define MASK_PMU_APB_APCPU_CORE7_FORCE_STOP                 0x0080
#define MASK_PMU_APB_APCPU_CORE6_FORCE_STOP                 0x0040
#define MASK_PMU_APB_APCPU_CORE5_FORCE_STOP                 0x0020
#define MASK_PMU_APB_APCPU_CORE4_FORCE_STOP                 0x0010
#define MASK_PMU_APB_APCPU_CORE3_FORCE_STOP                 0x0008
#define MASK_PMU_APB_APCPU_CORE2_FORCE_STOP                 0x0004
#define MASK_PMU_APB_APCPU_CORE1_FORCE_STOP                 0x0002
#define MASK_PMU_APB_APCPU_CORE0_FORCE_STOP                 0x0001
#define MASK_PMU_APB_APCPU_CSYSPWRUP_WAKEUP_EN              0x00FF
#define MASK_PMU_APB_WCN_ADDA_PWR_PD_REG                    0x0800
#define MASK_PMU_APB_DSI_PWR_PD_REG                         0x0020
#define MASK_PMU_APB_CSI_2LANE_PWR_PD_REG                   0x0008
#define MASK_PMU_APB_CSI_4LANE_PWR_PD_REG                   0x0004
#define MASK_PMU_APB_CSI_2P2LANE_PWR_PD_REG                 0x0002
#define MASK_PMU_APB_MPHY_PWR_PD_REG                        0x0001
#define MASK_PMU_APB_WCN_ADDA_PWR_ON_REG                    0x0800
#define MASK_PMU_APB_DSI_PWR_ON_REG                         0x0020
#define MASK_PMU_APB_CSI_2LANE_PWR_ON_REG                   0x0008
#define MASK_PMU_APB_CSI_4LANE_PWR_ON_REG                   0x0004
#define MASK_PMU_APB_CSI_2P2LANE_PWR_ON_REG                 0x0002
#define MASK_PMU_APB_MPHY_PWR_ON_REG                        0x0001
#define MASK_PMU_APB_PHY_PWR_DLY                            0x00FF
#define MASK_PMU_APB_PD_MM_BISR_FORCE_SEL                   0x10000000
#define MASK_PMU_APB_PD_GPU_C0_BISR_FORCE_SEL               0x100000
#define MASK_PMU_APB_PD_GPU_TOP_BISR_FORCE_SEL              0x80000
#define MASK_PMU_APB_PD_APCPU_CORE7_BISR_FORCE_SEL          0x0400
#define MASK_PMU_APB_PD_APCPU_CORE6_BISR_FORCE_SEL          0x0200
#define MASK_PMU_APB_PD_APCPU_CORE5_BISR_FORCE_SEL          0x0100
#define MASK_PMU_APB_PD_APCPU_CORE4_BISR_FORCE_SEL          0x0080
#define MASK_PMU_APB_PD_APCPU_CORE3_BISR_FORCE_SEL          0x0040
#define MASK_PMU_APB_PD_APCPU_CORE2_BISR_FORCE_SEL          0x0020
#define MASK_PMU_APB_PD_APCPU_CORE1_BISR_FORCE_SEL          0x0010
#define MASK_PMU_APB_PD_APCPU_CORE0_BISR_FORCE_SEL          0x0008
#define MASK_PMU_APB_PD_APCPU_TOP_BISR_FORCE_SEL            0x0004
#define MASK_PMU_APB_PD_AP_BISR_FORCE_SEL                   0x0002
#define MASK_PMU_APB_PD_AON_MEM_BISR_FORCE_SEL              0x0001
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_BISR_FORCE_SEL        0x10000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_FORCE_SEL        0x8000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_BISR_FORCE_SEL      0x4000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_BISR_FORCE_SEL         0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_BISR_FORCE_SEL       0x1000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_BISR_FORCE_SEL        0x800000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_FORCE_SEL          0x200000
#define MASK_PMU_APB_PD_WTLCP_LDSP_BISR_FORCE_SEL           0x100000
#define MASK_PMU_APB_PD_WTLCP_BISR_FORCE_SEL                0x80000
#define MASK_PMU_APB_PD_PUBCP_BISR_FORCE_SEL                0x4000
#define MASK_PMU_APB_PD_AP_VSP_BISR_FORCE_SEL               0x0080
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_BISR_FORCE_SEL         0x800000
#define MASK_PMU_APB_PD_AUDCP_BISR_FORCE_SEL                0x400000
#define MASK_PMU_APB_PD_GNSS_IP_BISR_FORCE_SEL              0x40000
#define MASK_PMU_APB_PD_GNSS_SS_BISR_FORCE_SEL              0x20000
#define MASK_PMU_APB_PD_BTWF_SS_BISR_FORCE_SEL              0x10000
#define MASK_PMU_APB_PD_WIFI_MAC_BISR_FORCE_SEL             0x4000
#define MASK_PMU_APB_PD_WIFI_WRAP_BISR_FORCE_SEL            0x2000
#define MASK_PMU_APB_PD_MM_BISR_FORCE_BYP                   0x10000000
#define MASK_PMU_APB_PD_GPU_C0_BISR_FORCE_BYP               0x100000
#define MASK_PMU_APB_PD_GPU_TOP_BISR_FORCE_BYP              0x80000
#define MASK_PMU_APB_PD_APCPU_CORE7_BISR_FORCE_BYP          0x0400
#define MASK_PMU_APB_PD_APCPU_CORE6_BISR_FORCE_BYP          0x0200
#define MASK_PMU_APB_PD_APCPU_CORE5_BISR_FORCE_BYP          0x0100
#define MASK_PMU_APB_PD_APCPU_CORE4_BISR_FORCE_BYP          0x0080
#define MASK_PMU_APB_PD_APCPU_CORE3_BISR_FORCE_BYP          0x0040
#define MASK_PMU_APB_PD_APCPU_CORE2_BISR_FORCE_BYP          0x0020
#define MASK_PMU_APB_PD_APCPU_CORE1_BISR_FORCE_BYP          0x0010
#define MASK_PMU_APB_PD_APCPU_CORE0_BISR_FORCE_BYP          0x0008
#define MASK_PMU_APB_PD_APCPU_TOP_BISR_FORCE_BYP            0x0004
#define MASK_PMU_APB_PD_AP_BISR_FORCE_BYP                   0x0002
#define MASK_PMU_APB_PD_AON_MEM_BISR_FORCE_BYP              0x0001
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_BISR_FORCE_BYP        0x10000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_FORCE_BYP        0x8000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_BISR_FORCE_BYP      0x4000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_BISR_FORCE_BYP         0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_BISR_FORCE_BYP       0x1000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_BISR_FORCE_BYP        0x800000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_FORCE_BYP          0x200000
#define MASK_PMU_APB_PD_WTLCP_LDSP_BISR_FORCE_BYP           0x100000
#define MASK_PMU_APB_PD_WTLCP_BISR_FORCE_BYP                0x80000
#define MASK_PMU_APB_PD_PUBCP_BISR_FORCE_BYP                0x4000
#define MASK_PMU_APB_PD_AP_VSP_BISR_FORCE_BYP               0x0080
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_BISR_FORCE_BYP         0x800000
#define MASK_PMU_APB_PD_AUDCP_BISR_FORCE_BYP                0x400000
#define MASK_PMU_APB_PD_GNSS_IP_BISR_FORCE_BYP              0x40000
#define MASK_PMU_APB_PD_GNSS_SS_BISR_FORCE_BYP              0x20000
#define MASK_PMU_APB_PD_BTWF_SS_BISR_FORCE_BYP              0x10000
#define MASK_PMU_APB_PD_WIFI_MAC_BISR_FORCE_BYP             0x4000
#define MASK_PMU_APB_PD_WIFI_WRAP_BISR_FORCE_BYP            0x2000
#define MASK_PMU_APB_PD_MM_BISR_FORCE_EN                    0x10000000
#define MASK_PMU_APB_PD_GPU_C0_BISR_FORCE_EN                0x100000
#define MASK_PMU_APB_PD_GPU_TOP_BISR_FORCE_EN               0x80000
#define MASK_PMU_APB_PD_APCPU_CORE7_BISR_FORCE_EN           0x0400
#define MASK_PMU_APB_PD_APCPU_CORE6_BISR_FORCE_EN           0x0200
#define MASK_PMU_APB_PD_APCPU_CORE5_BISR_FORCE_EN           0x0100
#define MASK_PMU_APB_PD_APCPU_CORE4_BISR_FORCE_EN           0x0080
#define MASK_PMU_APB_PD_APCPU_CORE3_BISR_FORCE_EN           0x0040
#define MASK_PMU_APB_PD_APCPU_CORE2_BISR_FORCE_EN           0x0020
#define MASK_PMU_APB_PD_APCPU_CORE1_BISR_FORCE_EN           0x0010
#define MASK_PMU_APB_PD_APCPU_CORE0_BISR_FORCE_EN           0x0008
#define MASK_PMU_APB_PD_APCPU_TOP_BISR_FORCE_EN             0x0004
#define MASK_PMU_APB_PD_AP_BISR_FORCE_EN                    0x0002
#define MASK_PMU_APB_PD_AON_MEM_BISR_FORCE_EN               0x0001
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_BISR_FORCE_EN         0x10000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_FORCE_EN         0x8000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_BISR_FORCE_EN       0x4000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_BISR_FORCE_EN          0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_BISR_FORCE_EN        0x1000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_BISR_FORCE_EN         0x800000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_FORCE_EN           0x200000
#define MASK_PMU_APB_PD_WTLCP_LDSP_BISR_FORCE_EN            0x100000
#define MASK_PMU_APB_PD_WTLCP_BISR_FORCE_EN                 0x80000
#define MASK_PMU_APB_PD_PUBCP_BISR_FORCE_EN                 0x4000
#define MASK_PMU_APB_PD_AP_VSP_BISR_FORCE_EN                0x0080
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_BISR_FORCE_EN          0x800000
#define MASK_PMU_APB_PD_AUDCP_BISR_FORCE_EN                 0x400000
#define MASK_PMU_APB_PD_GNSS_IP_BISR_FORCE_EN               0x40000
#define MASK_PMU_APB_PD_GNSS_SS_BISR_FORCE_EN               0x20000
#define MASK_PMU_APB_PD_BTWF_SS_BISR_FORCE_EN               0x10000
#define MASK_PMU_APB_PD_WIFI_MAC_BISR_FORCE_EN              0x4000
#define MASK_PMU_APB_PD_WIFI_WRAP_BISR_FORCE_EN             0x2000
#define MASK_PMU_APB_PD_MM_BISR_DONE                        0x10000000
#define MASK_PMU_APB_PD_GPU_C0_BISR_DONE                    0x100000
#define MASK_PMU_APB_PD_GPU_TOP_BISR_DONE                   0x80000
#define MASK_PMU_APB_PD_APCPU_CORE7_BISR_DONE               0x0400
#define MASK_PMU_APB_PD_APCPU_CORE6_BISR_DONE               0x0200
#define MASK_PMU_APB_PD_APCPU_CORE5_BISR_DONE               0x0100
#define MASK_PMU_APB_PD_APCPU_CORE4_BISR_DONE               0x0080
#define MASK_PMU_APB_PD_APCPU_CORE3_BISR_DONE               0x0040
#define MASK_PMU_APB_PD_APCPU_CORE2_BISR_DONE               0x0020
#define MASK_PMU_APB_PD_APCPU_CORE1_BISR_DONE               0x0010
#define MASK_PMU_APB_PD_APCPU_CORE0_BISR_DONE               0x0008
#define MASK_PMU_APB_PD_APCPU_TOP_BISR_DONE                 0x0004
#define MASK_PMU_APB_PD_AP_BISR_DONE                        0x0002
#define MASK_PMU_APB_PD_AON_MEM_BISR_DONE                   0x0001
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_BISR_DONE             0x10000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_DONE             0x8000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_BISR_DONE           0x4000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_BISR_DONE              0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_BISR_DONE            0x1000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_BISR_DONE             0x800000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_DONE               0x200000
#define MASK_PMU_APB_PD_WTLCP_LDSP_BISR_DONE                0x100000
#define MASK_PMU_APB_PD_WTLCP_BISR_DONE                     0x80000
#define MASK_PMU_APB_PD_PUBCP_BISR_DONE                     0x4000
#define MASK_PMU_APB_PD_AP_VSP_BISR_DONE                    0x0080
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_BISR_DONE              0x800000
#define MASK_PMU_APB_PD_AUDCP_BISR_DONE                     0x400000
#define MASK_PMU_APB_PD_GNSS_IP_BISR_DONE                   0x40000
#define MASK_PMU_APB_PD_GNSS_SS_BISR_DONE                   0x20000
#define MASK_PMU_APB_PD_BTWF_SS_BISR_DONE                   0x10000
#define MASK_PMU_APB_PD_WIFI_MAC_BISR_DONE                  0x4000
#define MASK_PMU_APB_PD_WIFI_WRAP_BISR_DONE                 0x2000
#define MASK_PMU_APB_PD_MM_BISR_BUSY                        0x10000000
#define MASK_PMU_APB_PD_GPU_C0_BISR_BUSY                    0x100000
#define MASK_PMU_APB_PD_GPU_TOP_BISR_BUSY                   0x80000
#define MASK_PMU_APB_PD_APCPU_CORE7_BISR_BUSY               0x0400
#define MASK_PMU_APB_PD_APCPU_CORE6_BISR_BUSY               0x0200
#define MASK_PMU_APB_PD_APCPU_CORE5_BISR_BUSY               0x0100
#define MASK_PMU_APB_PD_APCPU_CORE4_BISR_BUSY               0x0080
#define MASK_PMU_APB_PD_APCPU_CORE3_BISR_BUSY               0x0040
#define MASK_PMU_APB_PD_APCPU_CORE2_BISR_BUSY               0x0020
#define MASK_PMU_APB_PD_APCPU_CORE1_BISR_BUSY               0x0010
#define MASK_PMU_APB_PD_APCPU_CORE0_BISR_BUSY               0x0008
#define MASK_PMU_APB_PD_APCPU_TOP_BISR_BUSY                 0x0004
#define MASK_PMU_APB_PD_AP_BISR_BUSY                        0x0002
#define MASK_PMU_APB_PD_AON_MEM_BISR_BUSY                   0x0001
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_BISR_BUSY             0x10000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_BUSY             0x8000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_BISR_BUSY           0x4000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_BISR_BUSY              0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_BISR_BUSY            0x1000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_BISR_BUSY             0x800000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_BUSY               0x200000
#define MASK_PMU_APB_PD_WTLCP_LDSP_BISR_BUSY                0x100000
#define MASK_PMU_APB_PD_WTLCP_BISR_BUSY                     0x80000
#define MASK_PMU_APB_PD_PUBCP_BISR_BUSY                     0x4000
#define MASK_PMU_APB_PD_AP_VSP_BISR_BUSY                    0x0080
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_BISR_BUSY              0x800000
#define MASK_PMU_APB_PD_AUDCP_BISR_BUSY                     0x400000
#define MASK_PMU_APB_PD_GNSS_IP_BISR_BUSY                   0x40000
#define MASK_PMU_APB_PD_GNSS_SS_BISR_BUSY                   0x20000
#define MASK_PMU_APB_PD_BTWF_SS_BISR_BUSY                   0x10000
#define MASK_PMU_APB_PD_WIFI_MAC_BISR_BUSY                  0x4000
#define MASK_PMU_APB_PD_WIFI_WRAP_BISR_BUSY                 0x2000
#define MASK_PMU_APB_DCDC_CPU1_DVFS_BLOCK_SHUTDOWN_EN       0x0002
#define MASK_PMU_APB_DCDC_CPU0_DVFS_BLOCK_SHUTDOWN_EN       0x0001
#define MASK_PMU_APB_PD_DCDC_CPU0_PWR_ON_DLY                0xFF00
#define MASK_PMU_APB_PD_DCDC_CPU0_PWR_OFF_DLY               0x00FF
#define MASK_PMU_APB_PD_DCDC_CPU1_PWR_SEQ_DLY               0xFF000000
#define MASK_PMU_APB_PD_DCDC_CPU1_SHUTDOWN_WINDOW           0xFF0000
#define MASK_PMU_APB_PD_DCDC_CPU1_PWR_ON_DLY                0xFF00
#define MASK_PMU_APB_PD_DCDC_CPU1_PWR_OFF_DLY               0x00FF
#define MASK_PMU_APB_DCDC_CPU1_FRC_ON                       0x0003
#define MASK_PMU_APB_APCPU_CORE0_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE1_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE2_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE3_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE4_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE5_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE6_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE7_DSLP_ENA                   0x0001
#define MASK_PMU_APB_AUDCP_AUDDSP_DSLP_ENA                  0x0001
#define MASK_PMU_APB_WTLCP_LDSP_DSLP_ENA                    0x0001
#define MASK_PMU_APB_WTLCP_TGDSP_DSLP_ENA                   0x0001
#define MASK_PMU_APB_APCPU_CORE0_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE1_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE2_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE3_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE4_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE5_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE6_INT_DISABLE                0x0001
#define MASK_PMU_APB_APCPU_CORE7_INT_DISABLE                0x0001
#define MASK_PMU_APB_AUDCP_AUDDSP_CORE_INT_DISABLE          0x0001
#define MASK_PMU_APB_WTLCP_LDSP_CORE_INT_DISABLE            0x0001
#define MASK_PMU_APB_WTLCP_TGDSP_CORE_INT_DISABLE           0x0001
#define MASK_PMU_APB_GICDISABLE                             0x0001
#define MASK_PMU_APB_PD_AP_DBG_SHUTDOWN_EN                  0x10000000
#define MASK_PMU_APB_PD_AP_FORCE_SHUTDOWN                   0x2000000
#define MASK_PMU_APB_PD_AP_AUTO_SHUTDOWN_EN                 0x1000000
#define MASK_PMU_APB_PD_AP_PWR_ON_DLY                       0xFF0000
#define MASK_PMU_APB_PD_AP_PWR_ON_SEQ_DLY                   0xFF00
#define MASK_PMU_APB_PD_AP_ISO_ON_DLY                       0x00FF
#define MASK_PMU_APB_PD_APCPU_TOP_DBG_SHUTDOWN_EN           0x10000000
#define MASK_PMU_APB_PD_APCPU_TOP_PD_SEL                    0x8000000
#define MASK_PMU_APB_PD_APCPU_TOP_FORCE_SHUTDOWN            0x2000000
#define MASK_PMU_APB_PD_APCPU_TOP_AUTO_SHUTDOWN_EN          0x1000000
#define MASK_PMU_APB_PD_APCPU_TOP_PWR_ON_SEQ_DLY            0xFF00
#define MASK_PMU_APB_PD_APCPU_TOP_ISO_ON_DLY                0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE0_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE0_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE0_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE0_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE0_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE0_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE0_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE1_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE1_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE1_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE1_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE1_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE1_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE1_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE2_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE2_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE2_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE2_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE2_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE2_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE2_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE3_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE3_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE3_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE3_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE3_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE3_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE3_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE4_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE4_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE4_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE4_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE4_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE4_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE4_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE5_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE5_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE5_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE5_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE5_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE5_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE5_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE6_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE6_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE6_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE6_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE6_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE6_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE6_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE7_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_APCPU_CORE7_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_APCPU_CORE7_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_APCPU_CORE7_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_APCPU_CORE7_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE7_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE7_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_GPU_TOP_FORCE_SHUTDOWN              0x2000000
#define MASK_PMU_APB_PD_GPU_TOP_AUTO_SHUTDOWN_EN            0x1000000
#define MASK_PMU_APB_PD_GPU_TOP_PWR_ON_DLY                  0xFF0000
#define MASK_PMU_APB_PD_GPU_TOP_PWR_ON_SEQ_DLY              0xFF00
#define MASK_PMU_APB_PD_GPU_TOP_ISO_ON_DLY                  0x00FF
#define MASK_PMU_APB_PD_GPU_C0_PWR_CTRL_SEL                 0x4000000
#define MASK_PMU_APB_PD_GPU_C0_MEM_PD_REG                   0x0008
#define MASK_PMU_APB_PD_GPU_C0_ISO_REG                      0x0004
#define MASK_PMU_APB_PD_GPU_C0_PDCA_D_B_REG                 0x0002
#define MASK_PMU_APB_PD_GPU_C0_PDCA_M_B_REG                 0x0001
#define MASK_PMU_APB_PD_MM_FORCE_SHUTDOWN                   0x2000000
#define MASK_PMU_APB_PD_MM_AUTO_SHUTDOWN_EN                 0x1000000
#define MASK_PMU_APB_PD_MM_PWR_ON_DLY                       0xFF0000
#define MASK_PMU_APB_PD_MM_PWR_ON_SEQ_DLY                   0xFF00
#define MASK_PMU_APB_PD_MM_ISO_ON_DLY                       0x00FF
#define MASK_PMU_APB_PD_AP_VSP_FORCE_SHUTDOWN               0x2000000
#define MASK_PMU_APB_PD_AP_VSP_AUTO_SHUTDOWN_EN             0x1000000
#define MASK_PMU_APB_PD_AP_VSP_PWR_ON_DLY                   0xFF0000
#define MASK_PMU_APB_PD_AP_VSP_PWR_ON_SEQ_DLY               0xFF00
#define MASK_PMU_APB_PD_AP_VSP_ISO_ON_DLY                   0x00FF
#define MASK_PMU_APB_PD_PUBCP_DBG_SHUTDOWN_EN               0x10000000
#define MASK_PMU_APB_PD_PUBCP_FORCE_SHUTDOWN                0x2000000
#define MASK_PMU_APB_PD_PUBCP_AUTO_SHUTDOWN_EN              0x1000000
#define MASK_PMU_APB_PD_PUBCP_PWR_ON_DLY                    0xFF0000
#define MASK_PMU_APB_PD_PUBCP_PWR_ON_SEQ_DLY                0xFF00
#define MASK_PMU_APB_PD_PUBCP_ISO_ON_DLY                    0x00FF
#define MASK_PMU_APB_PD_WTLCP_FORCE_SHUTDOWN                0x2000000
#define MASK_PMU_APB_PD_WTLCP_AUTO_SHUTDOWN_EN              0x1000000
#define MASK_PMU_APB_PD_WTLCP_PWR_ON_DLY                    0xFF0000
#define MASK_PMU_APB_PD_WTLCP_PWR_ON_SEQ_DLY                0xFF00
#define MASK_PMU_APB_PD_WTLCP_ISO_ON_DLY                    0x00FF
#define MASK_PMU_APB_PD_WTLCP_LDSP_DBG_SHUTDOWN_EN          0x10000000
#define MASK_PMU_APB_PD_WTLCP_LDSP_PD_SEL                   0x8000000
#define MASK_PMU_APB_PD_WTLCP_LDSP_FORCE_SHUTDOWN           0x2000000
#define MASK_PMU_APB_PD_WTLCP_LDSP_AUTO_SHUTDOWN_EN         0x1000000
#define MASK_PMU_APB_PD_WTLCP_LDSP_PWR_ON_DLY               0xFF0000
#define MASK_PMU_APB_PD_WTLCP_LDSP_PWR_ON_SEQ_DLY           0xFF00
#define MASK_PMU_APB_PD_WTLCP_LDSP_ISO_ON_DLY               0x00FF
#define MASK_PMU_APB_PD_WTLCP_TGDSP_DBG_SHUTDOWN_EN         0x10000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_PD_SEL                  0x8000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_FORCE_SHUTDOWN          0x2000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_AUTO_SHUTDOWN_EN        0x1000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_PWR_ON_DLY              0xFF0000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_PWR_ON_SEQ_DLY          0xFF00
#define MASK_PMU_APB_PD_WTLCP_TGDSP_ISO_ON_DLY              0x00FF
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_FORCE_SHUTDOWN        0x2000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_AUTO_SHUTDOWN_EN      0x1000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_PWR_ON_DLY            0xFF0000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_PWR_ON_SEQ_DLY        0xFF00
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_ISO_ON_DLY            0x00FF
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_FORCE_SHUTDOWN       0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_AUTO_SHUTDOWN_EN     0x1000000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_PWR_ON_DLY           0xFF0000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_PWR_ON_SEQ_DLY       0xFF00
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_ISO_ON_DLY           0x00FF
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_FORCE_SHUTDOWN         0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_AUTO_SHUTDOWN_EN       0x1000000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_PWR_ON_DLY             0xFF0000
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_PWR_ON_SEQ_DLY         0xFF00
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_ISO_ON_DLY             0x00FF
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_FORCE_SHUTDOWN      0x2000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_AUTO_SHUTDOWN_EN    0x1000000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_PWR_ON_DLY          0xFF0000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_PWR_ON_SEQ_DLY      0xFF00
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_ISO_ON_DLY          0x00FF
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_FORCE_SHUTDOWN        0x2000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_AUTO_SHUTDOWN_EN      0x1000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_PWR_ON_DLY            0xFF0000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_PWR_ON_SEQ_DLY        0xFF00
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_ISO_ON_DLY            0x00FF
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_FORCE_SHUTDOWN        0x2000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_AUTO_SHUTDOWN_EN      0x1000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_PWR_ON_DLY            0xFF0000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_PWR_ON_SEQ_DLY        0xFF00
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_ISO_ON_DLY            0x00FF
#define MASK_PMU_APB_PD_WCN_FORCE_SHUTDOWN                  0x2000000
#define MASK_PMU_APB_PD_WCN_AUTO_SHUTDOWN_EN                0x1000000
#define MASK_PMU_APB_PD_WCN_PWR_ON_DLY                      0xFF0000
#define MASK_PMU_APB_PD_WCN_PWR_ON_SEQ_DLY                  0xFF00
#define MASK_PMU_APB_PD_WCN_ISO_ON_DLY                      0x00FF
#define MASK_PMU_APB_PD_WIFI_WRAP_PWR_CTRL_SEL              0x4000000
#define MASK_PMU_APB_PD_WIFI_WRAP_MEM_PD_REG                0x0008
#define MASK_PMU_APB_PD_WIFI_WRAP_ISO_REG                   0x0004
#define MASK_PMU_APB_PD_WIFI_WRAP_PDCA_D_B_REG              0x0002
#define MASK_PMU_APB_PD_WIFI_WRAP_PDCA_M_B_REG              0x0001
#define MASK_PMU_APB_PD_WIFI_MAC_PWR_CTRL_SEL               0x4000000
#define MASK_PMU_APB_PD_WIFI_MAC_MEM_PD_REG                 0x0008
#define MASK_PMU_APB_PD_WIFI_MAC_ISO_REG                    0x0004
#define MASK_PMU_APB_PD_WIFI_MAC_PDCA_D_B_REG               0x0002
#define MASK_PMU_APB_PD_WIFI_MAC_PDCA_M_B_REG               0x0001
#define MASK_PMU_APB_PD_WIFI_PHY_PWR_CTRL_SEL               0x4000000
#define MASK_PMU_APB_PD_WIFI_PHY_MEM_PD_REG                 0x0008
#define MASK_PMU_APB_PD_WIFI_PHY_ISO_REG                    0x0004
#define MASK_PMU_APB_PD_WIFI_PHY_PDCA_D_B_REG               0x0002
#define MASK_PMU_APB_PD_WIFI_PHY_PDCA_M_B_REG               0x0001
#define MASK_PMU_APB_PD_BTWF_SS_PWR_CTRL_SEL                0x4000000
#define MASK_PMU_APB_PD_BTWF_SS_MEM_PD_REG                  0x0008
#define MASK_PMU_APB_PD_BTWF_SS_ISO_REG                     0x0004
#define MASK_PMU_APB_PD_BTWF_SS_PDCA_D_B_REG                0x0002
#define MASK_PMU_APB_PD_BTWF_SS_PDCA_M_B_REG                0x0001
#define MASK_PMU_APB_PD_GNSS_SS_PWR_CTRL_SEL                0x4000000
#define MASK_PMU_APB_PD_GNSS_SS_MEM_PD_REG                  0x0008
#define MASK_PMU_APB_PD_GNSS_SS_ISO_REG                     0x0004
#define MASK_PMU_APB_PD_GNSS_SS_PDCA_D_B_REG                0x0002
#define MASK_PMU_APB_PD_GNSS_SS_PDCA_M_B_REG                0x0001
#define MASK_PMU_APB_PD_GNSS_IP_PWR_CTRL_SEL                0x4000000
#define MASK_PMU_APB_PD_GNSS_IP_MEM_PD_REG                  0x0008
#define MASK_PMU_APB_PD_GNSS_IP_ISO_REG                     0x0004
#define MASK_PMU_APB_PD_GNSS_IP_PDCA_D_B_REG                0x0002
#define MASK_PMU_APB_PD_GNSS_IP_PDCA_M_B_REG                0x0001
#define MASK_PMU_APB_PD_BT_PWR_CTRL_SEL                     0x4000000
#define MASK_PMU_APB_PD_BT_MEM_PD_REG                       0x0008
#define MASK_PMU_APB_PD_BT_ISO_REG                          0x0004
#define MASK_PMU_APB_PD_BT_PDCA_D_B_REG                     0x0002
#define MASK_PMU_APB_PD_BT_PDCA_M_B_REG                     0x0001
#define MASK_PMU_APB_PD_AUDCP_FORCE_SHUTDOWN                0x2000000
#define MASK_PMU_APB_PD_AUDCP_AUTO_SHUTDOWN_EN              0x1000000
#define MASK_PMU_APB_PD_AUDCP_PWR_ON_DLY                    0xFF0000
#define MASK_PMU_APB_PD_AUDCP_PWR_ON_SEQ_DLY                0xFF00
#define MASK_PMU_APB_PD_AUDCP_ISO_ON_DLY                    0x00FF
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_DBG_SHUTDOWN_EN        0x10000000
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_PD_SEL                 0x8000000
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_FORCE_SHUTDOWN         0x2000000
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_AUTO_SHUTDOWN_EN       0x1000000
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_PWR_ON_DLY             0xFF0000
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_PWR_ON_SEQ_DLY         0xFF00
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_ISO_ON_DLY             0x00FF
#define MASK_PMU_APB_PD_PUB_FORCE_SHUTDOWN                  0x2000000
#define MASK_PMU_APB_PD_PUB_AUTO_SHUTDOWN_EN                0x1000000
#define MASK_PMU_APB_PD_PUB_PWR_ON_DLY                      0xFF0000
#define MASK_PMU_APB_PD_PUB_PWR_ON_SEQ_DLY                  0xFF00
#define MASK_PMU_APB_PD_PUB_ISO_ON_DLY                      0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE1_RAM_PWR_DLY             0xFF000000
#define MASK_PMU_APB_PD_APCPU_CORE0_RAM_PWR_DLY             0xFF0000
#define MASK_PMU_APB_PD_APCPU_TOP_RAM_PWR_DLY               0xFF00
#define MASK_PMU_APB_PD_AP_RAM_PWR_DLY                      0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE5_RAM_PWR_DLY             0xFF000000
#define MASK_PMU_APB_PD_APCPU_CORE4_RAM_PWR_DLY             0xFF0000
#define MASK_PMU_APB_PD_APCPU_CORE3_RAM_PWR_DLY             0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE2_RAM_PWR_DLY             0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE7_RAM_PWR_DLY             0xFF00
#define MASK_PMU_APB_PD_APCPU_CORE6_RAM_PWR_DLY             0x00FF
#define MASK_PMU_APB_PD_GPU_C0_RAM_PWR_DLY                  0xFF000000
#define MASK_PMU_APB_PD_GPU_TOP_RAM_PWR_DLY                 0xFF0000
#define MASK_PMU_APB_PD_MM_RAM_PWR_DLY                      0xFF000000
#define MASK_PMU_APB_PD_AP_VSP_RAM_PWR_DLY                  0xFF0000
#define MASK_PMU_APB_PD_PUBCP_RAM_PWR_DLY                   0xFF00
#define MASK_PMU_APB_PD_WTLCP_LDSP_RAM_PWR_DLY              0xFF000000
#define MASK_PMU_APB_PD_WTLCP_RAM_PWR_DLY                   0xFF0000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_RAM_PWR_DLY          0xFF000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_RAM_PWR_DLY           0xFF0000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_RAM_PWR_DLY             0x00FF
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_RAM_PWR_DLY           0xFF000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_RAM_PWR_DLY           0xFF0000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_RAM_PWR_DLY         0xFF00
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_RAM_PWR_DLY            0x00FF
#define MASK_PMU_APB_PD_WCN_RAM_PWR_DLY                     0xFF000000
#define MASK_PMU_APB_PD_BTWF_SS_RAM_PWR_DLY                 0xFF000000
#define MASK_PMU_APB_PD_WIFI_PHY_RAM_PWR_DLY                0xFF0000
#define MASK_PMU_APB_PD_WIFI_MAC_RAM_PWR_DLY                0xFF00
#define MASK_PMU_APB_PD_WIFI_WRAP_RAM_PWR_DLY               0x00FF
#define MASK_PMU_APB_PD_BT_RAM_PWR_DLY                      0xFF0000
#define MASK_PMU_APB_PD_GNSS_IP_RAM_PWR_DLY                 0xFF00
#define MASK_PMU_APB_PD_GNSS_SS_RAM_PWR_DLY                 0x00FF
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_RAM_PWR_DLY            0xFF0000
#define MASK_PMU_APB_PD_AUDCP_RAM_PWR_DLY                   0xFF00
#define MASK_PMU_APB_PD_PUB_RAM_PWR_DLY                     0xFF000000
#define MASK_PMU_APB_ISO_OFF_DLY                            0xFF0000
#define MASK_PMU_APB_CGM_ON_DLY                             0xFF00
#define MASK_PMU_APB_RST_ASSERT_DLY                         0x00FF
#define MASK_PMU_APB_PD_APCPU_CORE1_STATE                   0x1F000000
#define MASK_PMU_APB_PD_APCPU_CORE0_STATE                   0x1F0000
#define MASK_PMU_APB_PD_APCPU_TOP_STATE                     0x1F00
#define MASK_PMU_APB_PD_AP_STATE                            0x001F
#define MASK_PMU_APB_PD_APCPU_CORE5_STATE                   0x1F000000
#define MASK_PMU_APB_PD_APCPU_CORE4_STATE                   0x1F0000
#define MASK_PMU_APB_PD_APCPU_CORE3_STATE                   0x1F00
#define MASK_PMU_APB_PD_APCPU_CORE2_STATE                   0x001F
#define MASK_PMU_APB_PD_APCPU_CORE7_STATE                   0x1F00
#define MASK_PMU_APB_PD_APCPU_CORE6_STATE                   0x001F
#define MASK_PMU_APB_PD_GPU_C0_STATE                        0x1F000000
#define MASK_PMU_APB_PD_GPU_TOP_STATE                       0x1F0000
#define MASK_PMU_APB_PD_MM_STATE                            0x1F000000
#define MASK_PMU_APB_PD_AP_VSP_STATE                        0x1F0000
#define MASK_PMU_APB_PD_PUBCP_STATE                         0x1F00
#define MASK_PMU_APB_PD_WTLCP_LDSP_STATE                    0x1F000000
#define MASK_PMU_APB_PD_WTLCP_STATE                         0x1F0000
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_STATE                0x1F000000
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_STATE                 0x1F0000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_STATE                   0x001F
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_STATE                 0x1F000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_STATE                 0x1F0000
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_STATE               0x1F00
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_STATE                  0x001F
#define MASK_PMU_APB_PD_WCN_STATE                           0x1F000000
#define MASK_PMU_APB_PD_BTWF_SS_STATE                       0x1F000000
#define MASK_PMU_APB_PD_WIFI_PHY_STATE                      0x1F0000
#define MASK_PMU_APB_PD_WIFI_MAC_STATE                      0x1F00
#define MASK_PMU_APB_PD_WIFI_WRAP_STATE                     0x001F
#define MASK_PMU_APB_PD_BT_STATE                            0x1F0000
#define MASK_PMU_APB_PD_GNSS_IP_STATE                       0x1F00
#define MASK_PMU_APB_PD_GNSS_SS_STATE                       0x001F
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_STATE                  0x1F0000
#define MASK_PMU_APB_PD_AUDCP_STATE                         0x1F00
#define MASK_PMU_APB_PD_PUB_STATE                           0x1F000000
#define MASK_PMU_APB_APCPU_CORE0_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE1_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE2_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE3_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE4_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE5_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE6_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_APCPU_CORE7_SIMD_RET_MODE              0x0007
#define MASK_PMU_APB_PACTIVE_CORE0_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE1_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE2_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE3_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE4_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE5_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE6_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CORE7_SW                       0x000F
#define MASK_PMU_APB_PACTIVE_CLUSTER_SW                     0x007F
#define MASK_PMU_APB_APCPU_CORE0_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE0_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE0_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE0_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE0_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE0_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE0_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE0_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE0_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE0_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE1_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE1_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE1_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE1_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE1_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE1_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE1_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE1_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE1_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE1_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE2_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE2_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE2_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE2_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE2_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE2_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE2_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE2_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE2_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE2_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE3_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE3_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE3_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE3_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE3_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE3_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE3_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE3_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE3_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE3_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE4_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE4_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE4_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE4_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE4_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE4_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE4_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE4_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE4_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE4_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE5_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE5_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE5_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE5_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE5_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE5_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE5_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE5_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE5_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE5_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE6_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE6_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE6_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE6_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE6_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE6_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE6_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE6_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE6_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE6_PREQ_SW                    0x0001
#define MASK_PMU_APB_APCPU_CORE7_PACTIVE                    0xF000
#define MASK_PMU_APB_APCPU_CORE7_PDENY                      0x0800
#define MASK_PMU_APB_APCPU_CORE7_PACCEPT                    0x0400
#define MASK_PMU_APB_MODE_ST_CORE7_CGM_EN_SW                0x0200
#define MASK_PMU_APB_RAM_RET_APCPU_CORE7_SW                 0x0100
#define MASK_PMU_APB_RAM_PD_APCPU_CORE7_SW                  0x0080
#define MASK_PMU_APB_RST_APCPU_CORE7_WARM_SW_N              0x0040
#define MASK_PMU_APB_RST_APCPU_CORE7_COLD_SW_N              0x0020
#define MASK_PMU_APB_APCPU_CORE7_PSTATE_SW                  0x001E
#define MASK_PMU_APB_APCPU_CORE7_PREQ_SW                    0x0001
#define MASK_PMU_APB_RAM_RET_APCPU_SNOOP_FILTER_SW          0x10000000
#define MASK_PMU_APB_RAM_PD_APCPU_SNOOP_FILTER_SW           0x8000000
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P3_SW        0x4000000
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P3_SW         0x2000000
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P2_SW        0x1000000
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P2_SW         0x800000
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P1_SW        0x400000
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P1_SW         0x200000
#define MASK_PMU_APB_RAM_RET_APCPU_L3CACHE_TAG_P0_SW        0x100000
#define MASK_PMU_APB_RAM_PD_APCPU_L3CACHE_TAG_P0_SW         0x80000
#define MASK_PMU_APB_APCPU_CLUSTER_PACTIVE                  0x7F000
#define MASK_PMU_APB_APCPU_CLUSTER_PDENY                    0x0800
#define MASK_PMU_APB_APCPU_CLUSTER_PACCEPT                  0x0400
#define MASK_PMU_APB_RST_APCPU_CLUSTER_WARM_SW_N            0x0200
#define MASK_PMU_APB_RST_APCPU_CLUSTER_COLD_SW_N            0x0100
#define MASK_PMU_APB_APCPU_CLUSTER_PSTATE_SW                0x00FE
#define MASK_PMU_APB_APCPU_CLUSTER_PREQ_SW                  0x0001
#define MASK_PMU_APB_APCPU_CORE0_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE0_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE1_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE1_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE2_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE2_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE3_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE3_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE4_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE4_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE5_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE5_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE6_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE6_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CORE7_DENY_TAR_STATE             0x1F00
#define MASK_PMU_APB_APCPU_CORE7_DENY_PRE_STATE             0x001F
#define MASK_PMU_APB_APCPU_CLUSTER_DENY_TAR_STATE           0x3F00
#define MASK_PMU_APB_APCPU_CLUSTER_DENY_PRE_STATE           0x003F
#define MASK_PMU_APB_APCPU_CORINTH_RAM_PWR_DLY              0xFF000000
#define MASK_PMU_APB_APCPU_CORE_RAM_PWR_DLY                 0xFF0000
#define MASK_PMU_APB_APCPU_CORE_INITIAL_DLY                 0xFF00
#define MASK_PMU_APB_APCPU_CORINTH_INITIAL_DLY              0x00FF
#define MASK_PMU_APB_APCPU_CORE_RST_DEASSERT_DLY            0xFF000000
#define MASK_PMU_APB_APCPU_CORE_RST_ASSERT_DLY              0xFF0000
#define MASK_PMU_APB_APCPU_CORINTH_RST_DEASSERT_DLY         0xFF00
#define MASK_PMU_APB_APCPU_CORINTH_RST_ASSERT_DLY           0x00FF
#define MASK_PMU_APB_APCPU_CORE_CGM_OFF_DLY                 0xFF00
#define MASK_PMU_APB_APCPU_CORE_CGM_ON_DLY                  0x00FF
#define MASK_PMU_APB_APCPU_CLUSTER_INITIAL_STATE            0x0001
#define MASK_PMU_APB_APCPU_CORINTH_FUNC_RET_GATE_CLK_EN     0x0001
#define MASK_PMU_APB_APCPU_CLUSTER_DENY_TIME_THRESHOLD      0x0FC0
#define MASK_PMU_APB_APCPU_CORE_DENY_TIME_THRESHOLD         0x003F
#define MASK_PMU_APB_APCPU_CORE7_MODE_ST_CGM_EN_DISABLE     0x0080
#define MASK_PMU_APB_APCPU_CORE6_MODE_ST_CGM_EN_DISABLE     0x0040
#define MASK_PMU_APB_APCPU_CORE5_MODE_ST_CGM_EN_DISABLE     0x0020
#define MASK_PMU_APB_APCPU_CORE4_MODE_ST_CGM_EN_DISABLE     0x0010
#define MASK_PMU_APB_APCPU_CORE3_MODE_ST_CGM_EN_DISABLE     0x0008
#define MASK_PMU_APB_APCPU_CORE2_MODE_ST_CGM_EN_DISABLE     0x0004
#define MASK_PMU_APB_APCPU_CORE1_MODE_ST_CGM_EN_DISABLE     0x0002
#define MASK_PMU_APB_APCPU_CORE0_MODE_ST_CGM_EN_DISABLE     0x0001
#define MASK_PMU_APB_PD_APCPU_CORE7_FRC_ON_EN               0x0080
#define MASK_PMU_APB_PD_APCPU_CORE6_FRC_ON_EN               0x0040
#define MASK_PMU_APB_PD_APCPU_CORE5_FRC_ON_EN               0x0020
#define MASK_PMU_APB_PD_APCPU_CORE4_FRC_ON_EN               0x0010
#define MASK_PMU_APB_PD_APCPU_CORE3_FRC_ON_EN               0x0008
#define MASK_PMU_APB_PD_APCPU_CORE2_FRC_ON_EN               0x0004
#define MASK_PMU_APB_PD_APCPU_CORE1_FRC_ON_EN               0x0002
#define MASK_PMU_APB_PD_APCPU_CORE0_FRC_ON_EN               0x0001
#define MASK_PMU_APB_APCPU_CORE_SOFT_RST_BYPASS             0x0020
#define MASK_PMU_APB_APCPU_CLUSTER_SOFT_RST_BYPASS          0x0010
#define MASK_PMU_APB_APCPU_SRST_RST_BYPASS                  0x0008
#define MASK_PMU_APB_CLUSTER_DBGRSTREQ_EN                   0x0004
#define MASK_PMU_APB_APCPU_SOFT_RST_TYPE_SEL                0x0002
#define MASK_PMU_APB_DBGRSTREQ_RST_TYPE_SEL                 0x0001
#define MASK_PMU_APB_DBG_RECOV_WAIT_BUS_IDLE_EN             0x0080
#define MASK_PMU_APB_DBGRSTREQ_TRIG_DBG_RECOV_EN            0x0040
#define MASK_PMU_APB_APCPU_TOP_SOFT_RST_TRIG_DBG_RECOV_EN   0x0020
#define MASK_PMU_APB_APCPU_CLUSTER_SOFT_RST_TRIG_DBG_RECOV_EN 0x0010
#define MASK_PMU_APB_DEBUG_RECOV_FORCE_TRIG                 0x0004
#define MASK_PMU_APB_DEBUG_RECOV_AUTO_TRIG_EN               0x0002
#define MASK_PMU_APB_DBG_RECOV_RST_TYPE_SEL                 0x0001
#define MASK_PMU_APB_APCPU_CORE7_OFF_EMU_CLR_INT_DISABLE_EN 0x0080
#define MASK_PMU_APB_APCPU_CORE6_OFF_EMU_CLR_INT_DISABLE_EN 0x0040
#define MASK_PMU_APB_APCPU_CORE5_OFF_EMU_CLR_INT_DISABLE_EN 0x0020
#define MASK_PMU_APB_APCPU_CORE4_OFF_EMU_CLR_INT_DISABLE_EN 0x0010
#define MASK_PMU_APB_APCPU_CORE3_OFF_EMU_CLR_INT_DISABLE_EN 0x0008
#define MASK_PMU_APB_APCPU_CORE2_OFF_EMU_CLR_INT_DISABLE_EN 0x0004
#define MASK_PMU_APB_APCPU_CORE1_OFF_EMU_CLR_INT_DISABLE_EN 0x0002
#define MASK_PMU_APB_APCPU_CORE0_OFF_EMU_CLR_INT_DISABLE_EN 0x0001
#define MASK_PMU_APB_APCPU_CORE7_OFF_EMU_TO_OFF             0x0080
#define MASK_PMU_APB_APCPU_CORE6_OFF_EMU_TO_OFF             0x0040
#define MASK_PMU_APB_APCPU_CORE5_OFF_EMU_TO_OFF             0x0020
#define MASK_PMU_APB_APCPU_CORE4_OFF_EMU_TO_OFF             0x0010
#define MASK_PMU_APB_APCPU_CORE3_OFF_EMU_TO_OFF             0x0008
#define MASK_PMU_APB_APCPU_CORE2_OFF_EMU_TO_OFF             0x0004
#define MASK_PMU_APB_APCPU_CORE1_OFF_EMU_TO_OFF             0x0002
#define MASK_PMU_APB_APCPU_CORE0_OFF_EMU_TO_OFF             0x0001
#define MASK_PMU_APB_WDG_RST_TRIG_DBG_RECOV_EN              0x0001
#define MASK_PMU_APB_CORE7_ON_DISABLE                       0x0080
#define MASK_PMU_APB_CORE6_ON_DISABLE                       0x0040
#define MASK_PMU_APB_CORE5_ON_DISABLE                       0x0020
#define MASK_PMU_APB_CORE4_ON_DISABLE                       0x0010
#define MASK_PMU_APB_CORE3_ON_DISABLE                       0x0008
#define MASK_PMU_APB_CORE2_ON_DISABLE                       0x0004
#define MASK_PMU_APB_CORE1_ON_DISABLE                       0x0002
#define MASK_PMU_APB_CORE0_ON_DISABLE                       0x0001
#define MASK_PMU_APB_APCPU_CLUSTER_SW_PACTIVE_EN            0x0100
#define MASK_PMU_APB_APCPU_CORE7_SW_PACTIVE_EN              0x0080
#define MASK_PMU_APB_APCPU_CORE6_SW_PACTIVE_EN              0x0040
#define MASK_PMU_APB_APCPU_CORE5_SW_PACTIVE_EN              0x0020
#define MASK_PMU_APB_APCPU_CORE4_SW_PACTIVE_EN              0x0010
#define MASK_PMU_APB_APCPU_CORE3_SW_PACTIVE_EN              0x0008
#define MASK_PMU_APB_APCPU_CORE2_SW_PACTIVE_EN              0x0004
#define MASK_PMU_APB_APCPU_CORE1_SW_PACTIVE_EN              0x0002
#define MASK_PMU_APB_APCPU_CORE0_SW_PACTIVE_EN              0x0001
#define MASK_PMU_APB_APCPU_CLUSTER_SW_PCHANNEL_EN           0x0100
#define MASK_PMU_APB_APCPU_CORE7_SW_PCHANNEL_EN             0x0080
#define MASK_PMU_APB_APCPU_CORE6_SW_PCHANNEL_EN             0x0040
#define MASK_PMU_APB_APCPU_CORE5_SW_PCHANNEL_EN             0x0020
#define MASK_PMU_APB_APCPU_CORE4_SW_PCHANNEL_EN             0x0010
#define MASK_PMU_APB_APCPU_CORE3_SW_PCHANNEL_EN             0x0008
#define MASK_PMU_APB_APCPU_CORE2_SW_PCHANNEL_EN             0x0004
#define MASK_PMU_APB_APCPU_CORE1_SW_PCHANNEL_EN             0x0002
#define MASK_PMU_APB_APCPU_CORE0_SW_PCHANNEL_EN             0x0001
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CLUSTER_EN       0x0100
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE7_EN         0x0080
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE6_EN         0x0040
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE5_EN         0x0020
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE4_EN         0x0010
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE3_EN         0x0008
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE2_EN         0x0004
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE1_EN         0x0002
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE0_EN         0x0001
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CLUSTER_CLR      0x0100
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE7_CLR        0x0080
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE6_CLR        0x0040
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE5_CLR        0x0020
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE4_CLR        0x0010
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE3_CLR        0x0008
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE2_CLR        0x0004
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE1_CLR        0x0002
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE0_CLR        0x0001
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CLUSTER          0x0100
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE7            0x0080
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE6            0x0040
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE5            0x0020
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE4            0x0010
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE3            0x0008
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE2            0x0004
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE1            0x0002
#define MASK_PMU_APB_INT_REQ_MODE_ST_APCPU_CORE0            0x0001
#define MASK_PMU_APB_CORE_WFI_MARK_CLR                      0xFF0000
#define MASK_PMU_APB_CORE_WFI_MARK                          0x00FF
#define MASK_PMU_APB_APCPU_CORE_DEBUG_RECOV_STATE_CLR       0xFF000000
#define MASK_PMU_APB_APCPU_CORE7_WAKEUP_FROM_DEBUG_RECOV    0x0080
#define MASK_PMU_APB_APCPU_CORE6_WAKEUP_FROM_DEBUG_RECOV    0x0040
#define MASK_PMU_APB_APCPU_CORE5_WAKEUP_FROM_DEBUG_RECOV    0x0020
#define MASK_PMU_APB_APCPU_CORE4_WAKEUP_FROM_DEBUG_RECOV    0x0010
#define MASK_PMU_APB_APCPU_CORE3_WAKEUP_FROM_DEBUG_RECOV    0x0008
#define MASK_PMU_APB_APCPU_CORE2_WAKEUP_FROM_DEBUG_RECOV    0x0004
#define MASK_PMU_APB_APCPU_CORE1_WAKEUP_FROM_DEBUG_RECOV    0x0002
#define MASK_PMU_APB_APCPU_CORE0_WAKEUP_FROM_DEBUG_RECOV    0x0001
#define MASK_PMU_APB_APCPU_CORE3_POWER_MODE_STATE           0xFF000000
#define MASK_PMU_APB_APCPU_CORE2_POWER_MODE_STATE           0xFF0000
#define MASK_PMU_APB_APCPU_CORE1_POWER_MODE_STATE           0xFF00
#define MASK_PMU_APB_APCPU_CORE0_POWER_MODE_STATE           0x00FF
#define MASK_PMU_APB_APCPU_CORE7_POWER_MODE_STATE           0xFF000000
#define MASK_PMU_APB_APCPU_CORE6_POWER_MODE_STATE           0xFF0000
#define MASK_PMU_APB_APCPU_CORE5_POWER_MODE_STATE           0xFF00
#define MASK_PMU_APB_APCPU_CORE4_POWER_MODE_STATE           0x00FF
#define MASK_PMU_APB_APCPU_CORINTH_POWER_MODE_STATE         0x00FF
#define MASK_PMU_APB_APCPU_CORE7_PCHANNEL_STATE             0xF0000000
#define MASK_PMU_APB_APCPU_CORE6_PCHANNEL_STATE             0xF000000
#define MASK_PMU_APB_APCPU_CORE5_PCHANNEL_STATE             0xF00000
#define MASK_PMU_APB_APCPU_CORE4_PCHANNEL_STATE             0xF0000
#define MASK_PMU_APB_APCPU_CORE3_PCHANNEL_STATE             0xF000
#define MASK_PMU_APB_APCPU_CORE2_PCHANNEL_STATE             0x0F00
#define MASK_PMU_APB_APCPU_CORE1_PCHANNEL_STATE             0x00F0
#define MASK_PMU_APB_APCPU_CORE0_PCHANNEL_STATE             0x000F
#define MASK_PMU_APB_APCPU_CORINTH_PCHANNEL_STATE           0x000F
#define MASK_PMU_APB_SP_SLEEP_XTL_ON                        0x0100
#define MASK_PMU_APB_WCN_SLEEP_XTL_ON                       0x0080
#define MASK_PMU_APB_AUDCP_SLEEP_XTL_ON                     0x0008
#define MASK_PMU_APB_WTLCP_SLEEP_XTL_ON                     0x0004
#define MASK_PMU_APB_PUBCP_SLEEP_XTL_ON                     0x0002
#define MASK_PMU_APB_AP_SLEEP_XTL_ON                        0x0001
#define MASK_PMU_APB_AUDCP_PWR_WAIT_CNT                     0xFF000000
#define MASK_PMU_APB_WTLCP_PWR_WAIT_CNT                     0xFF0000
#define MASK_PMU_APB_PUBCP_PWR_WAIT_CNT                     0xFF00
#define MASK_PMU_APB_AP_PWR_WAIT_CNT                        0x00FF
#define MASK_PMU_APB_WCN_PWR_WAIT_CNT                       0xFF000000
#define MASK_PMU_APB_SP_PWR_WAIT_CNT                        0x00FF
#define MASK_PMU_APB_SP_PWR_PD_SP_MEM_BYP                   0x0002
#define MASK_PMU_APB_SP_PWR_PD_AON_MEM_BYP                  0x0001
#define MASK_PMU_APB_AP_DSLP_ENA                            0x0001
#define MASK_PMU_APB_PUBCP_DSLP_ENA                         0x0001
#define MASK_PMU_APB_WTLCP_DSLP_ENA                         0x0001
#define MASK_PMU_APB_AUDCP_DSLP_ENA                         0x0001
#define MASK_PMU_APB_WCN_DSLP_ENA                           0x0001
#define MASK_PMU_APB_SP_DSLP_ENA                            0x0001
#define MASK_PMU_APB_APCPU_TOP_DSLP_ENA                     0x0001
#define MASK_PMU_APB_PUBCP_CORE_INT_DISABLE                 0x0001
#define MASK_PMU_APB_AON_LSLP_ENA                           0x0100
#define MASK_PMU_APB_WCN_LSLP_ENA                           0x0080
#define MASK_PMU_APB_AUDCP_LSLP_ENA                         0x0008
#define MASK_PMU_APB_WTLCP_LSLP_ENA                         0x0004
#define MASK_PMU_APB_PUBCP_LSLP_ENA                         0x0002
#define MASK_PMU_APB_AP_LSLP_ENA                            0x0001
#define MASK_PMU_APB_WCN_PUB_DSLP_ENA                       0x0002
#define MASK_PMU_APB_AUDCP_PUB_DSLP_ENA                     0x0001
#define MASK_PMU_APB_AON_LSLP_WAKEUP_EN                     0x0100
#define MASK_PMU_APB_WCN_LSLP_WAKEUP_EN                     0x0080
#define MASK_PMU_APB_AUDCP_LSLP_WAKEUP_EN                   0x0008
#define MASK_PMU_APB_WTLCP_LSLP_WAKEUP_EN                   0x0004
#define MASK_PMU_APB_PUBCP_LSLP_WAKEUP_EN                   0x0002
#define MASK_PMU_APB_AP_LSLP_WAKEUP_EN                      0x0001
#define MASK_PMU_APB_WCN_PUB_DSLP_WAKEUP_EN                 0x0002
#define MASK_PMU_APB_AUDCP_PUB_DSLP_WAKEUP_EN               0x0001
#define MASK_PMU_APB_SP_FORCE_DEEP_SLEEP_REG                0x0100
#define MASK_PMU_APB_WCN_FORCE_DEEP_SLEEP_REG               0x0080
#define MASK_PMU_APB_AUDCP_FORCE_DEEP_SLEEP_REG             0x0008
#define MASK_PMU_APB_WTLCP_FORCE_DEEP_SLEEP_REG             0x0004
#define MASK_PMU_APB_PUBCP_FORCE_DEEP_SLEEP_REG             0x0002
#define MASK_PMU_APB_AP_FORCE_DEEP_SLEEP_REG                0x0001
#define MASK_PMU_APB_PUB_FORCE_DEEP_SLEEP_REG               0x0001
#define MASK_PMU_APB_WCN_FORCE_PUB_DEEP_SLEEP               0x0002
#define MASK_PMU_APB_AUDCP_FORCE_PUB_DEEP_SLEEP             0x0001
#define MASK_PMU_APB_APCPU_TOP_FORCE_SYSTEM_SLEEP           0x80000
#define MASK_PMU_APB_SP_FORCE_SYSTEM_SLEEP                  0x0100
#define MASK_PMU_APB_WCN_FORCE_SYSTEM_SLEEP                 0x0080
#define MASK_PMU_APB_AUDCP_FORCE_SYSTEM_SLEEP               0x0008
#define MASK_PMU_APB_WTLCP_FORCE_SYSTEM_SLEEP               0x0004
#define MASK_PMU_APB_PUBCP_FORCE_SYSTEM_SLEEP               0x0002
#define MASK_PMU_APB_AP_FORCE_SYSTEM_SLEEP                  0x0001
#define MASK_PMU_APB_PUB_FORCE_SYSTEM_SLEEP                 0x0001
#define MASK_PMU_APB_AP_ALL_FORCE_SYSTEM_SLEEP              0x0001
#define MASK_PMU_APB_AON_FORCE_LIGHT_SLEEP                  0x0100
#define MASK_PMU_APB_WCN_FORCE_LIGHT_SLEEP                  0x0080
#define MASK_PMU_APB_AUDCP_FORCE_LIGHT_SLEEP                0x0008
#define MASK_PMU_APB_WTLCP_FORCE_LIGHT_SLEEP                0x0004
#define MASK_PMU_APB_PUBCP_FORCE_LIGHT_SLEEP                0x0002
#define MASK_PMU_APB_AP_FORCE_LIGHT_SLEEP                   0x0001
#define MASK_PMU_APB_PUB_FORCE_LIGHT_SLEEP                  0x0001
#define MASK_PMU_APB_REG_AON_TOP_AB_DDR_PWR_HS_ACK          0x0100
#define MASK_PMU_APB_REG_WCN_DDR_PWR_HS_ACK                 0x0080
#define MASK_PMU_APB_REG_PUBCP_DDR_PWR_HS_ACK               0x0040
#define MASK_PMU_APB_REG_WTLCP_DDR_PWR_HS_ACK               0x0020
#define MASK_PMU_APB_REG_AUDCP_DDR_PWR_HS_ACK               0x0010
#define MASK_PMU_APB_REG_APCPU_TOP_DDR_PWR_HS_ACK           0x0008
#define MASK_PMU_APB_REG_GPU_TOP_DDR_PWR_HS_ACK             0x0004
#define MASK_PMU_APB_REG_MM_DDR_PWR_HS_ACK                  0x0002
#define MASK_PMU_APB_REG_AP_DDR_PWR_HS_ACK                  0x0001
#define MASK_PMU_APB_SP_DEEP_SLEEP                          0x0100
#define MASK_PMU_APB_WCN_DEEP_SLEEP                         0x0080
#define MASK_PMU_APB_AUDCP_DEEP_SLEEP                       0x0008
#define MASK_PMU_APB_WTLCP_DEEP_SLEEP                       0x0004
#define MASK_PMU_APB_PUBCP_DEEP_SLEEP                       0x0002
#define MASK_PMU_APB_AP_DEEP_SLEEP                          0x0001
#define MASK_PMU_APB_PUB_DEEP_SLEEP                         0x0001
#define MASK_PMU_APB_AON_LIGHT_SLEEP                        0x0100
#define MASK_PMU_APB_WCN_LIGHT_SLEEP                        0x0080
#define MASK_PMU_APB_AUDCP_LIGHT_SLEEP                      0x0008
#define MASK_PMU_APB_WTLCP_LIGHT_SLEEP                      0x0004
#define MASK_PMU_APB_PUBCP_LIGHT_SLEEP                      0x0002
#define MASK_PMU_APB_AP_LIGHT_SLEEP                         0x0001
#define MASK_PMU_APB_PUB_LIGHT_SLEEP                        0x0001
#define MASK_PMU_APB_WCN_SLP_STATUS                         0xF0000000
#define MASK_PMU_APB_AUDCP_SLP_STATUS                       0xF000
#define MASK_PMU_APB_WTLCP_SLP_STATUS                       0x0F00
#define MASK_PMU_APB_PUBCP_SLP_STATUS                       0x00F0
#define MASK_PMU_APB_AP_SLP_STATUS                          0x000F
#define MASK_PMU_APB_SP_SLP_STATUS                          0x000F
#define MASK_PMU_APB_PUB_DEEP_SLEEP_WAIT_CNT                0xFFFF0000
#define MASK_PMU_APB_PUB_SLEEP_WAIT_CNT                     0xFFFF
#define MASK_PMU_APB_PUB_PD_VOL_DOWN_ENA                    0x0010
#define MASK_PMU_APB_PUB_VOL_ADJ_ENA                        0x0008
#define MASK_PMU_APB_PUB_SELF_REFRESH_FLAG_BYPASS           0x0004
#define MASK_PMU_APB_PUB_PWR_PD_ACK_BYPASS                  0x0002
#define MASK_PMU_APB_PUB_DEEP_SLEEP_LOCK_ACK_BYPASS         0x0001
#define MASK_PMU_APB_DDR_PHY_ISO_RST_EN                     0x0002
#define MASK_PMU_APB_DDR_PHY_AUTO_RET_EN                    0x0001
#define MASK_PMU_APB_DDR_UMCTL_SOFT_RST                     0x0002
#define MASK_PMU_APB_DDR_PHY_CKE_RET_EN                     0x0001
#define MASK_PMU_APB_PUB_ACC_RDY                            0x0001
#define MASK_PMU_APB_PUB_AUTO_DEEP_SLEEP_ENABLE             0x0008
#define MASK_PMU_APB_DDR_SLEEP_DISABLE_ACK                  0x0004
#define MASK_PMU_APB_DDR_SLEEP_DISABLE_ACK_BYP              0x0002
#define MASK_PMU_APB_DDR_SLEEP_DISABLE                      0x0001
#define MASK_PMU_APB_DDR_SLP_STATUS                         0x000F
#define MASK_PMU_APB_PUB_VOL_UP_CNT                         0xFFFF0000
#define MASK_PMU_APB_PUB_VOL_DOWN_CNT                       0xFFFF
#define MASK_PMU_APB_PUB_SMART_LSLP_ENA                     0x10000000
#define MASK_PMU_APB_GPU_TOP_SMART_LSLP_ENA                 0x800000
#define MASK_PMU_APB_MM_SMART_LSLP_ENA                      0x200000
#define MASK_PMU_APB_APCPU_TOP_SMART_LSLP_ENA               0x80000
#define MASK_PMU_APB_AON_SMART_LSLP_ENA                     0x0100
#define MASK_PMU_APB_WCN_SMART_LSLP_ENA                     0x0080
#define MASK_PMU_APB_AUDCP_SMART_LSLP_ENA                   0x0008
#define MASK_PMU_APB_WTLCP_SMART_LSLP_ENA                   0x0004
#define MASK_PMU_APB_PUBCP_SMART_LSLP_ENA                   0x0002
#define MASK_PMU_APB_AP_SMART_LSLP_ENA                      0x0001
#define MASK_PMU_APB_PUB_AUTO_LIGHT_SLEEP_ENABLE            0xFFFFFFFF
#define MASK_PMU_APB_MM_PUB_DEEP_SLEEP_POLL                 0xFF000000
#define MASK_PMU_APB_GPU_TOP_PUB_DEEP_SLEEP_POLL            0xFF0000
#define MASK_PMU_APB_APCPU_TOP_PUB_DEEP_SLEEP_POLL          0xFF00
#define MASK_PMU_APB_AP_PUB_DEEP_SLEEP_POLL                 0x00FF
#define MASK_PMU_APB_PUBCP_PUB_DEEP_SLEEP_POLL              0xFF000000
#define MASK_PMU_APB_WTLCP_PUB_DEEP_SLEEP_POLL              0xFF0000
#define MASK_PMU_APB_AUDCP_PUB_DEEP_SLEEP_POLL              0xFF0000
#define MASK_PMU_APB_WCN_PUB_DEEP_SLEEP_POLL                0x00FF
#define MASK_PMU_APB_AON_PUB_DEEP_SLEEP_POLL                0xFF0000
#define MASK_PMU_APB_SP_PUB_DEEP_SLEEP_POLL                 0x00FF
#define MASK_PMU_APB_PUB_DFS_FSP_OP_DATA                    0x0100
#define MASK_PMU_APB_PUB_DFS_FSP_OP                         0x0080
#define MASK_PMU_APB_PUB_DFS_FRQ_SET_DATA                   0x0070
#define MASK_PMU_APB_PUB_DFS_FRQ_SEL_SET                    0x0008
#define MASK_PMU_APB_PUB_DFS_FRQ_SEL_LOCK                   0x0007
#define MASK_PMU_APB_PUB_DEEP_SLEEP_SEL                     0x0001
#define MASK_PMU_APB_WCN_ACCESS_DDR_EIC_EN                  0x0004
#define MASK_PMU_APB_SP_ACCESS_DDR_EIC_EN                   0x0002
#define MASK_PMU_APB_SP_ACCESS_DDR_EN                       0x0001
#define MASK_PMU_APB_FW_WAKEUP_DDR_EN                       0x0001
#define MASK_PMU_APB_XTL0_TOP_DVFS_SEL                      0x2000000
#define MASK_PMU_APB_XTL0_PUB_SEL                           0x200000
#define MASK_PMU_APB_XTL0_SP_SEL                            0x0400
#define MASK_PMU_APB_XTL0_WCN_SEL                           0x0200
#define MASK_PMU_APB_XTL0_AUDCP_SEL                         0x0020
#define MASK_PMU_APB_XTL0_WTLCP_SEL                         0x0010
#define MASK_PMU_APB_XTL0_PUBCP_SEL                         0x0008
#define MASK_PMU_APB_XTL0_AP_SEL                            0x0004
#define MASK_PMU_APB_XTL0_FRC_OFF                           0x0002
#define MASK_PMU_APB_XTL0_FRC_ON                            0x0001
#define MASK_PMU_APB_XTL1_TOP_DVFS_SEL                      0x2000000
#define MASK_PMU_APB_XTL1_PUB_SEL                           0x200000
#define MASK_PMU_APB_XTL1_SP_SEL                            0x0400
#define MASK_PMU_APB_XTL1_WCN_SEL                           0x0200
#define MASK_PMU_APB_XTL1_AUDCP_SEL                         0x0020
#define MASK_PMU_APB_XTL1_WTLCP_SEL                         0x0010
#define MASK_PMU_APB_XTL1_PUBCP_SEL                         0x0008
#define MASK_PMU_APB_XTL1_AP_SEL                            0x0004
#define MASK_PMU_APB_XTL1_FRC_OFF                           0x0002
#define MASK_PMU_APB_XTL1_FRC_ON                            0x0001
#define MASK_PMU_APB_XTL2_TOP_DVFS_SEL                      0x2000000
#define MASK_PMU_APB_XTL2_PUB_SEL                           0x200000
#define MASK_PMU_APB_XTL2_SP_SEL                            0x0400
#define MASK_PMU_APB_XTL2_WCN_SEL                           0x0200
#define MASK_PMU_APB_XTL2_AUDCP_SEL                         0x0020
#define MASK_PMU_APB_XTL2_WTLCP_SEL                         0x0010
#define MASK_PMU_APB_XTL2_PUBCP_SEL                         0x0008
#define MASK_PMU_APB_XTL2_AP_SEL                            0x0004
#define MASK_PMU_APB_XTL2_FRC_OFF                           0x0002
#define MASK_PMU_APB_XTL2_FRC_ON                            0x0001
#define MASK_PMU_APB_XTL3_TOP_DVFS_SEL                      0x2000000
#define MASK_PMU_APB_XTL3_PUB_SEL                           0x200000
#define MASK_PMU_APB_XTL3_SP_SEL                            0x0400
#define MASK_PMU_APB_XTL3_WCN_SEL                           0x0200
#define MASK_PMU_APB_XTL3_AUDCP_SEL                         0x0020
#define MASK_PMU_APB_XTL3_WTLCP_SEL                         0x0010
#define MASK_PMU_APB_XTL3_PUBCP_SEL                         0x0008
#define MASK_PMU_APB_XTL3_AP_SEL                            0x0004
#define MASK_PMU_APB_XTL3_FRC_OFF                           0x0002
#define MASK_PMU_APB_XTL3_FRC_ON                            0x0001
#define MASK_PMU_APB_XTLBUF0_TOP_DVFS_SEL                   0x2000000
#define MASK_PMU_APB_XTLBUF0_PUB_SEL                        0x200000
#define MASK_PMU_APB_XTLBUF0_SP_SEL                         0x0400
#define MASK_PMU_APB_XTLBUF0_WCN_SEL                        0x0200
#define MASK_PMU_APB_XTLBUF0_AUDCP_SEL                      0x0020
#define MASK_PMU_APB_XTLBUF0_WTLCP_SEL                      0x0010
#define MASK_PMU_APB_XTLBUF0_PUBCP_SEL                      0x0008
#define MASK_PMU_APB_XTLBUF0_AP_SEL                         0x0004
#define MASK_PMU_APB_XTLBUF0_FRC_OFF                        0x0002
#define MASK_PMU_APB_XTLBUF0_FRC_ON                         0x0001
#define MASK_PMU_APB_XTLBUF1_TOP_DVFS_SEL                   0x2000000
#define MASK_PMU_APB_XTLBUF1_PUB_SEL                        0x200000
#define MASK_PMU_APB_XTLBUF1_SP_SEL                         0x0400
#define MASK_PMU_APB_XTLBUF1_WCN_SEL                        0x0200
#define MASK_PMU_APB_XTLBUF1_AUDCP_SEL                      0x0020
#define MASK_PMU_APB_XTLBUF1_WTLCP_SEL                      0x0010
#define MASK_PMU_APB_XTLBUF1_PUBCP_SEL                      0x0008
#define MASK_PMU_APB_XTLBUF1_AP_SEL                         0x0004
#define MASK_PMU_APB_XTLBUF1_FRC_OFF                        0x0002
#define MASK_PMU_APB_XTLBUF1_FRC_ON                         0x0001
#define MASK_PMU_APB_XTLBUF2_TOP_DVFS_SEL                   0x2000000
#define MASK_PMU_APB_XTLBUF2_PUB_SEL                        0x200000
#define MASK_PMU_APB_XTLBUF2_SP_SEL                         0x0400
#define MASK_PMU_APB_XTLBUF2_WCN_SEL                        0x0200
#define MASK_PMU_APB_XTLBUF2_AUDCP_SEL                      0x0020
#define MASK_PMU_APB_XTLBUF2_WTLCP_SEL                      0x0010
#define MASK_PMU_APB_XTLBUF2_PUBCP_SEL                      0x0008
#define MASK_PMU_APB_XTLBUF2_AP_SEL                         0x0004
#define MASK_PMU_APB_XTLBUF2_FRC_OFF                        0x0002
#define MASK_PMU_APB_XTLBUF2_FRC_ON                         0x0001
#define MASK_PMU_APB_XTLBUF3_TOP_DVFS_SEL                   0x2000000
#define MASK_PMU_APB_XTLBUF3_PUB_SEL                        0x200000
#define MASK_PMU_APB_XTLBUF3_SP_SEL                         0x0400
#define MASK_PMU_APB_XTLBUF3_WCN_SEL                        0x0200
#define MASK_PMU_APB_XTLBUF3_AUDCP_SEL                      0x0020
#define MASK_PMU_APB_XTLBUF3_WTLCP_SEL                      0x0010
#define MASK_PMU_APB_XTLBUF3_PUBCP_SEL                      0x0008
#define MASK_PMU_APB_XTLBUF3_AP_SEL                         0x0004
#define MASK_PMU_APB_XTLBUF3_FRC_OFF                        0x0002
#define MASK_PMU_APB_XTLBUF3_FRC_ON                         0x0001
#define MASK_PMU_APB_RCO_CSYSPWRUPREQ_SEL                   0x4000000
#define MASK_PMU_APB_RCO_TOP_DVFS_SEL                       0x2000000
#define MASK_PMU_APB_RCO_PUB_SEL                            0x200000
#define MASK_PMU_APB_RCO_SP_SEL                             0x0400
#define MASK_PMU_APB_RCO_WCN_SEL                            0x0200
#define MASK_PMU_APB_RCO_AUDCP_SEL                          0x0020
#define MASK_PMU_APB_RCO_WTLCP_SEL                          0x0010
#define MASK_PMU_APB_RCO_PUBCP_SEL                          0x0008
#define MASK_PMU_APB_RCO_AP_SEL                             0x0004
#define MASK_PMU_APB_RCO_FRC_OFF                            0x0002
#define MASK_PMU_APB_RCO_FRC_ON                             0x0001
#define MASK_PMU_APB_MPLL0_REF_SEL                          0x8000000
#define MASK_PMU_APB_MPLL0_TOP_DVFS_SEL                     0x2000000
#define MASK_PMU_APB_MPLL0_PUB_SEL                          0x200000
#define MASK_PMU_APB_MPLL0_SP_SEL                           0x0400
#define MASK_PMU_APB_MPLL0_WCN_SEL                          0x0200
#define MASK_PMU_APB_MPLL0_AUDCP_SEL                        0x0020
#define MASK_PMU_APB_MPLL0_WTLCP_SEL                        0x0010
#define MASK_PMU_APB_MPLL0_PUBCP_SEL                        0x0008
#define MASK_PMU_APB_MPLL0_AP_SEL                           0x0004
#define MASK_PMU_APB_MPLL0_FRC_OFF                          0x0002
#define MASK_PMU_APB_MPLL0_FRC_ON                           0x0001
#define MASK_PMU_APB_MPLL1_REF_SEL                          0x8000000
#define MASK_PMU_APB_MPLL1_TOP_DVFS_SEL                     0x2000000
#define MASK_PMU_APB_MPLL1_PUB_SEL                          0x200000
#define MASK_PMU_APB_MPLL1_SP_SEL                           0x0400
#define MASK_PMU_APB_MPLL1_WCN_SEL                          0x0200
#define MASK_PMU_APB_MPLL1_AUDCP_SEL                        0x0020
#define MASK_PMU_APB_MPLL1_WTLCP_SEL                        0x0010
#define MASK_PMU_APB_MPLL1_PUBCP_SEL                        0x0008
#define MASK_PMU_APB_MPLL1_AP_SEL                           0x0004
#define MASK_PMU_APB_MPLL1_FRC_OFF                          0x0002
#define MASK_PMU_APB_MPLL1_FRC_ON                           0x0001
#define MASK_PMU_APB_MPLL2_REF_SEL                          0x8000000
#define MASK_PMU_APB_MPLL2_TOP_DVFS_SEL                     0x2000000
#define MASK_PMU_APB_MPLL2_PUB_SEL                          0x200000
#define MASK_PMU_APB_MPLL2_SP_SEL                           0x0400
#define MASK_PMU_APB_MPLL2_WCN_SEL                          0x0200
#define MASK_PMU_APB_MPLL2_AUDCP_SEL                        0x0020
#define MASK_PMU_APB_MPLL2_WTLCP_SEL                        0x0010
#define MASK_PMU_APB_MPLL2_PUBCP_SEL                        0x0008
#define MASK_PMU_APB_MPLL2_AP_SEL                           0x0004
#define MASK_PMU_APB_MPLL2_FRC_OFF                          0x0002
#define MASK_PMU_APB_MPLL2_FRC_ON                           0x0001
#define MASK_PMU_APB_RPLL_REF_SEL                           0x18000000
#define MASK_PMU_APB_RPLL_TOP_DVFS_SEL                      0x2000000
#define MASK_PMU_APB_RPLL_PUB_SEL                           0x200000
#define MASK_PMU_APB_RPLL_SP_SEL                            0x0400
#define MASK_PMU_APB_RPLL_WCN_SEL                           0x0200
#define MASK_PMU_APB_RPLL_AUDCP_SEL                         0x0020
#define MASK_PMU_APB_RPLL_WTLCP_SEL                         0x0010
#define MASK_PMU_APB_RPLL_PUBCP_SEL                         0x0008
#define MASK_PMU_APB_RPLL_AP_SEL                            0x0004
#define MASK_PMU_APB_RPLL_FRC_OFF                           0x0002
#define MASK_PMU_APB_RPLL_FRC_ON                            0x0001
#define MASK_PMU_APB_DPLL0_REF_SEL                          0x8000000
#define MASK_PMU_APB_DPLL0_TOP_DVFS_SEL                     0x2000000
#define MASK_PMU_APB_DPLL0_PUB_SEL                          0x200000
#define MASK_PMU_APB_DPLL0_SP_SEL                           0x0400
#define MASK_PMU_APB_DPLL0_WCN_SEL                          0x0200
#define MASK_PMU_APB_DPLL0_AUDCP_SEL                        0x0020
#define MASK_PMU_APB_DPLL0_WTLCP_SEL                        0x0010
#define MASK_PMU_APB_DPLL0_PUBCP_SEL                        0x0008
#define MASK_PMU_APB_DPLL0_AP_SEL                           0x0004
#define MASK_PMU_APB_DPLL0_FRC_OFF                          0x0002
#define MASK_PMU_APB_DPLL0_FRC_ON                           0x0001
#define MASK_PMU_APB_GPLL_REF_SEL                           0x8000000
#define MASK_PMU_APB_GPLL_TOP_DVFS_SEL                      0x2000000
#define MASK_PMU_APB_GPLL_PUB_SEL                           0x200000
#define MASK_PMU_APB_GPLL_SP_SEL                            0x0400
#define MASK_PMU_APB_GPLL_WCN_SEL                           0x0200
#define MASK_PMU_APB_GPLL_AUDCP_SEL                         0x0020
#define MASK_PMU_APB_GPLL_WTLCP_SEL                         0x0010
#define MASK_PMU_APB_GPLL_PUBCP_SEL                         0x0008
#define MASK_PMU_APB_GPLL_AP_SEL                            0x0004
#define MASK_PMU_APB_GPLL_FRC_OFF                           0x0002
#define MASK_PMU_APB_GPLL_FRC_ON                            0x0001
#define MASK_PMU_APB_ISPPLL_REF_SEL                         0x8000000
#define MASK_PMU_APB_ISPPLL_TOP_DVFS_SEL                    0x2000000
#define MASK_PMU_APB_ISPPLL_PUB_SEL                         0x200000
#define MASK_PMU_APB_ISPPLL_SP_SEL                          0x0400
#define MASK_PMU_APB_ISPPLL_WCN_SEL                         0x0200
#define MASK_PMU_APB_ISPPLL_AUDCP_SEL                       0x0020
#define MASK_PMU_APB_ISPPLL_WTLCP_SEL                       0x0010
#define MASK_PMU_APB_ISPPLL_PUBCP_SEL                       0x0008
#define MASK_PMU_APB_ISPPLL_AP_SEL                          0x0004
#define MASK_PMU_APB_ISPPLL_FRC_OFF                         0x0002
#define MASK_PMU_APB_ISPPLL_FRC_ON                          0x0001
#define MASK_PMU_APB_TWPLL_REF_SEL                          0x18000000
#define MASK_PMU_APB_TWPLL_TOP_DVFS_SEL                     0x2000000
#define MASK_PMU_APB_TWPLL_PUB_SEL                          0x200000
#define MASK_PMU_APB_TWPLL_SP_SEL                           0x0400
#define MASK_PMU_APB_TWPLL_WCN_SEL                          0x0200
#define MASK_PMU_APB_TWPLL_AUDCP_SEL                        0x0020
#define MASK_PMU_APB_TWPLL_WTLCP_SEL                        0x0010
#define MASK_PMU_APB_TWPLL_PUBCP_SEL                        0x0008
#define MASK_PMU_APB_TWPLL_AP_SEL                           0x0004
#define MASK_PMU_APB_TWPLL_FRC_OFF                          0x0002
#define MASK_PMU_APB_TWPLL_FRC_ON                           0x0001
#define MASK_PMU_APB_LTEPLL_REF_SEL                         0x18000000
#define MASK_PMU_APB_LTEPLL_TOP_DVFS_SEL                    0x2000000
#define MASK_PMU_APB_LTEPLL_PUB_SEL                         0x200000
#define MASK_PMU_APB_LTEPLL_SP_SEL                          0x0400
#define MASK_PMU_APB_LTEPLL_WCN_SEL                         0x0200
#define MASK_PMU_APB_LTEPLL_AUDCP_SEL                       0x0020
#define MASK_PMU_APB_LTEPLL_WTLCP_SEL                       0x0010
#define MASK_PMU_APB_LTEPLL_PUBCP_SEL                       0x0008
#define MASK_PMU_APB_LTEPLL_AP_SEL                          0x0004
#define MASK_PMU_APB_LTEPLL_FRC_OFF                         0x0002
#define MASK_PMU_APB_LTEPLL_FRC_ON                          0x0001
#define MASK_PMU_APB_XTL3_WAIT_CNT                          0xFF000000
#define MASK_PMU_APB_XTL2_WAIT_CNT                          0xFF0000
#define MASK_PMU_APB_XTL1_WAIT_CNT                          0xFF00
#define MASK_PMU_APB_XTL0_WAIT_CNT                          0x00FF
#define MASK_PMU_APB_XTLBUF3_WAIT_CNT                       0xFF000000
#define MASK_PMU_APB_XTLBUF2_WAIT_CNT                       0xFF0000
#define MASK_PMU_APB_XTLBUF1_WAIT_CNT                       0xFF00
#define MASK_PMU_APB_XTLBUF0_WAIT_CNT                       0x00FF
#define MASK_PMU_APB_RCO_WAIT_CNT                           0x00FF
#define MASK_PMU_APB_MPLL2_WAIT_CNT                         0xFF0000
#define MASK_PMU_APB_MPLL1_WAIT_CNT                         0xFF00
#define MASK_PMU_APB_MPLL0_WAIT_CNT                         0x00FF
#define MASK_PMU_APB_RPLL_WAIT_CNT                          0xFF0000
#define MASK_PMU_APB_GPLL_WAIT_CNT                          0xFF000000
#define MASK_PMU_APB_DPLL0_WAIT_CNT                         0x00FF
#define MASK_PMU_APB_ISPPLL_WAIT_CNT                        0xFF00
#define MASK_PMU_APB_TWPLL_WAIT_CNT                         0xFF000000
#define MASK_PMU_APB_LTEPLL_WAIT_CNT                        0x00FF
#define MASK_PMU_APB_MPLL0_RST_CTRL_BYPASS                  0x1000000
#define MASK_PMU_APB_MPLL0_DELAY_PWR_ON                     0xFF0000
#define MASK_PMU_APB_MPLL0_DELAY_EN_OFF                     0xFF00
#define MASK_PMU_APB_MPLL0_DELAY_RST_ASSERT                 0x00FF
#define MASK_PMU_APB_MPLL1_RST_CTRL_BYPASS                  0x1000000
#define MASK_PMU_APB_MPLL1_DELAY_PWR_ON                     0xFF0000
#define MASK_PMU_APB_MPLL1_DELAY_EN_OFF                     0xFF00
#define MASK_PMU_APB_MPLL1_DELAY_RST_ASSERT                 0x00FF
#define MASK_PMU_APB_MPLL2_RST_CTRL_BYPASS                  0x1000000
#define MASK_PMU_APB_MPLL2_DELAY_PWR_ON                     0xFF0000
#define MASK_PMU_APB_MPLL2_DELAY_EN_OFF                     0xFF00
#define MASK_PMU_APB_MPLL2_DELAY_RST_ASSERT                 0x00FF
#define MASK_PMU_APB_RPLL_RST_CTRL_BYPASS                   0x1000000
#define MASK_PMU_APB_RPLL_DELAY_PWR_ON                      0xFF0000
#define MASK_PMU_APB_RPLL_DELAY_EN_OFF                      0xFF00
#define MASK_PMU_APB_RPLL_DELAY_RST_ASSERT                  0x00FF
#define MASK_PMU_APB_DPLL0_RST_CTRL_BYPASS                  0x1000000
#define MASK_PMU_APB_DPLL0_DELAY_PWR_ON                     0xFF0000
#define MASK_PMU_APB_DPLL0_DELAY_EN_OFF                     0xFF00
#define MASK_PMU_APB_DPLL0_DELAY_RST_ASSERT                 0x00FF
#define MASK_PMU_APB_GPLL_RST_CTRL_BYPASS                   0x1000000
#define MASK_PMU_APB_GPLL_DELAY_PWR_ON                      0xFF0000
#define MASK_PMU_APB_GPLL_DELAY_EN_OFF                      0xFF00
#define MASK_PMU_APB_GPLL_DELAY_RST_ASSERT                  0x00FF
#define MASK_PMU_APB_ISPPLL_RST_CTRL_BYPASS                 0x1000000
#define MASK_PMU_APB_ISPPLL_DELAY_PWR_ON                    0xFF0000
#define MASK_PMU_APB_ISPPLL_DELAY_EN_OFF                    0xFF00
#define MASK_PMU_APB_ISPPLL_DELAY_RST_ASSERT                0x00FF
#define MASK_PMU_APB_TWPLL_RST_CTRL_BYPASS                  0x1000000
#define MASK_PMU_APB_TWPLL_DELAY_PWR_ON                     0xFF0000
#define MASK_PMU_APB_TWPLL_DELAY_EN_OFF                     0xFF00
#define MASK_PMU_APB_TWPLL_DELAY_RST_ASSERT                 0x00FF
#define MASK_PMU_APB_LTEPLL_RST_CTRL_BYPASS                 0x1000000
#define MASK_PMU_APB_LTEPLL_DELAY_PWR_ON                    0xFF0000
#define MASK_PMU_APB_LTEPLL_DELAY_EN_OFF                    0xFF00
#define MASK_PMU_APB_LTEPLL_DELAY_RST_ASSERT                0x00FF
#define MASK_PMU_APB_ST_RPLL_STATE                          0xF000000
#define MASK_PMU_APB_ST_MPLL2_STATE                         0x0F00
#define MASK_PMU_APB_ST_MPLL1_STATE                         0x00F0
#define MASK_PMU_APB_ST_MPLL0_STATE                         0x000F
#define MASK_PMU_APB_ST_ISPPLL_STATE                        0xF00000
#define MASK_PMU_APB_ST_GPLL_STATE                          0xF000
#define MASK_PMU_APB_ST_DPLL0_STATE                         0x000F
#define MASK_PMU_APB_ST_LTEPLL_STATE                        0xF0000
#define MASK_PMU_APB_ST_TWPLL_STATE                         0xF000
#define MASK_PMU_APB_APCPU_TOP_DSLP_ENA_SOFT_RST_MASK       0x10000
#define MASK_PMU_APB_APCPU_CORE7_DSLP_ENA_SOFT_RST_MASK     0x0080
#define MASK_PMU_APB_APCPU_CORE6_DSLP_ENA_SOFT_RST_MASK     0x0040
#define MASK_PMU_APB_APCPU_CORE5_DSLP_ENA_SOFT_RST_MASK     0x0020
#define MASK_PMU_APB_APCPU_CORE4_DSLP_ENA_SOFT_RST_MASK     0x0010
#define MASK_PMU_APB_APCPU_CORE3_DSLP_ENA_SOFT_RST_MASK     0x0008
#define MASK_PMU_APB_APCPU_CORE2_DSLP_ENA_SOFT_RST_MASK     0x0004
#define MASK_PMU_APB_APCPU_CORE1_DSLP_ENA_SOFT_RST_MASK     0x0002
#define MASK_PMU_APB_APCPU_CORE0_DSLP_ENA_SOFT_RST_MASK     0x0001
#define MASK_PMU_APB_APCPU_TOP_GIC_RST_EN                   0x10000
#define MASK_PMU_APB_APCPU_CORE7_GIC_RST_EN                 0x0080
#define MASK_PMU_APB_APCPU_CORE6_GIC_RST_EN                 0x0040
#define MASK_PMU_APB_APCPU_CORE5_GIC_RST_EN                 0x0020
#define MASK_PMU_APB_APCPU_CORE4_GIC_RST_EN                 0x0010
#define MASK_PMU_APB_APCPU_CORE3_GIC_RST_EN                 0x0008
#define MASK_PMU_APB_APCPU_CORE2_GIC_RST_EN                 0x0004
#define MASK_PMU_APB_APCPU_CORE1_GIC_RST_EN                 0x0002
#define MASK_PMU_APB_APCPU_CORE0_GIC_RST_EN                 0x0001
#define MASK_PMU_APB_APCPU_TOP_CLUSTER_MODE_ST_SOFT_RST     0x10000
#define MASK_PMU_APB_APCPU_CORE7_MODE_ST_SOFT_RST           0x0080
#define MASK_PMU_APB_APCPU_CORE6_MODE_ST_SOFT_RST           0x0040
#define MASK_PMU_APB_APCPU_CORE5_MODE_ST_SOFT_RST           0x0020
#define MASK_PMU_APB_APCPU_CORE4_MODE_ST_SOFT_RST           0x0010
#define MASK_PMU_APB_APCPU_CORE3_MODE_ST_SOFT_RST           0x0008
#define MASK_PMU_APB_APCPU_CORE2_MODE_ST_SOFT_RST           0x0004
#define MASK_PMU_APB_APCPU_CORE1_MODE_ST_SOFT_RST           0x0002
#define MASK_PMU_APB_APCPU_CORE0_MODE_ST_SOFT_RST           0x0001
#define MASK_PMU_APB_WTLCP_TGDSP_SOFT_RST                   0x0010
#define MASK_PMU_APB_WTLCP_LDSP_SOFT_RST                    0x0008
#define MASK_PMU_APB_AUDCP_AUDDSP_SOFT_RST                  0x0001
#define MASK_PMU_APB_WTLCP_AON_SOFT_RST                     0x0001
#define MASK_PMU_APB_REG_AUDCP_SRST_FRC_LP_ACK              0x400000
#define MASK_PMU_APB_REG_WCN_SRST_FRC_LP_ACK                0x100000
#define MASK_PMU_APB_REG_WTLCP_SRST_FRC_LP_ACK              0x4000
#define MASK_PMU_APB_REG_PUBCP_SRST_FRC_LP_ACK              0x0800
#define MASK_PMU_APB_REG_MM_SRST_FRC_LP_ACK                 0x0008
#define MASK_PMU_APB_REG_GPU_TOP_SRST_FRC_LP_ACK            0x0004
#define MASK_PMU_APB_REG_APCPU_TOP_SRST_FRC_LP_ACK          0x0002
#define MASK_PMU_APB_REG_AP_SRST_FRC_LP_ACK                 0x0001
#define MASK_PMU_APB_AON_SOFT_RST                           0x40000000
#define MASK_PMU_APB_AUDCP_SOFT_RST                         0x400000
#define MASK_PMU_APB_WCN_SOFT_RST                           0x100000
#define MASK_PMU_APB_WTLCP_SOFT_RST                         0x4000
#define MASK_PMU_APB_PUBCP_SOFT_RST                         0x0800
#define MASK_PMU_APB_MM_SOFT_RST                            0x0008
#define MASK_PMU_APB_GPU_TOP_SOFT_RST                       0x0004
#define MASK_PMU_APB_APCPU_TOP_SOFT_RST                     0x0002
#define MASK_PMU_APB_AP_SOFT_RST                            0x0001
#define MASK_PMU_APB_PUB_SOFT_RST                           0x0010
#define MASK_PMU_APB_SP_SOFT_RST                            0x0001
#define MASK_PMU_APB_AUDCP_SRST_BUSY                        0x400000
#define MASK_PMU_APB_WCN_SRST_BUSY                          0x100000
#define MASK_PMU_APB_WTLCP_SRST_BUSY                        0x4000
#define MASK_PMU_APB_PUBCP_SRST_BUSY                        0x0800
#define MASK_PMU_APB_MM_SRST_BUSY                           0x0008
#define MASK_PMU_APB_GPU_TOP_SRST_BUSY                      0x0004
#define MASK_PMU_APB_APCPU_TOP_SRST_BUSY                    0x0002
#define MASK_PMU_APB_AP_SRST_BUSY                           0x0001
#define MASK_PMU_APB_SOFT_RST_SEL                           0xFFFFFFFF
#define MASK_PMU_APB_PD_AP_SHUTDOWN_MARK                    0x000F
#define MASK_PMU_APB_PD_APCPU_TOP_SHUTDOWN_MARK             0x000F
#define MASK_PMU_APB_PD_APCPU_CORE0_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE1_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE2_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE3_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE4_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE5_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE6_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_APCPU_CORE7_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_GPU_TOP_SHUTDOWN_MARK               0x000F
#define MASK_PMU_APB_PD_MM_SHUTDOWN_MARK                    0x000F
#define MASK_PMU_APB_PD_AP_VSP_SHUTDOWN_MARK                0x000F
#define MASK_PMU_APB_PD_PUBCP_SHUTDOWN_MARK                 0x000F
#define MASK_PMU_APB_PD_WTLCP_SHUTDOWN_MARK                 0x000F
#define MASK_PMU_APB_PD_WTLCP_LDSP_SHUTDOWN_MARK            0x000F
#define MASK_PMU_APB_PD_WTLCP_TGDSP_SHUTDOWN_MARK           0x000F
#define MASK_PMU_APB_PD_WTLCP_TD_PROC_SHUTDOWN_MARK         0x000F
#define MASK_PMU_APB_PD_WTLCP_LTE_PROC_SHUTDOWN_MARK        0x000F
#define MASK_PMU_APB_PD_WTLCP_LTE_CE_SHUTDOWN_MARK          0x000F
#define MASK_PMU_APB_PD_WTLCP_LTE_DPFEC_SHUTDOWN_MARK       0x000F
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_SHUTDOWN_MARK         0x000F
#define MASK_PMU_APB_PD_WTLCP_HU3GE_B_SHUTDOWN_MARK         0x000F
#define MASK_PMU_APB_PD_WCN_SHUTDOWN_MARK                   0x000F
#define MASK_PMU_APB_PD_AUDCP_SHUTDOWN_MARK                 0x000F
#define MASK_PMU_APB_PD_AUDCP_AUDDSP_SHUTDOWN_MARK          0x000F
#define MASK_PMU_APB_PD_PUB_SHUTDOWN_MARK                   0x000F
#define MASK_PMU_APB_ALL_PLL_PD_RCO_BYP                     0x0001
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_POL_SEL             0x80000000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_DCDC_CPU1_PD_MASK   0x4000000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_DCDC_CPU0_PD_MASK   0x2000000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_PLL_PD_MASK         0x1000000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_PUB_DEEP_SLEEP_MASK 0x100000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_SP_DEEP_SLEEP_MASK  0x0100
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_WCN_DEEP_SLEEP_MASK 0x0080
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_AUDCP_DEEP_SLEEP_MASK 0x0008
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_WTLCP_DEEP_SLEEP_MASK 0x0004
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_PUBCP_DEEP_SLEEP_MASK 0x0002
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_AP_DEEP_SLEEP_MASK  0x0001
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_POL_SEL                0x80000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_DCDC_CPU1_PD_MASK      0x4000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_DCDC_CPU0_PD_MASK      0x2000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_PLL_PD_MASK            0x1000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_PUB_DEEP_SLEEP_MASK    0x100000
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_SP_DEEP_SLEEP_MASK     0x0100
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_WCN_DEEP_SLEEP_MASK    0x0080
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_AUDCP_DEEP_SLEEP_MASK  0x0008
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_WTLCP_DEEP_SLEEP_MASK  0x0004
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_PUBCP_DEEP_SLEEP_MASK  0x0002
#define MASK_PMU_APB_PAD_OUT_XTL_EN0_AP_DEEP_SLEEP_MASK     0x0001
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_POL_SEL                0x80000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_DCDC_CPU1_PD_MASK      0x4000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_DCDC_CPU0_PD_MASK      0x2000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_PLL_PD_MASK            0x1000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_PUB_DEEP_SLEEP_MASK    0x100000
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_SP_DEEP_SLEEP_MASK     0x0100
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_WCN_DEEP_SLEEP_MASK    0x0080
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_AUDCP_DEEP_SLEEP_MASK  0x0008
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_WTLCP_DEEP_SLEEP_MASK  0x0004
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_PUBCP_DEEP_SLEEP_MASK  0x0002
#define MASK_PMU_APB_PAD_OUT_XTL_EN1_AP_DEEP_SLEEP_MASK     0x0001
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_POL_SEL                0x80000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_DCDC_CPU1_PD_MASK      0x4000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_DCDC_CPU0_PD_MASK      0x2000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_PLL_PD_MASK            0x1000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_PUB_DEEP_SLEEP_MASK    0x100000
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_SP_DEEP_SLEEP_MASK     0x0100
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_WCN_DEEP_SLEEP_MASK    0x0080
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_AUDCP_DEEP_SLEEP_MASK  0x0008
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_WTLCP_DEEP_SLEEP_MASK  0x0004
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_PUBCP_DEEP_SLEEP_MASK  0x0002
#define MASK_PMU_APB_PAD_OUT_XTL_EN2_AP_DEEP_SLEEP_MASK     0x0001
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_POL_SEL                0x80000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_DCDC_CPU1_PD_MASK      0x4000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_DCDC_CPU0_PD_MASK      0x2000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_PLL_PD_MASK            0x1000000
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_PUB_DEEP_SLEEP_MASK    0x100000
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_SP_DEEP_SLEEP_MASK     0x0100
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_WCN_DEEP_SLEEP_MASK    0x0080
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_AUDCP_DEEP_SLEEP_MASK  0x0008
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_WTLCP_DEEP_SLEEP_MASK  0x0004
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_PUBCP_DEEP_SLEEP_MASK  0x0002
#define MASK_PMU_APB_PAD_OUT_XTL_EN3_AP_DEEP_SLEEP_MASK     0x0001
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_POL_SEL           0x80000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_DCDC_CPU1_PD_MASK 0x4000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_DCDC_CPU0_PD_MASK 0x2000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_PLL_PD_MASK       0x1000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_PUB_DEEP_SLEEP_MASK 0x100000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_SP_DEEP_SLEEP_MASK 0x0100
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_WCN_DEEP_SLEEP_MASK 0x0080
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_AUDCP_DEEP_SLEEP_MASK 0x0008
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_WTLCP_DEEP_SLEEP_MASK 0x0004
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_PUBCP_DEEP_SLEEP_MASK 0x0002
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM0_EN_AP_DEEP_SLEEP_MASK 0x0001
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_POL_SEL           0x80000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_DCDC_CPU1_PD_MASK 0x4000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_DCDC_CPU0_PD_MASK 0x2000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_PLL_PD_MASK       0x1000000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_PUB_DEEP_SLEEP_MASK 0x100000
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_SP_DEEP_SLEEP_MASK 0x0100
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_WCN_DEEP_SLEEP_MASK 0x0080
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_AUDCP_DEEP_SLEEP_MASK 0x0008
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_WTLCP_DEEP_SLEEP_MASK 0x0004
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_PUBCP_DEEP_SLEEP_MASK 0x0002
#define MASK_PMU_APB_PAD_OUT_DCDC_ARM1_EN_AP_DEEP_SLEEP_MASK 0x0001
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_POL_SEL     0x80000000
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_TOP_DVFS_DEEP_SLEEP_MASK 0x40000000
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_DCDC_CPU1_PD_MASK 0x4000000
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_DCDC_CPU0_PD_MASK 0x2000000
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_PLL_PD_MASK 0x1000000
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_PUB_DEEP_SLEEP_MASK 0x100000
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_SP_DEEP_SLEEP_MASK 0x0100
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_WCN_DEEP_SLEEP_MASK 0x0080
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_AUDCP_DEEP_SLEEP_MASK 0x0008
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_WTLCP_DEEP_SLEEP_MASK 0x0004
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_PUBCP_DEEP_SLEEP_MASK 0x0002
#define MASK_PMU_APB_PAD_OUT_DCXO_LC_DEEP_SLEEP_AP_DEEP_SLEEP_MASK 0x0001
#define MASK_PMU_APB_AP_DEEP_SLEEP_EDG_CNT                  0x00FF
#define MASK_PMU_APB_PUBCP_DEEP_SLEEP_EDG_CNT               0x00FF
#define MASK_PMU_APB_WTLCP_DEEP_SLEEP_EDG_CNT               0x00FF
#define MASK_PMU_APB_AUDCP_DEEP_SLEEP_EDG_CNT               0x00FF
#define MASK_PMU_APB_WCN_DEEP_SLEEP_EDG_CNT                 0x00FF
#define MASK_PMU_APB_SP_DEEP_SLEEP_EDG_CNT                  0x00FF
#define MASK_PMU_APB_APCPU_TOP_DEEP_STOP_FINAL_EDG_CNT      0x00FF
#define MASK_PMU_APB_PUB_DEEP_SLEEP_EDG_CNT                 0x00FF
#define MASK_PMU_APB_PUB_DEEP_SLEEP_EDG_CNT_CLR             0x2000000
#define MASK_PMU_APB_APCPU_TOP_DEEP_STOP_FINAL_EDG_CNT_CLR  0x80000
#define MASK_PMU_APB_SP_DEEP_SLEEP_EDG_CNT_CLR              0x0100
#define MASK_PMU_APB_WCN_DEEP_SLEEP_EDG_CNT_CLR             0x0080
#define MASK_PMU_APB_AUDCP_DEEP_SLEEP_EDG_CNT_CLR           0x0008
#define MASK_PMU_APB_WTLCP_DEEP_SLEEP_EDG_CNT_CLR           0x0004
#define MASK_PMU_APB_PUBCP_DEEP_SLEEP_EDG_CNT_CLR           0x0002
#define MASK_PMU_APB_AP_DEEP_SLEEP_EDG_CNT_CLR              0x0001
#define MASK_PMU_APB_AP_LIGHT_SLEEP_EDG_CNT                 0x00FF
#define MASK_PMU_APB_PUBCP_LIGHT_SLEEP_EDG_CNT              0x00FF
#define MASK_PMU_APB_WTLCP_LIGHT_SLEEP_EDG_CNT              0x00FF
#define MASK_PMU_APB_AUDCP_LIGHT_SLEEP_EDG_CNT              0x00FF
#define MASK_PMU_APB_WCN_LIGHT_SLEEP_EDG_CNT                0x00FF
#define MASK_PMU_APB_AON_LIGHT_SLEEP_EDG_CNT                0x00FF
#define MASK_PMU_APB_APCPU_TOP_LIGHT_STOP_FINAL_EDG_CNT     0x00FF
#define MASK_PMU_APB_PUB_LIGHT_SLEEP_EDG_CNT                0x00FF
#define MASK_PMU_APB_PUB_LIGHT_SLEEP_EDG_CNT_CLR            0x2000000
#define MASK_PMU_APB_APCPU_TOP_LIGHT_STOP_FINAL_EDG_CNT_CLR 0x80000
#define MASK_PMU_APB_AON_LIGHT_SLEEP_EDG_CNT_CLR            0x0100
#define MASK_PMU_APB_WCN_LIGHT_SLEEP_EDG_CNT_CLR            0x0080
#define MASK_PMU_APB_AUDCP_LIGHT_SLEEP_EDG_CNT_CLR          0x0008
#define MASK_PMU_APB_WTLCP_LIGHT_SLEEP_EDG_CNT_CLR          0x0004
#define MASK_PMU_APB_PUBCP_LIGHT_SLEEP_EDG_CNT_CLR          0x0002
#define MASK_PMU_APB_AP_LIGHT_SLEEP_EDG_CNT_CLR             0x0001
#define MASK_PMU_APB_AP_SYS_STOP_EDG_CNT                    0x00FF
#define MASK_PMU_APB_PUBCP_SYS_STOP_EDG_CNT                 0x00FF
#define MASK_PMU_APB_WTLCP_SYS_STOP_EDG_CNT                 0x00FF
#define MASK_PMU_APB_AUDCP_SYS_STOP_EDG_CNT                 0x00FF
#define MASK_PMU_APB_WCN_SYS_STOP_EDG_CNT                   0x00FF
#define MASK_PMU_APB_APCPU_TOP_SYS_STOP_EDG_CNT             0x00FF
#define MASK_PMU_APB_APCPU_TOP_SYS_STOP_EDG_CNT_CLR         0x80000
#define MASK_PMU_APB_WCN_SYS_STOP_EDG_CNT_CLR               0x0080
#define MASK_PMU_APB_AUDCP_SYS_STOP_EDG_CNT_CLR             0x0008
#define MASK_PMU_APB_WTLCP_SYS_STOP_EDG_CNT_CLR             0x0004
#define MASK_PMU_APB_PUBCP_SYS_STOP_EDG_CNT_CLR             0x0002
#define MASK_PMU_APB_AP_SYS_STOP_EDG_CNT_CLR                0x0001
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_EDG_CNT             0x00FF
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_DUR_CNT             0x00FF
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_DUR_CNT_CLR         0x0002
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_EDG_CNT_CLR         0x0001
#define MASK_PMU_APB_PWR_ST_CLK_DIV_CFG                     0xFFFF
#define MASK_PMU_APB_SLP_CTRL_CLK_DIV_CFG                   0xFFFF
#define MASK_PMU_APB_MPLL_WAIT_CLK_DIV_CFG                  0xFFFF
#define MASK_PMU_APB_INT_REQ_PUB_PWR_DOWN_CLR               0x10000000
#define MASK_PMU_APB_INT_REQ_GPU_TOP_PWR_DOWN_CLR           0x800000
#define MASK_PMU_APB_INT_REQ_MM_PWR_DOWN_CLR                0x200000
#define MASK_PMU_APB_INT_REQ_APCPU_TOP_PWR_DOWN_CLR         0x80000
#define MASK_PMU_APB_INT_REQ_WCN_PWR_DOWN_CLR               0x0080
#define MASK_PMU_APB_INT_REQ_AUDCP_PWR_DOWN_CLR             0x0008
#define MASK_PMU_APB_INT_REQ_WTLCP_PWR_DOWN_CLR             0x0004
#define MASK_PMU_APB_INT_REQ_PUBCP_PWR_DOWN_CLR             0x0002
#define MASK_PMU_APB_INT_REQ_AP_PWR_DOWN_CLR                0x0001
#define MASK_PMU_APB_INT_REQ_PUB_PWR_UP_CLR                 0x10000000
#define MASK_PMU_APB_INT_REQ_GPU_TOP_PWR_UP_CLR             0x800000
#define MASK_PMU_APB_INT_REQ_MM_PWR_UP_CLR                  0x200000
#define MASK_PMU_APB_INT_REQ_APCPU_TOP_PWR_UP_CLR           0x80000
#define MASK_PMU_APB_INT_REQ_WCN_PWR_UP_CLR                 0x0080
#define MASK_PMU_APB_INT_REQ_AUDCP_PWR_UP_CLR               0x0008
#define MASK_PMU_APB_INT_REQ_WTLCP_PWR_UP_CLR               0x0004
#define MASK_PMU_APB_INT_REQ_PUBCP_PWR_UP_CLR               0x0002
#define MASK_PMU_APB_INT_REQ_AP_PWR_UP_CLR                  0x0001
#define MASK_PMU_APB_PMU_AUTO_SEL_RCO_EN                    0x0004
#define MASK_PMU_APB_CGM_PMU_SEL_REG                        0x0003
#define MASK_PMU_APB_EFUSE_SEL_BUF                          0x0001
#define MASK_PMU_APB_EIC_LIGHT_SLP_SYS_SEL                  0x000C
#define MASK_PMU_APB_EIC_LIGHT_SLEEP_SEL                    0x0002
#define MASK_PMU_APB_EIC_DEEP_SLEEP_SEL                     0x0001
#define MASK_PMU_APB_DUMMY_REG_0                            0xFFFFFFFF
#define MASK_PMU_APB_DUMMY_REG_1                            0xFFFFFFFF
#define MASK_PMU_APB_AON_DBG_SIG_SEL                        0xFFFF
#define MASK_PMU_APB_AON_DBG_SUBSYS_BUS                     0xFFFFFFFF
#define MASK_PMU_APB_AXI_LP_CTRL_DISABLE                    0x0001
#define MASK_PMU_APB_CSI_WRAP_ISO_EN_SEL                    0x0008
#define MASK_PMU_APB_CSI_WRAP_SOFT_RST                      0x0004
#define MASK_PMU_APB_CSI_WRAP_ISO_FRC_ON                    0x0002
#define MASK_PMU_APB_CSI_WRAP_ISO_FRC_OFF                   0x0001
#define MASK_PMU_APB_DCDC_ARM0_PD_EN                        0x0001
#define MASK_PMU_APB_EIC_SYS_SEL                            0x0007
#define MASK_PMU_APB_GPLL_GPIO_FORCE_GATING_DISABLE         0x0008
#define MASK_PMU_APB_MPLL0_GPIO_FORCE_GATING_DISABLE        0x0004
#define MASK_PMU_APB_MPLL1_GPIO_FORCE_GATING_DISABLE        0x0002
#define MASK_PMU_APB_MPLL2_GPIO_FORCE_GATING_DISABLE        0x0001
#define MASK_PMU_APB_WCDMA_AON_SOFT_RST                     0x0004
#define MASK_PMU_APB_AP_VSP_SOFT_RST                        0x0002
#define MASK_PMU_APB_WTLCP_DSP_SYS_SRST                     0x0001
#define MASK_PMU_APB_PD_DCDC_CPU1_ISO_ON_DLY                0x00FF
#define MASK_PMU_APB_PUBCP_FRC_STOP_REQ_FOR_WTL             0x0004
#define MASK_PMU_APB_REG_PUBCP_WTLCP_ASYNC_BRIDGE_W_FORCE_REQ 0x0002
#define MASK_PMU_APB_REG_PUBCP_WTLCP_PWR_HS_ACK             0x0001
#define MASK_PMU_APB_ALL_OFF_DVFS                           0x0001
#define MASK_PMU_APB_PD_WCN_DBG_SHUTDOWN_EN                 0x0001
#define MASK_PMU_APB_WCN_ACCESS_DDR_EN                      0x0008
#define MASK_PMU_APB_WCN_REF_26M_SEL                        0x0006
#define MASK_PMU_APB_WCN_BB_CK26M_SEL                       0x0001
#define MASK_TOP_DVFS_APB_GPU_SW_DVFS_EN                    0x2
#define MASK_WTL_AON_APB_CLK_ALL_EN_TD_RFT                  0x20000000
#define MASK_WTL_AON_APB_CLK_ALL_EN_STC                     0x10000000
#define MASK_WTL_AON_APB_CK26M_STC_EB                       0x4000000
#define MASK_WTL_AON_APB_CKRTC_GSTC_EB                      0x2000000
#define MASK_WTL_AON_APB_CKRTC_LTMR_EB                      0x1000000
#define MASK_WTL_AON_APB_CKRTC_LSYST_EB                     0x800000
#define MASK_WTL_AON_APB_CKRTC_TGTMR_EB                     0x400000
#define MASK_WTL_AON_APB_CKRTC_TGSYST_EB                    0x200000
#define MASK_WTL_AON_APB_CKRTC_LRFT_EB                      0x100000
#define MASK_WTL_AON_APB_CKRTC_TDRFT_EB                     0x80000
#define MASK_WTL_AON_APB_CLK_RFSPI_TG_EB                    0x20000
#define MASK_WTL_AON_APB_LTE_RFT_AHB_EB                     0x10000
#define MASK_WTL_AON_APB_CLK_LTE_RFT_EB                     0x8000
#define MASK_WTL_AON_APB_TGDSP_TMR1_EB                      0x4000
#define MASK_WTL_AON_APB_TGDSP_TMR0_EB                      0x2000
#define MASK_WTL_AON_APB_TGDSP_SYST_EB                      0x1000
#define MASK_WTL_AON_APB_CKRTC_TGWDG_EB                     0x0800
#define MASK_WTL_AON_APB_TGDSP_WDG_EB                       0x0400
#define MASK_WTL_AON_APB_TD_RFT_AHB_EB                      0x0100
#define MASK_WTL_AON_APB_GSM_STC_AHB_EB                     0x0080
#define MASK_WTL_AON_APB_LDSP_TMR1_EB                       0x0040
#define MASK_WTL_AON_APB_LDSP_TMR0_EB                       0x0020
#define MASK_WTL_AON_APB_LDSP_SYST_EB                       0x0010
#define MASK_WTL_AON_APB_CKRTC_LWDG_EB                      0x0004
#define MASK_WTL_AON_APB_LDSP_WDG_EB                        0x0002
#define MASK_WTL_AON_APB_ARM_BOOT_ADDR_STC                  0xFFFF0000
#define MASK_WTL_AON_APB_PMU_TDCAL_SOFT_RST                 0x0020
#define MASK_WTL_AON_APB_TD_RFT_SOFT_RST                    0x0010
#define MASK_WTL_AON_APB_LDSP_TMR1_SOFT_RST                 0x0008
#define MASK_WTL_AON_APB_LDSP_TMR0_SOFT_RST                 0x0004
#define MASK_WTL_AON_APB_LDSP_WDG_SOFT_RST                  0x0002
#define MASK_WTL_AON_APB_CKRTC_WCDMA_AON_EB                 0x0008
#define MASK_WTL_AON_APB_ZBUS_2T_ACCESS                     0x0002
#define MASK_WTL_AON_APB_ZBUS_32ACCESS                      0x0001
#define MASK_WTL_AON_APB_DSP_XTL_WAIT                       0xFFFF0000
#define MASK_WTL_AON_APB_ACCZ_ARCH_EB                       0x0001
#define MASK_WTL_AON_APB_CLK_ECC_EN                         0x4000
#define MASK_WTL_AON_APB_RFT_ARM_INT                        0x2000
#define MASK_WTL_AON_APB_RFT_TMR_AUTOPD_XTL_EN              0x1000
#define MASK_WTL_AON_APB_RFT_TMR_AUTOPD_RF_EN               0x0800
#define MASK_WTL_AON_APB_STC_TMR_AUTOPD_RF_EN               0x0400
#define MASK_WTL_AON_APB_CLK_VE_BUSY                        0x0010
#define MASK_WTL_AON_APB_PFMP_BUSY_IND                      0x0008
#define MASK_WTL_AON_APB_LSE_ACTIVE                         0x0004
#define MASK_WTL_AON_APB_CDC_ACTIVE                         0x0002
#define MASK_WTL_AON_APB_GCORR_BUSY_IND                     0x0001
#define MASK_WTL_AON_APB_INT_MASK                           0xFFFFFFFF
#define MASK_WTL_AON_APB_PMU_TD_FIR_SOFT_RST                0x20000
#define MASK_WTL_AON_APB_LDSP_SYST_SOFT_RST                 0x0200
#define MASK_WTL_AON_APB_TGDSP_TMR0_SOFT_RST                0x0080
#define MASK_WTL_AON_APB_TGDSP_TMR1_SOFT_RST                0x0040
#define MASK_WTL_AON_APB_TGDSP_SYST_SOFT_RST                0x0020
#define MASK_WTL_AON_APB_TGDSP_WDG_SOFT_RST                 0x0010
#define MASK_WTL_AON_APB_LTE_RFT_SOFT_RST                   0x0002
#define MASK_WTL_AON_APB_RFSPI_TG_SOFT_RST                  0x0001
#define MASK_WTL_AON_APB_WAKEUP_XTL_EN_3G_C                 0x0010
#define MASK_WTL_AON_APB_WAKEUP_XTL_EN_2G                   0x0008
#define MASK_WTL_AON_APB_WAKEUP_XTL_EN_3G_W                 0x0004
#define MASK_WTL_AON_APB_WAKEUP_XTL_EN_3G_TD                0x0002
#define MASK_WTL_AON_APB_WAKEUP_XTL_EN_4G_LTE               0x0001
#define MASK_WTL_AON_APB_DSP_CP_MATRIX_LP_CTRL_DISABLE      0x0008
#define MASK_WTL_AON_APB_ACC2DDR_MUX4TO1_MTX_LP_CTRL_DISABLE 0x0004
#define MASK_WTL_AON_APB_RSV_REG_A_ONES                     0xFFFF0000
#define MASK_WTL_AON_APB_RSV_REG_A_ZEROS                    0xFFFF
#define MASK_WTL_AON_APB_RSV_REG_B_ONES                     0xFFFF0000
#define MASK_WTL_AON_APB_RSV_REG_B_ZEROS                    0xFFFF
#define MASK_WTL_AON_APB_LTE_CEVA_OCM_RST_MASK              0x0002
#define MASK_WTL_AON_APB_TG_CEVA_OCM_RST_MASK               0x0001
#define MASK_WTL_AON_APB_RAM_PD_STC_EVT_0                   0x0800
#define MASK_WTL_AON_APB_RAM_RET_STC_EVT_0                  0x0400
#define MASK_WTL_AON_APB_RAM_PD_STC_EVT_1                   0x0200
#define MASK_WTL_AON_APB_RAM_RET_STC_EVT_1                  0x0100
#define MASK_WTL_AON_APB_RAM_PD_STC_ACT                     0x0080
#define MASK_WTL_AON_APB_RAM_RET_STC_ACT                    0x0040
#define MASK_WTL_AON_APB_RAM_PD_RFT                         0x0020
#define MASK_WTL_AON_APB_RAM_RET_RFT                        0x0010
#define MASK_WTL_AON_APB_RAM_SLP_RFT                        0x0008
#define MASK_WTL_AON_APB_MEM_AUTO_SLP_EN                    0x3FFFFF
#define MASK_WTL_AON_APB_WTL_AON_APB_REG_FREERUN            0x0004
#define MASK_WTL_AON_APB_WTL_AON_WCDMA_APB_REG_FREERUN      0x0002
#define MASK_WTL_AON_APB_WTLAON_AHB2APB_PCLK_PERI_EB_BYPASS 0x0001
#define MASK_MM_AHB_FD_EB                                   0x400
#define MASK_MM_AHB_ISP_AHB_EB                              0x100
#define MASK_MM_AHB_ISP_EB                                  0x8
#define MASK_MM_AHB_DCAM_EB                                 0x4
#define MASK_MM_AHB_CPP_EB                                  0x1
#define MASK_MM_AHB_FD_SOFT_RST_MASK                        0x8000000
#define MASK_MM_AHB_FD_SOFT_RST                             0x4000000
#define MASK_MM_AHB_LP_EB_FD                                0x10000
#define MASK_MM_AHB_DVFS_EB                                 0x200
#define MASK_MM_AHB_DCAM_ALL_SOFT_RST                       0x800000
#define MASK_MM_AHB_FD_VAU_SOFT_RST                         0x400000
#define MASK_MM_AHB_CPP_VAU_SOFT_RST                        0x200000
#define MASK_MM_AHB_JPG_VAU_SOFT_RST                        0x100000
#define MASK_MM_AHB_JPG_SOFT_RST_MASK                       0x80000
#define MASK_MM_AHB_CPP_SOFT_RST_MASK                       0x40000
#define MASK_MM_AHB_CPP_SOFT_RST                            0x10000
#define MASK_MM_AHB_CPP_PATH0_SOFT_RST                      0x8000
#define MASK_MM_AHB_CPP_PATH1_SOFT_RST                      0x4000
#define MASK_MM_AHB_CPP_DMA_SOFT_RST                        0x2000
#define MASK_MM_AHB_ISP_AHB_SOFT_RST                        0x1000
#define MASK_MM_AHB_ISP_VAU_SOFT_RST                        0x800
#define MASK_MM_AHB_ISP_SOFT_RST                            0x400
#define MASK_MM_AHB_DCAM_VAU_SOFT_RST                       0x40
#define MASK_MM_AHB_DCAM0_SOFT_RST                          0x20
#define MASK_MM_AHB_DCAM1_SOFT_RST                          0x10
#define MASK_MM_AHB_DCAM2_SOFT_RST                          0x8
#define MASK_MM_AHB_DCAM_AXI_SOFT_RST                       0x4
#define MASK_MM_AHB_ISP_AXI_CKG_EN                          0x80
#define MASK_MM_AHB_DCAM_AXI_CKG_EN                         0x40
#define MASK_MM_AHB_ISP_INT_1_MASK                          0x8000000
#define MASK_MM_AHB_ISP_INT_0_MASK                          0x4000000
#define MASK_MM_AHB_DCAM_INT_2_MASK                         0x2000000
#define MASK_MM_AHB_DCAM_INT_1_MASK                         0x1000000
#define MASK_MM_AHB_DCAM_INT_0_MASK                         0x800000
#define MASK_MM_AHB_ISP_BUSY_LSLP_EN                        0x1
#define MASK_MM_AHB_DCAM_BUSY                               0x8
#define MASK_MM_AHB_ISP_BUSY                                0x4
#define MASK_MM_AHB_CPP_BUSY                                0x1

#endif /* __DT_BINDINGS_SPRD_QOGIRL6_MASK_H */
