// SPDX-License-Identifier: GPL-2.0-only
/*
 * sprd,pike2-regs.h - Unisoc platform header
 *
 * Copyright 2022 Unisoc(Shanghai) Technologies Co.Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#define REG_GPU_APB_APB_RST                                                           0x0000
#define REG_GPU_APB_APB_CLK_CTRL                                                      0x0004
#define REG_GPU_APB_APB_T820_INT_STS                                                  0x0008
#define REG_GPU_APB_APB_GPU_PRB_SEL                                                   0x000c
#define REG_GPU_APB_GPU_EMC_BRG_S0_LPC_CTRL                                           0x0010
#define REG_GPU_APB_GPU_EMC_BRG_M0_LPC_CTRL                                           0x0014
#define REG_GPU_APB_GPU_EMC_BRG_GPV_LPC_CTRL                                          0x0018
#define REG_GPU_APB_GPU_APB_BRG_LPC_CTRL                                              0x001c
#define REG_GPU_APB_APB_BARRIER_CTRL                                                  0x0020
#define REG_GPU_APB_GPU_ENGINEER_DEBUG_RSVD                                           0x0024
#define REG_MM_AHB_AHB_EB                                                             0x0000
#define REG_MM_AHB_AHB_RST                                                            0x0004
#define REG_MM_AHB_GEN_CKG_CFG                                                        0x0008
#define REG_MM_AHB_MIPI_CSI2_CTRL                                                     0x000c
#define REG_MM_AHB_ISP_QOS_CTRL                                                       0x0010
#define REG_MM_AHB_CAM_MTX_LPC_CTRL                                                   0x0014
#define REG_MM_AHB_VSP_MTX_LPC_CTRL_M0                                                0x0018
#define REG_MM_AHB_VSP_MTX_LPC_CTRL_M1                                                0x001c
#define REG_MM_AHB_VSP_MTX_LPC_CTRL_S0                                                0x0020
#define REG_MM_AHB_MM_MTX_LPC_STAT                                                    0x0024
#define REG_MM_AHB_MM_LIGHT_SLEEP_CTRL                                                0x0028
#define REG_MM_AHB_CAM_MTX_LPC_CTRL_M0                                                0x002c
#define REG_MM_AHB_CAM_MTX_LPC_CTRL_M1                                                0x0030
#define REG_MM_AHB_VSP_MTX_LPC_CTRL_GPV                                               0x0034
#define REG_MM_AHB_MM_DUMMY_REG_0                                                     0x0038
#define REG_MM_AHB_MM_DUMMY_REG_1                                                     0x003c
#define REG_SP_AHB_CM4_EB                                                             0x0000
#define REG_SP_AHB_CM4_SOFT_RST                                                       0x0004
#define REG_SP_AHB_SLP_CTL                                                            0x0008
#define REG_SP_AHB_CM4_CORE_CFG                                                       0x000c
#define REG_SP_AHB_CM4_CORE_AUXFAULT_CFG                                              0x0010
#define REG_SP_AHB_CM4_MAIN_STATOUT                                                   0x0014
#define REG_SP_AHB_CM4_HWDATAD_STAT                                                   0x0018
#define REG_SP_AHB_CM4_INT_STAT                                                       0x001c
#define REG_SP_AHB_CM4_CLK_EMC_CTRL                                                   0x0020
#define REG_SP_AHB_CM4_MTX_LP_CTRL                                                    0x0024
#define REG_SP_AHB_DUMMY                                                              0x0040
#define REG_PMU_APB_PD_CA7_TOP_CFG                                                    0x0000
#define REG_PMU_APB_PD_CA7_C0_CFG                                                     0x0004
#define REG_PMU_APB_PD_CA7_C1_CFG                                                     0x0008
#define REG_PMU_APB_PD_CA7_C2_CFG                                                     0x000c
#define REG_PMU_APB_PD_CA7_C3_CFG                                                     0x0010
#define REG_PMU_APB_PD_AP_SYS_CFG                                                     0x0018
#define REG_PMU_APB_PD_MM_TOP_CFG                                                     0x001c
#define REG_PMU_APB_PD_GPU_TOP_CFG                                                    0x0020
#define REG_PMU_APB_PD_WTLCP_TGDSP_CFG                                                0x0038
#define REG_PMU_APB_PD_WTLCP_HU3GE_A_CFG                                              0x003c
#define REG_PMU_APB_PD_CP_SYS_CFG                                                     0x0048
#define REG_PMU_APB_CP_FRC_STOP_REQ_FOR_WTL                                           0x004c
#define REG_PMU_APB_PD_WCN_TOP_CFG                                                    0x0050
#define REG_PMU_APB_PD_WCN_WIFI_CFG                                                   0x0054
#define REG_PMU_APB_PD_WCN_GNSS_CFG                                                   0x0058
#define REG_PMU_APB_PD_PUB_SYS_CFG                                                    0x005c
#define REG_PMU_APB_XTL_WAIT_CNT                                                      0x0070
#define REG_PMU_APB_XTLBUF_WAIT_CNT                                                   0x0074
#define REG_PMU_APB_PLL_WAIT_CNT0                                                     0x0078
#define REG_PMU_APB_PLL_WAIT_CNT1                                                     0x007c
#define REG_PMU_APB_XTL0_REL_CFG                                                      0x0080
#define REG_PMU_APB_CPLL_REL_CFG                                                      0x0088
#define REG_PMU_APB_XTLBUF0_REL_CFG                                                   0x008c
#define REG_PMU_APB_GPLL_REL_CFG                                                      0x0090
#define REG_PMU_APB_MPLL_REL_CFG                                                      0x0094
#define REG_PMU_APB_DPLL_REL_CFG                                                      0x0098
#define REG_PMU_APB_TWPLL_REL_CFG                                                     0x00a0
#define REG_PMU_APB_PLL_FRC_OFF                                                       0x00a4
#define REG_PMU_APB_PLL_FRC_ON                                                        0x00a8
#define REG_PMU_APB_PUB_LSLP_CFG                                                      0x00ac
#define REG_PMU_APB_SOFT_RST                                                          0x00b0
#define REG_PMU_APB_CP_SLP_STATUS_DBG0                                                0x00b4
#define REG_PMU_APB_PWR_STATUS0_DBG                                                   0x00bc
#define REG_PMU_APB_PWR_STATUS1_DBG                                                   0x00c0
#define REG_PMU_APB_PWR_STATUS2_DBG                                                   0x00c4
#define REG_PMU_APB_SLEEP_CTRL                                                        0x00cc
#define REG_PMU_APB_DDR_SLEEP_CTRL                                                    0x00d0
#define REG_PMU_APB_SLEEP_STATUS                                                      0x00d4
#define REG_PMU_APB_CA7_TOP_CFG                                                       0x00e4
#define REG_PMU_APB_CA7_C0_CFG                                                        0x00e8
#define REG_PMU_APB_CA7_C1_CFG                                                        0x00ec
#define REG_PMU_APB_CA7_C2_CFG                                                        0x00f0
#define REG_PMU_APB_CA7_C3_CFG                                                        0x00f4
#define REG_PMU_APB_DDR_CHN_SLEEP_CTRL0                                               0x00f8
#define REG_PMU_APB_DDR_OP_MODE_CFG                                                   0x012c
#define REG_PMU_APB_DDR_PHY_RET_CFG                                                   0x0130
#define REG_PMU_APB_BISR_DONE_STATUS                                                  0x0138
#define REG_PMU_APB_BISR_BUSY_STATUS                                                  0x013c
#define REG_PMU_APB_BISR_BYP_CFG                                                      0x0140
#define REG_PMU_APB_BISR_EN_CFG                                                       0x0144
#define REG_PMU_APB_CGM_AUTO_GATE_SEL_CFG0                                            0x0148
#define REG_PMU_APB_CGM_AUTO_GATE_SEL_CFG1                                            0x014c
#define REG_PMU_APB_CGM_AUTO_GATE_SEL_CFG2                                            0x0150
#define REG_PMU_APB_CGM_AUTO_GATE_SEL_CFG3                                            0x0154
#define REG_PMU_APB_CGM_FORCE_EN_CFG0                                                 0x0158
#define REG_PMU_APB_CGM_FORCE_EN_CFG1                                                 0x015c
#define REG_PMU_APB_CGM_FORCE_EN_CFG2                                                 0x0160
#define REG_PMU_APB_CGM_FORCE_EN_CFG3                                                 0x0164
#define REG_PMU_APB_SLEEP_XTLON_CTRL                                                  0x0168
#define REG_PMU_APB_MEM_SLP_CFG                                                       0x016c
#define REG_PMU_APB_MEM_SD_CFG                                                        0x0170
#define REG_PMU_APB_CA7_CORE_PU_LOCK                                                  0x0174
#define REG_PMU_APB_PWR_CNT_WAIT_CFG0                                                 0x017c
#define REG_PMU_APB_PWR_CNT_WAIT_CFG1                                                 0x0180
#define REG_PMU_APB_MEM_AUTO_SLP_CFG                                                  0x0190
#define REG_PMU_APB_MEM_AUTO_SD_CFG                                                   0x0194
#define REG_PMU_APB_WAKEUP_LOCK_EN                                                    0x01a0
#define REG_PMU_APB_WTLCP_TGDSP_CORE_INT_DISABLE                                      0x01b0
#define REG_PMU_APB_CP_CORE_INT_DISABLE                                               0x01b8
#define REG_PMU_APB_CA7_C0_CORE_INT_DISABLE                                           0x01bc
#define REG_PMU_APB_CA7_C1_CORE_INT_DISABLE                                           0x01c0
#define REG_PMU_APB_CA7_C2_CORE_INT_DISABLE                                           0x01c4
#define REG_PMU_APB_CA7_C3_CORE_INT_DISABLE                                           0x01c8
#define REG_PMU_APB_AON_CM4_INT_DISABLE                                               0x01cc
#define REG_PMU_APB_WTLCP_TGDSP_DSLP_ENA                                              0x0200
#define REG_PMU_APB_AP_DSLP_ENA                                                       0x0208
#define REG_PMU_APB_CP_DSLP_ENA                                                       0x020c
#define REG_PMU_APB_CA7_TOP_DSLP_ENA                                                  0x0214
#define REG_PMU_APB_CM4_DSLP_ENA                                                      0x0218
#define REG_PMU_APB_PUBCP_INT_DISABLE                                                 0x0220
#define REG_PMU_APB_WTLCP_INT_DISABLE                                                 0x0224
#define REG_PMU_APB_LIGHT_SLEEP_ENABLE                                                0x0230
#define REG_PMU_APB_CM4_LIGHT_SLEEP                                                   0x0234
#define REG_PMU_APB_SYS_DOZE_DSLP_ENA                                                 0x0240
#define REG_PMU_APB_PUB_ACC_RDY                                                       0x0250
#define REG_PMU_APB_PUB_CLK_RDY                                                       0x0254
#define REG_PMU_APB_EIC_SEL                                                           0x0258
#define REG_PMU_APB_AXI_LP_CTRL_DISABLE                                               0x0260
#define REG_PMU_APB_PMU_DEBUG                                                         0x0270
#define REG_PMU_APB_SLEEP_CNT_CLR                                                     0x0274
#define REG_PMU_APB_PAD_OUT_ADIE_CTRL0                                                0x0290
#define REG_PMU_APB_BISR_FORCE_SEL                                                    0x0300
#define REG_PMU_APB_AON_MEM_CTRL                                                      0x0330
#define REG_PMU_APB_PWR_DOMAIN_INT_CLR                                                0x0334
#define REG_PMU_APB_WCN_SYS_CFG_STATUS                                                0x0338
#define REG_PMU_APB_RF_CFG                                                            0x033c
#define REG_PMU_APB_PUB_PLL_CFG                                                       0x0340
#define REG_PMU_APB_BBPLL_REL_CFG                                                     0x0344
#define REG_PMU_APB_CP_CG_CFG                                                         0x0348
#define REG_PMU_APB_WCN_WIFI_DSLP_ENA                                                 0x034c
#define REG_PMU_APB_WCN_GNSS_DSLP_ENA                                                 0x0350
#define REG_PMU_APB_EFUSE_SELECT_BUF_CFG                                              0x0354
#define REG_PMU_APB_EFUSE_SELECT_BUF_CLR                                              0x0358
#define REG_PMU_APB_EFUSE_SELECT_BUF_STS                                              0x035c
#define REG_PMU_APB_PMU_CLK_CFG                                                       0x0360
#define REG_PMU_APB_PWR_ST_DLY0                                                       0x0364
#define REG_PMU_APB_PWR_ST_DLY1                                                       0x0368
#define REG_PMU_APB_PMU_CLK_DIV_CFG0                                                  0x036c
#define REG_PMU_APB_PMU_CLK_DIV_CFG1                                                  0x0370
#define REG_PMU_APB_PUB_DSLP_CFG0                                                     0x0374
#define REG_PMU_APB_PUB_DSLP_CFG1                                                     0x0378
#define REG_PMU_APB_PUB_DSLP_EN                                                       0x037c
#define REG_PMU_APB_PLL_CNT_DONE                                                      0x0380
#define REG_PMU_APB_CGM_XTL_EN                                                        0x0384
#define REG_PMU_APB_CGM_XTL_EN_SEL                                                    0x0388
#define REG_PMU_APB_CA7_RST_CFG                                                       0x038c
#define REG_PMU_APB_PD_SYS_ACK                                                        0x0390
#define REG_PMU_APB_PD_CA7_C0_SHUTDOWN_MARK_STATUS                                    0x3000
#define REG_PMU_APB_PD_CA7_C1_SHUTDOWN_MARK_STATUS                                    0x3004
#define REG_PMU_APB_PD_CA7_C2_SHUTDOWN_MARK_STATUS                                    0x3008
#define REG_PMU_APB_PD_CA7_C3_SHUTDOWN_MARK_STATUS                                    0x300c
#define REG_PMU_APB_PD_CA7_TOP_SHUTDOWN_MARK_STATUS                                   0x3010
#define REG_PMU_APB_PD_AP_SYS_SHUTDOWN_MARK_STATUS                                    0x3014
#define REG_PMU_APB_PD_GPU_TOP_SHUTDOWN_MARK_STATUS                                   0x3018
#define REG_PMU_APB_PD_MM_TOP_SHUTDOWN_MARK_STATUS                                    0x301c
#define REG_PMU_APB_PD_WTLCP_TGDSP_SHUTDOWN_MARK_STATUS                               0x3034
#define REG_PMU_APB_PD_WTLCP_HU3GE_A_SHUTDOWN_MARK_STATUS                             0x3038
#define REG_PMU_APB_PD_CP_SYS_SHUTDOWN_MARK_STATUS                                    0x3044
#define REG_PMU_APB_PD_PUB_SYS_SHUTDOWN_MARK_STATUS                                   0x3054
#define REG_PMU_APB_PD_WCN_TOP_SHUTDOWN_MARK_STATUS                                   0x3058
#define REG_PMU_APB_PD_WCN_WIFI_SHUTDOWN_MARK_STATUS                                  0x305c
#define REG_PMU_APB_PD_WCN_GNSS_SHUTDOWN_MARK_STATUS                                  0x3060
#define REG_PMU_APB_PMU_DUMMY1                                                        0x3064
#define REG_PMU_APB_PMU_DUMMY2                                                        0x3068
#define REG_PMU_APB_PMU_DUMMY3                                                        0x306c
#define REG_PMU_APB_PMU_DUMMY4                                                        0x3070
#define REG_PMU_APB_PMU_DUMMY5                                                        0x3074
#define REG_PMU_APB_PMU_DUMMY6                                                        0x3078
#define REG_SERDES_APB_FUNC_EN                                                        0x0000
#define REG_SERDES_APB_CH_EN                                                          0x0004
#define REG_SERDES_APB_FUNNEL_EN                                                      0x0008
#define REG_SERDES_APB_FUNNEL_OVERFLOW                                                0x000c
#define REG_SERDES_APB_FSM_CUT_OFF_LEN                                                0x0010
#define REG_ANLG_PHY_G2_ANALOG_USB20_USB20_TEST_PIN                                   0x0000
#define REG_ANLG_PHY_G2_ANALOG_USB20_USB20_UTMI_CTL                                   0x0004
#define REG_ANLG_PHY_G2_ANALOG_USB20_USB20_BATTER_PLL                                 0x0008
#define REG_ANLG_PHY_G2_ANALOG_USB20_USB20_TRIMMING                                   0x000c
#define REG_ANLG_PHY_G2_ANALOG_USB20_USB20_PHY_BIST_TEST                              0x0010
#define REG_ANLG_PHY_G2_ANALOG_USB20_REG_SEL_CFG_0                                    0x0014
#define REG_PUB_APB_BUSMON_CNT_START                                                  0x0000
#define REG_PUB_APB_BUSMON_CFG                                                        0x0004
#define REG_PUB_APB_DDR_EB                                                            0x0008
#define REG_PUB_APB_DDR_SOFT_RST                                                      0x000c
#define REG_PUB_APB_DISP_MM_MTX_MAIN_LPC                                              0x0010
#define REG_PUB_APB_DISP_MM_MTX_GPV_LPC                                               0x0014
#define REG_PUB_APB_PUB_PORTS_REMAP_EN                                                0x3000
#define REG_PUB_APB_DMC_PORTS_MPU_EN                                                  0x3004
#define REG_PUB_APB_DMC_PORT0_ADDR_REMAP_0                                            0x3008
#define REG_PUB_APB_DMC_PORT1_ADDR_REMAP_0                                            0x300c
#define REG_PUB_APB_DMC_PORT2_ADDR_REMAP_0                                            0x3010
#define REG_PUB_APB_DMC_PORT3_ADDR_REMAP_0                                            0x3014
#define REG_PUB_APB_DMC_PORT4_ADDR_REMAP_0                                            0x3018
#define REG_PUB_APB_DMC_PORT5_ADDR_REMAP_0                                            0x301c
#define REG_PUB_APB_DMC_PORT6_ADDR_REMAP_0                                            0x3020
#define REG_PUB_APB_DMC_PORT7_ADDR_REMAP_0                                            0x3024
#define REG_PUB_APB_DMC_PORT8_ADDR_REMAP_0                                            0x3028
#define REG_PUB_APB_DMC_PORT9_ADDR_REMAP_0                                            0x302c
#define REG_PUB_APB_DMC_PORT0_MPU_RANGE                                               0x3030
#define REG_PUB_APB_DMC_PORT1_MPU_RANGE                                               0x3034
#define REG_PUB_APB_DMC_PORT2_MPU_RANGE                                               0x3038
#define REG_PUB_APB_DMC_PORT3_MPU_RANGE                                               0x303c
#define REG_PUB_APB_DMC_PORT4_MPU_RANGE                                               0x3040
#define REG_PUB_APB_DMC_PORT5_MPU_RANGE                                               0x3044
#define REG_PUB_APB_DMC_PORT6_MPU_RANGE                                               0x3048
#define REG_PUB_APB_DMC_PORT7_MPU_RANGE                                               0x3050
#define REG_PUB_APB_DMC_PORT8_MPU_RANGE                                               0x3054
#define REG_PUB_APB_DMC_PORT9_MPU_RANGE                                               0x3058
#define REG_PUB_APB_DMC_PORT0_DUMP_ADDR                                               0x305c
#define REG_PUB_APB_DMC_PORT1_DUMP_ADDR                                               0x3060
#define REG_PUB_APB_DMC_PORT2_DUMP_ADDR                                               0x3064
#define REG_PUB_APB_DMC_PORT3_DUMP_ADDR                                               0x3068
#define REG_PUB_APB_DMC_PORT4_DUMP_ADDR                                               0x306c
#define REG_PUB_APB_DMC_PORT5_DUMP_ADDR                                               0x3070
#define REG_PUB_APB_DMC_PORT6_DUMP_ADDR                                               0x3074
#define REG_PUB_APB_DMC_PORT7_DUMP_ADDR                                               0x3078
#define REG_PUB_APB_DMC_PORT8_DUMP_ADDR                                               0x307c
#define REG_PUB_APB_DMC_PORT9_DUMP_ADDR                                               0x3080
#define REG_PUB_APB_PUB_DUMMY_REG0                                                    0x3090
#define REG_PUB_APB_PUB_DUMMY_REG1                                                    0x3094
#define REG_PUB_APB_DMC_DUMMY_REG0                                                    0x30a0
#define REG_PUB_APB_DMC_DUMMY_REG1                                                    0x30a4
#define REG_PUB_APB_DMC_QOS_SEL                                                       0x3100
#define REG_PUB_APB_DMC_ARQOS_0_7                                                     0x3110
#define REG_PUB_APB_DMC_ARQOS_8                                                       0x3114
#define REG_PUB_APB_DMC_AWQOS_0_7                                                     0x3118
#define REG_PUB_APB_DMC_AWQOS_8                                                       0x311c
#define REG_PUB_APB_DMC_ARQOS_0_ID                                                    0x3120
#define REG_PUB_APB_DMC_ARQOS_1_ID                                                    0x3124
#define REG_PUB_APB_DMC_ARQOS_2_ID                                                    0x3128
#define REG_PUB_APB_DMC_ARQOS_3_ID                                                    0x312c
#define REG_PUB_APB_DMC_ARQOS_4_ID                                                    0x3130
#define REG_PUB_APB_DMC_ARQOS_5_ID                                                    0x3134
#define REG_PUB_APB_DMC_ARQOS_6_ID                                                    0x3138
#define REG_PUB_APB_DMC_ARQOS_7_ID                                                    0x313c
#define REG_PUB_APB_DMC_ARQOS_8_ID                                                    0x3140
#define REG_PUB_APB_DMC_AWQOS_0_ID                                                    0x3150
#define REG_PUB_APB_DMC_AWQOS_1_ID                                                    0x3154
#define REG_PUB_APB_DMC_AWQOS_2_ID                                                    0x3158
#define REG_PUB_APB_DMC_AWQOS_3_ID                                                    0x315c
#define REG_PUB_APB_DMC_AWQOS_4_ID                                                    0x3160
#define REG_PUB_APB_DMC_AWQOS_5_ID                                                    0x3164
#define REG_PUB_APB_DMC_AWQOS_6_ID                                                    0x3168
#define REG_PUB_APB_DMC_AWQOS_7_ID                                                    0x316c
#define REG_PUB_APB_DMC_AWQOS_8_ID                                                    0x3170
#define REG_PUB_APB_DMC_EXT_LPCTRL_CFG                                                0x31a0
#define REG_PUB_APB_DMC_EXT_LPCTRL_SEQL                                               0x31a4
#define REG_PUB_APB_DMC_EXT_LPCTRL_SEQH                                               0x31a8
#define REG_PUB_APB_DMC_EXT_LPCTRL_STEP                                               0x31ac
#define REG_PUB_APB_QOS_SELECT                                                        0x31b0
#define REG_PUB_APB_DMC_PORTS_MPU_SEL                                                 0x31b4
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_SEL                                          0x31b8
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_RID_MASK                                     0x31bc
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_WID_MASK                                     0x31c0
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_RID_VAL                                      0x31c4
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_WID_VAL                                      0x31c8
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_RHIGH_RANGE                                  0x31cc
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_RLOW_RANGE                                   0x31d0
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_WHIGH_RANGE                                  0x31d4
#define REG_PUB_APB_DMC_PORTS_MPU_SHARED_WLOW_RANGE                                   0x31d8
#define REG_PUB_APB_DMC_PORTS_MPU_CH0_RID_MASK_VAL                                    0x31dc
#define REG_PUB_APB_DMC_PORTS_MPU_CH0_WID_MASK_VAL                                    0x31e0
#define REG_PUB_APB_DMC_PORTS_MPU_CH1_RID_MASK_VAL                                    0x31e4
#define REG_PUB_APB_DMC_PORTS_MPU_CH1_WID_MASK_VAL                                    0x31e8
#define REG_PUB_APB_DMC_PORTS_MPU_CH2_RID_MASK_VAL                                    0x31ec
#define REG_PUB_APB_DMC_PORTS_MPU_CH2_WID_MASK_VAL                                    0x31f0
#define REG_PUB_APB_DMC_PORTS_MPU_CH3_RID_MASK_VAL                                    0x31f4
#define REG_PUB_APB_DMC_PORTS_MPU_CH3_WID_MASK_VAL                                    0x31f8
#define REG_PUB_APB_DMC_PORTS_MPU_CH4_RID_MASK_VAL                                    0x31fc
#define REG_PUB_APB_DMC_PORTS_MPU_CH4_WID_MASK_VAL                                    0x3200
#define REG_PUB_APB_DMC_PORTS_MPU_CH5_RID_MASK_VAL                                    0x3204
#define REG_PUB_APB_DMC_PORTS_MPU_CH5_WID_MASK_VAL                                    0x3208
#define REG_PUB_APB_DMC_PORTS_MPU_CH6_RID_MASK_VAL                                    0x320c
#define REG_PUB_APB_DMC_PORTS_MPU_CH6_WID_MASK_VAL                                    0x3210
#define REG_PUB_APB_DMC_PORTS_MPU_CH7_RID_MASK_VAL                                    0x3214
#define REG_PUB_APB_DMC_PORTS_MPU_CH7_WID_MASK_VAL                                    0x3218
#define REG_PUB_APB_DMC_PORT_MPU_CH0_RLOW_RANGE                                       0x321c
#define REG_PUB_APB_DMC_PORT_MPU_CH0_WLOW_RANGE                                       0x3220
#define REG_PUB_APB_DMC_PORT_MPU_CH1_RLOW_RANGE                                       0x3224
#define REG_PUB_APB_DMC_PORT_MPU_CH1_WLOW_RANGE                                       0x3228
#define REG_PUB_APB_DMC_PORT_MPU_CH2_RLOW_RANGE                                       0x322c
#define REG_PUB_APB_DMC_PORT_MPU_CH2_WLOW_RANGE                                       0x3230
#define REG_PUB_APB_DMC_PORT_MPU_CH3_RLOW_RANGE                                       0x3234
#define REG_PUB_APB_DMC_PORT_MPU_CH3_WLOW_RANGE                                       0x3238
#define REG_PUB_APB_DMC_PORT_MPU_CH4_RLOW_RANGE                                       0x323c
#define REG_PUB_APB_DMC_PORT_MPU_CH4_WLOW_RANGE                                       0x3240
#define REG_PUB_APB_DMC_PORT_MPU_CH5_RLOW_RANGE                                       0x3244
#define REG_PUB_APB_DMC_PORT_MPU_CH5_WLOW_RANGE                                       0x3248
#define REG_PUB_APB_DMC_PORT_MPU_CH6_RLOW_RANGE                                       0x324c
#define REG_PUB_APB_DMC_PORT_MPU_CH6_WLOW_RANGE                                       0x3250
#define REG_PUB_APB_DMC_PORT_MPU_CH7_RLOW_RANGE                                       0x3254
#define REG_PUB_APB_DMC_PORT_MPU_CH7_WLOW_RANGE                                       0x3258
#define REG_PUB_APB_DMC_PORT_MPU_CH0_RHIGH_RANGE                                      0x325c
#define REG_PUB_APB_DMC_PORT_MPU_CH0_WHIGH_RANGE                                      0x3260
#define REG_PUB_APB_DMC_PORT_MPU_CH1_RHIGH_RANGE                                      0x3264
#define REG_PUB_APB_DMC_PORT_MPU_CH1_WHIGH_RANGE                                      0x3268
#define REG_PUB_APB_DMC_PORT_MPU_CH2_RHIGH_RANGE                                      0x326c
#define REG_PUB_APB_DMC_PORT_MPU_CH2_WHIGH_RANGE                                      0x3270
#define REG_PUB_APB_DMC_PORT_MPU_CH3_RHIGH_RANGE                                      0x3274
#define REG_PUB_APB_DMC_PORT_MPU_CH3_WHIGH_RANGE                                      0x3278
#define REG_PUB_APB_DMC_PORT_MPU_CH4_RHIGH_RANGE                                      0x327c
#define REG_PUB_APB_DMC_PORT_MPU_CH4_WHIGH_RANGE                                      0x3280
#define REG_PUB_APB_DMC_PORT_MPU_CH5_RHIGH_RANGE                                      0x3284
#define REG_PUB_APB_DMC_PORT_MPU_CH5_WHIGH_RANGE                                      0x3288
#define REG_PUB_APB_DMC_PORT_MPU_CH6_RHIGH_RANGE                                      0x328c
#define REG_PUB_APB_DMC_PORT_MPU_CH6_WHIGH_RANGE                                      0x3290
#define REG_PUB_APB_DMC_PORT_MPU_CH7_RHIGH_RANGE                                      0x3294
#define REG_PUB_APB_DMC_PORT_MPU_CH7_WHIGH_RANGE                                      0x3298
#define REG_PUB_APB_DMC_MPU_VIO_ADDR                                                  0x329c
#define REG_PUB_APB_DMC_MPU_VIO_CMD                                                   0x32a0
#define REG_PUB_APB_DMC_MPU_VIO_USERID                                                0x32a4
#define REG_PUB_APB_DMC_REMAP_EN                                                      0x32a8
#define REG_PUB_APB_DMC_PORT0_REMAP_ADDR_0                                            0x32ac
#define REG_PUB_APB_DMC_PORT0_REMAP_ADDR_1                                            0x32b0
#define REG_PUB_APB_DMC_PORT1_REMAP_ADDR_0                                            0x32b4
#define REG_PUB_APB_DMC_PORT1_REMAP_ADDR_1                                            0x32b8
#define REG_PUB_APB_DMC_PORT2_REMAP_ADDR_0                                            0x32bc
#define REG_PUB_APB_DMC_PORT2_REMAP_ADDR_1                                            0x32c0
#define REG_PUB_APB_DMC_PORT3_REMAP_ADDR_0                                            0x32c4
#define REG_PUB_APB_DMC_PORT3_REMAP_ADDR_1                                            0x32c8
#define REG_PUB_APB_DMC_PORT4_REMAP_ADDR_0                                            0x32cc
#define REG_PUB_APB_DMC_PORT4_REMAP_ADDR_1                                            0x32d0
#define REG_PUB_APB_DMC_PORT5_REMAP_ADDR_0                                            0x32d4
#define REG_PUB_APB_DMC_PORT5_REMAP_ADDR_1                                            0x32d8
#define REG_PUB_APB_DMC_PORT6_REMAP_ADDR_0                                            0x32dc
#define REG_PUB_APB_DMC_PORT6_REMAP_ADDR_1                                            0x32e0
#define REG_PUB_APB_DMC_MPU_DUMP_ADDR                                                 0x32e4
#define REG_PUB_APB_PUB_DMC_MPU_INT                                                   0x32e8
#define REG_PUB_APB_MEM_FW_INT                                                        0x32ec
#define REG_PUB_APB_DMC_URGENT_CTRL                                                   0x3300
#define REG_PUB_APB_DMC_URGENT_THD0                                                   0x3304
#define REG_PUB_APB_DMC_URGENT_THD1                                                   0x3308
#define REG_PUB_APB_DMC_URGENT_THD2                                                   0x330c
#define REG_PUB_APB_DMC_URGENT_THD3                                                   0x3310
#define REG_AP_APB_APB_EB                                                             0x0000
#define REG_AP_APB_APB_RST                                                            0x0004
#define REG_AP_APB_APB_MISC_CTRL                                                      0x0008
#define REG_AP_APB_AP_DUMMY_REG4                                                      0x000c
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TSEN_ADC_CTRL0                                0x0000
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TSEN_ADC_CTRL1                                0x0004
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TSEN_ADC_CTRL2                                0x0008
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_TEST                            0x000c
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_TEST1                           0x0010
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_TEST0                             0x0014
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_TEST1                             0x0018
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_TEST2                             0x001c
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_TEST3                             0x0020
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_TEST0                             0x0024
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_TEST1                             0x0028
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_TEST2                             0x002c
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_TEST3                             0x0030
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_TEST0                             0x0034
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_TEST1                             0x0038
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_TEST2                             0x003c
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_TEST3                             0x0040
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_TEST0                             0x0044
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_TEST1                             0x0048
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_TEST2                             0x004c
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_TEST3                             0x0050
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_REG_SEL_CFG_0                                 0x0054
#define REG_ANLG_PHY_G6_ANALOG_TSEN_ADC_REG_SEL_CFG_1                                 0x0058
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_CLKLANE_STATE                0x0000
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_STATE_1                      0x0004
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_STATE_2                      0x0008
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_CTRL                         0x000c
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CTRL_CSI_4P2L                         0x0010
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_TXCLKLANE_DB                 0x0014
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_TXDATA_0_DB                  0x0018
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_TXDATA_1_DB                  0x001c
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_TXDATA_2_DB                  0x0020
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_TXDATA_3_DB                  0x0024
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_TXDATAESC_DB                 0x0028
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_STATE_RX_DB                  0x002c
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_DATALANE_CTRL_DB             0x0030
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_ERR_DB                       0x0034
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_CTRL_DB                      0x0038
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_2P2L_TEST_DB                      0x003c
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_4P2L_PHY_BERT_TEST                0x0040
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_REG_SEL_CFG_0                         0x0044
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_REG_SEL_CFG_1                         0x0048
#define REG_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_REG_SEL_CFG_2                         0x004c
#define REG_ANLG_PHY_G3_ANALOG_EFUSE_EFS0_ENK                                         0x0000
#define REG_ANLG_PHY_G3_ANALOG_EFUSE_EFS1_ENK                                         0x0004
#define REG_ANLG_PHY_G3_ANALOG_EFUSE_REG_SEL_CFG_0                                    0x0008
#define REG_AON_SEC_APB_SEC_EB                                                        0x0000
#define REG_AON_SEC_APB_SEC_SOFT_RST                                                  0x0004
#define REG_AON_SEC_APB_FUNC_DMA_EN                                                   0x0008
#define REG_AON_SEC_APB_CA7_CFG_CTRL                                                  0x000c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_ANA_BB_PWR_CTRL                                 0x0000
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_ANA_BB_RST_CTRL                                 0x0004
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_ANALOG_PLL_RES                                  0x0008
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_CTRL0                                      0x000c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_CTRL1                                      0x0010
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_CTRL2                                      0x0014
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_BIST_CTRL                                  0x0018
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_CTRL0                                      0x001c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_CTRL1                                      0x0020
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_CTRL2                                      0x0024
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_BIST_CTRL                                  0x0028
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_CTRL0                                     0x002c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_CTRL1                                     0x0030
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_CTRL2                                     0x0034
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_BIST_CTRL                                 0x0038
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_CTRL0                                     0x003c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_CTRL1                                     0x0040
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_CTRL2                                     0x0044
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_BIST_CTRL                                 0x0048
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_CTRL0                                      0x004c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_CTRL1                                      0x0050
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_CTRL2                                      0x0054
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_BIST_CTRL                                  0x0058
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_THM_CTRL_0                                      0x005c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_THM_CTRL_1                                      0x0060
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_ANA_BB_RSVD                                     0x0064
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_TEST_CLK_CTRL                                   0x0068
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_REG_SEL_CFG_0                                   0x006c
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_REG_SEL_CFG_1                                   0x0070
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_REG_SEL_CFG_2                                   0x0074
#define REG_ANLG_PHY_G1_ANALOG_BB_TOP_REG_SEL_CFG_3                                   0x0078
#define REG_AP_AHB_AHB_EB                                                             0x0000
#define REG_AP_AHB_AHB_RST                                                            0x0004
#define REG_AP_AHB_CA7_RST_SET                                                        0x0008
#define REG_AP_AHB_AP_SYS_FORCE_SLEEP_CFG                                             0x000c
#define REG_AP_AHB_AP_SYS_AUTO_SLEEP_CFG                                              0x0010
#define REG_AP_AHB_HOLDING_PEN                                                        0x0014
#define REG_AP_AHB_JMP_ADDR_CA7_C0                                                    0x0018
#define REG_AP_AHB_JMP_ADDR_CA7_C1                                                    0x001c
#define REG_AP_AHB_JMP_ADDR_CA7_C2                                                    0x0020
#define REG_AP_AHB_JMP_ADDR_CA7_C3                                                    0x0024
#define REG_AP_AHB_CA7_C0_PU_LOCK                                                     0x0028
#define REG_AP_AHB_CA7_C1_PU_LOCK                                                     0x002c
#define REG_AP_AHB_CA7_C2_PU_LOCK                                                     0x0030
#define REG_AP_AHB_CA7_C3_PU_LOCK                                                     0x0034
#define REG_AP_AHB_CA7_CKG_DIV_CFG                                                    0x0038
#define REG_AP_AHB_MCU_PAUSE                                                          0x003c
#define REG_AP_AHB_MISC_CKG_EN                                                        0x0040
#define REG_AP_AHB_CA7_C0_AUTO_FORCE_SHUTDOWN_EN                                      0x0044
#define REG_AP_AHB_CA7_C1_AUTO_FORCE_SHUTDOWN_EN                                      0x0048
#define REG_AP_AHB_CA7_C2_AUTO_FORCE_SHUTDOWN_EN                                      0x004c
#define REG_AP_AHB_CA7_C3_AUTO_FORCE_SHUTDOWN_EN                                      0x0050
#define REG_AP_AHB_CA7_CKG_SEL_CFG                                                    0x0054
#define REG_AP_AHB_MST_FRC_LSLP                                                       0x0058
#define REG_AP_AHB_M0_LPC                                                             0x0060
#define REG_AP_AHB_M9_LPC                                                             0x0084
#define REG_AP_AHB_S0_LPC                                                             0x008c
#define REG_AP_AHB_S1_LPC                                                             0x0090
#define REG_AP_AHB_M_SYNC_LPC                                                         0x00a0
#define REG_AP_AHB_S_SYNC_LPC                                                         0x00a4
#define REG_AP_AHB_AP_GSP_GPV_LPC                                                     0x00a8
#define REG_AP_AHB_AP_GSP_M0_LPC                                                      0x00ac
#define REG_AP_AHB_AP_GSP_M1_LPC                                                      0x00b0
#define REG_AP_AHB_AP_GSP_S0_LPC                                                      0x00b4
#define REG_AP_AHB_AP_IMC_MAIN_LPC                                                    0x00b8
#define REG_AP_AHB_AP_DISP_MAIN_LPC                                                   0x00bc
#define REG_AP_AHB_CA7_TOP_M0_LPC                                                     0x00c0
#define REG_AP_AHB_CA7_TOP_S1_LPC                                                     0x00c4
#define REG_AP_AHB_CA7_TOP_S2_LPC                                                     0x00c8
#define REG_AP_AHB_CA7_ABRG_S0_LPC                                                    0x00cc
#define REG_AP_AHB_TEE_AHB_EB                                                         0x00d0
#define REG_AP_AHB_USB_AHBM2AXI_S0_LPC                                                0x00d4
#define REG_AP_AHB_CA7_EMC_REG_SLICE_LPC                                              0x00d8
#define REG_AP_AHB_AP_DUMMY_REG0                                                      0x0100
#define REG_AP_AHB_AP_DUMMY_REG1                                                      0x0104
#define REG_AP_AHB_AP_DUMMY_REG2                                                      0x0108
#define REG_AP_AHB_AP_DUMMY_REG3                                                      0x010c
#define REG_AP_AHB_CA7_DUMMY_REG0                                                     0x0120
#define REG_AP_AHB_CA7_DUMMY_REG1                                                     0x0124
#define REG_AP_AHB_CA7_CORE_INT_DISABLE_EN                                            0x0128
#define REG_AP_AHB_CA7_STANDBY_STATUS                                                 0x3008
#define REG_AP_AHB_AP_QOS_CFG                                                         0x301c
#define REG_AP_AHB_OTG_PHY_TUNE                                                       0x3020
#define REG_AP_AHB_OTG_PHY_TEST                                                       0x3024
#define REG_AP_AHB_OTG_PHY_CTRL                                                       0x3028
#define REG_AP_AHB_OTG_CTRL0                                                          0x302c
#define REG_AP_AHB_OTG_CTRL1                                                          0x3030
#define REG_AP_AHB_CHIP_ID                                                            0x30fc
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_TXCLKLANE                        0x0000
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_TXDATA_0                         0x0004
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_TXDATA_1                         0x0008
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_TXDATA_2                         0x000c
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_TXDATAESC                        0x0010
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_STATE_RX                         0x0014
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_ERR                              0x0018
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_CTRL                             0x001c
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_RES                              0x0020
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_TEST                             0x0024
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_3L_DATALANE_CTRL                    0x0028
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_REG_SEL_CFG_0                           0x002c
#define REG_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_REG_SEL_CFG_1                           0x0030
#define REG_AON_APB_APB_EB0                                                           0x0000
#define REG_AON_APB_APB_EB1                                                           0x0004
#define REG_AON_APB_APB_RST0                                                          0x0008
#define REG_AON_APB_APB_RST1                                                          0x000c
#define REG_AON_APB_APB_RTC_EB                                                        0x0010
#define REG_AON_APB_REC_26MHZ_BUF_CFG                                                 0x0014
#define REG_AON_APB_APB_SEC_EB                                                        0x001c
#define REG_AON_APB_VBC_CTRL                                                          0x0020
#define REG_AON_APB_PWR_CTRL                                                          0x0024
#define REG_AON_APB_TS_CFG                                                            0x0028
#define REG_AON_APB_BOOT_MODE                                                         0x002c
#define REG_AON_APB_AON_CFG0                                                          0x0030
#define REG_AON_APB_PLL_SOFT_CNT_DONE                                                 0x0038
#define REG_AON_APB_DCXO_LC_REG0                                                      0x003c
#define REG_AON_APB_DCXO_LC_REG1                                                      0x0040
#define REG_AON_APB_MPLL_CFG1                                                         0x0044
#define REG_AON_APB_MPLL_CFG2                                                         0x0048
#define REG_AON_APB_DPLL_CFG1                                                         0x004c
#define REG_AON_APB_DPLL_CFG2                                                         0x0050
#define REG_AON_APB_TWPLL_CFG1                                                        0x0054
#define REG_AON_APB_TWPLL_CFG2                                                        0x0058
#define REG_AON_APB_AON_REG_PROT                                                      0x006c
#define REG_AON_APB_DSI_PHY_CTRL                                                      0x0070
#define REG_AON_APB_CSI_4P2L_M_PHY_CTRL                                               0x007c
#define REG_AON_APB_CSI_4P2L_DBG_PHY_CTRL                                             0x0080
#define REG_AON_APB_CSI_4P2L_PHY_CTRL                                                 0x0084
#define REG_AON_APB_AON_CGM_CFG                                                       0x0088
#define REG_AON_APB_SOFT_DFS_CTRL                                                     0x00a0
#define REG_AON_APB_HARD_DFS_CTRL_LO                                                  0x00a4
#define REG_AON_APB_HARD_DFS_CTRL_HI                                                  0x00a8
#define REG_AON_APB_HARD_DFS_HANSHAKE                                                 0x00ac
#define REG_AON_APB_APB_EB2                                                           0x00b0
#define REG_AON_APB_WCN_BUS_REMAP                                                     0x00cc
#define REG_AON_APB_ANALOG_TSEN_ADC_CONFIG0                                           0x00d0
#define REG_AON_APB_ANALOG_TSEN_ADC_CONFIG1                                           0x00d4
#define REG_AON_APB_WCN_CONFIG0                                                       0x00d8
#define REG_AON_APB_AON_CHIP_ID0                                                      0x00e0
#define REG_AON_APB_AON_CHIP_ID1                                                      0x00e4
#define REG_AON_APB_AON_PLAT_ID0                                                      0x00e8
#define REG_AON_APB_AON_PLAT_ID1                                                      0x00ec
#define REG_AON_APB_AON_IMPL_ID                                                       0x00f0
#define REG_AON_APB_AON_MFT_ID                                                        0x00f4
#define REG_AON_APB_AON_VER_ID                                                        0x00f8
#define REG_AON_APB_AON_CHIP_ID                                                       0x00fc
#define REG_AON_APB_ANALOG_TSEN_ADC_CONFIG2                                           0x0100
#define REG_AON_APB_CM4_SYS_SOFT_RST                                                  0x0114
#define REG_AON_APB_AON_DMA_INT_EN                                                    0x011c
#define REG_AON_APB_EMC_AUTO_GATE_EN                                                  0x0120
#define REG_AON_APB_CM4_CFG_BUS                                                       0x0124
#define REG_AON_APB_APB_RST2                                                          0x0130
#define REG_AON_APB_CLK_EB0                                                           0x0134
#define REG_AON_APB_MPLL_CTRL                                                         0x013c
#define REG_AON_APB_CPLL_CFG1                                                         0x0150
#define REG_AON_APB_CPLL_CFG2                                                         0x0154
#define REG_AON_APB_GPLL_CFG1                                                         0x0158
#define REG_AON_APB_GPLL_CFG2                                                         0x015c
#define REG_AON_APB_BUSMON_DMA_CFG                                                    0x0170
#define REG_AON_APB_ANALOG_CFG0                                                       0x0174
#define REG_AON_APB_ANALOG_CFG1                                                       0x0178
#define REG_AON_APB_MPLL_BIST_CTRL                                                    0x0180
#define REG_AON_APB_DPLL_BIST_CTRL                                                    0x0184
#define REG_AON_APB_CPLL_BIST_CTRL                                                    0x0188
#define REG_AON_APB_TWPLL_BIST_CTRL                                                   0x018c
#define REG_AON_APB_GPLL_BIST_CTRL                                                    0x0190
#define REG_AON_APB_DPLL_CTRL                                                         0x0194
#define REG_AON_APB_SENSOR_CFG0                                                       0x01a0
#define REG_AON_APB_ANALOG_IOS_CFG                                                    0x01a4
#define REG_AON_APB_MPLL_CFG3                                                         0x01b0
#define REG_AON_APB_DPLL_CFG3                                                         0x01b4
#define REG_AON_APB_CPLL_CFG3                                                         0x01b8
#define REG_AON_APB_TWPLL_CFG3                                                        0x01bc
#define REG_AON_APB_GPLL_CFG3                                                         0x01c0
#define REG_AON_APB_CP_DAP_PAD_CTRL                                                   0x0200
#define REG_AON_APB_CA7_PROT_CTRL                                                     0x0204
#define REG_AON_APB_CSSYS_CFG                                                         0x0208
#define REG_AON_APB_SEC_MUX_DBG_EN                                                    0x020c
#define REG_AON_APB_CR5_PROT_CTRL                                                     0x0210
#define REG_AON_APB_DBG_DJTAG_CTRL                                                    0x0214
#define REG_AON_APB_WTLCP_CTRL                                                        0x0240
#define REG_AON_APB_WTL_WCDMA_EB                                                      0x0244
#define REG_AON_APB_WTLCP_TDSP_CTRL0                                                  0x0250
#define REG_AON_APB_WTLCP_TDSP_CTRL1                                                  0x0254
#define REG_AON_APB_CP_CONFIG0                                                        0x0258
#define REG_AON_APB_CP_CONFIG1                                                        0x025c
#define REG_AON_APB_RF_CONFIG                                                         0x0260
#define REG_AON_APB_PCP_AON_EB                                                        0x0280
#define REG_AON_APB_PCP_SOFT_RST                                                      0x0284
#define REG_AON_APB_PUBCP_CTRL                                                        0x0288
#define REG_AON_APB_SYS_DBG_SEL                                                       0x02b0
#define REG_AON_APB_SYS_DBG_SEL2                                                      0x02b8
#define REG_AON_APB_SUBSYS_DBG_CFG                                                    0x02bc
#define REG_AON_APB_GLB_WCDMA_CTRL                                                    0x0300
#define REG_AON_APB_AON_MTX_EMC_LP_CTRL                                               0x03d4
#define REG_AON_APB_AON_MTX_MAIN_LP_CTRL                                              0x03d8
#define REG_AON_APB_AON_MTX_SW0_LP_CTRL                                               0x03dc
#define REG_AON_APB_AON_MTX_SW1_LP_CTRL                                               0x03e0
#define REG_AON_APB_AON_MTX__RF_LP_CTRL                                               0x03e4
#define REG_AON_APB_AON_MTX_WCN_LP_CTRL                                               0x03e8
#define REG_AON_APB_SUBSYS_LPC_FORCE_REQ                                              0x03f8
#define REG_AON_APB_SUBSYS_LPC_FORCE_ACK                                              0x03fc
#define REG_AON_APB_DAP_DJTAG_CTRL                                                    0x0430
#define REG_AON_APB_EFUSE_CONFIG0                                                     0x0450
#define REG_AON_APB_TOP_LPC0                                                          0x0500
#define REG_AON_APB_TOP_LPC1                                                          0x0504
#define REG_AON_APB_TOP_LPC2                                                          0x0508
#define REG_AON_APB_TOP_LPC3                                                          0x050c
#define REG_AON_APB_OVERHEAT_RST_CTRL                                                 0x0510
#define REG_AON_APB_TOP_LPC4                                                          0x0514
#define REG_AON_APB_TOP_LPC5                                                          0x0518
#define REG_AON_APB_DDR_SLEEP_CTRL0                                                   0x0530
#define REG_AON_APB_DDR_SLEEP_CTRL1                                                   0x0534
#define REG_AON_APB_DDR_SLEEP_CTRL2                                                   0x0538
#define REG_AON_APB_DDR_SLEEP_CTRL3                                                   0x053c
#define REG_AON_APB_ADI_CONFIG0                                                       0x0540
#define REG_AON_APB_AP_WPROT_EN1                                                      0x3004
#define REG_AON_APB_WTLCP_WPROT_EN1                                                   0x3008
#define REG_AON_APB_PUBCP_WPROT_EN1                                                   0x300c
#define REG_AON_APB_IO_DLY_CTRL                                                       0x3014
#define REG_AON_APB_AP_WPROT_EN0                                                      0x3018
#define REG_AON_APB_WTLCP_WPROT_EN0                                                   0x3020
#define REG_AON_APB_PUBCP_WPROT_EN0                                                   0x3024
#define REG_AON_APB_PMU_RST_MONITOR                                                   0x302c
#define REG_AON_APB_THM_RST_MONITOR                                                   0x3030
#define REG_AON_APB_AP_RST_MONITOR                                                    0x3034
#define REG_AON_APB_CA7_RST_MONITOR                                                   0x3038
#define REG_AON_APB_BOND_OPT0                                                         0x303c
#define REG_AON_APB_BOND_OPT1                                                         0x3040
#define REG_AON_APB_RES_REG0                                                          0x3044
#define REG_AON_APB_RES_REG1                                                          0x3048
#define REG_AON_APB_PLL_LOCK_OUT_SEL                                                  0x3064
#define REG_AON_APB_WDG_RST_FLAG                                                      0x3080
#define REG_AON_APB_CA7_CFG                                                           0x3084
#define REG_AON_APB_RES_REG2                                                          0x3090
#define REG_AON_APB_RES_REG3                                                          0x3094
#define REG_AON_APB_RES_REG4                                                          0x3098
#define REG_AON_APB_RES_REG5                                                          0x309c
#define REG_AON_APB_RES_REG6                                                          0x30a0
#define REG_AON_APB_RES_REG7                                                          0x30a4
#define REG_AON_APB_AON_APB_RSV                                                       0x30f0
#define REG_AON_APB_FUNCTION_DMA_BOOT_ADDR                                            0x3110
#define REG_AON_APB_SIM_HOT_PLUG_CTRL_PUBCP_SIM0                                      0x3114
#define REG_AON_APB_SIM_HOT_PLUG_CTRL_PUBCP_SIM1                                      0x3118
#define REG_AON_APB_SIM_HOT_PLUG_CTRL_PUBCP_SIM2                                      0x311c
#define REG_AON_APB_SIM_HOT_PLUG_CTRL_AP_SIM0                                         0x3120
#define REG_AON_APB_DEEP_SLEEP_SOFT                                                   0x3124
