// SPDX-License-Identifier: GPL-2.0-only
/*
 * sprd,pike2-mask.h - Unisoc platform header
 *
 * Copyright 2022 Unisoc(Shanghai) Technologies Co.Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#define MASK_GPU_APB_GPU_SOFT_RST                                                           0x1
#define MASK_GPU_APB_CLK_GPU_DIV                                                            0x30
#define MASK_GPU_APB_CLK_GPU_SEL                                                            0x7
#define MASK_GPU_APB_T820_IRQGPU                                                            0x4
#define MASK_GPU_APB_T820_IRQMMU                                                            0x2
#define MASK_GPU_APB_T820_IRQJOB                                                            0x1
#define MASK_GPU_APB_GPU_PRB_SEL                                                            0xf
#define MASK_GPU_APB_GPU_EMC_BRG_S0_LP_STAT_M                                               0x400000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_MMTX_STOP_CH                                            0x200000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_FRC_LSLP_MST                                            0x100000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_MTX_LP_DISABLE                                          0x80000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_LP_AUTO_CTRL_EN                                         0x40000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_LP_FORCE_M                                              0x20000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_LP_EB_M                                                 0x10000
#define MASK_GPU_APB_GPU_EMC_BRG_S0_LP_NUM                                                  0xffff
#define MASK_GPU_APB_GPU_EMC_BRG_M0_LP_STAT_M                                               0x400000
#define MASK_GPU_APB_GPU_EMC_BRG_M0_LP_FORCE_M                                              0x20000
#define MASK_GPU_APB_GPU_EMC_BRG_M0_LP_EB_M                                                 0x10000
#define MASK_GPU_APB_GPU_EMC_BRG_M0_LP_NUM                                                  0xffff
#define MASK_GPU_APB_GPU_EMC_BRG_GPV_LP_STAT_M                                              0x400000
#define MASK_GPU_APB_GPU_EMC_BRG_GPV_LP_FORCE_M                                             0x20000
#define MASK_GPU_APB_GPU_EMC_BRG_GPV_LP_EB_M                                                0x10000
#define MASK_GPU_APB_GPU_EMC_BRG_GPV_LP_NUM                                                 0xffff
#define MASK_GPU_APB_GPU_APB_BRG_S0_LP_STAT_M                                               0x400000
#define MASK_GPU_APB_GPU_APB_BRG_S0_LP_FORCE_M                                              0x20000
#define MASK_GPU_APB_GPU_APB_BRG_S0_LP_EB_M                                                 0x10000
#define MASK_GPU_APB_GPU_APB_BRG_S0_LP_NUM                                                  0xffff
#define MASK_GPU_APB_GPU_BARRIER_DISABLE                                                    0x1
#define MASK_GPU_APB_GPU_ENGINEER_DBG_H                                                     0xffff0000
#define MASK_GPU_APB_GPU_ENGINEER_DBG_L                                                     0xffff
#define MASK_MM_AHB_VSP_MTX_QOS_AHB_EB                                                      0x40
#define MASK_MM_AHB_CKG_EB                                                                  0x20
#define MASK_MM_AHB_JPG_EB                                                                  0x10
#define MASK_MM_AHB_CSI_EB                                                                  0x8
#define MASK_MM_AHB_VSP_EB                                                                  0x4
#define MASK_MM_AHB_ISP_EB                                                                  0x2
#define MASK_MM_AHB_DCAM_EB                                                                 0x1
#define MASK_MM_AHB_AXI_VSP_MTX_SOFT_RST                                                    0x1000
#define MASK_MM_AHB_AXI_CAM_MTX_SOFT_RST                                                    0x800
#define MASK_MM_AHB_AHB_CKG_SOFT_RST                                                        0x400
#define MASK_MM_AHB_APB_CSI_SOFT_RST                                                        0x200
#define MASK_MM_AHB_JPG_SOFT_RST                                                            0x100
#define MASK_MM_AHB_VSP_SOFT_RST                                                            0x80
#define MASK_MM_AHB_ISP_CFG_SOFT_RST                                                        0x40
#define MASK_MM_AHB_ISP_LOG_SOFT_RST                                                        0x20
#define MASK_MM_AHB_DCAM_ROT_SOFT_RST                                                       0x10
#define MASK_MM_AHB_DCAM_CAM2_SOFT_RST                                                      0x8
#define MASK_MM_AHB_DCAM_CAM1_SOFT_RST                                                      0x4
#define MASK_MM_AHB_DCAM_CAM0_SOFT_RST                                                      0x2
#define MASK_MM_AHB_DCAM_SOFT_RST                                                           0x1
#define MASK_MM_AHB_MIPI_CSI_CKG_EN                                                         0x10
#define MASK_MM_AHB_DCAM_AXI_CKG_EN                                                         0x8
#define MASK_MM_AHB_ISP_AXI_CKG_EN                                                          0x4
#define MASK_MM_AHB_SENSOR0_CKG_EN                                                          0x2
#define MASK_MM_AHB_CPHY_CFG_CKG_EN                                                         0x1
#define MASK_MM_AHB_MIPI_CPHY_SEL                                                           0x1
#define MASK_MM_AHB_ISP_ARQOS                                                               0xf0
#define MASK_MM_AHB_ISP_AWQOS                                                               0xf
#define MASK_MM_AHB_CAM_MTX_LPC_FORCE                                                       0x20000
#define MASK_MM_AHB_CAM_MTX_LPC_EB                                                          0x10000
#define MASK_MM_AHB_CAM_MTX_LPC_NUM                                                         0xffff
#define MASK_MM_AHB_VSP_MTX_M0_LPC_FORCE                                                    0x20000
#define MASK_MM_AHB_VSP_MTX_M0_LPC_EB                                                       0x10000
#define MASK_MM_AHB_VSP_MTX_M0_LPC_NUM                                                      0xffff
#define MASK_MM_AHB_VSP_MTX_M1_LPC_FORCE                                                    0x20000
#define MASK_MM_AHB_VSP_MTX_M1_LPC_EB                                                       0x10000
#define MASK_MM_AHB_VSP_MTX_M1_LPC_NUM                                                      0xffff
#define MASK_MM_AHB_VSP_MTX_S0_LPC_FORCE                                                    0x20000
#define MASK_MM_AHB_VSP_MTX_S0_LPC_EB                                                       0x10000
#define MASK_MM_AHB_VSP_MTX_S0_LPC_NUM                                                      0xffff
#define MASK_MM_AHB_VSP_MTX_S0_FORCE_ACK                                                    0x2000
#define MASK_MM_AHB_VSP_MTX_GPV_FORCE_ACK                                                   0x1000
#define MASK_MM_AHB_VSP_MTX_M1_FORCE_ACK                                                    0x800
#define MASK_MM_AHB_VSP_MTX_M0_FORCE_ACK                                                    0x400
#define MASK_MM_AHB_CAM_MTX_LPC_FORCE_ACK                                                   0x200
#define MASK_MM_AHB_CAM_MTX_M1_FORCE_ACK                                                    0x100
#define MASK_MM_AHB_CAM_MTX_M0_FORCE_ACK                                                    0x80
#define MASK_MM_AHB_VSP_MTX_S0_LPC_STAT                                                     0x40
#define MASK_MM_AHB_VSP_MTX_GPV_LPC_STAT                                                    0x20
#define MASK_MM_AHB_VSP_MTX_M1_LPC_STAT                                                     0x10
#define MASK_MM_AHB_VSP_MTX_M0_LPC_STAT                                                     0x8
#define MASK_MM_AHB_CAM_MTX_M1_LPC_STAT                                                     0x4
#define MASK_MM_AHB_CAM_MTX_M0_LPC_STAT                                                     0x2
#define MASK_MM_AHB_CAM_MTX_LPC_STAT                                                        0x1
#define MASK_MM_AHB_REG_CAM_MTX_AUTO_CTRL_EN                                                0x2000
#define MASK_MM_AHB_REG_CAM_MTX_LP_DISABLE                                                  0x400
#define MASK_MM_AHB_REG_CAM_MTX_FRC_LSLP_M0                                                 0x200
#define MASK_MM_AHB_REG_CAM_MTX_FRC_LSLP_M1                                                 0x100
#define MASK_MM_AHB_REG_VSP_MTX_AUTO_CTRL_EN                                                0x20
#define MASK_MM_AHB_REG_VSP_MTX_LP_DISABLE                                                  0x4
#define MASK_MM_AHB_REG_VSP_MTX_FRC_LSLP_M0                                                 0x2
#define MASK_MM_AHB_REG_VSP_MTX_FRC_LSLP_M1                                                 0x1
#define MASK_MM_AHB_CAM_MTX_M0_LPC_FORCE                                                    0x20000
#define MASK_MM_AHB_CAM_MTX_M0_LPC_EB                                                       0x10000
#define MASK_MM_AHB_CAM_MTX_M0_LPC_NUM                                                      0xffff
#define MASK_MM_AHB_CAM_MTX_M1_LPC_FORCE                                                    0x20000
#define MASK_MM_AHB_CAM_MTX_M1_LPC_EB                                                       0x10000
#define MASK_MM_AHB_CAM_MTX_M1_LPC_NUM                                                      0xffff
#define MASK_MM_AHB_VSP_MTX_GPV_LPC_FORCE                                                   0x20000
#define MASK_MM_AHB_VSP_MTX_GPV_LPC_EB                                                      0x10000
#define MASK_MM_AHB_VSP_MTX_GPV_LPC_NUM                                                     0xffff
#define MASK_MM_AHB_MM_DUMMY_REG_0                                                          0xffffffff
#define MASK_MM_AHB_MM_DUMMY_REG_1                                                          0xffffffff
#define MASK_SP_AHB_CM4_GPIO_EB                                                             0x400
#define MASK_SP_AHB_CM4_UART_EB                                                             0x200
#define MASK_SP_AHB_CM4_TMR_EB                                                              0x100
#define MASK_SP_AHB_CM4_SYST_EB                                                             0x80
#define MASK_SP_AHB_CM4_WDG_EB                                                              0x40
#define MASK_SP_AHB_CM4_EIC_EB                                                              0x20
#define MASK_SP_AHB_CM4_INTC_EB                                                             0x10
#define MASK_SP_AHB_CM4_IMC_EB                                                              0x4
#define MASK_SP_AHB_CM4_GPIO_SOFT_RST                                                       0x400
#define MASK_SP_AHB_CM4_UART_SOFT_RST                                                       0x200
#define MASK_SP_AHB_CM4_TMR_SOFT_RST                                                        0x100
#define MASK_SP_AHB_CM4_SYST_SOFT_RST                                                       0x80
#define MASK_SP_AHB_CM4_WDG_SOFT_RST                                                        0x40
#define MASK_SP_AHB_CM4_EIC_SOFT_RST                                                        0x20
#define MASK_SP_AHB_CM4_INTC_SOFT_RST                                                       0x10
#define MASK_SP_AHB_CM4_IMC_SOFT_RST                                                        0x4
#define MASK_SP_AHB_CM4_ARCH_SOFT_RST                                                       0x1
#define MASK_SP_AHB_SYS_AUTO_GATE_EN                                                        0x4
#define MASK_SP_AHB_CORE_AUTO_GATE_EN                                                       0x1
#define MASK_SP_AHB_SOFT_EXRESPD                                                            0x200
#define MASK_SP_AHB_SOFT_TSCLK_CHG                                                          0x80
#define MASK_SP_AHB_SOFT_FIX_MSTTYPE                                                        0x40
#define MASK_SP_AHB_SOFT_DBG_RESTART                                                        0x20
#define MASK_SP_AHB_SOFT_EDBGRQ                                                             0x10
#define MASK_SP_AHB_SOFT_SLEEP_HOLD_REQ_N                                                   0x8
#define MASK_SP_AHB_SOFT_EXRESPS                                                            0x4
#define MASK_SP_AHB_SOFT_CGBYPASS                                                           0x2
#define MASK_SP_AHB_SOFT_RSTBYPASS                                                          0x1
#define MASK_SP_AHB_SOFT_AUXFAULT                                                           0xffffffff
#define MASK_SP_AHB_WICENACK_STAT                                                           0x80000000
#define MASK_SP_AHB_GATEHCLK_STAT                                                           0x40000000
#define MASK_SP_AHB_WAKEUP_STAT                                                             0x20000000
#define MASK_SP_AHB_SLEEPHOLDACKN_STAT                                                      0x10000000
#define MASK_SP_AHB_SLEEPINGDEEP_STAT                                                       0x8000000
#define MASK_SP_AHB_SLEEPING_STAT                                                           0x4000000
#define MASK_SP_AHB_DBGRESTARTED_STAT                                                       0x1000000
#define MASK_SP_AHB_HALTED_STAT                                                             0x800000
#define MASK_SP_AHB_BRCHSTAT_STAT                                                           0x780000
#define MASK_SP_AHB_EXREQS_STAT                                                             0x40000
#define MASK_SP_AHB_MEMATTRS_STAT                                                           0x30000
#define MASK_SP_AHB_HMASTLOCKS_STAT                                                         0x8000
#define MASK_SP_AHB_HMASTERS_STAT                                                           0x6000
#define MASK_SP_AHB_HWRITED_STAT                                                            0x1000
#define MASK_SP_AHB_EXREQD_STAT                                                             0x800
#define MASK_SP_AHB_MEMATTRD_STAT                                                           0x600
#define MASK_SP_AHB_HMASTERD_STAT                                                           0x180
#define MASK_SP_AHB_MEMATTRI_STAT                                                           0x60
#define MASK_SP_AHB_SWV_STAT                                                                0x10
#define MASK_SP_AHB_CDBGPWRUPREQ_STAT                                                       0x1
#define MASK_SP_AHB_HWDATAD_STAT                                                            0xffffffff
#define MASK_SP_AHB_CURRPRI_STAT                                                            0xff
#define MASK_SP_AHB_CM4_CLK_EMC_SEL                                                         0x1c
#define MASK_SP_AHB_CM4_CLK_EMC_DIV                                                         0x3
#define MASK_SP_AHB_LP_FORCE_ACK                                                            0x80000
#define MASK_SP_AHB_LP_FORCE                                                                0x40000
#define MASK_SP_AHB_LP_STAT                                                                 0x20000
#define MASK_SP_AHB_LP_EB                                                                   0x10000
#define MASK_SP_AHB_LP_NUM                                                                  0xffff
#define MASK_SP_AHB_DUMMY_DEF1                                                              0xffff0000
#define MASK_SP_AHB_DUMMY_DEF0                                                              0xffff
#define MASK_PMU_APB_PD_CA7_TOP_DBG_SHUTDOWN_EN                                             0x10000000
#define MASK_PMU_APB_PD_CA7_TOP_PD_SEL                                                      0x8000000
#define MASK_PMU_APB_PD_CA7_TOP_FORCE_SHUTDOWN                                              0x2000000
#define MASK_PMU_APB_PD_CA7_TOP_AUTO_SHUTDOWN_EN                                            0x1000000
#define MASK_PMU_APB_PD_CA7_TOP_PWR_ON_DLY                                                  0xff0000
#define MASK_PMU_APB_PD_CA7_TOP_PWR_ON_SEQ_DLY                                              0xff00
#define MASK_PMU_APB_PD_CA7_TOP_ISO_ON_DLY                                                  0xff
#define MASK_PMU_APB_PD_CA7_C0_WFI_SHUTDOWN_EN                                              0x20000000
#define MASK_PMU_APB_PD_CA7_C0_DBG_SHUTDOWN_EN                                              0x10000000
#define MASK_PMU_APB_PD_CA7_C0_PD_SEL                                                       0x8000000
#define MASK_PMU_APB_PD_CA7_C0_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_CA7_C0_AUTO_SHUTDOWN_EN                                             0x1000000
#define MASK_PMU_APB_PD_CA7_C0_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_CA7_C0_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_CA7_C0_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_PD_CA7_C1_WFI_SHUTDOWN_EN                                              0x20000000
#define MASK_PMU_APB_PD_CA7_C1_DBG_SHUTDOWN_EN                                              0x10000000
#define MASK_PMU_APB_PD_CA7_C1_PD_SEL                                                       0x8000000
#define MASK_PMU_APB_PD_CA7_C1_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_CA7_C1_AUTO_SHUTDOWN_EN                                             0x1000000
#define MASK_PMU_APB_PD_CA7_C1_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_CA7_C1_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_CA7_C1_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_PD_CA7_C2_WFI_SHUTDOWN_EN                                              0x20000000
#define MASK_PMU_APB_PD_CA7_C2_DBG_SHUTDOWN_EN                                              0x10000000
#define MASK_PMU_APB_PD_CA7_C2_PD_SEL                                                       0x8000000
#define MASK_PMU_APB_PD_CA7_C2_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_CA7_C2_AUTO_SHUTDOWN_EN                                             0x1000000
#define MASK_PMU_APB_PD_CA7_C2_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_CA7_C2_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_CA7_C2_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_PD_CA7_C3_WFI_SHUTDOWN_EN                                              0x20000000
#define MASK_PMU_APB_PD_CA7_C3_DBG_SHUTDOWN_EN                                              0x10000000
#define MASK_PMU_APB_PD_CA7_C3_PD_SEL                                                       0x8000000
#define MASK_PMU_APB_PD_CA7_C3_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_CA7_C3_AUTO_SHUTDOWN_EN                                             0x1000000
#define MASK_PMU_APB_PD_CA7_C3_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_CA7_C3_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_CA7_C3_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_PD_AP_SYS_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_AP_SYS_AUTO_SHUTDOWN_EN                                             0x1000000
#define MASK_PMU_APB_PD_AP_SYS_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_AP_SYS_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_AP_SYS_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_PD_MM_TOP_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_MM_TOP_AUTO_SHUTDOWN_EN                                             0x1000000
#define MASK_PMU_APB_PD_MM_TOP_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_MM_TOP_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_MM_TOP_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_PD_GPU_TOP_FORCE_SHUTDOWN                                              0x2000000
#define MASK_PMU_APB_PD_GPU_TOP_AUTO_SHUTDOWN_EN                                            0x1000000
#define MASK_PMU_APB_PD_GPU_TOP_PWR_ON_DLY                                                  0xff0000
#define MASK_PMU_APB_PD_GPU_TOP_PWR_ON_SEQ_DLY                                              0xff00
#define MASK_PMU_APB_PD_GPU_TOP_ISO_ON_DLY                                                  0xff
#define MASK_PMU_APB_PD_WTLCP_TGDSP_PD_SEL                                                  0x8000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_FORCE_SHUTDOWN                                          0x2000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_AUTO_SHUTDOWN_EN                                        0x1000000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_PWR_ON_DLY                                              0xff0000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_PWR_ON_SEQ_DLY                                          0xff00
#define MASK_PMU_APB_PD_WTLCP_TGDSP_ISO_ON_DLY                                              0xff
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_FORCE_SHUTDOWN                                        0x2000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_AUTO_SHUTDOWN_EN                                      0x1000000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_PWR_ON_DLY                                            0xff0000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_PWR_ON_SEQ_DLY                                        0xff00
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_ISO_ON_DLY                                            0xff
#define MASK_PMU_APB_PD_PUBCP_SYS_AUTO_SHUTDOWN_EN                                          0x8000000
#define MASK_PMU_APB_PD_CP_SYS_DBG_SHUTDOWN_EN                                              0x4000000
#define MASK_PMU_APB_PD_CP_SYS_FORCE_SHUTDOWN                                               0x2000000
#define MASK_PMU_APB_PD_WTLCP_SYS_AUTO_SHUTDOWN_EN                                          0x1000000
#define MASK_PMU_APB_PD_CP_SYS_PWR_ON_DLY                                                   0xff0000
#define MASK_PMU_APB_PD_CP_SYS_PWR_ON_SEQ_DLY                                               0xff00
#define MASK_PMU_APB_PD_CP_SYS_ISO_ON_DLY                                                   0xff
#define MASK_PMU_APB_CP_FRC_STOP_REQ_FOR_WTL                                                0x1
#define MASK_PMU_APB_PD_WCN_TOP_FORCE_SHUTDOWN                                              0x2000000
#define MASK_PMU_APB_PD_WCN_TOP_AUTO_SHUTDOWN_EN                                            0x1000000
#define MASK_PMU_APB_PD_WCN_TOP_PWR_ON_DLY                                                  0xff0000
#define MASK_PMU_APB_PD_WCN_TOP_PWR_ON_SEQ_DLY                                              0xff00
#define MASK_PMU_APB_PD_WCN_TOP_ISO_ON_DLY                                                  0xff
#define MASK_PMU_APB_PD_WCN_WIFI_AUTO_SEL                                                   0x4000000
#define MASK_PMU_APB_PD_WCN_WIFI_FORCE_SHUTDOWN                                             0x2000000
#define MASK_PMU_APB_PD_WCN_WIFI_AUTO_SHUTDOWN_EN                                           0x1000000
#define MASK_PMU_APB_PD_WCN_WIFI_PWR_ON_DLY                                                 0xff0000
#define MASK_PMU_APB_PD_WCN_WIFI_PWR_ON_SEQ_DLY                                             0xff00
#define MASK_PMU_APB_PD_WCN_WIFI_ISO_ON_DLY                                                 0xff
#define MASK_PMU_APB_PD_WCN_GNSS_AUTO_SEL                                                   0x4000000
#define MASK_PMU_APB_PD_WCN_GNSS_FORCE_SHUTDOWN                                             0x2000000
#define MASK_PMU_APB_PD_WCN_GNSS_AUTO_SHUTDOWN_EN                                           0x1000000
#define MASK_PMU_APB_PD_WCN_GNSS_PWR_ON_DLY                                                 0xff0000
#define MASK_PMU_APB_PD_WCN_GNSS_PWR_ON_SEQ_DLY                                             0xff00
#define MASK_PMU_APB_PD_WCN_GNSS_ISO_ON_DLY                                                 0xff
#define MASK_PMU_APB_PD_PUB_SYS_PRE_EN                                                      0x4000000
#define MASK_PMU_APB_PD_PUB_SYS_FORCE_SHUTDOWN                                              0x2000000
#define MASK_PMU_APB_PD_PUB_SYS_AUTO_SHUTDOWN_EN                                            0x1000000
#define MASK_PMU_APB_PD_PUB_SYS_PWR_ON_DLY                                                  0xff0000
#define MASK_PMU_APB_PD_PUB_SYS_PWR_ON_SEQ_DLY                                              0xff00
#define MASK_PMU_APB_PD_PUB_SYS_ISO_ON_DLY                                                  0xff
#define MASK_PMU_APB_XTL0_WAIT_CNT                                                          0xff
#define MASK_PMU_APB_XTLBUF0_WAIT_CNT                                                       0xff
#define MASK_PMU_APB_CPLL_WAIT_CNT                                                          0xff000000
#define MASK_PMU_APB_TWPLL_WAIT_CNT                                                         0xff0000
#define MASK_PMU_APB_DPLL_WAIT_CNT                                                          0xff00
#define MASK_PMU_APB_MPLL_WAIT_CNT                                                          0xff
#define MASK_PMU_APB_GPLL_WAIT_CNT                                                          0xff0000
#define MASK_PMU_APB_BBPLL2_WAIT_CNT                                                        0xff00
#define MASK_PMU_APB_BBPLL1_WAIT_CNT                                                        0xff
#define MASK_PMU_APB_XTL0_DIG_RAM_SEL                                                       0x100
#define MASK_PMU_APB_XTL0_CM4_RAM_SEL                                                       0x80
#define MASK_PMU_APB_XTL0_AON_RAM_SEL                                                       0x40
#define MASK_PMU_APB_XTL0_CM4_SEL                                                           0x20
#define MASK_PMU_APB_XTL0_PUBCP_SEL                                                         0x10
#define MASK_PMU_APB_XTL0_PUB_SEL                                                           0x8
#define MASK_PMU_APB_XTL0_WCN_SEL                                                           0x4
#define MASK_PMU_APB_XTL0_WTLCP_SEL                                                         0x2
#define MASK_PMU_APB_XTL0_AP_SEL                                                            0x1
#define MASK_PMU_APB_CPLL_CM4_SEL                                                           0x20
#define MASK_PMU_APB_CPLL_PUB_SEL                                                           0x8
#define MASK_PMU_APB_CPLL_WCN_SEL                                                           0x4
#define MASK_PMU_APB_CPLL_CP_SEL                                                            0x2
#define MASK_PMU_APB_CPLL_AP_SEL                                                            0x1
#define MASK_PMU_APB_XTLBUF0_DIG_RAM_SEL                                                    0x100
#define MASK_PMU_APB_XTLBUF0_CM4_RAM_SEL                                                    0x80
#define MASK_PMU_APB_XTLBUF0_AON_RAM_SEL                                                    0x40
#define MASK_PMU_APB_XTLBUF0_CM4_SEL                                                        0x20
#define MASK_PMU_APB_XTLBUF0_PUBCP_SEL                                                      0x10
#define MASK_PMU_APB_XTLBUF0_PUB_SEL                                                        0x8
#define MASK_PMU_APB_XTLBUF0_WCN_SEL                                                        0x4
#define MASK_PMU_APB_XTLBUF0_WTLCP_SEL                                                      0x2
#define MASK_PMU_APB_XTLBUF0_AP_SEL                                                         0x1
#define MASK_PMU_APB_GPLL_AP_SEL                                                            0x1
#define MASK_PMU_APB_MPLL_CM4_SEL                                                           0x20
#define MASK_PMU_APB_MPLL_PUB_SEL                                                           0x8
#define MASK_PMU_APB_MPLL_AP_SEL                                                            0x1
#define MASK_PMU_APB_DPLL_CM4_SEL                                                           0x20
#define MASK_PMU_APB_DPLL_PUB_SEL                                                           0x8
#define MASK_PMU_APB_DPLL_CP_SEL                                                            0x2
#define MASK_PMU_APB_DPLL_AP_SEL                                                            0x1
#define MASK_PMU_APB_TWPLL_CM4_SEL                                                          0x20
#define MASK_PMU_APB_TWPLL_PUBCP_SEL                                                        0x10
#define MASK_PMU_APB_TWPLL_PUB_SEL                                                          0x8
#define MASK_PMU_APB_TWPLL_WCN_SEL                                                          0x4
#define MASK_PMU_APB_TWPLL_WTLCP_SEL                                                        0x2
#define MASK_PMU_APB_TWPLL_AP_SEL                                                           0x1
#define MASK_PMU_APB_GPLL_FRC_OFF                                                           0x80
#define MASK_PMU_APB_XTLBUF0_FRC_OFF                                                        0x40
#define MASK_PMU_APB_BBPLL2_FRC_OFF                                                         0x20
#define MASK_PMU_APB_BBPLL1_FRC_OFF                                                         0x10
#define MASK_PMU_APB_CPLL_FRC_OFF                                                           0x8
#define MASK_PMU_APB_DPLL_FRC_OFF                                                           0x4
#define MASK_PMU_APB_TWPLL_FRC_OFF                                                          0x2
#define MASK_PMU_APB_MPLL_FRC_OFF                                                           0x1
#define MASK_PMU_APB_GPLL_FRC_ON                                                            0x80
#define MASK_PMU_APB_XTLBUF0_FRC_ON                                                         0x40
#define MASK_PMU_APB_BBPLL2_FRC_ON                                                          0x20
#define MASK_PMU_APB_BBPLL1_FRC_ON                                                          0x10
#define MASK_PMU_APB_CPLL_FRC_ON                                                            0x8
#define MASK_PMU_APB_DPLL_FRC_ON                                                            0x4
#define MASK_PMU_APB_TWPLL_FRC_ON                                                           0x2
#define MASK_PMU_APB_MPLL_FRC_ON                                                            0x1
#define MASK_PMU_APB_PLL_AUTO_PD_EN                                                         0x1
#define MASK_PMU_APB_CM4_SOFT_RST                                                           0x100
#define MASK_PMU_APB_WCN_SOFT_RST                                                           0x80
#define MASK_PMU_APB_PUB_SOFT_RST                                                           0x40
#define MASK_PMU_APB_AP_SOFT_RST                                                            0x20
#define MASK_PMU_APB_GPU_SOFT_RST                                                           0x10
#define MASK_PMU_APB_MM_SOFT_RST                                                            0x8
#define MASK_PMU_APB_WTLCP_DSP_SYS_SRST                                                     0x4
#define MASK_PMU_APB_CP_SOFT_RST                                                            0x2
#define MASK_PMU_APB_WTLCP_SOFT_RST                                                         0x1
#define MASK_PMU_APB_CP_DEEP_SLP_DBG                                                        0xffffffff
#define MASK_PMU_APB_PD_MM_TOP_STATE                                                        0xf0000000
#define MASK_PMU_APB_PD_GPU_TOP_STATE                                                       0xf000000
#define MASK_PMU_APB_PD_AP_SYS_STATE                                                        0xf00000
#define MASK_PMU_APB_PD_CA7_C3_STATE                                                        0xf0000
#define MASK_PMU_APB_PD_CA7_C2_STATE                                                        0xf000
#define MASK_PMU_APB_PD_CA7_C1_STATE                                                        0xf00
#define MASK_PMU_APB_PD_CA7_C0_STATE                                                        0xf0
#define MASK_PMU_APB_PD_CA7_TOP_STATE                                                       0xf
#define MASK_PMU_APB_PD_WCN_GNSS_STATE                                                      0xf000000
#define MASK_PMU_APB_PD_WCN_WIFI_STATE                                                      0xf00000
#define MASK_PMU_APB_PD_WCN_TOP_STATE                                                       0xf0000
#define MASK_PMU_APB_PD_PUB_SYS_STATE                                                       0xf000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_STATE                                                   0xf00
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_STATE                                                 0xf0
#define MASK_PMU_APB_PD_CP_SYS_STATE                                                        0xf
#define MASK_PMU_APB_PD_WCN_GNSS_STATE_4                                                    0x4000
#define MASK_PMU_APB_PD_WCN_WIFI_STATE_4                                                    0x2000
#define MASK_PMU_APB_PD_WCN_TOP_STATE_4                                                     0x1000
#define MASK_PMU_APB_PD_PUB_SYS_STATE_4                                                     0x800
#define MASK_PMU_APB_PD_WTLCP_TGDSP_STATE_4                                                 0x400
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_STATE_4                                               0x200
#define MASK_PMU_APB_PD_CP_SYS_STATE_4                                                      0x100
#define MASK_PMU_APB_PD_MM_TOP_STATE_4                                                      0x80
#define MASK_PMU_APB_PD_GPU_TOP_STATE_4                                                     0x40
#define MASK_PMU_APB_PD_AP_SYS_STATE_4                                                      0x20
#define MASK_PMU_APB_PD_CA7_C3_STATE_4                                                      0x10
#define MASK_PMU_APB_PD_CA7_C2_STATE_4                                                      0x8
#define MASK_PMU_APB_PD_CA7_C1_STATE_4                                                      0x4
#define MASK_PMU_APB_PD_CA7_C0_STATE_4                                                      0x2
#define MASK_PMU_APB_PD_CA7_TOP_STATE_4                                                     0x1
#define MASK_PMU_APB_CM4_FORCE_DEEP_SLEEP                                                   0x200000
#define MASK_PMU_APB_CP_FORCE_DEEP_SLEEP                                                    0x40000
#define MASK_PMU_APB_AP_FORCE_DEEP_SLEEP                                                    0x10000
#define MASK_PMU_APB_PD_WCN_GNSS_DEEP_SLEEP                                                 0x100
#define MASK_PMU_APB_PD_WCN_WIFI_DEEP_SLEEP                                                 0x80
#define MASK_PMU_APB_CP_DEEP_SLEEP                                                          0x4
#define MASK_PMU_APB_AP_DEEP_SLEEP                                                          0x1
#define MASK_PMU_APB_BUSY_TRANSFER_HWDATA_SEL                                               0x10000
#define MASK_PMU_APB_DDR_PUBL_APB_SOFT_RST                                                  0x1000
#define MASK_PMU_APB_DDR_UMCTL_APB_SOFT_RST                                                 0x800
#define MASK_PMU_APB_DDR_PUBL_SOFT_RST                                                      0x400
#define MASK_PMU_APB_DDR_PHY_SOFT_RST                                                       0x100
#define MASK_PMU_APB_DDR_PHY_AUTO_GATE_EN                                                   0x40
#define MASK_PMU_APB_DDR_PUBL_AUTO_GATE_EN                                                  0x20
#define MASK_PMU_APB_DDR_UMCTL_AUTO_GATE_EN                                                 0x10
#define MASK_PMU_APB_DDR_PHY_EB                                                             0x4
#define MASK_PMU_APB_DDR_UMCTL_EB                                                           0x2
#define MASK_PMU_APB_DDR_PUBL_EB                                                            0x1
#define MASK_PMU_APB_CM4_SLP_STATUS                                                         0xf00000
#define MASK_PMU_APB_WCN_SLP_STATUS                                                         0xf000
#define MASK_PMU_APB_CP_SLP_STATUS                                                          0xf00
#define MASK_PMU_APB_AP_SLP_STATUS                                                          0xf
#define MASK_PMU_APB_CA7_L2RSTDISABLE                                                       0x1
#define MASK_PMU_APB_CA7_VINITHI_C0                                                         0x1
#define MASK_PMU_APB_CA7_VINITHI_C1                                                         0x1
#define MASK_PMU_APB_CA7_VINITHI_C2                                                         0x1
#define MASK_PMU_APB_CA7_VINITHI_C3                                                         0x1
#define MASK_PMU_APB_DDR_CTRL_AXI_LP_EN                                                     0x80000000
#define MASK_PMU_APB_DDR_CTRL_CGM_SEL                                                       0x40000000
#define MASK_PMU_APB_DDR_OPERATE_MODE_BUSY                                                  0x10000000
#define MASK_PMU_APB_DDR_PUBL_RET_EN                                                        0x8000000
#define MASK_PMU_APB_DDR_PHY_ISO_RST_EN                                                     0x4000000
#define MASK_PMU_APB_DDR_UMCTL_RET_EN                                                       0x2000000
#define MASK_PMU_APB_DDR_PHY_AUTO_RET_EN                                                    0x1000000
#define MASK_PMU_APB_DDR_OPERATE_MODE_CNT_LMT                                               0xff0000
#define MASK_PMU_APB_DDR_OPERATE_MODE                                                       0x700
#define MASK_PMU_APB_DDR_OPERATE_MODE_IDLE                                                  0x7
#define MASK_PMU_APB_DDR_UMCTL_SOFT_RST                                                     0x10000
#define MASK_PMU_APB_DDR_PHY_CKE_RET_EN                                                     0x1
#define MASK_PMU_APB_PD_AON_MEM_BISR_DONE                                                   0x40000
#define MASK_PMU_APB_PD_CP_SYS_BISR_DONE                                                    0x20000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_DONE                                             0x4000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_DONE                                               0x2000
#define MASK_PMU_APB_PD_PUB_TOP_BISR_DONE                                                   0x800
#define MASK_PMU_APB_PD_WCN_TOP_BISR_DONE                                                   0x400
#define MASK_PMU_APB_PD_WCN_WIFI_BISR_DONE                                                  0x200
#define MASK_PMU_APB_PD_WCN_GNSS_BISR_DONE                                                  0x100
#define MASK_PMU_APB_PD_MM_TOP_BISR_DONE                                                    0x80
#define MASK_PMU_APB_PD_GPU_TOP_BISR_DONE                                                   0x40
#define MASK_PMU_APB_PD_AP_SYS_BISR_DONE                                                    0x20
#define MASK_PMU_APB_PD_CA7_TOP_BISR_DONE                                                   0x10
#define MASK_PMU_APB_PD_CA7_C3_BISR_DONE                                                    0x8
#define MASK_PMU_APB_PD_CA7_C2_BISR_DONE                                                    0x4
#define MASK_PMU_APB_PD_CA7_C1_BISR_DONE                                                    0x2
#define MASK_PMU_APB_PD_CA7_C0_BISR_DONE                                                    0x1
#define MASK_PMU_APB_PD_AON_MEM_BISR_BUSY                                                   0x40000
#define MASK_PMU_APB_PD_CP_SYS_BISR_BUSY                                                    0x20000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_BUSY                                             0x4000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_BUSY                                               0x2000
#define MASK_PMU_APB_PD_PUB_TOP_BISR_BUSY                                                   0x800
#define MASK_PMU_APB_PD_WCN_TOP_BISR_BUSY                                                   0x400
#define MASK_PMU_APB_PD_WCN_WIFI_BISR_BUSY                                                  0x200
#define MASK_PMU_APB_PD_WCN_GNSS_BISR_BUSY                                                  0x100
#define MASK_PMU_APB_PD_MM_TOP_BISR_BUSY                                                    0x80
#define MASK_PMU_APB_PD_GPU_TOP_BISR_BUSY                                                   0x40
#define MASK_PMU_APB_PD_AP_SYS_BISR_BUSY                                                    0x20
#define MASK_PMU_APB_PD_CA7_TOP_BISR_BUSY                                                   0x10
#define MASK_PMU_APB_PD_CA7_C3_BISR_BUSY                                                    0x8
#define MASK_PMU_APB_PD_CA7_C2_BISR_BUSY                                                    0x4
#define MASK_PMU_APB_PD_CA7_C1_BISR_BUSY                                                    0x2
#define MASK_PMU_APB_PD_CA7_C0_BISR_BUSY                                                    0x1
#define MASK_PMU_APB_PD_AON_MEM_BISR_FORCE_BYP                                              0x40000
#define MASK_PMU_APB_PD_CP_SYS_BISR_FORCE_BYP                                               0x20000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_FORCE_BYP                                        0x4000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_FORCE_BYP                                          0x2000
#define MASK_PMU_APB_PD_PUB_SYS_BISR_FORCE_BYP                                              0x800
#define MASK_PMU_APB_PD_WCN_TOP_BISR_FORCE_BYP                                              0x400
#define MASK_PMU_APB_PD_WCN_WIFI_BISR_FORCE_BYP                                             0x200
#define MASK_PMU_APB_PD_WCN_GNSS_BISR_FORCE_BYP                                             0x100
#define MASK_PMU_APB_PD_MM_TOP_BISR_FORCE_BYP                                               0x80
#define MASK_PMU_APB_PD_GPU_TOP_BISR_FORCE_BYP                                              0x40
#define MASK_PMU_APB_PD_AP_SYS_BISR_FORCE_BYP                                               0x20
#define MASK_PMU_APB_PD_CA7_TOP_BISR_FORCE_BYP                                              0x10
#define MASK_PMU_APB_PD_CA7_C3_BISR_FORCE_BYP                                               0x8
#define MASK_PMU_APB_PD_CA7_C2_BISR_FORCE_BYP                                               0x4
#define MASK_PMU_APB_PD_CA7_C1_BISR_FORCE_BYP                                               0x2
#define MASK_PMU_APB_PD_CA7_C0_BISR_FORCE_BYP                                               0x1
#define MASK_PMU_APB_PD_AON_MEM_BISR_FORCE_EN                                               0x40000
#define MASK_PMU_APB_PD_CP_SYS_BISR_FORCE_EN                                                0x20000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_FORCE_EN                                         0x4000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_FORCE_EN                                           0x2000
#define MASK_PMU_APB_PD_PUB_SYS_BISR_FORCE_EN                                               0x800
#define MASK_PMU_APB_PD_WCN_TOP_BISR_FORCE_EN                                               0x400
#define MASK_PMU_APB_PD_WCN_WIFI_BISR_FORCE_EN                                              0x200
#define MASK_PMU_APB_PD_WCN_GNSS_BISR_FORCE_EN                                              0x100
#define MASK_PMU_APB_PD_MM_TOP_BISR_FORCE_EN                                                0x80
#define MASK_PMU_APB_PD_GPU_TOP_BISR_FORCE_EN                                               0x40
#define MASK_PMU_APB_PD_AP_SYS_BISR_FORCE_EN                                                0x20
#define MASK_PMU_APB_PD_CA7_TOP_BISR_FORCE_EN                                               0x10
#define MASK_PMU_APB_PD_CA7_C3_BISR_FORCE_EN                                                0x8
#define MASK_PMU_APB_PD_CA7_C2_BISR_FORCE_EN                                                0x4
#define MASK_PMU_APB_PD_CA7_C1_BISR_FORCE_EN                                                0x2
#define MASK_PMU_APB_PD_CA7_C0_BISR_FORCE_EN                                                0x1
#define MASK_PMU_APB_CGM_AUTO_GATE_SEL_CFG0                                                 0xffffffff
#define MASK_PMU_APB_CGM_AUTO_GATE_SEL_CFG1                                                 0xffffffff
#define MASK_PMU_APB_CGM_AUTO_GATE_SEL_CFG2                                                 0xffffffff
#define MASK_PMU_APB_CGM_AUTO_GATE_SEL_CFG3                                                 0xffffffff
#define MASK_PMU_APB_CGM_FORCE_EN_CFG0                                                      0xffffffff
#define MASK_PMU_APB_CGM_FORCE_EN_CFG1                                                      0xffffffff
#define MASK_PMU_APB_CGM_FORCE_EN_CFG2                                                      0xffffffff
#define MASK_PMU_APB_CGM_FORCE_EN_CFG3                                                      0xffffffff
#define MASK_PMU_APB_CM4_SLEEP_XTL_ON                                                       0x20
#define MASK_PMU_APB_PUBCP_SLEEP_XTL_ON                                                     0x8
#define MASK_PMU_APB_WCN_SLEEP_XTL_ON                                                       0x4
#define MASK_PMU_APB_WTLCP_SLEEP_XTL_ON                                                     0x2
#define MASK_PMU_APB_AP_SLEEP_XTL_ON                                                        0x1
#define MASK_PMU_APB_MEM_SLP_CFG                                                            0xfffff
#define MASK_PMU_APB_MEM_SD_CFG                                                             0xfffff
#define MASK_PMU_APB_CA7_C3_GIC_WAKEUP_EN                                                   0x800
#define MASK_PMU_APB_CA7_C2_GIC_WAKEUP_EN                                                   0x400
#define MASK_PMU_APB_CA7_C1_GIC_WAKEUP_EN                                                   0x200
#define MASK_PMU_APB_CA7_C0_GIC_WAKEUP_EN                                                   0x100
#define MASK_PMU_APB_CP_PWR_WAIT_CNT                                                        0xff0000
#define MASK_PMU_APB_WCN_PWR_WAIT_CNT                                                       0xff00
#define MASK_PMU_APB_AP_PWR_WAIT_CNT                                                        0xff
#define MASK_PMU_APB_CM4_PWR_WAIT_CNT                                                       0xff00
#define MASK_PMU_APB_MEM_AUTO_SLP_EN                                                        0xfffff
#define MASK_PMU_APB_MEM_AUTO_SD_EN                                                         0xfffff
#define MASK_PMU_APB_PUBCP_SYS_WAKEUP_LOCK_EN                                               0x2000000
#define MASK_PMU_APB_WTLCP_SYS_WAKEUP_LOCK_EN                                               0x1000000
#define MASK_PMU_APB_AP_SYS_WAKEUP_LOCK_EN                                                  0x400000
#define MASK_PMU_APB_PD_PUB_SYS_WAKEUP_LOCK_EN                                              0x200000
#define MASK_PMU_APB_PD_CP_SYS_WAKEUP_LOCK_EN                                               0x20000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_WAKEUP_LOCK_EN                                        0x4000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_WAKEUP_LOCK_EN                                          0x2000
#define MASK_PMU_APB_PD_WCN_TOP_WAKEUP_LOCK_EN                                              0x400
#define MASK_PMU_APB_PD_WCN_WIFI_WAKEUP_LOCK_EN                                             0x200
#define MASK_PMU_APB_PD_WCN_GNSS_WAKEUP_LOCK_EN                                             0x100
#define MASK_PMU_APB_PD_MM_TOP_WAKEUP_LOCK_EN                                               0x80
#define MASK_PMU_APB_PD_GPU_TOP_WAKEUP_LOCK_EN                                              0x40
#define MASK_PMU_APB_PD_AP_SYS_WAKEUP_LOCK_EN                                               0x20
#define MASK_PMU_APB_PD_CA7_TOP_WAKEUP_LOCK_EN                                              0x10
#define MASK_PMU_APB_PD_CA7_C3_WAKEUP_LOCK_EN                                               0x8
#define MASK_PMU_APB_PD_CA7_C2_WAKEUP_LOCK_EN                                               0x4
#define MASK_PMU_APB_PD_CA7_C1_WAKEUP_LOCK_EN                                               0x2
#define MASK_PMU_APB_PD_CA7_C0_WAKEUP_LOCK_EN                                               0x1
#define MASK_PMU_APB_WTLCP_TGDSP_CORE_INT_DISABLE_FRC                                       0x1
#define MASK_PMU_APB_CP_SYS_INT_DISABLE_FRC                                                 0x1
#define MASK_PMU_APB_CA7_C0_CORE_INT_DISABLE                                                0x1
#define MASK_PMU_APB_CA7_C1_CORE_INT_DISABLE                                                0x1
#define MASK_PMU_APB_CA7_C2_CORE_INT_DISABLE                                                0x1
#define MASK_PMU_APB_CA7_C3_CORE_INT_DISABLE                                                0x1
#define MASK_PMU_APB_AON_CM4_INT_DISABLE                                                    0x1
#define MASK_PMU_APB_WTLCP_TGDSP_DSLP_ENA                                                   0x1
#define MASK_PMU_APB_AP_DSLP_ENA                                                            0x1
#define MASK_PMU_APB_PUBCP_DSLP_ENA                                                         0x2
#define MASK_PMU_APB_WTLCP_DSLP_ENA                                                         0x1
#define MASK_PMU_APB_CA7_TOP_DSLP_ENA                                                       0x1
#define MASK_PMU_APB_CM4_DSLP_ENA                                                           0x1
#define MASK_PMU_APB_PUBCP_INT_DISABLE                                                      0x1
#define MASK_PMU_APB_WTLCP_INT_DISABLE                                                      0x1
#define MASK_PMU_APB_DMA_CHN3_LSLP_ENA                                                      0x40000
#define MASK_PMU_APB_DMA_CHN1_LSLP_ENA                                                      0x20000
#define MASK_PMU_APB_DMA_CHNALL_LSLP_ENA                                                    0x10000
#define MASK_PMU_APB_AON_DMA_LSLP_ENA                                                       0x8
#define MASK_PMU_APB_CM4_LIGHT_SLEEP                                                        0x1
#define MASK_PMU_APB_WTLCP_DOZE_SLEEP_ENA                                                   0x4
#define MASK_PMU_APB_PUBCP_DOZE_SLEEP_ENA                                                   0x2
#define MASK_PMU_APB_AP_DOZE_SLEEP_ENA                                                      0x1
#define MASK_PMU_APB_PUB_ACC_RDY                                                            0x1
#define MASK_PMU_APB_PUB_CLK_RDY                                                            0x1
#define MASK_PMU_APB_EIC_WCN_SEL                                                            0x4
#define MASK_PMU_APB_EIC_WCN_DEEP_SLEEP_SEL                                                 0x2
#define MASK_PMU_APB_EIC_DEEP_SLEEP_SEL                                                     0x1
#define MASK_PMU_APB_AXI_LP_CTRL_DISABLE                                                    0x1
#define MASK_PMU_APB_PMU_DEBUG                                                              0xffff
#define MASK_PMU_APB_WTLCP_DOZE_SLEEP_CNT_CLR                                               0x800
#define MASK_PMU_APB_PUBCP_DOZE_SLEEP_CNT_CLR                                               0x400
#define MASK_PMU_APB_AP_DOZE_SLEEP_CNT_CLR                                                  0x200
#define MASK_PMU_APB_CM4_DEEP_SLEEP_CNT_CLR                                                 0x100
#define MASK_PMU_APB_PUB_DEEP_SLEEP_CNT_CLR                                                 0x80
#define MASK_PMU_APB_CP_DEEP_SLEEP_CNT_CLR                                                  0x40
#define MASK_PMU_APB_AP_DEEP_SLEEP_CNT_CLR                                                  0x10
#define MASK_PMU_APB_PAD_OUT_XTL_EN_POL_SEL                                                 0x40000000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_POL_SEL                                             0x20000000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_POL_SEL                                             0x10000000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_PLL_PD_MASK                                         0x4000000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_CM4_RAM_XTL_PD_MASK                                 0x2000000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_AON_RAM_XTL_PD_MASK                                 0x1000000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_XTLBUF0_PD_MASK                                     0x800000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_XTL0_PD_MASK                                        0x400000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_EXT_XTL_PD_MASK                                     0x200000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_CM4_DEEP_SLEEP_MASK                                 0x100000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_CA7_TOP_PD_MASK                                     0x80000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_WCN_DEEP_SLEEP_MASK                                 0x40000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_CP_DEEP_SLEEP_MASK                                  0x20000
#define MASK_PMU_APB_DCXO_LC_DEEP_SLEEP_AP_DEEP_SLEEP_MASK                                  0x10000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_PUB_PD_MASK                                         0x8000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_PLL_PD_MASK                                         0x4000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_CM4_RAM_XTL_PD_MASK                                 0x2000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_AON_RAM_XTL_PD_MASK                                 0x1000
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_XTLBUF0_PD_MASK                                     0x800
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_XTL0_PD_MASK                                        0x400
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_EXT_XTL_PD_MASK                                     0x200
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_CM4_DEEP_SLEEP_MASK                                 0x100
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_CA7_TOP_PD_MASK                                     0x80
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_WCN_DEEP_SLEEP_MASK                                 0x40
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_PUBCP_DEEP_SLEEP_MASK                               0x20
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_AP_DEEP_SLEEP_MASK                                  0x10
#define MASK_PMU_APB_PAD_OUT_CHIP_SLEEP_WTLCP_DEEP_SLEEP_MASK                               0x8
#define MASK_PMU_APB_EXT_XTL1_COMB_EN                                                       0x2
#define MASK_PMU_APB_EXT_XTL0_COMB_EN                                                       0x1
#define MASK_PMU_APB_PD_AON_MEM_BISR_FORCE_SEL                                              0x40000
#define MASK_PMU_APB_PD_CP_SYS_BISR_FORCE_SEL                                               0x20000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_BISR_FORCE_SEL                                        0x4000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_BISR_FORCE_SEL                                          0x2000
#define MASK_PMU_APB_PD_PUB_SYS_BISR_FORCE_SEL                                              0x800
#define MASK_PMU_APB_PD_WCN_TOP_BISR_FORCE_SEL                                              0x400
#define MASK_PMU_APB_PD_WCN_WIFI_BISR_FORCE_SEL                                             0x200
#define MASK_PMU_APB_PD_WCN_GNSS_BISR_FORCE_SEL                                             0x100
#define MASK_PMU_APB_PD_MM_TOP_BISR_FORCE_SEL                                               0x80
#define MASK_PMU_APB_PD_GPU_TOP_BISR_FORCE_SEL                                              0x40
#define MASK_PMU_APB_PD_AP_SYS_BISR_FORCE_SEL                                               0x20
#define MASK_PMU_APB_PD_CA7_TOP_BISR_FORCE_SEL                                              0x10
#define MASK_PMU_APB_PD_CA7_C3_BISR_FORCE_SEL                                               0x8
#define MASK_PMU_APB_PD_CA7_C2_BISR_FORCE_SEL                                               0x4
#define MASK_PMU_APB_PD_CA7_C1_BISR_FORCE_SEL                                               0x2
#define MASK_PMU_APB_PD_CA7_C0_BISR_FORCE_SEL                                               0x1
#define MASK_PMU_APB_WCN_MEM_SEL                                                            0x8
#define MASK_PMU_APB_DIG_MEM_ALL_SEL                                                        0x4
#define MASK_PMU_APB_CM4_MEM_ALL_SEL                                                        0x2
#define MASK_PMU_APB_AON_MEM_CM4_SEL                                                        0x1
#define MASK_PMU_APB_INT_REQ_PWR_DOWN_CLR                                                   0x3ff0000
#define MASK_PMU_APB_INT_REQ_PWR_UP_CLR                                                     0x3ff
#define MASK_PMU_APB_WCN_GNSS_WRAP_DEEP_STOP                                                0x200000
#define MASK_PMU_APB_WCN_WIFI_WRAP_DEEP_STOP                                                0x100000
#define MASK_PMU_APB_WCN_TOP_DDR_WAKE_UP_N                                                  0x80000
#define MASK_PMU_APB_WCN_EXTCK_CLKOUT_EN                                                    0x40000
#define MASK_PMU_APB_WCN_TOP_XTL_STOP                                                       0x20000
#define MASK_PMU_APB_WCN_TOP_DEEP_STOP                                                      0x10000
#define MASK_PMU_APB_WCN_XTL_SOFT_CNT_DONE                                                  0x2000
#define MASK_PMU_APB_WCN_PLL_SOFT_CNT_DONE                                                  0x1000
#define MASK_PMU_APB_WCN_XTL_PLL_FORCE_DOWN                                                 0x800
#define MASK_PMU_APB_WCN_XTL_CNT_SEL                                                        0x100
#define MASK_PMU_APB_WCN_PLL_CNT_SEL                                                        0x80
#define MASK_PMU_APB_WCN_XTL_AUTO_EN                                                        0x40
#define MASK_PMU_APB_WCN_PLL_AUTO_EN                                                        0x20
#define MASK_PMU_APB_WCN_XTL_AUTO_SEL                                                       0x10
#define MASK_PMU_APB_WCN_DEEP_STOP_AUTO_EN                                                  0x8
#define MASK_PMU_APB_WCN_PLL_PD_EN                                                          0x4
#define MASK_PMU_APB_WCN_GNSS_SYS_EN                                                        0x2
#define MASK_PMU_APB_WCN_BTWF_SYS_EN                                                        0x1
#define MASK_PMU_APB_EXT_XTLBUF_MASK                                                        0x2
#define MASK_PMU_APB_XTLBUF_MASK                                                            0x1
#define MASK_PMU_APB_PUB_PLL_AUTO_PD_EN4                                                    0x40
#define MASK_PMU_APB_PUB_PLL_AUTO_PD_EN3                                                    0x20
#define MASK_PMU_APB_PUB_PLL_AUTO_PD_EN2                                                    0x10
#define MASK_PMU_APB_PUB_PLL_AUTO_PD_EN1                                                    0x8
#define MASK_PMU_APB_PUB_PLL_AUTO_PD_EN0                                                    0x4
#define MASK_PMU_APB_PUB_PLL_FORCE_DOWN                                                     0x2
#define MASK_PMU_APB_PUB_PLL_AUTO_PD_EN                                                     0x1
#define MASK_PMU_APB_BBPLL2_PUBCP_SEL                                                       0x80
#define MASK_PMU_APB_BBPLL1_PUBCP_SEL                                                       0x40
#define MASK_PMU_APB_BBPLL2_CM4_SEL                                                         0x20
#define MASK_PMU_APB_BBPLL1_CM4_SEL                                                         0x10
#define MASK_PMU_APB_BBPLL2_AP_SEL                                                          0x8
#define MASK_PMU_APB_BBPLL1_AP_SEL                                                          0x4
#define MASK_PMU_APB_BBPLL2_WTLCP_SEL                                                       0x2
#define MASK_PMU_APB_BBPLL1_WTLCP_SEL                                                       0x1
#define MASK_PMU_APB_WTLCP_CG_FORCE_OFF                                                     0x40
#define MASK_PMU_APB_WTLCP_CG_WITH_SLP_ENA                                                  0x20
#define MASK_PMU_APB_WTLCP_CG_AUTO_SEL                                                      0x10
#define MASK_PMU_APB_PUBCP_CG_FORCE_OFF                                                     0x4
#define MASK_PMU_APB_PUBCP_CG_WITH_SLP_ENA                                                  0x2
#define MASK_PMU_APB_PUBCP_CG_AUTO_SEL                                                      0x1
#define MASK_PMU_APB_WCN_WIFI_DSLP_ENA                                                      0x1
#define MASK_PMU_APB_WCN_GNSS_DSLP_ENA                                                      0x1
#define MASK_PMU_APB_EFUSE_SELECT_BUF_EN                                                    0x1
#define MASK_PMU_APB_SELECT_BUF_WCN_WIFI_CLR                                                0x800
#define MASK_PMU_APB_SELECT_BUF_WCN_GNSS_CLR                                                0x400
#define MASK_PMU_APB_SELECT_BUF_WCN_TOP_CLR                                                 0x200
#define MASK_PMU_APB_SELECT_BUF_PUB_TOP_CLR                                                 0x100
#define MASK_PMU_APB_SELECT_BUF_WTLCP_HU3GE_A_CLR                                           0x80
#define MASK_PMU_APB_SELECT_BUF_WTLCP_TGDSP_CLR                                             0x40
#define MASK_PMU_APB_SELECT_BUF_GPU_TOP_CLR                                                 0x20
#define MASK_PMU_APB_SELECT_BUF_MM_TOP_CLR                                                  0x10
#define MASK_PMU_APB_SELECT_BUF_CP_SYS_CLR                                                  0x8
#define MASK_PMU_APB_SELECT_BUF_CA7_TOP_CLR                                                 0x4
#define MASK_PMU_APB_SELECT_BUF_AP_SYS_CLR                                                  0x2
#define MASK_PMU_APB_SELECT_BUF_AON_CLR                                                     0x1
#define MASK_PMU_APB_SELECT_BUF_WCN_WIFI                                                    0x800
#define MASK_PMU_APB_SELECT_BUF_WCN_GNSS                                                    0x400
#define MASK_PMU_APB_SELECT_BUF_WCN_TOP                                                     0x200
#define MASK_PMU_APB_SELECT_BUF_PUB_TOP                                                     0x100
#define MASK_PMU_APB_SELECT_BUF_WTLCP_HU3GE_A                                               0x80
#define MASK_PMU_APB_SELECT_BUF_WTLCP_TGDSP                                                 0x40
#define MASK_PMU_APB_SELECT_BUF_GPU_TOP                                                     0x20
#define MASK_PMU_APB_SELECT_BUF_MM_TOP                                                      0x10
#define MASK_PMU_APB_SELECT_BUF_CP_SYS                                                      0x8
#define MASK_PMU_APB_SELECT_BUF_CA7_TOP                                                     0x4
#define MASK_PMU_APB_SELECT_BUF_AP_SYS                                                      0x2
#define MASK_PMU_APB_SELECT_BUF_AON                                                         0x1
#define MASK_PMU_APB_AON_APB_PROTECT_TWPLL_CNT_EN                                           0x8
#define MASK_PMU_APB_AON_APB_PROTECT_CPLL_DISABLE                                           0x4
#define MASK_PMU_APB_AON_APB_PROTECT_EN                                                     0x2
#define MASK_PMU_APB_CGM_PMU_SEL_REG                                                        0x1
#define MASK_PMU_APB_CGM_OFF_DLY                                                            0xff000000
#define MASK_PMU_APB_CGM_ON_DLY                                                             0xff0000
#define MASK_PMU_APB_ISO_OFF_DLY                                                            0xff00
#define MASK_PMU_APB_RST_ASSERT_DLY                                                         0xff
#define MASK_PMU_APB_WAKEUP_LOCK_DLY                                                        0xff000000
#define MASK_PMU_APB_RESTORE_DLY                                                            0xff0000
#define MASK_PMU_APB_SHUTDOWN_DLY                                                           0xff00
#define MASK_PMU_APB_BISR_RST_DLY                                                           0xff
#define MASK_PMU_APB_PWR_ST_CLK_DIV_CFG                                                     0x3ff
#define MASK_PMU_APB_SLP_CTRL_CLK_DIV_CFG                                                   0x3ff
#define MASK_PMU_APB_AP_PUB_DSLP_EN                                                         0xff000000
#define MASK_PMU_APB_PUBCP_PUB_DSLP_EN                                                      0xff0000
#define MASK_PMU_APB_WTLCP_PUB_DSLP_EN                                                      0xff00
#define MASK_PMU_APB_WCN_PUB_DSLP_EN0                                                       0xff
#define MASK_PMU_APB_WCN_PUB_DSLP_EN1                                                       0xff
#define MASK_PMU_APB_PUB_DSLP_EN                                                            0x1
#define MASK_PMU_APB_BBPLL1_CNT_DONE                                                        0x20
#define MASK_PMU_APB_BBPLL2_CNT_DONE                                                        0x10
#define MASK_PMU_APB_CPLL_CNT_DONE                                                          0x8
#define MASK_PMU_APB_TWPLL_CNT_DONE                                                         0x4
#define MASK_PMU_APB_DPLL_CNT_DONE                                                          0x2
#define MASK_PMU_APB_MPLL_CNT_DONE                                                          0x1
#define MASK_PMU_APB_BBPLL2_PD_REG                                                          0x20
#define MASK_PMU_APB_BBPLL1_PD_REG                                                          0x10
#define MASK_PMU_APB_XTL_PD_REG                                                             0x8
#define MASK_PMU_APB_CGM_26M_WCN_EN                                                         0x4
#define MASK_PMU_APB_CGM_26M_CP_EN                                                          0x2
#define MASK_PMU_APB_CGM_26M_AP_EN                                                          0x1
#define MASK_PMU_APB_BBPLL2_PD_SEL                                                          0x20
#define MASK_PMU_APB_BBPLL1_PD_SEL                                                          0x10
#define MASK_PMU_APB_XTL_SEL                                                                0x8
#define MASK_PMU_APB_CGM_26M_WCN_SEL                                                        0x4
#define MASK_PMU_APB_CGM_26M_CP_SEL                                                         0x2
#define MASK_PMU_APB_CGM_26M_AP_SEL                                                         0x1
#define MASK_PMU_APB_CA7_VINITHI_RST_DISABLE                                                0x1
#define MASK_PMU_APB_PD_PUB_SYS_ACK_M                                                       0x20000000
#define MASK_PMU_APB_PD_PUB_SYS_ACK_D                                                       0x10000000
#define MASK_PMU_APB_PD_WCN_GNSS_ACK_M                                                      0x8000000
#define MASK_PMU_APB_PD_WCN_GNSS_ACK_D                                                      0x4000000
#define MASK_PMU_APB_PD_WCN_WIFI_ACK_M                                                      0x2000000
#define MASK_PMU_APB_PD_WCN_WIFI_ACK_D                                                      0x1000000
#define MASK_PMU_APB_PD_WCN_TOP_ACK_M                                                       0x800000
#define MASK_PMU_APB_PD_WCN_TOP_ACK_D                                                       0x400000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_ACK_M                                                   0x200000
#define MASK_PMU_APB_PD_WTLCP_TGDSP_ACK_D                                                   0x100000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_ACK_M                                                 0x80000
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_ACK_D                                                 0x40000
#define MASK_PMU_APB_PD_MM_TOP_ACK_M                                                        0x20000
#define MASK_PMU_APB_PD_MM_TOP_ACK_D                                                        0x10000
#define MASK_PMU_APB_PD_GPU_TOP_ACK_M                                                       0x8000
#define MASK_PMU_APB_PD_GPU_TOP_ACK_D                                                       0x4000
#define MASK_PMU_APB_PD_CP_SYS_ACK_M                                                        0x2000
#define MASK_PMU_APB_PD_CP_SYS_ACK_D                                                        0x1000
#define MASK_PMU_APB_PD_AP_SYS_ACK_M                                                        0x800
#define MASK_PMU_APB_PD_AP_SYS_ACK_D                                                        0x400
#define MASK_PMU_APB_PD_CA7_C3_ACK_M                                                        0x200
#define MASK_PMU_APB_PD_CA7_C3_ACK_D                                                        0x100
#define MASK_PMU_APB_PD_CA7_C2_ACK_M                                                        0x80
#define MASK_PMU_APB_PD_CA7_C2_ACK_D                                                        0x40
#define MASK_PMU_APB_PD_CA7_C1_ACK_M                                                        0x20
#define MASK_PMU_APB_PD_CA7_C1_ACK_D                                                        0x10
#define MASK_PMU_APB_PD_CA7_C0_ACK_M                                                        0x8
#define MASK_PMU_APB_PD_CA7_C0_ACK_D                                                        0x4
#define MASK_PMU_APB_PD_CA7_TOP_ACK_M                                                       0x2
#define MASK_PMU_APB_PD_CA7_TOP_ACK_D                                                       0x1
#define MASK_PMU_APB_PD_CA7_C0_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_CA7_C1_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_CA7_C2_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_CA7_C3_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_CA7_TOP_SHUTDOWN_MARK                                               0xf
#define MASK_PMU_APB_PD_AP_SYS_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_GPU_TOP_SHUTDOWN_MARK                                               0xf
#define MASK_PMU_APB_PD_MM_TOP_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_WTLCP_TGDSP_SHUTDOWN_MARK                                           0xf
#define MASK_PMU_APB_PD_WTLCP_HU3GE_A_SHUTDOWN_MARK                                         0xf
#define MASK_PMU_APB_PD_CP_SYS_SHUTDOWN_MARK                                                0xf
#define MASK_PMU_APB_PD_PUB_SYS_SHUTDOWN_MARK                                               0xf
#define MASK_PMU_APB_PD_WCN_TOP_SHUTDOWN_MARK                                               0xf
#define MASK_PMU_APB_PD_WCN_WIFI_SHUTDOWN_MARK                                              0xf
#define MASK_PMU_APB_PD_WCN_GNSS_SHUTDOWN_MARK                                              0xf
#define MASK_PMU_APB_PMU_DUMMY1                                                             0xffffffff
#define MASK_PMU_APB_PMU_DUMMY2                                                             0xffffffff
#define MASK_PMU_APB_PMU_DUMMY3                                                             0xffffffff
#define MASK_PMU_APB_PMU_DUMMY4                                                             0xffffffff
#define MASK_PMU_APB_PMU_DUMMY5                                                             0xffffffff
#define MASK_PMU_APB_PMU_DUMMY6                                                             0xffffffff
#define MASK_SERDES_APB_FUNC_EN_FUNC_EN                                                     0x1
#define MASK_SERDES_APB_CH_EN_CH_EN                                                         0xffff
#define MASK_SERDES_APB_FUNNEL_EN_FUNNEL_EN                                                 0x1
#define MASK_SERDES_APB_FUNNEL_OVERFLOW_FUNNEL_OVERFLOW                                     0x1
#define MASK_SERDES_APB_FSM_CUT_OFF_LEN_FSM_CUT_OFF                                         0xffff
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TESTCLK                                         0x1000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TESTDATAIN                                      0xff0000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TESTADDR                                        0xf000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TESTDATAOUTSEL                                  0x800
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TESTDATAOUT                                     0x780
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BIST_MODE                                       0x7c
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_T2RCOMP                                         0x2
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_LPBK_END                                        0x1
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_DATABUS16_8                                     0x10000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_SUSPENDM                                        0x8000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_PORN                                            0x4000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_RESET                                           0x2000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_RXERROR                                         0x1000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_DRV_DP                                   0x800000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_DRV_DM                                   0x400000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_FS                                       0x200000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_IN_DP                                    0x100000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_IN_DM                                    0x80000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_OUT_DP                                   0x40000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BYPASS_OUT_DM                                   0x20000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_VBUSVLDEXT                                      0x10000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_RESERVED                                        0xffff
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_PS_PD_S                                         0x20
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_PS_PD_L                                         0x10
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_REXTENABLE                                      0x8
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_DMPULLUP                                        0x4
#define MASK_ANLG_PHY_G2_ANALOG_USB20_HSIC_PLLON                                            0x2
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_SAMPLER_SEL                                     0x1
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNEHSAMP                                       0x18000000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TFREGRES                                        0x7e00000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TFHSRES                                         0x1f0000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNERISE                                        0xc000
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNEOTG                                         0x3800
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNEDSC                                         0x600
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNESQ                                          0x1e0
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNEEQ                                          0x1c
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_TUNEPLLS                                        0x3
#define MASK_ANLG_PHY_G2_ANALOG_USB20_USB20_BIST_MODE_EN                                    0x1
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TESTCLK                                 0x40000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TESTDATAIN                              0x20000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TESTADDR                                0x10000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TESTDATAOUTSEL                          0x8000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_BIST_MODE                               0x4000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_DATABUS16_8                             0x2000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_SUSPENDM                                0x1000000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_PORN                                    0x800000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_RESET                                   0x400000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_BYPASS_DRV_DP                           0x200000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_BYPASS_DRV_DM                           0x100000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_BYPASS_FS                               0x80000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_BYPASS_IN_DP                            0x40000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_BYPASS_IN_DM                            0x20000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_VBUSVLDEXT                              0x10000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_RESERVED                                0x8000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_PS_PD_S                                 0x4000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_PS_PD_L                                 0x2000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_REXTENABLE                              0x1000
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_DMPULLUP                                0x800
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_HSIC_PLLON                                    0x400
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_SAMPLER_SEL                             0x200
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNEHSAMP                               0x100
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TFREGRES                                0x80
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TFHSRES                                 0x40
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNERISE                                0x20
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNEOTG                                 0x10
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNEDSC                                 0x8
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNESQ                                  0x4
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNEEQ                                  0x2
#define MASK_ANLG_PHY_G2_DBG_SEL_ANALOG_USB20_USB20_TUNEPLLS                                0x1
#define MASK_PUB_APB_PUB_BUSMON_CNT_START                                                   0x1
#define MASK_PUB_APB_PUB_BUSMON6_EB                                                         0x400000
#define MASK_PUB_APB_PUB_BUSMON5_EB                                                         0x200000
#define MASK_PUB_APB_PUB_BUSMON4_EB                                                         0x100000
#define MASK_PUB_APB_PUB_BUSMON3_EB                                                         0x80000
#define MASK_PUB_APB_PUB_BUSMON2_EB                                                         0x40000
#define MASK_PUB_APB_PUB_BUSMON1_EB                                                         0x20000
#define MASK_PUB_APB_PUB_BUSMON0_EB                                                         0x10000
#define MASK_PUB_APB_PUB_BUSMON6_SOFT_RST                                                   0x40
#define MASK_PUB_APB_PUB_BUSMON5_SOFT_RST                                                   0x20
#define MASK_PUB_APB_PUB_BUSMON4_SOFT_RST                                                   0x10
#define MASK_PUB_APB_PUB_BUSMON3_SOFT_RST                                                   0x8
#define MASK_PUB_APB_PUB_BUSMON2_SOFT_RST                                                   0x4
#define MASK_PUB_APB_PUB_BUSMON1_SOFT_RST                                                   0x2
#define MASK_PUB_APB_PUB_BUSMON0_SOFT_RST                                                   0x1
#define MASK_PUB_APB_MAIN_LP_FORCE                                                          0x20000
#define MASK_PUB_APB_MAIN_LP_EB                                                             0x10000
#define MASK_PUB_APB_MAIN_LP_NUM                                                            0xffff
#define MASK_PUB_APB_GPV_LP_FORCE                                                           0x20000
#define MASK_PUB_APB_GPV_LP_EB                                                              0x10000
#define MASK_PUB_APB_GPV_LP_NUM                                                             0xffff
#define MASK_PUB_APB_PUB_PORT6_REMAP_EN                                                     0x40
#define MASK_PUB_APB_PUB_PORT5_REMAP_EN                                                     0x20
#define MASK_PUB_APB_PUB_PORT4_REMAP_EN                                                     0x10
#define MASK_PUB_APB_PUB_PORT3_REMAP_EN                                                     0x8
#define MASK_PUB_APB_PUB_PORT2_REMAP_EN                                                     0x4
#define MASK_PUB_APB_PUB_PORT1_REMAP_EN                                                     0x2
#define MASK_PUB_APB_PUB_PORT0_REMAP_EN                                                     0x1
#define MASK_PUB_APB_PUB_DUMMY_REG0                                                         0xffffffff
#define MASK_PUB_APB_PUB_DUMMY_REG1                                                         0xffffffff
#define MASK_PUB_APB_DMC_DUMMY_REG0                                                         0xffffffff
#define MASK_PUB_APB_DMC_DUMMY_REG1                                                         0xffffffff
#define MASK_PUB_APB_SOFT_CMD_NUM                                                           0x700
#define MASK_PUB_APB_SOFT_CMD_FC_SEL                                                        0x30
#define MASK_PUB_APB_SOFT_CMD_RESP                                                          0x8
#define MASK_PUB_APB_SOFT_CMD_DONE                                                          0x4
#define MASK_PUB_APB_SOFT_CMD_START                                                         0x1
#define MASK_PUB_APB_SOFT_CMD_SEQL                                                          0xffffffff
#define MASK_PUB_APB_SOFT_CMD_SEQH                                                          0xffffffff
#define MASK_PUB_APB_SOFT_CMD_STEP                                                          0xffffffff
#define MASK_PUB_APB_USRID_SEL                                                              0x1fe0000
#define MASK_PUB_APB_MPU_SEL                                                                0x1fe00
#define MASK_PUB_APB_MPU_PORT_EN                                                            0x1fe
#define MASK_PUB_APB_MPU_EN                                                                 0x1
#define MASK_PUB_APB_MPU_SHARED_PORT                                                        0x78
#define MASK_PUB_APB_MPU_SHARED_USRID_SEL                                                   0x4
#define MASK_PUB_APB_MPU_SHARED_SEL                                                         0x2
#define MASK_PUB_APB_MPU_SHARED_EN                                                          0x1
#define MASK_PUB_APB_MPU_SHARED_RID_MASK                                                    0xffff
#define MASK_PUB_APB_MPU_SHARED_WID_MASK                                                    0xffff
#define MASK_PUB_APB_MPU_SHARED_RID_VAL                                                     0xffff
#define MASK_PUB_APB_MPU_SHARED_WID_VAL                                                     0xffff
#define MASK_PUB_APB_MPU_SHARED_RHIGH_RANGE                                                 0xffffffff
#define MASK_PUB_APB_MPU_SHARED_RLOW_RANGE                                                  0xffffffff
#define MASK_PUB_APB_MPU_SHARED_WHIGH_RANGE                                                 0xffffffff
#define MASK_PUB_APB_MPU_SHARED_WLOW_RANGE                                                  0xffffffff
#define MASK_PUB_APB_MPU_CH0_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH0_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH1_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH1_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH2_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH2_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH3_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH3_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH4_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH4_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH5_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH5_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH6_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH6_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH7_RID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH7_WID_MASK_VAL                                                   0xffffffff
#define MASK_PUB_APB_MPU_CH0_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH0_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH1_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH1_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH2_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH2_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH3_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH3_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH4_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH4_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH5_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH5_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH6_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH6_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH7_RLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH7_WLOW_RANGE                                                     0xffffffff
#define MASK_PUB_APB_MPU_CH0_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH0_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH1_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH1_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH2_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH2_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH3_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH3_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH4_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH4_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH5_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH5_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH6_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH6_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH7_RHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_MPU_CH7_WHIGH_RANGE                                                    0xffffffff
#define MASK_PUB_APB_DMC_MPU_VIO_ADDR                                                       0xffffffff
#define MASK_PUB_APB_DMC_MPU_VIO_CMD                                                        0xffffffff
#define MASK_PUB_APB_DMC_MPU_VIO_USERID                                                     0xff
#define MASK_PUB_APB_DMC_REMAP_EN                                                           0x3fff
#define MASK_PUB_APB_DMC_PORT0_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT0_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT1_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT1_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT2_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT2_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT3_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT3_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT4_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT4_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT5_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT5_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT6_REMAP_ADDR_0                                                 0xffffffff
#define MASK_PUB_APB_DMC_PORT6_REMAP_ADDR_1                                                 0xffffffff
#define MASK_PUB_APB_DMC_MPU_DUMP_ADDR                                                      0xffffffff
#define MASK_PUB_APB_INT_DMC_MPU_VIO                                                        0x8
#define MASK_PUB_APB_DMC_MPU_VIO_INT_RAW                                                    0x4
#define MASK_PUB_APB_DMC_MPU_VIO_INT_CLR                                                    0x2
#define MASK_PUB_APB_DMC_MPU_VIO_INT_EN                                                     0x1
#define MASK_PUB_APB_MEM_FW_INT_RAW                                                         0x8
#define MASK_PUB_APB_INT_MEM_FW                                                             0x4
#define MASK_PUB_APB_MEM_FW_INT_CLR                                                         0x2
#define MASK_PUB_APB_MEM_FW_INT_EN                                                          0x1
#define MASK_PUB_APB_THD_SYNC_ACK                                                           0x200
#define MASK_PUB_APB_THD_SYNC_REQ                                                           0x100
#define MASK_PUB_APB_URGENT_EB_CHN7                                                         0x80
#define MASK_PUB_APB_URGENT_EB_CHN6                                                         0x40
#define MASK_PUB_APB_URGENT_EB_CHN5                                                         0x20
#define MASK_PUB_APB_URGENT_EB_CHN4                                                         0x10
#define MASK_PUB_APB_URGENT_EB_CHN3                                                         0x8
#define MASK_PUB_APB_URGENT_EB_CHN2                                                         0x4
#define MASK_PUB_APB_URGENT_EB_CHN1                                                         0x2
#define MASK_PUB_APB_URGENT_EB_CHN0                                                         0x1
#define MASK_PUB_APB_AW_HIGH_THD_CHN1                                                       0xf0000000
#define MASK_PUB_APB_AW_LOW_THD_CHN1                                                        0xf000000
#define MASK_PUB_APB_AR_HIGH_THD_CHN1                                                       0xf00000
#define MASK_PUB_APB_AR_LOW_THD_CHN1                                                        0xf0000
#define MASK_PUB_APB_AW_HIGH_THD_CHN0                                                       0xf000
#define MASK_PUB_APB_AW_LOW_THD_CHN0                                                        0xf00
#define MASK_PUB_APB_AR_HIGH_THD_CHN0                                                       0xf0
#define MASK_PUB_APB_AR_LOW_THD_CHN0                                                        0xf
#define MASK_PUB_APB_AW_HIGH_THD_CHN3                                                       0xf0000000
#define MASK_PUB_APB_AW_LOW_THD_CHN3                                                        0xf000000
#define MASK_PUB_APB_AR_HIGH_THD_CHN3                                                       0xf00000
#define MASK_PUB_APB_AR_LOW_THD_CHN3                                                        0xf0000
#define MASK_PUB_APB_AW_HIGH_THD_CHN2                                                       0xf000
#define MASK_PUB_APB_AW_LOW_THD_CHN2                                                        0xf00
#define MASK_PUB_APB_AR_HIGH_THD_CHN2                                                       0xf0
#define MASK_PUB_APB_AR_LOW_THD_CHN2                                                        0xf
#define MASK_PUB_APB_AW_HIGH_THD_CHN5                                                       0xf0000000
#define MASK_PUB_APB_AW_LOW_THD_CHN5                                                        0xf000000
#define MASK_PUB_APB_AR_HIGH_THD_CHN5                                                       0xf00000
#define MASK_PUB_APB_AR_LOW_THD_CHN5                                                        0xf0000
#define MASK_PUB_APB_AW_HIGH_THD_CHN4                                                       0xf000
#define MASK_PUB_APB_AW_LOW_THD_CHN4                                                        0xf00
#define MASK_PUB_APB_AR_HIGH_THD_CHN4                                                       0xf0
#define MASK_PUB_APB_AR_LOW_THD_CHN4                                                        0xf
#define MASK_PUB_APB_AW_HIGH_THD_CHN7                                                       0xf0000000
#define MASK_PUB_APB_AW_LOW_THD_CHN7                                                        0xf000000
#define MASK_PUB_APB_AR_HIGH_THD_CHN7                                                       0xf00000
#define MASK_PUB_APB_AR_LOW_THD_CHN7                                                        0xf0000
#define MASK_PUB_APB_AW_HIGH_THD_CHN6                                                       0xf000
#define MASK_PUB_APB_AW_LOW_THD_CHN6                                                        0xf00
#define MASK_PUB_APB_AR_HIGH_THD_CHN6                                                       0xf0
#define MASK_PUB_APB_AR_LOW_THD_CHN6                                                        0xf
#define MASK_AP_APB_INTC3_EB                                                                0x400000
#define MASK_AP_APB_INTC2_EB                                                                0x200000
#define MASK_AP_APB_INTC1_EB                                                                0x100000
#define MASK_AP_APB_INTC0_EB                                                                0x80000
#define MASK_AP_APB_SIM0_32K_EB                                                             0x40000
#define MASK_AP_APB_UART1_EB                                                                0x4000
#define MASK_AP_APB_UART0_EB                                                                0x2000
#define MASK_AP_APB_I2C2_EB                                                                 0x400
#define MASK_AP_APB_I2C1_EB                                                                 0x200
#define MASK_AP_APB_I2C0_EB                                                                 0x100
#define MASK_AP_APB_SPI0_EB                                                                 0x20
#define MASK_AP_APB_IIS0_EB                                                                 0x2
#define MASK_AP_APB_SIM0_EB                                                                 0x1
#define MASK_AP_APB_INTC3_SOFT_RST                                                          0x400000
#define MASK_AP_APB_INTC2_SOFT_RST                                                          0x200000
#define MASK_AP_APB_INTC1_SOFT_RST                                                          0x100000
#define MASK_AP_APB_INTC0_SOFT_RST                                                          0x80000
#define MASK_AP_APB_UART1_SOFT_RST                                                          0x4000
#define MASK_AP_APB_UART0_SOFT_RST                                                          0x2000
#define MASK_AP_APB_I2C2_SOFT_RST                                                           0x400
#define MASK_AP_APB_I2C1_SOFT_RST                                                           0x200
#define MASK_AP_APB_I2C0_SOFT_RST                                                           0x100
#define MASK_AP_APB_SPI1_SOFT_RST                                                           0x40
#define MASK_AP_APB_SPI0_SOFT_RST                                                           0x20
#define MASK_AP_APB_IIS0_SOFT_RST                                                           0x2
#define MASK_AP_APB_SIM0_SOFT_RST                                                           0x1
#define MASK_AP_APB_FMARK_POLARITY_INV                                                      0x1
#define MASK_AP_APB_AP_DUMMY_REG4_H16                                                       0xffff0000
#define MASK_AP_APB_AP_DUMMY_REG4_L16                                                       0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_ADCLDOREF                                  0x7c00
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_ADCLDO_V                                   0x3c0
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_CHOP_CLKSEL                                0x30
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_CLKSEL                                     0xc
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_BIAS                                 0x3
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_VCMI                                 0xc000
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_VCMO                                 0x3000
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_UGBUF_CTRL                                      0xc00
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_ADCLDO_EN                                  0x200
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_CAPCHOP_EN                           0x100
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_CHOP_EN                              0x80
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_UGBUF_CHOP_EN                              0x40
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_EN                                   0x20
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_OFFSET_EN                            0x10
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_INPUT_EN                                   0x8
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_UGBUF_EN                                   0x4
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_DATA_EDGE_SEL                        0x2
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_SDADC_RST                                  0x1
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_UGBUF_BIAS                                 0x6000
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_RESERVED                                   0x1fe0
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_BIST_EN                                    0x10
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_BIST_CODE                                  0xe
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_RG_TSEN_TEST_CLK_SEL                               0x1
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_BYPASS                               0x2000
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_CFG0                                 0x1c00
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_CFG1                                 0x380
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_CFG2                                 0x70
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_CFG3                                 0xe
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_DONE                                 0x1
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_CODE_SEL                             0x200
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_TIME_SEL_CFG3                        0x180
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_TIME_SEL_CFG2                        0x60
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_TIME_SEL_CFG1                        0x18
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_TIME_SEL_CFG0                        0x6
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_BIST_CODE_EN_DIG                          0x1
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_RES0                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_RES1                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_RES2                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C0_RES3                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_RES0                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_RES1                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_RES2                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C1_RES3                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_RES0                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_RES1                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_RES2                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C2_RES3                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_RES0                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_RES1                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_RES2                                   0xffff
#define MASK_ANLG_PHY_G6_ANALOG_TSEN_ADC_TST_TSEN_C3_RES3                                   0xffff
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_UGBUF_CTRL                              0x8000
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_ADCLDO_EN                          0x4000
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_CAPCHOP_EN                   0x2000
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_CHOP_EN                      0x1000
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_UGBUF_CHOP_EN                      0x800
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_EN                           0x400
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_OFFSET_EN                    0x200
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_INPUT_EN                           0x100
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_UGBUF_EN                           0x80
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_DATA_EDGE_SEL                0x40
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_RST                          0x20
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_UGBUF_BIAS                         0x10
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_RESERVED                           0x8
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_BIST_EN                            0x4
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_BIST_CODE                          0x2
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_TEST_CLK_SEL                       0x1
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_ADCLDOREF                          0x40
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_ADCLDO_V                           0x20
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_CHOP_CLKSEL                        0x10
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_CLKSEL                             0x8
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_BIAS                         0x4
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_VCMI                         0x2
#define MASK_ANLG_PHY_G6_DBG_SEL_ANALOG_TSEN_ADC_RG_TSEN_SDADC_VCMO                         0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_STOPSTATECLK                           0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RXULPSCLKNOT                           0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RXCLKACTIVEHS                          0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ULPSACTIVENOTCLK                       0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RXULPSESC_0                            0x40000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ULPSACTIVENOT_0                        0x20000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_DIRECTION_0                            0x10000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_0                          0x8000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_STOPSTATEDATA_0                        0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTHS_0                             0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTSYNCHS_0                         0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRESC_0                               0x800
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSYNCESC_0                           0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRCONTROL_0                           0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ULPSACTIVENOT_1                        0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_DIRECTION_1                            0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_1                          0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_STOPSTATEDATA_1                        0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTHS_1                             0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTSYNCHS_1                         0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRESC_1                               0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSYNCESC_1                           0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRCONTROL_1                           0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RXULPSESC_2                            0x40000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ULPSACTIVENOT_2                        0x20000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_DIRECTION_2                            0x10000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_2                          0x8000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_STOPSTATEDATA_2                        0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTHS_2                             0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTSYNCHS_2                         0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRESC_2                               0x800
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSYNCESC_2                           0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRCONTROL_2                           0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ULPSACTIVENOT_3                        0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_DIRECTION_3                            0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_3                          0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_STOPSTATEDATA_3                        0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTHS_3                             0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSOTSYNCHS_3                         0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRESC_3                               0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRSYNCESC_3                           0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ERRCONTROL_3                           0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_SHUTDOWNZ                              0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RSTZ                                   0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_0                               0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_1                               0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_2                               0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_3                               0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLECLK                              0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_IF_SEL                                 0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_BISTON                                 0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_BISTOK                                 0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_PS_PD_S                                0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_PS_PD_L                                0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_MODE_SEL                               0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RX_RCTL                                0xf00
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_RESERVED                               0xff
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTHSCLK_DB                      0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSCLK_DB                           0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXITCLK_DB                       0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_STOPSTATECLK_DB                        0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ULPSACTIVENOTCLK_DB                    0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_0_DB                   0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_0_DB                      0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_0_DB                         0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_0_DB                         0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_0_DB                        0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_0_DB                      0x3c
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_0_DB                        0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREADYESC_0_DB                        0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_1_DB                   0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_1_DB                      0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_1_DB                         0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_1_DB                         0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_1_DB                        0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_1_DB                      0x3c
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_1_DB                        0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREADYESC_1_DB                        0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_2_DB                   0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_2_DB                      0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_2_DB                         0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_2_DB                         0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_2_DB                        0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_2_DB                      0x3c
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_2_DB                        0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREADYESC_2_DB                        0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_3_DB                   0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_3_DB                      0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_3_DB                         0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_3_DB                         0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_3_DB                        0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_3_DB                      0x3c
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_3_DB                        0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREADYESC_3_DB                        0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_0_DB                         0xff000000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_1_DB                         0xff0000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_2_DB                         0xff00
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_3_DB                         0xff
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXCLKESC_0_DB                          0x8000000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXLPDTESC_0_DB                         0x4000000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXTRIGGERESC_0_DB                      0x3c00000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXVALIDESC_0_DB                        0x200000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXCLKESC_1_DB                          0x100000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXLPDTESC_1_DB                         0x80000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXTRIGGERESC_1_DB                      0x78000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXVALIDESC_1_DB                        0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXCLKESC_2_DB                          0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXLPDTESC_2_DB                         0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXTRIGGERESC_2_DB                      0xf00
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXVALIDESC_2_DB                        0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXCLKESC_3_DB                          0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXLPDTESC_3_DB                         0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXTRIGGERESC_3_DB                      0x1e
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RXVALIDESC_3_DB                        0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_0_DB                       0x400000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_DIRECTION_0_DB                         0x200000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_0_DB                       0x100000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_0_DB                       0x80000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_0_DB                   0x40000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_STOPSTATEDATA_0_DB                     0x20000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_1_DB                       0x10000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_1_DB                       0x8000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_1_DB                       0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_1_DB                   0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_STOPSTATEDATA_1_DB                     0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_2_DB                       0x800
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_DIRECTION_2_DB                         0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_2_DB                       0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_2_DB                       0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_2_DB                   0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_STOPSTATEDATA_2_DB                     0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_3_DB                       0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_DIRECTION_3_DB                         0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_3_DB                       0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_3_DB                       0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_3_DB                   0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_STOPSTATEDATA_3_DB                     0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRESC_0_DB                            0x80000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRSYNCESC_0_DB                        0x40000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTROL_0_DB                        0x20000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP0_0_DB                  0x10000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP1_0_DB                  0x8000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRESC_1_DB                            0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRSYNCESC_1_DB                        0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTROL_1_DB                        0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP0_1_DB                  0x800
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP1_1_DB                  0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRESC_2_DB                            0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRSYNCESC_2_DB                        0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTROL_2_DB                        0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP0_2_DB                  0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP1_2_DB                  0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRESC_3_DB                            0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRSYNCESC_3_DB                        0x8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTROL_3_DB                        0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP0_3_DB                  0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ERRCONTENTIONLP1_3_DB                  0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_SHUTDOWNZ_DB                           0x8000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_RSTZ_DB                                0x4000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_0_DB                            0x2000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_1_DB                            0x1000
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_2_DB                            0x800
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_3_DB                            0x400
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLECLK_DB                           0x200
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCEPLL_DB                            0x100
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_BISTON_DB                              0x80
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_BISTDONE_DB                            0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_IF_SEL_DB                              0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DEBUG_EN_DB                                0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TRIMBG_DB                              0xf
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTDIN_DB                             0x7f800
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTDOUT_DB                            0x7f8
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTEN_DB                              0x4
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTCLK_DB                             0x2
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTCLR_DB                             0x1
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_TXREQHSCLK_DB                          0x40
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_BERT_TEST_SEL                          0x20
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_BERT_REFCLK_EN                         0x10
#define MASK_ANLG_PHY_G4_ANALOG_MIPI_CSI_4P2LANE_CSI_REFDIV                                 0xf
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_0                  0x80000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_1                  0x40000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_2                  0x20000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_FORCERXMODE_3                  0x10000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_SHUTDOWNZ                      0x8000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_RSTZ                           0x4000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_0                       0x2000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_1                       0x1000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_2                       0x800000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLE_3                       0x400000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_ENABLECLK                      0x200000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_IF_SEL                         0x100000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_BISTON                         0x80000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_PS_PD_S                        0x40000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_PS_PD_L                        0x20000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_MODE_SEL                       0x10000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_RX_RCTL                        0x8000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_CSI_RESERVED                       0x4000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTHSCLK_DB              0x2000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSCLK_DB                   0x1000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXITCLK_DB               0x800
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_0_DB           0x400
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_0_DB              0x200
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_0_DB                 0x100
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_0_DB                 0x80
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_0_DB                0x40
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_0_DB              0x20
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_0_DB                0x10
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_1_DB           0x8
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_1_DB              0x4
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_1_DB                 0x2
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_1_DB                 0x1
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_1_DB                0x80000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_1_DB              0x40000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_1_DB                0x20000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_2_DB           0x10000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_2_DB              0x8000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_2_DB                 0x4000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_2_DB                 0x2000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_2_DB                0x1000000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_2_DB              0x800000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_2_DB                0x400000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTDATAHS_3_DB           0x200000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXREQUESTESC_3_DB              0x100000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXLPDTESC_3_DB                 0x80000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSESC_3_DB                 0x40000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXULPSEXIT_3_DB                0x20000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXTRIGGERESC_3_DB              0x10000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXVALIDESC_3_DB                0x8000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_0_DB                 0x4000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_1_DB                 0x2000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_2_DB                 0x1000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TXDATAESC_3_DB                 0x800
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_0_DB               0x400
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_0_DB               0x200
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_0_DB               0x100
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_0_DB           0x80
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_1_DB               0x40
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_1_DB               0x20
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_1_DB               0x10
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_1_DB           0x8
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_2_DB               0x4
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_2_DB               0x2
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_2_DB               0x1
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_2_DB           0x100000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNREQUEST_3_DB               0x80000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TURNDISABLE_3_DB               0x40000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCERXMODE_3_DB               0x20000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCETXSTOPMODE_3_DB           0x10000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_SHUTDOWNZ_DB                   0x8000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_RSTZ_DB                        0x4000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_0_DB                    0x2000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_1_DB                    0x1000
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_2_DB                    0x800
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLE_3_DB                    0x400
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_ENABLECLK_DB                   0x200
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_FORCEPLL_DB                    0x100
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_BISTON_DB                      0x80
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_IF_SEL_DB                      0x40
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DEBUG_EN_DB                        0x20
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TRIMBG_DB                      0x10
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTDIN_DB                     0x8
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTEN_DB                      0x4
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTCLK_DB                     0x2
#define MASK_ANLG_PHY_G4_DBG_SEL_ANALOG_MIPI_CSI_4P2LANE_DSI_TESTCLR_DB                     0x1
#define MASK_ANLG_PHY_G3_ANALOG_EFUSE_EFS0_ENK1                                             0x2
#define MASK_ANLG_PHY_G3_ANALOG_EFUSE_EFS0_ENK2                                             0x1
#define MASK_ANLG_PHY_G3_ANALOG_EFUSE_EFS1_ENK1                                             0x2
#define MASK_ANLG_PHY_G3_ANALOG_EFUSE_EFS1_ENK2                                             0x1
#define MASK_ANLG_PHY_G3_DBG_SEL_ANALOG_EFUSE_EFS0_ENK1                                     0x8
#define MASK_ANLG_PHY_G3_DBG_SEL_ANALOG_EFUSE_EFS0_ENK2                                     0x4
#define MASK_ANLG_PHY_G3_DBG_SEL_ANALOG_EFUSE_EFS1_ENK1                                     0x2
#define MASK_ANLG_PHY_G3_DBG_SEL_ANALOG_EFUSE_EFS1_ENK2                                     0x1
#define MASK_AON_SEC_APB_SEC_EIC_RTCDV5_EB                                                  0x400
#define MASK_AON_SEC_APB_SEC_EIC_RTC_EB                                                     0x200
#define MASK_AON_SEC_APB_SEC_EIC_EB                                                         0x100
#define MASK_AON_SEC_APB_SEC_GPIO_EB                                                        0x80
#define MASK_AON_SEC_APB_SEC_RTC_CLK_GATE_EB                                                0x40
#define MASK_AON_SEC_APB_SEC_WDG_EB                                                         0x20
#define MASK_AON_SEC_APB_SEC_WDG_RTC_EB                                                     0x10
#define MASK_AON_SEC_APB_SEC_RTC_EB                                                         0x8
#define MASK_AON_SEC_APB_SEC_TMR_EB                                                         0x4
#define MASK_AON_SEC_APB_SEC_TMR_RTC_EB                                                     0x2
#define MASK_AON_SEC_APB_SEC_TZPC_EB                                                        0x1
#define MASK_AON_SEC_APB_SEC_EIC_SOFT_RST                                                   0x20
#define MASK_AON_SEC_APB_SEC_GPIO_RST                                                       0x10
#define MASK_AON_SEC_APB_SEC_WDG_SOFT_RST                                                   0x8
#define MASK_AON_SEC_APB_SEC_RTC_SOFT_RST                                                   0x4
#define MASK_AON_SEC_APB_SEC_TMR_SOFT_RST                                                   0x2
#define MASK_AON_SEC_APB_SEC_TZPC_SOFT_RST                                                  0x1
#define MASK_AON_SEC_APB_FUNC_DMA_EN                                                        0x1
#define MASK_AON_SEC_APB_CA7_GIC_CFGSDISABLE                                                0x100
#define MASK_AON_SEC_APB_CP15SDISABLE                                                       0xf
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_PD                                              0x20
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_PD                                              0x10
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_PD                                             0x8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_PD                                             0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_PD                                              0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_PD                                               0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_RST                                             0x20
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_RST                                             0x10
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_RST                                            0x8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_RST                                            0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_RST                                             0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_RSTN                                             0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_ANALOG_PLL_RESERVED                                  0xff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_REF_SEL                                         0x400000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_N                                               0x3ff800
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_IBIAS                                           0x600
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_SDM_EN                                          0x100
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_MOD_EN                                          0x80
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_DIV_S                                           0x40
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_RESERVED                                        0x3c
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_CLKOUT_EN                                       0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_LOCK_DONE                                       0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_NINT                                            0x3f800000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_KINT                                            0x7fffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_CCS_CTRL                                        0x7f8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_IL_DIV2                                         0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_OL_DIV2                                         0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_TEST_EN                                         0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_BIST_EN                                         0x10000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_DPLL_BIST_CNT                                        0xffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_REF_SEL                                         0x400000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_N                                               0x3ff800
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_IBIAS                                           0x600
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_SDM_EN                                          0x100
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_MOD_EN                                          0x80
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_DIV_S                                           0x40
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_RESERVED                                        0x3c
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_CLKOUT_EN                                       0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_LOCK_DONE                                       0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_NINT                                            0x3f800000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_KINT                                            0x7fffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_CCS_CTRL                                        0x7f8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_IL_DIV2                                         0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_OL_DIV2                                         0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_TEST_EN                                         0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_BIST_EN                                         0x10000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_MPLL_BIST_CNT                                        0xffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_REF_SEL                                        0x8000000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_N                                              0x7ff0000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_IBIAS                                          0xc000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_SDM_EN                                         0x2000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_MOD_EN                                         0x1000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_DIV_S                                          0x800
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_RESERVED                                       0x780
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_CLKOUT_EN                                      0x40
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_DIV1_EN                                        0x20
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_DIV2_EN                                        0x10
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_DIV3_EN                                        0x8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_DIV5_EN                                        0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_DIV7_EN                                        0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_LOCK_DONE                                      0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_NINT                                           0x3f800000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_KINT                                           0x7fffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_CCS_CTRL                                       0x7f8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_IL_DIV2                                        0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_OL_DIV2                                        0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_TEST_EN                                        0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_BIST_EN                                        0x10000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TWPLL_BIST_CNT                                       0xffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_REF_SEL                                        0x8000000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_N                                              0x7ff0000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_IBIAS                                          0xc000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_SDM_EN                                         0x2000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_MOD_EN                                         0x1000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_DIV_S                                          0x800
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_RESERVED                                       0x780
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_CLKOUT_EN                                      0x40
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_DIV1_EN                                        0x20
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_DIV2_EN                                        0x10
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_DIV3_EN                                        0x8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_DIV5_EN                                        0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_DIV7_EN                                        0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_LOCK_DONE                                      0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_NINT                                           0x3f800000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_KINT                                           0x7fffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_CCS_CTRL                                       0x7f8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_IL_DIV2                                        0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_OL_DIV2                                        0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_TEST_EN                                        0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_BIST_EN                                        0x10000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_CPPLL_BIST_CNT                                       0xffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_REF_SEL                                         0x400000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_N                                               0x3ff800
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_IBIAS                                           0x600
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_SDM_EN                                          0x100
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_MOD_EN                                          0x80
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_DIV_S                                           0x40
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_RESERVED                                        0x3c
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_CLKOUT_EN                                       0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_LOCK_DONE                                       0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_NINT                                            0x3f800000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_KINT                                            0x7fffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_CCS_CTRL                                        0x7f8
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_IL_DIV2                                         0x4
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_OL_DIV2                                         0x2
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_TEST_EN                                         0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_BIST_EN                                         0x10000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_GPLL_BIST_CNT                                        0xffff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_RUN                                              0x100000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_RESERVED                                         0xff000
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_BG_RBIAS_MODE                                    0x800
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_TEST_SEL                                         0x600
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_BP_MODE                                          0x100
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_BP_DATA                                          0xff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_DATA                                             0x1fe
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_THM_VALID                                            0x1
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_ANA_BB_RESERVED                                      0xff
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TEST_PLL_THM_MUX                                     0x7c
#define MASK_ANLG_PHY_G1_ANALOG_BB_TOP_TEST_CLK_DIV                                         0x3
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_PD                                      0x80000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_PD                                      0x40000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_PD                                     0x20000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_PD                                     0x10000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_PD                                      0x8000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_PD                                       0x4000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_RST                                     0x2000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_RST                                     0x1000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_RST                                    0x800000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_RST                                    0x400000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_RST                                     0x200000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_RSTN                                     0x100000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_ANALOG_PLL_RESERVED                          0x80000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_REF_SEL                                 0x40000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_N                                       0x20000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_IBIAS                                   0x10000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_SDM_EN                                  0x8000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_MOD_EN                                  0x4000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_DIV_S                                   0x2000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_RESERVED                                0x1000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_CLKOUT_EN                               0x800
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_NINT                                    0x400
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_KINT                                    0x200
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_CCS_CTRL                                0x100
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_IL_DIV2                                 0x80
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_OL_DIV2                                 0x40
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_TEST_EN                                 0x20
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_DPLL_BIST_EN                                 0x10
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_REF_SEL                                 0x8
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_N                                       0x4
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_IBIAS                                   0x2
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_SDM_EN                                  0x1
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_MOD_EN                                  0x80000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_DIV_S                                   0x40000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_RESERVED                                0x20000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_CLKOUT_EN                               0x10000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_NINT                                    0x8000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_KINT                                    0x4000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_CCS_CTRL                                0x2000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_IL_DIV2                                 0x1000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_OL_DIV2                                 0x800000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_TEST_EN                                 0x400000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_MPLL_BIST_EN                                 0x200000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_REF_SEL                                0x100000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_N                                      0x80000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_IBIAS                                  0x40000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_SDM_EN                                 0x20000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_MOD_EN                                 0x10000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_DIV_S                                  0x8000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_RESERVED                               0x4000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_CLKOUT_EN                              0x2000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_DIV1_EN                                0x1000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_DIV2_EN                                0x800
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_DIV3_EN                                0x400
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_DIV5_EN                                0x200
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_DIV7_EN                                0x100
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_NINT                                   0x80
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_KINT                                   0x40
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_CCS_CTRL                               0x20
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_IL_DIV2                                0x10
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_OL_DIV2                                0x8
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_TEST_EN                                0x4
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TWPLL_BIST_EN                                0x2
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_REF_SEL                                0x1
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_N                                      0x80000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_IBIAS                                  0x40000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_SDM_EN                                 0x20000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_MOD_EN                                 0x10000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_DIV_S                                  0x8000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_RESERVED                               0x4000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_CLKOUT_EN                              0x2000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_DIV1_EN                                0x1000000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_DIV2_EN                                0x800000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_DIV3_EN                                0x400000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_DIV5_EN                                0x200000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_DIV7_EN                                0x100000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_NINT                                   0x80000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_KINT                                   0x40000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_CCS_CTRL                               0x20000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_IL_DIV2                                0x10000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_OL_DIV2                                0x8000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_TEST_EN                                0x4000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_CPPLL_BIST_EN                                0x2000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_REF_SEL                                 0x1000
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_N                                       0x800
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_IBIAS                                   0x400
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_SDM_EN                                  0x200
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_MOD_EN                                  0x100
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_DIV_S                                   0x80
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_RESERVED                                0x40
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_CLKOUT_EN                               0x20
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_NINT                                    0x10
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_KINT                                    0x8
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_CCS_CTRL                                0x4
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_IL_DIV2                                 0x2
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_OL_DIV2                                 0x1
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_TEST_EN                                 0x200
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_GPLL_BIST_EN                                 0x100
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_RUN                                      0x80
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_RESERVED                                 0x40
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_BG_RBIAS_MODE                            0x20
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_TEST_SEL                                 0x10
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_BP_MODE                                  0x8
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_THM_BP_DATA                                  0x4
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_ANA_BB_RESERVED                              0x2
#define MASK_ANLG_PHY_G1_DBG_SEL_ANALOG_BB_TOP_TEST_PLL_THM_MUX                             0x1
#define MASK_AP_AHB_NANDC_ECC_EB                                                            0x40000000
#define MASK_AP_AHB_SDIO0_32K_EB                                                            0x10000000
#define MASK_AP_AHB_EMMC_32K_EB                                                             0x8000000
#define MASK_AP_AHB_CE_SEC_EB                                                               0x1000
#define MASK_AP_AHB_EMMC_EB                                                                 0x800
#define MASK_AP_AHB_NANDC_EB                                                                0x400
#define MASK_AP_AHB_SDIO0_EB                                                                0x100
#define MASK_AP_AHB_CE_PUB_EB                                                               0x40
#define MASK_AP_AHB_REE_DMA_EB                                                              0x20
#define MASK_AP_AHB_OTG_EB                                                                  0x10
#define MASK_AP_AHB_GSP_EB                                                                  0x8
#define MASK_AP_AHB_DISPC_EB                                                                0x2
#define MASK_AP_AHB_DSI_EB                                                                  0x1
#define MASK_AP_AHB_CE_SEC_SOFT_RST                                                         0x8000
#define MASK_AP_AHB_EMMC_SOFT_RST                                                           0x4000
#define MASK_AP_AHB_NANDC_SOFT_RST                                                          0x2000
#define MASK_AP_AHB_SDIO0_SOFT_RST                                                          0x800
#define MASK_AP_AHB_CE_PUB_SOFT_RST                                                         0x200
#define MASK_AP_AHB_DMA_SOFT_RST                                                            0x100
#define MASK_AP_AHB_OTG_PHY_SOFT_RST                                                        0x40
#define MASK_AP_AHB_OTG_UTMI_SOFT_RST                                                       0x20
#define MASK_AP_AHB_OTG_SOFT_RST                                                            0x10
#define MASK_AP_AHB_GSP_SOFT_RST                                                            0x8
#define MASK_AP_AHB_DISP_MTX_SOFT_RST                                                       0x4
#define MASK_AP_AHB_DISPC_SOFT_RST                                                          0x2
#define MASK_AP_AHB_DSI_SOFT_RST                                                            0x1
#define MASK_AP_AHB_CA7_CS_DBG_SOFT_RST                                                     0x4000
#define MASK_AP_AHB_CA7_L2_SOFT_RST                                                         0x2000
#define MASK_AP_AHB_CA7_SOCDBG_SOFT_RST                                                     0x1000
#define MASK_AP_AHB_CA7_ETM_SOFT_RST                                                        0xf00
#define MASK_AP_AHB_CA7_DBG_SOFT_RST                                                        0xf0
#define MASK_AP_AHB_CA7_CORE_SOFT_RST                                                       0xf
#define MASK_AP_AHB_MCU_LIGHT_SLEEP_EN_FORCE                                                0x100000
#define MASK_AP_AHB_AP_DISP_ASYNC_SLEEP                                                     0x40000
#define MASK_AP_AHB_AP_GSP_MTX_SLEEP                                                        0x20000
#define MASK_AP_AHB_AP_IMC_MTX_SLEEP                                                        0x10000
#define MASK_AP_AHB_CA7_C3_AUTO_SLP_EN                                                      0x8000
#define MASK_AP_AHB_CA7_C2_AUTO_SLP_EN                                                      0x4000
#define MASK_AP_AHB_CA7_C1_AUTO_SLP_EN                                                      0x2000
#define MASK_AP_AHB_CA7_C0_AUTO_SLP_EN                                                      0x1000
#define MASK_AP_AHB_CA7_C3_WFI_SHUTDOWN_EN                                                  0x800
#define MASK_AP_AHB_CA7_C2_WFI_SHUTDOWN_EN                                                  0x400
#define MASK_AP_AHB_CA7_C1_WFI_SHUTDOWN_EN                                                  0x200
#define MASK_AP_AHB_CA7_C0_WFI_SHUTDOWN_EN                                                  0x100
#define MASK_AP_AHB_MCU_CA7_C3_SLEEP                                                        0x80
#define MASK_AP_AHB_MCU_CA7_C2_SLEEP                                                        0x40
#define MASK_AP_AHB_MCU_CA7_C1_SLEEP                                                        0x20
#define MASK_AP_AHB_MCU_CA7_C0_SLEEP                                                        0x10
#define MASK_AP_AHB_AP_PERI_FORCE_ON                                                        0x4
#define MASK_AP_AHB_AP_PERI_FORCE_SLP                                                       0x2
#define MASK_AP_AHB_AP_APB_SLEEP                                                            0x1
#define MASK_AP_AHB_CLKCORE_CHIP_DEEP_SLEEP_EN                                              0x100000
#define MASK_AP_AHB_USB_AHBM2AXI_S0_LP_DISABLE                                              0x80000
#define MASK_AP_AHB_AP_MAINMTX_M9_LP_DISABLE                                                0x40000
#define MASK_AP_AHB_AP_MAINMTX_M_SYNC_LP_DISABLE                                            0x20000
#define MASK_AP_AHB_AP_MAINMTX_M1_LP_DISABLE                                                0x10000
#define MASK_AP_AHB_AP_MAINMTX_M0_LP_DISABLE                                                0x8000
#define MASK_AP_AHB_CA7_TOPMTX_LP_DISABLE                                                   0x4000
#define MASK_AP_AHB_AP_DISPASYNC_LP_DISABLE                                                 0x2000
#define MASK_AP_AHB_AP_GSPMTX_LP_DISABLE                                                    0x1000
#define MASK_AP_AHB_AP_IMCMTX_LP_DISABLE                                                    0x800
#define MASK_AP_AHB_GSP_CKG_FORCE_EN                                                        0x200
#define MASK_AP_AHB_GSP_AUTO_GATE_EN                                                        0x100
#define MASK_AP_AHB_LP_AUTO_CTRL_EN                                                         0x80
#define MASK_AP_AHB_AP_MAINMTX_LP_DISABLE                                                   0x40
#define MASK_AP_AHB_AP_AHB_AUTO_GATE_EN                                                     0x20
#define MASK_AP_AHB_AP_EMC_AUTO_GATE_EN                                                     0x10
#define MASK_AP_AHB_CA7_EMC_AUTO_GATE_EN                                                    0x8
#define MASK_AP_AHB_CA7_DBG_FORCE_SLEEP                                                     0x4
#define MASK_AP_AHB_CA7_DBG_AUTO_GATE_EN                                                    0x2
#define MASK_AP_AHB_CA7_CORE_AUTO_GATE_EN                                                   0x1
#define MASK_AP_AHB_HOLDING_PEN                                                             0xffffffff
#define MASK_AP_AHB_JMP_ADDR_CA7_C0                                                         0xffffffff
#define MASK_AP_AHB_JMP_ADDR_CA7_C1                                                         0xffffffff
#define MASK_AP_AHB_JMP_ADDR_CA7_C2                                                         0xffffffff
#define MASK_AP_AHB_JMP_ADDR_CA7_C3                                                         0xffffffff
#define MASK_AP_AHB_CA7_C0_PU_LOCK                                                          0x1
#define MASK_AP_AHB_CA7_C1_PU_LOCK                                                          0x1
#define MASK_AP_AHB_CA7_C2_PU_LOCK                                                          0x1
#define MASK_AP_AHB_CA7_C3_PU_LOCK                                                          0x1
#define MASK_AP_AHB_CA7_DBG_CKG_DIV                                                         0x70000
#define MASK_AP_AHB_CA7_AXI_CKG_DIV                                                         0x700
#define MASK_AP_AHB_CA7_MCU_CKG_DIV                                                         0x70
#define MASK_AP_AHB_CA7_TOP_MTX_SLEEP                                                       0x80
#define MASK_AP_AHB_GSP_SLEEP_FOLLOW_CA7_EN                                                 0x40
#define MASK_AP_AHB_DMA_SLEEP_FOLLOW_CA7_EN                                                 0x20
#define MASK_AP_AHB_MCU_SLEEP_FOLLOW_CA7_EN                                                 0x10
#define MASK_AP_AHB_MCU_LIGHT_SLEEP_EN                                                      0x8
#define MASK_AP_AHB_MCU_DEEP_SLEEP_EN                                                       0x4
#define MASK_AP_AHB_MCU_SYS_SLEEP_EN                                                        0x2
#define MASK_AP_AHB_MCU_CORE_SLEEP                                                          0x1
#define MASK_AP_AHB_ASHB_CA7_DBG_VLD                                                        0x200
#define MASK_AP_AHB_ASHB_CA7_DBG_EN                                                         0x100
#define MASK_AP_AHB_DPHY_REF_CKG_EN                                                         0x2
#define MASK_AP_AHB_DPHY_CFG_CKG_EN                                                         0x1
#define MASK_AP_AHB_CA7_C0_AUTO_FORCE_SHUTDOWN_EN                                           0x1
#define MASK_AP_AHB_CA7_C1_AUTO_FORCE_SHUTDOWN_EN                                           0x1
#define MASK_AP_AHB_CA7_C2_AUTO_FORCE_SHUTDOWN_EN                                           0x1
#define MASK_AP_AHB_CA7_C3_AUTO_FORCE_SHUTDOWN_EN                                           0x1
#define MASK_AP_AHB_CA7_MCU_CKG_SEL                                                         0x7
#define MASK_AP_AHB_CA7_TOP_M0_FRC_LSLP                                                     0x20000
#define MASK_AP_AHB_AP_DISP_MAIN_FRC_LSLP                                                   0x10000
#define MASK_AP_AHB_AP_IMC_MAIN_FRC_LSLP                                                    0x8000
#define MASK_AP_AHB_AP_GSP_GPV_FRC_LSLP                                                     0x4000
#define MASK_AP_AHB_AP_GSP_M0_FRC_LSLP                                                      0x2000
#define MASK_AP_AHB_AP_GSP_M1_FRC_LSLP                                                      0x1000
#define MASK_AP_AHB_AP_GSP_S0_FRC_LSLP                                                      0x800
#define MASK_AP_AHB_SLV3_FRC_LSLP                                                           0x400
#define MASK_AP_AHB_MST9_FRC_LSLP                                                           0x200
#define MASK_AP_AHB_MST8_FRC_LSLP                                                           0x100
#define MASK_AP_AHB_MST7_FRC_LSLP                                                           0x80
#define MASK_AP_AHB_MST6_FRC_LSLP                                                           0x40
#define MASK_AP_AHB_MST4_FRC_LSLP                                                           0x10
#define MASK_AP_AHB_MST2_FRC_LSLP                                                           0x4
#define MASK_AP_AHB_MST1_FRC_LSLP                                                           0x2
#define MASK_AP_AHB_MST0_FRC_LSLP                                                           0x1
#define MASK_AP_AHB_M0_FORCE_ACK                                                            0x80000
#define MASK_AP_AHB_M0_LP_STAT                                                              0x40000
#define MASK_AP_AHB_M0_LP_FORCE                                                             0x20000
#define MASK_AP_AHB_M0_LP_EB                                                                0x10000
#define MASK_AP_AHB_M0_LP_NUM                                                               0xffff
#define MASK_AP_AHB_M9_FORCE_ACK                                                            0x80000
#define MASK_AP_AHB_M9_LP_STAT                                                              0x40000
#define MASK_AP_AHB_M9_LP_FORCE                                                             0x20000
#define MASK_AP_AHB_M9_LP_EB                                                                0x10000
#define MASK_AP_AHB_M9_LP_NUM                                                               0xffff
#define MASK_AP_AHB_S0_FORCE_ACK                                                            0x80000
#define MASK_AP_AHB_S0_LP_STAT                                                              0x40000
#define MASK_AP_AHB_S0_LP_FORCE                                                             0x20000
#define MASK_AP_AHB_S0_LP_EB                                                                0x10000
#define MASK_AP_AHB_S0_LP_NUM                                                               0xffff
#define MASK_AP_AHB_S1_FORCE_ACK                                                            0x80000
#define MASK_AP_AHB_S1_LP_STAT                                                              0x40000
#define MASK_AP_AHB_S1_LP_FORCE                                                             0x20000
#define MASK_AP_AHB_S1_LP_EB                                                                0x10000
#define MASK_AP_AHB_S1_LP_NUM                                                               0xffff
#define MASK_AP_AHB_M_SYNC_FORCE_ACK                                                        0x80000
#define MASK_AP_AHB_M_SYNC_LP_STAT                                                          0x40000
#define MASK_AP_AHB_M_SYNC_LP_FORCE                                                         0x20000
#define MASK_AP_AHB_M_SYNC_LP_EB                                                            0x10000
#define MASK_AP_AHB_M_SYNC_LP_NUM                                                           0xffff
#define MASK_AP_AHB_S_SYNC_FORCE_ACK                                                        0x80000
#define MASK_AP_AHB_S_SYNC_LP_STAT                                                          0x40000
#define MASK_AP_AHB_S_SYNC_LP_FORCE                                                         0x20000
#define MASK_AP_AHB_S_SYNC_LP_EB                                                            0x10000
#define MASK_AP_AHB_S_SYNC_LP_NUM                                                           0xffff
#define MASK_AP_AHB_AP_GSP_GPV_FORCE_ACK                                                    0x80000
#define MASK_AP_AHB_AP_GSP_GPV_LP_STAT                                                      0x40000
#define MASK_AP_AHB_AP_GSP_GPV_LP_FORCE                                                     0x20000
#define MASK_AP_AHB_AP_GSP_GPV_LP_EB                                                        0x10000
#define MASK_AP_AHB_AP_GSP_GPV_LP_NUM                                                       0xffff
#define MASK_AP_AHB_AP_GSP_M0_FORCE_ACK                                                     0x80000
#define MASK_AP_AHB_AP_GSP_M0_LP_STAT                                                       0x40000
#define MASK_AP_AHB_AP_GSP_M0_LP_FORCE                                                      0x20000
#define MASK_AP_AHB_AP_GSP_M0_LP_EB                                                         0x10000
#define MASK_AP_AHB_AP_GSP_M0_LP_NUM                                                        0xffff
#define MASK_AP_AHB_AP_GSP_M1_FORCE_ACK                                                     0x80000
#define MASK_AP_AHB_AP_GSP_M1_LP_STAT                                                       0x40000
#define MASK_AP_AHB_AP_GSP_M1_LP_FORCE                                                      0x20000
#define MASK_AP_AHB_AP_GSP_M1_LP_EB                                                         0x10000
#define MASK_AP_AHB_AP_GSP_M1_LP_NUM                                                        0xffff
#define MASK_AP_AHB_AP_GSP_S0_FORCE_ACK                                                     0x80000
#define MASK_AP_AHB_AP_GSP_S0_LP_STAT                                                       0x40000
#define MASK_AP_AHB_AP_GSP_S0_LP_FORCE                                                      0x20000
#define MASK_AP_AHB_AP_GSP_S0_LP_EB                                                         0x10000
#define MASK_AP_AHB_AP_GSP_S0_LP_NUM                                                        0xffff
#define MASK_AP_AHB_AP_IMC_MAIN_FORCE_ACK                                                   0x80000
#define MASK_AP_AHB_AP_IMC_MAIN_LP_STAT                                                     0x40000
#define MASK_AP_AHB_AP_IMC_MAIN_LP_FORCE                                                    0x20000
#define MASK_AP_AHB_AP_IMC_MAIN_LP_EB                                                       0x10000
#define MASK_AP_AHB_AP_IMC_MAIN_LP_NUM                                                      0xffff
#define MASK_AP_AHB_AP_DISP_MAIN_FORCE_ACK                                                  0x80000
#define MASK_AP_AHB_AP_DISP_MAIN_LP_STAT                                                    0x40000
#define MASK_AP_AHB_AP_DISP_MAIN_LP_FORCE                                                   0x20000
#define MASK_AP_AHB_AP_DISP_MAIN_LP_EB                                                      0x10000
#define MASK_AP_AHB_AP_DISP_MAIN_LP_NUM                                                     0xffff
#define MASK_AP_AHB_CA7_TOP_M0_FORCE_ACK                                                    0x80000
#define MASK_AP_AHB_CA7_TOP_M0_LP_STAT                                                      0x40000
#define MASK_AP_AHB_CA7_TOP_M0_LP_FORCE                                                     0x20000
#define MASK_AP_AHB_CA7_TOP_M0_LP_EB                                                        0x10000
#define MASK_AP_AHB_CA7_TOP_M0_LP_NUM                                                       0xffff
#define MASK_AP_AHB_CA7_TOP_S1_FORCE_ACK                                                    0x80000
#define MASK_AP_AHB_CA7_TOP_S1_LP_STAT                                                      0x40000
#define MASK_AP_AHB_CA7_TOP_S1_LP_FORCE                                                     0x20000
#define MASK_AP_AHB_CA7_TOP_S1_LP_EB                                                        0x10000
#define MASK_AP_AHB_CA7_TOP_S1_LP_NUM                                                       0xffff
#define MASK_AP_AHB_CA7_TOP_S2_FORCE_ACK                                                    0x80000
#define MASK_AP_AHB_CA7_TOP_S2_LP_STAT                                                      0x40000
#define MASK_AP_AHB_CA7_TOP_S2_LP_FORCE                                                     0x20000
#define MASK_AP_AHB_CA7_TOP_S2_LP_EB                                                        0x10000
#define MASK_AP_AHB_CA7_TOP_S2_LP_NUM                                                       0xffff
#define MASK_AP_AHB_CA7_ABRG_S0_FORCE_ACK                                                   0x80000
#define MASK_AP_AHB_CA7_ABRG_S0_LP_STAT                                                     0x40000
#define MASK_AP_AHB_CA7_ABRG_S0_LP_FORCE                                                    0x20000
#define MASK_AP_AHB_CA7_ABRG_S0_LP_EB                                                       0x10000
#define MASK_AP_AHB_CA7_ABRG_S0_LP_NUM                                                      0xffff
#define MASK_AP_AHB_TEE_DMA_EB                                                              0x1
#define MASK_AP_AHB_USB_AHBM2AXI_S0_FORCE_ACK                                               0x80000
#define MASK_AP_AHB_USB_AHBM2AXI_S0_LP_STAT                                                 0x40000
#define MASK_AP_AHB_USB_AHBM2AXI_S0_LP_FORCE                                                0x20000
#define MASK_AP_AHB_USB_AHBM2AXI_S0_LP_EB                                                   0x10000
#define MASK_AP_AHB_USB_AHBM2AXI_S0_LP_NUM                                                  0xffff
#define MASK_AP_AHB_CA7_EMC_REG_SLICE_FORCE_ACK                                             0x80000
#define MASK_AP_AHB_CA7_EMC_REG_SLICE_LP_STAT                                               0x40000
#define MASK_AP_AHB_CA7_EMC_REG_SLICE_LP_FORCE                                              0x20000
#define MASK_AP_AHB_CA7_EMC_REG_SLICE_LP_EB                                                 0x10000
#define MASK_AP_AHB_CA7_EMC_REG_SLICE_LP_NUM                                                0xffff
#define MASK_AP_AHB_AP_DUMMY_REG0_H16                                                       0xffff0000
#define MASK_AP_AHB_AP_DUMMY_REG0_L16                                                       0xffff
#define MASK_AP_AHB_AP_DUMMY_REG1                                                           0xffffffff
#define MASK_AP_AHB_AP_DUMMY_REG2                                                           0xffffffff
#define MASK_AP_AHB_AP_DUMMY_REG3                                                           0xffffffff
#define MASK_AP_AHB_CA7_DUMMY_REG0_H16                                                      0xffff0000
#define MASK_AP_AHB_CA7_DUMMY_REG0_L16                                                      0xffff
#define MASK_AP_AHB_CA7_DUMMY_REG1                                                          0xffffffff
#define MASK_AP_AHB_CA7_C3_CORE_INT_DISABLE_EN                                              0x8
#define MASK_AP_AHB_CA7_C2_CORE_INT_DISABLE_EN                                              0x4
#define MASK_AP_AHB_CA7_C1_CORE_INT_DISABLE_EN                                              0x2
#define MASK_AP_AHB_CA7_C0_CORE_INT_DISABLE_EN                                              0x1
#define MASK_AP_AHB_CA7_STANDBYWFIL2                                                        0x1000
#define MASK_AP_AHB_CA7_ETMSTANDBYWFX                                                       0xf00
#define MASK_AP_AHB_CA7_STANDBYWFE                                                          0xf0
#define MASK_AP_AHB_CA7_STANDBYWFI                                                          0xf
#define MASK_AP_AHB_HPROT_OTG                                                               0xf00
#define MASK_AP_AHB_ARQOS_AP_GSP_M0                                                         0xf0
#define MASK_AP_AHB_AWQOS_AP_GSP_M0                                                         0xf
#define MASK_AP_AHB_OTG_TXPREEMPPULSETUNE                                                   0x100000
#define MASK_AP_AHB_OTG_TXRESTUNE                                                           0xc0000
#define MASK_AP_AHB_OTG_TXHSXVTUNE                                                          0x30000
#define MASK_AP_AHB_OTG_TXVREFTUNE                                                          0xf000
#define MASK_AP_AHB_OTG_TXPREEMPAMPTUNE                                                     0xc00
#define MASK_AP_AHB_OTG_TXRISETUNE                                                          0x300
#define MASK_AP_AHB_OTG_TXFSLSTUNE                                                          0xf0
#define MASK_AP_AHB_OTG_SQRXTUNE                                                            0x7
#define MASK_AP_AHB_OTG_ATERESET                                                            0x80000000
#define MASK_AP_AHB_OTG_VBUS_VALID_PHYREG                                                   0x1000000
#define MASK_AP_AHB_OTG_VBUS_VALID_PHYREG_SEL                                               0x800000
#define MASK_AP_AHB_OTG_VBUS_VALID_EXT                                                      0x400000
#define MASK_AP_AHB_OTG_TESTBURNIN                                                          0x200000
#define MASK_AP_AHB_OTG_LOOPBACKENB                                                         0x100000
#define MASK_AP_AHB_OTG_TESTDATAOUT                                                         0xf0000
#define MASK_AP_AHB_OTG_VATESTENB                                                           0xc000
#define MASK_AP_AHB_OTG_TESTCLK                                                             0x2000
#define MASK_AP_AHB_OTG_TESTDATAOUTSEL                                                      0x1000
#define MASK_AP_AHB_OTG_TESTADDR                                                            0xf00
#define MASK_AP_AHB_OTG_TESTDATAIN                                                          0xff
#define MASK_AP_AHB_USB2_CON_TESTMODE                                                       0x80000000
#define MASK_AP_AHB_UTMI_WIDTH_SEL                                                          0x40000000
#define MASK_AP_AHB_USB2_DATABUS16_8                                                        0x20000000
#define MASK_AP_AHB_OTG_SS_SCALEDOWNMODE                                                    0x6000000
#define MASK_AP_AHB_OTG_TXBITSTUFFENH                                                       0x800000
#define MASK_AP_AHB_OTG_TXBITSTUFFEN                                                        0x400000
#define MASK_AP_AHB_OTG_DMPULLDOWN                                                          0x200000
#define MASK_AP_AHB_OTG_DPPULLDOWN                                                          0x100000
#define MASK_AP_AHB_OTG_DMPULLUP                                                            0x200
#define MASK_AP_AHB_OTG_COMMONONN                                                           0x100
#define MASK_AP_AHB_USB2_PHY_IDDIG                                                          0x8
#define MASK_AP_AHB_OTG_FSEL                                                                0x7
#define MASK_AP_AHB_USB20_TUNEHSAMP                                                         0xc0000000
#define MASK_AP_AHB_USB20_TUNEPLLS                                                          0x30000000
#define MASK_AP_AHB_USB20_TUNERISE                                                          0xc000000
#define MASK_AP_AHB_USB20_TUNEDSC                                                           0x3000000
#define MASK_AP_AHB_USB20_TUNEOTG                                                           0xe00000
#define MASK_AP_AHB_USB20_TUNESQ                                                            0x1e0000
#define MASK_AP_AHB_USB20_RESERVED                                                          0xffff
#define MASK_AP_AHB_USB20_BIST_MODE                                                         0xf800000
#define MASK_AP_AHB_USB20_BYPASS_DRV_DM                                                     0x400000
#define MASK_AP_AHB_USB20_BYPASS_DRV_DP                                                     0x200000
#define MASK_AP_AHB_USB20_SAMPLER_SEL                                                       0x100000
#define MASK_AP_AHB_HSIC_PLLON                                                              0x10000
#define MASK_AP_AHB_USB20_REXTENABLE                                                        0x8000
#define MASK_AP_AHB_USB20_S_ID                                                              0x4000
#define MASK_AP_AHB_USB20_TFREGRES                                                          0x3f00
#define MASK_AP_AHB_USB20_TFHSRES                                                           0xf8
#define MASK_AP_AHB_USB20_TUNEEQ                                                            0x7
#define MASK_AP_AHB_CHIP_ID                                                                 0xffffffff
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTHSCLK                           0x10
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSCLK                                0x8
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXITCLK                            0x4
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_STOPSTATECLK                             0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ULPSACTIVENOTCLK                         0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTDATAHS_0                        0x400
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTESC_0                           0x200
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXLPDTESC_0                              0x100
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSESC_0                              0x80
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXIT_0                             0x40
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXTRIGGERESC_0                           0x3c
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXVALIDESC_0                             0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREADYESC_0                             0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTDATAHS_1                        0x400
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTESC_1                           0x200
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXLPDTESC_1                              0x100
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSESC_1                              0x80
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXIT_1                             0x40
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXTRIGGERESC_1                           0x3c
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXVALIDESC_1                             0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREADYESC_1                             0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTDATAHS_2                        0x400
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTESC_2                           0x200
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXLPDTESC_2                              0x100
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSESC_2                              0x80
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXIT_2                             0x40
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXTRIGGERESC_2                           0x3c
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXVALIDESC_2                             0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXREADYESC_2                             0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXDATAESC_0                              0xff0000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXDATAESC_1                              0xff00
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXDATAESC_2                              0xff
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXCLKESC_0                               0x100000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXLPDTESC_0                              0x80000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXTRIGGERESC_0                           0x78000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXVALIDESC_0                             0x4000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXCLKESC_1                               0x2000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXLPDTESC_1                              0x1000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXTRIGGERESC_1                           0xf00
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXVALIDESC_1                             0x80
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXCLKESC_2                               0x40
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXLPDTESC_2                              0x20
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXTRIGGERESC_2                           0x1e
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RXVALIDESC_2                             0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRESC_0                                 0x4000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRSYNCESC_0                             0x2000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTROL_0                             0x1000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTENTIONLP0_0                       0x800
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTENTIONLP1_0                       0x400
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRESC_1                                 0x200
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRSYNCESC_1                             0x100
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTROL_1                             0x80
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTENTIONLP0_1                       0x40
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTENTIONLP1_1                       0x20
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRESC_2                                 0x10
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRSYNCESC_2                             0x8
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTROL_2                             0x4
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTENTIONLP0_2                       0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ERRCONTENTIONLP1_2                       0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_PS_PD_S                                  0x800000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_PS_PD_L                                  0x400000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_SHUTDOWNZ                                0x200000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RSTZ                                     0x100000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ENABLE_0                                 0x80000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ENABLE_1                                 0x40000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ENABLE_2                                 0x20000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ENABLECLK                                0x10000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCEPLL                                 0x8000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXBITCLKN                                0x4000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TXBITCLKP                                0x2000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_ISO_SW_EN                                0x1000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_PLLLOCK                                  0x800
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_BISTON                                   0x400
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_BISTDONE                                 0x200
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_IF_SEL                                   0x100
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TRIMBG                                   0xf0
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TX_RCTL                                  0xf
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RESERVED                                 0xff00
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_RESERVEDO                                0xff
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TESTDIN                                  0x7f800
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TESTDOUT                                 0x7f8
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TESTEN                                   0x4
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TESTCLK                                  0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TESTCLR                                  0x1
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TURNREQUEST_0                            0x10000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_DIRECTION_0                              0x8000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TURNDISABLE_0                            0x4000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCERXMODE_0                            0x2000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCETXSTOPMODE_0                        0x1000
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_STOPSTATEDATA_0                          0x800
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TURNREQUEST_1                            0x400
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TURNDISABLE_1                            0x200
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCERXMODE_1                            0x100
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCETXSTOPMODE_1                        0x80
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_STOPSTATEDATA_1                          0x40
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TURNREQUEST_2                            0x20
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_DIRECTION_2                              0x10
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_TURNDISABLE_2                            0x8
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCERXMODE_2                            0x4
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_FORCETXSTOPMODE_2                        0x2
#define MASK_ANLG_PHY_G5_ANALOG_MIPI_DSI_3LANE_DSI_STOPSTATEDATA_2                          0x1
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTHSCLK                   0x80000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSCLK                        0x40000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXITCLK                    0x20000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTDATAHS_0                0x10000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTESC_0                   0x8000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXLPDTESC_0                      0x4000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSESC_0                      0x2000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXIT_0                     0x1000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXTRIGGERESC_0                   0x800000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXVALIDESC_0                     0x400000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTDATAHS_1                0x200000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTESC_1                   0x100000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXLPDTESC_1                      0x80000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSESC_1                      0x40000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXIT_1                     0x20000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXTRIGGERESC_1                   0x10000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXVALIDESC_1                     0x8000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTDATAHS_2                0x4000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXREQUESTESC_2                   0x2000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXLPDTESC_2                      0x1000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSESC_2                      0x800
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXULPSEXIT_2                     0x400
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXTRIGGERESC_2                   0x200
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXVALIDESC_2                     0x100
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXDATAESC_0                      0x80
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXDATAESC_1                      0x40
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TXDATAESC_2                      0x20
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_PS_PD_S                          0x10
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_PS_PD_L                          0x8
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_SHUTDOWNZ                        0x4
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_RSTZ                             0x2
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_ENABLE_0                         0x1
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_ENABLE_1                         0x2000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_ENABLE_2                         0x1000000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_ENABLECLK                        0x800000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCEPLL                         0x400000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_ISO_SW_EN                        0x200000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_BISTON                           0x100000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_IF_SEL                           0x80000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TRIMBG                           0x40000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TX_RCTL                          0x20000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_RESERVED                         0x10000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TESTDIN                          0x8000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TESTEN                           0x4000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TESTCLK                          0x2000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TESTCLR                          0x1000
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TURNREQUEST_0                    0x800
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TURNDISABLE_0                    0x400
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCERXMODE_0                    0x200
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCETXSTOPMODE_0                0x100
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TURNREQUEST_1                    0x80
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TURNDISABLE_1                    0x40
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCERXMODE_1                    0x20
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCETXSTOPMODE_1                0x10
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TURNREQUEST_2                    0x8
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_TURNDISABLE_2                    0x4
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCERXMODE_2                    0x2
#define MASK_ANLG_PHY_G5_DBG_SEL_ANALOG_MIPI_DSI_3LANE_DSI_FORCETXSTOPMODE_2                0x1
#define MASK_AON_APB_I2C_EB                                                                 0x80000000
#define MASK_AON_APB_CA7_DAP_EB                                                             0x40000000
#define MASK_AON_APB_CA7_TS1_EB                                                             0x20000000
#define MASK_AON_APB_CA7_TS0_EB                                                             0x10000000
#define MASK_AON_APB_GPU_EB                                                                 0x8000000
#define MASK_AON_APB_CKG_EB                                                                 0x4000000
#define MASK_AON_APB_MM_EB                                                                  0x2000000
#define MASK_AON_APB_AP_WDG_EB                                                              0x1000000
#define MASK_AON_APB_SPLK_EB                                                                0x400000
#define MASK_AON_APB_PIN_EB                                                                 0x100000
#define MASK_AON_APB_VBC_EB                                                                 0x80000
#define MASK_AON_APB_AUD_EB                                                                 0x40000
#define MASK_AON_APB_AUDIF_EB                                                               0x20000
#define MASK_AON_APB_ADI_EB                                                                 0x10000
#define MASK_AON_APB_INTC_EB                                                                0x8000
#define MASK_AON_APB_EIC_EB                                                                 0x4000
#define MASK_AON_APB_REE_EFUSE_EB                                                           0x2000
#define MASK_AON_APB_AP_TMR0_EB                                                             0x1000
#define MASK_AON_APB_AON_TMR_EB                                                             0x800
#define MASK_AON_APB_AP_SYST_EB                                                             0x400
#define MASK_AON_APB_AON_SYST_EB                                                            0x200
#define MASK_AON_APB_KPD_EB                                                                 0x100
#define MASK_AON_APB_PWM3_EB                                                                0x80
#define MASK_AON_APB_PWM2_EB                                                                0x40
#define MASK_AON_APB_PWM1_EB                                                                0x20
#define MASK_AON_APB_PWM0_EB                                                                0x10
#define MASK_AON_APB_GPIO_EB                                                                0x8
#define MASK_AON_APB_SERDES_DPHY_EB                                                         0x80000000
#define MASK_AON_APB_CROSS_TRIG_EB                                                          0x40000000
#define MASK_AON_APB_DBG_EMC_EB                                                             0x20000000
#define MASK_AON_APB_DBG_EB                                                                 0x10000000
#define MASK_AON_APB_DEF_EB                                                                 0x2000000
#define MASK_AON_APB_WCN_EB                                                                 0x1000000
#define MASK_AON_APB_CM4_JTAG_EB                                                            0x800000
#define MASK_AON_APB_REE_AON_DMA_EB                                                         0x400000
#define MASK_AON_APB_MBOX_EB                                                                0x200000
#define MASK_AON_APB_DJTAG_EB                                                               0x100000
#define MASK_AON_APB_RTC4M0_CAL_EB                                                          0x40000
#define MASK_AON_APB_MDAR_EB                                                                0x20000
#define MASK_AON_APB_MM_VSP_EB                                                              0x4000
#define MASK_AON_APB_GSP_EMC_EB                                                             0x2000
#define MASK_AON_APB_DJTAG_APB_EB                                                           0x800
#define MASK_AON_APB_AP_TMR2_EB                                                             0x400
#define MASK_AON_APB_AP_TMR1_EB                                                             0x200
#define MASK_AON_APB_CA7_WDG_EB                                                             0x100
#define MASK_AON_APB_CLK_EMC_REF_EB                                                         0x80
#define MASK_AON_APB_AVS_EB                                                                 0x40
#define MASK_AON_APB_PROBE_EB                                                               0x20
#define MASK_AON_APB_AUX2_EB                                                                0x10
#define MASK_AON_APB_AUX1_EB                                                                0x8
#define MASK_AON_APB_AUX0_EB                                                                0x4
#define MASK_AON_APB_THM_EB                                                                 0x2
#define MASK_AON_APB_PMU_EB                                                                 0x1
#define MASK_AON_APB_CA5_TS0_SOFT_RST                                                       0x80000000
#define MASK_AON_APB_I2C_SOFT_RST                                                           0x40000000
#define MASK_AON_APB_CA7_TS1_SOFT_RST                                                       0x20000000
#define MASK_AON_APB_CA7_TS0_SOFT_RST                                                       0x10000000
#define MASK_AON_APB_DAP_MTX_SOFT_RST                                                       0x8000000
#define MASK_AON_APB_SPLK_SOFT_RST                                                          0x1000000
#define MASK_AON_APB_IPI_SOFT_RST                                                           0x800000
#define MASK_AON_APB_CKG_SOFT_RST                                                           0x400000
#define MASK_AON_APB_PIN_SOFT_RST                                                           0x200000
#define MASK_AON_APB_VBC_SOFT_RST                                                           0x100000
#define MASK_AON_APB_AUD_SOFT_RST                                                           0x80000
#define MASK_AON_APB_AUDIF_SOFT_RST                                                         0x40000
#define MASK_AON_APB_ADI_SOFT_RST                                                           0x20000
#define MASK_AON_APB_INTC_SOFT_RST                                                          0x10000
#define MASK_AON_APB_EIC_SOFT_RST                                                           0x8000
#define MASK_AON_APB_EFUSE_SOFT_RST                                                         0x4000
#define MASK_AON_APB_AP_WDG_SOFT_RST                                                        0x2000
#define MASK_AON_APB_AP_TMR0_SOFT_RST                                                       0x1000
#define MASK_AON_APB_AON_TMR_SOFT_RST                                                       0x800
#define MASK_AON_APB_AP_SYST_SOFT_RST                                                       0x400
#define MASK_AON_APB_AON_SYST_SOFT_RST                                                      0x200
#define MASK_AON_APB_KPD_SOFT_RST                                                           0x100
#define MASK_AON_APB_PWM3_SOFT_RST                                                          0x80
#define MASK_AON_APB_PWM2_SOFT_RST                                                          0x40
#define MASK_AON_APB_PWM1_SOFT_RST                                                          0x20
#define MASK_AON_APB_PWM0_SOFT_RST                                                          0x10
#define MASK_AON_APB_GPIO_SOFT_RST                                                          0x8
#define MASK_AON_APB_SOFT_RST                                                               0x4
#define MASK_AON_APB_FM_SOFT_RST                                                            0x2
#define MASK_AON_APB_ADC_SOFT_RST                                                           0x1
#define MASK_AON_APB_RTC4M_ANA_SOFT_RST                                                     0x80000000
#define MASK_AON_APB_DEF_SLV_INT_SOFT_CLR                                                   0x40000000
#define MASK_AON_APB_DEF_SOFT_RST                                                           0x20000000
#define MASK_AON_APB_ADC3_SOFT_RST                                                          0x10000000
#define MASK_AON_APB_ADC2_SOFT_RST                                                          0x8000000
#define MASK_AON_APB_ADC1_SOFT_RST                                                          0x4000000
#define MASK_AON_APB_MBOX_SOFT_RST                                                          0x2000000
#define MASK_AON_APB_ROSC_SOFT_RST                                                          0x1000000
#define MASK_AON_APB_RTC4M0_CAL_SOFT_RST                                                    0x400000
#define MASK_AON_APB_SIM_AON_TOP_AP_SIM0_SOFT_RST                                           0x8000
#define MASK_AON_APB_SIM_AON_TOP_PUBCP_SIM2_SOFT_RST                                        0x4000
#define MASK_AON_APB_SIM_AON_TOP_PUBCP_SIM1_SOFT_RST                                        0x2000
#define MASK_AON_APB_SIM_AON_TOP_PUBCP_SIM0_SOFT_RST                                        0x1000
#define MASK_AON_APB_BB_CAL_SOFT_RST                                                        0x800
#define MASK_AON_APB_DCXO_LC_SOFT_RST                                                       0x400
#define MASK_AON_APB_AP_TMR2_SOFT_RST                                                       0x200
#define MASK_AON_APB_AP_TMR1_SOFT_RST                                                       0x100
#define MASK_AON_APB_CA7_WDG_SOFT_RST                                                       0x80
#define MASK_AON_APB_AON_DMA_SOFT_RST                                                       0x40
#define MASK_AON_APB_AVS_SOFT_RST                                                           0x20
#define MASK_AON_APB_GPU_THMA_SOFT_RST                                                      0x8
#define MASK_AON_APB_ARM_THMA_SOFT_RST                                                      0x4
#define MASK_AON_APB_THM_SOFT_RST                                                           0x2
#define MASK_AON_APB_PMU_SOFT_RST                                                           0x1
#define MASK_AON_APB_BB_CAL_RTC_EB                                                          0x40000
#define MASK_AON_APB_DCXO_LC_RTC_EB                                                         0x20000
#define MASK_AON_APB_AP_TMR2_RTC_EB                                                         0x10000
#define MASK_AON_APB_AP_TMR1_RTC_EB                                                         0x8000
#define MASK_AON_APB_GPU_THMA_RTC_AUTO_EN                                                   0x4000
#define MASK_AON_APB_ARM_THMA_RTC_AUTO_EN                                                   0x2000
#define MASK_AON_APB_GPU_THMA_RTC_EB                                                        0x1000
#define MASK_AON_APB_ARM_THMA_RTC_EB                                                        0x800
#define MASK_AON_APB_THM_RTC_EB                                                             0x400
#define MASK_AON_APB_CA7_WDG_RTC_EB                                                         0x200
#define MASK_AON_APB_AP_WDG_RTC_EB                                                          0x100
#define MASK_AON_APB_EIC_RTCDV5_EB                                                          0x80
#define MASK_AON_APB_EIC_RTC_EB                                                             0x40
#define MASK_AON_APB_AP_TMR0_RTC_EB                                                         0x20
#define MASK_AON_APB_AON_TMR_RTC_EB                                                         0x10
#define MASK_AON_APB_AP_SYST_RTC_EB                                                         0x8
#define MASK_AON_APB_AON_SYST_RTC_EB                                                        0x4
#define MASK_AON_APB_KPD_RTC_EB                                                             0x2
#define MASK_AON_APB_ARCH_RTC_EB                                                            0x1
#define MASK_AON_APB_PLL_PROBE_SEL                                                          0x3f00
#define MASK_AON_APB_TEE_AON_DMA_EB                                                         0x2
#define MASK_AON_APB_TEE_EFUSE_EB                                                           0x1
#define MASK_AON_APB_AUDIF_CKG_AUTO_EN                                                      0x100000
#define MASK_AON_APB_AUD_INT_SYS_SEL                                                        0xc0000
#define MASK_AON_APB_VBC_DA23_INT_SYS_SEL                                                   0x30000
#define MASK_AON_APB_VBC_AD23_INT_SYS_SEL                                                   0xc000
#define MASK_AON_APB_VBC_AD01_INT_SYS_SEL                                                   0x3000
#define MASK_AON_APB_VBC_DA01_INT_SYS_SEL                                                   0xc00
#define MASK_AON_APB_VBC_AD23_DMA_SYS_SEL                                                   0x300
#define MASK_AON_APB_VBC_AD01_DMA_SYS_SEL                                                   0xc0
#define MASK_AON_APB_VBC_DA01_DMA_SYS_SEL                                                   0x30
#define MASK_AON_APB_VBC_DA23_DMA_SYS_SEL                                                   0xc
#define MASK_AON_APB_FORCE_DSI_DBG_PHY_SHUTDOWNZ                                            0x200000
#define MASK_AON_APB_FORCE_CSI_S_PHY_SHUTDOWNZ                                              0x100000
#define MASK_AON_APB_USB_PHY_PD_S                                                           0x20000
#define MASK_AON_APB_USB_PHY_PD_L                                                           0x10000
#define MASK_AON_APB_MIPI_DSI_PS_PD_S                                                       0x8000
#define MASK_AON_APB_MIPI_DSI_PS_PD_L                                                       0x4000
#define MASK_AON_APB_MIPI_CSI_4P2LANE_PS_PD_S                                               0x2000
#define MASK_AON_APB_MIPI_CSI_4P2LANE_PS_PD_L                                               0x1000
#define MASK_AON_APB_USB_REF_ATE_SEL                                                        0x100
#define MASK_AON_APB_EFUSE_BIST_PWR_ON                                                      0x8
#define MASK_AON_APB_FORCE_DSI_PHY_SHUTDOWNZ                                                0x4
#define MASK_AON_APB_FORCE_CSI_PHY_SHUTDOWNZ                                                0x2
#define MASK_AON_APB_DSI_REFCLK_SEL                                                         0x1
#define MASK_AON_APB_DBG_TRACE_CTRL_EN                                                      0x4000
#define MASK_AON_APB_EVENTACK_RESTARTREQ_TS01                                               0x10
#define MASK_AON_APB_EVENT_RESTARTREQ_TS01                                                  0x2
#define MASK_AON_APB_EVENT_HALTREQ_TS01                                                     0x1
#define MASK_AON_APB_PTEST_FUNC_ATSPEED_SEL                                                 0x100
#define MASK_AON_APB_PTEST_FUNC_MODE                                                        0x80
#define MASK_AON_APB_FUNCTST_DMA_EB                                                         0x20
#define MASK_AON_APB_USB_DLOAD_EN                                                           0x10
#define MASK_AON_APB_ARM_BOOT_MD3                                                           0x8
#define MASK_AON_APB_ARM_BOOT_MD2                                                           0x4
#define MASK_AON_APB_ARM_BOOT_MD1                                                           0x2
#define MASK_AON_APB_ARM_BOOT_MD0                                                           0x1
#define MASK_AON_APB_ENABLE_BBPLL_307P2M_SEL                                                0x20
#define MASK_AON_APB_ENABLE_BBPLL_307P2M_REG                                                0x10
#define MASK_AON_APB_ENABLE_BBPLL_416M_SEL                                                  0x8
#define MASK_AON_APB_ENABLE_BBPLL_416M_REG                                                  0x4
#define MASK_AON_APB_ENABLE_BBPLL_624M_SEL                                                  0x2
#define MASK_AON_APB_ENABLE_BBPLL_624M_REG                                                  0x1
#define MASK_AON_APB_GPLL_SOFT_CNT_DONE                                                     0x10
#define MASK_AON_APB_CPLL_SOFT_CNT_DONE                                                     0x8
#define MASK_AON_APB_TWPLL_SOFT_CNT_DONE                                                    0x4
#define MASK_AON_APB_DPLL_SOFT_CNT_DONE                                                     0x2
#define MASK_AON_APB_MPLL_SOFT_CNT_DONE                                                     0x1
#define MASK_AON_APB_DCXO_LC_FLAG                                                           0x100
#define MASK_AON_APB_DCXO_LC_FLAG_CLR                                                       0x2
#define MASK_AON_APB_DCXO_LC_CNT_CLR                                                        0x1
#define MASK_AON_APB_DCXO_LC_CNT                                                            0xffffffff
#define MASK_AON_APB_MPLL_RESERVED                                                          0x3c00000
#define MASK_AON_APB_MPLL_LOCK_DONE                                                         0x200000
#define MASK_AON_APB_MPLL_DIV_S                                                             0x100000
#define MASK_AON_APB_MPLL_MOD_EN                                                            0x80000
#define MASK_AON_APB_MPLL_SDM_EN                                                            0x40000
#define MASK_AON_APB_MPLL_REF_SEL                                                           0x10000
#define MASK_AON_APB_MPLL_TEST_EN                                                           0x8000
#define MASK_AON_APB_MPLL_IL_DIV2                                                           0x4000
#define MASK_AON_APB_MPLL_OL_DIV2                                                           0x2000
#define MASK_AON_APB_MPLL_IBIAS                                                             0x1800
#define MASK_AON_APB_MPLL_N                                                                 0x7ff
#define MASK_AON_APB_MPLL_NINT                                                              0x3f800000
#define MASK_AON_APB_MPLL_KINT                                                              0x7fffff
#define MASK_AON_APB_DPLL_RESERVED                                                          0x3c00000
#define MASK_AON_APB_DPLL_LOCK_DONE                                                         0x200000
#define MASK_AON_APB_DPLL_DIV_S                                                             0x100000
#define MASK_AON_APB_DPLL_MOD_EN                                                            0x80000
#define MASK_AON_APB_DPLL_SDM_EN                                                            0x40000
#define MASK_AON_APB_DPLL_REF_SEL                                                           0x10000
#define MASK_AON_APB_DPLL_TEST_EN                                                           0x8000
#define MASK_AON_APB_DPLL_IL_DIV2                                                           0x4000
#define MASK_AON_APB_DPLL_OL_DIV2                                                           0x2000
#define MASK_AON_APB_DPLL_IBIAS                                                             0x1800
#define MASK_AON_APB_DPLL_N                                                                 0x7ff
#define MASK_AON_APB_DPLL_NINT                                                              0x3f800000
#define MASK_AON_APB_DPLL_KINT                                                              0x7fffff
#define MASK_AON_APB_TWPLL_RESERVED                                                         0x3c00000
#define MASK_AON_APB_TWPLL_LOCK_DONE                                                        0x200000
#define MASK_AON_APB_TWPLL_DIV_S                                                            0x100000
#define MASK_AON_APB_TWPLL_MOD_EN                                                           0x80000
#define MASK_AON_APB_TWPLL_SDM_EN                                                           0x40000
#define MASK_AON_APB_TWPLL_REF_SEL                                                          0x10000
#define MASK_AON_APB_TWPLL_TEST_EN                                                          0x8000
#define MASK_AON_APB_TWPLL_IL_DIV2                                                          0x4000
#define MASK_AON_APB_TWPLL_OL_DIV2                                                          0x2000
#define MASK_AON_APB_TWPLL_IBIAS                                                            0x1800
#define MASK_AON_APB_TWPLL_N                                                                0x7ff
#define MASK_AON_APB_TWPLL_NINT                                                             0x3f800000
#define MASK_AON_APB_TWPLL_KINT                                                             0x7fffff
#define MASK_AON_APB_TDSP_CTRL_PROT                                                         0x80000000
#define MASK_AON_APB_REG_PROT_REG                                                           0xffff
#define MASK_AON_APB_DSI_IF_SEL                                                             0x1000000
#define MASK_AON_APB_DSI_TRIMBG                                                             0xf00000
#define MASK_AON_APB_DSI_RCTL                                                               0xf0000
#define MASK_AON_APB_DSI_RES                                                                0xffff
#define MASK_AON_APB_CSI_4P2L_CFGCLK_M_EN                                                   0x1000000
#define MASK_AON_APB_CSI_4P2L_TESTCLR_M                                                     0x800000
#define MASK_AON_APB_CSI_4P2L_TESTCLR_M_SEL                                                 0x400000
#define MASK_AON_APB_CSI_4P2L_TESTCLK_M_EN                                                  0x200000
#define MASK_AON_APB_CSI_4P2L_M_IF_SEL                                                      0x100000
#define MASK_AON_APB_CSI_4P2L_RCTL                                                          0xf0000
#define MASK_AON_APB_CSI_4P2L_RES                                                           0xffff
#define MASK_AON_APB_CSI_4P2L_DBG_EN                                                        0x2000000
#define MASK_AON_APB_CSI_4P2L_DBG_IF_SEL                                                    0x1000000
#define MASK_AON_APB_CSI_4P2L_DBG_TRIMBG                                                    0xf00000
#define MASK_AON_APB_CSI_4P2L_MODE_SEL                                                      0x1
#define MASK_AON_APB_PROBE_CKG_DIV                                                          0xf0000000
#define MASK_AON_APB_AUX2_CKG_DIV                                                           0xf000000
#define MASK_AON_APB_AUX1_CKG_DIV                                                           0xf00000
#define MASK_AON_APB_AUX0_CKG_DIV                                                           0xf0000
#define MASK_AON_APB_PROBE_CKG_SEL                                                          0xf000
#define MASK_AON_APB_AUX2_CKG_SEL                                                           0xf00
#define MASK_AON_APB_AUX1_CKG_SEL                                                           0xf0
#define MASK_AON_APB_AUX0_CKG_SEL                                                           0xf
#define MASK_AON_APB_PUB_DFS_SW_SWITCH_PERIOD                                               0xff0000
#define MASK_AON_APB_PUB_DFS_SW_RATIO                                                       0x7c0
#define MASK_AON_APB_PUB_DFS_SW_FRQ_SEL                                                     0x30
#define MASK_AON_APB_PUB_DFS_SW_RESP                                                        0x8
#define MASK_AON_APB_PUB_DFS_SW_ACK                                                         0x4
#define MASK_AON_APB_PUB_DFS_SW_REQ                                                         0x2
#define MASK_AON_APB_PUB_DFS_SW_ENABLE                                                      0x1
#define MASK_AON_APB_PUB_DFS_HW_INITIAL_FREQ                                                0x18
#define MASK_AON_APB_PUB_DFS_HW_STOP                                                        0x4
#define MASK_AON_APB_PUB_DFS_HW_START                                                       0x2
#define MASK_AON_APB_PUB_DFS_HW_ENABLE                                                      0x1
#define MASK_AON_APB_PUB_DFS_HW_SWITCH_PERIOD                                               0xff00000
#define MASK_AON_APB_PUB_DFS_HW_F3_RATIO                                                    0xf8000
#define MASK_AON_APB_PUB_DFS_HW_F2_RATIO                                                    0x7c00
#define MASK_AON_APB_PUB_DFS_HW_F1_RATIO                                                    0x3e0
#define MASK_AON_APB_PUB_DFS_HW_F0_RATIO                                                    0x1f
#define MASK_AON_APB_WCN_WIFI_DFS_REQ_TO_PUB_EB                                             0x20
#define MASK_AON_APB_WCN_WIFI_DFS_ACK_INT_CLR                                               0x10
#define MASK_AON_APB_WCN_WIFI_DFS_ACK_INT_EN                                                0x8
#define MASK_AON_APB_WCN_WIFI_DFS_ACK_INT_STAT                                              0x4
#define MASK_AON_APB_WCN_WIFI_DFS_ACK                                                       0x2
#define MASK_AON_APB_WCN_WIFI_DFS_REQ                                                       0x1
#define MASK_AON_APB_AP_DAP_EB                                                              0x8000
#define MASK_AON_APB_BSMTMR_EB                                                              0x4000
#define MASK_AON_APB_ANLG_APB_EB                                                            0x2000
#define MASK_AON_APB_PIN_APB_EB                                                             0x1000
#define MASK_AON_APB_ANLG_EB                                                                0x800
#define MASK_AON_APB_BUSMON_DMA_EB                                                          0x400
#define MASK_AON_APB_SERDES_DPHY_REF_EB                                                     0x200
#define MASK_AON_APB_SERDES_DPHY_CFG_EB                                                     0x100
#define MASK_AON_APB_ROSC_EB                                                                0x80
#define MASK_AON_APB_PUB_REG_EB                                                             0x40
#define MASK_AON_APB_DMC_EB                                                                 0x20
#define MASK_AON_APB_CSSYS_EB                                                               0x10
#define MASK_AON_APB_WCDMA_ICI_EB                                                           0x2
#define MASK_AON_APB_WCDMA_EB                                                               0x1
#define MASK_AON_APB_WCNTODDR_ADDR_OFFSET                                                   0xff00
#define MASK_AON_APB_WCNTOAON_ADDR_OFFSET                                                   0xf
#define MASK_AON_APB_RG_TSEN_CHOP_CLKSEL                                                    0x3000000
#define MASK_AON_APB_RG_TSEN_CLKSEL                                                         0x300000
#define MASK_AON_APB_RG_TSEN_SDADC_BIAS                                                     0x30000
#define MASK_AON_APB_RG_TSEN_UGBUF_BIAS                                                     0x3000
#define MASK_AON_APB_RG_TSEN_SDADC_VCMI                                                     0x300
#define MASK_AON_APB_RG_TSEN_SDADC_VCMO                                                     0x30
#define MASK_AON_APB_RG_UGBUF_CTRL                                                          0x3
#define MASK_AON_APB_RG_TSEN_ADCLDO_EN                                                      0x4000000
#define MASK_AON_APB_RG_TSEN_SDADC_CAPCHOP_EN                                               0x2000000
#define MASK_AON_APB_RG_TSEN_SDADC_CHOP_EN                                                  0x1000000
#define MASK_AON_APB_RG_TSEN_UGBUF_CHOP_EN                                                  0x800000
#define MASK_AON_APB_RG_TSEN_SDADC_EN                                                       0x400000
#define MASK_AON_APB_RG_TSEN_SDADC_OFFSET_EN                                                0x200000
#define MASK_AON_APB_RG_TSEN_INPUT_EN                                                       0x100000
#define MASK_AON_APB_RG_TSEN_UGBUF_EN                                                       0x80000
#define MASK_AON_APB_RG_TSEN_SDADC_DATA_EDGE_SEL                                            0x40000
#define MASK_AON_APB_RG_TSEN_SDADC_RST                                                      0x20000
#define MASK_AON_APB_RG_TSEN_ADCLDOREF                                                      0x1f00
#define MASK_AON_APB_RG_TSEN_ADCLDO_V                                                       0xf
#define MASK_AON_APB_WCN_GNSS_CM4_ADDR_OFFSET                                               0xffffff00
#define MASK_AON_APB_WCN_OFFCHIP_XTRL_EN                                                    0x20
#define MASK_AON_APB_WCN_XTAL_DIF_SEL_H                                                     0x10
#define MASK_AON_APB_WCN_CM4_ADDR_REMAP_SEL                                                 0x3
#define MASK_AON_APB_AON_CHIP_ID0                                                           0xffffffff
#define MASK_AON_APB_AON_CHIP_ID1                                                           0xffffffff
#define MASK_AON_APB_AON_PLAT_ID0                                                           0xffffffff
#define MASK_AON_APB_AON_PLAT_ID1                                                           0xffffffff
#define MASK_AON_APB_AON_IMPL_ID                                                            0xffffffff
#define MASK_AON_APB_AON_MFT_ID                                                             0xffffffff
#define MASK_AON_APB_AON_VER_ID                                                             0xffffffff
#define MASK_AON_APB_AON_CHIP_ID                                                            0xffffffff
#define MASK_AON_APB_RG_TSEN_BIST_CODE                                                      0x7000
#define MASK_AON_APB_RG_TSEN_TEST_CLK_SEL                                                   0x200
#define MASK_AON_APB_RG_TSEN_BIST_EN                                                        0x100
#define MASK_AON_APB_RG_TSEN_RESERVED                                                       0xff
#define MASK_AON_APB_CM4_SYS_SOFT_RST                                                       0x10
#define MASK_AON_APB_CM4_CORE_SOFT_RST                                                      0x1
#define MASK_AON_APB_AON_DMA_INT_CM4_EN                                                     0x40
#define MASK_AON_APB_AON_DMA_INT_AP_EN                                                      0x1
#define MASK_AON_APB_MAILBOX_PCLK_AUTO_GATE_EN                                              0x80000
#define MASK_AON_APB_WTLCP_PUB_AUTO_GATE_EN                                                 0x40000
#define MASK_AON_APB_AP_PUB_AUTO_GATE_EN                                                    0x20000
#define MASK_AON_APB_AON_APB_PUB_AUTO_GATE_EN                                               0x10000
#define MASK_AON_APB_PUBCP_EMC_AUTO_GATE_EN                                                 0x8
#define MASK_AON_APB_WTLCP_EMC_AUTO_GATE_EN                                                 0x4
#define MASK_AON_APB_AP_EMC_AUTO_GATE_EN                                                    0x2
#define MASK_AON_APB_CA7_EMC_AUTO_GATE_EN                                                   0x1
#define MASK_AON_APB_CM4_CFG_BUS_SLEEP                                                      0x1
#define MASK_AON_APB_TOP_REG_SLICE_SOFT_RST                                                 0xff00000
#define MASK_AON_APB_THM1_SOFT_RST                                                          0x80000
#define MASK_AON_APB_BSMTMR_SOFT_RST                                                        0x40000
#define MASK_AON_APB_WTLCP_TDSP_CORE_SRST                                                   0x20000
#define MASK_AON_APB_WCN_DJTAG_SOFT_RST                                                     0x10000
#define MASK_AON_APB_DIG_DJTAG_SOFT_RST                                                     0x8000
#define MASK_AON_APB_ANLG_SOFT_RST                                                          0x4000
#define MASK_AON_APB_SERDES_DPHY_APB_SOFT_RST                                               0x2000
#define MASK_AON_APB_BUSMON_DMA_SOFT_RST                                                    0x1000
#define MASK_AON_APB_SERDES_DPHY_SOFT_RST                                                   0x800
#define MASK_AON_APB_CROSS_TRIG_SOFT_RST                                                    0x400
#define MASK_AON_APB_SERDES_SOFT_RST                                                        0x200
#define MASK_AON_APB_DBG_SOFT_RST                                                           0x100
#define MASK_AON_APB_DJTAG_SOFT_RST                                                         0x80
#define MASK_AON_APB_AON_DJTAG_SOFT_RST                                                     0x40
#define MASK_AON_APB_PUB_DJTAG_SOFT_RST                                                     0x20
#define MASK_AON_APB_GPU_DJTAG_SOFT_RST                                                     0x10
#define MASK_AON_APB_MM_DJTAG_SOFT_RST                                                      0x8
#define MASK_AON_APB_PUBCP_DJTAG_SOFT_RST                                                   0x4
#define MASK_AON_APB_WTLCP_DJTAG_SOFT_RST                                                   0x2
#define MASK_AON_APB_AP_DJTAG_SOFT_RST                                                      0x1
#define MASK_AON_APB_ALL_PLL_TEST_EB                                                        0x40000
#define MASK_AON_APB_CLK_26M_AUDIO_EB                                                       0x4000
#define MASK_AON_APB_CLK_26M_NFC_EB                                                         0x2000
#define MASK_AON_APB_CLK_26M_DTV_EB                                                         0x1000
#define MASK_AON_APB_TMR_EB                                                                 0x800
#define MASK_AON_APB_DET_32K_EB                                                             0x400
#define MASK_AON_APB_AP_HS_SPI_EB                                                           0x200
#define MASK_AON_APB_CSSYS_CA7_EB                                                           0x100
#define MASK_AON_APB_NANDC_2X_EB                                                            0x80
#define MASK_AON_APB_NANDC_1X_EB                                                            0x40
#define MASK_AON_APB_SDIO1_2X_EB                                                            0x20
#define MASK_AON_APB_SDIO1_1X_EB                                                            0x10
#define MASK_AON_APB_SDIO0_2X_EB                                                            0x8
#define MASK_AON_APB_SDIO0_1X_EB                                                            0x4
#define MASK_AON_APB_EMMC_2X_EB                                                             0x2
#define MASK_AON_APB_EMMC_1X_EB                                                             0x1
#define MASK_AON_APB_CGM_MPLL_CA7_FORCE_EN                                                  0x200
#define MASK_AON_APB_CGM_MPLL_CA7_AUTO_GATE_SEL                                             0x100
#define MASK_AON_APB_MPLL_WAIT_FORCE_EN                                                     0x4
#define MASK_AON_APB_MPLL_WAIT_AUTO_GATE_SEL                                                0x2
#define MASK_AON_APB_CPLL_RESERVED                                                          0x3c00000
#define MASK_AON_APB_CPLL_LOCK_DONE                                                         0x200000
#define MASK_AON_APB_CPLL_DIV_S                                                             0x100000
#define MASK_AON_APB_CPLL_MOD_EN                                                            0x80000
#define MASK_AON_APB_CPLL_SDM_EN                                                            0x40000
#define MASK_AON_APB_CPLL_REF_SEL                                                           0x10000
#define MASK_AON_APB_CPLL_TEST_EN                                                           0x8000
#define MASK_AON_APB_CPLL_IL_DIV2                                                           0x4000
#define MASK_AON_APB_CPLL_OL_DIV2                                                           0x2000
#define MASK_AON_APB_CPLL_IBIAS                                                             0x1800
#define MASK_AON_APB_CPLL_N                                                                 0x7ff
#define MASK_AON_APB_CPLL_NINT                                                              0x3f800000
#define MASK_AON_APB_CPLL_KINT                                                              0x7fffff
#define MASK_AON_APB_GPLL_RESERVED                                                          0x3c00000
#define MASK_AON_APB_GPLL_LOCK_DONE                                                         0x200000
#define MASK_AON_APB_GPLL_DIV_S                                                             0x100000
#define MASK_AON_APB_GPLL_MOD_EN                                                            0x80000
#define MASK_AON_APB_GPLL_SDM_EN                                                            0x40000
#define MASK_AON_APB_GPLL_REF_SEL                                                           0x10000
#define MASK_AON_APB_GPLL_TEST_EN                                                           0x8000
#define MASK_AON_APB_GPLL_IL_DIV2                                                           0x4000
#define MASK_AON_APB_GPLL_OL_DIV2                                                           0x2000
#define MASK_AON_APB_GPLL_IBIAS                                                             0x1800
#define MASK_AON_APB_GPLL_N                                                                 0x7ff
#define MASK_AON_APB_GPLL_NINT                                                              0x3f800000
#define MASK_AON_APB_GPLL_KINT                                                              0x7fffff
#define MASK_AON_APB_BUSMON_DMA_CNT_START                                                   0x1
#define MASK_AON_APB_ANALOG_PLL_RSV                                                         0xff0000
#define MASK_AON_APB_ANA_BB_RSV                                                             0xff
#define MASK_AON_APB_MPLL_BIST_CNT                                                          0xffff0000
#define MASK_AON_APB_MPLL_BIST_CTRL                                                         0x3fe
#define MASK_AON_APB_MPLL_BIST_EN                                                           0x1
#define MASK_AON_APB_DPLL_BIST_CNT                                                          0xffff0000
#define MASK_AON_APB_DPLL_BIST_CTRL                                                         0x3fe
#define MASK_AON_APB_DPLL_BIST_EN                                                           0x1
#define MASK_AON_APB_CPLL_BIST_CNT                                                          0xffff0000
#define MASK_AON_APB_CPLL_BIST_CTRL                                                         0x3fe
#define MASK_AON_APB_CPLL_BIST_EN                                                           0x1
#define MASK_AON_APB_TWPLL_BIST_CNT                                                         0xffff0000
#define MASK_AON_APB_TWPLL_BIST_CTRL                                                        0x3fe
#define MASK_AON_APB_TWPLL_BIST_EN                                                          0x1
#define MASK_AON_APB_GPLL_BIST_CNT                                                          0xffff0000
#define MASK_AON_APB_GPLL_BIST_EN                                                           0x1
#define MASK_AON_APB_CGM_DPLL_40M_AON_FORCE_EN                                              0x400
#define MASK_AON_APB_CGM_DPLL_40M_AON_AUTO_GATE_SEL                                         0x200
#define MASK_AON_APB_CGM_DPLL_AON_FORCE_EN                                                  0x100
#define MASK_AON_APB_CGM_DPLL_AON_AUTO_GATE_SEL                                             0x80
#define MASK_AON_APB_CGM_DPLL_AP_FORCE_EN                                                   0x40
#define MASK_AON_APB_CGM_DPLL_AP_AUTO_GATE_SEL                                              0x20
#define MASK_AON_APB_DPLL_DIV_40M_FORCE_EN                                                  0x10
#define MASK_AON_APB_DPLL_DIV_40M_AUTO_GATE_SEL                                             0x8
#define MASK_AON_APB_DPLL_WAIT_FORCE_EN                                                     0x4
#define MASK_AON_APB_DPLL_WAIT_AUTO_GATE_SEL                                                0x2
#define MASK_AON_APB_SENSOR_PD_POL                                                          0x30
#define MASK_AON_APB_SENSOR_RST_POL                                                         0x3
#define MASK_AON_APB_DSI_ISO_EN                                                             0x4
#define MASK_AON_APB_EFS2_ISO_EN                                                            0x2
#define MASK_AON_APB_EFS01_ISO_EN                                                           0x1
#define MASK_AON_APB_MPLL_CCS_CTRL                                                          0xff
#define MASK_AON_APB_DPLL_CCS_CTRL                                                          0xff
#define MASK_AON_APB_CPLL_CCS_CTRL                                                          0xff
#define MASK_AON_APB_TWPLL_CCS_CTRL                                                         0xff
#define MASK_AON_APB_GPLL_CCS_CTRL                                                          0xff
#define MASK_AON_APB_CP_DAP_PAD_SEL                                                         0x3
#define MASK_AON_APB_CA7_SPNIDEN                                                            0xf000
#define MASK_AON_APB_CA7_SPIDEN                                                             0xf00
#define MASK_AON_APB_CA7_NIDEN                                                              0xf0
#define MASK_AON_APB_CA7_DBGEN                                                              0xf
#define MASK_AON_APB_DAP_DEVICEEN                                                           0x80000000
#define MASK_AON_APB_DAP_DBGEN                                                              0x40000000
#define MASK_AON_APB_DAP_SPIDBGEN                                                           0x20000000
#define MASK_AON_APB_TG_JTAG_EN                                                             0x200
#define MASK_AON_APB_CM4_DBGEN                                                              0x100
#define MASK_AON_APB_CM4_JTAG_EN                                                            0x80
#define MASK_AON_APB_DJTAG_EN                                                               0x40
#define MASK_AON_APB_MJTAG_EN                                                               0x10
#define MASK_AON_APB_CSSYS_NIDEN                                                            0x8
#define MASK_AON_APB_CSSYS_SPNIDEN                                                          0x4
#define MASK_AON_APB_CSSYS_SPIDEN                                                           0x2
#define MASK_AON_APB_CSSYS_DBGEN                                                            0x1
#define MASK_AON_APB_DAP_DEVICEEN_S                                                         0x2000000
#define MASK_AON_APB_DAP_DBGEN_S                                                            0x1000000
#define MASK_AON_APB_DAP_SPIDBGEN_S                                                         0x800000
#define MASK_AON_APB_CR5_DBGEN_S                                                            0x10000
#define MASK_AON_APB_CR5_NIDEN_S                                                            0x8000
#define MASK_AON_APB_CSSYS_DBGEN_S                                                          0x4000
#define MASK_AON_APB_CSSYS_NIDEN_S                                                          0x2000
#define MASK_AON_APB_CSSYS_SPIDEN_S                                                         0x1000
#define MASK_AON_APB_CSSYS_SPNIDEN_S                                                        0x800
#define MASK_AON_APB_CA7_DBGEN_S                                                            0x400
#define MASK_AON_APB_CA7_NIDEN_S                                                            0x200
#define MASK_AON_APB_CA7_SPIDEN_S                                                           0x100
#define MASK_AON_APB_CA7_SPNIDEN_S                                                          0x80
#define MASK_AON_APB_DJTAG_EN_S                                                             0x4
#define MASK_AON_APB_CM4_DBGEN_S                                                            0x2
#define MASK_AON_APB_MJTAG_EN_S                                                             0x1
#define MASK_AON_APB_CR5_NIDEN                                                              0x2
#define MASK_AON_APB_CR5_DBGEN                                                              0x1
#define MASK_AON_APB_DBGSYS_CSSYS_STM_NSGUAREN                                              0x1
#define MASK_AON_APB_WTLCP_AON_FRC_WSYS_LT_STOP                                             0x10
#define MASK_AON_APB_WTLCP_AON_FRC_WSYS_STOP                                                0x8
#define MASK_AON_APB_WTLCP_WCMDA_EB                                                         0x10000
#define MASK_AON_APB_WCDMA_AUTO_GATE_EN                                                     0x100
#define MASK_AON_APB_WTLCP_TDSP_BOOT_VECTOR                                                 0xffffffff
#define MASK_AON_APB_WTLCP_STCK_TDSP                                                        0x2000
#define MASK_AON_APB_WTLCP_STMS_TDSP                                                        0x1000
#define MASK_AON_APB_WTLCP_STDO_TDSP                                                        0x800
#define MASK_AON_APB_WTLCP_STDI_TDSP                                                        0x400
#define MASK_AON_APB_WTLCP_STRTCK_TDSP                                                      0x200
#define MASK_AON_APB_WTLCP_SW_JTAG_ENA_TDSP                                                 0x100
#define MASK_AON_APB_WTLCP_TDSP_EXTERNAL_WAIT                                               0x2
#define MASK_AON_APB_WTLCP_TDSP_BOOT                                                        0x1
#define MASK_AON_APB_CP_AXI_VP_BASE                                                         0xfffff00
#define MASK_AON_APB_CP_AXI_VP_SIZE                                                         0x1f
#define MASK_AON_APB_CP_AXI_PP_BASE                                                         0xfffff00
#define MASK_AON_APB_CP_AXI_PP_SIZE                                                         0x1f
#define MASK_AON_APB_IDLE_ENABLE                                                            0x1
#define MASK_AON_APB_PUBCP_SYST_RTC_EB                                                      0x800
#define MASK_AON_APB_PUBCP_TMR_EB                                                           0x400
#define MASK_AON_APB_PUBCP_TMR_RTC_EB                                                       0x200
#define MASK_AON_APB_PUBCP_SYST_EB                                                          0x100
#define MASK_AON_APB_PUBCP_WDG_EB                                                           0x80
#define MASK_AON_APB_PUBCP_WDG_RTC_EB                                                       0x40
#define MASK_AON_APB_PUBCP_ARCH_RTC_EB                                                      0x20
#define MASK_AON_APB_PUBCP_EIC_EB                                                           0x10
#define MASK_AON_APB_PUBCP_EIC_RTCDV5_EB                                                    0x8
#define MASK_AON_APB_PUBCP_EIC_RTC_EB                                                       0x4
#define MASK_AON_APB_PUBCP_CR5_CORE_SOFT_RST                                                0x400
#define MASK_AON_APB_PUBCP_CR5_DBG_SOFT_RST                                                 0x200
#define MASK_AON_APB_PUBCP_CR5_ETM_SOFT_RST                                                 0x100
#define MASK_AON_APB_PUBCP_CR5_MP_SOFT_RST                                                  0x80
#define MASK_AON_APB_PUBCP_CR5_CS_DBG_SOFT_RST                                              0x40
#define MASK_AON_APB_PUBCP_TMR_SOFT_RST                                                     0x20
#define MASK_AON_APB_PUBCP_SYST_SOFT_RST                                                    0x10
#define MASK_AON_APB_PUBCP_WDG_SOFT_RST                                                     0x8
#define MASK_AON_APB_PUBCP_EIC_SOFT_RST                                                     0x4
#define MASK_AON_APB_AON_ACCESS_PUBCP                                                       0x2000
#define MASK_AON_APB_PUBCP_CR5_STANDBYWFI_N                                                 0x1000
#define MASK_AON_APB_PUBCP_CR5_STANDBYWFE_N                                                 0x800
#define MASK_AON_APB_PUBCP_CR5_CLKSTOPPED0_N                                                0x400
#define MASK_AON_APB_PUBCP_CR5_L2IDLE                                                       0x200
#define MASK_AON_APB_PUBCP_CR5_VALIRQ0_N                                                    0x100
#define MASK_AON_APB_PUBCP_CR5_VALFIQ0_N                                                    0x80
#define MASK_AON_APB_PUBCP_CR5_STOP                                                         0x40
#define MASK_AON_APB_PUBCP_CR5_CSYSACK_ATB                                                  0x20
#define MASK_AON_APB_PUBCP_CR5_CACTIVE_ATB                                                  0x10
#define MASK_AON_APB_PUBCP_CR5_CSSYNC_REQ                                                   0x8
#define MASK_AON_APB_PUBCP_CR5_CSYSREQ_ATB                                                  0x4
#define MASK_AON_APB_PUBCP_CR5_NODBGCLK                                                     0x2
#define MASK_AON_APB_PUBCP_CR5_CFGEE                                                        0x1
#define MASK_AON_APB_AP_DBG_SIG_SEL                                                         0xff0000
#define MASK_AON_APB_CP_DBG_MOD_SEL                                                         0xff00
#define MASK_AON_APB_AON_DBG_MOD_SEL                                                        0x100
#define MASK_AON_APB_AON_DBG_SIG_SEL                                                        0xff
#define MASK_AON_APB_SUBSYS_DBG_SEL                                                         0x7
#define MASK_AON_APB_WTLCP_WCDMA_AUTO_GATE_EN                                               0x8
#define MASK_AON_APB_WTLCP_WCDMA_SOFT_GATE_DIS                                              0x4
#define MASK_AON_APB_PUBCP_WCDMA_AUTO_GATE_EN                                               0x2
#define MASK_AON_APB_PUBCP_WCDMA_SOFT_GATE_DIS                                              0x1
#define MASK_AON_APB_LP_FORCE_ACK_EMC                                                       0x80000
#define MASK_AON_APB_LP_FORCE_EMC                                                           0x40000
#define MASK_AON_APB_LP_STAT_EMC                                                            0x20000
#define MASK_AON_APB_LP_EB_EMC                                                              0x10000
#define MASK_AON_APB_LP_NUM_EMC                                                             0xffff
#define MASK_AON_APB_LP_STAT_MAIN                                                           0x20000
#define MASK_AON_APB_LP_EB_MAIN                                                             0x10000
#define MASK_AON_APB_LP_NUM_MAIN                                                            0xffff
#define MASK_AON_APB_LP_STAT_SW0                                                            0x20000
#define MASK_AON_APB_LP_EB_SW0                                                              0x10000
#define MASK_AON_APB_LP_NUM_SW0                                                             0xffff
#define MASK_AON_APB_LP_STAT_SW1                                                            0x20000
#define MASK_AON_APB_LP_EB_SW1                                                              0x10000
#define MASK_AON_APB_LP_NUM_SW1                                                             0xffff
#define MASK_AON_APB_LP_STAT_RF                                                             0x20000
#define MASK_AON_APB_LP_EB_RF                                                               0x10000
#define MASK_AON_APB_LP_NUM_RF                                                              0xffff
#define MASK_AON_APB_LP_STAT_WCN                                                            0x20000
#define MASK_AON_APB_LP_EB_WCN                                                              0x10000
#define MASK_AON_APB_LP_NUM_WCN                                                             0xffff
#define MASK_AON_APB_WCN_FORCE_STOP_REQ                                                     0x2000
#define MASK_AON_APB_CA7_FORCE_STOP_REQ                                                     0x1000
#define MASK_AON_APB_PUBCP_ACC_FORCE_STOP_REQ                                               0x800
#define MASK_AON_APB_WTLCP_DDR_FORCE_STOP_REQ                                               0x400
#define MASK_AON_APB_PUBCP_DDR_FORCE_STOP_REQ                                               0x200
#define MASK_AON_APB_CP_FORCE_STOP_REQ                                                      0x100
#define MASK_AON_APB_WTLCP_AON_FORCE_STOP_REQ                                               0x80
#define MASK_AON_APB_PUBCP_AON_FORCE_STOP_REQ                                               0x40
#define MASK_AON_APB_GPU_FORCE_STOP_REQ                                                     0x20
#define MASK_AON_APB_MM_FORCE_STOP_REQ                                                      0x10
#define MASK_AON_APB_AP_DISP_FORCE_STOP_REQ                                                 0x8
#define MASK_AON_APB_AP_IMC_FORCE_STOP_REQ                                                  0x4
#define MASK_AON_APB_AP_DAP_FORCE_STOP_REQ                                                  0x2
#define MASK_AON_APB_AP_GSP_FORCE_STOP_REQ                                                  0x1
#define MASK_AON_APB_WCN_FORCE_STOP_ACK                                                     0x2000
#define MASK_AON_APB_CA7_FORCE_STOP_ACK                                                     0x1000
#define MASK_AON_APB_PUBCP_ACC_FORCE_STOP_ACK                                               0x800
#define MASK_AON_APB_WTLCP_DDR_FORCE_STOP_ACK                                               0x400
#define MASK_AON_APB_PUBCP_DDR_FORCE_STOP_ACK                                               0x200
#define MASK_AON_APB_CP_FORCE_STOP_ACK                                                      0x100
#define MASK_AON_APB_WTLCP_AON_FORCE_STOP_ACK                                               0x80
#define MASK_AON_APB_PUBCP_AON_FORCE_STOP_ACK                                               0x40
#define MASK_AON_APB_GPU_FORCE_STOP_ACK                                                     0x20
#define MASK_AON_APB_MM_FORCE_STOP_ACK                                                      0x10
#define MASK_AON_APB_AP_DISP_FORCE_STOP_ACK                                                 0x8
#define MASK_AON_APB_AP_IMC_FORCE_STOP_ACK                                                  0x4
#define MASK_AON_APB_AP_DAP_FORCE_STOP_ACK                                                  0x2
#define MASK_AON_APB_AP_GSP_FORCE_STOP_ACK                                                  0x1
#define MASK_AON_APB_DAP_DJTAG_EN                                                           0x1
#define MASK_AON_APB_S_EFS_BOUNDARY                                                         0xff
#define MASK_AON_APB_TOP_LPC0_LP_FORCE_ACK                                                  0x80000
#define MASK_AON_APB_TOP_LPC0_ACTIVE_SYNC_SEL                                               0x40000
#define MASK_AON_APB_TOP_LPC0_LP_REQ                                                        0x20000
#define MASK_AON_APB_TOP_LPC0_EB                                                            0x10000
#define MASK_AON_APB_TOP_LPC0_NUM                                                           0xffff
#define MASK_AON_APB_TOP_LPC1_LP_FORCE_ACK                                                  0x80000
#define MASK_AON_APB_TOP_LPC1_ACTIVE_SYNC_SEL                                               0x40000
#define MASK_AON_APB_TOP_LPC1_LP_REQ                                                        0x20000
#define MASK_AON_APB_TOP_LPC1_EB                                                            0x10000
#define MASK_AON_APB_TOP_LPC1_NUM                                                           0xffff
#define MASK_AON_APB_TOP_LPC2_LP_FORCE_ACK                                                  0x80000
#define MASK_AON_APB_TOP_LPC2_ACTIVE_SYNC_SEL                                               0x40000
#define MASK_AON_APB_TOP_LPC2_LP_REQ                                                        0x20000
#define MASK_AON_APB_TOP_LPC2_EB                                                            0x10000
#define MASK_AON_APB_TOP_LPC2_NUM                                                           0xffff
#define MASK_AON_APB_TOP_LPC3_LP_FORCE_ACK                                                  0x80000
#define MASK_AON_APB_TOP_LPC3_ACTIVE_SYNC_SEL                                               0x40000
#define MASK_AON_APB_TOP_LPC3_LP_REQ                                                        0x20000
#define MASK_AON_APB_TOP_LPC3_EB                                                            0x10000
#define MASK_AON_APB_TOP_LPC3_NUM                                                           0xffff
#define MASK_AON_APB_OVERHEAT_RST_DDIE_EN                                                   0x1
#define MASK_AON_APB_TOP_LPC4_LP_FORCE_ACK                                                  0x80000
#define MASK_AON_APB_TOP_LPC4_ACTIVE_SYNC_SEL                                               0x40000
#define MASK_AON_APB_TOP_LPC4_LP_REQ                                                        0x20000
#define MASK_AON_APB_TOP_LPC4_EB                                                            0x10000
#define MASK_AON_APB_TOP_LPC4_NUM                                                           0xffff
#define MASK_AON_APB_TOP_LPC5_LP_FORCE_ACK                                                  0x80000
#define MASK_AON_APB_TOP_LPC5_ACTIVE_SYNC_SEL                                               0x40000
#define MASK_AON_APB_TOP_LPC5_LP_REQ                                                        0x20000
#define MASK_AON_APB_TOP_LPC5_EB                                                            0x10000
#define MASK_AON_APB_TOP_LPC5_NUM                                                           0xffff
#define MASK_AON_APB_CONF_DMC_STOP_CH                                                       0x7f0000
#define MASK_AON_APB_CONF_DMC_SLEEP_CH                                                      0x7f00
#define MASK_AON_APB_CONF_MODE_SEL                                                          0x20
#define MASK_AON_APB_CONF_DMC_SLEEP                                                         0x10
#define MASK_AON_APB_CONF_DMC_STOP                                                          0x8
#define MASK_AON_APB_CONF_SUBSYS_HW_EN                                                      0x1ff0000
#define MASK_AON_APB_CONF_WAIT_NUM                                                          0xffff
#define MASK_AON_APB_DDR_SLP_CTRL_DEEP_SLEEP_FORCE_EN                                       0x10000
#define MASK_AON_APB_DDR_SLP_CTRL_FSM_STATE                                                 0xf000
#define MASK_AON_APB_DDR_SLP_CTRL_STAT_INTEN                                                0x700
#define MASK_AON_APB_DDR_SLP_CTRL_STAT_CLR                                                  0x70
#define MASK_AON_APB_DDR_SLP_CTRL_STAT                                                      0x7
#define MASK_AON_APB_CONF_DDR_SLP_REQ                                                       0x3ff0000
#define MASK_AON_APB_CONF_DDR_SLP_ACK                                                       0x1ff
#define MASK_AON_APB_AP_EMMC_POWER_OFF_EN                                                   0x2
#define MASK_AON_APB_AP_EMMC_POWER_OFF_CTRL_BY_HW                                           0x1
#define MASK_AON_APB_AP_AWADDR_WPROT_EN1                                                    0xffffffff
#define MASK_AON_APB_WTLCP_AWADDR_WPROT_EN1                                                 0xffffffff
#define MASK_AON_APB_PUBCP_AWADDR_WPROT_EN1                                                 0xffffffff
#define MASK_AON_APB_AP_AWADDR_WPROT_EN0                                                    0xffffffff
#define MASK_AON_APB_WTLCP_AWADDR_WPROT_EN0                                                 0xffffffff
#define MASK_AON_APB_PUBCP_AWADDR_WPROT_EN0                                                 0xffffffff
#define MASK_AON_APB_PMU_RST_MONITOR                                                        0xffffffff
#define MASK_AON_APB_THM_RST_MONITOR                                                        0xffffffff
#define MASK_AON_APB_AP_RST_MONITOR                                                         0xffffffff
#define MASK_AON_APB_CA7_RST_MONITOR                                                        0xffffffff
#define MASK_AON_APB_BOND_OPTION0                                                           0xffffffff
#define MASK_AON_APB_BOND_OPTION1                                                           0xffffffff
#define MASK_AON_APB_RES_REG0                                                               0xffffffff
#define MASK_AON_APB_RES_REG1                                                               0xffffffff
#define MASK_AON_APB_SLEEP_PLLLOCK_SEL                                                      0x80
#define MASK_AON_APB_PLL_LOCK_SEL                                                           0x70
#define MASK_AON_APB_SLEEP_DBG_SEL                                                          0xf
#define MASK_AON_APB_PCP_WDG_RST_FLAG                                                       0x20
#define MASK_AON_APB_WTLCP_TG_WDG_RST_FLAG                                                  0x8
#define MASK_AON_APB_AP_WDG_RST_FLAG                                                        0x4
#define MASK_AON_APB_CA7_WDG_RST_FLAG                                                       0x2
#define MASK_AON_APB_SEC_WDG_RST_FLAG                                                       0x1
#define MASK_AON_APB_READ_ALLOC_MODE_SPRD                                                   0xf
#define MASK_AON_APB_RES_REG2                                                               0xffffffff
#define MASK_AON_APB_RES_REG3                                                               0xffffffff
#define MASK_AON_APB_RES_REG4                                                               0xffffffff
#define MASK_AON_APB_RES_REG5                                                               0xffffffff
#define MASK_AON_APB_RES_REG6                                                               0xffffffff
#define MASK_AON_APB_RES_REG7                                                               0xffffffff
#define MASK_AON_APB_AON_APB_RSV                                                            0xffffffff
#define MASK_AON_APB_FUNCTION_DMA_BOOT_ADDR                                                 0xffffffff
#define MASK_AON_APB_SIM_OFF_PD_EN_PUBCP_SIM0                                               0x20
#define MASK_AON_APB_BAT_DETECT_POL_PUBCP_SIM0                                              0x10
#define MASK_AON_APB_SIM_DETECT_POL_PUBCP_SIM0                                              0x8
#define MASK_AON_APB_BAT_DETECT_EN_PUBCP_SIM0                                               0x4
#define MASK_AON_APB_SIM_DETECT_EN_PUBCP_SIM0                                               0x2
#define MASK_AON_APB_SIM_CLK_PL_PUBCP_SIM0                                                  0x1
#define MASK_AON_APB_SIM_OFF_PD_EN_PUBCP_SIM1                                               0x20
#define MASK_AON_APB_BAT_DETECT_POL_PUBCP_SIM1                                              0x10
#define MASK_AON_APB_SIM_DETECT_POL_PUBCP_SIM1                                              0x8
#define MASK_AON_APB_BAT_DETECT_EN_PUBCP_SIM1                                               0x4
#define MASK_AON_APB_SIM_DETECT_EN_PUBCP_SIM1                                               0x2
#define MASK_AON_APB_SIM_CLK_PL_PUBCP_SIM1                                                  0x1
#define MASK_AON_APB_SIM_OFF_PD_EN_PUBCP_SIM2                                               0x20
#define MASK_AON_APB_BAT_DETECT_POL_PUBCP_SIM2                                              0x10
#define MASK_AON_APB_SIM_DETECT_POL_PUBCP_SIM2                                              0x8
#define MASK_AON_APB_BAT_DETECT_EN_PUBCP_SIM2                                               0x4
#define MASK_AON_APB_SIM_DETECT_EN_PUBCP_SIM2                                               0x2
#define MASK_AON_APB_SIM_CLK_PL_PUBCP_SIM2                                                  0x1
#define MASK_AON_APB_SIM_OFF_PD_EN_AP_SIM0                                                  0x20
#define MASK_AON_APB_BAT_DETECT_POL_AP_SIM0                                                 0x10
#define MASK_AON_APB_SIM_DETECT_POL_AP_SIM0                                                 0x8
#define MASK_AON_APB_BAT_DETECT_EN_AP_SIM0                                                  0x4
#define MASK_AON_APB_SIM_DETECT_EN_AP_SIM0                                                  0x2
#define MASK_AON_APB_SIM_CLK_PL_AP_SIM0                                                     0x1
#define MASK_AON_APB_MM_DEEP_SLEEP_SOFT                                                     0x2
#define MASK_AON_APB_GPU_DEEP_SLEEP_SOFT                                                    0x1
