/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Unisoc Orca platform regs
 *
 * Copyright (C) 2022, Unisoc Inc.
 */
#ifndef __DT_BINDINGS_SPRD_GLB_REGS_H
#define __DT_BINDINGS_SPRD_GLB_REGS_H

#define REG_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM1_CTL					0x0000
#define REG_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM1_RESERVED_CTL				0x0004
#define REG_ANLG_PHY_G8_RF_ANALOG_THM1_1_REG_SEL_CFG_0				0x0008
#define REG_SCC_APB_RF_SCC_TUNE_LMT_CFG						0x0000
#define REG_SCC_APB_RF_SCC_TUNE_STATUS						0x0004
#define REG_SCC_APB_RF_SCC_CFG							0x0008
#define REG_SCC_APB_RF_SCC_TUNE_STEP_CFG						0x000c
#define REG_SCC_APB_RF_SCC_WAIT_CFG						0x0010
#define REG_SCC_APB_RF_SCC_INT_CFG							0x0014
#define REG_SCC_APB_RF_SCC_TUNE_MARK						0x0024
#define REG_SCC_APB_RF_SCC_FSM_STS							0x0028
#define REG_SCC_APB_RF_SCC_ROSC_MODE						0x0100
#define REG_SCC_APB_RF_SCC_ROSC_CFG						0x0104
#define REG_SCC_APB_RF_SCC_ROSC_CTRL						0x0108
#define REG_SCC_APB_RF_SCC_ROSC_RPT						0x010c
#define REG_SCC_APB_RF_SCC_ROSC_SW_RST						0x0110
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL0			0x0000
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL1			0x0004
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL2			0x0008
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL3			0x000c
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL4			0x0010
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL5			0x0014
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL6			0x0018
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL7			0x001c
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL8			0x0020
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL9			0x0024
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL10			0x0028
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL11			0x002c
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL12			0x0030
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL13			0x0034
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL14			0x0038
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL15			0x003c
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CTRL16			0x0040
#define REG_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_REG_SEL_CFG_0			0x0044
#define REG_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_ANA_USB30_CTRL0			0x0000
#define REG_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_ANA_USB30_CTRL1			0x0004
#define REG_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_REG_SEL_CFG_0			0x0008
#define REG_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_ANA_USB30_CTRL0			0x000c
#define REG_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_ANA_USB30_CTRL1			0x0010
#define REG_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_REG_SEL_CFG_0			0x0014
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TEST_PIN				0x0018
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_UTMI_CTL1				0x001c
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BATTER_PLL				0x0020
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_UTMI_CTL2				0x0024
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TRIMMING				0x0028
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PLL_CFG				0x002c
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PHY_BIST_TEST			0x0030
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_ISO_SW				0x0034
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_0_REG_SEL_CFG_0				0x0038
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TEST_PIN				0x003c
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_UTMI_CTL1				0x0040
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BATTER_PLL				0x0044
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_UTMI_CTL2				0x0048
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TRIMMING				0x004c
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PLL_CFG				0x0050
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PHY_BIST_TEST			0x0054
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_ISO_SW				0x0058
#define REG_ANLG_PHY_G4_RF_ANALOG_USB20_1_REG_SEL_CFG_0				0x005c
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_ANA_BB_SINE_CTRL1				0x0004
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_ANA_BB_SINE_CTRL2				0x0008
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_BB_BG_CTRL				0x000c
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_ANALOG_TEST				0x0010
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL0				0x0014
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2				0x001c
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL4				0x0024
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL5				0x0028
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL0				0x0030
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2				0x0038
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL4				0x0040
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL5				0x0044
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL0				0x004c
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL1				0x0050
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL2				0x0054
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL3				0x0058
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL4				0x005c
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL5				0x0060
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL6				0x0064
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_PLL_CLKEN					0x0068
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_AAPC_TEST_0				0x0080
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_WRAP_GLUE_CTRL				0x0084
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_ANA_LVDS_SEL				0x0088
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_TEST_CLK_CTRL				0x008c
#define REG_ANLG_PHY_G5_RF_ANALOG_BB_TOP_ANA_DUMMY_1				0x0090
#define REG_PUB_APB_REG_DDR_EB							0x0000
#define REG_PUB_APB_REG_DDR_SOFT_RST						0x0004
#define REG_PUB_APB_REG_DDL_MASK_CTRL						0x1000
#define REG_PUB_APB_REG_PUB_DDR_CHN_LP_CTRL					0x3104
#define REG_PUB_APB_REG_DMC_EXT_LPCTRL_CFG						0x31a0
#define REG_PUB_APB_REG_DMC_EXT_LPCTRL_SEQL					0x31a4
#define REG_PUB_APB_REG_DMC_EXT_LPCTRL_SEQH					0x31a8
#define REG_PUB_APB_REG_DMC_EXT_LPCTRL_STEP					0x31ac
#define REG_PUB_APB_REG_QOS_SELECT							0x31b0
#define REG_PUB_APB_REG_DPLL_PRE_DIV_STATUS					0x31c0
#define REG_PUB_APB_REG_DFI_BWMON_TIMER						0x31c4
#define REG_PUB_APB_REG_QOS_SWITCH							0x31c8
#define REG_PUB_APB_REG_PUB_BUS_CK_EB						0x31cc
#define REG_PUB_APB_REG_AXI_LPC_CTRL_3						0x31d0
#define REG_PUB_APB_REG_PUB_INT_CG_EN						0x31d4
#define REG_PUB_APB_REG_TIMER_ENABLE						0x31d8
#define REG_PUB_APB_REG_VOTE_CTRL							0x31e0
#define REG_PUB_APB_REG_VOTE_STATUS						0x31e4
#define REG_PUB_APB_REG_DFS_HW_CTRL3						0x31f0
#define REG_PUB_APB_REG_QOS_FIXED_CTRL0						0x31f4
#define REG_PUB_APB_REG_QOS_FIXED_CTRL1						0x31f8
#define REG_PUB_APB_REG_QOS_FIXED_CTRL2						0x31fc
#define REG_PUB_APB_REG_PUB_AXI_QOS_URGENT_REG_0					0x3200
#define REG_PUB_APB_REG_PUB_AXI_QOS_URGENT_REG_1					0x3204
#define REG_PUB_APB_REG_PUB_INT_CTRL						0x32f0
#define REG_PUB_APB_REG_DFS_STATUS							0x32f4
#define REG_PUB_APB_REG_DFS_STATUS1						0x32f8
#define REG_PUB_APB_REG_DFS_FC_REQ_DELAY						0x32fc
#define REG_PUB_APB_REG_PUB_LP_GEN_CTRL						0x333c
#define REG_PUB_APB_REG_AXI_LPC_CTRL_0						0x334c
#define REG_PUB_APB_REG_AXI_LPC_CTRL_1						0x3350
#define REG_PUB_APB_REG_AXI_LPC_CTRL_2						0x3354
#define REG_PUB_APB_REG_FENCING_CTRL						0x3358
#define REG_PUB_APB_REG_CP_BASE_ADDR						0x3360
#define REG_PUB_APB_REG_CLK_PUB_DFS_CTRL						0x3364
#define REG_PUB_APB_REG_AXI_LPC_CTRL_4						0x3368
#define REG_PUB_APB_REG_AXI_LPC_CTRL_5						0x336c
#define REG_PUB_APB_REG_BIST_CTRL							0x3400
#define REG_PUB_APB_REG_DMC_SOFT_RST_CTRL						0x3404
#define REG_PUB_APB_REG_MC_IDLE_WAIT_CTRL						0x3414
#define REG_PUB_APB_REG_QOS_THRESHOLD_0						0x3418
#define REG_PUB_APB_REG_QOS_THRESHOLD_1						0x341c
#define REG_PUB_APB_REG_DMC_DDR_CLK_CTRL						0x4000
#define REG_PUB_APB_REG_DMC_CLK_INIT_SW_START					0x4004
#define REG_PUB_APB_REG_DMC_CLK_STATE						0x4008
#define REG_PUB_APB_REG_DMC_CLK_INIT_CFG						0x400c
#define REG_PUB_APB_REG_DMC_DESKEW_WAIT_CFG					0x4010
#define REG_PUB_APB_REG_DMC_DESKEW_WAIT_CNT0					0x4014
#define REG_PUB_APB_REG_DMC_DESKEW_WAIT_CNT1					0x4018
#define REG_PUB_APB_REG_DMC_DESKEW_WAIT_CNT2					0x401c
#define REG_PUB_APB_REG_DMC_DESKEW_WAIT_CNT3					0x4020
#define REG_PUB_APB_REG_DMC_DDL_CTRL						0x402c
#define REG_PUB_APB_REG_DFS_PURE_SW_CTRL						0x4100
#define REG_PUB_APB_REG_DFS_SW_CTRL						0x4104
#define REG_PUB_APB_REG_DFS_SW_CTRL1						0x4108
#define REG_PUB_APB_REG_DFS_SW_CTRL2						0x410c
#define REG_PUB_APB_REG_DFS_SW_CTRL3						0x4110
#define REG_PUB_APB_REG_DFS_HW_CTRL						0x4114
#define REG_PUB_APB_REG_DFS_HW_CTRL1						0x4118
#define REG_PUB_APB_REG_DFS_HW_CTRL2						0x411c
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET0						0x4120
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET1						0x4124
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET2						0x4128
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET3						0x412c
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET4						0x4130
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET5						0x4134
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET6						0x4138
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET7						0x413c
#define REG_PUB_APB_REG_DFS_HW_RATIO_SET8						0x4140
#define REG_PUB_APB_REG_HW_DESKEWPLL_PD_CTRL0					0x4144
#define REG_PUB_APB_REG_HW_DESKEWPLL_PD_CTRL1					0x4148
#define REG_PUB_APB_REG_DVS_CTRL_0							0x4150
#define REG_PUB_APB_REG_DVS_CTRL_1							0x4154
#define REG_PUB_APB_REG_DVS_CTRL_2							0x4158
#define REG_PUB_APB_REG_VOTE_MASTER_EN						0x4310
#define REG_PUB_APB_REG_VOTE_FSM_CNT						0x4314
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_0					0x4318
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_1					0x431c
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_2					0x4320
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_3					0x4324
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_4					0x4328
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_5					0x432c
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_6					0x4330
#define REG_PUB_APB_REG_THRESHOLD_INC_FREQ_7					0x4334
#define REG_PUB_APB_REG_TEST_DSKPLL_BIST_CNT					0x4340
#define REG_PUB_APB_REG_PUB_STATUS_MON_CTRL					0x6200
#define REG_PUB_APB_REG_PUB_ST_IDLE_CYC_CNT					0x6204
#define REG_PUB_APB_REG_PUB_ST_WR_CYC_CNT						0x6208
#define REG_PUB_APB_REG_PUB_ST_RD_CYC_CNT						0x620c
#define REG_PUB_APB_REG_PUB_ST_SR_CYC_CNT						0x6210
#define REG_PUB_APB_REG_PUB_ST_LS_CYC_CNT						0x6214
#define REG_PUB_APB_REG_PUB_ST_LS_TIME_CNT						0x6218
#define REG_PUB_APB_REG_PUB_DFS_F0_CYC_CNT						0x621c
#define REG_PUB_APB_REG_PUB_DFS_F1_CYC_CNT						0x6220
#define REG_PUB_APB_REG_PUB_DFS_F2_CYC_CNT						0x6224
#define REG_PUB_APB_REG_PUB_DFS_F3_CYC_CNT						0x6228
#define REG_PUB_APB_REG_PUB_DFS_F4_CYC_CNT						0x622c
#define REG_PUB_APB_REG_PUB_DFS_F5_CYC_CNT						0x6230
#define REG_PUB_APB_REG_PUB_DFS_F6_CYC_CNT						0x6234
#define REG_PUB_APB_REG_PUB_DFS_F7_CYC_CNT						0x6238
#define REG_PUB_APB_REG_PUB_DFS_CNT						0x623c
#define REG_PUB_APB_REG_VOTE_CTRL_APCPU						0x6400
#define REG_PUB_APB_REG_VOTE_CTRL_MINIAP						0x6404
#define REG_PUB_APB_REG_VOTE_CTRL_NRCPU						0x6408
#define REG_PUB_APB_REG_VOTE_CTRL_NRACC						0x640c
#define REG_PUB_APB_REG_VOTE_CTRL_V3CPU						0x6410
#define REG_PUB_APB_REG_VOTE_CTRL_AGCP						0x6414
#define REG_PUB_APB_REG_VOTE_CTRL_SW						0x6418
#define REG_PUB_APB_REG_VOTE_CTRL_V3ACC						0x641c
#define REG_PUB_APB_REG_VOTE_CTRL_PSCP						0x6420
#define REG_PUB_APB_REG_VOTE_CTRL_WCDMA_PS						0x6424
#define REG_PUB_APB_REG_VOTE_CTRL_TDS_PS						0x6428
#define REG_PUB_APB_REG_VOTE_CTRL_GSM_PS						0x642c
#define REG_PUB_APB_REG_VOTE_CTRL_WCDMA_PHY					0x6430
#define REG_PUB_APB_REG_VOTE_CTRL_TDS_PHY						0x6434
#define REG_PUB_APB_REG_VOTE_CTRL_GSM_PHY						0x6438
#define REG_PUB_APB_REG_DFS_GFREE_CTRL						0x6500
#define REG_PUB_APB_REG_DFS_SW_CTRL_APPEND						0x6600
#define REG_PUB_APB_REG_AWURGENT_DBG_CTRL						0x6800
#define REG_PUB_APB_REG_ARURGENT_DBG_CTRL						0x6804
#define REG_PUB_APB_REG_LSLP_SRE_SIM						0x6808
#define REG_PUB_APB_REG_VOTE_BW_APCPU						0x680c
#define REG_PUB_APB_REG_VOTE_BW_MINIAP						0x6810
#define REG_PUB_APB_REG_VOTE_BW_AGCP						0x6814
#define REG_PUB_APB_REG_VOTE_BW_PSCP						0x6818
#define REG_PUB_APB_REG_VOTE_BW_NRACC						0x681c
#define REG_PUB_APB_REG_VOTE_BW_NRCPU						0x6820
#define REG_PUB_APB_REG_VOTE_BW_V3ACC						0x6824
#define REG_PUB_APB_REG_VOTE_BW_V3CPU						0x6828
#define REG_PUB_APB_REG_VOTE_BW_WACC						0x682c
#define REG_PUB_APB_REG_VOTE_BW_WCPU						0x6830
#define REG_PUB_APB_REG_VOTE_BW_TDACC						0x6834
#define REG_PUB_APB_REG_VOTE_BW_TDCPU						0x6838
#define REG_PUB_APB_REG_VOTE_BW_GSMACC						0x683c
#define REG_PUB_APB_REG_VOTE_BW_GSMCPU						0x6840
#define REG_PUB_APB_REG_VOTE_BW_SW							0x6844
#define REG_PUB_APB_REG_MTX_BUSMON_CTRL						0x6848
#define REG_PUB_APB_REG_HIGH_URGENCY_CTRL						0x684c
#define REG_PUB_APB_REG_LPC_PU_NUM_CTRL_0						0x6850
#define REG_PUB_APB_REG_LPC_PU_NUM_CTRL_1						0x6854
#define REG_PUB_APB_REG_LPC_PU_NUM_CTRL_2						0x6858
#define REG_PUB_APB_REG_LPC_PU_NUM_CTRL_3						0x685c
#define REG_PUB_APB_REG_DMC_BIST_MST_AXUSER_CFG_0					0x6860
#define REG_PUB_APB_REG_DMC_BIST_MST_AXUSER_CFG_1					0x6864
#define REG_PUB_APB_REG_PUB0_DUMMY_REG0						0x8000
#define REG_PUB_APB_REG_PUB0_DUMMY_REG1						0x8004
#define REG_ANLG_PHY_G10_RF_ANALOG_RCO100M_RTC100M_CTRL				0x0000
#define REG_ANLG_PHY_G10_RF_ANALOG_RCO100M_WRAP_RCO_CTRL				0x0004
#define REG_ANLG_PHY_G10_RF_ANALOG_EFUSE4K_EFUSE_PIN_PW_CTL			0x0008
#define REG_AUD_CP_AHB_RF_MODULE_EB0_STS						0x0000
#define REG_AUD_CP_AHB_RF_MODULE_EB1_STS						0x0004
#define REG_AUD_CP_AHB_RF_MODULE_RST0_STS						0x0008
#define REG_AUD_CP_AHB_RF_BUS_CLK_EB						0x000c
#define REG_AUD_CP_AHB_RF_EARLY_WAKEUP_EB						0x0010
#define REG_AUD_CP_AHB_RF_M_S_PUB_FRC_LSLP						0x0014
#define REG_AUD_CP_AHB_RF_AHB_ARCH_EB						0x0018
#define REG_AUD_CP_AHB_RF_CORE_SLEEP						0x001c
#define REG_AUD_CP_AHB_RF_SYS_SLP_EN						0x0020
#define REG_AUD_CP_AHB_RF_MCACHE_CTRL						0x0024
#define REG_AUD_CP_AHB_RF_MCU_STATUS						0x0028
#define REG_AUD_CP_AHB_RF_ID2QOS_AR_0						0x002c
#define REG_AUD_CP_AHB_RF_ID2QOS_AR_1						0x0030
#define REG_AUD_CP_AHB_RF_ID2QOS_AW_0						0x0034
#define REG_AUD_CP_AHB_RF_ID2QOS_AW_1						0x0038
#define REG_AUD_CP_AHB_RF_EXT_ACC_AUD_SEL						0x003c
#define REG_AUD_CP_AHB_RF_AUD_RESERVED						0x0040
#define REG_AUD_CP_AHB_RF_LP_EB_AUDCP						0x0044
#define REG_AUD_CP_AHB_RF_ACTIVE_SYNC_SEL_AUDCP					0x0048
#define REG_AUD_CP_AHB_RF_AXILP_NUM						0x004c
#define REG_AUD_CP_AHB_RF_AWQOS							0x0050
#define REG_AUD_CP_AHB_RF_ARQOS							0x0054
#define REG_AUD_CP_AHB_RF_M_S_PUB_CTL_PERI						0x0058
#define REG_AUD_CP_AHB_RF_M_S_FRC_DOZE						0x005c
#define REG_AUD_CP_AHB_RF_M_S_PUB_FRC_DSLP						0x0060
#define REG_AUD_CP_AHB_RF_AUD_BRIDGE_DEBUG_SIG					0x0064
#define REG_AUD_CP_AHB_RF_AUD_PROT_SEL						0x0068
#define REG_AUD_CP_AHB_RF_AUD_BRIDGE_STATE						0x006c
#define REG_AUD_CP_AHB_RF_AUD_BRIDGE_CTL						0x0070
#define REG_AUD_CP_AHB_RF_M_AXCACHE_CTL						0x0074
#define REG_AUD_CP_AHB_RF_DSP_DMA_INT_CLEAR					0x0078
#define REG_AUD_CP_AHB_RF_DSP_PSU_STA						0x007c
#define REG_AUD_CP_AHB_RF_FORCE_DMA_BUSY						0x0080
#define REG_AUD_CP_AHB_RF_WAKEUP_EN_INT_H						0x0084
#define REG_AUD_CP_AHB_RF_WAKEUP_EN_INT_L						0x0088
#define REG_AUD_CP_AHB_RF_DSP_L2CC_CTRL						0x008c
#define REG_AUD_CP_AHB_RF_MTX_QOS_THD						0x0090
#define REG_AUD_CP_AHB_RF_FREQ_FRC_ON_CTRL						0x0094
#define REG_AUD_CP_AHB_RF_FREQ_FRC_OFF_CTRL					0x0098
#define REG_AUD_CP_AHB_RF_DBG_DUMMG_REG						0x009c
#define REG_AUD_CP_AHB_RF_DVFS_CTRL						0x00a0
#define REG_AUD_CP_AHB_RF_CGM_AUTO_EN						0x00a4
#define REG_AUD_CP_AHB_RF_BUS_CLK_CTRL						0x00a8
#define REG_AUD_CP_AHB_RF_LPC_SYNC_SEL						0x00ac
#define REG_AUD_CP_AHB_RF_BUS_MON_CTRL						0x00b0
#define REG_AUD_CP_AHB_RF_SYS_DBG_BUS						0x00b4
#define REG_AP_APB_RF_APB_EB							0x0000
#define REG_AP_APB_RF_APB_RST							0x0004
#define REG_AP_APB_RF_APB_MISC_CTRL						0x0008
#define REG_AP_APB_RF_APB_PCLK_AUTO_GATE_EB					0x000c
#define REG_AP_APB_RF_APB_PCLK_AUTO_SLOW_SEL1					0x0014
#define REG_AP_APB_RF_APB_PCLK_AUTO_SLOW_SEL2					0x0018
#define REG_AP_APB_RF_APB_PERI_FRC_DOZE						0x001c
#define REG_AP_APB_RF_APB2APB_CLK_AUTO_GATE_EN					0x0020
#define REG_AP_APB_RF_RESERVE0							0x0040
#define REG_AP_APB_RF_RESERVE1							0x0044
#define REG_AUD_CP_APB_RF_APB_EB							0x0000
#define REG_AUD_CP_APB_RF_APB_RST							0x0004
#define REG_AUD_CP_APB_RF_AON_BUS_CTRL0						0x0008
#define REG_AUD_CP_APB_RF_SLEEP_CTRL0						0x000c
#define REG_AUD_CP_APB_RF_SLEEP_STATUS						0x0014
#define REG_AUD_CP_APB_RF_INT_MASK							0x0018
#define REG_AUD_CP_APB_RF_MEM_SLP							0x001c
#define REG_AUD_CP_APB_RF_AON_RESERVED						0x0020
#define REG_AUD_CP_APB_RF_IRAM_ENDIAN						0x0024
#define REG_AON_APB_RF_APB_EB0							0x0000
#define REG_AON_APB_RF_APB_EB1							0x0004
#define REG_AON_APB_RF_APB_EB2							0x0008
#define REG_AON_APB_RF_APB_RTC_EB0							0x000c
#define REG_AON_APB_RF_PSCP_AON_EB							0x0010
#define REG_AON_APB_RF_CGM_REG1							0x0020
#define REG_AON_APB_RF_CGM_CLK_TOP_REG1						0x0024
#define REG_AON_APB_RF_APCPU_INT_ENABLE_CTRL0					0x0030
#define REG_AON_APB_RF_APCPU_INT_ENABLE_CTRL1					0x0034
#define REG_AON_APB_RF_APCPU_INT_ENABLE_CTRL2					0x0038
#define REG_AON_APB_RF_APCPU_INT_ENABLE_CTRL3					0x003c
#define REG_AON_APB_RF_APCPU_INT_ENABLE_CTRL4					0x0040
#define REG_AON_APB_RF_APCPU_INT_ENABLE_CTRL5					0x0044
#define REG_AON_APB_RF_SP_WAKEUP_MASK_EN0						0x0050
#define REG_AON_APB_RF_SP_WAKEUP_MASK_EN1						0x0054
#define REG_AON_APB_RF_SP_WAKEUP_MASK_EN2						0x0058
#define REG_AON_APB_RF_APB_RST0							0x0200
#define REG_AON_APB_RF_APB_RST1							0x0204
#define REG_AON_APB_RF_APB_RST2							0x0208
#define REG_AON_APB_RF_APB_RST3							0x020c
#define REG_AON_APB_RF_CM4_SYS_SOFT_RST						0x0210
#define REG_AON_APB_RF_PSCP_SOFT_RST						0x0214
#define REG_AON_APB_RF_NRCP_SOFT_RST						0x0218
#define REG_AON_APB_RF_V3PS_SOFT_RST						0x021c
#define REG_AON_APB_RF_V3PHY_SOFT_RST						0x0220
#define REG_AON_APB_RF_WDG_RST_FLAG						0x0224
#define REG_AON_APB_RF_APCPU_SOFT_RST						0x0228
#define REG_AON_APB_RF_BOOT_MODE							0x0400
#define REG_AON_APB_RF_CP_ARM_JTAG_CTRL						0x0404
#define REG_AON_APB_RF_RC100M_CFG							0x0500
#define REG_AON_APB_RF_CCIR_RCVR_CFG						0x0504
#define REG_AON_APB_RF_PLL_BG_CFG							0x0508
#define REG_AON_APB_RF_MBIST_EFUSE_CTRL						0x050c
#define REG_AON_APB_RF_OTG_PHY_TEST						0x0510
#define REG_AON_APB_RF_OTG_PHY_CTRL						0x0514
#define REG_AON_APB_RF_OTG_CTRL0							0x0518
#define REG_AON_APB_RF_OTG_CTRL1							0x051c
#define REG_AON_APB_RF_USB_CLK_REF_SEL						0x0520
#define REG_AON_APB_RF_V3_LVDSRF_CTRL						0x0524
#define REG_AON_APB_RF_NR_LVDSRF_CTRL						0x0528
#define REG_AON_APB_RF_WCN_ADDA_MEM_PD_CTRL					0x052c
#define REG_AON_APB_RF_THM0_CTRL							0x0530
#define REG_AON_APB_RF_THM1_CTRL							0x0534
#define REG_AON_APB_RF_OVERHEAT_CTRL						0x0538
#define REG_AON_APB_RF_MPLL0_CTRL							0x0540
#define REG_AON_APB_RF_MPLL1_CTRL							0x0544
#define REG_AON_APB_RF_NR_RPLL_CTRL_REG2						0x0548
#define REG_AON_APB_RF_DPLL_CTRL							0x0550
#define REG_AON_APB_RF_PLL_LOCK_OUT_SEL						0x0554
#define REG_AON_APB_RF_SINDRV_POWER_CTRL						0x0560
#define REG_AON_APB_RF_PHY_REF_CLK_EN						0x0564
#define REG_AON_APB_RF_RPLL_CTL_SEL						0x0568
#define REG_AON_APB_RF_V3_RPLL_CTRL_REG0						0x0570
#define REG_AON_APB_RF_V3_RPLL_CTRL_REG1						0x0574
#define REG_AON_APB_RF_V3_RPLL_CTRL_REG2						0x0578
#define REG_AON_APB_RF_V3_RPLL_CTRL_REG3						0x057c
#define REG_AON_APB_RF_V3_RPLL_CTRL_SEL						0x0580
#define REG_AON_APB_RF_NR_RPLL_CTRL_REG0						0x0590
#define REG_AON_APB_RF_NR_RPLL_CTRL_REG1						0x0594
#define REG_AON_APB_RF_NR_RPLL_CTRL_REG3						0x059c
#define REG_AON_APB_RF_NR_RPLL_CTRL_SEL						0x05a0
#define REG_AON_APB_RF_RFSPI_SEL							0x05b0
#define REG_AON_APB_RF_BB_SW_RFSPI_FIFO_STATS					0x05c0
#define REG_AON_APB_RF_RPLL_PD_RST_SEL						0x05c4
#define REG_AON_APB_RF_CLK_AUD26M_EN						0x05c8
#define REG_AON_APB_RF_TS_CFG							0x0600
#define REG_AON_APB_RF_DCXO_LC_REG0						0x0604
#define REG_AON_APB_RF_DCXO_LC_REG1						0x0608
#define REG_AON_APB_RF_AUDCP_BOOT_PROT						0x060c
#define REG_AON_APB_RF_NR_DSP0_REG_PROT						0x0610
#define REG_AON_APB_RF_NR_DSP1_REG_PROT						0x0614
#define REG_AON_APB_RF_DAP_DJTAG_SEL						0x0618
#define REG_AON_APB_RF_SP_CFG_BUS							0x061c
#define REG_AON_APB_RF_AON_FUNC_CTRL_0						0x0620
#define REG_AON_APB_RF_AON_FUNC_CTRL_1						0x0624
#define REG_AON_APB_RF_FUNC_TEST_BOOT_ADDR						0x0628
#define REG_AON_APB_RF_LEAKAGE_MAGIC_WORD						0x0630
#define REG_AON_APB_RF_LEAKAGE_SWITCH						0x0634
#define REG_AON_APB_RF_AUDCP_DSP_CTRL0						0x0640
#define REG_AON_APB_RF_AUDCP_DSP_CTRL1						0x0644
#define REG_AON_APB_RF_AUDCP_CTRL							0x0648
#define REG_AON_APB_RF_V3_CTRL							0x0650
#define REG_AON_APB_RF_V3_CR5_CTRL							0x0654
#define REG_AON_APB_RF_V3PS_CR5_CTRL_1						0x0658
#define REG_AON_APB_RF_V3PHY_CR5_CTRL_1						0x065c
#define REG_AON_APB_RF_PSCP_CR8_CTRL						0x0660
#define REG_AON_APB_RF_NRCP_CTRL							0x0670
#define REG_AON_APB_RF_NRCP_CR8_CTRL						0x0674
#define REG_AON_APB_RF_NRCP_DSP0_CTRL						0x0678
#define REG_AON_APB_RF_NRCP_DSP1_CTRL						0x067c
#define REG_AON_APB_RF_NRCP_DSP0_BOOT_VECTOR					0x0680
#define REG_AON_APB_RF_NRCP_DSP1_BOOT_VECTOR					0x0684
#define REG_AON_APB_RF_DBG_DJTAG_CTRL						0x0690
#define REG_AON_APB_RF_PSCP_SIM1_TOP_CTRL						0x06a0
#define REG_AON_APB_RF_PSCP_SIM2_TOP_CTRL						0x06a4
#define REG_AON_APB_RF_PSCP_SIM3_TOP_CTRL						0x06a8
#define REG_AON_APB_RF_AP_SIM_TOP_CTRL						0x06ac
#define REG_AON_APB_RF_V3_PS_SIM1_TOP_CTRL						0x06b0
#define REG_AON_APB_RF_V3_PS_SIM2_TOP_CTRL						0x06b4
#define REG_AON_APB_RF_V3_PS_SIM3_TOP_CTRL						0x06b8
#define REG_AON_APB_RF_AON_SDIO							0x06c0
#define REG_AON_APB_RF_MTX_URGENCY_CTRL						0x06c4
#define REG_AON_APB_RF_MTX_URGENCY_STATS						0x06c8
#define REG_AON_APB_RF_NR_DSP0_CTRL0						0x06d0
#define REG_AON_APB_RF_NR_DSP0_CTRL1						0x06d4
#define REG_AON_APB_RF_NR_DSP1_CTRL0						0x06d8
#define REG_AON_APB_RF_NR_DSP1_CTRL1						0x06dc
#define REG_AON_APB_RF_SDIO_SLV_ADDR_OFFSET					0x06e0
#define REG_AON_APB_RF_APCPU_CFG_CTRL						0x06e4
#define REG_AON_APB_RF_SP_AON_DDR_EXTEND						0x06e8
#define REG_AON_APB_RF_AON_APB_CLK_SEL						0x0700
#define REG_AON_APB_RF_AUTO_GATE_CTRL0						0x0704
#define REG_AON_APB_RF_AUTO_GATE_CTRL1						0x0708
#define REG_AON_APB_RF_AUTO_GATE_CTRL3						0x070c
#define REG_AON_APB_RF_V3_LPC_CTRL							0x0710
#define REG_AON_APB_RF_PSCP_LPC_CTRL						0x0714
#define REG_AON_APB_RF_AP_LPC_CTRL							0x0718
#define REG_AON_APB_RF_AUDCP_LPC_CTRL						0x071c
#define REG_AON_APB_RF_NRCP_LPC_CTRL						0x0720
#define REG_AON_APB_RF_APCPU_AXI_CTRL						0x0730
#define REG_AON_APB_RF_APCPU_CLK_CTRL0						0x0734
#define REG_AON_APB_RF_PUB_CLK_GATING_CTRL						0x0740
#define REG_AON_APB_RF_DDRPHY_VREP							0x0744
#define REG_AON_APB_RF_CGM_RESCUE							0x0748
#define REG_AON_APB_RF_AON_APB_FREQ_CTRL						0x0750
#define REG_AON_APB_RF_APCPU_MONITOR_STATUS					0x0754
#define REG_AON_APB_RF_APCPU_DEBUG_PWR_LP_CTRL					0x0758
#define REG_AON_APB_RF_APCPU_GIC_COL_LP_CTRL					0x075c
#define REG_AON_APB_RF_APCPU_CLUSTER_ATB_LPC_CTRL					0x0760
#define REG_AON_APB_RF_APCPU_CLUSTER_APB_LPC_CTRL					0x0764
#define REG_AON_APB_RF_APCPU_CLUSTER_GIC_LPC_CTRL					0x0768
#define REG_AON_APB_RF_APCPU_GIC600_GIC_LPC_CTRL					0x076c
#define REG_AON_APB_RF_APCPU_DBG_BLK_LPC_CTRL					0x0770
#define REG_AON_APB_RF_APCPU_TOP_MTX_M0_LPC_CTRL					0x0774
#define REG_AON_APB_RF_APCPU_CLUSTER_SCU_LPC_CTRL					0x0778
#define REG_AON_APB_RF_APCPU_DDR_AB_LPC_CTRL					0x077c
#define REG_AON_APB_RF_APCPU_QOS_CTRL						0x0780
#define REG_AON_APB_RF_APCPU_URGENCY_CTRL						0x0784
#define REG_AON_APB_RF_AON_MTX_PROT_CFG						0x0788
#define REG_AON_APB_RF_APCU_LPC_CTRL						0x078c
#define REG_AON_APB_RF_CM42AON_LPC_CTRL						0x0790
#define REG_AON_APB_RF_AON_MTX_MAIN_LPC_CTRL					0x0794
#define REG_AON_APB_RF_AON_MTX_M0_LPC_CTRL						0x0798
#define REG_AON_APB_RF_AON_MTX_M1_LPC_CTRL						0x079c
#define REG_AON_APB_RF_AON_MTX_M2_LPC_CTRL						0x07a0
#define REG_AON_APB_RF_AON_MTX_M3_LPC_CTRL						0x07a4
#define REG_AON_APB_RF_AON_MTX_M4_LPC_CTRL						0x07a8
#define REG_AON_APB_RF_AON_MTX_M5_LPC_CTRL						0x07ac
#define REG_AON_APB_RF_AON_MTX_M6_LPC_CTRL						0x07b0
#define REG_AON_APB_RF_AON_MTX_S0_LPC_CTRL						0x07b4
#define REG_AON_APB_RF_AON_MTX_S1_LPC_CTRL						0x07b8
#define REG_AON_APB_RF_AON_MTX_S2_LPC_CTRL						0x07bc
#define REG_AON_APB_RF_AON_MTX_S3_LPC_CTRL						0x07c0
#define REG_AON_APB_RF_AON_MTX_S4_LPC_CTRL						0x07c4
#define REG_AON_APB_RF_AON_MTX_S5_LPC_CTRL						0x07c8
#define REG_AON_APB_RF_AON_MTX_S6_LPC_CTRL						0x07cc
#define REG_AON_APB_RF_AON_MTX_S7_LPC_CTRL						0x07d0
#define REG_AON_APB_RF_EAXI_MTX_M0_LPC_CTRL					0x07e0
#define REG_AON_APB_RF_EAXI_MTX_M1_LPC_CTRL					0x07e4
#define REG_AON_APB_RF_EAXI_MTX_M2_LPC_CTRL					0x07e8
#define REG_AON_APB_RF_EAXI_MTX_S0_LPC_CTRL					0x07ec
#define REG_AON_APB_RF_EAXI_MTX_S1_LPC_CTRL					0x07f0
#define REG_AON_APB_RF_EAXI_MTX_MAIN_LPC_CTRL					0x07f4
#define REG_AON_APB_RF_AON_SOC_USB_CTRL						0x07fc
#define REG_AON_APB_RF_PCIE_SLV_ADDR_OFFSET					0x0800
#define REG_AON_APB_RF_AP_EMMC_PHY_CTRL						0x0804
#define REG_AON_APB_RF_AP_SDIO1_PHY_CTRL						0x0808
#define REG_AON_APB_RF_PS_SDIO2_PHY_CTRL						0x080c
#define REG_AON_APB_RF_V3PS_SDIO2_PHY_CTRL						0x0810
#define REG_AON_APB_RF_RVBARADDR0							0x0820
#define REG_AON_APB_RF_RVBARADDR1							0x0824
#define REG_AON_APB_RF_APCPU_PU_NUM						0x0828
#define REG_AON_APB_RF_APCPU_L3CACHE_RAM_PD_BYPASS					0x082c
#define REG_AON_APB_RF_AON_TO_AUDCP_RS_LPC_CTRL					0x0830
#define REG_AON_APB_RF_AP_TO_NR_RS_LPC_CTRL					0x0834
#define REG_AON_APB_RF_AP_TO_PSCP_RS_LPC_CTRL					0x0838
#define REG_AON_APB_RF_APCPU_TO_AP_RS_LPC_CTRL					0x083c
#define REG_AON_APB_RF_NR_TO_AP_RS_LPC_CTRL					0x0840
#define REG_AON_APB_RF_NR_TO_PSCP_RS_LPC_CTRL					0x0844
#define REG_AON_APB_RF_PSCP_TO_AP_RS_LPC_CTRL					0x0848
#define REG_AON_APB_RF_PSCP_TO_NR_RS_LPC_CTRL					0x084c
#define REG_AON_APB_RF_PSCP_TO_V3_RS_LPC_CTRL					0x0850
#define REG_AON_APB_RF_AUDCP_TO_PUB_RS_LPC_CTRL					0x0854
#define REG_AON_APB_RF_AON_TO_PUB_RS_LPC_CTRL					0x0858
#define REG_AON_APB_RF_CSSYS_TO_PUB_RS_LPC_CTRL					0x085c
#define REG_AON_APB_RF_APCPU_TO_PUB_RS_LPC_CTRL					0x0860
#define REG_AON_APB_RF_AP_TO_PUB_RS_LPC_CTRL					0x0864
#define REG_AON_APB_RF_NRACC_TO_PUB_RS_LPC_CTRL					0x0868
#define REG_AON_APB_RF_NRCPU_TO_PUB_RS_LPC_CTRL					0x086c
#define REG_AON_APB_RF_V3CPU_TO_PUB_RS_LPC_CTRL					0x0870
#define REG_AON_APB_RF_V3ACC_TO_PUB_RS_LPC_CTRL					0x0874
#define REG_AON_APB_RF_PSCP_TO_PUB_RS_LPC_CTRL					0x0878
#define REG_AON_APB_RF_AB_W_AGCP2EMC_LPC_CTRL					0x087c
#define REG_AON_APB_RF_AB_W_AONSYS2EMC_LPC_CTRL					0x0880
#define REG_AON_APB_RF_AB_W_APCPU2EMC_LPC_CTRL					0x0884
#define REG_AON_APB_RF_AB_W_CSSYS2EMC_LPC_CTRL					0x0888
#define REG_AON_APB_RF_AB_W_MINIAP2EMC_LPC_CTRL					0x088c
#define REG_AON_APB_RF_AB_W_NRACC2EMC_LPC_CTRL					0x0890
#define REG_AON_APB_RF_AB_W_NRCPU2EMC_LPC_CTRL					0x0894
#define REG_AON_APB_RF_AB_W_V3ACC2EMC_LPC_CTRL					0x0898
#define REG_AON_APB_RF_AB_W_V3CPU2EMC_LPC_CTRL					0x089c
#define REG_AON_APB_RF_AB_W_PSCP2EMC_LPC_CTRL					0x08a0
#define REG_AON_APB_RF_AHB2AHB_ASYNC_CTRL						0x08a4
#define REG_AON_APB_RF_APCPU_ATB_CLK_DFS_CTRL					0x08a8
#define REG_AON_APB_RF_AON_APB_DFS_CTRL						0x08ac
#define REG_AON_APB_RF_AON_TO_PUB_RF_LPC_CTRL					0x08b0
#define REG_AON_APB_RF_EAXI_TO_APCPU_LPC_CTRL					0x08b4
#define REG_AON_APB_RF_EWARLY_WAKEUP_EN						0x08b8
#define REG_AON_APB_RF_PWR_CTRL							0x0a00
#define REG_AON_APB_RF_SYS_DEBUG_BUS_SEL_CFG4					0x0a0c
#define REG_AON_APB_RF_SYS_DEBUG_BUS_SEL_CFG0					0x0a10
#define REG_AON_APB_RF_SYS_DEBUG_BUS_SEL_CFG1					0x0a14
#define REG_AON_APB_RF_SYS_DEBUG_BUS_SEL_CFG2					0x0a18
#define REG_AON_APB_RF_SYS_DEBUG_BUS_SEL_CFG3					0x0a1c
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG1					0x0a20
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG2					0x0a24
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG3					0x0a28
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG4					0x0a2c
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG5					0x0a30
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG6					0x0a34
#define REG_AON_APB_RF_PAD_DBG_BUS_SEL_CFG7					0x0a38
#define REG_AON_APB_RF_PAD_DBG_BUS_DATA_A						0x0a40
#define REG_AON_APB_RF_PAD_DBG_BUS_DATA_B						0x0a44
#define REG_AON_APB_RF_PAD_DBG_BUS_DATA_OUT					0x0a48
#define REG_AON_APB_RF_DBG_BUS_DATA_V3						0x0a4c
#define REG_AON_APB_RF_DBG_BUS_DATA_PSCP						0x0a50
#define REG_AON_APB_RF_DBG_BUS_DATA_AUDCP						0x0a54
#define REG_AON_APB_RF_SCC_DBG_BUS							0x0a58
#define REG_AON_APB_RF_DEBUG_FILTER_0						0x0a60
#define REG_AON_APB_RF_DEBUG_FILTER_1						0x0a64
#define REG_AON_APB_RF_DEBUG_FILTER_2						0x0a68
#define REG_AON_APB_RF_DEBUG_FILTER_3						0x0a6c
#define REG_AON_APB_RF_DEBUG_FILTER_4						0x0a70
#define REG_AON_APB_RF_DEBUG_FILTER_5						0x0a74
#define REG_AON_APB_RF_TPIU_DATA_TO_SERDES_SEL					0x0a80
#define REG_AON_APB_RF_MTX_BUSMON_EB						0x0a84
#define REG_AON_APB_RF_AON_CHIP_ID0						0x0c00
#define REG_AON_APB_RF_AON_CHIP_ID1						0x0c04
#define REG_AON_APB_RF_AON_PLAT_ID0						0x0c08
#define REG_AON_APB_RF_AON_PLAT_ID1						0x0c0c
#define REG_AON_APB_RF_AON_IMPL_ID							0x0c10
#define REG_AON_APB_RF_AON_MFT_ID							0x0c14
#define REG_AON_APB_RF_AON_VER_ID							0x0c18
#define REG_AON_APB_RF_AON_CHIP_ID							0x0c1c
#define REG_AON_APB_RF_USER_RSV_FLAG1						0x0c20
#define REG_AON_APB_RF_BOND_OPT0							0x0c30
#define REG_AON_APB_RF_DEVICE_LIFE_CYCLE						0x0c34
#define REG_AON_APB_RF_RES_REG0							0x0c40
#define REG_AON_APB_RF_RES_REG1							0x0c44
#define REG_AON_APB_RF_CP_RFFE_RES_REG0						0x0d00
#define REG_AON_APB_RF_CP_RFFE_RES_REG1						0x0d04
#define REG_AON_APB_RF_CP_RFFE_RES_REG2						0x0d08
#define REG_AON_APB_RF_CP_RFFE_RES_REG3						0x0d0c
#define REG_AON_APB_RF_CP_RFFE_RES_REG4						0x0d10
#define REG_AON_APB_RF_CP_RFFE_RES_REG5						0x0d14
#define REG_ANLG_PHY_TOP_RF_ANALOG_RCO100M_RTC100M_CTRL				0x0000
#define REG_ANLG_PHY_TOP_RF_ANALOG_RCO100M_REG_SEL_CFG_0				0x0004
#define REG_ANLG_PHY_TOP_RF_ANALOG_EFUSE4K_EFUSE_PIN_PW_CTL			0x0008
#define REG_ANLG_PHY_TOP_RF_ANALOG_EFUSE4K_REG_SEL_CFG_0				0x000c
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_CTRL0				0x0010
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_CTRL2				0x0014
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_CTRL0				0x0018
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_CTRL2				0x001c
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL0				0x0020
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL2				0x0024
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL0				0x0028
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL2				0x002c
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_CTRL0				0x0030
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_CTRL2				0x0034
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_CTRL0				0x0038
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_CTRL2				0x003c
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_REG_SEL_CFG_0				0x0040
#define REG_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_REG_SEL_CFG_1				0x0044
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_CTRL0				0x0048
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_CTRL1				0x004c
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL0			0x0050
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL2			0x0054
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL0			0x0058
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL2			0x005c
#define REG_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_REG_SEL_CFG_0			0x0060
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_ANA_BB_PWR_CTRL				0x0064
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_ANA_BB_SINE_CTRL1			0x0068
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CTRL0				0x006c
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CTRL1				0x0070
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2				0x0074
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CTRL3				0x0078
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CTRL4				0x007c
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CTRL6				0x0080
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CTRL0				0x0084
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CTRL1				0x0088
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2				0x008c
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CTRL3				0x0090
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CTRL4				0x0094
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CTRL6				0x0098
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_CTRL0				0x009c
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_CTRL2				0x00a0
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_5G_APC_CTRL1				0x00a4
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_N5G_APC_CTRL1				0x00a8
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_5G_APC_CTRL1				0x00ac
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_N5G_APC_CTRL1				0x00b0
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_AAPC_CTRL1				0x00b4
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_TEST_CLK_CTRL				0x00b8
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_REG_SEL_CFG_0				0x00bc
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_REG_SEL_CFG_1				0x00c0
#define REG_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_REG_SEL_CFG_2				0x00c4
#define REG_CS_DBG_APB_RF_BUS_BUSY_TIMER						0x0000
#define REG_CS_DBG_APB_RF_MISC_STATUS						0x0004
#define REG_CS_DBG_APB_RF_PWR_UP_EN						0x0008
#define REG_CS_DBG_APB_RF_DBG_CTRL							0x000c
#define REG_CS_DBG_APB_RF_STM_SOFT_RST						0x0010
#define REG_CS_DBG_APB_RF_RCO_CLK_CTRL						0x0014
#define REG_CS_DBG_APB_RF_DBG_SYS_LP_CTRL_1					0x0018
#define REG_CS_DBG_APB_RF_DBG_SYS_LP_CTRL_2					0x001c
#define REG_CS_DBG_APB_RF_APCPU_CS_LP_CTRL						0x0020
#define REG_CS_DBG_APB_RF_DBG_MTX_M0_LPC_CTRL					0x0024
#define REG_CS_DBG_APB_RF_DBG_MTX_S0_LPC_CTRL					0x0028
#define REG_CS_DBG_APB_RF_DBG_MTX_S1_LPC_CTRL					0x002c
#define REG_CS_DBG_APB_RF_SUB_SYS_DBG_CLK_CTRL					0x00f0
#define REG_CS_DBG_APB_RF_DEBUG_SUBSYS_SEL_A					0x0100
#define REG_CS_DBG_APB_RF_DEBUG_SUBSYS_SEL_B					0x0104
#define REG_CS_DBG_APB_RF_AON_DBG_MOD_SEL						0x010c
#define REG_CS_DBG_APB_RF_AON_DBG_SIG_SEL						0x0110
#define REG_CS_DBG_APB_RF_APCPU_DBG_MOD_SEL					0x0114
#define REG_CS_DBG_APB_RF_APCPU_DBG_SIG_SEL					0x0118
#define REG_CS_DBG_APB_RF_AUDCP_DBG_MOD_SEL					0x011c
#define REG_CS_DBG_APB_RF_AUDCP_DBG_SIG_SEL					0x0120
#define REG_CS_DBG_APB_RF_PSCP_DBG_MOD_SEL						0x0124
#define REG_CS_DBG_APB_RF_PSCP_DBG_SIG_SEL						0x0128
#define REG_CS_DBG_APB_RF_PUB_DBG_MOD_SEL						0x012c
#define REG_CS_DBG_APB_RF_PUB_DBG_SIG_SEL						0x0130
#define REG_CS_DBG_APB_RF_V3_DBG_MOD_SEL						0x0134
#define REG_CS_DBG_APB_RF_V3_DBG_SIG_SEL						0x0138
#define REG_CS_DBG_APB_RF_NR_DBG_MOD_SEL						0x013c
#define REG_CS_DBG_APB_RF_NR_DBG_SIG_SEL						0x0140
#define REG_CS_DBG_APB_RF_AP_DBG_MOD_SEL						0x014c
#define REG_CS_DBG_APB_RF_AP_DBG_SIG_SEL						0x0150
#define REG_CS_DBG_APB_RF_MDAR_DBG_MOD_SEL						0x0154
#define REG_CS_DBG_APB_RF_MDAR_DBG_SIG_SEL						0x0158
#define REG_CS_DBG_APB_RF_AON_DBG_MOD_SEL_2					0x0160
#define REG_CS_DBG_APB_RF_AON_DBG_SIG_SEL_2					0x0164
#define REG_CS_DBG_APB_RF_DBG_BUS0_SEL						0x0200
#define REG_CS_DBG_APB_RF_DBG_BUS1_SEL						0x0204
#define REG_CS_DBG_APB_RF_DBG_BUS2_SEL						0x0208
#define REG_CS_DBG_APB_RF_DBG_BUS3_SEL						0x020c
#define REG_CS_DBG_APB_RF_DBG_BUS4_SEL						0x0210
#define REG_CS_DBG_APB_RF_DBG_BUS5_SEL						0x0214
#define REG_CS_DBG_APB_RF_DBG_BUS6_SEL						0x0218
#define REG_CS_DBG_APB_RF_DBG_BUS7_SEL						0x021c
#define REG_CS_DBG_APB_RF_DBG_BUS8_SEL						0x0220
#define REG_CS_DBG_APB_RF_DBG_BUS9_SEL						0x0224
#define REG_CS_DBG_APB_RF_DBG_BUS10_SEL						0x0228
#define REG_CS_DBG_APB_RF_DBG_BUS11_SEL						0x022c
#define REG_CS_DBG_APB_RF_DBG_BUS12_SEL						0x0230
#define REG_CS_DBG_APB_RF_DBG_BUS13_SEL						0x0234
#define REG_CS_DBG_APB_RF_DBG_BUS14_SEL						0x0238
#define REG_CS_DBG_APB_RF_DBG_BUS15_SEL						0x023c
#define REG_CS_DBG_APB_RF_DBG_BUS16_SEL						0x0240
#define REG_CS_DBG_APB_RF_DBG_BUS17_SEL						0x0244
#define REG_CS_DBG_APB_RF_DBG_BUS18_SEL						0x0248
#define REG_CS_DBG_APB_RF_DBG_BUS19_SEL						0x024c
#define REG_CS_DBG_APB_RF_DBG_BUS20_SEL						0x0250
#define REG_CS_DBG_APB_RF_DBG_BUS21_SEL						0x0254
#define REG_CS_DBG_APB_RF_DBG_BUS22_SEL						0x0258
#define REG_CS_DBG_APB_RF_DBG_BUS23_SEL						0x025c
#define REG_CS_DBG_APB_RF_DBG_BUS24_SEL						0x0260
#define REG_CS_DBG_APB_RF_DBG_BUS25_SEL						0x0264
#define REG_CS_DBG_APB_RF_DBG_BUS26_SEL						0x0268
#define REG_CS_DBG_APB_RF_DBG_BUS27_SEL						0x026c
#define REG_CS_DBG_APB_RF_DBG_BUS28_SEL						0x0270
#define REG_CS_DBG_APB_RF_DBG_BUS29_SEL						0x0274
#define REG_CS_DBG_APB_RF_DBG_BUS30_SEL						0x0278
#define REG_CS_DBG_APB_RF_DBG_BUS31_SEL						0x027c
#define REG_CS_DBG_APB_RF_DBG_BUS_DATA_A						0x0300
#define REG_CS_DBG_APB_RF_DBG_BUS_DATA_B						0x0304
#define REG_CS_DBG_APB_RF_DBG_BUS_DATA						0x0308
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_INT_EN					0x0400
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_INT_CLR					0x0404
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_INT_RAW					0x0408
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_INT_STAT					0x040c
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR0					0x0410
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR1					0x0414
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR2					0x0418
#define REG_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR3					0x041c
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL0				0x0000
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL1				0x0004
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL2				0x0008
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL3				0x000c
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL4				0x0010
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL5				0x0014
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL6				0x0018
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL7				0x001c
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL0				0x0020
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL1				0x0024
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL2				0x0028
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL3				0x002c
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL4				0x0030
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL5				0x0034
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL6				0x0038
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL7				0x003c
#define REG_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_REG_SEL_CFG_0				0x0040
#define REG_PUB_QOSC_AHB_REG_QOS_CTRL_EB						0x0000
#define REG_PUB_QOSC_AHB_REG_QOS_CTRL_RESET					0x0004
#define REG_PUB_QOSC_AHB_REG_QOSC_CLK_CTRL						0x0008
#define REG_PUB_QOSC_AHB_REG_QOSC_PORT_ENABLE					0x000c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNTER_EN					0x0010
#define REG_PUB_QOSC_AHB_REG_QOSC_AXURGENT_EN					0x0014
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_EN					0x0018
#define REG_PUB_QOSC_AHB_REG_QOSC_CFG						0x001c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH0				0x0020
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH1				0x0024
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH2				0x0028
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH3				0x002c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH4				0x0030
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH5				0x0034
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH6				0x0038
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH7				0x003c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH0				0x0050
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH1				0x0054
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH2				0x0058
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH3				0x005c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH4				0x0060
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH5				0x0064
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH6				0x0068
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH7				0x006c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH0				0x0080
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH1				0x0084
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH2				0x0088
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH3				0x008c
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH4				0x0090
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH5				0x0094
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH6				0x0098
#define REG_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH7				0x009c
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW0				0x00b0
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW1				0x00b4
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH0				0x00c0
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH1				0x00c4
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH2				0x00c8
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH3				0x00cc
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH4				0x00d0
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH5				0x00d4
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH6				0x00d8
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH7				0x00dc
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH8				0x00e0
#define REG_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_CH9				0x00e4
#define REG_PUB_QOSC_AHB_REG_QOSC_FORCE_URGENT_HIGH_EN				0x00f0
#define REG_PUB_QOSC_AHB_REG_QOSC_FORCE_URGENT_ULTRA_EN				0x00f4
#define REG_PUB_QOSC_AHB_REG_QOSC_LATMON_AXURGENT_EN				0x00f8
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH0					0x0100
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH1					0x0104
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH2					0x0108
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH3					0x010c
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH4					0x0110
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH5					0x0114
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH6					0x0118
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH7					0x011c
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH8					0x0120
#define REG_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_CH9					0x0124
#define REG_PUB_QOSC_AHB_REG_QOSC_STATUS0						0x0200
#define REG_PUB_QOSC_AHB_REG_QOSC_STATUS1						0x0204
#define REG_PUB_QOSC_AHB_REG_QOSC_STATUS2						0x0208
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH0					0x0210
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH1					0x0214
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH2					0x0218
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH3					0x021c
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH4					0x0220
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH5					0x0224
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH6					0x0228
#define REG_PUB_QOSC_AHB_REG_QOSC_URGENT_COUNT_CH7					0x022c
#define REG_PUB_QOSC_AHB_REG_QOSC_DBG_MON						0x0280
#define REG_PUB_QOSC_AHB_REG_QOSC_MON_STATUS					0x0284
#define REG_PUB_QOSC_AHB_REG_QOSC_MON_STATUS_1					0x0288
#define REG_PUB_QOSC_AHB_REG_LATMON_EB0						0x0800
#define REG_PUB_QOSC_AHB_REG_LATMON_EB1						0x0804
#define REG_PUB_QOSC_AHB_REG_LATMON_RESET						0x0808
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM0					0x080c
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM0					0x0810
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM0					0x0814
#define REG_PUB_QOSC_AHB_REG_LATMON_HW_DFS_CFG					0x0818
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM1					0x0820
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM1					0x0824
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM1					0x0828
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM2					0x0830
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM2					0x0834
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM2					0x0838
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM3					0x0840
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM3					0x0844
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM3					0x0848
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM4					0x0850
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM4					0x0854
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM4					0x0858
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM5					0x0860
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM5					0x0864
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM5					0x0868
#define REG_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_LM6					0x0870
#define REG_PUB_QOSC_AHB_REG_URGENT_RATIO_LM6					0x0874
#define REG_PUB_QOSC_AHB_REG_LATMON_SUB_CFG_LM6					0x0878
#define REG_PUB_QOSC_AHB_REG_LATMON_LM0_STATUS0					0x0900
#define REG_PUB_QOSC_AHB_REG_LATMON_LM0_STATUS1					0x0904
#define REG_PUB_QOSC_AHB_REG_LATMON_LM0_STATUS2					0x0908
#define REG_PUB_QOSC_AHB_REG_LATMON_LM0_STATUS3					0x090c
#define REG_PUB_QOSC_AHB_REG_LATMON_LM1_STATUS0					0x0910
#define REG_PUB_QOSC_AHB_REG_LATMON_LM1_STATUS1					0x0914
#define REG_PUB_QOSC_AHB_REG_LATMON_LM1_STATUS2					0x0918
#define REG_PUB_QOSC_AHB_REG_LATMON_LM1_STATUS3					0x091c
#define REG_PUB_QOSC_AHB_REG_LATMON_LM2_STATUS0					0x0920
#define REG_PUB_QOSC_AHB_REG_LATMON_LM2_STATUS1					0x0924
#define REG_PUB_QOSC_AHB_REG_LATMON_LM2_STATUS2					0x0928
#define REG_PUB_QOSC_AHB_REG_LATMON_LM2_STATUS3					0x092c
#define REG_PUB_QOSC_AHB_REG_LATMON_LM3_STATUS0					0x0930
#define REG_PUB_QOSC_AHB_REG_LATMON_LM3_STATUS1					0x0934
#define REG_PUB_QOSC_AHB_REG_LATMON_LM3_STATUS2					0x0938
#define REG_PUB_QOSC_AHB_REG_LATMON_LM3_STATUS3					0x093c
#define REG_PUB_QOSC_AHB_REG_LATMON_LM4_STATUS0					0x0940
#define REG_PUB_QOSC_AHB_REG_LATMON_LM4_STATUS1					0x0944
#define REG_PUB_QOSC_AHB_REG_LATMON_LM4_STATUS2					0x0948
#define REG_PUB_QOSC_AHB_REG_LATMON_LM4_STATUS3					0x094c
#define REG_PUB_QOSC_AHB_REG_LATMON_LM5_STATUS0					0x0950
#define REG_PUB_QOSC_AHB_REG_LATMON_LM5_STATUS1					0x0954
#define REG_PUB_QOSC_AHB_REG_LATMON_LM5_STATUS2					0x0958
#define REG_PUB_QOSC_AHB_REG_LATMON_LM5_STATUS3					0x095c
#define REG_PUB_QOSC_AHB_REG_LATMON_LM6_STATUS0					0x0960
#define REG_PUB_QOSC_AHB_REG_LATMON_LM6_STATUS1					0x0964
#define REG_PUB_QOSC_AHB_REG_LATMON_LM6_STATUS2					0x0968
#define REG_PUB_QOSC_AHB_REG_LATMON_LM6_STATUS3					0x096c
#define REG_PUB_QOSC_AHB_REG_LATMON_STATUS0					0x0970
#define REG_PUB_QOSC_AHB_REG_LATMON_STATUS1					0x0974
#define REG_PUB_QOSC_AHB_REG_BWMON_EB						0x0a00
#define REG_PUB_QOSC_AHB_REG_BWMON0_UP_WBW_SET					0x0a04
#define REG_PUB_QOSC_AHB_REG_BWMON0_UP_RBW_SET					0x0a08
#define REG_PUB_QOSC_AHB_REG_BWMON1_UP_WBW_SET					0x0a0c
#define REG_PUB_QOSC_AHB_REG_BWMON1_UP_RBW_SET					0x0a10
#define REG_PUB_QOSC_AHB_REG_BWMON2_UP_WBW_SET					0x0a14
#define REG_PUB_QOSC_AHB_REG_BWMON2_UP_RBW_SET					0x0a18
#define REG_PUB_QOSC_AHB_REG_BWMON3_UP_WBW_SET					0x0a1c
#define REG_PUB_QOSC_AHB_REG_BWMON3_UP_RBW_SET					0x0a20
#define REG_PUB_QOSC_AHB_REG_BWMON4_UP_WBW_SET					0x0a24
#define REG_PUB_QOSC_AHB_REG_BWMON4_UP_RBW_SET					0x0a28
#define REG_PUB_QOSC_AHB_REG_BWMON5_UP_WBW_SET					0x0a2c
#define REG_PUB_QOSC_AHB_REG_BWMON5_UP_RBW_SET					0x0a30
#define REG_PUB_QOSC_AHB_REG_BWMON_STATUS						0x0a70
#define REG_PUB_QOSC_AHB_REG_BWMON0_WBW_CNT					0x0a80
#define REG_PUB_QOSC_AHB_REG_BWMON0_RBW_CNT					0x0a84
#define REG_PUB_QOSC_AHB_REG_BWMON1_WBW_CNT					0x0a88
#define REG_PUB_QOSC_AHB_REG_BWMON1_RBW_CNT					0x0a8c
#define REG_PUB_QOSC_AHB_REG_BWMON2_WBW_CNT					0x0a90
#define REG_PUB_QOSC_AHB_REG_BWMON2_RBW_CNT					0x0a94
#define REG_PUB_QOSC_AHB_REG_BWMON3_WBW_CNT					0x0a98
#define REG_PUB_QOSC_AHB_REG_BWMON3_RBW_CNT					0x0a9c
#define REG_PUB_QOSC_AHB_REG_BWMON4_WBW_CNT					0x0aa0
#define REG_PUB_QOSC_AHB_REG_BWMON4_RBW_CNT					0x0aa4
#define REG_PUB_QOSC_AHB_REG_BWMON5_WBW_CNT					0x0aa8
#define REG_PUB_QOSC_AHB_REG_BWMON5_RBW_CNT					0x0aac
#define REG_PUB_QOSC_AHB_REG_BWMON_VOTE_CTRL					0x0ab0
#define REG_AON_DBG_APB_RF_APCPU_COMM_CTRL						0x0000
#define REG_AON_DBG_APB_RF_APCPU_PROT_CTRL						0x0004
#define REG_AON_DBG_APB_RF_CSSYS_CFG						0x0008
#define REG_AON_DBG_APB_RF_APCPU_PROT_CTRL_NON_SEC					0x0010
#define REG_AON_DBG_APB_RF_CSSYS_CFG_NON_SEC					0x0014
#define REG_AON_DBG_APB_RF_PSCP_CR8_PROT_CTRL					0x0020
#define REG_AON_DBG_APB_RF_PSCP_CR8_PROT_CTRL_NON_SEC				0x0024
#define REG_AON_DBG_APB_RF_NRCP_CR8_PROT_CTRL					0x0028
#define REG_AON_DBG_APB_RF_NRCP_CR8_PROT_CTRL_NON_SEC				0x002c
#define REG_AON_DBG_APB_RF_V3PS_CR5_PROT_CTRL					0x0030
#define REG_AON_DBG_APB_RF_V3PS_CR5_PROT_CTRL_NON_SEC				0x0034
#define REG_AON_DBG_APB_RF_V3PHY_CR5_PROT_CTRL					0x0038
#define REG_AON_DBG_APB_RF_V3PHY_CR5_PROT_CTRL_NON_SEC				0x003c
#define REG_AON_DBG_APB_RF_DEBUG_BOND_OPTION					0x0040
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_ANA_PCIE31_CTRL1			0x0004
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_ANA_PCIE31_CTRL2			0x0008
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_REG_SEL_CFG_0			0x000c
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL0				0x0010
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL1				0x0014
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL2				0x0018
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL3				0x001c
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL4				0x0020
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL5				0x0024
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL6				0x0028
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL7				0x002c
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL8				0x0030
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL9				0x0034
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_CTRL10			0x0038
#define REG_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_REG_SEL_CFG_0				0x003c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL0				0x0000
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL2				0x0004
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL4				0x0008
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL5				0x000c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL6				0x0010
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL0				0x0014
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL1				0x0018
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL2				0x001c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL3				0x0020
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL4				0x0024
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL5				0x0028
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL6				0x002c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL0				0x0030
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL2				0x0034
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL4				0x0038
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL5				0x003c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL6				0x0040
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL0				0x0044
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL2				0x0048
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL4				0x004c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL5				0x0050
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL6				0x0054
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL0				0x0058
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL1				0x005c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL2				0x0060
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL3				0x0064
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL4				0x0068
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL5				0x006c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL6				0x0070
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_TEST_CLK_CTRL				0x0074
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_ANA_TESTMUX				0x0078
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_ANA_PLL_RSVD				0x007c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CTRL0				0x0080
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CTRL2				0x0084
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CTRL3				0x0088
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CTRL5				0x008c
#define REG_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CTRL6				0x0090
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_THM_CTRL0				0x0094
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL0				0x009c
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL2				0x00a0
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL4				0x00a4
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL5				0x00a8
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL6				0x00ac
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL0				0x00b0
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL2				0x00b4
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL4				0x00b8
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL5				0x00bc
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL6				0x00c0
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_TEST_CLK_CTRL			0x00c4
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX0			0x00c8
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX1			0x00cc
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX2			0x00d0
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX3			0x00d4
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX4			0x00d8
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX5			0x00dc
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX6			0x00e0
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_DVFS_INDEX7			0x00e4
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL_DBG_SEL			0x00e8
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX0			0x00ec
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX1			0x00f0
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX2			0x00f4
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX3			0x00f8
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX4			0x00fc
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX5			0x0100
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX6			0x0104
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_DVFS_INDEX7			0x0108
#define REG_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL_DBG_SEL			0x010c
#define REG_AP_AHB_RF_AHB_EB							0x0000
#define REG_AP_AHB_RF_AHB_RST							0x0004
#define REG_AP_AHB_RF_AP_SYS_SLEEP_CFG						0x0008
#define REG_AP_AHB_RF_CLOCK_FREQUENCY_DOWN						0x0018
#define REG_AP_AHB_RF_USB0_CTRL							0x0020
#define REG_AP_AHB_RF_USB0_DBG0							0x0024
#define REG_AP_AHB_RF_USB0_DBG1							0x0028
#define REG_AP_AHB_RF_USB0_DBG2							0x002c
#define REG_AP_AHB_RF_APB_PCLK_AUTO_GATE_EB					0x003c
#define REG_AP_AHB_RF_APB_PCLK_AUTO_SLOW_SEL					0x0040
#define REG_AP_AHB_RF_AP_SYS_CLK_FRC_OFF0						0x0044
#define REG_AP_AHB_RF_AP_SYS_CLK_FRC_ON0						0x0048
#define REG_AP_AHB_RF_AP_SYS_CLK_BUS_AUTO_EN					0x004c
#define REG_AP_AHB_RF_AP_SYS_AUTO_SLEEP_CFG					0x0050
#define REG_AP_AHB_RF_MMTX_M0_LPC							0x0100
#define REG_AP_AHB_RF_MMTX_M1_LPC							0x0104
#define REG_AP_AHB_RF_MMTX_M2_LPC							0x0108
#define REG_AP_AHB_RF_MMTX_M3_LPC							0x010c
#define REG_AP_AHB_RF_MMTX_M4_LPC							0x0110
#define REG_AP_AHB_RF_MMTX_M5_LPC							0x0114
#define REG_AP_AHB_RF_MMTX_M6_LPC							0x0118
#define REG_AP_AHB_RF_MMTX_MAIN_LPC						0x013c
#define REG_AP_AHB_RF_MMTX_S0_LPC							0x0140
#define REG_AP_AHB_RF_MMTX_S1_LPC							0x0144
#define REG_AP_AHB_RF_MMTX_S2_LPC							0x0148
#define REG_AP_AHB_RF_MMTX_S3_LPC							0x014c
#define REG_AP_AHB_RF_MMTX_S4_LPC							0x0150
#define REG_AP_AHB_RF_MMTX_S5_LPC							0x0154
#define REG_AP_AHB_RF_MMTX_S6_LPC							0x0158
#define REG_AP_AHB_RF_MMTX_MST_FRC_LSLP						0x0180
#define REG_AP_AHB_RF_MMTX_LSLP_LPC_BYPASS						0x0184
#define REG_AP_AHB_RF_MMTX_MST_FRC_PUB_DSLP					0x0188
#define REG_AP_AHB_RF_MMTX_PUB_DSLP_LPC_BYPASS					0x018c
#define REG_AP_AHB_RF_MMTX_MST_FRC_DOZE						0x0190
#define REG_AP_AHB_RF_MMTX_DOZE_LPC_BYPASS						0x0194
#define REG_AP_AHB_RF_MMTX_AXI_FREQ_ALLOW0						0x0198
#define REG_AP_AHB_RF_MMTX_AXI_FREQ_ALLOW1						0x019c
#define REG_AP_AHB_RF_MMTX_AXI_FREQ_LSLP_ALLOW0					0x01a0
#define REG_AP_AHB_RF_MMTX_AXI_FREQ_LSLP_ALLOW1					0x01a4
#define REG_AP_AHB_RF_AP_QOS0							0x0300
#define REG_AP_AHB_RF_AP_QOS1							0x0304
#define REG_AP_AHB_RF_AP_URGENCY							0x0308
#define REG_AP_AHB_RF_AP_USER0							0x030c
#define REG_AP_AHB_RF_AP_USER1							0x0310
#define REG_AP_AHB_RF_MMTX_CTRL							0x0314
#define REG_AP_AHB_RF_MMTX_PU_NUM0							0x0318
#define REG_AP_AHB_RF_MMTX_PU_NUM1							0x031c
#define REG_AP_AHB_RF_MMTX_PU_NUM2							0x0320
#define REG_AP_AHB_RF_MMTX_PU_NUM3							0x0324
#define REG_AP_AHB_RF_USE_IP_BUSY_GATING						0x0328
#define REG_AP_AHB_RF_RESERVE0							0x0400
#define REG_AP_AHB_RF_RESERVE1							0x0404
#define REG_AP_AHB_RF_CHIP_ID							0x30fc
#define REG_PMU_APB_RF_PD_APCPU_TOP_CFG						0x0000
#define REG_PMU_APB_RF_PD_APCPU_C0_CFG						0x0004
#define REG_PMU_APB_RF_PD_APCPU_C1_CFG						0x0008
#define REG_PMU_APB_RF_PD_APCPU_C2_CFG						0x000c
#define REG_PMU_APB_RF_PD_APCPU_C3_CFG						0x0010
#define REG_PMU_APB_RF_PD_APCPU_TOP_CFG2						0x0014
#define REG_PMU_APB_RF_PD_NRCP_SYS_CFG						0x0018
#define REG_PMU_APB_RF_PD_AP_SYS_CFG						0x001c
#define REG_PMU_APB_RF_PD_NRCP_DL_CFG						0x0020
#define REG_PMU_APB_RF_PD_NRCP_UL_CFG						0x0024
#define REG_PMU_APB_RF_PD_NRCP_SYNC_CFG						0x0028
#define REG_PMU_APB_RF_PD_GPU_RGX_DUST_A_CFG1					0x002c
#define REG_PMU_APB_RF_PD_V3_PS_CFG						0x0030
#define REG_PMU_APB_RF_PD_V3_LCE_CFG						0x0034
#define REG_PMU_APB_RF_PD_V3_DPFEC_CFG						0x0038
#define REG_PMU_APB_RF_PD_NRCP_DSP_0_CFG						0x003c
#define REG_PMU_APB_RF_PD_NRCP_DSP_1_CFG						0x0040
#define REG_PMU_APB_RF_PD_V3_WCE_CFG						0x0044
#define REG_PMU_APB_RF_PD_V3_PHY_CFG						0x0048
#define REG_PMU_APB_RF_PD_V3_LWPROC_CFG						0x004c
#define REG_PMU_APB_RF_PD_V3_TD_CFG						0x0050
#define REG_PMU_APB_RF_PD_V3_MODEM_SYS_CFG						0x0054
#define REG_PMU_APB_RF_PD_PSCP_SYS_CFG						0x0058
#define REG_PMU_APB_RF_PD_AUDCP_AUDDSP_CFG						0x005c
#define REG_PMU_APB_RF_PD_AUDCP_SYS_CFG						0x0060
#define REG_PMU_APB_RF_PUBCP_FRC_STOP_REQ_FOR_WTL					0x0064
#define REG_PMU_APB_RF_PD_PUB_SYS_CFG						0x006c
#define REG_PMU_APB_RF_AP_WAKEUP_POR_CFG						0x0070
#define REG_PMU_APB_RF_XTL_WAIT_CNT						0x0074
#define REG_PMU_APB_RF_PLL_WAIT_CNT0						0x0078
#define REG_PMU_APB_RF_PLL_WAIT_CNT1						0x007c
#define REG_PMU_APB_RF_PLL_WAIT_CNT2						0x0080
#define REG_PMU_APB_RF_XTL0_REL_CFG						0x0084
#define REG_PMU_APB_RF_XTL1_REL_CFG						0x0088
#define REG_PMU_APB_RF_NR_RPLL_REL_CFG						0x008c
#define REG_PMU_APB_RF_XTLBUF0_REL_CFG						0x0090
#define REG_PMU_APB_RF_XTLBUF1_REL_CFG						0x0094
#define REG_PMU_APB_RF_DPLL0_REL_CFG						0x0098
#define REG_PMU_APB_RF_DPLL1_REL_CFG						0x009c
#define REG_PMU_APB_RF_V3PLL_REL_CFG						0x00a0
#define REG_PMU_APB_RF_NRPLL_REL_CFG						0x00a4
#define REG_PMU_APB_RF_V3_RPLL_REL_CFG						0x00a8
#define REG_PMU_APB_RF_R8PLL_REL_CFG						0x00ac
#define REG_PMU_APB_RF_CP_SOFT_RST							0x00b0
#define REG_PMU_APB_RF_CP_SLP_STATUS_DBG0						0x00b4
#define REG_PMU_APB_RF_XTLBUF_LDO_WAIT_CNT						0x00c4
#define REG_PMU_APB_RF_PUB_SYS_AUTO_LIGHT_SLEEP_ENABLE				0x00c8
#define REG_PMU_APB_RF_SLEEP_CTRL							0x00cc
#define REG_PMU_APB_RF_DDR_SLEEP_CTRL						0x00d0
#define REG_PMU_APB_RF_SLEEP_STATUS						0x00d4
#define REG_PMU_APB_RF_PUB_SYS_SLEEP_BYPASS_CFG					0x00d8
#define REG_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_POLL0					0x00dc
#define REG_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_POLL1					0x00e0
#define REG_PMU_APB_RF_DDR_CHN_SLEEP_CTRL0						0x00f8
#define REG_PMU_APB_RF_DDR_CHN_SLEEP_CTRL1						0x00fc
#define REG_PMU_APB_RF_DDR_OP_MODE_CFG						0x012c
#define REG_PMU_APB_RF_DDR_PHY_RET_CFG						0x0130
#define REG_PMU_APB_RF_CLK26M_SEL_CFG						0x0134
#define REG_PMU_APB_RF_BISR_DONE_STATUS						0x0138
#define REG_PMU_APB_RF_BISR_BUSY_STATUS						0x013c
#define REG_PMU_APB_RF_BISR_BYP_CFG						0x0140
#define REG_PMU_APB_RF_BISR_EN_CFG							0x0144
#define REG_PMU_APB_RF_SLEEP_XTLON_CTRL						0x0168
#define REG_PMU_APB_RF_MEM_SLP_CFG							0x016c
#define REG_PMU_APB_RF_MEM_SD_CFG							0x0170
#define REG_PMU_APB_RF_APCPU_CORE_WAKEUP_EN					0x0174
#define REG_PMU_APB_RF_SP_SYS_HOLD_CGM_EN						0x0178
#define REG_PMU_APB_RF_PWR_CNT_WAIT_CFG0						0x017c
#define REG_PMU_APB_RF_PWR_CNT_WAIT_CFG1						0x0180
#define REG_PMU_APB_RF_RCO_REL_CFG							0x0184
#define REG_PMU_APB_RF_RCO_CNT_WAIT_CFG						0x018c
#define REG_PMU_APB_RF_MPLL0_REL_CFG						0x0190
#define REG_PMU_APB_RF_MPLL1_REL_CFG						0x0194
#define REG_PMU_APB_RF_NR_CPUPLL_REL_CFG						0x0198
#define REG_PMU_APB_RF_MEM_AUTO_SLP_CFG						0x019c
#define REG_PMU_APB_RF_MEM_AUTO_SD_CFG						0x01a0
#define REG_PMU_APB_RF_WAKEUP_LOCK_EN						0x01a4
#define REG_PMU_APB_RF_AUDCP_SYS_CORE_INT_DISABLE					0x01a8
#define REG_PMU_APB_RF_V3_PS_CORE_INT_DISABLE					0x01ac
#define REG_PMU_APB_RF_NRCP_DSP_1_CORE_INT_DISABLE					0x01b0
#define REG_PMU_APB_RF_NRCP_DSP_0_CORE_INT_DISABLE					0x01b4
#define REG_PMU_APB_RF_PSCP_CORE_INT_DISABLE					0x01b8
#define REG_PMU_APB_RF_APCPU_C0_CORE_INT_DISABLE					0x01bc
#define REG_PMU_APB_RF_APCPU_C1_CORE_INT_DISABLE					0x01c0
#define REG_PMU_APB_RF_APCPU_C2_CORE_INT_DISABLE					0x01c4
#define REG_PMU_APB_RF_APCPU_C3_CORE_INT_DISABLE					0x01c8
#define REG_PMU_APB_RF_APCPU_C4_CORE_INT_DISABLE					0x01cc
#define REG_PMU_APB_RF_APCPU_C5_CORE_INT_DISABLE					0x01d0
#define REG_PMU_APB_RF_NRCP_CORE_INT_DISABLE					0x01d4
#define REG_PMU_APB_RF_V3_PHY_CORE_INT_DISABLE					0x01d8
#define REG_PMU_APB_RF_APCPU_C4_DSLP_ENA						0x01dc
#define REG_PMU_APB_RF_APCPU_C5_DSLP_ENA						0x01e0
#define REG_PMU_APB_RF_APCPU_C6_DSLP_ENA						0x01e4
#define REG_PMU_APB_RF_APCPU_C7_DSLP_ENA						0x01e8
#define REG_PMU_APB_RF_NR_DSPPLL_REL_CFG						0x01ec
#define REG_PMU_APB_RF_NRCP_DSP_0_DSLP_ENA						0x0200
#define REG_PMU_APB_RF_NRCP_DSP_1_DSLP_ENA						0x0204
#define REG_PMU_APB_RF_AP_DSLP_ENA							0x0208
#define REG_PMU_APB_RF_PSCP_DSLP_ENA						0x020c
#define REG_PMU_APB_RF_V3_MODEM_DSLP_ENA						0x0210
#define REG_PMU_APB_RF_APCPU_TOP_DSLP_ENA						0x0214
#define REG_PMU_APB_RF_SP_SYS_DSLP_ENA						0x0218
#define REG_PMU_APB_RF_PUB_DEEP_SLEEP_ENA						0x021c
#define REG_PMU_APB_RF_PUB_DEEP_SLEEP_WAKEUP_EN					0x0220
#define REG_PMU_APB_RF_LIGHT_SLEEP_WAKEUP_EN					0x0224
#define REG_PMU_APB_RF_V3_PS_DSLP_ENA						0x0228
#define REG_PMU_APB_RF_V3_PHY_DSLP_ENA						0x022c
#define REG_PMU_APB_RF_LIGHT_SLEEP_ENABLE						0x0230
#define REG_PMU_APB_RF_LIGHT_SLEEP_MON						0x0234
#define REG_PMU_APB_RF_AUDCP_SYS_DSLP_ENA						0x0244
#define REG_PMU_APB_RF_AUDCP_AUDDSP_DSLP_ENA					0x0248
#define REG_PMU_APB_RF_NRCP_DSLP_ENA						0x024c
#define REG_PMU_APB_RF_PUB_ACC_RDY							0x0250
#define REG_PMU_APB_RF_PUB_CLK_RDY							0x0254
#define REG_PMU_APB_RF_EIC_SEL							0x0258
#define REG_PMU_APB_RF_MIXED_CFG							0x025c
#define REG_PMU_APB_RF_PMU_DEBUG							0x0270
#define REG_PMU_APB_RF_SLEEP_CNT_CLR						0x0274
#define REG_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_CFG					0x027c
#define REG_PMU_APB_RF_LVDSRFPLL_REL_CFG						0x0280
#define REG_PMU_APB_RF_EXT_XTL_EN_CTRL						0x0284
#define REG_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_CFG					0x0288
#define REG_PMU_APB_RF_PAD_OUT_XTL_EN0_CFG						0x028c
#define REG_PMU_APB_RF_PAD_OUT_XTL_EN1_CFG						0x0290
#define REG_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_CFG					0x0294
#define REG_PMU_APB_RF_PAD_OUT_XTL_EN2_CFG						0x0298
#define REG_PMU_APB_RF_DCXO_LP_DEEP_SLEEP_CFG					0x029c
#define REG_PMU_APB_RF_BISR_FORCE_SEL						0x0300
#define REG_PMU_APB_RF_AON_MEM_CTRL						0x0330
#define REG_PMU_APB_RF_PWR_DOMAIN_INT_CLR						0x0334
#define REG_PMU_APB_RF_DDR_SLP_WAIT_CNT						0x0338
#define REG_PMU_APB_RF_PMU_CLK_DIV_CFG						0x033c
#define REG_PMU_APB_RF_CGM_PMU_SEL							0x0340
#define REG_PMU_APB_RF_PWR_DGB_PARAMETER						0x0344
#define REG_PMU_APB_RF_APCPU_C0_DSLP_ENA						0x0348
#define REG_PMU_APB_RF_APCPU_C1_DSLP_ENA						0x034c
#define REG_PMU_APB_RF_APCPU_C2_DSLP_ENA						0x0350
#define REG_PMU_APB_RF_APCPU_C3_DSLP_ENA						0x0354
#define REG_PMU_APB_RF_APCPU_GIC_RST_EN						0x0358
#define REG_PMU_APB_RF_ANALOG_PHY_PD_CFG						0x035c
#define REG_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_SEL					0x0360
#define REG_PMU_APB_RF_PD_APCPU_C4_CFG						0x0364
#define REG_PMU_APB_RF_PD_APCPU_C5_CFG						0x0368
#define REG_PMU_APB_RF_PD_APCPU_C6_CFG						0x036c
#define REG_PMU_APB_RF_PD_APCPU_C7_CFG						0x0370
#define REG_PMU_APB_RF_PD_APCPU_TOP_CFG3						0x0374
#define REG_PMU_APB_RF_DCDC_AI_CTRL						0x0378
#define REG_PMU_APB_RF_APCPU_TOP_CFG						0x0380
#define REG_PMU_APB_RF_PUB_VOL_DOWN_CFG						0x0384
#define REG_PMU_APB_RF_PLL_WAIT_CNT3						0x0388
#define REG_PMU_APB_RF_R5PLL_REL_CFG						0x038c
#define REG_PMU_APB_RF_APCPU_DSLP_ENA_SRST_MASK_CFG				0x0390
#define REG_PMU_APB_RF_PCIEPLL_H_REL_CFG						0x0394
#define REG_PMU_APB_RF_R5PLL_RST_CTRL_CFG						0x0398
#define REG_PMU_APB_RF_PCIEPLL_H_RST_CTRL_CFG					0x039c
#define REG_PMU_APB_RF_PCIE_SLP_CFG						0x03a0
#define REG_PMU_APB_RF_GIC_CFG							0x03a8
#define REG_PMU_APB_RF_FIREWALL_WAKEUP_PUB						0x03ac
#define REG_PMU_APB_RF_PD_ESE_SYS_CFG						0x03b0
#define REG_PMU_APB_RF_APCPU_MODE_ST_CFG						0x03b4
#define REG_PMU_APB_RF_APCPU_C0_SIMD_RET_MODE					0x03b8
#define REG_PMU_APB_RF_APCPU_C1_SIMD_RET_MODE					0x03bc
#define REG_PMU_APB_RF_APCPU_C2_SIMD_RET_MODE					0x03c0
#define REG_PMU_APB_RF_APCPU_C3_SIMD_RET_MODE					0x03c4
#define REG_PMU_APB_RF_APCPU_CORE_FORCE_STOP					0x03d4
#define REG_PMU_APB_RF_PD_GPU_TOP_CFG1						0x03e0
#define REG_PMU_APB_RF_MPLL_WAIT_CLK_DIV_CFG					0x03e4
#define REG_PMU_APB_RF_MPLL0_RST_CTRL_CFG						0x03e8
#define REG_PMU_APB_RF_MPLL1_RST_CTRL_CFG						0x03ec
#define REG_PMU_APB_RF_R8PLL_RST_CTRL_CFG						0x03f0
#define REG_PMU_APB_RF_NR_CPUPLL_RST_CTRL_CFG					0x03f4
#define REG_PMU_APB_RF_DPLL0_RST_CTRL_CFG						0x03f8
#define REG_PMU_APB_RF_DPLL1_RST_CTRL_CFG						0x03fc
#define REG_PMU_APB_RF_V3PLL_RST_CTRL_CFG						0x0400
#define REG_PMU_APB_RF_NRPLL_RST_CTRL_CFG						0x0404
#define REG_PMU_APB_RF_NR_DSPPLL_RST_CTRL_CFG					0x0408
#define REG_PMU_APB_RF_V3_RPLL_RST_CTRL_CFG					0x040c
#define REG_PMU_APB_RF_NR_RPLL_RST_CTRL_CFG					0x0410
#define REG_PMU_APB_RF_PLL_RST_CTRL_STATE0						0x0414
#define REG_PMU_APB_RF_PLL_RST_CTRL_STATE1						0x0418
#define REG_PMU_APB_RF_ESE_FAST_WAKEUP_CTRL					0x041c
#define REG_PMU_APB_RF_NRCP_DSP_TCM_RAM_POWER_CTRL					0x0420
#define REG_PMU_APB_RF_WTLCP_HU3GE_NEST_DOMAIN_CTRL				0x0424
#define REG_PMU_APB_RF_DEBUG_RECOV_TYPE_CFG					0x0428
#define REG_PMU_APB_RF_APCPU_MODE_ST_CFG1						0x042c
#define REG_PMU_APB_RF_APCPU_MODE_ST_CFG2						0x0430
#define REG_PMU_APB_RF_APCPU_MODE_ST_CFG3						0x0434
#define REG_PMU_APB_RF_DEBUG_STATE_MARK						0x0438
#define REG_PMU_APB_RF_ANANKELITE_MEM_POWER_CFG					0x043c
#define REG_PMU_APB_RF_APCPU_MODE_ST_FRC_ON_CFG					0x0440
#define REG_PMU_APB_RF_APCPU_SOFT_RST_TYPE_CFG					0x0444
#define REG_PMU_APB_RF_APCPU_CORINTH_SCU_CLK_GATE_CFG				0x0448
#define REG_PMU_APB_RF_APCPU_PCHANNEL_STATE0					0x044c
#define REG_PMU_APB_RF_APCPU_PCHANNEL_STATE1					0x0450
#define REG_PMU_APB_RF_APCPU_SOFT_INT_GEN						0x0454
#define REG_PMU_APB_RF_DUAL_RAIL_RAM_FORCE_PD_CFG					0x0458
#define REG_PMU_APB_RF_DUAL_RAIL_RAM_FORCE_SLP_CFG					0x045c
#define REG_PMU_APB_RF_PUB_DFS_FRQ_SEL						0x0460
#define REG_PMU_APB_RF_APCPU_CORE0_SW_PACTIVE					0x0464
#define REG_PMU_APB_RF_APCPU_CORE1_SW_PACTIVE					0x0468
#define REG_PMU_APB_RF_APCPU_CORE2_SW_PACTIVE					0x046c
#define REG_PMU_APB_RF_APCPU_CORE3_SW_PACTIVE					0x0470
#define REG_PMU_APB_RF_APCPU_CORE4_SW_PACTIVE					0x0474
#define REG_PMU_APB_RF_APCPU_CORE5_SW_PACTIVE					0x0478
#define REG_PMU_APB_RF_APCPU_CORE6_SW_PACTIVE					0x047c
#define REG_PMU_APB_RF_APCPU_CORE7_SW_PACTIVE					0x0480
#define REG_PMU_APB_RF_APCPU_CLUSTER_SW_PACTIVE					0x0484
#define REG_PMU_APB_RF_SOFTWARE_APCPU_PACTIVE_ENABLE				0x0488
#define REG_PMU_APB_RF_SOFTWARE_APCPU_PCHANNEL_HANDSHAKE_ENABLE			0x048c
#define REG_PMU_APB_RF_APCPU_CORE0_SW_PCHANNEL_HANDSHAKE				0x0490
#define REG_PMU_APB_RF_APCPU_CORE1_SW_PCHANNEL_HANDSHAKE				0x0494
#define REG_PMU_APB_RF_APCPU_CORE2_SW_PCHANNEL_HANDSHAKE				0x0498
#define REG_PMU_APB_RF_APCPU_CORE3_SW_PCHANNEL_HANDSHAKE				0x049c
#define REG_PMU_APB_RF_APCPU_CORE4_SW_PCHANNEL_HANDSHAKE				0x04a0
#define REG_PMU_APB_RF_APCPU_CORE5_SW_PCHANNEL_HANDSHAKE				0x04a4
#define REG_PMU_APB_RF_APCPU_CORE6_SW_PCHANNEL_HANDSHAKE				0x04a8
#define REG_PMU_APB_RF_APCPU_CORE7_SW_PCHANNEL_HANDSHAKE				0x04ac
#define REG_PMU_APB_RF_APCPU_CLUSTER_SW_PCHANNEL_HANDSHAKE				0x04b0
#define REG_PMU_APB_RF_WTLCP_DPFEC_NEST_DOMAIN_CTRL				0x04b4
#define REG_PMU_APB_RF_GPIO_FORCE_GATING_PLL_CFG					0x04b8
#define REG_PMU_APB_RF_ANALOG_PHY_PWRON_CFG					0x04bc
#define REG_PMU_APB_RF_APCPU_MODE_ST_CGM_EN_CFG					0x04c0
#define REG_PMU_APB_RF_APCPU_DENY_TIME_THRESHOLD_CFG				0x04c4
#define REG_PMU_APB_RF_INT_REQ_APCPU_MODE_ST_ENABLE				0x04c8
#define REG_PMU_APB_RF_INT_REQ_APCPU_MODE_ST_CLR					0x04cc
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_RECORD					0x04d0
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE0_INF				0x04d4
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE1_INF				0x04d8
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE2_INF				0x04dc
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE3_INF				0x04e0
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE4_INF				0x04e4
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE5_INF				0x04e8
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE6_INF				0x04ec
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE7_INF				0x04f0
#define REG_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CLUSTER_INF				0x04f4
#define REG_PMU_APB_RF_APCPU_CSYSPWRUP_WAKEUP_EN_CFG				0x04f8
#define REG_PMU_APB_RF_DVFS_BLOCK_SHUTDOWN_CFG					0x04fc
#define REG_PMU_APB_RF_OFF_EMU_CLR_IN_DISABLE_CFG					0x0500
#define REG_PMU_APB_RF_APCPU_DUAL_RAIL_RAM_FORCE_ON_CFG				0x0504
#define REG_PMU_APB_RF_OFF_EMU_TO_OFF_CFG						0x0508
#define REG_PMU_APB_RF_ALL_PLL_PD_RCO_BYP						0x050c
#define REG_PMU_APB_RF_SP_CLK_GATE_BYP_CFG						0x0510
#define REG_PMU_APB_RF_DPLL1_CNT_DONE_BYP						0x0514
#define REG_PMU_APB_RF_SRAM_DLY_CTRL_CFG						0x0518
#define REG_PMU_APB_RF_WDG_TRIG_DBG_RECOV_CFG					0x051c
#define REG_PMU_APB_RF_APCPU_TOP_RAM_POWER_CTRL					0x0520
#define REG_PMU_APB_RF_PD_GPU_RGX_DUST_B_CFG0					0x0524
#define REG_PMU_APB_RF_PD_GPU_RGX_DUST_B_CFG1					0x0528
#define REG_PMU_APB_RF_PD_IPA_SYS_CFG						0x0538
#define REG_PMU_APB_RF_APCPU_MODE_ST_SOFT_RST					0x053c
#define REG_PMU_APB_RF_FORCE_PUB_DEEP_SLEEP_CFG					0x0540
#define REG_PMU_APB_RF_FORCE_DEEP_SLEEP_CFG					0x0544
#define REG_PMU_APB_RF_FORCE_LIGHT_SLEEP_CFG					0x0548
#define REG_PMU_APB_RF_FORCE_SYSTEM_SLEEP_CFG					0x054c
#define REG_PMU_APB_RF_ESE_ACCESS_DDR_CFG						0x0550
#define REG_PMU_APB_RF_PWR_STATUS1_DBG						0x0584
#define REG_PMU_APB_RF_PWR_STATUS2_DBG						0x0588
#define REG_PMU_APB_RF_PWR_STATUS3_DBG						0x058c
#define REG_PMU_APB_RF_PWR_STATUS4_DBG						0x0590
#define REG_PMU_APB_RF_PWR_STATUS5_DBG						0x0594
#define REG_PMU_APB_RF_PWR_STATUS6_DBG						0x059c
#define REG_PMU_APB_RF_PWR_STATUS7_DBG						0x05a0
#define REG_PMU_APB_RF_PWR_STATUS8_DBG						0x05a4
#define REG_PMU_APB_RF_APCU_MODE_STATE0						0x05b0
#define REG_PMU_APB_RF_APCU_MODE_STATE1						0x05b4
#define REG_PMU_APB_RF_APCU_MODE_STATE2						0x05b8
#define REG_PMU_APB_RF_APCPU_WFI_MARK						0x05c0
#define REG_PMU_APB_RF_AXI_LP_CTRL_DISABLE						0x05d0
#define REG_PMU_APB_RF_PD_APCPU_C0_SHUTDOWN_MARK_STATUS				0x0600
#define REG_PMU_APB_RF_PD_APCPU_C1_SHUTDOWN_MARK_STATUS				0x0604
#define REG_PMU_APB_RF_PD_APCPU_C2_SHUTDOWN_MARK_STATUS				0x0608
#define REG_PMU_APB_RF_PD_APCPU_C3_SHUTDOWN_MARK_STATUS				0x060c
#define REG_PMU_APB_RF_PD_APCPU_TOP_SHUTDOWN_MARK_STATUS				0x0610
#define REG_PMU_APB_RF_PD_AP_SYS_SHUTDOWN_MARK_STATUS				0x0614
#define REG_PMU_APB_RF_PD_NRCP_SYS_SHUTDOWN_MARK_STATUS				0x0618
#define REG_PMU_APB_RF_PD_NRCP_SYNC_SHUTDOWN_MARK_STATUS				0x061c
#define REG_PMU_APB_RF_PD_V3_WCE_SHUTDOWN_MARK_STATUS				0x0620
#define REG_PMU_APB_RF_PD_V3_LCE_SHUTDOWN_MARK_STATUS				0x0624
#define REG_PMU_APB_RF_PD_V3_DPFEC_SHUTDOWN_MARK_STATUS				0x0628
#define REG_PMU_APB_RF_PD_V3_LWPROC_SHUTDOWN_MARK_STATUS				0x062c
#define REG_PMU_APB_RF_PD_V3_PHY_SHUTDOWN_MARK_STATUS				0x0630
#define REG_PMU_APB_RF_PD_V3_PS_SHUTDOWN_MARK_STATUS				0x0634
#define REG_PMU_APB_RF_PD_NRCP_DSP_0_SHUTDOWN_MARK_STATUS				0x0638
#define REG_PMU_APB_RF_PD_NRCP_DSP_1_SHUTDOWN_MARK_STATUS				0x063c
#define REG_PMU_APB_RF_PD_V3_MODEM_SYS_SHUTDOWN_MARK_STATUS			0x0640
#define REG_PMU_APB_RF_PD_PSCP_SYS_SHUTDOWN_MARK_STATUS				0x0644
#define REG_PMU_APB_RF_PD_NRCP_DL_SHUTDOWN_MARK_STATUS				0x0648
#define REG_PMU_APB_RF_PD_V3_TD_SHUTDOWN_MARK_STATUS				0x064c
#define REG_PMU_APB_RF_PD_AUDCP_SYS_SHUTDOWN_MARK_STATUS				0x0650
#define REG_PMU_APB_RF_PD_PUB_SYS_SHUTDOWN_MARK_STATUS				0x0654
#define REG_PMU_APB_RF_PD_AUDCP_AUDDSP_SHUTDOWN_MARK_STATUS			0x0658
#define REG_PMU_APB_RF_PD_NRCP_UL_SHUTDOWN_MARK_STATUS				0x065c
#define REG_PMU_APB_RF_PD_GPU_RGX_DUST_B_SHUTDOWN_MARK_STATUS			0x0660
#define REG_PMU_APB_RF_APCPU_TOP_SLEEP_CNT						0x0664
#define REG_PMU_APB_RF_AP_SYS_SLEEP_CNT						0x0668
#define REG_PMU_APB_RF_V3_MODEM_SYS_SLEEP_CNT					0x066c
#define REG_PMU_APB_RF_PSCP_SYS_SLEEP_CNT						0x0670
#define REG_PMU_APB_RF_AUDCP_SYS_SLEEP_CNT						0x0674
#define REG_PMU_APB_RF_PUB_SYS_LIGHT_SLEEP_CNT					0x0678
#define REG_PMU_APB_RF_AP_DEEP_SLEEP_CNT						0x067c
#define REG_PMU_APB_RF_SP_SYS_DEEP_SLEEP_CNT					0x0680
#define REG_PMU_APB_RF_V3_MODEM_DEEP_SLEEP_CNT					0x0684
#define REG_PMU_APB_RF_PSCP_DEEP_SLEEP_CNT						0x0688
#define REG_PMU_APB_RF_AUDCP_SYS_DEEP_SLEEP_CNT					0x068c
#define REG_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_CNT					0x0690
#define REG_PMU_APB_RF_AP_LIGHT_SLEEP_CNT						0x0694
#define REG_PMU_APB_RF_V3_MODEM_LIGHT_SLEEP_CNT					0x0698
#define REG_PMU_APB_RF_PSCP_LIGHT_SLEEP_CNT					0x069c
#define REG_PMU_APB_RF_AUDCP_SYS_LIGHT_SLEEP_CNT					0x06a0
#define REG_PMU_APB_RF_AON_SYS_LIGHT_SLEEP_CNT					0x06a4
#define REG_PMU_APB_RF_SYS_SOFT_RST_BUSY						0x06a8
#define REG_PMU_APB_RF_REG_SYS_SRST_FRC_LP_ACK					0x06ac
#define REG_PMU_APB_RF_SOFT_RST_SEL						0x06b0
#define REG_PMU_APB_RF_REG_SYS_DDR_PWR_HS_ACK					0x06b4
#define REG_PMU_APB_RF_CSI_DSI_PWR_CNT_DONE					0x06b8
#define REG_PMU_APB_RF_PD_AP_SYS_DBG_SHUTDOWN__EN					0x06bc
#define REG_PMU_APB_RF_EIC_SYS_SEL							0x06c0
#define REG_PMU_APB_RF_DDR_SLP_CTRL_STATE						0x06c4
#define REG_PMU_APB_RF_PD_APCPU_C4_SHUTDOWN_MARK_STATUS				0x06c8
#define REG_PMU_APB_RF_PD_APCPU_C5_SHUTDOWN_MARK_STATUS				0x06cc
#define REG_PMU_APB_RF_PD_APCPU_C6_SHUTDOWN_MARK_STATUS				0x06d0
#define REG_PMU_APB_RF_PD_APCPU_C7_SHUTDOWN_MARK_STATUS				0x06d4
#define REG_PMU_APB_RF_APCPU_TOP_DEEP_SLEEP_CNT					0x06d8
#define REG_PMU_APB_RF_APCPU_TOP_LIGHT_SLEEP_CNT					0x06dc
#define REG_PMU_APB_RF_PD_ESE_SYS_SHUTDOWN_MARK_STATUS				0x06e0
#define REG_PMU_APB_RF_NRCP_DEEP_SLEEP_CNT						0x06e4
#define REG_PMU_APB_RF_NRCP_SYS_SLEEP_CNT						0x06e8
#define REG_PMU_APB_RF_PD_IPA_SHUTDOWN_MARK_STATUS					0x06ec
#define REG_PMU_APB_RF_NRCP_LIGHT_SLEEP_CNT					0x0720
#define REG_PMU_APB_RF_IPA_DEEP_SLEEP_CNT						0x0724
#define REG_PMU_APB_RF_IPA_SYS_SLEEP_CNT						0x0728
#define REG_PMU_APB_RF_IPA_LIGHT_SLEEP_CNT						0x072c
#define REG_PUB_AHB_RF_DMC_EXT_LPCTRL_CFG						0x3000
#define REG_PUB_AHB_RF_DMC_EXT_LPCTRL_SEQL						0x3004
#define REG_PUB_AHB_RF_DMC_EXT_LPCTRL_SEQH						0x3008
#define REG_PUB_AHB_RF_DMC_EXT_LPCTRL_STEP						0x300c
#define REG_PUB_AHB_RF_MPU_DUMP_ADDR						0x3010
#define REG_PUB_AHB_RF_DMC_MPU_VIO_ADDR						0x3014
#define REG_PUB_AHB_RF_DMC_MPU_VIO_CMD						0x3018
#define REG_PUB_AHB_RF_DMC_MPU_BASE_CFG						0x301c
#define REG_PUB_AHB_RF_RF_MPU_CFG0							0x3020
#define REG_PUB_AHB_RF_RF_MPU_CFG0_ID_MASK_VAL					0x3024
#define REG_PUB_AHB_RF_RF_MPU_CFG0_LOW_RANGE					0x3028
#define REG_PUB_AHB_RF_RF_MPU_CFG0_HIGH_RANGE					0x302c
#define REG_PUB_AHB_RF_RF_MPU_CFG1							0x3030
#define REG_PUB_AHB_RF_RF_MPU_CFG1_ID_MASK_VAL					0x3034
#define REG_PUB_AHB_RF_RF_MPU_CFG1_LOW_RANGE					0x3038
#define REG_PUB_AHB_RF_RF_MPU_CFG1_HIGH_RANGE					0x303c
#define REG_PUB_AHB_RF_RF_MPU_CFG2							0x3040
#define REG_PUB_AHB_RF_RF_MPU_CFG2_ID_MASK_VAL					0x3044
#define REG_PUB_AHB_RF_RF_MPU_CFG2_LOW_RANGE					0x3048
#define REG_PUB_AHB_RF_RF_MPU_CFG2_HIGH_RANGE					0x304c
#define REG_PUB_AHB_RF_RF_MPU_CFG3							0x3050
#define REG_PUB_AHB_RF_RF_MPU_CFG3_ID_MASK_VAL					0x3054
#define REG_PUB_AHB_RF_RF_MPU_CFG3_LOW_RANGE					0x3058
#define REG_PUB_AHB_RF_RF_MPU_CFG3_HIGH_RANGE					0x305c
#define REG_PUB_AHB_RF_RF_MPU_CFG4							0x3060
#define REG_PUB_AHB_RF_RF_MPU_CFG4_ID_MASK_VAL					0x3064
#define REG_PUB_AHB_RF_RF_MPU_CFG4_LOW_RANGE					0x3068
#define REG_PUB_AHB_RF_RF_MPU_CFG4_HIGH_RANGE					0x306c
#define REG_PUB_AHB_RF_RF_MPU_CFG5							0x3070
#define REG_PUB_AHB_RF_RF_MPU_CFG5_ID_MASK_VAL					0x3074
#define REG_PUB_AHB_RF_RF_MPU_CFG5_LOW_RANGE					0x3078
#define REG_PUB_AHB_RF_RF_MPU_CFG5_HIGH_RANGE					0x307c
#define REG_PUB_AHB_RF_RF_MPU_CFG6							0x3080
#define REG_PUB_AHB_RF_RF_MPU_CFG6_ID_MASK_VAL					0x3084
#define REG_PUB_AHB_RF_RF_MPU_CFG6_LOW_RANGE					0x3088
#define REG_PUB_AHB_RF_RF_MPU_CFG6_HIGH_RANGE					0x308c
#define REG_PUB_AHB_RF_RF_MPU_CFG7							0x3090
#define REG_PUB_AHB_RF_RF_MPU_CFG7_ID_MASK_VAL					0x3094
#define REG_PUB_AHB_RF_RF_MPU_CFG7_LOW_RANGE					0x3098
#define REG_PUB_AHB_RF_RF_MPU_CFG7_HIGH_RANGE					0x309c
#define REG_PUB_AHB_RF_RF_MPU_CFG8							0x30a0
#define REG_PUB_AHB_RF_RF_MPU_CFG8_ID_MASK_VAL					0x30a4
#define REG_PUB_AHB_RF_RF_MPU_CFG8_LOW_RANGE					0x30a8
#define REG_PUB_AHB_RF_RF_MPU_CFG8_HIGH_RANGE					0x30ac
#define REG_PUB_AHB_RF_RF_MPU_CFG9							0x30b0
#define REG_PUB_AHB_RF_RF_MPU_CFG9_ID_MASK_VAL					0x30b4
#define REG_PUB_AHB_RF_RF_MPU_CFG9_LOW_RANGE					0x30b8
#define REG_PUB_AHB_RF_RF_MPU_CFG9_HIGH_RANGE					0x30bc
#define REG_PUB_AHB_RF_RF_MPU_CFG10						0x30c0
#define REG_PUB_AHB_RF_RF_MPU_CFG10_ID_MASK_VAL					0x30c4
#define REG_PUB_AHB_RF_RF_MPU_CFG10_LOW_RANGE					0x30c8
#define REG_PUB_AHB_RF_RF_MPU_CFG10_HIGH_RANGE					0x30cc
#define REG_PUB_AHB_RF_RF_MPU_CFG11						0x30d0
#define REG_PUB_AHB_RF_RF_MPU_CFG11_ID_MASK_VAL					0x30d4
#define REG_PUB_AHB_RF_RF_MPU_CFG11_LOW_RANGE					0x30d8
#define REG_PUB_AHB_RF_RF_MPU_CFG11_HIGH_RANGE					0x30dc
#define REG_PUB_AHB_RF_RF_MPU_CFG12						0x30e0
#define REG_PUB_AHB_RF_RF_MPU_CFG12_ID_MASK_VAL					0x30e4
#define REG_PUB_AHB_RF_RF_MPU_CFG12_LOW_RANGE					0x30e8
#define REG_PUB_AHB_RF_RF_MPU_CFG12_HIGH_RANGE					0x30ec
#define REG_PUB_AHB_RF_RF_MPU_CFG13						0x30f0
#define REG_PUB_AHB_RF_RF_MPU_CFG13_ID_MASK_VAL					0x30f4
#define REG_PUB_AHB_RF_RF_MPU_CFG13_LOW_RANGE					0x30f8
#define REG_PUB_AHB_RF_RF_MPU_CFG13_HIGH_RANGE					0x30fc
#define REG_PUB_AHB_RF_RF_MPU_CFG14						0x3100
#define REG_PUB_AHB_RF_RF_MPU_CFG14_ID_MASK_VAL					0x3104
#define REG_PUB_AHB_RF_RF_MPU_CFG14_LOW_RANGE					0x3108
#define REG_PUB_AHB_RF_RF_MPU_CFG14_HIGH_RANGE					0x310c
#define REG_PUB_AHB_RF_RF_MPU_CFG15						0x3110
#define REG_PUB_AHB_RF_RF_MPU_CFG15_ID_MASK_VAL					0x3114
#define REG_PUB_AHB_RF_RF_MPU_CFG15_LOW_RANGE					0x3118
#define REG_PUB_AHB_RF_RF_MPU_CFG15_HIGH_RANGE					0x311c
#define REG_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM1_CTL					0x0000
#define REG_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM1_RESERVED_CTL				0x0004
#define REG_ANLG_PHY_G9_RF_ANALOG_THM1_0_REG_SEL_CFG_0				0x0008
#define REG_AP_IPA_AHB_RF_AHB_EB							0x0000
#define REG_AP_IPA_AHB_RF_AHB_RST							0x0004
#define REG_AP_IPA_AHB_RF_AP_SYS_FORCE_SLEEP_CFG					0x0008
#define REG_AP_IPA_AHB_RF_USB1_CTRL						0x000c
#define REG_AP_IPA_AHB_RF_USB1_DBG0						0x0014
#define REG_AP_IPA_AHB_RF_USB1_DBG1						0x0018
#define REG_AP_IPA_AHB_RF_USB1_DBG2						0x001c
#define REG_AP_IPA_AHB_RF_PCIE_CTL0						0x002c
#define REG_AP_IPA_AHB_RF_PCIE_CTL1						0x0030
#define REG_AP_IPA_AHB_RF_PCIE_CTL2						0x0034
#define REG_AP_IPA_AHB_RF_PCIE_CTL3						0x0038
#define REG_AP_IPA_AHB_RF_APB_PCLK_AUTO_GATE_EB					0x003c
#define REG_AP_IPA_AHB_RF_APB_PCLK_AUTO_SLOW_SEL					0x0040
#define REG_AP_IPA_AHB_RF_AP_SYS_AUTO_SLEEP_CFG					0x004c
#define REG_AP_IPA_AHB_RF_IMTX_M0_LPC						0x0100
#define REG_AP_IPA_AHB_RF_IMTX_M1_LPC						0x0104
#define REG_AP_IPA_AHB_RF_IMTX_M2_LPC						0x0108
#define REG_AP_IPA_AHB_RF_IMTX_M3_LPC						0x010c
#define REG_AP_IPA_AHB_RF_IMTX_M4_LPC						0x0110
#define REG_AP_IPA_AHB_RF_IMTX_M5_LPC						0x0114
#define REG_AP_IPA_AHB_RF_IMTX_M6_LPC						0x0118
#define REG_AP_IPA_AHB_RF_IMTX_M7_LPC						0x011c
#define REG_AP_IPA_AHB_RF_IMTX_M8_LPC						0x0120
#define REG_AP_IPA_AHB_RF_IMTX_M9_LPC						0x0124
#define REG_AP_IPA_AHB_RF_IMTX_MAIN_LPC						0x013c
#define REG_AP_IPA_AHB_RF_IMTX_S0_LPC						0x0140
#define REG_AP_IPA_AHB_RF_IMTX_S1_LPC						0x0144
#define REG_AP_IPA_AHB_RF_IMTX_S2_LPC						0x0148
#define REG_AP_IPA_AHB_RF_IMTX_S3_LPC						0x014c
#define REG_AP_IPA_AHB_RF_IMTX_S4_LPC						0x0150
#define REG_AP_IPA_AHB_RF_IMTX_S5_LPC						0x0154
#define REG_AP_IPA_AHB_RF_IMTX_S6_LPC						0x0158
#define REG_AP_IPA_AHB_RF_IMTX_S7_LPC						0x015c
#define REG_AP_IPA_AHB_RF_IMTX_S8_LPC						0x0160
#define REG_AP_IPA_AHB_RF_IMTX_S9_LPC						0x0164
#define REG_AP_IPA_AHB_RF_IMTX_MST_FRC_LSLP					0x0180
#define REG_AP_IPA_AHB_RF_IMTX_LSLP_LPC_BYPASS					0x0184
#define REG_AP_IPA_AHB_RF_IMTX_MST_FRC_PUB_DSLP					0x0188
#define REG_AP_IPA_AHB_RF_IMTX_PUB_DSLP_LPC_BYPASS					0x018c
#define REG_AP_IPA_AHB_RF_IMTX_MST_FRC_DOZE					0x0190
#define REG_AP_IPA_AHB_RF_IMTX_DOZE_LPC_BYPASS					0x0194
#define REG_AP_IPA_AHB_RF_IMTX_AXI_FREQ_ALLOW0					0x0198
#define REG_AP_IPA_AHB_RF_IMTX_AXI_FREQ_ALLOW1					0x019c
#define REG_AP_IPA_AHB_RF_IMTX_AXI_FREQ_LSLP_ALLOW0				0x01a0
#define REG_AP_IPA_AHB_RF_IMTX_AXI_FREQ_LSLP_ALLOW1				0x01a4
#define REG_AP_IPA_AHB_RF_AP_QOS0							0x0300
#define REG_AP_IPA_AHB_RF_AP_QOS1							0x0304
#define REG_AP_IPA_AHB_RF_AP_URGENCY						0x0308
#define REG_AP_IPA_AHB_RF_AP_USER0							0x030c
#define REG_AP_IPA_AHB_RF_AP_USER1							0x0310
#define REG_AP_IPA_AHB_RF_AP_USER2							0x0314
#define REG_AP_IPA_AHB_RF_IMTX_CTRL						0x0318
#define REG_AP_IPA_AHB_RF_IPA_CTRL							0x031c
#define REG_AP_IPA_AHB_RF_PAM_WIFI_CTRL						0x0320
#define REG_AP_IPA_AHB_RF_IMTX_M10_CTRL						0x0324
#define REG_AP_IPA_AHB_RF_PCIE_LP_CTRL						0x0328
#define REG_AP_IPA_AHB_RF_IMTX_PU_NUM0						0x032c
#define REG_AP_IPA_AHB_RF_IMTX_PU_NUM1						0x0330
#define REG_AP_IPA_AHB_RF_IMTX_PU_NUM2						0x0334
#define REG_AP_IPA_AHB_RF_IMTX_PU_NUM3						0x0338
#define REG_AP_IPA_AHB_RF_IMTX_PU_NUM4						0x033c
#define REG_AP_IPA_AHB_RF_IMTX_PU_NUM5						0x0340
#define REG_AP_IPA_AHB_RF_PAM_WIFI_PCLK_DFS_CTRL					0x0344
#define REG_AP_IPA_AHB_RF_PCIE_CTRL						0x0348
#define REG_AP_IPA_AHB_RF_SYS_ACCESS_EN						0x034c
#define REG_AP_IPA_AHB_RF_CGM_GATE_EN						0x0350
#define REG_AP_IPA_AHB_RF_IP_BUSY_GATE_EN						0x0354
#define REG_AP_IPA_AHB_RF_SDSLV_CTRL						0x0358
#define REG_AP_IPA_AHB_RF_PCIE_SW_MSI_INT						0x035c
#define REG_AP_IPA_AHB_RF_RESERVE0							0x0400
#define REG_AP_IPA_AHB_RF_RESERVE1							0x0404
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TXCLKLANE		0x0000
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TXDATA_0		0x0004
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TXDATA_1		0x0008
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TXDATA_2		0x000c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TXDATA_3		0x0010
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TXDATAESC		0x0014
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_STATE_RX		0x0018
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_ERR			0x001c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_CTRL			0x0020
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_RSVD			0x0024
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_TEST			0x0028
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_4L_DATALANE_CTRL		0x002c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_DUMY_CTRL			0x0030
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_MIPI_CTRL7			0x0034
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_REG_SEL_CFG_0			0x0038
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_REG_SEL_CFG_1			0x003c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TXCLKLANE		0x0040
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TXDATA_0		0x0044
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TXDATA_1		0x0048
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TXDATA_2		0x004c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TXDATA_3		0x0050
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TXDATAESC		0x0054
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_STATE_RX		0x0058
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_ERR			0x005c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_CTRL			0x0060
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_RSVD			0x0064
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_TEST			0x0068
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_4L_DATALANE_CTRL		0x006c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_DUMY_CTRL			0x0070
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_MIPI_CTRL7			0x0074
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_REG_SEL_CFG_0			0x0078
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_REG_SEL_CFG_1			0x007c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TXCLKLANE		0x0080
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TXDATA_0		0x0084
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TXDATA_1		0x0088
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TXDATA_2		0x008c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TXDATA_3		0x0090
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TXDATAESC		0x0094
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_STATE_RX		0x0098
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_ERR			0x009c
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_CTRL			0x00a0
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_RSVD			0x00a4
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_TEST			0x00a8
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_4L_DATALANE_CTRL		0x00ac
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_DUMY_CTRL			0x00b0
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_MIPI_CTRL7			0x00b4
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_REG_SEL_CFG_0			0x00b8
#define REG_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_REG_SEL_CFG_1			0x00bc
#define REG_ANALOG_PCIE20_CFGA_RF_DIG_CFG13					0x00b4
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG0						0x0000
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG1						0x0004
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG2						0x0008
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG3						0x000c
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG4						0x0010
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG5						0x0014
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG6						0x0018
#define REG_ANALOG_USB30_CFGA_RF_DIG_CFG7						0x001c
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG0						0x0040
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG1						0x0044
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG2						0x0048
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG3						0x004c
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG4						0x0050
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG5						0x0054
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG6						0x0058
#define REG_ANALOG_USB30_CFGA_RF_TST_CFG7						0x005c
#define REG_ANALOG_USB30_CFGA_RF_DIG_STS0						0x0060
#define REG_ANALOG_USB30_CFGA_RF_DIG_STS1						0x0064
#define REG_ANALOG_USB30_CFGA_RF_DIG_STS2						0x0068
#define REG_ANALOG_USB30_CFGA_RF_DIG_STS3						0x006c
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG0						0x0080
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG1						0x0084
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG2						0x0088
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG3						0x008c
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG4						0x0090
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG5						0x0094
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG6						0x0098
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG7						0x009c
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG8						0x00a0
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG9						0x00a4
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG10						0x00a8
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG11						0x00ac
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG12						0x00b0
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG13						0x00b4
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG14						0x00b8
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG15						0x00bc
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG16						0x00c0
#define REG_ANALOG_USB30_CFGA_RF_ANA_CFG17						0x00c4

#endif
