/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Unisoc Orca platform regs
 *
 * Copyright (C) 2022, Unisoc Inc.
 */
#ifndef __DT_BINDINGS_SPRD_GLB_MASK_H
#define __DT_BINDINGS_SPRD_GLB_MASK_H

#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_RSTN				0x8000000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_RUN				0x4000000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_PD				0x2000000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_VALID				0x1000000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_BG_RBIAS_MODE			0x800000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_TEST_SEL				0x600000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_BP_MODE				0x100000
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_DATA				0xffc00
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_BP_DATA				0x3ff
#define MASK_ANLG_PHY_G8_RF_ANALOG_THM1_1_THM_RESERVED				0xffff
#define MASK_ANLG_PHY_G8_RF_DBG_SEL_ANALOG_THM1_1_THM_RSTN				0x8
#define MASK_ANLG_PHY_G8_RF_DBG_SEL_ANALOG_THM1_1_THM_RUN				0x4
#define MASK_ANLG_PHY_G8_RF_DBG_SEL_ANALOG_THM1_1_THM_PD				0x2
#define MASK_ANLG_PHY_G8_RF_DBG_SEL_ANALOG_THM1_1_THM_RESERVED			0x1
#define MASK_SCC_APB_RF_VOLT_TUNE_VAL_MAX						0xff00
#define MASK_SCC_APB_RF_VOLT_TUNE_VAL_MIN						0xff
#define MASK_SCC_APB_RF_VOLT_TUNE_VAL						0xff00
#define MASK_SCC_APB_RF_VOLT_OBS_VAL						0xff
#define MASK_SCC_APB_RF_VOLT0_SELECT_OVERRIDE					0x80000000
#define MASK_SCC_APB_RF_VOLT1_SELECT_OVERRIDE					0x40000000
#define MASK_SCC_APB_RF_PAUSE_OCCUR_ERR_EN						0x100
#define MASK_SCC_APB_RF_VOLT_TUNE_FORBID_EN					0x10
#define MASK_SCC_APB_RF_VOLT_OBS_FORBID_EN						0x1
#define MASK_SCC_APB_RF_VOLT_TUNE_DOWN_STEP					0x1ff0000
#define MASK_SCC_APB_RF_VOLT_TUNE_UP_STEP						0x1ff
#define MASK_SCC_APB_RF_RND_INTVAL_WAIT_NUM					0xffff0000
#define MASK_SCC_APB_RF_VOLT_STB_WAIT_NUM						0xffff
#define MASK_SCC_APB_RF_SCC_TUNE_DONE_INT_MASK_STATUS				0x2000
#define MASK_SCC_APB_RF_SCC_TUNE_ERR_INT_MASK_STATUS				0x1000
#define MASK_SCC_APB_RF_SCC_TUNE_DONE_INT_RAW_STATUS				0x200
#define MASK_SCC_APB_RF_SCC_TUNE_ERR_INT_RAW_STATUS				0x100
#define MASK_SCC_APB_RF_SCC_TUNE_DONE_INT_CLR					0x20
#define MASK_SCC_APB_RF_SCC_TUNE_ERR_INT_CLR					0x10
#define MASK_SCC_APB_RF_SCC_TUNE_DONE_INT_EN					0x2
#define MASK_SCC_APB_RF_SCC_TUNE_ERR_INT_EN					0x1
#define MASK_SCC_APB_RF_SCC_TUNE_DWN_MARK						0xffff0000
#define MASK_SCC_APB_RF_SCC_TUNE_UP_MARK						0xffff
#define MASK_SCC_APB_RF_SCC_FSM_STS						0x1f
#define MASK_SCC_APB_RF_SCC_IDLE_MODE						0x80000000
#define MASK_SCC_APB_RF_SCC_TUNE_BYPASS						0x40000000
#define MASK_SCC_APB_RF_SCC_INIT_HALT_BYPASS					0x20000000
#define MASK_SCC_APB_RF_SCC_AM_CLK_DIVIDER						0x18000000
#define MASK_SCC_APB_RF_SCC_AM_ENABLE						0x4000000
#define MASK_SCC_APB_RF_SCC_AM_OBS_EN						0x2000000
#define MASK_SCC_APB_RF_SCC_RPT_READ_CTRL						0x1000
#define MASK_SCC_APB_RF_SCC_ALL_ROSC_CHAIN						0x4
#define MASK_SCC_APB_RF_SCC_ALL_ROSC_SEQ						0x2
#define MASK_SCC_APB_RF_SCC_ROSC_REPEAT_MODE					0x1
#define MASK_SCC_APB_RF_SCC_ROSC_DURATION						0xfffff000
#define MASK_SCC_APB_RF_SCC_ROSC_SEL_Z						0xf00
#define MASK_SCC_APB_RF_SCC_ROSC_SEL_Y						0xf0
#define MASK_SCC_APB_RF_SCC_ROSC_SEL_X						0xf
#define MASK_SCC_APB_RF_SCC_RPT_READ_NXT						0x80000000
#define MASK_SCC_APB_RF_SCC_ROSC_GR_ENABLE						0x2
#define MASK_SCC_APB_RF_SCC_ROSC_RUN						0x1
#define MASK_SCC_APB_RF_SCC_INIT_PAT_FAIL						0x80000000
#define MASK_SCC_APB_RF_SCC_ROSC_RPT_VALID						0x40000000
#define MASK_SCC_APB_RF_SCC_ROSC_SETTING						0x1f00000
#define MASK_SCC_APB_RF_SCC_ROSC_CNT						0xfffff
#define MASK_SCC_APB_RF_SCC_ROSC_SW_RST						0xff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_26MHZ_BUF_PD		0x800000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_26MHZ_CUR_SEL		0x600000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CLK26M_RESERVED		0x1e0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_BG_RBIAS_MODE		0x10000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TESTMUX			0xffff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_BIST_CTRL		0x3fc00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_BIST_EN		0x200000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CP_EN			0x100000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CLKOUT_EN		0x80000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_DIV_S			0x40000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_MODE		0x30000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_INI		0xf800
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_TRIG		0x400
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_WAITCNT		0x300
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_POLARITY		0x80
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_DONE		0x40
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_OUT		0x3e
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CALI_CPPD		0x1
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_MOD_EN		0x10000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_NINT			0xff00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_KINT			0xfffff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_N			0xffe000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_PD			0x1000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_POSTDIV		0x800
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_REFCK_SEL		0x600
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_RST			0x100
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_SDM_EN		0x80
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_CP_OFFSET		0x70
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_FBDIV_EN		0x8
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_ICP			0x7
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_LDO_TRIM		0x1e00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_BIST_CNT		0x1fffe0
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_LOCK_DONE		0x10
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_TEST_CLK_EN		0x8
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_TEST_CLK_OD		0x4
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_TEST_CLK_DIV		0x3
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_FREQ_DIFF_EN		0x8000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_DIVN			0x7c00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_PREDIV		0x200000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_R2_SEL		0x1c0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_R3_SEL		0x30000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_C2_SEL		0xe000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_KVCO_SEL		0x1c00
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_VCO_TEST_EN		0x200
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_VCO_TEST_INT		0x100
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_VCO_TEST_INTSEL	0xe0
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_SHORT_CSR_EN		0x10
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_ALLOP_PD		0x8
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_TEST_VCO_PN		0x4
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_VCOBUF_EN		0x2
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_DOUBLER_EN		0x1
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_CLK_GEN_DIV		0xfc0
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_EN			0x20
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_RSTN			0x10
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CLK_EN		0x8
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_IQ_SWAP		0x4
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_ANA_CLK_EDGE_SEL	0x2
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_DIG_CLK_EDGE_SEL	0x1
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CLK_FQ_SEL		0x60000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_EN		0x10000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_RSTN		0x8000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_CLK_FQ_SEL	0x6000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_AVG		0x1c00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_OVWR_EN		0x200000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_OVWR_D		0x1c0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_READ_EN		0x20000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CAL_DONE		0x10000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_OFFSETI		0xff00
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_OFFSETQ		0xff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_CUR_SEL		0x30000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_OFFSET_CAL_EN	0x8000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_PCAL		0x7c00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_NCAL		0x3e0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_VCMI_SEL	0x18000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_VCMO_SEL	0x6000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_GAIN		0x1e00
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_BW_SEL	0x1f8
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_MODE_SEL	0x4
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_BYPASS	0x2
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_I2VBUF_EN		0x1
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_RESERVED		0x7fe0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_LDO_1P2_EN		0x10000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_LDO_1P2_V		0xe000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_LDO_0P8_EN		0x1000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_TXDAC_LDO_0P8_V		0xe00
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_EN			0x100
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_EN			0x80
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_RSTN			0x40
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DIG_EN			0x20
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_CLK_OUT_EN		0x10
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_CLK_IN_SEL		0xc
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_CLK_DIG_EDGE_S		0x2
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_CLK_OUT_SEL		0x1
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_VREF_BST		0xe000000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_VREF_SEL		0x1c00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_CAP_SEL		0x300000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_BIT_SEL		0xc0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_MODE_WR		0x20000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_MODE_IN		0x10000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_OFFSET_CAL		0x8000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_SHORT_WR		0x4000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_SHORT_IN		0x2000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_GAIN_CAL		0x1000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_SKEW_CAL		0x800
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_SKEW_WR		0x400
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_SKEW_IN		0x3fc
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_CAL		0x2
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_WR			0x1
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_IN			0xfc00000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_OS			0x3f0000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_RD			0x8000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_REF		0x7000
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_CAL		0x800
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_WR			0x400
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_IN			0x3c0
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_OS			0x3c
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_TEST_MUX		0x3
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_CAL_DONE		0x100
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_VCMI_S			0xc0
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_BUF_VCMI_S		0x30
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_BUF_VCMO_S		0xc
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_BUF_CUR_S		0x3
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_RESERVED		0xffffffff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_RESERVED			0xffff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_APLL_RESERVED		0x1fffff
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_LDO_CAL_DONE	0x400
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_DLL_OUT		0x3f0
#define MASK_ANLG_PHY_G0_RF_ANALOG_WCN_ADDA_TOP_WCNADDA_SAR_LDO_OUT		0xf
#define MASK_ANLG_PHY_G0_RF_DBG_SEL_ANALOG_WCN_ADDA_TOP_WCNADDA_26MHZ_BUF_PD	0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_RESERVEDIN			0xffff0000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_RESERVEDOUT			0xffff
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_RESET_N			0x20000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_TRIM_TXRCTL			0x1f000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_TRIM_RXRCTL			0xf00
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_TRIM_BG			0xf0
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_PS_PD_S			0x8
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_PS_PD_L			0x4
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_ISO_SW_EN			0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_0_USB30_SW_SEL			0x1
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB3_TYPEC_0_USB30_RESET_N		0x2
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB3_TYPEC_0_USB30_SW_SEL		0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_RESERVEDIN			0xffff0000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_RESERVEDOUT			0xffff
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_RESET_N			0x20000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_TRIM_TXRCTL			0x1f000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_TRIM_RXRCTL			0xf00
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_TRIM_BG			0xf0
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_PS_PD_S			0x8
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_PS_PD_L			0x4
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_ISO_SW_EN			0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB3_TYPEC_1_USB30_SW_SEL			0x1
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB3_TYPEC_1_USB30_RESET_N		0x2
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB3_TYPEC_1_USB30_SW_SEL		0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TESTCLK				0x1000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TESTDATAIN			0xff0000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TESTADDR				0xf000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TESTDATAOUTSEL			0x800
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TESTDATAOUT			0x780
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BIST_MODE				0x7c
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_T2RCOMP				0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_LPBK_END				0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_DATABUS16_8			0x10000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_SUSPENDM				0x8000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PORN				0x4000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_RESET				0x2000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_RXERROR				0x1000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_DRV_DP			0x800000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_DRV_DM			0x400000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_FS				0x200000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_IN_DP			0x100000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_IN_DM			0x80000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_OUT_DP			0x40000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BYPASS_OUT_DM			0x20000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_VBUSVLDEXT			0x10000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_RESERVED				0xffff
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PS_PD_S				0x10
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PS_PD_L				0x8
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_REXTENABLE			0x4
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_DMPULLUP				0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_SAMPLER_SEL			0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_DPPULLDOWN			0x10
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_DMPULLDOWN			0x8
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TXBITSTUFFENABLE			0x4
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TXBITSTUFFENABLEH			0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_SLEEPM				0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNEHSAMP				0x60000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TFREGRES				0x1f800000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TFHSRES				0x7c0000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNERISE				0x30000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNEOTG				0xe000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNEDSC				0x1800
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNESQ				0x780
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNEEQ				0x70
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_TUNEPLLS				0xf
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PLL_PFD_DEADZONE			0x300
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PLL_PFD_DELAY			0xc0
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PLL_CP_IOFFSET_EN			0x20
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PLL_CP_IOFFSET			0x1e
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_PLL_REF_DOUBLER_EN		0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BISTRAM_EN			0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_BIST_MODE_EN			0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_0_USB20_ISO_SW_EN				0x1
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_SUSPENDM			0x100
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_PORN			0x80
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_RESET			0x40
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_BYPASS_FS			0x20
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_BYPASS_IN_DM		0x10
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_SAMPLER_SEL		0x8
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_DPPULLDOWN		0x4
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_DMPULLDOWN		0x2
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_0_USB20_SLEEPM			0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TESTCLK				0x1000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TESTDATAIN			0xff0000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TESTADDR				0xf000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TESTDATAOUTSEL			0x800
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TESTDATAOUT			0x780
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BIST_MODE				0x7c
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_T2RCOMP				0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_LPBK_END				0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_DATABUS16_8			0x10000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_SUSPENDM				0x8000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PORN				0x4000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_RESET				0x2000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_RXERROR				0x1000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_DRV_DP			0x800000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_DRV_DM			0x400000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_FS				0x200000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_IN_DP			0x100000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_IN_DM			0x80000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_OUT_DP			0x40000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BYPASS_OUT_DM			0x20000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_VBUSVLDEXT			0x10000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_RESERVED				0xffff
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PS_PD_S				0x10
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PS_PD_L				0x8
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_REXTENABLE			0x4
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_DMPULLUP				0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_SAMPLER_SEL			0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_DPPULLDOWN			0x10
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_DMPULLDOWN			0x8
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TXBITSTUFFENABLE			0x4
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TXBITSTUFFENABLEH			0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_SLEEPM				0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNEHSAMP				0x60000000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TFREGRES				0x1f800000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TFHSRES				0x7c0000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNERISE				0x30000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNEOTG				0xe000
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNEDSC				0x1800
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNESQ				0x780
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNEEQ				0x70
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_TUNEPLLS				0xf
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PLL_PFD_DEADZONE			0x300
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PLL_PFD_DELAY			0xc0
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PLL_CP_IOFFSET_EN			0x20
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PLL_CP_IOFFSET			0x1e
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_PLL_REF_DOUBLER_EN		0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BISTRAM_EN			0x2
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_BIST_MODE_EN			0x1
#define MASK_ANLG_PHY_G4_RF_ANALOG_USB20_1_USB20_ISO_SW_EN				0x1
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_SUSPENDM			0x100
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_PORN			0x80
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_RESET			0x40
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_BYPASS_FS			0x20
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_BYPASS_IN_DM		0x10
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_SAMPLER_SEL		0x8
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_DPPULLDOWN		0x4
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_DMPULLDOWN		0x2
#define MASK_ANLG_PHY_G4_RF_DBG_SEL_ANALOG_USB20_1_USB20_SLEEPM			0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_REC_26MHZ_0_CUR_SEL			0xc
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_SINE_DRV_1_SEL				0x2
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_SINE_DRV_0_SEL				0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_CLK26M_RESERVED				0x7ff000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_REC_26MHZ_SR_0_TRIM			0xf00
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_REC_26MHZ_SR_1_TRIM			0xf0
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_REC_26MHZ_SR_2_TRIM			0xf
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_BB_BG_RBIAS_MODE				0x2
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_BB_CON_BG				0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_BB_RESERVED				0xffff0000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_BB_TESTMUX				0xffff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL0_RESERVED0			0x3
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_26M_SEL				0x400000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2_RESERVED4			0x300000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2_RESERVED3			0x80000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2_RESERVED2			0x60000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2_RESERVED1			0x1c000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL2_RESERVED0			0x3ffe
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_SINEO_V3_RPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_CTRL4_RESERVED0			0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_V3_RPLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL0_RESERVED0			0x3
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_26M_SEL				0x200000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2_RESERVED4			0x180000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2_RESERVED3			0x40000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2_RESERVED2			0x20000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2_RESERVED1			0x1c000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL2_RESERVED0			0x3ffe
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_SINEO_NR_RPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL4_RESERVED1			0x2
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_CTRL4_RESERVED0			0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_NR_RPLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_N					0x7ff00
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL0_RESERVED0			0xc0
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_ICP				0x38
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_SDM_EN				0x4
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_MOD_EN				0x2
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_DIV_S				0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_NINT				0x3f800000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_KINT				0x7fffff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_FREQ_DOUBLE_EN			0x800000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL2_RESERVED3			0x400000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL2_RESERVED2			0x380000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_REFCK_SEL				0x40000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL2_RESERVED1			0x38000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_POSTDIV				0x4000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL2_RESERVED0			0x3fff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_VCO_TEST_EN			0x100
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_SSC_CTRL				0xff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_LPF				0xe000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_LDO_TRIM				0x1e00
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL4_RESERVED1			0x1c0
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_FBDIV_EN				0x20
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CTRL4_RESERVED0			0x10
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CP_OFFSET				0xe
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_CP_EN				0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_BIST_CTRL				0x1fe0000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_TYPE_SEL				0x20000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_TEST_CLKOUT_EN			0x10000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DLPLL_RESERVED				0xffff
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_RPLL_TEST_CLK_EN				0x2
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_RPLL_TEST_SEL				0x1
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_AAPC_MAX_RANGE				0x7ffe0000
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_AAPC_MIN_RANGE				0x1fff8
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_AAPC_RSTN				0x4
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_AAPC_GEN_SEL				0x3
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_AAPC_STEP_SEL				0xf
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_LVDSRFPLL_V3_REF_SEL			0xc
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_LVDSRFPLL_NR_REF_SEL			0x3
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_DBG_SEL_CLK26M_RESERVED			0x10
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_TEST_CLK_EN				0x8
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_TEST_CLK_OD				0x4
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_TEST_CLK_DIV				0x3
#define MASK_ANLG_PHY_G5_RF_ANALOG_BB_TOP_ANALOG_DUMMY_REG				0xffffffff
#define MASK_PUB_APB_REG_DDL_MASK_CTRL						0x7
#define MASK_PUB_APB_REG_DDR_CHN6_AXI_LP_EN					0x4000
#define MASK_PUB_APB_REG_DDR_CHN5_AXI_LP_EN					0x2000
#define MASK_PUB_APB_REG_DDR_CHN4_AXI_LP_EN					0x1000
#define MASK_PUB_APB_REG_DDR_CHN3_AXI_LP_EN					0x800
#define MASK_PUB_APB_REG_DDR_CHN2_AXI_LP_EN					0x400
#define MASK_PUB_APB_REG_DDR_CHN1_AXI_LP_EN					0x200
#define MASK_PUB_APB_REG_DDR_CHN0_AXI_LP_EN					0x100
#define MASK_PUB_APB_REG_DDR_CH6_AXI_STOP_SEL					0x40
#define MASK_PUB_APB_REG_DDR_CH5_AXI_STOP_SEL					0x20
#define MASK_PUB_APB_REG_DDR_CH4_AXI_STOP_SEL					0x10
#define MASK_PUB_APB_REG_DDR_CH3_AXI_STOP_SEL					0x8
#define MASK_PUB_APB_REG_DDR_CH2_AXI_STOP_SEL					0x4
#define MASK_PUB_APB_REG_DDR_CH1_AXI_STOP_SEL					0x2
#define MASK_PUB_APB_REG_DDR_CH0_AXI_STOP_SEL					0x1
#define MASK_PUB_APB_REG_SOFT_CMD_NUM						0x700
#define MASK_PUB_APB_REG_SOFT_CMD_FC_SEL						0x30
#define MASK_PUB_APB_REG_SOFT_CMD_RESP						0x8
#define MASK_PUB_APB_REG_SOFT_CMD_DONE						0x4
#define MASK_PUB_APB_REG_SOFT_CMD_START						0x1
#define MASK_PUB_APB_REG_SOFT_CMD_SEQL						0xffffffff
#define MASK_PUB_APB_REG_SOFT_CMD_SEQH						0xffffffff
#define MASK_PUB_APB_REG_SOFT_CMD_STEP						0xffffffff
#define MASK_PUB_APB_REG_DPLL_PRE_DIV_MONITOR_GATE_AUTO_EN_STATUS			0xc
#define MASK_PUB_APB_REG_DPLL_PRE_DIV_MONITOR_WAIT_EN_STATUS			0x3
#define MASK_PUB_APB_REG_DFI_MON_IDLE_CNT						0xff00
#define MASK_PUB_APB_REG_DFI_MON_TIMER_DELAY					0xff
#define MASK_PUB_APB_REG_URGENT_CHN_SEL						0x2
#define MASK_PUB_APB_REG_QOS_URGENT_SEL						0x1
#define MASK_PUB_APB_REG_PUB_CLK_PTM_26M_EB					0x1000
#define MASK_PUB_APB_REG_LP_STAT_MTX_CG_EN						0x800
#define MASK_PUB_APB_REG_CHN_DMC_STOP_CG_EN					0x400
#define MASK_PUB_APB_REG_TRANS_MON_ENABLE						0x200
#define MASK_PUB_APB_REG_PUB_CLK_CSSYS_PTM_EB					0x100
#define MASK_PUB_APB_REG_PUB_APB_PTM_REG_EB					0x80
#define MASK_PUB_APB_REG_PUB_CLK_DMC_PTM_EB					0x40
#define MASK_PUB_APB_REG_PUB_APB_INT_EB						0x20
#define MASK_PUB_APB_REG_PUB_APB_BIST_REG_EB					0x10
#define MASK_PUB_APB_REG_PUB_AHB_QOSC_REG_EB					0x8
#define MASK_PUB_APB_REG_PUB_AHB_REG_EB						0x4
#define MASK_PUB_APB_REG_PUB_AHB_BUS_EB						0x2
#define MASK_PUB_APB_REG_PUB_PHY_REG_EB						0x1
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_MERGE_MTX_M0				0x20000000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_MERGE_MTX_M0				0x10000000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_MERGE_MTX_M1				0x8000000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_MERGE_MTX_M1				0x4000000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_MERGE_MTX_M2				0x2000000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_MERGE_MTX_M2				0x1000000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_MERGE_MTX_M3				0x800000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_MERGE_MTX_M3				0x400000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_MERGE_MTX_S0				0x200000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_MERGE_MTX_S0				0x100000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_NRCPU_DDR				0x80000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_NRCPU_DDR				0x40000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_NRACC_DDR				0x20000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_NRACC_DDR				0x10000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PSCP_DDR					0x8000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PSCP_DDR					0x4000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_AGCP_DDR					0x2000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_AGCP_DDR					0x1000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_CFG_S4				0x800
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_CFG_S4				0x400
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_CFG_S3				0x200
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_CFG_S3				0x100
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_CFG_S2				0x80
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_CFG_S2				0x40
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_CFG_S1				0x20
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_CFG_S1				0x10
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_CFG_S0				0x8
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_CFG_S0				0x4
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_PUB_CFG_M0				0x2
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_PUB_CFG_M0				0x1
#define MASK_PUB_APB_REG_INT_DFS_VOTE_DONE_CG_EN					0x400
#define MASK_PUB_APB_REG_MEM_FW_PUB_CACTIVE_CG_EN					0x200
#define MASK_PUB_APB_REG_INT_DMC_MPU_VIO_CG_EN					0x100
#define MASK_PUB_APB_REG_INT_MEM_FW_CG_EN						0x80
#define MASK_PUB_APB_REG_INT_DFS_GIVEUP_CG_EN					0x40
#define MASK_PUB_APB_REG_INT_DFS_DENY_CG_EN					0x20
#define MASK_PUB_APB_REG_INT_DFS_ERROR_CG_EN					0x10
#define MASK_PUB_APB_REG_INT_HARDWARE_DFS_EXIT_CG_EN				0x8
#define MASK_PUB_APB_REG_INT_DFS_COMPLETE_CG_EN					0x4
#define MASK_PUB_APB_REG_INT_DFI_BUS_MONITOR_CG_EN					0x2
#define MASK_PUB_APB_REG_INT_REQ_PUB_PTM_CG_EN					0x1
#define MASK_PUB_APB_REG_PTM_TIMER_EN						0x8
#define MASK_PUB_APB_REG_LATMON_TIMER_EN						0x4
#define MASK_PUB_APB_REG_BWMON_TIMER_EN						0x2
#define MASK_PUB_APB_REG_DBM_TIMER_EN						0x1
#define MASK_PUB_APB_REG_BWVOTE_SUB_BWMON_EN					0x40000000
#define MASK_PUB_APB_REG_BV_FV_EQUAL_INC_EN					0x20000000
#define MASK_PUB_APB_REG_DBM_PERCENT_SEL						0x1c000000
#define MASK_PUB_APB_REG_DFS_VOTE_DMC_REF_AG_EN					0x2000000
#define MASK_PUB_APB_REG_DFS_APB_ACCESS_CLK_AUTO_EN				0x1000000
#define MASK_PUB_APB_REG_RF_VOTE_CK_OPEN_CNT					0x1fe000
#define MASK_PUB_APB_REG_TIMING_WINDOW_SEL						0x1c00
#define MASK_PUB_APB_REG_VOTE_UNIT_TRANS_EN					0x200
#define MASK_PUB_APB_REG_SW_FORCE_VOTE_MASK_EN					0x100
#define MASK_PUB_APB_REG_SW_FORCE_VOTE_MASK					0xff
#define MASK_PUB_APB_REG_VOTE_TAR_FRQ						0xe00
#define MASK_PUB_APB_REG_VOTE_NEXT_STATE						0x1e0
#define MASK_PUB_APB_REG_VOTE_CUR_STATE						0x1e
#define MASK_PUB_APB_REG_VOTE_BW_OVERFLOW						0x1
#define MASK_PUB_APB_REG_DFS_LOCK_DELAY_EN						0x80000000
#define MASK_PUB_APB_REG_REG_DFS_LOCK_DELAY_CNT					0x78000000
#define MASK_PUB_APB_REG_DFI_MASK_WAIT_LSLP_EN					0x1000000
#define MASK_PUB_APB_REG_DFI_MASK_WAIT_TIME_LSLP					0xff0000
#define MASK_PUB_APB_REG_DFI_MASK_WAIT_EN						0x100
#define MASK_PUB_APB_REG_DFI_MASK_WAIT_TIME					0xff
#define MASK_PUB_APB_REG_DMC_FIXED_QOS_EN						0x7f
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH3					0xf0000000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH3					0xf000000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH2					0xf00000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH2					0xf0000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH1					0xf000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH1					0xf00
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH0					0xf0
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH0					0xf
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH6					0xf00000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH6					0xf0000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH5					0xf000
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH5					0xf00
#define MASK_PUB_APB_REG_RF_DMC_FIXED_ARQOS_CH4					0xf0
#define MASK_PUB_APB_REG_RF_DMC_FIXED_AWQOS_CH4					0xf
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH3					0xf0000000
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH3					0xf000000
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH2					0xf00000
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH2					0xf0000
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH1					0xf000
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH1					0xf00
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH0					0xf0
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH0					0xf
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH7					0xf0000000
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH7					0xf000000
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH6					0xf00000
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH6					0xf0000
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH5					0xf000
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH5					0xf00
#define MASK_PUB_APB_REG_RF_ARQOS_URGENT_CH4					0xf0
#define MASK_PUB_APB_REG_RF_AWQOS_URGENT_CH4					0xf
#define MASK_PUB_APB_REG_DFS_VOTE_DONE_INT_CLR					0x8000
#define MASK_PUB_APB_REG_DFS_VOTE_DONE_INT_EN					0x4000
#define MASK_PUB_APB_REG_DFS_GIVEUP_INT_CLR					0x2000
#define MASK_PUB_APB_REG_DFS_GIVEUP_INT_EN						0x1000
#define MASK_PUB_APB_REG_DFS_DENY_INT_CLR						0x800
#define MASK_PUB_APB_REG_DFS_DENY_INT_EN						0x400
#define MASK_PUB_APB_REG_DMC_MPU_VIO_INT_CLR					0x200
#define MASK_PUB_APB_REG_DMC_MPU_VIO_INT_EN					0x100
#define MASK_PUB_APB_REG_MEM_FW_INT_CLR						0x80
#define MASK_PUB_APB_REG_MEM_FW_INT_EN						0x40
#define MASK_PUB_APB_REG_DFS_ERROR_INT_CLR						0x20
#define MASK_PUB_APB_REG_DFS_ERROR_INT_EN						0x10
#define MASK_PUB_APB_REG_DFS_COMPLETE_INT_CLR					0x8
#define MASK_PUB_APB_REG_DFS_COMPLETE_INT_EN					0x4
#define MASK_PUB_APB_REG_HW_DFS_EXIT_INT_CLR					0x2
#define MASK_PUB_APB_REG_HW_DFS_EXIT_INT_EN					0x1
#define MASK_PUB_APB_REG_DFS_HW_MIN_FREQ_UP_FORCE_TRIG_ACK				0x40000000
#define MASK_PUB_APB_REG_DFS_USED_PLL						0x38000000
#define MASK_PUB_APB_REG_DFS_FC_SEL						0x7000000
#define MASK_PUB_APB_REG_SRC_AVAIL_PLL						0xe00000
#define MASK_PUB_APB_REG_DFS_URGENT_WAIT_TIMEOUT_FLAG				0x100000
#define MASK_PUB_APB_REG_RF_DFS_GIVEUP_INT_RAW					0x80000
#define MASK_PUB_APB_REG_RF_INT_DFS_GIVEUP						0x40000
#define MASK_PUB_APB_REG_RF_DFS_DENY_INT_RAW					0x20000
#define MASK_PUB_APB_REG_RF_INT_DFS_DENY						0x10000
#define MASK_PUB_APB_REG_HW_DFS_FSM_STATE						0xf800
#define MASK_PUB_APB_REG_HW_DFS_FSM_IDLE						0x400
#define MASK_PUB_APB_REG_RF_INT_DMC_MPU_VIO_RAW					0x200
#define MASK_PUB_APB_REG_RF_INT_DMC_MPU_VIO					0x100
#define MASK_PUB_APB_REG_RF_INT_MEM_FW_RAW						0x80
#define MASK_PUB_APB_REG_RF_INT_MEM_FW						0x40
#define MASK_PUB_APB_REG_RF_DFS_ERROR_INT_RAW					0x20
#define MASK_PUB_APB_REG_RF_INT_DFS_ERROR						0x10
#define MASK_PUB_APB_REG_RF_DFS_COMPLETE_INT_RAW					0x8
#define MASK_PUB_APB_REG_RF_INT_DFS_COMPLETE					0x4
#define MASK_PUB_APB_REG_RF_HW_DFS_EXIT_INT_RAW					0x2
#define MASK_PUB_APB_REG_RF_INT_HW_DFS_EXIT					0x1
#define MASK_PUB_APB_REG_DFS_SW_FSM_STATE						0x70
#define MASK_PUB_APB_REG_RF_DFS_VOTE_DONE_INT_RAW					0x2
#define MASK_PUB_APB_REG_RF_INT_DFS_VOTE_DONE					0x1
#define MASK_PUB_APB_REG_DFS_FC_REQ_DELAY						0x7
#define MASK_PUB_APB_REG_DFS_SW_MODE						0x40
#define MASK_PUB_APB_REG_HW_DFS_STOP_ENABLE					0x20
#define MASK_PUB_APB_REG_HW_DFS_RESTART_ENABLE					0x10
#define MASK_PUB_APB_REG_AUTO_STOP_NOC_ENABLE					0x8
#define MASK_PUB_APB_REG_AUTO_STOP_DFS_ENABLE					0x4
#define MASK_PUB_APB_REG_PUB_DFS_EN						0x2
#define MASK_PUB_APB_REG_PUB_LP_EN							0x1
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_WTL_AG_S0				0x8000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_WTL_AG_S0				0x4000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_WTL_AG_M1				0x2000
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_WTL_AG_M1				0x1000
#define MASK_PUB_APB_REG_CSYSACK_SYNC_SEL_WTL_AG_M0				0x800
#define MASK_PUB_APB_REG_CACTIVE_SYNC_SEL_WTL_AG_M0				0x400
#define MASK_PUB_APB_REG_LP_FORCE_ISP_VDSP_S0					0x20
#define MASK_PUB_APB_REG_LP_EB_ISP_VDSP_S0						0x10
#define MASK_PUB_APB_REG_LP_FORCE_ISP_VDSP_M1					0x8
#define MASK_PUB_APB_REG_LP_EB_ISP_VDSP_M1						0x4
#define MASK_PUB_APB_REG_LP_FORCE_ISP_VDSP_M0					0x2
#define MASK_PUB_APB_REG_LP_EB_ISP_VDSP_M0						0x1
#define MASK_PUB_APB_REG_LP_FORCE_PUB_CFG_S4					0x20000000
#define MASK_PUB_APB_REG_LP_EB_PUB_CFG_S4						0x10000000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_CFG_S3					0x8000000
#define MASK_PUB_APB_REG_LP_EB_PUB_CFG_S3						0x4000000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_CFG_S2					0x2000000
#define MASK_PUB_APB_REG_LP_EB_PUB_CFG_S2						0x1000000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_CFG_S1					0x800000
#define MASK_PUB_APB_REG_LP_EB_PUB_CFG_S1						0x400000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_CFG_S0					0x200000
#define MASK_PUB_APB_REG_LP_EB_PUB_CFG_S0						0x100000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_CFG_M0					0x80000
#define MASK_PUB_APB_REG_LP_EB_PUB_CFG_M0						0x40000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_MERGE_MTX_M0					0x20000
#define MASK_PUB_APB_REG_LP_EB_MERGE_MTX_M0					0x10000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_MERGE_MTX_M1					0x8000
#define MASK_PUB_APB_REG_LP_EB_MERGE_MTX_M1					0x4000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_MERGE_MTX_M2					0x2000
#define MASK_PUB_APB_REG_LP_EB_MERGE_MTX_M2					0x1000
#define MASK_PUB_APB_REG_LP_FORCE_PUB_MERGE_MTX_M3					0x800
#define MASK_PUB_APB_REG_LP_EB_MERGE_MTX_M3					0x400
#define MASK_PUB_APB_REG_LP_FORCE_PUB_MERGE_MTX_S0					0x200
#define MASK_PUB_APB_REG_LP_EB_MERGE_MTX_S0					0x100
#define MASK_PUB_APB_REG_LP_FORCE_NRCPU_DDR					0x80
#define MASK_PUB_APB_REG_LP_EB_NRCPU_DDR						0x40
#define MASK_PUB_APB_REG_LP_FORCE_NRACC_DDR					0x20
#define MASK_PUB_APB_REG_LP_EB_NRACC_DDR						0x10
#define MASK_PUB_APB_REG_LP_FORCE_PSCP_DDR						0x8
#define MASK_PUB_APB_REG_LP_EB_PSCP_DDR						0x4
#define MASK_PUB_APB_REG_LP_FORCE_AGCP_DDR						0x2
#define MASK_PUB_APB_REG_LP_EB_AGCP_DDR						0x1
#define MASK_PUB_APB_REG_LP_NUM_PUB_CFG						0xffff0000
#define MASK_PUB_APB_REG_LP_NUM_DDR						0xffff
#define MASK_PUB_APB_REG_PUB_CLK_DDR_EN_BY_FENCING_RELEASE				0x80000000
#define MASK_PUB_APB_REG_RF_DDR_FENCING_EN						0x40000000
#define MASK_PUB_APB_REG_RF_FENCING_CHNL_IDLE_CNT					0x3fffffff
#define MASK_PUB_APB_REG_RF_NRCPU_BASE_ADDR					0xf00000
#define MASK_PUB_APB_REG_RF_NRACC_BASE_ADDR					0xf0000
#define MASK_PUB_APB_REG_RF_V3CPU_BASE_ADDR					0xf000
#define MASK_PUB_APB_REG_RF_V3ACC_BASE_ADDR					0xf00
#define MASK_PUB_APB_REG_RF_PSCP_BASE_ADDR						0xf0
#define MASK_PUB_APB_REG_RF_AGCP_BASE_ADDR						0xf
#define MASK_PUB_APB_REG_LP_WAIT_CGM_BUSY_SEL					0x4
#define MASK_PUB_APB_REG_CGM_PUB_DFS_SEL						0x2
#define MASK_PUB_APB_REG_CGM_PUB_DFS_EN						0x1
#define MASK_PUB_APB_REG_LP_NUM_MERGE_MTX_M3					0xffff
#define MASK_PUB_APB_REG_LP_NUM_MERGE_MTX_M2					0xffff0000
#define MASK_PUB_APB_REG_LP_NUM_MERGE_MTX_M1					0xffff
#define MASK_PUB_APB_REG_BIST_FAIL_FLAG_CH3					0x800
#define MASK_PUB_APB_REG_BIST_FAIL_FLAG_CH2					0x400
#define MASK_PUB_APB_REG_BIST_FAIL_FLAG_CH1					0x200
#define MASK_PUB_APB_REG_BIST_FAIL_FLAG_CH0					0x100
#define MASK_PUB_APB_REG_BIST_PORT6_EN						0x40
#define MASK_PUB_APB_REG_BIST_PORT5_EN						0x20
#define MASK_PUB_APB_REG_BIST_PORT4_EN						0x10
#define MASK_PUB_APB_REG_BIST_PORT3_EN						0x8
#define MASK_PUB_APB_REG_BIST_PORT2_EN						0x4
#define MASK_PUB_APB_REG_BIST_PORT1_EN						0x2
#define MASK_PUB_APB_REG_BIST_PORT0_EN						0x1
#define MASK_PUB_APB_REG_DMC_SOFT_RST						0x4
#define MASK_PUB_APB_REG_DCC_SOFT_RST						0x2
#define MASK_PUB_APB_REG_DDRPHY_SOFT_RST						0x1
#define MASK_PUB_APB_REG_MC_IDLE_WAIT_CTRL						0xffffffff
#define MASK_PUB_APB_REG_AWQOS_THRESHOLD_WTL_AG					0xf0000000
#define MASK_PUB_APB_REG_ARQOS_THRESHOLD_WTL_AG					0xf000000
#define MASK_PUB_APB_REG_AWQOS_THRESHOLD_DPU_ISP					0xf00000
#define MASK_PUB_APB_REG_ARQOS_THRESHOLD_DPU_ISP					0xf0000
#define MASK_PUB_APB_REG_AWQOS_THRESHOLD_AP_AON					0xf000
#define MASK_PUB_APB_REG_ARQOS_THRESHOLD_AP_AON					0xf00
#define MASK_PUB_APB_REG_AON_AWQOS							0xf0
#define MASK_PUB_APB_REG_AON_ARQOS							0xf
#define MASK_PUB_APB_REG_AWQOS_THRESHOLD_ISP_VDSP					0xf0
#define MASK_PUB_APB_REG_ARQOS_THRESHOLD_ISP_VDSP					0xf
#define MASK_PUB_APB_REG_PUB_CLK_DFS_SLEEP_AUTO_GATE_EN				0x80000000
#define MASK_PUB_APB_REG_CLK_AON_APB_AUTO_GATE_EN					0x40000000
#define MASK_PUB_APB_REG_CLK_DMC_REF_AUTO_GATE_EN					0x20000000
#define MASK_PUB_APB_REG_PUB_CLK_DFS_AUTO_GATE_EN					0x10000000
#define MASK_PUB_APB_REG_DMC_DFI_MON_AUTO_GATE_EN					0x8000000
#define MASK_PUB_APB_REG_DMC_SREF_AUTO_GATE_EN					0x4000000
#define MASK_PUB_APB_REG_DDR_PHY_AUTO_GATE_EN					0x2000000
#define MASK_PUB_APB_REG_DDR_UMCTL_AUTO_GATE_EN					0x1000000
#define MASK_PUB_APB_REG_PUB_CLK_DMC_BIST_EB					0x800000
#define MASK_PUB_APB_REG_PUB_CLK_DMC_REF_EB					0x400000
#define MASK_PUB_APB_REG_PUB_CLK_CSSYS_EB						0x200000
#define MASK_PUB_APB_REG_PUB_CLK_AON_APB_EB					0x100000
#define MASK_PUB_APB_REG_PUB_CLK_PHY_X2_FORCE_PHASE				0xc0000
#define MASK_PUB_APB_REG_PUB_CLK_PHY_X2_FORCE_PHASE_SEL				0x20000
#define MASK_PUB_APB_REG_PUB_CLK_PHY_X2_FORCE_BYP					0x10000
#define MASK_PUB_APB_REG_PUB_CLK_DFS_EB						0x8000
#define MASK_PUB_APB_REG_PUB_CLK_DMC_X1_PTM_EB					0x4000
#define MASK_PUB_APB_REG_PUB_CLK_MLB_D2_EB						0x2000
#define MASK_PUB_APB_REG_PUB_CLK_DMC_D2_EB						0x1000
#define MASK_PUB_APB_REG_PUB_CLK_DMC_X1_EB						0x800
#define MASK_PUB_APB_REG_PUB_CLK_PHY_X2_EB						0x400
#define MASK_PUB_APB_REG_PUB_CLK_DCC_EB						0x200
#define MASK_PUB_APB_REG_PUB_DDR_CLK_EB						0x100
#define MASK_PUB_APB_REG_TIMER_CLK_AON_APB_OPEN_EN					0x80
#define MASK_PUB_APB_REG_PUB_CLK_DMC_X1_PTM_AUTO_GATE_EN				0x40
#define MASK_PUB_APB_REG_PUB_CLK_MLB_D2_CGM_SEL					0x20
#define MASK_PUB_APB_REG_PUB_CLK_DMC_D2_CGM_SEL					0x10
#define MASK_PUB_APB_REG_PUB_CLK_DMC_X1_CGM_SEL					0x8
#define MASK_PUB_APB_REG_PUB_CLK_PHY_X2_CGM_SEL					0x4
#define MASK_PUB_APB_REG_PUB_CLK_DCC_CGM_SEL					0x2
#define MASK_PUB_APB_REG_PUB_DDR_CLK_CGM_SEL					0x1
#define MASK_PUB_APB_REG_DMC_CLK_INIT_SW_START					0x1
#define MASK_PUB_APB_REG_DFS_LP_CTRL_CUR_STATE					0x7000
#define MASK_PUB_APB_REG_DMC_CLK_HW_CUR_STATE					0xf0
#define MASK_PUB_APB_REG_DMC_CUR_CLK_MODE						0xc
#define MASK_PUB_APB_REG_DMC_CLK_INIT_SW_DONE					0x1
#define MASK_PUB_APB_REG_PTM_LSLP_CLK_KEEP_ON_EN					0x2000000
#define MASK_PUB_APB_REG_DMC_DFI_MON_LSLP_AG_EN					0x1000000
#define MASK_PUB_APB_REG_DMC_STOP_WAIT_CNT						0xff0000
#define MASK_PUB_APB_REG_DMC_SLEEP_FORCE_FINISH_MODE				0x100
#define MASK_PUB_APB_REG_DESKEW_PLL_PD_DEFAULT_SW					0x20
#define MASK_PUB_APB_REG_DESKEW_PLL_PD_DEFAULT_SEL					0x10
#define MASK_PUB_APB_REG_DMC_SLEEP_CLK_AUTO_MODE					0x2
#define MASK_PUB_APB_REG_DFS_CLK_AUTO_MODE						0x1
#define MASK_PUB_APB_REG_DSKDLL_DCC_FINE_WAIT_SRC_SW				0x400
#define MASK_PUB_APB_REG_DSKDLL_DCC_COARSE_WAIT_SRC_SW				0x200
#define MASK_PUB_APB_REG_DSKPLL_LOCK_WAIT_SRC_SW					0x100
#define MASK_PUB_APB_REG_DDL_ADJS_V_WAIT_EN					0x8
#define MASK_PUB_APB_REG_DSKDLL_DCC_FINE_WAIT_EN					0x4
#define MASK_PUB_APB_REG_DSKDLL_DCC_COARSE_WAIT_EN					0x2
#define MASK_PUB_APB_REG_DSKPLL_LOCK_WAIT_EN					0x1
#define MASK_PUB_APB_REG_WAIT_CNT_DSKPLL_PWRON_TIME				0xffff0000
#define MASK_PUB_APB_REG_WAIT_CNT_DSKPLL_LOCK_TIME					0xffff
#define MASK_PUB_APB_REG_WAIT_CNT_DSKDLL_DCC_FINE_TIME				0xffff0000
#define MASK_PUB_APB_REG_WAIT_CNT_DSKDLL_DCC_COARSE_TIME				0xffff
#define MASK_PUB_APB_REG_WAIT_CNT_DFS_RESET_OFF_TIME				0xff000000
#define MASK_PUB_APB_REG_WAIT_CNT_DFS_RESET_ON_TIME				0xff0000
#define MASK_PUB_APB_REG_WAIT_CNT_DFS_CLK_OFF_TIME					0xff
#define MASK_PUB_APB_REG_WAIT_CNT_DDL_ADJS_V_HIGH_TIME				0xff0000
#define MASK_PUB_APB_REG_WAIT_CNT_DDL_ADJS_V_LOW_TIME				0xff
#define MASK_PUB_APB_REG_PTEST_DDL_SCOUT						0x4000000
#define MASK_PUB_APB_REG_PTEST_DDL_SCIN						0x2000000
#define MASK_PUB_APB_REG_PTEST_DDL_SE						0x1000000
#define MASK_PUB_APB_REG_DMC_DDL_SW_ADJS						0x1ff00
#define MASK_PUB_APB_REG_DMC_DDL_SW_UPDATE						0x80
#define MASK_PUB_APB_REG_DMC_DDL_SW_BYPASS						0x40
#define MASK_PUB_APB_REG_DMC_DDL_SW_RESET						0x20
#define MASK_PUB_APB_REG_DMC_DDL_SW_ADJS_VALID					0x10
#define MASK_PUB_APB_REG_DMC_DDL_CFG_SRC_PURE_SW					0x2
#define MASK_PUB_APB_REG_DMC_DDL_CFG_SRC_SW					0x1
#define MASK_PUB_APB_REG_PUB_DFS_SW_LOCK_REQ					0x8000000
#define MASK_PUB_APB_REG_PUB_DFS_SW_LOCK_MODE					0x4000000
#define MASK_PUB_APB_REG_EMC_CKG_MODE_PURE_SW					0x3000000
#define MASK_PUB_APB_REG_EMC_CKG_D2_SEL_PURE_SW					0xf00000
#define MASK_PUB_APB_REG_PURE_SW_DFS_CLK_MODE					0xc0000
#define MASK_PUB_APB_REG_PURE_SW_DFS_DENY						0x10000
#define MASK_PUB_APB_REG_PURE_SW_DFS_ACK						0x8000
#define MASK_PUB_APB_REG_PURE_SW_DFS_RESP						0x4000
#define MASK_PUB_APB_REG_PURE_SW_DFS_FC_REQ					0x2000
#define MASK_PUB_APB_REG_PURE_SW_DFS_REQ						0x1000
#define MASK_PUB_APB_REG_PURE_SW_DFS_FC_ACK					0x800
#define MASK_PUB_APB_REG_PURE_SW_DFS_FRQ_SEL					0x700
#define MASK_PUB_APB_REG_EMC_CKG_SEL_PURE_SW					0xfe
#define MASK_PUB_APB_REG_DFS_SW_DFS_MODE						0x1
#define MASK_PUB_APB_REG_PUB_DFS_SWITCH_TYPE					0x80000000
#define MASK_PUB_APB_REG_PUB_DFS_SW_SWITCH_PERIOD					0x3fc00000
#define MASK_PUB_APB_REG_PUB_DFS_SW_RATIO_DEFAULT					0x3f8000
#define MASK_PUB_APB_REG_PUB_DFS_SW_RATIO						0x7f00
#define MASK_PUB_APB_REG_PUB_DFS_SW_DENY						0x80
#define MASK_PUB_APB_REG_PUB_DFS_SW_FRQ_SEL					0x70
#define MASK_PUB_APB_REG_PUB_DFS_SW_RESP						0x8
#define MASK_PUB_APB_REG_PUB_DFS_SW_ACK						0x4
#define MASK_PUB_APB_REG_PUB_DFS_SW_REQ						0x2
#define MASK_PUB_APB_REG_PUB_DFS_SW_ENABLE						0x1
#define MASK_PUB_APB_REG_PUB_DFS_SW_UG_DENY_EN					0x400000
#define MASK_PUB_APB_REG_PUB_DFS_SW_LP_DENY_EN					0x200000
#define MASK_PUB_APB_REG_PUB_DFS_SW_UG_CHK_EN					0x100000
#define MASK_PUB_APB_REG_PUB_DFS_SW_CLK_MODE_DEFAULT				0xc0000
#define MASK_PUB_APB_REG_PUB_DFS_SW_CLK_MODE					0x30000
#define MASK_PUB_APB_REG_PUB_DFS_SW_RATIO_D2_DEFAULT				0xf00
#define MASK_PUB_APB_REG_PUB_DFS_SW_RATIO_D2					0xf
#define MASK_PUB_APB_REG_PUB_DFS_SW_DDL_ADJS_DEFAULT				0x1ff0000
#define MASK_PUB_APB_REG_PUB_DFS_SW_DDL_ADJS					0x1ff
#define MASK_PUB_APB_REG_PUB_DFS_URGENT_WAIT_TIMEOUT_PERIOD			0xffc0000
#define MASK_PUB_APB_REG_PUB_DFS_URGENT_WAIT_TIMEOUT_EN				0x20000
#define MASK_PUB_APB_REG_PUB_DFS_SW_URGENT_WAIT_EN					0x10000
#define MASK_PUB_APB_REG_PUB_DFS_SW_URGENT_DENY_EN					0xffff
#define MASK_PUB_APB_REG_PUB_DFS_HW_DDL_ADJS_DEFAULT				0x7fc00000
#define MASK_PUB_APB_REG_PUB_DFS_HW_CLK_MODE_DEFAULT				0x300000
#define MASK_PUB_APB_REG_PUB_DFS_HW_RATIO_D2_DEFAULT				0xf0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_RATIO_DEFAULT					0x7f00
#define MASK_PUB_APB_REG_PUB_DFS_HW_INITIAL_FREQ					0x70
#define MASK_PUB_APB_REG_PUB_DFS_HW_STOP						0x4
#define MASK_PUB_APB_REG_PUB_DFS_HW_START						0x2
#define MASK_PUB_APB_REG_PUB_DFS_HW_ENABLE						0x1
#define MASK_PUB_APB_REG_SW_FORCE_EXIT_SW_LP_WAIT_ACK				0x80000000
#define MASK_PUB_APB_REG_SW_FORCE_EXIT_HW_LP_WAIT_ACK				0x40000000
#define MASK_PUB_APB_REG_SW_FORCE_EXIT_LP_WAIT_REQ					0x20000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_MIN_FREQ_UP_FORCE_TRIG				0x10000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_BWMON_MIN_EN					0x8000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_BWMON_MIN_FREQ					0x7000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_AVAIL_FREQ_EN					0xff0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_CHECK_PLL_EN					0x1000
#define MASK_PUB_APB_REG_PUB_DFS_HW_MIN_FREQ_UP					0x700
#define MASK_PUB_APB_REG_PUB_DFS_HW_MIN_FREQ_DN					0x70
#define MASK_PUB_APB_REG_PUB_DFS_HW_MIN_EN_UP					0x8
#define MASK_PUB_APB_REG_PUB_DFS_HW_MIN_EN_DN					0x4
#define MASK_PUB_APB_REG_PUB_DFS_HW_MIN_LOAD					0x2
#define MASK_PUB_APB_REG_PUB_DFS_LP_PROT_EN					0x1
#define MASK_PUB_APB_REG_DFS_INC_REQ_HOLD_EN					0x80000000
#define MASK_PUB_APB_REG_DFS_DEC_TO_INC_EN						0x40000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_DEC_UG_DENY_EN					0x20000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_INC_UG_DENY_EN					0x10000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_DEC_LP_DENY_EN					0x8000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_INC_LP_DENY_EN					0x4000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_DEC_UG_CHK_EN					0x2000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_INC_UG_CHK_EN					0x1000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_URGENT_WAIT_EN					0x10000
#define MASK_PUB_APB_REG_PUB_DFS_HW_URGENT_DENY_EN					0xffff
#define MASK_PUB_APB_REG_PUB_DFS_HW_F3_RATIO					0x7f000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F2_RATIO					0x7f0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F1_RATIO					0x7f00
#define MASK_PUB_APB_REG_PUB_DFS_HW_F0_RATIO					0x7f
#define MASK_PUB_APB_REG_PUB_DFS_HW_F7_RATIO					0x7f000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F6_RATIO					0x7f0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F5_RATIO					0x7f00
#define MASK_PUB_APB_REG_PUB_DFS_HW_F4_RATIO					0x7f
#define MASK_PUB_APB_REG_PUB_DFS_HW_F7_RATIO_D2					0xf0000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F6_RATIO_D2					0xf000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F5_RATIO_D2					0xf00000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F4_RATIO_D2					0xf0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F3_RATIO_D2					0xf000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F2_RATIO_D2					0xf00
#define MASK_PUB_APB_REG_PUB_DFS_HW_F1_RATIO_D2					0xf0
#define MASK_PUB_APB_REG_PUB_DFS_HW_F0_RATIO_D2					0xf
#define MASK_PUB_APB_REG_PUB_DFS_HW_F7_CLK_MODE					0xc000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F6_CLK_MODE					0x3000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F5_CLK_MODE					0xc00
#define MASK_PUB_APB_REG_PUB_DFS_HW_F4_CLK_MODE					0x300
#define MASK_PUB_APB_REG_PUB_DFS_HW_F3_CLK_MODE					0xc0
#define MASK_PUB_APB_REG_PUB_DFS_HW_F2_CLK_MODE					0x30
#define MASK_PUB_APB_REG_PUB_DFS_HW_F1_CLK_MODE					0xc
#define MASK_PUB_APB_REG_PUB_DFS_HW_F0_CLK_MODE					0x3
#define MASK_PUB_APB_REG_PUB_DFS_HW_F1_DDL_ADJS					0x1ff0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F0_DDL_ADJS					0x1ff
#define MASK_PUB_APB_REG_PUB_DFS_HW_F3_DDL_ADJS					0x1ff0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F2_DDL_ADJS					0x1ff
#define MASK_PUB_APB_REG_PUB_DFS_HW_F5_DDL_ADJS					0x1ff0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F4_DDL_ADJS					0x1ff
#define MASK_PUB_APB_REG_PUB_DFS_HW_F7_DDL_ADJS					0x1ff0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F6_DDL_ADJS					0x1ff
#define MASK_PUB_APB_REG_PUB_DFS_HW_F7_REQ_DURATION				0xf0000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F6_REQ_DURATION				0xf000000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F5_REQ_DURATION				0xf00000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F4_REQ_DURATION				0xf0000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F3_REQ_DURATION				0xf000
#define MASK_PUB_APB_REG_PUB_DFS_HW_F2_REQ_DURATION				0xf00
#define MASK_PUB_APB_REG_PUB_DFS_HW_F1_REQ_DURATION				0xf0
#define MASK_PUB_APB_REG_PUB_DFS_HW_F0_REQ_DURATION				0xf
#define MASK_PUB_APB_REG_HW_DESKEW_PLL_PD_DEEP_SLEEP_MODE				0xff000000
#define MASK_PUB_APB_REG_HW_DESKEW_PLL_PD_AUTO_LIGHT_SLEEP_MODE			0xff0000
#define MASK_PUB_APB_REG_HW_DESKEW_PLL_PD_SMART_LIGHT_SLEEP_MODE			0xff00
#define MASK_PUB_APB_REG_HW_DESKEW_PLL_PD_DEFAULT_BYP_MODE				0xff
#define MASK_PUB_APB_REG_DFS_FC_ACK_ASSERT_WAIT_CNT				0xff00
#define MASK_PUB_APB_REG_DFS_HW_FRQ_SEL_SW						0x70
#define MASK_PUB_APB_REG_DFS_HW_FRQ_SEL_SET					0x8
#define MASK_PUB_APB_REG_DFS_CUR_CLK_MODE_TOGGLE					0x4
#define MASK_PUB_APB_REG_HW_DESKEW_PLL_PD_DEFAULT_HIGH				0x2
#define MASK_PUB_APB_REG_HW_DESKEW_PLL_PO_AHEAD_EN					0x1
#define MASK_PUB_APB_REG_VDDCORE_VOL_F7						0x70000000
#define MASK_PUB_APB_REG_VDDCORE_VOL_F6						0x7000000
#define MASK_PUB_APB_REG_VDDCORE_VOL_F5						0x700000
#define MASK_PUB_APB_REG_VDDCORE_VOL_F4						0x70000
#define MASK_PUB_APB_REG_VDDCORE_VOL_F3						0x7000
#define MASK_PUB_APB_REG_VDDCORE_VOL_F2						0x700
#define MASK_PUB_APB_REG_VDDCORE_VOL_F1						0x70
#define MASK_PUB_APB_REG_VDDCORE_VOL_F0						0x7
#define MASK_PUB_APB_REG_VDDCORE_VOL_CUR						0x1c000000
#define MASK_PUB_APB_REG_VDDCORE_VOL_DFLT						0x3800000
#define MASK_PUB_APB_REG_VDDCORE_VOL_SET						0x400000
#define MASK_PUB_APB_REG_VDDCORE_DVS_ACK						0x200000
#define MASK_PUB_APB_REG_VDDCORE_DVS_REQ_SW					0x100000
#define MASK_PUB_APB_REG_VDDCORE_DVS_VOL_SW					0xe0000
#define MASK_PUB_APB_REG_VDDCORE_DVS_SW_EN						0x10000
#define MASK_PUB_APB_REG_VDDCORE_DVS_DEC_EN					0xff00
#define MASK_PUB_APB_REG_VDDCORE_DVS_INC_EN					0xff
#define MASK_PUB_APB_REG_HW_DFS_AUTO_DIS						0x80000
#define MASK_PUB_APB_REG_HW_DFS_TARGET_FSP						0x70000
#define MASK_PUB_APB_REG_VDDCORE_DVS_DN_SW_EN					0xff00
#define MASK_PUB_APB_REG_VDDCORE_DVS_UP_SW_EN					0xff
#define MASK_PUB_APB_REG_DFS_VOTE_DEC_EN						0x80000000
#define MASK_PUB_APB_REG_VOTE_HW_DFS_DEC_MASK_EN					0x40000000
#define MASK_PUB_APB_REG_VOTE_HW_DFS_INC_MASK_EN					0x20000000
#define MASK_PUB_APB_REG_RF_DFS_INTERVAL_CNT					0x3fff8000
#define MASK_PUB_APB_REG_RF_VOTE_INTERVAL_CNT					0x7fff
#define MASK_PUB_APB_REG_RF_THRD_INC_F0						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F1						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F2						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F3						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F4						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F5						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F6						0xffffffff
#define MASK_PUB_APB_REG_RF_THRD_INC_F7						0xffffffff
#define MASK_PUB_APB_REG_TEST_DSKPLL_BIST_CNT					0xffff
#define MASK_PUB_APB_REG_DFS_COUNT_EN						0x200
#define MASK_PUB_APB_REG_PUB_DFS_STA_EN						0x100
#define MASK_PUB_APB_REG_DMC_ST_MON_SEL						0x6
#define MASK_PUB_APB_REG_PUB_TOP_MON_EN						0x1
#define MASK_PUB_APB_REG_DMC_ST_IDLE_CYCLE_CNT					0xffffffff
#define MASK_PUB_APB_REG_DMC_ST_WRITE_CYCLE_CNT					0xffffffff
#define MASK_PUB_APB_REG_DMC_ST_READ_CYCLE_CNT					0xffffffff
#define MASK_PUB_APB_REG_DMC_ST_SREF_CYCLE_CNT					0xffffffff
#define MASK_PUB_APB_REG_DMC_ST_LIGHT_CYCLE_CNT					0xffffffff
#define MASK_PUB_APB_REG_DMC_ST_SREF_CNT						0xffff0000
#define MASK_PUB_APB_REG_DMC_ST_LIGHT_CNT						0xffff
#define MASK_PUB_APB_REG_DFS_F0_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F1_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F2_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F3_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F4_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F5_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F6_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_F7_CYCLE_CNT						0xffffffff
#define MASK_PUB_APB_REG_DFS_COUNT							0x3ff
#define MASK_PUB_APB_REG_RF_APCPU_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_APCPU_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_APCPU_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_APCPU_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_APCPU						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_APCPU_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_MINIAP_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_MINIAP_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_MINIAP_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_MINIAP_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_MINIAP						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_MINIAP_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_NRCPU_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_NRCPU_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_NRCPU_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_NRCPU_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_NRCPU						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_NRCPU_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_NRACC_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_NRACC_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_NRACC_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_NRACC_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_NRACC						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_NRACC_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_V3CPU_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_V3CPU_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_V3CPU_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_V3CPU_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_V3CPU						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_V3CPU_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_AGCP_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_AGCP_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_AGCP_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_AGCP_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_AGCP						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_AGCP_FLAG						0x4000
#define MASK_PUB_APB_REG_RF_SW_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_SW_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_SW_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_SW_FLAG						0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_SW						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_SW_FLAG						0x4000
#define MASK_PUB_APB_REG_RF_V3ACC_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_V3ACC_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_V3ACC_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_V3ACC_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_V3ACC						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_V3ACC_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_PSCP_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_PSCP_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_PSCP_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_PSCP_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_PSCP						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_PSCP_FLAG						0x4000
#define MASK_PUB_APB_REG_RF_WCPU_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_WCPU_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_WCPU_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_WCPU_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_WCPU						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_WCPU_FLAG						0x4000
#define MASK_PUB_APB_REG_RF_TDCPU_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_TDCPU_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_TDCPU_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_TDCPU_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_TDCPU						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_TDCPU_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_GSMCPU_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_GSMCPU_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_GSMCPU_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_GSMCPU_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_GSMCPU						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_GSMCPU_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_WACC_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_WACC_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_WACC_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_WACC_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_WACC						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_WACC_FLAG						0x4000
#define MASK_PUB_APB_REG_RF_TDACC_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_TDACC_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_TDACC_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_TDACC_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_TDACC						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_TDACC_FLAG					0x4000
#define MASK_PUB_APB_REG_RF_GSMACC_BV_EN						0x80000000
#define MASK_PUB_APB_REG_RF_GSMACC_FV_EN						0x40000000
#define MASK_PUB_APB_REG_VOTE_GSMACC_ACK						0x800000
#define MASK_PUB_APB_REG_FREQ_VOTE_GSMACC_FLAG					0x80000
#define MASK_PUB_APB_REG_FREQ_VOTE_GSMACC						0x70000
#define MASK_PUB_APB_REG_BW_VOTE_GSMACC_FLAG					0x4000
#define MASK_PUB_APB_REG_DFS_GFREE_HW_BYPASS_EN					0x1000000
#define MASK_PUB_APB_REG_DFS_GFREE_SW_OPEN_DELAY					0x7fc00
#define MASK_PUB_APB_REG_DFS_GFREE_SW_CLOSE_DELAY					0x3fe
#define MASK_PUB_APB_REG_DFS_GFREE_SW_BYPASS					0x1
#define MASK_PUB_APB_REG_PUB_DFS_SW_SWITCH_PERIOD_APPEND				0xf
#define MASK_PUB_APB_REG_AWURGENT_DBG_AGCP						0xc0000
#define MASK_PUB_APB_REG_AWURGENT_DBG_PSCP						0x30000
#define MASK_PUB_APB_REG_AWURGENT_DBG_V3ACC					0xc000
#define MASK_PUB_APB_REG_AWURGENT_DBG_V3CPU					0x3000
#define MASK_PUB_APB_REG_AWURGENT_DBG_NRACC					0xc00
#define MASK_PUB_APB_REG_AWURGENT_DBG_NRCPU					0x300
#define MASK_PUB_APB_REG_AWURGENT_DBG_AONSYS					0xc0
#define MASK_PUB_APB_REG_AWURGENT_DBG_CSSYS					0x30
#define MASK_PUB_APB_REG_AWURGENT_DBG_MINIAP					0xc
#define MASK_PUB_APB_REG_AWURGENT_DBG_APCPU					0x3
#define MASK_PUB_APB_REG_ARURGENT_DBG_AGCP						0xc0000
#define MASK_PUB_APB_REG_ARURGENT_DBG_PSCP						0x30000
#define MASK_PUB_APB_REG_ARURGENT_DBG_V3ACC					0xc000
#define MASK_PUB_APB_REG_ARURGENT_DBG_V3CPU					0x3000
#define MASK_PUB_APB_REG_ARURGENT_DBG_NRACC					0xc00
#define MASK_PUB_APB_REG_ARURGENT_DBG_NRCPU					0x300
#define MASK_PUB_APB_REG_ARURGENT_DBG_AONSYS					0xc0
#define MASK_PUB_APB_REG_ARURGENT_DBG_CSSYS					0x30
#define MASK_PUB_APB_REG_ARURGENT_DBG_MINIAP					0xc
#define MASK_PUB_APB_REG_ARURGENT_DBG_APCPU					0x3
#define MASK_PUB_APB_REG_SRE_FLAG_DBG						0x2
#define MASK_PUB_APB_REG_SRE_REQ_DBG						0x1
#define MASK_PUB_APB_REG_BW_VOTE_APCPU						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_MINIAP						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_AGCP						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_PSCP						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_NRACC						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_NRCPU						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_V3ACC						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_V3CPU						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_WACC						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_WCPU						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_TDACC						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_TDCPU						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_GSMACC						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_GSMCPU						0xffffffff
#define MASK_PUB_APB_REG_BW_VOTE_SW						0xffffffff
#define MASK_PUB_APB_REG_MATRIX_BUSMON_EN						0x1
#define MASK_PUB_APB_REG_AGCP_HIGH_URGENCY_EN					0x40
#define MASK_PUB_APB_REG_PSCP_HIGH_URGENCY_EN					0x20
#define MASK_PUB_APB_REG_V3ACC_HIGH_URGENCY_EN					0x10
#define MASK_PUB_APB_REG_V3CPU_HIGH_URGENCY_EN					0x8
#define MASK_PUB_APB_REG_NRACC_HIGH_URGENCY_EN					0x4
#define MASK_PUB_APB_REG_NRCPU_HIGH_URGENCY_EN					0x2
#define MASK_PUB_APB_REG_APCPU_MINIAP_CS_AON_HIGH_URGENCY_EN			0x1
#define MASK_PUB_APB_REG_CFG_MTX_M0_PU_NUM						0xff000000
#define MASK_PUB_APB_REG_CFG_MTX_S0_MCTRL_PU_NUM					0xff0000
#define MASK_PUB_APB_REG_CFG_MTX_S1_GLBAPB_PU_NUM					0xff00
#define MASK_PUB_APB_REG_CFG_MTX_S2_PTM_PU_NUM					0xff
#define MASK_PUB_APB_REG_CFG_MTX_S4_REGU_PU_NUM					0xff00
#define MASK_PUB_APB_REG_CFG_MTX_S3_DMC_BIST_PU_NUM				0xff
#define MASK_PUB_APB_REG_MERGE_MTX_M0_APCPU_PU_NUM					0xff000000
#define MASK_PUB_APB_REG_MERGE_MTX_M1_MINIAP_PU_NUM				0xff0000
#define MASK_PUB_APB_REG_MERGE_MTX_M2_CS_PU_NUM					0xff00
#define MASK_PUB_APB_REG_MERGE_MTX_M3_AON_PU_NUM					0xff
#define MASK_PUB_APB_REG_MERGE_MTX_S0_PU_NUM					0xff
#define MASK_PUB_APB_REG_DMC_BIST_MST1_CFG_AWUSER					0xff000000
#define MASK_PUB_APB_REG_DMC_BIST_MST1_CFG_ARUSER					0xff0000
#define MASK_PUB_APB_REG_DMC_BIST_MST0_CFG_AWUSER					0xff00
#define MASK_PUB_APB_REG_DMC_BIST_MST0_CFG_ARUSER					0xff
#define MASK_PUB_APB_REG_DMC_BIST_MST3_CFG_AWUSER					0xff000000
#define MASK_PUB_APB_REG_DMC_BIST_MST3_CFG_ARUSER					0xff0000
#define MASK_PUB_APB_REG_DMC_BIST_MST2_CFG_AWUSER					0xff00
#define MASK_PUB_APB_REG_DMC_BIST_MST2_CFG_ARUSER					0xff
#define MASK_PUB_APB_REG_PUB0_DUMMY_REG0						0xffffffff
#define MASK_PUB_APB_REG_PUB0_DUMMY_REG1						0xffffffff
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_RCO100M_RESERVED			0x3fc0
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_RCO100M_LDO_EN				0x20
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_RCO100M_LDO_BYPASS			0x10
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_RCO100M_LDO_VOLTAGE_SEL		0xc
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_RCO100M_LDO_BIAS_SEL			0x3
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_DBG_SEL_RTC100M_LDO_BYPASS		0x4
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_DBG_SEL_RTC100M_LDO_EN			0x2
#define MASK_ANLG_PHY_G10_RF_ANALOG_RCO100M_RCO100M_POWER_MODE_SEL			0x1
#define MASK_ANLG_PHY_G10_RF_ANALOG_EFUSE4K_EFS_TRCS				0x4
#define MASK_ANLG_PHY_G10_RF_ANALOG_EFUSE4K_EFS_AT1				0x2
#define MASK_ANLG_PHY_G10_RF_ANALOG_EFUSE4K_EFS_AT0				0x1
#define MASK_AUD_CP_AHB_RF_DVFS_ASHB_EB						0x800000
#define MASK_AUD_CP_AHB_RF_TMR_26M_EB						0x400000
#define MASK_AUD_CP_AHB_RF_VBC_24M_EB						0x200000
#define MASK_AUD_CP_AHB_RF_AUDIF_CKG_AUTO_EN					0x100000
#define MASK_AUD_CP_AHB_RF_AUD_EB							0x80000
#define MASK_AUD_CP_AHB_RF_DMA_CP_ASHB_EB						0x40000
#define MASK_AUD_CP_AHB_RF_DMA_AP_ASHB_EB						0x20000
#define MASK_AUD_CP_AHB_RF_ICU_EB							0x10000
#define MASK_AUD_CP_AHB_RF_SPINLOCK_EB						0x8000
#define MASK_AUD_CP_AHB_RF_VBC_EB							0x4000
#define MASK_AUD_CP_AHB_RF_VBCIFD_EB						0x2000
#define MASK_AUD_CP_AHB_RF_MCDT_EB							0x1000
#define MASK_AUD_CP_AHB_RF_SRC48K_EB						0x400
#define MASK_AUD_CP_AHB_RF_DMA_AP_EB						0x40
#define MASK_AUD_CP_AHB_RF_DMA_CP_EB						0x20
#define MASK_AUD_CP_AHB_RF_UART_EB							0x10
#define MASK_AUD_CP_AHB_RF_IIS2_EB							0x4
#define MASK_AUD_CP_AHB_RF_IIS1_EB							0x2
#define MASK_AUD_CP_AHB_RF_IIS0_EB							0x1
#define MASK_AUD_CP_AHB_RF_DVFS_SOFT_RST						0x4000000
#define MASK_AUD_CP_AHB_RF_AUD_SOFT_RST						0x2000000
#define MASK_AUD_CP_AHB_RF_UART_SOFT_RST						0x10000
#define MASK_AUD_CP_AHB_RF_IIS2_SOFT_RST						0x4000
#define MASK_AUD_CP_AHB_RF_IIS1_SOFT_RST						0x2000
#define MASK_AUD_CP_AHB_RF_IIS0_SOFT_RST						0x1000
#define MASK_AUD_CP_AHB_RF_DMA_CP_SOFT_RST						0x800
#define MASK_AUD_CP_AHB_RF_SPINLOCK_SOFT_RST					0x400
#define MASK_AUD_CP_AHB_RF_VBC_SOFT_RST						0x200
#define MASK_AUD_CP_AHB_RF_VBCIFD_SOFT_RST						0x100
#define MASK_AUD_CP_AHB_RF_MCDT_SOFT_RST						0x80
#define MASK_AUD_CP_AHB_RF_SRC48K_SOFT_RST						0x20
#define MASK_AUD_CP_AHB_RF_DMA_AP_SOFT_RST						0x2
#define MASK_AUD_CP_AHB_RF_VBC_24M_SOFT_RST					0x1
#define MASK_AUD_CP_AHB_RF_DSP_CORE_CLK_EB						0x8
#define MASK_AUD_CP_AHB_RF_DSP_APB_CLK_EB						0x4
#define MASK_AUD_CP_AHB_RF_DSP_AHB_CLK_EB						0x2
#define MASK_AUD_CP_AHB_RF_DSP_AXI_CLK_EB						0x1
#define MASK_AUD_CP_AHB_RF_EARLY_WAKEUP_EN						0x1
#define MASK_AUD_CP_AHB_RF_SLAVE0_PUB0_FRC_LSLP					0x10000
#define MASK_AUD_CP_AHB_RF_MASTER4_PUB0_FRC_LSLP					0x4000
#define MASK_AUD_CP_AHB_RF_MASTER3_PUB0_FRC_LSLP					0x2000
#define MASK_AUD_CP_AHB_RF_MASTER2_PUB0_FRC_LSLP					0x1000
#define MASK_AUD_CP_AHB_RF_MASTER1_PUB0_FRC_LSLP					0x800
#define MASK_AUD_CP_AHB_RF_MASTER0_PUB0_FRC_LSLP					0x400
#define MASK_AUD_CP_AHB_RF_DMA_CHN2_GRP2_LSLP_EN					0x200
#define MASK_AUD_CP_AHB_RF_DMA_CHN2_GRP1_LSLP_EN					0x100
#define MASK_AUD_CP_AHB_RF_AUD_DSP_CORE_FRC_SLEEP					0x80
#define MASK_AUD_CP_AHB_RF_PMU_CPDMA_FRC_SLP					0x8
#define MASK_AUD_CP_AHB_RF_PMU_APDMA_FRC_SLP					0x4
#define MASK_AUD_CP_AHB_RF_AHB_ARCH_EB						0x1
#define MASK_AUD_CP_AHB_RF_DSP_CORE_SLEEP						0x1
#define MASK_AUD_CP_AHB_RF_DSP_SYS_SLEEP_EN					0x1
#define MASK_AUD_CP_AHB_RF_MCACHE_STRAP_POST_NUM					0xf0
#define MASK_AUD_CP_AHB_RF_MCACHE_STRAP_PRE_NUM					0xf
#define MASK_AUD_CP_AHB_RF_MCU_STATUS						0xfff
#define MASK_AUD_CP_AHB_RF_AUD_IIS2_EXT_SEL					0x4
#define MASK_AUD_CP_AHB_RF_AUD_IIS1_EXT_SEL					0x2
#define MASK_AUD_CP_AHB_RF_AUD_IIS0_EXT_SEL					0x1
#define MASK_AUD_CP_AHB_RF_HIGH_RESERVED						0xffff0000
#define MASK_AUD_CP_AHB_RF_LOW_RESERVED						0xffff
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S7					0x8000
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_ASYNC_BRIDGE				0x4000
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S6					0x2000
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S5					0x1000
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S4					0x800
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S3					0x400
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S2					0x200
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S1					0x100
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_S0					0x80
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_MAIN					0x40
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_M4					0x10
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_M3					0x8
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_M2					0x4
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_M1					0x2
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_EB_M0					0x1
#define MASK_AUD_CP_AHB_RF_PU_AUD_CP_MTX_NUM					0xff0000
#define MASK_AUD_CP_AHB_RF_LP_AUD_CP_MTX_NUM					0xffff
#define MASK_AUD_CP_AHB_RF_AWQOS_M0						0xf00000
#define MASK_AUD_CP_AHB_RF_AWQOS_M1						0xf0000
#define MASK_AUD_CP_AHB_RF_AWQOS_M2						0xf000
#define MASK_AUD_CP_AHB_RF_AWQOS_M4						0xf0
#define MASK_AUD_CP_AHB_RF_ARQOS_M0						0xf00000
#define MASK_AUD_CP_AHB_RF_ARQOS_M1						0xf0000
#define MASK_AUD_CP_AHB_RF_ARQOS_M2						0xf000
#define MASK_AUD_CP_AHB_RF_ARQOS_M4						0xf0
#define MASK_AUD_CP_AHB_RF_PERI_FRC_OFF						0x4
#define MASK_AUD_CP_AHB_RF_PERI_FRC_ON						0x2
#define MASK_AUD_CP_AHB_RF_SLAVE0_PUB0_FRC_DSLP					0x200
#define MASK_AUD_CP_AHB_RF_DMA_CHN2_GRP2_FRC_DSLP					0x100
#define MASK_AUD_CP_AHB_RF_DMA_CHN2_GRP1_FRC_DSLP					0x80
#define MASK_AUD_CP_AHB_RF_MASTER4_PUB0_FRC_DSLP					0x10
#define MASK_AUD_CP_AHB_RF_MASTER3_PUB0_FRC_DSLP					0x8
#define MASK_AUD_CP_AHB_RF_MASTER2_PUB0_FRC_DSLP					0x4
#define MASK_AUD_CP_AHB_RF_MASTER1_PUB0_FRC_DSLP					0x2
#define MASK_AUD_CP_AHB_RF_MASTER0_PUB0_FRC_DSLP					0x1
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_DEBUG_SIGNAL_W				0xffffffff
#define MASK_AUD_CP_AHB_RF_DMA_CP_PROT						0xf0
#define MASK_AUD_CP_AHB_RF_DMA_AP_PROT						0xf
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_AXI_DETECTOR_OVERFLOW			0x2
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_TRANS_IDLE					0x1
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AF_LVL_AW_CH				0x38000000
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AF_LVL_W_CH				0x7000000
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AF_LVL_B_CH				0xe00000
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AF_LVL_AR_CH				0x1c0000
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AF_LVL_R_CH				0x38000
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AE_LVL_AW_CH				0x7000
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AE_LVL_W_CH				0xe00
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AE_LVL_B_CH				0x1c0
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AE_LVL_AR_CH				0x38
#define MASK_AUD_CP_AHB_RF_AUD_BRIDGE_FIFO_AE_LVL_R_CH				0x7
#define MASK_AUD_CP_AHB_RF_ARCACHE_SRC_CFG						0xf00000
#define MASK_AUD_CP_AHB_RF_AWCACHE_SRC_CFG						0xf0000
#define MASK_AUD_CP_AHB_RF_ARCACHE_DMA_CP_CFG					0xf000
#define MASK_AUD_CP_AHB_RF_AWCACHE_DMA_CP_CFG					0xf00
#define MASK_AUD_CP_AHB_RF_ARCACHE_DMA_CFG						0xf0
#define MASK_AUD_CP_AHB_RF_AWCACHE_DMA_CFG						0xf
#define MASK_AUD_CP_AHB_RF_CEVA_PDMA_IACKN						0x2
#define MASK_AUD_CP_AHB_RF_CEVA_DDMA_IACK						0x1
#define MASK_AUD_CP_AHB_RF_TL42X_PSU_SYS_PSHTDWN_R					0x7fc000
#define MASK_AUD_CP_AHB_RF_TL42X_PSU_PSHTDWN_R					0x3ff8
#define MASK_AUD_CP_AHB_RF_TL42X_PSU_CORE_IDLE_R					0x4
#define MASK_AUD_CP_AHB_RF_TL42X_PSU_DSP_IDLE_R					0x2
#define MASK_AUD_CP_AHB_RF_TL42X_PSU_CORE_WAIT_R					0x1
#define MASK_AUD_CP_AHB_RF_FORCE_DMA_CP_BUSY					0x2
#define MASK_AUD_CP_AHB_RF_FORCE_DMA_AP_BUSY					0x1
#define MASK_AUD_CP_AHB_RF_WAKEUP_EN_INT_H						0xffff
#define MASK_AUD_CP_AHB_RF_WAKEUP_EN_INT_L						0xffffffff
#define MASK_AUD_CP_AHB_RF_DSP_L2CC_ENDIAN						0x2
#define MASK_AUD_CP_AHB_RF_DSP_L2CC_DBG_LIMIT					0x1
#define MASK_AUD_CP_AHB_RF_ARQOS_THRESHOLD						0xf0
#define MASK_AUD_CP_AHB_RF_AWQOS_THRESHOLD						0xf
#define MASK_AUD_CP_AHB_RF_AUDCP_AUTO_FREQ_DE					0x800
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_FUNC_M4				0x400
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_FUNC_M2				0x200
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_FUNC_M0_1				0x100
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_FUNC_M0_0				0x80
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_MTX_MAIN				0x40
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_MTX_M4				0x20
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_MTX_M3				0x10
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_MTX_M2				0x8
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_MTX_M1				0x4
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_ON_MTX_M0				0x2
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_EB						0x1
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_FUNC_M4				0x200
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_FUNC_M2				0x100
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_FUNC_M0_1				0x80
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_FUNC_M0_0				0x40
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_MTX_MAIN				0x20
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_MTX_M4				0x10
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_MTX_M3				0x8
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_MTX_M2				0x4
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_MTX_M1				0x2
#define MASK_AUD_CP_AHB_RF_AUTO_FREQ_DE_FRC_OFF_MTX_M0				0x1
#define MASK_AUD_CP_AHB_RF_DBG_DUMMG_REG						0xffffffff
#define MASK_AUD_CP_AHB_RF_CGM_DVFS_ROOT_AUTO_GATE_EN				0x1
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE7				0x1000000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE6				0x800000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE5				0x400000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE4				0x200000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE3				0x100000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE2				0x80000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE1				0x40000
#define MASK_AUD_CP_AHB_RF_DISABLE_CGM_MASTER_2_SLAVE0				0x20000
#define MASK_AUD_CP_AHB_RF_ASYNC_BRIDGE_AUTO_GATE_EN				0x10000
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S7_AUTO_GATE_EN					0x2000
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S6_AUTO_GATE_EN					0x1000
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S5_AUTO_GATE_EN					0x800
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S4_AUTO_GATE_EN					0x400
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S3_AUTO_GATE_EN					0x200
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S2_AUTO_GATE_EN					0x100
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S1_AUTO_GATE_EN					0x80
#define MASK_AUD_CP_AHB_RF_CGM_MTX_S0_AUTO_GATE_EN					0x40
#define MASK_AUD_CP_AHB_RF_CGM_MTX_MAIN_AUTO_GATE_EN				0x20
#define MASK_AUD_CP_AHB_RF_CGM_MTX_M4_AUTO_GATE_EN					0x10
#define MASK_AUD_CP_AHB_RF_CGM_MTX_M3_AUTO_GATE_EN					0x8
#define MASK_AUD_CP_AHB_RF_CGM_MTX_M2_AUTO_GATE_EN					0x4
#define MASK_AUD_CP_AHB_RF_CGM_MTX_M1_AUTO_GATE_EN					0x2
#define MASK_AUD_CP_AHB_RF_CGM_MTX_M0_AUTO_GATE_EN					0x1
#define MASK_AUD_CP_AHB_RF_DVFS_2_AHB_BYPASS					0x2000
#define MASK_AUD_CP_AHB_RF_PCLK_S4_EN_AUTO						0x1000
#define MASK_AUD_CP_AHB_RF_FRC_CLK_CORE_EN						0x80
#define MASK_AUD_CP_AHB_RF_FRC_CLK_APB_EN						0x40
#define MASK_AUD_CP_AHB_RF_FRC_CLK_AHB_EN						0x20
#define MASK_AUD_CP_AHB_RF_FRC_CLK_AXI_EN						0x10
#define MASK_AUD_CP_AHB_RF_CLK_CORE_AUTO_GATE_EN					0x8
#define MASK_AUD_CP_AHB_RF_CLK_APB_AUTO_GATE_EN					0x4
#define MASK_AUD_CP_AHB_RF_CLK_AHB_AUTO_GATE_EN					0x2
#define MASK_AUD_CP_AHB_RF_CLK_AXI_AUTO_GATE_EN					0x1
#define MASK_AUD_CP_AHB_RF_CSYSACK_SYNC_SEL_M1					0x8
#define MASK_AUD_CP_AHB_RF_CACTIVE_SYNC_SEL_M1					0x4
#define MASK_AUD_CP_AHB_RF_CSYSACK_SYNC_SEL_M0					0x2
#define MASK_AUD_CP_AHB_RF_CACTIVE_SYNC_SEL_M0					0x1
#define MASK_AUD_CP_AHB_RF_BUSMON_4_EB						0x8
#define MASK_AUD_CP_AHB_RF_BUSMON_3_EB						0x4
#define MASK_AUD_CP_AHB_RF_BUSMON_2_EB						0x2
#define MASK_AUD_CP_AHB_RF_BUSMON_1_EB						0x1
#define MASK_AUD_CP_AHB_RF_SYS_DBG_BUS						0xffffffff
#define MASK_AP_APB_RF_SIM0_32K_EB							0x40000
#define MASK_AP_APB_RF_SIM0_EB							0x20000
#define MASK_AP_APB_RF_PWM3_EB							0x10000
#define MASK_AP_APB_RF_PWM2_EB							0x8000
#define MASK_AP_APB_RF_PWM1_EB							0x4000
#define MASK_AP_APB_RF_PWM0_EB							0x2000
#define MASK_AP_APB_RF_SPI2_LCD_FMARK_IN_EB					0x1000
#define MASK_AP_APB_RF_SPI2_EB							0x800
#define MASK_AP_APB_RF_SPI1_LCD_FMARK_IN_EB					0x400
#define MASK_AP_APB_RF_SPI1_EB							0x200
#define MASK_AP_APB_RF_SPI0_LCD_FMARK_IN_EB					0x100
#define MASK_AP_APB_RF_SPI0_EB							0x80
#define MASK_AP_APB_RF_I2C4_EB							0x40
#define MASK_AP_APB_RF_I2C3_EB							0x20
#define MASK_AP_APB_RF_I2C2_EB							0x10
#define MASK_AP_APB_RF_I2C1_EB							0x8
#define MASK_AP_APB_RF_I2C0_EB							0x4
#define MASK_AP_APB_RF_UART0_EB							0x2
#define MASK_AP_APB_RF_APB_REG_EB							0x1
#define MASK_AP_APB_RF_SIM0_SOFT_RST						0x2000
#define MASK_AP_APB_RF_PWM3_SOFT_RST						0x1000
#define MASK_AP_APB_RF_PWM2_SOFT_RST						0x800
#define MASK_AP_APB_RF_PWM1_SOFT_RST						0x400
#define MASK_AP_APB_RF_PWM0_SOFT_RST						0x200
#define MASK_AP_APB_RF_SPI2_SOFT_RST						0x100
#define MASK_AP_APB_RF_SPI1_SOFT_RST						0x80
#define MASK_AP_APB_RF_SPI0_SOFT_RST						0x40
#define MASK_AP_APB_RF_I2C4_SOFT_RST						0x20
#define MASK_AP_APB_RF_I2C3_SOFT_RST						0x10
#define MASK_AP_APB_RF_I2C2_SOFT_RST						0x8
#define MASK_AP_APB_RF_I2C1_SOFT_RST						0x4
#define MASK_AP_APB_RF_I2C0_SOFT_RST						0x2
#define MASK_AP_APB_RF_UART0_SOFT_RST						0x1
#define MASK_AP_APB_RF_SIM_CLK_POLARITY						0x8
#define MASK_AP_APB_RF_SPI2_FMARK_POLARITY_INV					0x4
#define MASK_AP_APB_RF_SPI1_FMARK_POLARITY_INV					0x2
#define MASK_AP_APB_RF_SPI0_FMARK_POLARITY_INV					0x1
#define MASK_AP_APB_RF_SIM0_PCLK_AUTO_GATE_EB					0x2000
#define MASK_AP_APB_RF_PWM3_PCLK_AUTO_GATE_EB					0x1000
#define MASK_AP_APB_RF_PWM2_PCLK_AUTO_GATE_EB					0x800
#define MASK_AP_APB_RF_PWM1_PCLK_AUTO_GATE_EB					0x400
#define MASK_AP_APB_RF_PWM0_PCLK_AUTO_GATE_EB					0x200
#define MASK_AP_APB_RF_SPI2_PCLK_AUTO_GATE_EB					0x100
#define MASK_AP_APB_RF_SPI1_PCLK_AUTO_GATE_EB					0x80
#define MASK_AP_APB_RF_SPI0_PCLK_AUTO_GATE_EB					0x40
#define MASK_AP_APB_RF_I2C4_PCLK_AUTO_GATE_EB					0x20
#define MASK_AP_APB_RF_I2C3_PCLK_AUTO_GATE_EB					0x10
#define MASK_AP_APB_RF_I2C2_PCLK_AUTO_GATE_EB					0x8
#define MASK_AP_APB_RF_I2C1_PCLK_AUTO_GATE_EB					0x4
#define MASK_AP_APB_RF_I2C0_PCLK_AUTO_GATE_EB					0x2
#define MASK_AP_APB_RF_UART0_PCLK_AUTO_GATE_EB					0x1
#define MASK_AP_APB_RF_SIM0_PCLK_AUTO_SLOW_EN					0x800000
#define MASK_AP_APB_RF_SIM0_PCLK_AUTO_SLOW_SEL					0x700000
#define MASK_AP_APB_RF_PWM3_PCLK_AUTO_SLOW_EN					0x80000
#define MASK_AP_APB_RF_PWM3_PCLK_AUTO_SLOW_SEL					0x70000
#define MASK_AP_APB_RF_PWM2_PCLK_AUTO_SLOW_EN					0x8000
#define MASK_AP_APB_RF_PWM2_PCLK_AUTO_SLOW_SEL					0x7000
#define MASK_AP_APB_RF_PWM1_PCLK_AUTO_SLOW_EN					0x800
#define MASK_AP_APB_RF_PWM1_PCLK_AUTO_SLOW_SEL					0x700
#define MASK_AP_APB_RF_PWM0_PCLK_AUTO_SLOW_EN					0x80
#define MASK_AP_APB_RF_PWM0_PCLK_AUTO_SLOW_SEL					0x70
#define MASK_AP_APB_RF_SPI2_PCLK_AUTO_SLOW_EN					0x8
#define MASK_AP_APB_RF_SPI2_PCLK_AUTO_SLOW_SEL					0x7
#define MASK_AP_APB_RF_SPI1_PCLK_AUTO_SLOW_EN					0x80000000
#define MASK_AP_APB_RF_SPI1_PCLK_AUTO_SLOW_SEL					0x70000000
#define MASK_AP_APB_RF_SPI0_PCLK_AUTO_SLOW_EN					0x8000000
#define MASK_AP_APB_RF_SPI0_PCLK_AUTO_SLOW_SEL					0x7000000
#define MASK_AP_APB_RF_I2C4_PCLK_AUTO_SLOW_EN					0x800000
#define MASK_AP_APB_RF_I2C4_PCLK_AUTO_SLOW_SEL					0x700000
#define MASK_AP_APB_RF_I2C3_PCLK_AUTO_SLOW_EN					0x80000
#define MASK_AP_APB_RF_I2C3_PCLK_AUTO_SLOW_SEL					0x70000
#define MASK_AP_APB_RF_I2C2_PCLK_AUTO_SLOW_EN					0x8000
#define MASK_AP_APB_RF_I2C2_PCLK_AUTO_SLOW_SEL					0x7000
#define MASK_AP_APB_RF_I2C1_PCLK_AUTO_SLOW_EN					0x800
#define MASK_AP_APB_RF_I2C1_PCLK_AUTO_SLOW_SEL					0x700
#define MASK_AP_APB_RF_I2C0_PCLK_AUTO_SLOW_EN					0x80
#define MASK_AP_APB_RF_I2C0_PCLK_AUTO_SLOW_SEL					0x70
#define MASK_AP_APB_RF_UART0_PCLK_AUTO_SLOW_EN					0x8
#define MASK_AP_APB_RF_UART0_PCLK_AUTO_SLOW_SEL					0x7
#define MASK_AP_APB_RF_SIM0_FRC_DOZE						0x2000
#define MASK_AP_APB_RF_PWM3_FRC_DOZE						0x1000
#define MASK_AP_APB_RF_PWM2_FRC_DOZE						0x800
#define MASK_AP_APB_RF_PWM1_FRC_DOZE						0x400
#define MASK_AP_APB_RF_PWM0_FRC_DOZE						0x200
#define MASK_AP_APB_RF_SPI2_FRC_DOZE						0x100
#define MASK_AP_APB_RF_SPI1_FRC_DOZE						0x80
#define MASK_AP_APB_RF_SPI0_FRC_DOZE						0x40
#define MASK_AP_APB_RF_I2C4_FRC_DOZE						0x20
#define MASK_AP_APB_RF_I2C3_FRC_DOZE						0x10
#define MASK_AP_APB_RF_I2C2_FRC_DOZE						0x8
#define MASK_AP_APB_RF_I2C1_FRC_DOZE						0x4
#define MASK_AP_APB_RF_I2C0_FRC_DOZE						0x2
#define MASK_AP_APB_RF_UART0_FRC_DOZE						0x1
#define MASK_AP_APB_RF_MCLK_AUTO_GATE_EN						0x2
#define MASK_AP_APB_RF_SCLK_AUTO_GATE_EN						0x1
#define MASK_AP_APB_RF_RESERVE0							0xffffffff
#define MASK_AP_APB_RF_RESERVE1							0xffffffff
#define MASK_AUD_CP_APB_RF_TMR1_EB							0x40
#define MASK_AUD_CP_APB_RF_TMR0_EB							0x20
#define MASK_AUD_CP_APB_RF_RTC_WDG_EB						0x4
#define MASK_AUD_CP_APB_RF_WDG_EB							0x2
#define MASK_AUD_CP_APB_RF_TMR1_SOFT_RST						0x8
#define MASK_AUD_CP_APB_RF_TMR0_SOFT_RST						0x4
#define MASK_AUD_CP_APB_RF_WDG_SOFT_RST						0x2
#define MASK_AUD_CP_APB_RF_AXI_LP_CTRL_DISABLE					0x10000
#define MASK_AUD_CP_APB_RF_OCEM_RST_MASK						0x2
#define MASK_AUD_CP_APB_RF_DSP_STATUS						0x1ff80000
#define MASK_AUD_CP_APB_RF_WAKE_INT_MSK						0xffff
#define MASK_AUD_CP_APB_RF_HIGH_RESERVED						0xffff0000
#define MASK_AUD_CP_APB_RF_LOW_RESERVED						0xffff
#define MASK_AUD_CP_APB_RF_IRAM_ENDIAN_SEL						0x1
#define MASK_AON_APB_RF_APB_BUSMON_S5_EB						0x80000000
#define MASK_AON_APB_RF_AON_NR_SPI_WRAP_EB						0x40000000
#define MASK_AON_APB_RF_RTM_ATB_EB							0x20000000
#define MASK_AON_APB_RF_RTM_EB							0x10000000
#define MASK_AON_APB_RF_SERDES2_EB							0x8000000
#define MASK_AON_APB_RF_SERDES1_EB							0x4000000
#define MASK_AON_APB_RF_SERDES0_EB							0x2000000
#define MASK_AON_APB_RF_SERDES_DPHY2_REF_EB					0x1000000
#define MASK_AON_APB_RF_SERDES_DPHY2_CFG_EB					0x800000
#define MASK_AON_APB_RF_SERDES_DPHY1_REF_EB					0x400000
#define MASK_AON_APB_RF_SERDES_DPHY1_CFG_EB					0x200000
#define MASK_AON_APB_RF_SERDES_DPHY0_REF_EB					0x100000
#define MASK_AON_APB_RF_SERDES_DPHY0_CFG_EB					0x80000
#define MASK_AON_APB_RF_WCN_ADDA_TEST_EB						0x40000
#define MASK_AON_APB_RF_CSSYS_PUB_EB						0x20000
#define MASK_AON_APB_RF_CSSYS_APB_EB						0x10000
#define MASK_AON_APB_RF_CSSYS_EB							0x8000
#define MASK_AON_APB_RF_APCPU_DAP_EB						0x4000
#define MASK_AON_APB_RF_DEBUG_FILTER_EB						0x2000
#define MASK_AON_APB_RF_APCPU_CSSYS_EB						0x1000
#define MASK_AON_APB_RF_PMU_APB_BUSMON_EB						0x800
#define MASK_AON_APB_RF_SP_AHB_CLK_SOFT_EB						0x400
#define MASK_AON_APB_RF_AON_APB_BUSMON_EB						0x200
#define MASK_AON_APB_RF_BSM_TMR_EB							0x100
#define MASK_AON_APB_RF_PROBE_EB							0x80
#define MASK_AON_APB_RF_AUX2_EB							0x40
#define MASK_AON_APB_RF_AUX1_EB							0x20
#define MASK_AON_APB_RF_AUX0_EB							0x10
#define MASK_AON_APB_RF_DJTAG_EB							0x8
#define MASK_AON_APB_RF_DJTAG_TCK_EB						0x4
#define MASK_AON_APB_RF_AON_SPI_WRAP_EB						0x2
#define MASK_AON_APB_RF_RC100M_CAL_EB						0x1
#define MASK_AON_APB_RF_SC_CC_EB							0x80000000
#define MASK_AON_APB_RF_APB_BUSMON_S3_EB						0x40000000
#define MASK_AON_APB_RF_SIM_AON_TOP_V3PS2						0x20000000
#define MASK_AON_APB_RF_SIM_AON_TOP_V3PS1						0x10000000
#define MASK_AON_APB_RF_SIM_AON_TOP_V3PS0						0x8000000
#define MASK_AON_APB_RF_APCPU_AB_EB						0x4000000
#define MASK_AON_APB_RF_AP_SPI2_EB							0x2000000
#define MASK_AON_APB_RF_AP_SPI1_EB							0x1000000
#define MASK_AON_APB_RF_AP_SPI0_EB							0x800000
#define MASK_AON_APB_RF_APB_DIRECT_ACC_PROT_AON_APB_EB				0x400000
#define MASK_AON_APB_RF_APB_DIRECT_ACC_PROT_PMU_APB_EB				0x200000
#define MASK_AON_APB_RF_SCC_EB							0x100000
#define MASK_AON_APB_RF_NIC400_AON_CFG_EB						0x80000
#define MASK_AON_APB_RF_APCPU_TS0_EB						0x20000
#define MASK_AON_APB_RF_DJTAG_CTRL_EB						0x10000
#define MASK_AON_APB_RF_AON_RFSPI_SLV_NR_EB					0x8000
#define MASK_AON_APB_RF_AON_RFSPI_SLV_V3_EB					0x4000
#define MASK_AON_APB_RF_CKG_EB							0x2000
#define MASK_AON_APB_RF_ANA_EB							0x1000
#define MASK_AON_APB_RF_PIN_EB							0x800
#define MASK_AON_APB_RF_SPLK_EB							0x400
#define MASK_AON_APB_RF_APCPU_CLK_RF_EB						0x100
#define MASK_AON_APB_RF_DVFS_TOP_EB						0x80
#define MASK_AON_APB_RF_AON_TMR_EB							0x40
#define MASK_AON_APB_RF_AP_SYST_EB							0x20
#define MASK_AON_APB_RF_AON_SYST_EB						0x10
#define MASK_AON_APB_RF_KPD_EB							0x8
#define MASK_AON_APB_RF_MBOX_EB							0x4
#define MASK_AON_APB_RF_GPIO_EB							0x2
#define MASK_AON_APB_RF_EFUSE_EB							0x1
#define MASK_AON_APB_RF_THM2_EB							0x40000000
#define MASK_AON_APB_RF_APCPU_WDG_EB						0x20000000
#define MASK_AON_APB_RF_AP_WDG_EB							0x10000000
#define MASK_AON_APB_RF_AP_TMR2_EB							0x8000000
#define MASK_AON_APB_RF_AP_TMR1_EB							0x4000000
#define MASK_AON_APB_RF_AP_TMR0_EB							0x2000000
#define MASK_AON_APB_RF_NR_CP_INTC_EB						0x1000000
#define MASK_AON_APB_RF_NR_DSP1_INTC_EB						0x800000
#define MASK_AON_APB_RF_NR_DSP0_INTC_EB						0x400000
#define MASK_AON_APB_RF_NR_CR8_INTC_EB						0x200000
#define MASK_AON_APB_RF_V3PHY_INTC_EB						0x100000
#define MASK_AON_APB_RF_V3PS_INTC_EB						0x80000
#define MASK_AON_APB_RF_V3MODEM_INTC_EB						0x40000
#define MASK_AON_APB_RF_PSCP_INTC_EB						0x20000
#define MASK_AON_APB_RF_AUDCP_INTC_EB						0x10000
#define MASK_AON_APB_RF_AP_INTC5_EB						0x8000
#define MASK_AON_APB_RF_AP_INTC4_EB						0x4000
#define MASK_AON_APB_RF_AP_INTC3_EB						0x2000
#define MASK_AON_APB_RF_AP_INTC2_EB						0x1000
#define MASK_AON_APB_RF_AP_INTC1_EB						0x800
#define MASK_AON_APB_RF_AP_INTC0_EB						0x400
#define MASK_AON_APB_RF_EIC_EB							0x200
#define MASK_AON_APB_RF_ADI_EB							0x100
#define MASK_AON_APB_RF_PMU_EB							0x80
#define MASK_AON_APB_RF_I2C_EB							0x40
#define MASK_AON_APB_RF_PSCP_SIM2_AON_TOP_EB					0x20
#define MASK_AON_APB_RF_PSCP_SIM1_AON_TOP_EB					0x10
#define MASK_AON_APB_RF_PSCP_SIM0_AON_TOP_EB					0x8
#define MASK_AON_APB_RF_AP_SIM_AON_TOP_EB						0x4
#define MASK_AON_APB_RF_THM1_EB							0x2
#define MASK_AON_APB_RF_THM0_EB							0x1
#define MASK_AON_APB_RF_BB_CAL_RTC_EB						0x2000
#define MASK_AON_APB_RF_DCXO_LC_RTC_EB						0x1000
#define MASK_AON_APB_RF_AP_TMR2_RTC_EB						0x800
#define MASK_AON_APB_RF_AP_TMR1_RTC_EB						0x400
#define MASK_AON_APB_RF_AP_TMR0_RTC_EB						0x200
#define MASK_AON_APB_RF_APCPU_WDG_RTC_EB						0x100
#define MASK_AON_APB_RF_AP_WDG_RTC_EB						0x80
#define MASK_AON_APB_RF_EIC_RTCDV5_EB						0x40
#define MASK_AON_APB_RF_EIC_RTC_EB							0x20
#define MASK_AON_APB_RF_AON_TMR_RTC_EB						0x10
#define MASK_AON_APB_RF_AP_SYST_RTC_EB						0x8
#define MASK_AON_APB_RF_AON_SYST_RTC_EB						0x4
#define MASK_AON_APB_RF_KPD_RTC_EB							0x2
#define MASK_AON_APB_RF_ARCH_RTC_EB						0x1
#define MASK_AON_APB_RF_PSCP_SYST_RTC_EB						0x800
#define MASK_AON_APB_RF_PSCP_TMR_EB						0x400
#define MASK_AON_APB_RF_PSCP_TMR_RTC_EB						0x200
#define MASK_AON_APB_RF_PSCP_SYST_EB						0x100
#define MASK_AON_APB_RF_PSCP_WDG_EB						0x80
#define MASK_AON_APB_RF_PSCP_WDG_RTC_EB						0x40
#define MASK_AON_APB_RF_PSCP_ARCH_RTC_EB						0x20
#define MASK_AON_APB_RF_CPALL_EIC_EB						0x10
#define MASK_AON_APB_RF_CPALL_EIC_RTCDV5_EB					0x8
#define MASK_AON_APB_RF_CPALL_EIC_RTC_EB						0x4
#define MASK_AON_APB_RF_CGM_CM4_TMR2_EN						0x80000
#define MASK_AON_APB_RF_DET_32K_EB							0x40000
#define MASK_AON_APB_RF_CGM_DEBOUNCE_EN						0x20000
#define MASK_AON_APB_RF_CGM_RC100M_FDK_EN						0x10000
#define MASK_AON_APB_RF_CGM_RC100M_REF_EN						0x8000
#define MASK_AON_APB_RF_CGM_TMR_EN							0x4000
#define MASK_AON_APB_RF_CGM_TSEN_EN						0x2000
#define MASK_AON_APB_RF_CGM_OTG_REF_EN						0x1000
#define MASK_AON_APB_RF_CGM_DMC_REF_EN						0x800
#define MASK_AON_APB_RF_CGM_DPHY_REF_EN						0x400
#define MASK_AON_APB_RF_CGM_DJTAG_TCK_EN						0x200
#define MASK_AON_APB_RF_CGM_DSI2_TEST_EB						0x100
#define MASK_AON_APB_RF_CGM_DSI1_TEST_EB						0x80
#define MASK_AON_APB_RF_CGM_DSI0_TEST_EB						0x40
#define MASK_AON_APB_RF_SOFT_DDR0_CKG_1X_EN					0x4000000
#define MASK_AON_APB_RF_SOFT_DDR0_DATA_RET						0x800000
#define MASK_AON_APB_RF_LIGHT_SLEEP_DDR0_DATA_RET_EN				0x200000
#define MASK_AON_APB_RF_EMC0_CKG_SEL_LOAD						0x80000
#define MASK_AON_APB_RF_CLK_DEBUG_TS_EB						0x40000
#define MASK_AON_APB_RF_AAPC_CLK_TEST_EB						0x10000
#define MASK_AON_APB_RF_CGM_CPHY_CFG_EN						0x8000
#define MASK_AON_APB_RF_ALL_PLL_TEST_EB						0x4000
#define MASK_AON_APB_RF_CGM_NANDC_2X_EN						0x800
#define MASK_AON_APB_RF_CGM_NANDC_1X_EN						0x400
#define MASK_AON_APB_RF_CGM_EMMC_2X_EN						0x200
#define MASK_AON_APB_RF_CGM_EMMC_1X_EN						0x100
#define MASK_AON_APB_RF_CGM_SDIO2_1X_EN						0x80
#define MASK_AON_APB_RF_CGM_SDIO2_2X_EN						0x40
#define MASK_AON_APB_RF_CGM_SDIO1_1X_EN						0x20
#define MASK_AON_APB_RF_CGM_SDIO1_2X_EN						0x10
#define MASK_AON_APB_RF_CGM_SDIO0_1X_EN						0x8
#define MASK_AON_APB_RF_CGM_SDIO0_2X_EN						0x4
#define MASK_AON_APB_RF_CGM_APCPU_AXI_EN						0x2
#define MASK_AON_APB_RF_CGM_CSSYS_EN						0x1
#define MASK_AON_APB_RF_APCPU_INT_EN_31						0x80000000
#define MASK_AON_APB_RF_APCPU_INT_EN_30						0x40000000
#define MASK_AON_APB_RF_APCPU_INT_EN_29						0x20000000
#define MASK_AON_APB_RF_APCPU_INT_EN_28						0x10000000
#define MASK_AON_APB_RF_APCPU_INT_EN_27						0x8000000
#define MASK_AON_APB_RF_APCPU_INT_EN_26						0x4000000
#define MASK_AON_APB_RF_APCPU_INT_EN_25						0x2000000
#define MASK_AON_APB_RF_APCPU_INT_EN_24						0x1000000
#define MASK_AON_APB_RF_APCPU_INT_EN_23						0x800000
#define MASK_AON_APB_RF_APCPU_INT_EN_22						0x400000
#define MASK_AON_APB_RF_APCPU_INT_EN_21						0x200000
#define MASK_AON_APB_RF_APCPU_INT_EN_20						0x100000
#define MASK_AON_APB_RF_APCPU_INT_EN_19						0x80000
#define MASK_AON_APB_RF_APCPU_INT_EN_18						0x40000
#define MASK_AON_APB_RF_APCPU_INT_EN_17						0x20000
#define MASK_AON_APB_RF_APCPU_INT_EN_16						0x10000
#define MASK_AON_APB_RF_APCPU_INT_EN_15						0x8000
#define MASK_AON_APB_RF_APCPU_INT_EN_14						0x4000
#define MASK_AON_APB_RF_APCPU_INT_EN_13						0x2000
#define MASK_AON_APB_RF_APCPU_INT_EN_12						0x1000
#define MASK_AON_APB_RF_APCPU_INT_EN_11						0x800
#define MASK_AON_APB_RF_APCPU_INT_EN_10						0x400
#define MASK_AON_APB_RF_APCPU_INT_EN_9						0x200
#define MASK_AON_APB_RF_APCPU_INT_EN_8						0x100
#define MASK_AON_APB_RF_APCPU_INT_EN_7						0x80
#define MASK_AON_APB_RF_APCPU_INT_EN_6						0x40
#define MASK_AON_APB_RF_APCPU_INT_EN_5						0x20
#define MASK_AON_APB_RF_APCPU_INT_EN_4						0x10
#define MASK_AON_APB_RF_APCPU_INT_EN_3						0x8
#define MASK_AON_APB_RF_APCPU_INT_EN_2						0x4
#define MASK_AON_APB_RF_APCPU_INT_EN_1						0x2
#define MASK_AON_APB_RF_APCPU_INT_EN_0						0x1
#define MASK_AON_APB_RF_APCPU_INT_EN_63						0x80000000
#define MASK_AON_APB_RF_APCPU_INT_EN_62						0x40000000
#define MASK_AON_APB_RF_APCPU_INT_EN_61						0x20000000
#define MASK_AON_APB_RF_APCPU_INT_EN_60						0x10000000
#define MASK_AON_APB_RF_APCPU_INT_EN_59						0x8000000
#define MASK_AON_APB_RF_APCPU_INT_EN_58						0x4000000
#define MASK_AON_APB_RF_APCPU_INT_EN_57						0x2000000
#define MASK_AON_APB_RF_APCPU_INT_EN_56						0x1000000
#define MASK_AON_APB_RF_APCPU_INT_EN_55						0x800000
#define MASK_AON_APB_RF_APCPU_INT_EN_54						0x400000
#define MASK_AON_APB_RF_APCPU_INT_EN_53						0x200000
#define MASK_AON_APB_RF_APCPU_INT_EN_52						0x100000
#define MASK_AON_APB_RF_APCPU_INT_EN_51						0x80000
#define MASK_AON_APB_RF_APCPU_INT_EN_50						0x40000
#define MASK_AON_APB_RF_APCPU_INT_EN_49						0x20000
#define MASK_AON_APB_RF_APCPU_INT_EN_48						0x10000
#define MASK_AON_APB_RF_APCPU_INT_EN_47						0x8000
#define MASK_AON_APB_RF_APCPU_INT_EN_46						0x4000
#define MASK_AON_APB_RF_APCPU_INT_EN_45						0x2000
#define MASK_AON_APB_RF_APCPU_INT_EN_44						0x1000
#define MASK_AON_APB_RF_APCPU_INT_EN_43						0x800
#define MASK_AON_APB_RF_APCPU_INT_EN_42						0x400
#define MASK_AON_APB_RF_APCPU_INT_EN_41						0x200
#define MASK_AON_APB_RF_APCPU_INT_EN_40						0x100
#define MASK_AON_APB_RF_APCPU_INT_EN_39						0x80
#define MASK_AON_APB_RF_APCPU_INT_EN_38						0x40
#define MASK_AON_APB_RF_APCPU_INT_EN_37						0x20
#define MASK_AON_APB_RF_APCPU_INT_EN_36						0x10
#define MASK_AON_APB_RF_APCPU_INT_EN_35						0x8
#define MASK_AON_APB_RF_APCPU_INT_EN_34						0x4
#define MASK_AON_APB_RF_APCPU_INT_EN_33						0x2
#define MASK_AON_APB_RF_APCPU_INT_EN_32						0x1
#define MASK_AON_APB_RF_APCPU_INT_EN_95						0x80000000
#define MASK_AON_APB_RF_APCPU_INT_EN_94						0x40000000
#define MASK_AON_APB_RF_APCPU_INT_EN_93						0x20000000
#define MASK_AON_APB_RF_APCPU_INT_EN_92						0x10000000
#define MASK_AON_APB_RF_APCPU_INT_EN_91						0x8000000
#define MASK_AON_APB_RF_APCPU_INT_EN_90						0x4000000
#define MASK_AON_APB_RF_APCPU_INT_EN_89						0x2000000
#define MASK_AON_APB_RF_APCPU_INT_EN_88						0x1000000
#define MASK_AON_APB_RF_APCPU_INT_EN_87						0x800000
#define MASK_AON_APB_RF_APCPU_INT_EN_86						0x400000
#define MASK_AON_APB_RF_APCPU_INT_EN_85						0x200000
#define MASK_AON_APB_RF_APCPU_INT_EN_84						0x100000
#define MASK_AON_APB_RF_APCPU_INT_EN_83						0x80000
#define MASK_AON_APB_RF_APCPU_INT_EN_82						0x40000
#define MASK_AON_APB_RF_APCPU_INT_EN_81						0x20000
#define MASK_AON_APB_RF_APCPU_INT_EN_80						0x10000
#define MASK_AON_APB_RF_APCPU_INT_EN_79						0x8000
#define MASK_AON_APB_RF_APCPU_INT_EN_78						0x4000
#define MASK_AON_APB_RF_APCPU_INT_EN_77						0x2000
#define MASK_AON_APB_RF_APCPU_INT_EN_76						0x1000
#define MASK_AON_APB_RF_APCPU_INT_EN_75						0x800
#define MASK_AON_APB_RF_APCPU_INT_EN_74						0x400
#define MASK_AON_APB_RF_APCPU_INT_EN_73						0x200
#define MASK_AON_APB_RF_APCPU_INT_EN_72						0x100
#define MASK_AON_APB_RF_APCPU_INT_EN_71						0x80
#define MASK_AON_APB_RF_APCPU_INT_EN_70						0x40
#define MASK_AON_APB_RF_APCPU_INT_EN_69						0x20
#define MASK_AON_APB_RF_APCPU_INT_EN_68						0x10
#define MASK_AON_APB_RF_APCPU_INT_EN_67						0x8
#define MASK_AON_APB_RF_APCPU_INT_EN_66						0x4
#define MASK_AON_APB_RF_APCPU_INT_EN_65						0x2
#define MASK_AON_APB_RF_APCPU_INT_EN_64						0x1
#define MASK_AON_APB_RF_APCPU_INT_EN_127						0x80000000
#define MASK_AON_APB_RF_APCPU_INT_EN_126						0x40000000
#define MASK_AON_APB_RF_APCPU_INT_EN_125						0x20000000
#define MASK_AON_APB_RF_APCPU_INT_EN_124						0x10000000
#define MASK_AON_APB_RF_APCPU_INT_EN_123						0x8000000
#define MASK_AON_APB_RF_APCPU_INT_EN_122						0x4000000
#define MASK_AON_APB_RF_APCPU_INT_EN_121						0x2000000
#define MASK_AON_APB_RF_APCPU_INT_EN_120						0x1000000
#define MASK_AON_APB_RF_APCPU_INT_EN_119						0x800000
#define MASK_AON_APB_RF_APCPU_INT_EN_118						0x400000
#define MASK_AON_APB_RF_APCPU_INT_EN_117						0x200000
#define MASK_AON_APB_RF_APCPU_INT_EN_116						0x100000
#define MASK_AON_APB_RF_APCPU_INT_EN_115						0x80000
#define MASK_AON_APB_RF_APCPU_INT_EN_114						0x40000
#define MASK_AON_APB_RF_APCPU_INT_EN_113						0x20000
#define MASK_AON_APB_RF_APCPU_INT_EN_112						0x10000
#define MASK_AON_APB_RF_APCPU_INT_EN_111						0x8000
#define MASK_AON_APB_RF_APCPU_INT_EN_110						0x4000
#define MASK_AON_APB_RF_APCPU_INT_EN_109						0x2000
#define MASK_AON_APB_RF_APCPU_INT_EN_108						0x1000
#define MASK_AON_APB_RF_APCPU_INT_EN_107						0x800
#define MASK_AON_APB_RF_APCPU_INT_EN_106						0x400
#define MASK_AON_APB_RF_APCPU_INT_EN_105						0x200
#define MASK_AON_APB_RF_APCPU_INT_EN_104						0x100
#define MASK_AON_APB_RF_APCPU_INT_EN_103						0x80
#define MASK_AON_APB_RF_APCPU_INT_EN_102						0x40
#define MASK_AON_APB_RF_APCPU_INT_EN_101						0x20
#define MASK_AON_APB_RF_APCPU_INT_EN_100						0x10
#define MASK_AON_APB_RF_APCPU_INT_EN_99						0x8
#define MASK_AON_APB_RF_APCPU_INT_EN_98						0x4
#define MASK_AON_APB_RF_APCPU_INT_EN_97						0x2
#define MASK_AON_APB_RF_APCPU_INT_EN_96						0x1
#define MASK_AON_APB_RF_APCPU_INT_EN_159						0x80000000
#define MASK_AON_APB_RF_APCPU_INT_EN_158						0x40000000
#define MASK_AON_APB_RF_APCPU_INT_EN_157						0x20000000
#define MASK_AON_APB_RF_APCPU_INT_EN_156						0x10000000
#define MASK_AON_APB_RF_APCPU_INT_EN_155						0x8000000
#define MASK_AON_APB_RF_APCPU_INT_EN_154						0x4000000
#define MASK_AON_APB_RF_APCPU_INT_EN_153						0x2000000
#define MASK_AON_APB_RF_APCPU_INT_EN_152						0x1000000
#define MASK_AON_APB_RF_APCPU_INT_EN_151						0x800000
#define MASK_AON_APB_RF_APCPU_INT_EN_150						0x400000
#define MASK_AON_APB_RF_APCPU_INT_EN_149						0x200000
#define MASK_AON_APB_RF_APCPU_INT_EN_148						0x100000
#define MASK_AON_APB_RF_APCPU_INT_EN_147						0x80000
#define MASK_AON_APB_RF_APCPU_INT_EN_146						0x40000
#define MASK_AON_APB_RF_APCPU_INT_EN_145						0x20000
#define MASK_AON_APB_RF_APCPU_INT_EN_144						0x10000
#define MASK_AON_APB_RF_APCPU_INT_EN_143						0x8000
#define MASK_AON_APB_RF_APCPU_INT_EN_142						0x4000
#define MASK_AON_APB_RF_APCPU_INT_EN_141						0x2000
#define MASK_AON_APB_RF_APCPU_INT_EN_140						0x1000
#define MASK_AON_APB_RF_APCPU_INT_EN_139						0x800
#define MASK_AON_APB_RF_APCPU_INT_EN_138						0x400
#define MASK_AON_APB_RF_APCPU_INT_EN_137						0x200
#define MASK_AON_APB_RF_APCPU_INT_EN_136						0x100
#define MASK_AON_APB_RF_APCPU_INT_EN_135						0x80
#define MASK_AON_APB_RF_APCPU_INT_EN_134						0x40
#define MASK_AON_APB_RF_APCPU_INT_EN_133						0x20
#define MASK_AON_APB_RF_APCPU_INT_EN_132						0x10
#define MASK_AON_APB_RF_APCPU_INT_EN_131						0x8
#define MASK_AON_APB_RF_APCPU_INT_EN_130						0x4
#define MASK_AON_APB_RF_APCPU_INT_EN_129						0x2
#define MASK_AON_APB_RF_APCPU_INT_EN_128						0x1
#define MASK_AON_APB_RF_APCPU_INT_EN_191						0x80000000
#define MASK_AON_APB_RF_APCPU_INT_EN_190						0x40000000
#define MASK_AON_APB_RF_APCPU_INT_EN_189						0x20000000
#define MASK_AON_APB_RF_APCPU_INT_EN_188						0x10000000
#define MASK_AON_APB_RF_APCPU_INT_EN_187						0x8000000
#define MASK_AON_APB_RF_APCPU_INT_EN_186						0x4000000
#define MASK_AON_APB_RF_APCPU_INT_EN_185						0x2000000
#define MASK_AON_APB_RF_APCPU_INT_EN_184						0x1000000
#define MASK_AON_APB_RF_APCPU_INT_EN_183						0x800000
#define MASK_AON_APB_RF_APCPU_INT_EN_182						0x400000
#define MASK_AON_APB_RF_APCPU_INT_EN_181						0x200000
#define MASK_AON_APB_RF_APCPU_INT_EN_180						0x100000
#define MASK_AON_APB_RF_APCPU_INT_EN_179						0x80000
#define MASK_AON_APB_RF_APCPU_INT_EN_178						0x40000
#define MASK_AON_APB_RF_APCPU_INT_EN_177						0x20000
#define MASK_AON_APB_RF_APCPU_INT_EN_176						0x10000
#define MASK_AON_APB_RF_APCPU_INT_EN_175						0x8000
#define MASK_AON_APB_RF_APCPU_INT_EN_174						0x4000
#define MASK_AON_APB_RF_APCPU_INT_EN_173						0x2000
#define MASK_AON_APB_RF_APCPU_INT_EN_172						0x1000
#define MASK_AON_APB_RF_APCPU_INT_EN_171						0x800
#define MASK_AON_APB_RF_APCPU_INT_EN_170						0x400
#define MASK_AON_APB_RF_APCPU_INT_EN_169						0x200
#define MASK_AON_APB_RF_APCPU_INT_EN_168						0x100
#define MASK_AON_APB_RF_APCPU_INT_EN_167						0x80
#define MASK_AON_APB_RF_APCPU_INT_EN_166						0x40
#define MASK_AON_APB_RF_APCPU_INT_EN_165						0x20
#define MASK_AON_APB_RF_APCPU_INT_EN_164						0x10
#define MASK_AON_APB_RF_APCPU_INT_EN_163						0x8
#define MASK_AON_APB_RF_APCPU_INT_EN_162						0x4
#define MASK_AON_APB_RF_APCPU_INT_EN_161						0x2
#define MASK_AON_APB_RF_APCPU_INT_EN_160						0x1
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_PSCP_WAKEUP_EN				0x80000000
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_AUDCP_WAKEUP_EN				0x40000000
#define MASK_AON_APB_RF_SP_INT_REQ_ADI_WAKEUP_EN					0x20000000
#define MASK_AON_APB_RF_SP_INT_REQ_PCP_WDG_WAKEUP_EN				0x10000000
#define MASK_AON_APB_RF_SP_INT_REQ_PWR_DOWN_ALL_WAKEUP_EN				0x8000000
#define MASK_AON_APB_RF_SP_INT_REQ_PWR_UP_ALL_WAKEUP_EN				0x4000000
#define MASK_AON_APB_RF_SP_INT_REQ_AP_WDG_RST_WAKEUP_EN				0x2000000
#define MASK_AON_APB_RF_SP_INT_REQ_APCPU_WDG_RST_WAKEUP_EN				0x1000000
#define MASK_AON_APB_RF_SP_INT_REQ_APCPU_BUSMON_WAKEUP_EN				0x800000
#define MASK_AON_APB_RF_SP_INT_REQ_PSCP_BUSMON_WAKEUP_EN				0x400000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_BUSMON_WAKEUP_EN				0x200000
#define MASK_AON_APB_RF_SP_INT_REQ_AP_SYS_BUSMON_WAKEUP_EN				0x100000
#define MASK_AON_APB_RF_SP_INT_REQ_MBOX_SRC_SIPC_SP_CM4_WAKEUP_EN			0x40000
#define MASK_AON_APB_RF_SP_INT_REQ_MBOX_SRC_CM4_WAKEUP_EN				0x20000
#define MASK_AON_APB_RF_SP_INT_REQ_MBOX_TAR_CM4_WAKEUP_EN				0x10000
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_SOFT_WAKEUP_EN				0x8000
#define MASK_AON_APB_RF_SP_INT_FPU_EXCEPTION_WAKEUP_EN				0x4000
#define MASK_AON_APB_RF_SP_INT_REQ_EIC_GPIO_NON_LAT_WAKEUP_EN			0x2000
#define MASK_AON_APB_RF_SP_INT_REQ_EIC_GPIO_LAT_WAKEUP_EN				0x1000
#define MASK_AON_APB_RF_SP_INT_REQ_EIC_NON_LAT_WAKEUP_EN				0x800
#define MASK_AON_APB_RF_SP_INT_REQ_EIC_LAT_WAKEUP_EN				0x400
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_DMA_WAKEUP_EN				0x200
#define MASK_AON_APB_RF_SP_INT_REQ_GPIO_WAKEUP_EN					0x100
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_SYST_WAKEUP_EN				0x80
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_I2C0_SLV_WAKEUP_EN				0x40
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_WDG_WAKEUP_EN				0x20
#define MASK_AON_APB_RF_SP_INT_REQ_EIC1_NON_LAT_WAKEUP_EN				0x10
#define MASK_AON_APB_RF_SP_INT_REQ_EIC1_LAT_WAKEUP_EN				0x8
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_UART0_WAKEUP_EN				0x4
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_VBC_AUDRCD_WAKEUP_EN			0x80000000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_MCDT_WAKEUP_EN				0x40000000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_DMA_WAKEUP_EN				0x20000000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_CHN_START_CHN3_WAKEUP_EN			0x10000000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_CHN_START_CHN2_WAKEUP_EN			0x8000000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_CHN_START_CHN1_WAKEUP_EN			0x4000000
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_CHN_START_CHN0_WAKEUP_EN			0x2000000
#define MASK_AON_APB_RF_SP_INT_REQ_ANA_WAKEUP_EN					0x1000000
#define MASK_AON_APB_RF_SP_INT_REQ_WTLCP_LTE_WDG_RST_WAKEUP_EN			0x800000
#define MASK_AON_APB_RF_SP_INT_REQ_WTLCP_TG_WDG_RST_WAKEUP_EN			0x400000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_DFS_DENY_EN					0x40000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_DMC_MPU_VIO_WAKEUP_EN			0x20000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_DFI_BUSMON_WAKEUP_EN			0x8000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_PTM_WAKEUP_EN				0x4000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_HARDWARE_DFS_EXIT_WAKEUP_EN			0x2000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_DFS_COMPLETE_WAKEUP_EN			0x1000
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_DFS_ERROR_WAKEUP_EN				0x800
#define MASK_AON_APB_RF_SP_INT_REQ_PUB_DFS_GIVEUP_EN				0x400
#define MASK_AON_APB_RF_SP_INT_REQ_CLK_32K_DET_WAKEUP_EN				0x200
#define MASK_AON_APB_RF_SP_INT_REQ_AON_I2C_WAKEUP_EN				0x100
#define MASK_AON_APB_RF_SP_INT_REQ_THM0_WAKEUP_EN					0x80
#define MASK_AON_APB_RF_SP_INT_REQ_PWR_UP_PUB_WAKEUP_EN				0x40
#define MASK_AON_APB_RF_SP_INT_REQ_PWR_UP_AP_WAKEUP_EN				0x20
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_TMC_WAKEUP_EN				0x10
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_DAP_MTX_WAKEUP_EN			0x8
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_NR_WAKEUP_EN				0x4
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_AP_WAKEUP_EN				0x2
#define MASK_AON_APB_RF_SP_INT_REQ_BUSMON_V3_WAKEUP_EN				0x1
#define MASK_AON_APB_RF_SP_INT_REQ_DFS_VOTE_DONE_WAKEUP_EN				0x200
#define MASK_AON_APB_RF_SP_INT_REQ_THM2_WAKEUP_EN					0x100
#define MASK_AON_APB_RF_SP_INT_REQ_THM1_WAKEUP_EN					0x80
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_TMR2_WAKEUP_EN				0x40
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_TMR1_WAKEUP_EN				0x20
#define MASK_AON_APB_RF_SP_INT_REQ_CM4_TMR0_WAKEUP_EN				0x10
#define MASK_AON_APB_RF_SP_INT_REQ_EXT_RSTB_SPCPU_WAKEUP_EN			0x8
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_WDG_RST_WAKEUP_EN				0x2
#define MASK_AON_APB_RF_SP_INT_REQ_AUDCP_VBC_AUDPLY_WAKEUP_EN			0x1
#define MASK_AON_APB_RF_V3PS_SIM2_AON_TOP_SOFT_RST					0x200000
#define MASK_AON_APB_RF_V3PS_SIM1_AON_TOP_SOFT_RST					0x100000
#define MASK_AON_APB_RF_V3PS_SIM0_AON_TOP_SOFT_RST					0x80000
#define MASK_AON_APB_RF_WCN_ADDA_TEST_SOFT_RST					0x40000
#define MASK_AON_APB_RF_RTM_SOFT_RST						0x20000
#define MASK_AON_APB_RF_SERDES2_SOFT_RST						0x10000
#define MASK_AON_APB_RF_SERDES1_SOFT_RST						0x8000
#define MASK_AON_APB_RF_SERDES0_SOFT_RST						0x4000
#define MASK_AON_APB_RF_SERDES_DPHY2_APB_SOFT_RST					0x2000
#define MASK_AON_APB_RF_SERDES_DPHY2_SOFT_RST					0x1000
#define MASK_AON_APB_RF_SERDES_DPHY1_APB_SOFT_RST					0x800
#define MASK_AON_APB_RF_SERDES_DPHY1_SOFT_RST					0x400
#define MASK_AON_APB_RF_SERDES_DPHY0_APB_SOFT_RST					0x200
#define MASK_AON_APB_RF_SERDES_DPHY0_SOFT_RST					0x100
#define MASK_AON_APB_RF_DAP_MTX_SOFT_RST						0x40
#define MASK_AON_APB_RF_AON_NR_SPI_SOFT_RST					0x10
#define MASK_AON_APB_RF_BB_CAL_SOFT_RST						0x8
#define MASK_AON_APB_RF_DCXO_LC_SOFT_RST						0x4
#define MASK_AON_APB_RF_AON_SPI_SOFT_RST						0x2
#define MASK_AON_APB_RF_RC100M_CAL_SOFT_RST					0x1
#define MASK_AON_APB_RF_AON_RFSPI_SLV_NR_SOFT_RST					0x10000000
#define MASK_AON_APB_RF_AON_RFSPI_SLV_V3_SOFT_RST					0x8000000
#define MASK_AON_APB_RF_PMU_APB_BUSMON_SOFT_RST					0x4000000
#define MASK_AON_APB_RF_AON_APB_BUSMON_SOFT_RST					0x2000000
#define MASK_AON_APB_RF_CSSYS_SOFT_RST						0x1000000
#define MASK_AON_APB_RF_BSMTMR_SOFT_RST						0x800000
#define MASK_AON_APB_RF_APB_DIRECT_ACC_PROT_AON_APB_SOFT_RST			0x400000
#define MASK_AON_APB_RF_APB_DIRECT_ACC_PROT_PMU_APB_SOFT_RST			0x200000
#define MASK_AON_APB_RF_SCC_SOFT_RST						0x100000
#define MASK_AON_APB_RF_DEBUG_FILTER_SOFT_RST					0x80000
#define MASK_AON_APB_RF_APB_DIRECT_ACC_PROT_SOFT_RST				0x40000
#define MASK_AON_APB_RF_APCPU_TS0_SOFT_RST						0x20000
#define MASK_AON_APB_RF_DJTAG_CTRL_SOFT_RST					0x10000
#define MASK_AON_APB_RF_SEC_32K_DET_SOFT_RST					0x4000
#define MASK_AON_APB_RF_CKG_SOFT_RST						0x2000
#define MASK_AON_APB_RF_ANA_SOFT_RST						0x1000
#define MASK_AON_APB_RF_PIN_SOFT_RST						0x800
#define MASK_AON_APB_RF_SPLK_SOFT_RST						0x400
#define MASK_AON_APB_RF_APCPU_CLK_RF_SOFT_RST					0x100
#define MASK_AON_APB_RF_DVFS_TOP_SOFT_RST						0x80
#define MASK_AON_APB_RF_AON_TMR_SOFT_RST						0x40
#define MASK_AON_APB_RF_AP_SYST_SOFT_RST						0x20
#define MASK_AON_APB_RF_AON_SYST_SOFT_RST						0x10
#define MASK_AON_APB_RF_KPD_SOFT_RST						0x8
#define MASK_AON_APB_RF_MBOX_SOFT_RST						0x4
#define MASK_AON_APB_RF_GPIO_SOFT_RST						0x2
#define MASK_AON_APB_RF_EFUSE_SOFT_RST						0x1
#define MASK_AON_APB_RF_APCPU_WDG_SOFT_RST						0x80000000
#define MASK_AON_APB_RF_AP_WDG_SOFT_RST						0x40000000
#define MASK_AON_APB_RF_AP_TMR2_SOFT_RST						0x20000000
#define MASK_AON_APB_RF_AP_TMR1_SOFT_RST						0x10000000
#define MASK_AON_APB_RF_AP_TMR0_SOFT_RST						0x8000000
#define MASK_AON_APB_RF_THM2_SOFT_RST						0x2000000
#define MASK_AON_APB_RF_NR_INTC_SOFT_RST						0x1000000
#define MASK_AON_APB_RF_NR_DSP1_INTC_SOFT_RST					0x800000
#define MASK_AON_APB_RF_NR_DSP0_INTC_SOFT_RST					0x400000
#define MASK_AON_APB_RF_NR_CR8_INTC_SOFT_RST					0x200000
#define MASK_AON_APB_RF_V3PHY_INTC_SOFT_RST					0x100000
#define MASK_AON_APB_RF_V3PS_INTC_SOFT_RST						0x80000
#define MASK_AON_APB_RF_V3MODEM_INTC_SOFT_RST					0x40000
#define MASK_AON_APB_RF_PSCP_INTC_SOFT_RST						0x20000
#define MASK_AON_APB_RF_AUDCP_INTC_SOFT_RST					0x10000
#define MASK_AON_APB_RF_AP_INTC5_SOFT_RST						0x8000
#define MASK_AON_APB_RF_AP_INTC4_SOFT_RST						0x4000
#define MASK_AON_APB_RF_AP_INTC3_SOFT_RST						0x2000
#define MASK_AON_APB_RF_AP_INTC2_SOFT_RST						0x1000
#define MASK_AON_APB_RF_AP_INTC1_SOFT_RST						0x800
#define MASK_AON_APB_RF_AP_INTC0_SOFT_RST						0x400
#define MASK_AON_APB_RF_EIC_SOFT_RST						0x200
#define MASK_AON_APB_RF_ADI_SOFT_RST						0x100
#define MASK_AON_APB_RF_PMU_SOFT_RST						0x80
#define MASK_AON_APB_RF_I2C_SOFT_RST						0x40
#define MASK_AON_APB_RF_PSCP_SIM2_AON_TOP_SOFT_RST					0x20
#define MASK_AON_APB_RF_PSCP_SIM1_AON_TOP_SOFT_RST					0x10
#define MASK_AON_APB_RF_PSCP_SIM0_AON_TOP_SOFT_RST					0x8
#define MASK_AON_APB_RF_AP_SIM_AON_TOP_SOFT_RST					0x4
#define MASK_AON_APB_RF_THM1_SOFT_RST						0x2
#define MASK_AON_APB_RF_THM0_SOFT_RST						0x1
#define MASK_AON_APB_RF_DJTAG_SOFT_RST						0x400
#define MASK_AON_APB_RF_DJTAG_PUB0_SOFT_RST					0x200
#define MASK_AON_APB_RF_DJTAG_AON_SOFT_RST						0x100
#define MASK_AON_APB_RF_DJTAG_AUDCP_SOFT_RST					0x80
#define MASK_AON_APB_RF_DJTAG_V3_SOFT_RST						0x40
#define MASK_AON_APB_RF_DJTAG_PSCP_SOFT_RST					0x20
#define MASK_AON_APB_RF_DJTAG_NRCP_SOFT_RST					0x10
#define MASK_AON_APB_RF_DJTAG_APCPU_SOFT_RST					0x2
#define MASK_AON_APB_RF_DJTAG_AP_SOFT_RST						0x1
#define MASK_AON_APB_RF_CM4_SYS_SOFT_RST						0x10
#define MASK_AON_APB_RF_CM4_CORE_SOFT_RST						0x1
#define MASK_AON_APB_RF_PSCP_CR8_BLK_CORE_SOFT_RST					0x4000
#define MASK_AON_APB_RF_PSCP_CR8_CORE_SOFT_RST					0x3000
#define MASK_AON_APB_RF_PSCP_CR8_BLK_DBG_SOFT_RST					0x800
#define MASK_AON_APB_RF_PSCP_CR8_DBG_SOFT_RST					0x600
#define MASK_AON_APB_RF_PSCP_CR8_ETM_SOFT_RST					0x100
#define MASK_AON_APB_RF_PSCP_CR8_MP_SOFT_RST					0x80
#define MASK_AON_APB_RF_PSCP_CR8_CS_DBG_SOFT_RST					0x40
#define MASK_AON_APB_RF_PSCP_TMR_SOFT_RST						0x20
#define MASK_AON_APB_RF_PSCP_SYST_SOFT_RST						0x10
#define MASK_AON_APB_RF_PSCP_WDG_SOFT_RST						0x8
#define MASK_AON_APB_RF_CPALL_EIC_SOFT_RST						0x4
#define MASK_AON_APB_RF_NRCP_CR8_BLK_CORE_SOFT_RST					0x4000
#define MASK_AON_APB_RF_NRCP_CR8_CORE_SOFT_RST					0x3000
#define MASK_AON_APB_RF_NRCP_CR8_BLK_DBG_SOFT_RST					0x800
#define MASK_AON_APB_RF_NRCP_CR8_DBG_SOFT_RST					0x600
#define MASK_AON_APB_RF_V3_PS_CR5_DBG_SW_RST					0x4
#define MASK_AON_APB_RF_V3_PS_CR5_BLK_SW_RST					0x2
#define MASK_AON_APB_RF_V3_PS_CR5_CORE_SW_RST					0x1
#define MASK_AON_APB_RF_V3_PHY_CR5_DBG_SW_RST					0x4
#define MASK_AON_APB_RF_V3_PHY_CR5_BLK_SW_RST					0x2
#define MASK_AON_APB_RF_V3_PHY_CR5_CORE_SW_RST					0x1
#define MASK_AON_APB_RF_AP_WDG_RST_FLAG						0x200
#define MASK_AON_APB_RF_PCP_WDG_RST_FLAG						0x100
#define MASK_AON_APB_RF_NR_DSP1_WDG_RST_FLAG					0x80
#define MASK_AON_APB_RF_NR_DSP0_WDG_RST_FLAG					0x40
#define MASK_AON_APB_RF_NR_CR8_WDG_RST_FLAG					0x20
#define MASK_AON_APB_RF_V3_PS_CR5_WDG_RST_FLAG					0x10
#define MASK_AON_APB_RF_V3_PHY_CR5_WDG_RST_FLAG					0x8
#define MASK_AON_APB_RF_AUDCP_WDG_RST_FLAG						0x4
#define MASK_AON_APB_RF_APCPU_WDG_RST_FLAG						0x2
#define MASK_AON_APB_RF_SEC_WDG_RST_FLAG						0x1
#define MASK_AON_APB_RF_APCPU_CSSYS_APB_SOFT_RST					0x400
#define MASK_AON_APB_RF_APCPU_CSSYS_SOFT_RST					0x200
#define MASK_AON_APB_RF_APCPU_SCU_SOFT_RST						0x100
#define MASK_AON_APB_RF_APCPU_DEBUG_APB_SOFT_RST					0x80
#define MASK_AON_APB_RF_APCPU_PERIPH_SOFT_RST					0x40
#define MASK_AON_APB_RF_APCPU_GIC_SOFT_RST						0x20
#define MASK_AON_APB_RF_APCPU_ATB_SOFT_RST						0x10
#define MASK_AON_APB_RF_APCPU_CORE_SOFT_RST					0x3
#define MASK_AON_APB_RF_PTEST_FUNC_ATSPEED_SEL					0x100
#define MASK_AON_APB_RF_PTEST_FUNC_MODE						0x80
#define MASK_AON_APB_RF_FUNCTST_DMA_EB						0x40
#define MASK_AON_APB_RF_PTEST_BIST_MODE						0x20
#define MASK_AON_APB_RF_USB_DLOAD_EN						0x10
#define MASK_AON_APB_RF_ARM_BOOT_MD3						0x8
#define MASK_AON_APB_RF_ARM_BOOT_MD2						0x4
#define MASK_AON_APB_RF_ARM_BOOT_MD1						0x2
#define MASK_AON_APB_RF_ARM_BOOT_MD0						0x1
#define MASK_AON_APB_RF_AGCP_DSP_JTAG_MODE						0x8
#define MASK_AON_APB_RF_CP_ARM_JTAG_PIN_SEL					0x7
#define MASK_AON_APB_RF_RF_RTC_CAL_CTL						0x1fc00000
#define MASK_AON_APB_RF_RF_RTC_CAL_SEL						0x200000
#define MASK_AON_APB_RF_RF_RTC_CAL_PRECISION					0x1fe000
#define MASK_AON_APB_RF_RC100M_DIV							0x1f80
#define MASK_AON_APB_RF_RC100M_CAL_DONE						0x40
#define MASK_AON_APB_RF_RC100M_CAL_START						0x20
#define MASK_AON_APB_RF_RC100M_ANA_SOFT_RST					0x10
#define MASK_AON_APB_RF_RC100M_FORCE_EN						0x2
#define MASK_AON_APB_RF_RC100M_AUTO_GATE_EN					0x1
#define MASK_AON_APB_RF_ANALOG_PLL_RSV						0xffff0000
#define MASK_AON_APB_RF_ANALOG_TESTMUX						0xffff
#define MASK_AON_APB_RF_PLL_BG_RSV							0x3f
#define MASK_AON_APB_RF_FUSEBOX_SEL_CTRL						0x2
#define MASK_AON_APB_RF_FUSEBOX_SEL_BUF_SW						0x1
#define MASK_AON_APB_RF_OTG_ATERESET						0x80000000
#define MASK_AON_APB_RF_OTG_VBUS_VALID_PHYREG					0x1000000
#define MASK_AON_APB_RF_OTG_VBUS_VALID_PHYREG_SEL					0x800000
#define MASK_AON_APB_RF_OTG_VBUS_VALID_EXT						0x400000
#define MASK_AON_APB_RF_OTG_TESTBURNIN						0x200000
#define MASK_AON_APB_RF_OTG_LOOPBACKENB						0x100000
#define MASK_AON_APB_RF_OTG_TESTDATAOUT						0xf0000
#define MASK_AON_APB_RF_OTG_VATESTENB						0xc000
#define MASK_AON_APB_RF_OTG_TESTCLK						0x2000
#define MASK_AON_APB_RF_OTG_TESTDATAOUTSEL						0x1000
#define MASK_AON_APB_RF_OTG_TESTADDR						0xf00
#define MASK_AON_APB_RF_OTG_TESTDATAIN						0xff
#define MASK_AON_APB_RF_USB2_CON_TESTMODE						0x80000000
#define MASK_AON_APB_RF_UTMI_WIDTH_SEL						0x40000000
#define MASK_AON_APB_RF_USB2_DATABUS16_8						0x20000000
#define MASK_AON_APB_RF_OTG_SS_SCALEDOWNMODE					0x6000000
#define MASK_AON_APB_RF_OTG_TXBITSTUFFENH						0x800000
#define MASK_AON_APB_RF_OTG_TXBITSTUFFEN						0x400000
#define MASK_AON_APB_RF_OTG_DMPULLDOWN						0x200000
#define MASK_AON_APB_RF_OTG_DPPULLDOWN						0x100000
#define MASK_AON_APB_RF_OTG_DMPULLUP						0x200
#define MASK_AON_APB_RF_OTG_COMMONONN						0x100
#define MASK_AON_APB_RF_USB2_PHY_IDDIG						0x8
#define MASK_AON_APB_RF_OTG_FSEL							0x7
#define MASK_AON_APB_RF_USB20_TUNEHSAMP						0xc0000000
#define MASK_AON_APB_RF_USB20_TUNEPLLS						0x30000000
#define MASK_AON_APB_RF_USB20_TUNERISE						0xc000000
#define MASK_AON_APB_RF_USB20_TUNEDSC						0x3000000
#define MASK_AON_APB_RF_USB20_TUNEOTG						0xe00000
#define MASK_AON_APB_RF_USB20_TUNESQ						0x1e0000
#define MASK_AON_APB_RF_USB20_RESERVED						0xffff
#define MASK_AON_APB_RF_USB20_BIST_MODE						0xf800000
#define MASK_AON_APB_RF_USB20_BYPASS_DRV_DM					0x400000
#define MASK_AON_APB_RF_USB20_BYPASS_DRV_DP					0x200000
#define MASK_AON_APB_RF_USB20_SAMPLER_SEL						0x100000
#define MASK_AON_APB_RF_HSIC_PLLON							0x10000
#define MASK_AON_APB_RF_USB20_REXTENABLE						0x8000
#define MASK_AON_APB_RF_USB20_S_ID							0x4000
#define MASK_AON_APB_RF_USB20_TFREGRES						0x3f00
#define MASK_AON_APB_RF_USB20_TFHSRES						0xf8
#define MASK_AON_APB_RF_USB20_TUNEEQ						0x7
#define MASK_AON_APB_RF_USB_REF_CLK_MUX_SEL					0x1
#define MASK_AON_APB_RF_V3_LVDSRF_ISO_EN						0x4
#define MASK_AON_APB_RF_V3_LVDSRF_PD_PD_L						0x2
#define MASK_AON_APB_RF_V3_LVDSRF_PS_PD_S						0x1
#define MASK_AON_APB_RF_NR_LVDSRF_ISO_EN						0x4
#define MASK_AON_APB_RF_NR_LVDSRF_PD_PD_L						0x2
#define MASK_AON_APB_RF_NR_LVDSRF_PS_PD_S						0x1
#define MASK_AON_APB_RF_RAM_LS_WCN_ADDA_TEST_0					0x4
#define MASK_AON_APB_RF_RAM_RET_WCN_ADDA_TEST_0					0x2
#define MASK_AON_APB_RF_RAM_PD_WCN_ADDA_TEST_0					0x1
#define MASK_AON_APB_RF_THM0_CALI_RSVD						0xff
#define MASK_AON_APB_RF_THM1_CALI_RSVD						0xff
#define MASK_AON_APB_RF_THM2_INT_ADIE_EN						0x400
#define MASK_AON_APB_RF_THM1_INT_ADIE_EN						0x200
#define MASK_AON_APB_RF_THM0_INT_ADIE_EN						0x100
#define MASK_AON_APB_RF_THM2_OVERHEAT_ALARM_ADIE_EN				0x40
#define MASK_AON_APB_RF_THM1_OVERHEAT_ALARM_ADIE_EN				0x20
#define MASK_AON_APB_RF_THM0_OVERHEAT_ALARM_ADIE_EN				0x10
#define MASK_AON_APB_RF_THM2_OVERHEAT_RST_DDIE_EN					0x4
#define MASK_AON_APB_RF_THM1_OVERHEAT_RST_DDIE_EN					0x2
#define MASK_AON_APB_RF_THM0_OVERHEAT_RST_DDIE_EN					0x1
#define MASK_AON_APB_RF_CGM_MPLL0_APCPU_FORCE_EN					0x200
#define MASK_AON_APB_RF_CGM_MPLL0_APCPU_AUTO_GATE_SEL				0x100
#define MASK_AON_APB_RF_MPLL0_WAIT_FORCE_EN					0x4
#define MASK_AON_APB_RF_MPLL0_WAIT_AUTO_GATE_SEL					0x2
#define MASK_AON_APB_RF_MPLL0_SOFT_CNT_DONE					0x1
#define MASK_AON_APB_RF_CGM_MPLL1_APCPU_FORCE_EN					0x200
#define MASK_AON_APB_RF_CGM_MPLL1_APCPU_AUTO_GATE_SEL				0x100
#define MASK_AON_APB_RF_MPLL1_WAIT_FORCE_EN					0x4
#define MASK_AON_APB_RF_MPLL1_WAIT_AUTO_GATE_SEL					0x2
#define MASK_AON_APB_RF_MPLL1_SOFT_CNT_DONE					0x1
#define MASK_AON_APB_RF_NR_RPLL_POSTDIV_REG					0x100000
#define MASK_AON_APB_RF_NR_RPLL_26M_DIV_REG					0xfc000
#define MASK_AON_APB_RF_NR_RPLL_N_REG						0x3ff8
#define MASK_AON_APB_RF_NR_RPLL_DIV_S_REG						0x4
#define MASK_AON_APB_RF_NR_RPLL_MOD_EN_REG						0x2
#define MASK_AON_APB_RF_NR_RPLL_SDM_EN_REG						0x1
#define MASK_AON_APB_RF_CGM_DPLL1_1600M_PUB_FORCE_EN				0x200
#define MASK_AON_APB_RF_CGM_DPLL0_2666M_PUB_FORCE_EN				0x100
#define MASK_AON_APB_RF_CGM_DPLL1_1600M_PUB_AUTO_GATE_SEL				0x80
#define MASK_AON_APB_RF_CGM_DPLL0_2666M_PUB_AUTO_GATE_SEL				0x40
#define MASK_AON_APB_RF_DPLL1_WAIT_FORCE_EN					0x20
#define MASK_AON_APB_RF_DPLL0_WAIT_FORCE_EN					0x10
#define MASK_AON_APB_RF_DPLL1_WAIT_AUTO_GATE_SEL					0x8
#define MASK_AON_APB_RF_DPLL0_WAIT_AUTO_GATE_SEL					0x4
#define MASK_AON_APB_RF_DPLL1_SOFT_CNT_DONE					0x2
#define MASK_AON_APB_RF_DPLL0_SOFT_CNT_DONE					0x1
#define MASK_AON_APB_RF_REC_26MHZ_0_BUF_PD						0x100
#define MASK_AON_APB_RF_SLEEP_PLLLOCK_SEL						0x80
#define MASK_AON_APB_RF_PLL_LOCK_SEL						0x70
#define MASK_AON_APB_RF_SLEEP_DBG_SEL						0xf
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_2_ENA_ADC				0x80000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_2_ENA_DVFS			0x40000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_2_ENA_CAL				0x20000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_1_ENA_ADC				0x10000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_1_ENA_DVFS			0x8000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_1_ENA_CAL				0x4000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_0_ENA_ADC				0x2000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_0_ENA_DVFS			0x1000
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_0_ENA_CAL				0x800
#define MASK_AON_APB_RF_ANALOG_BB_TOP_SINDRV_2_ENA_AUTO_EN				0x400
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_2_ENA				0x200
#define MASK_AON_APB_RF_ANALOG_BB_TOP_SINDRV_1_ENA_AUTO_EN				0x100
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_1_ENA				0x80
#define MASK_AON_APB_RF_ANALOG_BB_TOP_SINDRV_0_ENA_AUTO_EN				0x40
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_0_ENA				0x20
#define MASK_AON_APB_RF_M2G_ANALOG_BB_TOP_SINDRV_ENA				0x10
#define MASK_AON_APB_RF_R2G_ANALOG_BB_TOP_SINDRV_ENA_SQUARE			0x8
#define MASK_AON_APB_RF_C2G_ANALOG_BB_TOP_CLK26MHZ_AUD_EN				0x4
#define MASK_AON_APB_RF_C2G_ANALOG_USB20_USB20_PS_PD_S				0x2
#define MASK_AON_APB_RF_C2G_ANALOG_USB20_USB20_PS_PD_L				0x1
#define MASK_AON_APB_RF_PCIE_PHY_REF_CLK_EN					0x200
#define MASK_AON_APB_RF_DSI_2_PHY_REF_CLK_EN					0x100
#define MASK_AON_APB_RF_DSI_1_PHY_REF_CLK_EN					0x80
#define MASK_AON_APB_RF_DSI_0_PHY_REF_CLK_EN					0x40
#define MASK_AON_APB_RF_U3_1_PHY_SUSPEND_CLK_EN					0x20
#define MASK_AON_APB_RF_U3_1_PHY_REF_CLK_EN					0x10
#define MASK_AON_APB_RF_U3_0_PHY_SUSPEND_CLK_EN					0x8
#define MASK_AON_APB_RF_U3_0_PHY_REF_CLK_EN					0x4
#define MASK_AON_APB_RF_U2_1_PHY_REF_CLK_EN					0x2
#define MASK_AON_APB_RF_U2_0_PHY_REF_CLK_EN					0x1
#define MASK_AON_APB_RF_R2G_NR_RPLL_RST_SEL_SPI_AFC_OR_PMU				0x8
#define MASK_AON_APB_RF_R2G_NR_RPLL_PD_SEL_SPI_AFC_OR_PMU				0x4
#define MASK_AON_APB_RF_R2G_V3_RPLL_RST_SEL_SPI_AFC_OR_PMU				0x2
#define MASK_AON_APB_RF_R2G_V3_RPLL_PD_SEL_SPI_AFC_OR_PMU				0x1
#define MASK_AON_APB_RF_V3_RPLL_FREQ_DOUBEL_EN_REG					0x40000000
#define MASK_AON_APB_RF_V3_RPLL_CP_OFFSET_REG					0x30000000
#define MASK_AON_APB_RF_V3_RPLL_VSET_REG						0xe000000
#define MASK_AON_APB_RF_V3_RPLL_FBDIV_EN_REG					0x1000000
#define MASK_AON_APB_RF_V3_RPLL_VCO_TEST_EN_REG					0x800000
#define MASK_AON_APB_RF_V3_RPLL_LDO_TRIM_REG					0x780000
#define MASK_AON_APB_RF_V3_RPLL_CP_EN_REG						0x40000
#define MASK_AON_APB_RF_V3_RPLL_ICP_REG						0x38000
#define MASK_AON_APB_RF_V3_RPLL_SCC_CTRL_REG					0x7f80
#define MASK_AON_APB_RF_V3_RPLL_REF_SEL_REG					0x60
#define MASK_AON_APB_RF_V3_RPLL_LPF_REG						0x1c
#define MASK_AON_APB_RF_V3_RPLL_IBIAS_REG						0x3
#define MASK_AON_APB_RF_V3_RPLL_RESERVED_REG					0x1fffff
#define MASK_AON_APB_RF_V3_RPLL_POSTDIV_REG					0x100000
#define MASK_AON_APB_RF_V3_RPLL_26M_DIV_REG					0xfc000
#define MASK_AON_APB_RF_V3_RPLL_N_REG						0x3ff8
#define MASK_AON_APB_RF_V3_RPLL_DIV_S_REG						0x4
#define MASK_AON_APB_RF_V3_RPLL_MOD_EN_REG						0x2
#define MASK_AON_APB_RF_V3_RPLL_SDM_EN_REG						0x1
#define MASK_AON_APB_RF_V3_RPLL_KINT_REG						0x3fffff80
#define MASK_AON_APB_RF_V3_RPLL_NINT_REG						0x7f
#define MASK_AON_APB_RF_V3_RPLL_CTRL_SEL_AON_BB_SW_RFSPI				0x100
#define MASK_AON_APB_RF_V3_RPLL_CTRL_SEL_AON_APB					0x1
#define MASK_AON_APB_RF_NR_RPLL_FREQ_DOUBEL_EN_REG					0x40000000
#define MASK_AON_APB_RF_NR_RPLL_CP_OFFSET_REG					0x30000000
#define MASK_AON_APB_RF_NR_RPLL_VSET_REG						0xe000000
#define MASK_AON_APB_RF_NR_RPLL_FBDIV_EN_REG					0x1000000
#define MASK_AON_APB_RF_NR_RPLL_VCO_TEST_EN_REG					0x800000
#define MASK_AON_APB_RF_NR_RPLL_LDO_TRIM_REG					0x780000
#define MASK_AON_APB_RF_NR_RPLL_CP_EN_REG						0x40000
#define MASK_AON_APB_RF_NR_RPLL_ICP_REG						0x38000
#define MASK_AON_APB_RF_NR_RPLL_SCC_CTRL_REG					0x7f80
#define MASK_AON_APB_RF_NR_RPLL_REF_SEL_REG					0x60
#define MASK_AON_APB_RF_NR_RPLL_LPF_REG						0x1c
#define MASK_AON_APB_RF_NR_RPLL_IBIAS_REG						0x3
#define MASK_AON_APB_RF_NR_RPLL_RESERVED_REG					0x1fffff
#define MASK_AON_APB_RF_NR_RPLL_KINT_REG						0x3fffff80
#define MASK_AON_APB_RF_NR_RPLL_NINT_REG						0x7f
#define MASK_AON_APB_RF_NR_RPLL_CTRL_SEL_BB_SW_SPI					0x100
#define MASK_AON_APB_RF_NR_RPLL_CTRL_SEL_AON_APB					0x1
#define MASK_AON_APB_RF_RFSPI_SEL_AON_NR_RFSPI					0x2
#define MASK_AON_APB_RF_RFSPI_SEL_AON_RFSPI					0x1
#define MASK_AON_APB_RF_NR_BB_SW_RFSPI_FIFO1_FULL					0x800
#define MASK_AON_APB_RF_NR_BB_SW_RFSPI_FIFO1_EMPTY					0x400
#define MASK_AON_APB_RF_NR_BB_SW_RFSPI_FIFO0_FULL					0x200
#define MASK_AON_APB_RF_NR_BB_SW_RFSPI_FIFO0_EMPTY					0x100
#define MASK_AON_APB_RF_V3_BB_SW_RFSPI_FIFO1_FULL					0x8
#define MASK_AON_APB_RF_V3_BB_SW_RFSPI_FIFO1_EMPTY					0x4
#define MASK_AON_APB_RF_V3_BB_SW_RFSPI_FIFO0_FULL					0x2
#define MASK_AON_APB_RF_V3_BB_SW_RFSPI_FIFO0_EMPTY					0x1
#define MASK_AON_APB_RF_NR_RPLL_RST_SEL_SPI_AFC					0x8
#define MASK_AON_APB_RF_NR_RPLL_PD_SEL_SPI_AFC					0x4
#define MASK_AON_APB_RF_V3_RPLL_RST_SEL_SPI_AFC					0x2
#define MASK_AON_APB_RF_V3_RPLL_PD_SEL_SPI_AFC					0x1
#define MASK_AON_APB_RF_CLK_AUD26M_EN_DVFS_AUDIO					0x10
#define MASK_AON_APB_RF_CLK_AUD26M_EN_DVFS_CP_ADC					0x8
#define MASK_AON_APB_RF_CLK_AUD26M_EN_AP_ADC					0x4
#define MASK_AON_APB_RF_CLK_AUD26M_EN_CALIBRATION					0x2
#define MASK_AON_APB_RF_CLK_AUD26M_EN_DVFS						0x1
#define MASK_AON_APB_RF_DBG_TRACE_CTRL_EN						0x10000
#define MASK_AON_APB_RF_EVENTACK_RESTARTREQ_TS01					0x10
#define MASK_AON_APB_RF_EVENT_RESTARTREQ_TS01					0x2
#define MASK_AON_APB_RF_EVENT_HALTREQ_TS01						0x1
#define MASK_AON_APB_RF_DCXO_LC_FLAG						0x100
#define MASK_AON_APB_RF_DCXO_LC_FLAG_CLR						0x2
#define MASK_AON_APB_RF_DCXO_LC_CNT_CLR						0x1
#define MASK_AON_APB_RF_DCXO_LC_CNT						0xffffffff
#define MASK_AON_APB_RF_AUDCP_BOOTCTRL_PROT					0x80000000
#define MASK_AON_APB_RF_AUDCP_REG_PROT_VAL						0xffff
#define MASK_AON_APB_RF_NR_DSP0_CTRL_PROT						0x80000000
#define MASK_AON_APB_RF_NR_DSP0_REG_PROT_VAL					0xffff
#define MASK_AON_APB_RF_NR_DSP1_CTRL_PROT						0x80000000
#define MASK_AON_APB_RF_NR_DSP1_REG_PROT_VAL					0xffff
#define MASK_AON_APB_RF_DAP_DBGPWRUP_SOFT_EN					0x4
#define MASK_AON_APB_RF_DAP_SYSPWRUP_SOFT_EN					0x2
#define MASK_AON_APB_RF_DAP_DJTAG_EN						0x1
#define MASK_AON_APB_RF_SP_AHB_CLK_SOFT_EN						0x80
#define MASK_AON_APB_RF_CM4_SLEEPING_STAT						0x40
#define MASK_AON_APB_RF_CM4_LOCKUP_STAT						0x20
#define MASK_AON_APB_RF_CM4_SOFT_MPUDIS						0x10
#define MASK_AON_APB_RF_MMTX_SLEEP_CM4_PUB_WR					0x8
#define MASK_AON_APB_RF_MMTX_SLEEP_CM4_PUB_RD					0x4
#define MASK_AON_APB_RF_INT_REQ_CM4_SOFT						0x2
#define MASK_AON_APB_RF_SP_CFG_BUS_SLEEP						0x1
#define MASK_AON_APB_RF_AON_FUNC_CTRL_0						0xffffffff
#define MASK_AON_APB_RF_AON_FUNC_CTRL_1						0xffffffff
#define MASK_AON_APB_RF_FUNC_TEST_BOOT_ADDR					0xffffffff
#define MASK_AON_APB_RF_LEAKAGE_MAGIC_WORD						0xffffffff
#define MASK_AON_APB_RF_LEAKAGE_SWITCH						0x1
#define MASK_AON_APB_RF_AUDCP_DSP_BOOT_VECTOR					0xffffffff
#define MASK_AON_APB_RF_AUDCP_STCK_DSP						0x2000
#define MASK_AON_APB_RF_AUDCP_STMS_DSP						0x1000
#define MASK_AON_APB_RF_AUDCP_STDO_DSP						0x800
#define MASK_AON_APB_RF_AUDCP_STDI_DSP						0x400
#define MASK_AON_APB_RF_AUDCP_STRTCK_DSP						0x200
#define MASK_AON_APB_RF_AUDCP_SW_JTAG_ENA_DSP					0x100
#define MASK_AON_APB_RF_AUDCP_DSP_EXTERNAL_WAIT					0x2
#define MASK_AON_APB_RF_AUDCP_DSP_BOOT						0x1
#define MASK_AON_APB_RF_NR_DSP1_2_AUD_ACCESS_EN					0x200
#define MASK_AON_APB_RF_NR_DSP0_2_AUD_ACCESS_EN					0x100
#define MASK_AON_APB_RF_NR_CR8_2_AUD_ACCESS_EN					0x80
#define MASK_AON_APB_RF_CM4_2_AUD_ACCESS_EN					0x40
#define MASK_AON_APB_RF_AP_2_AUD_ACCESS_EN						0x20
#define MASK_AON_APB_RF_PS_CR8_2_AUD_ACCESS_EN					0x10
#define MASK_AON_APB_RF_V3PS_CR5_2_AUD_ACCESS_EN					0x8
#define MASK_AON_APB_RF_V3PHY_CR8_2_AUD_ACCESS_EN					0x4
#define MASK_AON_APB_RF_AUDCP_FRC_CLK_DSP_EN					0x2
#define MASK_AON_APB_RF_TOP_2_AUD_ACCESS_EN					0x1
#define MASK_AON_APB_RF_V3_AON_FRC_WSYS_LT_STOP					0x10
#define MASK_AON_APB_RF_V3_AON_FRC_WSYS_STOP					0x8
#define MASK_AON_APB_RF_V3_DSP_DEEP_SLEEP_EN					0x4
#define MASK_AON_APB_RF_V3PHY_CR5_SLBTCMSB						0x4000
#define MASK_AON_APB_RF_V3PHY_CR5_TEINIT						0x2000
#define MASK_AON_APB_RF_V3PHY_CR5_CFGNMFI0						0x1000
#define MASK_AON_APB_RF_V3PHY_CR5_CFGIE						0x800
#define MASK_AON_APB_RF_V3PHY_CR5_CFGEE						0x400
#define MASK_AON_APB_RF_V3PHY_CR5_DBGNOCLKSTOP					0x200
#define MASK_AON_APB_RF_V3PHY_CR5_NCPUHALT0					0x100
#define MASK_AON_APB_RF_V3PS_CR5_TEINIT						0x20
#define MASK_AON_APB_RF_V3PS_CR5_CFGNMFI0						0x10
#define MASK_AON_APB_RF_V3PS_CR5_CFGIE						0x8
#define MASK_AON_APB_RF_V3PS_CR5_CFGEE						0x4
#define MASK_AON_APB_RF_V3PS_CR5_DBGNOCLKSTOP					0x2
#define MASK_AON_APB_RF_V3PS_CR5_NCPUHALT0						0x1
#define MASK_AON_APB_RF_V3PS_CR5_AXI_VP_BASE					0xfffff00
#define MASK_AON_APB_RF_V3PS_CR5_AXI_VP_SIZE					0x3e
#define MASK_AON_APB_RF_V3PS_CR5_INITPPX						0x1
#define MASK_AON_APB_RF_V3PHY_CR5_AXI_VP_BASE					0xfffff00
#define MASK_AON_APB_RF_V3PHY_CR5_AXI_VP_SIZE					0x3e
#define MASK_AON_APB_RF_V3PHY_CR5_INITPPX						0x1
#define MASK_AON_APB_RF_PSCP_CR8_FORCE_DIVN_ON					0x200
#define MASK_AON_APB_RF_PSCP_CR8_MFILTEREN						0x100
#define MASK_AON_APB_RF_PSCP_CR8_TEINIT						0xc0
#define MASK_AON_APB_RF_PSCP_CR8_VINITHI						0x30
#define MASK_AON_APB_RF_PSCP_CR8_NMFI						0xc
#define MASK_AON_APB_RF_PSCP_CR8_CFGEE						0x3
#define MASK_AON_APB_RF_NRCP_CR8_FORCE_DIVN_ON					0x200
#define MASK_AON_APB_RF_NRCP_CR8_MFILTEREN						0x100
#define MASK_AON_APB_RF_NRCP_CR8_TEINIT						0xc0
#define MASK_AON_APB_RF_NRCP_CR8_VINITHI						0x30
#define MASK_AON_APB_RF_NRCP_CR8_NMFI						0xc
#define MASK_AON_APB_RF_NRCP_CR8_CFGEE						0x3
#define MASK_AON_APB_RF_NRDSP0_STOP_SD						0x4
#define MASK_AON_APB_RF_NRDSP0_EXTERNAL_WAIT					0x2
#define MASK_AON_APB_RF_NRDSP0_BOOT						0x1
#define MASK_AON_APB_RF_NRDSP1_STOP_SD						0x4
#define MASK_AON_APB_RF_NRDSP1_EXTERNAL_WAIT					0x2
#define MASK_AON_APB_RF_NRDSP1_BOOT						0x1
#define MASK_AON_APB_RF_NRDSP0_BOOT_VECTOR						0xffffffff
#define MASK_AON_APB_RF_NRDSP1_BOOT_VECTOR						0xffffffff
#define MASK_AON_APB_RF_DBGSYS_CSSYS_STM_NSGUAREN					0x10000
#define MASK_AON_APB_RF_DJTAG_SRC_MUX_SEL						0x1
#define MASK_AON_APB_RF_CP_SIM1_CLK_PL						0x20
#define MASK_AON_APB_RF_CP_SIM1_DETECT_EN						0x10
#define MASK_AON_APB_RF_CP_BAT1_DETECT_EN						0x8
#define MASK_AON_APB_RF_CP_SIM1_DETECT_POL						0x4
#define MASK_AON_APB_RF_CP_BAT1_DETECT_POL						0x2
#define MASK_AON_APB_RF_CP_SIM1_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_CP_SIM2_CLK_PL						0x20
#define MASK_AON_APB_RF_CP_SIM2_DETECT_EN						0x10
#define MASK_AON_APB_RF_CP_BAT2_DETECT_EN						0x8
#define MASK_AON_APB_RF_CP_SIM2_DETECT_POL						0x4
#define MASK_AON_APB_RF_CP_BAT2_DETECT_POL						0x2
#define MASK_AON_APB_RF_CP_SIM2_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_CP_SIM3_CLK_PL						0x20
#define MASK_AON_APB_RF_CP_SIM3_DETECT_EN						0x10
#define MASK_AON_APB_RF_CP_BAT3_DETECT_EN						0x8
#define MASK_AON_APB_RF_CP_SIM3_DETECT_POL						0x4
#define MASK_AON_APB_RF_CP_BAT3_DETECT_POL						0x2
#define MASK_AON_APB_RF_CP_SIM3_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_AP_SIM_CLK_PL						0x20
#define MASK_AON_APB_RF_AP_SIM_DETECT_EN						0x10
#define MASK_AON_APB_RF_AP_BAT_DETECT_EN						0x8
#define MASK_AON_APB_RF_AP_SIM_DETECT_POL						0x4
#define MASK_AON_APB_RF_AP_BAT_DETECT_POL						0x2
#define MASK_AON_APB_RF_AP_SIM_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_V3_SIM1_CLK_PL						0x20
#define MASK_AON_APB_RF_V3_SIM1_DETECT_EN						0x10
#define MASK_AON_APB_RF_V3_BAT1_DETECT_EN						0x8
#define MASK_AON_APB_RF_V3_SIM1_DETECT_POL						0x4
#define MASK_AON_APB_RF_V3_BAT1_DETECT_POL						0x2
#define MASK_AON_APB_RF_V3_SIM1_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_V3_SIM2_CLK_PL						0x20
#define MASK_AON_APB_RF_V3_SIM2_DETECT_EN						0x10
#define MASK_AON_APB_RF_V3_BAT2_DETECT_EN						0x8
#define MASK_AON_APB_RF_V3_SIM2_DETECT_POL						0x4
#define MASK_AON_APB_RF_V3_BAT2_DETECT_POL						0x2
#define MASK_AON_APB_RF_V3_SIM2_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_V3_SIM3_CLK_PL						0x20
#define MASK_AON_APB_RF_V3_SIM3_DETECT_EN						0x10
#define MASK_AON_APB_RF_V3_BAT3_DETECT_EN						0x8
#define MASK_AON_APB_RF_V3_SIM3_DETECT_POL						0x4
#define MASK_AON_APB_RF_V3_BAT3_DETECT_POL						0x2
#define MASK_AON_APB_RF_V3_SIM3_OFF_PD_EN						0x1
#define MASK_AON_APB_RF_SDIO2_SLICE_EN						0x8
#define MASK_AON_APB_RF_PSCP_SDIO_ENABLE						0x4
#define MASK_AON_APB_RF_V3PS_SDIO_ENABLE						0x2
#define MASK_AON_APB_RF_SDIO_MODULE_SEL						0x1
#define MASK_AON_APB_RF_ARURGENCY_M6						0xc000000
#define MASK_AON_APB_RF_AWURGENCY_M6						0x3000000
#define MASK_AON_APB_RF_ARURGENCY_M5						0xc00000
#define MASK_AON_APB_RF_AWURGENCY_M5						0x300000
#define MASK_AON_APB_RF_ARURGENCY_M4						0xc0000
#define MASK_AON_APB_RF_AWURGENCY_M4						0x30000
#define MASK_AON_APB_RF_ARURGENCY_M3						0xc000
#define MASK_AON_APB_RF_AWURGENCY_M3						0x3000
#define MASK_AON_APB_RF_ARURGENCY_M2						0xc00
#define MASK_AON_APB_RF_AWURGENCY_M2						0x300
#define MASK_AON_APB_RF_ARURGENCY_M1						0xc0
#define MASK_AON_APB_RF_AWURGENCY_M1						0x30
#define MASK_AON_APB_RF_ARURGENCY_M0						0xc
#define MASK_AON_APB_RF_AWURGENCY_M0						0x3
#define MASK_AON_APB_RF_ARURGENCY_AON_MAIN_MTX					0xc
#define MASK_AON_APB_RF_AWURGENCY_AON_MAIN_MTX					0x3
#define MASK_AON_APB_RF_NR_DSP0_BOOT_VECTOR					0xffffffff
#define MASK_AON_APB_RF_NR_DSP0_STCK_DSP						0x2000
#define MASK_AON_APB_RF_NR_DSP0_STMS_DSP						0x1000
#define MASK_AON_APB_RF_NR_DSP0_STDO_DSP						0x800
#define MASK_AON_APB_RF_NR_DSP0_STDI_DSP						0x400
#define MASK_AON_APB_RF_NR_DSP0_STRTCK_DSP						0x200
#define MASK_AON_APB_RF_NR_DSP0_SW_JTAG_ENA_DSP					0x100
#define MASK_AON_APB_RF_NR_DSP0_DSP_EXTERNAL_WAIT					0x2
#define MASK_AON_APB_RF_NR_DSP0_DSP_BOOT						0x1
#define MASK_AON_APB_RF_NR_DSP1_BOOT_VECTOR					0xffffffff
#define MASK_AON_APB_RF_NR_DSP1_STCK_DSP						0x2000
#define MASK_AON_APB_RF_NR_DSP1_STMS_DSP						0x1000
#define MASK_AON_APB_RF_NR_DSP1_STDO_DSP						0x800
#define MASK_AON_APB_RF_NR_DSP1_STDI_DSP						0x400
#define MASK_AON_APB_RF_NR_DSP1_STRTCK_DSP						0x200
#define MASK_AON_APB_RF_NR_DSP1_SW_JTAG_ENA_DSP					0x100
#define MASK_AON_APB_RF_NR_DSP1_DSP_EXTERNAL_WAIT					0x2
#define MASK_AON_APB_RF_NR_DSP1_DSP_BOOT						0x1
#define MASK_AON_APB_RF_SDIO_SLV_ADDR_OFFSET					0x1
#define MASK_AON_APB_RF_APCPU_PWAKEUPDBG_FORCE_OON					0x10
#define MASK_AON_APB_RF_APCPU_GICP_ALLOW_NS					0x8
#define MASK_AON_APB_RF_APCPU_GICT_ALLOW_NS					0x4
#define MASK_AON_APB_RF_APCPU_GICCDISABLE						0x2
#define MASK_AON_APB_RF_APCPU_CRYPTDODISABLE					0x1
#define MASK_AON_APB_RF_SP_AON_DDR_EXTEND						0x3
#define MASK_AON_APB_RF_CGM_AON_APB_LP_SEL						0x7
#define MASK_AON_APB_RF_CGM_AP_AXI_APCPU_AUTO_GATE_SEL				0x80000000
#define MASK_AON_APB_RF_CGM_EMC_FORCE_EN						0x10000000
#define MASK_AON_APB_RF_CGM_EMC_AUTO_GATE_SEL					0x8000000
#define MASK_AON_APB_RF_CGM_AON_APB_PUB_FORCE_EN					0x1000000
#define MASK_AON_APB_RF_CGM_AON_APB_PUB_AUTO_GATE_SEL				0x800000
#define MASK_AON_APB_RF_CGM_AON_APB_AUDCP_FORCE_EN					0x400000
#define MASK_AON_APB_RF_CGM_AON_APB_AUDCP_AUTO_GATE_SEL				0x200000
#define MASK_AON_APB_RF_CGM_AON_APB_PSCP_FORCE_EN					0x100000
#define MASK_AON_APB_RF_CGM_AON_APB_PSCP_AUTO_GATE_SEL				0x80000
#define MASK_AON_APB_RF_CGM_AON_APB_V3_FORCE_EN					0x40000
#define MASK_AON_APB_RF_CGM_AON_APB_V3_AUTO_GATE_SEL				0x20000
#define MASK_AON_APB_RF_CGM_AON_APB_NR_FORCE_EN					0x10000
#define MASK_AON_APB_RF_CGM_AON_APB_NR_AUTO_GATE_SEL				0x8000
#define MASK_AON_APB_RF_CGM_AON_APB_AP_FORCE_EN					0x4000
#define MASK_AON_APB_RF_CGM_AON_APB_AP_AUTO_GATE_SEL				0x2000
#define MASK_AON_APB_RF_CGM_AP_AXI_FORCE_EN					0x1000
#define MASK_AON_APB_RF_CGM_AP_AXI_AUTO_GATE_SEL					0x800
#define MASK_AON_APB_RF_CGM_CP1_AXI_AP_FORCE_EN					0x400
#define MASK_AON_APB_RF_CGM_CP1_AXI_AP_AUTO_GATE_SEL				0x200
#define MASK_AON_APB_RF_CGM_CP0_AXI_AP_FORCE_EN					0x100
#define MASK_AON_APB_RF_CGM_CP0_AXI_AP_AUTO_GATE_SEL				0x80
#define MASK_AON_APB_RF_CGM_APCPU_PMU_AUTO_GATE_SEL				0x4
#define MASK_AON_APB_RF_CGM_APCPU_PMU_FORCE_EN					0x2
#define MASK_AON_APB_RF_MBOX_AUTO_GATE_SEL						0x1
#define MASK_AON_APB_RF_CGM_PUB_CLK_ANLG_IO_APB_EN					0x20
#define MASK_AON_APB_RF_CGM_DMC_REF_AUTO_GATE_SEL					0x10
#define MASK_AON_APB_RF_CGM_TOP_DVFS_ROOT_AUTO_GATE_SEL				0x8
#define MASK_AON_APB_RF_CGM_TOP_DVFS_ROOT_FORCE_EN					0x4
#define MASK_AON_APB_RF_CGM_PERIPH_AUTO_GATE_EN					0x2000
#define MASK_AON_APB_RF_CGM_GIC_AUTO_GATE_EN					0x1000
#define MASK_AON_APB_RF_CGM_ACP_AUTO_GATE_EN					0x800
#define MASK_AON_APB_RF_CGM_AXI_PERIPH_AUTO_GATE_EN				0x400
#define MASK_AON_APB_RF_CGM_ACE_AUTO_GATE_EN					0x200
#define MASK_AON_APB_RF_CGM_SCU_AUTO_GATE_EN					0x100
#define MASK_AON_APB_RF_CGM_CORE1_AUTO_GATE_EN					0x2
#define MASK_AON_APB_RF_CGM_CORE0_AUTO_GATE_EN					0x1
#define MASK_AON_APB_RF_V3_FRC_STOP_ACK						0x100
#define MASK_AON_APB_RF_V3_FRC_STOP_REQ						0x1
#define MASK_AON_APB_RF_PSCP_FRC_STOP_ACK						0x100
#define MASK_AON_APB_RF_PSCP_FRC_STOP_REQ						0x1
#define MASK_AON_APB_RF_APCPU_FRC_STOP_ACK						0x200
#define MASK_AON_APB_RF_AP_FRC_STOP_ACK						0x100
#define MASK_AON_APB_RF_APCPU_FRC_STOP_REQ						0x2
#define MASK_AON_APB_RF_AP_FRC_STOP_REQ						0x1
#define MASK_AON_APB_RF_AUDCP_FRC_STOP_ACK						0x100
#define MASK_AON_APB_RF_AUDCP_FRC_STOP_REQ						0x1
#define MASK_AON_APB_RF_NRCP_FRC_STOP_ACK						0x100
#define MASK_AON_APB_RF_NRCP_FRC_STOP_REQ						0x1
#define MASK_AON_APB_RF_CGM_APCPU_AXI_AUTO_FREQ_DOWN_CTRL_SEL			0x8
#define MASK_AON_APB_RF_CGM_APCPU_AXI_AUTO_FREQ_DOWN_EN				0x4
#define MASK_AON_APB_RF_CGM_APCPU_AXI_SEL_IDLE					0x3
#define MASK_AON_APB_RF_APCPU_CORE_WAKEUP_ACE_CLK_EN				0x2
#define MASK_AON_APB_RF_APCPU_CORE_WAKEUP_SCU_CLK_EN				0x1
#define MASK_AON_APB_RF_PUB_APB_FW_EB						0x20000
#define MASK_AON_APB_RF_PUB_REG_EB							0x10000
#define MASK_AON_APB_RF_DMC_EB							0x8000
#define MASK_AON_APB_RF_PHY_VREF_ADJ						0x3fc
#define MASK_AON_APB_RF_PHY_VREF_PD						0x2
#define MASK_AON_APB_RF_PHY_VREF_HI_C						0x1
#define MASK_AON_APB_RF_CGM_RESCUE							0xffffffff
#define MASK_AON_APB_RF_AON_APB_MASTER_BUSY					0x7ffc
#define MASK_AON_APB_RF_AON_APB_FREQ_CTRL_EN					0x2
#define MASK_AON_APB_RF_AON_APB_IDLE_EN						0x1
#define MASK_AON_APB_RF_MONITOR_GATE_AUTO_EN_STATUS				0xf0
#define MASK_AON_APB_RF_MONITOR_WAIT_EN_STATUS					0xf
#define MASK_AON_APB_RF_APCPU_LP_NUM_DEBUG_PWR					0x1fffe
#define MASK_AON_APB_RF_APCPU_LP_EB_DEBUG_PWR					0x1
#define MASK_AON_APB_RF_APCPU_LP_NUM_GIC_COL					0x1fffe
#define MASK_AON_APB_RF_APCPU_LP_EB_GIC_COL					0x1
#define MASK_AON_APB_RF_APCPU_CLUSTER_ATB_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_CLUSTER_ATB_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_CLUSTER_APB_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_CLUSTER_APB_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_CLUSTER_GIC_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_CLUSTER_GIC_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_GIC600_GIC_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_GIC600_GIC_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_DBG_BLK_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_DBG_BLK_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_TOP_MTX_LP_NUM					0x1fffe00
#define MASK_AON_APB_RF_APCPU_TOP_MTX_MIAN_LP_EB					0x100
#define MASK_AON_APB_RF_APCPU_TOP_MTX_S3_LP_EB					0x80
#define MASK_AON_APB_RF_APCPU_TOP_MTX_S2_LP_EB					0x40
#define MASK_AON_APB_RF_APCPU_TOP_MTX_S1_LP_EB					0x20
#define MASK_AON_APB_RF_APCPU_TOP_MTX_S0_LP_EB					0x10
#define MASK_AON_APB_RF_APCPU_TOP_MTX_M3_LP_EB					0x8
#define MASK_AON_APB_RF_APCPU_TOP_MTX_M2_LP_EB					0x4
#define MASK_AON_APB_RF_APCPU_TOP_MTX_M1_LP_EB					0x2
#define MASK_AON_APB_RF_APCPU_TOP_MTX_M0_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_CLUSTER_SCU_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_CLUSTER_SCU_LP_EB					0x1
#define MASK_AON_APB_RF_APCPU_DDR_AB_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_APCPU_DDR_AB_LP_EB						0x1
#define MASK_AON_APB_RF_QOS_DAP_APCPU						0xf00000
#define MASK_AON_APB_RF_QOS_ETR_APCPU						0xf0000
#define MASK_AON_APB_RF_ARQOS_THRESHOLD_APCPU					0xf000
#define MASK_AON_APB_RF_AWQOS_THRESHOLD_APCPU					0xf00
#define MASK_AON_APB_RF_ARQOS_APCPU						0xf0
#define MASK_AON_APB_RF_AWQOS_APCPU						0xf
#define MASK_AON_APB_RF_ARURGENCY_APCPU						0xc000
#define MASK_AON_APB_RF_AWURGENCY_APCPU						0x3000
#define MASK_AON_APB_RF_ARURGENCY_APCPU_M3						0xc00
#define MASK_AON_APB_RF_AWURGENCY_APCPU_M3						0x300
#define MASK_AON_APB_RF_ARURGENCY_APCPU_M2						0xc0
#define MASK_AON_APB_RF_AWURGENCY_APCPU_M2						0x30
#define MASK_AON_APB_RF_ARURGENCY_APCPU_M0						0xc
#define MASK_AON_APB_RF_AWURGENCY_APCPU_M0						0x3
#define MASK_AON_APB_RF_HPROT_DMAW							0xf0
#define MASK_AON_APB_RF_HPROT_DMAR							0xf
#define MASK_AON_APB_RF_APCPU2AP_LP_ACK						0x8
#define MASK_AON_APB_RF_APCPU2AP_LP_FORCE						0x4
#define MASK_AON_APB_RF_DAP2APCPU_LP_ACK						0x2
#define MASK_AON_APB_RF_DAP2APCPU_LP_FORCE						0x1
#define MASK_AON_APB_RF_CM4_TO_AON_AXI_PU_NUM					0x1fe0000
#define MASK_AON_APB_RF_CM4_TO_AON_AXI_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_CM4_TO_AON_AXI_LP_EB					0x1
#define MASK_AON_APB_RF_AON_MTX_MAIN_PU_NUM					0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_MAIN_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_AON_MTX_MAIN_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M0_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M0_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M0_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M1_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M1_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M1_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M2_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M2_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M2_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M3_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M3_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M3_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M4_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M4_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M4_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M5_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M5_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M5_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_M6_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_M6_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_M6_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S0_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S0_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S0_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S1_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S1_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S1_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S2_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S2_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S2_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S3_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S3_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S3_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S4_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S4_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S4_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S5_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S5_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S5_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S6_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S6_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S6_LP_EB						0x1
#define MASK_AON_APB_RF_AON_MTX_S7_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_AON_MTX_S7_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_AON_MTX_S7_LP_EB						0x1
#define MASK_AON_APB_RF_EAXI_MTX_M0_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_EAXI_MTX_M0_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_EAXI_MTX_M0_LP_EB						0x1
#define MASK_AON_APB_RF_EAXI_MTX_M1_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_EAXI_MTX_M1_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_EAXI_MTX_M1_LP_EB						0x1
#define MASK_AON_APB_RF_EAXI_MTX_M2_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_EAXI_MTX_M2_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_EAXI_MTX_M2_LP_EB						0x1
#define MASK_AON_APB_RF_EAXI_MTX_S0_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_EAXI_MTX_S0_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_EAXI_MTX_S0_LP_EB						0x1
#define MASK_AON_APB_RF_EAXI_MTX_S1_PU_NUM						0x1fe0000
#define MASK_AON_APB_RF_EAXI_MTX_S1_LP_NUM						0x1fffe
#define MASK_AON_APB_RF_EAXI_MTX_S1_LP_EB						0x1
#define MASK_AON_APB_RF_EAXI_MTX_MAIN_PU_NUM					0x1fe0000
#define MASK_AON_APB_RF_EAXI_MTX_MAIN_LP_NUM					0x1fffe
#define MASK_AON_APB_RF_EAXI_MTX_MAIN_LP_EB					0x1
#define MASK_AON_APB_RF_U2U3_REF_CLK_SEL						0x18
#define MASK_AON_APB_RF_USB_BUSCLK_SEL_SOC						0x4
#define MASK_AON_APB_RF_USB_DIVN_MUX_SEL						0x2
#define MASK_AON_APB_RF_PCIE_MOD_SEL						0x10000
#define MASK_AON_APB_RF_PCIE_SLV_ADDR_OFFSET					0x3ff
#define MASK_AON_APB_RF_AP_EMMC_IO_POWER_OFF_DELAY					0x2000000
#define MASK_AON_APB_RF_AP_EMMC_IO_POWER_OFF					0x1000000
#define MASK_AON_APB_RF_AP_EMMC_CARDDET_DBNC_THD_32K				0xff0000
#define MASK_AON_APB_RF_AP_EMMC_BATTERY_DBNC_THD_32K				0xff00
#define MASK_AON_APB_RF_AP_EMMC_CARDDET_DBNC_EN_32K				0x80
#define MASK_AON_APB_RF_AP_EMMC_BATTERY_DBNC_EN_32K				0x40
#define MASK_AON_APB_RF_AP_EMMC_BATTERY_DEB_EN_32K					0x20
#define MASK_AON_APB_RF_AP_EMMC_BATTERY_PRESENT_32K				0x10
#define MASK_AON_APB_RF_AP_EMMC_CARD_PROTECT_32K					0x8
#define MASK_AON_APB_RF_AP_EMMC_CARD_PRESENT_32K					0x4
#define MASK_AON_APB_RF_AP_EMMC_BATTERY_DET					0x2
#define MASK_AON_APB_RF_AP_EMMC_CARD_DET						0x1
#define MASK_AON_APB_RF_AP_SDIO1_IO_POWER_OFF_DELAY				0x2000000
#define MASK_AON_APB_RF_AP_SDIO1_IO_POWER_OFF					0x1000000
#define MASK_AON_APB_RF_AP_SDIO1_CARDDET_DBNC_THD_32K				0xff0000
#define MASK_AON_APB_RF_AP_SDIO1_BATTERY_DBNC_THD_32K				0xff00
#define MASK_AON_APB_RF_AP_SDIO1_CARDDET_DBNC_EN_32K				0x80
#define MASK_AON_APB_RF_AP_SDIO1_BATTERY_DBNC_EN_32K				0x40
#define MASK_AON_APB_RF_AP_SDIO1_BATTERY_DEB_EN_32K				0x20
#define MASK_AON_APB_RF_AP_SDIO1_BATTERY_PRESENT_32K				0x10
#define MASK_AON_APB_RF_AP_SDIO1_CARD_PROTECT_32K					0x8
#define MASK_AON_APB_RF_AP_SDIO1_CARD_PRESENT_32K					0x4
#define MASK_AON_APB_RF_AP_SDIO1_BATTERY_DET					0x2
#define MASK_AON_APB_RF_AP_SDIO1_CARD_DET						0x1
#define MASK_AON_APB_RF_PS_SDIO2_IO_POWER_OFF_DELAY				0x2000000
#define MASK_AON_APB_RF_PS_SDIO2_IO_POWER_OFF					0x1000000
#define MASK_AON_APB_RF_PS_SDIO2_CARDDET_DBNC_THD_32K				0xff0000
#define MASK_AON_APB_RF_PS_SDIO2_BATTERY_DBNC_THD_32K				0xff00
#define MASK_AON_APB_RF_PS_SDIO2_CARDDET_DBNC_EN_32K				0x80
#define MASK_AON_APB_RF_PS_SDIO2_BATTERY_DBNC_EN_32K				0x40
#define MASK_AON_APB_RF_PS_SDIO2_BATTERY_DEB_EN_32K				0x20
#define MASK_AON_APB_RF_PS_SDIO2_BATTERY_PRESENT_32K				0x10
#define MASK_AON_APB_RF_PS_SDIO2_CARD_PROTECT_32K					0x8
#define MASK_AON_APB_RF_PS_SDIO2_CARD_PRESENT_32K					0x4
#define MASK_AON_APB_RF_PS_SDIO2_BATTERY_DET					0x2
#define MASK_AON_APB_RF_PS_SDIO2_CARD_DET						0x1
#define MASK_AON_APB_RF_V3PS_SDIO2_IO_POWER_OFF_DELAY				0x2000000
#define MASK_AON_APB_RF_V3PS_SDIO2_IO_POWER_OFF					0x1000000
#define MASK_AON_APB_RF_V3PS_SDIO2_CARDDET_DBNC_THD_32K				0xff0000
#define MASK_AON_APB_RF_V3PS_SDIO2_BATTERY_DBNC_THD_32K				0xff00
#define MASK_AON_APB_RF_V3PS_SDIO2_CARDDET_DBNC_EN_32K				0x80
#define MASK_AON_APB_RF_V3PS_SDIO2_BATTERY_DBNC_EN_32K				0x40
#define MASK_AON_APB_RF_V3PS_SDIO2_BATTERY_DEB_EN_32K				0x20
#define MASK_AON_APB_RF_V3PS_SDIO2_BATTERY_PRESENT_32K				0x10
#define MASK_AON_APB_RF_V3PS_SDIO2_CARD_PROTECT_32K				0x8
#define MASK_AON_APB_RF_V3PS_SDIO2_CARD_PRESENT_32K				0x4
#define MASK_AON_APB_RF_V3PS_SDIO2_BATTERY_DET					0x2
#define MASK_AON_APB_RF_V3PS_SDIO2_CARD_DET					0x1
#define MASK_AON_APB_RF_RVBARADDR0							0xffffffff
#define MASK_AON_APB_RF_RVBARADDR1							0xffffffff
#define MASK_AON_APB_RF_APCPU_ACE_PU_NUM						0xff00
#define MASK_AON_APB_RF_APCPU_MTX_PU_NUM						0xff
#define MASK_AON_APB_RF_APCPU_L3CACHE_RAM_PD_BYPASS				0x1
#define MASK_AON_APB_RF_PU_NUM_AON_TO_AUDCP					0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_AON_TO_AUDCP					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AON_TO_AUDCP						0x1
#define MASK_AON_APB_RF_PU_NUM_AP_TO_NR						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_AP_TO_NR						0x1fffe
#define MASK_AON_APB_RF_LP_EB_AP_TO_NR						0x1
#define MASK_AON_APB_RF_PU_NUM_AP_TO_PSCP						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_AP_TO_PSCP						0x1fffe
#define MASK_AON_APB_RF_LP_EB_AP_TO_PSCP						0x1
#define MASK_AON_APB_RF_PU_NUM_APCPU_TO_AP						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_APCPU_TO_AP						0x1fffe
#define MASK_AON_APB_RF_LP_EB_APCPU_TO_AP						0x1
#define MASK_AON_APB_RF_PU_NUM_NR_TO_AP						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_NR_TO_AP						0x1fffe
#define MASK_AON_APB_RF_LP_EB_NR_TO_AP						0x1
#define MASK_AON_APB_RF_PU_NUM_NR_TO_PSCP						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_NR_TO_PSCP						0x1fffe
#define MASK_AON_APB_RF_LP_EB_NR_TO_PSCP						0x1
#define MASK_AON_APB_RF_PU_NUM_PSCP_TO_AP						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_PSCP_TO_AP						0x1fffe
#define MASK_AON_APB_RF_LP_EB_PSCP_TO_AP						0x1
#define MASK_AON_APB_RF_PU_NUM_PSCP_TO_NR						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_PSCP_TO_NR						0x1fffe
#define MASK_AON_APB_RF_LP_EB_PSCP_TO_NR						0x1
#define MASK_AON_APB_RF_PU_NUM_PSCP_TO_V3						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_PSCP_TO_V3						0x1fffe
#define MASK_AON_APB_RF_LP_EB_PSCP_TO_V3						0x1
#define MASK_AON_APB_RF_LP_NUM_AUDCP_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AUDCP_TO_PUB						0x1
#define MASK_AON_APB_RF_LP_NUM_AON_TO_PUB						0x1fffe
#define MASK_AON_APB_RF_LP_EB_AON_TO_PUB						0x1
#define MASK_AON_APB_RF_LP_NUM_CSSYS_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_CSSYS_TO_PUB						0x1
#define MASK_AON_APB_RF_PU_NUM_APCPU_TO_PUB					0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_APCPU_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_APCPU_TO_PUB						0x1
#define MASK_AON_APB_RF_PU_NUM_AP_TO_PUB						0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_AP_TO_PUB						0x1fffe
#define MASK_AON_APB_RF_LP_EB_AP_TO_PUB						0x1
#define MASK_AON_APB_RF_LP_NUM_NRACC_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_NRACC_TO_PUB						0x1
#define MASK_AON_APB_RF_LP_NUM_NRCPU_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_NRCPU_TO_PUB						0x1
#define MASK_AON_APB_RF_PU_NUM_V3CPU_TO_PUB					0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_V3CPU_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_V3CPU_TO_PUB						0x1
#define MASK_AON_APB_RF_PU_NUM_V3ACC_TO_PUB					0x1fe0000
#define MASK_AON_APB_RF_LP_NUM_V3ACC_TO_PUB					0x1fffe
#define MASK_AON_APB_RF_LP_EB_V3ACC_TO_PUB						0x1
#define MASK_AON_APB_RF_LP_NUM_PSCP_TO_PUB						0x1fffe
#define MASK_AON_APB_RF_LP_EB_PSCP_TO_PUB						0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_AGCP2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_AGCP2EMC					0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_AGCP2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_AGCP2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_AGCP2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_AONSYS2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_AONSYS2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_AONSYS2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_AONSYS2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_AONSYS2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_APCPU2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_APCPU2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_APCPU2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_APCPU2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_APCPU2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_CSSYS2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_CSSYS2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_CSSYS2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_CSSYS2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_CSSYS2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_MINIAP2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_MINIAP2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_MINIAP2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_MINIAP2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_MINIAP2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_NRACC2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_NRACC2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_NRACC2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_NRACC2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_NRACC2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_NRCPU2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_NRCPU2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_NRCPU2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_NRCPU2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_NRCPU2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_V3ACC2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_V3ACC2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_V3ACC2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_V3ACC2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_V3ACC2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_V3CPU2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_V3CPU2EMC				0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_V3CPU2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_V3CPU2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_V3CPU2EMC					0x1
#define MASK_AON_APB_RF_PU_NUM_AB_W_PSCP2EMC					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AB_W_PSCP2EMC					0x40000
#define MASK_AON_APB_RF_LP_FORCE_AB_W_PSCP2EMC					0x20000
#define MASK_AON_APB_RF_LP_NUM_AB_W_PSCP2EMC					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AB_W_PSCP2EMC					0x1
#define MASK_AON_APB_RF_NOBUF_EARLY_RESP_EN					0x4
#define MASK_AON_APB_RF_SCLK_AUTO_GATE_EN						0x2
#define MASK_AON_APB_RF_MCLK_AUTO_GATE_EN						0x1
#define MASK_AON_APB_RF_APCPU_ATB_CLK_DFS_CTRL_DIV					0x2
#define MASK_AON_APB_RF_APCPU_ATB_CLK_DFS_CTRL_SEL					0x1
#define MASK_AON_APB_RF_AON_APB_DFS_SUB_SYS_MASK					0x2
#define MASK_AON_APB_RF_AON_APB_DFS_REG_SLICE_MASK					0x1
#define MASK_AON_APB_RF_PU_NUM_AON_TO_PUB_RF					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_AON_TO_PUB_RF					0x40000
#define MASK_AON_APB_RF_LP_FORCE_AON_TO_PUB_RF					0x20000
#define MASK_AON_APB_RF_LP_NUM_AON_TO_PUB_RF					0x1fffe
#define MASK_AON_APB_RF_LP_EB_AON_TO_PUB_RF					0x1
#define MASK_AON_APB_RF_PU_NUM_EAXI_TO_APCPU					0x7f80000
#define MASK_AON_APB_RF_LP_FORCE_ACK_EAXI_TO_APCPU					0x40000
#define MASK_AON_APB_RF_LP_FORCE_EAXI_TO_APCPU					0x20000
#define MASK_AON_APB_RF_LP_NUM_EAXI_TO_APCPU					0x1fffe
#define MASK_AON_APB_RF_LP_EB_EAXI_TO_APCPU					0x1
#define MASK_AON_APB_RF_EARLY_WAKEUP_EN						0x1
#define MASK_AON_APB_RF_EFUSE_PWON_RD_END_FLAG					0x4
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_AON					0xff000000
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_PUB					0xff0000
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_AUDCP					0xff00
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_AP						0xff
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_NR						0xff000000
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_V3						0xff0000
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_PSCP					0xff00
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_APCPU					0xff
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_AP						0xff000000
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_PSCP					0xff0000
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_V3						0xff00
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_AUDCP					0xff
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_PUB					0xff000000
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_NR						0xff0000
#define MASK_AON_APB_RF_REG_DBG_BUS_SEL_AON					0xff00
#define MASK_AON_APB_RF_REG_DBG_MOD_SEL_APCPU					0xff0000
#define MASK_AON_APB_RF_REG_DBG_SYS_SEL_B						0xff00
#define MASK_AON_APB_RF_REG_DBG_SYS_SEL						0xff
#define MASK_AON_APB_RF_DBG_BUS4_SEL						0x3f000000
#define MASK_AON_APB_RF_DBG_BUS3_SEL						0xfc0000
#define MASK_AON_APB_RF_DBG_BUS2_SEL						0x3f000
#define MASK_AON_APB_RF_DBG_BUS1_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS0_SEL						0x3f
#define MASK_AON_APB_RF_DBG_BUS9_SEL						0x3f000000
#define MASK_AON_APB_RF_DBG_BUS8_SEL						0xfc0000
#define MASK_AON_APB_RF_DBG_BUS7_SEL						0x3f000
#define MASK_AON_APB_RF_DBG_BUS6_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS5_SEL						0x3f
#define MASK_AON_APB_RF_DBG_BUS14_SEL						0x3f000000
#define MASK_AON_APB_RF_DBG_BUS13_SEL						0xfc0000
#define MASK_AON_APB_RF_DBG_BUS12_SEL						0x3f000
#define MASK_AON_APB_RF_DBG_BUS11_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS10_SEL						0x3f
#define MASK_AON_APB_RF_DBG_BUS19_SEL						0x3f000000
#define MASK_AON_APB_RF_DBG_BUS18_SEL						0xfc0000
#define MASK_AON_APB_RF_DBG_BUS17_SEL						0x3f000
#define MASK_AON_APB_RF_DBG_BUS16_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS15_SEL						0x3f
#define MASK_AON_APB_RF_DBG_BUS24_SEL						0x3f000000
#define MASK_AON_APB_RF_DBG_BUS23_SEL						0xfc0000
#define MASK_AON_APB_RF_DBG_BUS22_SEL						0x3f000
#define MASK_AON_APB_RF_DBG_BUS21_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS20_SEL						0x3f
#define MASK_AON_APB_RF_DBG_BUS29_SEL						0x3f000000
#define MASK_AON_APB_RF_DBG_BUS28_SEL						0xfc0000
#define MASK_AON_APB_RF_DBG_BUS27_SEL						0x3f000
#define MASK_AON_APB_RF_DBG_BUS26_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS25_SEL						0x3f
#define MASK_AON_APB_RF_DBG_BUS31_SEL						0xfc0
#define MASK_AON_APB_RF_DBG_BUS30_SEL						0x3f
#define MASK_AON_APB_RF_PAD_DBG_BUS_DATA_A						0xffffffff
#define MASK_AON_APB_RF_PAD_DBG_BUS_DATA_B						0xffffffff
#define MASK_AON_APB_RF_PAD_DBG_BUS_DATA_OUT					0xffffffff
#define MASK_AON_APB_RF_DBG_BUS_DATA_V3						0xffffffff
#define MASK_AON_APB_RF_DBG_BUS_DATA_PSCP						0xffffffff
#define MASK_AON_APB_RF_DBG_BUS_DATA_AUDCP						0xffffffff
#define MASK_AON_APB_RF_SCC_DBG_BUS						0xffffffff
#define MASK_AON_APB_RF_MATCH_SEL							0x80000
#define MASK_AON_APB_RF_WAIT_OVER							0x7fff8
#define MASK_AON_APB_RF_ENABLE_COUNTER						0x4
#define MASK_AON_APB_RF_ENABLE_FILTER						0x2
#define MASK_AON_APB_RF_DEBUG_MODE							0x1
#define MASK_AON_APB_RF_ADDR_FLT							0xffffffff
#define MASK_AON_APB_RF_ADDR_OVER							0xffffffff
#define MASK_AON_APB_RF_ADDR_DIFF							0xffffffff
#define MASK_AON_APB_RF_LATEST_ADDR						0xffffffff
#define MASK_AON_APB_RF_ADDR_MASK							0xffffffff
#define MASK_AON_APB_RF_TPIU_TO_SERDES_SEL						0x1
#define MASK_AON_APB_RF_BUSMON_EB_DBD_MTX						0x4
#define MASK_AON_APB_RF_BUSMON_EB_EAXI_MTX						0x2
#define MASK_AON_APB_RF_BUSMON_EB_AON_MAIN_MTX					0x1
#define MASK_AON_APB_RF_AON_CHIP_ID0						0xffffffff
#define MASK_AON_APB_RF_AON_CHIP_ID1						0xffffffff
#define MASK_AON_APB_RF_AON_PLAT_ID0						0xffffffff
#define MASK_AON_APB_RF_AON_PLAT_ID1						0xffffffff
#define MASK_AON_APB_RF_AON_IMPL_ID						0xffffffff
#define MASK_AON_APB_RF_AON_MFT_ID							0xffffffff
#define MASK_AON_APB_RF_AON_VER_ID							0xffffffff
#define MASK_AON_APB_RF_AON_CHIP_ID						0xffffffff
#define MASK_AON_APB_RF_USER_RSV_FLAG1_B1						0x2
#define MASK_AON_APB_RF_USER_RSV_FLAG1_B0						0x1
#define MASK_AON_APB_RF_BOND_OPTION0						0xffffffff
#define MASK_AON_APB_RF_BOND_OPTION1						0xffffffff
#define MASK_AON_APB_RF_RES_REG0							0xffffffff
#define MASK_AON_APB_RF_RES_REG1							0xffffffff
#define MASK_AON_APB_RF_CP_RFFE_RES_REG0						0xffffffff
#define MASK_AON_APB_RF_CP_RFFE_RES_REG1						0xffffffff
#define MASK_AON_APB_RF_CP_RFFE_RES_REG2						0xffffffff
#define MASK_AON_APB_RF_CP_RFFE_RES_REG3						0xffffffff
#define MASK_AON_APB_RF_CP_RFFE_RES_REG4						0xffffffff
#define MASK_AON_APB_RF_CP_RFFE_RES_REG5						0xffffffff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_RCO100M_RCO100M_EN				0x100
#define MASK_ANLG_PHY_TOP_RF_ANALOG_RCO100M_RCO100M_RSTB				0x80
#define MASK_ANLG_PHY_TOP_RF_ANALOG_RCO100M_RCO100M_RC_C				0x7f
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_RCO100M_RCO100M_EN			0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_RCO100M_RCO100M_RSTB			0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_RCO100M_RCO100M_RC_C			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_EFUSE4K_EFS_ENK1				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_EFUSE4K_EFS_ENK2				0x1
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_EFUSE4K_EFS_ENK1			0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_EFUSE4K_EFS_ENK2			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_RST				0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_PD				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_REF_SEL				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_DIV32_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R8PLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_RST				0x100
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_PD				0x80
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_REF_SEL				0x60
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_DIV32_EN				0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_DIV2P5_EN			0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_DIV1P5_EN			0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_DIV1_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_V3PLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_PD				0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_RST				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_REF_SEL			0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_DIV32_EN			0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_CPUPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_RST				0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_PD				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_REF_SEL			0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_DIV32_EN			0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NR_DSPPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_RST				0x100
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_PD				0x80
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_REF_SEL				0x60
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_DIV32_EN				0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_DIV3_EN				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_DIV2_EN				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_DIV1_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_NRPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_PD				0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_RST				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_REF_SEL				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_DIV32_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_PLL_TOP_R5PLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R8PLL_RST			0x80000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R8PLL_PD			0x40000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R8PLL_REF_SEL			0x20000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R8PLL_DIV32_EN			0x10000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R8PLL_CLKOUT_EN		0x8000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_RST			0x4000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_PD			0x2000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_REF_SEL			0x1000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_DIV32_EN			0x800000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_DIV2P5_EN		0x400000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_DIV1P5_EN		0x200000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_DIV1_EN			0x100000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_V3PLL_CLKOUT_EN		0x80000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_CPUPLL_PD			0x40000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_CPUPLL_RST			0x20000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_CPUPLL_REF_SEL		0x10000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_CPUPLL_DIV32_EN		0x8000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_CPUPLL_CLKOUT_EN		0x4000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_DSPPLL_RST			0x2000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_DSPPLL_PD			0x1000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_DSPPLL_REF_SEL		0x800
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_DSPPLL_DIV32_EN		0x400
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NR_DSPPLL_CLKOUT_EN		0x200
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_RST			0x100
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_PD			0x80
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_REF_SEL			0x40
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_DIV32_EN			0x20
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_DIV3_EN			0x10
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_DIV2_EN			0x8
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_DIV1_EN			0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_NRPLL_CLKOUT_EN		0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R5PLL_PD			0x1
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R5PLL_RST			0x8
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R5PLL_REF_SEL			0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R5PLL_DIV32_EN			0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_PLL_TOP_R5PLL_CLKOUT_EN		0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_RSTN				0x2000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_RUN				0x1000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_PD				0x800
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_DATA				0x7fe
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_VALID				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_THM_RESERVED			0xffff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_RST				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_PD				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_DIV32_EN			0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL0_CLKOUTEN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_LOCK_DONE			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_RST				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_PD				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_DIV32_EN			0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_MPLL_THM_TOP_MPLL1_CLKOUTEN			0x1
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_THM_RSTN			0x800
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_THM_RUN			0x400
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_THM_PD			0x200
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_THM_RESERVED		0x100
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL0_RST			0x80
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL0_PD			0x40
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL0_DIV32_EN		0x20
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL0_CLKOUTEN		0x10
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL1_RST			0x8
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL1_PD			0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL1_DIV32_EN		0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_MPLL_THM_TOP_MPLL1_CLKOUTEN		0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_REC_26MHZ_0_BUF_PD			0x10
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APC5G_PD				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APCNON5G_PD				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APCNON5G_PD				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APC5G_PD				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_SINDRV_ENA_SQUARE			0x800
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_PROBE_SEL				0x7f8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_SINDRV_0_ENA				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_SINDRV_1_ENA				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_SINDRV_2_ENA				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_LOCK_DONE			0x20000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_N				0x1ffc0
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_ICP				0x38
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_SDM_EN				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_MOD_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_DIV_S				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_NINT				0x3f800000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_KINT				0x7fffff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_FREQ_DOUBLE_EN			0x80
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_RST				0x40
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_PD				0x20
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_REF_SEL				0x18
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_POSTDIV				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_DIV_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_VCO_TEST_EN			0x100
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_SSC_CTRL			0xff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_LPF				0x1c00
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_LDO_TRIM			0x3c0
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_IBIAS				0x30
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_FBDIV_EN			0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CP_OFFSET			0x6
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_CP_EN				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_VSET				0x38000000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_26M_DIV				0x7e00000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_V3_RPLL_RESERVED			0x1fffff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_LOCK_DONE			0x20000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_N				0x1ffc0
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_ICP				0x38
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_SDM_EN				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_MOD_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_DIV_S				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_NINT				0x3f800000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_KINT				0x7fffff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_FREQ_DOUBLE_EN			0x80
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_RST				0x40
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_PD				0x20
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_REF_SEL				0x18
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_POSTDIV				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_DIV_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_VCO_TEST_EN			0x100
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_SSC_CTRL			0xff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_LPF				0x1c00
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_LDO_TRIM			0x3c0
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_IBIAS				0x30
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_FBDIV_EN			0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CP_OFFSET			0x6
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_CP_EN				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_VSET				0x38000000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_26M_DIV				0x7e00000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_NR_RPLL_RESERVED			0x1fffff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_LOCK_DONE				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_RST				0x8
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_PD				0x4
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_DIV32_EN				0x2
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_DLPLL_CLKOUT_EN				0x1
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APC5G_RESERVED			0xc0000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APC5GOUT_SEL				0x30000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APC5G_LOW_V_CON			0x8000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APC5G_BPRES				0x4000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APC5G_D				0x3fff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APCNON5G_RESERVED			0xc0000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APCNON5GOUT_SEL			0x30000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APCNON5G_LOW_V_CON			0x8000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APCNON5G_BPRES			0x4000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_M_APCNON5G_D				0x3fff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APC5G_RESERVED			0xc0000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APC5GOUT_SEL				0x30000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APC5G_LOW_V_CON			0x8000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APC5G_BPRES				0x4000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APC5G_D				0x3fff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APCNON5G_RESERVED			0xc0000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APCNON5GOUT_SEL			0x30000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APCNON5G_LOW_V_CON			0x8000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APCNON5G_BPRES			0x4000
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_S_APCNON5G_D				0x3fff
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_APC5G_G0				0xc0
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_APC5G_G1				0x30
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_APCNON5G_G0				0xc
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_APCNON5G_G1				0x3
#define MASK_ANLG_PHY_TOP_RF_ANALOG_BB_TOP_U2U3_REF_SEL				0x3
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_REC_26MHZ_0_BUF_PD		0x80000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APC5G_PD			0x40000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APCNON5G_PD			0x20000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APCNON5G_PD			0x10000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APC5G_PD			0x8000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_SINDRV_ENA_SQUARE		0x4000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_PROBE_SEL			0x2000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_SINDRV_0_ENA			0x1000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_SINDRV_1_ENA			0x800000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_SINDRV_2_ENA			0x400000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_N			0x200000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_ICP			0x100000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_SDM_EN			0x80000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_MOD_EN			0x40000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_DIV_S			0x20000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_NINT			0x10000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_KINT			0x8000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_FREQ_DOUBLE_EN		0x4000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_RST			0x2000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_PD			0x1000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_REF_SEL			0x800
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_POSTDIV			0x400
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_DIV_EN			0x200
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_CLKOUT_EN		0x100
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_VCO_TEST_EN		0x80
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_SSC_CTRL		0x40
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_LPF			0x20
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_LDO_TRIM		0x10
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_IBIAS			0x8
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_FBDIV_EN		0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_CP_OFFSET		0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_CP_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_VSET			0x80000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_26M_DIV			0x40000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_V3_RPLL_RESERVED		0x20000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_N			0x10000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_ICP			0x8000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_SDM_EN			0x4000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_MOD_EN			0x2000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_DIV_S			0x1000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_NINT			0x800000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_KINT			0x400000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_FREQ_DOUBLE_EN		0x200000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_RST			0x100000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_PD			0x80000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_REF_SEL			0x40000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_POSTDIV			0x20000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_DIV_EN			0x10000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_CLKOUT_EN		0x8000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_VCO_TEST_EN		0x4000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_SSC_CTRL		0x2000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_LPF			0x1000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_LDO_TRIM		0x800
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_IBIAS			0x400
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_FBDIV_EN		0x200
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_CP_OFFSET		0x100
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_CP_EN			0x80
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_VSET			0x40
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_26M_DIV			0x20
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_NR_RPLL_RESERVED		0x10
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_DLPLL_RST			0x8
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_DLPLL_PD			0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_DLPLL_DIV32_EN			0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_DLPLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APC5G_RESERVED		0x1000000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APC5GOUT_SEL			0x800000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APC5G_LOW_V_CON		0x400000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APC5G_BPRES			0x200000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APC5G_D			0x100000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APCNON5G_RESERVED		0x80000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APCNON5GOUT_SEL		0x40000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APCNON5G_LOW_V_CON		0x20000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APCNON5G_BPRES		0x10000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_M_APCNON5G_D			0x8000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APC5G_RESERVED		0x4000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APC5GOUT_SEL			0x2000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APC5G_LOW_V_CON		0x1000
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APC5G_BPRES			0x800
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APC5G_D			0x400
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APCNON5G_RESERVED		0x200
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APCNON5GOUT_SEL		0x100
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APCNON5G_LOW_V_CON		0x80
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APCNON5G_BPRES		0x40
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_S_APCNON5G_D			0x20
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_APC5G_G0			0x10
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_APC5G_G1			0x8
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_APCNON5G_G0			0x4
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_APCNON5G_G1			0x2
#define MASK_ANLG_PHY_TOP_RF_DBG_SEL_ANALOG_BB_TOP_U2U3_REF_SEL			0x1
#define MASK_CS_DBG_APB_RF_BUS_BUSY_TIMER_EN					0x100
#define MASK_CS_DBG_APB_RF_BUS_BUSY_TIMER_DIVIDER					0xff
#define MASK_CS_DBG_APB_RF_TPIU_DATA_OVF						0x10
#define MASK_CS_DBG_APB_RF_APCPU_CSSYS_EN						0x8
#define MASK_CS_DBG_APB_RF_APCPU_APB_TRANS_CSYSREQ					0x4
#define MASK_CS_DBG_APB_RF_CPWRUPREQ_CDBGPWRUP					0x2
#define MASK_CS_DBG_APB_RF_DBGCONNECTED						0x1
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_NRCP_EN					0x40
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_V3PS_EN					0x20
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_V3PHY_EN					0x10
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_RCO_EN					0x8
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_PSCP_EN					0x4
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_AON_CM4_EN					0x2
#define MASK_CS_DBG_APB_RF_CSYSPWRUPREQ_APCPU_EN					0x1
#define MASK_CS_DBG_APB_RF_DBG_SYS_CLK_GATING_SEL					0x40000
#define MASK_CS_DBG_APB_RF_ANTI_HANG_EN						0x20000
#define MASK_CS_DBG_APB_RF_U_SYS_AON_CSSYS_EN_REG					0x10000
#define MASK_CS_DBG_APB_RF_APCPU_DAP_EN_REG					0x8000
#define MASK_CS_DBG_APB_RF_CROSS_TRIGGER_EN					0x4000
#define MASK_CS_DBG_APB_RF_APCPU_MTX_SOFT_RST					0x2000
#define MASK_CS_DBG_APB_RF_APCPU_AXI_TRANS_BLKR_BYPASS				0x1000
#define MASK_CS_DBG_APB_RF_APCPU_APB_TRANS_BLKR_BYPASS				0x800
#define MASK_CS_DBG_APB_RF_APCPU_CORINTH_DEBUG_EN_FOR_LP				0x400
#define MASK_CS_DBG_APB_RF_AUTO_REG_SAVE_SEL					0x200
#define MASK_CS_DBG_APB_RF_AUTO_REG_SAVE_SOFT_TRIG					0x100
#define MASK_CS_DBG_APB_RF_AUTO_REG_SAVE_EN					0x80
#define MASK_CS_DBG_APB_RF_CSSYS_SOFT_RST_EN					0x40
#define MASK_CS_DBG_APB_RF_AON_MTX_SOFT_RST_EN					0x20
#define MASK_CS_DBG_APB_RF_DAP_SOFT_RST_EN						0x10
#define MASK_CS_DBG_APB_RF_APCPU_CSSYS_EN_REG					0x8
#define MASK_CS_DBG_APB_RF_APCPU_DBG_CONNECTED_SW					0x4
#define MASK_CS_DBG_APB_RF_APCPU_DBG_CONNECTED_CTRL				0x3
#define MASK_CS_DBG_APB_RF_STM_SOFT_RST						0x1
#define MASK_CS_DBG_APB_RF_AON_APB_CLK_RCO_SEL					0xe00
#define MASK_CS_DBG_APB_RF_CSSYS_CLK_RCO_SEL					0x1c0
#define MASK_CS_DBG_APB_RF_DAP_CLK_RCO_SEL						0x38
#define MASK_CS_DBG_APB_RF_AON_APB_CLK_RCO_CTRL_EN_REG				0x4
#define MASK_CS_DBG_APB_RF_CSSYS_CLK_RCO_CTRL_EN_REG				0x2
#define MASK_CS_DBG_APB_RF_DAP_CLK_RCO_CTRL_EN_REG					0x1
#define MASK_CS_DBG_APB_RF_DBG_SYS_IDLE_THR					0xffff0000
#define MASK_CS_DBG_APB_RF_DBG_SYS_CLK_SWITCH_INTVL				0xff00
#define MASK_CS_DBG_APB_RF_DBG_SYS_CLK_IDLE_SEL					0x70
#define MASK_CS_DBG_APB_RF_DBG_SYS_CW_EN						0x4
#define MASK_CS_DBG_APB_RF_DBG_SYS_CG_EN						0x2
#define MASK_CS_DBG_APB_RF_DBG_SYS_CLK_CTRL_EN					0x1
#define MASK_CS_DBG_APB_RF_DBG_SYS_SW_EVENT					0xffff0000
#define MASK_CS_DBG_APB_RF_AXI_ED_EN						0x1000
#define MASK_CS_DBG_APB_RF_ETR_ED_EN						0x800
#define MASK_CS_DBG_APB_RF_TPIU_ED_EN						0x400
#define MASK_CS_DBG_APB_RF_DAP_CPWRUP_ED_EN					0x200
#define MASK_CS_DBG_APB_RF_DAP_APB_ED_EN						0x100
#define MASK_CS_DBG_APB_RF_CTM_ED_EN						0x80
#define MASK_CS_DBG_APB_RF_CTI_ED_EN						0x40
#define MASK_CS_DBG_APB_RF_RTM_ED_EN						0x20
#define MASK_CS_DBG_APB_RF_PTM_ED_EN						0x10
#define MASK_CS_DBG_APB_RF_NRCP_ED_EN						0x8
#define MASK_CS_DBG_APB_RF_V3_ED_EN						0x4
#define MASK_CS_DBG_APB_RF_PSCP_ED_EN						0x2
#define MASK_CS_DBG_APB_RF_APCPU_ED_EN						0x1
#define MASK_CS_DBG_APB_RF_APCPU_CS_IDLE_THR					0xffff0000
#define MASK_CS_DBG_APB_RF_APCPU_CS_CLK_SWITCH_INTVL				0xff00
#define MASK_CS_DBG_APB_RF_APCPU_CS_CLK_IDLE_DIV_EN				0x80
#define MASK_CS_DBG_APB_RF_APCPU_CS_CLK_IDLE_DIV					0x70
#define MASK_CS_DBG_APB_RF_APCPU_CS_CLK_IDLE_SEL_EN				0x8
#define MASK_CS_DBG_APB_RF_APCPU_CS_CLK_IDLE_SEL					0x6
#define MASK_CS_DBG_APB_RF_APCPU_CS_CLK_CTRL_EN					0x1
#define MASK_CS_DBG_APB_RF_DBG_MTX_M0_LP_NUM					0xffff0000
#define MASK_CS_DBG_APB_RF_DBG_MTX_M0_PU_NUM					0xff00
#define MASK_CS_DBG_APB_RF_DBG_MTX_M0_CSYSACK_SYNC_SEL				0x4
#define MASK_CS_DBG_APB_RF_DBG_MTX_M0_CACTIVE_SYNC_SEL				0x2
#define MASK_CS_DBG_APB_RF_DBG_MTX_M0_LPC_EB					0x1
#define MASK_CS_DBG_APB_RF_DBG_MTX_S0_LP_NUM					0xffff0000
#define MASK_CS_DBG_APB_RF_DBG_MTX_S0_PU_NUM					0xff00
#define MASK_CS_DBG_APB_RF_DBG_MTX_S0_CSYSACK_SYNC_SEL				0x4
#define MASK_CS_DBG_APB_RF_DBG_MTX_S0_CACTIVE_SYNC_SEL				0x2
#define MASK_CS_DBG_APB_RF_DBG_MTX_S0_LPC_EB					0x1
#define MASK_CS_DBG_APB_RF_DBG_MTX_S1_LP_NUM					0xffff0000
#define MASK_CS_DBG_APB_RF_DBG_MTX_S1_PU_NUM					0xff00
#define MASK_CS_DBG_APB_RF_DBG_MTX_S1_CSYSACK_SYNC_SEL				0x4
#define MASK_CS_DBG_APB_RF_DBG_MTX_S1_CACTIVE_SYNC_SEL				0x2
#define MASK_CS_DBG_APB_RF_DBG_MTX_S1_LPC_EB					0x1
#define MASK_CS_DBG_APB_RF_TPIU2SERDES_CGM_EN					0x1
#define MASK_CS_DBG_APB_RF_DBG_SUBSYS_SEL_A					0xff
#define MASK_CS_DBG_APB_RF_DBG_SUBSYS_SEL_B					0xff
#define MASK_CS_DBG_APB_RF_AON_DBG_MOD_SEL						0xff
#define MASK_CS_DBG_APB_RF_AON_DBG_SIG_SEL						0xff
#define MASK_CS_DBG_APB_RF_APCPU_DBG_MOD_SEL					0xff
#define MASK_CS_DBG_APB_RF_APCPU_DBG_SIG_SEL					0xff
#define MASK_CS_DBG_APB_RF_AUDCP_DBG_MOD_SEL					0xff
#define MASK_CS_DBG_APB_RF_AUDCP_DBG_SIG_SEL					0xff
#define MASK_CS_DBG_APB_RF_PSCP_DBG_MOD_SEL					0xff
#define MASK_CS_DBG_APB_RF_PSCP_DBG_SIG_SEL					0xff
#define MASK_CS_DBG_APB_RF_PUB_DBG_MOD_SEL						0xff
#define MASK_CS_DBG_APB_RF_PUB_DBG_SIG_SEL						0xff
#define MASK_CS_DBG_APB_RF_V3_DBG_MOD_SEL						0xff
#define MASK_CS_DBG_APB_RF_V3_DBG_SIG_SEL						0xff
#define MASK_CS_DBG_APB_RF_NR_DBG_MOD_SEL						0xff
#define MASK_CS_DBG_APB_RF_NR_DBG_SIG_SEL						0xff
#define MASK_CS_DBG_APB_RF_AP_DBG_MOD_SEL						0xff
#define MASK_CS_DBG_APB_RF_AP_DBG_SIG_SEL						0xff
#define MASK_CS_DBG_APB_RF_MDAR_DBG_MOD_SEL					0xff
#define MASK_CS_DBG_APB_RF_MDAR_DBG_SIG_SEL					0xff
#define MASK_CS_DBG_APB_RF_AON_DBG_MOD_SEL_2					0xff
#define MASK_CS_DBG_APB_RF_AON_DBG_SIG_SEL_2					0xff
#define MASK_CS_DBG_APB_RF_DBG_BUS0_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS1_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS2_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS3_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS4_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS5_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS6_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS7_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS8_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS9_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS10_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS11_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS12_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS13_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS14_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS15_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS16_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS17_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS18_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS19_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS20_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS21_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS22_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS23_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS24_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS25_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS26_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS27_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS28_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS29_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS30_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS31_SEL						0x3f
#define MASK_CS_DBG_APB_RF_DBG_BUS_DATA_A						0xffffffff
#define MASK_CS_DBG_APB_RF_DBG_BUS_DATA_B						0xffffffff
#define MASK_CS_DBG_APB_RF_DBG_BUS_DATA						0xffffffff
#define MASK_CS_DBG_APB_RF_AWADDR3_MATCH_INT_EN					0x8
#define MASK_CS_DBG_APB_RF_AWADDR2_MATCH_INT_EN					0x4
#define MASK_CS_DBG_APB_RF_AWADDR1_MATCH_INT_EN					0x2
#define MASK_CS_DBG_APB_RF_AWADDR0_MATCH_INT_EN					0x1
#define MASK_CS_DBG_APB_RF_AWADDR3_MATCH_INT_CLR					0x8
#define MASK_CS_DBG_APB_RF_AWADDR2_MATCH_INT_CLR					0x4
#define MASK_CS_DBG_APB_RF_AWADDR1_MATCH_INT_CLR					0x2
#define MASK_CS_DBG_APB_RF_AWADDR0_MATCH_INT_CLR					0x1
#define MASK_CS_DBG_APB_RF_AWADDR3_MATCH_INT_RAW					0x8
#define MASK_CS_DBG_APB_RF_AWADDR2_MATCH_INT_RAW					0x4
#define MASK_CS_DBG_APB_RF_AWADDR1_MATCH_INT_RAW					0x2
#define MASK_CS_DBG_APB_RF_AWADDR0_MATCH_INT_RAW					0x1
#define MASK_CS_DBG_APB_RF_AWADDR3_MATCH_INT_STAT					0x8
#define MASK_CS_DBG_APB_RF_AWADDR2_MATCH_INT_STAT					0x4
#define MASK_CS_DBG_APB_RF_AWADDR1_MATCH_INT_STAT					0x2
#define MASK_CS_DBG_APB_RF_AWADDR0_MATCH_INT_STAT					0x1
#define MASK_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR0					0xfffffff
#define MASK_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR1					0xfffffff
#define MASK_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR2					0xfffffff
#define MASK_CS_DBG_APB_RF_ETR_AXI_MON_AWADDR3					0xfffffff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_LOCK_DONE			0x20000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_N				0x1ffc0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_ICP				0x38
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_SDM_EN				0x4
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_MOD_EN				0x2
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_DIV_S				0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_NINT				0x3f800000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_KINT				0x7fffff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_IL_DIV				0x10000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_FREQ_DOUBLE_EN			0x8000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL2_RESERVED2			0x4000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_RST				0x2000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_PD				0x1000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL2_RESERVED1			0xfff800
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL2_RESERVED0			0x7c0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_DIV32_EN				0x20
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_DIV_SEL				0x1e
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CCS_CTRL				0xff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_R2_SEL				0xc00000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_R3_SEL				0x300000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_C1_SEL				0xc0000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_C2_SEL				0x30000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CTRL4_RESERVED0			0xfff0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_FBDIV_EN				0x8
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CP_OFFSET			0x6
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CP_EN				0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_BIST_EN				0x10000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_RESERVED				0x1fe0000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_DONE			0x10000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCTRL_HIGH			0x8000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCTRL_LOW			0x4000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_OUT				0x3e00
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_CPPD			0x100
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_KVCO_SEL				0xc0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCO_TEST_EN			0x20
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCO_TEST_INT			0x10
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCO_TEST_INTSEL			0xe
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCOBUF_EN			0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_MODE			0xc000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_INI				0x3e00000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_TRIG			0x100000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_FREQ_DIFF_EN			0x80000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_WAITCNT			0x60000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_CALI_POLARITY			0x10000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCTRLH_SEL			0xe000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCTRLL_SEL			0x1c00
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_VCO_BANK_SEL			0x3e0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_RG_CLOSELOOP_EN			0x10
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL0_LDO_TRIM				0xf
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_LOCK_DONE			0x20000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_N				0x1ffc0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_ICP				0x38
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_SDM_EN				0x4
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_MOD_EN				0x2
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_DIV_S				0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_NINT				0x3f800000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_KINT				0x7fffff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_IL_DIV				0x10000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_FREQ_DOUBLE_EN			0x8000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL2_RESERVED2			0x4000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_RST				0x2000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_PD				0x1000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL2_RESERVED1			0xfff800
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL2_RESERVED0			0x7c0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_DIV32_EN				0x20
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_DIV_SEL				0x1e
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CCS_CTRL				0xff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_R2_SEL				0xc00000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_R3_SEL				0x300000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_C1_SEL				0xc0000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_C2_SEL				0x30000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CTRL4_RESERVED0			0xfff0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_FBDIV_EN				0x8
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CP_OFFSET			0x6
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CP_EN				0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_BIST_EN				0x10000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_RESERVED				0x1fe0000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_DONE			0x10000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCTRL_HIGH			0x8000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCTRL_LOW			0x4000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_OUT				0x3e00
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_CPPD			0x100
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_KVCO_SEL				0xc0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCO_TEST_EN			0x20
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCO_TEST_INT			0x10
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCO_TEST_INTSEL			0xe
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCOBUF_EN			0x1
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_MODE			0xc000000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_INI				0x3e00000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_TRIG			0x100000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_FREQ_DIFF_EN			0x80000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_WAITCNT			0x60000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_CALI_POLARITY			0x10000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCTRLH_SEL			0xe000
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCTRLL_SEL			0x1c00
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_VCO_BANK_SEL			0x3e0
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_RG_CLOSELOOP_EN			0x10
#define MASK_ANLG_PHY_G1_RF_ANALOG_DPLL_TOP_DPLL1_LDO_TRIM				0xf
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL0_RST			0x80
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL0_PD			0x40
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL0_DIV_SEL			0x20
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL0_CLKOUT_EN		0x10
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL1_RST			0x8
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL1_PD			0x4
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL1_DIV_SEL			0x2
#define MASK_ANLG_PHY_G1_RF_DBG_SEL_ANALOG_DPLL_TOP_DPLL1_CLKOUT_EN		0x1
#define MASK_PUB_QOSC_AHB_REG_QOS_CTRL_ENABLE					0x1
#define MASK_PUB_QOSC_AHB_REG_QOS_URGENT_COUNT_RESET				0x2
#define MASK_PUB_QOSC_AHB_REG_QOS_CTRL_RESET					0x1
#define MASK_PUB_QOSC_AHB_REG_QOSC_CFG_CLK_AUTO_GATE_EN				0x200
#define MASK_PUB_QOSC_AHB_REG_QOSC_CFG_CLK_EB					0x100
#define MASK_PUB_QOSC_AHB_REG_QOSC_CLK_TICK_ENABLE					0x10
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMIT_AUTO_GATE_EN				0x2
#define MASK_PUB_QOSC_AHB_REG_QOSC_PORT_CLK_AUTO_GATE_EN				0x1
#define MASK_PUB_QOSC_AHB_REG_QOSC_PORT_ENABLE					0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNTER_EN_RD				0x7f0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNTER_EN_WR				0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_ARURGENT_EN					0x7f0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_AWURGENT_EN					0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_EN_RD				0x7f0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_EN_WR				0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_NO_SV_BW_SLICE_BYPASS				0x10000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_DFS_FREQ					0x7000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_DFS_PAUSE_ENABLE				0x200000
#define MASK_PUB_QOSC_AHB_REG_QOSC_MODE						0x100000
#define MASK_PUB_QOSC_AHB_REG_QOSC_UG_ULTRA_OSTD_ENABLE				0x20000
#define MASK_PUB_QOSC_AHB_REG_QOSC_UG_HIGH_OSTD_ENABLE				0x10000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_NORM_BYPASS					0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH0			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH0			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH1			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH1			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH2			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH2			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH3			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH3			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH4			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH4			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH5			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH5			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_WR_CH6			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_WR_CH6			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH0			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH0			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH1			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH1			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH2			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH2			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH3			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH3			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH4			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH4			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH5			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH5			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_ULTRA_RD_CH6			0x3ff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_THRESHOLD_HIGH_RD_CH6			0x3ff
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH0				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH1				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH2				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH3				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH4				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH5				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_SV_COUNT_OFFSET_CH6				0x3f
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH7				0x70000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH6				0x7000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH5				0x700000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH4				0x70000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH3				0x7000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH2				0x700
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH1				0x70
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_TIMING_WINDOW_CH0				0x7
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH0				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH0				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH1				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH1				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH2				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH2				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH3				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH3				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH4				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH4				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH5				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH5				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_RD_CH6				0xff0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_BW_LIMITER_MAX_WR_CH6				0xff
#define MASK_PUB_QOSC_AHB_REG_QOSC_FORCE_URGENT_HIGH_EN_RD				0x7f0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_FORCE_URGENT_HIGH_EN_WR				0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_FORCE_URGENT_ULTRA_EN_RD			0x7f0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_FORCE_URGENT_ULTRA_EN_WR			0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_LATMON_ARURGENT_EN				0x7f0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_LATMON_AWURGENT_EN				0x7f
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH0				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH0				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH0				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH0				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH0				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH0				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH0				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH0				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH1				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH1				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH1				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH1				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH1				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH1				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH1				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH1				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH2				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH2				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH2				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH2				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH2				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH2				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH2				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH2				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH3				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH3				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH3				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH3				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH3				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH3				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH3				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH3				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH4				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH4				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH4				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH4				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH4				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH4				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH4				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH4				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH5				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH5				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH5				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH5				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH5				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH5				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH5				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH5				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_RD_CH6				0xf0000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_ULTRA_WR_CH6				0xf000000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_RD_CH6				0xf00000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_HIGH_WR_CH6				0xf0000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_RD_CH6				0xf000
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_NORM_WR_CH6				0xf00
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_RD_CH6				0xf0
#define MASK_PUB_QOSC_AHB_REG_QOSC_QOS_VALUE_LOW_WR_CH6				0xf
#define MASK_PUB_QOSC_AHB_REG_QOSC_STATUS0						0xffffffff
#define MASK_PUB_QOSC_AHB_REG_QOSC_STATUS1						0xffffffff
#define MASK_PUB_QOSC_AHB_REG_QOSC_STATUS2						0xffffffff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH0				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH0				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH0				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH0				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH1				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH1				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH1				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH1				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH2				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH2				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH2				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH2				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH3				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH3				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH3				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH3				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH4				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH4				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH4				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH4				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH5				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH5				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH5				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH5				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_RD_CH6				0xff000000
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_RD_CH6				0xff0000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_COUNT_WR_CH6				0xff00
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_COUNT_WR_CH6				0xff
#define MASK_PUB_QOSC_AHB_REG_QOS_DBG_MON_SEL					0xf0
#define MASK_PUB_QOSC_AHB_REG_QOS_DBG_MON_EB					0x2
#define MASK_PUB_QOSC_AHB_REG_QOS_DBG_MON_START					0x1
#define MASK_PUB_QOSC_AHB_REG_QOSC_MON_STATUS					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_QOSC_MON_OVERFLOW_CNT				0x1f
#define MASK_PUB_QOSC_AHB_REG_LATMON_SW_TIMER_EN					0x7f0000
#define MASK_PUB_QOSC_AHB_REG_LATMON_TIMER_SEL					0x7f
#define MASK_PUB_QOSC_AHB_REG_LATMON2_SEL						0x800000
#define MASK_PUB_QOSC_AHB_REG_LATMON_AUTO_GATE_EN					0x7f0000
#define MASK_PUB_QOSC_AHB_REG_LATMON_CLK_TICK_ENABLE				0x7f00
#define MASK_PUB_QOSC_AHB_REG_LATMON_ENABLE					0x7f
#define MASK_PUB_QOSC_AHB_REG_LATMON_COUNT_RESET					0x7f00
#define MASK_PUB_QOSC_AHB_REG_LATMON_RESET						0x7f
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM0				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM0				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM0				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM0				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM0				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM0				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM0				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM0				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM0				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM0				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM0				0xf
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM6			0x70000000
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM5			0xe000000
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM4			0x1c00000
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM3			0x380000
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM2			0x70000
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM1			0x7000
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_SEL_LM0			0x700
#define MASK_PUB_QOSC_AHB_REG_LATMON_HW_DFS_TRIGGER_EN				0x7f
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM1				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM1				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM1				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM1				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM1				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM1				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM1				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM1				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM1				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM1				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM1				0xf
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM2				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM2				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM2				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM2				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM2				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM2				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM2				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM2				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM2				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM2				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM2				0xf
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM3				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM3				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM3				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM3				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM3				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM3				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM3				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM3				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM3				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM3				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM3				0xf
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM4				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM4				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM4				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM4				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM4				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM4				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM4				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM4				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM4				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM4				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM4				0xf
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM5				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM5				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM5				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM5				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM5				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM5				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM5				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM5				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM5				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM5				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM5				0xf
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_RD_LM6				0xff0000
#define MASK_PUB_QOSC_AHB_REG_TAR_LAT_OFFSET_WR_LM6				0xff
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_RD_LM6				0x3000
#define MASK_PUB_QOSC_AHB_REG_URGENT_ULTRA_RATIO_WR_LM6				0x300
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_RD_LM6				0x30
#define MASK_PUB_QOSC_AHB_REG_URGENT_HIGH_RATIO_WR_LM6				0x3
#define MASK_PUB_QOSC_AHB_REG_LATMON_INIT_URGENT_DEB_LM6				0x70000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_SEL_LM6				0xc000000
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_VALUE_LM6				0xfff000
#define MASK_PUB_QOSC_AHB_REG_LAT_SUB_ALL_RATIO_LM6				0x300
#define MASK_PUB_QOSC_AHB_REG_TIMER_LAT_SUB_PERIOD_LM6				0xf
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM0				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM0				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM0				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM0				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM1				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM1				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM1				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM1				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM2				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM2				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM2				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM2				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM3				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM3				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM3				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM3				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM4				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM4				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM4				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM4				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM5				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM5				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM5				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM5				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_WR_LM6				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_WR_LM6				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_ACTUAL_RD_LM6				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATENCY_TARGET_RD_LM6				0xffffffff
#define MASK_PUB_QOSC_AHB_REG_LATMON6_UPDATE_FLAG_CLR				0x4000
#define MASK_PUB_QOSC_AHB_REG_LATMON5_UPDATE_FLAG_CLR				0x2000
#define MASK_PUB_QOSC_AHB_REG_LATMON4_UPDATE_FLAG_CLR				0x1000
#define MASK_PUB_QOSC_AHB_REG_LATMON3_UPDATE_FLAG_CLR				0x800
#define MASK_PUB_QOSC_AHB_REG_LATMON2_UPDATE_FLAG_CLR				0x400
#define MASK_PUB_QOSC_AHB_REG_LATMON1_UPDATE_FLAG_CLR				0x200
#define MASK_PUB_QOSC_AHB_REG_LATMON0_UPDATE_FLAG_CLR				0x100
#define MASK_PUB_QOSC_AHB_REG_LATMON6_UPDATE_FLAG					0x40
#define MASK_PUB_QOSC_AHB_REG_LATMON5_UPDATE_FLAG					0x20
#define MASK_PUB_QOSC_AHB_REG_LATMON4_UPDATE_FLAG					0x10
#define MASK_PUB_QOSC_AHB_REG_LATMON3_UPDATE_FLAG					0x8
#define MASK_PUB_QOSC_AHB_REG_LATMON2_UPDATE_FLAG					0x4
#define MASK_PUB_QOSC_AHB_REG_LATMON1_UPDATE_FLAG					0x2
#define MASK_PUB_QOSC_AHB_REG_LATMON0_UPDATE_FLAG					0x1
#define MASK_PUB_QOSC_AHB_REG_LATMON_COUNTER_OV_ST					0xfffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON_F_UP_REQ_EN					0x3f000000
#define MASK_PUB_QOSC_AHB_REG_BWMON_RBW_EN						0x3f0000
#define MASK_PUB_QOSC_AHB_REG_BWMON_WBW_EN						0x3f00
#define MASK_PUB_QOSC_AHB_REG_BWMON_ENABLE						0x3f
#define MASK_PUB_QOSC_AHB_REG_BWMON0_UP_WBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON0_UP_RBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON1_UP_WBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON1_UP_RBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON2_UP_WBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON2_UP_RBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON3_UP_WBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON3_UP_RBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON4_UP_WBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON4_UP_RBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON5_UP_WBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON5_UP_RBW_SET					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON5_UPDATE_FLAG_CLR				0x2000
#define MASK_PUB_QOSC_AHB_REG_BWMON4_UPDATE_FLAG_CLR				0x1000
#define MASK_PUB_QOSC_AHB_REG_BWMON3_UPDATE_FLAG_CLR				0x800
#define MASK_PUB_QOSC_AHB_REG_BWMON2_UPDATE_FLAG_CLR				0x400
#define MASK_PUB_QOSC_AHB_REG_BWMON1_UPDATE_FLAG_CLR				0x200
#define MASK_PUB_QOSC_AHB_REG_BWMON0_UPDATE_FLAG_CLR				0x100
#define MASK_PUB_QOSC_AHB_REG_BWMON5_UPDATE_FLAG					0x20
#define MASK_PUB_QOSC_AHB_REG_BWMON4_UPDATE_FLAG					0x10
#define MASK_PUB_QOSC_AHB_REG_BWMON3_UPDATE_FLAG					0x8
#define MASK_PUB_QOSC_AHB_REG_BWMON2_UPDATE_FLAG					0x4
#define MASK_PUB_QOSC_AHB_REG_BWMON1_UPDATE_FLAG					0x2
#define MASK_PUB_QOSC_AHB_REG_BWMON0_UPDATE_FLAG					0x1
#define MASK_PUB_QOSC_AHB_REG_BWMON0_WBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON0_RBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON1_WBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON1_RBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON2_WBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON2_RBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON3_WBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON3_RBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON4_WBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON4_RBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON5_WBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON5_RBW_CNT					0xffffffff
#define MASK_PUB_QOSC_AHB_REG_BWMON_UPDATE_FLAG_DFS_CNT				0x1f00
#define MASK_PUB_QOSC_AHB_REG_BWMON_VOTE_V3CPU_EN					0x20
#define MASK_PUB_QOSC_AHB_REG_BWMON_VOTE_V3ACC_EN					0x10
#define MASK_PUB_QOSC_AHB_REG_BWMON_VOTE_NRCPU_EN					0x8
#define MASK_PUB_QOSC_AHB_REG_BWMON_VOTE_NRACC_EN					0x4
#define MASK_PUB_QOSC_AHB_REG_BWMON_VOTE_MINIAP_EN					0x2
#define MASK_PUB_QOSC_AHB_REG_BWMON_VOTE_APCPU_EN					0x1
#define MASK_AON_DBG_APB_RF_APCPU_AWSTASHLPIDENS					0x100000
#define MASK_AON_DBG_APB_RF_APCPU_AWSTASHLPIDS					0xf0000
#define MASK_AON_DBG_APB_RF_APCPU_CFGTE						0xff00
#define MASK_AON_DBG_APB_RF_APCPU_AA64NAA32					0xff
#define MASK_AON_DBG_APB_RF_APCPU_SPNIDEN						0x8
#define MASK_AON_DBG_APB_RF_APCPU_SPIDEN						0x4
#define MASK_AON_DBG_APB_RF_APCPU_NIDEN						0x2
#define MASK_AON_DBG_APB_RF_APCPU_DBGEN						0x1
#define MASK_AON_DBG_APB_RF_DAP_DEVICEEN						0x80000000
#define MASK_AON_DBG_APB_RF_DAP_DBGEN						0x40000000
#define MASK_AON_DBG_APB_RF_DAP_SPIDBGEN						0x20000000
#define MASK_AON_DBG_APB_RF_NR_DSP1_JTAG_EN					0x400
#define MASK_AON_DBG_APB_RF_NR_DSP0_JTAG_EN					0x200
#define MASK_AON_DBG_APB_RF_AON_CM4_DBGEN						0x100
#define MASK_AON_DBG_APB_RF_DJTAG_EN_1						0x80
#define MASK_AON_DBG_APB_RF_DJTAG_EN_0						0x40
#define MASK_AON_DBG_APB_RF_AG_JTAG_EN						0x20
#define MASK_AON_DBG_APB_RF_MJTAG_EN						0x10
#define MASK_AON_DBG_APB_RF_CSSYS_NIDEN						0x8
#define MASK_AON_DBG_APB_RF_CSSYS_SPNIDEN						0x4
#define MASK_AON_DBG_APB_RF_CSSYS_SPIDEN						0x2
#define MASK_AON_DBG_APB_RF_CSSYS_DBGEN						0x1
#define MASK_AON_DBG_APB_RF_APCPU_SPNIDEN_NON_SEC					0x8
#define MASK_AON_DBG_APB_RF_APCPU_SPIDEN_NON_SEC					0x4
#define MASK_AON_DBG_APB_RF_APCPU_NIDEN_NON_SEC					0x2
#define MASK_AON_DBG_APB_RF_APCPU_DBGEN_NON_SEC					0x1
#define MASK_AON_DBG_APB_RF_DAP_DEVICEEN_NON_SEC					0x80000000
#define MASK_AON_DBG_APB_RF_DAP_DBGEN_NON_SEC					0x40000000
#define MASK_AON_DBG_APB_RF_DAP_SPIDBGEN_NON_SEC					0x20000000
#define MASK_AON_DBG_APB_RF_NR_DSP1_JTAG_EN_NON_SEC				0x400
#define MASK_AON_DBG_APB_RF_NR_DSP0_JTAG_EN_NON_SEC				0x200
#define MASK_AON_DBG_APB_RF_AON_CM4_DBGEN_NON_SEC					0x100
#define MASK_AON_DBG_APB_RF_DJTAG_EN_NON_SEC_1					0x80
#define MASK_AON_DBG_APB_RF_DJTAG_EN_NON_SEC_0					0x40
#define MASK_AON_DBG_APB_RF_AG_JTAG_EN_NON_SEC					0x20
#define MASK_AON_DBG_APB_RF_MJTAG_EN_NON_SEC					0x10
#define MASK_AON_DBG_APB_RF_CSSYS_NIDEN_NON_SEC					0x8
#define MASK_AON_DBG_APB_RF_CSSYS_SPNIDEN_NON_SEC					0x4
#define MASK_AON_DBG_APB_RF_CSSYS_SPIDEN_NON_SEC					0x2
#define MASK_AON_DBG_APB_RF_CSSYS_DBGEN_NON_SEC					0x1
#define MASK_AON_DBG_APB_RF_PSCP_CR8_1_NIDEN					0x8
#define MASK_AON_DBG_APB_RF_PSCP_CR8_1_DBGEN					0x4
#define MASK_AON_DBG_APB_RF_PSCP_CR8_0_NIDEN					0x2
#define MASK_AON_DBG_APB_RF_PSCP_CR8_0_DBGEN					0x1
#define MASK_AON_DBG_APB_RF_PSCP_CR8_1_NIDEN_NON_SEC				0x8
#define MASK_AON_DBG_APB_RF_PSCP_CR8_1_DBGEN_NON_SEC				0x4
#define MASK_AON_DBG_APB_RF_PSCP_CR8_0_NIDEN_NON_SEC				0x2
#define MASK_AON_DBG_APB_RF_PSCP_CR8_0_DBGEN_NON_SEC				0x1
#define MASK_AON_DBG_APB_RF_NRCP_CR8_1_NIDEN					0x8
#define MASK_AON_DBG_APB_RF_NRCP_CR8_1_DBGEN					0x4
#define MASK_AON_DBG_APB_RF_NRCP_CR8_0_NIDEN					0x2
#define MASK_AON_DBG_APB_RF_NRCP_CR8_0_DBGEN					0x1
#define MASK_AON_DBG_APB_RF_NRCP_CR8_1_NIDEN_NON_SEC				0x8
#define MASK_AON_DBG_APB_RF_NRCP_CR8_1_DBGEN_NON_SEC				0x4
#define MASK_AON_DBG_APB_RF_NRCP_CR8_0_NIDEN_NON_SEC				0x2
#define MASK_AON_DBG_APB_RF_NRCP_CR8_0_DBGEN_NON_SEC				0x1
#define MASK_AON_DBG_APB_RF_V3PS_CR5_NIDEN						0x2
#define MASK_AON_DBG_APB_RF_V3PS_CR5_DBGEN						0x1
#define MASK_AON_DBG_APB_RF_V3PS_CR5_NIDEN_NON_SEC					0x2
#define MASK_AON_DBG_APB_RF_V3PS_CR5_DBGEN_NON_SEC					0x1
#define MASK_AON_DBG_APB_RF_V3PHY_CR5_NIDEN					0x2
#define MASK_AON_DBG_APB_RF_V3PHY_CR5_DBGEN					0x1
#define MASK_AON_DBG_APB_RF_V3PHY_CR5_NIDEN_NON_SEC				0x2
#define MASK_AON_DBG_APB_RF_V3PHY_CR5_DBGEN_NON_SEC				0x1
#define MASK_AON_DBG_APB_RF_EFUSE_DEBUG_BOND_OFF					0x80000000
#define MASK_AON_DBG_APB_RF_EFUSE_SECURE_DEBUG					0x40000000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_RESET_N			0x8000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_TRIM_TXRCTL			0x7800
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_TRIM_RXRCTL			0x780
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_TRIM_BG			0x78
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_PS_PD_S			0x4
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_PS_PD_L			0x2
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_ISO_SW_EN			0x1
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_RESERVEDIN			0xffff0000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIE_GEN2_1T1R_PIPE_RESERVEDOUT			0xffff
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_RESET_N		0x80
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_TRIM_TXRCTL		0x40
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_TRIM_RXRCTL		0x20
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_TRIM_BG		0x10
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_PS_PD_S		0x8
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_PS_PD_L		0x4
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_ISO_SW_EN		0x2
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIE_GEN2_1T1R_PIPE_RESERVEDIN		0x1
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_LOCKDONE			0x20000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_N				0x1ffc0
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_ICP			0x38
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_SDM_EN			0x4
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_MOD_EN			0x2
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_DIV_S			0x1
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_NINT			0xff00000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_KINT			0xfffff
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_DOUBLER_EN		0x4000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_PD			0x2000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_RST			0x1000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_DIVN			0xf80
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_PREDIV			0x40
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_POSTDIV			0x20
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_REFCK_SEL			0x1c
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CLKOUTEXT_EN		0x2
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CLKOUTEN			0x1
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_SSC_DIV			0x7
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_R2_SEL			0x3800
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_R3_SEL			0x600
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_C2_SEL			0x1c0
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_FBDIV_EN			0x20
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_VCOBUF_EN			0x10
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CP_OFFSET			0xe
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CP_EN			0x1
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_BIST_EN			0x10000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_BIST_CNT			0xffff
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_RESERVED			0x1fffff
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_KDELTA			0xffff
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_KSTEP			0x7ffff
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_BG_RBIAS_MODE				0x40000000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_DUTY_FIT_EN			0x20000000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_26MBUFFER_BIASSEL		0x18000000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_26MBUFFER_PD			0x4000000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_26MBUFFER_TEST_EN		0x2000000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_PCIEPLLH_LDOOUT_SEL			0x1800000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_DIFF_OR_SING_SEL			0x400000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_LDO_TRIM			0x3c0000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_KVCO_SEL			0x38000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_VCTRLH_SEL		0x7000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_VCTRLL_SEL		0xe00
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_VCO_TEST_EN		0x100
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_VCO_TEST_INT		0x80
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_VCO_TEST_INTSEL		0x70
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_SHORT_CSR_EN		0x8
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_ALLOP_PD			0x4
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_TEST_VCO_PN		0x2
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_MANUAL_ADJ_PD		0x1
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_MODE			0x180000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_INI			0x7c000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_TRIG			0x2000
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_WAITCNT		0x1800
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_POLARITY		0x400
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_DONE			0x200
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_OUT			0x1f0
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_CPPD			0x8
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_VCTRL_HIGH		0x4
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CALI_VCTRL_LOW		0x2
#define MASK_ANLG_PHY_G2_RF_ANALOG_PCIEPLL_H_RG_PCIEPLLH_FREQ_DIFF_EN		0x1
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIEPLL_H_RG_PCIEPLLH_PD		0x8
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIEPLL_H_RG_PCIEPLLH_RST		0x4
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIEPLL_H_RG_PCIEPLLH_REFCK_SEL		0x2
#define MASK_ANLG_PHY_G2_RF_DBG_SEL_ANALOG_PCIEPLL_H_RG_PCIEPLLH_CLKOUTEN		0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_N					0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL0_RESERVED1			0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL0_RESERVED0			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL2_RESERVED1			0x38000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_POSTDIV				0x4000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL2_RESERVED0			0x3fff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_LPF				0x7000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_LDO_TRIM				0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CTRL4_RESERVED1			0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_FBDIV_EN				0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CP_EN				0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_CP_OFFSET				0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_BIST_CTRL				0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_OD_R8PLL_CLKOUT_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R8PLL_RESERVED				0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_N					0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_ICP_FS				0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_SDM_EN				0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_MOD_EN				0x2
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_DIV_S				0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_NINT				0x3f800000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_KINT				0x7fffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_IL_DIV				0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL2_RESERVED2			0xc000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL2_RESERVED1			0x3800
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL2_RESERVED0			0x7ff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_DIV_SEL				0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_SSC_CTRL				0xff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_R2_SEL				0xc000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_R3_SEL				0x3000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_LDO_TRIM				0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CTRL4_RESERVED0			0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_FBDIV_EN				0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CP_OFFSET				0xe
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_CP_EN				0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_BIST_CTRL				0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_OD_V3PLL_CLKOUT_EN			0x800
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_V3PLL_RESERVED				0x7ff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_N				0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL0_RESERVED1		0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL0_RESERVED0		0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL2_RESERVED2		0x1c0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL2_RESERVED1		0x38000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_POSTDIV			0x4000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL2_RESERVED0		0x3fff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_LPF				0x7000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_LDO_TRIM			0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CTRL4_RESERVED0		0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_FBDIV_EN			0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CP_OFFSET			0xe
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_CP_EN				0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_BIST_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_BIST_CNT			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_OD_NR_CPUPLL_CLKOUT_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_CPUPLL_RESERVED			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_N				0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL0_RESERVED1		0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL0_RESERVED0		0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL2_RESERVED2		0x1c0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL2_RESERVED1		0x38000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_POSTDIV			0x4000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL2_RESERVED0		0x3fff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_LPF				0x7000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_LDO_TRIM			0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CTRL4_RESERVED1		0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_FBDIV_EN			0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CP_OFFSET			0xe
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_CP_EN				0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_BIST_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_BIST_CNT			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_OD_NR_DSPPLL_CLKOUT_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NR_DSPPLL_RESERVED			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_N					0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_ICP_FS				0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_SDM_EN				0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_MOD_EN				0x2
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_DIV_S				0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_NINT				0x3f800000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_KINT				0x7fffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_IL_DIV				0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL2_RESERVED2			0xc000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL2_RESERVED1			0x3800
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL2_RESERVED0			0x7ff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_DIV_SEL				0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_SSC_CTRL				0xff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_R2_SEL				0xc000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_R3_SEL				0x3000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_LDO_TRIM				0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CTRL4_RESERVED0			0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_FBDIV_EN				0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CP_OFFSET				0xe
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_CP_EN				0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_BIST_CTRL				0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_OD_NRPLL_CLKOUT_EN			0x800
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_NRPLL_RESERVED				0x7ff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_TEST_CLK_EN				0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_TEST_CLK_DIV				0x3
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_ANALOG_TESTMUX				0x7ff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_ANALOG_PLL_RESERVED			0xfffffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_N					0x1ffc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CP_OFFSET				0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_POSTDIV				0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_FBDIV_EN				0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_CP_EN				0x2
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_OD_R5PLL_CLKOUT_EN			0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_LPF				0x70
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_LDO_TRIM				0xf
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_BIST_CTRL				0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_BIST_EN				0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_BIST_CNT				0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_PLL_TOP_R5PLL_RESERVED				0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_THM_BG_RBIAS_MODE			0x2000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_THM_TEST_SEL			0x1800
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_THM_BP_MODE			0x400
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_THM_BP_DATA			0x3ff
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N				0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL0_RESERVED1		0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL0_RESERVED		0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL2_RESERVED2		0x380000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_REFCK_SEL			0x40000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL2_RESERVED1		0x38000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV			0x4000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL2_RESERVED0		0x3ffe
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_TEST_CLKOUT_EN		0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_LPF				0x7000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_LDO_TRIM			0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CTRL4_RESERVED0		0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_FBDIV_EN			0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CP_OFFSET			0xe
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_CP_EN			0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_BIST_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_BIST_CNT			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_RESERVED			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N				0x7ff00
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL0_RESERVED1		0xc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP				0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL0_RESERVED		0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL2_RESERVED2		0x380000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_REFCK_SEL			0x40000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL2_RESERVED1		0x38000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV			0x4000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL2_RESERVED0		0x3ffe
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_TEST_CLKOUT_EN		0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_LPF				0x7000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_LDO_TRIM			0xf00
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CTRL4_RESERVED0		0xe0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_FBDIV_EN			0x10
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CP_OFFSET			0xe
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_CP_EN			0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_BIST_CTRL			0x1fe0000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_BIST_EN			0x10000
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_BIST_CNT			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_RESERVED			0xffff
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_ANALOG_MPLL_RESERVED		0x7ffffc0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_TEST_CLK_DIV			0x38
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_TEST_CLK_SEL			0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_TEST_CLK_EN			0x2
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_TEST_THM_EN			0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX0			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX0		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX0			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX1			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX1		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX1			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX2			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX2		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX2			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX3			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX3		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX3			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX4			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX4		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX4			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX5			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX5		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX5			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX6			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX6		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX6			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_N_INDEX7			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_POSTDIV_INDEX7		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL0_ICP_INDEX7			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_DBG_SEL_ANALOG_MPLL0_MPLL0_ICP	0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_DBG_SEL_ANALOG_MPLL0_MPLL0_N	0x2
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_DBG_SEL_ANALOG_MPLL0_MPLL0_POSTDIV	0x1
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX0			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX0		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX0			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX1			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX1		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX1			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX2			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX2		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX2			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX3			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX3		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX3			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX4			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX4		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX4			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX5			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX5		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX5			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX6			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX6		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX6			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_N_INDEX7			0x7ff0
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_POSTDIV_INDEX7		0x8
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_MPLL1_ICP_INDEX7			0x7
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_DBG_SEL_ANALOG_MPLL1_MPLL1_ICP	0x4
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_DBG_SEL_ANALOG_MPLL1_MPLL1_N	0x2
#define MASK_ANLG_PHY_G3_RF_ANALOG_MPLL_THM_TOP_DBG_SEL_ANALOG_MPLL1_MPLL1_POSTDIV	0x1
#define MASK_AP_AHB_RF_EMMC_32K_EB							0x1000
#define MASK_AP_AHB_RF_EMMC_EB							0x800
#define MASK_AP_AHB_RF_SDIO_MST_32K_EB						0x400
#define MASK_AP_AHB_RF_SDIO_MST_EB							0x200
#define MASK_AP_AHB_RF_USB0_REF_EB							0x100
#define MASK_AP_AHB_RF_USB0_SUSPEND_EB						0x80
#define MASK_AP_AHB_RF_USB0_EB							0x40
#define MASK_AP_AHB_RF_DMA_EB2							0x20
#define MASK_AP_AHB_RF_DMA_EB							0x10
#define MASK_AP_AHB_RF_NANDC_26M_EB						0x8
#define MASK_AP_AHB_RF_NANDC_ECC_EB						0x4
#define MASK_AP_AHB_RF_NANDC_EB							0x2
#define MASK_AP_AHB_RF_CKG_EB							0x1
#define MASK_AP_AHB_RF_EMMC_SOFT_RST						0x10
#define MASK_AP_AHB_RF_SDIO_MST_SOFT_RST						0x8
#define MASK_AP_AHB_RF_DMA_SOFT_RST						0x4
#define MASK_AP_AHB_RF_USB0_SOFT_RST						0x2
#define MASK_AP_AHB_RF_NANDC_SOFT_RST						0x1
#define MASK_AP_AHB_RF_SLEEP_FOLLOW_APCPU_EN					0x20
#define MASK_AP_AHB_RF_APCPU_SYS_SW_SLEEP						0x10
#define MASK_AP_AHB_RF_DMA_ACT_LIGHT_EN						0x8
#define MASK_AP_AHB_RF_AP_APB_FRC_SLP						0x4
#define MASK_AP_AHB_RF_AP_PERI_FRC_SLP						0x2
#define MASK_AP_AHB_RF_AP_PERI_FRC_ON						0x1
#define MASK_AP_AHB_RF_APB2APB_SCLK_AUTO_GATE_EN					0x2000
#define MASK_AP_AHB_RF_APB2APB_MCLK_AUTO_GATE_EN					0x1000
#define MASK_AP_AHB_RF_CGM_CLK_AON_AXI_AUTO_GATE_EN				0x800
#define MASK_AP_AHB_RF_CGM_CLK_APCPU_AXI_AUTO_GATE_EN				0x400
#define MASK_AP_AHB_RF_AP_AXI_BUS_IDLE_BYPASS_USB0					0x200
#define MASK_AP_AHB_RF_AP_AXI_BUS_IDLE_BYPASS_NANDC				0x100
#define MASK_AP_AHB_RF_AP_AXI_BUS_IDLE_BYPASS_SDIO_MST				0x80
#define MASK_AP_AHB_RF_AP_AXI_BUS_IDLE_BYPASS_EMMC					0x40
#define MASK_AP_AHB_RF_AP_AXI_BUS_IDLE_BYPASS_APCPU				0x20
#define MASK_AP_AHB_RF_AP_AXI_BUS_IDLE_BYPASS_DMA					0x10
#define MASK_AP_AHB_RF_AP_PERI_APB_AUTO_CONTROL_SEL				0x8
#define MASK_AP_AHB_RF_AP_PERI_APB_AUTO_MUX_SEL					0x6
#define MASK_AP_AHB_RF_AP_PERI_APB_AUTO_MUX_EN					0x1
#define MASK_AP_AHB_RF_PIPE3_POWERPRESENT0						0x10000
#define MASK_AP_AHB_RF_UTMISRP_BVALID_REG0						0x8000
#define MASK_AP_AHB_RF_OTG_VBUS_VALID_PHYREG0					0x4000
#define MASK_AP_AHB_RF_OTG_VBUS_VALID_PHYREG_SEL0					0x2000
#define MASK_AP_AHB_RF_HOST_SYSTEM_ERR0						0x1000
#define MASK_AP_AHB_RF_HOST_PORT_POWER_CONTROL_PRESENT0				0x800
#define MASK_AP_AHB_RF_FLADJ_30MHZ_REG0						0x7e0
#define MASK_AP_AHB_RF_PME_EN0							0x10
#define MASK_AP_AHB_RF_BUS_FILTER_BYPASS0						0xf
#define MASK_AP_AHB_RF_USB0_DUG_0							0xffffffff
#define MASK_AP_AHB_RF_USB0_DUG_1							0xffffffff
#define MASK_AP_AHB_RF_USB0_HOST_CURRENT_BELT					0x3ffc0
#define MASK_AP_AHB_RF_USB0_CLK_GATE_CTRL						0x38
#define MASK_AP_AHB_RF_USB0_DUG_2							0x7
#define MASK_AP_AHB_RF_SDIO_MST_PCLK_AUTO_GATE_EB					0x2
#define MASK_AP_AHB_RF_EMMC_PCLK_AUTO_GATE_EB					0x1
#define MASK_AP_AHB_RF_SDIO_MST_PCLK_AUTO_SLOW_EN					0x80
#define MASK_AP_AHB_RF_SDIO_MST_PCLK_AUTO_SLOW_SEL					0x70
#define MASK_AP_AHB_RF_EMMC_PCLK_AUTO_SLOW_EN					0x8
#define MASK_AP_AHB_RF_EMMC_PCLK_AUTO_SLOW_SEL					0x7
#define MASK_AP_AHB_RF_PCIE_AUX_CLK_FRC_OFF					0x20000000
#define MASK_AP_AHB_RF_USB1_SUSPEND_CLK_FRC_OFF					0x10000000
#define MASK_AP_AHB_RF_USB1_REF_CLK_FRC_OFF					0x8000000
#define MASK_AP_AHB_RF_USB0_SUSPEND_CLK_FRC_OFF					0x4000000
#define MASK_AP_AHB_RF_USB0_REF_CLK_FRC_OFF					0x2000000
#define MASK_AP_AHB_RF_NANDC_CLK_FRC_OFF						0x1000000
#define MASK_AP_AHB_RF_NANDC_ECC_CLK_FRC_OFF					0x800000
#define MASK_AP_AHB_RF_NANDC_26M_CLK_FRC_OFF					0x400000
#define MASK_AP_AHB_RF_EMMC_CLK_FRC_OFF						0x200000
#define MASK_AP_AHB_RF_EMMC_32K_CLK_FRC_OFF					0x100000
#define MASK_AP_AHB_RF_SDIO_SLV_CLK_FRC_OFF					0x80000
#define MASK_AP_AHB_RF_SDIO_SLV_FRUN_CLK_FRC_OFF					0x40000
#define MASK_AP_AHB_RF_SDIO_MST_CLK_FRC_OFF					0x20000
#define MASK_AP_AHB_RF_SDIO_MST_32K_CLK_FRC_OFF					0x10000
#define MASK_AP_AHB_RF_SIM0_32K_CLK_FRC_OFF					0x8000
#define MASK_AP_AHB_RF_SIM0_CLK_FRC_OFF						0x4000
#define MASK_AP_AHB_RF_PWM3_CLK_FRC_OFF						0x2000
#define MASK_AP_AHB_RF_PWM2_CLK_FRC_OFF						0x1000
#define MASK_AP_AHB_RF_PWM1_CLK_FRC_OFF						0x800
#define MASK_AP_AHB_RF_PWM0_CLK_FRC_OFF						0x400
#define MASK_AP_AHB_RF_SPI2_CLK_FRC_OFF						0x200
#define MASK_AP_AHB_RF_SPI1_CLK_FRC_OFF						0x100
#define MASK_AP_AHB_RF_SPI0_CLK_FRC_OFF						0x80
#define MASK_AP_AHB_RF_I2C4_CLK_FRC_OFF						0x40
#define MASK_AP_AHB_RF_I2C3_CLK_FRC_OFF						0x20
#define MASK_AP_AHB_RF_I2C2_CLK_FRC_OFF						0x10
#define MASK_AP_AHB_RF_I2C1_CLK_FRC_OFF						0x8
#define MASK_AP_AHB_RF_I2C0_CLK_FRC_OFF						0x4
#define MASK_AP_AHB_RF_UART0_CLK_FRC_OFF						0x2
#define MASK_AP_AHB_RF_AP_APB_CLK_FRC_OFF						0x1
#define MASK_AP_AHB_RF_PCIE_AUX_CLK_FRC_ON						0x20000000
#define MASK_AP_AHB_RF_USB1_SUSPEND_CLK_FRC_ON					0x10000000
#define MASK_AP_AHB_RF_USB1_REF_CLK_FRC_ON						0x8000000
#define MASK_AP_AHB_RF_USB0_SUSPEND_CLK_FRC_ON					0x4000000
#define MASK_AP_AHB_RF_USB0_REF_CLK_FRC_ON						0x2000000
#define MASK_AP_AHB_RF_NANDC_CLK_FRC_ON						0x1000000
#define MASK_AP_AHB_RF_NANDC_ECC_CLK_FRC_ON					0x800000
#define MASK_AP_AHB_RF_NANDC_26M_CLK_FRC_ON					0x400000
#define MASK_AP_AHB_RF_EMMC_CLK_FRC_ON						0x200000
#define MASK_AP_AHB_RF_EMMC_32K_CLK_FRC_ON						0x100000
#define MASK_AP_AHB_RF_SDIO_SLV_CLK_FRC_ON						0x80000
#define MASK_AP_AHB_RF_SDIO_SLV_FRUN_CLK_FRC_ON					0x40000
#define MASK_AP_AHB_RF_SDIO_MST_CLK_FRC_ON						0x20000
#define MASK_AP_AHB_RF_SDIO_MST_32K_CLK_FRC_ON					0x10000
#define MASK_AP_AHB_RF_SIM0_32K_CLK_FRC_ON						0x8000
#define MASK_AP_AHB_RF_SIM0_CLK_FRC_ON						0x4000
#define MASK_AP_AHB_RF_PWM3_CLK_FRC_ON						0x2000
#define MASK_AP_AHB_RF_PWM2_CLK_FRC_ON						0x1000
#define MASK_AP_AHB_RF_PWM1_CLK_FRC_ON						0x800
#define MASK_AP_AHB_RF_PWM0_CLK_FRC_ON						0x400
#define MASK_AP_AHB_RF_SPI2_CLK_FRC_ON						0x200
#define MASK_AP_AHB_RF_SPI1_CLK_FRC_ON						0x100
#define MASK_AP_AHB_RF_SPI0_CLK_FRC_ON						0x80
#define MASK_AP_AHB_RF_I2C4_CLK_FRC_ON						0x40
#define MASK_AP_AHB_RF_I2C3_CLK_FRC_ON						0x20
#define MASK_AP_AHB_RF_I2C2_CLK_FRC_ON						0x10
#define MASK_AP_AHB_RF_I2C1_CLK_FRC_ON						0x8
#define MASK_AP_AHB_RF_I2C0_CLK_FRC_ON						0x4
#define MASK_AP_AHB_RF_UART0_CLK_FRC_ON						0x2
#define MASK_AP_AHB_RF_AP_APB_CLK_FRC_ON						0x1
#define MASK_AP_AHB_RF_PCIE_AUX_CLK_BUS_AUTO_EN					0x800000
#define MASK_AP_AHB_RF_USB1_REF_CLK_BUS_AUTO_EN					0x400000
#define MASK_AP_AHB_RF_USB0_REF_CLK_BUS_AUTO_EN					0x200000
#define MASK_AP_AHB_RF_NANDC_ECC_CLK_BUS_AUTO_EN					0x100000
#define MASK_AP_AHB_RF_NANDC_26M_CLK_BUS_AUTO_EN					0x80000
#define MASK_AP_AHB_RF_EMMC_32K_CLK_BUS_AUTO_EN					0x40000
#define MASK_AP_AHB_RF_SDIO_SLV_FRUN_CLK_BUS_AUTO_EN				0x20000
#define MASK_AP_AHB_RF_SDIO_MST_32K_CLK_BUS_AUTO_EN				0x10000
#define MASK_AP_AHB_RF_SIM0_32K_CLK_BUS_AUTO_EN					0x8000
#define MASK_AP_AHB_RF_SIM0_CLK_BUS_AUTO_EN					0x4000
#define MASK_AP_AHB_RF_PWM3_CLK_BUS_AUTO_EN					0x2000
#define MASK_AP_AHB_RF_PWM2_CLK_BUS_AUTO_EN					0x1000
#define MASK_AP_AHB_RF_PWM1_CLK_BUS_AUTO_EN					0x800
#define MASK_AP_AHB_RF_PWM0_CLK_BUS_AUTO_EN					0x400
#define MASK_AP_AHB_RF_SPI2_CLK_BUS_AUTO_EN					0x200
#define MASK_AP_AHB_RF_SPI1_CLK_BUS_AUTO_EN					0x100
#define MASK_AP_AHB_RF_SPI0_CLK_BUS_AUTO_EN					0x80
#define MASK_AP_AHB_RF_I2C4_CLK_BUS_AUTO_EN					0x40
#define MASK_AP_AHB_RF_I2C3_CLK_BUS_AUTO_EN					0x20
#define MASK_AP_AHB_RF_I2C2_CLK_BUS_AUTO_EN					0x10
#define MASK_AP_AHB_RF_I2C1_CLK_BUS_AUTO_EN					0x8
#define MASK_AP_AHB_RF_I2C0_CLK_BUS_AUTO_EN					0x4
#define MASK_AP_AHB_RF_UART0_CLK_BUS_AUTO_EN					0x2
#define MASK_AP_AHB_RF_AP_APB_CLK_BUS_AUTO_EN					0x1
#define MASK_AP_AHB_RF_CACTIVE_SLV3_WAKEUP_EN					0x8
#define MASK_AP_AHB_RF_AP_CLK_GATE_LPC_BYP						0x4
#define MASK_AP_AHB_RF_LP_AUTO_CTRL_EN						0x2
#define MASK_AP_AHB_RF_MMTX_LPC_DISABLE						0x1
#define MASK_AP_AHB_RF_MMTX_M0_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_MMTX_M0_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M0_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_M1_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M1_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_M2_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M2_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_M3_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_MMTX_M3_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M3_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_M4_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M4_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_M5_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M5_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_M6_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_M6_LP_NUM						0xffff
#define MASK_AP_AHB_RF_CGM_MMTX_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_MAIN_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_MAIN_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S0_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S0_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S0_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S0_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S1_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S1_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S1_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S1_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S2_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S2_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S2_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S2_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S3_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S3_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S3_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S3_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S4_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S4_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S4_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S4_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S5_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S5_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S5_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S5_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S6_LP_EARLY_WAKEUP_EN					0x40000
#define MASK_AP_AHB_RF_CGM_MMTX_S6_AUTO_GATE_EN					0x20000
#define MASK_AP_AHB_RF_MMTX_S6_LP_EB						0x10000
#define MASK_AP_AHB_RF_MMTX_S6_LP_NUM						0xffff
#define MASK_AP_AHB_RF_MMTX_S6_FRC_LSLP						0x80
#define MASK_AP_AHB_RF_MMTX_M6_FRC_LSLP						0x40
#define MASK_AP_AHB_RF_MMTX_M5_FRC_LSLP						0x20
#define MASK_AP_AHB_RF_MMTX_M4_FRC_LSLP						0x10
#define MASK_AP_AHB_RF_MMTX_M3_FRC_LSLP						0x8
#define MASK_AP_AHB_RF_MMTX_M2_FRC_LSLP						0x4
#define MASK_AP_AHB_RF_MMTX_M1_FRC_LSLP						0x2
#define MASK_AP_AHB_RF_LSLP_MMTX_S6_LPC_BYPASS					0x80
#define MASK_AP_AHB_RF_LSLP_MMTX_M6_LPC_BYPASS					0x40
#define MASK_AP_AHB_RF_LSLP_MMTX_M5_LPC_BYPASS					0x20
#define MASK_AP_AHB_RF_LSLP_MMTX_M4_LPC_BYPASS					0x10
#define MASK_AP_AHB_RF_LSLP_MMTX_M3_LPC_BYPASS					0x8
#define MASK_AP_AHB_RF_LSLP_MMTX_M2_LPC_BYPASS					0x4
#define MASK_AP_AHB_RF_LSLP_MMTX_M1_LPC_BYPASS					0x2
#define MASK_AP_AHB_RF_MMTX_S6_FRC_PUB_DSLP					0x80
#define MASK_AP_AHB_RF_MMTX_M6_FRC_PUB_DSLP					0x40
#define MASK_AP_AHB_RF_MMTX_M5_FRC_PUB_DSLP					0x20
#define MASK_AP_AHB_RF_MMTX_M4_FRC_PUB_DSLP					0x10
#define MASK_AP_AHB_RF_MMTX_M3_FRC_PUB_DSLP					0x8
#define MASK_AP_AHB_RF_MMTX_M2_FRC_PUB_DSLP					0x4
#define MASK_AP_AHB_RF_MMTX_M1_FRC_PUB_DSLP					0x2
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_S6_LPC_BYPASS					0x80
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_M6_LPC_BYPASS					0x40
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_M5_LPC_BYPASS					0x20
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_M4_LPC_BYPASS					0x10
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_M3_LPC_BYPASS					0x8
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_M2_LPC_BYPASS					0x4
#define MASK_AP_AHB_RF_PUB_DSLP_MMTX_M1_LPC_BYPASS					0x2
#define MASK_AP_AHB_RF_MMTX_M6_FRC_DOZE						0x40
#define MASK_AP_AHB_RF_MMTX_M5_FRC_DOZE						0x20
#define MASK_AP_AHB_RF_MMTX_M4_FRC_DOZE						0x10
#define MASK_AP_AHB_RF_MMTX_M3_FRC_DOZE						0x8
#define MASK_AP_AHB_RF_MMTX_M2_FRC_DOZE						0x4
#define MASK_AP_AHB_RF_MMTX_M1_FRC_DOZE						0x2
#define MASK_AP_AHB_RF_MMTX_M0_FRC_DOZE						0x1
#define MASK_AP_AHB_RF_DOZE_MMTX_MAIN_LPC_BYPASS					0x4000
#define MASK_AP_AHB_RF_DOZE_MMTX_S6_LPC_BYPASS					0x2000
#define MASK_AP_AHB_RF_DOZE_MMTX_S5_LPC_BYPASS					0x1000
#define MASK_AP_AHB_RF_DOZE_MMTX_S4_LPC_BYPASS					0x800
#define MASK_AP_AHB_RF_DOZE_MMTX_S3_LPC_BYPASS					0x400
#define MASK_AP_AHB_RF_DOZE_MMTX_S2_LPC_BYPASS					0x200
#define MASK_AP_AHB_RF_DOZE_MMTX_S1_LPC_BYPASS					0x100
#define MASK_AP_AHB_RF_DOZE_MMTX_S0_LPC_BYPASS					0x80
#define MASK_AP_AHB_RF_DOZE_MMTX_M6_LPC_BYPASS					0x40
#define MASK_AP_AHB_RF_DOZE_MMTX_M5_LPC_BYPASS					0x20
#define MASK_AP_AHB_RF_DOZE_MMTX_M4_LPC_BYPASS					0x10
#define MASK_AP_AHB_RF_DOZE_MMTX_M3_LPC_BYPASS					0x8
#define MASK_AP_AHB_RF_DOZE_MMTX_M2_LPC_BYPASS					0x4
#define MASK_AP_AHB_RF_DOZE_MMTX_M1_LPC_BYPASS					0x2
#define MASK_AP_AHB_RF_DOZE_MMTX_M0_LPC_BYPASS					0x1
#define MASK_AP_AHB_RF_MMTX_AXI_FREQ_DFS_SW					0xf0000000
#define MASK_AP_AHB_RF_MMTX_M6_AXI_FREQ_ALLOW					0xf000000
#define MASK_AP_AHB_RF_MMTX_M5_AXI_FREQ_ALLOW					0xf00000
#define MASK_AP_AHB_RF_MMTX_M4_AXI_FREQ_ALLOW					0xf0000
#define MASK_AP_AHB_RF_MMTX_M3_AXI_FREQ_ALLOW					0xf000
#define MASK_AP_AHB_RF_MMTX_M2_AXI_FREQ_ALLOW					0xf00
#define MASK_AP_AHB_RF_MMTX_M1_AXI_FREQ_ALLOW					0xf0
#define MASK_AP_AHB_RF_MMTX_M0_AXI_FREQ_ALLOW					0xf
#define MASK_AP_AHB_RF_MMTX_AXI_FREQ_DFS_MODE					0x3
#define MASK_AP_AHB_RF_MMTX_AXI_FREQ_LSLP_DFS_SW					0xf0000000
#define MASK_AP_AHB_RF_MMTX_M6_AXI_FREQ_LSLP_ALLOW					0xf000000
#define MASK_AP_AHB_RF_MMTX_M5_AXI_FREQ_LSLP_ALLOW					0xf00000
#define MASK_AP_AHB_RF_MMTX_M4_AXI_FREQ_LSLP_ALLOW					0xf0000
#define MASK_AP_AHB_RF_MMTX_M3_AXI_FREQ_LSLP_ALLOW					0xf000
#define MASK_AP_AHB_RF_MMTX_M2_AXI_FREQ_LSLP_ALLOW					0xf00
#define MASK_AP_AHB_RF_MMTX_M1_AXI_FREQ_LSLP_ALLOW					0xf0
#define MASK_AP_AHB_RF_MMTX_M0_AXI_FREQ_LSLP_ALLOW					0xf
#define MASK_AP_AHB_RF_MMTX_AXI_FREQ_LSLP_DFS_MODE					0x3
#define MASK_AP_AHB_RF_ARQOS_USB0							0xf0000000
#define MASK_AP_AHB_RF_AWQOS_USB0							0xf000000
#define MASK_AP_AHB_RF_ARQOS_EMMC							0xf00000
#define MASK_AP_AHB_RF_AWQOS_EMMC							0xf0000
#define MASK_AP_AHB_RF_ARQOS_SDIO_MST						0xf000
#define MASK_AP_AHB_RF_AWQOS_SDIO_MST						0xf00
#define MASK_AP_AHB_RF_ARQOS_NANDC							0xf0
#define MASK_AP_AHB_RF_AWQOS_NANDC							0xf
#define MASK_AP_AHB_RF_ARQOS_DMA							0xf0
#define MASK_AP_AHB_RF_AWQOS_DMA							0xf
#define MASK_AP_AHB_RF_ARURGENCY_DMA						0xc0000
#define MASK_AP_AHB_RF_AWURGENCY_DMA						0x30000
#define MASK_AP_AHB_RF_ARURGENCY_USB0						0xc000
#define MASK_AP_AHB_RF_AWURGENCY_USB0						0x3000
#define MASK_AP_AHB_RF_ARURGENCY_EMMC						0xc00
#define MASK_AP_AHB_RF_AWURGENCY_EMMC						0x300
#define MASK_AP_AHB_RF_ARURGENCY_SDIO_MST						0xc0
#define MASK_AP_AHB_RF_AWURGENCY_SDIO_MST						0x30
#define MASK_AP_AHB_RF_ARURGENCY_NANDC						0xc
#define MASK_AP_AHB_RF_AWURGENCY_NANDC						0x3
#define MASK_AP_AHB_RF_ARUSER_EMMC							0xff000000
#define MASK_AP_AHB_RF_AWUSER_EMMC							0xff0000
#define MASK_AP_AHB_RF_ARUSER_SDIO_MST						0xff00
#define MASK_AP_AHB_RF_AWUSER_SDIO_MST						0xff
#define MASK_AP_AHB_RF_ARUSER_USB0							0xff000000
#define MASK_AP_AHB_RF_AWUSER_USB0							0xff0000
#define MASK_AP_AHB_RF_ARUSER_NANDC						0xff00
#define MASK_AP_AHB_RF_AWUSER_NANDC						0xff
#define MASK_AP_AHB_RF_MMTX_BUSMON_ENABLE						0x1
#define MASK_AP_AHB_RF_MMTX_M3_PU_NUM						0xff000000
#define MASK_AP_AHB_RF_MMTX_M2_PU_NUM						0xff0000
#define MASK_AP_AHB_RF_MMTX_M1_PU_NUM						0xff00
#define MASK_AP_AHB_RF_MMTX_M0_PU_NUM						0xff
#define MASK_AP_AHB_RF_MMTX_MAIN_PU_NUM						0xff000000
#define MASK_AP_AHB_RF_MMTX_M6_PU_NUM						0xff0000
#define MASK_AP_AHB_RF_MMTX_M5_PU_NUM						0xff00
#define MASK_AP_AHB_RF_MMTX_M4_PU_NUM						0xff
#define MASK_AP_AHB_RF_MMTX_S3_PU_NUM						0xff000000
#define MASK_AP_AHB_RF_MMTX_S2_PU_NUM						0xff0000
#define MASK_AP_AHB_RF_MMTX_S1_PU_NUM						0xff00
#define MASK_AP_AHB_RF_MMTX_S0_PU_NUM						0xff
#define MASK_AP_AHB_RF_MMTX_S6_PU_NUM						0xff0000
#define MASK_AP_AHB_RF_MMTX_S5_PU_NUM						0xff00
#define MASK_AP_AHB_RF_MMTX_S4_PU_NUM						0xff
#define MASK_AP_AHB_RF_DDR_BUSY_GATING_EB						0x2
#define MASK_AP_AHB_RF_DMA_BUSY_GATING_EB						0x1
#define MASK_AP_AHB_RF_RESERVE0							0xffffffff
#define MASK_AP_AHB_RF_RESERVE1							0xffffffff
#define MASK_AP_AHB_RF_CHIP_ID							0xffffffff
#define MASK_PMU_APB_RF_PD_APCPU_TOP_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_TOP_PD_SEL					0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_TOP_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_TOP_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_TOP_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_APCPU_TOP_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C0_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C0_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C0_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C0_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C0_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C0_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C0_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C0_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C1_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C1_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C1_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C1_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C1_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C1_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C1_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C1_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C2_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C2_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C2_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C2_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C2_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C2_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C2_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C2_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C3_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C3_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C3_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C3_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C3_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C3_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C3_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C3_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_TOP_DCDC_PWR_ON_DLY				0xff00
#define MASK_PMU_APB_RF_PD_APCPU_TOP_DCDC_PWR_OFF_DLY				0xff
#define MASK_PMU_APB_RF_PD_NRCP_SYS_DBG_SHUTDOWN_EN				0x8000000
#define MASK_PMU_APB_RF_PD_NRCP_SYS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_NRCP_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_SYS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_NRCP_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_AP_SYS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_AP_SYS_AUTO_SHUTDOWN_EN					0x1000000
#define MASK_PMU_APB_RF_PD_AP_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_AP_SYS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_AP_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_NRCP_DL_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DL_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_NRCP_DL_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_DL_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_NRCP_DL_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_NRCP_UL_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_UL_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_NRCP_UL_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_UL_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_NRCP_UL_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_A_SHUTDOWN_DLY				0xff000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_A_RST_DEASSERT_DLY				0xff0000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_A_RST_ASSERT_DLY				0xff00
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_A_ISO_OFF_DLY				0xff
#define MASK_PMU_APB_RF_PD_V3_PS_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_V3_PS_DBG_SHUTDOWN_EN					0x4000000
#define MASK_PMU_APB_RF_PD_V3_PS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_V3_PS_AUTO_SHUTDOWN_EN					0x1000000
#define MASK_PMU_APB_RF_PD_V3_PS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_PS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_V3_PS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_LCE_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_V3_LCE_AUTO_SHUTDOWN_EN					0x1000000
#define MASK_PMU_APB_RF_PD_V3_LCE_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_LCE_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_V3_LCE_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_DPFEC_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_V3_DPFEC_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_PD_SEL					0x8000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_PD_SEL					0x8000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_WCE_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_V3_WCE_AUTO_SHUTDOWN_EN					0x1000000
#define MASK_PMU_APB_RF_PD_V3_WCE_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_WCE_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_V3_WCE_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_PHY_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_V3_PHY_DBG_SHUTDOWN_EN					0x4000000
#define MASK_PMU_APB_RF_PD_V3_PHY_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_V3_PHY_AUTO_SHUTDOWN_EN					0x1000000
#define MASK_PMU_APB_RF_PD_V3_PHY_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_PHY_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_V3_PHY_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_LWPROC_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_V3_LWPROC_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_TD_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_V3_TD_AUTO_SHUTDOWN_EN					0x1000000
#define MASK_PMU_APB_RF_PD_V3_TD_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_TD_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_V3_TD_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_PSCP_SYS_DBG_SHUTDOWN_EN				0x4000000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_PSCP_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_PD_SEL					0x8000000
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PUBCP_FRC_STOP_REQ_FOR_WTL					0x1
#define MASK_PMU_APB_RF_PD_PUB_SYS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_PUB_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_PUB_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_PUB_SYS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_PUB_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_AP_WAKEUP_POR_N						0x1
#define MASK_PMU_APB_RF_XTLBUF1_WAIT_CNT						0xff000000
#define MASK_PMU_APB_RF_XTLBUF0_WAIT_CNT						0xff0000
#define MASK_PMU_APB_RF_XTL1_WAIT_CNT						0xff00
#define MASK_PMU_APB_RF_XTL0_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_PCIEPLL_H_WAIT_CNT						0xff000000
#define MASK_PMU_APB_RF_R8PLL_WAIT_CNT						0xff0000
#define MASK_PMU_APB_RF_MPLL1_WAIT_CNT						0xff00
#define MASK_PMU_APB_RF_MPLL0_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_V3PLL_WAIT_CNT						0xff000000
#define MASK_PMU_APB_RF_NRPLL_WAIT_CNT						0xff0000
#define MASK_PMU_APB_RF_DPLL1_WAIT_CNT						0xff00
#define MASK_PMU_APB_RF_DPLL0_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_NR_RPLL_WAIT_CNT						0xff000000
#define MASK_PMU_APB_RF_V3_RPLL_WAIT_CNT						0xff0000
#define MASK_PMU_APB_RF_NR_CPUPLL_WAIT_CNT						0xff00
#define MASK_PMU_APB_RF_NR_DSPPLL_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_XTL0_IPA_SEL						0x400
#define MASK_PMU_APB_RF_XTL0_FRC_OFF						0x200
#define MASK_PMU_APB_RF_XTL0_FRC_ON						0x100
#define MASK_PMU_APB_RF_XTL0_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_XTL0_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_XTL0_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_XTL0_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_XTL0_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_XTL0_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_XTL0_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_XTL0_AP_SEL						0x1
#define MASK_PMU_APB_RF_XTL1_IPA_SEL						0x400
#define MASK_PMU_APB_RF_XTL1_FRC_OFF						0x200
#define MASK_PMU_APB_RF_XTL1_FRC_ON						0x100
#define MASK_PMU_APB_RF_XTL1_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_XTL1_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_XTL1_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_XTL1_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_XTL1_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_XTL1_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_XTL1_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_XTL1_AP_SEL						0x1
#define MASK_PMU_APB_RF_NR_RPLL_IPA_SEL						0x800
#define MASK_PMU_APB_RF_NR_RPLL_REF_SEL						0x400
#define MASK_PMU_APB_RF_NR_RPLL_FRC_OFF						0x200
#define MASK_PMU_APB_RF_NR_RPLL_FRC_ON						0x100
#define MASK_PMU_APB_RF_NR_RPLL_TOP_DVFS_SEL					0x80
#define MASK_PMU_APB_RF_NR_RPLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_NR_RPLL_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_NR_RPLL_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_NR_RPLL_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_NR_RPLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_NR_RPLL_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_NR_RPLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_XTLBUF0_IPA_SEL						0x400
#define MASK_PMU_APB_RF_XTLBUF0_FRC_OFF						0x200
#define MASK_PMU_APB_RF_XTLBUF0_FRC_ON						0x100
#define MASK_PMU_APB_RF_XTLBUF0_TOP_DVFS_SEL					0x80
#define MASK_PMU_APB_RF_XTLBUF0_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_XTLBUF0_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_XTLBUF0_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_XTLBUF0_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_XTLBUF0_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_XTLBUF0_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_XTLBUF0_AP_SEL						0x1
#define MASK_PMU_APB_RF_XTLBUF1_IPA_SEL						0x400
#define MASK_PMU_APB_RF_XTLBUF1_FRC_OFF						0x200
#define MASK_PMU_APB_RF_XTLBUF1_FRC_ON						0x100
#define MASK_PMU_APB_RF_XTLBUF1_TOP_DVFS_SEL					0x80
#define MASK_PMU_APB_RF_XTLBUF1_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_XTLBUF1_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_XTLBUF1_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_XTLBUF1_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_XTLBUF1_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_XTLBUF1_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_XTLBUF1_AP_SEL						0x1
#define MASK_PMU_APB_RF_DPLL0_IPA_SEL						0x800
#define MASK_PMU_APB_RF_DPLL0_REF_SEL						0x400
#define MASK_PMU_APB_RF_DPLL0_FRC_OFF						0x200
#define MASK_PMU_APB_RF_DPLL0_FRC_ON						0x100
#define MASK_PMU_APB_RF_DPLL0_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_DPLL0_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_DPLL0_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_DPLL0_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_DPLL0_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_DPLL0_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_DPLL0_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_DPLL0_AP_SEL						0x1
#define MASK_PMU_APB_RF_DPLL1_IPA_SEL						0x800
#define MASK_PMU_APB_RF_DPLL1_REF_SEL						0x400
#define MASK_PMU_APB_RF_DPLL1_FRC_OFF						0x200
#define MASK_PMU_APB_RF_DPLL1_FRC_ON						0x100
#define MASK_PMU_APB_RF_DPLL1_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_DPLL1_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_DPLL1_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_DPLL1_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_DPLL1_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_DPLL1_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_DPLL1_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_DPLL1_AP_SEL						0x1
#define MASK_PMU_APB_RF_V3PLL_IPA_SEL						0x1000
#define MASK_PMU_APB_RF_V3PLL_REF_SEL						0xc00
#define MASK_PMU_APB_RF_V3PLL_FRC_OFF						0x200
#define MASK_PMU_APB_RF_V3PLL_FRC_ON						0x100
#define MASK_PMU_APB_RF_V3PLL_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_V3PLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_V3PLL_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_V3PLL_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_V3PLL_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_V3PLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_V3PLL_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_V3PLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_NRPLL_IPA_SEL						0x1000
#define MASK_PMU_APB_RF_NRPLL_REF_SEL						0xc00
#define MASK_PMU_APB_RF_NRPLL_FRC_OFF						0x200
#define MASK_PMU_APB_RF_NRPLL_FRC_ON						0x100
#define MASK_PMU_APB_RF_NRPLL_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_NRPLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_NRPLL_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_NRPLL_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_NRPLL_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_NRPLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_NRPLL_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_NRPLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_V3_RPLL_IPA_SEL						0x800
#define MASK_PMU_APB_RF_V3_RPLL_REF_SEL						0x400
#define MASK_PMU_APB_RF_V3_RPLL_FRC_OFF						0x200
#define MASK_PMU_APB_RF_V3_RPLL_FRC_ON						0x100
#define MASK_PMU_APB_RF_V3_RPLL_TOP_DVFS_SEL					0x80
#define MASK_PMU_APB_RF_V3_RPLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_V3_RPLL_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_V3_RPLL_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_V3_RPLL_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_V3_RPLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_V3_RPLL_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_V3_RPLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_R8PLL_IPA_SEL						0x1000
#define MASK_PMU_APB_RF_R8PLL_REF_SEL						0x400
#define MASK_PMU_APB_RF_R8PLL_FRC_OFF						0x200
#define MASK_PMU_APB_RF_R8PLL_FRC_ON						0x100
#define MASK_PMU_APB_RF_R8PLL_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_R8PLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_R8PLL_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_R8PLL_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_R8PLL_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_R8PLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_R8PLL_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_R8PLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_NRCP_SYS_SOFT_RST						0x20000
#define MASK_PMU_APB_RF_AP_VSP_SOFT_RST						0x10000
#define MASK_PMU_APB_RF_NRCP_DSP_1_SOFT_RST					0x8000
#define MASK_PMU_APB_RF_NRCP_DSP_0_SOFT_RST					0x4000
#define MASK_PMU_APB_RF_NRCP_AON_SOFT_RST						0x2000
#define MASK_PMU_APB_RF_V3_MODEM_AON_SOFT_RST					0x1000
#define MASK_PMU_APB_RF_AP_VDSP_SOFT_RST						0x800
#define MASK_PMU_APB_RF_AUDCP_AUDDSP_SOFT_RST					0x400
#define MASK_PMU_APB_RF_AUDCP_SYS_SOFT_RST						0x200
#define MASK_PMU_APB_RF_SP_SYS_SOFT_RST						0x100
#define MASK_PMU_APB_RF_APCPU_SOFT_RST						0x80
#define MASK_PMU_APB_RF_PUB_SOFT_RST						0x40
#define MASK_PMU_APB_RF_AP_SOFT_RST						0x20
#define MASK_PMU_APB_RF_GPU_SOFT_RST						0x10
#define MASK_PMU_APB_RF_V3_MODEM_PHY_SOFT_RST					0x8
#define MASK_PMU_APB_RF_V3_MODEM_PS_SOFT_RST					0x4
#define MASK_PMU_APB_RF_PSCP_SOFT_RST						0x2
#define MASK_PMU_APB_RF_V3_MODEM_SOFT_RST						0x1
#define MASK_PMU_APB_RF_PSCP_DEEP_SLP_DBG						0xffff0000
#define MASK_PMU_APB_RF_V3_MODEM_DEEP_SLP_DBG					0xffff
#define MASK_PMU_APB_RF_XTLBUF1_LDO_WAIT_CNT					0xff00
#define MASK_PMU_APB_RF_XTLBUF0_LDO_WAIT_CNT					0xff
#define MASK_PMU_APB_RF_PUB_SYS_AUTO_LIGHT_SLEEP_ENABLE				0xffffffff
#define MASK_PMU_APB_RF_IPA_DEEP_SLEEP						0x80
#define MASK_PMU_APB_RF_SP_SYS_DEEP_SLEEP						0x40
#define MASK_PMU_APB_RF_AUDCP_DEEP_SLEEP						0x20
#define MASK_PMU_APB_RF_PUB_SYS_DEEP_SLEEP						0x10
#define MASK_PMU_APB_RF_NRCP_DEEP_SLEEP						0x8
#define MASK_PMU_APB_RF_PSCP_DEEP_SLEEP						0x4
#define MASK_PMU_APB_RF_V3_MODEM_DEEP_SLEEP					0x2
#define MASK_PMU_APB_RF_AP_DEEP_SLEEP						0x1
#define MASK_PMU_APB_RF_PUB_SYS_AUTO_DEEP_SLEEP_ENABLE				0x100000
#define MASK_PMU_APB_RF_DDR_SLEEP_DISABLE_ACK					0x80000
#define MASK_PMU_APB_RF_DDR_SLEEP_DISABLE_ACK_BYP					0x40000
#define MASK_PMU_APB_RF_DDR_SLEEP_DISABLE						0x20000
#define MASK_PMU_APB_RF_BUSY_TRANSFER_HWDATA_SEL					0x10000
#define MASK_PMU_APB_RF_DDR_PUBL_APB_SOFT_RST					0x1000
#define MASK_PMU_APB_RF_DDR_UMCTL_APB_SOFT_RST					0x800
#define MASK_PMU_APB_RF_DDR_PUBL_SOFT_RST						0x400
#define MASK_PMU_APB_RF_DDR_PHY_SOFT_RST						0x100
#define MASK_PMU_APB_RF_DDR_PHY_AUTO_GATE_EN					0x40
#define MASK_PMU_APB_RF_DDR_PUBL_AUTO_GATE_EN					0x20
#define MASK_PMU_APB_RF_DDR_UMCTL_AUTO_GATE_EN					0x10
#define MASK_PMU_APB_RF_DDR_PHY_EB							0x4
#define MASK_PMU_APB_RF_DDR_UMCTL_EB						0x2
#define MASK_PMU_APB_RF_DDR_PUBL_EB						0x1
#define MASK_PMU_APB_RF_IPA_SLP_STATUS						0xf000000
#define MASK_PMU_APB_RF_SP_SYS_SLP_STATUS						0xf00000
#define MASK_PMU_APB_RF_NRCP_SLP_STATUS						0xf0000
#define MASK_PMU_APB_RF_AUDCP_SLP_STATUS						0xf000
#define MASK_PMU_APB_RF_PSCP_SLP_STATUS						0xf00
#define MASK_PMU_APB_RF_V3_MODEM_SLP_STATUS					0xf0
#define MASK_PMU_APB_RF_AP_SLP_STATUS						0xf
#define MASK_PMU_APB_RF_PUB_PD_VOL_DOWN_ENA					0x10
#define MASK_PMU_APB_RF_PUB_SYS_VOL_ADJ_ENA					0x8
#define MASK_PMU_APB_RF_PUB_SYS_SELF_REFRESH_FLAG_BYPASS				0x4
#define MASK_PMU_APB_RF_PUB_SYS_PWR_PD_ACK_BYPASS					0x2
#define MASK_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_LOCK_ACK_BYPASS				0x1
#define MASK_PMU_APB_RF_IPA_PUB_SYS_DEEP_SLEEP_POLL				0xff0000
#define MASK_PMU_APB_RF_NRCP_PUB_SYS_DEEP_SLEEP_POLL				0xff00
#define MASK_PMU_APB_RF_AUDCP_PUB_SYS_DEEP_SLEEP_POLL				0xff
#define MASK_PMU_APB_RF_AON_PUB_SYS_DEEP_SLEEP_POLL				0xff000000
#define MASK_PMU_APB_RF_PSCP_PUB_SYS_DEEP_SLEEP_POLL				0xff0000
#define MASK_PMU_APB_RF_AP_PUB_SYS_DEEP_SLEEP_POLL					0xff00
#define MASK_PMU_APB_RF_V3_MODEM_PUB_SYS_DEEP_SLEEP_POLL				0xff
#define MASK_PMU_APB_RF_DDR_CTRL_AXI_LP_EN						0x80000000
#define MASK_PMU_APB_RF_DDR_CTRL_CGM_SEL						0x40000000
#define MASK_PMU_APB_RF_DDR_CHN9_AXI_LP_EN						0x2000000
#define MASK_PMU_APB_RF_DDR_CHN8_AXI_LP_EN						0x1000000
#define MASK_PMU_APB_RF_DDR_CHN7_AXI_LP_EN						0x800000
#define MASK_PMU_APB_RF_DDR_CHN6_AXI_LP_EN						0x400000
#define MASK_PMU_APB_RF_DDR_CHN5_AXI_LP_EN						0x200000
#define MASK_PMU_APB_RF_DDR_CHN4_AXI_LP_EN						0x100000
#define MASK_PMU_APB_RF_DDR_CHN3_AXI_LP_EN						0x80000
#define MASK_PMU_APB_RF_DDR_CHN2_AXI_LP_EN						0x40000
#define MASK_PMU_APB_RF_DDR_CHN1_AXI_LP_EN						0x20000
#define MASK_PMU_APB_RF_DDR_CHN0_AXI_LP_EN						0x10000
#define MASK_PMU_APB_RF_DDR_CHN9_CGM_SEL						0x200
#define MASK_PMU_APB_RF_DDR_CHN8_CGM_SEL						0x100
#define MASK_PMU_APB_RF_DDR_CHN7_CGM_SEL						0x80
#define MASK_PMU_APB_RF_DDR_CHN6_CGM_SEL						0x40
#define MASK_PMU_APB_RF_DDR_CHN5_CGM_SEL						0x20
#define MASK_PMU_APB_RF_DDR_CHN4_CGM_SEL						0x10
#define MASK_PMU_APB_RF_DDR_CHN3_CGM_SEL						0x8
#define MASK_PMU_APB_RF_DDR_CHN2_CGM_SEL						0x4
#define MASK_PMU_APB_RF_DDR_CHN1_CGM_SEL						0x2
#define MASK_PMU_APB_RF_DDR_CHN0_CGM_SEL						0x1
#define MASK_PMU_APB_RF_DDR_CHN9_AXI_STOP_SEL					0x200
#define MASK_PMU_APB_RF_DDR_CHN8_AXI_STOP_SEL					0x100
#define MASK_PMU_APB_RF_DDR_CHN7_AXI_STOP_SEL					0x80
#define MASK_PMU_APB_RF_DDR_CHN6_AXI_STOP_SEL					0x40
#define MASK_PMU_APB_RF_DDR_CHN5_AXI_STOP_SEL					0x20
#define MASK_PMU_APB_RF_DDR_CHN4_AXI_STOP_SEL					0x10
#define MASK_PMU_APB_RF_DDR_CHN3_AXI_STOP_SEL					0x8
#define MASK_PMU_APB_RF_DDR_CHN2_AXI_STOP_SEL					0x4
#define MASK_PMU_APB_RF_DDR_CHN1_AXI_STOP_SEL					0x2
#define MASK_PMU_APB_RF_DDR_CHN0_AXI_STOP_SEL					0x1
#define MASK_PMU_APB_RF_DDR_PUB_RET_EN						0x8000000
#define MASK_PMU_APB_RF_DDR_PHY_ISO_RST_EN						0x4000000
#define MASK_PMU_APB_RF_DDR_UMCTL_RET_EN						0x2000000
#define MASK_PMU_APB_RF_DDR_PHY_CHB_AUTO_RET_EN					0x1000000
#define MASK_PMU_APB_RF_DDR_PHY_CHA_AUTO_RET_EN					0x800000
#define MASK_PMU_APB_RF_DDR_UMCTL_SOFT_RST						0x10000
#define MASK_PMU_APB_RF_DDR_PHY_CHB_CKE_RET_EN					0x2
#define MASK_PMU_APB_RF_DDR_PHY_CHA_CKE_RET_EN					0x1
#define MASK_PMU_APB_RF_AON_RC_4M_SEL						0x100
#define MASK_PMU_APB_RF_NRCP_26M_SEL						0x40
#define MASK_PMU_APB_RF_PUB_26M_SEL						0x20
#define MASK_PMU_APB_RF_AON_26M_SEL						0x10
#define MASK_PMU_APB_RF_AUDCP_26M_SEL						0x8
#define MASK_PMU_APB_RF_PSCP_26M_SEL						0x4
#define MASK_PMU_APB_RF_V3_MODEM_26M_SEL						0x2
#define MASK_PMU_APB_RF_AP_26M_SEL							0x1
#define MASK_PMU_APB_RF_PD_IPA_SYS_BISR_DONE					0x40000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_BISR_DONE					0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_BISR_DONE					0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_BISR_DONE					0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_BISR_DONE					0x4000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_BISR_DONE					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_BISR_DONE					0x800000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_BISR_DONE					0x400000
#define MASK_PMU_APB_RF_PD_NRCP_UL_BISR_DONE					0x200000
#define MASK_PMU_APB_RF_PD_NRCP_DL_BISR_DONE					0x100000
#define MASK_PMU_APB_RF_PD_V3_TD_BISR_DONE						0x80000
#define MASK_PMU_APB_RF_PD_AON_MEM_BISR_DONE					0x40000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_BISR_DONE					0x20000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_BISR_DONE					0x10000
#define MASK_PMU_APB_RF_PD_V3_PS_BISR_DONE						0x8000
#define MASK_PMU_APB_RF_PD_V3_PHY_BISR_DONE					0x4000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_BISR_DONE					0x2000
#define MASK_PMU_APB_RF_PD_V3_WCE_BISR_DONE					0x1000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_BISR_DONE					0x800
#define MASK_PMU_APB_RF_PD_V3_LCE_BISR_DONE					0x400
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_BISR_DONE					0x200
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_BISR_DONE					0x100
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_BISR_DONE					0x80
#define MASK_PMU_APB_RF_PD_NRCP_SYS_BISR_DONE					0x40
#define MASK_PMU_APB_RF_PD_AP_SYS_BISR_DONE					0x20
#define MASK_PMU_APB_RF_PD_APCPU_TOP_BISR_DONE					0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_BISR_DONE					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_BISR_DONE					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_BISR_DONE					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_BISR_DONE					0x1
#define MASK_PMU_APB_RF_PD_IPA_SYS_BISR_BUSY					0x40000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_BISR_BUSY					0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_BISR_BUSY					0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_BISR_BUSY					0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_BISR_BUSY					0x4000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_BISR_BUSY					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_BISR_BUSY					0x800000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_BISR_BUSY					0x400000
#define MASK_PMU_APB_RF_PD_NRCP_UL_BISR_BUSY					0x200000
#define MASK_PMU_APB_RF_PD_NRCP_DL_BISR_BUSY					0x100000
#define MASK_PMU_APB_RF_PD_V3_TD_BISR_BUSY						0x80000
#define MASK_PMU_APB_RF_PD_AON_MEM_BISR_BUSY					0x40000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_BISR_BUSY					0x20000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_BISR_BUSY					0x10000
#define MASK_PMU_APB_RF_PD_V3_PS_BISR_BUSY						0x8000
#define MASK_PMU_APB_RF_PD_V3_PHY_BISR_BUSY					0x4000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_BISR_BUSY					0x2000
#define MASK_PMU_APB_RF_PD_V3_WCE_BISR_BUSY					0x1000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_BISR_BUSY					0x800
#define MASK_PMU_APB_RF_PD_V3_LCE_BISR_BUSY					0x400
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_BISR_BUSY					0x200
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_BISR_BUSY					0x100
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_BISR_BUSY					0x80
#define MASK_PMU_APB_RF_PD_NRCP_SYS_BISR_BUSY					0x40
#define MASK_PMU_APB_RF_PD_AP_SYS_BISR_BUSY					0x20
#define MASK_PMU_APB_RF_PD_APCPU_TOP_BISR_BUSY					0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_BISR_BUSY					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_BISR_BUSY					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_BISR_BUSY					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_BISR_BUSY					0x1
#define MASK_PMU_APB_RF_PD_IPA_SYS_BISR_FORCE_BYP					0x40000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_BISR_FORCE_BYP					0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_BISR_FORCE_BYP					0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_BISR_FORCE_BYP					0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_BISR_FORCE_BYP					0x4000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_BISR_FORCE_BYP					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_BISR_FORCE_BYP				0x800000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_BISR_FORCE_BYP				0x400000
#define MASK_PMU_APB_RF_PD_NRCP_UL_BISR_FORCE_BYP					0x200000
#define MASK_PMU_APB_RF_PD_NRCP_DL_BISR_FORCE_BYP					0x100000
#define MASK_PMU_APB_RF_PD_V3_TD_BISR_FORCE_BYP					0x80000
#define MASK_PMU_APB_RF_PD_AON_MEM_BISR_FORCE_BYP					0x40000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_BISR_FORCE_BYP					0x20000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_BISR_FORCE_BYP				0x10000
#define MASK_PMU_APB_RF_PD_V3_PS_BISR_FORCE_BYP					0x8000
#define MASK_PMU_APB_RF_PD_V3_PHY_BISR_FORCE_BYP					0x4000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_BISR_FORCE_BYP				0x2000
#define MASK_PMU_APB_RF_PD_V3_WCE_BISR_FORCE_BYP					0x1000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_BISR_FORCE_BYP					0x800
#define MASK_PMU_APB_RF_PD_V3_LCE_BISR_FORCE_BYP					0x400
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_BISR_FORCE_BYP				0x200
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_BISR_FORCE_BYP				0x100
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_BISR_FORCE_BYP				0x80
#define MASK_PMU_APB_RF_PD_NRCP_SYS_BISR_FORCE_BYP					0x40
#define MASK_PMU_APB_RF_PD_AP_SYS_BISR_FORCE_BYP					0x20
#define MASK_PMU_APB_RF_PD_APCPU_TOP_BISR_FORCE_BYP				0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_BISR_FORCE_BYP					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_BISR_FORCE_BYP					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_BISR_FORCE_BYP					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_BISR_FORCE_BYP					0x1
#define MASK_PMU_APB_RF_PD_IPA_SYS_BISR_FORCE_EN					0x40000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_BISR_FORCE_EN					0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_BISR_FORCE_EN					0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_BISR_FORCE_EN					0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_BISR_FORCE_EN					0x4000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_BISR_FORCE_EN					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_BISR_FORCE_EN				0x800000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_BISR_FORCE_EN				0x400000
#define MASK_PMU_APB_RF_PD_NRCP_UL_BISR_FORCE_EN					0x200000
#define MASK_PMU_APB_RF_PD_NRCP_DL_BISR_FORCE_EN					0x100000
#define MASK_PMU_APB_RF_PD_V3_TD_BISR_FORCE_EN					0x80000
#define MASK_PMU_APB_RF_PD_AON_MEM_BISR_FORCE_EN					0x40000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_BISR_FORCE_EN					0x20000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_BISR_FORCE_EN				0x10000
#define MASK_PMU_APB_RF_PD_V3_PS_BISR_FORCE_EN					0x8000
#define MASK_PMU_APB_RF_PD_V3_PHY_BISR_FORCE_EN					0x4000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_BISR_FORCE_EN					0x2000
#define MASK_PMU_APB_RF_PD_V3_WCE_BISR_FORCE_EN					0x1000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_BISR_FORCE_EN					0x800
#define MASK_PMU_APB_RF_PD_V3_LCE_BISR_FORCE_EN					0x400
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_BISR_FORCE_EN				0x200
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_BISR_FORCE_EN					0x100
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_BISR_FORCE_EN					0x80
#define MASK_PMU_APB_RF_PD_NRCP_SYS_BISR_FORCE_EN					0x40
#define MASK_PMU_APB_RF_PD_AP_SYS_BISR_FORCE_EN					0x20
#define MASK_PMU_APB_RF_PD_APCPU_TOP_BISR_FORCE_EN					0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_BISR_FORCE_EN					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_BISR_FORCE_EN					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_BISR_FORCE_EN					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_BISR_FORCE_EN					0x1
#define MASK_PMU_APB_RF_IPA_SLEEP_XTL_ON						0x40
#define MASK_PMU_APB_RF_SP_SYS_SLEEP_XTL_ON					0x20
#define MASK_PMU_APB_RF_NRCP_SLEEP_XTL_ON						0x10
#define MASK_PMU_APB_RF_AUDCP_SYS_SLEEP_XTL_ON					0x8
#define MASK_PMU_APB_RF_PSCP_SLEEP_XTL_ON						0x4
#define MASK_PMU_APB_RF_V3_MODEM_SLEEP_XTL_ON					0x2
#define MASK_PMU_APB_RF_AP_SLEEP_XTL_ON						0x1
#define MASK_PMU_APB_RF_MEM_SLP_CFG						0xffffffff
#define MASK_PMU_APB_RF_MEM_SD_CFG							0xffffffff
#define MASK_PMU_APB_RF_APCPU_C7_WAKEUP_EN						0x80
#define MASK_PMU_APB_RF_APCPU_C6_WAKEUP_EN						0x40
#define MASK_PMU_APB_RF_APCPU_C5_WAKEUP_EN						0x20
#define MASK_PMU_APB_RF_APCPU_C4_WAKEUP_EN						0x10
#define MASK_PMU_APB_RF_APCPU_C3_WAKEUP_EN						0x8
#define MASK_PMU_APB_RF_APCPU_C2_WAKEUP_EN						0x4
#define MASK_PMU_APB_RF_APCPU_C1_WAKEUP_EN						0x2
#define MASK_PMU_APB_RF_APCPU_C0_WAKEUP_EN						0x1
#define MASK_PMU_APB_RF_PD_APCPU_TOP_CMG_HOLD_EN					0x100
#define MASK_PMU_APB_RF_PD_APCPU_C7_CMG_HOLD_EN					0x80
#define MASK_PMU_APB_RF_PD_APCPU_C6_CMG_HOLD_EN					0x40
#define MASK_PMU_APB_RF_PD_APCPU_C5_CMG_HOLD_EN					0x20
#define MASK_PMU_APB_RF_PD_APCPU_C4_CMG_HOLD_EN					0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_CMG_HOLD_EN					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_CMG_HOLD_EN					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_CMG_HOLD_EN					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_CMG_HOLD_EN					0x1
#define MASK_PMU_APB_RF_AUDCP_PWR_WAIT_CNT						0xff000000
#define MASK_PMU_APB_RF_PSCP_PWR_WAIT_CNT						0xff0000
#define MASK_PMU_APB_RF_V3_MODEM_PWR_WAIT_CNT					0xff00
#define MASK_PMU_APB_RF_AP_PWR_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_IPA_PWR_WAIT_CNT						0xff0000
#define MASK_PMU_APB_RF_SP_SYS_PWR_WAIT_CNT					0xff00
#define MASK_PMU_APB_RF_NRCP_PWR_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_RCO_IPA_SEL						0x800
#define MASK_PMU_APB_RF_RCO_CSYSPWRUPREQ_SEL					0x400
#define MASK_PMU_APB_RF_RCO_FRC_OFF						0x200
#define MASK_PMU_APB_RF_RCO_FRC_ON							0x100
#define MASK_PMU_APB_RF_RCO_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_RCO_PUB_SYS_SEL						0x40
#define MASK_PMU_APB_RF_RCO_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_RCO_NRCP_SEL						0x10
#define MASK_PMU_APB_RF_RCO_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_RCO_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_RCO_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_RCO_AP_SEL							0x1
#define MASK_PMU_APB_RF_RCO_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_MPLL0_IPA_SEL						0x800
#define MASK_PMU_APB_RF_MPLL0_TOP_DVFS_SEL						0x400
#define MASK_PMU_APB_RF_MPLL0_REF_SEL						0x200
#define MASK_PMU_APB_RF_MPLL0_FRC_OFF						0x100
#define MASK_PMU_APB_RF_MPLL0_FRC_ON						0x80
#define MASK_PMU_APB_RF_MPLL0_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_MPLL0_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_MPLL0_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_MPLL0_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_MPLL0_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_MPLL0_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_MPLL0_AP_SEL						0x1
#define MASK_PMU_APB_RF_MPLL1_IPA_SEL						0x800
#define MASK_PMU_APB_RF_MPLL1_TOP_DVFS_SEL						0x400
#define MASK_PMU_APB_RF_MPLL1_REF_SEL						0x200
#define MASK_PMU_APB_RF_MPLL1_FRC_OFF						0x100
#define MASK_PMU_APB_RF_MPLL1_FRC_ON						0x80
#define MASK_PMU_APB_RF_MPLL1_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_MPLL1_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_MPLL1_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_MPLL1_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_MPLL1_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_MPLL1_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_MPLL1_AP_SEL						0x1
#define MASK_PMU_APB_RF_NR_CPUPLL_IPA_SEL						0x800
#define MASK_PMU_APB_RF_NR_CPUPLL_TOP_DVFS_SEL					0x400
#define MASK_PMU_APB_RF_NR_CPUPLL_REF_SEL						0x200
#define MASK_PMU_APB_RF_NR_CPUPLL_FRC_OFF						0x100
#define MASK_PMU_APB_RF_NR_CPUPLL_FRC_ON						0x80
#define MASK_PMU_APB_RF_NR_CPUPLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_NR_CPUPLL_SP_SYS_SEL					0x20
#define MASK_PMU_APB_RF_NR_CPUPLL_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_NR_CPUPLL_AUDCP_SEL					0x8
#define MASK_PMU_APB_RF_NR_CPUPLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_NR_CPUPLL_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_NR_CPUPLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_MEM_AUTO_SLP_EN						0xffffffff
#define MASK_PMU_APB_RF_MEM_AUTO_SD_EN						0xffffffff
#define MASK_PMU_APB_RF_PD_APCPU_C7_WAKEUP_LOCK_EN					0x80000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_WAKEUP_LOCK_EN					0x40000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_WAKEUP_LOCK_EN					0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_WAKEUP_LOCK_EN					0x10000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_WAKEUP_LOCK_EN				0x8000000
#define MASK_PMU_APB_RF_PD_V3_TD_WAKEUP_LOCK_EN					0x4000000
#define MASK_PMU_APB_RF_NRCP_SYS_WAKEUP_LOCK_EN					0x2000000
#define MASK_PMU_APB_RF_PSCP_SYS_WAKEUP_LOCK_EN					0x1000000
#define MASK_PMU_APB_RF_V3_MODEM_SYS_WAKEUP_LOCK_EN				0x800000
#define MASK_PMU_APB_RF_AP_SYS_WAKEUP_LOCK_EN					0x400000
#define MASK_PMU_APB_RF_PD_PUB_SYS_WAKEUP_LOCK_EN					0x200000
#define MASK_PMU_APB_RF_PD_NRCP_UL_WAKEUP_LOCK_EN					0x80000
#define MASK_PMU_APB_RF_PD_NRCP_DL_WAKEUP_LOCK_EN					0x40000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_WAKEUP_LOCK_EN					0x20000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_WAKEUP_LOCK_EN				0x10000
#define MASK_PMU_APB_RF_PD_V3_PS_WAKEUP_LOCK_EN					0x8000
#define MASK_PMU_APB_RF_PD_V3_PHY_WAKEUP_LOCK_EN					0x4000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_WAKEUP_LOCK_EN				0x2000
#define MASK_PMU_APB_RF_PD_V3_WCE_WAKEUP_LOCK_EN					0x1000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_WAKEUP_LOCK_EN					0x800
#define MASK_PMU_APB_RF_PD_V3_LCE_WAKEUP_LOCK_EN					0x400
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_WAKEUP_LOCK_EN				0x200
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_WAKEUP_LOCK_EN				0x100
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_WAKEUP_LOCK_EN				0x80
#define MASK_PMU_APB_RF_PD_NRCP_SYS_WAKEUP_LOCK_EN					0x40
#define MASK_PMU_APB_RF_PD_AP_SYS_WAKEUP_LOCK_EN					0x20
#define MASK_PMU_APB_RF_PD_APCPU_TOP_WAKEUP_LOCK_EN				0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_WAKEUP_LOCK_EN					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_WAKEUP_LOCK_EN					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_WAKEUP_LOCK_EN					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_WAKEUP_LOCK_EN					0x1
#define MASK_PMU_APB_RF_AUDCP_SYS_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_V3_PS_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_NRCP_DSP_1_CORE_INT_DISABLE				0x1
#define MASK_PMU_APB_RF_NRCP_DSP_0_CORE_INT_DISABLE				0x1
#define MASK_PMU_APB_RF_PSCP_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C0_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C1_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C2_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C3_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C4_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C5_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_NRCP_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_V3_PHY_CORE_INT_DISABLE					0x1
#define MASK_PMU_APB_RF_APCPU_C4_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C5_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C6_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C7_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_NR_DSPPLL_IPA_SEL						0x800
#define MASK_PMU_APB_RF_NR_DSPPLL_TOP_DVFS_SEL					0x400
#define MASK_PMU_APB_RF_NR_DSPPLL_REF_SEL						0x200
#define MASK_PMU_APB_RF_NR_DSPPLL_FRC_OFF						0x100
#define MASK_PMU_APB_RF_NR_DSPPLL_FRC_ON						0x80
#define MASK_PMU_APB_RF_NR_DSPPLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_NR_DSPPLL_SP_SYS_SEL					0x20
#define MASK_PMU_APB_RF_NR_DSPPLL_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_NR_DSPPLL_AUDCP_SEL					0x8
#define MASK_PMU_APB_RF_NR_DSPPLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_NR_DSPPLL_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_NR_DSPPLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_NRCP_DSP_0_DSLP_ENA					0x1
#define MASK_PMU_APB_RF_NRCP_DSP_1_DSLP_ENA					0x1
#define MASK_PMU_APB_RF_AP_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_PSCP_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_V3_MODEM_DSLP_ENA1						0x2
#define MASK_PMU_APB_RF_V3_MODEM_DSLP_ENA0						0x1
#define MASK_PMU_APB_RF_APCPU_TOP_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_SP_SYS_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_AUDCP_SYS_PUB_DSLP_ENA					0x1
#define MASK_PMU_APB_RF_AUDCP_PUB_DSLP_WAKEUP_EN					0x1
#define MASK_PMU_APB_RF_NRCP_LSLP_WAKEUP_EN					0x10
#define MASK_PMU_APB_RF_AUDCP_LSLP_WAKEUP_EN					0x8
#define MASK_PMU_APB_RF_V3_MODEM_LSLP_WAKEUP_EN					0x4
#define MASK_PMU_APB_RF_PSCP_LSLP_WAKEUP_EN					0x2
#define MASK_PMU_APB_RF_AP_LSLP_WAKEUP_EN						0x1
#define MASK_PMU_APB_RF_V3_PS_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_V3_PHY_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_TOP_SMART_LSLP_ENA					0x200000
#define MASK_PMU_APB_RF_NRCP_SMART_LSLP_ENA					0x10000
#define MASK_PMU_APB_RF_AUDCP_SYS_SMART_LSLP_ENA					0x8000
#define MASK_PMU_APB_RF_AON_SMART_LSLP_ENA						0x4000
#define MASK_PMU_APB_RF_V3_MODEM_SMART_LSLP_ENA					0x2000
#define MASK_PMU_APB_RF_PSCP_SMART_LSLP_ENA					0x1000
#define MASK_PMU_APB_RF_AP_SMART_LSLP_ENA						0x800
#define MASK_PMU_APB_RF_PUB_SYS_SMART_LSLP_ENA					0x400
#define MASK_PMU_APB_RF_MM_LSLP_ENA						0x200
#define MASK_PMU_APB_RF_GPU_LSLP_ENA						0x100
#define MASK_PMU_APB_RF_IPA_LSLP_ENA						0x40
#define MASK_PMU_APB_RF_NRCP_LSLP_ENA						0x20
#define MASK_PMU_APB_RF_AUDCP_SYS_LSLP_ENA						0x10
#define MASK_PMU_APB_RF_AON_LSLP_ENA						0x8
#define MASK_PMU_APB_RF_V3_MODEM_LSLP_ENA						0x4
#define MASK_PMU_APB_RF_PSCP_LSLP_ENA						0x2
#define MASK_PMU_APB_RF_AP_LSLP_ENA						0x1
#define MASK_PMU_APB_RF_IPA_LIGHT_SLEEP						0x80
#define MASK_PMU_APB_RF_NRCP_LIGHT_SLEEP						0x40
#define MASK_PMU_APB_RF_PUB_SYS_LIGHT_SLEEP					0x20
#define MASK_PMU_APB_RF_AP_LIGHT_SLEEP						0x10
#define MASK_PMU_APB_RF_V3_MODEM_LIGHT_SLEEP					0x8
#define MASK_PMU_APB_RF_PSCP_LIGHT_SLEEP						0x4
#define MASK_PMU_APB_RF_AUDCP_LIGHT_SLEEP						0x2
#define MASK_PMU_APB_RF_AON_SYS_LIGHT_SLEEP					0x1
#define MASK_PMU_APB_RF_AUDCP_SYS_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_AUDCP_AUDDSP_DSLP_ENA					0x1
#define MASK_PMU_APB_RF_NRCP_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_PUB_ACC_RDY						0x1
#define MASK_PMU_APB_RF_PUB_CLK_RDY						0x1
#define MASK_PMU_APB_RF_EIC_LIGHT_SLEEP_SEL					0x2
#define MASK_PMU_APB_RF_EIC_DEEP_SLEEP_SEL						0x1
#define MASK_PMU_APB_RF_CS_SYS_DDR_WAKEUP_N_MASK					0x2
#define MASK_PMU_APB_RF_AP_APCPU_COUPLE_EN						0x1
#define MASK_PMU_APB_RF_PMU_DEBUG							0xffffffff
#define MASK_PMU_APB_RF_IPA_SYS_SLEEP_CNT_CLR					0x400000
#define MASK_PMU_APB_RF_IPA_LIGHT_SLEEP_CNT_CLR					0x200000
#define MASK_PMU_APB_RF_IPA_DEEP_SLEEP_CNT_CLR					0x100000
#define MASK_PMU_APB_RF_NRCP_LIGHT_SLEEP_CNT_CLR					0x80000
#define MASK_PMU_APB_RF_NRCP_SYS_SLEEP_CNT_CLR					0x40000
#define MASK_PMU_APB_RF_APCPU_TOP_SYS_SLEEP_CNT_CLR				0x20000
#define MASK_PMU_APB_RF_PSCP_SYS_SLEEP_CNT_CLR					0x10000
#define MASK_PMU_APB_RF_V3_MODEM_SYS_SLEEP_CNT_CLR					0x8000
#define MASK_PMU_APB_RF_AP_SYS_SLEEP_CNT_CLR					0x4000
#define MASK_PMU_APB_RF_AUDCP_SYS_SLEEP_CNT_CLR					0x2000
#define MASK_PMU_APB_RF_AON_SYS_LIGHT_SLEEP_CNT_CLR				0x1000
#define MASK_PMU_APB_RF_PSCP_LIGHT_SLEEP_CNT_CLR					0x800
#define MASK_PMU_APB_RF_V3_MODEM_LIGHT_SLEEP_CNT_CLR				0x400
#define MASK_PMU_APB_RF_AP_LIGHT_SLEEP_CNT_CLR					0x200
#define MASK_PMU_APB_RF_PUB_SYS_LIGHT_SLEEP_CNT_CLR				0x100
#define MASK_PMU_APB_RF_AUDCP_SYS_LIGHT_SLEEP_CNT_CLR				0x80
#define MASK_PMU_APB_RF_NRCP_DEEP_SLEEP_CNT_CLR					0x40
#define MASK_PMU_APB_RF_SP_SYS_DEEP_SLEEP_CNT_CLR					0x20
#define MASK_PMU_APB_RF_PSCP_DEEP_SLEEP_CNT_CLR					0x10
#define MASK_PMU_APB_RF_V3_MODEM_DEEP_SLEEP_CNT_CLR				0x8
#define MASK_PMU_APB_RF_AP_DEEP_SLEEP_CNT_CLR					0x4
#define MASK_PMU_APB_RF_PUB_DEEP_SLEEP_CNT_CLR					0x2
#define MASK_PMU_APB_RF_AUDCP_SYS_DEEP_SLEEP_CNT_CLR				0x1
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_POL_SEL					0x1000
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_TOP_DVFS_DEEP_SLEEP_MASK		0x800
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_EXT_XTL_PD_MASK				0x200
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_SP_SYS_DEEP_SLEEP_MASK			0x100
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_AP_DEEP_SLEEP_MASK			0x80
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_ESE_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_PUB_SYS_DEEP_SLEEP_MASK			0x20
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_AI_SYS_PD_MASK				0x10
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_APCPU_TOP_PD_MASK			0x8
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_WTLCP_DEEP_SLEEP_MASK			0x4
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_PUBCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_LVDSRFPLL_REF_SEL						0x300
#define MASK_PMU_APB_RF_EXT_XTL3_COMB_EN						0x8
#define MASK_PMU_APB_RF_EXT_XTL2_COMB_EN						0x4
#define MASK_PMU_APB_RF_EXT_XTL1_COMB_EN						0x2
#define MASK_PMU_APB_RF_EXT_XTL0_COMB_EN						0x1
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_POL_SEL					0x1000
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_TOP_DVFS_DEEP_SLEEP_MASK		0x800
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_EXT_XTL_PD_MASK				0x200
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_SP_SYS_DEEP_SLEEP_MASK			0x100
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_AP_DEEP_SLEEP_MASK			0x80
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_NRCP_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_PUB_SYS_DEEP_SLEEP_MASK			0x20
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_APCPU_C7_PD_MASK			0x10
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_APCPU_TOP_PD_MASK			0x8
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_V3_MODEM_DEEP_SLEEP_MASK		0x4
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_PSCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_PAD_OUT_CHIP_SLEEP_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_POL_SEL					0x1000
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_TOP_DVFS_DEEP_SLEEP_MASK			0x800
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_EXT_XTL_PD_MASK				0x200
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_SP_SYS_DEEP_SLEEP_MASK			0x100
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_AP_DEEP_SLEEP_MASK				0x80
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_NRCP_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_PUB_SYS_DEEP_SLEEP_MASK			0x20
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_APCPU_C7_PD_MASK				0x10
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_APCPU_TOP_PD_MASK				0x8
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_V3_MODEM_DEEP_SLEEP_MASK			0x4
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_PSCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN0_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_POL_SEL					0x1000
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_TOP_DVFS_DEEP_SLEEP_MASK			0x800
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_EXT_XTL_PD_MASK				0x200
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_SP_SYS_DEEP_SLEEP_MASK			0x100
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_AP_DEEP_SLEEP_MASK				0x80
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_NRCP_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_PUB_SYS_DEEP_SLEEP_MASK			0x20
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_APCPU_C7_PD_MASK				0x10
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_APCPU_TOP_PD_MASK				0x8
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_V3_MODEM_DEEP_SLEEP_MASK			0x4
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_PSCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN1_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_POL_SEL				0x1000
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_TOP_DVFS_DEEP_SLEEP_MASK		0x800
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_EXT_XTL_PD_MASK			0x200
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_SP_SYS_DEEP_SLEEP_MASK		0x100
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_AP_DEEP_SLEEP_MASK			0x80
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_NRCP_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_PUB_SYS_DEEP_SLEEP_MASK		0x20
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_APCPU_C7_PD_MASK			0x10
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_APCPU_TOP_PD_MASK			0x8
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_V3_MODEM_DEEP_SLEEP_MASK		0x4
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_PSCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_ARM0_EN_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_POL_SEL					0x1000
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_TOP_DVFS_DEEP_SLEEP_MASK			0x800
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_EXT_XTL_PD_MASK				0x200
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_SP_SYS_DEEP_SLEEP_MASK			0x100
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_AP_DEEP_SLEEP_MASK				0x80
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_NRCP_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_PUB_SYS_DEEP_SLEEP_MASK			0x20
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_APCPU_C7_PD_MASK				0x10
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_APCPU_TOP_PD_MASK				0x8
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_V3_MODEM_DEEP_SLEEP_MASK			0x4
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_PSCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_PAD_OUT_XTL_EN2_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_IPA_DEEP_SLEEP_MASK			0x2000
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_POL_SEL					0x1000
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_TOP_DVFS_DEEP_SLEEP_MASK		0x800
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_PLL_PD_MASK				0x400
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_EXT_XTL_PD_MASK				0x200
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_SP_SYS_DEEP_SLEEP_MASK			0x100
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_AP_DEEP_SLEEP_MASK			0x80
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_NRCP_DEEP_SLEEP_MASK			0x40
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_PUB_SYS_DEEP_SLEEP_MASK			0x20
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_APCPU_C7_PD_MASK			0x10
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_APCPU_TOP_PD_MASK			0x8
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_V3_MODEM_DEEP_SLEEP_MASK		0x4
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_PSCP_DEEP_SLEEP_MASK			0x2
#define MASK_PMU_APB_RF_DCXO_LC_DEEP_SLEEP_AUDCP_DEEP_SLEEP_MASK			0x1
#define MASK_PMU_APB_RF_PD_IPA_SYS_BISR_FORCE_SEL					0x40000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_BISR_FORCE_SEL					0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_BISR_FORCE_SEL					0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_BISR_FORCE_SEL					0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_BISR_FORCE_SEL					0x4000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_BISR_FORCE_SEL					0x2000000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_BISR_FORCE_SEL				0x800000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_BISR_FORCE_SEL				0x400000
#define MASK_PMU_APB_RF_PD_NRCP_UL_BISR_FORCE_SEL					0x200000
#define MASK_PMU_APB_RF_PD_NRCP_DL_BISR_FORCE_SEL					0x100000
#define MASK_PMU_APB_RF_PD_V3_TD_BISR_FORCE_SEL					0x80000
#define MASK_PMU_APB_RF_PD_AON_MEM_BISR_FORCE_SEL					0x40000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_BISR_FORCE_SEL					0x20000
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_BISR_FORCE_SEL				0x10000
#define MASK_PMU_APB_RF_PD_V3_PS_BISR_FORCE_SEL					0x8000
#define MASK_PMU_APB_RF_PD_V3_PHY_BISR_FORCE_SEL					0x4000
#define MASK_PMU_APB_RF_PD_V3_LWPROC_BISR_FORCE_SEL				0x2000
#define MASK_PMU_APB_RF_PD_V3_WCE_BISR_FORCE_SEL					0x1000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_BISR_FORCE_SEL					0x800
#define MASK_PMU_APB_RF_PD_V3_LCE_BISR_FORCE_SEL					0x400
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_BISR_FORCE_SEL				0x200
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_BISR_FORCE_SEL				0x100
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_BISR_FORCE_SEL				0x80
#define MASK_PMU_APB_RF_PD_NRCP_SYS_BISR_FORCE_SEL					0x40
#define MASK_PMU_APB_RF_PD_AP_SYS_BISR_FORCE_SEL					0x20
#define MASK_PMU_APB_RF_PD_APCPU_TOP_BISR_FORCE_SEL				0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_BISR_FORCE_SEL					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_BISR_FORCE_SEL					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_BISR_FORCE_SEL					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_BISR_FORCE_SEL					0x1
#define MASK_PMU_APB_RF_EFUSE_SEL_BUF						0x4
#define MASK_PMU_APB_RF_SP_SYS_MEM_ALL_SEL						0x2
#define MASK_PMU_APB_RF_AON_MEM_SP_SYS_SEL						0x1
#define MASK_PMU_APB_RF_INT_REQ_PWR_DOWN_CLR					0x1ff0000
#define MASK_PMU_APB_RF_INT_REQ_PWR_UP_CLR						0x1ff
#define MASK_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_WAIT_CNT				0xffff0000
#define MASK_PMU_APB_RF_PUB_SYS_SLEEP_WAIT_CNT					0xffff
#define MASK_PMU_APB_RF_PWR_ST_CLK_DIV_CFG						0xffff0000
#define MASK_PMU_APB_RF_SLP_CTRL_CLK_DIV_CFG					0xffff
#define MASK_PMU_APB_RF_CGM_PMU_SEL_REG						0x3
#define MASK_PMU_APB_RF_RAM_PWR_DLY						0xff000000
#define MASK_PMU_APB_RF_ISO_OFF_DLY						0xff0000
#define MASK_PMU_APB_RF_CGM_ON_DLY							0xff00
#define MASK_PMU_APB_RF_RST_ASSERT_DLY						0xff
#define MASK_PMU_APB_RF_APCPU_C0_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C1_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C2_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C3_DSLP_ENA						0x1
#define MASK_PMU_APB_RF_APCPU_C7_GIC_RST_EN					0x100
#define MASK_PMU_APB_RF_APCPU_C6_GIC_RST_EN					0x80
#define MASK_PMU_APB_RF_APCPU_C5_GIC_RST_EN					0x40
#define MASK_PMU_APB_RF_APCPU_C4_GIC_RST_EN					0x20
#define MASK_PMU_APB_RF_APCPU_C3_GIC_RST_EN					0x10
#define MASK_PMU_APB_RF_APCPU_C2_GIC_RST_EN					0x8
#define MASK_PMU_APB_RF_APCPU_C1_GIC_RST_EN					0x4
#define MASK_PMU_APB_RF_APCPU_C0_GIC_RST_EN					0x2
#define MASK_PMU_APB_RF_APCPU_TOP_GIC_RST_EN					0x1
#define MASK_PMU_APB_RF_CSI_2P2LANE_PD_REG						0x1000
#define MASK_PMU_APB_RF_PHY_PWR_DLY						0xff0
#define MASK_PMU_APB_RF_DSI_PD_REG							0x8
#define MASK_PMU_APB_RF_PCIE2_PD_REG						0x4
#define MASK_PMU_APB_RF_CSI_4LANE1_PD_REG						0x2
#define MASK_PMU_APB_RF_CSI_4LANE0_PD_REG						0x1
#define MASK_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_SEL					0x1
#define MASK_PMU_APB_RF_PD_APCPU_C4_QUAD_CORE_FORCE_SHUTDOWN			0x80000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_QUAD_CORE_AUTO_SHUTDOWN_EN			0x40000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C4_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C4_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C4_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C5_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C5_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C5_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C5_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C6_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C6_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C6_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_APCPU_C7_WFI_SHUTDOWN_EN				0x20000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_DBG_SHUTDOWN_EN				0x10000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_PD_SEL						0x8000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_APCPU_C7_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C7_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C7_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_PD_DCDC_CPU1_SHUTDOWN_WINDOW				0xff0000
#define MASK_PMU_APB_RF_PD_DCDC_CPU1_PWR_ON_DLY					0xff00
#define MASK_PMU_APB_RF_PD_DCDC_CPU1_PWR_OFF_DLY					0xff
#define MASK_PMU_APB_RF_PAD_OUT_DCDC_AI_EN						0x1
#define MASK_PMU_APB_RF_APCPU_L2RSTDISABLE						0x1
#define MASK_PMU_APB_RF_PUB_VOL_UP_CNT						0xffff0000
#define MASK_PMU_APB_RF_PUB_VOL_DOWN_CNT						0xffff
#define MASK_PMU_APB_RF_R5PLL_WAIT_CNT						0xff
#define MASK_PMU_APB_RF_R5PLL_IPA_SEL						0x800
#define MASK_PMU_APB_RF_R5PLL_REF_SEL						0x400
#define MASK_PMU_APB_RF_R5PLL_FRC_OFF						0x200
#define MASK_PMU_APB_RF_R5PLL_FRC_ON						0x100
#define MASK_PMU_APB_RF_R5PLL_TOP_DVFS_SEL						0x80
#define MASK_PMU_APB_RF_R5PLL_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_R5PLL_SP_SYS_SEL						0x20
#define MASK_PMU_APB_RF_R5PLL_PUB_SYS_SEL						0x10
#define MASK_PMU_APB_RF_R5PLL_AUDCP_SEL						0x8
#define MASK_PMU_APB_RF_R5PLL_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_R5PLL_V3_MODEM_SEL						0x2
#define MASK_PMU_APB_RF_R5PLL_AP_SEL						0x1
#define MASK_PMU_APB_RF_APCPU_CORE_DSLP_ENA_SOFT_RST_MASK				0x6
#define MASK_PMU_APB_RF_APCPU_TOP_DSLP_ENA_SOFT_RST_MASK				0x1
#define MASK_PMU_APB_RF_PCIEPLL_H_PCIE_CLKREQ_SEL					0x4000
#define MASK_PMU_APB_RF_PCIEPLL_H_PCIE_L2_SEL					0x2000
#define MASK_PMU_APB_RF_PCIEPLL_H_REF_SEL						0x1c00
#define MASK_PMU_APB_RF_PCIEPLL_H_FRC_OFF						0x200
#define MASK_PMU_APB_RF_PCIEPLL_H_FRC_ON						0x100
#define MASK_PMU_APB_RF_PCIEPLL_H_TOP_DVFS_SEL					0x80
#define MASK_PMU_APB_RF_PCIEPLL_H_NRCP_SEL						0x40
#define MASK_PMU_APB_RF_PCIEPLL_H_SP_SYS_SEL					0x20
#define MASK_PMU_APB_RF_PCIEPLL_H_PUB_SYS_SEL					0x10
#define MASK_PMU_APB_RF_PCIEPLL_H_AUDCP_SEL					0x8
#define MASK_PMU_APB_RF_PCIEPLL_H_PSCP_SEL						0x4
#define MASK_PMU_APB_RF_PCIEPLL_H_V3_MODEM_SEL					0x2
#define MASK_PMU_APB_RF_PCIEPLL_H_AP_SEL						0x1
#define MASK_PMU_APB_RF_R5PLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_R5PLL_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_R5PLL_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_R5PLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_PCIEPLL_H_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_PCIEPLL_H_DELAY_PWR_ON					0xff0000
#define MASK_PMU_APB_RF_PCIEPLL_H_DELAY_EN_OFF					0xff00
#define MASK_PMU_APB_RF_PCIEPLL_H_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_AP_CP_HANDSHK						0xf80
#define MASK_PMU_APB_RF_PCIE_CLKREQ_PLL_GATE_MASK					0x40
#define MASK_PMU_APB_RF_PERST_AP_WAKEUP_EN						0x20
#define MASK_PMU_APB_RF_REG_PERST_N_ASSERT						0x10
#define MASK_PMU_APB_RF_PERST_N_AUTO_EN						0x8
#define MASK_PMU_APB_RF_PCIE_LOAD_DONE						0x4
#define MASK_PMU_APB_RF_RCO_PCIE_L2_SEL						0x2
#define MASK_PMU_APB_RF_PCIE_L2_DSLP_MASK						0x1
#define MASK_PMU_APB_RF_GICDISABLE							0x1
#define MASK_PMU_APB_RF_FW_WAKEUP_DDR_EN						0x1
#define MASK_PMU_APB_RF_PD_ESE_SYS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_ESE_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_ESE_SYS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_ESE_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_APCPU_CORINTH_RAM_PWR_DLY					0xff000000
#define MASK_PMU_APB_RF_APCPU_CORE_RAM_PWR_DLY					0xff0000
#define MASK_PMU_APB_RF_APCPU_CORE_INITIAL_DLY					0xff00
#define MASK_PMU_APB_RF_APCPU_CORINTH_INITIAL_DLY					0xff
#define MASK_PMU_APB_RF_APCPU_CORE0_SIMD_RET_MODE					0x7
#define MASK_PMU_APB_RF_APCPU_CORE1_SIMD_RET_MODE					0x7
#define MASK_PMU_APB_RF_APCPU_CORE2_SIMD_RET_MODE					0x7
#define MASK_PMU_APB_RF_APCPU_CORE3_SIMD_RET_MODE					0x7
#define MASK_PMU_APB_RF_APCPU_TOP_FORCE_DEEP_STOP					0x100
#define MASK_PMU_APB_RF_APCPU_CORE_FORCE_STOP					0xff
#define MASK_PMU_APB_RF_PD_GPU_TOP_SHUTDOWN_DLY					0xff000000
#define MASK_PMU_APB_RF_PD_GPU_TOP_RST_DEASSERT_DLY				0xff0000
#define MASK_PMU_APB_RF_PD_GPU_TOP_RST_ASSERT_DLY					0xff00
#define MASK_PMU_APB_RF_PD_GPU_TOP_ISO_OFF_DLY					0xff
#define MASK_PMU_APB_RF_MPLL_WAIT_CLK_DIV_CFG					0xffff
#define MASK_PMU_APB_RF_MPLL0_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_MPLL0_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_MPLL0_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_MPLL0_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_MPLL1_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_MPLL1_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_MPLL1_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_MPLL1_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_R8PLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_R8PLL_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_R8PLL_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_R8PLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_NR_CPUPLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_NR_CPUPLL_DELAY_PWR_ON					0xff0000
#define MASK_PMU_APB_RF_NR_CPUPLL_DELAY_EN_OFF					0xff00
#define MASK_PMU_APB_RF_NR_CPUPLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_DPLL0_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_DPLL0_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_DPLL0_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_DPLL0_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_DPLL1_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_DPLL1_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_DPLL1_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_DPLL1_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_V3PLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_V3PLL_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_V3PLL_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_V3PLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_NRPLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_NRPLL_DELAY_PWR_ON						0xff0000
#define MASK_PMU_APB_RF_NRPLL_DELAY_EN_OFF						0xff00
#define MASK_PMU_APB_RF_NRPLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_NR_DSPPLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_NR_DSPPLL_DELAY_PWR_ON					0xff0000
#define MASK_PMU_APB_RF_NR_DSPPLL_DELAY_EN_OFF					0xff00
#define MASK_PMU_APB_RF_NR_DSPPLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_V3_RPLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_V3_RPLL_DELAY_PWR_ON					0xff0000
#define MASK_PMU_APB_RF_V3_RPLL_DELAY_EN_OFF					0xff00
#define MASK_PMU_APB_RF_V3_RPLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_NR_RPLL_RST_CTRL_BYPASS					0x1000000
#define MASK_PMU_APB_RF_NR_RPLL_DELAY_PWR_ON					0xff0000
#define MASK_PMU_APB_RF_NR_RPLL_DELAY_EN_OFF					0xff00
#define MASK_PMU_APB_RF_NR_RPLL_DELAY_RST_ASSERT					0xff
#define MASK_PMU_APB_RF_ST_NRPLL_STATE						0xf0000000
#define MASK_PMU_APB_RF_ST_V3PLL_STATE						0xf000000
#define MASK_PMU_APB_RF_ST_DPLL1_STATE						0xf00000
#define MASK_PMU_APB_RF_ST_DPLL0_STATE						0xf0000
#define MASK_PMU_APB_RF_ST_NR_CPUPLL_STATE						0xf000
#define MASK_PMU_APB_RF_ST_R8PLL_STATE						0xf00
#define MASK_PMU_APB_RF_ST_MPLL1_STATE						0xf0
#define MASK_PMU_APB_RF_ST_MPLL0_STATE						0xf
#define MASK_PMU_APB_RF_ST_R5PLL_STATE						0xf0000
#define MASK_PMU_APB_RF_ST_PCIEPLL_H_STATE						0xf000
#define MASK_PMU_APB_RF_ST_NR_RPLL_STATE						0xf00
#define MASK_PMU_APB_RF_ST_V3_RPLL_STATE						0xf0
#define MASK_PMU_APB_RF_ST_NR_DSPPLL_STATE						0xf
#define MASK_PMU_APB_RF_PMU_AUTO_SEL_RCO_EN					0x8
#define MASK_PMU_APB_RF_ESE_SYS_FAST_WAKEUP_AFTER_RCO				0x4
#define MASK_PMU_APB_RF_ESE_SYS_DEEP_STOP_TYPE_SEL					0x2
#define MASK_PMU_APB_RF_ESE_SYS_FAST_WAKEUP_EN					0x1
#define MASK_PMU_APB_RF_NRCP_DSP_1_TCM_RAM_SHUTDOWN_EN				0x2
#define MASK_PMU_APB_RF_NRCP_DSP_0_TCM_RAM_SHUTDOWN_EN				0x1
#define MASK_PMU_APB_RF_WTLCP_HU3GE_NEST_DOMAIN_EN					0x1
#define MASK_PMU_APB_RF_DBG_RECOV_WAIT_BUS_IDLE_EN					0x80
#define MASK_PMU_APB_RF_DBGRSTREQ_TRIG_DBG_RECOV_EN				0x40
#define MASK_PMU_APB_RF_APCPU_TOP_SOFT_RST_TRIG_DBG_RECOV_EN			0x20
#define MASK_PMU_APB_RF_APCPU_CLUSTER_SOFT_RST_TRIG_DBG_RECOV_EN			0x10
#define MASK_PMU_APB_RF_DEBUG_RECOV_FORCE_TRIG					0x4
#define MASK_PMU_APB_RF_DEBUG_RECOV_AUTO_TRIG_EN					0x2
#define MASK_PMU_APB_RF_DBG_RECOV_RST_TYPE_SEL					0x1
#define MASK_PMU_APB_RF_APCPU_CORE_RST_DEASSERT_DLY				0xff000000
#define MASK_PMU_APB_RF_APCPU_CORE_RST_ASSERT_DLY					0xff0000
#define MASK_PMU_APB_RF_APCPU_CORINTH_RST_DEASSERT_DLY				0xff00
#define MASK_PMU_APB_RF_APCPU_CORINTH_RST_ASSERT_DLY				0xff
#define MASK_PMU_APB_RF_APCPU_CORE_CGM_OFF_DLY					0xff00
#define MASK_PMU_APB_RF_APCPU_CORE_CGM_ON_DLY					0xff
#define MASK_PMU_APB_RF_APCPU_CLUSTER_INITIAL_STATE				0x1
#define MASK_PMU_APB_RF_APCPU_CORE_DEBUG_RECOV_STATE_CLR				0xff00
#define MASK_PMU_APB_RF_APCPU_CORE7_WAKEUP_FROM_DEBUG_RECOV			0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_WAKEUP_FROM_DEBUG_RECOV			0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_WAKEUP_FROM_DEBUG_RECOV			0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_WAKEUP_FROM_DEBUG_RECOV			0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_WAKEUP_FROM_DEBUG_RECOV			0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_WAKEUP_FROM_DEBUG_RECOV			0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_WAKEUP_FROM_DEBUG_RECOV			0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_WAKEUP_FROM_DEBUG_RECOV			0x1
#define MASK_PMU_APB_RF_APCPU_SNOOP_FILTER_RAM_DSLP_EN				0x100
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P3_RAM_DSLP_EN				0x80
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P2_RAM_DSLP_EN				0x40
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P1_RAM_DSLP_EN				0x20
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P0_RAM_DSLP_EN				0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_RAM_DSLP_EN					0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_RAM_DSLP_EN					0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_RAM_DSLP_EN					0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_RAM_DSLP_EN					0x1
#define MASK_PMU_APB_RF_PD_APCPU_C7_FRC_ON_EN					0x80
#define MASK_PMU_APB_RF_PD_APCPU_C6_FRC_ON_EN					0x40
#define MASK_PMU_APB_RF_PD_APCPU_C5_FRC_ON_EN					0x20
#define MASK_PMU_APB_RF_PD_APCPU_C4_FRC_ON_EN					0x10
#define MASK_PMU_APB_RF_PD_APCPU_C3_FRC_ON_EN					0x8
#define MASK_PMU_APB_RF_PD_APCPU_C2_FRC_ON_EN					0x4
#define MASK_PMU_APB_RF_PD_APCPU_C1_FRC_ON_EN					0x2
#define MASK_PMU_APB_RF_PD_APCPU_C0_FRC_ON_EN					0x1
#define MASK_PMU_APB_RF_APCPU_CORE_SOFT_RST_BYPASS					0x20
#define MASK_PMU_APB_RF_APCPU_CLUSTER_SOFT_RST_BYPASS				0x10
#define MASK_PMU_APB_RF_APCPU_SRST_RST_BYPASS					0x8
#define MASK_PMU_APB_RF_CLUSTER_DBGRSTREQ_EN					0x4
#define MASK_PMU_APB_RF_APCPU_SOFT_RST_TYPE_SEL					0x2
#define MASK_PMU_APB_RF_DBGRSTREQ_RST_TYPE_SEL					0x1
#define MASK_PMU_APB_RF_APCPU_CORINTH_FUNC_RET_GATE_CLK_EN				0x1
#define MASK_PMU_APB_RF_APCPU_CORE7_PCHANNEL_STATE					0xf0000000
#define MASK_PMU_APB_RF_APCPU_CORE6_PCHANNEL_STATE					0xf000000
#define MASK_PMU_APB_RF_APCPU_CORE5_PCHANNEL_STATE					0xf00000
#define MASK_PMU_APB_RF_APCPU_CORE4_PCHANNEL_STATE					0xf0000
#define MASK_PMU_APB_RF_APCPU_CORE3_PCHANNEL_STATE					0xf000
#define MASK_PMU_APB_RF_APCPU_CORE2_PCHANNEL_STATE					0xf00
#define MASK_PMU_APB_RF_APCPU_CORE1_PCHANNEL_STATE					0xf0
#define MASK_PMU_APB_RF_APCPU_CORE0_PCHANNEL_STATE					0xf
#define MASK_PMU_APB_RF_APCPU_CORINTH_PCHANNEL_STATE				0xf
#define MASK_PMU_APB_RF_APCPU_CORE7_SOFT_INT					0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_SOFT_INT					0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_SOFT_INT					0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_SOFT_INT					0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_SOFT_INT					0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_SOFT_INT					0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_SOFT_INT					0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_SOFT_INT					0x1
#define MASK_PMU_APB_RF_RAM_PD_GPU_RGX_DUST_B_FRC					0x40000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_TOP_FRC					0x20000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_SNOOP_FILTER_FRC				0x10000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P3_FRC				0x8000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P2_FRC				0x4000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P1_FRC				0x2000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P0_FRC				0x1000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE3_FRC					0x800000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE2_FRC					0x400000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE1_FRC					0x200000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE0_FRC					0x100000
#define MASK_PMU_APB_RF_RAM_PD_PUBCP_SYS_FRC					0x80000
#define MASK_PMU_APB_RF_RAM_PD_AUDCP_SYS_FRC					0x40000
#define MASK_PMU_APB_RF_RAM_PD_AUDCP_AUDDSP_FRC					0x20000
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_SYS_FRC					0x10000
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_LTE_DPFEC_FRC					0x8000
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_LTE_CE_FRC					0x4000
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_LTE_PROC_FRC					0x2000
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_TD_PROC_FRC					0x1000
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_HU3GE_B_FRC					0x800
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_HU3GE_A_FRC					0x400
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_TGDSP_CACHE_FRC				0x200
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_TGDSP_TCM_FRC					0x100
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_LDSP_CACHE_FRC				0x80
#define MASK_PMU_APB_RF_RAM_PD_WTLCP_LDSP_TCM_FRC					0x40
#define MASK_PMU_APB_RF_RAM_PD_AP_SYS_FRC						0x20
#define MASK_PMU_APB_RF_RAM_PD_AP_VSP_FRC						0x10
#define MASK_PMU_APB_RF_RAM_PD_AP_VDSP_FRC						0x8
#define MASK_PMU_APB_RF_RAM_PD_MM_TOP_FRC						0x4
#define MASK_PMU_APB_RF_RAM_PD_GPU_TOP_FRC						0x2
#define MASK_PMU_APB_RF_RAM_PD_GPU_RGX_DUST_A_FRC					0x1
#define MASK_PMU_APB_RF_RAM_RET_APCPU_TOP_FRC					0x800
#define MASK_PMU_APB_RF_RAM_RET_APCPU_SNOOP_FILTER_FRC				0x400
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P3_FRC				0x200
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P2_FRC				0x100
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P1_FRC				0x80
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P0_FRC				0x40
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE3_FRC					0x20
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE2_FRC					0x10
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE1_FRC					0x8
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE0_FRC					0x4
#define MASK_PMU_APB_RF_RAM_SLP_WTLCP_TGDSP_TCM_FRC				0x2
#define MASK_PMU_APB_RF_RAM_SLP_WTLCP_LDSP_TCM_FRC					0x1
#define MASK_PMU_APB_RF_PUB_DFS_FREQ_SEL						0x7
#define MASK_PMU_APB_RF_PACTIVE_CORE0_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE1_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE2_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE3_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE4_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE5_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE6_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CORE7_SW						0xf
#define MASK_PMU_APB_RF_PACTIVE_CLUSTER_SW						0x7f
#define MASK_PMU_APB_RF_APCPU_CLUSTER_SW_PACTIVE_EN				0x100
#define MASK_PMU_APB_RF_APCPU_CORE7_SW_PACTIVE_EN					0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_SW_PACTIVE_EN					0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_SW_PACTIVE_EN					0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_SW_PACTIVE_EN					0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_SW_PACTIVE_EN					0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_SW_PACTIVE_EN					0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_SW_PACTIVE_EN					0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_SW_PACTIVE_EN					0x1
#define MASK_PMU_APB_RF_APCPU_CLUSTER_SW_PCHANNEL_EN				0x100
#define MASK_PMU_APB_RF_APCPU_CORE7_SW_PCHANNEL_EN					0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_SW_PCHANNEL_EN					0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_SW_PCHANNEL_EN					0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_SW_PCHANNEL_EN					0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_SW_PCHANNEL_EN					0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_SW_PCHANNEL_EN					0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_SW_PCHANNEL_EN					0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_SW_PCHANNEL_EN					0x1
#define MASK_PMU_APB_RF_APCPU_CORE0_PACTIVE					0xf000
#define MASK_PMU_APB_RF_APCPU_CORE0_PDENY						0x800
#define MASK_PMU_APB_RF_APCPU_CORE0_PACCEPT					0x400
#define MASK_PMU_APB_RF_MODE_ST_CORE0_CGM_EN_SW					0x200
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE0_SW					0x100
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE0_SW					0x80
#define MASK_PMU_APB_RF_RST_APCPU_CORE0_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE0_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE0_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE0_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE1_PACTIVE					0xf000
#define MASK_PMU_APB_RF_APCPU_CORE1_PDENY						0x800
#define MASK_PMU_APB_RF_APCPU_CORE1_PACCEPT					0x400
#define MASK_PMU_APB_RF_MODE_ST_CORE1_CGM_EN_SW					0x200
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE1_SW					0x100
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE1_SW					0x80
#define MASK_PMU_APB_RF_RST_APCPU_CORE1_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE1_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE1_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE1_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE2_PACTIVE					0xf000
#define MASK_PMU_APB_RF_APCPU_CORE2_PDENY						0x800
#define MASK_PMU_APB_RF_APCPU_CORE2_PACCEPT					0x400
#define MASK_PMU_APB_RF_MODE_ST_CORE2_CGM_EN_SW					0x200
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE2_SW					0x100
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE2_SW					0x80
#define MASK_PMU_APB_RF_RST_APCPU_CORE2_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE2_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE2_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE2_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE3_PACTIVE					0xf000
#define MASK_PMU_APB_RF_APCPU_CORE3_PDENY						0x800
#define MASK_PMU_APB_RF_APCPU_CORE3_PACCEPT					0x400
#define MASK_PMU_APB_RF_MODE_ST_CORE3_CGM_EN_SW					0x200
#define MASK_PMU_APB_RF_RAM_RET_APCPU_CORE3_SW					0x100
#define MASK_PMU_APB_RF_RAM_PD_APCPU_CORE3_SW					0x80
#define MASK_PMU_APB_RF_RST_APCPU_CORE3_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE3_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE3_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE3_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE4_PACTIVE					0x3c00
#define MASK_PMU_APB_RF_APCPU_CORE4_PDENY						0x200
#define MASK_PMU_APB_RF_APCPU_CORE4_PACCEPT					0x100
#define MASK_PMU_APB_RF_RST_APCPU_CORE4_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE4_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE4_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE5_PACTIVE					0x3c00
#define MASK_PMU_APB_RF_APCPU_CORE5_PDENY						0x200
#define MASK_PMU_APB_RF_APCPU_CORE5_PACCEPT					0x100
#define MASK_PMU_APB_RF_RST_APCPU_CORE5_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE5_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE5_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE5_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE6_PACTIVE					0x3c00
#define MASK_PMU_APB_RF_APCPU_CORE6_PDENY						0x200
#define MASK_PMU_APB_RF_APCPU_CORE6_PACCEPT					0x100
#define MASK_PMU_APB_RF_RST_APCPU_CORE6_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE6_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE6_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE6_PREQ_SW					0x1
#define MASK_PMU_APB_RF_APCPU_CORE7_PACTIVE					0x3c00
#define MASK_PMU_APB_RF_APCPU_CORE7_PDENY						0x200
#define MASK_PMU_APB_RF_APCPU_CORE7_PACCEPT					0x100
#define MASK_PMU_APB_RF_RST_APCPU_CORE7_WARM_SW_N					0x40
#define MASK_PMU_APB_RF_RST_APCPU_CORE7_COLD_SW_N					0x20
#define MASK_PMU_APB_RF_APCPU_CORE7_PSTATE_SW					0x1e
#define MASK_PMU_APB_RF_APCPU_CORE7_PREQ_SW					0x1
#define MASK_PMU_APB_RF_RAM_RET_APCPU_SNOOP_FILTER_SW				0x10000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_SNOOP_FILTER_SW				0x8000000
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P3_SW				0x4000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P3_SW				0x2000000
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P2_SW				0x1000000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P2_SW				0x800000
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P1_SW				0x400000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P1_SW				0x200000
#define MASK_PMU_APB_RF_RAM_RET_APCPU_L3CACHE_TAG_P0_SW				0x100000
#define MASK_PMU_APB_RF_RAM_PD_APCPU_L3CACHE_TAG_P0_SW				0x80000
#define MASK_PMU_APB_RF_APCPU_CLUSTER_PACTIVE					0x7f000
#define MASK_PMU_APB_RF_APCPU_CLUSTER_PDENY					0x800
#define MASK_PMU_APB_RF_APCPU_CLUSTER_PACCEPT					0x400
#define MASK_PMU_APB_RF_RST_APCPU_CLUSTER_WARM_SW_N				0x200
#define MASK_PMU_APB_RF_RST_APCPU_CLUSTER_COLD_SW_N				0x100
#define MASK_PMU_APB_RF_APCPU_CLUSTER_PSTATE_SW					0xfe
#define MASK_PMU_APB_RF_APCPU_CLUSTER_PREQ_SW					0x1
#define MASK_PMU_APB_RF_WTLCP_DPFEC_NEST_DOMAIN_EN					0x1
#define MASK_PMU_APB_RF_GPLL_GPIO_FORCE_GATING_DISABLE				0x10
#define MASK_PMU_APB_RF_MPLL2_GPIO_FORCE_GATING_DISABLE				0x4
#define MASK_PMU_APB_RF_MPLL1_GPIO_FORCE_GATING_DISABLE				0x2
#define MASK_PMU_APB_RF_MPLL0_GPIO_FORCE_GATING_DISABLE				0x1
#define MASK_PMU_APB_RF_CSI_2P2LANE_PWRON_REG					0x10
#define MASK_PMU_APB_RF_DSI_PWRON_REG						0x8
#define MASK_PMU_APB_RF_PCIE2_PWRON_REG						0x4
#define MASK_PMU_APB_RF_CSI_4LANE1_PWRON_REG					0x2
#define MASK_PMU_APB_RF_CSI_4LANE0_PWRON_REG					0x1
#define MASK_PMU_APB_RF_APCPU_CORE3_MODE_ST_CGM_EN_DISABLE				0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_MODE_ST_CGM_EN_DISABLE				0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_MODE_ST_CGM_EN_DISABLE				0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_MODE_ST_CGM_EN_DISABLE				0x1
#define MASK_PMU_APB_RF_APCPU_CLUSTER_DENY_TIME_THRESHOLD				0xfc0
#define MASK_PMU_APB_RF_APCPU_CORE_DENY_TIME_THRESHOLD				0x3f
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CLUSTER_EN				0x100
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE7_EN				0x80
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE6_EN				0x40
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE5_EN				0x20
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE4_EN				0x10
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE3_EN				0x8
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE2_EN				0x4
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE1_EN				0x2
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE0_EN				0x1
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CLUSTER_CLR				0x100
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE7_CLR				0x80
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE6_CLR				0x40
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE5_CLR				0x20
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE4_CLR				0x10
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE3_CLR				0x8
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE2_CLR				0x4
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE1_CLR				0x2
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE0_CLR				0x1
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CLUSTER				0x100
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE7				0x80
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE6				0x40
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE5				0x20
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE4				0x10
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE3				0x8
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE2				0x4
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE1				0x2
#define MASK_PMU_APB_RF_INT_REQ_MODE_ST_APCPU_CORE0				0x1
#define MASK_PMU_APB_RF_APCPU_CORE0_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE0_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE1_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE1_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE2_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE2_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE3_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE3_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE4_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE4_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE5_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE5_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE6_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE6_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CORE7_DENY_TAR_STATE					0x3e0
#define MASK_PMU_APB_RF_APCPU_CORE7_DENY_PRE_STATE					0x1f
#define MASK_PMU_APB_RF_APCPU_CLUSTER_DENY_TAR_STATE				0xfc0
#define MASK_PMU_APB_RF_APCPU_CLUSTER_DENY_PRE_STATE				0x3f
#define MASK_PMU_APB_RF_APCPU_CSYSPWRUP_WAKEUP_EN					0xff
#define MASK_PMU_APB_RF_DCDC_AI_DVFS_BLOCK_SHUTDOWN_EN				0x4
#define MASK_PMU_APB_RF_DCDC_CPU1_DVFS_BLOCK_SHUTDOWN_EN				0x2
#define MASK_PMU_APB_RF_DCDC_CPU0_DVFS_BLOCK_SHUTDOWN_EN				0x1
#define MASK_PMU_APB_RF_APCPU_CORE7_OFF_EMU_CLR_INT_DISABLE_EN			0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_OFF_EMU_CLR_INT_DISABLE_EN			0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_OFF_EMU_CLR_INT_DISABLE_EN			0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_OFF_EMU_CLR_INT_DISABLE_EN			0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_OFF_EMU_CLR_INT_DISABLE_EN			0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_OFF_EMU_CLR_INT_DISABLE_EN			0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_OFF_EMU_CLR_INT_DISABLE_EN			0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_OFF_EMU_CLR_INT_DISABLE_EN			0x1
#define MASK_PMU_APB_RF_APCPU_SNOOP_FILTER_RAM_FRC_ON				0x100
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P3_RAM_FRC_ON				0x80
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P2_RAM_FRC_ON				0x40
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P1_RAM_FRC_ON				0x20
#define MASK_PMU_APB_RF_APCPU_L3CACHE_TAG_P0_RAM_FRC_ON				0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_RAM_FRC_ON					0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_RAM_FRC_ON					0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_RAM_FRC_ON					0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_RAM_FRC_ON					0x1
#define MASK_PMU_APB_RF_APCPU_CORE7_OFF_EMU_TO_OFF					0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_OFF_EMU_TO_OFF					0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_OFF_EMU_TO_OFF					0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_OFF_EMU_TO_OFF					0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_OFF_EMU_TO_OFF					0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_OFF_EMU_TO_OFF					0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_OFF_EMU_TO_OFF					0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_OFF_EMU_TO_OFF					0x1
#define MASK_PMU_APB_RF_ALL_PLL_PD_RCO_BYP						0x1
#define MASK_PMU_APB_RF_SP_PWR_PD_AON_MEM_BYP					0x2
#define MASK_PMU_APB_RF_SP_PWR_PD_SP_MEM_BYP					0x1
#define MASK_PMU_APB_RF_LPDDR3_DPLL1_CNT_DONE_BYP					0x1
#define MASK_PMU_APB_RF_SP_SRAM_RCO_SYS_SEL					0x8
#define MASK_PMU_APB_RF_SP_SRAM_XTLBUF0_SYS_SEL					0x4
#define MASK_PMU_APB_RF_AON_SRAM_RCO_SYS_SEL					0x2
#define MASK_PMU_APB_RF_AON_SRAM_XTLBUF0_SYS_SEL					0x1
#define MASK_PMU_APB_RF_WDG_RST_TRIG_DBG_RECOV_EN					0x1
#define MASK_PMU_APB_RF_APCPU_TOP_RAM_SHUTDOWN_EN					0x1
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_PWRUP_ABORT				0x10000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_PWRDWN_ABORT				0x8000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_PD_SEL					0x4000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_FORCE_SHUTDOWN				0x2000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_PWR_ON_DLY				0xff0000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_PWR_ON_SEQ_DLY				0xff00
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_ISO_ON_DLY				0xff
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_SHUTDOWN_DLY				0xff000000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_RST_DEASSERT_DLY				0xff0000
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_RST_ASSERT_DLY				0xff00
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_ISO_OFF_DLY				0xff
#define MASK_PMU_APB_RF_PD_IPA_SYS_FORCE_SHUTDOWN					0x2000000
#define MASK_PMU_APB_RF_PD_IPA_SYS_AUTO_SHUTDOWN_EN				0x1000000
#define MASK_PMU_APB_RF_PD_IPA_SYS_PWR_ON_DLY					0xff0000
#define MASK_PMU_APB_RF_PD_IPA_SYS_PWR_ON_SEQ_DLY					0xff00
#define MASK_PMU_APB_RF_PD_IPA_SYS_ISO_ON_DLY					0xff
#define MASK_PMU_APB_RF_APCPU_CLUSTER_MODE_ST_SOFT_RST				0x100
#define MASK_PMU_APB_RF_APCPU_CORE7_MODE_ST_SOFT_RST				0x80
#define MASK_PMU_APB_RF_APCPU_CORE6_MODE_ST_SOFT_RST				0x40
#define MASK_PMU_APB_RF_APCPU_CORE5_MODE_ST_SOFT_RST				0x20
#define MASK_PMU_APB_RF_APCPU_CORE4_MODE_ST_SOFT_RST				0x10
#define MASK_PMU_APB_RF_APCPU_CORE3_MODE_ST_SOFT_RST				0x8
#define MASK_PMU_APB_RF_APCPU_CORE2_MODE_ST_SOFT_RST				0x4
#define MASK_PMU_APB_RF_APCPU_CORE1_MODE_ST_SOFT_RST				0x2
#define MASK_PMU_APB_RF_APCPU_CORE0_MODE_ST_SOFT_RST				0x1
#define MASK_PMU_APB_RF_AUDCP_FORCE_PUB_DEEP_SLEEP					0x1
#define MASK_PMU_APB_RF_PUB_SYS_FORCE_DEEP_SLEEP					0x80
#define MASK_PMU_APB_RF_IPA_FORCE_DEEP_SLEEP					0x40
#define MASK_PMU_APB_RF_SP_SYS_FORCE_DEEP_SLEEP					0x20
#define MASK_PMU_APB_RF_AUDCP_FORCE_DEEP_SLEEP					0x10
#define MASK_PMU_APB_RF_PSCP_FORCE_DEEP_SLEEP					0x8
#define MASK_PMU_APB_RF_V3_MODEM_FORCE_DEEP_SLEEP					0x4
#define MASK_PMU_APB_RF_AP_FORCE_DEEP_SLEEP					0x2
#define MASK_PMU_APB_RF_NRCP_FORCE_DEEP_SLEEP					0x1
#define MASK_PMU_APB_RF_PUB_SYS_FORCE_LIGHT_SLEEP					0x80
#define MASK_PMU_APB_RF_IPA_FORCE_LIGHT_SLEEP					0x40
#define MASK_PMU_APB_RF_NRCP_FORCE_LIGHT_SLEEP					0x20
#define MASK_PMU_APB_RF_AON_FORCE_LIGHT_SLEEP					0x10
#define MASK_PMU_APB_RF_PSCP_FORCE_LIGHT_SLEEP					0x8
#define MASK_PMU_APB_RF_V3_MODEM_FORCE_LIGHT_SLEEP					0x4
#define MASK_PMU_APB_RF_AUDCP_FORCE_LIGHT_SLEEP					0x2
#define MASK_PMU_APB_RF_AP_FORCE_LIGHT_SLEEP					0x1
#define MASK_PMU_APB_RF_PUB_SYS_FORCE_SYSTEM_SLEEP					0x200
#define MASK_PMU_APB_RF_IPA_FORCE_SYSTEM_SLEEP					0x100
#define MASK_PMU_APB_RF_AUDCP_FORCE_SYSTEM_SLEEP					0x80
#define MASK_PMU_APB_RF_GPU_TOP_FORCE_SYSTEM_SLEEP					0x40
#define MASK_PMU_APB_RF_NRCP_FORCE_SYSTEM_SLEEP					0x20
#define MASK_PMU_APB_RF_PSCP_FORCE_SYSTEM_SLEEP					0x10
#define MASK_PMU_APB_RF_V3_MODEM_FORCE_SYSTEM_SLEEP				0x8
#define MASK_PMU_APB_RF_AP_FORCE_SYSTEM_SLEEP					0x4
#define MASK_PMU_APB_RF_APCPU_FORCE_SYSTEM_SLEEP					0x2
#define MASK_PMU_APB_RF_AP_ALL_FORCE_SYSTEM_SLEEP					0x1
#define MASK_PMU_APB_RF_ESE_ACCESS_DDR_EN						0x1
#define MASK_PMU_APB_RF_PD_NRCP_SYS_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_AP_VSP_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_AP_VDSP_STATE						0xff00
#define MASK_PMU_APB_RF_PD_AP_SYS_STATE						0xff
#define MASK_PMU_APB_RF_PD_NRCP_UL_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_NRCP_DL_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_STATE					0xff00
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_STATE					0xff
#define MASK_PMU_APB_RF_PD_PUB_SYS_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_PSCP_SYS_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_STATE					0xff00
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_STATE						0xff
#define MASK_PMU_APB_RF_PD_V3_LCE_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_V3_DPFEC_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_V3_WCE_STATE						0xff00
#define MASK_PMU_APB_RF_PD_V3_LWPROC_STATE						0xff
#define MASK_PMU_APB_RF_PD_V3_PHY_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_V3_PS_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_V3_MODEM_STATE						0xff00
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_STATE						0xff
#define MASK_PMU_APB_RF_PD_APCPU_C3_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_APCPU_C2_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C1_STATE						0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C0_STATE						0xff
#define MASK_PMU_APB_RF_PD_APCPU_C7_STATE						0xff000000
#define MASK_PMU_APB_RF_PD_APCPU_C6_STATE						0xff0000
#define MASK_PMU_APB_RF_PD_APCPU_C5_STATE						0xff00
#define MASK_PMU_APB_RF_PD_APCPU_C4_STATE						0xff
#define MASK_PMU_APB_RF_PD_V3_TD_STATE						0xff00
#define MASK_PMU_APB_RF_PD_APCPU_TOP_STATE						0xff
#define MASK_PMU_APB_RF_APCPU_CORE3_POWER_MODE_STATE				0xff000000
#define MASK_PMU_APB_RF_APCPU_CORE2_POWER_MODE_STATE				0xff0000
#define MASK_PMU_APB_RF_APCPU_CORE1_POWER_MODE_STATE				0xff00
#define MASK_PMU_APB_RF_APCPU_CORE0_POWER_MODE_STATE				0xff
#define MASK_PMU_APB_RF_APCPU_CORE7_POWER_MODE_STATE				0xff000000
#define MASK_PMU_APB_RF_APCPU_CORE6_POWER_MODE_STATE				0xff0000
#define MASK_PMU_APB_RF_APCPU_CORE5_POWER_MODE_STATE				0xff00
#define MASK_PMU_APB_RF_APCPU_CORE4_POWER_MODE_STATE				0xff
#define MASK_PMU_APB_RF_APCPU_CORINTH_POWER_MODE_STATE				0xff
#define MASK_PMU_APB_RF_CORE_WFI_MARK_CLR						0x300
#define MASK_PMU_APB_RF_CORE_WFI_MARK						0x3
#define MASK_PMU_APB_RF_AXI_LP_CTRL_DISABLE					0x1
#define MASK_PMU_APB_RF_PD_APCPU_C0_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_C1_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_C2_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_C3_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_TOP_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_AP_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_NRCP_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_NRCP_SYNC_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_WCE_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_LCE_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_DPFEC_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_LWPROC_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_PHY_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_PS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_NRCP_DSP_0_SHUTDOWN_MARK				0xf
#define MASK_PMU_APB_RF_PD_NRCP_DSP_1_SHUTDOWN_MARK				0xf
#define MASK_PMU_APB_RF_PD_V3_MODEM_SYS_SHUTDOWN_MARK				0xf
#define MASK_PMU_APB_RF_PD_PSCP_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_NRCP_DL_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_V3_TD_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_AUDCP_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_PUB_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_AUDCP_AUDDSP_SHUTDOWN_MARK				0xf
#define MASK_PMU_APB_RF_PD_NRCP_UL_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_GPU_RGX_DUST_B_SHUTDOWN_MARK				0xf
#define MASK_PMU_APB_RF_APCPU_TOP_SYS_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_AP_SYS_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_V3_MODEM_SYS_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_PSCP_SYS_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_AUDCP_SYS_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_PUB_SYS_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_AP_DEEP_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_SP_SYS_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_V3_MODEM_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_PSCP_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_AUDCP_SYS_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_PUB_SYS_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_AP_LIGHT_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_V3_MODEM_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_PSCP_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_AUDCP_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_AON_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_IPA_SYS_SRST_BUSY						0x200
#define MASK_PMU_APB_RF_AI_SYS_SRST_BUSY						0x100
#define MASK_PMU_APB_RF_NRCP_SYS_SRST_BUSY						0x80
#define MASK_PMU_APB_RF_AUDCP_SYS_SRST_BUSY					0x40
#define MASK_PMU_APB_RF_AP_SYS_SRST_BUSY						0x20
#define MASK_PMU_APB_RF_APCPU_SYS_SRST_BUSY					0x10
#define MASK_PMU_APB_RF_GPU_SYS_SRST_BUSY						0x8
#define MASK_PMU_APB_RF_MM_SYS_SRST_BUSY						0x4
#define MASK_PMU_APB_RF_V3_MODEM_SYS_SRST_BUSY					0x2
#define MASK_PMU_APB_RF_PSCP_SYS_SRST_BUSY						0x1
#define MASK_PMU_APB_RF_REG_IPA_SRST_FRC_LP_ACK					0x200
#define MASK_PMU_APB_RF_REG_AI_SRST_FRC_LP_ACK					0x100
#define MASK_PMU_APB_RF_REG_NRCP_SRST_FRC_LP_ACK					0x80
#define MASK_PMU_APB_RF_REG_AUDCP_SRST_FRC_LP_ACK					0x40
#define MASK_PMU_APB_RF_REG_AP_SRST_FRC_LP_ACK					0x20
#define MASK_PMU_APB_RF_REG_APCPU_SRST_FRC_LP_ACK					0x10
#define MASK_PMU_APB_RF_REG_GPU_SRST_FRC_LP_ACK					0x8
#define MASK_PMU_APB_RF_REG_MM_SRST_FRC_LP_ACK					0x4
#define MASK_PMU_APB_RF_REG_V3_MODEM_SRST_FRC_LP_ACK				0x2
#define MASK_PMU_APB_RF_REG_PSCP_SRST_FRC_LP_ACK					0x1
#define MASK_PMU_APB_RF_SOFT_RST_SEL						0x3ff
#define MASK_PMU_APB_RF_REG_CS_SYS_DDR_PWR_HS_ACK					0x800
#define MASK_PMU_APB_RF_FRC_TOP_ASYNC_BRG_ENA					0x400
#define MASK_PMU_APB_RF_ASYNC_BRG_EB_IGNORE					0x200
#define MASK_PMU_APB_RF_REG_NRCP_SYS_DDR_PWR_HS_ACK				0x100
#define MASK_PMU_APB_RF_REG_AUDCP_SYS_DDR_PWR_HS_ACK				0x80
#define MASK_PMU_APB_RF_REG_PSCP_SYS_DDR_PWR_HS_ACK				0x40
#define MASK_PMU_APB_RF_REG_V3_MODEM_SYS_DDR_PWR_HS_ACK				0x20
#define MASK_PMU_APB_RF_REG_APCPU_TOP_DDR_PWR_HS_ACK				0x10
#define MASK_PMU_APB_RF_REG_AP_SYS_DDR_PWR_HS_ACK					0x8
#define MASK_PMU_APB_RF_REG_MM_SYS_DDR_PWR_HS_ACK					0x4
#define MASK_PMU_APB_RF_REG_GPU_SYS_DDR_PWR_HS_ACK					0x2
#define MASK_PMU_APB_RF_REG_AON_SYS_DDR_PWR_HS_ACK					0x1
#define MASK_PMU_APB_RF_CSI_2P2LANE_PWR_CNT_DONE					0x8
#define MASK_PMU_APB_RF_CSI_4LANE1_PWR_CNT_DONE					0x4
#define MASK_PMU_APB_RF_CSI_4LANE0_PWR_CNT_DONE					0x2
#define MASK_PMU_APB_RF_DSI_PWR_CNT_DONE						0x1
#define MASK_PMU_APB_RF_PD_AP_SYS_DBG_SHUTDOWN_EN					0x1
#define MASK_PMU_APB_RF_EIC_SYS_SEL						0x7
#define MASK_PMU_APB_RF_DDR_SLP_CTRL_STATE						0xf
#define MASK_PMU_APB_RF_PD_APCPU_C4_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_C5_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_C6_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_PD_APCPU_C7_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_APCPU_TOP_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_APCPU_TOP_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_PD_ESE_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_NRCP_DEEP_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_NRCP_SYS_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_PD_IPA_SYS_SHUTDOWN_MARK					0xf
#define MASK_PMU_APB_RF_NRCP_LIGHT_SLEEP_CNT					0xff
#define MASK_PMU_APB_RF_IPA_DEEP_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_IPA_SYS_SLEEP_CNT						0xff
#define MASK_PMU_APB_RF_IPA_LIGHT_SLEEP_CNT					0xff
#define MASK_PUB_AHB_RF_SOFT_CMD_NUM						0x700
#define MASK_PUB_AHB_RF_SOFT_CMD_FC_SEL						0x70
#define MASK_PUB_AHB_RF_SOFT_CMD_RESP						0x8
#define MASK_PUB_AHB_RF_SOFT_CMD_DONE						0x4
#define MASK_PUB_AHB_RF_SOFT_CMD_START						0x1
#define MASK_PUB_AHB_RF_SOFT_CMD_SEQL						0xffffffff
#define MASK_PUB_AHB_RF_SOFT_CMD_SEQH						0xffffffff
#define MASK_PUB_AHB_RF_SOFT_CMD_STEP						0xffffffff
#define MASK_PUB_AHB_RF_MPU_DUMP_ADDR						0xffffffff
#define MASK_PUB_AHB_RF_DMC_MPU_VIO_ADDR						0xffffffff
#define MASK_PUB_AHB_RF_DMC_MPU_VIO_CMD						0xffffffff
#define MASK_PUB_AHB_RF_DMC_MPU_VIO_INT_REQ					0x2
#define MASK_PUB_AHB_RF_RF_MPU_EN							0x1
#define MASK_PUB_AHB_RF_RF_MPU_CFG0						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG0_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG0_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG0_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG1						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG1_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG1_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG1_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG2						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG2_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG2_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG2_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG3						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG3_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG3_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG3_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG4						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG4_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG4_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG4_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG5						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG5_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG5_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG5_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG6						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG6_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG6_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG6_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG7						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG7_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG7_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG7_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG8						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG8_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG8_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG8_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG9						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG9_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG9_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG9_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG10						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG10_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG10_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG10_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG11						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG11_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG11_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG11_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG12						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG12_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG12_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG12_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG13						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG13_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG13_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG13_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG14						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG14_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG14_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG14_HIGH_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG15						0x1ff
#define MASK_PUB_AHB_RF_RF_MPU_CFG15_ID_MASK_VAL					0xffffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG15_LOW_RANGE					0x7ffffff
#define MASK_PUB_AHB_RF_RF_MPU_CFG15_HIGH_RANGE					0x7ffffff
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_RSTN					0x8000000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_RUN					0x4000000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_PD					0x2000000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_VALID				0x1000000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_BG_RBIAS_MODE			0x800000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_TEST_SEL				0x600000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_BP_MODE				0x100000
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_DATA					0xffc00
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_BP_DATA				0x3ff
#define MASK_ANLG_PHY_G9_RF_ANALOG_THM1_0_THM_RESERVED				0xffff
#define MASK_ANLG_PHY_G9_RF_DBG_SEL_ANALOG_THM1_0_THM_RSTN				0x8
#define MASK_ANLG_PHY_G9_RF_DBG_SEL_ANALOG_THM1_0_THM_RUN				0x4
#define MASK_ANLG_PHY_G9_RF_DBG_SEL_ANALOG_THM1_0_THM_PD				0x2
#define MASK_ANLG_PHY_G9_RF_DBG_SEL_ANALOG_THM1_0_THM_RESERVED			0x1
#define MASK_AP_IPA_AHB_RF_PCIE_SEL						0x200
#define MASK_AP_IPA_AHB_RF_USB_PAM_EB						0x100
#define MASK_AP_IPA_AHB_RF_IPA_EB							0x80
#define MASK_AP_IPA_AHB_RF_PCIE_AUX_EB						0x40
#define MASK_AP_IPA_AHB_RF_PCIE_EB							0x20
#define MASK_AP_IPA_AHB_RF_SDIO_SLV_FRUN_EB					0x10
#define MASK_AP_IPA_AHB_RF_SDIO_SLV_EB						0x8
#define MASK_AP_IPA_AHB_RF_USB1_REF_EB						0x4
#define MASK_AP_IPA_AHB_RF_USB1_SUSPEND_EB						0x2
#define MASK_AP_IPA_AHB_RF_USB1_EB							0x1
#define MASK_AP_IPA_AHB_RF_USB_PAM_SOFT_RST					0x20
#define MASK_AP_IPA_AHB_RF_IPA_SOFT_RST						0x10
#define MASK_AP_IPA_AHB_RF_PCIE_SOFT_RST						0x8
#define MASK_AP_IPA_AHB_RF_SDIO_SLV_SOFT_RST					0x4
#define MASK_AP_IPA_AHB_RF_PCIE_BUT_SOFT_RST					0x2
#define MASK_AP_IPA_AHB_RF_USB1_SOFT_RST						0x1
#define MASK_AP_IPA_AHB_RF_CP1_SYS_SW_SLEEP					0x8
#define MASK_AP_IPA_AHB_RF_CP0_SYS_SW_SLEEP					0x4
#define MASK_AP_IPA_AHB_RF_IPA_APB_FRC_SLP						0x2
#define MASK_AP_IPA_AHB_RF_CGM_CLK_AP_AXI_AUTO_GATE_EN				0x1
#define MASK_AP_IPA_AHB_RF_PIPE3_POWERPRESENT1					0x10000
#define MASK_AP_IPA_AHB_RF_UTMISRP_BVALID_REG1					0x8000
#define MASK_AP_IPA_AHB_RF_OTG_VBUS_VALID_PHYREG1					0x4000
#define MASK_AP_IPA_AHB_RF_OTG_VBUS_VALID_PHYREG_SEL1				0x2000
#define MASK_AP_IPA_AHB_RF_HOST_SYSTEM_ERR1					0x1000
#define MASK_AP_IPA_AHB_RF_HOST_PORT_POWER_CONTROL_PRESENT1			0x800
#define MASK_AP_IPA_AHB_RF_FLADJ_30MHZ_REG1					0x7e0
#define MASK_AP_IPA_AHB_RF_PME_EN1							0x10
#define MASK_AP_IPA_AHB_RF_BUS_FILTER_BYPASS1					0xf
#define MASK_AP_IPA_AHB_RF_USB1_DUG_0						0xffffffff
#define MASK_AP_IPA_AHB_RF_USB1_DUG_1						0xffffffff
#define MASK_AP_IPA_AHB_RF_USB1_HOST_CURRENT_BELT					0x3ffc0
#define MASK_AP_IPA_AHB_RF_USB1_CLK_GATE_CTRL					0x38
#define MASK_AP_IPA_AHB_RF_USB1_DUG_2						0x7
#define MASK_AP_IPA_AHB_RF_PCIE_STATUS						0xffff0000
#define MASK_AP_IPA_AHB_RF_PCIE_CONFIG						0xffc0
#define MASK_AP_IPA_AHB_RF_APP_XFER_PENDING					0x20
#define MASK_AP_IPA_AHB_RF_APP_L1_PWR_OFF_EN					0x10
#define MASK_AP_IPA_AHB_RF_DBG_PBA							0x8
#define MASK_AP_IPA_AHB_RF_DBG_TABLE						0x4
#define MASK_AP_IPA_AHB_RF_PCIE_SYS_INT_USB_PAM_EN					0x2
#define MASK_AP_IPA_AHB_RF_PCIE_SYS_INT_SW_EN					0x1
#define MASK_AP_IPA_AHB_RF_PCIE_RSV						0xffffffff
#define MASK_AP_IPA_AHB_RF_APP_RAS_DES_TBA_CTRL					0xc0000000
#define MASK_AP_IPA_AHB_RF_APP_RAS_DES_SD_HOLD_LTSSM				0x20000000
#define MASK_AP_IPA_AHB_RF_CFG_LINK_AUTO_BW_INT					0x10000000
#define MASK_AP_IPA_AHB_RF_HP_MSI							0x8000000
#define MASK_AP_IPA_AHB_RF_HP_INT							0x4000000
#define MASK_AP_IPA_AHB_RF_HP_PMUE							0x3e00000
#define MASK_AP_IPA_AHB_RF_CFG_PCIE_CAP_INT_MSG_NUM				0x100000
#define MASK_AP_IPA_AHB_RF_CFG_PME_MSI						0x80000
#define MASK_AP_IPA_AHB_RF_CFG_PME_INT						0x7c000
#define MASK_AP_IPA_AHB_RF_CFG_AER_INT_MSG_NUM					0x2000
#define MASK_AP_IPA_AHB_RF_CFG_AER_RC_ERR_MSI					0x1000
#define MASK_AP_IPA_AHB_RF_CFG_AER_RC_ERR_INT					0x800
#define MASK_AP_IPA_AHB_RF_CFG_EML_CONTRL						0x400
#define MASK_AP_IPA_AHB_RF_CFG_BUS_MASTER_EN					0x200
#define MASK_AP_IPA_AHB_RF_CFG_PWR_CTRLER_CTRL					0x100
#define MASK_AP_IPA_AHB_RF_CFG_ATTEN_IND						0xc0
#define MASK_AP_IPA_AHB_RF_CFG_PWR_IND						0x30
#define MASK_AP_IPA_AHB_RF_CFG_MULTI_MSI_EN					0xe
#define MASK_AP_IPA_AHB_RF_CFG_MSI_EN						0x1
#define MASK_AP_IPA_AHB_RF_CFG_MSI_MASK						0xffffffff
#define MASK_AP_IPA_AHB_RF_SDIO_SLV_PCLK_AUTO_GATE_EB				0x8
#define MASK_AP_IPA_AHB_RF_PCIE_SNPS_PCLK_AUTO_GATE_EB				0x4
#define MASK_AP_IPA_AHB_RF_PCIE_XZ_PCLK_AUTO_GATE_EB				0x2
#define MASK_AP_IPA_AHB_RF_USB_PAM_PCLK_AUTO_GATE_EB				0x1
#define MASK_AP_IPA_AHB_RF_SDIO_SLV_PCLK_AUTO_SLOW_EN				0x8000
#define MASK_AP_IPA_AHB_RF_SDIO_SLV_PCLK_AUTO_SLOW_SEL				0x7000
#define MASK_AP_IPA_AHB_RF_PCIE_SNPS_PCLK_AUTO_SLOW_EN				0x800
#define MASK_AP_IPA_AHB_RF_PCIE_SNPS_PCLK_AUTO_SLOW_SEL				0x700
#define MASK_AP_IPA_AHB_RF_PCIE_XZ_PCLK_AUTO_SLOW_EN				0x80
#define MASK_AP_IPA_AHB_RF_PCIE_XZ_PCLK_AUTO_SLOW_SEL				0x70
#define MASK_AP_IPA_AHB_RF_USB_PAM_PCLK_AUTO_SLOW_EN				0x8
#define MASK_AP_IPA_AHB_RF_USB_PAM_PCLK_AUTO_SLOW_SEL				0x7
#define MASK_AP_IPA_AHB_RF_CACTIVE_SLV3_WAKEUP_EN					0x8
#define MASK_AP_IPA_AHB_RF_AP_CLK_GATE_LPC_BYP					0x4
#define MASK_AP_IPA_AHB_RF_LP_AUTO_CTRL_EN						0x2
#define MASK_AP_IPA_AHB_RF_IMTX_LPC_DISABLE					0x1
#define MASK_AP_IPA_AHB_RF_IMTX_M0_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M0_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M1_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M1_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M2_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_IMTX_M2_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M2_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M3_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_IMTX_M3_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M3_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M4_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_IMTX_M4_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M4_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M5_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M5_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M6_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M6_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M7_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M7_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M8_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M8_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_M9_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_IMTX_M9_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M9_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_MAIN_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_AUTO_GATE_EN					0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_MAIN_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_MAIN_LP_NUM					0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S0_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S0_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S0_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S0_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S1_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S1_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S1_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S1_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S2_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S2_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S2_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S2_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S3_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S3_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S3_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S3_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S4_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S4_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S4_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S4_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S5_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S5_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S5_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S5_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S6_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S6_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S6_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S6_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S7_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S7_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S7_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S7_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S8_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S8_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S8_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S8_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S9_LP_EARLY_WAKEUP_EN				0x40000
#define MASK_AP_IPA_AHB_RF_CGM_IMTX_S9_AUTO_GATE_EN				0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_S9_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_S9_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_IMTX_S5_FRC_LSLP					0x400
#define MASK_AP_IPA_AHB_RF_IMTX_M9_FRC_LSLP					0x200
#define MASK_AP_IPA_AHB_RF_IMTX_M8_FRC_LSLP					0x100
#define MASK_AP_IPA_AHB_RF_IMTX_M7_FRC_LSLP					0x80
#define MASK_AP_IPA_AHB_RF_IMTX_M6_FRC_LSLP					0x40
#define MASK_AP_IPA_AHB_RF_IMTX_M5_FRC_LSLP					0x20
#define MASK_AP_IPA_AHB_RF_IMTX_M4_FRC_LSLP					0x10
#define MASK_AP_IPA_AHB_RF_IMTX_M3_FRC_LSLP					0x8
#define MASK_AP_IPA_AHB_RF_IMTX_M2_FRC_LSLP					0x4
#define MASK_AP_IPA_AHB_RF_IMTX_M1_FRC_LSLP					0x2
#define MASK_AP_IPA_AHB_RF_IMTX_M0_FRC_LSLP					0x1
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_S5_LPC_BYPASS					0x400
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M9_LPC_BYPASS					0x200
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M8_LPC_BYPASS					0x100
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M7_LPC_BYPASS					0x80
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M6_LPC_BYPASS					0x40
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M5_LPC_BYPASS					0x20
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M4_LPC_BYPASS					0x10
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M3_LPC_BYPASS					0x8
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M2_LPC_BYPASS					0x4
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M1_LPC_BYPASS					0x2
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M0_LPC_BYPASS					0x1
#define MASK_AP_IPA_AHB_RF_IMTX_S5_FRC_PUB_DSLP					0x400
#define MASK_AP_IPA_AHB_RF_IMTX_M9_FRC_PUB_DSLP					0x200
#define MASK_AP_IPA_AHB_RF_IMTX_M8_FRC_PUB_DSLP					0x100
#define MASK_AP_IPA_AHB_RF_IMTX_M7_FRC_PUB_DSLP					0x80
#define MASK_AP_IPA_AHB_RF_IMTX_M6_FRC_PUB_DSLP					0x40
#define MASK_AP_IPA_AHB_RF_IMTX_M5_FRC_PUB_DSLP					0x20
#define MASK_AP_IPA_AHB_RF_IMTX_M4_FRC_PUB_DSLP					0x10
#define MASK_AP_IPA_AHB_RF_IMTX_M3_FRC_PUB_DSLP					0x8
#define MASK_AP_IPA_AHB_RF_IMTX_M2_FRC_PUB_DSLP					0x4
#define MASK_AP_IPA_AHB_RF_IMTX_M1_FRC_PUB_DSLP					0x2
#define MASK_AP_IPA_AHB_RF_IMTX_M0_FRC_PUB_DSLP					0x1
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_S5_LPC_BYPASS				0x400
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M9_LPC_BYPASS				0x200
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M8_LPC_BYPASS				0x100
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M7_LPC_BYPASS				0x80
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M6_LPC_BYPASS				0x40
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M5_LPC_BYPASS				0x20
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M4_LPC_BYPASS				0x10
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M3_LPC_BYPASS				0x8
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M2_LPC_BYPASS				0x4
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M1_LPC_BYPASS				0x2
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M0_LPC_BYPASS				0x1
#define MASK_AP_IPA_AHB_RF_IMTX_M9_FRC_DOZE					0x200
#define MASK_AP_IPA_AHB_RF_IMTX_M8_FRC_DOZE					0x100
#define MASK_AP_IPA_AHB_RF_IMTX_M7_FRC_DOZE					0x80
#define MASK_AP_IPA_AHB_RF_IMTX_M6_FRC_DOZE					0x40
#define MASK_AP_IPA_AHB_RF_IMTX_M5_FRC_DOZE					0x20
#define MASK_AP_IPA_AHB_RF_IMTX_M4_FRC_DOZE					0x10
#define MASK_AP_IPA_AHB_RF_IMTX_M3_FRC_DOZE					0x8
#define MASK_AP_IPA_AHB_RF_IMTX_M2_FRC_DOZE					0x4
#define MASK_AP_IPA_AHB_RF_IMTX_M1_FRC_DOZE					0x2
#define MASK_AP_IPA_AHB_RF_IMTX_M0_FRC_DOZE					0x1
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_MAIN_LPC_BYPASS				0x100000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S9_LPC_BYPASS					0x80000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S8_LPC_BYPASS					0x40000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S7_LPC_BYPASS					0x20000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S6_LPC_BYPASS					0x10000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S5_LPC_BYPASS					0x8000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S4_LPC_BYPASS					0x4000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S3_LPC_BYPASS					0x2000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S2_LPC_BYPASS					0x1000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S1_LPC_BYPASS					0x800
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_S0_LPC_BYPASS					0x400
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M9_LPC_BYPASS					0x200
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M8_LPC_BYPASS					0x100
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M7_LPC_BYPASS					0x80
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M6_LPC_BYPASS					0x40
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M5_LPC_BYPASS					0x20
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M4_LPC_BYPASS					0x10
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M3_LPC_BYPASS					0x8
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M2_LPC_BYPASS					0x4
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M1_LPC_BYPASS					0x2
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M0_LPC_BYPASS					0x1
#define MASK_AP_IPA_AHB_RF_IMTX_AXI_FREQ_DFS_MODE					0x3000
#define MASK_AP_IPA_AHB_RF_IMTX_AXI_FREQ_DFS_SW					0xf00
#define MASK_AP_IPA_AHB_RF_IMTX_M9_AXI_FREQ_ALLOW					0xf0
#define MASK_AP_IPA_AHB_RF_IMTX_M8_AXI_FREQ_ALLOW					0xf
#define MASK_AP_IPA_AHB_RF_IMTX_M7_AXI_FREQ_ALLOW					0xf0000000
#define MASK_AP_IPA_AHB_RF_IMTX_M6_AXI_FREQ_ALLOW					0xf000000
#define MASK_AP_IPA_AHB_RF_IMTX_M5_AXI_FREQ_ALLOW					0xf00000
#define MASK_AP_IPA_AHB_RF_IMTX_M4_AXI_FREQ_ALLOW					0xf0000
#define MASK_AP_IPA_AHB_RF_IMTX_M3_AXI_FREQ_ALLOW					0xf000
#define MASK_AP_IPA_AHB_RF_IMTX_M2_AXI_FREQ_ALLOW					0xf00
#define MASK_AP_IPA_AHB_RF_IMTX_M1_AXI_FREQ_ALLOW					0xf0
#define MASK_AP_IPA_AHB_RF_IMTX_M0_AXI_FREQ_ALLOW					0xf
#define MASK_AP_IPA_AHB_RF_IMTX_AXI_FREQ_LSLP_DFS_MODE				0x3000
#define MASK_AP_IPA_AHB_RF_IMTX_AXI_FREQ_LSLP_DFS_SW				0xf00
#define MASK_AP_IPA_AHB_RF_IMTX_M9_AXI_FREQ_LSLP_ALLOW				0xf0
#define MASK_AP_IPA_AHB_RF_IMTX_M8_AXI_FREQ_LSLP_ALLOW				0xf
#define MASK_AP_IPA_AHB_RF_IMTX_M7_AXI_FREQ_LSLP_ALLOW				0xf0000000
#define MASK_AP_IPA_AHB_RF_IMTX_M6_AXI_FREQ_LSLP_ALLOW				0xf000000
#define MASK_AP_IPA_AHB_RF_IMTX_M5_AXI_FREQ_LSLP_ALLOW				0xf00000
#define MASK_AP_IPA_AHB_RF_IMTX_M4_AXI_FREQ_LSLP_ALLOW				0xf0000
#define MASK_AP_IPA_AHB_RF_IMTX_M3_AXI_FREQ_LSLP_ALLOW				0xf000
#define MASK_AP_IPA_AHB_RF_IMTX_M2_AXI_FREQ_LSLP_ALLOW				0xf00
#define MASK_AP_IPA_AHB_RF_IMTX_M1_AXI_FREQ_LSLP_ALLOW				0xf0
#define MASK_AP_IPA_AHB_RF_IMTX_M0_AXI_FREQ_LSLP_ALLOW				0xf
#define MASK_AP_IPA_AHB_RF_ARQOS_PCIE_MSTR						0xf0000000
#define MASK_AP_IPA_AHB_RF_AWQOS_PCIE_MSTR						0xf000000
#define MASK_AP_IPA_AHB_RF_ARQOS_TFT						0xf00000
#define MASK_AP_IPA_AHB_RF_AWQOS_TFT						0xf0000
#define MASK_AP_IPA_AHB_RF_ARQOS_IPA						0xf000
#define MASK_AP_IPA_AHB_RF_AWQOS_IPA						0xf00
#define MASK_AP_IPA_AHB_RF_ARQOS_USB_PAM						0xf0
#define MASK_AP_IPA_AHB_RF_AWQOS_USB_PAM						0xf
#define MASK_AP_IPA_AHB_RF_ARQOS_USB1						0xf000
#define MASK_AP_IPA_AHB_RF_AWQOS_USB1						0xf00
#define MASK_AP_IPA_AHB_RF_ARQOS_SDIO_SLV						0xf0
#define MASK_AP_IPA_AHB_RF_AWQOS_SDIO_SLV						0xf
#define MASK_AP_IPA_AHB_RF_ARURGENCY_USB1						0xc00000
#define MASK_AP_IPA_AHB_RF_AWURGENCY_USB1						0x300000
#define MASK_AP_IPA_AHB_RF_ARURGENCY_SDIO_SLV					0xc0000
#define MASK_AP_IPA_AHB_RF_AWURGENCY_SDIO_SLV					0x30000
#define MASK_AP_IPA_AHB_RF_ARURGENCY_PCIE						0xc000
#define MASK_AP_IPA_AHB_RF_AWURGENCY_PCIE						0x3000
#define MASK_AP_IPA_AHB_RF_ARURGENCY_TFT						0xc00
#define MASK_AP_IPA_AHB_RF_AWURGENCY_TFT						0x300
#define MASK_AP_IPA_AHB_RF_ARURGENCY_IPA						0xc0
#define MASK_AP_IPA_AHB_RF_AWURGENCY_IPA						0x30
#define MASK_AP_IPA_AHB_RF_ARURGENCY_USB_PAM					0xc
#define MASK_AP_IPA_AHB_RF_AWURGENCY_USB_PAM					0x3
#define MASK_AP_IPA_AHB_RF_ARUSER_PCIE_MSTR					0xff000000
#define MASK_AP_IPA_AHB_RF_AWUSER_PCIE_MSTR					0xff0000
#define MASK_AP_IPA_AHB_RF_ARUSER_SDIO_SLV						0xff00
#define MASK_AP_IPA_AHB_RF_AWUSER_SDIO_SLV						0xff
#define MASK_AP_IPA_AHB_RF_ARUSER_USB_PAM						0xff000000
#define MASK_AP_IPA_AHB_RF_AWUSER_USB_PAM						0xff0000
#define MASK_AP_IPA_AHB_RF_ARUSER_USB1						0xff00
#define MASK_AP_IPA_AHB_RF_AWUSER_USB1						0xff
#define MASK_AP_IPA_AHB_RF_ARUSER_IPA						0xff000000
#define MASK_AP_IPA_AHB_RF_AWUSER_IPA						0xff0000
#define MASK_AP_IPA_AHB_RF_ARUSER_TFT						0xff00
#define MASK_AP_IPA_AHB_RF_AWUSER_TFT						0xff
#define MASK_AP_IPA_AHB_RF_IMTX_BUSMON_ENABLE					0x1
#define MASK_AP_IPA_AHB_RF_IPA_DFS_VOTE_LSLP_EB					0x4
#define MASK_AP_IPA_AHB_RF_IPA_DFS_VOTE_EB						0x2
#define MASK_AP_IPA_AHB_RF_IPA_DEBUG_EB						0x1
#define MASK_AP_IPA_AHB_RF_ARUSER_PAM_WIFI						0xff000000
#define MASK_AP_IPA_AHB_RF_AWUSER_PAM_WIFI						0xff0000
#define MASK_AP_IPA_AHB_RF_ARQOS_PAM_WIFI						0x3c00
#define MASK_AP_IPA_AHB_RF_AWQOS_PAM_WIFI						0x3c0
#define MASK_AP_IPA_AHB_RF_ARURGENCY_PAM_WIFI					0x30
#define MASK_AP_IPA_AHB_RF_AWURGENCY_PAM_WIFI					0xc
#define MASK_AP_IPA_AHB_RF_PAM_WIFI_SOFT_RST					0x2
#define MASK_AP_IPA_AHB_RF_PAM_WIFI_EB						0x1
#define MASK_AP_IPA_AHB_RF_IMTX_M10_AXI_FREQ_LSLP_ALLOW				0x78000000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_AXI_FREQ_ALLOW					0x7800000
#define MASK_AP_IPA_AHB_RF_DOZE_IMTX_M10_LPC_BYPASS				0x400000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_FRC_DOZE					0x200000
#define MASK_AP_IPA_AHB_RF_PUB_DSLP_IMTX_M10_LPC_BYPASS				0x100000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_FRC_PUB_DSLP					0x80000
#define MASK_AP_IPA_AHB_RF_LSLP_IMTX_M10_LPC_BYPASS				0x40000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_FRC_LSLP					0x20000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_LP_EB						0x10000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_LP_NUM						0xffff
#define MASK_AP_IPA_AHB_RF_CGM_BUSY_LPC_APB_MASK					0x80
#define MASK_AP_IPA_AHB_RF_CGM_BUSY_LPC_SAXI_MASK					0x40
#define MASK_AP_IPA_AHB_RF_PCIE_L12_AXI_CGM_MASK					0x20
#define MASK_AP_IPA_AHB_RF_PCIE_L2_AXI_CGM_MASK					0x10
#define MASK_AP_IPA_AHB_RF_PERST_AUX_CGM_MASK					0x8
#define MASK_AP_IPA_AHB_RF_PERST_SLP_MASK						0x4
#define MASK_AP_IPA_AHB_RF_PCIE_L12_SLP_ENA					0x2
#define MASK_AP_IPA_AHB_RF_PCIE_L2_SLP_ENA						0x1
#define MASK_AP_IPA_AHB_RF_IMTX_M3_PU_NUM						0xff000000
#define MASK_AP_IPA_AHB_RF_IMTX_M2_PU_NUM						0xff0000
#define MASK_AP_IPA_AHB_RF_IMTX_M1_PU_NUM						0xff00
#define MASK_AP_IPA_AHB_RF_IMTX_M0_PU_NUM						0xff
#define MASK_AP_IPA_AHB_RF_IMTX_M7_PU_NUM						0xff000000
#define MASK_AP_IPA_AHB_RF_IMTX_M6_PU_NUM						0xff0000
#define MASK_AP_IPA_AHB_RF_IMTX_M5_PU_NUM						0xff00
#define MASK_AP_IPA_AHB_RF_IMTX_M4_PU_NUM						0xff
#define MASK_AP_IPA_AHB_RF_IMTX_MAIN_PU_NUM					0xff000000
#define MASK_AP_IPA_AHB_RF_IMTX_M10_PU_NUM						0xff0000
#define MASK_AP_IPA_AHB_RF_IMTX_M9_PU_NUM						0xff00
#define MASK_AP_IPA_AHB_RF_IMTX_M8_PU_NUM						0xff
#define MASK_AP_IPA_AHB_RF_IMTX_S3_PU_NUM						0xff000000
#define MASK_AP_IPA_AHB_RF_IMTX_S2_PU_NUM						0xff0000
#define MASK_AP_IPA_AHB_RF_IMTX_S1_PU_NUM						0xff00
#define MASK_AP_IPA_AHB_RF_IMTX_S0_PU_NUM						0xff
#define MASK_AP_IPA_AHB_RF_IMTX_S7_PU_NUM						0xff000000
#define MASK_AP_IPA_AHB_RF_IMTX_S6_PU_NUM						0xff0000
#define MASK_AP_IPA_AHB_RF_IMTX_S5_PU_NUM						0xff00
#define MASK_AP_IPA_AHB_RF_IMTX_S4_PU_NUM						0xff
#define MASK_AP_IPA_AHB_RF_IMTX_S9_PU_NUM						0xff00
#define MASK_AP_IPA_AHB_RF_IMTX_S8_PU_NUM						0xff
#define MASK_AP_IPA_AHB_RF_PAM_WIFI_PCLK_AUTO_SLOW_EN				0x10
#define MASK_AP_IPA_AHB_RF_PAM_WIFI_PCLK_AUTO_SLOW_SEL				0xe
#define MASK_AP_IPA_AHB_RF_PAM_WIFI_PCLK_AUTO_GATE_EB				0x1
#define MASK_AP_IPA_AHB_RF_PCIE_SNPS_AXI_AUTO_GATE					0x1000
#define MASK_AP_IPA_AHB_RF_PCIE_DEVICE_TYPE					0xf00
#define MASK_AP_IPA_AHB_RF_AP_CTL_PCIE						0xff
#define MASK_AP_IPA_AHB_RF_NR_ACCESS_AP_EN						0x8
#define MASK_AP_IPA_AHB_RF_PS_ACCESS_AP_EN						0x4
#define MASK_AP_IPA_AHB_RF_NR_CP_ACCESS_EN						0x2
#define MASK_AP_IPA_AHB_RF_PS_CP_ACCESS_EN						0x1
#define MASK_AP_IPA_AHB_RF_CGM_CLK_CP1_AXI_AUTO_GATE_EN				0x2
#define MASK_AP_IPA_AHB_RF_CGM_CLK_CP0_AXI_AUTO_GATE_EN				0x1
#define MASK_AP_IPA_AHB_RF_USE_SDIO_SLV_BUSY					0x1
#define MASK_AP_IPA_AHB_RF_SDSLV_DEBUG_EB						0x1
#define MASK_AP_IPA_AHB_RF_PCIE_SW_MSI_INT						0xffffffff
#define MASK_AP_IPA_AHB_RF_RESERVE0						0xffffffff
#define MASK_AP_IPA_AHB_RF_RESERVE1						0xffffffff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTHSCLK		0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSCLK			0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXITCLK		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_STOPSTATECLK		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ULPSACTIVENOTCLK		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_0		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_0		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXLPDTESC_0		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_0		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_0		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXTRIGGERESC_0		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXVALIDESC_0		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREADYESC_0		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_1		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_1		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXLPDTESC_1		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_1		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_1		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXTRIGGERESC_1		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXVALIDESC_1		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREADYESC_1		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_2		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_2		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXLPDTESC_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXTRIGGERESC_2		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXVALIDESC_2		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREADYESC_2		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_3		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_3		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXLPDTESC_3		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_3		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_3		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXTRIGGERESC_3		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXVALIDESC_3		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREADYESC_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXDATAESC_0		0xff000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXDATAESC_1		0xff0000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXDATAESC_2		0xff00
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXDATAESC_3		0xff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXCLKESC_0		0x8000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXCLKESC_1		0x4000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXCLKESC_2		0x2000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXCLKESC_3		0x1000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXLPDTESC_0		0x800000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXTRIGGERESC_0		0x780000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXVALIDESC_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXLPDTESC_1		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXTRIGGERESC_1		0x1e000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXVALIDESC_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXLPDTESC_2		0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXTRIGGERESC_2		0x780
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXVALIDESC_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXLPDTESC_3		0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXTRIGGERESC_3		0x1e
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RXVALIDESC_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRESC_0			0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRSYNCESC_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTROL_0		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP0_0	0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP1_0	0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRESC_1			0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRSYNCESC_1		0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTROL_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP0_1	0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP1_1	0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRESC_2			0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRSYNCESC_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTROL_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP0_2	0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP1_2	0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRESC_3			0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRSYNCESC_3		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTROL_3		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP0_3	0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ERRCONTENTIONLP1_3	0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_PS_PD_S			0x200000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_PS_PD_L			0x100000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_SHUTDOWNZ			0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RSTZ			0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_0			0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_1			0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_2			0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_3			0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLECLK			0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCEPLL			0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_PLLLOCK			0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_BISTON			0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_BISTDONE			0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_IF_SEL			0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TRIMBG			0xf0
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TX_RCTL			0xf
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RESERVED			0xff00
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_RESERVEDO			0xff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTDIN			0x7f800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTDOUT			0x7f8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTEN			0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTCLK			0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTCLR			0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNREQUEST_0		0x400000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_DIRECTION_0		0x200000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNDISABLE_0		0x100000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCERXMODE_0		0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCETXSTOPMODE_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_STOPSTATEDATA_0		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNREQUEST_1		0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNDISABLE_1		0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCERXMODE_1		0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCETXSTOPMODE_1		0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_STOPSTATEDATA_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNREQUEST_2		0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_DIRECTION_2		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNDISABLE_2		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCERXMODE_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCETXSTOPMODE_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_STOPSTATEDATA_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNREQUEST_3		0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_DIRECTION_3		0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNDISABLE_3		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCERXMODE_3		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCETXSTOPMODE_3		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_STOPSTATEDATA_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_ANALOG_DSI_DUMY_IN		0xffff0000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_ANALOG_DSI_DUMY_OUT		0xffff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_ISO_SW_EN			0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_0		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_1		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_2		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_3		0x1
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTHSCLK	0x80000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSCLK		0x40000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXITCLK	0x20000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_0	0x10000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_0	0x8000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXLPDTESC_0	0x4000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_0	0x2000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_0	0x1000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXTRIGGERESC_0	0x800000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXVALIDESC_0	0x400000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_1	0x200000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_1	0x100000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_1	0x80000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_1	0x40000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_2	0x20000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_2	0x10000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_2	0x8000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_2	0x4000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTDATAHS_3	0x2000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXREQUESTESC_3	0x1000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSESC_3	0x800
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXULPSEXIT_3	0x400
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXDATAESC_0	0x200
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_PS_PD_S		0x100
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_PS_PD_L		0x80
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_SHUTDOWNZ		0x40
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_RSTZ		0x20
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_0		0x10
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_1		0x8
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_2		0x4
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLE_3		0x2
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_ENABLECLK		0x1
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_FORCEPLL		0x400
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTDIN		0x200
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTEN		0x100
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTCLK		0x80
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TESTCLR		0x40
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TURNREQUEST_0	0x20
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_ISO_SW_EN		0x10
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_0	0x8
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_1	0x4
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_2	0x2
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_0_DSI_TXSKEWCALHS_3	0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTHSCLK		0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSCLK			0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXITCLK		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_STOPSTATECLK		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ULPSACTIVENOTCLK		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_0		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_0		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXLPDTESC_0		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_0		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_0		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXTRIGGERESC_0		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXVALIDESC_0		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREADYESC_0		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_1		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_1		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXLPDTESC_1		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_1		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_1		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXTRIGGERESC_1		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXVALIDESC_1		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREADYESC_1		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_2		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_2		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXLPDTESC_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXTRIGGERESC_2		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXVALIDESC_2		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREADYESC_2		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_3		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_3		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXLPDTESC_3		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_3		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_3		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXTRIGGERESC_3		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXVALIDESC_3		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREADYESC_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXDATAESC_0		0xff000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXDATAESC_1		0xff0000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXDATAESC_2		0xff00
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXDATAESC_3		0xff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXCLKESC_0		0x8000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXCLKESC_1		0x4000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXCLKESC_2		0x2000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXCLKESC_3		0x1000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXLPDTESC_0		0x800000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXTRIGGERESC_0		0x780000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXVALIDESC_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXLPDTESC_1		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXTRIGGERESC_1		0x1e000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXVALIDESC_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXLPDTESC_2		0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXTRIGGERESC_2		0x780
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXVALIDESC_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXLPDTESC_3		0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXTRIGGERESC_3		0x1e
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RXVALIDESC_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRESC_0			0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRSYNCESC_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTROL_0		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP0_0	0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP1_0	0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRESC_1			0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRSYNCESC_1		0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTROL_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP0_1	0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP1_1	0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRESC_2			0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRSYNCESC_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTROL_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP0_2	0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP1_2	0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRESC_3			0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRSYNCESC_3		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTROL_3		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP0_3	0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ERRCONTENTIONLP1_3	0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_PS_PD_S			0x200000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_PS_PD_L			0x100000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_SHUTDOWNZ			0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RSTZ			0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_0			0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_1			0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_2			0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_3			0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLECLK			0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCEPLL			0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_PLLLOCK			0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_BISTON			0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_BISTDONE			0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_IF_SEL			0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TRIMBG			0xf0
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TX_RCTL			0xf
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RESERVED			0xff00
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_RESERVEDO			0xff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTDIN			0x7f800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTDOUT			0x7f8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTEN			0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTCLK			0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTCLR			0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNREQUEST_0		0x400000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_DIRECTION_0		0x200000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNDISABLE_0		0x100000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCERXMODE_0		0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCETXSTOPMODE_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_STOPSTATEDATA_0		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNREQUEST_1		0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNDISABLE_1		0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCERXMODE_1		0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCETXSTOPMODE_1		0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_STOPSTATEDATA_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNREQUEST_2		0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_DIRECTION_2		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNDISABLE_2		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCERXMODE_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCETXSTOPMODE_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_STOPSTATEDATA_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNREQUEST_3		0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_DIRECTION_3		0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNDISABLE_3		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCERXMODE_3		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCETXSTOPMODE_3		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_STOPSTATEDATA_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_ANALOG_DSI_DUMY_IN		0xffff0000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_ANALOG_DSI_DUMY_OUT		0xffff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_ISO_SW_EN			0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_0		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_1		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_2		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_3		0x1
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTHSCLK	0x80000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSCLK		0x40000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXITCLK	0x20000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_0	0x10000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_0	0x8000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXLPDTESC_0	0x4000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_0	0x2000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_0	0x1000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXTRIGGERESC_0	0x800000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXVALIDESC_0	0x400000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_1	0x200000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_1	0x100000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_1	0x80000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_1	0x40000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_2	0x20000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_2	0x10000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_2	0x8000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_2	0x4000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTDATAHS_3	0x2000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXREQUESTESC_3	0x1000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSESC_3	0x800
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXULPSEXIT_3	0x400
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXDATAESC_0	0x200
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_PS_PD_S		0x100
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_PS_PD_L		0x80
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_SHUTDOWNZ		0x40
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_RSTZ		0x20
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_0		0x10
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_1		0x8
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_2		0x4
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLE_3		0x2
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_ENABLECLK		0x1
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_FORCEPLL		0x400
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTDIN		0x200
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTEN		0x100
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTCLK		0x80
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TESTCLR		0x40
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TURNREQUEST_0	0x20
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_ISO_SW_EN		0x10
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_0	0x8
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_1	0x4
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_2	0x2
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_1_DSI_TXSKEWCALHS_3	0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTHSCLK		0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSCLK			0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXITCLK		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_STOPSTATECLK		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ULPSACTIVENOTCLK		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_0		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_0		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXLPDTESC_0		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_0		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_0		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXTRIGGERESC_0		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXVALIDESC_0		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREADYESC_0		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_1		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_1		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXLPDTESC_1		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_1		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_1		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXTRIGGERESC_1		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXVALIDESC_1		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREADYESC_1		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_2		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_2		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXLPDTESC_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXTRIGGERESC_2		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXVALIDESC_2		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREADYESC_2		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_3		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_3		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXLPDTESC_3		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_3		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_3		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXTRIGGERESC_3		0x3c
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXVALIDESC_3		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREADYESC_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXDATAESC_0		0xff000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXDATAESC_1		0xff0000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXDATAESC_2		0xff00
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXDATAESC_3		0xff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXCLKESC_0		0x8000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXCLKESC_1		0x4000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXCLKESC_2		0x2000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXCLKESC_3		0x1000000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXLPDTESC_0		0x800000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXTRIGGERESC_0		0x780000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXVALIDESC_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXLPDTESC_1		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXTRIGGERESC_1		0x1e000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXVALIDESC_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXLPDTESC_2		0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXTRIGGERESC_2		0x780
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXVALIDESC_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXLPDTESC_3		0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXTRIGGERESC_3		0x1e
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RXVALIDESC_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRESC_0			0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRSYNCESC_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTROL_0		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP0_0	0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP1_0	0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRESC_1			0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRSYNCESC_1		0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTROL_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP0_1	0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP1_1	0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRESC_2			0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRSYNCESC_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTROL_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP0_2	0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP1_2	0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRESC_3			0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRSYNCESC_3		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTROL_3		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP0_3	0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ERRCONTENTIONLP1_3	0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_PS_PD_S			0x200000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_PS_PD_L			0x100000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_SHUTDOWNZ			0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RSTZ			0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_0			0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_1			0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_2			0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_3			0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLECLK			0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCEPLL			0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_PLLLOCK			0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_BISTON			0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_BISTDONE			0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_IF_SEL			0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TRIMBG			0xf0
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TX_RCTL			0xf
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RESERVED			0xff00
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_RESERVEDO			0xff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTDIN			0x7f800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTDOUT			0x7f8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTEN			0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTCLK			0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTCLR			0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNREQUEST_0		0x400000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_DIRECTION_0		0x200000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNDISABLE_0		0x100000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCERXMODE_0		0x80000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCETXSTOPMODE_0		0x40000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_STOPSTATEDATA_0		0x20000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNREQUEST_1		0x10000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNDISABLE_1		0x8000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCERXMODE_1		0x4000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCETXSTOPMODE_1		0x2000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_STOPSTATEDATA_1		0x1000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNREQUEST_2		0x800
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_DIRECTION_2		0x400
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNDISABLE_2		0x200
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCERXMODE_2		0x100
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCETXSTOPMODE_2		0x80
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_STOPSTATEDATA_2		0x40
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNREQUEST_3		0x20
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_DIRECTION_3		0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNDISABLE_3		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCERXMODE_3		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCETXSTOPMODE_3		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_STOPSTATEDATA_3		0x1
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_ANALOG_DSI_DUMY_IN		0xffff0000
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_ANALOG_DSI_DUMY_OUT		0xffff
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_ISO_SW_EN			0x10
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_0		0x8
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_1		0x4
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_2		0x2
#define MASK_ANLG_PHY_G11_RF_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_3		0x1
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTHSCLK	0x80000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSCLK		0x40000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXITCLK	0x20000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_0	0x10000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_0	0x8000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXLPDTESC_0	0x4000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_0	0x2000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_0	0x1000000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXTRIGGERESC_0	0x800000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXVALIDESC_0	0x400000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_1	0x200000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_1	0x100000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_1	0x80000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_1	0x40000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_2	0x20000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_2	0x10000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_2	0x8000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_2	0x4000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTDATAHS_3	0x2000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXREQUESTESC_3	0x1000
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSESC_3	0x800
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXULPSEXIT_3	0x400
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXDATAESC_0	0x200
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_PS_PD_S		0x100
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_PS_PD_L		0x80
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_SHUTDOWNZ		0x40
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_RSTZ		0x20
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_0		0x10
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_1		0x8
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_2		0x4
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLE_3		0x2
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_ENABLECLK		0x1
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_FORCEPLL		0x400
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTDIN		0x200
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTEN		0x100
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTCLK		0x80
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TESTCLR		0x40
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TURNREQUEST_0	0x20
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_ISO_SW_EN		0x10
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_0	0x8
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_1	0x4
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_2	0x2
#define MASK_ANLG_PHY_G11_RF_DBG_SEL_ANALOG_MIPI_DSI_4LANE_2_DSI_TXSKEWCALHS_3	0x1
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG0_CFG_PHY_RESET				0x2
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG0_CFG_PCS_RESET				0x1
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG1_CFG_TOUT_3_SEL				0xf0000000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG1_CFG_TOUT_2_SEL				0xf000000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG1_CFG_TOUT_1_SEL				0xf00000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG1_CFG_TOUT_0_SEL				0xf0000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG1_CFG_PIPE_TXINTF_SEL			0x1
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_TX_LFPS_EN			0x8000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_TX_LFPS_EN_OVRD			0x4000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_TXDETECTRX_EN			0x2000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_TXDETECTRX_EN_OVRD		0x1000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_OFFK_EN				0x800
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_OFFK_EN_OVRD			0x400
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_SQ				0x200
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_SQ_OVRD			0x100
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_RX				0x80
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_RX_OVRD			0x40
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_TX_DATA_EN			0x20
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_TX_DATA_EN_OVRD			0x10
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_PLL				0x8
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_PLL_OVRD			0x4
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_IVREF				0x2
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG2_CFG_PM_PU_IVREF_OVRD			0x1
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXDEEMPH			0xc0000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXDEEMPH_OVRD			0x20000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_POWERDOWN			0x18000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_POWERDOWN_OVRD			0x4000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_RXEQTRAINING			0x2000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_RXEQTRAINING_OVRD		0x1000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXONESZEROS			0x800
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXONESZEROS_OVRD		0x400
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXDETECTRX			0x200
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXDETECTRX_OVRD		0x100
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXELECIDLE			0x80
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXELECIDLE_OVRD		0x40
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_RXPOLARITY			0x20
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_RXPOLARITY_OVRD		0x10
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_EBUF_MODE			0x8
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_EBUF_MODE_OVRD			0x4
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXSWING			0x2
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG3_CFG_PIPE_TXSWING_OVRD			0x1
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG4_CFG_PM_UPDATE				0x20
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG4_CFG_PM_STATE				0x1f
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG5_CFG_TIME_TDR_CM				0xc0
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG5_CFG_TIME_TDR_SAMPLE			0x30
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG5_CFG_TIME_CM				0xc
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG5_CFG_TIME_PLL_LOCK			0x3
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_UNLOCK_BC			0xf0000000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_UNLOCK_BS			0xf000000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_UNLOCK_GC			0xf00000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_UNLOCK_GS			0xf0000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_LOCK_BC				0xf000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_LOCK_BS				0xf00
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_LOCK_GC				0xf0
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG6_CFG_SAL_LOCK_GS				0xf
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_CDR_ACTIVE_EN			0x8000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_RX_INIT_RATIO			0x7000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_NUM_ONESZEROS			0xf00
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_RX_LFPS_NUM_CNT			0xf8
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_USE_SKP_LOCK			0x4
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_IGNORE_PHY_RDY			0x2
#define MASK_ANALOG_USB30_CFGA_RF_DIG_CFG7_CFG_ALWAYS_ALIGN			0x1
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_ADD_ERR			0x2000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_PRBS_INV			0x800
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_PRBS_MODE			0x7f0
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_START_RX			0x8
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_START_TX			0x4
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_SELF_TEST_MODE			0x2
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG0_CFG_TEST_LOOPBACK_MODE			0x1
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG1_CFG_TEST_PRBS_SEED			0x7fffffff
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG2_CFG_TEST_PATTERN0			0xffffffff
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG3_CFG_TEST_PATTERN1			0xffffffff
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG4_CFG_TEST_PATTERN2			0xffffffff
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_DBG_BIST_OK				0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_DBG_BIST_DONE				0x40000000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_DBG_BIST_STATUS				0x1f000000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_BIST_STATUS_MASK			0x1f0000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_POWERDOWN				0xc000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_CP_CTRL				0x3e00
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_FORCED_LTSSM			0x1e0
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_FORCE_EN				0x10
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_PLL_BIST_EN				0x4
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_BIST_EN				0x2
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG5_CFG_COMP_EN				0x1
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG6_CFG_PLL_BIST_EXP_CNT			0xffff0000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG6_CFG_PLL_BIST_DELTA_CNT			0xf000
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG6_CFG_PLL_BIST_REF_CNT			0xfff
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG7_CFG_TRIG_SOFT				0x100
#define MASK_ANALOG_USB30_CFGA_RF_TST_CFG7_CFG_TRIG_PM_STATE			0x1f
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS0_DBG_TEST_PATTERN_LOCK			0x10000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS0_DBG_TEST_ERR_CNT			0xffff
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS1_DBG_PLL_BIST_OK				0x20000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS1_DBG_PLL_BIST_DONE			0x10000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS1_DBG_PLL_BIST_CNT			0xffff
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS2_DBG_BERT_STATUS				0x3ff00000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS2_DBG_EBUF_STATUS				0xf0000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS2_DBG_SAL_STATUS				0xf000
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS2_DBG_TDR_STATE				0xf00
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS2_DBG_PWRON_STATE				0x70
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS2_DBG_TST_LTSSM				0xf
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS3_PM_TDR_PRESENT				0x20
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS3_PM_TDR_VALID				0x10
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS3_PM_RX_LOS				0x8
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS3_PM_RX_LOCK				0x4
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS3_PM_PLL_LOCK				0x2
#define MASK_ANALOG_USB30_CFGA_RF_DIG_STS3_PM_OFFK_DONE				0x1
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_IVREF_EN			0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_IVREF_EN			0x40000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TX_BIAS_EN			0x20000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TX_BIAS_EN			0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TX_IDLE			0x8000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TX_IDLE			0x4000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_RX_LOS				0x2000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_RX_LOS			0x1000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_BEACON_EN			0x800000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_BEACON_EN			0x400000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_BEACON_IN			0x200000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_BEACON_IN			0x100000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_MPLL_EN			0x80000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_MPLL_EN			0x40000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_PLL_OEN			0x20000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_PLL_OEN			0x10000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_PLL_PRE_LOCK			0x8000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_PLL_PRE_LOCK			0x4000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_RX_LOS_EN			0x2000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_RX_LOS_EN			0x1000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TDR_CIR_EN			0x800
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TDR_CIR_EN			0x400
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TDR_EN				0x200
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TDR_EN			0x100
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TDR_PRESENT			0x80
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TDR_PRESENT			0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TX_CM_EN			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TX_CM_EN			0x10
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_TX_DATA_EN			0x8
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_TX_DATA_EN			0x4
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_TEST_SW_SEL				0x2
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG0_CFG_FORCE_SW_SEL			0x1
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_TAP0_HOLD			0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_TAP0_HOLD			0x40000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_TAP0_ADAPT_EN			0x20000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_TAP0_ADAPT_EN			0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_TAP1_HOLD			0x8000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_TAP1_HOLD			0x4000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_TAP1_ADAPT_EN			0x2000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_TAP1_ADAPT_EN			0x1000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_DFE_ADAPT_EN			0x800000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_DFE_ADAPT_EN			0x400000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_POWERPRESENT			0x200000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_POWERPRESENT			0x100000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_RX_LDO_STABLE			0x80000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_RX_LDO_STABLE			0x40000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_RX_LDO_EN			0x20000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_RX_LDO_EN			0x10000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_OFFK_RSTN			0x8000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_OFFK_RSTN			0x4000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_OFFK_EN			0x2000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_OFFK_EN			0x1000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_CDR_ACTIVE_N			0x800
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_CDR_ACTIVE_N			0x400
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_RX_DATA_EN			0x200
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_RX_DATA_EN			0x100
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_OFFK_FINISH			0x80
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_OFFK_FINISH			0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_TX_SW_EN			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_TX_SW_EN			0x10
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_TX_LDO_EN			0x8
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_TX_LDO_EN			0x4
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_TEST_RXTERM_EN			0x2
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG1_CFG_FORCE_RXTERM_EN			0x1
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TEST_DEEMPH_HALFX2			0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_DEEMPH_HALFX2			0x40000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TEST_DEEMPH_HALFX1			0x20000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_DEEMPH_HALFX1			0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TEST_HALF_CELLX2_EN			0x8000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_HALF_CELLX2_EN		0x4000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TEST_HALF_CELLX1_EN			0x2000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_HALF_CELLX1_EN		0x1000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_DEEMPHX2			0x800000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TEST_DEEMPHX2			0x700000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_DEEMPHX1			0x80000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TEST_DEEMPHX1			0x70000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_TRIM_BG			0x8000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_TRIM_TXRCTL			0x4000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_FORCE_TRIM_RXRCTL			0x2000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TRIM_TXRCTL				0x1f00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TRIM_BG				0xf0
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG2_CFG_TRIM_RXRCTL				0xf
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_TEST_PLL_LATCHEN			0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_FORCE_PLL_LATCHEN			0x40000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_TEST_TXSWING			0x20000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_FORCE_TXSWING			0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_FORCE_TXRCTLX2			0x8000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_TEST_TXRCTLX2			0x7000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_FORCE_TXRCTLX1			0x800000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_TEST_TXRCTLX1			0x700000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_PI_DIV2				0x20000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_HIGHGAIN				0x10000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_BIAS_BOOST				0xf00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_PEAK2G5				0x80
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_CONSTGM_EN				0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_LDO_PI_REF				0x30
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_LDO_RX_REF				0xc
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG3_CFG_SQ_CTRL				0x3
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_FORCE_LEQ_ADAPT_EN			0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_HOLD				0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_ADAPT_EN			0x8000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_MAX				0x7c00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_MIN				0x3e0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_INIT				0x1f000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_MANUAL				0x800
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_LOOP_GAIN			0x700
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_RATE				0xf0
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_RATE_EN				0x8
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_SLICE_EN			0x4
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_ADAPT_INV			0x2
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG4_CFG_LEQ_ADAPT_RSTN			0x1
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_LEQ_OFFSET_IN			0xf000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_READ_LEQ_LIMIT			0x100000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_OFFK_RATE				0xf0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_OFFK_RATE_EN			0x8000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_STABLE_MODE_SLICER			0x7000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_OFFK_INV_SLICER			0x800
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_STABLE_MODE_AFE			0x700
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_OFFK_INV_AFE			0x80
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_OFFK_MODE				0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG5_CFG_OFFK_BIAS_HALF			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG6_CFG_OFFK_FINISH				0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG6_CFG_READ_COEF_OUT			0xff00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG6_CFG_OFFK_MANUAL_SLICER			0x20000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG6_CFG_OFFK_MANUAL_AFE			0x10000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG6_CFG_READ_COEF_SEL			0xff00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG6_CFG_OFFK_INIT_AFE			0xff
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_LOOP_GAIN			0x70000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_MIN				0x7c00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_MAX				0x3e0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_INIT				0x1f000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_RATE				0xf00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_READ_TAP1_LIMIT			0x80
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_MANUAL				0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_RATE_EN			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_TRANS				0x10
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_SLICE_EN			0x8
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_TAP1_ADAPT_INV			0x4
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_DFE_ADAPT_RSTN			0x2
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG7_CFG_DFE_RF_ANA_EN			0x1
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_LOOP_GAIN			0x70000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_MIN				0x7c00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_MAX				0x3e0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_INIT				0x1f000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_RATE				0xf00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_MANUAL				0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_RATE_EN			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_NOTRANS			0x10
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_SLICE_EN			0x8
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_ADAPT_INV			0x4
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG8_CFG_TAP0_RUNLENGTH			0x3
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG9_CFG_VTH_MAX				0x3f00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG9_CFG_VTH_SIGN_TOGGLE_EN			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG9_CFG_VTH_SIGN				0x10
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG9_CFG_VTH_SIGN_TOGGLE_RATE		0xf
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_MIXER_RST				0x20000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_FREQOSIN				0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_FREQ_INTEG_IN			0xff00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_FIRST_ORDER_N			0x80000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_FPATH_OFF				0x40000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_PPM_CTRL				0x30000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_SAT_CTRL				0x8000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_FGAINC				0x7000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_CDR_MODE_CTRL			0x800
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_PGAINC				0x700
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_PI_MANUAL_EN			0x80
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG10_CFG_PI_MANUAL				0x7f
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_STEP3_CFG				0xff000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_STEP2_CFG				0xff0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_STEP1_CFG				0xff00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_CDR_SCENARIO			0xc0
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_CDR_JUMP_STEP			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_CDR_JUMP_INIT			0x10
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_CDR_JUMP_VTH			0xc
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_CDR_JUMP_CASE			0x2
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG11_CFG_CDR_MONITOR_BYPASS			0x1
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG12_CFG_STEP2_CYCLE			0xffff0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG12_CFG_STEP1_CYCLE			0xffff
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_LDO_PLL_REF			0xc0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_TX_LDO_IDC				0x30000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_DRV_SW				0xc000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_ICOMP_MODE				0x1000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_ICOMP_PD				0x800
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_LDO_0P9_REF_SEL			0x400
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_LDO_0P9_REF			0x300
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_TXLDOCK_FILTER			0xc0
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_CK_PATH_CTRL			0x20
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_TX_EN				0x8
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_VCM_HOLD_CTRL			0x4
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG13_CFG_TDR_REF				0x3
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG14_CFG_KDELTA				0xfff00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG14_CFG_KSTEP				0x7ffff
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_SDM_EN				0x80000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_MOD_EN				0x40000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_HOP_EN				0x20000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_HOP_TRIG				0x10000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_VCOBAND				0x8000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_DIVN				0x7000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_NINT				0xff0000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_NS					0xff00
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_FDK_S				0x40
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_PRESEL				0x30
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_CP					0xc
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG15_CFG_LPF				0x3
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG16_CFG_CP_OFFSET				0x60000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG16_CFG_REFCLK_SEL				0x18000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG16_CFG_LDO_PLL				0x7000000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG16_CFG_LDO_1P4				0xf00000
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG16_CFG_KINT				0xfffff
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG17_CFG_MISC_OUT				0xf0
#define MASK_ANALOG_USB30_CFGA_RF_ANA_CFG17_CFG_MISC_IN				0xf

#endif
