/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2022, Unisoc Inc.
 */

#ifndef __DT_BINDINGS_SPRD_UMS9620_RESET_H
#define __DT_BINDINGS_SPRD_UMS9620_RESET_H


/* PMU APB resets */
#define RESET_PMU_APB_AUD_CEVA_SOFT_RST		0
#define RESET_PMU_APB_AP_SOFT_RST		1
#define RESET_PMU_APB_APCPU_TOP_SOFT_RST	2
#define RESET_PMU_APB_GPU_SOFT_RST		3
#define RESET_PMU_APB_CAMERA_SOFT_RST		4
#define RESET_PMU_APB_DPU_VSP_SOFT_RST		5
#define RESET_PMU_APB_AI_SOFT_RST		6
#define RESET_PMU_APB_PS_CP_SOFT_RST		7
#define RESET_PMU_APB_PHY_CP_SOFT_RST		8
#define RESET_PMU_APB_CDMA_PROC0_SOFT_RST	9
#define RESET_PMU_APB_AUDIO_SOFT_RST		10
#define RESET_PMU_APB_IPA_SOFT_RST		11
#define RESET_PMU_APB_PCIE_SOFT_RST		12
#define RESET_PMU_APB_ISE_SOFT_RST		13
#define RESET_PMU_APB_CS_SOFT_RST		14
#define RESET_PMU_APB_AON_SOFT_RST		15
#define RESET_PMU_APB_SP_SOFT_RST		16
#define RESET_PMU_APB_CH_SOFT_RST		17
#define RESET_PMU_APB_PUB_SOFT_RST		18


/* AP APB resets */
#define RESET_AP_APB_IIS0_SOFT_RST		0
#define RESET_AP_APB_IIS1_SOFT_RST		1
#define RESET_AP_APB_IIS2_SOFT_RST		2
#define RESET_AP_APB_SPI0_SOFT_RST		3
#define RESET_AP_APB_SPI1_SOFT_RST		4
#define RESET_AP_APB_SPI2_SOFT_RST		5
#define RESET_AP_APB_UART3_SOFT_RST		6
#define RESET_AP_APB_UART0_SOFT_RST		7
#define RESET_AP_APB_UART1_SOFT_RST		8
#define RESET_AP_APB_UART2_SOFT_RST		9
#define RESET_AP_APB_CE_SEC_SOFT_RST		10
#define RESET_AP_APB_CE_PUB_SOFT_RST		11
#define RESET_AP_APB_AP_DVFS_SOFT_RST		12


/* AP AHB resets */
#define RESET_AP_AHB_SDIO0_SOFT_RST		0
#define RESET_AP_AHB_SDIO1_SOFT_RST		1
#define RESET_AP_AHB_SDIO2_SOFT_RST		2
#define RESET_AP_AHB_EMMC_SOFT_RST		3
#define RESET_AP_AHB_UFS_SOFT_RST		4
#define RESET_AP_AHB_DMA_SOFT_RST		5
#define RESET_AP_AHB_I2C0_SOFT_RST		6
#define RESET_AP_AHB_I2C1_SOFT_RST		7
#define RESET_AP_AHB_I2C2_SOFT_RST		8
#define RESET_AP_AHB_I2C3_SOFT_RST		9
#define RESET_AP_AHB_I2C4_SOFT_RST		10
#define RESET_AP_AHB_I2C5_SOFT_RST		11
#define RESET_AP_AHB_I2C6_SOFT_RST		12
#define RESET_AP_AHB_I2C7_SOFT_RST		13
#define RESET_AP_AHB_I2C8_SOFT_RST		14
#define RESET_AP_AHB_I2C9_SOFT_RST		15


/* AON APB resets */
#define RESET_AON_APB_RC100M_CAL_SOFT_RST		0
#define RESET_AON_APB_RFTI_SOFT_RST			1
#define RESET_AON_APB_DCXO_LC_SOFT_RST			2
#define RESET_AON_APB_BB_CAL_SOFT_RST			3
#define RESET_AON_APB_MSPI0_SOFT_RST			4
#define RESET_AON_APB_MSPI1_SOFT_RST			5
#define RESET_AON_APB_DAP_MTX_SOFT_RST			6
#define RESET_AON_APB_LVDSDIS_SOFT_RST			7
#define RESET_AON_APB_SERDES_DPHY_SOFT_RST		8
#define RESET_AON_APB_SERDES_DPHY_APB_SOFT_RST		9
#define RESET_AON_APB_BB_SW_RFSPI_MST_SOFT_RST		10
#define RESET_AON_APB_RC150M_CAL_SOFT_RST		11
#define RESET_AON_APB_RC60M_CAL_SOFT_RST		12
#define RESET_AON_APB_RC6M_CAL_SOFT_RST			13
#define RESET_AON_APB_AON_SW_RFFE_SOFT_RST		14
#define RESET_AON_APB_LVDS_PHY_SOFT_RST			15
#define RESET_AON_APB_EFUSE_SOFT_RST			16
#define RESET_AON_APB_GPIO_SOFT_RST			17
#define RESET_AON_APB_MBOX_SOFT_RST			18
#define RESET_AON_APB_KPD_SOFT_RST			19
#define RESET_AON_APB_AON_SYST_SOFT_RST			20
#define RESET_AON_APB_AP_SYST_SOFT_RST			21
#define RESET_AON_APB_DVFS_TOP_SOFT_RST			22
#define RESET_AON_APB_OTG_UTMI_SOFT_RST			23
#define RESET_AON_APB_OTG_PHY_SOFT_RST			24
#define RESET_AON_APB_SPLK_SOFT_RST			25
#define RESET_AON_APB_PIN_SOFT_RST			26
#define RESET_AON_APB_ANA_SOFT_RST			27
#define RESET_AON_APB_CKG_SOFT_RST			28
#define RESET_AON_APB_UFS_AO_SOFT_RST			29
#define RESET_AON_APB_APCPU_TS0_SOFT_RST		30
#define RESET_AON_APB_DEBUG_FILTER_SOFT_RST		31
#define RESET_AON_APB_AON_IIS_SOFT_RST			32
#define RESET_AON_APB_SCC_SOFT_RST			33
#define RESET_AON_APB_SERDES1_SOFT_RST			34
#define RESET_AON_APB_SERDES0_SOFT_RST			35
#define RESET_AON_APB_THM0_OVERHEAT_SOFT_RST		36
#define RESET_AON_APB_THM1_OVERHEAT_SOFT_RST		37
#define RESET_AON_APB_THM2_OVERHEAT_SOFT_RST		38
#define RESET_AON_APB_THM3_OVERHEAT_SOFT_RST		39
#define RESET_AON_APB_THM0_SOFT_RST			40
#define RESET_AON_APB_THM1_SOFT_RST			41
#define RESET_AON_APB_THM2_SOFT_RST			42
#define RESET_AON_APB_THM3_SOFT_RST			43
#define RESET_AON_APB_PSCP_SIM0_AON_TOP_SOFT_RST	44
#define RESET_AON_APB_PSCP_SIM1_AON_TOP_SOFT_RST	45
#define RESET_AON_APB_PSCP_SIM2_AON_TOP_SOFT_RST	46
#define RESET_AON_APB_LP_AUDCP_INTC_SOFT_RST		47
#define RESET_AON_APB_PMU_SOFT_RST			48
#define RESET_AON_APB_ADI_SOFT_RST			49
#define RESET_AON_APB_EIC_SOFT_RST			50
#define RESET_AON_APB_LP_AP_INTC0_SOFT_RST		51
#define RESET_AON_APB_LP_AP_INTC1_SOFT_RST		52
#define RESET_AON_APB_LP_AP_INTC2_SOFT_RST		53
#define RESET_AON_APB_LP_AP_INTC3_SOFT_RST		54
#define RESET_AON_APB_LP_AP_INTC4_SOFT_RST		55
#define RESET_AON_APB_LP_AP_INTC5_SOFT_RST		56
#define RESET_AON_APB_LP_AP_INTC6_SOFT_RST		57
#define RESET_AON_APB_LP_AP_INTC7_SOFT_RST		58
#define RESET_AON_APB_LP_PSCP_INTC_SOFT_RST		59
#define RESET_AON_APB_LP_PHYCP_INTC_SOFT_RST		60
#define RESET_AON_APB_LP_ISE_INTC_SOFT_RST		61
#define RESET_AON_APB_PWM0_SOFT_RST			62
#define RESET_AON_APB_PWM1_SOFT_RST			63
#define RESET_AON_APB_PWM2_SOFT_RST			64
#define RESET_AON_APB_PWM3_SOFT_RST			65
#define RESET_AON_APB_AP_WDG_SOFT_RST			66
#define RESET_AON_APB_APCPU_WDG_SOFT_RST		67
#define RESET_AON_APB_DJTAG_SOFT_RST			68
#define RESET_AON_APB_UFSDEV_SOFT_RST			69


/* IPA APB resets */
#define RESET_IPA_APB_USB_SOFT_RST			0
#define RESET_IPA_APB_PAM_U3_SOFT_RST			1
#define RESET_IPA_APB_NIC_400_CFG_SOFT_RST		2
#define RESET_IPA_APB_PAM_WIFI_SOFT_RST			3
#define RESET_IPA_APB_BUSMON_PERF_PAM_U3_SOFT_RST	4
#define RESET_IPA_APB_BUSMON_PERF_UPA_WIFI_SOFT_RST	5
#define RESET_IPA_APB_BUSMON_PERF_IPA_M0_SOFT_RST	6


/* IPA GLB APB resets */
#define RESET_IPA_GLB_APB_IPA_SOFT_RST			0


/* IPA DISPC1 GLB APB resets */
#define RESET_IPA_DISPC1_GLB_APB_DPU1_SOFT_RST		0
#define RESET_IPA_DISPC1_GLB_APB_DPTX_SOFT_RST		1
#define RESET_IPA_DISPC1_GLB_APB_TRNG_SOFT_RST		2
#define RESET_IPA_DISPC1_GLB_APB_DPU1_VAU_SOFT_RST	3
#define RESET_IPA_DISPC1_GLB_APB_PHY_SOFT_RST		4
#define RESET_IPA_DISPC1_GLB_APB_TCA_SOFT_RST		5


/* PCIE APB resets */
#define RESET_PCIE_APB_PCIE3_SOFT_RST			0
#define RESET_PCIE_APB_NIC400_CFG_SOFT_RST		1
#define RESET_PCIE_APB_PCIE_ANLG_SOFT_RST		2


/* AI APB resets */
#define RESET_PCIE_APB_DVFS_SOFT_RST		0
#define RESET_PCIE_APB_OCM_SOFT_RST		1
#define RESET_PCIE_APB_POWERVR_SOFT_RST		2


/* MM AHB resets */
#define RESET_MM_AHB_REGU_SOFT_RST		0
#define RESET_MM_AHB_DCAM0_1_SOFT_RST		1
#define RESET_MM_AHB_DCAM2_3_SOFT_RST		2
#define RESET_MM_AHB_DCAM0_1_AXI_SOFT_RST	3
#define RESET_MM_AHB_DCAM3_SOFT_RST		4
#define RESET_MM_AHB_DCAM2_SOFT_RST		5
#define RESET_MM_AHB_DCAM1_SOFT_RST		6
#define RESET_MM_AHB_DCAM0_SOFT_RST		7
#define RESET_MM_AHB_MIPI_CSI3_SOFT_RST		8
#define RESET_MM_AHB_MIPI_CSI2_SOFT_RST		9
#define RESET_MM_AHB_MIPI_CSI1_SOFT_RST		10
#define RESET_MM_AHB_MIPI_CSI0_SOFT_RST		11
#define RESET_MM_AHB_DCAM2_3_AXI_SOFT_RST	12
#define RESET_MM_AHB_DCAM2_3_VAU_SOFT_RST	13
#define RESET_MM_AHB_DCAM0_1_VAU_SOFT_RST	14
#define RESET_MM_AHB_DEP_VAU_SOFT_RST		15
#define RESET_MM_AHB_DEP_SOFT_RST		16
#define RESET_MM_AHB_DEP_ALL_SOFT_RST		17
#define RESET_MM_AHB_FD_VAU_SOFT_RST		18
#define RESET_MM_AHB_FD_SOFT_RST		19
#define RESET_MM_AHB_FD_ALL_SOFT_RST		20
#define RESET_MM_AHB_CPP_DMA_SOFT_RST		21
#define RESET_MM_AHB_CPP_PATH1_SOFT_RST		22
#define RESET_MM_AHB_CPP_PATH0_SOFT_RST		23
#define RESET_MM_AHB_CPP_VAU_SOFT_RST		24
#define RESET_MM_AHB_CPP_SOFT_RST		25
#define RESET_MM_AHB_CPP_ALL_SOFT_RST		26
#define RESET_MM_AHB_ISP_VAU_SOFT_RST		27
#define RESET_MM_AHB_ISP_ALL_SOFT_RST		28
#define RESET_MM_AHB_ISP_SOFT_RST		29
#define RESET_MM_AHB_CKG_SOFT_RST		30
#define RESET_MM_AHB_DVFS_SOFT_RST		31
#define RESET_MM_AHB_SYS_H2P_DB_SOFT_RST	32
#define RESET_MM_AHB_JPG_SOFT_RST		33
#define RESET_MM_AHB_JPG_VAU_SOFT_RST		34
#define RESET_MM_AHB_MAILBOX_SOFT_RST		35
#define RESET_MM_AHB_UART_SOFT_RST		36


/* DPU VSP APB resets */
#define RESET_DPU_VSP_APB_DPU_SOFT_RST			0
#define RESET_DPU_VSP_APB_DSI0_SOFT_RST			1
#define RESET_DPU_VSP_APB_DSI1_SOFT_RST			2
#define RESET_DPU_VSP_APB_VPU_ENC0_SOFT_RST		3
#define RESET_DPU_VSP_APB_VPU_ENC1_SOFT_RST		4
#define RESET_DPU_VSP_APB_VPU_DEC_SOFT_RST		5
#define RESET_DPU_VSP_APB_GSP0_SOFT_RST			6
#define RESET_DPU_VSP_APB_GSP1_SOFT_RST			7
#define RESET_DPU_VSP_APB_DVFS_SOFT_RST			8
#define RESET_DPU_VSP_APB_VPU_ENC0_VPP_SOFT_RST		9
#define RESET_DPU_VSP_APB_VPU_ENC0_VSP_SOFT_RST		10
#define RESET_DPU_VSP_APB_VPU_ENC1_VPP_SOFT_RST		11
#define RESET_DPU_VSP_APB_VPU_ENC1_VSP_SOFT_RST		12
#define RESET_DPU_VSP_APB_VPU_DEC_VPP_SOFT_RST		13
#define RESET_DPU_VSP_APB_VPU_DEC_VSP_SOFT_RST		14
#define RESET_DPU_VSP_APB_VPU_ENC0_VAU_SOFT_RST		15
#define RESET_DPU_VSP_APB_VPU_ENC1_VAU_SOFT_RST		16
#define RESET_DPU_VSP_APB_VPU_DEC_VAU_SOFT_RST		17
#define RESET_DPU_VSP_APB_DPU_VAU_SOFT_RST		18
#define RESET_DPU_VSP_APB_GSP0_VAU_SOFT_RST		19
#define RESET_DPU_VSP_APB_GSP1_VAU_SOFT_RST		20
#define RESET_DPU_VSP_APB_SYS_SOFT_RST_REQ_DISP		21
#define RESET_DPU_VSP_APB_SYS_SOFT_RST_REQ_VPU_ENC0	22
#define RESET_DPU_VSP_APB_SYS_SOFT_RST_REQ_VPU_ENC1	23
#define RESET_DPU_VSP_APB_SYS_SOFT_RST_REQ_VPU_DEC	24
#define RESET_DPU_VSP_APB_SYS_SOFT_RST_REQ_GSP0		25
#define RESET_DPU_VSP_APB_SYS_SOFT_RST_REQ_GSP1		26


/* AUDCP GLB resets */
#define RESET_AUDCP_GLB_VBS_24M_SOFT_RST		0
#define RESET_AUDCP_GLB_DMA_AP_SOFT_RST			1
#define RESET_AUDCP_GLB_SRC48K_SOFT_RST			2
#define RESET_AUDCP_GLB_MCDT_SOFT_RST			3
#define RESET_AUDCP_GLB_VBC_SOFT_RST			4
#define RESET_AUDCP_GLB_SPINLOCK_SOFT_RST		5
#define RESET_AUDCP_GLB_DMA_CP_SOFT_RST			6
#define RESET_AUDCP_GLB_IIS0_SOFT_RST			7
#define RESET_AUDCP_GLB_IIS1_SOFT_RST			8
#define RESET_AUDCP_GLB_IIS2_SOFT_RST			9
#define RESET_AUDCP_GLB_UART_SOFT_RST			10
#define RESET_AUDCP_GLB_AUD_SOFT_RST			11
#define RESET_AUDCP_GLB_TDM_SOFT_RST			12
#define RESET_AUDCP_GLB_MATRIX_CFG_SOFT_RST		13
#define RESET_AUDCP_GLB_TDM_HF_SOFT_RST			14


/* AUDCP AON APB  resets */
#define RESET_AUDCP_AON_APB_VAD_SOFT_RST		0
#define RESET_AUDCP_AON_APB_PDM_SOFT_RST		1
#define RESET_AUDCP_AON_APB_PDM_IIS_SOFT_RST		2
#define RESET_AUDCP_AON_APB_DVFS_SOFT_RST		3


#endif /* __DT_BINDINGS_SPRD_UMS9620_RESET_H */
