/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2022, Unisoc Inc.
 */

#ifndef __DT_BINDINGS_SPRD_UMS9230_RESET_H
#define __DT_BINDINGS_SPRD_UMS9230_RESET_H


/* PMU APB resets */
#define RESET_PMU_APB_AP_SOFT_RST		0
#define RESET_PMU_APB_APCPU_TOP_SOFT_RST	1
#define RESET_PMU_APB_GPU_SOFT_RST		2
#define RESET_PMU_APB_MM_SOFT_RST		3
#define RESET_PMU_APB_PUBCP_SOFT_RST		4
#define RESET_PMU_APB_WTLCP_SOFT_RST		5
#define RESET_PMU_APB_WCN_SOFT_RST		6
#define RESET_PMU_APB_AUDCP_SOFT_RST		7
#define RESET_PMU_APB_AON_SOFT_RST		8
#define RESET_PMU_APB_SP_SOFT_RST		9
#define RESET_PMU_APB_PUB_SOFT_RST		10


/* AP APB resets */
#define RESET_AP_APB_SIM0_SOFT_RST		0
#define RESET_AP_APB_IIS0_SOFT_RST		1
#define RESET_AP_APB_IIS1_SOFT_RST		2
#define RESET_AP_APB_IIS2_SOFT_RST		3
#define RESET_AP_APB_SPI0_SOFT_RST		4
#define RESET_AP_APB_SPI1_SOFT_RST		5
#define RESET_AP_APB_SPI2_SOFT_RST		6
#define RESET_AP_APB_SPI3_SOFT_RST		7
#define RESET_AP_APB_I2C0_SOFT_RST		8
#define RESET_AP_APB_I2C1_SOFT_RST		9
#define RESET_AP_APB_I2C2_SOFT_RST		10
#define RESET_AP_APB_I2C3_SOFT_RST		11
#define RESET_AP_APB_I2C4_SOFT_RST		12
#define RESET_AP_APB_UART0_SOFT_RST		13
#define RESET_AP_APB_UART1_SOFT_RST		14
#define RESET_AP_APB_UART2_SOFT_RST		15
#define RESET_AP_APB_SDIO0_SOFT_RST		16
#define RESET_AP_APB_SDIO1_SOFT_RST		17
#define RESET_AP_APB_SDIO2_SOFT_RST		18
#define RESET_AP_APB_EMMC_SOFT_RST		19
#define RESET_AP_APB_CE_SEC_SOFT_RST		20
#define RESET_AP_APB_CE_PUB_SOFT_RST		21
#define RESET_AP_APB_AP_DVFS_SOFT_RST		22
#define RESET_AP_APB_UFS_SOFT_RST		23
#define RESET_AP_APB_UFS_REG_SOFT_RST		24
#define RESET_AP_APB_CKG_SOFT_RST		25
#define RESET_AP_APB_I2C5_SOFT_RST		26
#define RESET_AP_APB_I2C6_SOFT_RST		27
#define RESET_AP_APB_AXI_REGU_SOFT_RST		28
#define RESET_AP_APB_UFS_AES_SOFT_RST		29
#define RESET_AP_APB_UFS_GLB_RST		30


/* AP AHB resets */
#define RESET_AP_AHB_DSI_SOFT_RST		0
#define RESET_AP_AHB_DISPC_SOFT_RST		1
#define RESET_AP_AHB_DMA_SOFT_RST		2
#define RESET_AP_AHB_VSP_VAU_SOFT_RST		3
#define RESET_AP_AHB_VSP_GLOBAL_SOFT_RST	4
#define RESET_AP_AHB_VPP_SOFT_RST		5
#define RESET_AP_AHB_VSP_SOFT_RST		6
#define RESET_AP_AHB_DISPC_VAU_SOFT_RST		7


/* AON APB resets */
#define RESET_AON_APB_RC100M_CAL_SOFT_RST	0
#define RESET_AON_APB_RFTI_SOFT_RST		1
#define RESET_AON_APB_DCXO_LC_SOFT_RST		2
#define RESET_AON_APB_BB_CAL_SOFT_RST		3
#define RESET_AON_APB_MSPI0_SOFT_RST		4
#define RESET_AON_APB_MSPI1_SOFT_RST		5
#define RESET_AON_APB_DAP_MTX_SOFT_RST		6
#define RESET_AON_APB_LVDSDIS_SOFT_RST		7
#define RESET_AON_APB_AP_EMMC_SOFT_RST		8
#define RESET_AON_APB_AP_SDIO0_SOFT_RST		9
#define RESET_AON_APB_AP_SDIO1_SOFT_RST		10
#define RESET_AON_APB_AP_SDIO2_SOFT_RST		11
#define RESET_AON_APB_PUBCP_SDIO0_SOFT_RST	12
#define RESET_AON_APB_EFUSE_SOFT_RST		13
#define RESET_AON_APB_GPIO_SOFT_RST		14
#define RESET_AON_APB_MBOX_SOFT_RST		15
#define RESET_AON_APB_KPD_SOFT_RST		16
#define RESET_AON_APB_AON_SYST_SOFT_RST		17
#define RESET_AON_APB_AP_SYST_SOFT_RST		18
#define RESET_AON_APB_AON_TMR_SOFT_RST		19
#define RESET_AON_APB_DVFS_TOP_SOFT_RST		20
#define RESET_AON_APB_OTG_UTMI_SOFT_RST		21
#define RESET_AON_APB_OTG_PHY_SOFT_RST		22
#define RESET_AON_APB_SPLK_SOFT_RST		23
#define RESET_AON_APB_PIN_SOFT_RST		24
#define RESET_AON_APB_ANA_SOFT_RST		25
#define RESET_AON_APB_CKG_SOFT_RST		26
#define RESET_AON_APB_ADI_2ND_SOFT_RST		27
#define RESET_AON_APB_APCPU_TS0_SOFT_RST	28
#define RESET_AON_APB_APB_BUSMON_SOFT_RST	29
#define RESET_AON_APB_AON_IIS_SOFT_RST		30
#define RESET_AON_APB_SCC_SOFT_RST		31
#define RESET_AON_APB_THM0_SOFT_RST		32
#define RESET_AON_APB_THM1_SOFT_RST		33
#define RESET_AON_APB_THM2_SOFT_RST		34
#define RESET_AON_APB_AP_SIM_AON_TOP_SOFT_RST	35
#define RESET_AON_APB_PUBCP_SIM0_AON_TOP_SOFT_RST	36
#define RESET_AON_APB_PUBCP_SIM1_AON_TOP_SOFT_RST	37
#define RESET_AON_APB_PUBCP_SIM2_AON_TOP_SOFT_RST	38
#define RESET_AON_APB_I2C_SOFT_RST		39
#define RESET_AON_APB_PMU_SOFT_RST		40
#define RESET_AON_APB_ADI_SOFT_RST		41
#define RESET_AON_APB_EIC_SOFT_RST		42
#define RESET_AON_APB_AP_INTC0_SOFT_RST		43
#define RESET_AON_APB_AP_INTC1_SOFT_RST		44
#define RESET_AON_APB_AP_INTC2_SOFT_RST		45
#define RESET_AON_APB_AP_INTC3_SOFT_RST		46
#define RESET_AON_APB_AP_INTC4_SOFT_RST		47
#define RESET_AON_APB_AP_INTC5_SOFT_RST		48
#define RESET_AON_APB_AUDCP_INTC_SOFT_RST	49
#define RESET_AON_APB_PUBCP_INTC_SOFT_RST	50
#define RESET_AON_APB_WTLCP_TGDSP_INTC_SOFT_RST	51
#define RESET_AON_APB_WTLCP_LDSP_INTC_SOFT_RST	52
#define RESET_AON_APB_WTLCP_INTC_SOFT_RST	53
#define RESET_AON_APB_AP_TMR0_SOFT_RST		54
#define RESET_AON_APB_AP_TMR1_SOFT_RST		55
#define RESET_AON_APB_AP_TMR2_SOFT_RST		56
#define RESET_AON_APB_PWM0_SOFT_RST		57
#define RESET_AON_APB_PWM1_SOFT_RST		58
#define RESET_AON_APB_PWM2_SOFT_RST		59
#define RESET_AON_APB_PWM3_SOFT_RST		60
#define RESET_AON_APB_AP_WDG_SOFT_RST		61
#define RESET_AON_APB_APCPU_WDG_SOFT_RST	62
#define  RESET_AON_APB_SERDES_SOFT_RST		63
#define  RESET_AON_APB_DJTAG_SOFT_RST		64


/* GPU APB resets */
#define RESET_GPU_APB_GPU_CORE_SOFT_RST		0
#define RESET_GPU_APB_SYS_SOFT_RST_REQ_CORE	1


/* MM AHB resets */
#define RESET_MM_AHB_CKG_SOFT_RST		0
#define RESET_MM_AHB_JPG_SOFT_RST		1
#define RESET_MM_AHB_DCAM_AXI_SOFT_RST		2
#define RESET_MM_AHB_DCAM2_SOFT_RST		3
#define RESET_MM_AHB_DCAM1_SOFT_RST		4
#define RESET_MM_AHB_DCAM0_SOFT_RST		5
#define RESET_MM_AHB_DCAM_VAU_SOFT_RST		6
#define RESET_MM_AHB_MIPI_CSI2_SOFT_RST		7
#define RESET_MM_AHB_MIPI_CSI1_SOFT_RST		8
#define RESET_MM_AHB_MIPI_CSI0_SOFT_RST		9
#define RESET_MM_AHB_ISP_SOFT_RST		10
#define RESET_MM_AHB_ISP_VAU_SOFT_RST		11
#define RESET_MM_AHB_ISP_AHB_SOFT_RST		12
#define RESET_MM_AHB_CPP_DMA_SOFT_RST		13
#define RESET_MM_AHB_CPP_PATH1_SOFT_RST		14
#define RESET_MM_AHB_CPP_PATH0_SOFT_RST		15
#define RESET_MM_AHB_CPP_SOFT_RST		16
#define RESET_MM_AHB_MM_MAIN_SOFT_RST		17
#define RESET_MM_AHB_CPP_SOFT_RST_MASK		18
#define RESET_MM_AHB_JPG_SOFT_RST_MASK		19
#define RESET_MM_AHB_JPG_VAU_SOFT_RST		20
#define RESET_MM_AHB_CPP_VAU_SOFT_RST		21
#define RESET_MM_AHB_FD_VAU_SOFT_RST		22
#define RESET_MM_AHB_DCAM_ALL_SOFT_RST		23
#define RESET_MM_AHB_DVFS_SOFT_RST		24
#define RESET_MM_AHB_FD_SOFT_RST		25
#define RESET_MM_AHB_FD_SOFT_RST_MASK		26
#define RESET_MM_AHB_CSI2DCAM_SW_SOFT_RST	27
#define RESET_MM_AHB_AXI_REGU_SOFT_RST		28


/* AUDCP AHB resets */
#define RESET_AUDCP_AHB_VBS_24M_SOFT_RST	0
#define RESET_AUDCP_AHB_DMA_AP_SOFT_RST		1
#define RESET_AUDCP_AHB_SRC48K_SOFT_RST		2
#define RESET_AUDCP_AHB_PDM_SOFT_RST		3
#define RESET_AUDCP_AHB_MCDT_SOFT_RST		4
#define RESET_AUDCP_AHB_VBCIFD_SOFT_RST		5
#define RESET_AUDCP_AHB_VBC_SOFT_RST		6
#define RESET_AUDCP_AHB_SPINLOCK_SOFT_RST	7
#define RESET_AUDCP_AHB_DMA_CP_SOFT_RST		8
#define RESET_AUDCP_AHB_IIS0_SOFT_RST		9
#define RESET_AUDCP_AHB_IIS1_SOFT_RST		10
#define RESET_AUDCP_AHB_IIS2_SOFT_RST		11
#define RESET_AUDCP_AHB_UART_SOFT_RST		12
#define RESET_AUDCP_AHB_AUD_SOFT_RST		13
#define RESET_AUDCP_AHB_DVFS_SOFT_RST		14

/* AUDCP APB  resets */
#define RESET_AUDCP_APB_WDG_SOFT_RST		0
#define RESET_AUDCP_APB_TMR0_SOFT_RST		1
#define RESET_AUDCP_APB_TMR1_SOFT_RST		2


#endif /* __DT_BINDINGS_SPRD_UMS9230_RESET_H */
