/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2023, Unisoc Inc.
 */

#ifndef __DT_BINDINGS_SPRD_UIS8520_RESET_H
#define __DT_BINDINGS_SPRD_UIS8520_RESET_H


/* PMU APB resets */
#define RESET_PMU_APB_AUD_CEVA_SOFT_RST		0
#define RESET_PMU_APB_AP_SOFT_RST		1
#define RESET_PMU_APB_APCPU_TOP_SOFT_RST	2
#define RESET_PMU_APB_PS_CP_SOFT_RST		3
#define RESET_PMU_APB_PHY_CP_SOFT_RST		4
#define RESET_PMU_APB_AUDIO_SOFT_RST		5
#define RESET_PMU_APB_IPA_SOFT_RST		6
#define RESET_PMU_APB_PCIE_0_SOFT_RST		7
#define RESET_PMU_APB_PCIE_1_SOFT_RST		8
#define RESET_PMU_APB_ETHER_XGE_SOFT_RST	9
#define RESET_PMU_APB_CS_SOFT_RST		10
#define RESET_PMU_APB_AON_SOFT_RST		11
#define RESET_PMU_APB_TIANSHAN_CP_SOFT_RST	12
#define RESET_PMU_APB_SP_SOFT_RST		13
#define RESET_PMU_APB_PUB_SOFT_RST		14


/* AP APB resets */
#define RESET_AP_APB_IIS0_SOFT_RST		0
#define RESET_AP_APB_IIS1_SOFT_RST		1
#define RESET_AP_APB_IIS2_SOFT_RST		2
#define RESET_AP_APB_SPI0_SOFT_RST		3
#define RESET_AP_APB_SPI1_SOFT_RST		4
#define RESET_AP_APB_SPI2_SOFT_RST		5
#define RESET_AP_APB_UART3_SOFT_RST		6
#define RESET_AP_APB_UART0_SOFT_RST		7
#define RESET_AP_APB_UART1_SOFT_RST		8
#define RESET_AP_APB_UART2_SOFT_RST		9
#define RESET_AP_APB_CE_SEC_SOFT_RST		10
#define RESET_AP_APB_CE_PUB_SOFT_RST		11
#define RESET_AP_APB_AP_DVFS_SOFT_RST		12
#define RESET_AP_APB_SPI3_SOFT_RST		13
#define RESET_AP_APB_SPI4_SOFT_RST		14
#define RESET_AP_APB_SPI5_SOFT_RST		15
#define RESET_AP_APB_UART4_SOFT_RST		16
#define RESET_AP_APB_UART5_SOFT_RST		17
#define RESET_AP_APB_UART6_SOFT_RST		18
#define RESET_AP_APB_UART7_SOFT_RST		19
#define RESET_AP_APB_UART8_SOFT_RST		20
#define RESET_AP_APB_UART9_SOFT_RST		21
#define RESET_AP_APB_UART10_SOFT_RST		22


/* AP AHB resets */
#define RESET_AP_AHB_SDIO_SOFT_RST		0
#define RESET_AP_AHB_EMMC_SOFT_RST		1
#define RESET_AP_AHB_DMA_SOFT_RST		2
#define RESET_AP_AHB_I2C0_SOFT_RST		3
#define RESET_AP_AHB_I2C1_SOFT_RST		4
#define RESET_AP_AHB_I2C2_SOFT_RST		5
#define RESET_AP_AHB_I2C3_SOFT_RST		6
#define RESET_AP_AHB_I2C4_SOFT_RST		7
#define RESET_AP_AHB_I2C5_SOFT_RST		8
#define RESET_AP_AHB_I2C6_SOFT_RST		9
#define RESET_AP_AHB_I2C7_SOFT_RST		10
#define RESET_AP_AHB_I2C8_SOFT_RST		11
#define RESET_AP_AHB_I2C9_SOFT_RST		12
#define RESET_AP_AHB_NANDC_SOFT_RST		13
#define RESET_AP_AHB_I2C_S0_SOFT_RST		14
#define RESET_AP_AHB_I2C_S1_SOFT_RST		15

/* AON APB resets */
#define RESET_AON_APB_RC100M_CAL_SOFT_RST		0
#define RESET_AON_APB_DCXO_LC_SOFT_RST			1
#define RESET_AON_APB_DAP_MTX_SOFT_RST			2
#define RESET_AON_APB_RC60M_CAL_SOFT_RST		3
#define RESET_AON_APB_RC6M_CAL_SOFT_RST			4
#define RESET_AON_APB_AON_SW_RFFE_SOFT_RST		5
#define RESET_AON_APB_LVDS_PHY_SOFT_RST			6
#define RESET_AON_APB_LCM_RST				7
#define RESET_AON_APB_EFUSE_SOFT_RST			8
#define RESET_AON_APB_GPIO_SOFT_RST			9
#define RESET_AON_APB_MBOX_SOFT_RST			10
#define RESET_AON_APB_KPD_SOFT_RST			11
#define RESET_AON_APB_AON_SYST_SOFT_RST			12
#define RESET_AON_APB_AP_SYST_SOFT_RST			13
#define RESET_AON_APB_DVFS_TOP_SOFT_RST			14
#define RESET_AON_APB_OTG_UTMI_SOFT_RST			15
#define RESET_AON_APB_OTG_PHY_SOFT_RST			16
#define RESET_AON_APB_SPLK_SOFT_RST			17
#define RESET_AON_APB_PIN_SOFT_RST			18
#define RESET_AON_APB_ANA_SOFT_RST			19
#define RESET_AON_APB_CKG_SOFT_RST			20
#define RESET_AON_APB_APCPU_TS0_SOFT_RST		21
#define RESET_AON_APB_DEBUG_FILTER_SOFT_RST		22
#define RESET_AON_APB_AON_IIS_SOFT_RST			23
#define RESET_AON_APB_SCC_SOFT_RST			24
#define RESET_AON_APB_THM0_OVERHEAT_SOFT_RST		25
#define RESET_AON_APB_THM1_OVERHEAT_SOFT_RST		26
#define RESET_AON_APB_THM0_SOFT_RST			27
#define RESET_AON_APB_THM1_SOFT_RST			28
#define RESET_AON_APB_PSCP_SIM0_AON_TOP_SOFT_RST	29
#define RESET_AON_APB_PSCP_SIM1_AON_TOP_SOFT_RST	30
#define RESET_AON_APB_AON_ASE_SOFT_RST			31
#define RESET_AON_APB_LP_AUDCP_INTC_SOFT_RST		32
#define RESET_AON_APB_PMU_SOFT_RST			33
#define RESET_AON_APB_ADI_SOFT_RST			34
#define RESET_AON_APB_EIC_SOFT_RST			35
#define RESET_AON_APB_LP_AP_INTC0_SOFT_RST		36
#define RESET_AON_APB_LP_AP_INTC1_SOFT_RST		37
#define RESET_AON_APB_LP_AP_INTC2_SOFT_RST		38
#define RESET_AON_APB_LP_AP_INTC3_SOFT_RST		39
#define RESET_AON_APB_LP_AP_INTC4_SOFT_RST		40
#define RESET_AON_APB_LP_AP_INTC5_SOFT_RST		41
#define RESET_AON_APB_LP_AP_INTC6_SOFT_RST		42
#define RESET_AON_APB_LP_AP_INTC7_SOFT_RST		43
#define RESET_AON_APB_LP_PSCP_INTC_SOFT_RST		44
#define RESET_AON_APB_LP_PHYCP_INTC_SOFT_RST		45
#define RESET_AON_APB_AP_WDG_SOFT_RST			46
#define RESET_AON_APB_APCPU_WDG_SOFT_RST		47
#define RESET_AON_APB_AP_UART_SOFT_RST			48
#define RESET_AON_APB_DJTAG_SOFT_RST			49


/* IPA APB resets */
#define RESET_IPA_APB_USB_SOFT_RST			0
#define RESET_IPA_APB_PAM_U3_SOFT_RST			1
#define RESET_IPA_APB_NIC_400_CFG_SOFT_RST		2
#define RESET_IPA_APB_PAM_WIFI_SOFT_RST			3
#define RESET_IPA_APB_IPA_SOFT_RST			4
#define RESET_IPA_APB_PHY_SOFT_RST			5
#define RESET_IPA_APB_TCA_SOFT_RST			6
#define RESET_IPA_APB_BUSMON_PERF_PAM_U3_SOFT_RST	7
#define RESET_IPA_APB_BUSMON_PERF_UPA_WIFI_SOFT_RST	8
#define RESET_IPA_APB_BUSMON_PERF_IPA_M0_SOFT_RST	9


/* PCIE0 APB resets */
#define RESET_PCIE_APB_PCIE3_SOFT_0_RST			0
#define RESET_PCIE_APB_NIC400_CFG_SOFT_0_RST		1
#define RESET_PCIE_APB_PCIE_ANLG_SOFT_0_RST		2


/* PCIE1 APB resets */
#define RESET_PCIE_APB_PCIE3_SOFT_1_RST			0
#define RESET_PCIE_APB_NIC400_CFG_SOFT_1_RST		1
#define RESET_PCIE_APB_PCIE_ANLG_SOFT_1_RST		2

/*ETH APB reset*/
#define RESET_XGMAC_SOFT_RST				0
#define RESET_XPCS_SOFT_RST				1
#define RESET_PHY_SOFT_RST				2
#define RESET_NIC400_CFG_SOFT_RST			3
#define RESET_ETH_PLL_SSMOD_SOFT_RST			4

/* AUDCP GLB resets */
#define RESET_AUDCP_GLB_VBS_24M_SOFT_RST		0
#define RESET_AUDCP_GLB_DMA_AP_SOFT_RST			1
#define RESET_AUDCP_GLB_VAD_SOFT_RST			2
#define RESET_AUDCP_GLB_SRC48K_SOFT_RST			3
#define RESET_AUDCP_GLB_MCDT_SOFT_RST			4
#define RESET_AUDCP_GLB_VBC_SOFT_RST			5
#define RESET_AUDCP_GLB_SPINLOCK_SOFT_RST		6
#define RESET_AUDCP_GLB_DMA_CP_SOFT_RST			7
#define RESET_AUDCP_GLB_IIS0_SOFT_RST			8
#define RESET_AUDCP_GLB_IIS1_SOFT_RST			9
#define RESET_AUDCP_GLB_IIS2_SOFT_RST			10
#define RESET_AUDCP_GLB_UART_SOFT_RST			11
#define RESET_AUDCP_GLB_AUD_SOFT_RST			12
#define RESET_AUDCP_GLB_TDM_SOFT_RST			13
#define RESET_AUDCP_GLB_MATRIX_CFG_SOFT_RST		14
#define RESET_AUDCP_GLB_TDM_HF_SOFT_RST			15
#define RESET_AUDCP_GLB_PDM_SOFT_RST			16
#define RESET_AUDCP_GLB_PDM_IIS_SOFT_RST		17


/* AUDCP AON APB  resets */
#define RESET_AUDCP_AON_APB_VAD_SOFT_RST		0
#define RESET_AUDCP_AON_APB_PDM_SOFT_RST		1
#define RESET_AUDCP_AON_APB_PDM_IIS_SOFT_RST		2
#define RESET_AUDCP_AON_APB_DVFS_SOFT_RST		3


#endif /* __DT_BINDINGS_SPRD_UIS8520_RESET_H */

