/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Unisoc sc9863 platform reset
 *
 * Copyright (C) 2022, Unisoc Inc.
 */
#ifndef __DT_BINDINGS_SPRD_SC9863A_RESET_H
#define __DT_BINDINGS_SPRD_SC9863A_RESET_H


/* PMU APB resets */
#define RESET_PMU_APB_WTLCP_SOFT_RST		0
#define RESET_PMU_APB_PUBCP_SOFT_RST		1
#define RESET_PMU_APB_WTLCP_DSP_SOFT_RST	2
#define RESET_PMU_APB_MM_SOFT_RST		3
#define RESET_PMU_APB_GPU_SOFT_RST		4
#define RESET_PMU_APB_AP_SOFT_RST		5
#define RESET_PMU_APB_PUB_SOFT_RST		6
#define RESET_PMU_APB_SP_CORE_SOFT_RST		7
#define RESET_PMU_APB_SP_SYS_SOFT_RST		8
#define RESET_PMU_APB_CPU_TOP_SOFT_RST		9
#define RESET_PMU_APB_WIFI_WRAP_SOFT_RST	10
#define RESET_PMU_APB_GNSS_WRAP_SOFT_RST	11
#define RESET_PMU_APB_WTLCP_AON_SOFT_RST	12
#define RESET_PMU_APB_WCDMA_AON_SOFT_RST	13
#define RESET_PMU_APB_WTLCP_LDSP_SOFT_RST	14
#define RESET_PMU_APB_WTLCP_TGDSP_SOFT_RST	15
#define RESET_PMU_APB_WCN_SYS_SOFT_RST		16
#define RESET_PMU_APB_VSP_SOFT_RST		17
#define RESET_PMU_APB_DISP_SOFT_RST		18
#define RESET_PMU_APB_WIFI_SOFT_RST		19
#define RESET_PMU_APB_GNSS_SOFT_RST		20


/* AP APB resets */
#define RESET_AP_APB_SIM0_SOFT_RST		0
#define RESET_AP_APB_IIS0_SOFT_RST		1
#define RESET_AP_APB_IIS1_SOFT_RST		2
#define RESET_AP_APB_IIS2_SOFT_RST		3
#define RESET_AP_APB_SPI0_SOFT_RST		4
#define RESET_AP_APB_SPI1_SOFT_RST		5
#define RESET_AP_APB_SPI2_SOFT_RST		6
#define RESET_AP_APB_I2C0_SOFT_RST		7
#define RESET_AP_APB_I2C1_SOFT_RST		8
#define RESET_AP_APB_I2C2_SOFT_RST		9
#define RESET_AP_APB_I2C3_SOFT_RST		10
#define RESET_AP_APB_I2C4_SOFT_RST		11
#define RESET_AP_APB_UART0_SOFT_RST		12
#define RESET_AP_APB_UART1_SOFT_RST		13
#define RESET_AP_APB_UART2_SOFT_RST		14
#define RESET_AP_APB_UART3_SOFT_RST		15
#define RESET_AP_APB_UART4_SOFT_RST		16
#define RESET_AP_APB_SIM0_32K_SOFT_RST		17
#define RESET_AP_APB_SPI3_SOFT_RST		18
#define RESET_AP_APB_I2C5_SOFT_RST		19
#define RESET_AP_APB_I2C6_SOFT_RST		20


/* AP AHB resets */
#define RESET_AP_AHB_OTG_SOFT_RST		0
#define RESET_AP_AHB_UTM1_SOFT_RST		1
#define RESET_AP_AHB_DMA_SOFT_RST		2
#define RESET_AP_AHB_CE_PUB_SOFT_RST		3
#define RESET_AP_AHB_NANDC_SOFT_RST		4
#define RESET_AP_AHB_SDIO0_SOFT_RST		5
#define RESET_AP_AHB_SDIO1_SOFT_RST		6
#define RESET_AP_AHB_SDIO2_SOFT_RST		7
#define RESET_AP_AHB_EMMC_SOFT_RST		8
#define RESET_AP_AHB_CE_SEC_SOFT_RST		9
#define RESET_AP_AHB_SDIO0_32K_SOFT_RST		10
#define RESET_AP_AHB_SDIO1_32K_SOFT_RST		11
#define RESET_AP_AHB_SDIO2_32K_SOFT_RST		12
#define RESET_AP_AHB_EMMC_32K_SOFT_RST		13


/* AON APB resets */
#define RESET_AON_APB_ADC_SOFT_RST		0
#define RESET_AON_APB_FM_SOFT_RST		1
#define RESET_AON_APB_TPC_SOFT_RST		2
#define RESET_AON_APB_GPIO_SOFT_RST		3
#define RESET_AON_APB_PWM0_SOFT_RST		4
#define RESET_AON_APB_PWM1_SOFT_RST		5
#define RESET_AON_APB_PWM2_SOFT_RST		6
#define RESET_AON_APB_PWM3_SOFT_RST		7
#define RESET_AON_APB_KPD_SOFT_RST		8
#define RESET_AON_APB_AON_SYST_SOFT_RST		9
#define RESET_AON_APB_AP_SYST_SOFT_RST		10
#define RESET_AON_APB_AON_TMR_SOFT_RST		11
#define RESET_AON_APB_AP_TMR0_SOFT_RST		12
#define RESET_AON_APB_AP_WDG_SOFT_RST		13
#define RESET_AON_APB_EFUSE_SOFT_RST		14
#define RESET_AON_APB_EIC_SOFT_RST		15
#define RESET_AON_APB_INTC_SOFT_RST		16
#define RESET_AON_APB_ADI_SOFT_RST		17
#define RESET_AON_APB_AUDIF_SOFT_RST		18
#define RESET_AON_APB_AUD_SOFT_RST		19
#define RESET_AON_APB_VBC_SOFT_RST		20
#define RESET_AON_APB_PIN_SOFT_RST		21
#define RESET_AON_APB_CKG_SOFT_RST		22
#define RESET_AON_APB_IPI_SOFT_RST		23
#define RESET_AON_APB_SPLK_SOFT_RST		24
#define RESET_AON_APB_MSPI0_SOFT_RST		25
#define RESET_AON_APB_MSPI1_SOFT_RST		26
#define RESET_AON_APB_DAP_MTX_SOFT_RST		27
#define RESET_AON_APB_CA53_TS0_SOFT_RST		28
#define RESET_AON_APB_CA53_TS1_SOFT_RST		29
#define RESET_AON_APB_I2C_SOFT_RST		30
#define RESET_AON_APB_CA5_TS0_SOFT_RST		31
#define RESET_AON_APB_PMU_SOFT_RST		32
#define RESET_AON_APB_THM_SOFT_RST		33
#define RESET_AON_APB_ARM_THMA_SOFT_RST		34
#define RESET_AON_APB_GPU_THMA_SOFT_RST		35
#define RESET_AON_APB_DMC_PHY_SOFT_RST		36
#define RESET_AON_APB_AON_DMA_SOFT_RST		37
#define RESET_AON_APB_CA53_WDG_SOFT_RST		38
#define RESET_AON_APB_AP_TMR1_SOFT_RST		39
#define RESET_AON_APB_AP_TMR2_SOFT_RST		40
#define RESET_AON_APB_DXCO_LC_SOFT_RST		41
#define RESET_AON_APB_BB_CAL_SOFT_RST		42
#define RESET_AON_APB_LVDSDIS_SOFT_RST		43
#define RESET_AON_APB_MDAR_SOFT_RST		44
#define RESET_AON_APB_ADC1_CAL_SOFT_RST		45
#define RESET_AON_APB_ADC2_CAL_SOFT_RST		46
#define RESET_AON_APB_ADC3_CAL_SOFT_RST		47
#define RESET_AON_APB_DAC1_SOFT_RST		48
#define RESET_AON_APB_DAC2_SOFT_RST		49
#define RESET_AON_APB_DAC3_SOFT_RST		50
#define RESET_AON_APB_DISP_SOFT_RST		51
#define RESET_AON_APB_RTC4M0_CAL_SOFT_RST	52
#define RESET_AON_APB_RTC4M1_CAL_SOFT_RST	53
#define RESET_AON_APB_ROSC_SOFT_RST		54
#define RESET_AON_APB_MBOX_SOFT_RST		55
#define RESET_AON_APB_ADC1_SOFT_RST		56
#define RESET_AON_APB_ADC2_SOFT_RST		57
#define RESET_AON_APB_ADC3_SOFT_RST		58
#define RESET_AON_APB_DEF_SOFT_RST		59
#define RESET_AON_APB_DEF_SLV_INT_SOFT_RST	60
#define RESET_AON_APB_RTC4M_ANA_SOFT_RST	61
#define RESET_AON_APB_DJTAG_SOFT_RST		62

/* MM AHB resets */
#define RESET_MM_AHB_CKG_SOFT_RST		0
#define RESET_MM_AHB_AXI_MM_EMC_SOFT_RST	1
#define RESET_MM_AHB_DCAM0_SOFT_RST		2
#define RESET_MM_AHB_DCAM1_SOFT_RST		3
#define RESET_MM_AHB_DCAM2_SOFT_RST		4
#define RESET_MM_AHB_DCAM_AXIM_SOFT_RST		5
#define RESET_MM_AHB_DCAM_ALL_SOFT_RST		6
#define RESET_MM_AHB_ISP_LOG_SOFT_RST		7
#define RESET_MM_AHB_CSI_SOFT_RST		8
#define RESET_MM_AHB_CSI_S_SOFT_RST		9
#define RESET_MM_AHB_CSI_T_SOFT_RST		10


/* MM VSP AHB resets */
#define RESET_VSP_AHB_CKG_SOFT_RST		0
#define RESET_VSP_AHB_AXI_MM_VSP_EMC_SOFT_RST	1
#define RESET_VSP_AHB_VSP_GLB_SOFT_RST		2
#define RESET_VSP_AHB_VSP_SOFT_RST		3
#define RESET_VSP_AHB_VPP_SOFT_RST		4
#define RESET_VSP_AHB_JPG_SOFT_RST		5
#define RESET_VSP_AHB_CPP_SOFT_RST		6
#define RESET_VSP_AHB_CPP_PATH0_SOFT_RST	7
#define RESET_VSP_AHB_CPP_PATH1_SOFT_RST	8
#define RESET_VSP_AHB_CPP_DMA_SOFT_RST		9


#endif /* __DT_BINDINGS_SPRD_SC9863A_RESET_H */
