/* SPDX-License-Identifier: GPL-2.0+ OR MIT
 *
 * UNISOC sc2730 global register file
 *
 * Copyright C 2020, UNISOC Communications Inc.
 */

#ifndef __DT_BINDINGS_SPRD_SC2730_MASK_H
#define __DT_BINDINGS_SPRD_SC2730_MASK_H

#define MASK_ANA_CHIP_ID_LOW                                0xFFFF
#define MASK_ANA_CHIP_ID_HIGH                               0xFFFF
#define MASK_ANA_TYPEC_EN                                   0x4000
#define MASK_ANA_PD_EN                                      0x2000
#define MASK_ANA_TMR_EN                                     0x1000
#define MASK_ANA_FAST_CHG_EN                                0x0800
#define MASK_ANA_BLTC_EN                                    0x0200
#define MASK_ANA_PINREG_EN                                  0x0100
#define MASK_ANA_FGU_EN                                     0x0080
#define MASK_ANA_EFS_EN                                     0x0040
#define MASK_ANA_ADC_EN                                     0x0020
#define MASK_ANA_AUD_EN                                     0x0010
#define MASK_ANA_EIC_EN                                     0x0008
#define MASK_ANA_WDG_EN                                     0x0004
#define MASK_ANA_RTC_EN                                     0x0002
#define MASK_ANA_CAL_EN                                     0x0001
#define MASK_ANA_CLK_PD_SEL                                 0x0400
#define MASK_ANA_CLK_PD_EN                                  0x0200
#define MASK_ANA_CLK_TSEN_ADC_EN                            0x0100
#define MASK_ANA_CLK_AUD_SCLK_EN                            0x0080
#define MASK_ANA_CLK_AUXAD_EN                               0x0040
#define MASK_ANA_CLK_AUXADC_EN                              0x0020
#define MASK_ANA_CLK_CAL_SRC_SEL                            0x0018
#define MASK_ANA_CLK_CAL_EN                                 0x0004
#define MASK_ANA_CLK_AUD_IF_6P5M_EN                         0x0002
#define MASK_ANA_CLK_AUD_IF_EN                              0x0001
#define MASK_ANA_RTC_PD_EN                                  0x8000
#define MASK_ANA_RTC_TYPEC_EN                               0x4000
#define MASK_ANA_RTC_TMR_EN                                 0x2000
#define MASK_ANA_RTC_EFS_EN                                 0x0800
#define MASK_ANA_RTC_BLTC_EN                                0x0080
#define MASK_ANA_RTC_FGU_EN                                 0x0040
#define MASK_ANA_RTC_FAST_CHG_EN                            0x0010
#define MASK_ANA_RTC_EIC_EN                                 0x0008
#define MASK_ANA_RTC_WDG_EN                                 0x0004
#define MASK_ANA_RTC_RTC_EN                                 0x0002
#define MASK_ANA_RTC_ARCH_EN                                0x0001
#define MASK_ANA_AUDRX_SOFT_RST                             0x2000
#define MASK_ANA_AUDTX_SOFT_RST                             0x1000
#define MASK_ANA_BLTC_SOFT_RST                              0x0200
#define MASK_ANA_AUD_SOFT_RST                               0x0100
#define MASK_ANA_EFS_SOFT_RST                               0x0080
#define MASK_ANA_ADC_SOFT_RST                               0x0040
#define MASK_ANA_FGU_SOFT_RST                               0x0010
#define MASK_ANA_EIC_SOFT_RST                               0x0008
#define MASK_ANA_WDG_SOFT_RST                               0x0004
#define MASK_ANA_RTC_SOFT_RST                               0x0002
#define MASK_ANA_CAL_SOFT_RST                               0x0001
#define MASK_ANA_TYPEC_SOFT_RST                             0x0008
#define MASK_ANA_PD_SOFT_RST                                0x0004
#define MASK_ANA_TMR_SOFT_RST                               0x0002
#define MASK_ANA_FAST_CHG_SOFT_RST                          0x0001
#define MASK_ANA_DCDC_SRAM_PD                               0x2000
#define MASK_ANA_DCDC_MEMQ_PD                               0x1000
#define MASK_ANA_DCDC_MODEM_PD                              0x0800
#define MASK_ANA_LDO_VDD18_DCXO_PD                          0x0400
#define MASK_ANA_LDO_EMM_PD                                 0x0200
#define MASK_ANA_DCDC_GEN0_PD                               0x0100
#define MASK_ANA_DCDC_GEN1_PD                               0x0080
#define MASK_ANA_DCDC_MEM_PD                                0x0040
#define MASK_ANA_DCDC_CORE_PD                               0x0020
#define MASK_ANA_DCDC_CPU_PD                                0x0010
#define MASK_ANA_DCDC_GPU_PD                                0x0008
#define MASK_ANA_LDO_AVDD18_PD                              0x0004
#define MASK_ANA_LDO_VDD28_PD                               0x0002
#define MASK_ANA_BG_PD                                      0x0001
#define MASK_ANA_PWR_OFF_SEQ_EN                             0x0001
#define MASK_ANA_REG_SOFT_RST                               0x0001
#define MASK_ANA_DCDC_CPU_DEADTIME                          0xC000
#define MASK_ANA_DCDC_CPU_PDRSLOW                           0x00F0
#define MASK_ANA_DCDC_CPU_PFMB                              0x0004
#define MASK_ANA_DCDC_CPU_DCMB                              0x0002
#define MASK_ANA_DCDC_CPU_CF                                0x0030
#define MASK_ANA_DCDC_CPU_CL_CTRL                           0x0003
#define MASK_ANA_DCDC_CPU_STBOP                             0x1FC0
#define MASK_ANA_DCDC_CPU_ZCD                               0x0030
#define MASK_ANA_DCDC_CPU_PFMAD                             0x000F
#define MASK_ANA_CLK_SEL_CPU                                0x8000
#define MASK_ANA_FRACTION_DIV_CPU                           0x7800
#define MASK_ANA_INTEGER_DIV_CPU                            0x0600
#define MASK_ANA_DCDC_CPU_CTRL                              0x01FF
#define MASK_ANA_DCDC_GPU_DEADTIME                          0xC000
#define MASK_ANA_DCDC_GPU_PDRSLOW                           0x00F0
#define MASK_ANA_DCDC_GPU_PFMB                              0x0004
#define MASK_ANA_DCDC_GPU_DCMB                              0x0002
#define MASK_ANA_DCDC_GPU_CF                                0x0030
#define MASK_ANA_DCDC_GPU_CL_CTRL                           0x0003
#define MASK_ANA_DCDC_GPU_STBOP                             0x1FC0
#define MASK_ANA_DCDC_GPU_ZCD                               0x0030
#define MASK_ANA_DCDC_GPU_PFMAD                             0x000F
#define MASK_ANA_CLK_SEL_GPU                                0x8000
#define MASK_ANA_FRACTION_DIV_GPU                           0x7800
#define MASK_ANA_INTEGER_DIV_GPU                            0x0600
#define MASK_ANA_DCDC_GPU_CTRL                              0x01FF
#define MASK_ANA_DCDC_CORE_DEADTIME                         0xC000
#define MASK_ANA_DCDC_CORE_PDRSLOW                          0x00F0
#define MASK_ANA_DCDC_CORE_PFMB                             0x0004
#define MASK_ANA_DCDC_CORE_DCMB                             0x0002
#define MASK_ANA_DCDC_CORE_CF                               0x0030
#define MASK_ANA_DCDC_CORE_CL_CTRL                          0x0003
#define MASK_ANA_DCDC_CORE_STBOP                            0x1FC0
#define MASK_ANA_DCDC_CORE_ZCD                              0x0030
#define MASK_ANA_DCDC_CORE_PFMAD                            0x000F
#define MASK_ANA_CLK_SEL_CORE                               0x8000
#define MASK_ANA_FRACTION_DIV_CORE                          0x7800
#define MASK_ANA_INTEGER_DIV_CORE                           0x0600
#define MASK_ANA_DCDC_CORE_CTRL                             0x01FF
#define MASK_ANA_DCDC_MODEM_DEADTIME                        0xC000
#define MASK_ANA_DCDC_MODEM_PDRSLOW                         0x00F0
#define MASK_ANA_DCDC_MODEM_PFMB                            0x0004
#define MASK_ANA_DCDC_MODEM_DCMB                            0x0002
#define MASK_ANA_DCDC_MODEM_CF                              0x0030
#define MASK_ANA_DCDC_MODEM_CL_CTRL                         0x0003
#define MASK_ANA_DCDC_MODEM_STBOP                           0x1FC0
#define MASK_ANA_DCDC_MODEM_ZCD                             0x0030
#define MASK_ANA_DCDC_MODEM_PFMAD                           0x000F
#define MASK_ANA_CLK_SEL_MODEM                              0x8000
#define MASK_ANA_FRACTION_DIV_MODEM                         0x7800
#define MASK_ANA_INTEGER_DIV_MODEM                          0x0600
#define MASK_ANA_DCDC_MODEM_CTRL                            0x01FF
#define MASK_ANA_DCDC_MEM_DEADTIME                          0xC000
#define MASK_ANA_DCDC_MEM_PDRSLOW                           0x00F0
#define MASK_ANA_DCDC_MEM_PFMB                              0x0004
#define MASK_ANA_DCDC_MEM_DCMB                              0x0002
#define MASK_ANA_DCDC_MEM_CF                                0x0030
#define MASK_ANA_DCDC_MEM_CL_CTRL                           0x0003
#define MASK_ANA_DCDC_MEM_STBOP                             0x1FC0
#define MASK_ANA_DCDC_MEM_ZCD                               0x0030
#define MASK_ANA_DCDC_MEM_PFMAD                             0x000F
#define MASK_ANA_DCDC_MEM_CTRL                              0x00FF
#define MASK_ANA_DCDC_MEMQ_DEADTIME                         0xC000
#define MASK_ANA_DCDC_MEMQ_PDRSLOW                          0x00F0
#define MASK_ANA_DCDC_MEMQ_PFMB                             0x0004
#define MASK_ANA_DCDC_MEMQ_DCMB                             0x0002
#define MASK_ANA_DCDC_MEMQ_CF                               0x0030
#define MASK_ANA_DCDC_MEMQ_CL_CTRL                          0x0003
#define MASK_ANA_DCDC_MEMQ_STBOP                            0x1FC0
#define MASK_ANA_DCDC_MEMQ_ZCD                              0x0030
#define MASK_ANA_DCDC_MEMQ_PFMAD                            0x000F
#define MASK_ANA_DCDC_MEMQ_CTRL                             0x01FF
#define MASK_ANA_DCDC_GEN0_DEADTIME                         0xC000
#define MASK_ANA_DCDC_GEN0_PDRSLOW                          0x00F0
#define MASK_ANA_DCDC_GEN0_PFMB                             0x0004
#define MASK_ANA_DCDC_GEN0_DCMB                             0x0002
#define MASK_ANA_DCDC_GEN0_CF                               0x0030
#define MASK_ANA_DCDC_GEN0_CL_CTRL                          0x0003
#define MASK_ANA_DCDC_GEN0_STBOP                            0x1FC0
#define MASK_ANA_DCDC_GEN0_ZCD                              0x0030
#define MASK_ANA_DCDC_GEN0_PFMAD                            0x000F
#define MASK_ANA_DCDC_GEN0_CTRL                             0x00FF
#define MASK_ANA_DCDC_GEN1_DEADTIME                         0xC000
#define MASK_ANA_DCDC_GEN1_PDRSLOW                          0x00F0
#define MASK_ANA_DCDC_GEN1_PFMB                             0x0004
#define MASK_ANA_DCDC_GEN1_DCMB                             0x0002
#define MASK_ANA_DCDC_GEN1_CF                               0x0030
#define MASK_ANA_DCDC_GEN1_CL_CTRL                          0x0003
#define MASK_ANA_DCDC_GEN1_STBOP                            0x1FC0
#define MASK_ANA_DCDC_GEN1_ZCD                              0x0030
#define MASK_ANA_DCDC_GEN1_PFMAD                            0x000F
#define MASK_ANA_DCDC_GEN1_CTRL                             0x00FF
#define MASK_ANA_DCDC_WPA_DEADTIME                          0xC000
#define MASK_ANA_DCDC_WPA_PDRSLOW                           0x00F0
#define MASK_ANA_DCDC_WPA_CF                                0x000C
#define MASK_ANA_DCDC_WPA_CL_CTRL                           0x0003
#define MASK_ANA_DCDC_WPA_BPOUT_SOFTW                       0x8000
#define MASK_ANA_DCDC_WPA_VBAT_DIV                          0x7000
#define MASK_ANA_DCDC_WPA_BPEN                              0x0800
#define MASK_ANA_DCDC_WPA_BPMODE                            0x0400
#define MASK_ANA_DCDC_WPA_DEGEN                             0x0200
#define MASK_ANA_DCDC_WPA_APTEN                             0x0100
#define MASK_ANA_DCDC_WPA_DEBC_SEL                          0x00C0
#define MASK_ANA_DCDC_WPA_FRTHRD                            0x0030
#define MASK_ANA_DCDC_WPA_FREN                              0x0008
#define MASK_ANA_DCDC_WPA_DEG_CUR_SEL                       0x0004
#define MASK_ANA_DCDC_WPA_PFMB                              0x0002
#define MASK_ANA_DCDC_WPA_APT2P5XEN                         0x0001
#define MASK_ANA_DCDC_WPA_PD                                0x0020
#define MASK_ANA_DCDC_WPA_VREF_CAL                          0x001F
#define MASK_ANA_DCDC_WPA_STBOP                             0x1FC0
#define MASK_ANA_DCDC_WPA_ZCD                               0x0030
#define MASK_ANA_DCDC_WPA_PFMAD                             0x000F
#define MASK_ANA_DCDC_WPA_FR_CUR_CTRL                       0x0C00
#define MASK_ANA_DCDC_WPA_FR_EMI_CTRL                       0x0300
#define MASK_ANA_DCDC_WPA_CTRL                              0x00FF
#define MASK_ANA_DCDC_WPA_DCMB                              0x0001
#define MASK_ANA_DCDC_SRAM_DEADTIME                         0xC000
#define MASK_ANA_DCDC_SRAM_PDRSLOW                          0x00F0
#define MASK_ANA_DCDC_SRAM_PFMB                             0x0004
#define MASK_ANA_DCDC_SRAM_DCMB                             0x0002
#define MASK_ANA_DCDC_SRAM_CF                               0x0030
#define MASK_ANA_DCDC_SRAM_CL_CTRL                          0x0003
#define MASK_ANA_DCDC_SRAM_STBOP                            0x1FC0
#define MASK_ANA_DCDC_SRAM_ZCD                              0x0030
#define MASK_ANA_DCDC_SRAM_PFMAD                            0x000F
#define MASK_ANA_DCDC_SRAM_CTRL                             0x01FF
#define MASK_ANA_DCDC_CAL_SEL                               0x000F
#define MASK_ANA_DCDC_OSCCLK_OPTION                         0x1800
#define MASK_ANA_DCDC_ILIMITCAL                             0x07C0
#define MASK_ANA_DCDC_CLSEL                                 0x0020
#define MASK_ANA_DCDC_6MCLKOUT_EN                           0x2000
#define MASK_ANA_DCDC_6MFRECAL_SW                           0x0F80
#define MASK_ANA_DCDC_CLK_SP_SEL                            0x0002
#define MASK_ANA_DCDC_CLK_SP_EN                             0x0001
#define MASK_ANA_LDO_AVDD18_V                               0x003F
#define MASK_ANA_LDO_AVDD18_SHPT_PD                         0x0020
#define MASK_ANA_LDO_AVDD18_REFTRIM                         0x001F
#define MASK_ANA_LDO_VDDRF1V8_PD                            0x0001
#define MASK_ANA_LDO_VDDRF1V8_V                             0x003F
#define MASK_ANA_LDO_VDDRF1V8_SHPT_PD                       0x0020
#define MASK_ANA_LDO_VDDRF1V8_REFTRIM                       0x001F
#define MASK_ANA_LDO_VDDCAMIO_PD                            0x0001
#define MASK_ANA_LDO_VDDWCN_PD                              0x0001
#define MASK_ANA_LDO_VDDWCN_V                               0x003F
#define MASK_ANA_LDO_VDDWCN_SHPT_PD                         0x0020
#define MASK_ANA_LDO_VDDWCN_REFTRIM                         0x001F
#define MASK_ANA_LDO_VDDCAMD1_PD                            0x0001
#define MASK_ANA_LDO_VDDCAMD1_V                             0x001F
#define MASK_ANA_LDO_VDDCAMD1_SHPT_PD                       0x0020
#define MASK_ANA_LDO_VDDCAMD1_REFTRIM                       0x001F
#define MASK_ANA_LDO_VDDCAMD0_PD                            0x0001
#define MASK_ANA_LDO_VDDCAMD0_V                             0x001F
#define MASK_ANA_LDO_VDDCAMD0_SHPT_PD                       0x0020
#define MASK_ANA_LDO_VDDCAMD0_REFTRIM                       0x001F
#define MASK_ANA_LDO_VDDRF1V25_PD                           0x0001
#define MASK_ANA_LDO_VDDRF1V25_V                            0x001F
#define MASK_ANA_LDO_VDDRF1V25_SHPT_PD                      0x0020
#define MASK_ANA_LDO_VDDRF1V25_REFTRIM                      0x001F
#define MASK_ANA_LDO_AVDD12_PD                              0x0001
#define MASK_ANA_LDO_AVDD12_V                               0x001F
#define MASK_ANA_LDO_AVDD12_SHPT_PD                         0x0020
#define MASK_ANA_LDO_AVDD12_REFTRIM                         0x001F
#define MASK_ANA_LDO_VDDCAMA0_PD                            0x0001
#define MASK_ANA_LDO_VDDCAMA0_V                             0x00FF
#define MASK_ANA_LDO_VDDCAMA0_REFTRIM                       0x007C
#define MASK_ANA_LDO_VDDCAMA0_SHPT_PD                       0x0002
#define MASK_ANA_LDO_VDDCAMA1_PD                            0x0001
#define MASK_ANA_LDO_VDDCAMA1_V                             0x00FF
#define MASK_ANA_LDO_VDDCAMA1_REFTRIM                       0x007C
#define MASK_ANA_LDO_VDDCAMA1_SHPT_PD                       0x0002
#define MASK_ANA_LDO_VDDCAMMOT_PD                           0x0001
#define MASK_ANA_LDO_VDDCAMMOT_V                            0x00FF
#define MASK_ANA_LDO_VDDCAMMOT_SHPT_PD                      0x0040
#define MASK_ANA_LDO_VDDCAMMOT_REFTRIM                      0x003E
#define MASK_ANA_LDO_VDDSIM0_PD                             0x0001
#define MASK_ANA_LDO_VDDSIM0_V                              0x00FF
#define MASK_ANA_LDO_VDDSIM0_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDSIM0_REFTRIM                        0x003E
#define MASK_ANA_LDO_VDDSIM1_PD                             0x0001
#define MASK_ANA_LDO_VDDSIM1_V                              0x00FF
#define MASK_ANA_LDO_VDDSIM1_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDSIM1_REFTRIM                        0x003E
#define MASK_ANA_LDO_VDDSIM2_PD                             0x0001
#define MASK_ANA_LDO_VDDSIM2_V                              0x00FF
#define MASK_ANA_LDO_VDDSIM2_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDSIM2_REFTRIM                        0x003E
#define MASK_ANA_LDO_VDDEMMCCORE_PD                         0x0001
#define MASK_ANA_LDO_VDDEMMCCORE_V                          0x00FF
#define MASK_ANA_LDO_VDDEMMCCORE_SHPT_PD                    0x0040
#define MASK_ANA_LDO_VDDEMMCCORE_REFTRIM                    0x003E
#define MASK_ANA_LDO_VDDSDCORE_PD                           0x0001
#define MASK_ANA_LDO_VDDSDCORE_V                            0x00FF
#define MASK_ANA_LDO_VDDSDCORE_CL_ADJ                       0x0F80
#define MASK_ANA_LDO_VDDSDCORE_SHPT_PD                      0x0040
#define MASK_ANA_LDO_VDDSDCORE_REFTRIM                      0x003E
#define MASK_ANA_LDO_VDDSDIO_PD                             0x0001
#define MASK_ANA_LDO_VDDSDIO_V                              0x00FF
#define MASK_ANA_LDO_VDDSDIO_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDSDIO_REFTRIM                        0x003E
#define MASK_ANA_LDO_VDD28_V                                0x00FF
#define MASK_ANA_LDO_VDD28_SHPT_PD                          0x0040
#define MASK_ANA_LDO_VDD28_REFTRIM                          0x003E
#define MASK_ANA_LDO_VDDWIFIPA_PD                           0x0001
#define MASK_ANA_LDO_VDDWIFIPA_V                            0x00FF
#define MASK_ANA_LDO_VDDWIFIPA_SHPT_PD                      0x0040
#define MASK_ANA_LDO_VDDWIFIPA_REFTRIM                      0x003E
#define MASK_ANA_LDO_VDD18_DCXO_V                           0x00FF
#define MASK_ANA_LDO_VDD18_DCXO_REFTRIM_LP                  0x0780
#define MASK_ANA_LDO_VDD18_DCXO_SHPT_PD                     0x0040
#define MASK_ANA_LDO_VDD18_DCXO_REFTRIM                     0x003E
#define MASK_ANA_LDO_VDDUSB33_PD                            0x0001
#define MASK_ANA_LDO_VDDUSB33_V                             0x00FF
#define MASK_ANA_LDO_VDDUSB33_SHPT_PD                       0x0040
#define MASK_ANA_LDO_VDDUSB33_REFTRIM                       0x003E
#define MASK_ANA_LDO_VDDLDO0_PD                             0x0001
#define MASK_ANA_LDO_VDDLDO0_V                              0x00FF
#define MASK_ANA_LDO_VDDLDO0_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDLDO0_REFTRIM                        0x003E
#define MASK_ANA_LDO_VDDLDO1_PD                             0x0001
#define MASK_ANA_LDO_VDDLDO1_V                              0x00FF
#define MASK_ANA_LDO_VDDLDO1_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDLDO1_REFTRIM                        0x003E
#define MASK_ANA_LDO_VDDLDO2_PD                             0x0001
#define MASK_ANA_LDO_VDDLDO2_V                              0x00FF
#define MASK_ANA_LDO_VDDLDO2_SHPT_PD                        0x0040
#define MASK_ANA_LDO_VDDLDO2_REFTRIM                        0x003E
#define MASK_ANA_RC1M_CAL                                   0xFE00
#define MASK_ANA_LDO_RTC_CAL                                0x01F0
#define MASK_ANA_LDO_RTC_V                                  0x000C
#define MASK_ANA_VBATBK_V                                   0x0003
#define MASK_ANA_LDODCDC_CAL_SEL                            0x3800
#define MASK_ANA_LDOA_CAL_SEL                               0x0780
#define MASK_ANA_LDOB_CAL_SEL                               0x0070
#define MASK_ANA_SLP_IN_WAIT_DCDCCPU                        0xFF00
#define MASK_ANA_SLP_OUT_WAIT_DCDCCPU                       0x00FF
#define MASK_ANA_LDO_XTL_EN                                 0x0004
#define MASK_ANA_SLP_IO_EN                                  0x0002
#define MASK_ANA_SLP_LDO_PD_EN                              0x0001
#define MASK_ANA_SLP_DCDCMODEM_PD_EN                        0x0400
#define MASK_ANA_SLP_DCDCMEMQ_PD_EN                         0x0200
#define MASK_ANA_SLP_DCDCSRAM_PD_EN                         0x0100
#define MASK_ANA_SLP_DCDCSRAM_DROP_EN                       0x0080
#define MASK_ANA_SLP_DCDCMODEM_DROP_EN                      0x0040
#define MASK_ANA_SLP_DCDCGPU_DROP_EN                        0x0020
#define MASK_ANA_SLP_DCDCCORE_DROP_EN                       0x0010
#define MASK_ANA_SLP_DCDCWPA_PD_EN                          0x0008
#define MASK_ANA_SLP_DCDCGPU_PD_EN                          0x0004
#define MASK_ANA_SLP_DCDCCPU_PD_EN                          0x0002
#define MASK_ANA_SLP_DCDCGEN1_PD_EN                         0x0001
#define MASK_ANA_SLP_LDO_VDDRF1V8_PD_EN                     0x4000
#define MASK_ANA_SLP_LDO_VDDRF1V25_PD_EN                    0x2000
#define MASK_ANA_SLP_LDO_VDDEMMCCORE_PD_EN                  0x1000
#define MASK_ANA_SLP_LDO_VDD18_DCXO_PD_EN                   0x0800
#define MASK_ANA_SLP_LDO_VDDWIFIPA_PD_EN                    0x0400
#define MASK_ANA_SLP_LDO_VDD28_PD_EN                        0x0200
#define MASK_ANA_SLP_LDO_VDDSDCORE_PD_EN                    0x0100
#define MASK_ANA_SLP_LDO_VDDSDIO_PD_EN                      0x0080
#define MASK_ANA_SLP_LDO_VDDUSB33_PD_EN                     0x0040
#define MASK_ANA_SLP_LDO_VDDCAMMOT_PD_EN                    0x0020
#define MASK_ANA_SLP_LDO_VDDCAMIO_PD_EN                     0x0010
#define MASK_ANA_SLP_LDO_VDDCAMD0_PD_EN                     0x0008
#define MASK_ANA_SLP_LDO_VDDCAMA0_PD_EN                     0x0004
#define MASK_ANA_SLP_LDO_VDDSIM2_PD_EN                      0x0002
#define MASK_ANA_SLP_LDO_VDDSIM1_PD_EN                      0x0001
#define MASK_ANA_SLP_LDO_VDDLDO2_PD_EN                      0x0100
#define MASK_ANA_SLP_LDO_AVDD12_PD_EN                       0x0080
#define MASK_ANA_SLP_LDO_VDDWCN_PD_EN                       0x0040
#define MASK_ANA_SLP_LDO_VDDLDO0_PD_EN                      0x0020
#define MASK_ANA_SLP_LDO_VDDCAMD1_PD_EN                     0x0010
#define MASK_ANA_SLP_LDO_VDDCAMA1_PD_EN                     0x0008
#define MASK_ANA_SLP_LDO_VDDSIM0_PD_EN                      0x0004
#define MASK_ANA_SLP_LDO_AVDD18_PD_EN                       0x0002
#define MASK_ANA_SLP_LDO_VDDLDO1_PD_EN                      0x0001
#define MASK_ANA_SLP_DCDCSRAM_LP_EN                         0x0200
#define MASK_ANA_SLP_DCDCMODEM_LP_EN                        0x0100
#define MASK_ANA_SLP_DCDCMEMQ_LP_EN                         0x0080
#define MASK_ANA_SLP_DCDCMEM_LP_EN                          0x0040
#define MASK_ANA_SLP_DCDCGPU_LP_EN                          0x0020
#define MASK_ANA_SLP_DCDCCORE_LP_EN                         0x0010
#define MASK_ANA_SLP_DCDCCPU_LP_EN                          0x0008
#define MASK_ANA_SLP_DCDCGEN1_LP_EN                         0x0004
#define MASK_ANA_SLP_DCDCGEN0_LP_EN                         0x0002
#define MASK_ANA_SLP_DCDCWPA_LP_EN                          0x0001
#define MASK_ANA_SLP_LDO_VDDRF1V8_LP_EN                     0x4000
#define MASK_ANA_SLP_LDO_VDDRF1V25_LP_EN                    0x2000
#define MASK_ANA_SLP_LDO_VDDEMMCCORE_LP_EN                  0x1000
#define MASK_ANA_SLP_LDO_VDD18_DCXO_LP_EN                   0x0800
#define MASK_ANA_SLP_LDO_VDDWIFIPA_LP_EN                    0x0400
#define MASK_ANA_SLP_LDO_VDD28_LP_EN                        0x0200
#define MASK_ANA_SLP_LDO_VDDSDCORE_LP_EN                    0x0100
#define MASK_ANA_SLP_LDO_VDDSDIO_LP_EN                      0x0080
#define MASK_ANA_SLP_LDO_VDDUSB33_LP_EN                     0x0040
#define MASK_ANA_SLP_LDO_VDDCAMMOT_LP_EN                    0x0020
#define MASK_ANA_SLP_LDO_VDDCAMD0_LP_EN                     0x0008
#define MASK_ANA_SLP_LDO_VDDCAMA0_LP_EN                     0x0004
#define MASK_ANA_SLP_LDO_VDDSIM2_LP_EN                      0x0002
#define MASK_ANA_SLP_LDO_VDDSIM1_LP_EN                      0x0001
#define MASK_ANA_SLP_LDO_VDDLDO2_LP_EN                      0x0100
#define MASK_ANA_SLP_LDO_AVDD12_LP_EN                       0x0080
#define MASK_ANA_SLP_LDO_VDDWCN_LP_EN                       0x0040
#define MASK_ANA_SLP_LDO_VDDCAMD1_LP_EN                     0x0020
#define MASK_ANA_SLP_LDO_VDDCAMA1_LP_EN                     0x0010
#define MASK_ANA_SLP_LDO_VDDLDO0_LP_EN                      0x0008
#define MASK_ANA_SLP_LDO_VDDSIM0_LP_EN                      0x0004
#define MASK_ANA_SLP_LDO_AVDD18_LP_EN                       0x0002
#define MASK_ANA_SLP_LDO_VDDLDO1_LP_EN                      0x0001
#define MASK_ANA_DCDC_CORE_SLP_STEP_DELAY                   0x3000
#define MASK_ANA_DCDC_CORE_SLP_STEP_NUM                     0x0F00
#define MASK_ANA_DCDC_CORE_SLP_STEP_VOL                     0x00F8
#define MASK_ANA_DCDC_CORE_SLP_STEP_EN                      0x0001
#define MASK_ANA_DCDC_CORE_CTRL_DS_SW                       0x01FF
#define MASK_ANA_DCDC_GPU_SLP_STEP_DELAY                    0x3000
#define MASK_ANA_DCDC_GPU_SLP_STEP_NUM                      0x0F00
#define MASK_ANA_DCDC_GPU_SLP_STEP_VOL                      0x00F8
#define MASK_ANA_DCDC_GPU_SLP_STEP_EN                       0x0001
#define MASK_ANA_DCDC_GPU_CTRL_DS_SW                        0x01FF
#define MASK_ANA_DCDC_MODEM_SLP_STEP_DELAY                  0x3000
#define MASK_ANA_DCDC_MODEM_SLP_STEP_NUM                    0x0F00
#define MASK_ANA_DCDC_MODEM_SLP_STEP_VOL                    0x00F8
#define MASK_ANA_DCDC_MODEM_SLP_STEP_EN                     0x0001
#define MASK_ANA_DCDC_MODEM_CTRL_DS_SW                      0x01FF
#define MASK_ANA_DCDC_SRAM_SLP_STEP_DELAY                   0x3000
#define MASK_ANA_DCDC_SRAM_SLP_STEP_NUM                     0x0F00
#define MASK_ANA_DCDC_SRAM_SLP_STEP_VOL                     0x00F8
#define MASK_ANA_DCDC_SRAM_SLP_STEP_EN                      0x0001
#define MASK_ANA_DCDC_SRAM_CTRL_DS_SW                       0x01FF
#define MASK_ANA_DCDC_CORE_EXT_XTL0_EN                      0x8000
#define MASK_ANA_DCDC_CORE_EXT_XTL1_EN                      0x4000
#define MASK_ANA_DCDC_CORE_EXT_XTL2_EN                      0x2000
#define MASK_ANA_DCDC_CORE_EXT_XTL3_EN                      0x1000
#define MASK_ANA_DCDC_CORE_EXT_XTL4_EN                      0x0800
#define MASK_ANA_DCDC_CORE_EXT_XTL5_EN                      0x0400
#define MASK_ANA_DCDC_WPA_EXT_XTL0_EN                       0x0020
#define MASK_ANA_DCDC_WPA_EXT_XTL1_EN                       0x0010
#define MASK_ANA_DCDC_WPA_EXT_XTL2_EN                       0x0008
#define MASK_ANA_DCDC_WPA_EXT_XTL3_EN                       0x0004
#define MASK_ANA_DCDC_WPA_EXT_XTL4_EN                       0x0002
#define MASK_ANA_DCDC_WPA_EXT_XTL5_EN                       0x0001
#define MASK_ANA_DCDC_GEN0_EXT_XTL0_EN                      0x8000
#define MASK_ANA_DCDC_GEN0_EXT_XTL1_EN                      0x4000
#define MASK_ANA_DCDC_GEN0_EXT_XTL2_EN                      0x2000
#define MASK_ANA_DCDC_GEN0_EXT_XTL3_EN                      0x1000
#define MASK_ANA_DCDC_GEN0_EXT_XTL4_EN                      0x0800
#define MASK_ANA_DCDC_GEN0_EXT_XTL5_EN                      0x0400
#define MASK_ANA_DCDC_SRAM_EXT_XTL0_EN                      0x0020
#define MASK_ANA_DCDC_SRAM_EXT_XTL1_EN                      0x0010
#define MASK_ANA_DCDC_SRAM_EXT_XTL2_EN                      0x0008
#define MASK_ANA_DCDC_SRAM_EXT_XTL3_EN                      0x0004
#define MASK_ANA_DCDC_SRAM_EXT_XTL4_EN                      0x0002
#define MASK_ANA_DCDC_SRAM_EXT_XTL5_EN                      0x0001
#define MASK_ANA_DCDC_CPU_EXT_XTL0_EN                       0x8000
#define MASK_ANA_DCDC_CPU_EXT_XTL1_EN                       0x4000
#define MASK_ANA_DCDC_CPU_EXT_XTL2_EN                       0x2000
#define MASK_ANA_DCDC_CPU_EXT_XTL3_EN                       0x1000
#define MASK_ANA_DCDC_CPU_EXT_XTL4_EN                       0x0800
#define MASK_ANA_DCDC_CPU_EXT_XTL5_EN                       0x0400
#define MASK_ANA_DCDC_GPU_EXT_XTL0_EN                       0x0020
#define MASK_ANA_DCDC_GPU_EXT_XTL1_EN                       0x0010
#define MASK_ANA_DCDC_GPU_EXT_XTL2_EN                       0x0008
#define MASK_ANA_DCDC_GPU_EXT_XTL3_EN                       0x0004
#define MASK_ANA_DCDC_GPU_EXT_XTL4_EN                       0x0002
#define MASK_ANA_DCDC_GPU_EXT_XTL5_EN                       0x0001
#define MASK_ANA_DCDC_MEM_EXT_XTL0_EN                       0x8000
#define MASK_ANA_DCDC_MEM_EXT_XTL1_EN                       0x4000
#define MASK_ANA_DCDC_MEM_EXT_XTL2_EN                       0x2000
#define MASK_ANA_DCDC_MEM_EXT_XTL3_EN                       0x1000
#define MASK_ANA_DCDC_MEM_EXT_XTL4_EN                       0x0800
#define MASK_ANA_DCDC_MEM_EXT_XTL5_EN                       0x0400
#define MASK_ANA_DCDC_GEN1_EXT_XTL0_EN                      0x0020
#define MASK_ANA_DCDC_GEN1_EXT_XTL1_EN                      0x0010
#define MASK_ANA_DCDC_GEN1_EXT_XTL2_EN                      0x0008
#define MASK_ANA_DCDC_GEN1_EXT_XTL3_EN                      0x0004
#define MASK_ANA_DCDC_GEN1_EXT_XTL4_EN                      0x0002
#define MASK_ANA_DCDC_GEN1_EXT_XTL5_EN                      0x0001
#define MASK_ANA_DCDC_MEMQ_EXT_XTL0_EN                      0x8000
#define MASK_ANA_DCDC_MEMQ_EXT_XTL1_EN                      0x4000
#define MASK_ANA_DCDC_MEMQ_EXT_XTL2_EN                      0x2000
#define MASK_ANA_DCDC_MEMQ_EXT_XTL3_EN                      0x1000
#define MASK_ANA_DCDC_MEMQ_EXT_XTL4_EN                      0x0800
#define MASK_ANA_DCDC_MEMQ_EXT_XTL5_EN                      0x0400
#define MASK_ANA_DCDC_MODEM_EXT_XTL0_EN                     0x0020
#define MASK_ANA_DCDC_MODEM_EXT_XTL1_EN                     0x0010
#define MASK_ANA_DCDC_MODEM_EXT_XTL2_EN                     0x0008
#define MASK_ANA_DCDC_MODEM_EXT_XTL3_EN                     0x0004
#define MASK_ANA_DCDC_MODEM_EXT_XTL4_EN                     0x0002
#define MASK_ANA_DCDC_MODEM_EXT_XTL5_EN                     0x0001
#define MASK_ANA_LDO_VDD18_DCXO_EXT_XTL0_EN                 0x8000
#define MASK_ANA_LDO_VDD18_DCXO_EXT_XTL1_EN                 0x4000
#define MASK_ANA_LDO_VDD18_DCXO_EXT_XTL2_EN                 0x2000
#define MASK_ANA_LDO_VDD18_DCXO_EXT_XTL3_EN                 0x1000
#define MASK_ANA_LDO_VDD18_DCXO_EXT_XTL4_EN                 0x0800
#define MASK_ANA_LDO_VDD18_DCXO_EXT_XTL5_EN                 0x0400
#define MASK_ANA_LDO_VDD28_EXT_XTL0_EN                      0x0020
#define MASK_ANA_LDO_VDD28_EXT_XTL1_EN                      0x0010
#define MASK_ANA_LDO_VDD28_EXT_XTL2_EN                      0x0008
#define MASK_ANA_LDO_VDD28_EXT_XTL3_EN                      0x0004
#define MASK_ANA_LDO_VDD28_EXT_XTL4_EN                      0x0002
#define MASK_ANA_LDO_VDD28_EXT_XTL5_EN                      0x0001
#define MASK_ANA_LDO_VDDRF1V8_EXT_XTL0_EN                   0x8000
#define MASK_ANA_LDO_VDDRF1V8_EXT_XTL1_EN                   0x4000
#define MASK_ANA_LDO_VDDRF1V8_EXT_XTL2_EN                   0x2000
#define MASK_ANA_LDO_VDDRF1V8_EXT_XTL3_EN                   0x1000
#define MASK_ANA_LDO_VDDRF1V8_EXT_XTL4_EN                   0x0800
#define MASK_ANA_LDO_VDDRF1V8_EXT_XTL5_EN                   0x0400
#define MASK_ANA_LDO_VDDRF1V25_EXT_XTL0_EN                  0x0020
#define MASK_ANA_LDO_VDDRF1V25_EXT_XTL1_EN                  0x0010
#define MASK_ANA_LDO_VDDRF1V25_EXT_XTL2_EN                  0x0008
#define MASK_ANA_LDO_VDDRF1V25_EXT_XTL3_EN                  0x0004
#define MASK_ANA_LDO_VDDRF1V25_EXT_XTL4_EN                  0x0002
#define MASK_ANA_LDO_VDDRF1V25_EXT_XTL5_EN                  0x0001
#define MASK_ANA_LDO_VDDSIM0_EXT_XTL0_EN                    0x8000
#define MASK_ANA_LDO_VDDSIM0_EXT_XTL1_EN                    0x4000
#define MASK_ANA_LDO_VDDSIM0_EXT_XTL2_EN                    0x2000
#define MASK_ANA_LDO_VDDSIM0_EXT_XTL3_EN                    0x1000
#define MASK_ANA_LDO_VDDSIM0_EXT_XTL4_EN                    0x0800
#define MASK_ANA_LDO_VDDSIM0_EXT_XTL5_EN                    0x0400
#define MASK_ANA_LDO_VDDSIM1_EXT_XTL0_EN                    0x0020
#define MASK_ANA_LDO_VDDSIM1_EXT_XTL1_EN                    0x0010
#define MASK_ANA_LDO_VDDSIM1_EXT_XTL2_EN                    0x0008
#define MASK_ANA_LDO_VDDSIM1_EXT_XTL3_EN                    0x0004
#define MASK_ANA_LDO_VDDSIM1_EXT_XTL4_EN                    0x0002
#define MASK_ANA_LDO_VDDSIM1_EXT_XTL5_EN                    0x0001
#define MASK_ANA_LDO_VDDSIM2_EXT_XTL0_EN                    0x8000
#define MASK_ANA_LDO_VDDSIM2_EXT_XTL1_EN                    0x4000
#define MASK_ANA_LDO_VDDSIM2_EXT_XTL2_EN                    0x2000
#define MASK_ANA_LDO_VDDSIM2_EXT_XTL3_EN                    0x1000
#define MASK_ANA_LDO_VDDSIM2_EXT_XTL4_EN                    0x0800
#define MASK_ANA_LDO_VDDSIM2_EXT_XTL5_EN                    0x0400
#define MASK_ANA_LDO_AVDD12_EXT_XTL0_EN                     0x0020
#define MASK_ANA_LDO_AVDD12_EXT_XTL1_EN                     0x0010
#define MASK_ANA_LDO_AVDD12_EXT_XTL2_EN                     0x0008
#define MASK_ANA_LDO_AVDD12_EXT_XTL3_EN                     0x0004
#define MASK_ANA_LDO_AVDD12_EXT_XTL4_EN                     0x0002
#define MASK_ANA_LDO_AVDD12_EXT_XTL5_EN                     0x0001
#define MASK_ANA_LDO_VDDCAMMOT_EXT_XTL0_EN                  0x8000
#define MASK_ANA_LDO_VDDCAMMOT_EXT_XTL1_EN                  0x4000
#define MASK_ANA_LDO_VDDCAMMOT_EXT_XTL2_EN                  0x2000
#define MASK_ANA_LDO_VDDCAMMOT_EXT_XTL3_EN                  0x1000
#define MASK_ANA_LDO_VDDCAMMOT_EXT_XTL4_EN                  0x0800
#define MASK_ANA_LDO_VDDCAMMOT_EXT_XTL5_EN                  0x0400
#define MASK_ANA_LDO_VDDCAMIO_EXT_XTL0_EN                   0x0020
#define MASK_ANA_LDO_VDDCAMIO_EXT_XTL1_EN                   0x0010
#define MASK_ANA_LDO_VDDCAMIO_EXT_XTL2_EN                   0x0008
#define MASK_ANA_LDO_VDDCAMIO_EXT_XTL3_EN                   0x0004
#define MASK_ANA_LDO_VDDCAMIO_EXT_XTL4_EN                   0x0002
#define MASK_ANA_LDO_VDDCAMIO_EXT_XTL5_EN                   0x0001
#define MASK_ANA_LDO_VDDCAMA0_EXT_XTL0_EN                   0x8000
#define MASK_ANA_LDO_VDDCAMA0_EXT_XTL1_EN                   0x4000
#define MASK_ANA_LDO_VDDCAMA0_EXT_XTL2_EN                   0x2000
#define MASK_ANA_LDO_VDDCAMA0_EXT_XTL3_EN                   0x1000
#define MASK_ANA_LDO_VDDCAMA0_EXT_XTL4_EN                   0x0800
#define MASK_ANA_LDO_VDDCAMA0_EXT_XTL5_EN                   0x0400
#define MASK_ANA_LDO_VDDCAMA1_EXT_XTL0_EN                   0x0020
#define MASK_ANA_LDO_VDDCAMA1_EXT_XTL1_EN                   0x0010
#define MASK_ANA_LDO_VDDCAMA1_EXT_XTL2_EN                   0x0008
#define MASK_ANA_LDO_VDDCAMA1_EXT_XTL3_EN                   0x0004
#define MASK_ANA_LDO_VDDCAMA1_EXT_XTL4_EN                   0x0002
#define MASK_ANA_LDO_VDDCAMA1_EXT_XTL5_EN                   0x0001
#define MASK_ANA_LDO_VDDCAMD0_EXT_XTL0_EN                   0x8000
#define MASK_ANA_LDO_VDDCAMD0_EXT_XTL1_EN                   0x4000
#define MASK_ANA_LDO_VDDCAMD0_EXT_XTL2_EN                   0x2000
#define MASK_ANA_LDO_VDDCAMD0_EXT_XTL3_EN                   0x1000
#define MASK_ANA_LDO_VDDCAMD0_EXT_XTL4_EN                   0x0800
#define MASK_ANA_LDO_VDDCAMD0_EXT_XTL5_EN                   0x0400
#define MASK_ANA_LDO_VDDCAMD1_EXT_XTL0_EN                   0x0020
#define MASK_ANA_LDO_VDDCAMD1_EXT_XTL1_EN                   0x0010
#define MASK_ANA_LDO_VDDCAMD1_EXT_XTL2_EN                   0x0008
#define MASK_ANA_LDO_VDDCAMD1_EXT_XTL3_EN                   0x0004
#define MASK_ANA_LDO_VDDCAMD1_EXT_XTL4_EN                   0x0002
#define MASK_ANA_LDO_VDDCAMD1_EXT_XTL5_EN                   0x0001
#define MASK_ANA_LDO_VDDSDIO_EXT_XTL0_EN                    0x8000
#define MASK_ANA_LDO_VDDSDIO_EXT_XTL1_EN                    0x4000
#define MASK_ANA_LDO_VDDSDIO_EXT_XTL2_EN                    0x2000
#define MASK_ANA_LDO_VDDSDIO_EXT_XTL3_EN                    0x1000
#define MASK_ANA_LDO_VDDSDIO_EXT_XTL4_EN                    0x0800
#define MASK_ANA_LDO_VDDSDIO_EXT_XTL5_EN                    0x0400
#define MASK_ANA_LDO_VDDSDCORE_EXT_XTL0_EN                  0x0020
#define MASK_ANA_LDO_VDDSDCORE_EXT_XTL1_EN                  0x0010
#define MASK_ANA_LDO_VDDSDCORE_EXT_XTL2_EN                  0x0008
#define MASK_ANA_LDO_VDDSDCORE_EXT_XTL3_EN                  0x0004
#define MASK_ANA_LDO_VDDSDCORE_EXT_XTL4_EN                  0x0002
#define MASK_ANA_LDO_VDDSDCORE_EXT_XTL5_EN                  0x0001
#define MASK_ANA_LDO_VDDEMMCCORE_EXT_XTL0_EN                0x8000
#define MASK_ANA_LDO_VDDEMMCCORE_EXT_XTL1_EN                0x4000
#define MASK_ANA_LDO_VDDEMMCCORE_EXT_XTL2_EN                0x2000
#define MASK_ANA_LDO_VDDEMMCCORE_EXT_XTL3_EN                0x1000
#define MASK_ANA_LDO_VDDEMMCCORE_EXT_XTL4_EN                0x0800
#define MASK_ANA_LDO_VDDEMMCCORE_EXT_XTL5_EN                0x0400
#define MASK_ANA_LDO_VDDUSB33_EXT_XTL0_EN                   0x0020
#define MASK_ANA_LDO_VDDUSB33_EXT_XTL1_EN                   0x0010
#define MASK_ANA_LDO_VDDUSB33_EXT_XTL2_EN                   0x0008
#define MASK_ANA_LDO_VDDUSB33_EXT_XTL3_EN                   0x0004
#define MASK_ANA_LDO_VDDUSB33_EXT_XTL4_EN                   0x0002
#define MASK_ANA_LDO_VDDUSB33_EXT_XTL5_EN                   0x0001
#define MASK_ANA_LDO_VDDKPLED_EXT_XTL0_EN                   0x8000
#define MASK_ANA_LDO_VDDKPLED_EXT_XTL1_EN                   0x4000
#define MASK_ANA_LDO_VDDKPLED_EXT_XTL2_EN                   0x2000
#define MASK_ANA_LDO_VDDKPLED_EXT_XTL3_EN                   0x1000
#define MASK_ANA_LDO_VDDKPLED_EXT_XTL4_EN                   0x0800
#define MASK_ANA_LDO_VDDKPLED_EXT_XTL5_EN                   0x0400
#define MASK_ANA_LDO_VDDVIB_EXT_XTL0_EN                     0x0020
#define MASK_ANA_LDO_VDDVIB_EXT_XTL1_EN                     0x0010
#define MASK_ANA_LDO_VDDVIB_EXT_XTL2_EN                     0x0008
#define MASK_ANA_LDO_VDDVIB_EXT_XTL3_EN                     0x0004
#define MASK_ANA_LDO_VDDVIB_EXT_XTL4_EN                     0x0002
#define MASK_ANA_LDO_VDDVIB_EXT_XTL5_EN                     0x0001
#define MASK_ANA_LDO_VDDWCN_EXT_XTL0_EN                     0x8000
#define MASK_ANA_LDO_VDDWCN_EXT_XTL1_EN                     0x4000
#define MASK_ANA_LDO_VDDWCN_EXT_XTL2_EN                     0x2000
#define MASK_ANA_LDO_VDDWCN_EXT_XTL3_EN                     0x1000
#define MASK_ANA_LDO_VDDWCN_EXT_XTL4_EN                     0x0800
#define MASK_ANA_LDO_VDDWCN_EXT_XTL5_EN                     0x0400
#define MASK_ANA_LDO_AVDD18_EXT_XTL0_EN                     0x0020
#define MASK_ANA_LDO_AVDD18_EXT_XTL1_EN                     0x0010
#define MASK_ANA_LDO_AVDD18_EXT_XTL2_EN                     0x0008
#define MASK_ANA_LDO_AVDD18_EXT_XTL3_EN                     0x0004
#define MASK_ANA_LDO_AVDD18_EXT_XTL4_EN                     0x0002
#define MASK_ANA_LDO_AVDD18_EXT_XTL5_EN                     0x0001
#define MASK_ANA_LDO_VDDLDO0_EXT_XTL0_EN                    0x8000
#define MASK_ANA_LDO_VDDLDO0_EXT_XTL1_EN                    0x4000
#define MASK_ANA_LDO_VDDLDO0_EXT_XTL2_EN                    0x2000
#define MASK_ANA_LDO_VDDLDO0_EXT_XTL3_EN                    0x1000
#define MASK_ANA_LDO_VDDLDO0_EXT_XTL4_EN                    0x0800
#define MASK_ANA_LDO_VDDLDO0_EXT_XTL5_EN                    0x0400
#define MASK_ANA_LDO_VDDWIFIPA_EXT_XTL0_EN                  0x0020
#define MASK_ANA_LDO_VDDWIFIPA_EXT_XTL1_EN                  0x0010
#define MASK_ANA_LDO_VDDWIFIPA_EXT_XTL2_EN                  0x0008
#define MASK_ANA_LDO_VDDWIFIPA_EXT_XTL3_EN                  0x0004
#define MASK_ANA_LDO_VDDWIFIPA_EXT_XTL4_EN                  0x0002
#define MASK_ANA_LDO_VDDWIFIPA_EXT_XTL5_EN                  0x0001
#define MASK_ANA_LDO_VDDLDO2_EXT_XTL0_EN                    0x8000
#define MASK_ANA_LDO_VDDLDO2_EXT_XTL1_EN                    0x4000
#define MASK_ANA_LDO_VDDLDO2_EXT_XTL2_EN                    0x2000
#define MASK_ANA_LDO_VDDLDO2_EXT_XTL3_EN                    0x1000
#define MASK_ANA_LDO_VDDLDO2_EXT_XTL4_EN                    0x0800
#define MASK_ANA_LDO_VDDLDO2_EXT_XTL5_EN                    0x0400
#define MASK_ANA_LDO_VDDLDO1_EXT_XTL0_EN                    0x0020
#define MASK_ANA_LDO_VDDLDO1_EXT_XTL1_EN                    0x0010
#define MASK_ANA_LDO_VDDLDO1_EXT_XTL2_EN                    0x0008
#define MASK_ANA_LDO_VDDLDO1_EXT_XTL3_EN                    0x0004
#define MASK_ANA_LDO_VDDLDO1_EXT_XTL4_EN                    0x0002
#define MASK_ANA_LDO_VDDLDO1_EXT_XTL5_EN                    0x0001
#define MASK_ANA_TSX_XO_EXT_XTL0_EN                         0x8000
#define MASK_ANA_TSX_XO_EXT_XTL1_EN                         0x4000
#define MASK_ANA_TSX_XO_EXT_XTL2_EN                         0x2000
#define MASK_ANA_TSX_XO_EXT_XTL3_EN                         0x1000
#define MASK_ANA_TSX_XO_EXT_XTL4_EN                         0x0800
#define MASK_ANA_TSX_XO_EXT_XTL5_EN                         0x0400
#define MASK_ANA_XO_EXT_XTL0_EN                             0x0020
#define MASK_ANA_XO_EXT_XTL1_EN                             0x0010
#define MASK_ANA_XO_EXT_XTL2_EN                             0x0008
#define MASK_ANA_XO_EXT_XTL3_EN                             0x0004
#define MASK_ANA_XO_EXT_XTL4_EN                             0x0002
#define MASK_ANA_XO_EXT_XTL5_EN                             0x0001
#define MASK_ANA_DCXO_26M_REF_OUT0_PIN_EXT_XTL5_EN          0x8000
#define MASK_ANA_DCXO_26M_REF_OUT0_PIN_EXT_XTL4_EN          0x4000
#define MASK_ANA_DCXO_26M_REF_OUT0_PIN_EXT_XTL3_EN          0x2000
#define MASK_ANA_DCXO_26M_REF_OUT0_PIN_EXT_XTL2_EN          0x1000
#define MASK_ANA_DCXO_26M_REF_OUT0_PIN_EXT_XTL1_EN          0x0800
#define MASK_ANA_DCXO_26M_REF_OUT0_PIN_EXT_XTL0_EN          0x0400
#define MASK_ANA_DCXO_26M_REF_OUT1_PIN_EXT_XTL5_EN          0x0200
#define MASK_ANA_DCXO_26M_REF_OUT1_PIN_EXT_XTL4_EN          0x0100
#define MASK_ANA_DCXO_26M_REF_OUT1_PIN_EXT_XTL3_EN          0x0080
#define MASK_ANA_DCXO_26M_REF_OUT1_PIN_EXT_XTL2_EN          0x0040
#define MASK_ANA_DCXO_26M_REF_OUT1_PIN_EXT_XTL1_EN          0x0020
#define MASK_ANA_DCXO_26M_REF_OUT1_PIN_EXT_XTL0_EN          0x0010
#define MASK_ANA_DCXO_26M_REF_OUT2_PIN_EXT_XTL5_EN          0x8000
#define MASK_ANA_DCXO_26M_REF_OUT2_PIN_EXT_XTL4_EN          0x4000
#define MASK_ANA_DCXO_26M_REF_OUT2_PIN_EXT_XTL3_EN          0x2000
#define MASK_ANA_DCXO_26M_REF_OUT2_PIN_EXT_XTL2_EN          0x1000
#define MASK_ANA_DCXO_26M_REF_OUT2_PIN_EXT_XTL1_EN          0x0800
#define MASK_ANA_DCXO_26M_REF_OUT2_PIN_EXT_XTL0_EN          0x0400
#define MASK_ANA_DCXO_26M_REF_OUT3_PIN_EXT_XTL5_EN          0x0200
#define MASK_ANA_DCXO_26M_REF_OUT3_PIN_EXT_XTL4_EN          0x0100
#define MASK_ANA_DCXO_26M_REF_OUT3_PIN_EXT_XTL3_EN          0x0080
#define MASK_ANA_DCXO_26M_REF_OUT3_PIN_EXT_XTL2_EN          0x0040
#define MASK_ANA_DCXO_26M_REF_OUT3_PIN_EXT_XTL1_EN          0x0020
#define MASK_ANA_DCXO_26M_REF_OUT3_PIN_EXT_XTL0_EN          0x0010
#define MASK_ANA_DCXO_26M_REF_OUT4_PIN_EXT_XTL5_EN          0x8000
#define MASK_ANA_DCXO_26M_REF_OUT4_PIN_EXT_XTL4_EN          0x4000
#define MASK_ANA_DCXO_26M_REF_OUT4_PIN_EXT_XTL3_EN          0x2000
#define MASK_ANA_DCXO_26M_REF_OUT4_PIN_EXT_XTL2_EN          0x1000
#define MASK_ANA_DCXO_26M_REF_OUT4_PIN_EXT_XTL1_EN          0x0800
#define MASK_ANA_DCXO_26M_REF_OUT4_PIN_EXT_XTL0_EN          0x0400
#define MASK_ANA_SLP_DCXO_26M_REF_OUT4_EN                   0x0200
#define MASK_ANA_SLP_DCXO_26M_REF_OUT3_EN                   0x0100
#define MASK_ANA_SLP_DCXO_26M_REF_OUT2_EN                   0x0080
#define MASK_ANA_SLP_DCXO_26M_REF_OUT1_EN                   0x0040
#define MASK_ANA_SLP_DCXO_26M_REF_OUT0_EN                   0x0020
#define MASK_ANA_DCXO_26M_REF_OUT_EN                        0x001F
#define MASK_ANA_DCXO_26M_REF_OUT4_EXT_XTL1_EN              0x0400
#define MASK_ANA_DCXO_26M_REF_OUT3_EXT_XTL1_EN              0x0200
#define MASK_ANA_DCXO_26M_REF_OUT2_EXT_XTL1_EN              0x0100
#define MASK_ANA_DCXO_26M_REF_OUT1_EXT_XTL1_EN              0x0080
#define MASK_ANA_DCXO_26M_REF_OUT0_EXT_XTL1_EN              0x0040
#define MASK_ANA_DCXO_26M_REF_OUT4_EXT_XTL0_EN              0x0010
#define MASK_ANA_DCXO_26M_REF_OUT3_EXT_XTL0_EN              0x0008
#define MASK_ANA_DCXO_26M_REF_OUT2_EXT_XTL0_EN              0x0004
#define MASK_ANA_DCXO_26M_REF_OUT1_EXT_XTL0_EN              0x0002
#define MASK_ANA_DCXO_26M_REF_OUT0_EXT_XTL0_EN              0x0001
#define MASK_ANA_DCXO_26M_REF_OUT4_EXT_XTL3_EN              0x0400
#define MASK_ANA_DCXO_26M_REF_OUT3_EXT_XTL3_EN              0x0200
#define MASK_ANA_DCXO_26M_REF_OUT2_EXT_XTL3_EN              0x0100
#define MASK_ANA_DCXO_26M_REF_OUT1_EXT_XTL3_EN              0x0080
#define MASK_ANA_DCXO_26M_REF_OUT0_EXT_XTL3_EN              0x0040
#define MASK_ANA_DCXO_26M_REF_OUT4_EXT_XTL2_EN              0x0010
#define MASK_ANA_DCXO_26M_REF_OUT3_EXT_XTL2_EN              0x0008
#define MASK_ANA_DCXO_26M_REF_OUT2_EXT_XTL2_EN              0x0004
#define MASK_ANA_DCXO_26M_REF_OUT1_EXT_XTL2_EN              0x0002
#define MASK_ANA_DCXO_26M_REF_OUT0_EXT_XTL2_EN              0x0001
#define MASK_ANA_SLP_DCXO_LP_EN                             0x8000
#define MASK_ANA_DCXO_26M_REF_OUT4_EXT_XTL5_EN              0x4000
#define MASK_ANA_DCXO_26M_REF_OUT3_EXT_XTL5_EN              0x2000
#define MASK_ANA_DCXO_26M_REF_OUT2_EXT_XTL5_EN              0x1000
#define MASK_ANA_DCXO_26M_REF_OUT1_EXT_XTL5_EN              0x0800
#define MASK_ANA_DCXO_26M_REF_OUT0_EXT_XTL5_EN              0x0400
#define MASK_ANA_DCXO_26M_REF_OUT4_EXT_XTL4_EN              0x0100
#define MASK_ANA_DCXO_26M_REF_OUT3_EXT_XTL4_EN              0x0080
#define MASK_ANA_DCXO_26M_REF_OUT2_EXT_XTL4_EN              0x0040
#define MASK_ANA_DCXO_26M_REF_OUT1_EXT_XTL4_EN              0x0020
#define MASK_ANA_DCXO_26M_REF_OUT0_EXT_XTL4_EN              0x0010
#define MASK_ANA_DCXO_CORE_AML_CAL_EN                       0x0008
#define MASK_ANA_CLK_DCXO_SEL                               0x0007
#define MASK_ANA_DCXO_26M_REF_BUF2_DRV_LEVEL_CTRL           0xE000
#define MASK_ANA_DCXO_26M_REF_BUF3_DRV_LEVEL_CTRL           0x1C00
#define MASK_ANA_DCXO_32K_DIV_MODE_SEL                      0x0200
#define MASK_ANA_DCXO_32K_CLKIN_26M_INV_CTRL                0x0100
#define MASK_ANA_DCXO_CORE_AML_CTRL                         0x00F0
#define MASK_ANA_DCXO_CORE_AML_CAL_OK_FLAG                  0x0008
#define MASK_ANA_DCXO_26M_REF_BUF4_DRV_LEVEL_CTRL           0x0007
#define MASK_ANA_DCXO_CORE_AML_CAL_CTRL_HP                  0x00FF
#define MASK_ANA_DCXO_CORE_AML_CAL_CTRL_LP                  0x00FF
#define MASK_ANA_DCXO_CORE_GM_HELPER_HP                     0x0001
#define MASK_ANA_DCXO_CORE_GM_HELPER_LP                     0x0001
#define MASK_ANA_DCXO_CORE_CBANK_HP                         0x00FF
#define MASK_ANA_DCXO_CORE_CBANK_LP                         0x00FF
#define MASK_ANA_DCXO_32K_FRAC_DIV_RATIO_CTRL_HP            0x0FFF
#define MASK_ANA_DCXO_32K_FRAC_DIV_RATIO_CTRL_LP            0x0FFF
#define MASK_ANA_DCXO_CORE_BUF_MODE_SEL                     0x8000
#define MASK_ANA_DCXO_26M_REF_BUF2_DIV_MODE_SEL             0x4000
#define MASK_ANA_DCXO_26M_REF_BUF3_DIV_MODE_SEL             0x2000
#define MASK_ANA_DCXO_26M_REF_BUF4_DIV_MODE_SEL             0x1000
#define MASK_ANA_DCXO_LP_CAL_EN                             0x0800
#define MASK_ANA_DCXO_26M_REF_BUF_OUTPUT_BYPASS             0x07C0
#define MASK_ANA_DCXO_26M_REF_BUF0_DRV_LEVEL_CTRL           0x0038
#define MASK_ANA_DCXO_26M_REF_BUF1_DRV_LEVEL_CTRL           0x0007
#define MASK_ANA_TSEN_ADCLDO_EN                             0x8000
#define MASK_ANA_TSEN_CLKSEL                                0x1800
#define MASK_ANA_TSEN_CHOP_CLKSEL                           0x0600
#define MASK_ANA_TSEN_ADCLDO_V                              0x01E0
#define MASK_ANA_TSEN_CLK_SRC_SEL                           0x0010
#define MASK_ANA_TSEN_CLK_DUTY_CRC_EN                       0x0008
#define MASK_ANA_TSEN_CLK_PHASE_SEL                         0x0007
#define MASK_ANA_TSEN_DATA_EDGE_SEL                         0x8000
#define MASK_ANA_TSEN_UGBUF_EN                              0x4000
#define MASK_ANA_TSEN_INPUT_EN                              0x2000
#define MASK_ANA_TSEN_SDADC_EN                              0x0800
#define MASK_ANA_TSEN_UGBUF_CHOP_EN                         0x0400
#define MASK_ANA_TSEN_SDADC_CHOP_EN                         0x0200
#define MASK_ANA_CLK_26M_TESN_EN                            0x0080
#define MASK_ANA_UGBUF_CTRL                                 0x0040
#define MASK_ANA_TSEN_CLK_SOFT_RST                          0x0100
#define MASK_ANA_TSEN_CH_THM_SEL                            0x0080
#define MASK_ANA_TSEN_CLK_PHASE_MODE_SEL                    0x0040
#define MASK_ANA_TSEN_SDADC_CTRL1                           0x003C
#define MASK_ANA_TSEN_INPUT_RC_EN                           0x0002
#define MASK_ANA_CLK_TSEN_SEL                               0x0001
#define MASK_ANA_TSEN_SEL_CH                                0x0010
#define MASK_ANA_TSEN_SEL_EN                                0x0008
#define MASK_ANA_TSEN_TIME_SEL                              0x0006
#define MASK_ANA_TSEN_EN                                    0x0001
#define MASK_ANA_TSEN_OUT                                   0xFFFF
#define MASK_ANA_OSC_OUT                                    0xFFFF
#define MASK_ANA_RESERVED_CORE                              0xFFFF
#define MASK_ANA_RESERVED_RTC                               0xFFFF
#define MASK_ANA_BG_CHOP_EN                                 0x0001
#define MASK_ANA_DCDC_MODEM_PFMAD_SW_SEL                    0x8000
#define MASK_ANA_DCDC_MEMQ_PFMAD_SW_SEL                     0x4000
#define MASK_ANA_DCDC_GPU_PFMAD_SW_SEL                      0x2000
#define MASK_ANA_DCDC_CPU_PFMAD_SW_SEL                      0x1000
#define MASK_ANA_DCDC_CORE_PFMAD_SW_SEL                     0x0800
#define MASK_ANA_DCDC_GEN1_PFMAD_SW_SEL                     0x0400
#define MASK_ANA_DCDC_GEN0_PFMAD_SW_SEL                     0x0200
#define MASK_ANA_DCDC_MEM_PFMAD_SW_SEL                      0x0100
#define MASK_ANA_DCDC_WPA_PFMAD_SW_SEL                      0x0080
#define MASK_ANA_DCDC_6MFRECAL_SW_SEL                       0x0040
#define MASK_ANA_DCDC_WPA_VREF_CAL_SW_SEL                   0x0020
#define MASK_ANA_DCDC_MEMQ_SW_SEL                           0x0010
#define MASK_ANA_DCDC_GEN0_SW_SEL                           0x0008
#define MASK_ANA_DCDC_GEN1_SW_SEL                           0x0004
#define MASK_ANA_DCDC_CORE_SLP_SW_SEL                       0x0002
#define MASK_ANA_DCDC_CORE_NOR_SW_SEL                       0x0001
#define MASK_ANA_DCDC_SRAM_PFMAD_SW_SEL                     0x0020
#define MASK_ANA_DCDC_SRAM_SW_SEL                           0x0010
#define MASK_ANA_DCDC_MODEM_SW_SEL                          0x0008
#define MASK_ANA_DCDC_MEM_SW_SEL                            0x0004
#define MASK_ANA_DCDC_GPU_SW_SEL                            0x0002
#define MASK_ANA_DCDC_CPU_SW_SEL                            0x0001
#define MASK_ANA_LDO_VDDSDCORE_CL_SW_SEL                    0x8000
#define MASK_ANA_LDO_VDDLDO1_SW_SEL                         0x4000
#define MASK_ANA_LDO_VDDLDO0_SW_SEL                         0x2000
#define MASK_ANA_LDO_VDDUSB33_SW_SEL                        0x1000
#define MASK_ANA_LDO_VDD18_DCXO_SW_SEL                      0x0800
#define MASK_ANA_LDO_VDDWIFIPA_SW_SEL                       0x0400
#define MASK_ANA_LDO_VDD28_SW_SEL                           0x0200
#define MASK_ANA_LDO_VDDSDIO_SW_SEL                         0x0100
#define MASK_ANA_LDO_VDDSDCORE_SW_SEL                       0x0080
#define MASK_ANA_LDO_VDDEMMCCORE_SW_SEL                     0x0040
#define MASK_ANA_LDO_VDDSIM2_SW_SEL                         0x0020
#define MASK_ANA_LDO_VDDSIM1_SW_SEL                         0x0010
#define MASK_ANA_LDO_VDDSIM0_SW_SEL                         0x0008
#define MASK_ANA_LDO_VDDCAMMOT_SW_SEL                       0x0004
#define MASK_ANA_LDO_VDDCAMA1_SW_SEL                        0x0002
#define MASK_ANA_LDO_VDDCAMA0_SW_SEL                        0x0001
#define MASK_ANA_LDO_VDDLDO2_SW_SEL                         0x0400
#define MASK_ANA_LDO_RTC_CAL_SW_SEL                         0x0200
#define MASK_ANA_LDO_VDDKPLED_SW_SEL                        0x0100
#define MASK_ANA_LDO_VDDVIBR_SW_SEL                         0x0080
#define MASK_ANA_LDO_AVDD12_SW_SEL                          0x0040
#define MASK_ANA_LDO_VDDRF1V25_SW_SEL                       0x0020
#define MASK_ANA_LDO_VDDCAMD1_SW_SEL                        0x0010
#define MASK_ANA_LDO_VDDCAMD0_SW_SEL                        0x0008
#define MASK_ANA_LDO_VDDWCN_SW_SEL                          0x0004
#define MASK_ANA_LDO_VDDRF1V8_SW_SEL                        0x0002
#define MASK_ANA_LDO_AVDD18_SW_SEL                          0x0001
#define MASK_ANA_TSX_MODE                                   0x8000
#define MASK_ANA_RC_MODE_WR_ACK_FLAG                        0x4000
#define MASK_ANA_XO_LOW_CUR_FLAG                            0x2000
#define MASK_ANA_XO_LOW_CUR_FRC_RTCSET                      0x1000
#define MASK_ANA_XO_LOW_CUR_FRC_RTCCLR                      0x0800
#define MASK_ANA_RC_MODE_WR_ACK_FLAG_CLR                    0x0400
#define MASK_ANA_XO_LOW_CUR_FLAG_CLR                        0x0200
#define MASK_ANA_XO_LOW_CUR_CNT_CLR                         0x0100
#define MASK_ANA_LDO_VDD18_DCXO_LP_EN_RTCSET                0x0080
#define MASK_ANA_LDO_VDD18_DCXO_LP_EN_RTCCLR                0x0040
#define MASK_ANA_SLP_XO_LOW_CUR_EN                          0x0020
#define MASK_ANA_RTC_MODE                                   0x0010
#define MASK_ANA_OPT_TCXO                                   0x0008
#define MASK_ANA_OPT_26_52                                  0x0004
#define MASK_ANA_RC_32K_SEL                                 0x0002
#define MASK_ANA_RC_32K_EN                                  0x0001
#define MASK_ANA_RC_MODE                                    0xFFFF
#define MASK_ANA_XO_LOW_CUR_CNT_LOW                         0xFFFF
#define MASK_ANA_XO_LOW_CUR_CNT_HIGH                        0xFFFF
#define MASK_ANA_EXT_XTL5_FOR_26M_EN                        0x8000
#define MASK_ANA_EXT_XTL4_FOR_26M_EN                        0x4000
#define MASK_ANA_EXT_XTL3_FOR_26M_EN                        0x2000
#define MASK_ANA_EXT_XTL2_FOR_26M_EN                        0x1000
#define MASK_ANA_EXT_XTL1_FOR_26M_EN                        0x0800
#define MASK_ANA_EXT_XTL0_FOR_26M_EN                        0x0400
#define MASK_ANA_SLP_XTLBUF_PD_EN                           0x0200
#define MASK_ANA_XTL_EN                                     0x0100
#define MASK_ANA_XTL_WAIT                                   0x00FF
#define MASK_ANA_OPT_L5                                     0x0004
#define MASK_ANA_OPT_WK                                     0x0002
#define MASK_ANA_CLK_26M_SOURCE_SEL                         0x0001
#define MASK_ANA_SLP_RGB_PD_EN                              0x0004
#define MASK_ANA_BATDET_CUR_EN                              0x2000
#define MASK_ANA_BATDET_CUR_I                               0x0E00
#define MASK_ANA_IB_TRIM                                    0x01FC
#define MASK_ANA_IB_TRIM_EM_SEL                             0x0002
#define MASK_ANA_IB_REX_EN                                  0x0001
#define MASK_ANA_KPLED_V                                    0xF000
#define MASK_ANA_KPLED_PD                                   0x0800
#define MASK_ANA_KPLED_PULLDOWN_EN                          0x0400
#define MASK_ANA_LDO_VDDKPLED_PD                            0x8000
#define MASK_ANA_LDO_VDDKPLED_V                             0x7F80
#define MASK_ANA_LDO_VDDKPLED_REFTRIM                       0x007C
#define MASK_ANA_SLP_LDO_VDDKPLED_PD_EN                     0x0002
#define MASK_ANA_LDO_VDDKPLED_SHPT_PD                       0x0001
#define MASK_ANA_LDO_VDDVIB_SHPT_PD                         0x8000
#define MASK_ANA_SLP_LDO_VDDVIB_PD_EN                       0x4000
#define MASK_ANA_LDO_VDDVIB_PD                              0x2000
#define MASK_ANA_LDO_VDDVIB_REFTRIM                         0x1F00
#define MASK_ANA_LDO_VDDVIB_V                               0x00FF
#define MASK_ANA_CLK_AUD_IF_TX_INV_EN                       0x0008
#define MASK_ANA_CLK_AUD_IF_RX_INV_EN                       0x0004
#define MASK_ANA_CLK_AUD_IF_6P5M_TX_INV_EN                  0x0002
#define MASK_ANA_CLK_AUD_IF_6P5M_RX_INV_EN                  0x0001
#define MASK_ANA_CHGR_PD                                    0x0001
#define MASK_ANA_CHGR_INT_EN                                0x2000
#define MASK_ANA_NON_DCP_INT                                0x1000
#define MASK_ANA_CHG_DET_DONE                               0x0800
#define MASK_ANA_DP_LOW                                     0x0400
#define MASK_ANA_DCP_DET                                    0x0200
#define MASK_ANA_CHG_DET                                    0x0100
#define MASK_ANA_SDP_INT                                    0x0080
#define MASK_ANA_DCP_INT                                    0x0040
#define MASK_ANA_CDP_INT                                    0x0020
#define MASK_ANA_CHGR_INT                                   0x0004
#define MASK_ANA_DCP_SWITCH_EN                              0x0002
#define MASK_ANA_DP_DM_FC_ENB                               0x4000
#define MASK_ANA_FGUA_SOFT_RST                              0x2000
#define MASK_ANA_LDO_FGU_PD                                 0x1000
#define MASK_ANA_CHG_INT_DELAY                              0x0E00
#define MASK_ANA_DP_DM_AUX_EN                               0x0002
#define MASK_ANA_DP_DM_BC_ENB                               0x0001
#define MASK_ANA_VBAT_CRASH_V                               0x0C00
#define MASK_ANA_OVLO_EN                                    0x0200
#define MASK_ANA_OVLO_V                                     0x000C
#define MASK_ANA_OVLO_T                                     0x0003
#define MASK_ANA_XOSC32K_CTL                                0x1000
#define MASK_ANA_BATON_T                                    0x0C00
#define MASK_ANA_BATDET_OK                                  0x0100
#define MASK_ANA_VBAT_OK                                    0x0010
#define MASK_ANA_ALL_GPI_DEB                                0x0008
#define MASK_ANA_GPI_DEBUG_EN                               0x0004
#define MASK_ANA_ALL_INT_DEB                                0x0002
#define MASK_ANA_INT_DEBUG_EN                               0x0001
#define MASK_ANA_POR_RST_MONITOR                            0xFFFF
#define MASK_ANA_WDG_RST_MONITOR                            0xFFFF
#define MASK_ANA_POR_PIN_RST_MONITOR                        0xFFFF
#define MASK_ANA_POR_SW_FORCE_ON                            0x8000
#define MASK_ANA_REG_SOFT_RST_FLG_CLR                       0x4000
#define MASK_ANA_POR_SRC_FLAG                               0x3FFF
#define MASK_ANA_POR_CHIP_PD_FLAG                           0x2000
#define MASK_ANA_POR_CHIP_PD_FLAG_CLR                       0x1000
#define MASK_ANA_UVLO_CHIP_PD_FLAG                          0x0800
#define MASK_ANA_UVLO_CHIP_PD_FLAG_CLR                      0x0400
#define MASK_ANA_HARD_7S_CHIP_PD_FLAG                       0x0200
#define MASK_ANA_HARD_7S_CHIP_PD_FLAG_CLR                   0x0100
#define MASK_ANA_SW_CHIP_PD_FLAG                            0x0080
#define MASK_ANA_SW_CHIP_PD_FLAG_CLR                        0x0040
#define MASK_ANA_HW_CHIP_PD_FLAG                            0x0020
#define MASK_ANA_HW_CHIP_PD_FLAG_CLR                        0x0010
#define MASK_ANA_OTP_CHIP_PD_FLAG                           0x0008
#define MASK_ANA_OTP_CHIP_PD_FLAG_CLR                       0x0004
#define MASK_ANA_PBINT_7S_FLAG_CLR                          0x8000
#define MASK_ANA_EXT_RSTN_FLAG_CLR                          0x4000
#define MASK_ANA_CHGR_INT_FLAG_CLR                          0x2000
#define MASK_ANA_PBINT2_FLAG_CLR                            0x1000
#define MASK_ANA_PBINT_FLAG_CLR                             0x0800
#define MASK_ANA_KEY2_7S_RST_EN                             0x0200
#define MASK_ANA_PBINT_7S_RST_SWMODE                        0x0100
#define MASK_ANA_PBINT_7S_RST_THRESHOLD                     0x00F0
#define MASK_ANA_EXT_RSTN_MODE                              0x0008
#define MASK_ANA_PBINT_7S_AUTO_ON_EN                        0x0004
#define MASK_ANA_PBINT_7S_RST_DISABLE                       0x0002
#define MASK_ANA_PBINT_7S_RST_MODE                          0x0001
#define MASK_ANA_HWRST_RTC_REG_STS                          0xFF00
#define MASK_ANA_HWRST_RTC_REG_SET                          0x00FF
#define MASK_ANA_ARCH_EN                                    0x0001
#define MASK_ANA_MCU_WR_PROT                                0x8000
#define MASK_ANA_MCU_WR_PROT_VALUE                          0x7FFF
#define MASK_ANA_PWR_WR_PROT                                0x8000
#define MASK_ANA_PWR_WR_PROT_VALUE                          0x7FFF
#define MASK_ANA_DCDC_WR_PROT                               0x8000
#define MASK_ANA_DCDC_WR_PROT_VALUE                         0x7FFF
#define MASK_ANA_TSX_WR_PROT                                0x8000
#define MASK_ANA_TSX_WR_PROT_VALUE                          0x7FFF
#define MASK_ANA_SMPL_MODE                                  0xFFFF
#define MASK_ANA_SMPL_PWR_ON_FLAG                           0x8000
#define MASK_ANA_SMPL_MODE_WR_ACK_FLAG                      0x4000
#define MASK_ANA_SMPL_PWR_ON_FLAG_CLR                       0x2000
#define MASK_ANA_SMPL_MODE_WR_ACK_FLAG_CLR                  0x1000
#define MASK_ANA_SMPL_PWR_ON_SET                            0x0800
#define MASK_ANA_SMPL_EN                                    0x0001
#define MASK_ANA_RTC_CLK_FLAG_SET                           0xFFFF
#define MASK_ANA_RTC_CLK_FLAG_CLR                           0xFFFF
#define MASK_ANA_RTC_CLK_FLAG_RTC                           0xFFFF
#define MASK_ANA_RTC_CLK_STOP_FLAG                          0x0080
#define MASK_ANA_RTC_CLK_STOP_THRESHOLD                     0x007F
#define MASK_ANA_VBAT_DROP_CNT                              0x0FFF
#define MASK_ANA_SW_RST_DCDCSRAM_PD_EN                      0x0200
#define MASK_ANA_EXT_RSTN_PD_EN                             0x0100
#define MASK_ANA_PB_7S_RST_PD_EN                            0x0080
#define MASK_ANA_REG_RST_PD_EN                              0x0040
#define MASK_ANA_WDG_RST_PD_EN                              0x0020
#define MASK_ANA_REG_RST_EN                                 0x0010
#define MASK_ANA_SW_RST_PD_THRESHOLD                        0x000F
#define MASK_ANA_HW_OFF_RST_EN                              0x0001
#define MASK_ANA_SW_RST_DCDCGPU_PD_EN                       0x8000
#define MASK_ANA_SW_RST_DCDCMODEM_PD_EN                     0x4000
#define MASK_ANA_SW_RST_DCDCMEMQ_PD_EN                      0x2000
#define MASK_ANA_SW_RST_DCDCMEM_PD_EN                       0x1000
#define MASK_ANA_SW_RST_DCDCGEN1_PD_EN                      0x0800
#define MASK_ANA_SW_RST_DCDCGEN0_PD_EN                      0x0400
#define MASK_ANA_SW_RST_DCDCCORE_PD_EN                      0x0200
#define MASK_ANA_SW_RST_LDO_AVDD12_PD_EN                    0x0100
#define MASK_ANA_SW_RST_LDOVDD18_DCXO_PD_EN                 0x0080
#define MASK_ANA_SW_RST_LDO_VDD28_PD_EN                     0x0040
#define MASK_ANA_SW_RST_LDO_AVDD18_PD_EN                    0x0020
#define MASK_ANA_SW_RST_LDOVDD_RF1V8_PD_EN                  0x0010
#define MASK_ANA_SW_RST_LDOVDD_USB33_PD_EN                  0x0008
#define MASK_ANA_SW_RST_LDOVDD_EMMCCORE_PD_EN               0x0004
#define MASK_ANA_SW_RST_LDOVDD_SDIO_PD_EN                   0x0002
#define MASK_ANA_SW_RST_LDOVDD_SDCORE_PD_EN                 0x0001
#define MASK_ANA_OTP_OP                                     0x0006
#define MASK_ANA_OTP_EN                                     0x0001
#define MASK_ANA_TIMER_LOW                                  0xFFFF
#define MASK_ANA_TIMER_HIGH                                 0xFFFF
#define MASK_ANA_AUTO_SWITCH_TO_RC_EN                       0x4000
#define MASK_ANA_MONITOR_ACCURACY                           0x3800
#define MASK_ANA_TIME_BETWEEN_CALIBRATION                   0x0780
#define MASK_ANA_TIME_FOR_CALIBRATION                       0x0060
#define MASK_ANA_TIME_FOR_DCXO_STABLE                       0x001E
#define MASK_ANA_LOW_PWR_CLK32K_EN                          0x0001
#define MASK_ANA_CORE_CLK_SEL                               0x4000
#define MASK_ANA_CORE_STEP_DELAY                            0x3000
#define MASK_ANA_CORE_STEP_NUM                              0x0F00
#define MASK_ANA_CORE_STEP_VOL                              0x00F8
#define MASK_ANA_CORE_VOL_TUNE_START                        0x0004
#define MASK_ANA_CORE_VOL_TUNE_FLAG                         0x0002
#define MASK_ANA_CORE_VOL_TUNE_EN                           0x0001
#define MASK_ANA_CPU_CLK_SEL                                0x4000
#define MASK_ANA_CPU_STEP_DELAY                             0x3000
#define MASK_ANA_CPU_STEP_NUM                               0x0F00
#define MASK_ANA_CPU_STEP_VOL                               0x00F8
#define MASK_ANA_CPU_VOL_TUNE_START                         0x0004
#define MASK_ANA_CPU_VOL_TUNE_FLAG                          0x0002
#define MASK_ANA_CPU_VOL_TUNE_EN                            0x0001
#define MASK_ANA_GPU_CLK_SEL                                0x4000
#define MASK_ANA_GPU_STEP_DELAY                             0x3000
#define MASK_ANA_GPU_STEP_NUM                               0x0F00
#define MASK_ANA_GPU_STEP_VOL                               0x00F8
#define MASK_ANA_GPU_VOL_TUNE_START                         0x0004
#define MASK_ANA_GPU_VOL_TUNE_FLAG                          0x0002
#define MASK_ANA_GPU_VOL_TUNE_EN                            0x0001
#define MASK_ANA_MODEM_CLK_SEL                              0x4000
#define MASK_ANA_MODEM_STEP_DELAY                           0x3000
#define MASK_ANA_MODEM_STEP_NUM                             0x0F00
#define MASK_ANA_MODEM_STEP_VOL                             0x00F8
#define MASK_ANA_MODEM_VOL_TUNE_START                       0x0004
#define MASK_ANA_MODEM_VOL_TUNE_FLAG                        0x0002
#define MASK_ANA_MODEM_VOL_TUNE_EN                          0x0001
#define MASK_ANA_DCDC_CPU_DVFS_EN                           0x0008
#define MASK_ANA_DCDC_GPU_DVFS_EN                           0x0004
#define MASK_ANA_DCDC_CORE_DVFS_EN                          0x0002
#define MASK_ANA_DCDC_MODEM_DVFS_EN                         0x0001
#define MASK_ANA_MEMQ_SYNC_MODE                             0x0400
#define MASK_ANA_SRAM_SYNC_MODE                             0x0200
#define MASK_ANA_START_POINT                                0x01FF
#define MASK_ANA_GAP                                        0x03FF
#define MASK_ANA_DELAY_TIME_UP                              0xFFFF
#define MASK_ANA_DELAY_TIME_DOWN                            0xFFFF
#define MASK_ANA_TOP_TRIM_SW_SEL                            0x4000
#define MASK_ANA_TOP_TRIM                                   0x3FFF
#define MASK_ANA_ENDURA_OPTION_O                            0x00FF
#define MASK_ANA_ENDURA_OPTION_I_AD                         0x00FF
#define MASK_ANA_ENDURA_OPTION_I_D                          0x00FF
#define MASK_ANA_ENDURA_OPTION_I_C                          0x0001

#endif /* __DT_BINDINGS_SPRD_SC2730_MASK_H */
