// SPDX-License-Identifier: GPL-2.0-only
/*
 * gsp_hdr_param.h - Unisoc platform header
 *
 * Copyright 2022 Unisoc(Shanghai) Technologies Co.Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _GSP_HDR_PARAM_H
#define _GSP_HDR_PARAM_H

#define HDR_DEGAMMA_LUT_SIZE 1024
#define HDR_REGAMMA_LUT_SIZE 1024
#define HDR_TM_LUT_SIZE (1024 + 1)
#define PQ_TYPE 16
#define HLG_TYPE 18
#define HDR_DR_LUT_WRITE 0x30101
#define HDR_TM_LUT_WRITE 0x30100
#define HDR_DR_LUT_WRITE_FINISH 0x101
#define HDR_TM_LUT_WRITE_FINISH 0x80100
#define HDR_TM23_BETA_GAIN 0xffd0ffe

uint32_t hdr_bypass_param[38] = {
	0x0073E00, 0x0008080, 0x00004a8, 0x4a8072c, 0xfddeff26, 0x87304a8, 0x0000000,
	0x72c0873, 0x300c03e0, 0x0000000, 0x0000000, 0x0000000, 0xf69a1a91, 0xfe02fed6,
	0xffde1220, 0xfe65ffb6, 0x100011e6, 0x0000000, 0x10000000, 0x0000000, 0x10000000,
	0x0000000, 0x0000000, 0x0001000, 0xf0e0e09, 0x0008188, 0x0000101, 0xf0e0e09,
	0x10001000, 0x0000000, 0x0000000, 0x0000000, 0x0f820034, 0x1c20ebb, 0xe6201c2,
	0x0000fdc, 0x0000000, 0x025400e7,
};

uint32_t hdr_pq_degamma_tbl[HDR_DEGAMMA_LUT_SIZE] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3,
	0x3, 0x4, 0x5, 0x6, 0x6, 0x7, 0x9, 0xa, 0xb, 0xc,
	0xd, 0xf, 0x10, 0x12, 0x14, 0x15, 0x17, 0x19, 0x1b, 0x1d,
	0x1f, 0x21, 0x24, 0x26, 0x29, 0x2b, 0x2e, 0x31, 0x34, 0x37,
	0x3a, 0x3d, 0x40, 0x44, 0x47, 0x4b, 0x4f, 0x53, 0x57, 0x5b,
	0x5f, 0x63, 0x68, 0x6d, 0x71, 0x76, 0x7b, 0x81, 0x86, 0x8b,
	0x91, 0x97, 0x9c, 0xa3, 0xa9, 0xaf, 0xb6, 0xbc, 0xc3, 0xca,
	0xd1, 0xd8, 0xe0, 0xe8, 0xef, 0xf7, 0x100, 0x108, 0x110, 0x119,
	0x122, 0x12b, 0x135, 0x13e, 0x148, 0x152, 0x15c, 0x166, 0x171, 0x17b,
	0x186, 0x191, 0x19d, 0x1a9, 0x1b4, 0x1c0, 0x1cd, 0x1d9, 0x1e6, 0x1f3,
	0x201, 0x20e, 0x21c, 0x22a, 0x238, 0x247, 0x256, 0x265, 0x274, 0x284,
	0x294, 0x2a4, 0x2b4, 0x2c5, 0x2d6, 0x2e8, 0x2f9, 0x30b, 0x31e, 0x330,
	0x343, 0x357, 0x36a, 0x37e, 0x392, 0x3a7, 0x3bc, 0x3d1, 0x3e7, 0x3fd,
	0x413, 0x42a, 0x441, 0x458, 0x470, 0x488, 0x4a0, 0x4b9, 0x4d3, 0x4ec,
	0x507, 0x521, 0x53c, 0x557, 0x573, 0x58f, 0x5ac, 0x5c9, 0x5e6, 0x604,
	0x623, 0x642, 0x661, 0x681, 0x6a1, 0x6c1, 0x6e3, 0x704, 0x726, 0x749,
	0x76c, 0x790, 0x7b4, 0x7d9, 0x7fe, 0x824, 0x84a, 0x871, 0x898, 0x8c0,
	0x8e9, 0x912, 0x93b, 0x965, 0x990, 0x9bc, 0x9e7, 0xa14, 0xa41, 0xa6f,
	0xa9d, 0xacc, 0xafc, 0xb2c, 0xb5d, 0xb8f, 0xbc1, 0xbf4, 0xc28, 0xc5c,
	0xc91, 0xcc7, 0xcfd, 0xd35, 0xd6d, 0xda5, 0xdde, 0xe19, 0xe53, 0xe8f,
	0xecb, 0xf08, 0xf46, 0xf85, 0xfc5, 0x1005, 0x1046, 0x1088, 0x10cb, 0x110f,
	0x1153, 0x1198, 0x11df, 0x1226, 0x126e, 0x12b7, 0x1301, 0x134b, 0x1397, 0x13e3,
	0x1431, 0x1480, 0x14cf, 0x151f, 0x1571, 0x15c3, 0x1617, 0x166b, 0x16c0, 0x1717,
	0x176e, 0x17c7, 0x1821, 0x187b, 0x18d7, 0x1934, 0x1992, 0x19f1, 0x1a51, 0x1ab3,
	0x1b15, 0x1b79, 0x1bde, 0x1c44, 0x1cab, 0x1d14, 0x1d7d, 0x1de8, 0x1e55, 0x1ec2,
	0x1f31, 0x1fa1, 0x2012, 0x2085, 0x20f9, 0x216e, 0x21e5, 0x225d, 0x22d6, 0x2351,
	0x23cd, 0x244a, 0x24c9, 0x254a, 0x25cc, 0x264f, 0x26d4, 0x275a, 0x27e2, 0x286c,
	0x28f7, 0x2983, 0x2a11, 0x2aa1, 0x2b32, 0x2bc5, 0x2c5a, 0x2cf0, 0x2d88, 0x2e21,
	0x2ebc, 0x2f59, 0x2ff8, 0x3099, 0x313b, 0x31df, 0x3285, 0x332c, 0x33d6, 0x3481,
	0x352e, 0x35dd, 0x368e, 0x3741, 0x37f6, 0x38ad, 0x3965, 0x3a20, 0x3add, 0x3b9c,
	0x3c5c, 0x3d1f, 0x3de4, 0x3eac, 0x3f75, 0x4040, 0x410e, 0x41de, 0x42b0, 0x4384,
	0x445a, 0x4533, 0x460e, 0x46ec, 0x47cb, 0x48ae, 0x4992, 0x4a79, 0x4b62, 0x4c4e,
	0x4d3c, 0x4e2d, 0x4f20, 0x5016, 0x510f, 0x520a, 0x5307, 0x5407, 0x550a, 0x5610,
	0x5718, 0x5823, 0x5931, 0x5a42, 0x5b55, 0x5c6c, 0x5d85, 0x5ea1, 0x5fc0, 0x60e2,
	0x6207, 0x632e, 0x6459, 0x6587, 0x66b8, 0x67ed, 0x6924, 0x6a5e, 0x6b9c, 0x6cdd,
	0x6e21, 0x6f69, 0x70b4, 0x7202, 0x7353, 0x74a8, 0x7601, 0x775d, 0x78bc, 0x7a1f,
	0x7b86, 0x7cf0, 0x7e5e, 0x7fcf, 0x8144, 0x82bd, 0x843a, 0x85ba, 0x873f, 0x88c7,
	0x8a53, 0x8be3, 0x8d77, 0x8f0f, 0x90ab, 0x924b, 0x93f0, 0x9598, 0x9745, 0x98f6,
	0x9aab, 0x9c64, 0x9e22, 0x9fe5, 0xa1ab, 0xa377, 0xa546, 0xa71b, 0xa8f4, 0xaad1,
	0xacb3, 0xae9a, 0xb086, 0xb276, 0xb46c, 0xb666, 0xb865, 0xba69, 0xbc73, 0xbe81,
	0xc094, 0xc2ad, 0xc4cb, 0xc6ee, 0xc916, 0xcb44, 0xcd77, 0xcfb0, 0xd1ee, 0xd431,
	0xd67b, 0xd8ca, 0xdb1e, 0xdd79, 0xdfd9, 0xe23f, 0xe4ab, 0xe71c, 0xe994, 0xec12,
	0xee96, 0xf120, 0xf3b1, 0xf648, 0xf8e5, 0xfb88, 0xfe32, 0x100e3, 0x1039a, 0x10657,
	0x1091c, 0x10be7, 0x10eb9, 0x11191, 0x11471, 0x11758, 0x11a46, 0x11d3a, 0x12036, 0x1233a,
	0x12644, 0x12956, 0x12c70, 0x12f90, 0x132b9, 0x135e9, 0x13921, 0x13c60, 0x13fa8, 0x142f7,
	0x1464e, 0x149ae, 0x14d15, 0x15085, 0x153fd, 0x1577d, 0x15b06, 0x15e97, 0x16230, 0x165d3,
	0x1697e, 0x16d32, 0x170ee, 0x174b4, 0x17883, 0x17c5b, 0x1803c, 0x18426, 0x1881a, 0x18c17,
	0x1901d, 0x1942d, 0x19847, 0x19c6b, 0x1a098, 0x1a4d0, 0x1a911, 0x1ad5d, 0x1b1b2, 0x1b612,
	0x1ba7d, 0x1bef2, 0x1c371, 0x1c7fb, 0x1cc90, 0x1d130, 0x1d5db, 0x1da91, 0x1df51, 0x1e41e,
	0x1e8f5, 0x1edd8, 0x1f2c6, 0x1f7c1, 0x1fcc6, 0x201d8, 0x206f6, 0x20c1f, 0x21155, 0x21697,
	0x21be6, 0x22141, 0x226a8, 0x22c1d, 0x2319e, 0x2372c, 0x23cc7, 0x2426f, 0x24825, 0x24de8,
	0x253b8, 0x25996, 0x25f82, 0x2657b, 0x26b83, 0x27199, 0x277bd, 0x27def, 0x28430, 0x28a7f,
	0x290dd, 0x2974a, 0x29dc6, 0x2a452, 0x2aaec, 0x2b196, 0x2b84f, 0x2bf18, 0x2c5f1, 0x2ccda,
	0x2d3d3, 0x2dadc, 0x2e1f5, 0x2e91f, 0x2f05a, 0x2f7a5, 0x2ff01, 0x3066f, 0x30dee, 0x3157e,
	0x31d1f, 0x324d3, 0x32c98, 0x3346f, 0x33c59, 0x34454, 0x34c63, 0x35484, 0x35cb7, 0x364fe,
	0x36d58, 0x375c5, 0x37e46, 0x386da, 0x38f82, 0x3983e, 0x3a10f, 0x3a9f4, 0x3b2ed, 0x3bbfb,
	0x3c51e, 0x3ce56, 0x3d7a3, 0x3e106, 0x3ea7e, 0x3f40c, 0x3fdb0, 0x4076b, 0x4113b, 0x41b23,
	0x42521, 0x42f36, 0x43963, 0x443a6, 0x44e02, 0x45875, 0x46300, 0x46da4, 0x47860, 0x48335,
	0x48e22, 0x49929, 0x4a449, 0x4af82, 0x4bad6, 0x4c643, 0x4d1ca, 0x4dd6c, 0x4e929, 0x4f500,
	0x500f3, 0x50d01, 0x5192b, 0x52571, 0x531d2, 0x53e51, 0x54aeb, 0x557a3, 0x56478, 0x5716a,
	0x57e7a, 0x58ba7, 0x598f3, 0x5a65d, 0x5b3e6, 0x5c18e, 0x5cf55, 0x5dd3c, 0x5eb43, 0x5f969,
	0x607b0, 0x61617, 0x624a0, 0x63349, 0x64214, 0x65101, 0x66010, 0x66f42, 0x67e96, 0x68e0d,
	0x69da7, 0x6ad65, 0x6bd47, 0x6cd4d, 0x6dd78, 0x6edc8, 0x6fe3d, 0x70ed7, 0x71f97, 0x7307e,
	0x7418b, 0x752bf, 0x7641a, 0x7759c, 0x78747, 0x7991a, 0x7ab15, 0x7bd3a, 0x7cf88, 0x7e1ff,
	0x7f4a1, 0x8076d, 0x81a64, 0x82d86, 0x840d3, 0x8544d, 0x867f3, 0x87bc6, 0x88fc6, 0x8a3f3,
	0x8b84f, 0x8ccd8, 0x8e191, 0x8f678, 0x90b90, 0x920d7, 0x9364f, 0x94bf7, 0x961d1, 0x977dd,
	0x98e1a, 0x9a48b, 0x9bb2e, 0x9d205, 0x9e910, 0xa0050, 0xa17c4, 0xa2f6e, 0xa474d, 0xa5f63,
	0xa77af, 0xa9033, 0xaa8ef, 0xac1e3, 0xadb10, 0xaf476, 0xb0e16, 0xb27f0, 0xb4205, 0xb5c55,
	0xb76e1, 0xb91a9, 0xbacaf, 0xbc7f2, 0xbe372, 0xbff32, 0xc1b30, 0xc376f, 0xc53ed, 0xc70ad,
	0xc8dad, 0xcaaf0, 0xcc875, 0xce63e, 0xd044a, 0xd229b, 0xd4130, 0xd600b, 0xd7f2d, 0xd9e95,
	0xdbe45, 0xdde3d, 0xdfe7d, 0xe1f07, 0xe3fdb, 0xe60fa, 0xe8264, 0xea41a, 0xec61d, 0xee86d,
	0xf0b0c, 0xf2df9, 0xf5136, 0xf74c3, 0xf98a1, 0xfbcd1, 0xfe153, 0x100628, 0x102b51, 0x1050cf,
	0x1076a2, 0x109ccc, 0x10c34c, 0x10ea24, 0x111154, 0x1138de, 0x1160c2, 0x118901, 0x11b19c, 0x11da93,
	0x1203e7, 0x122d9a, 0x1257ac, 0x12821e, 0x12acf0, 0x12d824, 0x1303bc, 0x132fb6, 0x135c15, 0x1388d8,
	0x13b602, 0x13e393, 0x14118c, 0x143fee, 0x146eba, 0x149df0, 0x14cd93, 0x14fda2, 0x152e1f, 0x155f0b,
	0x159066, 0x15c232, 0x15f470, 0x162721, 0x165a46, 0x168ddf, 0x16c1ef, 0x16f675, 0x172b74, 0x1760eb,
	0x1796de, 0x17cd4b, 0x180435, 0x183b9d, 0x187383, 0x18abea, 0x18e4d1, 0x191e3b, 0x195828, 0x19929a,
	0x19cd92, 0x1a0910, 0x1a4518, 0x1a81a8, 0x1abec4, 0x1afc6b, 0x1b3aa0, 0x1b7964, 0x1bb8b7, 0x1bf89c,
	0x1c3913, 0x1c7a1e, 0x1cbbbf, 0x1cfdf6, 0x1d40c5, 0x1d842d, 0x1dc831, 0x1e0cd0, 0x1e520d, 0x1e97e9,
	0x1ede66, 0x1f2585, 0x1f6d47, 0x1fb5ae, 0x1ffebc, 0x204872, 0x2092d1, 0x20dddb, 0x212993, 0x2175f8,
	0x21c30f, 0x2210d5, 0x225f4f, 0x22ae7e, 0x22fe63, 0x234f01, 0x23a058, 0x23f26b, 0x24453b, 0x2498ca,
	0x24ed1a, 0x25422c, 0x259803, 0x25ee9f, 0x264604, 0x269e33, 0x26f72d, 0x2750f5, 0x27ab8d, 0x2806f6,
	0x286332, 0x28c044, 0x291e2c, 0x297cef, 0x29dc8c, 0x2a3d07, 0x2a9e61, 0x2b009c, 0x2b63bc, 0x2bc7c0,
	0x2c2cad, 0x2c9284, 0x2cf946, 0x2d60f7, 0x2dc999, 0x2e332d, 0x2e9db7, 0x2f0937, 0x2f75b2, 0x2fe328,
	0x30519d, 0x30c112, 0x31318b, 0x31a309, 0x32158f, 0x32891f, 0x32fdbd, 0x337369, 0x33ea28, 0x3461fc,
	0x34dae6, 0x3554ea, 0x35d00b, 0x364c4b, 0x36c9ac, 0x374832, 0x37c7df, 0x3848b6, 0x38caba, 0x394dee,
	0x39d254, 0x3a57f0, 0x3adec4, 0x3b66d3, 0x3bf022, 0x3c7ab1, 0x3d0683, 0x3d939d, 0x3e2202, 0x3eb1b4,
	0x3f42b7, 0x3fd50d, 0x4068bb, 0x40fdc3, 0x419429, 0x422bef, 0x42c51a, 0x435fac, 0x43fbaa, 0x449916,
	0x4537f4, 0x45d847, 0x467a14, 0x471d5d, 0x47c227, 0x486874, 0x491049, 0x49b9a9, 0x4a6499, 0x4b111b,
	0x4bbf34, 0x4c6ee8, 0x4d203b, 0x4dd330, 0x4e87cb, 0x4f3e11, 0x4ff606, 0x50afad, 0x516b0c, 0x522825,
	0x52e6fe, 0x53a79b, 0x546a00, 0x552e31, 0x55f433, 0x56bc0a, 0x5785bb, 0x58514b, 0x591ebd, 0x59ee17,
	0x5abf5d, 0x5b9295, 0x5c67c2, 0x5d3eea, 0x5e1812, 0x5ef33e, 0x5fd074, 0x60afb8, 0x619110, 0x627481,
	0x635a10, 0x6441c2, 0x652b9d, 0x6617a5, 0x6705e2, 0x67f656, 0x68e90a, 0x69de01, 0x6ad545, 0x6bced5,
	0x6ccaba, 0x6dc8fa, 0x6ec99b, 0x6fcca2, 0x70d216, 0x71d9fd, 0x72e45c, 0x73f13b, 0x75009f, 0x76128e,
	0x77270f, 0x783e29, 0x7957e2, 0x7a7440, 0x7b934a, 0x7cb507, 0x7dd97e, 0x7f00b5, 0x802ab3, 0x815780,
	0x828723, 0x83b9a2, 0x84ef05, 0x862753, 0x876293, 0x88a0ce, 0x89e20a, 0x8b264f, 0x8c6da4, 0x8db813,
	0x8f05a1, 0x905658, 0x91aa3f, 0x93015f, 0x945bbf, 0x95b968, 0x971a62, 0x987eb5, 0x99e66b, 0x9b518c,
	0x9cc020, 0x9e3230, 0x9fa7c5, 0xa120e9, 0xa29da3, 0xa41dfe, 0xa5a203, 0xa729bb, 0xa8b52f, 0xaa4469,
	0xabd773, 0xad6e57, 0xaf091d, 0xb0a7d2, 0xb24a7d, 0xb3f12a, 0xb59be4, 0xb74ab3, 0xb8fda4, 0xbab4c0,
	0xbc7012, 0xbe2fa5, 0xbff38c, 0xc1bbc3, 0xc3885c, 0xc55963, 0xc72ee4, 0xc908e9, 0xcae77e, 0xcccab0,
	0xceb28b, 0xd09f19, 0xd29069, 0xd48685, 0xd6817b, 0xd88157, 0xda8626, 0xdc8ff4, 0xde9ecf, 0xe0b2c4,
	0xe2cbe1, 0xe4ea32, 0xe70dc5, 0xe936a9, 0xeb64ea, 0xed9898, 0xefd1c0, 0xf21070, 0xf454b7, 0xf69ea5,
	0xf8ee46, 0xfb43ac, 0xfd9ee4, 0xffffff,
};

uint32_t hdr_hlg_degamma_tbl[HDR_DEGAMMA_LUT_SIZE] = {
	0x0, 0x5, 0x15, 0x30, 0x55, 0x85, 0xc0, 0x105, 0x156, 0x1b0,
	0x216, 0x286, 0x301, 0x387, 0x417, 0x4b2, 0x558, 0x608, 0x6c3, 0x789,
	0x859, 0x934, 0xa1a, 0xb0a, 0xc06, 0xd0b, 0xe1c, 0xf37, 0x105d, 0x118e,
	0x12c9, 0x140f, 0x1560, 0x16bb, 0x1821, 0x1992, 0x1b0d, 0x1c93, 0x1e24, 0x1fbf,
	0x2166, 0x2316, 0x24d2, 0x2698, 0x2869, 0x2a45, 0x2c2b, 0x2e1c, 0x3018, 0x321e,
	0x342f, 0x364b, 0x3871, 0x3aa2, 0x3cde, 0x3f24, 0x4176, 0x43d1, 0x4638, 0x48a9,
	0x4b25, 0x4dac, 0x503d, 0x52d9, 0x5580, 0x5831, 0x5aed, 0x5db4, 0x6085, 0x6361,
	0x6648, 0x6939, 0x6c36, 0x6f3c, 0x724e, 0x756a, 0x7891, 0x7bc3, 0x7eff, 0x8246,
	0x8598, 0x88f4, 0x8c5b, 0x8fcd, 0x9349, 0x96d0, 0x9a62, 0x9dfe, 0xa1a6, 0xa557,
	0xa914, 0xacdb, 0xb0ad, 0xb48a, 0xb871, 0xbc63, 0xc060, 0xc467, 0xc879, 0xcc96,
	0xd0bd, 0xd4ef, 0xd92c, 0xdd74, 0xe1c6, 0xe623, 0xea8a, 0xeefc, 0xf379, 0xf801,
	0xfc93, 0x10130, 0x105d8, 0x10a8a, 0x10f47, 0x1140f, 0x118e1, 0x11dbe, 0x122a6, 0x12799,
	0x12c96, 0x1319e, 0x136b0, 0x13bcd, 0x140f5, 0x14628, 0x14b65, 0x150ad, 0x15600, 0x15b5d,
	0x160c5, 0x16638, 0x16bb5, 0x1713d, 0x176d0, 0x17c6e, 0x18216, 0x187c9, 0x18d86, 0x1934e,
	0x19921, 0x19eff, 0x1a4e7, 0x1aada, 0x1b0d8, 0x1b6e0, 0x1bcf3, 0x1c311, 0x1c939, 0x1cf6c,
	0x1d5aa, 0x1dbf3, 0x1e246, 0x1e8a4, 0x1ef0c, 0x1f57f, 0x1fbfd, 0x20286, 0x20919, 0x20fb7,
	0x21660, 0x21d13, 0x223d1, 0x22a9a, 0x2316d, 0x2384b, 0x23f34, 0x24628, 0x24d26, 0x2542f,
	0x25b42, 0x26261, 0x26989, 0x270bd, 0x277fb, 0x27f44, 0x28698, 0x28df6, 0x2955f, 0x29cd3,
	0x2a451, 0x2abdb, 0x2b36e, 0x2bb0d, 0x2c2b6, 0x2ca6a, 0x2d228, 0x2d9f2, 0x2e1c6, 0x2e9a4,
	0x2f18d, 0x2f981, 0x30180, 0x30989, 0x3119d, 0x319bc, 0x321e6, 0x32a1a, 0x33258, 0x33aa2,
	0x342f6, 0x34b55, 0x353be, 0x35c33, 0x364b2, 0x36d3b, 0x375d0, 0x37e6e, 0x38718, 0x38fcc,
	0x3988c, 0x3a155, 0x3aa2a, 0x3b309, 0x3bbf3, 0x3c4e7, 0x3cde6, 0x3d6f0, 0x3e005, 0x3e924,
	0x3f24e, 0x3fb82, 0x404c2, 0x40e0c, 0x41760, 0x420c0, 0x42a2a, 0x4339e, 0x43d1e, 0x446a8,
	0x4503d, 0x459dc, 0x46386, 0x46d3b, 0x476fb, 0x480c5, 0x48a9a, 0x49479, 0x49e64, 0x4a859,
	0x4b258, 0x4bc63, 0x4c678, 0x4d097, 0x4dac2, 0x4e4f7, 0x4ef37, 0x4f981, 0x503d6, 0x50e36,
	0x518a1, 0x52316, 0x52d96, 0x53821, 0x542b6, 0x54d56, 0x55800, 0x562b6, 0x56d76, 0x57841,
	0x58316, 0x58df6, 0x598e1, 0x5a3d6, 0x5aed7, 0x5b9e1, 0x5c4f7, 0x5d017, 0x5db42, 0x5e678,
	0x5f1b8, 0x5fd03, 0x60859, 0x613b9, 0x61f24, 0x62a9a, 0x6361a, 0x641a5, 0x64d3b, 0x658dc,
	0x66487, 0x6703d, 0x67bfd, 0x687c8, 0x6939e, 0x69f7f, 0x6ab6a, 0x6b760, 0x6c361, 0x6cf6c,
	0x6db82, 0x6e7a3, 0x6f3ce, 0x70004, 0x70c45, 0x71891, 0x724e7, 0x73148, 0x73db3, 0x74a29,
	0x756aa, 0x76336, 0x76fcc, 0x77c6d, 0x78919, 0x795cf, 0x7a290, 0x7af5c, 0x7bc32, 0x7c914,
	0x7d5ff, 0x7e2f6, 0x7eff7, 0x7fd03, 0x80a19, 0x8173b, 0x82467, 0x8319d, 0x83ede, 0x84c2a,
	0x85981, 0x866e2, 0x8744e, 0x881c5, 0x88f47, 0x89cd3, 0x8aa69, 0x8b80b, 0x8c5b7, 0x8d36e,
	0x8e12f, 0x8eefc, 0x8fcd3, 0x90ab4, 0x918a0, 0x92697, 0x93499, 0x942a6, 0x950bd, 0x95ede,
	0x96d0b, 0x97b42, 0x98984, 0x997d0, 0x9a627, 0x9b489, 0x9c2f6, 0x9d16d, 0x9dfef, 0x9ee7b,
	0x9fd13, 0xa0bb5, 0xa1a61, 0xa2919, 0xa37db, 0xa46a7, 0xa557f, 0xa6461, 0xa734e, 0xa8245,
	0xa9147, 0xaa054, 0xaaf6c, 0xabe8e, 0xacdbb, 0xadcf3, 0xaec35, 0xafb82, 0xb0ada, 0xb1a3c,
	0xb29a9, 0xb3921, 0xb48a3, 0xb5830, 0xb67c8, 0xb776a, 0xb8718, 0xb96cf, 0xba692, 0xbb65f,
	0xbc637, 0xbd61a, 0xbe607, 0xbf5ff, 0xc0602, 0xc160f, 0xc2627, 0xc364a, 0xc4677, 0xc56af,
	0xc66f2, 0xc7740, 0xc8798, 0xc97fb, 0xca868, 0xcb8e0, 0xcc963, 0xcd9f1, 0xcea89, 0xcfb2c,
	0xd0bda, 0xd1c92, 0xd2d55, 0xd3e23, 0xd4efb, 0xd5fdf, 0xd70cc, 0xd81c5, 0xd92c8, 0xda3d6,
	0xdb4ee, 0xdc612, 0xdd740, 0xde878, 0xdf9bb, 0xe0b09, 0xe1c62, 0xe2dc5, 0xe3f33, 0xe50ac,
	0xe6230, 0xe73be, 0xe8557, 0xe96fa, 0xea8a8, 0xeba61, 0xecc25, 0xeddf3, 0xeefcc, 0xf01af,
	0xf139e, 0xf2597, 0xf379a, 0xf49a9, 0xf5bc2, 0xf6de5, 0xf8014, 0xf924d, 0xfa491, 0xfb6df,
	0xfc938, 0xfdb9c, 0xfee0b, 0x100084, 0x101308, 0x102597, 0x103830, 0x104ad4, 0x105d83, 0x10703c,
	0x108300, 0x1095cf, 0x10a8a8, 0x10bb8c, 0x10ce7b, 0x10e174, 0x10f479, 0x110787, 0x111aa1, 0x112dc5,
	0x1140f4, 0x11542e, 0x116772, 0x117ac1, 0x118e1b, 0x11a17f, 0x11b4ee, 0x11c868, 0x11dbec, 0x11ef7b,
	0x120315, 0x1216ba, 0x122a69, 0x123e23, 0x1251e7, 0x1265b6, 0x127990, 0x128d75, 0x12a164, 0x12b55e,
	0x12c963, 0x12dd72, 0x12f18c, 0x1305b1, 0x1319e0, 0x132e1b, 0x13425f, 0x1356af, 0x136b09, 0x137f6e,
	0x1393dd, 0x13a858, 0x13bcdd, 0x13d16c, 0x13e606, 0x13faab, 0x140f5b, 0x142416, 0x1438db, 0x144daa,
	0x146285, 0x14776a, 0x148c5a, 0x14a154, 0x14b659, 0x14cb69, 0x14e084, 0x14f5a9, 0x150ad9, 0x152013,
	0x153559, 0x154aa9, 0x156006, 0x15757e, 0x158b15, 0x15a0ca, 0x15b69e, 0x15cc90, 0x15e2a1, 0x15f8d1,
	0x160f20, 0x16258e, 0x163c1c, 0x1652c9, 0x166997, 0x168084, 0x169791, 0x16aebf, 0x16c60d, 0x16dd7c,
	0x16f50c, 0x170cbd, 0x17248f, 0x173c83, 0x175498, 0x176ccf, 0x178528, 0x179da3, 0x17b641, 0x17cf01,
	0x17e7e4, 0x1800e9, 0x181a12, 0x18335e, 0x184cce, 0x186662, 0x188019, 0x1899f4, 0x18b3f4, 0x18ce18,
	0x18e860, 0x1902ce, 0x191d61, 0x193819, 0x1952f6, 0x196df9, 0x198922, 0x19a471, 0x19bfe7, 0x19db83,
	0x19f746, 0x1a132f, 0x1a2f40, 0x1a4b78, 0x1a67d8, 0x1a8460, 0x1aa10f, 0x1abde7, 0x1adae8, 0x1af811,
	0x1b1563, 0x1b32de, 0x1b5083, 0x1b6e51, 0x1b8c49, 0x1baa6b, 0x1bc8b7, 0x1be72e, 0x1c05cf, 0x1c249c,
	0x1c4393, 0x1c62b6, 0x1c8205, 0x1ca180, 0x1cc127, 0x1ce0fa, 0x1d00fa, 0x1d2127, 0x1d4181, 0x1d6209,
	0x1d82be, 0x1da3a1, 0x1dc4b2, 0x1de5f2, 0x1e0760, 0x1e28fd, 0x1e4ac9, 0x1e6cc5, 0x1e8ef0, 0x1eb14c,
	0x1ed3d7, 0x1ef693, 0x1f1980, 0x1f3c9e, 0x1f5fed, 0x1f836d, 0x1fa720, 0x1fcb04, 0x1fef1c, 0x201365,
	0x2037e1, 0x205c91, 0x208174, 0x20a68b, 0x20cbd6, 0x20f155, 0x211709, 0x213cf1, 0x21630f, 0x218963,
	0x21afec, 0x21d6ab, 0x21fda1, 0x2224cd, 0x224c30, 0x2273cb, 0x229b9d, 0x22c3a7, 0x22ebe9, 0x231463,
	0x233d17, 0x236603, 0x238f29, 0x23b889, 0x23e223, 0x240bf7, 0x243606, 0x24604f, 0x248ad4, 0x24b595,
	0x24e092, 0x250bcb, 0x253741, 0x2562f4, 0x258ee4, 0x25bb11, 0x25e77d, 0x261427, 0x264110, 0x266e38,
	0x269b9f, 0x26c945, 0x26f72c, 0x272553, 0x2753bb, 0x278265, 0x27b14f, 0x27e07c, 0x280fea, 0x283f9b,
	0x286f8f, 0x289fc7, 0x28d042, 0x290101, 0x293204, 0x29634c, 0x2994da, 0x29c6ad, 0x29f8c5, 0x2a2b25,
	0x2a5dca, 0x2a90b7, 0x2ac3ec, 0x2af768, 0x2b2b2d, 0x2b5f3a, 0x2b9390, 0x2bc82f, 0x2bfd19, 0x2c324c,
	0x2c67cb, 0x2c9d94, 0x2cd3a9, 0x2d0a09, 0x2d40b6, 0x2d77b0, 0x2daef7, 0x2de68b, 0x2e1e6d, 0x2e569e,
	0x2e8f1e, 0x2ec7ed, 0x2f010b, 0x2f3a7a, 0x2f7439, 0x2fae4a, 0x2fe8ab, 0x30235f, 0x305e65, 0x3099be,
	0x30d56a, 0x31116a, 0x314dbe, 0x318a67, 0x31c765, 0x3204b9, 0x324262, 0x328062, 0x32beb9, 0x32fd68,
	0x333c6e, 0x337bcd, 0x33bb85, 0x33fb96, 0x343c01, 0x347cc7, 0x34bde7, 0x34ff63, 0x35413a, 0x35836f,
	0x35c5ff, 0x3608ee, 0x364c3a, 0x368fe5, 0x36d3ee, 0x371857, 0x375d21, 0x37a24a, 0x37e7d5, 0x382dc1,
	0x38740f, 0x38bac0, 0x3901d4, 0x39494c, 0x399129, 0x39d96a, 0x3a2211, 0x3a6b1d, 0x3ab490, 0x3afe6a,
	0x3b48ac, 0x3b9355, 0x3bde68, 0x3c29e4, 0x3c75c9, 0x3cc21a, 0x3d0ed5, 0x3d5bfc, 0x3da98f, 0x3df78f,
	0x3e45fd, 0x3e94d8, 0x3ee423, 0x3f33dc, 0x3f8405, 0x3fd49f, 0x4025aa, 0x407727, 0x40c916, 0x411b78,
	0x416e4d, 0x41c197, 0x421556, 0x42698a, 0x42be34, 0x431355, 0x4368ee, 0x43befe, 0x441588, 0x446c8b,
	0x44c407, 0x451bff, 0x457472, 0x45cd61, 0x4626cd, 0x4680b7, 0x46db1f, 0x473605, 0x47916b, 0x47ed51,
	0x4849b9, 0x48a6a1, 0x49040d, 0x4961fb, 0x49c06d, 0x4a1f64, 0x4a7ee0, 0x4adee2, 0x4b3f6a, 0x4ba07a,
	0x4c0212, 0x4c6434, 0x4cc6de, 0x4d2a14, 0x4d8dd4, 0x4df221, 0x4e56fa, 0x4ebc61, 0x4f2256, 0x4f88da,
	0x4fefef, 0x505794, 0x50bfca, 0x512892, 0x5191ed, 0x51fbdc, 0x526660, 0x52d179, 0x533d28, 0x53a96f,
	0x54164d, 0x5483c5, 0x54f1d5, 0x556081, 0x55cfc7, 0x563faa, 0x56b02a, 0x572147, 0x579303, 0x58055f,
	0x58785b, 0x58ebf9, 0x596039, 0x59d51c, 0x5a4aa3, 0x5ac0cf, 0x5b37a0, 0x5baf19, 0x5c2739, 0x5ca001,
	0x5d1973, 0x5d9390, 0x5e0e58, 0x5e89cc, 0x5f05ed, 0x5f82bd, 0x60003b, 0x607e6a, 0x60fd4a, 0x617cdc,
	0x61fd20, 0x627e19, 0x62ffc7, 0x63822b, 0x640545, 0x648918, 0x650da4, 0x6592e9, 0x6618ea, 0x669fa6,
	0x672720, 0x67af58, 0x68384f, 0x68c206, 0x694c7e, 0x69d7b8, 0x6a63b6, 0x6af079, 0x6b7e01, 0x6c0c4f,
	0x6c9b65, 0x6d2b44, 0x6dbbed, 0x6e4d61, 0x6edfa3, 0x6f72b0, 0x70068b, 0x709b36, 0x7130b2, 0x71c6ff,
	0x725e1f, 0x72f613, 0x738edd, 0x74287c, 0x74c2f4, 0x755e44, 0x75fa6e, 0x769773, 0x773554, 0x77d413,
	0x7873b1, 0x79142f, 0x79b58e, 0x7a57cf, 0x7afaf4, 0x7b9efe, 0x7c43ee, 0x7ce9c5, 0x7d9086, 0x7e3830,
	0x7ee0c5, 0x7f8a47, 0x8034b7, 0x80e016, 0x818c65, 0x8239a7, 0x82e7db, 0x839704, 0x844722, 0x84f838,
	0x85aa46, 0x865d4e, 0x871151, 0x87c651, 0x887c4f, 0x89334c, 0x89eb49, 0x8aa449, 0x8b5e4d, 0x8c1956,
	0x8cd565, 0x8d927c, 0x8e509c, 0x8f0fc7, 0x8fcffe, 0x909143, 0x915397, 0x9216fc, 0x92db73, 0x93a0fe,
	0x94679d, 0x952f54, 0x95f823, 0x96c20b, 0x978d0f, 0x985930, 0x99266f, 0x99f4ce, 0x9ac452, 0x9b94f6,
	0x9c66be, 0x9d39ad, 0x9e0dc4, 0x9ee305, 0x9fb970, 0xa09109, 0xa169d0, 0xa243c7, 0xa31ef0, 0xa3fb4d,
	0xa4d8df, 0xa5b7a8, 0xa697a9, 0xa778e5, 0xa85b5c, 0xa93f12, 0xaa2407, 0xab0a3d, 0xabf1b6, 0xacda74,
	0xadc479, 0xaeafc6, 0xaf9c5d, 0xb08a40, 0xb17971, 0xb269f2, 0xb35bc4, 0xb44ee9, 0xb54363, 0xb63935,
	0xb7305f, 0xb828e5, 0xb922c7, 0xba1e07, 0xbb1aa8, 0xbc18ac, 0xbd1814, 0xbe18e2, 0xbf1b19, 0xc01eba,
	0xc123c7, 0xc22a43, 0xc3322f, 0xc43b8d, 0xc54660, 0xc652a9, 0xc7606a, 0xc86fa6, 0xc9805f, 0xca9296,
	0xcba64e, 0xccbb89, 0xcdd249, 0xceea90, 0xd00460, 0xd11fbb, 0xd23ca5, 0xd35b1e, 0xd47b29, 0xd59cc8,
	0xd6bffd, 0xd7e4cc, 0xd90b39, 0xda333f, 0xdb5ce5, 0xdc882c, 0xddb517, 0xdee3a8, 0xe013e2, 0xe145c7,
	0xe27959, 0xe3ae9a, 0xe4e58e, 0xe61e36, 0xe75894, 0xe894ac, 0xe9d27f, 0xeb1210, 0xec5361, 0xed9676,
	0xeedb4f, 0xf021f1, 0xf16a5c, 0xf2b495, 0xf4009d, 0xf54e77, 0xf69e25, 0xf7efaa, 0xf94309, 0xfa9844,
	0xfbef5e, 0xfd4859, 0xfea339, 0xffffff,
};

uint32_t hdr_default_degamma_tbl[HDR_DEGAMMA_LUT_SIZE] = {
	0x000000, 0x000e3c, 0x001c78, 0x002ab5, 0x0038f1, 0x00472e, 0x00556a, 0x0063a7, 0x0071e3, 0x008020,
	0x008e5c, 0x009c98, 0x00aad5, 0x00b911, 0x00c74e, 0x00d58a, 0x00e3c7, 0x00f203, 0x010040, 0x010e7c,
	0x011cb8, 0x012af5, 0x013931, 0x01476e, 0x0155aa, 0x0163e7, 0x017223, 0x018060, 0x018e9c, 0x019cd8,
	0x01ab15, 0x01b951, 0x01c78e, 0x01d5ca, 0x01e407, 0x01f243, 0x020080, 0x020ebc, 0x021cf9, 0x022b35,
	0x023971, 0x0247ae, 0x0255ea, 0x026427, 0x027263, 0x0280a0, 0x028edc, 0x029d19, 0x02ab55, 0x02b991,
	0x02c7ce, 0x02d60a, 0x02e447, 0x02f283, 0x0300c0, 0x030efc, 0x031d39, 0x032b75, 0x0339b1, 0x0347ee,
	0x03562a, 0x036467, 0x0372a3, 0x0380e0, 0x038f1c, 0x039d59, 0x03ab95, 0x03b9d1, 0x03c80e, 0x03d64a,
	0x03e487, 0x03f2c3, 0x040100, 0x040f3c, 0x041d79, 0x042bb5, 0x0439f2, 0x04482e, 0x04566a, 0x0464a7,
	0x0472e3, 0x048120, 0x048f5c, 0x0499fd, 0x04a83e, 0x04b697, 0x04c508, 0x04d391, 0x04e232, 0x04f0ec,
	0x04ffbe, 0x050ea8, 0x051dab, 0x052cc6, 0x053bf9, 0x054b45, 0x055aaa, 0x056a27, 0x0579bc, 0x05896a,
	0x059930, 0x05a90f, 0x05b907, 0x05c917, 0x05d940, 0x05e982, 0x05f9dd, 0x060a50, 0x061adc, 0x062b81,
	0x063c3e, 0x064d15, 0x065e04, 0x066f0d, 0x06802e, 0x069168, 0x06a2bb, 0x06b428, 0x06c5ad, 0x06d74b,
	0x06e903, 0x06fad3, 0x070cbd, 0x071ec0, 0x0730dc, 0x074311, 0x075560, 0x0767c8, 0x077a49, 0x078ce3,
	0x079f97, 0x07b264, 0x07c54b, 0x07d84b, 0x07eb64, 0x07fe97, 0x0811e3, 0x082549, 0x0838c9, 0x084c62,
	0x086014, 0x0873e0, 0x0887c6, 0x089bc6, 0x08afdf, 0x08c412, 0x08d85e, 0x08ecc5, 0x090145, 0x0915df,
	0x092a92, 0x093f60, 0x095447, 0x096949, 0x097e64, 0x099399, 0x09a8e8, 0x09be51, 0x09d3d4, 0x09e971,
	0x09ff28, 0x0a14fa, 0x0a2ae5, 0x0a40ea, 0x0a570a, 0x0a6d43, 0x0a8397, 0x0a9a05, 0x0ab08e, 0x0ac730,
	0x0added, 0x0af4c4, 0x0b0bb5, 0x0b22c1, 0x0b39e7, 0x0b5128, 0x0b6882, 0x0b7ff8, 0x0b9787, 0x0baf31,
	0x0bc6f6, 0x0bded5, 0x0bf6cf, 0x0c0ee3, 0x0c2711, 0x0c3f5b, 0x0c57bf, 0x0c703d, 0x0c88d6, 0x0ca18a,
	0x0cba58, 0x0cd342, 0x0cec46, 0x0d0564, 0x0d1e9e, 0x0d37f2, 0x0d5161, 0x0d6aeb, 0x0d848f, 0x0d9e4f,
	0x0db829, 0x0dd21f, 0x0dec2f, 0x0e065a, 0x0e20a0, 0x0e3b01, 0x0e557e, 0x0e7015, 0x0e8ac7, 0x0ea594,
	0x0ec07c, 0x0edb80, 0x0ef69e, 0x0f11d8, 0x0f2d2d, 0x0f489d, 0x0f6428, 0x0f7fcf, 0x0f9b91, 0x0fb76e,
	0x0fd366, 0x0fef79, 0x100ba8, 0x1027f2, 0x104458, 0x1060d9, 0x107d75, 0x109a2c, 0x10b6ff, 0x10d3ee,
	0x10f0f8, 0x110e1d, 0x112b5e, 0x1148bb, 0x116633, 0x1183c6, 0x11a176, 0x11bf40, 0x11dd27, 0x11fb28,
	0x121946, 0x12377f, 0x1255d4, 0x127445, 0x1292d1, 0x12b179, 0x12d03d, 0x12ef1c, 0x130e18, 0x132d2f,
	0x134c62, 0x136bb1, 0x138b1c, 0x13aaa2, 0x13ca44, 0x13ea03, 0x1409dd, 0x1429d3, 0x1449e5, 0x146a14,
	0x148a5e, 0x14aac4, 0x14cb46, 0x14ebe4, 0x150c9f, 0x152d75, 0x154e67, 0x156f76, 0x1590a1, 0x15b1e8,
	0x15d34b, 0x15f4ca, 0x161665, 0x16381d, 0x1659f1, 0x167be1, 0x169ded, 0x16c016, 0x16e25b, 0x1704bc,
	0x17273a, 0x1749d4, 0x176c8a, 0x178f5d, 0x17b24c, 0x17d558, 0x17f880, 0x181bc4, 0x183f25, 0x1862a2,
	0x18863c, 0x18a9f2, 0x18cdc5, 0x18f1b5, 0x1915c1, 0x1939e9, 0x195e2e, 0x198290, 0x19a70f, 0x19cbaa,
	0x19f061, 0x1a1536, 0x1a3a27, 0x1a5f35, 0x1a845f, 0x1aa9a7, 0x1acf0b, 0x1af48b, 0x1b1a29, 0x1b3fe3,
	0x1b65ba, 0x1b8bae, 0x1bb1bf, 0x1bd7ed, 0x1bfe37, 0x1c249f, 0x1c4b23, 0x1c71c4, 0x1c9883, 0x1cbf5e,
	0x1ce656, 0x1d0d6b, 0x1d349d, 0x1d5bec, 0x1d8359, 0x1daae2, 0x1dd288, 0x1dfa4c, 0x1e222c, 0x1e4a2a,
	0x1e7244, 0x1e9a7c, 0x1ec2d1, 0x1eeb43, 0x1f13d3, 0x1f3c7f, 0x1f6549, 0x1f8e30, 0x1fb734, 0x1fe056,
	0x200994, 0x2032f1, 0x205c6a, 0x208600, 0x20afb4, 0x20d986, 0x210374, 0x212d80, 0x2157aa, 0x2181f1,
	0x21ac55, 0x21d6d7, 0x220176, 0x222c32, 0x22570c, 0x228204, 0x22ad19, 0x22d84b, 0x23039c, 0x232f09,
	0x235a94, 0x23863d, 0x23b204, 0x23dde8, 0x2409e9, 0x243608, 0x246245, 0x248ea0, 0x24bb18, 0x24e7ae,
	0x251462, 0x254133, 0x256e22, 0x259b2f, 0x25c85a, 0x25f5a2, 0x262308, 0x26508c, 0x267e2e, 0x26abed,
	0x26d9cb, 0x2707c6, 0x2735df, 0x276416, 0x27926b, 0x27c0de, 0x27ef6e, 0x281e1d, 0x284cea, 0x287bd4,
	0x28aadd, 0x28da03, 0x290948, 0x2938ab, 0x29682b, 0x2997ca, 0x29c787, 0x29f761, 0x2a275a, 0x2a5771,
	0x2a87a7, 0x2ab7fa, 0x2ae86b, 0x2b18fb, 0x2b49a8, 0x2b7a74, 0x2bab5e, 0x2bdc67, 0x2c0d8d, 0x2c3ed2,
	0x2c7035, 0x2ca1b6, 0x2cd356, 0x2d0513, 0x2d36ef, 0x2d68ea, 0x2d9b03, 0x2dcd3a, 0x2dff8f, 0x2e3203,
	0x2e6495, 0x2e9745, 0x2eca14, 0x2efd02, 0x2f300e, 0x2f6338, 0x2f9680, 0x2fc9e8, 0x2ffd6d, 0x303111,
	0x3064d4, 0x3098b5, 0x30ccb5, 0x3100d3, 0x313510, 0x31696c, 0x319de6, 0x31d27e, 0x320735, 0x323c0b,
	0x3270ff, 0x32a612, 0x32db44, 0x331094, 0x334604, 0x337b91, 0x33b13e, 0x33e709, 0x341cf3, 0x3452fb,
	0x348923, 0x34bf69, 0x34f5ce, 0x352c52, 0x3562f4, 0x3599b6, 0x35d096, 0x360795, 0x363eb3, 0x3675f0,
	0x36ad4b, 0x36e4c6, 0x371c5f, 0x375418, 0x378bef, 0x37c3e6, 0x37fbfb, 0x38342f, 0x386c82, 0x38a4f4,
	0x38dd86, 0x391636, 0x394f05, 0x3987f3, 0x39c100, 0x39fa2d, 0x3a3378, 0x3a6ce3, 0x3aa66c, 0x3ae015,
	0x3b19dd, 0x3b53c4, 0x3b8dca, 0x3bc7ef, 0x3c0234, 0x3c3c97, 0x3c771a, 0x3cb1bc, 0x3cec7d, 0x3d275e,
	0x3d625e, 0x3d9d7d, 0x3dd8bb, 0x3e1418, 0x3e4f95, 0x3e8b31, 0x3ec6ed, 0x3f02c8, 0x3f3ec2, 0x3f7adb,
	0x3fb714, 0x3ff36c, 0x402fe4, 0x406c7b, 0x40a931, 0x40e607, 0x4122fc, 0x416011, 0x419d45, 0x41da98,
	0x42180b, 0x42559e, 0x429350, 0x42d121, 0x430f12, 0x434d23, 0x438b53, 0x43c9a2, 0x440812, 0x4446a0,
	0x44854f, 0x44c41d, 0x45030a, 0x454217, 0x458144, 0x45c091, 0x45fffd, 0x463f89, 0x467f34, 0x46beff,
	0x46feea, 0x473ef5, 0x477f1f, 0x47bf69, 0x47ffd3, 0x48405c, 0x488105, 0x48c1ce, 0x4902b7, 0x4943c0,
	0x4984e8, 0x49c631, 0x4a0799, 0x4a4921, 0x4a8aca, 0x4acc91, 0x4b0e79, 0x4b5080, 0x4b92a8, 0x4bd4ef,
	0x4c1756, 0x4c59dd, 0x4c9c84, 0x4cdf4b, 0x4d2232, 0x4d6539, 0x4da860, 0x4deba7, 0x4e2f0e, 0x4e7295,
	0x4eb63c, 0x4efa03, 0x4f3dea, 0x4f81f1, 0x4fc618, 0x500a60, 0x504ec7, 0x50934e, 0x50d7f6, 0x511cbe,
	0x5161a6, 0x51a6ae, 0x51ebd6, 0x52311e, 0x527687, 0x52bc0f, 0x5301b8, 0x534781, 0x538d6b, 0x53d374,
	0x54199e, 0x545fe8, 0x54a652, 0x54ecdd, 0x553388, 0x557a53, 0x55c13e, 0x56084a, 0x564f76, 0x5696c3,
	0x56de30, 0x5725bd, 0x576d6a, 0x57b538, 0x57fd27, 0x584535, 0x588d64, 0x58d5b4, 0x591e24, 0x5966b4,
	0x59af65, 0x59f836, 0x5a4128, 0x5a8a3a, 0x5ad36d, 0x5b1cc0, 0x5b6634, 0x5bafc8, 0x5bf97e, 0x5c4354,
	0x5c8d4a, 0x5cd760, 0x5d2197, 0x5d6bef, 0x5db667, 0x5e0100, 0x5e4bb9, 0x5e9693, 0x5ee18e, 0x5f2ca9,
	0x5f77e5, 0x5fc342, 0x600ebf, 0x605a5d, 0x60a61c, 0x60f1fc, 0x613dfc, 0x618a1d, 0x61d65e, 0x6222c0,
	0x626f44, 0x62bbe7, 0x6308ac, 0x635591, 0x63a298, 0x63efbf, 0x643d07, 0x648a6f, 0x64d7f9, 0x6525a3,
	0x65736e, 0x65c15a, 0x660f67, 0x665d95, 0x66abe4, 0x66fa53, 0x6748e4, 0x679795, 0x67e668, 0x68355b,
	0x68846f, 0x68d3a4, 0x6922fb, 0x697272, 0x69c20a, 0x6a11c3, 0x6a619d, 0x6ab198, 0x6b01b5, 0x6b51f2,
	0x6ba250, 0x6bf2d0, 0x6c4370, 0x6c9431, 0x6ce514, 0x6d3618, 0x6d873d, 0x6dd882, 0x6e29ea, 0x6e7b72,
	0x6ecd1b, 0x6f1ee5, 0x6f70d2, 0x6fc2df, 0x70150d, 0x70675c, 0x70b9cd, 0x710c5e, 0x715f11, 0x71b1e5,
	0x7204db, 0x7257f1, 0x72ab29, 0x72fe82, 0x7351fc, 0x73a598, 0x73f955, 0x744d33, 0x74a133, 0x74f554,
	0x754996, 0x759df9, 0x75f27e, 0x764725, 0x769bec, 0x76f0d5, 0x7745e0, 0x779b0c, 0x77f059, 0x7845c7,
	0x789b57, 0x78f109, 0x7946dc, 0x799cd0, 0x79f2e6, 0x7a491e, 0x7a9f76, 0x7af5f1, 0x7b4c8d, 0x7ba34a,
	0x7bfa29, 0x7c5129, 0x7ca84b, 0x7cff8e, 0x7d56f4, 0x7dae7a, 0x7e0622, 0x7e5dec, 0x7eb5d7, 0x7f0de4,
	0x7f6613, 0x7fbe63, 0x8016d5, 0x806f68, 0x80c81d, 0x8120f4, 0x8179ed, 0x81d307, 0x822c42, 0x8285a0,
	0x82df1f, 0x8338c0, 0x839283, 0x83ec67, 0x84466d, 0x84a095, 0x84fae0, 0x85554b, 0x85afd8, 0x860a87,
	0x866558, 0x86c04a, 0x871b5e, 0x877695, 0x87d1ed, 0x882d66, 0x888902, 0x88e4bf, 0x89409f, 0x899ca0,
	0x89f8c3, 0x8a5508, 0x8ab16f, 0x8b0df8, 0x8b6aa2, 0x8bc76f, 0x8c245e, 0x8c816e, 0x8cdea1, 0x8d3bf5,
	0x8d996b, 0x8df704, 0x8e54be, 0x8eb29a, 0x8f1099, 0x8f6eb9, 0x8fccfb, 0x902b60, 0x9089e6, 0x90e88f,
	0x914759, 0x91a646, 0x920555, 0x926485, 0x92c3d8, 0x93234d, 0x9382e4, 0x93e29d, 0x944279, 0x94a276,
	0x950296, 0x9562d8, 0x95c33b, 0x9623c2, 0x96846a, 0x96e534, 0x974621, 0x97a730, 0x980861, 0x9869b4,
	0x98cb29, 0x992cc1, 0x998e7b, 0x99f057, 0x9a5256, 0x9ab477, 0x9b16ba, 0x9b791f, 0x9bdba7, 0x9c3e51,
	0x9ca11e, 0x9d040d, 0x9d671e, 0x9dca51, 0x9e2da7, 0x9e911f, 0x9ef4b9, 0x9f5876, 0x9fbc55, 0xa02056,
	0xa0847a, 0xa0e8c0, 0xa14d29, 0xa1b1b4, 0xa21661, 0xa27b31, 0xa2e024, 0xa34539, 0xa3aa70, 0xa40fca,
	0xa47546, 0xa4dae5, 0xa540a6, 0xa5a68a, 0xa60c90, 0xa672b9, 0xa6d904, 0xa73f72, 0xa7a603, 0xa80cb6,
	0xa8738b, 0xa8da83, 0xa9419e, 0xa9a8db, 0xaa103b, 0xaa77be, 0xaadf63, 0xab472b, 0xabaf15, 0xac1722,
	0xac7f52, 0xace7a4, 0xad5019, 0xadb8b1, 0xae216b, 0xae8a48, 0xaef348, 0xaf5c6a, 0xafc5af, 0xb02f17,
	0xb098a2, 0xb1024f, 0xb16c1f, 0xb1d612, 0xb24027, 0xb2aa60, 0xb314bb, 0xb37f39, 0xb3e9d9, 0xb4549d,
	0xb4bf83, 0xb52a8c, 0xb595b8, 0xb60107, 0xb66c7a, 0xb6d80f, 0xb743c6, 0xb7afa0, 0xb81b9d, 0xb887bd,
	0xb8f400, 0xb96066, 0xb9ccee, 0xba399a, 0xbaa668, 0xbb135a, 0xbb806e, 0xbbeda5, 0xbc5b00, 0xbcc87d,
	0xbd361d, 0xbda3e0, 0xbe11c6, 0xbe7fcf, 0xbeedfc, 0xbf5c4b, 0xbfcabd, 0xc03952, 0xc0a80a, 0xc116e5,
	0xc185e4, 0xc1f505, 0xc26449, 0xc2d3b1, 0xc3433c, 0xc3b2e9, 0xc422ba, 0xc492ae, 0xc502c5, 0xc572ff,
	0xc5e35c, 0xc653dc, 0xc6c480, 0xc73546, 0xc7a630, 0xc8173d, 0xc8886d, 0xc8f9c1, 0xc96b37, 0xc9dcd1,
	0xca4e8e, 0xcac06e, 0xcb3271, 0xcba498, 0xcc16e1, 0xcc894e, 0xccfbdf, 0xcd6e92, 0xcde169, 0xce5463,
	0xcec780, 0xcf3ac1, 0xcfae25, 0xd021ac, 0xd09557, 0xd10925, 0xd17d16, 0xd1f12a, 0xd26564, 0xd2d9bf,
	0xd34e3e, 0xd3c2e0, 0xd437a5, 0xd4ac8e, 0xd5219a, 0xd596ca, 0xd60c1c, 0xd68193, 0xd6f72c, 0xd76cea,
	0xd7e2ca, 0xd858ce, 0xd8cef6, 0xd94541, 0xd9bbaf, 0xda3241, 0xdaa8f6, 0xdb1fcf, 0xdb96cb, 0xdc0deb,
	0xdc852f, 0xdcfc95, 0xdd7420, 0xddebce, 0xde639f, 0xdedb94, 0xdf53ad, 0xdfcbe9, 0xe04448, 0xe0bccc,
	0xe13573, 0xe1ae3d, 0xe2272b, 0xe2a03d, 0xe31972, 0xe392cb, 0xe40c47, 0xe485e7, 0xe4ffab, 0xe57993,
	0xe5f39e, 0xe66dcc, 0xe6e81f, 0xe76295, 0xe7dd2f, 0xe857ec, 0xe8d2cd, 0xe94dd2, 0xe9c8fb, 0xea4447,
	0xeabfb7, 0xeb3b4b, 0xebb703, 0xec32de, 0xecaedd, 0xed2b00, 0xeda747, 0xee23b1, 0xeea03f, 0xef1cf1,
	0xef99c7, 0xf016c1, 0xf093e0, 0xf11121, 0xf18e86, 0xf20c0f, 0xf289bc, 0xf3078d, 0xf38581, 0xf4039a,
	0xf481d6, 0xf50036, 0xf57eba, 0xf5fd62, 0xf67c2e, 0xf6fb1d, 0xf77a31, 0xf7f969, 0xf878c4, 0xf8f844,
	0xf977e7, 0xf9f7af, 0xfa779a, 0xfaf7a9, 0xfb77dd, 0xfbf834, 0xfc78af, 0xfcf94e, 0xfd7a12, 0xfdfaf9,
	0xfe7c04, 0xfefd34, 0xff7e87, 0xffffff,
};

uint32_t hdr_default_tm_tbl[HDR_TM_LUT_SIZE] = {
	0x0000, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0203, 0x0203, 0x0203, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0201,
	0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201,
	0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201,
	0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201,
	0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0201, 0x0203, 0x0203, 0x0203, 0x0203,
	0x0203, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202,
	0x0202, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
	0x0200, 0x0200, 0x0200, 0x0200, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe,
	0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe,
	0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fd, 0x01fd, 0x01fd, 0x01fd, 0x01fd,
	0x01fd, 0x01fd, 0x01fc, 0x01fb, 0x01f9, 0x01f9, 0x01f8, 0x01f7, 0x01f7, 0x01f7,
	0x01f5, 0x01f3, 0x01f3, 0x01f1, 0x01ef, 0x01ee, 0x01ed, 0x01eb, 0x01ea, 0x01e9,
	0x01e8, 0x01e6, 0x01e5, 0x01e4, 0x01e3, 0x01e1, 0x01e0, 0x01de, 0x01de, 0x01dc,
	0x01dc, 0x01db, 0x01da, 0x01d8, 0x01d7, 0x01d5, 0x01d3, 0x01d2, 0x01d1, 0x01cf,
	0x01ce, 0x01cc, 0x01ca, 0x01c9, 0x01c7, 0x01c6, 0x01c4, 0x01c2, 0x01c1, 0x01c1,
	0x01bb, 0x01bd, 0x01bf, 0x01ba, 0x01bb, 0x01b7, 0x01b8, 0x01b5, 0x01b5, 0x01b6,
	0x01b3, 0x01b3, 0x01b3, 0x01b1, 0x01b3, 0x01b0, 0x01b0, 0x01ad, 0x01af, 0x01af,
	0x01ac, 0x01a9, 0x01ab, 0x01ab, 0x01a9, 0x01aa, 0x01a8, 0x01a8, 0x01a9, 0x01a7,
	0x01a8, 0x01a6, 0x01a6, 0x01a8, 0x01a5, 0x01a6, 0x01a7, 0x01a5, 0x01a6, 0x01a3,
	0x01a4, 0x01a6, 0x01a4, 0x01a4, 0x01a5, 0x01a3, 0x01a4, 0x01a2, 0x01a3, 0x01a4,
	0x01a2, 0x01a2, 0x01a1, 0x01a2, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
	0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f,
	0x019f, 0x019f, 0x019f, 0x019e, 0x019e, 0x019f, 0x019e, 0x019e, 0x019f, 0x019e,
	0x019f, 0x019f, 0x019e, 0x019e, 0x019d, 0x019d, 0x019c, 0x019d, 0x019e, 0x019c,
	0x019d, 0x019e, 0x019d, 0x019d, 0x019e, 0x019c, 0x019d, 0x019c, 0x019c, 0x019d,
	0x019c, 0x019c, 0x019d, 0x019c, 0x019c, 0x019d, 0x019c, 0x019d, 0x019d, 0x019c,
	0x019c, 0x019b, 0x019c, 0x019c, 0x019b, 0x019c, 0x019b, 0x019b, 0x019c, 0x019b,
	0x019b, 0x019c, 0x019b, 0x019b, 0x019a, 0x019b, 0x019c, 0x019b, 0x019b, 0x019b,
	0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019a, 0x019b, 0x019b, 0x019a, 0x019a,
	0x019b, 0x019a, 0x019a, 0x019b, 0x019a, 0x019b, 0x019a, 0x019a, 0x0199, 0x019a,
	0x019a, 0x0199, 0x019a, 0x0199, 0x0199, 0x019a, 0x0199, 0x019a, 0x019a, 0x0199,
	0x019a, 0x0199, 0x0199, 0x019a, 0x0199, 0x0199, 0x019a, 0x0199, 0x0199, 0x0199,
	0x0199, 0x0199, 0x0199, 0x0199, 0x0198, 0x0199, 0x0199, 0x0198, 0x0197, 0x0198,
	0x0198, 0x0198, 0x0198, 0x0197, 0x0198, 0x0198, 0x0197, 0x0198, 0x0197, 0x0197,
	0x0198, 0x0197, 0x0198, 0x0197, 0x0197, 0x0198, 0x0197, 0x0197, 0x0196, 0x0197,
	0x0196, 0x0196, 0x0197, 0x0196, 0x0197, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196,
	0x0196, 0x0195, 0x0196, 0x0195, 0x0195, 0x0195, 0x0195, 0x0195, 0x0195, 0x0195,
	0x0195, 0x0195, 0x0194, 0x0195, 0x0194, 0x0194, 0x0194, 0x0194, 0x0195, 0x0194,
	0x0194, 0x0194, 0x0194, 0x0193, 0x0194, 0x0193, 0x0194, 0x0193, 0x0193, 0x0193,
	0x0192, 0x0193, 0x0192, 0x0192, 0x0192, 0x0192, 0x0192, 0x0192, 0x0191, 0x0192,
	0x0191, 0x0191, 0x0191, 0x0191, 0x0191, 0x0191, 0x0190, 0x0191, 0x0190, 0x0191,
	0x0190, 0x0190, 0x0190, 0x018f, 0x0190, 0x018f, 0x0190, 0x018f, 0x018f, 0x018f,
	0x018f, 0x018f, 0x018e, 0x018e, 0x018e, 0x018e, 0x018e, 0x018d, 0x018e, 0x018d,
	0x018e, 0x018d, 0x018d, 0x018d, 0x018c, 0x018d, 0x018c, 0x018c, 0x018c, 0x018c,
	0x018c, 0x018b, 0x018b, 0x018b, 0x018b, 0x018a, 0x018b, 0x018a, 0x018b, 0x018a,
	0x018a, 0x018a, 0x018a, 0x0189, 0x0189, 0x0189, 0x0189, 0x0188, 0x0188, 0x0188,
	0x0187, 0x0187, 0x0186, 0x0186, 0x0185, 0x0185, 0x0184, 0x0184, 0x0183, 0x0183,
	0x0182, 0x0181, 0x0181, 0x0180, 0x0180, 0x017f, 0x017f, 0x017e, 0x017e, 0x017d,
	0x017d, 0x017c, 0x017c, 0x017b, 0x017b, 0x017a, 0x017a, 0x0179, 0x0179, 0x0178,
	0x0178, 0x0177, 0x0177, 0x0176, 0x0176, 0x0175, 0x0175, 0x0174, 0x0174, 0x0173,
	0x0173, 0x0172, 0x0172, 0x0171, 0x0171, 0x0171, 0x0170, 0x0170, 0x016f, 0x016f,
	0x016e, 0x016e, 0x016d, 0x016d, 0x016c, 0x016c, 0x016b, 0x016b, 0x016b, 0x016a,
	0x016a, 0x0169, 0x0169, 0x0168, 0x0168, 0x0167, 0x0167, 0x0167, 0x0166, 0x0166,
	0x0165, 0x0165, 0x0164, 0x0164, 0x0163, 0x0163, 0x0163, 0x0162, 0x0162, 0x0161,
	0x0161, 0x0160, 0x0160, 0x0160, 0x015f, 0x015f, 0x015e, 0x015e, 0x015e, 0x015d,
	0x015d, 0x015c, 0x015c, 0x015b, 0x015b, 0x015b, 0x015a, 0x015a, 0x0159, 0x0159,
	0x0159, 0x0158, 0x0158, 0x0157, 0x0157, 0x0157, 0x0156, 0x0156, 0x0155, 0x0155,
	0x0155, 0x0154, 0x0154, 0x0154, 0x0153, 0x0153, 0x0152, 0x0152, 0x0152, 0x0151,
	0x0151, 0x0150, 0x0150, 0x0150, 0x014f, 0x014f, 0x014f, 0x014e, 0x014e, 0x014e,
	0x014d, 0x014d, 0x014c, 0x014c, 0x014c, 0x014b, 0x014b, 0x014b, 0x014a, 0x014a,
	0x014a, 0x0149, 0x0149, 0x0148, 0x0148, 0x0148, 0x0147, 0x0147, 0x0147, 0x0146,
	0x0146, 0x0146, 0x0145, 0x0145, 0x0145, 0x0144, 0x0144, 0x0144, 0x0143, 0x0143,
	0x0143, 0x0142, 0x0142, 0x0142, 0x0141, 0x0141, 0x0141, 0x0140, 0x0140, 0x0140,
	0x013f, 0x013f, 0x013f, 0x013e, 0x013e, 0x013e, 0x013d, 0x013d, 0x013d, 0x013c,
	0x013c, 0x013c, 0x013b, 0x013b, 0x013b, 0x013a, 0x013a, 0x013a, 0x0139, 0x0139,
	0x0139, 0x0138, 0x0138, 0x0138, 0x0137, 0x0137, 0x0137, 0x0137, 0x0136, 0x0136,
	0x0136, 0x0135, 0x0135, 0x0135, 0x0134, 0x0134, 0x0134, 0x0134, 0x0133, 0x0133,
	0x0133, 0x0132, 0x0132, 0x0132, 0x0131, 0x0131, 0x0131, 0x0131, 0x0130, 0x0130,
	0x0130, 0x012f, 0x012f, 0x012f, 0x012e, 0x012e, 0x012e, 0x012e, 0x012d, 0x012d,
	0x012d, 0x012c, 0x012c, 0x012c, 0x012c, 0x012b, 0x012b, 0x012b, 0x012b, 0x012a,
	0x012a, 0x012a, 0x0129, 0x0129, 0x0129, 0x0129, 0x0128, 0x0128, 0x0128, 0x0127,
	0x0127, 0x0127, 0x0127, 0x0126, 0x0126, 0x0126, 0x0126, 0x0125, 0x0125, 0x0125,
	0x0125, 0x0124, 0x0124, 0x0124, 0x0123, 0x0123, 0x0123, 0x0123, 0x0122, 0x0122,
	0x0122, 0x0122, 0x0121, 0x0121, 0x0121, 0x0121, 0x0120, 0x0120, 0x0120, 0x0120,
	0x011f, 0x011f, 0x011f, 0x011f, 0x011e, 0x011e, 0x011e, 0x011e, 0x011d, 0x011d,
	0x011d, 0x011d, 0x011c, 0x011c, 0x011c, 0x011c, 0x011b, 0x011b, 0x011b, 0x011b,
	0x011a, 0x011a, 0x011a, 0x011a, 0x0119, 0x0119, 0x0119, 0x0119, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0117, 0x0117, 0x0117, 0x0117, 0x0116, 0x0116, 0x0116,
	0x0116, 0x0115, 0x0115, 0x0115, 0x0115, 0x0114, 0x0114, 0x0114, 0x0114, 0x0114,
	0x0113, 0x0113, 0x0113, 0x0113, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0111,
	0x0111, 0x0111, 0x0111, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x010f, 0x010f,
	0x010f, 0x010f, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010d, 0x010d, 0x010d,
	0x010d, 0x010d, 0x010c, 0x010c, 0x010c, 0x010c, 0x010b, 0x010b, 0x010b, 0x010b,
	0x010b, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a, 0x0109, 0x0109, 0x0109, 0x0109,
	0x0109, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0107, 0x0107, 0x0107, 0x0107,
	0x0107, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0105, 0x0105, 0x0105, 0x0105,
	0x0105, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0103, 0x0103, 0x0103, 0x0103,
	0x0103, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0101, 0x0101, 0x0101,
	0x0101, 0x0101, 0x0100, 0x0100, 0x0100,
};

#endif
