// SPDX-License-Identifier: GPL-2.0-only
/* Copyright (C) 2019 Spreadtrum Communications Inc.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifdef pr_fmt
#undef pr_fmt
#endif
#define pr_fmt(fmt) "sipa_phy: " fmt

#include <linux/bitops.h>
#include <linux/io.h>
#include <linux/ioport.h>
#include <linux/kernel.h>

#include "../sipa_priv.h"

#define IPA_USB_MODE_OFFSET			(29)
#define IPA_WORKING_MODE_MASK			(BIT(31))
#define IPA_USB_MODE_MASK			(GENMASK(30, 29))
#define IPA_NEED_CP_THROUGH_PCIE_MASK		(BIT(28))
#define IPA_SW_PAUSE_IPA_MASK			(BIT(27))
#define IPA_HW_READY_FOR_CHECK_MASK		(BIT(26))
#define IPA_SW_RESUME_IPA_MASK			(BIT(25))
#define IPA_CP_DL_HASH_EN_MASK			(BIT(24))
#define IPA_WIAP_DL_HASH_EN_MASK		(BIT(23))
#define IPA_PCIE_UL_HASH_EN_MASK		(BIT(22))
#define IPA_WIFI_UL_HASH_EN_MASK		(BIT(21))
#define IPA_USB_UL_HASH_EN_MASK			(BIT(20))
#define IPA_CP_DL_CHKSUM_EN_MASK		(BIT(19))
#define IPA_WIAP_DL_CHKSUM_EN_MASK		(BIT(18))
#define IPA_PCIE_UL_CHKSUM_EN_MASK		(BIT(17))
#define IPA_WIFI_UL_CHKSUM_EN_MASK		(BIT(16))
#define IPA_USB_UL_CHKSUM_EN_MASK		(BIT(15))
#define IPA_MONITOR_IPA_OR_TFT_MASK		(BIT(14))
#define IPA_TO_PCIE_NO_MAC_HDR_MASK		(BIT(13))
#define IPA_FROM_PCIE_NO_MAC_HDR_MASK		(BIT(12))
#define IPA_DBG_CLK_GATE_EN_MASK		(BIT(11))
#define IPA_CP_WORK_STATUS_MASK			(BIT(10))
#define IPA_WIAP_UL_FLOW_CTL_MASK		(BIT(9))
#define IPA_WIFI_DL_FLOW_CTL_MASK		(BIT(8))
#define IPA_USB_DL_FLOW_CTL_MASK		(BIT(7))
#define IPA_PCIE_DL_FLOW_CTL_MASK		(BIT(6))
#define IPA_CP_UL_FLOW_CTL_MASK			(BIT(5))
#define IPA_MAP_OUT_FLOW_CTL_MASK		(BIT(4))
#define IPA_INPUT_FILTER_EN_MASK		(BIT(3))
#define IPA_OUTPUT_FILTER_EN_MASK		(BIT(2))
#define IPA_HTABLE_CACHE_EN_MASK		(BIT(1))
#define IPA_CP_REMOTE_FLOW_CTRL_MASK		(BIT(0))
#define IPA_MODE_N_FLOWCTRL			(0x0UL)

#define IPA_CP_FLOW_CTL_TO_SRC_BLK_MASK		(GENMASK(29, 25))
#define IPA_MAP_FLOW_CTL_TO_SRC_BLK_MASK	(GENMASK(24, 20))
#define IPA_WIAP_FLOW_CTL_TO_SRC_BLK_MASK	(GENMASK(19, 15))
#define IPA_PCIE_FLOW_CTL_TO_SRC_BLK_MASK	(GENMASK(14, 10))
#define IPA_WIFI_FLOW_CTL_TO_SRC_BLK_MASK	(GENMASK(9, 5))
#define IPA_USB_FLOW_CTL_TO_SRC_BLK_MASK	(GENMASK(4, 0))
#define IPA_CP_FLOW_CTL_TO_AP_MASK		(BIT(29))
#define IPA_CP_FLOW_CTL_TO_WIAP_MASK		(BIT(28))
#define IPA_CP_FLOW_CTL_TO_PCIE_MASK		(BIT(27))
#define IPA_CP_FLOW_CTL_TO_WIFI_MASK		(BIT(26))
#define IPA_CP_FLOW_CTL_TO_USB_MASK		(BIT(25))
#define IPA_MAP_FLOW_CTL_TO_CP_MASK		(BIT(24))
#define IPA_MAP_FLOW_CTL_TO_WIAP_MASK		(BIT(23))
#define IPA_MAP_FLOW_CTL_TO_PCIE_MASK		(BIT(22))
#define IPA_MAP_FLOW_CTL_TO_WIFI_MASK		(BIT(21))
#define IPA_MAP_FLOW_CTL_TO_USB_MASK		(BIT(20))
#define IPA_WIAP_FLOW_CTL_TO_CP_MASK		(BIT(19))
#define IPA_WIAP_FLOW_CTL_TO_MAP_MASK		(BIT(18))
#define IPA_WIAP_FLOW_CTL_TO_PCIE_MASK		(BIT(17))
#define IPA_WIAP_FLOW_CTL_TO_WIFI_MASK		(BIT(16))
#define IPA_WIAP_FLOW_CTL_TO_USB_MASK		(BIT(15))
#define IPA_PCIE_FLOW_CTL_TO_CP_MASK		(BIT(14))
#define IPA_PCIE_FLOW_CTL_TO_MAP_MASK		(BIT(13))
#define IPA_PCIE_FLOW_CTL_TO_WIAP_MASK		(BIT(12))
#define IPA_PCIE_FLOW_CTL_TO_WIFI_MASK		(BIT(11))
#define IPA_PCIE_FLOW_CTL_TO_USB_MASK		(BIT(10))
#define IPA_WIFI_FLOW_CTL_TO_CP_MASK		(BIT(9))
#define IPA_WIFI_FLOW_CTL_TO_MAP_MASK		(BIT(8))
#define IPA_WIFI_FLOW_CTL_TO_WIAP_MASK		(BIT(7))
#define IPA_WIFI_FLOW_CTL_TO_PCIE_MASK		(BIT(6))
#define IPA_WIFI_FLOW_CTL_TO_USB_MASK		(BIT(5))
#define IPA_USB_FLOW_CTL_TO_CP_MASK		(BIT(4))
#define IPA_USB_FLOW_CTL_TO_MAP_MASK		(BIT(3))
#define IPA_USB_FLOW_CTL_TO_WIAP_MASK		(BIT(2))
#define IPA_USB_FLOW_CTL_TO_PCIE_MASK		(BIT(1))
#define IPA_USB_FLOW_CTL_TO_WIFI_MASK		(BIT(0))
#define IPA_DST_FLOW_CTL_TO_SRC_BLK		(0x4UL)

/**
 * AXI_Outstanding_n_cg:
 *   [31:15]: Reserved
 *   [14]: rf_axi_mst_cg_en
 *   [13:8]: rf_axi_os_wr
 *   [7:6]: Reserved
 *   [5:0]: rt_axi_os_rd
 */
#define IPA_RF_AXI_MST_CG_EN_MASK		(BIT(14))
#define IPA_RF_AXI_OS_WR_MASK			(GENMASK(13, 8))
#define IPA_RF_AXI_OS_RD_MASK			(GENMASK(5, 0))
#define IPA_AXI_OUTSTANDING_N_CG		(0x8UL)

/**
 * cache_qos_prot_cfg:
 *   [31:28]: rf_cache_wr
 *   [27:24]: rf_cache_rd
 *   [23:20]: rf_qos_wr
 *   [19:16]: rf_qos_rd
 *   [15:6]: Reserved
 *   [5:3]: rf_prot_wr
 *   [2:0]: rf_prot_rd
 */
#define IPA_RF_CACHE_WR_MASK			(GENMASK(31, 28))
#define IPA_RF_CACHE_RD_MASK			(GENMASK(27, 24))
#define IPA_RF_QOS_WR_MASK			(GENMASK(23, 20))
#define IPA_RF_QOS_RD_MASK			(GENMASK(19, 16))
#define IPA_RF_PROT_WR_MASK			(GENMASK(5, 3))
#define IPA_RF_PROT_RD_MASK			(GENMASK(2, 0))
#define IPA_CACHE_QOS_PROT_CFG			(0x1CUL)

/**
 * internal_fifo_clr:
 *   [31]: TCP_fin_leave_2_ap
 *   [30]: TCP_syn_leave_2_ap
 *   [29]: TCP_rst_leave_2_ap
 *   [28]: TCP_psh_leave_2_ap
 *   [27]: TCP_ack_leave_2_ap
 *   [26]: TCP_urg_leave_2_ap
 *       1: when fin bit set in TCP,  leave to AP process
 *       0: processed by route table
 *   [25]: CP_DL_flow_ctrl_recover
 *       write 1 then 0,  CP DL exit from SW initial state
 *   [24:0]: reserved
 */
#define IPA_TCP_FIN_LEAVE_2_AP_MASK             (BIT(31))
#define IPA_TCP_SYN_LEAVE_2_AP_MASK             (BIT(30))
#define IPA_TCP_RST_LEAVE_2_AP_MASK             (BIT(29))
#define IPA_TCP_PSH_LEAVE_2_AP_MASK             (BIT(28))
#define IPA_TCP_ACK_LEAVE_2_AP_MASK             (BIT(27))
#define IPA_TCP_URG_LEAVE_2_AP_MASK             (BIT(26))
#define IPA_CP_DL_FLOW_CTRL_RECOVER_MASK        (BIT(25))
#define IPA_INTERNAL_FIFO_CLR                   (0x20UL)

/**
 * axi_mst_chn_priority
 *   2'b00: channel priority is 0
 *   2'b01: channel priority is 1
 *   2'b10: channel priority is 2
 *   2'b11: channel priority is 3
 *   3 is the highest priority. 0 is the lowest priority
 */
#define IPA_AXI_WR_CHN6_PRIORITY_MASK		(GENMASK(27, 26))
#define IPA_AXI_WR_CHN5_PRIORITY_MASK		(GENMASK(25, 24))
#define IPA_AXI_WR_CHN4_PRIORITY_MASK		(GENMASK(23, 22))
#define IPA_AXI_WR_CHN3_PRIORITY_MASK		(GENMASK(21, 20))
#define IPA_AXI_WR_CHN2_PRIORITY_MASK		(GENMASK(19, 18))
#define IPA_AXI_WR_CHN1_PRIORITY_MASK		(GENMASK(17, 16))
#define IPA_AXI_RD_CHN6_PRIORITY_MASK		(GENMASK(11, 10))
#define IPA_AXI_RD_CHN5_PRIORITY_MASK		(GENMASK(9, 8))
#define IPA_AXI_RD_CHN4_PRIORITY_MASK		(GENMASK(7, 6))
#define IPA_AXI_RD_CHN3_PRIORITY_MASK		(GENMASK(5, 4))
#define IPA_AXI_RD_CHN2_PRIORITY_MASK		(GENMASK(3, 2))
#define IPA_AXI_RD_CHN1_PRIORITY_MASK		(GENMASK(1, 0))
#define IPA_AXI_MST_CHN_PRIORITY                (0x24UL)

/**
 * map_general_int:
 *   [31]: errnode_int_clr
 *   [30]: map_out_free_fifo_fatal_int_clr
 *   [29]: dc_int_clr
 *   [28:21]: reserved
 *   [20]: map7_out_general_int_sel
 *   [19]: map6_out_general_int_sel
 *   [18]: map5_out_general_int_sel
 *   [17]: map4_out_general_int_sel
 *   [16]: map3_out_general_int_sel
 *   [15]: map2_out_general_int_sel
 *   [14]: map1_out_general_int_sel
 *   [13]: map0_out_general_int_sel
 *   [12]: dc_general_int_sel
 *   [11]: map_out_fatal_general_int
 *   [10]: errnode_general_int_sel
 *   [9]: map_in_general_int_sel
 *   [8]: map_out_general_int_sel
 *   [7]: usb_dl_general_int_sel
 *   [6]: usb_ul_general_int_sel
 *   [5]: pcie_dl_general_int_sel
 *   [4]: pcie_ul_general_int_sel
 *   [3]: wifi_dl_general_int_sel
 *   [2]: wifi_ul_general_int_sel
 *   [1]: wiap_dl_general_int_sel
 *   [0]: wiap_ul_general_int_sel
 */
#define IPA_ERRNODE_INT_CLR_MASK		(BIT(31))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_INT_CLR_MASK    (BIT(30))
#define IPA_DC_INT_CLR_MASK			(BIT(29))
#define IPA_MAP7_OUT_GENERAL_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_GENERAL_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_GENERAL_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_GENERAL_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_GENERAL_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_GENERAL_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_GENERAL_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_GENERAL_INT_SEL_MASK	(BIT(13))
#define IPA_DC_GENERAL_INT_SEL_MASK		(BIT(12))
#define IPA_MAP_OUT_FATAL_GENERAL_INT_SEL_MASK	(BIT(11))
#define IPA_ERRNODE_GENERAL_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_GENERAL_INT_SEL_MASK		(BIT(9))
#define IPA_MAP_OUT_GENERAL_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_GENERAL_INT_SEL_MASK		(BIT(7))
#define IPA_USB_UL_GENERAL_INT_SEL_MASK		(BIT(6))
#define IPA_PCIE_DL_GENERAL_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_GENERAL_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_GENERAL_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_GENERAL_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_GENERAL_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_GENERAL_INT_SEL_MASK	(BIT(0))
#define IPA_GENERAL_INT_SEL_GROUP_MASK		(GENMASK(20, 0))
#define IPA_MAP_GENERAL_INT			(0x28UL)

/**
 * map_general_int_sts:
 *   [31:21]: reserved
 *   [20]: map7_out_general_int
 *   [19]: map6_out_general_int
 *   [18]: map5_out_general_int
 *   [17]: map4_out_general_int
 *   [16]: map3_out_general_int
 *   [15]: map2_out_general_int
 *   [14]: map1_out_general_int
 *   [13]: map0_out_general_int
 *   [12]: dc_general_int
 *   [11]: map_out_free_fifo_fatal_general_int
 *   [10]: errnode_general_int
 *   [9]: map_in_general_int
 *   [8]: map_out_general_int
 *   [7]: usb_dl_general_int
 *   [6]: usb_ul_general_int
 *   [5]: pcie_dl_general_int
 *   [4]: pcie_ul_general_int
 *   [3]: wifi_dl_general_int
 *   [2]: wifi_ul_general_int
 *   [1]: wiap_dl_general_int
 *   [0]: wiap_ul_general_int
 */
#define IPA_MAP7_OUT_GENERAL_INT_MASK	(BIT(20))
#define IPA_MAP6_OUT_GENERAL_INT_MASK	(BIT(19))
#define IPA_MAP5_OUT_GENERAL_INT_MASK	(BIT(18))
#define IPA_MAP4_OUT_GENERAL_INT_MASK	(BIT(17))
#define IPA_MAP3_OUT_GENERAL_INT_MASK	(BIT(16))
#define IPA_MAP2_OUT_GENERAL_INT_MASK	(BIT(15))
#define IPA_MAP1_OUT_GENERAL_INT_MASK	(BIT(14))
#define IPA_MAP0_OUT_GENERAL_INT_MASK	(BIT(13))
#define IPA_DC_GENERAL_INT_MASK		(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_GENERAL_INT_MASK	(BIT(11))
#define IPA_ERRNODE_GENERAL_INT_MASK	(BIT(10))
#define IPA_MAP_IN_GENERAL_INT_MASK	(BIT(9))
#define IPA_MAP_OUT_GENERAL_INT_MASK	(BIT(8))
#define IPA_USB_DL_GENERAL_INT_MASK	(BIT(7))
#define IPA_USB_UL_GENERAL_INT_MASK	(BIT(6))
#define IPA_PCIE_DL_GENERAL_INT_MASK	(BIT(5))
#define IPA_PCIE_UL_GENERAL_INT_MASK	(BIT(4))
#define IPA_WIFI_DL_GENERAL_INT_MASK	(BIT(3))
#define IPA_WIFI_UL_GENERAL_INT_MASK	(BIT(2))
#define IPA_WIAP_UL_GENERAL_INT_MASK	(BIT(1))
#define IPA_WIAP_DL_GENERAL_INT_MASK	(BIT(0))
#define IPA_MAP_GENERAL_INT_STS		(0x2CUL)

/**
 * priority can be 0x0 ~ 0xF
 * 15 is the highest priority,  0 is the lowest priority.
 */
#define IPA_CP_DL_FLOW_CTRL_SEL_MASK	(GENMASK(31, 30))
#define IPA_CP_DL_CUR_TERM_NUM_MASK	(GENMASK(29, 25))
#define IPA_CP_DL_DST_TERM_NUM_MASK	(GENMASK(24, 20))
#define IPA_CP_DL_PRIORITY_MASK		(GENMASK(19, 16))
#define IPA_CP_UL_FLOW_CTRL_SEL_MASK	(GENMASK(15, 14))
#define IPA_CP_UL_CUR_TERM_NUM_MASK	(GENMASK(13, 9))
#define IPA_CP_UL_DST_TERM_NUM_MASK	(GENMASK(8, 4))
#define IPA_CP_UL_PRIORITY_MASK		(GENMASK(3, 0))
#define IPA_CP_CONFIGURATION		(0x30UL)

#define IPA_IFILTER_DROP_CNT		(0x34UL)
#define IPA_OFILTER_DROP_CNT		(0x38UL)
#define IPA_HTABLE_COUNT_INDEX		(0x3CUL)
#define IPA_HTABLE_TIMESTAMP		(0x40UL)

#define IPA_HTABLE_CACHE_HIT_CNT_EN_MASK	(BIT(31))
#define IPA_CACHE_HIT_CNT_MASK		(GENMASK(30, 0))
#define IPA_CACHE_HIT_CTRL			(0x44UL)

#define IPA_HTABLE_CACHE_HIT_CNT_CLR_MASK	(BIT(31))
#define IPA_HTABLE_HIT_CNT_MASK		(GENMASK(30, 0))
#define IPA_HTABLE_HIT_CTRL		(0x48UL)

#define IPA_BYPASS_DSTID_CHK_SEL_MASK	(BIT(28))
#define IPA_BYPASS_SRCID_CHK_SEL_MASK	(BIT(27))
#define IPA_NODE_DSTID_CHK_EN_MASK	(BIT(26))
#define IPA_NODE_SRCID_CHK_EN_MASK	(BIT(25))
#define IPA_OFILTER_DROP_CNT_EN_MASK	(BIT(24))
#define IPA_IFILTER_DROP_CNT_EN_MASK	(BIT(23))
#define IPA_OFILTER_DROP_CLR_MASK	(BIT(22))
#define IPA_IFILTER_DROP_CLR_MASK	(BIT(21))
#define IPA_AXI_AVERAGE_WR_LAT_VLD_MASK	(BIT(20))
#define IPA_AXI_AVERAGE_RD_LAT_VLD_MASK	(BIT(19))
#define IPA_AXI_MON_WR_ID_MASK		(GENMASK(18, 15))
#define IPA_AXI_MON_RD_ID_MASK		(GENMASK(14, 11))
#define IPA_AXI_LAT_MON_STOP_MASK	(BIT(10))
#define IPA_AXI_LAT_MON_START_MASK	(BIT(9))
#define IPA_AXI_BYTES_CLR_MASK		(BIT(8))
#define IPA_AXI_MON_EN_MASK		(BIT(7))
#define IPA_SW_WR_TRANS_NUM_MASK	(GENMASK(5, 3))
#define IPA_SW_RD_TRANS_NUM_MASK	(GENMASK(2, 0))
#define IPA_DMA_COPY_CTRL		(0x4CUL)

#define IPA_OFILTER_DEPTH_IPV6_MASK	(GENMASK(31, 25))
#define IPA_OFILTER_DEPTH_IPV4_MASK	(GENMASK(24, 18))
#define IPA_OFILTER_LOCKED_MASK		(BIT(17))
#define IPA_OFILTER_CTRL_MASK		(BIT(16))
#define IPA_IFILTER_DEPTH_IPV6_MASK	(GENMASK(15, 9))
#define IPA_IFILTER_DEPTH_IPV4_MASK	(GENMASK(8, 2))
#define IPA_IFILTER_LOCKED_MASK		(BIT(1))
#define IPA_IFILTER_CTRL_MASK		(BIT(0))
#define IPA_FILTER_CTRL			(0x50UL)

#define IPA_DEFAULT_HASH_MASK			(GENMASK(29, 26))
#define IPA_HTABLE_HW_VALID_MASK		(BIT(25))
#define IPA_HTABLE_MAX_ENTRY_LEN_MASK		(GENMASK(24, 11))
#define IPA_CACHE_WAIT_UPDATE_CNT_MASK		(GENMASK(10, 4))
#define IPA_HTABLE_MAX_RD_LEN_MASK		(GENMASK(3, 0))
#define IPA_HASH_TABLE_STS			(0x54UL)

#define IPA_MAP_FIFO_SEL_MODE			(BIT(27))
#define IPA_MAP_FIFO_CNT			(GENMASK(26, 23))
#define IPA_HTABLE_LIMIT_TMR_CLR_MASK		(BIT(22))
#define IPA_HTABLE_LIMIT_TMR_SCALE_MASK		(GENMASK(21, 12))
#define IPA_HTABLE_TIMESTAMP_TMR_CLR_MASK	(BIT(11))
#define IPA_HTABLE_TIMESTAMP_TMR_SCALE_MASK	(GENMASK(10, 1))
#define IPA_HTABLE_BASE_TMR_EN_MASK		(BIT(0))
#define IPA_HTABLE_TIMER			(0x58UL)

#define IPA_HTABLE_BASE_L			(0x5CUL)

#define IPA_HTABLE_BASE_H_MASK			(GENMASK(31, 24))
#define IPA_CACHE_SYNC_DONE_MASK		(BIT(23))
#define IPA_CACHE_SYNC_REQ_MASK			(BIT(22))
#define IPA_ROUTE_MODE_IHL_CTRL_BIT_MASK	(BIT(21))
#define IPA_HTABLE_SW_EN_MASK			(BIT(20))
#define IPA_HTABLE_ERRCODE_MASK			(GENMASK(19, 18))
#define IPA_HTABLE_LEN_MASK			(GENMASK(17, 2))
#define IPA_HTABLE_UPDATE_MASK			(BIT(1))
#define IPA_HTABLE_UPDATE_DONE_MASK		(BIT(0))
#define IPA_HASH_TABLE_SWITCH_CTRL		(0x60UL)

#define IPA_ERRNODE_INFO_L			(0x64UL)
#define IPA_ERRNODE_INFO_M			(0x68UL)
#define IPA_ERRNODE_INFO_H			(0x6CUL)
#define IPA_AXI_TOTAL_RD_BYTE			(0x70UL)
#define IPA_AXI_TOTAL_WR_BYTE			(0x74UL)
#define IPA_AXI_AVERAGE_RD_LAT			(0x78UL)
#define IPA_AXI_AVERAGE_WR_LAT			(0x7CUL)

#define IPA_MAP_HASH_MASK_MASK			(GENMASK(30, 27))
#define IPA_MAP_MULTI_FIFO_MODE_EN_MASK		(BIT(26))
#define IPA_ERRCODE_INT_EN_MASK			(GENMASK(18, 15))
#define IPA_DL_PCIE_DMA_EN_MASK			(BIT(17))
#define IPA_PCIE_MSI_INT_MODE_MASK		(BIT(16))
#define IPA_PCIE_HW_INT_EN_MASK			(BIT(15))
#define IPA_CM4_INT_MASK_MASK			(GENMASK(14, 1))
#define IPA_IPA_WIAP_UL_DMA_EN_MASK		(BIT(0))
#define IPA_IPA_CTRL				(0x80UL)

#define IPA_IPA_DFS_CYCLE_CNT_VAL_MASK		(GENMASK(31, 11))
#define IPA_IPA_DFS_PERIOD_MASK			(GENMASK(10, 1))
#define IPA_IPA_DFS_EN_MASK			(BIT(0))
#define IPA_IPA_DFS_CTRL0			(0x84UL)

#define IPA_IPA_DFS_TH3_MASK			(GENMASK(31, 24))
#define IPA_IPA_DFS_TH2_MASK			(GENMASK(23, 16))
#define IPA_IPA_DFS_TH1_MASK			(GENMASK(15, 8))
#define IPA_IPA_DFS_TH0_MASK			(GENMASK(7, 0))
#define IPA_IPA_DFS_CTRL1			(0x88UL)

#define IPA_DC_DONE_MASK			(BIT(24))
#define IPA_DC_IP_SEL_MASK			(BIT(23))
#define IPA_DC_EN_MASK				(BIT(22))
#define IPA_DC_INIT_MASK			(BIT(21))
#define IPA_DC_LOOP_MODE_MASK			(BIT(20))
#define IPA_DC_CHN_SEL_MASK			(GENMASK(19, 16))
#define IPA_DC_STOP_SEL_MASK			(GENMASK(15, 14))
#define IPA_DC_START_SEL_MASK			(GENMASK(13, 12))
#define IPA_DC_SW_STOP_MASK			(BIT(11))
#define IPA_DC_SW_START_MASK			(BIT(10))
#define IPA_DC_MAX_LEN_MASK			(GENMASK(9, 0))
#define IPA_IPA_DC_CTRL				(0x8CUL)

#define IPA_IPA_DC_VLD_CLK_CNT			(0x90UL)

#define IPA_IPA_DC_DATA_MASK			(0x94UL)

#define IPA_IPA_DC_MEET_COND			(0x98UL)

#define IPA_DC_INIT_RADDR_MASK			(GENMASK(20, 11))
#define IPA_DC_RADDR_LOAD_MASK			(BIT(10))
#define IPA_DC_RADDR_MASK			(GENMASK(9, 0))
#define IPA_IPA_DC_RADDR_CTRL			(0x9CUL)

#define IPA_FIFO_MONITOR_SEL0			(0xA0UL)

#define IPA_IP_PKT_FIFO_MONITOR_SEL_MASK	(GENMASK(23, 16))
#define IPA_OUTPUT_CHN_FIFO_MONITOR_SEL_MASK	(GENMASK(15, 8))
#define IPA_INPUT_CHN_FIFO_MONITOR_SEL_MASK	(GENMASK(7, 0))
#define IPA_FIFO_MONITOR_SEL1			(0xA4UL)

#define IPA_IP_PKT_FIFO_EMPTY_HIT_MASK		(GENMASK(31, 16))
#define IPA_IP_PKT_FIFO_FULL_HIT_MASK		(GENMASK(15, 0))
#define IPA_IP_PKT_FIFO_STS       (0xA8UL)

#define IPA_DATA_CHN_FIFO_EMPTY_HIT_MASK	(GENMASK(31, 16))
#define IPA_DATA_CHN_FIFO_FULL_HIT_MASK		(GENMASK(15, 0))
#define IPA_DATA_CHN_FIFO_STS			(0xACUL)

#define IPA_INPUT_CHN_FIFO_EMPTY_HIT_MASK	(GENMASK(31, 16))
#define IPA_INPUT_CHN_FIFO_FULL_HIT_MASK	(GENMASK(15, 0))
#define IPA_INPUT_CHN_FIFO_STS			(0xB0UL)

#define IPA_OUTPUT_CHN_FIFO_EMPTY_HIT_MASK	(GENMASK(31, 16))
#define IPA_OUTPUT_CHN_FIFO_FULL_HIT_MASK	(GENMASK(15, 0))
#define IPA_OUTPUT_CHN_FIFO_STS			(0xB4UL)

#define IPA_OUTPREF_RD_CH_MASK			(GENMASK(20, 17))
#define IPA_DATA_CPY_RD_CH_MASK			(GENMASK(16, 12))
#define IPA_HTBL_RD_CH_MASK			(GENMASK(11, 8))
#define IPA_PHDR_RD_CH_MASK			(GENMASK(7, 4))
#define IPA_INPREF_RD_CH_MASK			(GENMASK(3, 0))
#define IPA_AXI_RD_OS_MON			(0xB8UL)

#define IPA_INTR_MEM_CH_MASK			(GENMASK(31, 27))
#define IPA_HTBL_WR_CH_MASK			(GENMASK(26, 21))
#define IPA_REL_NODE_CH_MASK			(GENMASK(20, 16))
#define IPA_PUSH_NODE_CH_MASK			(GENMASK(15, 11))
#define IPA_DATA_CPY_WR_CH_MASK			(GENMASK(10, 6))
#define IPA_NAT_WR_CH_MASK			(GENMASK(5, 2))
#define IPA_AXI_OS_MON_CLR_MASK			(BIT(1))
#define IPA_AXI_WR_OS_MON			(0xBCUL)

#define IPA_CLK_GATE_AON_0			(0xC0UL)

#define IPA_CLK_GATE_AON_1			(0xC4UL)
#define IPA_MAP3_FREE_FIFO_PRI_MASK		(GENMASK(31,  24))
#define IPA_MAP2_FREE_FIFO_PRI_MASK		(GENMASK(23, 16))
#define IPA_MAP1_FREE_FIFO_PRI_MASK		(GENMASK(15, 8))
#define IPA_MAP0_FREE_FIFO_PRI_MASK		(GENMASK(7, 0))
#define IPA_OUT_MAP_PRI0			(0xC8UL)

#define IPA_MAP7_FREE_FIFO_PRI_MASK		(GENMASK(31, 24))
#define IPA_MAP6_FREE_FIFO_PRI_MASK		(GENMASK(23, 16))
#define IPA_MAP5_FREE_FIFO_PRI_MASK		(GENMASK(15, 8))
#define IPA_MAP4_FREE_FIFO_PRI_MASK		(GENMASK(7, 0))
#define IPA_OUT_MAP_PRI1			(0xCCUL)

#define IPA_OUT_MAP_EN_MASK			(GENMASK(27, 20))
#define IPA_OUT_WIAP_EN_MASK			(BIT(19))
#define IPA_OUT_PCIE_EN_MASK			(BIT(18))
#define IPA_OUT_WIFI_EN_MASK			(BIT(17))
#define IPA_OUT_USB_EN_MASK			(BIT(16))
#define IPA_IN_MAP_EN_MASK			(BIT(4))
#define IPA_IN_WIAP_EN_MASK			(BIT(3))
#define IPA_IN_PCIE_EN_MASK			(BIT(2))
#define IPA_IN_WIFI_EN_MASK			(BIT(1))
#define IPA_IN_USB_EN_MASK			(BIT(0))
#define IPA_COMMON_FIFO_EN			(0xD0UL)

#define IPA_IPA_DUMMY_REG			(0xD4UL)

#define IPA_PCIE_DL_TX_FIFO_INT_ADDR_LOW	(0xDCUL)

#define IPA_PCIE_DL_TX_FIFO_INT_ADDR_HIGH_MASK	(GENMASK(7, 0))
#define IPA_PCIE_DL_TX_FIFO_INT_ADDR_HIGH	(0xE0UL)

#define IPA_PCIE_DL_TX_FIFO_INT_PATTERN		(0xE4UL)
#define IPA_PCIE_DL_RX_FIFO_INT_ADDR_LOW	(0xE8UL)

#define IPA_PCIE_DL_RX_FIFO_INT_ADDR_HIGH_MASK	(GENMASK(7, 0))
#define IPA_PCIE_DL_RX_FIFO_INT_ADDR_HIGH	(0xECUL)

#define IPA_PCIE_DL_RX_FIFO_INT_PATTERN		(0xF0UL)
#define IPA_PCIE_UL_TX_FIFO_INT_ADDR_LOW	(0xF4UL)

#define IPA_PCIE_UL_TX_FIFO_INT_ADDR_HIGH_MASK	(GENMASK(7, 0))
#define IPA_PCIE_UL_TX_FIFO_INT_ADDR_HIGH	(0xF8UL)

#define IPA_PCIE_UL_TX_FIFO_INT_PATTERN		(0xFCUL)
#define IPA_PCIE_UL_RX_FIFO_INT_ADDR_LOW	(0x100UL)

#define IPA_PCIE_UL_RX_FIFO_INT_ADDR_HIGH_MASK	(GENMASK(7, 0))
#define IPA_PCIE_UL_RX_FIFO_INT_ADDR_HIGH	(0x104UL)
#define IPA_PCIE_UL_RX_FIFO_INT_PATTERN		(0x108UL)

#define IPA_USB_PUSH_NODE_TOTAL_CNT		(0x10CUL)
#define IPA_USB_PUSH_NODE_L1_CNT		(0x110UL)
#define IPA_USB_PUSH_NODE_L2_CNT		(0x114UL)
#define IPA_USB_PUSH_NODE_L3_CNT		(0x118UL)
#define IPA_USB_PUSH_NODE_L4_CNT		(0x11CUL)
#define IPA_USB_FETCH_NODE_TOTAL_CNT		(0x120UL)
#define IPA_USB_FETCH_NODE_L1_CNT		(0x124UL)
#define IPA_USB_FETCH_NODE_L2_CNT		(0x128UL)
#define IPA_USB_FETCH_NODE_L3_CNT		(0x12CUL)
#define IPA_USB_FETCH_NODE_L4_CNT		(0x130UL)
#define IPA_PCIE_PUSH_NODE_TOTAL_CNT		(0x134UL)
#define IPA_PCIE_PUSH_NODE_L1_CNT		(0x138UL)
#define IPA_PCIE_PUSH_NODE_L2_CNT		(0x13CUL)
#define IPA_PCIE_PUSH_NODE_L3_CNT		(0x140UL)
#define IPA_PCIE_PUSH_NODE_L4_CNT		(0x144UL)
#define IPA_PCIE_FETCH_NODE_TOTAL_CNT		(0x148UL)
#define IPA_PCIE_FETCH_NODE_L1_CNT		(0x14CUL)
#define IPA_PCIE_FETCH_NODE_L2_CNT		(0x150UL)
#define IPA_PCIE_FETCH_NODE_L3_CNT		(0x154UL)
#define IPA_PCIE_FETCH_NODE_L4_CNT		(0x158UL)
#define IPA_WIFI_PUSH_NODE_TOTAL_CNT		(0x15CUL)
#define IPA_WIFI_PUSH_NODE_L1_CNT		(0x160UL)
#define IPA_WIFI_PUSH_NODE_L2_CNT		(0x164UL)
#define IPA_WIFI_PUSH_NODE_L3_CNT		(0x168UL)
#define IPA_WIFI_PUSH_NODE_L4_CNT		(0x16CUL)
#define IPA_WIFI_FETCH_NODE_TOTAL_CNT		(0x170UL)
#define IPA_WIFI_FETCH_NODE_L1_CNT		(0x174UL)
#define IPA_WIFI_FETCH_NODE_L2_CNT		(0x178UL)
#define IPA_WIFI_FETCH_NODE_L3_CNT		(0x17CUL)
#define IPA_WIFI_FETCH_NODE_L4_CNT		(0x180UL)
#define IPA_MAP_PUSH_NODE_TOTAL_CNT		(0x184UL)
#define IPA_MAP_PUSH_NODE_L1_CNT		(0x188UL)
#define IPA_MAP_PUSH_NODE_L2_CNT		(0x18CUL)
#define IPA_MAP_PUSH_NODE_L3_CNT		(0x190UL)
#define IPA_MAP_PUSH_NODE_L4_CNT		(0x194UL)
#define IPA_MAP_FETCH_NODE_TOTAL_CNT		(0x198UL)
#define IPA_MAP_FETCH_NODE_L1_CNT		(0x19CUL)
#define IPA_MAP_FETCH_NODE_L2_CNT		(0x1A0UL)
#define IPA_MAP_FETCH_NODE_L3_CNT		(0x1A4UL)
#define IPA_MAP_FETCH_NODE_L4_CNT		(0x1A8UL)
#define IPA_CP_PUSH_NODE_TOTAL_CNT		(0x1ACUL)
#define IPA_CP_PUSH_NODE_L1_CNT			(0x1B0UL)
#define IPA_CP_PUSH_NODE_L2_CNT			(0x1B4UL)
#define IPA_CP_PUSH_NODE_L3_CNT			(0x1B8UL)
#define IPA_CP_PUSH_NODE_L4_CNT			(0x1BCUL)
#define IPA_CP_FETCH_NODE_TOTAL_CNT		(0x1C0UL)
#define IPA_CP_FETCH_NODE_L1_CNT		(0x1C4UL)
#define IPA_CP_FETCH_NODE_L2_CNT		(0x1C8UL)
#define IPA_CP_FETCH_NODE_L3_CNT		(0x1CCUL)
#define IPA_CP_FETCH_NODE_L4_CNT		(0x1D0UL)

#define IPA_USB_FETCH_NODE_L2_CNT_H_MASK        (GENMASK(31, 28))
#define IPA_USB_FETCH_NODE_L1_CNT_H_MASK        (GENMASK(27, 24))
#define IPA_USB_FETCH_NODE_TOTAL_CNT_H_MASK     (GENMASK(23, 20))
#define IPA_USB_PUSH_NODE_L4_CNT_H_MASK         (GENMASK(19, 16))
#define IPA_USB_PUSH_NODE_L3_CNT_H_MASK         (GENMASK(15, 12))
#define IPA_USB_PUSH_NODE_L2_CNT_H_MASK         (GENMASK(11, 8))
#define IPA_USB_PUSH_NODE_L1_CNT_H_MASK         (GENMASK(7, 4))
#define IPA_USB_PUSH_NODE_TOTAL_CNT_H_MASK      (GENMASK(3, 0))
#define IPA_USB_NODE_CNT		(0x1D4UL)

#define IPA_PCIE_FETCH_NODE_L2_CNT_H_MASK       (GENMASK(31, 28))
#define IPA_PCIE_FETCH_NODE_L1_CNT_H_MASK       (GENMASK(27, 24))
#define IPA_PCIE_FETCH_NODE_TOTAL_CNT_H_MASK    (GENMASK(23, 20))
#define IPA_PCIE_PUSH_NODE_L4_CNT_H_MASK        (GENMASK(19, 16))
#define IPA_PCIE_PUSH_NODE_L3_CNT_H_MASK        (GENMASK(15, 12))
#define IPA_PCIE_PUSH_NODE_L2_CNT_H_MASK        (GENMASK(11, 8))
#define IPA_PCIE_PUSH_NODE_L1_CNT_H_MASK        (GENMASK(7, 4))
#define IPA_PCIE_PUSH_NODE_TOTAL_CNT_H_MASK     (GENMASK(3, 0))
#define IPA_PCIE_NODE_CNT		(0x1D8UL)

#define IPA_WIFI_FETCH_NODE_L2_CNT_H_MASK       (GENMASK(31, 28))
#define IPA_WIFI_FETCH_NODE_L1_CNT_H_MASK       (GENMASK(27, 24))
#define IPA_WIFI_FETCH_NODE_TOTAL_CNT_H_MASK    (GENMASK(23, 20))
#define IPA_WIFI_PUSH_NODE_L4_CNT_H_MASK        (GENMASK(19, 16))
#define IPA_WIFI_PUSH_NODE_L3_CNT_H_MASK        (GENMASK(15, 12))
#define IPA_WIFI_PUSH_NODE_L2_CNT_H_MASK        (GENMASK(11, 8))
#define IPA_WIFI_PUSH_NODE_L1_CNT_H_MASK        (GENMASK(7, 4))
#define IPA_WIFI_PUSH_NODE_TOTAL_CNT_H_MASK     (GENMASK(3, 0))
#define IPA_WIFI_NODE_CNT		(0x1DCUL)

#define IPA_MAP_FETCH_NODE_L2_CNT_H_MASK        (GENMASK(31, 28))
#define IPA_MAP_FETCH_NODE_L1_CNT_H_MASK        (GENMASK(27, 24))
#define IPA_MAP_FETCH_NODE_TOTAL_CNT_H_MASK     (GENMASK(23, 20))
#define IPA_MAP_PUSH_NODE_L4_CNT_H_MASK         (GENMASK(19, 16))
#define IPA_MAP_PUSH_NODE_L3_CNT_H_MASK         (GENMASK(15, 12))
#define IPA_MAP_PUSH_NODE_L2_CNT_H_MASK         (GENMASK(11, 8))
#define IPA_MAP_PUSH_NODE_L1_CNT_H_MASK         (GENMASK(7, 4))
#define IPA_MAP_PUSH_NODE_TOTAL_CNT_H_MASK      (GENMASK(3, 0))
#define IPA_MAP_NODE_CNT			(0x1E0UL)

#define IPA_CP_FETCH_NODE_L2_CNT_H_MASK		(GENMASK(31, 28))
#define IPA_CP_FETCH_NODE_L1_CNT_H_MASK		(GENMASK(27, 24))
#define IPA_CP_FETCH_NODE_TOTAL_CNT_H_MASK	(GENMASK(23, 20))
#define IPA_CP_PUSH_NODE_L4_CNT_H_MASK		(GENMASK(19, 16))
#define IPA_CP_PUSH_NODE_L3_CNT_H_MASK		(GENMASK(15, 12))
#define IPA_CP_PUSH_NODE_L2_CNT_H_MASK		(GENMASK(11, 8))
#define IPA_CP_PUSH_NODE_L1_CNT_H_MASK		(GENMASK(7, 4))
#define IPA_CP_PUSH_NODE_TOTAL_CNT_H_MASK	(GENMASK(3, 0))
#define IPA_CP_NODE_CNT			(0x1E4UL)
#define IPA_MAP_FETCH_NODE_L4_CNT_H_MASK	(GENMASK(31, 28))
#define IPA_MAP_FETCH_NODE_L3_CNT_H_MASK	(GENMASK(27, 24))
#define IPA_WIFI_FETCH_NODE_L4_CNT_H_MASK	(GENMASK(23, 20))
#define IPA_WIFI_FETCH_NODE_L3_CNT_H_MASK	(GENMASK(19, 16))
#define IPA_PCIE_FETCH_NODE_L4_CNT_H_MASK	(GENMASK(15, 12))
#define IPA_PCIE_FETCH_NODE_L3_CNT_H_MASK	(GENMASK(11, 8))
#define IPA_USB_FETCH_NODE_L4_CNT_H_MASK	(GENMASK(7, 4))
#define IPA_USB_FETCH_NODE_L3_CNT_H_MASK	(GENMASK(3, 0))
#define IPA_FETCH_NODE_CNT_L		(0x1E8UL)

#define IPA_TRAFFIC_COUNTER_CLR_MASK		(BIT(9))
#define IPA_TRAFFIC_COUNT_EN_MASK		(BIT(8))
#define IPA_CP_FETCH_NODE_L4_CNT_H_MASK		(GENMASK(7, 4))
#define IPA_CP_FETCH_NODE_L3_CNT_H_MASK		(GENMASK(3, 0))
#define IPA_FETCH_NODE_CNT_H			(0x1ECUL)

#define IPA_MAP7_OUT_MAP0_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP0_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP0_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP0_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP0_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP0_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP0_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP0_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP0_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP0_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP0_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP0_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP0_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP0_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP0_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP0_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP0_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP0_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP0_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP0_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP0_INT_SEL_MASK	(BIT(0))
#define IPA_MAP0_INTERRUPT_SRC_EN		(0x1F0UL)

#define IPA_MAP7_OUT_MAP1_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP1_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP1_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP1_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP1_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP1_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP1_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP1_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP1_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP1_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP1_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP1_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP1_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP1_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP1_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP1_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP1_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP1_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP1_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP1_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP1_INT_SEL_MASK	(BIT(0))
#define IPA_MAP1_INTERRUPT_SRC_EN	(0x1F4UL)

#define IPA_MAP7_OUT_MAP2_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP2_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP2_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP2_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP2_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP2_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP2_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP2_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP2_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP2_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP2_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP2_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP2_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP2_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP2_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP2_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP2_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP2_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP2_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP2_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP2_INT_SEL_MASK	(BIT(0))
#define IPA_MAP2_INTERRUPT_SRC_EN	(0x1F8UL)

#define IPA_MAP7_OUT_MAP3_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP3_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP3_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP3_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP3_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP3_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP3_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP3_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP3_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP3_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP3_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP3_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP3_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP3_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP3_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP3_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP3_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP3_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP3_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP3_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP3_INT_SEL_MASK	(BIT(0))
#define IPA_MAP3_INTERRUPT_SRC_EN	(0x1FCUL)

#define IPA_MAP7_OUT_MAP4_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP4_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP4_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP4_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP4_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP4_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP4_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP4_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP4_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP4_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP4_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP4_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP4_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP4_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP4_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP4_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP4_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP4_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP4_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP4_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP4_INT_SEL_MASK	(BIT(0))
#define IPA_MAP4_INTERRUPT_SRC_EN	(0x200UL)

#define IPA_MAP7_OUT_MAP5_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP5_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP5_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP5_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP5_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP5_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP5_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP5_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP5_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP5_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP5_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP5_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP5_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP5_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP5_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP5_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP5_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP5_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP5_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP5_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP5_INT_SEL_MASK	(BIT(0))
#define IPA_MAP5_INTERRUPT_SRC_EN	(0x204UL)

#define IPA_MAP7_OUT_MAP6_INT_SEL_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP6_INT_SEL_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP6_INT_SEL_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP6_INT_SEL_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP6_INT_SEL_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP6_INT_SEL_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP6_INT_SEL_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP6_INT_SEL_MASK	(BIT(13))
#define IPA_DC_MAP6_INT_SEL_MASK	(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP6_INT_SEL_MASK   (BIT(11))
#define IPA_ERRNODE_MAP6_INT_SEL_MASK	(BIT(10))
#define IPA_MAP_IN_MAP6_INT_SEL_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP6_INT_SEL_MASK	(BIT(8))
#define IPA_USB_DL_MAP6_INT_SEL_MASK	(BIT(7))
#define IPA_USB_UL_MAP6_INT_SEL_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP6_INT_SEL_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP6_INT_SEL_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP6_INT_SEL_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP6_INT_SEL_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP6_INT_SEL_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP6_INT_SEL_MASK	(BIT(0))
#define IPA_MAP6_INTERRUPT_SRC_EN	(0x208UL)

#define IPA_MAP7_OUT_MAP7_INT_SEL_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP7_INT_SEL_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP7_INT_SEL_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP7_INT_SEL_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP7_INT_SEL_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP7_INT_SEL_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP7_INT_SEL_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP7_INT_SEL_MASK		(BIT(13))
#define IPA_DC_MAP7_INT_SEL_MASK		(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP7_INT_SEL_MASK	(BIT(11))
#define IPA_ERRNODE_MAP7_INT_SEL_MASK		(BIT(10))
#define IPA_MAP_IN_MAP7_INT_SEL_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP7_INT_SEL_MASK		(BIT(8))
#define IPA_USB_DL_MAP7_INT_SEL_MASK		(BIT(7))
#define IPA_USB_UL_MAP7_INT_SEL_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP7_INT_SEL_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP7_INT_SEL_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP7_INT_SEL_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP7_INT_SEL_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP7_INT_SEL_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP7_INT_SEL_MASK		(BIT(0))
#define IPA_MAP7_INTERRUPT_SRC_EN		(0x20CUL)

#define IPA_MAP7_OUT_MAP0_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP0_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP0_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP0_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP0_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP0_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP0_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP0_INT_MASK		(BIT(13))
#define IPA_DC_MAP0_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP0_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP0_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP0_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP0_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP0_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP0_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP0_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP0_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP0_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP0_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP0_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP0_INT_MASK		(BIT(0))
#define IPA_MAP0_INT_STS			(0x210UL)

#define IPA_MAP7_OUT_MAP1_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP1_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP1_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP1_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP1_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP1_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP1_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP1_INT_MASK		(BIT(13))
#define IPA_DC_MAP1_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP1_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP1_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP1_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP1_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP1_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP1_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP1_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP1_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP1_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP1_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP1_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP1_INT_MASK		(BIT(0))
#define IPA_MAP1_INT_STS			(0x214UL)

#define IPA_MAP7_OUT_MAP2_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP2_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP2_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP2_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP2_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP2_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP2_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP2_INT_MASK		(BIT(13))
#define IPA_DC_MAP2_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP2_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP2_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP2_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP2_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP2_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP2_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP2_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP2_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP2_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP2_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP2_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP2_INT_MASK		(BIT(0))
#define IPA_MAP2_INT_STS			(0x218UL)

#define IPA_MAP7_OUT_MAP3_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP3_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP3_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP3_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP3_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP3_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP3_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP3_INT_MASK		(BIT(13))
#define IPA_DC_MAP3_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP3_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP3_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP3_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP3_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP3_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP3_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP3_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP3_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP3_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP3_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP3_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP3_INT_MASK		(BIT(0))
#define IPA_MAP3_INT_STS			(0x21CUL)

#define IPA_MAP7_OUT_MAP4_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP4_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP4_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP4_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP4_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP4_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP4_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP4_INT_MAS		(BIT(13))
#define IPA_DC_MAP4_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP4_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP4_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP4_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP4_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP4_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP4_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP4_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP4_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP4_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP4_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP4_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP4_INT_MASK		(BIT(0))
#define IPA_MAP4_INT_STS			(0x220UL)

#define IPA_MAP7_OUT_MAP5_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP5_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP5_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP5_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP5_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP5_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP5_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP5_INT_MASK		(BIT(13))
#define IPA_DC_MAP5_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP5_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP5_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP5_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP5_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP5_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP5_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP5_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP5_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP5_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP5_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP5_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP5_INT_MASK		(BIT(0))
#define IPA_MAP5_INT_STS			(0x224UL)

#define IPA_MAP7_OUT_MAP6_INT_MASK		(BIT(20))
#define IPA_MAP6_OUT_MAP6_INT_MASK		(BIT(19))
#define IPA_MAP5_OUT_MAP6_INT_MASK		(BIT(18))
#define IPA_MAP4_OUT_MAP6_INT_MASK		(BIT(17))
#define IPA_MAP3_OUT_MAP6_INT_MASK		(BIT(16))
#define IPA_MAP2_OUT_MAP6_INT_MASK		(BIT(15))
#define IPA_MAP1_OUT_MAP6_INT_MASK		(BIT(14))
#define IPA_MAP0_OUT_MAP6_INT_MASK		(BIT(13))
#define IPA_DC_MAP6_INT_MASK			(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP6_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP6_INT_MASK		(BIT(10))
#define IPA_MAP_IN_MAP6_INT_MASK		(BIT(9))
#define IPA_MAP_OUT_MAP6_INT_MASK		(BIT(8))
#define IPA_USB_DL_MAP6_INT_MASK		(BIT(7))
#define IPA_USB_UL_MAP6_INT_MASK		(BIT(6))
#define IPA_PCIE_DL_MAP6_INT_MASK		(BIT(5))
#define IPA_PCIE_UL_MAP6_INT_MASK		(BIT(4))
#define IPA_WIFI_DL_MAP6_INT_MASK		(BIT(3))
#define IPA_WIFI_UL_MAP6_INT_MASK		(BIT(2))
#define IPA_WIAP_UL_MAP6_INT_MASK		(BIT(1))
#define IPA_WIAP_DL_MAP6_INT_MASK		(BIT(0))
#define IPA_MAP6_INT_STS			(0x228UL)

#define IPA_MAP7_OUT_MAP7_INT_MASK	(BIT(20))
#define IPA_MAP6_OUT_MAP7_INT_MASK	(BIT(19))
#define IPA_MAP5_OUT_MAP7_INT_MASK	(BIT(18))
#define IPA_MAP4_OUT_MAP7_INT_MASK	(BIT(17))
#define IPA_MAP3_OUT_MAP7_INT_MASK	(BIT(16))
#define IPA_MAP2_OUT_MAP7_INT_MASK	(BIT(15))
#define IPA_MAP1_OUT_MAP7_INT_MASK	(BIT(14))
#define IPA_MAP0_OUT_MAP7_INT_MASK	(BIT(13))
#define IPA_DC_MAP7_INT_MASK		(BIT(12))
#define IPA_MAP_OUT_FREE_FIFO_FATAL_MAP7_INT_MASK	(BIT(11))
#define IPA_ERRNODE_MAP7_INT_MASK	(BIT(10))
#define IPA_MAP_IN_MAP7_INT_MASK	(BIT(9))
#define IPA_MAP_OUT_MAP7_INT_MASK	(BIT(8))
#define IPA_USB_DL_MAP7_INT_MASK	(BIT(7))
#define IPA_USB_UL_MAP7_INT_MASK	(BIT(6))
#define IPA_PCIE_DL_MAP7_INT_MASK	(BIT(5))
#define IPA_PCIE_UL_MAP7_INT_MASK	(BIT(4))
#define IPA_WIFI_DL_MAP7_INT_MASK	(BIT(3))
#define IPA_WIFI_UL_MAP7_INT_MASK	(BIT(2))
#define IPA_WIAP_UL_MAP7_INT_MASK	(BIT(1))
#define IPA_WIAP_DL_MAP7_INT_MASK	(BIT(0))
#define IPA_MAP7_INT_STS		(0x22CUL)

#define IPA_IFILTER_IPV4		(0x02E0UL)
#define IPA_IFILTER_IPV6		(0x02E4UL)
#define IPA_OFILTER_IPV4		(0x02E8UL)
#define IPA_OFILTER_IPV6		(0x02ECUL)

static int ipa_phy_set_work_mode(void __iomem *reg_base, bool is_bypass)
{
	u32 tmp;

	if (!is_bypass) {
		tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
		tmp &= (~IPA_WORKING_MODE_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_WORKING_MODE_MASK)
			return -EIO;
	} else {
		tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
		tmp |= IPA_WORKING_MODE_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_WORKING_MODE_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_get_work_mode(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		IPA_WORKING_MODE_MASK) >> 31;
}

static int ipa_phy_set_usb_mode(void __iomem *reg_base, u32 mode)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
	tmp &= (~IPA_USB_MODE_MASK);
	tmp |= (mode << IPA_USB_MODE_OFFSET);
	writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);

	if (((readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
	      IPA_USB_MODE_MASK) >> IPA_USB_MODE_OFFSET) != mode)
		return -EIO;
	return 0;
}

static int ipa_phy_set_need_cp_through_pcie(void __iomem *reg_base,
					    bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_NEED_CP_THROUGH_PCIE_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_NEED_CP_THROUGH_PCIE_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_NEED_CP_THROUGH_PCIE_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_NEED_CP_THROUGH_PCIE_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_ctrl_ipa_action(void __iomem *reg_base, bool enable)
{
	u32 tmp, timeout = 5000;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
	tmp &= (~(IPA_SW_PAUSE_IPA_MASK | IPA_SW_RESUME_IPA_MASK));

	if (enable) {
		tmp |= IPA_SW_RESUME_IPA_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_SW_RESUME_IPA_MASK))
			return -EIO;
	} else {
		tmp |= IPA_SW_PAUSE_IPA_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		while (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
			 IPA_HW_READY_FOR_CHECK_MASK) && timeout--)
			cpu_relax();

		if (!timeout)
			return -EIO;
	}

	return 0;
}

static bool ipa_phy_get_pause_status(void __iomem *reg_base)
{
	return IPA_SW_PAUSE_IPA_MASK &
		readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
}

static bool ipa_phy_get_resume_status(void __iomem *reg_base)
{
	return IPA_SW_RESUME_IPA_MASK &
		readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
}

static int ipa_phy_ctrl_hash_en(void __iomem *reg_base,
				u32 term, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= term;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) & term))
			return -EIO;
	} else {
		tmp &= (~term);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) & term)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_ctrl_chksum_en(void __iomem *reg_base,
				  u32 term, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= term;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) & term))
			return -EIO;
	} else {
		tmp &= (~term);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) & term)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_monitor_ipa_or_tft(void __iomem *reg_base, u32 flag)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);
	tmp &= (~IPA_MONITOR_IPA_OR_TFT_MASK);
	tmp |= (flag << 14);
	writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);

	if ((u32)(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		  IPA_MONITOR_IPA_OR_TFT_MASK) != (flag << 14))
		return -EIO;

	return 0;
}

static int ipa_phy_to_pcie_no_mac_hdr(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_TO_PCIE_NO_MAC_HDR_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_TO_PCIE_NO_MAC_HDR_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_TO_PCIE_NO_MAC_HDR_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_TO_PCIE_NO_MAC_HDR_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_from_pcie_no_mac_hdr(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_FROM_PCIE_NO_MAC_HDR_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_FROM_PCIE_NO_MAC_HDR_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_FROM_PCIE_NO_MAC_HDR_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_FROM_PCIE_NO_MAC_HDR_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_dbg_clk_gate_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_DBG_CLK_GATE_EN_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_DBG_CLK_GATE_EN_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_DBG_CLK_GATE_EN_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_DBG_CLK_GATE_EN_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_cp_work_status(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp &= (~IPA_CP_WORK_STATUS_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_CP_WORK_STATUS_MASK)
			return -EIO;
	} else {
		tmp |= IPA_CP_WORK_STATUS_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_CP_WORK_STATUS_MASK))
			return -EIO;
	}

	return 0;
}

static bool ipa_phy_get_wiap_ul_flow_ctrl_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		IPA_WIAP_UL_FLOW_CTL_MASK) == IPA_WIAP_UL_FLOW_CTL_MASK;
}

static bool ipa_phy_get_wifi_dl_flow_ctrl_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
	    IPA_WIFI_DL_FLOW_CTL_MASK) == IPA_WIFI_DL_FLOW_CTL_MASK;
}

static bool ipa_phy_get_usb_dl_flow_ctrl_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		IPA_USB_DL_FLOW_CTL_MASK) == IPA_USB_DL_FLOW_CTL_MASK;
}

static bool ipa_phy_get_pcie_dl_flow_ctrl_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		IPA_PCIE_DL_FLOW_CTL_MASK) == IPA_PCIE_DL_FLOW_CTL_MASK;
}

static bool ipa_phy_get_cp_ul_flow_ctrl_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		IPA_CP_UL_FLOW_CTL_MASK) == IPA_CP_UL_FLOW_CTL_MASK;
}

static int ipa_phy_input_filter_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_INPUT_FILTER_EN_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_INPUT_FILTER_EN_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_INPUT_FILTER_EN_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_INPUT_FILTER_EN_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_output_filter_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_OUTPUT_FILTER_EN_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_OUTPUT_FILTER_EN_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_OUTPUT_FILTER_EN_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_OUTPUT_FILTER_EN_MASK)
			return -EIO;
	}

	return 0;
}

static int ipa_phy_htable_cache_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL);

	if (enable) {
		tmp |= IPA_HTABLE_CACHE_EN_MASK;
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (!(readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		      IPA_HTABLE_CACHE_EN_MASK))
			return -EIO;
	} else {
		tmp &= (~IPA_HTABLE_CACHE_EN_MASK);
		writel_relaxed(tmp, reg_base + IPA_MODE_N_FLOWCTRL);
		if (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		    IPA_HTABLE_CACHE_EN_MASK)
			return -EIO;
	}
	return 0;
}

static bool ipa_phy_get_cp_remote_flow_ctrl_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_MODE_N_FLOWCTRL) &
		(IPA_CP_REMOTE_FLOW_CTRL_MASK)) == IPA_CP_REMOTE_FLOW_CTRL_MASK;
}

static void ipa_phy_set_flow_ctl_to_src_blk(void __iomem *reg_base, u32 chan,
					    bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DST_FLOW_CTL_TO_SRC_BLK);

	if (enable)
		tmp &= (~chan);
	else
		tmp |= chan;

	writel_relaxed(tmp, reg_base + IPA_DST_FLOW_CTL_TO_SRC_BLK);
}

static void
ipa_phy_set_force_to_ap(void __iomem *reg_base, u32 mask, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_INTERNAL_FIFO_CLR);

	if (enable)
		tmp |= mask;
	else
		tmp &= (~mask);

	writel_relaxed(tmp, reg_base + IPA_INTERNAL_FIFO_CLR);
}

static void ipa_phy_tcp_special_leave_to_ap(void __iomem *reg_base)
{
	ipa_phy_set_force_to_ap(reg_base, IPA_TCP_FIN_LEAVE_2_AP_MASK |
				IPA_TCP_RST_LEAVE_2_AP_MASK, true);
}

static void ipa_phy_cp_dl_flow_ctrl_recover(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_INTERNAL_FIFO_CLR);

	tmp |= IPA_CP_DL_FLOW_CTRL_RECOVER_MASK;
	writel_relaxed(tmp, reg_base + IPA_INTERNAL_FIFO_CLR);

	tmp &= (~IPA_CP_DL_FLOW_CTRL_RECOVER_MASK);
	writel_relaxed(tmp, reg_base + IPA_INTERNAL_FIFO_CLR);
}

static void ipa_phy_errnode_int_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP_GENERAL_INT);

	tmp |= IPA_ERRNODE_INT_CLR_MASK;
	writel_relaxed(tmp, reg_base + IPA_MAP_GENERAL_INT);
}

static void ipa_phy_map_out_free_fifo_fatal_int_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP_GENERAL_INT);

	tmp |= IPA_MAP_OUT_FREE_FIFO_FATAL_INT_CLR_MASK;
	writel_relaxed(tmp, reg_base + IPA_MAP_GENERAL_INT);
}

static void ipa_phy_dc_int_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP_GENERAL_INT);

	tmp |= IPA_DC_INT_CLR_MASK;
	writel_relaxed(tmp, reg_base + IPA_MAP_GENERAL_INT);
}

static void ipa_phy_general_int_sel(void __iomem *reg_base, u32 mask,
				    bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP_GENERAL_INT);

	if (enable)
		tmp |= mask;
	else
		tmp &= (~mask);

	writel_relaxed(tmp, reg_base + IPA_MAP_GENERAL_INT);
}

static u32 ipa_phy_get_general_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_GENERAL_INT_STS);
}

static void ipa_phy_cp_dl_flow_ctrl_sel(void __iomem *reg_base, u32 mode)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_DL_FLOW_CTRL_SEL_MASK);
	tmp |= (mode << 30);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_dl_cur_term_num(void __iomem *reg_base, u32 term)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_DL_CUR_TERM_NUM_MASK);
	tmp |= (term << 25);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_dl_dst_term_num(void __iomem *reg_base, u32 term)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_DL_DST_TERM_NUM_MASK);
	tmp |= (term << 20);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_dl_priority(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_DL_PRIORITY_MASK);
	tmp |= (pri << 16);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_ul_flow_ctrl_sel(void __iomem *reg_base, u32 mode)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_UL_FLOW_CTRL_SEL_MASK);
	tmp |= (mode << 14);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_ul_cur_term_num(void __iomem *reg_base, u32 term)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_UL_CUR_TERM_NUM_MASK);
	tmp |= (term << 9);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_ul_dst_term_num(void __iomem *reg_base, u32 term)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_UL_DST_TERM_NUM_MASK);
	tmp |= (term << 4);
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static void ipa_phy_cp_ul_priority(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CP_CONFIGURATION);
	tmp &= (~IPA_CP_UL_PRIORITY_MASK);
	tmp |= pri;
	writel_relaxed(tmp, reg_base + IPA_CP_CONFIGURATION);
}

static u32 ipa_phy_get_ifilter_drop_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_IFILTER_DROP_CNT);
}

static u32 ipa_phy_get_ofilter_drop_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_OFILTER_DROP_CNT);
}

static u32 ipa_phy_get_htable_count_index(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_HTABLE_COUNT_INDEX);
}

static u32 ipa_phy_get_htable_timestamp(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_HTABLE_TIMESTAMP);
}

static void ipa_phy_htable_cache_hit_cnt_en(void __iomem *reg_base,
					    bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_CACHE_HIT_CTRL);

	if (enable)
		tmp |= IPA_HTABLE_CACHE_HIT_CNT_EN_MASK;
	else
		tmp &= (~IPA_HTABLE_CACHE_HIT_CNT_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_CACHE_HIT_CTRL);
}

static u32 ipa_phy_get_cache_hit_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CACHE_HIT_CTRL) &
		IPA_CACHE_HIT_CNT_MASK;
}

static void ipa_phy_htable_cache_hit_cnt_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_HIT_CTRL);

	tmp |= IPA_HTABLE_CACHE_HIT_CNT_CLR_MASK;

	writel_relaxed(tmp, reg_base + IPA_HTABLE_HIT_CTRL);
}

static u32 ipa_phy_get_htable_hit_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_HTABLE_HIT_CTRL) &
		IPA_HTABLE_HIT_CNT_MASK;
}

static void ipa_phy_bypass_dstid_chk_sel(void __iomem *reg_base,
					 bool node_id)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	if (node_id)
		tmp |= IPA_BYPASS_DSTID_CHK_SEL_MASK;
	else
		tmp &= (~IPA_BYPASS_DSTID_CHK_SEL_MASK);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_bypass_srcid_chk_sel(void __iomem *reg_base,
					 bool node_id)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	if (node_id)
		tmp |= IPA_BYPASS_SRCID_CHK_SEL_MASK;
	else
		tmp &= (~IPA_BYPASS_SRCID_CHK_SEL_MASK);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_node_dstid_chk_en(void __iomem *reg_base,
				      bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	if (enable)
		tmp |= IPA_NODE_DSTID_CHK_EN_MASK;
	else
		tmp &= (~IPA_NODE_DSTID_CHK_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_node_srcid_chk_en(void __iomem *reg_base,
				      bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	if (enable)
		tmp |= IPA_NODE_SRCID_CHK_EN_MASK;
	else
		tmp &= (~IPA_NODE_SRCID_CHK_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_ofilter_drop_cnt_en(void __iomem *reg_base,
					bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	if (enable)
		tmp |= IPA_OFILTER_DROP_CNT_EN_MASK;
	else
		tmp &= (~IPA_OFILTER_DROP_CNT_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_ifilter_drop_cnt_en(void __iomem *reg_base,
					bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	if (enable)
		tmp |= IPA_IFILTER_DROP_CNT_EN_MASK;
	else
		tmp &= (~IPA_IFILTER_DROP_CNT_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_ofilter_drop_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	tmp |= IPA_OFILTER_DROP_CLR_MASK;

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_ifilter_drop_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);

	tmp |= IPA_IFILTER_DROP_CLR_MASK;

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_set_sw_wr_trans_num_mask(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);
	tmp &= (~IPA_SW_WR_TRANS_NUM_MASK);
	tmp |= (val << 3);

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_set_sw_rd_trans_num_mask(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_DMA_COPY_CTRL);
	tmp &= (~IPA_SW_RD_TRANS_NUM_MASK);
	tmp |= val;

	writel_relaxed(tmp, reg_base + IPA_DMA_COPY_CTRL);
}

static void ipa_phy_set_ofilter_depth_ipv6(void __iomem *reg_base,
					   u32 depth)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FILTER_CTRL);

	tmp &= (~IPA_OFILTER_DEPTH_IPV6_MASK);
	tmp |= (depth << 25);

	writel_relaxed(tmp, reg_base + IPA_FILTER_CTRL);
}

static void ipa_phy_set_ofilter_depth_ipv4(void __iomem *reg_base,
					   u32 depth)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FILTER_CTRL);

	tmp &= (~IPA_OFILTER_DEPTH_IPV4_MASK);
	tmp |= (depth << 18);

	writel_relaxed(tmp, reg_base + IPA_FILTER_CTRL);
}

static bool ipa_phy_get_ofilter_locked_status(void __iomem *reg_base,
					      bool enable)
{
	u32 timeout = 5000;

	if (enable) {
		while (!((readl_relaxed(reg_base + IPA_FILTER_CTRL) &
			  IPA_OFILTER_LOCKED_MASK) ==
			 IPA_OFILTER_LOCKED_MASK) && timeout--)
			cpu_relax();

		if (!timeout)
			return -EIO;
	} else {
		while (((readl_relaxed(reg_base + IPA_FILTER_CTRL) &
			 IPA_OFILTER_LOCKED_MASK) ==
			IPA_OFILTER_LOCKED_MASK) && timeout--)
			cpu_relax();

		if (!timeout)
			return -EIO;
	}

	return 0;
}

static void ipa_phy_ofilter_ctrl(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FILTER_CTRL);

	if (enable)
		tmp |= IPA_OFILTER_CTRL_MASK;
	else
		tmp &= (~IPA_OFILTER_CTRL_MASK);

	writel_relaxed(tmp, reg_base + IPA_FILTER_CTRL);
}

static void ipa_phy_set_ifilter_depth_ipv6(void __iomem *reg_base,
					   u32 depth)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FILTER_CTRL);

	tmp &= (~IPA_IFILTER_DEPTH_IPV6_MASK);
	tmp |= (depth << 9);

	writel_relaxed(tmp, reg_base + IPA_FILTER_CTRL);
}

static void ipa_phy_set_ifilter_depth_ipv4(void __iomem *reg_base,
					   u32 depth)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FILTER_CTRL);

	tmp &= (~IPA_IFILTER_DEPTH_IPV4_MASK);
	tmp |= (depth << 2);

	writel_relaxed(tmp, reg_base + IPA_FILTER_CTRL);
}

static bool ipa_phy_get_ifilter_locked_status(void __iomem *reg_base,
					      bool enable)
{
	u32 timeout = 5000;

	if (enable) {
		while (!((readl_relaxed(reg_base + IPA_FILTER_CTRL) &
			  IPA_IFILTER_LOCKED_MASK) ==
			 IPA_IFILTER_LOCKED_MASK) && timeout--)
			cpu_relax();

		if (!timeout)
			return -EIO;
	} else {
		while (((readl_relaxed(reg_base + IPA_FILTER_CTRL) &
			 IPA_IFILTER_LOCKED_MASK) ==
			IPA_IFILTER_LOCKED_MASK) && timeout--)
			cpu_relax();

		if (!timeout)
			return -EIO;
	}

	return 0;
}

static void ipa_phy_ifilter_ctrl(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FILTER_CTRL);

	if (enable)
		tmp |= IPA_IFILTER_CTRL_MASK;
	else
		tmp &= (~IPA_IFILTER_CTRL_MASK);

	writel_relaxed(tmp, reg_base + IPA_FILTER_CTRL);
}

static void ipa_phy_set_default_hash(void __iomem *reg_base, u32 hash)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_STS);
	tmp &= (~IPA_DEFAULT_HASH_MASK);
	tmp |= (hash << 26);
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_STS);
}

static bool ipa_phy_get_htable_hw_valid(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_HASH_TABLE_STS) &
		IPA_HTABLE_HW_VALID_MASK) == IPA_HTABLE_HW_VALID_MASK;
}

static void ipa_phy_set_htable_max_entry_len(void __iomem *reg_base,
					     u32 hash)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_STS);
	tmp &= (~IPA_HTABLE_MAX_ENTRY_LEN_MASK);
	tmp |= (hash << 11);
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_STS);
}

static u32 ipa_phy_get_cache_wait_update_cnt(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_HASH_TABLE_STS) &
		IPA_CACHE_WAIT_UPDATE_CNT_MASK) >> 4;
}

static void ipa_phy_set_htable_max_rd_len(void __iomem *reg_base, u32 len)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_STS);
	tmp &= (~IPA_HTABLE_MAX_RD_LEN_MASK);
	tmp |= len;
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_STS);
}

static void ipa_phy_map_fifo_sel_mode(void __iomem *reg_base,
				      bool mode)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);

	if (mode)
		tmp |= IPA_MAP_FIFO_SEL_MODE;
	else
		tmp &= (~IPA_MAP_FIFO_SEL_MODE);

	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static void ipa_phy_set_map_fifo_cnt(void __iomem *reg_base, u32 cnt)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);
	tmp &= (~IPA_MAP_FIFO_CNT);
	tmp |= (cnt << 23);
	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static void ipa_phy_htable_limit_tmr_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);
	tmp |= IPA_HTABLE_LIMIT_TMR_CLR_MASK;
	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static void ipa_phy_htable_limit_tmr_scale(void __iomem *reg_base, u32 scale)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);
	tmp &= (~IPA_HTABLE_LIMIT_TMR_SCALE_MASK);
	tmp |= (scale << 12);
	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static void ipa_phy_htable_timestamp_tmr_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);
	tmp |= IPA_HTABLE_TIMESTAMP_TMR_CLR_MASK;
	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static void ipa_phy_htable_timestamp_tmr_scale(void __iomem *reg_base,
					       u32 scale)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);
	tmp &= (~IPA_HTABLE_TIMESTAMP_TMR_SCALE_MASK);
	tmp |= (scale << 1);
	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static void ipa_phy_htable_base_tmr_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HTABLE_TIMER);

	if (enable)
		tmp |= IPA_HTABLE_BASE_TMR_EN_MASK;
	else
		tmp &= (~IPA_HTABLE_BASE_TMR_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_HTABLE_TIMER);
}

static int ipa_phy_set_htable(void __iomem *reg_base, u32 htable_l,
			      u32 htable_h, u32 len)
{
	u32 tmp, timeout = 5000;

	writel_relaxed(htable_l, reg_base + IPA_HTABLE_BASE_L);
	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
	tmp &= (~IPA_HTABLE_BASE_H_MASK);
	tmp |= (htable_h << 24);
	tmp &= (~IPA_HTABLE_LEN_MASK);
	tmp |= (len << 2);
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
	tmp |= IPA_HTABLE_UPDATE_MASK;
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);

	while (!(readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL) &
		 IPA_HTABLE_UPDATE_DONE_MASK) && timeout--)
		cpu_relax();

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
	tmp &= (~IPA_HTABLE_UPDATE_MASK);
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);

	if (!timeout)
		return -EIO;

	return 0;
}

static bool ipa_phy_get_cache_sync_done(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL) &
		IPA_CACHE_SYNC_DONE_MASK) == IPA_CACHE_SYNC_DONE_MASK;
}

static void ipa_phy_set_cache_sync_req(void __iomem *reg_base)
{
	u32 tmp, timeout = 5000;

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
	tmp |= IPA_CACHE_SYNC_REQ_MASK;
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);

	while (!(readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL) &
		 IPA_CACHE_SYNC_DONE_MASK) && timeout--)
		cpu_relax();

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
	tmp &= (~IPA_CACHE_SYNC_REQ_MASK);
	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
}

static void ipa_phy_set_route_mode_ihl_ctrl_bit(void __iomem *reg_base,
						bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);

	if (enable)
		tmp |= IPA_ROUTE_MODE_IHL_CTRL_BIT_MASK;
	else
		tmp &= (~IPA_ROUTE_MODE_IHL_CTRL_BIT_MASK);

	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
}

static void ipa_phy_htable_sw_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL);

	if (enable)
		tmp |= IPA_HTABLE_SW_EN_MASK;
	else
		tmp &= (~IPA_HTABLE_SW_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_HASH_TABLE_SWITCH_CTRL);
}

static u32 ipa_phy_get_htable_errcode(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_HASH_TABLE_SWITCH_CTRL) &
		IPA_HTABLE_ERRCODE_MASK) >> 18;
}

static u32 ipa_phy_get_errnode_info_l(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_ERRNODE_INFO_L);
}

static u32 ipa_phy_get_errnode_info_m(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_ERRNODE_INFO_M);
}

static u32 ipa_phy_get_errnode_info_h(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_ERRNODE_INFO_H);
}

static void ipa_phy_set_map_hash_mask(void __iomem *reg_base, u32 mask)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);
	tmp &= (~IPA_MAP_HASH_MASK_MASK);
	tmp |= (mask << 27);
	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static void ipa_phy_map_multi_fifo_mode_en(void __iomem *reg_base,
					   bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);

	if (enable)
		tmp |= IPA_MAP_MULTI_FIFO_MODE_EN_MASK;
	else
		tmp &= (~IPA_MAP_MULTI_FIFO_MODE_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static u32 ipa_phy_map_multi_fifo_mode(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_IPA_CTRL) &
		IPA_MAP_MULTI_FIFO_MODE_EN_MASK) >> 26;
}

static void ipa_phy_errcode_int_en(void __iomem *reg_base, u32 mode)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);
	tmp &= (~IPA_ERRCODE_INT_EN_MASK);
	tmp |= (mode << 18);
	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static void ipa_phy_dl_pcie_dma_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);

	if (enable)
		tmp |= IPA_DL_PCIE_DMA_EN_MASK;
	else
		tmp &= (~IPA_DL_PCIE_DMA_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static void ipa_phy_set_pcie_msi_int_mode(void __iomem *reg_base,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);

	if (enable)
		tmp |= IPA_PCIE_MSI_INT_MODE_MASK;
	else
		tmp &= (~IPA_PCIE_MSI_INT_MODE_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static void ipa_phy_pcie_hw_int_en(void __iomem *reg_base,
				   bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);

	if (enable)
		tmp |= IPA_PCIE_HW_INT_EN_MASK;
	else
		tmp &= (~IPA_PCIE_HW_INT_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static void ipa_phy_wiap_ul_dma_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_CTRL);

	if (enable)
		tmp |= IPA_IPA_WIAP_UL_DMA_EN_MASK;
	else
		tmp &= (~IPA_IPA_WIAP_UL_DMA_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_CTRL);
}

static void ipa_phy_set_dfs_cycle_cnt_val(void __iomem *reg_base,
					  u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL0);
	tmp &= (~IPA_IPA_DFS_CYCLE_CNT_VAL_MASK);
	tmp |= (val << 11);
	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL0);
}

static void ipa_phy_set_dfs_period(void __iomem *reg_base, u32 period)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL0);
	tmp &= (~IPA_IPA_DFS_PERIOD_MASK);
	tmp |= (period << 1);
	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL0);
}

static void ipa_phy_dfs_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL0);

	if (enable)
		tmp |= IPA_IPA_DFS_EN_MASK;
	else
		tmp &= (~IPA_IPA_DFS_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL0);
}

static void ipa_phy_dfs_th3(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL1);
	tmp &= (~IPA_IPA_DFS_TH3_MASK);
	tmp |= (val << 24);
	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL1);
}

static void ipa_phy_dfs_th2(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL1);
	tmp &= (~IPA_IPA_DFS_TH2_MASK);
	tmp |= (val << 16);
	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL1);
}

static void ipa_phy_dfs_th1(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL1);
	tmp &= (~IPA_IPA_DFS_TH1_MASK);
	tmp |= (val << 8);
	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL1);
}

static void ipa_phy_dfs_th0(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DFS_CTRL1);
	tmp &= (~IPA_IPA_DFS_TH0_MASK);
	tmp |= val;
	writel_relaxed(tmp, reg_base + IPA_IPA_DFS_CTRL1);
}

static bool ipa_phy_get_dc_done_status(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_IPA_DC_CTRL) &
		IPA_DC_DONE_MASK) == IPA_DC_DONE_MASK;
}

static void ipa_phy_dc_ip_sel(void __iomem *reg_base, bool is_tft)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);

	if (is_tft)
		tmp |= IPA_DC_IP_SEL_MASK;
	else
		tmp &= (~IPA_DC_IP_SEL_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);

	if (enable)
		tmp |= IPA_DC_EN_MASK;
	else
		tmp &= (~IPA_DC_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_init(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp |= IPA_DC_INIT_MASK;
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_loop_mode(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);

	if (enable)
		tmp |= IPA_DC_LOOP_MODE_MASK;
	else
		tmp &= (~IPA_DC_LOOP_MODE_MASK);

	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_chn_sel(void __iomem *reg_base, u32 chn)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp &= (~IPA_DC_CHN_SEL_MASK);
	tmp |= (chn << 16);
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_stop_sel(void __iomem *reg_base, u32 chn)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp &= (~IPA_DC_STOP_SEL_MASK);
	tmp |= (chn << 14);
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_start_sel(void __iomem *reg_base, u32 chn)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp &= (~IPA_DC_START_SEL_MASK);
	tmp |= (chn << 12);
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_sw_stop(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp |= IPA_DC_SW_STOP_MASK;
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_sw_start(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp |= IPA_DC_SW_START_MASK;
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static void ipa_phy_dc_sw_len(void __iomem *reg_base, u32 len)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_CTRL);
	tmp &= (~IPA_DC_MAX_LEN_MASK);
	tmp |= len;
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_CTRL);
}

static u32 ipa_phy_get_dc_vld_clk_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_IPA_DC_VLD_CLK_CNT);
}

static void ipa_phy_set_dc_data_mask(void __iomem *reg_base, u32 mask)
{
	writel_relaxed(mask, reg_base + IPA_IPA_DC_DATA_MASK);
}

static void ipa_phy_set_dc_meet_cond(void __iomem *reg_base, u32 cond)
{
	writel_relaxed(cond, reg_base + IPA_IPA_DC_MEET_COND);
}

static void ipa_phy_set_dc_init_raddr(void __iomem *reg_base, u32 addr)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_RADDR_CTRL);
	tmp &= (~IPA_DC_INIT_RADDR_MASK);
	tmp |= (addr << 11);
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_RADDR_CTRL);
}

static void ipa_phy_set_dc_raddr_load(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_IPA_DC_RADDR_CTRL);
	tmp |= IPA_DC_RADDR_LOAD_MASK;
	writel_relaxed(tmp, reg_base + IPA_IPA_DC_RADDR_CTRL);
}

static u32 ipa_phy_get_dc_raddr(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_IPA_DC_RADDR_CTRL) &
		IPA_DC_RADDR_MASK;
}

static void ipa_phy_set_fifo_monitor_sel0(void __iomem *reg_base, u32 chn)
{
	writel_relaxed(chn, reg_base + IPA_FIFO_MONITOR_SEL0);
}

static void ipa_phy_set_ip_pkt_fifo_monitor_sel(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FIFO_MONITOR_SEL1);
	tmp &= (~IPA_IP_PKT_FIFO_MONITOR_SEL_MASK);
	tmp |= (val << 16);
	writel_relaxed(tmp, reg_base + IPA_FIFO_MONITOR_SEL1);
}

static void
ipa_phy_set_output_chn_fifo_monitor_sel(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FIFO_MONITOR_SEL1);
	tmp &= (~IPA_OUTPUT_CHN_FIFO_MONITOR_SEL_MASK);
	tmp |= (val << 8);
	writel_relaxed(tmp, reg_base + IPA_FIFO_MONITOR_SEL1);
}

static void
ipa_phy_set_input_chn_fifo_monitor_sel(void __iomem *reg_base, u32 val)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FIFO_MONITOR_SEL1);
	tmp &= (~IPA_INPUT_CHN_FIFO_MONITOR_SEL_MASK);
	tmp |= val;
	writel_relaxed(tmp, reg_base + IPA_FIFO_MONITOR_SEL1);
}

static u32 ipa_phy_get_ip_pkt_fifo_empty_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_IP_PKT_FIFO_STS) &
		IPA_IP_PKT_FIFO_EMPTY_HIT_MASK) >> 16;
}

static u32 ipa_phy_get_ip_pkt_fifo_full_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_IP_PKT_FIFO_STS) &
		IPA_IP_PKT_FIFO_FULL_HIT_MASK);
}

static u32 ipa_phy_get_data_chn_fifo_empty_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_DATA_CHN_FIFO_STS) &
		IPA_DATA_CHN_FIFO_EMPTY_HIT_MASK) >> 16;
}

static u32 ipa_phy_get_data_chn_fifo_full_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_DATA_CHN_FIFO_STS) &
		IPA_DATA_CHN_FIFO_FULL_HIT_MASK);
}

static u32 ipa_phy_get_input_chn_fifo_empty_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_INPUT_CHN_FIFO_STS) &
		IPA_INPUT_CHN_FIFO_EMPTY_HIT_MASK) >> 16;
}

static u32 ipa_phy_get_input_chn_fifo_full_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_INPUT_CHN_FIFO_STS) &
		IPA_INPUT_CHN_FIFO_FULL_HIT_MASK);
}

static u32 ipa_phy_get_output_chn_fifo_empty_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_OUTPUT_CHN_FIFO_STS) &
		IPA_OUTPUT_CHN_FIFO_EMPTY_HIT_MASK) >> 16;
}

static u32 ipa_phy_get_output_chn_fifo_full_hit(void __iomem *reg_base)
{
	return (readl_relaxed(reg_base + IPA_OUTPUT_CHN_FIFO_STS) &
		IPA_OUTPUT_CHN_FIFO_FULL_HIT_MASK);
}

static u32 ipa_phy_get_clk_gate_aon_0(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CLK_GATE_AON_0);
}

static u32 ipa_phy_get_clk_gate_aon_1(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CLK_GATE_AON_1);
}

static void ipa_phy_set_map3_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI0);
	tmp &= (~IPA_MAP3_FREE_FIFO_PRI_MASK);
	tmp |= (pri << 24);
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI0);
}

static void ipa_phy_set_map2_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI0);
	tmp &= (~IPA_MAP2_FREE_FIFO_PRI_MASK);
	tmp |= (pri << 16);
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI0);
}

static void ipa_phy_set_map1_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI0);
	tmp &= (~IPA_MAP1_FREE_FIFO_PRI_MASK);
	tmp |= (pri << 8);
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI0);
}

static void ipa_phy_set_map0_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI0);
	tmp &= (~IPA_MAP0_FREE_FIFO_PRI_MASK);
	tmp |= pri;
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI0);
}

static void ipa_phy_set_map7_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI1);
	tmp &= (~IPA_MAP7_FREE_FIFO_PRI_MASK);
	tmp |= (pri << 24);
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI1);
}

static void ipa_phy_set_map6_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI1);
	tmp &= (~IPA_MAP6_FREE_FIFO_PRI_MASK);
	tmp |= (pri << 16);
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI1);
}

static void ipa_phy_set_map5_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI1);
	tmp &= (~IPA_MAP5_FREE_FIFO_PRI_MASK);
	tmp |= (pri << 8);
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI1);
}

static void ipa_phy_set_map4_free_fifo_pri(void __iomem *reg_base, u32 pri)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_OUT_MAP_PRI1);
	tmp &= (~IPA_MAP4_FREE_FIFO_PRI_MASK);
	tmp |= pri;
	writel_relaxed(tmp, reg_base + IPA_OUT_MAP_PRI1);
}

static void ipa_phy_out_map_en(void __iomem *reg_base, u32 mask)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	tmp &= (~IPA_OUT_MAP_EN_MASK);
	tmp |= (mask << 20);
	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_out_wiap_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_OUT_WIAP_EN_MASK;
	else
		tmp &= (~IPA_OUT_WIAP_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_out_pcie_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_OUT_PCIE_EN_MASK;
	else
		tmp &= (~IPA_OUT_PCIE_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_out_wifi_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_OUT_WIFI_EN_MASK;
	else
		tmp &= (~IPA_OUT_WIFI_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_out_usb_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_OUT_USB_EN_MASK;
	else
		tmp &= (~IPA_OUT_USB_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_in_map_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_IN_MAP_EN_MASK;
	else
		tmp &= (~IPA_IN_MAP_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_in_wiap_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_IN_WIAP_EN_MASK;
	else
		tmp &= (~IPA_IN_WIAP_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_in_pcie_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_IN_PCIE_EN_MASK;
	else
		tmp &= (~IPA_IN_PCIE_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_in_wifi_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_IN_WIFI_EN_MASK;
	else
		tmp &= (~IPA_IN_WIFI_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_in_usb_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_COMMON_FIFO_EN);
	if (enable)
		tmp |= IPA_IN_USB_EN_MASK;
	else
		tmp &= (~IPA_IN_USB_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_COMMON_FIFO_EN);
}

static void ipa_phy_set_pcie_dl_tx_fifo_int_addr_low(void __iomem *reg_base,
						     u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_DL_TX_FIFO_INT_ADDR_LOW);
}

static void ipa_phy_set_pcie_dl_rx_fifo_int_addr_low(void __iomem *reg_base,
						     u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_DL_RX_FIFO_INT_ADDR_LOW);
}

static void ipa_phy_set_pcie_ul_tx_fifo_int_addr_low(void __iomem *reg_base,
						     u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_UL_TX_FIFO_INT_ADDR_LOW);
}

static void ipa_phy_set_pcie_ul_rx_fifo_int_addr_low(void __iomem *reg_base,
						     u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_UL_RX_FIFO_INT_ADDR_LOW);
}

static void ipa_phy_set_pcie_dl_tx_fifo_int_addr_high(void __iomem *reg_base,
						      u32 addr)
{
	addr &= IPA_PCIE_DL_TX_FIFO_INT_ADDR_HIGH_MASK;
	writel_relaxed(addr, reg_base + IPA_PCIE_DL_TX_FIFO_INT_ADDR_HIGH);
}

static void ipa_phy_set_pcie_dl_rx_fifo_int_addr_high(void __iomem *reg_base,
						      u32 addr)
{
	addr &= IPA_PCIE_DL_RX_FIFO_INT_ADDR_HIGH_MASK;
	writel_relaxed(addr, reg_base + IPA_PCIE_DL_RX_FIFO_INT_ADDR_HIGH);
}

static void ipa_phy_set_pcie_ul_tx_fifo_int_addr_high(void __iomem *reg_base,
						      u32 addr)
{
	addr &= IPA_PCIE_UL_TX_FIFO_INT_ADDR_HIGH_MASK;
	writel_relaxed(addr, reg_base + IPA_PCIE_UL_TX_FIFO_INT_ADDR_HIGH);
}

static void ipa_phy_set_pcie_ul_rx_fifo_int_addr_high(void __iomem *reg_base,
						      u32 addr)
{
	addr &= IPA_PCIE_UL_RX_FIFO_INT_ADDR_HIGH_MASK;
	writel_relaxed(addr, reg_base + IPA_PCIE_UL_RX_FIFO_INT_ADDR_HIGH);
}

static void ipa_phy_set_pcie_dl_tx_fifo_int_pattern(void __iomem *reg_base,
						    u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_DL_TX_FIFO_INT_PATTERN);
}

static void ipa_phy_set_pcie_dl_rx_fifo_int_pattern(void __iomem *reg_base,
						    u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_DL_RX_FIFO_INT_PATTERN);
}

static void ipa_phy_set_pcie_ul_tx_fifo_int_pattern(void __iomem *reg_base,
						    u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_UL_TX_FIFO_INT_PATTERN);
}

static void ipa_phy_set_pcie_ul_rx_fifo_int_pattern(void __iomem *reg_base,
						    u32 addr)
{
	writel_relaxed(addr, reg_base + IPA_PCIE_UL_RX_FIFO_INT_PATTERN);
}

static u64 ipa_phy_get_usb_push_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_PUSH_NODE_TOTAL_CNT) |
		((u64)(readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_PUSH_NODE_TOTAL_CNT_H_MASK) << 32);
}

static u64 ipa_phy_get_usb_push_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_PUSH_NODE_L1_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_PUSH_NODE_L1_CNT_H_MASK) >> 4) << 32);
}

static u64 ipa_phy_get_usb_push_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_PUSH_NODE_L2_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_PUSH_NODE_L2_CNT_H_MASK) >> 8) << 32);
}

static u64 ipa_phy_get_usb_push_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_PUSH_NODE_L3_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_PUSH_NODE_L3_CNT_H_MASK) >> 12) << 32);
}

static u64 ipa_phy_get_usb_push_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_PUSH_NODE_L4_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_PUSH_NODE_L4_CNT_H_MASK) >> 16) << 32);
}

static u64 ipa_phy_get_usb_fetch_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_FETCH_NODE_TOTAL_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_FETCH_NODE_TOTAL_CNT_H_MASK) >> 20) << 32);
}

static u64 ipa_phy_get_usb_fetch_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_FETCH_NODE_L1_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_FETCH_NODE_L1_CNT_H_MASK) >> 24) << 32);
}

static u64 ipa_phy_get_usb_fetch_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_FETCH_NODE_L2_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_USB_NODE_CNT) &
		IPA_USB_FETCH_NODE_L2_CNT_H_MASK) >> 28) << 32);
}

static u64 ipa_phy_get_usb_fetch_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_FETCH_NODE_L3_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		IPA_USB_FETCH_NODE_L3_CNT_H_MASK)) << 32);
}

static u64 ipa_phy_get_usb_fetch_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_USB_FETCH_NODE_L4_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		IPA_USB_FETCH_NODE_L4_CNT_H_MASK) >> 4) << 32);
}

static u64 ipa_phy_get_pcie_push_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_PUSH_NODE_TOTAL_CNT) |
		((u64)(readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		IPA_PCIE_PUSH_NODE_TOTAL_CNT_H_MASK) << 32);
}

static u64 ipa_phy_get_pcie_push_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_PUSH_NODE_L1_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_PUSH_NODE_L1_CNT_H_MASK) >> 4) << 32);
}

static u64 ipa_phy_get_pcie_push_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_PUSH_NODE_L2_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_PUSH_NODE_L2_CNT_H_MASK) >> 8) << 32);
}

static u64 ipa_phy_get_pcie_push_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_PUSH_NODE_L3_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_PUSH_NODE_L3_CNT_H_MASK) >> 12) << 32);
}

static u64 ipa_phy_get_pcie_push_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_PUSH_NODE_L4_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_PUSH_NODE_L4_CNT_H_MASK) >> 16) << 32);
}

static u64 ipa_phy_get_pcie_fetch_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_FETCH_NODE_TOTAL_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_FETCH_NODE_TOTAL_CNT_H_MASK) >> 20) << 32);
}

static u64 ipa_phy_get_pcie_fetch_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_FETCH_NODE_L1_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_FETCH_NODE_L1_CNT_H_MASK) >> 24) << 32);
}

static u64 ipa_phy_get_pcie_fetch_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_FETCH_NODE_L2_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_PCIE_NODE_CNT) &
		 IPA_PCIE_FETCH_NODE_L2_CNT_H_MASK) >> 28) << 32);
}

static u64 ipa_phy_get_pcie_fetch_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_FETCH_NODE_L3_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		 IPA_PCIE_FETCH_NODE_L3_CNT_H_MASK) >> 8) << 32);
}

static u64 ipa_phy_get_pcie_fetch_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_PCIE_FETCH_NODE_L4_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		 IPA_PCIE_FETCH_NODE_L4_CNT_H_MASK) >> 12) << 32);
}

static u64 ipa_phy_get_wifi_push_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_PUSH_NODE_TOTAL_CNT) |
		((u64)(readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_PUSH_NODE_TOTAL_CNT_H_MASK) << 32);
}

static u64 ipa_phy_get_wifi_push_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_PUSH_NODE_L1_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_PUSH_NODE_L1_CNT_H_MASK) >> 4) << 32);
}

static u64 ipa_phy_get_wifi_push_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_PUSH_NODE_L2_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_PUSH_NODE_L2_CNT_H_MASK) >> 8) << 32);
}

static u64 ipa_phy_get_wifi_push_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_PUSH_NODE_L3_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_PUSH_NODE_L3_CNT_H_MASK) >> 12) << 32);
}

static u64 ipa_phy_get_wifi_push_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_PUSH_NODE_L4_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_PUSH_NODE_L4_CNT_H_MASK) >> 16) << 32);
}

static u64 ipa_phy_get_wifi_fetch_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_FETCH_NODE_TOTAL_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_FETCH_NODE_TOTAL_CNT_H_MASK) >> 20) << 32);
}

static u64 ipa_phy_get_wifi_fetch_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_FETCH_NODE_L1_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_FETCH_NODE_L1_CNT_H_MASK) >> 24) << 32);
}

static u64 ipa_phy_get_wifi_fetch_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_FETCH_NODE_L2_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_WIFI_NODE_CNT) &
		 IPA_WIFI_FETCH_NODE_L2_CNT_H_MASK) >> 28) << 32);
}

static u64 ipa_phy_get_wifi_fetch_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_FETCH_NODE_L3_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		 IPA_WIFI_FETCH_NODE_L3_CNT_H_MASK) >> 16) << 32);
}

static u64 ipa_phy_get_wifi_fetch_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_WIFI_FETCH_NODE_L4_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		 IPA_WIFI_FETCH_NODE_L4_CNT_H_MASK) >> 20) << 32);
}

static u64 ipa_phy_get_map_push_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_PUSH_NODE_TOTAL_CNT) |
		((u64)(readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_PUSH_NODE_TOTAL_CNT_H_MASK) << 32);
}

static u64 ipa_phy_get_map_push_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_PUSH_NODE_L1_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_PUSH_NODE_L1_CNT_H_MASK) >> 4) << 32);
}

static u64 ipa_phy_get_map_push_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_PUSH_NODE_L2_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_PUSH_NODE_L2_CNT_H_MASK) >> 8) << 32);
}

static u64 ipa_phy_get_map_push_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_PUSH_NODE_L3_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_PUSH_NODE_L3_CNT_H_MASK) >> 12) << 32);
}

static u64 ipa_phy_get_map_push_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_PUSH_NODE_L4_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_PUSH_NODE_L4_CNT_H_MASK) >> 16) << 32);
}

static u64 ipa_phy_get_map_fetch_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_FETCH_NODE_TOTAL_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_FETCH_NODE_TOTAL_CNT_H_MASK) >> 20) << 32);
}

static u64 ipa_phy_get_map_fetch_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_FETCH_NODE_L1_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_FETCH_NODE_L1_CNT_H_MASK) >> 24) << 32);
}

static u64 ipa_phy_get_map_fetch_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_FETCH_NODE_L2_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_MAP_NODE_CNT) &
		 IPA_MAP_FETCH_NODE_L2_CNT_H_MASK) >> 28) << 32);
}

static u64 ipa_phy_get_map_fetch_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_FETCH_NODE_L3_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		 IPA_MAP_FETCH_NODE_L3_CNT_H_MASK) >> 24) << 32);
}

static u64 ipa_phy_get_map_fetch_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP_FETCH_NODE_L4_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_L) &
		 IPA_MAP_FETCH_NODE_L4_CNT_H_MASK) >> 28) << 32);
}

static u64 ipa_phy_get_cp_push_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_PUSH_NODE_TOTAL_CNT) |
		((u64)(readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_PUSH_NODE_TOTAL_CNT_H_MASK) << 32);
}

static u64 ipa_phy_get_cp_push_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_PUSH_NODE_L1_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_PUSH_NODE_L1_CNT_H_MASK) >> 4) << 32);
}

static u64 ipa_phy_get_cp_push_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_PUSH_NODE_L2_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_PUSH_NODE_L2_CNT_H_MASK) >> 8) << 32);
}

static u64 ipa_phy_get_cp_push_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_PUSH_NODE_L3_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_PUSH_NODE_L3_CNT_H_MASK) >> 12) << 32);
}

static u64 ipa_phy_get_cp_push_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_PUSH_NODE_L4_CNT) |
		((u64)((readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_PUSH_NODE_L4_CNT_H_MASK) >> 16) << 32);
}

static u64 ipa_phy_get_cp_fetch_node_total_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_FETCH_NODE_TOTAL_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_FETCH_NODE_TOTAL_CNT_H_MASK) >> 20) << 32);
}

static u64 ipa_phy_get_cp_fetch_node_l1_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_FETCH_NODE_L1_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_FETCH_NODE_L1_CNT_H_MASK) >> 24) << 32);
}

static u64 ipa_phy_get_cp_fetch_node_l2_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_FETCH_NODE_L2_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_CP_NODE_CNT) &
		 IPA_CP_FETCH_NODE_L2_CNT_H_MASK) >> 28) << 32);
}

static u64 ipa_phy_get_cp_fetch_node_l3_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_FETCH_NODE_L3_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_H) &
		 IPA_CP_FETCH_NODE_L3_CNT_H_MASK)) << 32);
}

static u64 ipa_phy_get_cp_fetch_node_l4_cnt(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_CP_FETCH_NODE_L4_CNT) |
		(((u64)(readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_H) &
		 IPA_CP_FETCH_NODE_L4_CNT_H_MASK) >> 4) << 32);
}

static void ipa_phy_traffic_counter_clr(void __iomem *reg_base)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_H);
	tmp |= IPA_TRAFFIC_COUNTER_CLR_MASK;
	writel_relaxed(tmp, reg_base + IPA_FETCH_NODE_CNT_H);
}

static void ipa_phy_traffic_counter_en(void __iomem *reg_base, bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_FETCH_NODE_CNT_H);

	if (enable)
		tmp |= IPA_TRAFFIC_COUNT_EN_MASK;
	else
		tmp &= (~IPA_TRAFFIC_COUNT_EN_MASK);

	writel_relaxed(tmp, reg_base + IPA_FETCH_NODE_CNT_H);
}

static void ipa_phy_map0_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP0_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP0_INTERRUPT_SRC_EN);
}

static void ipa_phy_map1_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP1_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP1_INTERRUPT_SRC_EN);
}

static void ipa_phy_map2_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP2_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP2_INTERRUPT_SRC_EN);
}

static void ipa_phy_map3_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP3_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP3_INTERRUPT_SRC_EN);
}

static void ipa_phy_map4_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP4_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP4_INTERRUPT_SRC_EN);
}

static void ipa_phy_map5_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP5_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP5_INTERRUPT_SRC_EN);
}

static void ipa_phy_map6_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP6_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP6_INTERRUPT_SRC_EN);
}

static void ipa_phy_map7_interrupt_src_en(void __iomem *reg_base, u32 src,
					  bool enable)
{
	u32 tmp;

	tmp = readl_relaxed(reg_base + IPA_MAP7_INTERRUPT_SRC_EN);

	if (enable)
		tmp |= src;
	else
		tmp &= (~src);

	writel_relaxed(tmp, reg_base + IPA_MAP7_INTERRUPT_SRC_EN);
}

static u32 ipa_phy_get_map0_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP0_INT_STS);
}

static u32 ipa_phy_get_map1_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP1_INT_STS);
}

static u32 ipa_phy_get_map2_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP2_INT_STS);
}

static u32 ipa_phy_get_map3_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP3_INT_STS);
}

static u32 ipa_phy_get_map4_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP4_INT_STS);
}

static u32 ipa_phy_get_map5_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP5_INT_STS);
}

static u32 ipa_phy_get_map6_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP6_INT_STS);
}

static u32 ipa_phy_get_map7_int_sts(void __iomem *reg_base)
{
	return readl_relaxed(reg_base + IPA_MAP7_INT_STS);
}

static u32 ipa_phy_get_fifo_irq_status(int cpu, void __iomem *reg_base)
{
	switch (cpu) {
	case 0:
		return readl_relaxed(reg_base + IPA_MAP0_INT_STS);
	case 1:
		return readl_relaxed(reg_base + IPA_MAP1_INT_STS);
	case 2:
		return readl_relaxed(reg_base + IPA_MAP2_INT_STS);
	case 3:
		return readl_relaxed(reg_base + IPA_MAP3_INT_STS);
	case 4:
		return readl_relaxed(reg_base + IPA_MAP4_INT_STS);
	case 5:
		return readl_relaxed(reg_base + IPA_MAP5_INT_STS);
	case 6:
		return readl_relaxed(reg_base + IPA_MAP6_INT_STS);
	case 7:
		return readl_relaxed(reg_base + IPA_MAP7_INT_STS);
	default:
		pr_err("sipa invalid cpu = %d\n", cpu);
		break;
	}

	return 0;
}

static void ipa_phy_enable_def_interrupt_src(void __iomem *reg_base)
{
	ipa_phy_map0_interrupt_src_en(reg_base, IPA_MAP_IN_MAP0_INT_SEL_MASK,
				      true);
	ipa_phy_map0_interrupt_src_en(reg_base, IPA_MAP0_OUT_MAP0_INT_SEL_MASK,
				      true);
	ipa_phy_map1_interrupt_src_en(reg_base, IPA_MAP1_OUT_MAP1_INT_SEL_MASK,
				      true);
	ipa_phy_map2_interrupt_src_en(reg_base, IPA_MAP2_OUT_MAP2_INT_SEL_MASK,
				      true);
	ipa_phy_map3_interrupt_src_en(reg_base, IPA_MAP3_OUT_MAP3_INT_SEL_MASK,
				      true);
	ipa_phy_map4_interrupt_src_en(reg_base, IPA_MAP4_OUT_MAP4_INT_SEL_MASK,
				      true);
	ipa_phy_map5_interrupt_src_en(reg_base, IPA_MAP5_OUT_MAP5_INT_SEL_MASK,
				      true);
	ipa_phy_map6_interrupt_src_en(reg_base, IPA_MAP6_OUT_MAP6_INT_SEL_MASK,
				      true);
	ipa_phy_map7_interrupt_src_en(reg_base, IPA_MAP7_OUT_MAP7_INT_SEL_MASK,
				      true);
}

static void ipa_phy_set_wifi_ul_map0_int_sel(void __iomem *reg_base,
					     bool status)
{
	ipa_phy_map0_interrupt_src_en(reg_base,
				      IPA_WIFI_UL_MAP0_INT_SEL_MASK,
				      status);
}

static void ipa_phy_set_def_flow_ctl_to_src_blk(void __iomem *reg_base)
{
	ipa_phy_set_flow_ctl_to_src_blk(reg_base, IPA_MAP_FLOW_CTL_TO_CP_MASK,
					true);
}

static void ipa_phy_set_map_flow_ctl_to_wifi(void __iomem *reg_base, bool status)
{
	ipa_phy_set_flow_ctl_to_src_blk(reg_base,
					IPA_MAP_FLOW_CTL_TO_WIFI_MASK,
					status);
}

static int ipa_phy_ctrl_def_hash_en(void __iomem *reg_base)
{
	return ipa_phy_ctrl_hash_en(reg_base, IPA_CP_DL_HASH_EN_MASK |
				    IPA_WIAP_DL_HASH_EN_MASK |
				    IPA_PCIE_UL_HASH_EN_MASK |
				    IPA_WIFI_UL_HASH_EN_MASK |
				    IPA_USB_UL_HASH_EN_MASK, true);
}

static int ipa_phy_ctrl_def_chksum_en(void __iomem *reg_base)
{
	return ipa_phy_ctrl_chksum_en(reg_base, IPA_CP_DL_CHKSUM_EN_MASK |
				     IPA_WIAP_DL_CHKSUM_EN_MASK |
				     IPA_PCIE_UL_CHKSUM_EN_MASK |
				     IPA_WIFI_UL_CHKSUM_EN_MASK |
				     IPA_USB_UL_CHKSUM_EN_MASK, true);
}

static void ipa_phy_fill_ifilter_ipv4(void __iomem *reg_base, u32 data)
{
	writel_relaxed(data, reg_base + IPA_IFILTER_IPV4);
}

static void ipa_phy_fill_ifilter_ipv6(void __iomem *reg_base, u32 data)
{
	writel_relaxed(data, reg_base + IPA_IFILTER_IPV6);
}

static void ipa_phy_fill_ofilter_ipv4(void __iomem *reg_base, u32 data)
{
	writel_relaxed(data, reg_base + IPA_OFILTER_IPV4);
}

static void ipa_phy_fill_ofilter_ipv6(void __iomem *reg_base, u32 data)
{
	writel_relaxed(data, reg_base + IPA_OFILTER_IPV6);
}

void sipa_glb_ops_init(struct sipa_glb_phy_ops *glb_ops)
{
	glb_ops->set_work_mode = ipa_phy_set_work_mode;
	glb_ops->get_work_mode = ipa_phy_get_work_mode;
	glb_ops->set_usb_mode = ipa_phy_set_usb_mode;
	glb_ops->set_need_cp_through_pcie = ipa_phy_set_need_cp_through_pcie;
	glb_ops->ctrl_ipa_action = ipa_phy_ctrl_ipa_action;
	glb_ops->ctrl_hash_en = ipa_phy_ctrl_hash_en;
	glb_ops->ctrl_chksum_en = ipa_phy_ctrl_chksum_en;
	glb_ops->monitor_ipa_or_tft = ipa_phy_monitor_ipa_or_tft;
	glb_ops->to_pcie_no_mac_hdr = ipa_phy_to_pcie_no_mac_hdr;
	glb_ops->from_pcie_no_mac_hdr = ipa_phy_from_pcie_no_mac_hdr;
	glb_ops->dbg_clk_gate_en = ipa_phy_dbg_clk_gate_en;
	glb_ops->cp_work_status = ipa_phy_cp_work_status;
	glb_ops->get_wiap_ul_flow_ctrl_status =
		ipa_phy_get_wiap_ul_flow_ctrl_status;
	glb_ops->get_wifi_dl_flow_ctrl_status =
		ipa_phy_get_wifi_dl_flow_ctrl_status;
	glb_ops->get_usb_dl_flow_ctrl_status =
		ipa_phy_get_usb_dl_flow_ctrl_status;
	glb_ops->get_pcie_dl_flow_ctrl_status =
		ipa_phy_get_pcie_dl_flow_ctrl_status;
	glb_ops->get_cp_ul_flow_ctrl_status =
		ipa_phy_get_cp_ul_flow_ctrl_status;
	glb_ops->input_filter_en = ipa_phy_input_filter_en;
	glb_ops->output_filter_en = ipa_phy_output_filter_en;
	glb_ops->htable_cache_en = ipa_phy_htable_cache_en;
	glb_ops->get_cp_remote_flow_ctrl_status =
		ipa_phy_get_cp_remote_flow_ctrl_status;
	glb_ops->set_flow_ctl_to_src_blk = ipa_phy_set_flow_ctl_to_src_blk;
	glb_ops->set_force_to_ap = ipa_phy_set_force_to_ap;
	glb_ops->tcp_special_leave_to_ap = ipa_phy_tcp_special_leave_to_ap;
	glb_ops->cp_dl_flow_ctrl_recover = ipa_phy_cp_dl_flow_ctrl_recover;
	glb_ops->errnode_int_clr = ipa_phy_errnode_int_clr;
	glb_ops->map_out_free_fifo_fatal_int_clr =
		ipa_phy_map_out_free_fifo_fatal_int_clr;
	glb_ops->dc_int_clr = ipa_phy_dc_int_clr;
	glb_ops->general_int_sel = ipa_phy_general_int_sel;
	glb_ops->get_general_int_sts = ipa_phy_get_general_int_sts;
	glb_ops->cp_dl_flow_ctrl_sel = ipa_phy_cp_dl_flow_ctrl_sel;
	glb_ops->cp_dl_cur_term_num = ipa_phy_cp_dl_cur_term_num;
	glb_ops->cp_dl_dst_term_num = ipa_phy_cp_dl_dst_term_num;
	glb_ops->cp_dl_priority = ipa_phy_cp_dl_priority;
	glb_ops->cp_ul_flow_ctrl_sel = ipa_phy_cp_ul_flow_ctrl_sel;
	glb_ops->cp_ul_cur_term_num = ipa_phy_cp_ul_cur_term_num;
	glb_ops->cp_ul_dst_term_num = ipa_phy_cp_ul_dst_term_num;
	glb_ops->cp_ul_priority = ipa_phy_cp_ul_priority;
	glb_ops->get_ifilter_drop_cnt = ipa_phy_get_ifilter_drop_cnt;
	glb_ops->get_ofilter_drop_cnt = ipa_phy_get_ofilter_drop_cnt;
	glb_ops->get_htable_count_index = ipa_phy_get_htable_count_index;
	glb_ops->get_htable_timestamp = ipa_phy_get_htable_timestamp;
	glb_ops->htable_cache_hit_cnt_en = ipa_phy_htable_cache_hit_cnt_en;
	glb_ops->get_cache_hit_cnt = ipa_phy_get_cache_hit_cnt;
	glb_ops->htable_cache_hit_cnt_clr = ipa_phy_htable_cache_hit_cnt_clr;
	glb_ops->get_htable_hit_cnt = ipa_phy_get_htable_hit_cnt;
	glb_ops->bypass_dstid_chk_sel = ipa_phy_bypass_dstid_chk_sel;
	glb_ops->bypass_srcid_chk_sel = ipa_phy_bypass_srcid_chk_sel;
	glb_ops->node_dstid_chk_en = ipa_phy_node_dstid_chk_en;
	glb_ops->node_srcid_chk_en = ipa_phy_node_srcid_chk_en;
	glb_ops->ofilter_drop_cnt_en = ipa_phy_ofilter_drop_cnt_en;
	glb_ops->ifilter_drop_cnt_en = ipa_phy_ifilter_drop_cnt_en;
	glb_ops->ofilter_drop_clr = ipa_phy_ofilter_drop_clr;
	glb_ops->ifilter_drop_clr = ipa_phy_ifilter_drop_clr;
	glb_ops->set_ofilter_depth_ipv6 = ipa_phy_set_ofilter_depth_ipv6;
	glb_ops->set_ofilter_depth_ipv4 = ipa_phy_set_ofilter_depth_ipv4;
	glb_ops->get_ofilter_locked_status = ipa_phy_get_ofilter_locked_status;
	glb_ops->ofilter_ctrl = ipa_phy_ofilter_ctrl;
	glb_ops->set_ifilter_depth_ipv6 = ipa_phy_set_ifilter_depth_ipv6;
	glb_ops->set_ifilter_depth_ipv4 = ipa_phy_set_ifilter_depth_ipv4;
	glb_ops->get_ifilter_locked_status = ipa_phy_get_ifilter_locked_status;
	glb_ops->ifilter_ctrl = ipa_phy_ifilter_ctrl;
	glb_ops->set_default_hash = ipa_phy_set_default_hash;
	glb_ops->get_htable_hw_valid = ipa_phy_get_htable_hw_valid;
	glb_ops->set_htable_max_entry_len = ipa_phy_set_htable_max_entry_len;
	glb_ops->get_cache_wait_update_cnt = ipa_phy_get_cache_wait_update_cnt;
	glb_ops->set_htable_max_rd_len = ipa_phy_set_htable_max_rd_len;
	glb_ops->map_fifo_sel_mode = ipa_phy_map_fifo_sel_mode;
	glb_ops->set_map_fifo_cnt = ipa_phy_set_map_fifo_cnt;
	glb_ops->htable_limit_tmr_clr = ipa_phy_htable_limit_tmr_clr;
	glb_ops->htable_limit_tmr_scale = ipa_phy_htable_limit_tmr_scale;
	glb_ops->htable_timestamp_tmr_clr = ipa_phy_htable_timestamp_tmr_clr;
	glb_ops->htable_timestamp_tmr_scale =
		ipa_phy_htable_timestamp_tmr_scale;
	glb_ops->htable_base_tmr_en = ipa_phy_htable_base_tmr_en;
	glb_ops->set_htable = ipa_phy_set_htable;
	glb_ops->get_cache_sync_done = ipa_phy_get_cache_sync_done;
	glb_ops->set_cache_sync_req = ipa_phy_set_cache_sync_req;
	glb_ops->set_route_mode_ihl_ctrl_bit =
		ipa_phy_set_route_mode_ihl_ctrl_bit;
	glb_ops->htable_sw_en = ipa_phy_htable_sw_en;
	glb_ops->get_htable_errcode = ipa_phy_get_htable_errcode;
	glb_ops->get_errnode_info_l = ipa_phy_get_errnode_info_l;
	glb_ops->get_errnode_info_m = ipa_phy_get_errnode_info_m;
	glb_ops->get_errnode_info_h = ipa_phy_get_errnode_info_h;
	glb_ops->set_map_hash_mask = ipa_phy_set_map_hash_mask;
	glb_ops->map_multi_fifo_mode_en = ipa_phy_map_multi_fifo_mode_en;
	glb_ops->map_multi_fifo_mode = ipa_phy_map_multi_fifo_mode;
	glb_ops->errcode_int_en = ipa_phy_errcode_int_en;
	glb_ops->dl_pcie_dma_en = ipa_phy_dl_pcie_dma_en;
	glb_ops->set_pcie_msi_int_mode = ipa_phy_set_pcie_msi_int_mode;
	glb_ops->pcie_hw_int_en = ipa_phy_pcie_hw_int_en;
	glb_ops->wiap_ul_dma_en = ipa_phy_wiap_ul_dma_en;
	glb_ops->set_dfs_cycle_cnt_val = ipa_phy_set_dfs_cycle_cnt_val;
	glb_ops->set_dfs_period = ipa_phy_set_dfs_period;
	glb_ops->dfs_en = ipa_phy_dfs_en;
	glb_ops->dfs_th3 = ipa_phy_dfs_th3;
	glb_ops->dfs_th2 = ipa_phy_dfs_th2;
	glb_ops->dfs_th1 = ipa_phy_dfs_th1;
	glb_ops->dfs_th0 = ipa_phy_dfs_th0;
	glb_ops->get_dc_done_status = ipa_phy_get_dc_done_status;
	glb_ops->dc_ip_sel = ipa_phy_dc_ip_sel;
	glb_ops->dc_en = ipa_phy_dc_en;
	glb_ops->dc_init = ipa_phy_dc_init;
	glb_ops->dc_loop_mode = ipa_phy_dc_loop_mode;
	glb_ops->dc_chn_sel = ipa_phy_dc_chn_sel;
	glb_ops->dc_stop_sel = ipa_phy_dc_stop_sel;
	glb_ops->dc_start_sel = ipa_phy_dc_start_sel;
	glb_ops->dc_sw_stop = ipa_phy_dc_sw_stop;
	glb_ops->dc_sw_start = ipa_phy_dc_sw_start;
	glb_ops->dc_sw_len = ipa_phy_dc_sw_len;
	glb_ops->get_dc_vld_clk_cnt = ipa_phy_get_dc_vld_clk_cnt;
	glb_ops->set_dc_data_mask = ipa_phy_set_dc_data_mask;
	glb_ops->set_dc_meet_cond = ipa_phy_set_dc_meet_cond;
	glb_ops->set_dc_init_raddr = ipa_phy_set_dc_init_raddr;
	glb_ops->set_dc_raddr_load = ipa_phy_set_dc_raddr_load;
	glb_ops->get_dc_raddr = ipa_phy_get_dc_raddr;
	glb_ops->set_fifo_monitor_sel0 = ipa_phy_set_fifo_monitor_sel0;
	glb_ops->set_ip_pkt_fifo_monitor_sel =
		ipa_phy_set_ip_pkt_fifo_monitor_sel;
	glb_ops->set_output_chn_fifo_monitor_sel =
		ipa_phy_set_output_chn_fifo_monitor_sel;
	glb_ops->set_input_chn_fifo_monitor_sel =
		ipa_phy_set_input_chn_fifo_monitor_sel;
	glb_ops->get_ip_pkt_fifo_empty_hit =
		ipa_phy_get_ip_pkt_fifo_empty_hit;
	glb_ops->get_ip_pkt_fifo_full_hit = ipa_phy_get_ip_pkt_fifo_full_hit;
	glb_ops->get_data_chn_fifo_empty_hit =
		ipa_phy_get_data_chn_fifo_empty_hit;
	glb_ops->get_data_chn_fifo_full_hit =
		ipa_phy_get_data_chn_fifo_full_hit;
	glb_ops->get_input_chn_fifo_empty_hit =
		ipa_phy_get_input_chn_fifo_empty_hit;
	glb_ops->get_input_chn_fifo_full_hit =
		ipa_phy_get_input_chn_fifo_full_hit;
	glb_ops->get_output_chn_fifo_empty_hit =
		ipa_phy_get_output_chn_fifo_empty_hit;
	glb_ops->get_output_chn_fifo_full_hit =
		ipa_phy_get_output_chn_fifo_full_hit;
	glb_ops->get_clk_gate_aon_0 = ipa_phy_get_clk_gate_aon_0;
	glb_ops->get_clk_gate_aon_1 = ipa_phy_get_clk_gate_aon_1;
	glb_ops->set_map3_free_fifo_pri = ipa_phy_set_map3_free_fifo_pri;
	glb_ops->set_map2_free_fifo_pri = ipa_phy_set_map2_free_fifo_pri;
	glb_ops->set_map1_free_fifo_pri = ipa_phy_set_map1_free_fifo_pri;
	glb_ops->set_map0_free_fifo_pri = ipa_phy_set_map0_free_fifo_pri;
	glb_ops->set_map7_free_fifo_pri = ipa_phy_set_map7_free_fifo_pri;
	glb_ops->set_map6_free_fifo_pri = ipa_phy_set_map6_free_fifo_pri;
	glb_ops->set_map5_free_fifo_pri = ipa_phy_set_map5_free_fifo_pri;
	glb_ops->set_map4_free_fifo_pri = ipa_phy_set_map4_free_fifo_pri;
	glb_ops->out_map_en = ipa_phy_out_map_en;
	glb_ops->out_wiap_en = ipa_phy_out_wiap_en;
	glb_ops->out_pcie_en = ipa_phy_out_pcie_en;
	glb_ops->out_wifi_en = ipa_phy_out_wifi_en;
	glb_ops->out_usb_en = ipa_phy_out_usb_en;
	glb_ops->in_map_en = ipa_phy_in_map_en;
	glb_ops->in_wiap_en = ipa_phy_in_wiap_en;
	glb_ops->in_pcie_en = ipa_phy_in_pcie_en;
	glb_ops->in_wifi_en = ipa_phy_in_wifi_en;
	glb_ops->in_usb_en = ipa_phy_in_usb_en;
	glb_ops->set_pcie_dl_tx_fifo_int_addr_low =
		ipa_phy_set_pcie_dl_tx_fifo_int_addr_low;
	glb_ops->set_pcie_dl_rx_fifo_int_addr_low =
		ipa_phy_set_pcie_dl_rx_fifo_int_addr_low;
	glb_ops->set_pcie_ul_tx_fifo_int_addr_low =
		ipa_phy_set_pcie_ul_tx_fifo_int_addr_low;
	glb_ops->set_pcie_ul_rx_fifo_int_addr_low =
		ipa_phy_set_pcie_ul_rx_fifo_int_addr_low;
	glb_ops->set_pcie_dl_tx_fifo_int_addr_high =
		ipa_phy_set_pcie_dl_tx_fifo_int_addr_high;
	glb_ops->set_pcie_dl_rx_fifo_int_addr_high =
		ipa_phy_set_pcie_dl_rx_fifo_int_addr_high;
	glb_ops->set_pcie_ul_tx_fifo_int_addr_high =
		ipa_phy_set_pcie_ul_tx_fifo_int_addr_high;
	glb_ops->set_pcie_ul_rx_fifo_int_addr_high =
		ipa_phy_set_pcie_ul_rx_fifo_int_addr_high;
	glb_ops->set_pcie_dl_tx_fifo_int_pattern =
		ipa_phy_set_pcie_dl_tx_fifo_int_pattern;
	glb_ops->set_pcie_dl_rx_fifo_int_pattern =
		ipa_phy_set_pcie_dl_rx_fifo_int_pattern;
	glb_ops->set_pcie_ul_tx_fifo_int_pattern =
		ipa_phy_set_pcie_ul_tx_fifo_int_pattern;
	glb_ops->set_pcie_ul_rx_fifo_int_pattern =
		ipa_phy_set_pcie_ul_rx_fifo_int_pattern;
	glb_ops->get_usb_push_node_total_cnt =
		ipa_phy_get_usb_push_node_total_cnt;
	glb_ops->get_usb_push_node_l1_cnt = ipa_phy_get_usb_push_node_l1_cnt;
	glb_ops->get_usb_push_node_l2_cnt = ipa_phy_get_usb_push_node_l2_cnt;
	glb_ops->get_usb_push_node_l3_cnt = ipa_phy_get_usb_push_node_l3_cnt;
	glb_ops->get_usb_push_node_l4_cnt = ipa_phy_get_usb_push_node_l4_cnt;
	glb_ops->get_usb_fetch_node_total_cnt =
		ipa_phy_get_usb_fetch_node_total_cnt;
	glb_ops->get_usb_fetch_node_l1_cnt = ipa_phy_get_usb_fetch_node_l1_cnt;
	glb_ops->get_usb_fetch_node_l2_cnt = ipa_phy_get_usb_fetch_node_l2_cnt;
	glb_ops->get_usb_fetch_node_l3_cnt = ipa_phy_get_usb_fetch_node_l3_cnt;
	glb_ops->get_usb_fetch_node_l4_cnt = ipa_phy_get_usb_fetch_node_l4_cnt;
	glb_ops->get_pcie_push_node_total_cnt =
		ipa_phy_get_pcie_push_node_total_cnt;
	glb_ops->get_pcie_push_node_l1_cnt = ipa_phy_get_pcie_push_node_l1_cnt;
	glb_ops->get_pcie_push_node_l2_cnt = ipa_phy_get_pcie_push_node_l2_cnt;
	glb_ops->get_pcie_push_node_l3_cnt = ipa_phy_get_pcie_push_node_l3_cnt;
	glb_ops->get_pcie_push_node_l4_cnt = ipa_phy_get_pcie_push_node_l4_cnt;
	glb_ops->get_pcie_fetch_node_total_cnt =
		ipa_phy_get_pcie_fetch_node_total_cnt;
	glb_ops->get_pcie_fetch_node_l1_cnt =
		ipa_phy_get_pcie_fetch_node_l1_cnt;
	glb_ops->get_pcie_fetch_node_l2_cnt =
		ipa_phy_get_pcie_fetch_node_l2_cnt;
	glb_ops->get_pcie_fetch_node_l3_cnt =
		ipa_phy_get_pcie_fetch_node_l3_cnt;
	glb_ops->get_pcie_fetch_node_l4_cnt =
		ipa_phy_get_pcie_fetch_node_l4_cnt;
	glb_ops->get_wifi_push_node_total_cnt =
		ipa_phy_get_wifi_push_node_total_cnt;
	glb_ops->get_wifi_push_node_l1_cnt = ipa_phy_get_wifi_push_node_l1_cnt;
	glb_ops->get_wifi_push_node_l2_cnt = ipa_phy_get_wifi_push_node_l2_cnt;
	glb_ops->get_wifi_push_node_l3_cnt = ipa_phy_get_wifi_push_node_l3_cnt;
	glb_ops->get_wifi_push_node_l4_cnt = ipa_phy_get_wifi_push_node_l4_cnt;
	glb_ops->get_wifi_fetch_node_total_cnt =
		ipa_phy_get_wifi_fetch_node_total_cnt;
	glb_ops->get_wifi_fetch_node_l1_cnt =
		ipa_phy_get_wifi_fetch_node_l1_cnt;
	glb_ops->get_wifi_fetch_node_l2_cnt =
		ipa_phy_get_wifi_fetch_node_l2_cnt;
	glb_ops->get_wifi_fetch_node_l3_cnt =
		ipa_phy_get_wifi_fetch_node_l3_cnt;
	glb_ops->get_wifi_fetch_node_l4_cnt =
		ipa_phy_get_wifi_fetch_node_l4_cnt;
	glb_ops->get_map_push_node_total_cnt =
		ipa_phy_get_map_push_node_total_cnt;
	glb_ops->get_map_push_node_l1_cnt = ipa_phy_get_map_push_node_l1_cnt;
	glb_ops->get_map_push_node_l2_cnt = ipa_phy_get_map_push_node_l2_cnt;
	glb_ops->get_map_push_node_l3_cnt = ipa_phy_get_map_push_node_l3_cnt;
	glb_ops->get_map_push_node_l4_cnt = ipa_phy_get_map_push_node_l4_cnt;
	glb_ops->get_map_fetch_node_total_cnt =
		ipa_phy_get_map_fetch_node_total_cnt;
	glb_ops->get_map_fetch_node_l1_cnt = ipa_phy_get_map_fetch_node_l1_cnt;
	glb_ops->get_map_fetch_node_l2_cnt = ipa_phy_get_map_fetch_node_l2_cnt;
	glb_ops->get_map_fetch_node_l3_cnt = ipa_phy_get_map_fetch_node_l3_cnt;
	glb_ops->get_map_fetch_node_l4_cnt = ipa_phy_get_map_fetch_node_l4_cnt;
	glb_ops->get_cp_push_node_total_cnt =
		ipa_phy_get_cp_push_node_total_cnt;
	glb_ops->get_cp_push_node_l1_cnt = ipa_phy_get_cp_push_node_l1_cnt;
	glb_ops->get_cp_push_node_l2_cnt = ipa_phy_get_cp_push_node_l2_cnt;
	glb_ops->get_cp_push_node_l3_cnt = ipa_phy_get_cp_push_node_l3_cnt;
	glb_ops->get_cp_push_node_l4_cnt = ipa_phy_get_cp_push_node_l4_cnt;
	glb_ops->get_cp_fetch_node_total_cnt =
		ipa_phy_get_cp_fetch_node_total_cnt;
	glb_ops->get_cp_fetch_node_l1_cnt = ipa_phy_get_cp_fetch_node_l1_cnt;
	glb_ops->get_cp_fetch_node_l2_cnt = ipa_phy_get_cp_fetch_node_l2_cnt;
	glb_ops->get_cp_fetch_node_l3_cnt = ipa_phy_get_cp_fetch_node_l3_cnt;
	glb_ops->get_cp_fetch_node_l4_cnt = ipa_phy_get_cp_fetch_node_l4_cnt;
	glb_ops->traffic_counter_clr = ipa_phy_traffic_counter_clr;
	glb_ops->traffic_counter_en = ipa_phy_traffic_counter_en;
	glb_ops->set_wifi_ul_map0_int_sel = ipa_phy_set_wifi_ul_map0_int_sel;
	glb_ops->map0_interrupt_src_en = ipa_phy_map0_interrupt_src_en;
	glb_ops->map1_interrupt_src_en = ipa_phy_map1_interrupt_src_en;
	glb_ops->map2_interrupt_src_en = ipa_phy_map2_interrupt_src_en;
	glb_ops->map3_interrupt_src_en = ipa_phy_map3_interrupt_src_en;
	glb_ops->map4_interrupt_src_en = ipa_phy_map4_interrupt_src_en;
	glb_ops->map5_interrupt_src_en = ipa_phy_map5_interrupt_src_en;
	glb_ops->map6_interrupt_src_en = ipa_phy_map6_interrupt_src_en;
	glb_ops->map7_interrupt_src_en = ipa_phy_map7_interrupt_src_en;
	glb_ops->get_map0_int_sts = ipa_phy_get_map0_int_sts;
	glb_ops->get_map1_int_sts = ipa_phy_get_map1_int_sts;
	glb_ops->get_map2_int_sts = ipa_phy_get_map2_int_sts;
	glb_ops->get_map3_int_sts = ipa_phy_get_map3_int_sts;
	glb_ops->get_map4_int_sts = ipa_phy_get_map4_int_sts;
	glb_ops->get_map5_int_sts = ipa_phy_get_map5_int_sts;
	glb_ops->get_map6_int_sts = ipa_phy_get_map6_int_sts;
	glb_ops->get_map7_int_sts = ipa_phy_get_map7_int_sts;
	glb_ops->set_sw_wr_trans_num_mask = ipa_phy_set_sw_wr_trans_num_mask;
	glb_ops->set_sw_rd_trans_num_mask = ipa_phy_set_sw_rd_trans_num_mask;

	glb_ops->get_pause_status = ipa_phy_get_pause_status;
	glb_ops->get_resume_status = ipa_phy_get_resume_status;
	glb_ops->get_fifo_irq_status = ipa_phy_get_fifo_irq_status;
	glb_ops->enable_def_interrupt_src = ipa_phy_enable_def_interrupt_src;
	glb_ops->set_def_flow_ctl_to_src_blk = ipa_phy_set_def_flow_ctl_to_src_blk;
	glb_ops->set_map_flow_ctl_to_wifi = ipa_phy_set_map_flow_ctl_to_wifi;
	glb_ops->ctrl_def_hash_en = ipa_phy_ctrl_def_hash_en;
	glb_ops->ctrl_def_chksum_en = ipa_phy_ctrl_def_chksum_en;

	glb_ops->fill_ifilter_ipv4 = ipa_phy_fill_ifilter_ipv4;
	glb_ops->fill_ifilter_ipv6 = ipa_phy_fill_ifilter_ipv6;
	glb_ops->fill_ofilter_ipv4 = ipa_phy_fill_ofilter_ipv4;
	glb_ops->fill_ofilter_ipv6 = ipa_phy_fill_ofilter_ipv6;
}
