// SPDX-License-Identifier: GPL-2.0-only
/*
 *
 * Unisoc qogirl6 pinctrl driver
 *
 * Copyright (C) 2021 Unisoc, Inc.
 * Author: luting guo<luting.guo@unisoc.com>
 */

#include <linux/module.h>
#include <linux/mod_devicetable.h>
#include <linux/platform_device.h>

#include "pinctrl-sprd.h"

#define	PINCTRL_REG_OFFSET		0x40
#define	PINCTRL_REG_MISC_OFFSET		0x440

enum sprd_qogirl6_pins {
	/* UART_MATRIX_MTX_CFG */
	QOGIRL6_UART_INF6_SYS_SEL = SPRD_PIN_INFO(0, GLOBAL_CTRL_PIN, 28, 4, 1),
	QOGIRL6_UART_INF5_SYS_SEL = SPRD_PIN_INFO(1, GLOBAL_CTRL_PIN, 24, 4, 1),
	QOGIRL6_UART_INF4_SYS_SEL = SPRD_PIN_INFO(2, GLOBAL_CTRL_PIN, 20, 4, 1),
	QOGIRL6_UART_INF3_SYS_SEL = SPRD_PIN_INFO(3, GLOBAL_CTRL_PIN, 16, 4, 1),
	QOGIRL6_UART_INF2_INF3_LOOP = SPRD_PIN_INFO(4, GLOBAL_CTRL_PIN, 15, 1, 1),
	QOGIRL6_UART_INF2_INF4_LOOP = SPRD_PIN_INFO(5, GLOBAL_CTRL_PIN, 14, 1, 1),
	QOGIRL6_UART_INF2_SYS_SEL = SPRD_PIN_INFO(6, GLOBAL_CTRL_PIN, 10, 4, 1),
	QOGIRL6_UART_INF1_INF4_LOOP = SPRD_PIN_INFO(7, GLOBAL_CTRL_PIN, 9, 1, 1),
	QOGIRL6_UART_INF1_INF3_LOOP = SPRD_PIN_INFO(8, GLOBAL_CTRL_PIN, 8, 1, 1),
	QOGIRL6_UART_INF1_SYS_SEL = SPRD_PIN_INFO(9, GLOBAL_CTRL_PIN, 4, 4, 1),
	QOGIRL6_UART_INF0_SYS_SEL = SPRD_PIN_INFO(10, GLOBAL_CTRL_PIN, 0, 4, 1),

	/* UART_MATRIX_MTX_CFG1 */
	QOGIRL6_UART_INF9_SYS_SEL = SPRD_PIN_INFO(11, GLOBAL_CTRL_PIN, 9, 4, 2),
	QOGIRL6_UART_INF8_SYS_SEL = SPRD_PIN_INFO(12, GLOBAL_CTRL_PIN, 5, 4, 2),
	QOGIRL6_UART_INF7_INF8_LOOP = SPRD_PIN_INFO(13, GLOBAL_CTRL_PIN, 4, 1, 2),
	QOGIRL6_UART_INF7_SYS_SEL = SPRD_PIN_INFO(14, GLOBAL_CTRL_PIN, 0, 4, 2),

	/* IIS_MATRIX_MTX_CFG */
	QOGIRL6_IIS_INF5_SYS_SEL = SPRD_PIN_INFO(15, GLOBAL_CTRL_PIN, 29, 2, 3),
	QOGIRL6_IIS_INF4_INF3_LOOP = SPRD_PIN_INFO(16, GLOBAL_CTRL_PIN, 28, 1, 3),
	QOGIRL6_IIS_INF4_SYS_SEL = SPRD_PIN_INFO(17, GLOBAL_CTRL_PIN, 23, 5, 3),
	QOGIRL6_IIS_INF3_SYS_SEL = SPRD_PIN_INFO(18, GLOBAL_CTRL_PIN, 18, 5, 3),
	QOGIRL6_IIS_INF2_SYS_SEL = SPRD_PIN_INFO(19, GLOBAL_CTRL_PIN, 13, 5, 3),
	QOGIRL6_IIS_INF1_INF2_LOOP = SPRD_PIN_INFO(20, GLOBAL_CTRL_PIN, 12, 1, 3),
	QOGIRL6_IIS_INF1_SYS_SEL = SPRD_PIN_INFO(21, GLOBAL_CTRL_PIN, 7, 5, 3),
	QOGIRL6_IIS_INF0_INF2_LOOP = SPRD_PIN_INFO(22, GLOBAL_CTRL_PIN, 6, 1, 3),
	QOGIRL6_IIS_INF0_INF1_LOOP = SPRD_PIN_INFO(23, GLOBAL_CTRL_PIN, 5, 1, 3),
	QOGIRL6_IIS_INF0_SYS_SEL = SPRD_PIN_INFO(24, GLOBAL_CTRL_PIN, 0, 5, 3),

	/* SIM_MATRIX_MTX_CFG */
	QOGIRL6_SIM_INF2_SYS_SEL = SPRD_PIN_INFO(25, GLOBAL_CTRL_PIN, 2, 1, 4),
	QOGIRL6_SIM_INF1_SYS_SEL = SPRD_PIN_INFO(26, GLOBAL_CTRL_PIN, 1, 1, 4),
	QOGIRL6_SIM_INF0_SYS_SEL = SPRD_PIN_INFO(27, GLOBAL_CTRL_PIN, 0, 1, 4),

	/* SPI_MATRIX_MTX_CFG */
	QOGIRL6_SPI_INF2_SYS_SEL = SPRD_PIN_INFO(28, GLOBAL_CTRL_PIN, 2, 1, 5),
	QOGIRL6_SPI_INF1_SYS_SEL = SPRD_PIN_INFO(29, GLOBAL_CTRL_PIN, 1, 1, 5),
	QOGIRL6_SPI_INF0_SYS_SEL = SPRD_PIN_INFO(30, GLOBAL_CTRL_PIN, 0, 1, 5),

	/* IIC_MATRIX_MTX_CFG */
	QOGIRL6_IIC_INF7_SYS_SEL = SPRD_PIN_INFO(31, GLOBAL_CTRL_PIN, 28, 4, 6),
	QOGIRL6_IIC_INF6_SYS_SEL = SPRD_PIN_INFO(32, GLOBAL_CTRL_PIN, 24, 4, 6),
	QOGIRL6_IIC_INF5_SYS_SEL = SPRD_PIN_INFO(33, GLOBAL_CTRL_PIN, 20, 4, 6),
	QOGIRL6_IIC_INF4_SYS_SEL = SPRD_PIN_INFO(34, GLOBAL_CTRL_PIN, 16, 4, 6),
	QOGIRL6_IIC_INF3_SYS_SEL = SPRD_PIN_INFO(35, GLOBAL_CTRL_PIN, 12, 4, 6),
	QOGIRL6_IIC_INF2_SYS_SEL = SPRD_PIN_INFO(36, GLOBAL_CTRL_PIN, 8, 4, 6),
	QOGIRL6_IIC_INF1_SYS_SEL = SPRD_PIN_INFO(37, GLOBAL_CTRL_PIN, 4, 4, 6),
	QOGIRL6_IIC_INF0_SYS_SEL = SPRD_PIN_INFO(38, GLOBAL_CTRL_PIN, 0, 4, 6),

	/* IIC_MATRIX_MTX_CFG1 */
	QOGIRL6_IIC_INF9_SYS_SEL = SPRD_PIN_INFO(39, GLOBAL_CTRL_PIN, 4, 4, 7),
	QOGIRL6_IIC_INF8_SYS_SEL = SPRD_PIN_INFO(40, GLOBAL_CTRL_PIN, 0, 4, 7),

	/* HOT_PLUG_DET_MATRIX_MTX_CFG */
	QOGIRL6_HOTPLUG_INF2_SYS_SEL = SPRD_PIN_INFO(41, GLOBAL_CTRL_PIN, 6, 3, 8),
	QOGIRL6_HOTPLUG_INF1_SYS_SEL = SPRD_PIN_INFO(42, GLOBAL_CTRL_PIN, 3, 3, 8),
	QOGIRL6_HOTPLUG_INF0_SYS_SEL = SPRD_PIN_INFO(43, GLOBAL_CTRL_PIN, 0, 3, 8),

	/* HOT_PLUG_DET_MATRIX_MTX_CFG */
	QOGIRL6_DMIC_INF2_SYS_SEL = SPRD_PIN_INFO(44, GLOBAL_CTRL_PIN, 2, 1, 9),
	QOGIRL6_DMIC_INF1_SYS_SEL = SPRD_PIN_INFO(45, GLOBAL_CTRL_PIN, 1, 1, 9),
	QOGIRL6_DMIC_INF0_SYS_SEL = SPRD_PIN_INFO(46, GLOBAL_CTRL_PIN, 0, 1, 9),

	/* PIN_CTRL_REG0 */
	QOGIRL6_PIN_CTRL_REG0 = SPRD_PIN_INFO(47, GLOBAL_CTRL_PIN, 0, 32, 10),

	/* PIN_CTRL_REG1 */
	QOGIRL6_PIN_CTRL_REG1 = SPRD_PIN_INFO(48, GLOBAL_CTRL_PIN, 28, 4, 11),

	/* PIN_CTRL_REG2 */
	QOGIRL6_UART_USB_PHY_SEL = SPRD_PIN_INFO(49, GLOBAL_CTRL_PIN, 31, 1, 12),
	QOGIRL6_USB_PHY_DM_OE = SPRD_PIN_INFO(50, GLOBAL_CTRL_PIN, 30, 1, 12),
	QOGIRL6_USB_PHY_DP_OE = SPRD_PIN_INFO(51, GLOBAL_CTRL_PIN, 29, 1, 12),

	/* PIN_CTRL_REG3 */
	QOGIRL6_SP_EIC_DPAD3 = SPRD_PIN_INFO(52, GLOBAL_CTRL_PIN, 24, 8, 13),
	QOGIRL6_SP_EIC_DPAD2 = SPRD_PIN_INFO(53, GLOBAL_CTRL_PIN, 16, 8, 13),
	QOGIRL6_SP_EIC_DPAD1 = SPRD_PIN_INFO(54, GLOBAL_CTRL_PIN, 8, 8, 13),
	QOGIRL6_SP_EIC_DPAD0 = SPRD_PIN_INFO(55, GLOBAL_CTRL_PIN, 0, 8, 13),

	/* PIN_CTRL_REG4 */
	QOGIRL6_SP_EIC_DPAD7 = SPRD_PIN_INFO(56, GLOBAL_CTRL_PIN, 24, 8, 14),
	QOGIRL6_SP_EIC_DPAD6 = SPRD_PIN_INFO(57, GLOBAL_CTRL_PIN, 16, 8, 14),
	QOGIRL6_SP_EIC_DPAD5 = SPRD_PIN_INFO(58, GLOBAL_CTRL_PIN, 8, 8, 14),
	QOGIRL6_SP_EIC_DPAD4 = SPRD_PIN_INFO(59, GLOBAL_CTRL_PIN, 0, 8, 14),

	/* PIN_CTRL_REG5 */
	QOGIRL6_WCN_VBC_IIS0_INF_SYS_SEL = SPRD_PIN_INFO(60, GLOBAL_CTRL_PIN, 24, 1, 15),
	QOGIRL6_WCN_EM_LATCH_INF_SYS_SEL = SPRD_PIN_INFO(61, GLOBAL_CTRL_PIN, 23, 1, 15),
	QOGIRL6_WCN_BTWF_UART0_INF_SYS_SEL = SPRD_PIN_INFO(62, GLOBAL_CTRL_PIN, 22, 1, 15),
	QOGIRL6_WCN_WCI2_INF_SYS_SEL = SPRD_PIN_INFO(63, GLOBAL_CTRL_PIN, 21, 1, 15),
	QOGIRL6_VBC_IIS_INF_SYS_SEL = SPRD_PIN_INFO(64, GLOBAL_CTRL_PIN, 20, 1, 15),
	QOGIRL6_CARD_DET_SEL = SPRD_PIN_INFO(65, GLOBAL_CTRL_PIN, 17, 3, 15),
	QOGIRL6_SIM0_DET_SEL = SPRD_PIN_INFO(66, GLOBAL_CTRL_PIN, 16, 1, 15),
	QOGIRL6_AP_SDIO1_BD_EB = SPRD_PIN_INFO(67, GLOBAL_CTRL_PIN, 15, 1, 15),
	QOGIRL6_TF_DET_SW_REG_CFG = SPRD_PIN_INFO(68, GLOBAL_CTRL_PIN, 10, 1, 15),
	QOGIRL6_TF_DET_DET_SOUR_SEL = SPRD_PIN_INFO(69, GLOBAL_CTRL_PIN, 8, 2, 15),
	QOGIRL6_SIM1_DET_SW_REG_CFG = SPRD_PIN_INFO(70, GLOBAL_CTRL_PIN, 6, 1, 15),
	QOGIRL6_SIM1_DET_DET_SOUR_SEL = SPRD_PIN_INFO(71, GLOBAL_CTRL_PIN, 4, 2, 15),
	QOGIRL6_SIM0_DET_SW_REG_CFG = SPRD_PIN_INFO(72, GLOBAL_CTRL_PIN, 2, 1, 15),
	QOGIRL6_SIM0_DET_DET_SOUR_SEL = SPRD_PIN_INFO(73, GLOBAL_CTRL_PIN, 0, 2, 15),

	/* Common pin registers definitions */
	QOGIRL6_EMMC_RST = SPRD_PIN_INFO(74, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_CMD = SPRD_PIN_INFO(75, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D0 = SPRD_PIN_INFO(76, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D3 = SPRD_PIN_INFO(77, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D2 = SPRD_PIN_INFO(78, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D5 = SPRD_PIN_INFO(79, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_CLK = SPRD_PIN_INFO(80, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_DS = SPRD_PIN_INFO(81, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D1 = SPRD_PIN_INFO(82, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D4 = SPRD_PIN_INFO(83, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D6 = SPRD_PIN_INFO(84, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D7 = SPRD_PIN_INFO(85, COMMON_PIN, 0, 0, 0),
	QOGIRL6_DSI_TE = SPRD_PIN_INFO(86, COMMON_PIN, 0, 0, 0),
	QOGIRL6_LCM_RSTN = SPRD_PIN_INFO(87, COMMON_PIN, 0, 0, 0),
	QOGIRL6_DCDC_ARM1_EN = SPRD_PIN_INFO(88, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CHIP_SLEEP = SPRD_PIN_INFO(89, COMMON_PIN, 0, 0, 0),
	QOGIRL6_AUD_SCLK = SPRD_PIN_INFO(90, COMMON_PIN, 0, 0, 0),
	QOGIRL6_AUD_ADD0 = SPRD_PIN_INFO(91, COMMON_PIN, 0, 0, 0),
	QOGIRL6_ANA_INT = SPRD_PIN_INFO(92, COMMON_PIN, 0, 0, 0),
	QOGIRL6_DCDC_ARM0_EN = SPRD_PIN_INFO(93, COMMON_PIN, 0, 0, 0),
	QOGIRL6_AUD_ADSYNC = SPRD_PIN_INFO(94, COMMON_PIN, 0, 0, 0),
	QOGIRL6_AUD_DASYNC = SPRD_PIN_INFO(95, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXT_RST_B = SPRD_PIN_INFO(96, COMMON_PIN, 0, 0, 0),
	QOGIRL6_ADI_SCLK = SPRD_PIN_INFO(97, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CLK_32K = SPRD_PIN_INFO(98, COMMON_PIN, 0, 0, 0),
	QOGIRL6_AUD_DAD1 = SPRD_PIN_INFO(99, COMMON_PIN, 0, 0, 0),
	QOGIRL6_ADI_D = SPRD_PIN_INFO(100, COMMON_PIN, 0, 0, 0),
	QOGIRL6_ADI_SCLK2 = SPRD_PIN_INFO(101, COMMON_PIN, 0, 0, 0),
	QOGIRL6_XTL_EN0 = SPRD_PIN_INFO(102, COMMON_PIN, 0, 0, 0),
	QOGIRL6_AUD_DAD0 = SPRD_PIN_INFO(103, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CHG_TYPE = SPRD_PIN_INFO(104, COMMON_PIN, 0, 0, 0),
	QOGIRL6_ADI_D2 = SPRD_PIN_INFO(105, COMMON_PIN, 0, 0, 0),
	QOGIRL6_XTL_EN2 = SPRD_PIN_INFO(106, COMMON_PIN, 0, 0, 0),
	QOGIRL6_PTEST = SPRD_PIN_INFO(107, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_XTLEN = SPRD_PIN_INFO(108, COMMON_PIN, 0, 0, 0),
	QOGIRL6_XTL_EN1 = SPRD_PIN_INFO(109, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMCLK2 = SPRD_PIN_INFO(110, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMDA2 = SPRD_PIN_INFO(111, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMRST2 = SPRD_PIN_INFO(112, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD0_CMD = SPRD_PIN_INFO(113, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD0_D0 = SPRD_PIN_INFO(114, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD0_D1 = SPRD_PIN_INFO(115, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD0_CLK = SPRD_PIN_INFO(116, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD0_D2 = SPRD_PIN_INFO(117, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD0_D3 = SPRD_PIN_INFO(118, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMCLK0 = SPRD_PIN_INFO(119, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMDA0 = SPRD_PIN_INFO(120, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMRST0 = SPRD_PIN_INFO(121, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMCLK1 = SPRD_PIN_INFO(122, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMDA1 = SPRD_PIN_INFO(123, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SIMRST1 = SPRD_PIN_INFO(124, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD2_CMD = SPRD_PIN_INFO(125, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD2_D0 = SPRD_PIN_INFO(126, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD2_D1 = SPRD_PIN_INFO(127, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD2_CLK = SPRD_PIN_INFO(128, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD2_D2 = SPRD_PIN_INFO(129, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SD2_D3 = SPRD_PIN_INFO(130, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL0 = SPRD_PIN_INFO(131, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL1 = SPRD_PIN_INFO(132, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL2 = SPRD_PIN_INFO(133, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL3 = SPRD_PIN_INFO(134, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL4 = SPRD_PIN_INFO(135, COMMON_PIN, 0, 0, 0),
	QOGIRL6_DNS_D0 = SPRD_PIN_INFO(136, COMMON_PIN, 0, 0, 0),
	QOGIRL6_DNS_D1 = SPRD_PIN_INFO(137, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS3DI = SPRD_PIN_INFO(138, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS3DO = SPRD_PIN_INFO(139, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS3CLK = SPRD_PIN_INFO(140, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS3LRCK = SPRD_PIN_INFO(141, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL5 = SPRD_PIN_INFO(142, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL6 = SPRD_PIN_INFO(143, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL7 = SPRD_PIN_INFO(144, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL8 = SPRD_PIN_INFO(145, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL9 = SPRD_PIN_INFO(146, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL10 = SPRD_PIN_INFO(147, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL11 = SPRD_PIN_INFO(148, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL12 = SPRD_PIN_INFO(149, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL13 = SPRD_PIN_INFO(150, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL14 = SPRD_PIN_INFO(151, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL15 = SPRD_PIN_INFO(152, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL16 = SPRD_PIN_INFO(153, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL17 = SPRD_PIN_INFO(154, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL18 = SPRD_PIN_INFO(155, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFCTL19 = SPRD_PIN_INFO(156, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFSCK0 = SPRD_PIN_INFO(157, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFSDA0 = SPRD_PIN_INFO(158, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFSEN0 = SPRD_PIN_INFO(159, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFSCK1 = SPRD_PIN_INFO(160, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFSDA1 = SPRD_PIN_INFO(161, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFSEN1 = SPRD_PIN_INFO(162, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFFE0_SCK = SPRD_PIN_INFO(163, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFFE0_SDA = SPRD_PIN_INFO(164, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFFE1_SCK = SPRD_PIN_INFO(165, COMMON_PIN, 0, 0, 0),
	QOGIRL6_RFFE1_SDA = SPRD_PIN_INFO(166, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U1TXD = SPRD_PIN_INFO(167, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U1RXD = SPRD_PIN_INFO(168, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MTCK_ARM = SPRD_PIN_INFO(169, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MTMS_ARM = SPRD_PIN_INFO(170, COMMON_PIN, 0, 0, 0),
	QOGIRL6_PWMC = SPRD_PIN_INFO(171, COMMON_PIN, 0, 0, 0),
	QOGIRL6_KEYOUT0 = SPRD_PIN_INFO(172, COMMON_PIN, 0, 0, 0),
	QOGIRL6_KEYOUT1 = SPRD_PIN_INFO(173, COMMON_PIN, 0, 0, 0),
	QOGIRL6_KEYOUT2 = SPRD_PIN_INFO(174, COMMON_PIN, 0, 0, 0),
	QOGIRL6_KEYIN0 = SPRD_PIN_INFO(175, COMMON_PIN, 0, 0, 0),
	QOGIRL6_KEYIN1 = SPRD_PIN_INFO(176, COMMON_PIN, 0, 0, 0),
	QOGIRL6_KEYIN2 = SPRD_PIN_INFO(177, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_CLK0 = SPRD_PIN_INFO(178, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_DATA0 = SPRD_PIN_INFO(179, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_CLK1 = SPRD_PIN_INFO(180, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_DATA1 = SPRD_PIN_INFO(181, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_CLK2 = SPRD_PIN_INFO(182, COMMON_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_DATA2 = SPRD_PIN_INFO(183, COMMON_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL0 = SPRD_PIN_INFO(184, COMMON_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL1 = SPRD_PIN_INFO(185, COMMON_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL2 = SPRD_PIN_INFO(186, COMMON_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL3 = SPRD_PIN_INFO(187, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_A_RST = SPRD_PIN_INFO(188, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_A_EN = SPRD_PIN_INFO(189, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXTINT0 = SPRD_PIN_INFO(190, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXTINT1 = SPRD_PIN_INFO(191, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SDA3 = SPRD_PIN_INFO(192, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SCL3 = SPRD_PIN_INFO(193, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SCL7 = SPRD_PIN_INFO(194, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SDA7 = SPRD_PIN_INFO(195, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CLK_AUX2 = SPRD_PIN_INFO(196, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXTINT13 = SPRD_PIN_INFO(197, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXTINT14 = SPRD_PIN_INFO(198, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI0_CSN = SPRD_PIN_INFO(199, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI0_DO = SPRD_PIN_INFO(200, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI0_DI = SPRD_PIN_INFO(201, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI0_CLK = SPRD_PIN_INFO(202, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXTINT9 = SPRD_PIN_INFO(203, COMMON_PIN, 0, 0, 0),
	QOGIRL6_EXTINT10 = SPRD_PIN_INFO(204, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS1DI = SPRD_PIN_INFO(205, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS1DO = SPRD_PIN_INFO(206, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS1CLK = SPRD_PIN_INFO(207, COMMON_PIN, 0, 0, 0),
	QOGIRL6_IIS1LRCK = SPRD_PIN_INFO(208, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SCL2 = SPRD_PIN_INFO(209, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SDA2 = SPRD_PIN_INFO(210, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U2TXD = SPRD_PIN_INFO(211, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U2RXD = SPRD_PIN_INFO(212, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI_TE = SPRD_PIN_INFO(213, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI2_CS1N = SPRD_PIN_INFO(214, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI2_CS0N = SPRD_PIN_INFO(215, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI2_DO = SPRD_PIN_INFO(216, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI2_DI = SPRD_PIN_INFO(217, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SPI2_CLK = SPRD_PIN_INFO(218, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_RFCTL2 = SPRD_PIN_INFO(219, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_RFCTL1 = SPRD_PIN_INFO(220, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_RFCTL0 = SPRD_PIN_INFO(221, COMMON_PIN, 0, 0, 0),
	QOGIRL6_GNSS_LNA_EN = SPRD_PIN_INFO(222, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U5TXD = SPRD_PIN_INFO(223, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U5RXD = SPRD_PIN_INFO(224, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CLK_AUX0 = SPRD_PIN_INFO(225, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U0TXD = SPRD_PIN_INFO(226, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U0RXD = SPRD_PIN_INFO(227, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U0CTS = SPRD_PIN_INFO(228, COMMON_PIN, 0, 0, 0),
	QOGIRL6_U0RTS = SPRD_PIN_INFO(229, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SCL8 = SPRD_PIN_INFO(230, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SDA8 = SPRD_PIN_INFO(231, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SCL0 = SPRD_PIN_INFO(232, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SDA0 = SPRD_PIN_INFO(233, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SDA1 = SPRD_PIN_INFO(234, COMMON_PIN, 0, 0, 0),
	QOGIRL6_SCL1 = SPRD_PIN_INFO(235, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMMCLK0 = SPRD_PIN_INFO(236, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMMCLK1 = SPRD_PIN_INFO(237, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMRST0 = SPRD_PIN_INFO(238, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMRST1 = SPRD_PIN_INFO(239, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMPD0 = SPRD_PIN_INFO(240, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMPD1 = SPRD_PIN_INFO(241, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMMCLK2 = SPRD_PIN_INFO(242, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMPD2 = SPRD_PIN_INFO(243, COMMON_PIN, 0, 0, 0),
	QOGIRL6_CMRST2 = SPRD_PIN_INFO(244, COMMON_PIN, 0, 0, 0),
	QOGIRL6_TSX_OSC_SEL = SPRD_PIN_INFO(245, COMMON_PIN, 0, 0, 0),
	QOGIRL6_T_DIG = SPRD_PIN_INFO(246, COMMON_PIN, 0, 0, 0),
	QOGIRL6_FM_CLK = SPRD_PIN_INFO(247, COMMON_PIN, 0, 0, 0),
	QOGIRL6_FM_DATA = SPRD_PIN_INFO(248, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WF_D0 = SPRD_PIN_INFO(249, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WF_D1 = SPRD_PIN_INFO(250, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WF_D2 = SPRD_PIN_INFO(251, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WF_CLK = SPRD_PIN_INFO(252, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_CLK = SPRD_PIN_INFO(253, COMMON_PIN, 0, 0, 0),
	QOGIRL6_WCN_DATA = SPRD_PIN_INFO(254, COMMON_PIN, 0, 0, 0),

	/* MSIC pin registers definitions */
	QOGIRL6_EMMC_RST_MISC = SPRD_PIN_INFO(255, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_CMD_MISC = SPRD_PIN_INFO(256, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D0_MISC = SPRD_PIN_INFO(257, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D3_MISC = SPRD_PIN_INFO(258, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D2_MISC = SPRD_PIN_INFO(259, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D5_MISC = SPRD_PIN_INFO(260, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_CLK_MISC = SPRD_PIN_INFO(261, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_DS_MISC = SPRD_PIN_INFO(262, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D1_MISC = SPRD_PIN_INFO(263, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D4_MISC = SPRD_PIN_INFO(264, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D6_MISC = SPRD_PIN_INFO(265, MISC_PIN, 0, 0, 0),
	QOGIRL6_EMMC_D7_MISC = SPRD_PIN_INFO(266, MISC_PIN, 0, 0, 0),
	QOGIRL6_DSI_TE_MISC = SPRD_PIN_INFO(267, MISC_PIN, 0, 0, 0),
	QOGIRL6_LCM_RSTN_MISC = SPRD_PIN_INFO(268, MISC_PIN, 0, 0, 0),
	QOGIRL6_DCDC_ARM1_EN_MISC = SPRD_PIN_INFO(269, MISC_PIN, 0, 0, 0),
	QOGIRL6_CHIP_SLEEP_MISC = SPRD_PIN_INFO(270, MISC_PIN, 0, 0, 0),
	QOGIRL6_AUD_SCLK_MISC = SPRD_PIN_INFO(271, MISC_PIN, 0, 0, 0),
	QOGIRL6_AUD_ADD0_MISC = SPRD_PIN_INFO(272, MISC_PIN, 0, 0, 0),
	QOGIRL6_ANA_INT_MISC = SPRD_PIN_INFO(273, MISC_PIN, 0, 0, 0),
	QOGIRL6_DCDC_ARM0_EN_MISC = SPRD_PIN_INFO(274, MISC_PIN, 0, 0, 0),
	QOGIRL6_AUD_ADSYNC_MISC = SPRD_PIN_INFO(275, MISC_PIN, 0, 0, 0),
	QOGIRL6_AUD_DASYNC_MISC = SPRD_PIN_INFO(276, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXT_RST_B_MISC = SPRD_PIN_INFO(277, MISC_PIN, 0, 0, 0),
	QOGIRL6_ADI_SCLK_MISC = SPRD_PIN_INFO(278, MISC_PIN, 0, 0, 0),
	QOGIRL6_CLK_32K_MISC = SPRD_PIN_INFO(279, MISC_PIN, 0, 0, 0),
	QOGIRL6_AUD_DAD1_MISC = SPRD_PIN_INFO(280, MISC_PIN, 0, 0, 0),
	QOGIRL6_ADI_D_MISC = SPRD_PIN_INFO(281, MISC_PIN, 0, 0, 0),
	QOGIRL6_ADI_SCLK2_MISC = SPRD_PIN_INFO(282, MISC_PIN, 0, 0, 0),
	QOGIRL6_XTL_EN0_MISC = SPRD_PIN_INFO(283, MISC_PIN, 0, 0, 0),
	QOGIRL6_AUD_DAD0_MISC = SPRD_PIN_INFO(284, MISC_PIN, 0, 0, 0),
	QOGIRL6_CHG_TYPE_MISC = SPRD_PIN_INFO(285, MISC_PIN, 0, 0, 0),
	QOGIRL6_ADI_D2_MISC = SPRD_PIN_INFO(286, MISC_PIN, 0, 0, 0),
	QOGIRL6_XTL_EN2_MISC = SPRD_PIN_INFO(287, MISC_PIN, 0, 0, 0),
	QOGIRL6_PTEST_MISC = SPRD_PIN_INFO(288, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_XTLEN_MISC = SPRD_PIN_INFO(289, MISC_PIN, 0, 0, 0),
	QOGIRL6_XTL_EN1_MISC = SPRD_PIN_INFO(290, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMCLK2_MISC = SPRD_PIN_INFO(291, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMDA2_MISC = SPRD_PIN_INFO(292, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMRST2_MISC = SPRD_PIN_INFO(293, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD0_CMD_MISC = SPRD_PIN_INFO(294, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD0_D0_MISC = SPRD_PIN_INFO(295, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD0_D1_MISC = SPRD_PIN_INFO(296, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD0_CLK_MISC = SPRD_PIN_INFO(297, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD0_D2_MISC = SPRD_PIN_INFO(298, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD0_D3_MISC = SPRD_PIN_INFO(299, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMCLK0_MISC = SPRD_PIN_INFO(300, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMDA0_MISC = SPRD_PIN_INFO(301, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMRST0_MISC = SPRD_PIN_INFO(302, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMCLK1_MISC = SPRD_PIN_INFO(303, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMDA1_MISC = SPRD_PIN_INFO(304, MISC_PIN, 0, 0, 0),
	QOGIRL6_SIMRST1_MISC = SPRD_PIN_INFO(305, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD2_CMD_MISC = SPRD_PIN_INFO(306, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD2_D0_MISC = SPRD_PIN_INFO(307, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD2_D1_MISC = SPRD_PIN_INFO(308, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD2_CLK_MISC = SPRD_PIN_INFO(309, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD2_D2_MISC = SPRD_PIN_INFO(310, MISC_PIN, 0, 0, 0),
	QOGIRL6_SD2_D3_MISC = SPRD_PIN_INFO(311, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL0_MISC = SPRD_PIN_INFO(312, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL1_MISC = SPRD_PIN_INFO(313, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL2_MISC = SPRD_PIN_INFO(314, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL3_MISC = SPRD_PIN_INFO(315, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL4_MISC = SPRD_PIN_INFO(316, MISC_PIN, 0, 0, 0),
	QOGIRL6_DNS_D0_MISC = SPRD_PIN_INFO(317, MISC_PIN, 0, 0, 0),
	QOGIRL6_DNS_D1_MISC = SPRD_PIN_INFO(318, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS3DI_MISC = SPRD_PIN_INFO(319, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS3DO_MISC = SPRD_PIN_INFO(320, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS3CLK_MISC = SPRD_PIN_INFO(321, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS3LRCK_MISC = SPRD_PIN_INFO(322, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL5_MISC = SPRD_PIN_INFO(323, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL6_MISC = SPRD_PIN_INFO(324, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL7_MISC = SPRD_PIN_INFO(325, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL8_MISC = SPRD_PIN_INFO(326, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL9_MISC = SPRD_PIN_INFO(327, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL10_MISC = SPRD_PIN_INFO(328, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL11_MISC = SPRD_PIN_INFO(329, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL12_MISC = SPRD_PIN_INFO(330, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL13_MISC = SPRD_PIN_INFO(331, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL14_MISC = SPRD_PIN_INFO(332, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL15_MISC = SPRD_PIN_INFO(333, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL16_MISC = SPRD_PIN_INFO(334, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL17_MISC = SPRD_PIN_INFO(335, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL18_MISC = SPRD_PIN_INFO(336, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFCTL19_MISC = SPRD_PIN_INFO(337, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFSCK0_MISC = SPRD_PIN_INFO(338, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFSDA0_MISC = SPRD_PIN_INFO(339, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFSEN0_MISC = SPRD_PIN_INFO(340, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFSCK1_MISC = SPRD_PIN_INFO(341, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFSDA1_MISC = SPRD_PIN_INFO(342, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFSEN1_MISC = SPRD_PIN_INFO(343, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFFE0_SCK_MISC = SPRD_PIN_INFO(344, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFFE0_SDA_MISC = SPRD_PIN_INFO(345, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFFE1_SCK_MISC = SPRD_PIN_INFO(346, MISC_PIN, 0, 0, 0),
	QOGIRL6_RFFE1_SDA_MISC = SPRD_PIN_INFO(347, MISC_PIN, 0, 0, 0),
	QOGIRL6_U1TXD_MISC = SPRD_PIN_INFO(348, MISC_PIN, 0, 0, 0),
	QOGIRL6_U1RXD_MISC = SPRD_PIN_INFO(349, MISC_PIN, 0, 0, 0),
	QOGIRL6_MTCK_ARM_MISC = SPRD_PIN_INFO(350, MISC_PIN, 0, 0, 0),
	QOGIRL6_MTMS_ARM_MISC = SPRD_PIN_INFO(351, MISC_PIN, 0, 0, 0),
	QOGIRL6_PWMC_MISC = SPRD_PIN_INFO(352, MISC_PIN, 0, 0, 0),
	QOGIRL6_KEYOUT0_MISC = SPRD_PIN_INFO(353, MISC_PIN, 0, 0, 0),
	QOGIRL6_KEYOUT1_MISC = SPRD_PIN_INFO(354, MISC_PIN, 0, 0, 0),
	QOGIRL6_KEYOUT2_MISC = SPRD_PIN_INFO(355, MISC_PIN, 0, 0, 0),
	QOGIRL6_KEYIN0_MISC = SPRD_PIN_INFO(356, MISC_PIN, 0, 0, 0),
	QOGIRL6_KEYIN1_MISC = SPRD_PIN_INFO(357, MISC_PIN, 0, 0, 0),
	QOGIRL6_KEYIN2_MISC = SPRD_PIN_INFO(358, MISC_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_CLK0_MISC = SPRD_PIN_INFO(359, MISC_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_DATA0_MISC = SPRD_PIN_INFO(360, MISC_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_CLK1_MISC = SPRD_PIN_INFO(361, MISC_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_DATA1_MISC = SPRD_PIN_INFO(362, MISC_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_CLK2_MISC = SPRD_PIN_INFO(363, MISC_PIN, 0, 0, 0),
	QOGIRL6_MEMS_MIC_DATA2_MISC = SPRD_PIN_INFO(364, MISC_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL0_MISC = SPRD_PIN_INFO(365, MISC_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL1_MISC = SPRD_PIN_INFO(366, MISC_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL2_MISC = SPRD_PIN_INFO(367, MISC_PIN, 0, 0, 0),
	QOGIRL6_BT_RFCTL3_MISC = SPRD_PIN_INFO(368, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_A_RST_MISC = SPRD_PIN_INFO(369, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_A_EN_MISC = SPRD_PIN_INFO(370, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXTINT0_MISC = SPRD_PIN_INFO(371, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXTINT1_MISC = SPRD_PIN_INFO(372, MISC_PIN, 0, 0, 0),
	QOGIRL6_SDA3_MISC = SPRD_PIN_INFO(373, MISC_PIN, 0, 0, 0),
	QOGIRL6_SCL3_MISC = SPRD_PIN_INFO(374, MISC_PIN, 0, 0, 0),
	QOGIRL6_SCL7_MISC = SPRD_PIN_INFO(375, MISC_PIN, 0, 0, 0),
	QOGIRL6_SDA7_MISC = SPRD_PIN_INFO(376, MISC_PIN, 0, 0, 0),
	QOGIRL6_CLK_AUX2_MISC = SPRD_PIN_INFO(377, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXTINT13_MISC = SPRD_PIN_INFO(378, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXTINT14_MISC = SPRD_PIN_INFO(379, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI0_CSN_MISC = SPRD_PIN_INFO(380, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI0_DO_MISC = SPRD_PIN_INFO(381, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI0_DI_MISC = SPRD_PIN_INFO(382, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI0_CLK_MISC = SPRD_PIN_INFO(383, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXTINT9_MISC = SPRD_PIN_INFO(384, MISC_PIN, 0, 0, 0),
	QOGIRL6_EXTINT10_MISC = SPRD_PIN_INFO(385, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS1DI_MISC = SPRD_PIN_INFO(386, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS1DO_MISC = SPRD_PIN_INFO(387, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS1CLK_MISC = SPRD_PIN_INFO(388, MISC_PIN, 0, 0, 0),
	QOGIRL6_IIS1LRCK_MISC = SPRD_PIN_INFO(389, MISC_PIN, 0, 0, 0),
	QOGIRL6_SCL2_MISC = SPRD_PIN_INFO(390, MISC_PIN, 0, 0, 0),
	QOGIRL6_SDA2_MISC = SPRD_PIN_INFO(391, MISC_PIN, 0, 0, 0),
	QOGIRL6_U2TXD_MISC = SPRD_PIN_INFO(392, MISC_PIN, 0, 0, 0),
	QOGIRL6_U2RXD_MISC = SPRD_PIN_INFO(393, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI_TE_MISC = SPRD_PIN_INFO(394, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI2_CS1N_MISC = SPRD_PIN_INFO(395, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI2_CS0N_MISC = SPRD_PIN_INFO(396, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI2_DO_MISC = SPRD_PIN_INFO(397, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI2_DI_MISC = SPRD_PIN_INFO(398, MISC_PIN, 0, 0, 0),
	QOGIRL6_SPI2_CLK_MISC = SPRD_PIN_INFO(399, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_RFCTL2_MISC = SPRD_PIN_INFO(400, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_RFCTL1_MISC = SPRD_PIN_INFO(401, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_RFCTL0_MISC = SPRD_PIN_INFO(402, MISC_PIN, 0, 0, 0),
	QOGIRL6_GNSS_LNA_EN_MISC = SPRD_PIN_INFO(403, MISC_PIN, 0, 0, 0),
	QOGIRL6_U5TXD_MISC = SPRD_PIN_INFO(404, MISC_PIN, 0, 0, 0),
	QOGIRL6_U5RXD_MISC = SPRD_PIN_INFO(405, MISC_PIN, 0, 0, 0),
	QOGIRL6_CLK_AUX0_MISC = SPRD_PIN_INFO(406, MISC_PIN, 0, 0, 0),
	QOGIRL6_U0TXD_MISC = SPRD_PIN_INFO(407, MISC_PIN, 0, 0, 0),
	QOGIRL6_U0RXD_MISC = SPRD_PIN_INFO(408, MISC_PIN, 0, 0, 0),
	QOGIRL6_U0CTS_MISC = SPRD_PIN_INFO(409, MISC_PIN, 0, 0, 0),
	QOGIRL6_U0RTS_MISC = SPRD_PIN_INFO(410, MISC_PIN, 0, 0, 0),
	QOGIRL6_SCL8_MISC = SPRD_PIN_INFO(411, MISC_PIN, 0, 0, 0),
	QOGIRL6_SDA8_MISC = SPRD_PIN_INFO(412, MISC_PIN, 0, 0, 0),
	QOGIRL6_SCL0_MISC = SPRD_PIN_INFO(413, MISC_PIN, 0, 0, 0),
	QOGIRL6_SDA0_MISC = SPRD_PIN_INFO(414, MISC_PIN, 0, 0, 0),
	QOGIRL6_SDA1_MISC = SPRD_PIN_INFO(415, MISC_PIN, 0, 0, 0),
	QOGIRL6_SCL1_MISC = SPRD_PIN_INFO(416, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMMCLK0_MISC = SPRD_PIN_INFO(417, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMMCLK1_MISC = SPRD_PIN_INFO(418, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMRST0_MISC = SPRD_PIN_INFO(419, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMRST1_MISC = SPRD_PIN_INFO(420, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMPD0_MISC = SPRD_PIN_INFO(421, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMPD1_MISC = SPRD_PIN_INFO(422, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMMCLK2_MISC = SPRD_PIN_INFO(423, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMPD2_MISC = SPRD_PIN_INFO(424, MISC_PIN, 0, 0, 0),
	QOGIRL6_CMRST2_MISC = SPRD_PIN_INFO(425, MISC_PIN, 0, 0, 0),
	QOGIRL6_TSX_OSC_SEL_MISC = SPRD_PIN_INFO(426, MISC_PIN, 0, 0, 0),
	QOGIRL6_T_DIG_MISC = SPRD_PIN_INFO(427, MISC_PIN, 0, 0, 0),
	QOGIRL6_FM_CLK_MISC = SPRD_PIN_INFO(428, MISC_PIN, 0, 0, 0),
	QOGIRL6_FM_DATA_MISC = SPRD_PIN_INFO(429, MISC_PIN, 0, 0, 0),
	QOGIRL6_WF_D0_MISC = SPRD_PIN_INFO(430, MISC_PIN, 0, 0, 0),
	QOGIRL6_WF_D1_MISC = SPRD_PIN_INFO(431, MISC_PIN, 0, 0, 0),
	QOGIRL6_WF_D2_MISC = SPRD_PIN_INFO(432, MISC_PIN, 0, 0, 0),
	QOGIRL6_WF_CLK_MISC = SPRD_PIN_INFO(433, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_CLK_MISC = SPRD_PIN_INFO(434, MISC_PIN, 0, 0, 0),
	QOGIRL6_WCN_DATA_MISC = SPRD_PIN_INFO(435, MISC_PIN, 0, 0, 0),
};

static struct sprd_pins_info sprd_qogirl6_pins_info[] = {
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF5_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF2_INF3_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF2_INF4_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF1_INF4_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF1_INF3_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF9_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF8_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF7_INF8_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_UART_INF7_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF5_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF4_INF3_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF1_INF2_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF0_INF2_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF0_INF1_LOOP),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_SIM_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_SPI_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF7_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF5_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF9_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_IIC_INF8_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_HOTPLUG_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_HOTPLUG_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_HOTPLUG_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_DMIC_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_DMIC_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_DMIC_INF0_SYS_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_PIN_CTRL_REG0),

	SPRD_PINCTRL_PIN(QOGIRL6_PIN_CTRL_REG1),

	SPRD_PINCTRL_PIN(QOGIRL6_UART_USB_PHY_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_USB_PHY_DM_OE),
	SPRD_PINCTRL_PIN(QOGIRL6_USB_PHY_DP_OE),

	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD3),
	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD2),
	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD1),
	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD0),

	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD7),
	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD6),
	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD5),
	SPRD_PINCTRL_PIN(QOGIRL6_SP_EIC_DPAD4),

	SPRD_PINCTRL_PIN(QOGIRL6_WCN_VBC_IIS0_INF_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_EM_LATCH_INF_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_BTWF_UART0_INF_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_WCI2_INF_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_VBC_IIS_INF_SYS_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_CARD_DET_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM0_DET_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_AP_SDIO1_BD_EB),
	SPRD_PINCTRL_PIN(QOGIRL6_TF_DET_SW_REG_CFG),
	SPRD_PINCTRL_PIN(QOGIRL6_TF_DET_DET_SOUR_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM1_DET_SW_REG_CFG),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM1_DET_DET_SOUR_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM0_DET_SW_REG_CFG),
	SPRD_PINCTRL_PIN(QOGIRL6_SIM0_DET_DET_SOUR_SEL),

	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_RST),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_CMD),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D0),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D3),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D2),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D5),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_DS),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D1),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D4),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D6),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D7),
	SPRD_PINCTRL_PIN(QOGIRL6_DSI_TE),
	SPRD_PINCTRL_PIN(QOGIRL6_LCM_RSTN),
	SPRD_PINCTRL_PIN(QOGIRL6_DCDC_ARM1_EN),
	SPRD_PINCTRL_PIN(QOGIRL6_CHIP_SLEEP),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_SCLK),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_ADD0),
	SPRD_PINCTRL_PIN(QOGIRL6_ANA_INT),
	SPRD_PINCTRL_PIN(QOGIRL6_DCDC_ARM0_EN),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_ADSYNC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_DASYNC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXT_RST_B),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_SCLK),
	SPRD_PINCTRL_PIN(QOGIRL6_CLK_32K),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_DAD1),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_D),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_SCLK2),
	SPRD_PINCTRL_PIN(QOGIRL6_XTL_EN0),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_DAD0),
	SPRD_PINCTRL_PIN(QOGIRL6_CHG_TYPE),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_D2),
	SPRD_PINCTRL_PIN(QOGIRL6_XTL_EN2),
	SPRD_PINCTRL_PIN(QOGIRL6_PTEST),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_XTLEN),
	SPRD_PINCTRL_PIN(QOGIRL6_XTL_EN1),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMCLK2),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMDA2),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMRST2),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_CMD),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D0),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D1),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D2),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D3),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMCLK0),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMDA0),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMRST0),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMCLK1),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMDA1),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMRST1),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_CMD),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D0),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D1),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D2),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D3),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL0),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL1),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL2),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL3),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL4),
	SPRD_PINCTRL_PIN(QOGIRL6_DNS_D0),
	SPRD_PINCTRL_PIN(QOGIRL6_DNS_D1),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3DI),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3DO),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3LRCK),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL5),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL6),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL7),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL8),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL9),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL10),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL11),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL12),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL13),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL14),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL15),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL16),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL17),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL18),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL19),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSCK0),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSDA0),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSEN0),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSCK1),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSDA1),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSEN1),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE0_SCK),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE0_SDA),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE1_SCK),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE1_SDA),
	SPRD_PINCTRL_PIN(QOGIRL6_U1TXD),
	SPRD_PINCTRL_PIN(QOGIRL6_U1RXD),
	SPRD_PINCTRL_PIN(QOGIRL6_MTCK_ARM),
	SPRD_PINCTRL_PIN(QOGIRL6_MTMS_ARM),
	SPRD_PINCTRL_PIN(QOGIRL6_PWMC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYOUT0),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYOUT1),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYOUT2),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYIN0),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYIN1),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYIN2),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_CLK0),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_DATA0),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_CLK1),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_DATA1),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_CLK2),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_DATA2),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL0),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL1),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL2),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL3),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_A_RST),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_A_EN),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT0),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT1),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA3),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL3),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL7),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA7),
	SPRD_PINCTRL_PIN(QOGIRL6_CLK_AUX2),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT13),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT14),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_CSN),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_DO),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_DI),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT9),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT10),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1DI),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1DO),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1LRCK),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL2),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA2),
	SPRD_PINCTRL_PIN(QOGIRL6_U2TXD),
	SPRD_PINCTRL_PIN(QOGIRL6_U2RXD),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI_TE),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_CS1N),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_CS0N),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_DO),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_DI),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_RFCTL2),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_RFCTL1),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_RFCTL0),
	SPRD_PINCTRL_PIN(QOGIRL6_GNSS_LNA_EN),
	SPRD_PINCTRL_PIN(QOGIRL6_U5TXD),
	SPRD_PINCTRL_PIN(QOGIRL6_U5RXD),
	SPRD_PINCTRL_PIN(QOGIRL6_CLK_AUX0),
	SPRD_PINCTRL_PIN(QOGIRL6_U0TXD),
	SPRD_PINCTRL_PIN(QOGIRL6_U0RXD),
	SPRD_PINCTRL_PIN(QOGIRL6_U0CTS),
	SPRD_PINCTRL_PIN(QOGIRL6_U0RTS),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL8),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA8),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL0),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA0),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA1),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL1),
	SPRD_PINCTRL_PIN(QOGIRL6_CMMCLK0),
	SPRD_PINCTRL_PIN(QOGIRL6_CMMCLK1),
	SPRD_PINCTRL_PIN(QOGIRL6_CMRST0),
	SPRD_PINCTRL_PIN(QOGIRL6_CMRST1),
	SPRD_PINCTRL_PIN(QOGIRL6_CMPD0),
	SPRD_PINCTRL_PIN(QOGIRL6_CMPD1),
	SPRD_PINCTRL_PIN(QOGIRL6_CMMCLK2),
	SPRD_PINCTRL_PIN(QOGIRL6_CMPD2),
	SPRD_PINCTRL_PIN(QOGIRL6_CMRST2),
	SPRD_PINCTRL_PIN(QOGIRL6_TSX_OSC_SEL),
	SPRD_PINCTRL_PIN(QOGIRL6_T_DIG),
	SPRD_PINCTRL_PIN(QOGIRL6_FM_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_FM_DATA),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_D0),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_D1),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_D2),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_CLK),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_DATA),

	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_RST_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D5_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_DS_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D4_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D6_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EMMC_D7_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_DSI_TE_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_LCM_RSTN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_DCDC_ARM1_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CHIP_SLEEP_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_SCLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_ADD0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_ANA_INT_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_DCDC_ARM0_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_ADSYNC_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_DASYNC_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXT_RST_B_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_SCLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CLK_32K_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_DAD1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_D_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_SCLK2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_XTL_EN0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_AUD_DAD0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CHG_TYPE_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_ADI_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_XTL_EN2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_PTEST_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_XTLEN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_XTL_EN1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMCLK2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMDA2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMRST2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD0_D3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMCLK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMDA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMRST0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMCLK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMDA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SIMRST1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_CMD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SD2_D3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL4_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_DNS_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_DNS_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS3LRCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL5_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL6_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL7_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL8_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL9_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL10_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL11_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL12_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL13_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL14_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL15_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL16_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL17_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL18_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFCTL19_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSCK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSDA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSEN0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSCK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSDA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFSEN1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE0_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE0_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE1_SCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_RFFE1_SDA_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U1TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U1RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MTCK_ARM_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MTMS_ARM_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_PWMC_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYOUT0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYOUT1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYOUT2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYIN0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYIN1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_KEYIN2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_CLK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_DATA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_CLK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_DATA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_CLK2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_MEMS_MIC_DATA2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_BT_RFCTL3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_A_RST_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_A_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL3_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL7_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA7_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CLK_AUX2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT13_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT14_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_CSN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI0_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT9_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_EXTINT10_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_IIS1LRCK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U2TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U2RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI_TE_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_CS1N_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_CS0N_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_DO_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_DI_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SPI2_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_RFCTL2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_RFCTL1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_RFCTL0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_GNSS_LNA_EN_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U5TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U5RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CLK_AUX0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U0TXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U0RXD_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U0CTS_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_U0RTS_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL8_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA8_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SDA1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_SCL1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMMCLK0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMMCLK1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMRST0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMRST1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMPD0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMPD1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMMCLK2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMPD2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_CMRST2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_TSX_OSC_SEL_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_T_DIG_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_FM_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_FM_DATA_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_D0_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_D1_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_D2_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WF_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_CLK_MISC),
	SPRD_PINCTRL_PIN(QOGIRL6_WCN_DATA_MISC),
};

static int sprd_pinctrl_probe(struct platform_device *pdev)
{
	return sprd_pinctrl_core_probe(pdev, sprd_qogirl6_pins_info,
				       ARRAY_SIZE(sprd_qogirl6_pins_info),
				       PINCTRL_REG_OFFSET,
				       PINCTRL_REG_MISC_OFFSET);
}

static const struct of_device_id sprd_pinctrl_of_match[] = {
	{
		.compatible = "sprd,qogirl6-pinctrl",
	},
	{ },
};
MODULE_DEVICE_TABLE(of, sprd_pinctrl_of_match);

static struct platform_driver sprd_pinctrl_driver = {
	.driver = {
		.name = "sprd-pinctrl",
		.of_match_table = sprd_pinctrl_of_match,
	},
	.probe = sprd_pinctrl_probe,
	.remove = sprd_pinctrl_remove,
	.shutdown = sprd_pinctrl_shutdown,
};

module_platform_driver(sprd_pinctrl_driver);

MODULE_DESCRIPTION("SPREADTRUM Pin Controller Driver");
MODULE_AUTHOR("luting guo <luting.guo@unisoc.com>");
MODULE_LICENSE("GPL v2");
