// SPDX-License-Identifier: GPL-2.0-only
/*
 *
 * Unisoc pike2 pinctrl driver
 *
 * Copyright (C) 2021 Unisoc, Inc.
 * Author: luting guo <luting.guo@unisoc.com>
 */

#include <linux/module.h>
#include <linux/mod_devicetable.h>
#include <linux/platform_device.h>

#include "pinctrl-sprd.h"

#define PINCTRL_REG_OFFSET		0x20
#define PINCTRL_REG_MISC_OFFSET		0x0420

enum sprd_pike2_pins {
	/* PIN_CTRL_REG0 */
	PIKE2_WPD_EMMCPD = SPRD_PIN_INFO(0, GLOBAL_CTRL_PIN, 15, 1, 0),
	PIKE2_WPD_ADPD = SPRD_PIN_INFO(1, GLOBAL_CTRL_PIN, 13, 1, 0),
	PIKE2_WPD_SIM2PD = SPRD_PIN_INFO(2, GLOBAL_CTRL_PIN, 10, 1, 0),
	PIKE2_WPD_SIM1PD = SPRD_PIN_INFO(3, GLOBAL_CTRL_PIN, 9, 1, 0),
	PIKE2_WPD_SIM0PD = SPRD_PIN_INFO(4, GLOBAL_CTRL_PIN, 8, 1, 0),
	PIKE2_WPD_SD0PD = SPRD_PIN_INFO(5, GLOBAL_CTRL_PIN, 7, 1, 0),
	PIKE2_WPD_CAMPD = SPRD_PIN_INFO(6, GLOBAL_CTRL_PIN, 6, 1, 0),
	PIKE2_SIM2_SYS_DLP_MODE = SPRD_PIN_INFO(7, GLOBAL_CTRL_PIN, 2, 1, 0),
	PIKE2_SIM1_SYS_DLP_MODE = SPRD_PIN_INFO(8, GLOBAL_CTRL_PIN, 1, 1, 0),
	PIKE2_SIM0_SYS_DLP_MODE = SPRD_PIN_INFO(9, GLOBAL_CTRL_PIN, 0, 1, 0),

	/* PIN_CTRL_REG1 */
	PIKE2_SIMRST2_ISO_VALUE = SPRD_PIN_INFO(10, GLOBAL_CTRL_PIN, 12, 1, 1),
	PIKE2_SIMDA2_ISO_VALUE = SPRD_PIN_INFO(11, GLOBAL_CTRL_PIN, 11, 1, 1),
	PIKE2_SIMCLK2_ISO_VALUE = SPRD_PIN_INFO(12, GLOBAL_CTRL_PIN, 10, 1, 1),
	PIKE2_SIMRST1_ISO_VALUE = SPRD_PIN_INFO(13, GLOBAL_CTRL_PIN, 9, 1, 1),
	PIKE2_SIMDA1_ISO_VALUE = SPRD_PIN_INFO(14, GLOBAL_CTRL_PIN, 8, 1, 1),
	PIKE2_SIMCLK1_ISO_VALUE = SPRD_PIN_INFO(15, GLOBAL_CTRL_PIN, 7, 1, 1),
	PIKE2_SIMRST0_ISO_VALUE = SPRD_PIN_INFO(16, GLOBAL_CTRL_PIN, 6, 1, 1),
	PIKE2_SIMDA0_ISO_VALUE = SPRD_PIN_INFO(17, GLOBAL_CTRL_PIN, 5, 1, 1),
	PIKE2_SIMCLK0_ISO_VALUE = SPRD_PIN_INFO(18, GLOBAL_CTRL_PIN, 4, 1, 1),

	/* PIN_CTRL_REG2 */
	PIKE2_SIM2_SYS_SEL = SPRD_PIN_INFO(19, GLOBAL_CTRL_PIN, 23, 1, 2),
	PIKE2_SIM1_SYS_SEL = SPRD_PIN_INFO(20, GLOBAL_CTRL_PIN, 22, 1, 2),
	PIKE2_SIM0_SYS_SEL = SPRD_PIN_INFO(21, GLOBAL_CTRL_PIN, 21, 1, 2),
	PIKE2_UART3_SYS_SEL = SPRD_PIN_INFO(22, GLOBAL_CTRL_PIN, 15, 3, 2),
	PIKE2_UART2_SYS_SEL = SPRD_PIN_INFO(23, GLOBAL_CTRL_PIN, 11, 4, 2),
	PIKE2_UART1_SYS_SEL = SPRD_PIN_INFO(24, GLOBAL_CTRL_PIN, 7, 4, 2),
	PIKE2_UART0_SYS_SEL = SPRD_PIN_INFO(25, GLOBAL_CTRL_PIN, 4, 3, 2),
	PIKE2_UART23_LOOP_SEL = SPRD_PIN_INFO(26, GLOBAL_CTRL_PIN, 2, 1, 2),
	PIKE2_UART13_LOOP_SEL = SPRD_PIN_INFO(27, GLOBAL_CTRL_PIN, 0, 1, 2),

	/* PIN_CTRL_REG3 */
	PIKE2_WDRST_OUT_SEL = SPRD_PIN_INFO(28, GLOBAL_CTRL_PIN, 29, 3, 3),
	PIKE2_IIS2_CLK_OE = SPRD_PIN_INFO(29, GLOBAL_CTRL_PIN, 22, 1, 3),
	PIKE2_IIS2_SYS_SEL = SPRD_PIN_INFO(30, GLOBAL_CTRL_PIN, 14, 2, 3),
	PIKE2_IIS1_SYS_SEL = SPRD_PIN_INFO(31, GLOBAL_CTRL_PIN, 10, 2, 3),
	PIKE2_IIS0_SYS_SEL = SPRD_PIN_INFO(32, GLOBAL_CTRL_PIN, 6, 2, 3),

	/* PIN_CTRL_REG4 */
	PIKE2_VSD0_MSEN = SPRD_PIN_INFO(33, GLOBAL_CTRL_PIN, 9, 1, 4),
	PIKE2_VSIM2_MSEN = SPRD_PIN_INFO(34, GLOBAL_CTRL_PIN, 8, 1, 4),
	PIKE2_VSIM1_MSEN = SPRD_PIN_INFO(35, GLOBAL_CTRL_PIN, 7, 1, 4),
	PIKE2_VSIM0_MSEN = SPRD_PIN_INFO(36, GLOBAL_CTRL_PIN, 6, 1, 4),
	PIKE2_VSD0_MS = SPRD_PIN_INFO(37, GLOBAL_CTRL_PIN, 5, 1, 4),
	PIKE2_VSIM2_MS = SPRD_PIN_INFO(38, GLOBAL_CTRL_PIN, 4, 1, 4),
	PIKE2_VSIM1_MS = SPRD_PIN_INFO(39, GLOBAL_CTRL_PIN, 3, 1, 4),
	PIKE2_VSIM0_MS = SPRD_PIN_INFO(40, GLOBAL_CTRL_PIN, 2, 1, 4),
	PIKE2_VIO_MS = SPRD_PIN_INFO(41, GLOBAL_CTRL_PIN, 0, 1, 4),

	/* PIN_CTRL_REG5 */
	PIKE2_CARD_DET_SEL = SPRD_PIN_INFO(42, GLOBAL_CTRL_PIN, 17, 3, 5),
	PIKE2_SIM0_DET_SEL = SPRD_PIN_INFO(43, GLOBAL_CTRL_PIN, 16, 1, 5),
	PIKE2_AP_SIM0_BD_EB = SPRD_PIN_INFO(44, GLOBAL_CTRL_PIN, 15, 1, 5),
	PIKE2_AP_EMMC_BD_EB = SPRD_PIN_INFO(45, GLOBAL_CTRL_PIN, 14, 1, 5),
	PIKE2_AP_SDIO0_BD_EB = SPRD_PIN_INFO(46, GLOBAL_CTRL_PIN, 11, 1, 6),
	PIKE2_PUBCP_SIM1_BD_EB = SPRD_PIN_INFO(47, GLOBAL_CTRL_PIN, 9, 1, 5),
	PIKE2_PUBCP_SIM0_BD_EB = SPRD_PIN_INFO(48, GLOBAL_CTRL_PIN, 8, 1, 5),

	/* Common pin registers definitions */
	PIKE2_U0TXD = SPRD_PIN_INFO(49, COMMON_PIN, 0, 0, 0),
	PIKE2_U0RXD = SPRD_PIN_INFO(50, COMMON_PIN, 0, 0, 0),
	PIKE2_U0CTS = SPRD_PIN_INFO(51, COMMON_PIN, 0, 0, 0),
	PIKE2_U0RTS = SPRD_PIN_INFO(52, COMMON_PIN, 0, 0, 0),
	PIKE2_TCK_ARM = SPRD_PIN_INFO(53, COMMON_PIN, 0, 0, 0),
	PIKE2_TMS_ARM = SPRD_PIN_INFO(54, COMMON_PIN, 0, 0, 0),
	PIKE2_PTEST = SPRD_PIN_INFO(55, COMMON_PIN, 0, 0, 0),
	PIKE2_ANA_INT = SPRD_PIN_INFO(56, COMMON_PIN, 0, 0, 0),
	PIKE2_EXT_RST_B = SPRD_PIN_INFO(57, COMMON_PIN, 0, 0, 0),
	PIKE2_CHIP_SLEEP = SPRD_PIN_INFO(58, COMMON_PIN, 0, 0, 0),
	PIKE2_CLK_32K = SPRD_PIN_INFO(59, COMMON_PIN, 0, 0, 0),
	PIKE2_AUD_SCLK = SPRD_PIN_INFO(60, COMMON_PIN, 0, 0, 0),
	PIKE2_AUD_ADD0 = SPRD_PIN_INFO(61, COMMON_PIN, 0, 0, 0),
	PIKE2_AUD_ADSYNC = SPRD_PIN_INFO(62, COMMON_PIN, 0, 0, 0),
	PIKE2_AUD_DAD1 = SPRD_PIN_INFO(63, COMMON_PIN, 0, 0, 0),
	PIKE2_AUD_DAD0 = SPRD_PIN_INFO(64, COMMON_PIN, 0, 0, 0),
	PIKE2_AUD_DASYNC = SPRD_PIN_INFO(65, COMMON_PIN, 0, 0, 0),
	PIKE2_ADI_D = SPRD_PIN_INFO(66, COMMON_PIN, 0, 0, 0),
	PIKE2_ADI_SYNC = SPRD_PIN_INFO(67, COMMON_PIN, 0, 0, 0),
	PIKE2_ADI_SCLK = SPRD_PIN_INFO(68, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMDA0 = SPRD_PIN_INFO(69, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMCLK0 = SPRD_PIN_INFO(70, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMRST0 = SPRD_PIN_INFO(71, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMDA1 = SPRD_PIN_INFO(72, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMRST1 = SPRD_PIN_INFO(73, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMCLK1 = SPRD_PIN_INFO(74, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMCLK2 = SPRD_PIN_INFO(75, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMDA2 = SPRD_PIN_INFO(76, COMMON_PIN, 0, 0, 0),
	PIKE2_SIMRST2 = SPRD_PIN_INFO(77, COMMON_PIN, 0, 0, 0),

	PIKE2_NF_DATA_2 = SPRD_PIN_INFO(78, COMMON_PIN, 0, 0, 0),
	PIKE2_NF_DATA_1 = SPRD_PIN_INFO(79, COMMON_PIN, 0, 0, 0),
	PIKE2_NF_DATA_0 = SPRD_PIN_INFO(80, COMMON_PIN, 0, 0, 0),
	PIKE2_NF_WEN = SPRD_PIN_INFO(81, COMMON_PIN, 0, 0, 0),
	PIKE2_NF_CEN0 = SPRD_PIN_INFO(82, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_DUMMY = SPRD_PIN_INFO(83, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D0 = SPRD_PIN_INFO(84, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D1 = SPRD_PIN_INFO(85, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D2 = SPRD_PIN_INFO(86, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D3 = SPRD_PIN_INFO(87, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D4 = SPRD_PIN_INFO(88, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D5 = SPRD_PIN_INFO(89, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D6 = SPRD_PIN_INFO(90, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_D7 = SPRD_PIN_INFO(91, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_CLK = SPRD_PIN_INFO(92, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_DS = SPRD_PIN_INFO(93, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_CMD = SPRD_PIN_INFO(94, COMMON_PIN, 0, 0, 0),
	PIKE2_EMMC_RST = SPRD_PIN_INFO(95, COMMON_PIN, 0, 0, 0),
	PIKE2_LCM_RSTN = SPRD_PIN_INFO(96, COMMON_PIN, 0, 0, 0),
	PIKE2_DSI_TE = SPRD_PIN_INFO(97, COMMON_PIN, 0, 0, 0),
	PIKE2_SCL0 = SPRD_PIN_INFO(98, COMMON_PIN, 0, 0, 0),
	PIKE2_SDA0 = SPRD_PIN_INFO(99, COMMON_PIN, 0, 0, 0),
	PIKE2_CMMCLK0 = SPRD_PIN_INFO(100, COMMON_PIN, 0, 0, 0),
	PIKE2_CMRST0 = SPRD_PIN_INFO(101, COMMON_PIN, 0, 0, 0),
	PIKE2_CMPD0 = SPRD_PIN_INFO(102, COMMON_PIN, 0, 0, 0),
	PIKE2_CMPD1 = SPRD_PIN_INFO(103, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_CLK0 = SPRD_PIN_INFO(104, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_CMD = SPRD_PIN_INFO(105, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_D0 = SPRD_PIN_INFO(106, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_D1 = SPRD_PIN_INFO(107, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_D2 = SPRD_PIN_INFO(108, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_D3 = SPRD_PIN_INFO(109, COMMON_PIN, 0, 0, 0),
	PIKE2_SD0_DUMMY = SPRD_PIN_INFO(110, COMMON_PIN, 0, 0, 0),
	PIKE2_IIS0CLK = SPRD_PIN_INFO(111, COMMON_PIN, 0, 0, 0),
	PIKE2_IIS0LRCK = SPRD_PIN_INFO(112, COMMON_PIN, 0, 0, 0),
	PIKE2_IIS0DI = SPRD_PIN_INFO(113, COMMON_PIN, 0, 0, 0),
	PIKE2_IIS0DO = SPRD_PIN_INFO(114, COMMON_PIN, 0, 0, 0),
	PIKE2_U1RXD = SPRD_PIN_INFO(115, COMMON_PIN, 0, 0, 0),
	PIKE2_U1TXD = SPRD_PIN_INFO(116, COMMON_PIN, 0, 0, 0),
	PIKE2_KEYIN0 = SPRD_PIN_INFO(117, COMMON_PIN, 0, 0, 0),
	PIKE2_KEYIN1 = SPRD_PIN_INFO(118, COMMON_PIN, 0, 0, 0),
	PIKE2_KEYIN2 = SPRD_PIN_INFO(119, COMMON_PIN, 0, 0, 0),
	PIKE2_KEYOUT0 = SPRD_PIN_INFO(120, COMMON_PIN, 0, 0, 0),
	PIKE2_KEYOUT1 = SPRD_PIN_INFO(121, COMMON_PIN, 0, 0, 0),
	PIKE2_KEYOUT2 = SPRD_PIN_INFO(122, COMMON_PIN, 0, 0, 0),
	PIKE2_LNA_EN = SPRD_PIN_INFO(123, COMMON_PIN, 0, 0, 0),
	PIKE2_SPI_HS_DO = SPRD_PIN_INFO(124, COMMON_PIN, 0, 0, 0),
	PIKE2_SPI_HS_DI = SPRD_PIN_INFO(125, COMMON_PIN, 0, 0, 0),
	PIKE2_SPI_HS_CLK = SPRD_PIN_INFO(126, COMMON_PIN, 0, 0, 0),
	PIKE2_SPI_HS_CSN = SPRD_PIN_INFO(127, COMMON_PIN, 0, 0, 0),
	PIKE2_EXTINT1 = SPRD_PIN_INFO(128, COMMON_PIN, 0, 0, 0),
	PIKE2_EXTINT0 = SPRD_PIN_INFO(129, COMMON_PIN, 0, 0, 0),
	PIKE2_SCL2 = SPRD_PIN_INFO(130, COMMON_PIN, 0, 0, 0),
	PIKE2_SDA2 = SPRD_PIN_INFO(131, COMMON_PIN, 0, 0, 0),
	PIKE2_SCL1 = SPRD_PIN_INFO(132, COMMON_PIN, 0, 0, 0),
	PIKE2_SDA1 = SPRD_PIN_INFO(133, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL11 = SPRD_PIN_INFO(134, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL10 = SPRD_PIN_INFO(135, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL9 = SPRD_PIN_INFO(136, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL8 = SPRD_PIN_INFO(137, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL7 = SPRD_PIN_INFO(138, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL6 = SPRD_PIN_INFO(139, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL5 = SPRD_PIN_INFO(140, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL4 = SPRD_PIN_INFO(141, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL3 = SPRD_PIN_INFO(142, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL2 = SPRD_PIN_INFO(143, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL1 = SPRD_PIN_INFO(144, COMMON_PIN, 0, 0, 0),
	PIKE2_RFCTL0 = SPRD_PIN_INFO(145, COMMON_PIN, 0, 0, 0),

	/* MSIC pin registers definitions */
	PIKE2_U0TXD_MISC = SPRD_PIN_INFO(146, MISC_PIN, 0, 0, 0),
	PIKE2_U0RXD_MISC = SPRD_PIN_INFO(147, MISC_PIN, 0, 0, 0),
	PIKE2_U0CTS_MISC = SPRD_PIN_INFO(148, MISC_PIN, 0, 0, 0),
	PIKE2_U0RTS_MISC = SPRD_PIN_INFO(149, MISC_PIN, 0, 0, 0),
	PIKE2_TCK_ARM_MISC = SPRD_PIN_INFO(150, MISC_PIN, 0, 0, 0),
	PIKE2_TMS_ARM_MISC = SPRD_PIN_INFO(151, MISC_PIN, 0, 0, 0),
	PIKE2_PTEST_MISC = SPRD_PIN_INFO(152, MISC_PIN, 0, 0, 0),
	PIKE2_ANA_INT_MISC = SPRD_PIN_INFO(153, MISC_PIN, 0, 0, 0),
	PIKE2_EXT_RST_B_MISC = SPRD_PIN_INFO(154, MISC_PIN, 0, 0, 0),
	PIKE2_CHIP_SLEEP_MISC = SPRD_PIN_INFO(155, MISC_PIN, 0, 0, 0),
	PIKE2_CLK_32K_MISC = SPRD_PIN_INFO(156, MISC_PIN, 0, 0, 0),
	PIKE2_AUD_SCLK_MISC = SPRD_PIN_INFO(157, MISC_PIN, 0, 0, 0),
	PIKE2_AUD_ADD0_MISC = SPRD_PIN_INFO(158, MISC_PIN, 0, 0, 0),
	PIKE2_AUD_ADSYNC_MISC = SPRD_PIN_INFO(159, MISC_PIN, 0, 0, 0),
	PIKE2_AUD_DAD1_MISC = SPRD_PIN_INFO(160, MISC_PIN, 0, 0, 0),
	PIKE2_AUD_DAD0_MISC = SPRD_PIN_INFO(161, MISC_PIN, 0, 0, 0),
	PIKE2_AUD_DASYNC_MISC = SPRD_PIN_INFO(162, MISC_PIN, 0, 0, 0),
	PIKE2_ADI_D_MISC = SPRD_PIN_INFO(163, MISC_PIN, 0, 0, 0),
	PIKE2_ADI_SYNC_MISC = SPRD_PIN_INFO(164, MISC_PIN, 0, 0, 0),
	PIKE2_ADI_SCLK_MISC = SPRD_PIN_INFO(165, MISC_PIN, 0, 0, 0),
	PIKE2_SIMDA0_MISC = SPRD_PIN_INFO(166, MISC_PIN, 0, 0, 0),
	PIKE2_SIMCLK0_MISC = SPRD_PIN_INFO(167, MISC_PIN, 0, 0, 0),
	PIKE2_SIMRST0_MISC = SPRD_PIN_INFO(168, MISC_PIN, 0, 0, 0),
	PIKE2_SIMDA1_MISC = SPRD_PIN_INFO(169, MISC_PIN, 0, 0, 0),
	PIKE2_SIMRST1_MISC = SPRD_PIN_INFO(170, MISC_PIN, 0, 0, 0),
	PIKE2_SIMCLK1_MISC = SPRD_PIN_INFO(171, MISC_PIN, 0, 0, 0),
	PIKE2_SIMCLK2_MISC = SPRD_PIN_INFO(172, MISC_PIN, 0, 0, 0),
	PIKE2_SIMDA2_MISC = SPRD_PIN_INFO(173, MISC_PIN, 0, 0, 0),
	PIKE2_SIMRST2_MISC = SPRD_PIN_INFO(174, MISC_PIN, 0, 0, 0),
	PIKE2_NF_DATA_2_MISC = SPRD_PIN_INFO(175, MISC_PIN, 0, 0, 0),
	PIKE2_NF_DATA_1_MISC = SPRD_PIN_INFO(176, MISC_PIN, 0, 0, 0),
	PIKE2_NF_DATA_0_MISC = SPRD_PIN_INFO(177, MISC_PIN, 0, 0, 0),
	PIKE2_NF_WEN_MISC = SPRD_PIN_INFO(178, MISC_PIN, 0, 0, 0),
	PIKE2_NF_CEN0_MISC = SPRD_PIN_INFO(179, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_DUMMY_MISC = SPRD_PIN_INFO(180, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D0_MISC = SPRD_PIN_INFO(181, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D1_MISC = SPRD_PIN_INFO(182, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D2_MISC = SPRD_PIN_INFO(183, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D3_MISC = SPRD_PIN_INFO(184, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D4_MISC = SPRD_PIN_INFO(185, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D5_MISC = SPRD_PIN_INFO(186, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D6_MISC = SPRD_PIN_INFO(187, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_D7_MISC = SPRD_PIN_INFO(188, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_CLK_MISC = SPRD_PIN_INFO(189, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_DS_MISC = SPRD_PIN_INFO(190, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_CMD_MISC = SPRD_PIN_INFO(191, MISC_PIN, 0, 0, 0),
	PIKE2_EMMC_RST_MISC = SPRD_PIN_INFO(192, MISC_PIN, 0, 0, 0),
	PIKE2_LCM_RSTN_MISC = SPRD_PIN_INFO(193, MISC_PIN, 0, 0, 0),
	PIKE2_DSI_TE_MISC = SPRD_PIN_INFO(194, MISC_PIN, 0, 0, 0),
	PIKE2_SCL0_MISC = SPRD_PIN_INFO(195, MISC_PIN, 0, 0, 0),
	PIKE2_SDA0_MISC = SPRD_PIN_INFO(196, MISC_PIN, 0, 0, 0),
	PIKE2_CMMCLK0_MISC = SPRD_PIN_INFO(197, MISC_PIN, 0, 0, 0),
	PIKE2_CMRST0_MISC = SPRD_PIN_INFO(198, MISC_PIN, 0, 0, 0),
	PIKE2_CMPD0_MISC = SPRD_PIN_INFO(199, MISC_PIN, 0, 0, 0),
	PIKE2_CMPD1_MISC = SPRD_PIN_INFO(200, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_CLK0_MISC = SPRD_PIN_INFO(201, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_CMD_MISC = SPRD_PIN_INFO(202, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_D0_MISC = SPRD_PIN_INFO(203, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_D1_MISC = SPRD_PIN_INFO(204, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_D2_MISC = SPRD_PIN_INFO(205, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_D3_MISC = SPRD_PIN_INFO(206, MISC_PIN, 0, 0, 0),
	PIKE2_SD0_DUMMY_MISC = SPRD_PIN_INFO(207, MISC_PIN, 0, 0, 0),
	PIKE2_IIS0CLK_MISC = SPRD_PIN_INFO(208, MISC_PIN, 0, 0, 0),
	PIKE2_IIS0LRCK_MISC = SPRD_PIN_INFO(209, MISC_PIN, 0, 0, 0),
	PIKE2_IIS0DI_MISC = SPRD_PIN_INFO(210, MISC_PIN, 0, 0, 0),
	PIKE2_IIS0DO_MISC = SPRD_PIN_INFO(211, MISC_PIN, 0, 0, 0),
	PIKE2_U1RXD_MISC = SPRD_PIN_INFO(212, MISC_PIN, 0, 0, 0),
	PIKE2_U1TXD_MISC = SPRD_PIN_INFO(213, MISC_PIN, 0, 0, 0),
	PIKE2_KEYIN0_MISC = SPRD_PIN_INFO(214, MISC_PIN, 0, 0, 0),
	PIKE2_KEYIN1_MISC = SPRD_PIN_INFO(215, MISC_PIN, 0, 0, 0),
	PIKE2_KEYIN2_MISC = SPRD_PIN_INFO(216, MISC_PIN, 0, 0, 0),
	PIKE2_KEYOUT0_MISC = SPRD_PIN_INFO(217, MISC_PIN, 0, 0, 0),
	PIKE2_KEYOUT1_MISC = SPRD_PIN_INFO(218, MISC_PIN, 0, 0, 0),
	PIKE2_KEYOUT2_MISC = SPRD_PIN_INFO(219, MISC_PIN, 0, 0, 0),
	PIKE2_LNA_EN_MISC = SPRD_PIN_INFO(220, MISC_PIN, 0, 0, 0),
	PIKE2_SPI_HS_DO_MISC = SPRD_PIN_INFO(221, MISC_PIN, 0, 0, 0),
	PIKE2_SPI_HS_DI_MISC = SPRD_PIN_INFO(222, MISC_PIN, 0, 0, 0),
	PIKE2_SPI_HS_CLK_MISC = SPRD_PIN_INFO(223, MISC_PIN, 0, 0, 0),
	PIKE2_SPI_HS_CSN_MISC = SPRD_PIN_INFO(224, MISC_PIN, 0, 0, 0),
	PIKE2_EXTINT1_MISC = SPRD_PIN_INFO(225, MISC_PIN, 0, 0, 0),
	PIKE2_EXTINT0_MISC = SPRD_PIN_INFO(226, MISC_PIN, 0, 0, 0),
	PIKE2_SCL2_MISC = SPRD_PIN_INFO(227, MISC_PIN, 0, 0, 0),
	PIKE2_SDA2_MISC = SPRD_PIN_INFO(228, MISC_PIN, 0, 0, 0),
	PIKE2_SCL1_MISC = SPRD_PIN_INFO(229, MISC_PIN, 0, 0, 0),
	PIKE2_SDA1_MISC = SPRD_PIN_INFO(230, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL11_MISC = SPRD_PIN_INFO(231, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL10_MISC = SPRD_PIN_INFO(232, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL9_MISC = SPRD_PIN_INFO(233, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL8_MISC = SPRD_PIN_INFO(234, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL7_MISC = SPRD_PIN_INFO(235, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL6_MISC = SPRD_PIN_INFO(236, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL5_MISC = SPRD_PIN_INFO(237, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL4_MISC = SPRD_PIN_INFO(238, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL3_MISC = SPRD_PIN_INFO(239, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL2_MISC = SPRD_PIN_INFO(240, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL1_MISC = SPRD_PIN_INFO(241, MISC_PIN, 0, 0, 0),
	PIKE2_RFCTL0_MISC = SPRD_PIN_INFO(242, MISC_PIN, 0, 0, 0),
};

static struct sprd_pins_info sprd_pike2_pins_info[] = {
	SPRD_PINCTRL_PIN(PIKE2_WPD_EMMCPD),
	SPRD_PINCTRL_PIN(PIKE2_WPD_ADPD),
	SPRD_PINCTRL_PIN(PIKE2_WPD_SIM2PD),
	SPRD_PINCTRL_PIN(PIKE2_WPD_SIM1PD),
	SPRD_PINCTRL_PIN(PIKE2_WPD_SIM0PD),
	SPRD_PINCTRL_PIN(PIKE2_WPD_SD0PD),
	SPRD_PINCTRL_PIN(PIKE2_WPD_CAMPD),
	SPRD_PINCTRL_PIN(PIKE2_SIM2_SYS_DLP_MODE),
	SPRD_PINCTRL_PIN(PIKE2_SIM1_SYS_DLP_MODE),
	SPRD_PINCTRL_PIN(PIKE2_SIM0_SYS_DLP_MODE),

	SPRD_PINCTRL_PIN(PIKE2_SIMRST2_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA2_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK2_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST1_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA1_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK1_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST0_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA0_ISO_VALUE),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK0_ISO_VALUE),

	SPRD_PINCTRL_PIN(PIKE2_SIM2_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_SIM1_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_SIM0_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_UART3_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_UART2_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_UART1_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_UART0_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_UART23_LOOP_SEL),
	SPRD_PINCTRL_PIN(PIKE2_UART13_LOOP_SEL),

	SPRD_PINCTRL_PIN(PIKE2_WDRST_OUT_SEL),
	SPRD_PINCTRL_PIN(PIKE2_IIS2_CLK_OE),
	SPRD_PINCTRL_PIN(PIKE2_IIS2_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_IIS1_SYS_SEL),
	SPRD_PINCTRL_PIN(PIKE2_IIS0_SYS_SEL),

	SPRD_PINCTRL_PIN(PIKE2_VSD0_MSEN),
	SPRD_PINCTRL_PIN(PIKE2_VSIM2_MSEN),
	SPRD_PINCTRL_PIN(PIKE2_VSIM1_MSEN),
	SPRD_PINCTRL_PIN(PIKE2_VSIM0_MSEN),
	SPRD_PINCTRL_PIN(PIKE2_VSD0_MS),
	SPRD_PINCTRL_PIN(PIKE2_VSIM2_MS),
	SPRD_PINCTRL_PIN(PIKE2_VSIM1_MS),
	SPRD_PINCTRL_PIN(PIKE2_VSIM0_MS),
	SPRD_PINCTRL_PIN(PIKE2_VIO_MS),

	SPRD_PINCTRL_PIN(PIKE2_CARD_DET_SEL),
	SPRD_PINCTRL_PIN(PIKE2_SIM0_DET_SEL),
	SPRD_PINCTRL_PIN(PIKE2_AP_SIM0_BD_EB),
	SPRD_PINCTRL_PIN(PIKE2_AP_EMMC_BD_EB),
	SPRD_PINCTRL_PIN(PIKE2_AP_SDIO0_BD_EB),
	SPRD_PINCTRL_PIN(PIKE2_PUBCP_SIM1_BD_EB),
	SPRD_PINCTRL_PIN(PIKE2_PUBCP_SIM0_BD_EB),

	SPRD_PINCTRL_PIN(PIKE2_U0TXD),
	SPRD_PINCTRL_PIN(PIKE2_U0RXD),
	SPRD_PINCTRL_PIN(PIKE2_U0CTS),
	SPRD_PINCTRL_PIN(PIKE2_U0RTS),
	SPRD_PINCTRL_PIN(PIKE2_TCK_ARM),
	SPRD_PINCTRL_PIN(PIKE2_TMS_ARM),
	SPRD_PINCTRL_PIN(PIKE2_PTEST),
	SPRD_PINCTRL_PIN(PIKE2_ANA_INT),
	SPRD_PINCTRL_PIN(PIKE2_EXT_RST_B),
	SPRD_PINCTRL_PIN(PIKE2_CHIP_SLEEP),
	SPRD_PINCTRL_PIN(PIKE2_CLK_32K),
	SPRD_PINCTRL_PIN(PIKE2_AUD_SCLK),
	SPRD_PINCTRL_PIN(PIKE2_AUD_ADD0),
	SPRD_PINCTRL_PIN(PIKE2_AUD_ADSYNC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_DAD1),
	SPRD_PINCTRL_PIN(PIKE2_AUD_DAD0),
	SPRD_PINCTRL_PIN(PIKE2_AUD_DASYNC),
	SPRD_PINCTRL_PIN(PIKE2_ADI_D),
	SPRD_PINCTRL_PIN(PIKE2_ADI_SYNC),
	SPRD_PINCTRL_PIN(PIKE2_ADI_SCLK),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA0),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK0),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST0),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA1),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST1),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK1),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK2),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA2),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST2),

	SPRD_PINCTRL_PIN(PIKE2_NF_DATA_2),
	SPRD_PINCTRL_PIN(PIKE2_NF_DATA_1),
	SPRD_PINCTRL_PIN(PIKE2_NF_DATA_0),
	SPRD_PINCTRL_PIN(PIKE2_NF_WEN),
	SPRD_PINCTRL_PIN(PIKE2_NF_CEN0),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_DUMMY),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D0),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D1),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D2),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D3),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D4),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D5),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D6),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D7),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_CLK),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_DS),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_CMD),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_RST),
	SPRD_PINCTRL_PIN(PIKE2_LCM_RSTN),
	SPRD_PINCTRL_PIN(PIKE2_DSI_TE),
	SPRD_PINCTRL_PIN(PIKE2_SCL0),
	SPRD_PINCTRL_PIN(PIKE2_SDA0),
	SPRD_PINCTRL_PIN(PIKE2_CMMCLK0),
	SPRD_PINCTRL_PIN(PIKE2_CMRST0),
	SPRD_PINCTRL_PIN(PIKE2_CMPD0),
	SPRD_PINCTRL_PIN(PIKE2_CMPD1),
	SPRD_PINCTRL_PIN(PIKE2_SD0_CLK0),
	SPRD_PINCTRL_PIN(PIKE2_SD0_CMD),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D0),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D1),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D2),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D3),
	SPRD_PINCTRL_PIN(PIKE2_SD0_DUMMY),
	SPRD_PINCTRL_PIN(PIKE2_IIS0CLK),
	SPRD_PINCTRL_PIN(PIKE2_IIS0LRCK),
	SPRD_PINCTRL_PIN(PIKE2_IIS0DI),
	SPRD_PINCTRL_PIN(PIKE2_IIS0DO),
	SPRD_PINCTRL_PIN(PIKE2_U1RXD),
	SPRD_PINCTRL_PIN(PIKE2_U1TXD),
	SPRD_PINCTRL_PIN(PIKE2_KEYIN0),
	SPRD_PINCTRL_PIN(PIKE2_KEYIN1),
	SPRD_PINCTRL_PIN(PIKE2_KEYIN2),
	SPRD_PINCTRL_PIN(PIKE2_KEYOUT0),
	SPRD_PINCTRL_PIN(PIKE2_KEYOUT1),
	SPRD_PINCTRL_PIN(PIKE2_KEYOUT2),
	SPRD_PINCTRL_PIN(PIKE2_LNA_EN),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_DO),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_DI),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_CLK),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_CSN),
	SPRD_PINCTRL_PIN(PIKE2_EXTINT1),
	SPRD_PINCTRL_PIN(PIKE2_EXTINT0),
	SPRD_PINCTRL_PIN(PIKE2_SCL2),
	SPRD_PINCTRL_PIN(PIKE2_SDA2),
	SPRD_PINCTRL_PIN(PIKE2_SCL1),
	SPRD_PINCTRL_PIN(PIKE2_SDA1),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL11),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL10),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL9),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL8),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL7),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL6),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL5),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL4),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL3),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL2),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL1),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL0),

	SPRD_PINCTRL_PIN(PIKE2_U0TXD_MISC),
	SPRD_PINCTRL_PIN(PIKE2_U0RXD_MISC),
	SPRD_PINCTRL_PIN(PIKE2_U0CTS_MISC),
	SPRD_PINCTRL_PIN(PIKE2_U0RTS_MISC),
	SPRD_PINCTRL_PIN(PIKE2_TCK_ARM_MISC),
	SPRD_PINCTRL_PIN(PIKE2_TMS_ARM_MISC),
	SPRD_PINCTRL_PIN(PIKE2_PTEST_MISC),
	SPRD_PINCTRL_PIN(PIKE2_ANA_INT_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EXT_RST_B_MISC),
	SPRD_PINCTRL_PIN(PIKE2_CHIP_SLEEP_MISC),
	SPRD_PINCTRL_PIN(PIKE2_CLK_32K_MISC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_SCLK_MISC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_ADD0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_ADSYNC_MISC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_DAD1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_DAD0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_AUD_DASYNC_MISC),
	SPRD_PINCTRL_PIN(PIKE2_ADI_D_MISC),
	SPRD_PINCTRL_PIN(PIKE2_ADI_SYNC_MISC),
	SPRD_PINCTRL_PIN(PIKE2_ADI_SCLK_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMCLK2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMDA2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SIMRST2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_NF_DATA_2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_NF_DATA_1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_NF_DATA_0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_NF_WEN_MISC),
	SPRD_PINCTRL_PIN(PIKE2_NF_CEN0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_DUMMY_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D3_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D4_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D5_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D6_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_D7_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_CLK_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_DS_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_CMD_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EMMC_RST_MISC),
	SPRD_PINCTRL_PIN(PIKE2_LCM_RSTN_MISC),
	SPRD_PINCTRL_PIN(PIKE2_DSI_TE_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SCL0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SDA0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_CMMCLK0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_CMRST0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_CMPD0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_CMPD1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_CLK0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_CMD_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_D3_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SD0_DUMMY_MISC),
	SPRD_PINCTRL_PIN(PIKE2_IIS0CLK_MISC),
	SPRD_PINCTRL_PIN(PIKE2_IIS0LRCK_MISC),
	SPRD_PINCTRL_PIN(PIKE2_IIS0DI_MISC),
	SPRD_PINCTRL_PIN(PIKE2_IIS0DO_MISC),
	SPRD_PINCTRL_PIN(PIKE2_U1RXD_MISC),
	SPRD_PINCTRL_PIN(PIKE2_U1TXD_MISC),
	SPRD_PINCTRL_PIN(PIKE2_KEYIN0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_KEYIN1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_KEYIN2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_KEYOUT0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_KEYOUT1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_KEYOUT2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_LNA_EN_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_DO_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_DI_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_CLK_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SPI_HS_CSN_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EXTINT1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_EXTINT0_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SCL2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SDA2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SCL1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_SDA1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL11_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL10_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL9_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL8_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL7_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL6_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL5_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL4_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL3_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL2_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL1_MISC),
	SPRD_PINCTRL_PIN(PIKE2_RFCTL0_MISC),
};

static int sprd_pinctrl_probe(struct platform_device *pdev)
{
	return sprd_pinctrl_core_probe(pdev, sprd_pike2_pins_info,
				       ARRAY_SIZE(sprd_pike2_pins_info),
				       PINCTRL_REG_OFFSET,
				       PINCTRL_REG_MISC_OFFSET);
}

static const struct of_device_id sprd_pinctrl_of_match[] = {
	{
		.compatible = "sprd,pike2-pinctrl",
	},
	{ },
};
MODULE_DEVICE_TABLE(of, sprd_pinctrl_of_match);

static struct platform_driver sprd_pinctrl_driver = {
	.driver = {
		.name = "sprd-pinctrl",
		.of_match_table = sprd_pinctrl_of_match,
	},
	.probe = sprd_pinctrl_probe,
	.remove = sprd_pinctrl_remove,
	.shutdown = sprd_pinctrl_shutdown,
};

module_platform_driver(sprd_pinctrl_driver);

MODULE_DESCRIPTION("SPREADTRUM Pin Controller Driver");
MODULE_AUTHOR("luting guo <luting.guo@unisoc.com>");
MODULE_LICENSE("GPL v2");
