/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2021-2022,2023 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef __QMI_SENSORS_H__
#define __QMI_SENSORS_H__

#define QMI_CLIENT_NAME_LENGTH	40

enum qmi_ts_sensor {
	QMI_TS_PA,
	QMI_TS_PA_1,
	QMI_TS_PA_2,
	QMI_TS_QFE_PA_0,
	QMI_TS_QFE_WTR_0,
	QMI_TS_MODEM_MODEM,
	QMI_TS_MMW_0,
	QMI_TS_MMW_1,
	QMI_TS_MMW_2,
	QMI_TS_MMW_3,
	QMI_TS_MODEM_SKIN,
	QMI_TS_QFE_PA_MDM,
	QMI_TS_QFE_PA_WTR,
	QMI_TS_STREAMER_0,
	QMI_TS_MOD_MMW_0,
	QMI_TS_MOD_MMW_1,
	QMI_TS_MOD_MMW_2,
	QMI_TS_MOD_MMW_3,
	QMI_TS_RET_PA_0,
	QMI_TS_WTR_PA_0,
	QMI_TS_WTR_PA_1,
	QMI_TS_WTR_PA_2,
	QMI_TS_WTR_PA_3,
	QMI_SYS_THERM1,
	QMI_SYS_THERM2,
	QMI_TS_TSENS_1,
	QMI_TS_MMW_PA1,
	QMI_TS_MMW_PA2,
	QMI_TS_MMW_PA3,
	QMI_TS_SDR_MMW,
	QMI_TS_QTM_THERM,
	QMI_TS_BCL_WARN,
	QMI_TS_SDR0_PA0,
	QMI_TS_SDR0_PA1,
	QMI_TS_SDR0_PA2,
	QMI_TS_SDR0_PA3,
	QMI_TS_SDR0_PA4,
	QMI_TS_SDR0_PA5,
	QMI_TS_SDR0,
	QMI_TS_SDR1_PA0,
	QMI_TS_SDR1_PA1,
	QMI_TS_SDR1_PA2,
	QMI_TS_SDR1_PA3,
	QMI_TS_SDR1_PA4,
	QMI_TS_SDR1_PA5,
	QMI_TS_SDR1,
	QMI_TS_MMW0,
	QMI_TS_MMW1,
	QMI_TS_MMW2,
	QMI_TS_MMW3,
	QMI_TS_MMW_IFIC0,
	QMI_TS_SUB1_MODEM_CFG,
	QMI_TS_SUB1_LTE_CC,
	QMI_TS_SUB1_MCG_FR1_CC,
	QMI_TS_SUB1_MCG_FR2_CC,
	QMI_TS_SUB1_SCG_FR1_CC,
	QMI_TS_SUB1_SCG_FR2_CC,
	QMI_TS_SUB2_MODEM_CFG,
	QMI_TS_SUB2_LTE_CC,
	QMI_TS_SUB2_MCG_FR1_CC,
	QMI_TS_SUB2_MCG_FR2_CC,
	QMI_TS_SUB2_SCG_FR1_CC,
	QMI_TS_SUB2_SCG_FR2_CC,
	QMI_TS_NSP_ISENSE_TRIM,
	QMI_TS_EPM0,
	QMI_TS_EPM1,
	QMI_TS_EPM2,
	QMI_TS_EPM3,
	QMI_TS_EPM4,
	QMI_TS_EPM5,
	QMI_TS_EPM6,
	QMI_TS_EPM7,
	QMI_TS_SDR0_PA,
	QMI_TS_SDR1_PA,
	QMI_TS_SDR2_PA,
	QMI_TS_SDR3_PA,
	QMI_TS_SDR4_PA,
	QMI_TS_SDR5_PA,
	QMI_TS_SDR6_PA,
	QMI_TS_SDR7_PA,
	QMI_TS_SDR2,
	QMI_TS_SDR3,
	QMI_TS_SDR4,
	QMI_TS_SDR5,
	QMI_TS_SDR6,
	QMI_TS_SDR7,
	QMI_TS_RF_CAL,
	QMI_TS_MODEM_CFG,
	QMI_TS_LTE_CC,
	QMI_TS_MCG_FR1_CC,
	QMI_TS_MCG_FR2_CC,
	QMI_TS_SCG_FR1_CC,
	QMI_TS_SCG_FR2_CC,
	QMI_TS_MAX_NR
};

static char sensor_clients[QMI_TS_MAX_NR][QMI_CLIENT_NAME_LENGTH] = {
	{"pa"},
	{"pa_1"},
	{"pa_2"},
	{"qfe_pa0"},
	{"qfe_wtr0"},
	{"modem_tsens"},
	{"qfe_mmw0"},
	{"qfe_mmw1"},
	{"qfe_mmw2"},
	{"qfe_mmw3"},
	{"xo_therm"},
	{"qfe_pa_mdm"},
	{"qfe_pa_wtr"},
	{"qfe_mmw_streamer0"},
	{"qfe_mmw0_mod"},
	{"qfe_mmw1_mod"},
	{"qfe_mmw2_mod"},
	{"qfe_mmw3_mod"},
	{"qfe_ret_pa0"},
	{"qfe_wtr_pa0"},
	{"qfe_wtr_pa1"},
	{"qfe_wtr_pa2"},
	{"qfe_wtr_pa3"},
	{"sys_therm1"},
	{"sys_therm2"},
	{"modem_tsens1"},
	{"mmw_pa1"},
	{"mmw_pa2"},
	{"mmw_pa3"},
	{"sdr_mmw_therm"},
	{"qtm_therm"},
	{"modem_bcl_warn"},
	{"sdr0_pa0"},
	{"sdr0_pa1"},
	{"sdr0_pa2"},
	{"sdr0_pa3"},
	{"sdr0_pa4"},
	{"sdr0_pa5"},
	{"sdr0"},
	{"sdr1_pa0"},
	{"sdr1_pa1"},
	{"sdr1_pa2"},
	{"sdr1_pa3"},
	{"sdr1_pa4"},
	{"sdr1_pa5"},
	{"sdr1"},
	{"mmw0"},
	{"mmw1"},
	{"mmw2"},
	{"mmw3"},
	{"mmw_ific0"},
	{"sub1_modem_cfg"},
	{"sub1_lte_cc"},
	{"sub1_mcg_fr1_cc"},
	{"sub1_mcg_fr2_cc"},
	{"sub1_scg_fr1_cc"},
	{"sub1_scg_fr2_cc"},
	{"sub2_modem_cfg"},
	{"sub2_lte_cc"},
	{"sub2_mcg_fr1_cc"},
	{"sub2_mcg_fr2_cc"},
	{"sub2_scg_fr1_cc"},
	{"sub2_scg_fr2_cc"},
	{"isense_trim"},
	{"epm0"},
	{"epm1"},
	{"epm2"},
	{"epm3"},
	{"epm4"},
	{"epm5"},
	{"epm6"},
	{"epm7"},
	{"sdr0_pa"},
	{"sdr1_pa"},
	{"sdr2_pa"},
	{"sdr3_pa"},
	{"sdr4_pa"},
	{"sdr5_pa"},
	{"sdr6_pa"},
	{"sdr7_pa"},
	{"sdr2"},
	{"sdr3"},
	{"sdr4"},
	{"sdr5"},
	{"sdr6"},
	{"sdr7"},
	{"rf_cal"},
	{"modem_cfg"},
	{"lte_cc"},
	{"mcg_fr1_cc"},
	{"mcg_fr2_cc"},
	{"scg_fr1_cc"},
	{"scg_fr2_cc"},
};

#endif /* __QMI_SENSORS_H__ */
