// SPDX-License-Identifier: GPL-2.0-only
/*
 * Copyright (c) 2022-2023 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#include <linux/regmap.h>
#include <linux/device.h>
#include "wcd-usbss-registers.h"

extern const u8 wcd_usbss_reg_access[WCD_USBSS_NUM_REGISTERS];

static struct reg_default wcd_usbss_defaults[] = {
	{WCD_USBSS_PAGE0_PAGE,                   0x00},
	{WCD_USBSS_PMP_EN,                       0x00},
	{WCD_USBSS_PMP_OUT1,                     0x08},
	{WCD_USBSS_PMP_OUT2,                     0x07},
	{WCD_USBSS_PMP_CLK,                      0x10},
	{WCD_USBSS_PMP_MISC1,                    0x00},
	{WCD_USBSS_PMP_MISC2,                    0x00},
	{WCD_USBSS_RCO_EN,                       0x00},
	{WCD_USBSS_RCO_RST,                      0x01},
	{WCD_USBSS_RCO_CLK,                      0x00},
	{WCD_USBSS_RCO_IBIAS,                    0x00},
	{WCD_USBSS_RCO_MISC1,                    0x00},
	{WCD_USBSS_RCO_MISC2,                    0x01},
	{WCD_USBSS_DP_EN,                        0x04},
	{WCD_USBSS_DP_BIAS,                      0x0f},
	{WCD_USBSS_DP_DN_MISC1,                  0x00},
	{WCD_USBSS_DN_EN,                        0x04},
	{WCD_USBSS_DN_BIAS,                      0x0f},
	{WCD_USBSS_DP_DN_MISC2,                  0x34},
	{WCD_USBSS_MG1_EN,                       0x0a},
	{WCD_USBSS_MG1_BIAS,                     0x0f},
	{WCD_USBSS_MG1_CTSNS_CTL,                0x21},
	{WCD_USBSS_MG1_MISC,                     0x00},
	{WCD_USBSS_MG2_EN,                       0x0a},
	{WCD_USBSS_MG2_BIAS,                     0x0f},
	{WCD_USBSS_MG2_CTSNS_CTL,                0x21},
	{WCD_USBSS_MG2_MISC,                     0x00},
	{WCD_USBSS_BIAS_TOP,                     0x00},
	{WCD_USBSS_VREF_CTRL,                    0x40},
	{WCD_USBSS_TOP_MISC1,                    0x20},
	{WCD_USBSS_TOP_MISC2,                    0x0f},
	{WCD_USBSS_STATUS_1,                     0x00},
	{WCD_USBSS_STATUS_2,                     0x00},
	{WCD_USBSS_STATUS_3,                     0x00},
	{WCD_USBSS_EXT_LIN_EN,                   0x00},
	{WCD_USBSS_INT_LIN_EN,                   0x00},
	{WCD_USBSS_COMBINER_IREF_PROG_1,         0x88},
	{WCD_USBSS_COMBINER_IREF_PROG_2,         0x88},
	{WCD_USBSS_EXTSW_AMP_BIAS,               0x00},
	{WCD_USBSS_INTSW_ILIFT,                  0x88},
	{WCD_USBSS_EXT_SW_CTRL_1,                0x00},
	{WCD_USBSS_EXT_SW_CTRL_2,                0x0c},
	{WCD_USBSS_INT_SW_CTRL_1,                0x00},
	{WCD_USBSS_INT_SW_CTRL_2,                0x1b},
	{WCD_USBSS_INT_SW_CTRL_3,                0x90},
	{WCD_USBSS_ATEST_CTRL,                   0x00},
	{WCD_USBSS_EXT_LIN_AUD_CEQ_PRG,          0xcc},
	{WCD_USBSS_EXT_LIN_GND_CEQ_PRG,          0xcc},
	{WCD_USBSS_LIN_STATUS_1,                 0x00},
	{WCD_USBSS_LIN_STATUS_2,                 0x00},
	{WCD_USBSS_LIN_STATUS_3,                 0x00},
	{WCD_USBSS_LIN_STATUS_4,                 0x00},
	{WCD_USBSS_SW_LIN_CTRL,                  0x00},
	{WCD_USBSS_SW_LIN_CTRL_1,                0x00},
	{WCD_USBSS_LDO_3P6,                      0x00},
	{WCD_USBSS_SWITCH_BANK_ATEST,            0x00},
	{WCD_USBSS_EQ_EN,                        0x28},
	{WCD_USBSS_EQ_MISC,                      0x19},
	{WCD_USBSS_STATUS_MISC,                  0x00},
	{WCD_USBSS_FSM_DELAYS1,                  0x00},
	{WCD_USBSS_FSM_DELAYS2,                  0x00},
	{WCD_USBSS_FSM_DELAYS3,                  0x00},
	{WCD_USBSS_FSM_DELAYS4,                  0x00},
	{WCD_USBSS_FSM_DELAYS5,                  0x00},
	{WCD_USBSS_FSM_DELAYS6,                  0x00},
	{WCD_USBSS_FSM_DELAYS7,                  0x00},
	{WCD_USBSS_FSM_DELAYS8,                  0x00},
	{WCD_USBSS_FSM_DEBUG_SIGNALS,            0x00},
	{WCD_USBSS_FSM_OVERRIDE,                 0x40},
	{WCD_USBSS_ENABLE_STATUS,                0xe0},
	{WCD_USBSS_FRZ_STATUS,                   0x80},
	{WCD_USBSS_DPR_DNL_SWITCH_ENABLE_STATUS, 0x90},
	{WCD_USBSS_SBU_GSBU_SWITCH_ENABLE_STATUS, 0x00},
	{WCD_USBSS_DPAUX_SWITCH_ENABLE_STATUS,   0x00},
	{WCD_USBSS_DPR_DNL_EXTFET_GATE_MUX_STATUS, 0x44},
	{WCD_USBSS_SBU_EXTFET_GATE_MUX_OVP_STATUS, 0x00},
	{WCD_USBSS_CP_LIN_CNTL_STATUS,           0xc0},
	{WCD_USBSS_DISP_AUXP_THRESH,             0x60},
	{WCD_USBSS_DISP_AUXP_CTL,                0xc3},
	{WCD_USBSS_DISP_AUXM_THRESH,             0xa0},
	{WCD_USBSS_DISP_AUXM_CTL,                0xc3},
	{WCD_USBSS_CTRL_0,                       0x90},
	{WCD_USBSS_CTRL_1,                       0x00},
	{WCD_USBSS_DC_TRIMCODE_1,                0x00},
	{WCD_USBSS_DC_TRIMCODE_2,                0x00},
	{WCD_USBSS_DC_TRIMCODE_3,                0x00},
	{WCD_USBSS_AC_TRIMCODE_1,                0x00},
	{WCD_USBSS_AC_TRIMCODE_2,                0x00},
	{WCD_USBSS_CPLDO_CTL1,                   0x08},
	{WCD_USBSS_CPLDO_CTL2,                   0x00},
	{WCD_USBSS_LUT_REG0,                     0x00},
	{WCD_USBSS_LUT_REG1,                     0x00},
	{WCD_USBSS_LUT_REG2,                     0x00},
	{WCD_USBSS_LUT_REG3,                     0x00},
	{WCD_USBSS_LUT_REG4,                     0x00},
	{WCD_USBSS_LUT_REG5,                     0x00},
	{WCD_USBSS_LUT_REG6,                     0x00},
	{WCD_USBSS_LUT_REG7,                     0x00},
	{WCD_USBSS_LUT_REG8,                     0x00},
	{WCD_USBSS_LUT_REG9,                     0x00},
	{WCD_USBSS_LUT_REG10,                    0x00},
	{WCD_USBSS_LUT_REG11,                    0x00},
	{WCD_USBSS_LUT_REG12,                    0x00},
	{WCD_USBSS_LUT_REG13,                    0x00},
	{WCD_USBSS_LUT_REG14,                    0x00},
	{WCD_USBSS_LUT_REG15,                    0x00},
	{WCD_USBSS_LUT_REG16,                    0x00},
	{WCD_USBSS_LUT_REG17,                    0x00},
	{WCD_USBSS_LUT_REG18,                    0x00},
	{WCD_USBSS_LUT_REG19,                    0x00},
	{WCD_USBSS_LUT_REG20,                    0x00},
	{WCD_USBSS_LUT_REG21,                    0x00},
	{WCD_USBSS_LUT_REG22,                    0x00},
	{WCD_USBSS_LUT_REG23,                    0x00},
	{WCD_USBSS_LUT_REG24,                    0x00},
	{WCD_USBSS_LUT_REG25,                    0x00},
	{WCD_USBSS_LUT_REG26,                    0x00},
	{WCD_USBSS_LUT_REG27,                    0x00},
	{WCD_USBSS_LUT_REG28,                    0x00},
	{WCD_USBSS_LUT_REG29,                    0x00},
	{WCD_USBSS_LUT_REG30,                    0x00},
	{WCD_USBSS_LUT_REG31,                    0x00},
	{WCD_USBSS_LUT_REG32,                    0x00},
	{WCD_USBSS_LUT_REG33,                    0x00},
	{WCD_USBSS_LUT_REG34,                    0x00},
	{WCD_USBSS_LUT_REG35,                    0x00},
	{WCD_USBSS_LUT_REG36,                    0x00},
	{WCD_USBSS_LUT_REG37,                    0x00},
	{WCD_USBSS_LUT_REG38,                    0x00},
	{WCD_USBSS_LUT_REG39,                    0x00},
	{WCD_USBSS_LUT_REG40,                    0x00},
	{WCD_USBSS_LUT_REG41,                    0x00},
	{WCD_USBSS_LUT_REG42,                    0x00},
	{WCD_USBSS_LUT_REG43,                    0x00},
	{WCD_USBSS_LUT_REG44,                    0x00},
	{WCD_USBSS_LUT_REG45,                    0x00},
	{WCD_USBSS_LUT_REG46,                    0x00},
	{WCD_USBSS_LUT_REG47,                    0x00},
	{WCD_USBSS_LUT_REG48,                    0x00},
	{WCD_USBSS_LUT_REG49,                    0x00},
	{WCD_USBSS_LUT_REG50,                    0x00},
	{WCD_USBSS_LUT_REG51,                    0x00},
	{WCD_USBSS_LUT_REG52,                    0x00},
	{WCD_USBSS_LUT_REG53,                    0x00},
	{WCD_USBSS_LUT_REG54,                    0x00},
	{WCD_USBSS_LUT_REG55,                    0x00},
	{WCD_USBSS_LUT_REG56,                    0x00},
	{WCD_USBSS_LUT_REG57,                    0x00},
	{WCD_USBSS_LUT_REG58,                    0x00},
	{WCD_USBSS_LUT_REG59,                    0x00},
	{WCD_USBSS_LUT_REG60,                    0x00},
	{WCD_USBSS_LUT_REG61,                    0x00},
	{WCD_USBSS_LUT_REG62,                    0x00},
	{WCD_USBSS_LUT_REG63,                    0x00},
	{WCD_USBSS_LUT_REG64,                    0x00},
	{WCD_USBSS_LUT_REG65,                    0x00},
	{WCD_USBSS_LUT_REG66,                    0x00},
	{WCD_USBSS_LUT_REG67,                    0x00},
	{WCD_USBSS_LUT_REG68,                    0x00},
	{WCD_USBSS_LUT_REG69,                    0x00},
	{WCD_USBSS_LUT_REG70,                    0x00},
	{WCD_USBSS_LUT_REG71,                    0x00},
	{WCD_USBSS_LUT_REG72,                    0x00},
	{WCD_USBSS_LUT_REG73,                    0x00},
	{WCD_USBSS_LUT_REG74,                    0x00},
	{WCD_USBSS_LUT_REG75,                    0x00},
	{WCD_USBSS_LUT_REG76,                    0x00},
	{WCD_USBSS_LUT_REG77,                    0x00},
	{WCD_USBSS_LUT_REG78,                    0x00},
	{WCD_USBSS_LUT_REG79,                    0x00},
	{WCD_USBSS_LUT_REG80,                    0x00},
	{WCD_USBSS_LUT_REG81,                    0x00},
	{WCD_USBSS_LUT_REG82,                    0x00},
	{WCD_USBSS_LUT_REG83,                    0x00},
	{WCD_USBSS_LUT_REG84,                    0x00},
	{WCD_USBSS_LUT_REG85,                    0x00},
	{WCD_USBSS_LUT_REG86,                    0x00},
	{WCD_USBSS_LUT_REG87,                    0x00},
	{WCD_USBSS_LUT_REG88,                    0x00},
	{WCD_USBSS_LUT_REG89,                    0x00},
	{WCD_USBSS_LUT_REG90,                    0x00},
	{WCD_USBSS_LUT_REG91,                    0x00},
	{WCD_USBSS_LUT_REG92,                    0x00},
	{WCD_USBSS_LUT_REG93,                    0x00},
	{WCD_USBSS_LUT_REG94,                    0x00},
	{WCD_USBSS_LUT_REG95,                    0x00},
	{WCD_USBSS_LUT_REG96,                    0x00},
	{WCD_USBSS_LUT_REG97,                    0x00},
	{WCD_USBSS_LUT_REG98,                    0x00},
	{WCD_USBSS_LUT_REG99,                    0x00},
	{WCD_USBSS_LUT_REG100,                   0x00},
	{WCD_USBSS_LUT_REG101,                   0x00},
	{WCD_USBSS_LUT_REG102,                   0x00},
	{WCD_USBSS_LUT_REG103,                   0x00},
	{WCD_USBSS_LUT_REG104,                   0x00},
	{WCD_USBSS_LUT_REG105,                   0x00},
	{WCD_USBSS_LUT_REG106,                   0x00},
	{WCD_USBSS_LUT_REG107,                   0x00},
	{WCD_USBSS_LUT_REG108,                   0x00},
	{WCD_USBSS_LUT_REG109,                   0x00},
	{WCD_USBSS_LUT_REG110,                   0x00},
	{WCD_USBSS_LUT_REG111,                   0x00},
	{WCD_USBSS_LUT_REG112,                   0x00},
	{WCD_USBSS_LUT_REG113,                   0x00},
	{WCD_USBSS_LUT_REG114,                   0x00},
	{WCD_USBSS_LUT_REG115,                   0x00},
	{WCD_USBSS_LUT_REG116,                   0x00},
	{WCD_USBSS_LUT_REG117,                   0x00},
	{WCD_USBSS_LUT_REG118,                   0x00},
	{WCD_USBSS_LUT_REG119,                   0x00},
	{WCD_USBSS_LUT_REG120,                   0x00},
	{WCD_USBSS_LUT_REG121,                   0x00},
	{WCD_USBSS_LUT_REG122,                   0x00},
	{WCD_USBSS_LUT_REG123,                   0x00},
	{WCD_USBSS_LUT_REG124,                   0x00},
	{WCD_USBSS_LUT_REG125,                   0x00},
	{WCD_USBSS_LUT_REG126,                   0x00},
	{WCD_USBSS_LUT_REG127,                   0x00},
	{WCD_USBSS_LUT_REG128,                   0x00},
	{WCD_USBSS_LUT_REG129,                   0x00},
	{WCD_USBSS_LUT_REG130,                   0x00},
	{WCD_USBSS_LUT_REG131,                   0x00},
	{WCD_USBSS_LUT_REG132,                   0x00},
	{WCD_USBSS_LUT_REG133,                   0x00},
	{WCD_USBSS_LUT_REG134,                   0x00},
	{WCD_USBSS_LUT_REG135,                   0x00},
	{WCD_USBSS_LUT_REG136,                   0x00},
	{WCD_USBSS_LUT_REG137,                   0x00},
	{WCD_USBSS_LUT_REG138,                   0x00},
	{WCD_USBSS_LUT_REG139,                   0x00},
	{WCD_USBSS_LUT_REG140,                   0x00},
	{WCD_USBSS_LUT_REG141,                   0x00},
	{WCD_USBSS_LUT_REG142,                   0x00},
	{WCD_USBSS_LUT_REG143,                   0x00},
	{WCD_USBSS_LUT_REG144,                   0x00},
	{WCD_USBSS_LUT_REG145,                   0x00},
	{WCD_USBSS_LUT_REG146,                   0x00},
	{WCD_USBSS_LUT_REG147,                   0x00},
	{WCD_USBSS_LUT_REG148,                   0x00},
	{WCD_USBSS_LUT_REG149,                   0x00},
	{WCD_USBSS_LUT_REG150,                   0x00},
	{WCD_USBSS_LUT_REG151,                   0x00},
	{WCD_USBSS_LUT_REG152,                   0x00},
	{WCD_USBSS_LUT_REG153,                   0x00},
	{WCD_USBSS_LUT_REG154,                   0x00},
	{WCD_USBSS_LUT_REG155,                   0x00},
	{WCD_USBSS_LUT_REG156,                   0x00},
	{WCD_USBSS_LUT_REG157,                   0x00},
	{WCD_USBSS_LUT_REG158,                   0x00},
	{WCD_USBSS_LUT_REG159,                   0x00},
	{WCD_USBSS_LUT_REG160,                   0x00},
	{WCD_USBSS_LUT_REG161,                   0x00},
	{WCD_USBSS_LUT_REG162,                   0x00},
	{WCD_USBSS_LUT_REG163,                   0x00},
	{WCD_USBSS_LUT_REG164,                   0x00},
	{WCD_USBSS_LUT_REG165,                   0x00},
	{WCD_USBSS_LUT_REG166,                   0x00},
	{WCD_USBSS_LUT_REG167,                   0x00},
	{WCD_USBSS_LUT_REG168,                   0x00},
	{WCD_USBSS_LUT_REG169,                   0x00},
	{WCD_USBSS_LUT_REG170,                   0x00},
	{WCD_USBSS_LUT_REG171,                   0x00},
	{WCD_USBSS_LUT_REG172,                   0x00},
	{WCD_USBSS_LUT_REG173,                   0x00},
	{WCD_USBSS_LUT_REG174,                   0x00},
	{WCD_USBSS_LUT_REG175,                   0x00},
	{WCD_USBSS_LUT_REG176,                   0x00},
	{WCD_USBSS_LUT_REG177,                   0x00},
	{WCD_USBSS_LUT_REG178,                   0x00},
	{WCD_USBSS_LUT_REG179,                   0x00},
	{WCD_USBSS_LUT_REG180,                   0x00},
	{WCD_USBSS_LUT_REG181,                   0x00},
	{WCD_USBSS_LUT_REG182,                   0x00},
	{WCD_USBSS_LUT_REG183,                   0x00},
	{WCD_USBSS_LUT_REG184,                   0x00},
	{WCD_USBSS_LUT_REG185,                   0x00},
	{WCD_USBSS_LUT_REG186,                   0x00},
	{WCD_USBSS_LUT_REG187,                   0x00},
	{WCD_USBSS_LUT_REG188,                   0x00},
	{WCD_USBSS_LUT_REG189,                   0x00},
	{WCD_USBSS_LUT_REG190,                   0x00},
	{WCD_USBSS_LUT_REG191,                   0x00},
	{WCD_USBSS_LUT_REG192,                   0x00},
	{WCD_USBSS_LUT_REG193,                   0x00},
	{WCD_USBSS_LUT_REG194,                   0x00},
	{WCD_USBSS_LUT_REG195,                   0x00},
	{WCD_USBSS_LUT_REG196,                   0x00},
	{WCD_USBSS_LUT_REG197,                   0x00},
	{WCD_USBSS_LUT_REG198,                   0x00},
	{WCD_USBSS_LUT_REG199,                   0x00},
	{WCD_USBSS_LUT_REG200,                   0x00},
	{WCD_USBSS_LUT_REG201,                   0x00},
	{WCD_USBSS_LUT_REG202,                   0x00},
	{WCD_USBSS_LUT_REG203,                   0x00},
	{WCD_USBSS_LUT_REG204,                   0x00},
	{WCD_USBSS_LUT_REG205,                   0x00},
	{WCD_USBSS_LUT_REG206,                   0x00},
	{WCD_USBSS_LUT_REG207,                   0x00},
	{WCD_USBSS_LUT_REG208,                   0x00},
	{WCD_USBSS_LUT_REG209,                   0x00},
	{WCD_USBSS_LUT_REG210,                   0x00},
	{WCD_USBSS_DATA_SEL,                     0x2b},
	{WCD_USBSS_OFF3,                         0x00},
	{WCD_USBSS_OFF2_LSB,                     0x78},
	{WCD_USBSS_OFF2_MSB,                     0x01},
	{WCD_USBSS_OFF1_LSB,                     0x7f},
	{WCD_USBSS_OFF1_MSB,                     0x01},
	{WCD_USBSS_AUD_L,                        0x00},
	{WCD_USBSS_AUD_R,                        0x00},
	{WCD_USBSS_GND_L,                        0x00},
	{WCD_USBSS_GND_R,                        0x00},
	{WCD_USBSS_USB_DIG_PAGE,                 0x00},
	{WCD_USBSS_OVP_STATUS_SELF_CLEARING,     0x00},
	{WCD_USBSS_OVP_STATUS,                   0x00},
	{WCD_USBSS_SWITCH_SETTINGS_ENABLE,       0x98},
	{WCD_USBSS_SWITCH_SELECT0,               0x14},
	{WCD_USBSS_SWITCH_SELECT1,               0x00},
	{WCD_USBSS_SWITCH_STATUS0,               0x00},
	{WCD_USBSS_SWITCH_STATUS1,               0x00},
	{WCD_USBSS_AUD_LEFT_SW_SLOW,             0x01},
	{WCD_USBSS_AUD_RIGHT_SW_SLOW,            0x01},
	{WCD_USBSS_AUD_MIC_SW_SLOW,              0x01},
	{WCD_USBSS_AUD_SENSE_SW_SLOW,            0x01},
	{WCD_USBSS_AUD_GND_SW_SLOW,              0x01},
	{WCD_USBSS_DELAY_R_SW,                   0x00},
	{WCD_USBSS_DELAY_MIC_SW,                 0x00},
	{WCD_USBSS_DELAY_SENSE_SW,               0x00},
	{WCD_USBSS_DELAY_GND_SW,                 0x00},
	{WCD_USBSS_DELAY_L_SW,                   0x00},
	{WCD_USBSS_EXT_FET_ENABLE_DELAY,         0x0f},
	{WCD_USBSS_FUNCTION_ENABLE,              0x01},
	{WCD_USBSS_USB_RST_CTL,                  0x03},
	{WCD_USBSS_EQUALIZER1,                   0xc0},
	{WCD_USBSS_SPARE_0,                      0x00},
	{WCD_USBSS_DIG_FUNCTIONS_STATUS,         0x00},
	{WCD_USBSS_CLK_SOURCE,                   0x00},
	{WCD_USBSS_USB_SS_CNTL,                  0x0d},
	{WCD_USBSS_SPARE_1,                      0x00},
	{WCD_USBSS_ANA_FUNCTIONS_STATUS,         0x00},
	{WCD_USBSS_FSM_STATUS,                   0x00},
	{WCD_USBSS_SPARE_14,                     0x00},
	{WCD_USBSS_SAFE_STATE_PD_DPAUX,          0x00},
	{WCD_USBSS_AUDIO_FSM_START,              0x00},
	{WCD_USBSS_FSM_RESET,                    0x00},
	{WCD_USBSS_CHIP_ID0,                     0x00},
	{WCD_USBSS_CHIP_ID1,                     0x00},
	{WCD_USBSS_CHIP_ID2,                     0x01},
	{WCD_USBSS_CHIP_ID3,                     0x03},
	{WCD_USBSS_LINEARIZER_CFG,               0x00},
	{WCD_USBSS_RATIO_SPKR_REXT_L_LSB,        0x8f},
	{WCD_USBSS_RATIO_SPKR_REXT_L_MSB,        0x02},
	{WCD_USBSS_RATIO_SPKR_REXT_R_LSB,        0x8f},
	{WCD_USBSS_RATIO_SPKR_REXT_R_MSB,        0x02},
	{WCD_USBSS_SW_TAP_AUD_L_LSB,             0xd4},
	{WCD_USBSS_SW_TAP_AUD_L_MSB,             0x03},
	{WCD_USBSS_SW_TAP_AUD_R_LSB,             0xd4},
	{WCD_USBSS_SW_TAP_AUD_R_MSB,             0x03},
	{WCD_USBSS_SW_TAP_GND_L_LSB,             0x11},
	{WCD_USBSS_SW_TAP_GND_L_MSB,             0x00},
	{WCD_USBSS_SW_TAP_GND_R_LSB,             0x11},
	{WCD_USBSS_SW_TAP_GND_R_MSB,             0x00},
	{WCD_USBSS_HW_TAP_AUD_L_LSB,             0x00},
	{WCD_USBSS_HW_TAP_AUD_L_MSB,             0x00},
	{WCD_USBSS_HW_TAP_AUD_R_LSB,             0x00},
	{WCD_USBSS_HW_TAP_AUD_R_MSB,             0x00},
	{WCD_USBSS_HW_TAP_GND_L_LSB,             0x00},
	{WCD_USBSS_HW_TAP_GND_L_MSB,             0x00},
	{WCD_USBSS_HW_TAP_GND_R_LSB,             0x00},
	{WCD_USBSS_HW_TAP_GND_R_MSB,             0x00},
	{WCD_USBSS_AUD_COEF_L_K0_0,              0xd3},
	{WCD_USBSS_AUD_COEF_L_K0_1,              0x9e},
	{WCD_USBSS_AUD_COEF_L_K0_2,              0x3f},
	{WCD_USBSS_AUD_COEF_L_K1_0,              0x15},
	{WCD_USBSS_AUD_COEF_L_K1_1,              0xfd},
	{WCD_USBSS_AUD_COEF_L_K2_0,              0x7a},
	{WCD_USBSS_AUD_COEF_L_K2_1,              0x05},
	{WCD_USBSS_AUD_COEF_L_K3_0,              0x6e},
	{WCD_USBSS_AUD_COEF_L_K3_1,              0xf5},
	{WCD_USBSS_AUD_COEF_L_K4_0,              0xd1},
	{WCD_USBSS_AUD_COEF_L_K4_1,              0x0e},
	{WCD_USBSS_AUD_COEF_L_K5_0,              0x24},
	{WCD_USBSS_AUD_COEF_L_K5_1,              0xf6},
	{WCD_USBSS_AUD_COEF_R_K0_0,              0xd3},
	{WCD_USBSS_AUD_COEF_R_K0_1,              0x9e},
	{WCD_USBSS_AUD_COEF_R_K0_2,              0x3f},
	{WCD_USBSS_AUD_COEF_R_K1_0,              0x15},
	{WCD_USBSS_AUD_COEF_R_K1_1,              0xfd},
	{WCD_USBSS_AUD_COEF_R_K2_0,              0x7a},
	{WCD_USBSS_AUD_COEF_R_K2_1,              0x05},
	{WCD_USBSS_AUD_COEF_R_K3_0,              0x6e},
	{WCD_USBSS_AUD_COEF_R_K3_1,              0xf5},
	{WCD_USBSS_AUD_COEF_R_K4_0,              0xd1},
	{WCD_USBSS_AUD_COEF_R_K4_1,              0x0e},
	{WCD_USBSS_AUD_COEF_R_K5_0,              0x24},
	{WCD_USBSS_AUD_COEF_R_K5_1,              0xf6},
	{WCD_USBSS_GND_COEF_L_K0_0,              0xf4},
	{WCD_USBSS_GND_COEF_L_K0_1,              0x30},
	{WCD_USBSS_GND_COEF_L_K0_2,              0x00},
	{WCD_USBSS_GND_COEF_L_K1_0,              0xe9},
	{WCD_USBSS_GND_COEF_L_K1_1,              0x02},
	{WCD_USBSS_GND_COEF_L_K2_0,              0xe7},
	{WCD_USBSS_GND_COEF_L_K2_1,              0xf7},
	{WCD_USBSS_GND_COEF_L_K3_0,              0x7a},
	{WCD_USBSS_GND_COEF_L_K3_1,              0x12},
	{WCD_USBSS_GND_COEF_L_K4_0,              0x72},
	{WCD_USBSS_GND_COEF_L_K4_1,              0xe4},
	{WCD_USBSS_GND_COEF_L_K5_0,              0xa0},
	{WCD_USBSS_GND_COEF_L_K5_1,              0x12},
	{WCD_USBSS_GND_COEF_R_K0_0,              0xf4},
	{WCD_USBSS_GND_COEF_R_K0_1,              0x30},
	{WCD_USBSS_GND_COEF_R_K0_2,              0x00},
	{WCD_USBSS_GND_COEF_R_K1_0,              0xe9},
	{WCD_USBSS_GND_COEF_R_K1_1,              0x02},
	{WCD_USBSS_GND_COEF_R_K2_0,              0xe7},
	{WCD_USBSS_GND_COEF_R_K2_1,              0xf7},
	{WCD_USBSS_GND_COEF_R_K3_0,              0x7a},
	{WCD_USBSS_GND_COEF_R_K3_1,              0x12},
	{WCD_USBSS_GND_COEF_R_K4_0,              0x72},
	{WCD_USBSS_GND_COEF_R_K4_1,              0xe4},
	{WCD_USBSS_GND_COEF_R_K5_0,              0xa0},
	{WCD_USBSS_GND_COEF_R_K5_1,              0x12},
	{WCD_USBSS_AUD_L_SLOPE_SCALE_LSB,        0xe8},
	{WCD_USBSS_AUD_L_SLOPE_SCALE_MSB,        0x03},
	{WCD_USBSS_AUD_R_SLOPE_SCALE_LSB,        0xe8},
	{WCD_USBSS_AUD_R_SLOPE_SCALE_MSB,        0x03},
	{WCD_USBSS_GND_L_SLOPE_SCALE_LSB,        0xe8},
	{WCD_USBSS_GND_L_SLOPE_SCALE_MSB,        0x03},
	{WCD_USBSS_GND_R_SLOPE_SCALE_LSB,        0xe8},
	{WCD_USBSS_GND_R_SLOPE_SCALE_MSB,        0x03},
	{WCD_USBSS_AUD_L_FIRST_TAP,              0x00},
	{WCD_USBSS_AUD_R_FIRST_TAP,              0x00},
	{WCD_USBSS_GND_L_FIRST_TAP,              0x00},
	{WCD_USBSS_GND_R_FIRST_TAP,              0x00},
	{WCD_USBSS_FEATURE_SELECTION,            0x00},
	{WCD_USBSS_EFUSE_REG_0,                  0x00},
	{WCD_USBSS_EFUSE_REG_1,                  0x00},
	{WCD_USBSS_EFUSE_REG_2,                  0x00},
	{WCD_USBSS_EFUSE_REG_3,                  0x00},
	{WCD_USBSS_EFUSE_REG_4,                  0x00},
	{WCD_USBSS_EFUSE_REG_5,                  0x00},
	{WCD_USBSS_EFUSE_REG_6,                  0x00},
	{WCD_USBSS_EFUSE_REG_7,                  0x00},
	{WCD_USBSS_EFUSE_REG_8,                  0x00},
	{WCD_USBSS_EFUSE_REG_9,                  0x00},
	{WCD_USBSS_EFUSE_REG_10,                 0x00},
	{WCD_USBSS_EFUSE_REG_11,                 0x00},
	{WCD_USBSS_EFUSE_REG_12,                 0x00},
	{WCD_USBSS_EFUSE_REG_13,                 0x00},
	{WCD_USBSS_EFUSE_REG_14,                 0x00},
	{WCD_USBSS_EFUSE_REG_15,                 0x00},
	{WCD_USBSS_EFUSE_PRG_CTL,                0x00},
};

static bool wcd_usbss_readable_register(struct device *dev, unsigned int reg)
{
	if (reg <= (WCD_USBSS_BASE + 1))
		return false;

	return wcd_usbss_reg_access[WCD_USBSS_REG(reg)] & RD_REG;
}

static bool wcd_usbss_writeable_register(struct device *dev, unsigned int reg)
{
	if (reg <= (WCD_USBSS_BASE + 1))
		return false;

	return wcd_usbss_reg_access[WCD_USBSS_REG(reg)] & WR_REG;
}

static bool wcd_usbss_volatile_register(struct device *dev, unsigned int reg)
{
	if (reg <= (WCD_USBSS_BASE + 1))
		return false;

	return ((wcd_usbss_reg_access[WCD_USBSS_REG(reg)] & RD_REG) &&
		!(wcd_usbss_reg_access[WCD_USBSS_REG(reg)] & WR_REG));
}

struct regmap_config wcd_usbss_regmap_config = {
	.reg_bits = 16,
	.val_bits = 8,
	.cache_type = REGCACHE_RBTREE,
	.reg_defaults = wcd_usbss_defaults,
	.num_reg_defaults = ARRAY_SIZE(wcd_usbss_defaults),
	.max_register = WCD_USBSS_MAX_REGISTER,
	.volatile_reg = wcd_usbss_volatile_register,
	.readable_reg = wcd_usbss_readable_register,
	.writeable_reg = wcd_usbss_writeable_register,
	.reg_format_endian = REGMAP_ENDIAN_NATIVE,
	.val_format_endian = REGMAP_ENDIAN_NATIVE,
	.use_single_read = true,
	.use_single_write = true,
};
