/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022-2023 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef WCD_USBSS_REGISTERS_H
#define WCD_USBSS_REGISTERS_H

enum {
	REG_NO_ACCESS,
	RD_REG,
	WR_REG,
	RD_WR_REG,
};

#define WCD_USBSS_BASE (-1)
#define WCD_USBSS_REG(reg)  (reg - WCD_USBSS_BASE - 1)

#define WCD_USBSS_PAGE0_BASE                   (WCD_USBSS_BASE+0x01)
#define WCD_USBSS_PAGE0_PAGE                   (WCD_USBSS_PAGE0_BASE+0x00)

#define WCD_USBSS_CP_BASE                      (WCD_USBSS_BASE+0x02)
#define WCD_USBSS_PMP_EN                       (WCD_USBSS_CP_BASE+0x00)
#define WCD_USBSS_PMP_OUT1                     (WCD_USBSS_CP_BASE+0x01)
#define WCD_USBSS_PMP_OUT2                     (WCD_USBSS_CP_BASE+0x02)
#define WCD_USBSS_PMP_CLK                      (WCD_USBSS_CP_BASE+0x03)
#define WCD_USBSS_PMP_MISC1                    (WCD_USBSS_CP_BASE+0x04)
#define WCD_USBSS_PMP_MISC2                    (WCD_USBSS_CP_BASE+0x05)

#define WCD_USBSS_RCO_BASE                     (WCD_USBSS_BASE+0x11)
#define WCD_USBSS_RCO_EN                       (WCD_USBSS_RCO_BASE+0x00)
#define WCD_USBSS_RCO_RST                      (WCD_USBSS_RCO_BASE+0x01)
#define WCD_USBSS_RCO_CLK                      (WCD_USBSS_RCO_BASE+0x02)
#define WCD_USBSS_RCO_IBIAS                    (WCD_USBSS_RCO_BASE+0x03)
#define WCD_USBSS_RCO_MISC1                    (WCD_USBSS_RCO_BASE+0x04)
#define WCD_USBSS_RCO_MISC2                    (WCD_USBSS_RCO_BASE+0x05)

#define WCD_USBSS_OVP_BASE                     (WCD_USBSS_BASE+0x1f)
#define WCD_USBSS_DP_EN                        (WCD_USBSS_OVP_BASE+0x00)
#define WCD_USBSS_DP_BIAS                      (WCD_USBSS_OVP_BASE+0x01)
#define WCD_USBSS_DP_DN_MISC1                  (WCD_USBSS_OVP_BASE+0x02)
#define WCD_USBSS_DN_EN                        (WCD_USBSS_OVP_BASE+0x03)
#define WCD_USBSS_DN_BIAS                      (WCD_USBSS_OVP_BASE+0x04)
#define WCD_USBSS_DP_DN_MISC2                  (WCD_USBSS_OVP_BASE+0x05)
#define WCD_USBSS_MG1_EN                       (WCD_USBSS_OVP_BASE+0x06)
#define WCD_USBSS_MG1_BIAS                     (WCD_USBSS_OVP_BASE+0x07)
#define WCD_USBSS_MG1_CTSNS_CTL                (WCD_USBSS_OVP_BASE+0x08)
#define WCD_USBSS_MG1_MISC                     (WCD_USBSS_OVP_BASE+0x09)
#define WCD_USBSS_MG2_EN                       (WCD_USBSS_OVP_BASE+0x0a)
#define WCD_USBSS_MG2_BIAS                     (WCD_USBSS_OVP_BASE+0x0b)
#define WCD_USBSS_MG2_CTSNS_CTL                (WCD_USBSS_OVP_BASE+0x0c)
#define WCD_USBSS_MG2_MISC                     (WCD_USBSS_OVP_BASE+0x0d)
#define WCD_USBSS_BIAS_TOP                     (WCD_USBSS_OVP_BASE+0x0e)
#define WCD_USBSS_VREF_CTRL                    (WCD_USBSS_OVP_BASE+0x0f)
#define WCD_USBSS_TOP_MISC1                    (WCD_USBSS_OVP_BASE+0x10)
#define WCD_USBSS_TOP_MISC2                    (WCD_USBSS_OVP_BASE+0x11)
#define WCD_USBSS_STATUS_1                     (WCD_USBSS_OVP_BASE+0x12)
#define WCD_USBSS_STATUS_2                     (WCD_USBSS_OVP_BASE+0x13)
#define WCD_USBSS_STATUS_3                     (WCD_USBSS_OVP_BASE+0x14)

#define WCD_USBSS_LINEARIZER_BASE              (WCD_USBSS_BASE+0x3e)
#define WCD_USBSS_EXT_LIN_EN                   (WCD_USBSS_LINEARIZER_BASE+0x00)
#define WCD_USBSS_INT_LIN_EN                   (WCD_USBSS_LINEARIZER_BASE+0x01)
#define WCD_USBSS_COMBINER_IREF_PROG_1         (WCD_USBSS_LINEARIZER_BASE+0x02)
#define WCD_USBSS_COMBINER_IREF_PROG_2         (WCD_USBSS_LINEARIZER_BASE+0x03)
#define WCD_USBSS_INTSW_BULK_CTRL              (WCD_USBSS_LINEARIZER_BASE+0x03)
#define WCD_USBSS_EXTSW_AMP_BIAS               (WCD_USBSS_LINEARIZER_BASE+0x04)
#define WCD_USBSS_INTSW_ILIFT                  (WCD_USBSS_LINEARIZER_BASE+0x05)
#define WCD_USBSS_EXT_SW_CTRL_1                (WCD_USBSS_LINEARIZER_BASE+0x06)
#define WCD_USBSS_EXT_SW_CTRL_2                (WCD_USBSS_LINEARIZER_BASE+0x07)
#define WCD_USBSS_INT_SW_CTRL_1                (WCD_USBSS_LINEARIZER_BASE+0x08)
#define WCD_USBSS_INT_SW_CTRL_2                (WCD_USBSS_LINEARIZER_BASE+0x09)
#define WCD_USBSS_INT_SW_CTRL_3                (WCD_USBSS_LINEARIZER_BASE+0x0a)
#define WCD_USBSS_ATEST_CTRL                   (WCD_USBSS_LINEARIZER_BASE+0x0b)
#define WCD_USBSS_EXT_LIN_AUD_CEQ_PRG          (WCD_USBSS_LINEARIZER_BASE+0x0c)
#define WCD_USBSS_EXT_LIN_GND_CEQ_PRG          (WCD_USBSS_LINEARIZER_BASE+0x0d)
#define WCD_USBSS_LIN_STATUS_1                 (WCD_USBSS_LINEARIZER_BASE+0x0e)
#define WCD_USBSS_LIN_STATUS_2                 (WCD_USBSS_LINEARIZER_BASE+0x0f)
#define WCD_USBSS_LIN_STATUS_3                 (WCD_USBSS_LINEARIZER_BASE+0x10)
#define WCD_USBSS_LIN_STATUS_4                 (WCD_USBSS_LINEARIZER_BASE+0x11)
#define WCD_USBSS_SW_LIN_CTRL                  (WCD_USBSS_LINEARIZER_BASE+0x12)
#define WCD_USBSS_SW_LIN_CTRL_1                (WCD_USBSS_LINEARIZER_BASE+0x13)

#define WCD_USBSS_NON_AUDIO_BASE               (WCD_USBSS_BASE+0x52)
#define WCD_USBSS_LDO_3P6                      (WCD_USBSS_NON_AUDIO_BASE+0x00)
#define WCD_USBSS_SWITCH_BANK_ATEST            (WCD_USBSS_NON_AUDIO_BASE+0x01)
#define WCD_USBSS_EQ_EN                        (WCD_USBSS_NON_AUDIO_BASE+0x02)
#define WCD_USBSS_EQ_MISC                      (WCD_USBSS_NON_AUDIO_BASE+0x03)
#define WCD_USBSS_STATUS_MISC                  (WCD_USBSS_NON_AUDIO_BASE+0x04)

#define WCD_USBSS_SEQUENCER_BASE               (WCD_USBSS_BASE+0x5b)
#define WCD_USBSS_FSM_DELAYS1                  (WCD_USBSS_SEQUENCER_BASE+0x00)
#define WCD_USBSS_FSM_DELAYS2                  (WCD_USBSS_SEQUENCER_BASE+0x01)
#define WCD_USBSS_FSM_DELAYS3                  (WCD_USBSS_SEQUENCER_BASE+0x02)
#define WCD_USBSS_FSM_DELAYS4                  (WCD_USBSS_SEQUENCER_BASE+0x03)
#define WCD_USBSS_FSM_DELAYS5                  (WCD_USBSS_SEQUENCER_BASE+0x04)
#define WCD_USBSS_FSM_DELAYS6                  (WCD_USBSS_SEQUENCER_BASE+0x05)
#define WCD_USBSS_FSM_DELAYS7                  (WCD_USBSS_SEQUENCER_BASE+0x06)
#define WCD_USBSS_FSM_DELAYS8                  (WCD_USBSS_SEQUENCER_BASE+0x07)
#define WCD_USBSS_FSM_DEBUG_SIGNALS            (WCD_USBSS_SEQUENCER_BASE+0x08)
#define WCD_USBSS_FSM_OVERRIDE                 (WCD_USBSS_SEQUENCER_BASE+0x09)
#define WCD_USBSS_ENABLE_STATUS                (WCD_USBSS_SEQUENCER_BASE+0x0a)
#define WCD_USBSS_FRZ_STATUS                   (WCD_USBSS_SEQUENCER_BASE+0x0b)

#define WCD_USBSS_USB_ANA_DIG_TOP_BASE         (WCD_USBSS_BASE+0x6c)
#define WCD_USBSS_DPR_DNL_SWITCH_ENABLE_STATUS (WCD_USBSS_USB_ANA_DIG_TOP_BASE+0x00)
#define WCD_USBSS_SBU_GSBU_SWITCH_ENABLE_STATUS (WCD_USBSS_USB_ANA_DIG_TOP_BASE+0x01)
#define WCD_USBSS_DPAUX_SWITCH_ENABLE_STATUS   (WCD_USBSS_USB_ANA_DIG_TOP_BASE+0x02)
#define WCD_USBSS_DPR_DNL_EXTFET_GATE_MUX_STATUS (WCD_USBSS_USB_ANA_DIG_TOP_BASE+0x03)
#define WCD_USBSS_SBU_EXTFET_GATE_MUX_OVP_STATUS (WCD_USBSS_USB_ANA_DIG_TOP_BASE+0x04)
#define WCD_USBSS_CP_LIN_CNTL_STATUS           (WCD_USBSS_USB_ANA_DIG_TOP_BASE+0x05)

#define WCD_USBSS_E_BASE                       (WCD_USBSS_BASE+0x81)
#define WCD_USBSS_DISP_AUXP_THRESH             (WCD_USBSS_E_BASE+0x00)
#define WCD_USBSS_DISP_AUXP_CTL                (WCD_USBSS_E_BASE+0x01)
#define WCD_USBSS_DISP_AUXM_THRESH             (WCD_USBSS_E_BASE+0x02)
#define WCD_USBSS_DISP_AUXM_CTL                (WCD_USBSS_E_BASE+0x03)

#define WCD_USBSS_USB_LDO_BASE                 (WCD_USBSS_BASE+0x87)
#define WCD_USBSS_CTRL_0                       (WCD_USBSS_USB_LDO_BASE+0x00)
#define WCD_USBSS_CTRL_1                       (WCD_USBSS_USB_LDO_BASE+0x01)

#define WCD_USBSS_LINEARIZER_BYPASS_CAL_BASE   (WCD_USBSS_BASE+0x91)
#define WCD_USBSS_DC_TRIMCODE_1                (WCD_USBSS_LINEARIZER_BYPASS_CAL_BASE+0x00)
#define WCD_USBSS_DC_TRIMCODE_2                (WCD_USBSS_LINEARIZER_BYPASS_CAL_BASE+0x01)
#define WCD_USBSS_DC_TRIMCODE_3                (WCD_USBSS_LINEARIZER_BYPASS_CAL_BASE+0x02)
#define WCD_USBSS_AC_TRIMCODE_1                (WCD_USBSS_LINEARIZER_BYPASS_CAL_BASE+0x03)
#define WCD_USBSS_AC_TRIMCODE_2                (WCD_USBSS_LINEARIZER_BYPASS_CAL_BASE+0x04)

#define WCD_USBSS_CP_LDO_BASE                  (WCD_USBSS_BASE+0xa1)
#define WCD_USBSS_CPLDO_CTL1                   (WCD_USBSS_CP_LDO_BASE+0x00)
#define WCD_USBSS_CPLDO_CTL2                   (WCD_USBSS_CP_LDO_BASE+0x01)

#define WCD_USBSS_LINEARIZER_CAL_BASE          (WCD_USBSS_BASE+0x101)
#define WCD_USBSS_LUT_REG0                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x01)
#define WCD_USBSS_LUT_REG1                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x02)
#define WCD_USBSS_LUT_REG2                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x03)
#define WCD_USBSS_LUT_REG3                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x04)
#define WCD_USBSS_LUT_REG4                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x05)
#define WCD_USBSS_LUT_REG5                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x06)
#define WCD_USBSS_LUT_REG6                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x07)
#define WCD_USBSS_LUT_REG7                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x08)
#define WCD_USBSS_LUT_REG8                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x09)
#define WCD_USBSS_LUT_REG9                     (WCD_USBSS_LINEARIZER_CAL_BASE+0x0a)
#define WCD_USBSS_LUT_REG10                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x0b)
#define WCD_USBSS_LUT_REG11                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x0c)
#define WCD_USBSS_LUT_REG12                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x0d)
#define WCD_USBSS_LUT_REG13                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x0e)
#define WCD_USBSS_LUT_REG14                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x0f)
#define WCD_USBSS_LUT_REG15                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x10)
#define WCD_USBSS_LUT_REG16                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x11)
#define WCD_USBSS_LUT_REG17                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x12)
#define WCD_USBSS_LUT_REG18                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x13)
#define WCD_USBSS_LUT_REG19                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x14)
#define WCD_USBSS_LUT_REG20                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x15)
#define WCD_USBSS_LUT_REG21                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x16)
#define WCD_USBSS_LUT_REG22                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x17)
#define WCD_USBSS_LUT_REG23                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x18)
#define WCD_USBSS_LUT_REG24                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x19)
#define WCD_USBSS_LUT_REG25                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x1a)
#define WCD_USBSS_LUT_REG26                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x1b)
#define WCD_USBSS_LUT_REG27                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x1c)
#define WCD_USBSS_LUT_REG28                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x1d)
#define WCD_USBSS_LUT_REG29                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x1e)
#define WCD_USBSS_LUT_REG30                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x1f)
#define WCD_USBSS_LUT_REG31                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x20)
#define WCD_USBSS_LUT_REG32                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x21)
#define WCD_USBSS_LUT_REG33                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x22)
#define WCD_USBSS_LUT_REG34                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x23)
#define WCD_USBSS_LUT_REG35                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x24)
#define WCD_USBSS_LUT_REG36                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x25)
#define WCD_USBSS_LUT_REG37                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x26)
#define WCD_USBSS_LUT_REG38                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x27)
#define WCD_USBSS_LUT_REG39                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x28)
#define WCD_USBSS_LUT_REG40                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x29)
#define WCD_USBSS_LUT_REG41                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x2a)
#define WCD_USBSS_LUT_REG42                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x2b)
#define WCD_USBSS_LUT_REG43                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x2c)
#define WCD_USBSS_LUT_REG44                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x2d)
#define WCD_USBSS_LUT_REG45                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x2e)
#define WCD_USBSS_LUT_REG46                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x2f)
#define WCD_USBSS_LUT_REG47                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x30)
#define WCD_USBSS_LUT_REG48                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x31)
#define WCD_USBSS_LUT_REG49                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x32)
#define WCD_USBSS_LUT_REG50                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x33)
#define WCD_USBSS_LUT_REG51                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x34)
#define WCD_USBSS_LUT_REG52                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x35)
#define WCD_USBSS_LUT_REG53                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x36)
#define WCD_USBSS_LUT_REG54                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x37)
#define WCD_USBSS_LUT_REG55                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x38)
#define WCD_USBSS_LUT_REG56                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x39)
#define WCD_USBSS_LUT_REG57                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x3a)
#define WCD_USBSS_LUT_REG58                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x3b)
#define WCD_USBSS_LUT_REG59                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x3c)
#define WCD_USBSS_LUT_REG60                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x3d)
#define WCD_USBSS_LUT_REG61                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x3e)
#define WCD_USBSS_LUT_REG62                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x3f)
#define WCD_USBSS_LUT_REG63                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x40)
#define WCD_USBSS_LUT_REG64                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x41)
#define WCD_USBSS_LUT_REG65                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x42)
#define WCD_USBSS_LUT_REG66                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x43)
#define WCD_USBSS_LUT_REG67                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x44)
#define WCD_USBSS_LUT_REG68                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x45)
#define WCD_USBSS_LUT_REG69                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x46)
#define WCD_USBSS_LUT_REG70                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x47)
#define WCD_USBSS_LUT_REG71                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x48)
#define WCD_USBSS_LUT_REG72                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x49)
#define WCD_USBSS_LUT_REG73                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x4a)
#define WCD_USBSS_LUT_REG74                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x4b)
#define WCD_USBSS_LUT_REG75                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x4c)
#define WCD_USBSS_LUT_REG76                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x4d)
#define WCD_USBSS_LUT_REG77                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x4e)
#define WCD_USBSS_LUT_REG78                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x4f)
#define WCD_USBSS_LUT_REG79                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x50)
#define WCD_USBSS_LUT_REG80                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x51)
#define WCD_USBSS_LUT_REG81                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x52)
#define WCD_USBSS_LUT_REG82                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x53)
#define WCD_USBSS_LUT_REG83                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x54)
#define WCD_USBSS_LUT_REG84                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x55)
#define WCD_USBSS_LUT_REG85                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x56)
#define WCD_USBSS_LUT_REG86                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x57)
#define WCD_USBSS_LUT_REG87                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x58)
#define WCD_USBSS_LUT_REG88                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x59)
#define WCD_USBSS_LUT_REG89                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x5a)
#define WCD_USBSS_LUT_REG90                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x5b)
#define WCD_USBSS_LUT_REG91                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x5c)
#define WCD_USBSS_LUT_REG92                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x5d)
#define WCD_USBSS_LUT_REG93                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x5e)
#define WCD_USBSS_LUT_REG94                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x5f)
#define WCD_USBSS_LUT_REG95                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x60)
#define WCD_USBSS_LUT_REG96                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x61)
#define WCD_USBSS_LUT_REG97                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x62)
#define WCD_USBSS_LUT_REG98                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x63)
#define WCD_USBSS_LUT_REG99                    (WCD_USBSS_LINEARIZER_CAL_BASE+0x64)
#define WCD_USBSS_LUT_REG100                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x65)
#define WCD_USBSS_LUT_REG101                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x66)
#define WCD_USBSS_LUT_REG102                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x67)
#define WCD_USBSS_LUT_REG103                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x68)
#define WCD_USBSS_LUT_REG104                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x69)
#define WCD_USBSS_LUT_REG105                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x6a)
#define WCD_USBSS_LUT_REG106                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x6b)
#define WCD_USBSS_LUT_REG107                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x6c)
#define WCD_USBSS_LUT_REG108                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x6d)
#define WCD_USBSS_LUT_REG109                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x6e)
#define WCD_USBSS_LUT_REG110                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x6f)
#define WCD_USBSS_LUT_REG111                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x70)
#define WCD_USBSS_LUT_REG112                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x71)
#define WCD_USBSS_LUT_REG113                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x72)
#define WCD_USBSS_LUT_REG114                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x73)
#define WCD_USBSS_LUT_REG115                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x74)
#define WCD_USBSS_LUT_REG116                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x75)
#define WCD_USBSS_LUT_REG117                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x76)
#define WCD_USBSS_LUT_REG118                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x77)
#define WCD_USBSS_LUT_REG119                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x78)
#define WCD_USBSS_LUT_REG120                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x79)
#define WCD_USBSS_LUT_REG121                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x7a)
#define WCD_USBSS_LUT_REG122                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x7b)
#define WCD_USBSS_LUT_REG123                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x7c)
#define WCD_USBSS_LUT_REG124                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x7d)
#define WCD_USBSS_LUT_REG125                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x7e)
#define WCD_USBSS_LUT_REG126                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x7f)
#define WCD_USBSS_LUT_REG127                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x80)
#define WCD_USBSS_LUT_REG128                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x81)
#define WCD_USBSS_LUT_REG129                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x82)
#define WCD_USBSS_LUT_REG130                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x83)
#define WCD_USBSS_LUT_REG131                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x84)
#define WCD_USBSS_LUT_REG132                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x85)
#define WCD_USBSS_LUT_REG133                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x86)
#define WCD_USBSS_LUT_REG134                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x87)
#define WCD_USBSS_LUT_REG135                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x88)
#define WCD_USBSS_LUT_REG136                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x89)
#define WCD_USBSS_LUT_REG137                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x8a)
#define WCD_USBSS_LUT_REG138                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x8b)
#define WCD_USBSS_LUT_REG139                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x8c)
#define WCD_USBSS_LUT_REG140                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x8d)
#define WCD_USBSS_LUT_REG141                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x8e)
#define WCD_USBSS_LUT_REG142                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x8f)
#define WCD_USBSS_LUT_REG143                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x90)
#define WCD_USBSS_LUT_REG144                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x91)
#define WCD_USBSS_LUT_REG145                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x92)
#define WCD_USBSS_LUT_REG146                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x93)
#define WCD_USBSS_LUT_REG147                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x94)
#define WCD_USBSS_LUT_REG148                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x95)
#define WCD_USBSS_LUT_REG149                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x96)
#define WCD_USBSS_LUT_REG150                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x97)
#define WCD_USBSS_LUT_REG151                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x98)
#define WCD_USBSS_LUT_REG152                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x99)
#define WCD_USBSS_LUT_REG153                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x9a)
#define WCD_USBSS_LUT_REG154                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x9b)
#define WCD_USBSS_LUT_REG155                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x9c)
#define WCD_USBSS_LUT_REG156                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x9d)
#define WCD_USBSS_LUT_REG157                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x9e)
#define WCD_USBSS_LUT_REG158                   (WCD_USBSS_LINEARIZER_CAL_BASE+0x9f)
#define WCD_USBSS_LUT_REG159                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa0)
#define WCD_USBSS_LUT_REG160                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa1)
#define WCD_USBSS_LUT_REG161                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa2)
#define WCD_USBSS_LUT_REG162                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa3)
#define WCD_USBSS_LUT_REG163                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa4)
#define WCD_USBSS_LUT_REG164                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa5)
#define WCD_USBSS_LUT_REG165                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa6)
#define WCD_USBSS_LUT_REG166                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa7)
#define WCD_USBSS_LUT_REG167                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa8)
#define WCD_USBSS_LUT_REG168                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xa9)
#define WCD_USBSS_LUT_REG169                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xaa)
#define WCD_USBSS_LUT_REG170                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xab)
#define WCD_USBSS_LUT_REG171                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xac)
#define WCD_USBSS_LUT_REG172                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xad)
#define WCD_USBSS_LUT_REG173                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xae)
#define WCD_USBSS_LUT_REG174                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xaf)
#define WCD_USBSS_LUT_REG175                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb0)
#define WCD_USBSS_LUT_REG176                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb1)
#define WCD_USBSS_LUT_REG177                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb2)
#define WCD_USBSS_LUT_REG178                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb3)
#define WCD_USBSS_LUT_REG179                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb4)
#define WCD_USBSS_LUT_REG180                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb5)
#define WCD_USBSS_LUT_REG181                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb6)
#define WCD_USBSS_LUT_REG182                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb7)
#define WCD_USBSS_LUT_REG183                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb8)
#define WCD_USBSS_LUT_REG184                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xb9)
#define WCD_USBSS_LUT_REG185                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xba)
#define WCD_USBSS_LUT_REG186                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xbb)
#define WCD_USBSS_LUT_REG187                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xbc)
#define WCD_USBSS_LUT_REG188                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xbd)
#define WCD_USBSS_LUT_REG189                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xbe)
#define WCD_USBSS_LUT_REG190                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xbf)
#define WCD_USBSS_LUT_REG191                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc0)
#define WCD_USBSS_LUT_REG192                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc1)
#define WCD_USBSS_LUT_REG193                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc2)
#define WCD_USBSS_LUT_REG194                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc3)
#define WCD_USBSS_LUT_REG195                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc4)
#define WCD_USBSS_LUT_REG196                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc5)
#define WCD_USBSS_LUT_REG197                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc6)
#define WCD_USBSS_LUT_REG198                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc7)
#define WCD_USBSS_LUT_REG199                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc8)
#define WCD_USBSS_LUT_REG200                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xc9)
#define WCD_USBSS_LUT_REG201                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xca)
#define WCD_USBSS_LUT_REG202                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xcb)
#define WCD_USBSS_LUT_REG203                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xcc)
#define WCD_USBSS_LUT_REG204                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xcd)
#define WCD_USBSS_LUT_REG205                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xce)
#define WCD_USBSS_LUT_REG206                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xcf)
#define WCD_USBSS_LUT_REG207                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xd0)
#define WCD_USBSS_LUT_REG208                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xd1)
#define WCD_USBSS_LUT_REG209                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xd2)
#define WCD_USBSS_LUT_REG210                   (WCD_USBSS_LINEARIZER_CAL_BASE+0xd3)
#define WCD_USBSS_DATA_SEL                     (WCD_USBSS_LINEARIZER_CAL_BASE+0xf6)
#define WCD_USBSS_OFF3                         (WCD_USBSS_LINEARIZER_CAL_BASE+0xf7)
#define WCD_USBSS_OFF2_LSB                     (WCD_USBSS_LINEARIZER_CAL_BASE+0xf8)
#define WCD_USBSS_OFF2_MSB                     (WCD_USBSS_LINEARIZER_CAL_BASE+0xf9)
#define WCD_USBSS_OFF1_LSB                     (WCD_USBSS_LINEARIZER_CAL_BASE+0xfa)
#define WCD_USBSS_OFF1_MSB                     (WCD_USBSS_LINEARIZER_CAL_BASE+0xfb)
#define WCD_USBSS_AUD_L                        (WCD_USBSS_LINEARIZER_CAL_BASE+0xfc)
#define WCD_USBSS_AUD_R                        (WCD_USBSS_LINEARIZER_CAL_BASE+0xfd)
#define WCD_USBSS_GND_L                        (WCD_USBSS_LINEARIZER_CAL_BASE+0xfe)
#define WCD_USBSS_GND_R                        (WCD_USBSS_LINEARIZER_CAL_BASE+0xff)

#define WCD_USBSS_USB_DIG_BASE                 (WCD_USBSS_BASE+0x401)
#define WCD_USBSS_USB_DIG_PAGE                 (WCD_USBSS_USB_DIG_BASE+0x00)
#define WCD_USBSS_OVP_STATUS_SELF_CLEARING     (WCD_USBSS_USB_DIG_BASE+0x01)
#define WCD_USBSS_OVP_STATUS                   (WCD_USBSS_USB_DIG_BASE+0x02)
#define WCD_USBSS_SWITCH_SETTINGS_ENABLE       (WCD_USBSS_USB_DIG_BASE+0x03)
#define WCD_USBSS_SWITCH_SELECT0               (WCD_USBSS_USB_DIG_BASE+0x04)
#define WCD_USBSS_SWITCH_SELECT1               (WCD_USBSS_USB_DIG_BASE+0x05)
#define WCD_USBSS_SWITCH_STATUS0               (WCD_USBSS_USB_DIG_BASE+0x06)
#define WCD_USBSS_SWITCH_STATUS1               (WCD_USBSS_USB_DIG_BASE+0x07)
#define WCD_USBSS_AUD_LEFT_SW_SLOW             (WCD_USBSS_USB_DIG_BASE+0x08)
#define WCD_USBSS_AUD_RIGHT_SW_SLOW            (WCD_USBSS_USB_DIG_BASE+0x09)
#define WCD_USBSS_AUD_MIC_SW_SLOW              (WCD_USBSS_USB_DIG_BASE+0x0a)
#define WCD_USBSS_AUD_SENSE_SW_SLOW            (WCD_USBSS_USB_DIG_BASE+0x0b)
#define WCD_USBSS_AUD_GND_SW_SLOW              (WCD_USBSS_USB_DIG_BASE+0x0c)
#define WCD_USBSS_DELAY_R_SW                   (WCD_USBSS_USB_DIG_BASE+0x0d)
#define WCD_USBSS_DELAY_MIC_SW                 (WCD_USBSS_USB_DIG_BASE+0x0e)
#define WCD_USBSS_DELAY_SENSE_SW               (WCD_USBSS_USB_DIG_BASE+0x0f)
#define WCD_USBSS_DELAY_GND_SW                 (WCD_USBSS_USB_DIG_BASE+0x10)
#define WCD_USBSS_DELAY_L_SW                   (WCD_USBSS_USB_DIG_BASE+0x11)
#define WCD_USBSS_EXT_FET_ENABLE_DELAY         (WCD_USBSS_USB_DIG_BASE+0x12)
#define WCD_USBSS_FUNCTION_ENABLE              (WCD_USBSS_USB_DIG_BASE+0x13)
#define WCD_USBSS_USB_RST_CTL                  (WCD_USBSS_USB_DIG_BASE+0x14)
#define WCD_USBSS_EQUALIZER1                   (WCD_USBSS_USB_DIG_BASE+0x15)
#define WCD_USBSS_SPARE_0                      (WCD_USBSS_USB_DIG_BASE+0x16)
#define WCD_USBSS_DIG_FUNCTIONS_STATUS         (WCD_USBSS_USB_DIG_BASE+0x17)
#define WCD_USBSS_CLK_SOURCE                   (WCD_USBSS_USB_DIG_BASE+0x18)
#define WCD_USBSS_USB_SS_CNTL                  (WCD_USBSS_USB_DIG_BASE+0x19)
#define WCD_USBSS_SPARE_1                      (WCD_USBSS_USB_DIG_BASE+0x1a)
#define WCD_USBSS_ANA_FUNCTIONS_STATUS         (WCD_USBSS_USB_DIG_BASE+0x1b)
#define WCD_USBSS_FSM_STATUS                   (WCD_USBSS_USB_DIG_BASE+0x1c)
#define WCD_USBSS_SPARE_14                     (WCD_USBSS_USB_DIG_BASE+0x30)
#define WCD_USBSS_SAFE_STATE_PD_DPAUX          (WCD_USBSS_USB_DIG_BASE+0x32)
#define WCD_USBSS_AUDIO_FSM_START              (WCD_USBSS_USB_DIG_BASE+0x33)
#define WCD_USBSS_FSM_RESET                    (WCD_USBSS_USB_DIG_BASE+0x34)
#define WCD_USBSS_CHIP_ID0                     (WCD_USBSS_USB_DIG_BASE+0x38)
#define WCD_USBSS_CHIP_ID1                     (WCD_USBSS_USB_DIG_BASE+0x39)
#define WCD_USBSS_CHIP_ID2                     (WCD_USBSS_USB_DIG_BASE+0x3a)
#define WCD_USBSS_CHIP_ID3                     (WCD_USBSS_USB_DIG_BASE+0x3b)
#define WCD_USBSS_LINEARIZER_CFG               (WCD_USBSS_USB_DIG_BASE+0x60)
#define WCD_USBSS_RATIO_SPKR_REXT_L_LSB        (WCD_USBSS_USB_DIG_BASE+0x61)
#define WCD_USBSS_RATIO_SPKR_REXT_L_MSB        (WCD_USBSS_USB_DIG_BASE+0x62)
#define WCD_USBSS_RATIO_SPKR_REXT_R_LSB        (WCD_USBSS_USB_DIG_BASE+0x63)
#define WCD_USBSS_RATIO_SPKR_REXT_R_MSB        (WCD_USBSS_USB_DIG_BASE+0x64)
#define WCD_USBSS_SW_TAP_AUD_L_LSB             (WCD_USBSS_USB_DIG_BASE+0x65)
#define WCD_USBSS_SW_TAP_AUD_L_MSB             (WCD_USBSS_USB_DIG_BASE+0x66)
#define WCD_USBSS_SW_TAP_AUD_R_LSB             (WCD_USBSS_USB_DIG_BASE+0x67)
#define WCD_USBSS_SW_TAP_AUD_R_MSB             (WCD_USBSS_USB_DIG_BASE+0x68)
#define WCD_USBSS_SW_TAP_GND_L_LSB             (WCD_USBSS_USB_DIG_BASE+0x69)
#define WCD_USBSS_SW_TAP_GND_L_MSB             (WCD_USBSS_USB_DIG_BASE+0x6a)
#define WCD_USBSS_SW_TAP_GND_R_LSB             (WCD_USBSS_USB_DIG_BASE+0x6b)
#define WCD_USBSS_SW_TAP_GND_R_MSB             (WCD_USBSS_USB_DIG_BASE+0x6c)
#define WCD_USBSS_HW_TAP_AUD_L_LSB             (WCD_USBSS_USB_DIG_BASE+0x6d)
#define WCD_USBSS_HW_TAP_AUD_L_MSB             (WCD_USBSS_USB_DIG_BASE+0x6e)
#define WCD_USBSS_HW_TAP_AUD_R_LSB             (WCD_USBSS_USB_DIG_BASE+0x6f)
#define WCD_USBSS_HW_TAP_AUD_R_MSB             (WCD_USBSS_USB_DIG_BASE+0x70)
#define WCD_USBSS_HW_TAP_GND_L_LSB             (WCD_USBSS_USB_DIG_BASE+0x71)
#define WCD_USBSS_HW_TAP_GND_L_MSB             (WCD_USBSS_USB_DIG_BASE+0x72)
#define WCD_USBSS_HW_TAP_GND_R_LSB             (WCD_USBSS_USB_DIG_BASE+0x73)
#define WCD_USBSS_HW_TAP_GND_R_MSB             (WCD_USBSS_USB_DIG_BASE+0x74)
#define WCD_USBSS_AUD_COEF_L_K0_0              (WCD_USBSS_USB_DIG_BASE+0x75)
#define WCD_USBSS_AUD_COEF_L_K0_1              (WCD_USBSS_USB_DIG_BASE+0x76)
#define WCD_USBSS_AUD_COEF_L_K0_2              (WCD_USBSS_USB_DIG_BASE+0x77)
#define WCD_USBSS_AUD_COEF_L_K1_0              (WCD_USBSS_USB_DIG_BASE+0x78)
#define WCD_USBSS_AUD_COEF_L_K1_1              (WCD_USBSS_USB_DIG_BASE+0x79)
#define WCD_USBSS_AUD_COEF_L_K2_0              (WCD_USBSS_USB_DIG_BASE+0x7a)
#define WCD_USBSS_AUD_COEF_L_K2_1              (WCD_USBSS_USB_DIG_BASE+0x7b)
#define WCD_USBSS_AUD_COEF_L_K3_0              (WCD_USBSS_USB_DIG_BASE+0x7c)
#define WCD_USBSS_AUD_COEF_L_K3_1              (WCD_USBSS_USB_DIG_BASE+0x7d)
#define WCD_USBSS_AUD_COEF_L_K4_0              (WCD_USBSS_USB_DIG_BASE+0x7e)
#define WCD_USBSS_AUD_COEF_L_K4_1              (WCD_USBSS_USB_DIG_BASE+0x7f)
#define WCD_USBSS_AUD_COEF_L_K5_0              (WCD_USBSS_USB_DIG_BASE+0x80)
#define WCD_USBSS_AUD_COEF_L_K5_1              (WCD_USBSS_USB_DIG_BASE+0x81)
#define WCD_USBSS_AUD_COEF_R_K0_0              (WCD_USBSS_USB_DIG_BASE+0x82)
#define WCD_USBSS_AUD_COEF_R_K0_1              (WCD_USBSS_USB_DIG_BASE+0x83)
#define WCD_USBSS_AUD_COEF_R_K0_2              (WCD_USBSS_USB_DIG_BASE+0x84)
#define WCD_USBSS_AUD_COEF_R_K1_0              (WCD_USBSS_USB_DIG_BASE+0x85)
#define WCD_USBSS_AUD_COEF_R_K1_1              (WCD_USBSS_USB_DIG_BASE+0x86)
#define WCD_USBSS_AUD_COEF_R_K2_0              (WCD_USBSS_USB_DIG_BASE+0x87)
#define WCD_USBSS_AUD_COEF_R_K2_1              (WCD_USBSS_USB_DIG_BASE+0x88)
#define WCD_USBSS_AUD_COEF_R_K3_0              (WCD_USBSS_USB_DIG_BASE+0x89)
#define WCD_USBSS_AUD_COEF_R_K3_1              (WCD_USBSS_USB_DIG_BASE+0x8a)
#define WCD_USBSS_AUD_COEF_R_K4_0              (WCD_USBSS_USB_DIG_BASE+0x8b)
#define WCD_USBSS_AUD_COEF_R_K4_1              (WCD_USBSS_USB_DIG_BASE+0x8c)
#define WCD_USBSS_AUD_COEF_R_K5_0              (WCD_USBSS_USB_DIG_BASE+0x8d)
#define WCD_USBSS_AUD_COEF_R_K5_1              (WCD_USBSS_USB_DIG_BASE+0x8e)
#define WCD_USBSS_GND_COEF_L_K0_0              (WCD_USBSS_USB_DIG_BASE+0x8f)
#define WCD_USBSS_GND_COEF_L_K0_1              (WCD_USBSS_USB_DIG_BASE+0x90)
#define WCD_USBSS_GND_COEF_L_K0_2              (WCD_USBSS_USB_DIG_BASE+0x91)
#define WCD_USBSS_GND_COEF_L_K1_0              (WCD_USBSS_USB_DIG_BASE+0x92)
#define WCD_USBSS_GND_COEF_L_K1_1              (WCD_USBSS_USB_DIG_BASE+0x93)
#define WCD_USBSS_GND_COEF_L_K2_0              (WCD_USBSS_USB_DIG_BASE+0x94)
#define WCD_USBSS_GND_COEF_L_K2_1              (WCD_USBSS_USB_DIG_BASE+0x95)
#define WCD_USBSS_GND_COEF_L_K3_0              (WCD_USBSS_USB_DIG_BASE+0x96)
#define WCD_USBSS_GND_COEF_L_K3_1              (WCD_USBSS_USB_DIG_BASE+0x97)
#define WCD_USBSS_GND_COEF_L_K4_0              (WCD_USBSS_USB_DIG_BASE+0x98)
#define WCD_USBSS_GND_COEF_L_K4_1              (WCD_USBSS_USB_DIG_BASE+0x99)
#define WCD_USBSS_GND_COEF_L_K5_0              (WCD_USBSS_USB_DIG_BASE+0x9a)
#define WCD_USBSS_GND_COEF_L_K5_1              (WCD_USBSS_USB_DIG_BASE+0x9b)
#define WCD_USBSS_GND_COEF_R_K0_0              (WCD_USBSS_USB_DIG_BASE+0x9c)
#define WCD_USBSS_GND_COEF_R_K0_1              (WCD_USBSS_USB_DIG_BASE+0x9d)
#define WCD_USBSS_GND_COEF_R_K0_2              (WCD_USBSS_USB_DIG_BASE+0x9e)
#define WCD_USBSS_GND_COEF_R_K1_0              (WCD_USBSS_USB_DIG_BASE+0x9f)
#define WCD_USBSS_GND_COEF_R_K1_1              (WCD_USBSS_USB_DIG_BASE+0xa0)
#define WCD_USBSS_GND_COEF_R_K2_0              (WCD_USBSS_USB_DIG_BASE+0xa1)
#define WCD_USBSS_GND_COEF_R_K2_1              (WCD_USBSS_USB_DIG_BASE+0xa2)
#define WCD_USBSS_GND_COEF_R_K3_0              (WCD_USBSS_USB_DIG_BASE+0xa3)
#define WCD_USBSS_GND_COEF_R_K3_1              (WCD_USBSS_USB_DIG_BASE+0xa4)
#define WCD_USBSS_GND_COEF_R_K4_0              (WCD_USBSS_USB_DIG_BASE+0xa5)
#define WCD_USBSS_GND_COEF_R_K4_1              (WCD_USBSS_USB_DIG_BASE+0xa6)
#define WCD_USBSS_GND_COEF_R_K5_0              (WCD_USBSS_USB_DIG_BASE+0xa7)
#define WCD_USBSS_GND_COEF_R_K5_1              (WCD_USBSS_USB_DIG_BASE+0xa8)
#define WCD_USBSS_AUD_L_SLOPE_SCALE_LSB        (WCD_USBSS_USB_DIG_BASE+0xa9)
#define WCD_USBSS_AUD_L_SLOPE_SCALE_MSB        (WCD_USBSS_USB_DIG_BASE+0xaa)
#define WCD_USBSS_AUD_R_SLOPE_SCALE_LSB        (WCD_USBSS_USB_DIG_BASE+0xab)
#define WCD_USBSS_AUD_R_SLOPE_SCALE_MSB        (WCD_USBSS_USB_DIG_BASE+0xac)
#define WCD_USBSS_GND_L_SLOPE_SCALE_LSB        (WCD_USBSS_USB_DIG_BASE+0xad)
#define WCD_USBSS_GND_L_SLOPE_SCALE_MSB        (WCD_USBSS_USB_DIG_BASE+0xae)
#define WCD_USBSS_GND_R_SLOPE_SCALE_LSB        (WCD_USBSS_USB_DIG_BASE+0xaf)
#define WCD_USBSS_GND_R_SLOPE_SCALE_MSB        (WCD_USBSS_USB_DIG_BASE+0xb0)
#define WCD_USBSS_AUD_L_FIRST_TAP              (WCD_USBSS_USB_DIG_BASE+0xb1)
#define WCD_USBSS_AUD_R_FIRST_TAP              (WCD_USBSS_USB_DIG_BASE+0xb2)
#define WCD_USBSS_GND_L_FIRST_TAP              (WCD_USBSS_USB_DIG_BASE+0xb3)
#define WCD_USBSS_GND_R_FIRST_TAP              (WCD_USBSS_USB_DIG_BASE+0xb4)
#define WCD_USBSS_FEATURE_SELECTION            (WCD_USBSS_USB_DIG_BASE+0xcb)
#define WCD_USBSS_EFUSE_REG_0                  (WCD_USBSS_USB_DIG_BASE+0xcc)
#define WCD_USBSS_EFUSE_REG_1                  (WCD_USBSS_USB_DIG_BASE+0xcd)
#define WCD_USBSS_EFUSE_REG_2                  (WCD_USBSS_USB_DIG_BASE+0xce)
#define WCD_USBSS_EFUSE_REG_3                  (WCD_USBSS_USB_DIG_BASE+0xcf)
#define WCD_USBSS_EFUSE_REG_4                  (WCD_USBSS_USB_DIG_BASE+0xd0)
#define WCD_USBSS_EFUSE_REG_5                  (WCD_USBSS_USB_DIG_BASE+0xd1)
#define WCD_USBSS_EFUSE_REG_6                  (WCD_USBSS_USB_DIG_BASE+0xd2)
#define WCD_USBSS_EFUSE_REG_7                  (WCD_USBSS_USB_DIG_BASE+0xd3)
#define WCD_USBSS_EFUSE_REG_8                  (WCD_USBSS_USB_DIG_BASE+0xd4)
#define WCD_USBSS_EFUSE_REG_9                  (WCD_USBSS_USB_DIG_BASE+0xd5)
#define WCD_USBSS_EFUSE_REG_10                 (WCD_USBSS_USB_DIG_BASE+0xd6)
#define WCD_USBSS_EFUSE_REG_11                 (WCD_USBSS_USB_DIG_BASE+0xd7)
#define WCD_USBSS_EFUSE_REG_12                 (WCD_USBSS_USB_DIG_BASE+0xd8)
#define WCD_USBSS_EFUSE_REG_13                 (WCD_USBSS_USB_DIG_BASE+0xd9)
#define WCD_USBSS_EFUSE_REG_14                 (WCD_USBSS_USB_DIG_BASE+0xda)
#define WCD_USBSS_EFUSE_REG_15                 (WCD_USBSS_USB_DIG_BASE+0xdb)
#define WCD_USBSS_EFUSE_PRG_CTL                (WCD_USBSS_USB_DIG_BASE+0xe0)

#define WCD_USBSS_NUM_REGISTERS                (WCD_USBSS_EFUSE_PRG_CTL+1)
#define WCD_USBSS_MAX_REGISTER                 (WCD_USBSS_NUM_REGISTERS-1)

#endif /* WCD_USBSS_REGISTERS_H */
