/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022-2023 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _QTI_HARDWARE_KEY_MANAGER_REGS_H_
#define _QTI_HARDWARE_KEY_MANAGER_REGS_H_

#define HWKM_VERSION_STEP_REV_MASK		0xFFFF
#define HWKM_VERSION_STEP_REV			0 /* bit 15-0 */
#define HWKM_VERSION_MAJOR_REV_MASK		0xFF000000
#define HWKM_VERSION_MAJOR_REV			24 /* bit 31-24 */
#define HWKM_VERSION_MINOR_REV_MASK		0xFF0000
#define HWKM_VERSION_MINOR_REV			16 /* bit 23-16 */

/* QTI HWKM ICE slave config and status registers */
#define QTI_HWKM_ICE_RG_TZ_KM_CTL			0x1000
#define QTI_HWKM_ICE_RG_TZ_KM_STATUS			0x1004
#define QTI_HWKM_ICE_RG_TZ_KM_STATUS_IRQ_MASK		0x1008
#define QTI_HWKM_ICE_RG_TZ_KM_BOOT_STAGE_OTP		0x100C
#define QTI_HWKM_ICE_RG_TZ_KM_DEBUG_CTL			0x1010
#define QTI_HWKM_ICE_RG_TZ_KM_DEBUG_WRITE		0x1014
#define QTI_HWKM_ICE_RG_TZ_KM_DEBUG_READ		0x1018
#define QTI_HWKM_ICE_RG_TZ_TPKEY_RECEIVE_CTL		0x101C
#define QTI_HWKM_ICE_RG_TZ_TPKEY_RECEIVE_STATUS		0x1020
#define QTI_HWKM_ICE_RG_TZ_KM_COMMON_IRQ_ROUTING	0x1024

/* QTI HWKM ICE slave registers from SWI */
/* QTI HWKM ICE slave shared registers */
#define QTI_HWKM_ICE_RG_IPCAT_VERSION			0x0000
#define QTI_HWKM_ICE_RG_KEY_POLICY_VERSION		0x0004
#define QTI_HWKM_ICE_RG_SHARED_STATUS			0x0008
#define QTI_HWKM_ICE_RG_KEYTABLE_SIZE			0x000C

/* QTI HWKM ICE slave register bank 0 */
#define QTI_HWKM_ICE_RG_BANK0_BANKN_CTL			0x2000
#define QTI_HWKM_ICE_RG_BANK0_BANKN_STATUS		0x2004
#define QTI_HWKM_ICE_RG_BANK0_BANKN_IRQ_STATUS		0x2008
#define QTI_HWKM_ICE_RG_BANK0_BANKN_IRQ_MASK		0x200C
#define QTI_HWKM_ICE_RG_BANK0_BANKN_ESR			0x2010
#define QTI_HWKM_ICE_RG_BANK0_BANKN_ESR_IRQ_MASK	0x2014
#define QTI_HWKM_ICE_RG_BANK0_BANKN_ESYNR		0x2018
#define QTI_HWKM_ICE_RG_BANK0_CMD_0			0x201C
#define QTI_HWKM_ICE_RG_BANK0_CMD_1			0x2020
#define QTI_HWKM_ICE_RG_BANK0_CMD_2			0x2024
#define QTI_HWKM_ICE_RG_BANK0_CMD_3			0x2028
#define QTI_HWKM_ICE_RG_BANK0_CMD_4			0x202C
#define QTI_HWKM_ICE_RG_BANK0_CMD_5			0x2030
#define QTI_HWKM_ICE_RG_BANK0_CMD_6			0x2034
#define QTI_HWKM_ICE_RG_BANK0_CMD_7			0x2038
#define QTI_HWKM_ICE_RG_BANK0_CMD_8			0x203C
#define QTI_HWKM_ICE_RG_BANK0_CMD_9			0x2040
#define QTI_HWKM_ICE_RG_BANK0_CMD_10			0x2044
#define QTI_HWKM_ICE_RG_BANK0_CMD_11			0x2048
#define QTI_HWKM_ICE_RG_BANK0_CMD_12			0x204C
#define QTI_HWKM_ICE_RG_BANK0_CMD_13			0x2050
#define QTI_HWKM_ICE_RG_BANK0_CMD_14			0x2054
#define QTI_HWKM_ICE_RG_BANK0_CMD_15			0x2058
#define QTI_HWKM_ICE_RG_BANK0_RSP_0			0x205C
#define QTI_HWKM_ICE_RG_BANK0_RSP_1			0x2060
#define QTI_HWKM_ICE_RG_BANK0_RSP_2			0x2064
#define QTI_HWKM_ICE_RG_BANK0_RSP_3			0x2068
#define QTI_HWKM_ICE_RG_BANK0_RSP_4			0x206C
#define QTI_HWKM_ICE_RG_BANK0_RSP_5			0x2070
#define QTI_HWKM_ICE_RG_BANK0_RSP_6			0x2074
#define QTI_HWKM_ICE_RG_BANK0_RSP_7			0x2078
#define QTI_HWKM_ICE_RG_BANK0_RSP_8			0x207C
#define QTI_HWKM_ICE_RG_BANK0_RSP_9			0x2080
#define QTI_HWKM_ICE_RG_BANK0_RSP_10			0x2084
#define QTI_HWKM_ICE_RG_BANK0_RSP_11			0x2088
#define QTI_HWKM_ICE_RG_BANK0_RSP_12			0x208C
#define QTI_HWKM_ICE_RG_BANK0_RSP_13			0x2090
#define QTI_HWKM_ICE_RG_BANK0_RSP_14			0x2094
#define QTI_HWKM_ICE_RG_BANK0_RSP_15			0x2098
#define QTI_HWKM_ICE_RG_BANK0_BANKN_IRQ_ROUTING		0x209C
#define QTI_HWKM_ICE_RG_BANK0_BANKN_BBAC_0		0x20A0
#define QTI_HWKM_ICE_RG_BANK0_BANKN_BBAC_1		0x20A4
#define QTI_HWKM_ICE_RG_BANK0_BANKN_BBAC_2		0x20A8
#define QTI_HWKM_ICE_RG_BANK0_BANKN_BBAC_3		0x20AC
#define QTI_HWKM_ICE_RG_BANK0_BANKN_BBAC_4		0x20B0

/* QTI HWKM access control registers for Bank 2 */
#define QTI_HWKM_ICE_RG_BANK0_AC_BANKN_BBAC_0		0x5000
#define QTI_HWKM_ICE_RG_BANK0_AC_BANKN_BBAC_1		0x5004
#define QTI_HWKM_ICE_RG_BANK0_AC_BANKN_BBAC_2		0x5008
#define QTI_HWKM_ICE_RG_BANK0_AC_BANKN_BBAC_3		0x500C
#define QTI_HWKM_ICE_RG_BANK0_AC_BANKN_BBAC_4		0x5010

#if IS_ENABLED(CONFIG_QTI_HW_KEY_MANAGER_V1)
/* QTI HWKM master register bank 2 */
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_CTL		0x4000
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_STATUS		0x4004
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_IRQ_STATUS	0x4008
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_IRQ_MASK		0x400C
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_ESR		0x4010
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_ESR_IRQ_MASK	0x4014
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_ESYNR		0x4018
#define QTI_HWKM_MASTER_RG_BANK2_CMD_0			0x401C
#define QTI_HWKM_MASTER_RG_BANK2_CMD_1			0x4020
#define QTI_HWKM_MASTER_RG_BANK2_CMD_2			0x4024
#define QTI_HWKM_MASTER_RG_BANK2_CMD_3			0x4028
#define QTI_HWKM_MASTER_RG_BANK2_CMD_4			0x402C
#define QTI_HWKM_MASTER_RG_BANK2_CMD_5			0x4030
#define QTI_HWKM_MASTER_RG_BANK2_CMD_6			0x4034
#define QTI_HWKM_MASTER_RG_BANK2_CMD_7			0x4038
#define QTI_HWKM_MASTER_RG_BANK2_CMD_8			0x403C
#define QTI_HWKM_MASTER_RG_BANK2_CMD_9			0x4040
#define QTI_HWKM_MASTER_RG_BANK2_CMD_10			0x4044
#define QTI_HWKM_MASTER_RG_BANK2_CMD_11			0x4048
#define QTI_HWKM_MASTER_RG_BANK2_CMD_12			0x404C
#define QTI_HWKM_MASTER_RG_BANK2_CMD_13			0x4050
#define QTI_HWKM_MASTER_RG_BANK2_CMD_14			0x4054
#define QTI_HWKM_MASTER_RG_BANK2_CMD_15			0x4058
#define QTI_HWKM_MASTER_RG_BANK2_RSP_0			0x405C
#define QTI_HWKM_MASTER_RG_BANK2_RSP_1			0x4060
#define QTI_HWKM_MASTER_RG_BANK2_RSP_2			0x4064
#define QTI_HWKM_MASTER_RG_BANK2_RSP_3			0x4068
#define QTI_HWKM_MASTER_RG_BANK2_RSP_4			0x406C
#define QTI_HWKM_MASTER_RG_BANK2_RSP_5			0x4070
#define QTI_HWKM_MASTER_RG_BANK2_RSP_6			0x4074
#define QTI_HWKM_MASTER_RG_BANK2_RSP_7			0x4078
#define QTI_HWKM_MASTER_RG_BANK2_RSP_8			0x407C
#define QTI_HWKM_MASTER_RG_BANK2_RSP_9			0x4080
#define QTI_HWKM_MASTER_RG_BANK2_RSP_10			0x4084
#define QTI_HWKM_MASTER_RG_BANK2_RSP_11			0x4088
#define QTI_HWKM_MASTER_RG_BANK2_RSP_12			0x408C
#define QTI_HWKM_MASTER_RG_BANK2_RSP_13			0x4090
#define QTI_HWKM_MASTER_RG_BANK2_RSP_14			0x4094
#define QTI_HWKM_MASTER_RG_BANK2_RSP_15			0x4098
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_IRQ_ROUTING	0x409C
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_BBAC_0		0x40A0
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_BBAC_1		0x40A4
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_BBAC_2		0x40A8
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_BBAC_3		0x40AC
#define QTI_HWKM_MASTER_RG_BANK2_BANKN_BBAC_4		0x40B0

/* QTI HWKM access control registers for Bank 2 */
#define QTI_HWKM_MASTER_RG_BANK2_AC_BANKN_BBAC_0	0x8000
#define QTI_HWKM_MASTER_RG_BANK2_AC_BANKN_BBAC_1	0x8004
#define QTI_HWKM_MASTER_RG_BANK2_AC_BANKN_BBAC_2	0x8008
#define QTI_HWKM_MASTER_RG_BANK2_AC_BANKN_BBAC_3	0x800C
#define QTI_HWKM_MASTER_RG_BANK2_AC_BANKN_BBAC_4	0x8010

#endif

/* QTI HWKM ICE slave config reg vals */

/* HWKM_ICEMEM_SLAVE_ICE_KM_RG_TZ_KM_CTL */
#define CRC_CHECK_EN				0
#define KEYTABLE_HW_WR_ACCESS_EN		1
#define KEYTABLE_HW_RD_ACCESS_EN		2
#define BOOT_INIT0_DISABLE			3
#define BOOT_INIT1_DISABLE			4
#define ICE_LEGACY_MODE_EN_OTP			5

/* HWKM_ICEMEM_SLAVE_ICE_KM_RG_TZ_KM_STATUS */
#define KT_CLEAR_DONE				0
#define BOOT_CMD_LIST0_DONE			1
#define BOOT_CMD_LIST1_DONE			2

#if IS_ENABLED(CONFIG_QTI_HW_KEY_MANAGER)
#define LAST_ACTIVITY_BANK			3
#define CRYPTO_LIB_BIST_ERROR			6
#define CRYPTO_LIB_BIST_DONE			7
#define BIST_ERROR				8
#define BIST_DONE				9
#define LAST_ACTIVITY_BANK_MASK			0x38

#else

#define KEYTABLE_KEY_POLICY			3
#define KEYTABLE_INTEGRITY_ERROR		4
#define KEYTABLE_KEY_SLOT_ERROR			5
#define KEYTABLE_KEY_SLOT_NOT_EVEN_ERROR	6
#define KEYTABLE_KEY_SLOT_OUT_OF_RANGE		7
#define KEYTABLE_KEY_SIZE_ERROR			8
#define KEYTABLE_OPERATION_ERROR		9
#define LAST_ACTIVITY_BANK			10
#define CRYPTO_LIB_BIST_ERROR		13
#define CRYPTO_LIB_BIST_DONE		14
#define BIST_ERROR				15
#define BIST_DONE				16
#define LAST_ACTIVITY_BANK_MASK			0x1c00
#endif /* CONFIG_QTI_HW_KEY_MANAGER */

/* HWKM_ICEMEM_SLAVE_ICE_KM_RG_TZ_TPKEY_RECEIVE_CTL */
#define TPKEY_EN				8

/* QTI HWKM Bank status & control reg vals */

/* HWKM_MASTER_CFG_KM_BANKN_CTL */
#define CMD_ENABLE_BIT				0
#define CMD_FIFO_CLEAR_BIT			1

/* HWKM_MASTER_CFG_KM_BANKN_STATUS */
#define CURRENT_CMD_REMAINING_LENGTH		0
#define MOST_RECENT_OPCODE			5
#define RSP_FIFO_AVAILABLE_DATA			9
#define CMD_FIFO_AVAILABLE_SPACE		14
#define ICE_LEGACY_MODE_BIT			19
#define CMD_FIFO_AVAILABLE_SPACE_MASK		0x7c000
#define RSP_FIFO_AVAILABLE_DATA_MASK		0x3e00
#define MOST_RECENT_OPCODE_MASK			0x1e0
#define CURRENT_CMD_REMAINING_LENGTH_MASK	0x1f

/* HWKM_MASTER_CFG_KM_BANKN_IRQ_STATUS */
#define ARB_GRAN_WINNER				0
#define CMD_DONE_BIT				1
#define RSP_FIFO_NOT_EMPTY			2
#define RSP_FIFO_FULL				3
#define RSP_FIFO_UNDERFLOW			4
#define CMD_FIFO_UNDERFLOW			5

#endif /* __QTI_HARDWARE_KEY_MANAGER_REGS_H_ */
