## Contributing guide
This document serves as a checklist before contributing to this repository. It includes links to additional information if topics are unclear to you.

This guide mainly focuses on the proper use of Git.

### 1. Before opening an issue
To report a bug/request please enter the issue in the right repository.

Please check the following boxes before posting an issue:
- [ ] `Make sure you are using the latest commit (major releases are Tagged, but corrections are available as new commits).`
- [ ] `Make sure your issue is a question/feedback/suggestion RELATED TO the software provided in this repository.` Otherwise, it should be discussed on the [ST Community forum](https://community.st.com/s/).
- [ ] `Make sure your issue is not already reported/fixed on GitHub or discussed in a previous issue.` Please refer to the tab issue for the list of issues and pull-requests. Do not forget to browse to the **closed** issues.

### 2. Posting the issue
When you have checked the previous boxes, you will find two templates (Bug Report or Other Issue) available in the **Issues** tab of the repository.

### 3. Pull Requests
STMicroelectronics is happy to receive contributions from the community, based on an initial Contributor License Agreement (CLA) procedure.

* If you are an individual writing original source code and you are sure **you own the intellectual property**, then you need to sign an Individual CLA (https://cla.st.com).
* If you work for a company that wants also to allow you to contribute with your work, your company needs to provide a Corporate CLA (https://cla.st.com) mentioning your GitHub account name.
* If you are not sure that a CLA (Individual or Corporate) has been signed for your GitHub account, you can check here (https://cla.st.com).

Please note that:
* The Corporate CLA will always take precedence over the Individual CLA.
* One CLA submission is sufficient for any project proposed by STMicroelectronics.

#### How to proceed

* We recommend to engage first a communication through an issue, in order to present your proposal and just to confirm that it corresponds to a STMicroelectronics domain or scope.
* Then fork the project to your GitHub account to further develop your contribution. Please use the latest commit version.
* Please submit one Pull Request for one new feature or proposal. This will facilitate the analysis and the final merge if accepted.

